/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.TeXFontSize;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import java.io.IOException;

public class FontSizeDeclaration
extends Declaration {
    private TeXFontSize size;
    private TeXFontSize orgSize;

    public FontSizeDeclaration(String string, int n) {
        super(string);
        this.orgSize = TeXFontSize.INHERIT;
        switch (n) {
            case -1: {
                this.size = TeXFontSize.INHERIT;
                break;
            }
            case 0: {
                this.size = TeXFontSize.NORMAL;
                break;
            }
            case 1: {
                this.size = TeXFontSize.LARGE;
                break;
            }
            case 2: {
                this.size = TeXFontSize.XLARGE;
                break;
            }
            case 3: {
                this.size = TeXFontSize.XXLARGE;
                break;
            }
            case 4: {
                this.size = TeXFontSize.HUGE;
                break;
            }
            case 5: {
                this.size = TeXFontSize.XHUGE;
                break;
            }
            case 6: {
                this.size = TeXFontSize.XXHUGE;
                break;
            }
            case 7: {
                this.size = TeXFontSize.SMALL;
                break;
            }
            case 8: {
                this.size = TeXFontSize.FOOTNOTE;
                break;
            }
            case 9: {
                this.size = TeXFontSize.SCRIPT;
                break;
            }
            case 10: {
                this.size = TeXFontSize.TINY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid size ID: " + n);
            }
        }
    }

    public FontSizeDeclaration(String string, TeXFontSize teXFontSize) {
        super(string);
        this.size = teXFontSize;
        this.orgSize = TeXFontSize.INHERIT;
    }

    @Override
    public Object clone() {
        return new FontSizeDeclaration(this.getName(), this.size);
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        this.orgSize = teXSettings.getCurrentFontSize();
        teXSettings.setFontSize(this.size);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.setFontSize(this.orgSize);
    }

    @Override
    public boolean isModeSwitcher() {
        return false;
    }

    public TeXFontSize getSize() {
        return this.size;
    }
}

