# The QWorld Package

## Overview

QWorld is a LaTeX package designed to simplify the drawing of complex graphical calculus in monoidal category theory. This package provides a concise and intuitive set of commands, allowing users to efficiently render string diagrams with minimal effort. This package is particularly useful for researchers working in category theory, quantum theory, and related fields where diagrammatic reasoning plays a crucial role.

## Installation

Once the package is available in a TeX distribution via CTAN, you can use it in your document by adding:

```
\usepackage{qworld}
```

Alternatively, to install it manually:

1. Download the package's `.sty` file.
2. Place it in your LaTeX working directory or an appropriate directory within your TeX distribution.
3. Add \usepackage{qworld} to the preamble of your document.
4. Run `texhash` if necessary to update the file database.

## Usage

Below is a basic example of how to use qworld

```
\documentclass{article}
\usepackage{qworld}

\begin{document}
  \[
    \q{
      \qcap\qwire\n
      \qwire\qcup
    }=\q{
      \qwireup[vlen=2]
    }
  \]
\end{document}
```

For more detailed usage instructions, refer to the package documentation.

## License

This package is distributed under the [LaTeX Project Public License (LPPL)](https://www.latex-project.org/lppl.txt), version 1.3c or later.

## Copyright

© 2025 Niina Ryota

This Package consists of the following files:

- `qworld.sty` (the main package file)
- `qworld.pdf` (documentation)

The current maintainer of this package is **Niina Ryota**.

## Modification Policy

Under the terms of the LPPL:

- Any modifications must **not** be distributed under the original package name.
- Any modified versions must clearly state that they are derived from this package.
- The original author (Niina Ryota) must always be credited in derived works.

## Contact

Author: Niina Ryota
Email: qworld-package@googlegroups.com

## Change Log
### 1.1.0 (2025-04-03)
- The following commands have been updated. The ID, which was previously a required argument for these commands, has been made optional. Users can now specify the ID via an optional key, allowing for more flexible usage of the commands.
  - `\symbolI`, `\symbols`, `\symbolS`, `\symbolO`, `\symboln`, `\symbolN`.
    - Specific changes:
      - Old format: `\symbolI[i]{ID}{text}[above right]`
      - New format: `\symbolI[i]{text}[above right, id=ID]`
- English documentation has been added to the package.

### 1.0.0 (2025-04-01)
- Initial release of the package.

## Contributions

Bug reports, feature requests, and contributions are welcome. Please contact qworld-package@googlegroups.com for inquires or to submit issues.
