# -*- coding: utf-8 -*-
# Copyright 2023 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the ios_static_routes module
"""


class Static_routesArgs(object):  # pylint: disable=R0903
    """The arg spec for the ios_static_routes module"""

    argument_spec = {
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "vrf": {"type": "str"},
                "address_families": {
                    "elements": "dict",
                    "type": "list",
                    "options": {
                        "afi": {
                            "required": True,
                            "type": "str",
                            "choices": ["ipv4", "ipv6"],
                        },
                        "routes": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "dest": {"type": "str", "required": True},
                                "topology": {"type": "str"},
                                "next_hops": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "forward_router_address": {"type": "str"},
                                        "interface": {"type": "str"},
                                        "dhcp": {"type": "bool"},
                                        "distance_metric": {"type": "int"},
                                        "global": {"type": "bool"},
                                        "name": {"type": "str"},
                                        "multicast": {"type": "bool"},
                                        "unicast": {"type": "bool"},
                                        "permanent": {"type": "bool"},
                                        "tag": {"type": "int"},
                                        "track": {"type": "int"},
                                    },
                                },
                            },
                        },
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "type": "str",
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "rendered",
                "parsed",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
