# SPDX-FileCopyrightText: 2010-2022 Blender Foundation
#
# SPDX-License-Identifier: GPL-2.0-or-later

import bpy

from mathutils import Color


def create(obj):  # noqa
    # generated by rigify.utils.write_metarig
    bpy.ops.object.mode_set(mode='EDIT')
    arm = obj.data

    for i in range(6):
        arm.rigify_colors.add()

    arm.rigify_colors[0].name = "Root"
    arm.rigify_colors[0].active = Color((0.5490, 1.0000, 1.0000))
    arm.rigify_colors[0].normal = Color((0.4353, 0.1843, 0.4157))
    arm.rigify_colors[0].select = Color((0.3137, 0.7843, 1.0000))
    arm.rigify_colors[0].standard_colors_lock = True
    arm.rigify_colors[1].name = "IK"
    arm.rigify_colors[1].active = Color((0.5490, 1.0000, 1.0000))
    arm.rigify_colors[1].normal = Color((0.6039, 0.0000, 0.0000))
    arm.rigify_colors[1].select = Color((0.3137, 0.7843, 1.0000))
    arm.rigify_colors[1].standard_colors_lock = True
    arm.rigify_colors[2].name = "Special"
    arm.rigify_colors[2].active = Color((0.5490, 1.0000, 1.0000))
    arm.rigify_colors[2].normal = Color((0.9569, 0.7882, 0.0471))
    arm.rigify_colors[2].select = Color((0.3137, 0.7843, 1.0000))
    arm.rigify_colors[2].standard_colors_lock = True
    arm.rigify_colors[3].name = "Tweak"
    arm.rigify_colors[3].active = Color((0.5490, 1.0000, 1.0000))
    arm.rigify_colors[3].normal = Color((0.0392, 0.2118, 0.5804))
    arm.rigify_colors[3].select = Color((0.3137, 0.7843, 1.0000))
    arm.rigify_colors[3].standard_colors_lock = True
    arm.rigify_colors[4].name = "FK"
    arm.rigify_colors[4].active = Color((0.5490, 1.0000, 1.0000))
    arm.rigify_colors[4].normal = Color((0.1176, 0.5686, 0.0353))
    arm.rigify_colors[4].select = Color((0.3137, 0.7843, 1.0000))
    arm.rigify_colors[4].standard_colors_lock = True
    arm.rigify_colors[5].name = "Extra"
    arm.rigify_colors[5].active = Color((0.5490, 1.0000, 1.0000))
    arm.rigify_colors[5].normal = Color((0.9686, 0.2510, 0.0941))
    arm.rigify_colors[5].select = Color((0.3137, 0.7843, 1.0000))
    arm.rigify_colors[5].standard_colors_lock = True

    bone_collections = {}

    for bcoll in list(arm.collections_all):
        arm.collections.remove(bcoll)

    def add_bone_collection(name, *, ui_row=0, ui_title='', sel_set=False, color_set_id=0):
        new_bcoll = arm.collections.new(name)
        new_bcoll.rigify_ui_row = ui_row
        new_bcoll.rigify_ui_title = ui_title
        new_bcoll.rigify_sel_set = sel_set
        new_bcoll.rigify_color_set_id = color_set_id
        bone_collections[name] = new_bcoll

    def assign_bone_collections(pose_bone, *coll_names):
        assert not len(pose_bone.bone.collections)
        for name in coll_names:
            bone_collections[name].assign(pose_bone)

    def assign_bone_collection_refs(params, attr_name, *coll_names):
        ref_list = getattr(params, attr_name + '_coll_refs', None)
        if ref_list is not None:
            for name in coll_names:
                ref_list.add().set_collection(bone_collections[name])

    add_bone_collection('Face', ui_row=1, color_set_id=5)
    add_bone_collection('Face (Primary)', ui_row=2, ui_title='(Primary)', color_set_id=2)
    add_bone_collection('Face (Secondary)', ui_row=2, ui_title='(Secondary)', color_set_id=3)
    add_bone_collection('Spine', ui_row=4, color_set_id=3)
    add_bone_collection('Spine (Tweak)', ui_row=5, ui_title='(Tweak)', color_set_id=4)
    add_bone_collection('Paws', ui_row=7, color_set_id=6)
    add_bone_collection('Paws (Tweak)', ui_row=8, ui_title='(Tweak)', color_set_id=4)
    add_bone_collection('Arm.L (IK)', ui_row=10, color_set_id=2)
    add_bone_collection('Arm.L (FK)', ui_row=11, ui_title='(FK)', color_set_id=5)
    add_bone_collection('Arm.L (Tweak)', ui_row=12, ui_title='(Tweak)', color_set_id=4)
    add_bone_collection('Arm.R (IK)', ui_row=10, color_set_id=2)
    add_bone_collection('Arm.R (FK)', ui_row=11, ui_title='(FK)', color_set_id=5)
    add_bone_collection('Arm.R (Tweak)', ui_row=12, ui_title='(Tweak)', color_set_id=4)
    add_bone_collection('Leg.L (IK)', ui_row=14, color_set_id=2)
    add_bone_collection('Leg.L (FK)', ui_row=15, ui_title='(FK)', color_set_id=5)
    add_bone_collection('Leg.L (Tweak)', ui_row=16, ui_title='(Tweak)', color_set_id=4)
    add_bone_collection('Leg.R (IK)', ui_row=14, color_set_id=2)
    add_bone_collection('Leg.R (FK)', ui_row=15, ui_title='(FK)', color_set_id=5)
    add_bone_collection('Leg.R (Tweak)', ui_row=16, ui_title='(Tweak)', color_set_id=4)
    add_bone_collection('Tail', ui_row=18, color_set_id=6)
    add_bone_collection('Root', ui_row=21, color_set_id=1)

    bones = {}

    bone = arm.edit_bones.new('spine.004')
    bone.head = 0.0000, 0.4085, 0.7928
    bone.tail = 0.0000, 0.2416, 0.7927
    bone.roll = 0.0000
    bone.use_connect = False
    bones['spine.004'] = bone.name
    bone = arm.edit_bones.new('spine.003')
    bone.head = 0.0000, 0.4085, 0.7928
    bone.tail = 0.0000, 0.5555, 0.7567
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.004']]
    bones['spine.003'] = bone.name
    bone = arm.edit_bones.new('spine.005')
    bone.head = 0.0000, 0.2416, 0.7927
    bone.tail = 0.0000, 0.1202, 0.7773
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.004']]
    bones['spine.005'] = bone.name
    bone = arm.edit_bones.new('spine.002')
    bone.head = 0.0000, 0.5555, 0.7567
    bone.tail = 0.0000, 0.7816, 0.7411
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.003']]
    bones['spine.002'] = bone.name
    bone = arm.edit_bones.new('spine.006')
    bone.head = 0.0000, 0.1202, 0.7773
    bone.tail = 0.0000, 0.0096, 0.7772
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.005']]
    bones['spine.006'] = bone.name
    bone = arm.edit_bones.new('pelvis.L')
    bone.head = 0.0000, 0.3757, 0.6043
    bone.tail = 0.0751, 0.2755, 0.8544
    bone.roll = -1.5841
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.005']]
    bones['pelvis.L'] = bone.name
    bone = arm.edit_bones.new('pelvis.R')
    bone.head = -0.0000, 0.3757, 0.6043
    bone.tail = -0.0751, 0.2755, 0.8544
    bone.roll = 1.5841
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.005']]
    bones['pelvis.R'] = bone.name
    bone = arm.edit_bones.new('thigh.L')
    bone.head = 0.1249, 0.3419, 0.7379
    bone.tail = 0.1249, 0.2712, 0.4731
    bone.roll = -0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.005']]
    bones['thigh.L'] = bone.name
    bone = arm.edit_bones.new('thigh.R')
    bone.head = -0.1249, 0.3419, 0.7379
    bone.tail = -0.1249, 0.2712, 0.4731
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.005']]
    bones['thigh.R'] = bone.name
    bone = arm.edit_bones.new('spine.001')
    bone.head = 0.0000, 0.7816, 0.7411
    bone.tail = 0.0000, 0.9624, 0.7412
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.002']]
    bones['spine.001'] = bone.name
    bone = arm.edit_bones.new('spine.007')
    bone.head = 0.0000, 0.0096, 0.7772
    bone.tail = 0.0000, -0.0980, 0.7945
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.006']]
    bones['spine.007'] = bone.name
    bone = arm.edit_bones.new('shin.L')
    bone.head = 0.1249, 0.2712, 0.4731
    bone.tail = 0.1114, 0.4766, 0.2473
    bone.roll = 0.0195
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['thigh.L']]
    bones['shin.L'] = bone.name
    bone = arm.edit_bones.new('shin.R')
    bone.head = -0.1249, 0.2712, 0.4731
    bone.tail = -0.1114, 0.4766, 0.2473
    bone.roll = -0.0195
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['thigh.R']]
    bones['shin.R'] = bone.name
    bone = arm.edit_bones.new('spine')
    bone.head = 0.0000, 0.9624, 0.7412
    bone.tail = 0.0000, 1.1044, 0.7633
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.001']]
    bones['spine'] = bone.name
    bone = arm.edit_bones.new('spine.008')
    bone.head = 0.0000, -0.0980, 0.7945
    bone.tail = 0.0000, -0.3618, 0.8375
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.007']]
    bones['spine.008'] = bone.name
    bone = arm.edit_bones.new('foot.L')
    bone.head = 0.1114, 0.4766, 0.2473
    bone.tail = 0.1088, 0.4138, 0.0411
    bone.roll = 0.0165
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['shin.L']]
    bones['foot.L'] = bone.name
    bone = arm.edit_bones.new('foot.R')
    bone.head = -0.1114, 0.4766, 0.2473
    bone.tail = -0.1088, 0.4138, 0.0411
    bone.roll = -0.0165
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['shin.R']]
    bones['foot.R'] = bone.name
    bone = arm.edit_bones.new('spine.009')
    bone.head = 0.0000, -0.3618, 0.8375
    bone.tail = 0.0000, -0.4253, 0.8585
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.008']]
    bones['spine.009'] = bone.name
    bone = arm.edit_bones.new('shoulder.L')
    bone.head = 0.0596, -0.2578, 0.8876
    bone.tail = 0.1249, -0.3418, 0.7153
    bone.roll = -0.3526
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.008']]
    bones['shoulder.L'] = bone.name
    bone = arm.edit_bones.new('shoulder.R')
    bone.head = -0.0596, -0.2578, 0.8876
    bone.tail = -0.1249, -0.3418, 0.7153
    bone.roll = 0.3526
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.008']]
    bones['shoulder.R'] = bone.name
    bone = arm.edit_bones.new('breast.L')
    bone.head = 0.0340, -0.1694, 0.6676
    bone.tail = 0.0340, -0.3139, 0.5296
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.008']]
    bones['breast.L'] = bone.name
    bone = arm.edit_bones.new('breast.R')
    bone.head = -0.0340, -0.1694, 0.6676
    bone.tail = -0.0340, -0.3139, 0.5296
    bone.roll = -0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.008']]
    bones['breast.R'] = bone.name
    bone = arm.edit_bones.new('toe.L')
    bone.head = 0.1088, 0.4138, 0.0411
    bone.tail = 0.1088, 0.3213, 0.0000
    bone.roll = 3.1416
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['foot.L']]
    bones['toe.L'] = bone.name
    bone = arm.edit_bones.new('toe.R')
    bone.head = -0.1088, 0.4138, 0.0411
    bone.tail = -0.1088, 0.3213, 0.0000
    bone.roll = -3.1416
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['foot.R']]
    bones['toe.R'] = bone.name
    bone = arm.edit_bones.new('spine.010')
    bone.head = 0.0000, -0.4253, 0.8585
    bone.tail = 0.0000, -0.4888, 0.8796
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.009']]
    bones['spine.010'] = bone.name
    bone = arm.edit_bones.new('front_thigh.L')
    bone.head = 0.1249, -0.3161, 0.6902
    bone.tail = 0.1249, -0.2245, 0.4418
    bone.roll = -0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['shoulder.L']]
    bones['front_thigh.L'] = bone.name
    bone = arm.edit_bones.new('front_thigh.R')
    bone.head = -0.1249, -0.3161, 0.6902
    bone.tail = -0.1249, -0.2245, 0.4418
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['shoulder.R']]
    bones['front_thigh.R'] = bone.name
    bone = arm.edit_bones.new('r_palm.04.L')
    bone.head = 0.1140, 0.4168, 0.0282
    bone.tail = 0.1337, 0.3749, 0.0253
    bone.roll = -2.8623
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toe.L']]
    bones['r_palm.04.L'] = bone.name
    bone = arm.edit_bones.new('r_palm.03.L')
    bone.head = 0.1053, 0.4151, 0.0282
    bone.tail = 0.1150, 0.3664, 0.0377
    bone.roll = 1.5833
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toe.L']]
    bones['r_palm.03.L'] = bone.name
    bone = arm.edit_bones.new('r_palm.02.L')
    bone.head = 0.0964, 0.4152, 0.0282
    bone.tail = 0.0894, 0.3664, 0.0377
    bone.roll = -1.2317
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toe.L']]
    bones['r_palm.02.L'] = bone.name
    bone = arm.edit_bones.new('r_palm.01.L')
    bone.head = 0.0845, 0.4178, 0.0282
    bone.tail = 0.0702, 0.3781, 0.0253
    bone.roll = 2.8333
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toe.L']]
    bones['r_palm.01.L'] = bone.name
    bone = arm.edit_bones.new('r_palm.04.R')
    bone.head = -0.1140, 0.4168, 0.0282
    bone.tail = -0.1337, 0.3749, 0.0253
    bone.roll = 2.8623
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toe.R']]
    bones['r_palm.04.R'] = bone.name
    bone = arm.edit_bones.new('r_palm.03.R')
    bone.head = -0.1053, 0.4151, 0.0282
    bone.tail = -0.1150, 0.3664, 0.0377
    bone.roll = -1.5833
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toe.R']]
    bones['r_palm.03.R'] = bone.name
    bone = arm.edit_bones.new('r_palm.02.R')
    bone.head = -0.0964, 0.4152, 0.0282
    bone.tail = -0.0894, 0.3664, 0.0377
    bone.roll = 1.2317
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toe.R']]
    bones['r_palm.02.R'] = bone.name
    bone = arm.edit_bones.new('r_palm.01.R')
    bone.head = -0.0845, 0.4178, 0.0282
    bone.tail = -0.0702, 0.3781, 0.0253
    bone.roll = -2.8333
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toe.R']]
    bones['r_palm.01.R'] = bone.name
    bone = arm.edit_bones.new('spine.011')
    bone.head = 0.0000, -0.4888, 0.8796
    bone.tail = 0.0000, -0.6590, 0.9809
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.010']]
    bones['spine.011'] = bone.name
    bone = arm.edit_bones.new('front_shin.L')
    bone.head = 0.1249, -0.2245, 0.4418
    bone.tail = 0.1114, -0.2147, 0.1698
    bone.roll = 0.0098
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['front_thigh.L']]
    bones['front_shin.L'] = bone.name
    bone = arm.edit_bones.new('front_shin.R')
    bone.head = -0.1249, -0.2245, 0.4418
    bone.tail = -0.1114, -0.2147, 0.1698
    bone.roll = -0.0098
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['front_thigh.R']]
    bones['front_shin.R'] = bone.name
    bone = arm.edit_bones.new('r_pinky.01.L')
    bone.head = 0.1337, 0.3749, 0.0253
    bone.tail = 0.1388, 0.3551, 0.0222
    bone.roll = -2.0928
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['r_palm.04.L']]
    bones['r_pinky.01.L'] = bone.name
    bone = arm.edit_bones.new('r_ring.01.L')
    bone.head = 0.1150, 0.3664, 0.0377
    bone.tail = 0.1166, 0.3467, 0.0317
    bone.roll = -0.5451
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['r_palm.03.L']]
    bones['r_ring.01.L'] = bone.name
    bone = arm.edit_bones.new('r_middle.01.L')
    bone.head = 0.0894, 0.3664, 0.0377
    bone.tail = 0.0866, 0.3467, 0.0317
    bone.roll = 0.9401
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['r_palm.02.L']]
    bones['r_middle.01.L'] = bone.name
    bone = arm.edit_bones.new('r_index.01.L')
    bone.head = 0.0702, 0.3781, 0.0253
    bone.tail = 0.0660, 0.3581, 0.0222
    bone.roll = 1.9945
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['r_palm.01.L']]
    bones['r_index.01.L'] = bone.name
    bone = arm.edit_bones.new('r_pinky.01.R')
    bone.head = -0.1337, 0.3749, 0.0253
    bone.tail = -0.1388, 0.3551, 0.0222
    bone.roll = 2.0928
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['r_palm.04.R']]
    bones['r_pinky.01.R'] = bone.name
    bone = arm.edit_bones.new('r_ring.01.R')
    bone.head = -0.1150, 0.3664, 0.0377
    bone.tail = -0.1166, 0.3467, 0.0317
    bone.roll = 0.5451
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['r_palm.03.R']]
    bones['r_ring.01.R'] = bone.name
    bone = arm.edit_bones.new('r_middle.01.R')
    bone.head = -0.0894, 0.3664, 0.0377
    bone.tail = -0.0866, 0.3467, 0.0317
    bone.roll = -0.9401
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['r_palm.02.R']]
    bones['r_middle.01.R'] = bone.name
    bone = arm.edit_bones.new('r_index.01.R')
    bone.head = -0.0702, 0.3781, 0.0253
    bone.tail = -0.0660, 0.3581, 0.0222
    bone.roll = -1.9945
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['r_palm.01.R']]
    bones['r_index.01.R'] = bone.name
    bone = arm.edit_bones.new('face')
    bone.head = -0.0000, -0.6484, 0.8273
    bone.tail = -0.0000, -0.6484, 0.8890
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.011']]
    bones['face'] = bone.name
    bone = arm.edit_bones.new('front_foot.L')
    bone.head = 0.1114, -0.2147, 0.1698
    bone.tail = 0.1088, -0.2462, 0.0411
    bone.roll = 0.0272
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['front_shin.L']]
    bones['front_foot.L'] = bone.name
    bone = arm.edit_bones.new('front_foot.R')
    bone.head = -0.1114, -0.2147, 0.1698
    bone.tail = -0.1088, -0.2462, 0.0411
    bone.roll = -0.0272
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['front_shin.R']]
    bones['front_foot.R'] = bone.name
    bone = arm.edit_bones.new('r_pinky.02.L')
    bone.head = 0.1388, 0.3551, 0.0222
    bone.tail = 0.1431, 0.3382, 0.0170
    bone.roll = -1.4292
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_pinky.01.L']]
    bones['r_pinky.02.L'] = bone.name
    bone = arm.edit_bones.new('r_ring.02.L')
    bone.head = 0.1166, 0.3467, 0.0317
    bone.tail = 0.1188, 0.3297, 0.0224
    bone.roll = -0.5100
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_ring.01.L']]
    bones['r_ring.02.L'] = bone.name
    bone = arm.edit_bones.new('r_middle.02.L')
    bone.head = 0.0866, 0.3467, 0.0317
    bone.tail = 0.0851, 0.3297, 0.0224
    bone.roll = 0.4076
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_middle.01.L']]
    bones['r_middle.02.L'] = bone.name
    bone = arm.edit_bones.new('r_index.02.L')
    bone.head = 0.0660, 0.3581, 0.0222
    bone.tail = 0.0623, 0.3410, 0.0170
    bone.roll = 1.3847
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_index.01.L']]
    bones['r_index.02.L'] = bone.name
    bone = arm.edit_bones.new('r_pinky.02.R')
    bone.head = -0.1388, 0.3551, 0.0222
    bone.tail = -0.1431, 0.3382, 0.0170
    bone.roll = 1.4292
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_pinky.01.R']]
    bones['r_pinky.02.R'] = bone.name
    bone = arm.edit_bones.new('r_ring.02.R')
    bone.head = -0.1166, 0.3467, 0.0317
    bone.tail = -0.1188, 0.3297, 0.0224
    bone.roll = 0.5100
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_ring.01.R']]
    bones['r_ring.02.R'] = bone.name
    bone = arm.edit_bones.new('r_middle.02.R')
    bone.head = -0.0866, 0.3467, 0.0317
    bone.tail = -0.0851, 0.3297, 0.0224
    bone.roll = -0.4076
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_middle.01.R']]
    bones['r_middle.02.R'] = bone.name
    bone = arm.edit_bones.new('r_index.02.R')
    bone.head = -0.0660, 0.3581, 0.0222
    bone.tail = -0.0623, 0.3410, 0.0170
    bone.roll = -1.3847
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_index.01.R']]
    bones['r_index.02.R'] = bone.name
    bone = arm.edit_bones.new('nose')
    bone.head = 0.0000, -0.7082, 0.9031
    bone.tail = 0.0000, -0.7989, 0.8595
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['nose'] = bone.name
    bone = arm.edit_bones.new('lip.T.L')
    bone.head = 0.0000, -0.8212, 0.7930
    bone.tail = 0.0353, -0.7614, 0.7866
    bone.roll = 0.0551
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['lip.T.L'] = bone.name
    bone = arm.edit_bones.new('lip.B.L')
    bone.head = 0.0000, -0.7962, 0.7788
    bone.tail = 0.0258, -0.7624, 0.7742
    bone.roll = 0.0255
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['lip.B.L'] = bone.name
    bone = arm.edit_bones.new('jaw')
    bone.head = 0.0000, -0.6191, 0.7820
    bone.tail = 0.0000, -0.6960, 0.7733
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['jaw'] = bone.name
    bone = arm.edit_bones.new('ear.L')
    bone.head = 0.0949, -0.5457, 0.9545
    bone.tail = 0.0524, -0.5459, 0.9899
    bone.roll = -1.1774
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['ear.L'] = bone.name
    bone = arm.edit_bones.new('ear.R')
    bone.head = -0.0949, -0.5457, 0.9545
    bone.tail = -0.0524, -0.5459, 0.9899
    bone.roll = 1.1774
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['ear.R'] = bone.name
    bone = arm.edit_bones.new('lip.T.R')
    bone.head = 0.0000, -0.8212, 0.7930
    bone.tail = -0.0353, -0.7614, 0.7866
    bone.roll = -0.0551
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['lip.T.R'] = bone.name
    bone = arm.edit_bones.new('lip.B.R')
    bone.head = 0.0000, -0.7962, 0.7788
    bone.tail = -0.0258, -0.7624, 0.7742
    bone.roll = -0.0255
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['lip.B.R'] = bone.name
    bone = arm.edit_bones.new('brow.B.L')
    bone.head = 0.0745, -0.6532, 0.9192
    bone.tail = 0.0659, -0.6703, 0.9324
    bone.roll = 0.7673
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['brow.B.L'] = bone.name
    bone = arm.edit_bones.new('lid.T.L')
    bone.head = 0.0621, -0.6644, 0.9197
    bone.tail = 0.0588, -0.6755, 0.9223
    bone.roll = 0.0733
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['lid.T.L'] = bone.name
    bone = arm.edit_bones.new('brow.B.R')
    bone.head = -0.0745, -0.6532, 0.9192
    bone.tail = -0.0659, -0.6703, 0.9324
    bone.roll = -0.7673
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['brow.B.R'] = bone.name
    bone = arm.edit_bones.new('lid.T.R')
    bone.head = -0.0621, -0.6644, 0.9197
    bone.tail = -0.0588, -0.6755, 0.9223
    bone.roll = -0.0733
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['lid.T.R'] = bone.name
    bone = arm.edit_bones.new('forehead.L')
    bone.head = 0.0208, -0.6604, 0.9808
    bone.tail = 0.0160, -0.7017, 0.9527
    bone.roll = 1.9432
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['forehead.L'] = bone.name
    bone = arm.edit_bones.new('forehead.R')
    bone.head = -0.0208, -0.6604, 0.9808
    bone.tail = -0.0160, -0.7017, 0.9527
    bone.roll = -1.9432
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['forehead.R'] = bone.name
    bone = arm.edit_bones.new('eye.L')
    bone.head = 0.0388, -0.6496, 0.9149
    bone.tail = 0.0388, -0.7010, 0.9149
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['eye.L'] = bone.name
    bone = arm.edit_bones.new('eye.R')
    bone.head = -0.0388, -0.6496, 0.9149
    bone.tail = -0.0388, -0.7010, 0.9149
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['eye.R'] = bone.name
    bone = arm.edit_bones.new('cheek.T.L')
    bone.head = 0.0906, -0.6428, 0.9032
    bone.tail = 0.0660, -0.6881, 0.8704
    bone.roll = -0.0634
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['cheek.T.L'] = bone.name
    bone = arm.edit_bones.new('cheek.T.R')
    bone.head = -0.0906, -0.6428, 0.9032
    bone.tail = -0.0660, -0.6881, 0.8704
    bone.roll = 0.0634
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['cheek.T.R'] = bone.name
    bone = arm.edit_bones.new('teeth.T')
    bone.head = 0.0004, -0.7594, 0.8194
    bone.tail = 0.0004, -0.7302, 0.8292
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['teeth.T'] = bone.name
    bone = arm.edit_bones.new('teeth.B')
    bone.head = 0.0004, -0.7504, 0.7968
    bone.tail = 0.0004, -0.7204, 0.8041
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['teeth.B'] = bone.name
    bone = arm.edit_bones.new('tongue')
    bone.head = 0.0004, -0.7646, 0.7930
    bone.tail = 0.0004, -0.7476, 0.7967
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['face']]
    bones['tongue'] = bone.name
    bone = arm.edit_bones.new('front_toe.L')
    bone.head = 0.1088, -0.2462, 0.0411
    bone.tail = 0.1088, -0.3259, 0.0000
    bone.roll = 3.1416
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['front_foot.L']]
    bones['front_toe.L'] = bone.name
    bone = arm.edit_bones.new('front_toe.R')
    bone.head = -0.1088, -0.2462, 0.0411
    bone.tail = -0.1088, -0.3259, 0.0000
    bone.roll = -3.1416
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['front_foot.R']]
    bones['front_toe.R'] = bone.name
    bone = arm.edit_bones.new('r_pinky.03.L')
    bone.head = 0.1431, 0.3382, 0.0170
    bone.tail = 0.1455, 0.3175, 0.0129
    bone.roll = -1.0952
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_pinky.02.L']]
    bones['r_pinky.03.L'] = bone.name
    bone = arm.edit_bones.new('r_ring.03.L')
    bone.head = 0.1188, 0.3297, 0.0224
    bone.tail = 0.1239, 0.2905, 0.0129
    bone.roll = -0.9905
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_ring.02.L']]
    bones['r_ring.03.L'] = bone.name
    bone = arm.edit_bones.new('r_middle.03.L')
    bone.head = 0.0851, 0.3297, 0.0224
    bone.tail = 0.0813, 0.2904, 0.0129
    bone.roll = 0.8084
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_middle.02.L']]
    bones['r_middle.03.L'] = bone.name
    bone = arm.edit_bones.new('r_index.03.L')
    bone.head = 0.0623, 0.3410, 0.0170
    bone.tail = 0.0552, 0.3214, 0.0129
    bone.roll = 2.2048
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_index.02.L']]
    bones['r_index.03.L'] = bone.name
    bone = arm.edit_bones.new('r_pinky.03.R')
    bone.head = -0.1431, 0.3382, 0.0170
    bone.tail = -0.1455, 0.3175, 0.0129
    bone.roll = 1.0952
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_pinky.02.R']]
    bones['r_pinky.03.R'] = bone.name
    bone = arm.edit_bones.new('r_ring.03.R')
    bone.head = -0.1188, 0.3297, 0.0224
    bone.tail = -0.1239, 0.2905, 0.0129
    bone.roll = 0.9905
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_ring.02.R']]
    bones['r_ring.03.R'] = bone.name
    bone = arm.edit_bones.new('r_middle.03.R')
    bone.head = -0.0851, 0.3297, 0.0224
    bone.tail = -0.0813, 0.2904, 0.0129
    bone.roll = -0.8084
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_middle.02.R']]
    bones['r_middle.03.R'] = bone.name
    bone = arm.edit_bones.new('r_index.03.R')
    bone.head = -0.0623, 0.3410, 0.0170
    bone.tail = -0.0552, 0.3214, 0.0129
    bone.roll = -2.2048
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['r_index.02.R']]
    bones['r_index.03.R'] = bone.name
    bone = arm.edit_bones.new('nose.001')
    bone.head = 0.0000, -0.7989, 0.8595
    bone.tail = 0.0000, -0.8391, 0.8371
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['nose']]
    bones['nose.001'] = bone.name
    bone = arm.edit_bones.new('lip.T.L.001')
    bone.head = 0.0353, -0.7614, 0.7866
    bone.tail = 0.0482, -0.6927, 0.7995
    bone.roll = 0.1558
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lip.T.L']]
    bones['lip.T.L.001'] = bone.name
    bone = arm.edit_bones.new('lip.B.L.001')
    bone.head = 0.0258, -0.7624, 0.7742
    bone.tail = 0.0482, -0.6927, 0.7995
    bone.roll = 0.4650
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lip.B.L']]
    bones['lip.B.L.001'] = bone.name
    bone = arm.edit_bones.new('chin')
    bone.head = 0.0000, -0.6960, 0.7733
    bone.tail = 0.0000, -0.7687, 0.7625
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['jaw']]
    bones['chin'] = bone.name
    bone = arm.edit_bones.new('ear.L.001')
    bone.head = 0.0524, -0.5459, 0.9899
    bone.tail = 0.0727, -0.5682, 1.0212
    bone.roll = 0.2280
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['ear.L']]
    bones['ear.L.001'] = bone.name
    bone = arm.edit_bones.new('ear.R.001')
    bone.head = -0.0524, -0.5459, 0.9899
    bone.tail = -0.0727, -0.5682, 1.0212
    bone.roll = -0.2280
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['ear.R']]
    bones['ear.R.001'] = bone.name
    bone = arm.edit_bones.new('lip.T.R.001')
    bone.head = -0.0353, -0.7614, 0.7866
    bone.tail = -0.0482, -0.6927, 0.7995
    bone.roll = -0.1558
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lip.T.R']]
    bones['lip.T.R.001'] = bone.name
    bone = arm.edit_bones.new('lip.B.R.001')
    bone.head = -0.0258, -0.7624, 0.7742
    bone.tail = -0.0482, -0.6927, 0.7995
    bone.roll = -0.4650
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lip.B.R']]
    bones['lip.B.R.001'] = bone.name
    bone = arm.edit_bones.new('brow.B.L.001')
    bone.head = 0.0659, -0.6703, 0.9324
    bone.tail = 0.0507, -0.6764, 0.9344
    bone.roll = 0.0953
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['brow.B.L']]
    bones['brow.B.L.001'] = bone.name
    bone = arm.edit_bones.new('lid.T.L.001')
    bone.head = 0.0588, -0.6755, 0.9223
    bone.tail = 0.0503, -0.6779, 0.9257
    bone.roll = 0.4801
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.T.L']]
    bones['lid.T.L.001'] = bone.name
    bone = arm.edit_bones.new('brow.B.R.001')
    bone.head = -0.0659, -0.6703, 0.9324
    bone.tail = -0.0507, -0.6764, 0.9344
    bone.roll = -0.0953
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['brow.B.R']]
    bones['brow.B.R.001'] = bone.name
    bone = arm.edit_bones.new('lid.T.R.001')
    bone.head = -0.0588, -0.6755, 0.9223
    bone.tail = -0.0503, -0.6779, 0.9257
    bone.roll = -0.4801
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.T.R']]
    bones['lid.T.R.001'] = bone.name
    bone = arm.edit_bones.new('forehead.L.001')
    bone.head = 0.0418, -0.6520, 0.9749
    bone.tail = 0.0510, -0.6773, 0.9561
    bone.roll = 0.5278
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['forehead.L']]
    bones['forehead.L.001'] = bone.name
    bone = arm.edit_bones.new('forehead.R.001')
    bone.head = -0.0418, -0.6520, 0.9749
    bone.tail = -0.0510, -0.6773, 0.9561
    bone.roll = -0.5278
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['forehead.R']]
    bones['forehead.R.001'] = bone.name
    bone = arm.edit_bones.new('cheek.T.L.001')
    bone.head = 0.0660, -0.6881, 0.8704
    bone.tail = 0.0389, -0.7093, 0.8768
    bone.roll = -0.5772
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['cheek.T.L']]
    bones['cheek.T.L.001'] = bone.name
    bone = arm.edit_bones.new('cheek.T.R.001')
    bone.head = -0.0660, -0.6881, 0.8704
    bone.tail = -0.0389, -0.7093, 0.8768
    bone.roll = 0.5772
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['cheek.T.R']]
    bones['cheek.T.R.001'] = bone.name
    bone = arm.edit_bones.new('tongue.001')
    bone.head = 0.0004, -0.7476, 0.7967
    bone.tail = 0.0004, -0.7246, 0.8052
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['tongue']]
    bones['tongue.001'] = bone.name
    bone = arm.edit_bones.new('f_palm.04.L')
    bone.head = 0.1229, -0.2329, 0.0282
    bone.tail = 0.1426, -0.2749, 0.0253
    bone.roll = -2.8623
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['front_toe.L']]
    bones['f_palm.04.L'] = bone.name
    bone = arm.edit_bones.new('f_palm.03.L')
    bone.head = 0.1142, -0.2346, 0.0282
    bone.tail = 0.1239, -0.2833, 0.0377
    bone.roll = 1.5833
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['front_toe.L']]
    bones['f_palm.03.L'] = bone.name
    bone = arm.edit_bones.new('f_palm.02.L')
    bone.head = 0.1053, -0.2345, 0.0282
    bone.tail = 0.0983, -0.2834, 0.0377
    bone.roll = -1.2317
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['front_toe.L']]
    bones['f_palm.02.L'] = bone.name
    bone = arm.edit_bones.new('f_palm.01.L')
    bone.head = 0.0934, -0.2319, 0.0282
    bone.tail = 0.0791, -0.2716, 0.0253
    bone.roll = 2.8333
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['front_toe.L']]
    bones['f_palm.01.L'] = bone.name
    bone = arm.edit_bones.new('f_palm.04.R')
    bone.head = -0.1229, -0.2329, 0.0282
    bone.tail = -0.1426, -0.2749, 0.0253
    bone.roll = 2.8623
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['front_toe.R']]
    bones['f_palm.04.R'] = bone.name
    bone = arm.edit_bones.new('f_palm.03.R')
    bone.head = -0.1142, -0.2346, 0.0282
    bone.tail = -0.1239, -0.2833, 0.0377
    bone.roll = -1.5833
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['front_toe.R']]
    bones['f_palm.03.R'] = bone.name
    bone = arm.edit_bones.new('f_palm.02.R')
    bone.head = -0.1053, -0.2345, 0.0282
    bone.tail = -0.0983, -0.2834, 0.0377
    bone.roll = 1.2317
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['front_toe.R']]
    bones['f_palm.02.R'] = bone.name
    bone = arm.edit_bones.new('f_palm.01.R')
    bone.head = -0.0934, -0.2319, 0.0282
    bone.tail = -0.0791, -0.2716, 0.0253
    bone.roll = -2.8333
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['front_toe.R']]
    bones['f_palm.01.R'] = bone.name
    bone = arm.edit_bones.new('nose.002')
    bone.head = 0.0000, -0.8391, 0.8371
    bone.tail = 0.0000, -0.8452, 0.8281
    bone.roll = -0.0162
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['nose.001']]
    bones['nose.002'] = bone.name
    bone = arm.edit_bones.new('chin.001')
    bone.head = 0.0000, -0.7687, 0.7625
    bone.tail = 0.0000, -0.7926, 0.7756
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['chin']]
    bones['chin.001'] = bone.name
    bone = arm.edit_bones.new('ear.L.002')
    bone.head = 0.0727, -0.5682, 1.0212
    bone.tail = 0.1158, -0.5606, 1.0358
    bone.roll = -1.9007
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['ear.L.001']]
    bones['ear.L.002'] = bone.name
    bone = arm.edit_bones.new('ear.R.002')
    bone.head = -0.0727, -0.5682, 1.0212
    bone.tail = -0.1158, -0.5606, 1.0358
    bone.roll = 1.9007
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['ear.R.001']]
    bones['ear.R.002'] = bone.name
    bone = arm.edit_bones.new('brow.B.L.002')
    bone.head = 0.0507, -0.6764, 0.9344
    bone.tail = 0.0362, -0.6871, 0.9343
    bone.roll = 0.2604
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['brow.B.L.001']]
    bones['brow.B.L.002'] = bone.name
    bone = arm.edit_bones.new('lid.T.L.002')
    bone.head = 0.0503, -0.6779, 0.9257
    bone.tail = 0.0361, -0.6798, 0.9241
    bone.roll = 0.0945
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.T.L.001']]
    bones['lid.T.L.002'] = bone.name
    bone = arm.edit_bones.new('brow.B.R.002')
    bone.head = -0.0507, -0.6764, 0.9344
    bone.tail = -0.0362, -0.6871, 0.9343
    bone.roll = -0.2604
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['brow.B.R.001']]
    bones['brow.B.R.002'] = bone.name
    bone = arm.edit_bones.new('lid.T.R.002')
    bone.head = -0.0503, -0.6779, 0.9257
    bone.tail = -0.0361, -0.6798, 0.9241
    bone.roll = -0.0945
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.T.R.001']]
    bones['lid.T.R.002'] = bone.name
    bone = arm.edit_bones.new('forehead.L.002')
    bone.head = 0.0581, -0.6362, 0.9723
    bone.tail = 0.0774, -0.6567, 0.9438
    bone.roll = -0.3374
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['forehead.L.001']]
    bones['forehead.L.002'] = bone.name
    bone = arm.edit_bones.new('forehead.R.002')
    bone.head = -0.0581, -0.6362, 0.9723
    bone.tail = -0.0774, -0.6567, 0.9438
    bone.roll = 0.3374
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['forehead.R.001']]
    bones['forehead.R.002'] = bone.name
    bone = arm.edit_bones.new('nose.L')
    bone.head = 0.0389, -0.7093, 0.8768
    bone.tail = 0.0360, -0.7993, 0.8371
    bone.roll = -2.8274
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['cheek.T.L.001']]
    bones['nose.L'] = bone.name
    bone = arm.edit_bones.new('nose.R')
    bone.head = -0.0389, -0.7093, 0.8768
    bone.tail = -0.0360, -0.7993, 0.8371
    bone.roll = 2.8274
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['cheek.T.R.001']]
    bones['nose.R'] = bone.name
    bone = arm.edit_bones.new('tongue.002')
    bone.head = 0.0004, -0.7246, 0.8052
    bone.tail = 0.0004, -0.6900, 0.8003
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['tongue.001']]
    bones['tongue.002'] = bone.name
    bone = arm.edit_bones.new('f_pinky.01.L')
    bone.head = 0.1426, -0.2749, 0.0253
    bone.tail = 0.1477, -0.2946, 0.0222
    bone.roll = -2.0928
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['f_palm.04.L']]
    bones['f_pinky.01.L'] = bone.name
    bone = arm.edit_bones.new('f_ring.01.L')
    bone.head = 0.1239, -0.2833, 0.0377
    bone.tail = 0.1255, -0.3031, 0.0317
    bone.roll = -0.5451
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['f_palm.03.L']]
    bones['f_ring.01.L'] = bone.name
    bone = arm.edit_bones.new('f_middle.01.L')
    bone.head = 0.0983, -0.2834, 0.0377
    bone.tail = 0.0955, -0.3030, 0.0317
    bone.roll = 0.9401
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['f_palm.02.L']]
    bones['f_middle.01.L'] = bone.name
    bone = arm.edit_bones.new('f_index.01.L')
    bone.head = 0.0791, -0.2716, 0.0253
    bone.tail = 0.0749, -0.2916, 0.0222
    bone.roll = 1.9945
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['f_palm.01.L']]
    bones['f_index.01.L'] = bone.name
    bone = arm.edit_bones.new('f_pinky.01.R')
    bone.head = -0.1426, -0.2749, 0.0253
    bone.tail = -0.1477, -0.2946, 0.0222
    bone.roll = 2.0928
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['f_palm.04.R']]
    bones['f_pinky.01.R'] = bone.name
    bone = arm.edit_bones.new('f_ring.01.R')
    bone.head = -0.1239, -0.2833, 0.0377
    bone.tail = -0.1255, -0.3031, 0.0317
    bone.roll = 0.5451
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['f_palm.03.R']]
    bones['f_ring.01.R'] = bone.name
    bone = arm.edit_bones.new('f_middle.01.R')
    bone.head = -0.0983, -0.2834, 0.0377
    bone.tail = -0.0955, -0.3030, 0.0317
    bone.roll = -0.9401
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['f_palm.02.R']]
    bones['f_middle.01.R'] = bone.name
    bone = arm.edit_bones.new('f_index.01.R')
    bone.head = -0.0791, -0.2716, 0.0253
    bone.tail = -0.0749, -0.2916, 0.0222
    bone.roll = -1.9945
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['f_palm.01.R']]
    bones['f_index.01.R'] = bone.name
    bone = arm.edit_bones.new('nose.003')
    bone.head = 0.0000, -0.8452, 0.8281
    bone.tail = 0.0000, -0.8349, 0.8089
    bone.roll = -0.0248
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['nose.002']]
    bones['nose.003'] = bone.name
    bone = arm.edit_bones.new('ear.L.003')
    bone.head = 0.1158, -0.5606, 1.0358
    bone.tail = 0.1130, -0.5379, 0.9935
    bone.roll = 2.4141
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['ear.L.002']]
    bones['ear.L.003'] = bone.name
    bone = arm.edit_bones.new('ear.R.003')
    bone.head = -0.1158, -0.5606, 1.0358
    bone.tail = -0.1130, -0.5379, 0.9935
    bone.roll = -2.4141
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['ear.R.002']]
    bones['ear.R.003'] = bone.name
    bone = arm.edit_bones.new('brow.B.L.003')
    bone.head = 0.0362, -0.6871, 0.9343
    bone.tail = 0.0269, -0.6936, 0.9293
    bone.roll = 0.2912
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['brow.B.L.002']]
    bones['brow.B.L.003'] = bone.name
    bone = arm.edit_bones.new('lid.T.L.003')
    bone.head = 0.0361, -0.6798, 0.9241
    bone.tail = 0.0281, -0.6756, 0.9088
    bone.roll = -0.3539
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.T.L.002']]
    bones['lid.T.L.003'] = bone.name
    bone = arm.edit_bones.new('brow.B.R.003')
    bone.head = -0.0362, -0.6871, 0.9343
    bone.tail = -0.0269, -0.6936, 0.9293
    bone.roll = -0.2912
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['brow.B.R.002']]
    bones['brow.B.R.003'] = bone.name
    bone = arm.edit_bones.new('lid.T.R.003')
    bone.head = -0.0361, -0.6798, 0.9241
    bone.tail = -0.0281, -0.6756, 0.9088
    bone.roll = 0.3539
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.T.R.002']]
    bones['lid.T.R.003'] = bone.name
    bone = arm.edit_bones.new('temple.L')
    bone.head = 0.0590, -0.5870, 0.9758
    bone.tail = 0.0931, -0.5866, 0.8642
    bone.roll = -0.4594
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['forehead.L.002']]
    bones['temple.L'] = bone.name
    bone = arm.edit_bones.new('temple.R')
    bone.head = -0.0590, -0.5870, 0.9758
    bone.tail = -0.0931, -0.5866, 0.8642
    bone.roll = 0.4594
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['forehead.R.002']]
    bones['temple.R'] = bone.name
    bone = arm.edit_bones.new('nose.L.001')
    bone.head = 0.0360, -0.7993, 0.8371
    bone.tail = 0.0000, -0.8391, 0.8371
    bone.roll = 2.9287
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['nose.L']]
    bones['nose.L.001'] = bone.name
    bone = arm.edit_bones.new('nose.R.001')
    bone.head = -0.0360, -0.7993, 0.8371
    bone.tail = 0.0000, -0.8391, 0.8371
    bone.roll = -2.9287
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['nose.R']]
    bones['nose.R.001'] = bone.name
    bone = arm.edit_bones.new('f_pinky.02.L')
    bone.head = 0.1477, -0.2946, 0.0222
    bone.tail = 0.1520, -0.3116, 0.0170
    bone.roll = -1.4292
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_pinky.01.L']]
    bones['f_pinky.02.L'] = bone.name
    bone = arm.edit_bones.new('f_ring.02.L')
    bone.head = 0.1255, -0.3031, 0.0317
    bone.tail = 0.1278, -0.3200, 0.0224
    bone.roll = -0.5100
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_ring.01.L']]
    bones['f_ring.02.L'] = bone.name
    bone = arm.edit_bones.new('f_middle.02.L')
    bone.head = 0.0955, -0.3030, 0.0317
    bone.tail = 0.0940, -0.3200, 0.0224
    bone.roll = 0.4076
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_middle.01.L']]
    bones['f_middle.02.L'] = bone.name
    bone = arm.edit_bones.new('f_index.02.L')
    bone.head = 0.0749, -0.2916, 0.0222
    bone.tail = 0.0712, -0.3087, 0.0170
    bone.roll = 1.3847
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_index.01.L']]
    bones['f_index.02.L'] = bone.name
    bone = arm.edit_bones.new('f_pinky.02.R')
    bone.head = -0.1477, -0.2946, 0.0222
    bone.tail = -0.1520, -0.3116, 0.0170
    bone.roll = 1.4292
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_pinky.01.R']]
    bones['f_pinky.02.R'] = bone.name
    bone = arm.edit_bones.new('f_ring.02.R')
    bone.head = -0.1255, -0.3031, 0.0317
    bone.tail = -0.1278, -0.3200, 0.0224
    bone.roll = 0.5100
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_ring.01.R']]
    bones['f_ring.02.R'] = bone.name
    bone = arm.edit_bones.new('f_middle.02.R')
    bone.head = -0.0955, -0.3030, 0.0317
    bone.tail = -0.0940, -0.3200, 0.0224
    bone.roll = -0.4076
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_middle.01.R']]
    bones['f_middle.02.R'] = bone.name
    bone = arm.edit_bones.new('f_index.02.R')
    bone.head = -0.0749, -0.2916, 0.0222
    bone.tail = -0.0712, -0.3087, 0.0170
    bone.roll = -1.3847
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_index.01.R']]
    bones['f_index.02.R'] = bone.name
    bone = arm.edit_bones.new('nose.004')
    bone.head = 0.0000, -0.8349, 0.8089
    bone.tail = 0.0000, -0.8159, 0.7913
    bone.roll = 0.0082
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['nose.003']]
    bones['nose.004'] = bone.name
    bone = arm.edit_bones.new('ear.L.004')
    bone.head = 0.1130, -0.5379, 0.9935
    bone.tail = 0.0949, -0.5457, 0.9545
    bone.roll = -2.3814
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['ear.L.003']]
    bones['ear.L.004'] = bone.name
    bone = arm.edit_bones.new('ear.R.004')
    bone.head = -0.1130, -0.5379, 0.9935
    bone.tail = -0.0949, -0.5457, 0.9545
    bone.roll = 2.3814
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['ear.R.003']]
    bones['ear.R.004'] = bone.name
    bone = arm.edit_bones.new('lid.B.L')
    bone.head = 0.0281, -0.6756, 0.9088
    bone.tail = 0.0382, -0.6786, 0.9040
    bone.roll = 0.2941
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.T.L.003']]
    bones['lid.B.L'] = bone.name
    bone = arm.edit_bones.new('lid.B.R')
    bone.head = -0.0281, -0.6756, 0.9088
    bone.tail = -0.0382, -0.6786, 0.9040
    bone.roll = -0.2941
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.T.R.003']]
    bones['lid.B.R'] = bone.name
    bone = arm.edit_bones.new('jaw.L')
    bone.head = 0.0931, -0.5866, 0.8642
    bone.tail = 0.0694, -0.6211, 0.8005
    bone.roll = 0.0983
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['temple.L']]
    bones['jaw.L'] = bone.name
    bone = arm.edit_bones.new('jaw.R')
    bone.head = -0.0931, -0.5866, 0.8642
    bone.tail = -0.0694, -0.6211, 0.8005
    bone.roll = -0.0983
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['temple.R']]
    bones['jaw.R'] = bone.name
    bone = arm.edit_bones.new('f_pinky.03.L')
    bone.head = 0.1520, -0.3116, 0.0170
    bone.tail = 0.1544, -0.3323, 0.0129
    bone.roll = -1.0952
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_pinky.02.L']]
    bones['f_pinky.03.L'] = bone.name
    bone = arm.edit_bones.new('f_ring.03.L')
    bone.head = 0.1278, -0.3200, 0.0224
    bone.tail = 0.1328, -0.3592, 0.0129
    bone.roll = -0.9905
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_ring.02.L']]
    bones['f_ring.03.L'] = bone.name
    bone = arm.edit_bones.new('f_middle.03.L')
    bone.head = 0.0940, -0.3200, 0.0224
    bone.tail = 0.0902, -0.3593, 0.0129
    bone.roll = 0.8084
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_middle.02.L']]
    bones['f_middle.03.L'] = bone.name
    bone = arm.edit_bones.new('f_index.03.L')
    bone.head = 0.0712, -0.3087, 0.0170
    bone.tail = 0.0641, -0.3283, 0.0129
    bone.roll = 2.2048
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_index.02.L']]
    bones['f_index.03.L'] = bone.name
    bone = arm.edit_bones.new('f_pinky.03.R')
    bone.head = -0.1520, -0.3116, 0.0170
    bone.tail = -0.1544, -0.3323, 0.0129
    bone.roll = 1.0952
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_pinky.02.R']]
    bones['f_pinky.03.R'] = bone.name
    bone = arm.edit_bones.new('f_ring.03.R')
    bone.head = -0.1278, -0.3200, 0.0224
    bone.tail = -0.1328, -0.3592, 0.0129
    bone.roll = 0.9905
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_ring.02.R']]
    bones['f_ring.03.R'] = bone.name
    bone = arm.edit_bones.new('f_middle.03.R')
    bone.head = -0.0940, -0.3200, 0.0224
    bone.tail = -0.0902, -0.3593, 0.0129
    bone.roll = -0.8084
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_middle.02.R']]
    bones['f_middle.03.R'] = bone.name
    bone = arm.edit_bones.new('f_index.03.R')
    bone.head = -0.0712, -0.3087, 0.0170
    bone.tail = -0.0641, -0.3283, 0.0129
    bone.roll = -2.2048
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['f_index.02.R']]
    bones['f_index.03.R'] = bone.name
    bone = arm.edit_bones.new('lid.B.L.001')
    bone.head = 0.0382, -0.6786, 0.9040
    bone.tail = 0.0476, -0.6772, 0.9036
    bone.roll = 0.0266
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.B.L']]
    bones['lid.B.L.001'] = bone.name
    bone = arm.edit_bones.new('lid.B.R.001')
    bone.head = -0.0382, -0.6786, 0.9040
    bone.tail = -0.0476, -0.6772, 0.9036
    bone.roll = -0.0266
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.B.R']]
    bones['lid.B.R.001'] = bone.name
    bone = arm.edit_bones.new('jaw.L.001')
    bone.head = 0.0694, -0.6211, 0.8005
    bone.tail = 0.0481, -0.6715, 0.7849
    bone.roll = 0.2993
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['jaw.L']]
    bones['jaw.L.001'] = bone.name
    bone = arm.edit_bones.new('jaw.R.001')
    bone.head = -0.0694, -0.6211, 0.8005
    bone.tail = -0.0481, -0.6715, 0.7849
    bone.roll = -0.2993
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['jaw.R']]
    bones['jaw.R.001'] = bone.name
    bone = arm.edit_bones.new('lid.B.L.002')
    bone.head = 0.0476, -0.6772, 0.9036
    bone.tail = 0.0570, -0.6724, 0.9082
    bone.roll = -0.1195
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.B.L.001']]
    bones['lid.B.L.002'] = bone.name
    bone = arm.edit_bones.new('lid.B.R.002')
    bone.head = -0.0476, -0.6772, 0.9036
    bone.tail = -0.0570, -0.6724, 0.9082
    bone.roll = 0.1195
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.B.R.001']]
    bones['lid.B.R.002'] = bone.name
    bone = arm.edit_bones.new('chin.L')
    bone.head = 0.0481, -0.6715, 0.7849
    bone.tail = 0.0482, -0.6927, 0.7995
    bone.roll = 3.1083
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['jaw.L.001']]
    bones['chin.L'] = bone.name
    bone = arm.edit_bones.new('chin.R')
    bone.head = -0.0481, -0.6715, 0.7849
    bone.tail = -0.0482, -0.6927, 0.7995
    bone.roll = -3.1083
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['jaw.R.001']]
    bones['chin.R'] = bone.name
    bone = arm.edit_bones.new('lid.B.L.003')
    bone.head = 0.0570, -0.6724, 0.9082
    bone.tail = 0.0621, -0.6644, 0.9197
    bone.roll = -0.1171
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.B.L.002']]
    bones['lid.B.L.003'] = bone.name
    bone = arm.edit_bones.new('lid.B.R.003')
    bone.head = -0.0570, -0.6724, 0.9082
    bone.tail = -0.0621, -0.6644, 0.9197
    bone.roll = 0.1171
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['lid.B.R.002']]
    bones['lid.B.R.003'] = bone.name
    bone = arm.edit_bones.new('cheek.B.L')
    bone.head = 0.0482, -0.6927, 0.7995
    bone.tail = 0.0707, -0.6771, 0.8294
    bone.roll = -0.1207
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['chin.L']]
    bones['cheek.B.L'] = bone.name
    bone = arm.edit_bones.new('cheek.B.R')
    bone.head = -0.0482, -0.6927, 0.7995
    bone.tail = -0.0707, -0.6771, 0.8294
    bone.roll = 0.1207
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['chin.R']]
    bones['cheek.B.R'] = bone.name
    bone = arm.edit_bones.new('cheek.B.L.001')
    bone.head = 0.0707, -0.6771, 0.8294
    bone.tail = 0.0906, -0.6428, 0.9032
    bone.roll = 0.0640
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['cheek.B.L']]
    bones['cheek.B.L.001'] = bone.name
    bone = arm.edit_bones.new('cheek.B.R.001')
    bone.head = -0.0707, -0.6771, 0.8294
    bone.tail = -0.0906, -0.6428, 0.9032
    bone.roll = -0.0640
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['cheek.B.R']]
    bones['cheek.B.R.001'] = bone.name
    bone = arm.edit_bones.new('brow.T.L')
    bone.head = 0.0906, -0.6428, 0.9032
    bone.tail = 0.0774, -0.6567, 0.9438
    bone.roll = 0.1270
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['cheek.B.L.001']]
    bones['brow.T.L'] = bone.name
    bone = arm.edit_bones.new('brow.T.R')
    bone.head = -0.0906, -0.6428, 0.9032
    bone.tail = -0.0774, -0.6567, 0.9438
    bone.roll = -0.1270
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['cheek.B.R.001']]
    bones['brow.T.R'] = bone.name
    bone = arm.edit_bones.new('brow.T.L.001')
    bone.head = 0.0774, -0.6567, 0.9438
    bone.tail = 0.0510, -0.6773, 0.9561
    bone.roll = -2.7274
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['brow.T.L']]
    bones['brow.T.L.001'] = bone.name
    bone = arm.edit_bones.new('brow.T.R.001')
    bone.head = -0.0774, -0.6567, 0.9438
    bone.tail = -0.0510, -0.6773, 0.9561
    bone.roll = 2.7274
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['brow.T.R']]
    bones['brow.T.R.001'] = bone.name
    bone = arm.edit_bones.new('brow.T.L.002')
    bone.head = 0.0510, -0.6773, 0.9561
    bone.tail = 0.0160, -0.7017, 0.9527
    bone.roll = 0.4172
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['brow.T.L.001']]
    bones['brow.T.L.002'] = bone.name
    bone = arm.edit_bones.new('brow.T.R.002')
    bone.head = -0.0510, -0.6773, 0.9561
    bone.tail = -0.0160, -0.7017, 0.9527
    bone.roll = -0.4172
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['brow.T.R.001']]
    bones['brow.T.R.002'] = bone.name
    bone = arm.edit_bones.new('brow.T.L.003')
    bone.head = 0.0160, -0.7017, 0.9527
    bone.tail = 0.0000, -0.7082, 0.9031
    bone.roll = -0.6706
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['brow.T.L.002']]
    bones['brow.T.L.003'] = bone.name
    bone = arm.edit_bones.new('brow.T.R.003')
    bone.head = -0.0160, -0.7017, 0.9527
    bone.tail = 0.0000, -0.7082, 0.9031
    bone.roll = 0.6706
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['brow.T.R.002']]
    bones['brow.T.R.003'] = bone.name

    bpy.ops.object.mode_set(mode='OBJECT')
    pbone = obj.pose.bones[bones['spine.004']]
    pbone.rigify_type = 'spines.basic_spine'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    try:
        pbone.rigify_parameters.pivot_pos = 2
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Spine (Tweak)')
    assign_bone_collection_refs(pbone.rigify_parameters, 'fk', 'Spine (Tweak)')
    pbone = obj.pose.bones[bones['spine.003']]
    pbone.rigify_type = 'spines.basic_tail'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Tail')
    try:
        pbone.rigify_parameters.copy_rotation_axes = (True, False, True)
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters.connect_chain = True
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Spine (Tweak)')
    pbone = obj.pose.bones[bones['spine.005']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    try:
        pbone.rigify_parameters.neck_pos = 5
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Spine (Tweak)')
    pbone = obj.pose.bones[bones['spine.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Tail')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Face (Primary)')
    pbone = obj.pose.bones[bones['spine.006']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    pbone = obj.pose.bones[bones['pelvis.L']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    assign_bone_collections(pbone, 'Spine')
    try:
        pbone.rigify_parameters.make_control = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['pelvis.R']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    assign_bone_collections(pbone, 'Spine')
    try:
        pbone.rigify_parameters.make_control = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['thigh.L']]
    pbone.rigify_type = 'limbs.rear_paw'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.L (IK)')
    try:
        pbone.rigify_parameters.limb_type = 'paw'
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters.ik_local_location = False
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'fk', 'Leg.L (FK)')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Leg.L (Tweak)')
    pbone = obj.pose.bones[bones['thigh.R']]
    pbone.rigify_type = 'limbs.rear_paw'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.R (IK)')
    try:
        pbone.rigify_parameters.limb_type = 'paw'
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters.ik_local_location = False
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'fk', 'Leg.R (FK)')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Leg.R (Tweak)')
    pbone = obj.pose.bones[bones['spine.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Tail')
    pbone = obj.pose.bones[bones['spine.007']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    pbone = obj.pose.bones[bones['shin.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.L (IK)')
    pbone = obj.pose.bones[bones['shin.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.R (IK)')
    pbone = obj.pose.bones[bones['spine']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Tail')
    pbone = obj.pose.bones[bones['spine.008']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    pbone = obj.pose.bones[bones['foot.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.L (IK)')
    pbone = obj.pose.bones[bones['foot.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.R (IK)')
    pbone = obj.pose.bones[bones['spine.009']]
    pbone.rigify_type = 'spines.super_head'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    try:
        pbone.rigify_parameters.connect_chain = True
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Spine (Tweak)')
    pbone = obj.pose.bones[bones['shoulder.L']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    assign_bone_collections(pbone, 'Arm.L (IK)')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['shoulder.R']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    assign_bone_collections(pbone, 'Arm.R (IK)')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['breast.L']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    assign_bone_collections(pbone, 'Spine (Tweak)')
    pbone = obj.pose.bones[bones['breast.R']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    assign_bone_collections(pbone, 'Spine (Tweak)')
    pbone = obj.pose.bones[bones['toe.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.L (IK)')
    try:
        pbone.rigify_parameters.limb_type = 'paw'
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['toe.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.R (IK)')
    try:
        pbone.rigify_parameters.limb_type = 'paw'
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['spine.010']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    pbone = obj.pose.bones[bones['front_thigh.L']]
    pbone.rigify_type = 'limbs.front_paw'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Arm.L (IK)')
    try:
        pbone.rigify_parameters.limb_type = 'paw'
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters.ik_local_location = False
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'fk', 'Arm.L (FK)')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Arm.L (Tweak)')
    pbone = obj.pose.bones[bones['front_thigh.R']]
    pbone.rigify_type = 'limbs.front_paw'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Arm.R (IK)')
    try:
        pbone.rigify_parameters.limb_type = 'paw'
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters.ik_local_location = False
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'fk', 'Arm.R (FK)')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Arm.R (Tweak)')
    pbone = obj.pose.bones[bones['r_palm.04.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_palm.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_palm.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_palm.01.L']]
    pbone.rigify_type = 'limbs.super_palm'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_palm.04.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_palm.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_palm.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_palm.01.R']]
    pbone.rigify_type = 'limbs.super_palm'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['spine.011']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    pbone = obj.pose.bones[bones['front_shin.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Arm.L (IK)')
    pbone = obj.pose.bones[bones['front_shin.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Arm.R (IK)')
    pbone = obj.pose.bones[bones['r_pinky.01.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['r_ring.01.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['r_middle.01.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['r_index.01.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['r_pinky.01.R']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['r_ring.01.R']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['r_middle.01.R']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['r_index.01.R']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['face']]
    pbone.rigify_type = 'faces.super_face'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    assign_bone_collection_refs(pbone.rigify_parameters, 'secondary', 'Face (Secondary)')
    assign_bone_collection_refs(pbone.rigify_parameters, 'primary', 'Face (Primary)')
    pbone = obj.pose.bones[bones['front_foot.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Arm.L (IK)')
    pbone = obj.pose.bones[bones['front_foot.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Arm.R (IK)')
    pbone = obj.pose.bones[bones['r_pinky.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_ring.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_middle.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_index.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_pinky.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_ring.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_middle.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_index.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['nose']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lip.T.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lip.B.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['jaw']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['ear.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['ear.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lip.T.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lip.B.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.B.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.T.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.B.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.T.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['forehead.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['forehead.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['eye.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['eye.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['cheek.T.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['cheek.T.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['teeth.T']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['teeth.B']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['tongue']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['front_toe.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Arm.L (IK)')
    try:
        pbone.rigify_parameters.limb_type = 'paw'
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['front_toe.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Arm.R (IK)')
    try:
        pbone.rigify_parameters.rotation_axis = 'x'
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters.limb_type = 'paw'
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['r_pinky.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_ring.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_middle.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_index.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_pinky.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_ring.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_middle.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['r_index.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['nose.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lip.T.L.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lip.B.L.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['chin']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['ear.L.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['ear.R.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lip.T.R.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lip.B.R.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.B.L.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.T.L.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.B.R.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.T.R.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['forehead.L.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['forehead.R.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['cheek.T.L.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['cheek.T.R.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['tongue.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['f_palm.04.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_palm.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_palm.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_palm.01.L']]
    pbone.rigify_type = 'limbs.super_palm'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_palm.04.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_palm.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_palm.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_palm.01.R']]
    pbone.rigify_type = 'limbs.super_palm'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['nose.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['chin.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['ear.L.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['ear.R.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.B.L.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.T.L.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.B.R.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.T.R.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['forehead.L.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['forehead.R.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['nose.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['nose.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['tongue.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['f_pinky.01.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['f_ring.01.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['f_middle.01.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['f_index.01.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['f_pinky.01.R']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['f_ring.01.R']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['f_middle.01.R']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['f_index.01.R']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Paws (Tweak)')
    pbone = obj.pose.bones[bones['nose.003']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['ear.L.003']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['ear.R.003']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.B.L.003']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.T.L.003']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.B.R.003']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.T.R.003']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['temple.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['temple.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['nose.L.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['nose.R.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['f_pinky.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_ring.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_middle.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_index.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_pinky.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_ring.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_middle.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_index.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['nose.004']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['ear.L.004']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['ear.R.004']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.B.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.B.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['jaw.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['jaw.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['f_pinky.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_ring.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_middle.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_index.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_pinky.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_ring.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_middle.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['f_index.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Paws')
    pbone = obj.pose.bones[bones['lid.B.L.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.B.R.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['jaw.L.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['jaw.R.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.B.L.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.B.R.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['chin.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['chin.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.B.L.003']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['lid.B.R.003']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['cheek.B.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['cheek.B.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['cheek.B.L.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['cheek.B.R.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.T.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.T.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.T.L.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.T.R.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.T.L.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.T.R.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.T.L.003']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['brow.T.R.003']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')

    bpy.ops.object.mode_set(mode='EDIT')
    for bone in arm.edit_bones:
        bone.select = False
        bone.select_head = False
        bone.select_tail = False
    for b in bones:
        bone = arm.edit_bones[bones[b]]
        bone.select = True
        bone.select_head = True
        bone.select_tail = True
        bone.bbone_x = bone.bbone_z = bone.length * 0.05
        arm.edit_bones.active = bone

    arm.collections.active_index = 0

    return bones


if __name__ == "__main__":
    create(bpy.context.active_object)
