/* SPDX-License-Identifier: GPL-2.0-or-later */

/*
 * Memory map for Neoverse N2
 * See Technical Reference: Table 5-2: FVP board peripherals
 */

#define RDN2_FLASH_BASE			0x08000000
#define RDN2_FLASH_SIZE			(64 * MiB)

/* Actual DRAM size should be probed */
#define RDN2_DRAM_BASE			0x80000000
#define RDN2_DRAM_SIZE			(2 * GiB)

#define RDN2_SECMEM_BASE		0xff000000
#define RDN2_SECMEM_SIZE		(16 * MiB)

#define RDN2_DRAM2_BASE			0x8080000000
#define RDN2_DRAM2_SIZE			(6UL * GiB)

#define RDN2_GIC_DIST			0x30000000
#define RDN2_GIC_REDIST			0x301C0000
#define RDN2_VGIC_BASE			0x2c020000
#define RDN2_HGIC_BASE			0x2c010000

#define RDN2_GIC_ITS_BASE		0x30040000
#define RDN2_GIC_ITS_SIZE		0x40000
#define RDN2_GIC_ITS(i)			(RDN2_GIC_ITS_BASE + i * RDN2_GIC_ITS_SIZE)

#define SEC_EL1_TIMER_GISV		29
#define NONSEC_EL1_TIMER_GSIV		30
#define VIRTUAL_TIMER_GSIV		27
#define NONSEC_EL2_TIMER_GSIV		26

#define RDN2_TIMER_FLAGS (ACPI_GTDT_INTERRUPT_POLARITY)
#define RDN2_GT_CTL_BASE		0x2A810000
#define RDN2_GT_FRAME0_CTL_BASE		0x2A820000
#define RDN2_GT_FRAME0_EL0_BASE		-1
#define RDN2_GT_FRAME0_GSIV		0x6c

#define RDN2_GT_FRAME1_CTL_BASE		0x2A830000
#define RDN2_GT_FRAME1_EL0_BASE		-1
#define RDN2_GT_FRAME1_GSIV		0x6d

#define RDN2_GWDT_REFRESH		0x2a450000
#define RDN2_GWDT_CONTROL		0x2a440000
#define RDN2_GWDT_WS0_GSIV		0x6e
#define RDN2_GWDT_WS1_GSIV		0x6f

#define RDN2_UART_CLK_HZ		7372800
#define RDN2_UART_NS_BASE		0x2a400000
#define RDN2_UART_NS_GSIV		112
#define RDN2_SECURE_UART_BASE		0x2a410000
#define RDN2_SECURE_UART_GSIV		81

#define RDN2_RTC_BASE			0x0C170000
#define RDN2_RTC1_BASE			0x0C180000
#define RDN2_GPIO_BASE			0x0c1d0000
#define RDN2_GPIO1_BASE			0x0c1e0000

#define RDN2_SMMU_BASE			0x40000000
#define RDN2_SMMU_SIZE			0x2000000




#define RDN2_SMMU_V3(i) (RDN2_SMMU_BASE + i * RDN2_SMMU_SIZE)
#define ACPI_IORT_SMMU_V3_FLAGS	(ACPI_IORT_SMMU_V3_COHACC_OVERRIDE | ACPI_IORT_SMMU_V3_DEVICEID_VALID)

#define RDN2_DMA0_BASE			0x1090000000
#define RDN2_DMA1_BASE			0x10B0000000
/* Virtio block device */
#define RDN2_AHCI_BASE			0x0C130000
#define RDN2_AHCI_INT			458

/* Virtio net */
#define RDN2_VNET_BASE			0x0C150000
#define RDN2_VNET_INT			460

/* Arm Dual-Timer Module */
#define RDN2_DUAL_TIMER			0x0C110000
#define RDN2_DUAL_TIMER_INT		486

#define RDN2_GPIO0			0x0C1D0000
#define RDN2_GPIO0_INT			392

#define RDN2_EHCI_BASE			0x60110000

#define RDN2_PCIE_MMIO_BASE		0x60000000
#define RDN2_PCIE_MMIO_LIMIT		0x7fffffff
#define RDN2_PCIE_MMIO_SIZE		0x20000000
#define RDN2_PCIE_ECAM_BASE		0x1010000000
#define RDN2_PCIE_ECAM_LIMIT		0x101FFFFFFF
#define RDN2_PCIE_ECAM_SIZE		0x10000000
#define RDN2_PCIE_MMIO_HIGH_BASE	0x4000000000
#define RDN2_PCIE_MMIO_HIGH_LIMIT	0x807fffffff
#define RDN2_PCIE_MMIO_HIGH_SIZE	0x4080000000
