/* $Id: method.h 224642 2021-08-25 22:03:29Z twu $ */
#ifndef METHOD_INCLUDED
#define METHOD_INCLUDED

#include "filestring.h"


/* Keep in order of single_read */
typedef enum {TR, /* tr, from Kmer_search_transcriptome_{single|paired} */
	      KMER_EXACT, /* both ends, from Kmer_search_genome_ends_exact */
	      EXT, /* ext, from Extension_search */
	      KMER_APPROX, /* both ends, from Kmer_search_genome_ends_approx */
	      SEGMENT1, /* seg1, from Segment_search_genome */
	      DISTANT_RNA, /* distant, from Distant_rna_solve */
	      DISTANT_DNA, /* distant, from Distant_dna_solve */
	      TERMINAL, /* term, from Terminal_solve */
	      SEGMENT2, /* seg2, from Segment_search_genome */} Method_T;

extern char *
Method_string (Method_T method);
extern void
Method_samprint (Filestring_T fp, Method_T method);
extern void
Method_print (Filestring_T fp, Method_T method);

#endif

