package network

import (
	"bytes"
	"text/template"
)

const (
	resolvFileTemplate = `# Generated by CRC
{{ range .SearchDomains }}search {{ .Domain }}{{ end }}
{{ range .NameServers }}nameserver {{ .IPAddress }}
{{ end }}
`
)

func CreateResolvFile(values ResolvFileValues) (string, error) {
	var resolvFile bytes.Buffer

	t, err := template.New("resolvfile").Parse(resolvFileTemplate)
	if err != nil {
		return "", err
	}
	err = t.Execute(&resolvFile, values)
	if err != nil {
		return "", err
	}

	return resolvFile.String(), nil
}
