/*
 * Copyright © 2025 Red Hat, Inc
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Matthias Clasen <mclasen@redhat.com>
 */

#pragma once

#include <gtk/gtk.h>

#include "icon-editor-application.h"


#define ICON_EDITOR_WINDOW_TYPE (icon_editor_window_get_type ())
G_DECLARE_FINAL_TYPE (IconEditorWindow, icon_editor_window, ICON_EDITOR, WINDOW, GtkApplicationWindow)


IconEditorWindow * icon_editor_window_new  (IconEditorApplication *application);
gboolean           icon_editor_window_load (IconEditorWindow      *self,
                                            GFile                 *file);
