// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

.intel_syntax noprefix
#include <AsmOffsets.inc>         // generated by the build from AsmOffsets.cpp
#include <unixasmmacros.inc>

LEAF_ENTRY RhpCastableObjectDispatch_CommonStub, _TEXT
        // UNIXTODO: Implement this function
        int 3
LEAF_END RhpCastableObjectDispatch_CommonStub, _TEXT

LEAF_ENTRY RhpTailCallTLSDispatchCell, _TEXT
        // UNIXTODO: Implement this function
        int 3
LEAF_END RhpTailCallTLSDispatchCell, _TEXT

LEAF_ENTRY RhpCastableObjectDispatchHelper_TailCalled, _TEXT
        // UNIXTODO: Implement this function
        int 3
LEAF_END RhpCastableObjectDispatchHelper_TailCalled, _TEXT

LEAF_ENTRY RhpCastableObjectDispatchHelper, _TEXT
        // UNIXTODO: Implement this function
        int 3
LEAF_END RhpCastableObjectDispatchHelper, _TEXT


// Macro that generates a stub consuming a cache with the given number of entries.
.macro DEFINE_INTERFACE_DISPATCH_STUB entries

LEAF_ENTRY RhpInterfaceDispatch\entries, _TEXT

        // r10 currently contains the indirection cell address.
        // load r11 to point to the cache block.
        mov     r11, [r10 + OFFSETOF__InterfaceDispatchCell__m_pCache]

        // Load the EEType from the object instance in rdi.
        mov     rax, [rdi]

        CurrentOffset = OFFSETOF__InterfaceDispatchCache__m_rgEntries

        // For each entry in the cache, see if its EEType type matches the EEType in rax.
        // If so, call the second cache entry.  If not, skip the InterfaceDispatchCacheEntry.
        .rept \entries
            cmp     rax, [r11 + CurrentOffset]
            jne     0f
            jmp     [r11 + CurrentOffset + 8]
        0:
            CurrentOffset = CurrentOffset + 16
        .endr

        // r10 still contains the the indirection cell address.

        jmp     C_FUNC(RhpInterfaceDispatchSlow)
LEAF_END RhpInterfaceDispatch\entries, _TEXT

.endm // DEFINE_INTERFACE_DISPATCH_STUB



// Define all the stub routines we currently need.
//
// The mrt100dbi requires these be exported to identify mrt100 code that dispatches back into managed.
// If you change or add any new dispatch stubs, please also change slr.def and dbi\process.cpp CordbProcess::GetExportStepInfo
//
DEFINE_INTERFACE_DISPATCH_STUB 1
DEFINE_INTERFACE_DISPATCH_STUB 2
DEFINE_INTERFACE_DISPATCH_STUB 4
DEFINE_INTERFACE_DISPATCH_STUB 8
DEFINE_INTERFACE_DISPATCH_STUB 16
DEFINE_INTERFACE_DISPATCH_STUB 32
DEFINE_INTERFACE_DISPATCH_STUB 64

// Stub dispatch routine for dispatch to a vtable slot
LEAF_ENTRY RhpVTableOffsetDispatch, _TEXT
        // UNIXTODO: Implement this function
        int 3
LEAF_END RhpVTableOffsetDispatch, _TEXT

// Initial dispatch on an interface when we don't have a cache yet.
LEAF_ENTRY RhpInitialInterfaceDispatch, _TEXT
ALTERNATE_ENTRY RhpInitialDynamicInterfaceDispatch

        // Just tail call to the cache miss helper.
        jmp     C_FUNC(RhpInterfaceDispatchSlow)

LEAF_END RhpInitialInterfaceDispatch, _TEXT

// Cache miss case, call the runtime to resolve the target and update the cache.
// Use universal transition helper to allow an exception to flow out of resolution
LEAF_ENTRY RhpInterfaceDispatchSlow, _TEXT
        // r10 contains indirection cell address, move to r11 where it will be passed by
        // the universal transition thunk as an argument to RhpCidResolve
        mov r11, r10
        lea r10, [rip + C_FUNC(RhpCidResolve)]
        jmp C_FUNC(RhpUniversalTransition_DebugStepTailCall)

LEAF_END RhpInterfaceDispatchSlow, _TEXT
