// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

.syntax unified
.thumb

#include <AsmOffsets.inc>         // generated by the build from AsmOffsets.cpp
#include <unixasmmacros.inc>

#define POINTER_SIZE 4

//
// RhCommonStub
//
NESTED_ENTRY RhCommonStub, _TEXT, NoHandler
          // Custom calling convention:
          //      red zone has pointer to the current thunk's data block (data contains 2 pointer values: context + target pointers)
          //      Copy red zone value into r12 so that the PROLOG_PUSH doesn't destroy it
          ldr          r12, [sp, #-4]
          PROLOG_PUSH  "{r0-r4, lr}"
          PROLOG_VPUSH {d0-d7}        // Capture the floating point argument registers

          mov          r4, r12

          INLINE_GET_TLS_VAR  tls_thunkData

          // r0 = base address of TLS data
          // r4 = address of context cell in thunk's data

          ldr          r12, [r4]
          str          r12, [r0]

          // Now load the target address and jump to it.
          ldr          r12, [r4, #POINTER_SIZE]
          EPILOG_VPOP  {d0-d7}
          EPILOG_POP   "{r0-r4, lr}"
          bx           r12

NESTED_END RhCommonStub, _TEXT

//
// IntPtr RhGetCommonStubAddress()
//
LEAF_ENTRY RhGetCommonStubAddress, _TEXT
          ldr           r0, =C_FUNC(RhCommonStub)
          bx            lr
LEAF_END RhGetCommonStubAddress, _TEXT

//
// IntPtr RhGetCurrentThunkContext()
//
LEAF_ENTRY RhGetCurrentThunkContext, _TEXT

          PROLOG_PUSH   "{r12, lr}"

          INLINE_GET_TLS_VAR  tls_thunkData

          ldr           r0, [r0]
          EPILOG_POP    "{r12, pc}"
LEAF_END RhGetCurrentThunkContext, _TEXT
