<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

OCIO v2 WORKING GROUP MEETING  
2020-01-23  
via Zoom  

Participants:
  * Dennis Adams (Sony)
  * Mark Boorer (ILM)
  * Michael Dolan (Epic)
  * Joseph Goldstone (ARRI)
  * Bernard Lefebvre (Autodesk)
  * Thomas Mansencal (Weta)
  * Daniel Mulligan (Method)
  * Matthias Scharfenberg (ILM)
  * Troy Sobotka
  * Kevin Wheatley (Framestore)

Hosts:
  * Doug Walker (Autodesk)
  * Patrick Hodoul (Autodesk)

Recording on Zoom cloud:  
<https://autodesk.zoom.us/rec/share/wfp5D3F7iEg6MbylOzyTB6y4STopy75IgZ_-F8zSJwUtID0rugAayyk9xvy9RY91.eERi3h16sgzuNC4J>


**QUESTIONS ON RECENT MERGES**

   - Mark: Is ociocheck crashing for anyone?
   - Doug: We will look into it.
   - *UPDATE:* We tested this and it is working.  We found a case where illegal
(too long) spi1d LUTs caused a crash in master.  These LUTs were not flagged as
being illegal in OCIO v1 and would have had incorrect results.

**STRING UTILS**

   - Patrick: Wrote some pytstring equivalents to work around dependencies in
pystring.  They are used by both core and apps.  Proposal is they would go under
the utils directory.  Current contents of utils would go to ocioutils.
   - Mark: It would be kept static?  Patrick: Yes.
   - Michael, Mark: Sounds great.
   - Troy: Does that address the locale issue?  Patrick: No.

**ACES 1.2 COMMON LUT FORMAT V3 SUPPORT**

   - Doug:  There is an update to CLF as part of the ACES 1.2 work.  We are
updating OCIO support of CLF to this latest version.
   - Doug:  I'm chairing the CLF Implementation working group.  The group needs
test CLF files.  I'm making a spreadsheet of what's in OCIO.  We will make this
available to the ACES VWG.
   - Doug: We want to validate some parsing issues.  We've been following
Kevin's advice to be strict when writing but permissive when reading.  There are
some cases where we may want to allow slight syntax variations (e.g. changes in
case).  We are planning to handle these by logging a warning rather than
throwing an exception.  Is it ok?
   - Thomas: Yes, allow it but let people know it is not correct so they can
take action.
   - Mark: But we don't have a proper logging system in OCIO, right?  (Just
writes to stderr?)
   - Patrick: Upgrades were made awhile ago, applications can register to
customize the logging.
   - Mark: Logging a warning sounds good.
   - Doug:  We're adding a new app called ociochecklut.  It will parse any OCIO
LUT format and print errors or warnings and allow you to evaluate RGB values
from the command line.
   - Mark:  Does it handle data types?  Doug: We are calling the float applyRGB
methods, which normalizes the values.
   - Mark:  That sounds cool.
   - Joseph:  If you wanted to evaluate a lot of points, could you send them via
standard input?
   - Patrick:  You have ocioconvert, although that's images.
   - Doug:  We've done a starting point and people could add features like that.
   - Matthias:  Would be nice to check some standard points (black, mid grey,
white, RGB, ...).
   - *UPDATE:* We have added a set of test points like that, via the -t flag.
   - Kevin:  One of the ICC profile libraries has a calculator tool.  Troy:
That's in Argyle.

**DISPLAY REFERENCE SPACE**

   - Doug made a proposal to introduce the option to have a display reference
space.  This will better align OCIO with various standards such as HDR video
(ITU-R BT.2390/2100) and ACES, and make it easier to convert between display
color spaces.
   - Dennis:  Sounds good, Sony's HDR color space approach would also fit nicely
with this.
   - Mark:  Our ILM color spaces already also do this.  But when we get LUTs
from clients, 99% of the time they go directly to a display color space.  We
make variations on these by appending display to display conversions.  It's
possible to design a config so that the view transform could be optimized out
when needing to convert between displays.
   - Matthias:  But it's not broken out as separate displays.  If a client gives
you a LUT that goes to a display, how would you get to the display reference?
   - Doug:  The idea is that both the new and original methods would be
supported.  The industry has grown up around tools that only proovide "one slot"
and so there has been an imperitive to combine them.
   - Kevin:  We do something similar but we use the looks to hide the mapping
between one provided LUT and another.  I've been thinking about similar concepts
because it has been a mess to implement grades, OCIO doesn't have anything so
far to implement image states.  The looks have not really solved the problem. 
It can be unwieldy for users who just want to convert from one display to
another.
   - Doug:  The hope is that this will allow people to write clearer configs
that are easier to understand.
   - Troy:  Can you query the colorimetry and transfer function of the displays?
 Because this is a huge deal for authorship.
   - Doug:  There would be a new section in the config for display color spaces
that uses basically the same machinery as the existing color spaces except would
go to/from the display reference space.
   - Dennis:  I'd like to suggest you add a "VPID" (Video Payload ID) field for
display color spaces, so that applications can use it to send to the monitor to
enable it to auto-switch to the correct input color space and EOTF. For example,
Sony BVM-X310 supports this payload.
   - Thomas:  We are using EDID info from the monitor to know what display to
select.
   - There was more discussion/chat about VPID vs VCGT vs EDID.  These are all
different things, VPID is kind of the opposite of an EDID.  We will look into
it.
   - Troy:  It would be nice to be able to handle data as well.  So for example
alpha 0.5 could be at middle gray.
   - Doug:  Agreed, right now visualizing data is a problem since as soon as you
set isdata, it turns off transforms for that color space.  Coincidentally, the
response of most monitors works quite well for alpha/mattes, so we've been able
to get away with it by just turning color management off.  But as HDR monitors
arrive, that isn't the case anymore.
   - Troy:  I'd like the display color spaces to be mandated.  It would simplify
working with multiple configs.
   - Doug:  My opinion is that we should start with it being optional for now. 
We want to facilitate the transition from v1 to v2.
   - Mark:  OCIO isn't intended to handle converting between configs.  As the
config author, it is your job to handle any color spaces that your users need.
   - Troy:  The display colorimetry is very important, if an application wants
to use OCIO has a CMS, it cannot today.  This proposal could fix that.
   - Mark:  OCIO isn't a real CMS, it's not designed for that.
   - Troy:  You can't integrate with a CMS yet, so it's a moot point.
   - Mark:  Chromaticities could help.  But agree to keep it optional for now.
   - Doug explained the ViewTransform section of the config and how color spaces
would be converted using the view transforms.
   - Kevin:  You might need to do some environmental adjustment (e.g. cinema vs.
tv viewing environments).  Is one display reference space enough?
   - Doug:  It's a good point.  OCIO already has this problem to some extent
with the existing reference space.  Having one reference on each side simplifies
some things a lot.
   - Mark:  Awhile ago I made a proposal to remove to_ref/from_ref and just have
a to and from and name the color space you want to go between.  Rather than
being a graph that always connects through a single reference you could make a
graph that connects any color spaces together.  It's good if you have a LUT that
goes between two edges of the graph but you don't want to go through the middle.
   - Michael:  What happens when you want to convert between two color spaces
that don't have matching to/from references, is it an errror?
   - Mark:  There would need to be a route for it to work.  It would walk the
graph and try to find a path.  You could add edges to that graph to short cut. 
It could also be confusing.
   - Joseph:  Is the short cut required to do the same thing the long way around
would do?  
   - Mark: You could do whatever you like, it's your config.  But ideally you
would do the same thing.  I know Sony does some stuff in their configs with
named looks and transforms to short cut through the graph as well.
   - Thomas:  I like the generic from/to edges.
   - Troy:  Is it possible to include a look on the display side as well?
   - Doug:  Looks would be set up in the display/view section of the config the
same as today.  In the case where the view transform starts in the display
reference, it would be applied in the display reference.
   - Michael:  What happens if you need to convert from a color space to a
display color space and there may not be view transform defined?
   - Doug:  Good question, that brings us to the getProcessor API.  There are 4
cases that ColorSpaceTransform needs to support for the 4 combinations of color
space and display color space.  The interesting ones are the ones that convert
from the scene side to the display side.  My proposal is that we would like that
case to succeed rather than throw, so we could use the first view transform as
the default.  The DisplayTransform class would be the preferred way to do that
conversion and that would allow choosing a specific view transform.
   - Troy:  Could you define it via transfer function and chromaticities, in
order to get it to succeed?
   - Mark:  But the differences are not simply that, there is creative intent as
well.
   - Kevin:  We would like to use a context to filter out which view transforms
the graph search would find.
   - Mark:  I don't like exposing a view transform to the getProcessor call.  It
has implications for apps.  It will be confusing for some people.
   - Kevin:  We currently have to use context because some shows have creative
LUTs almost per shot.  It might help with that.
   - Matthias:  Would it be possible to define a null view transform.  For
example for texture conversion.
   - Doug:  Yes, that's exactly one of the use cases I was thinking of too. 
That could be the default view transform in many configs.
   - Thomas:  You still need a fall back for when you don't have a context.
   - Mark:  What's the primary motivator for the change?  Is it to make it
easier for DCC authors to do display changes, or is it to allow people to write
clearer configs?
   - Doug:  It solves several problems, it provides a conceptually cleaner way
of representing things.  Incorporating the view into the display leads to lots
of variants on a display (e.g. Rec709_showLUT1, Rec709_nograde, etc.).
   - Mark:  We already get that for free based on the way we build the configs. 
I prefer the idea of allowing transforms between arbitrary color spaces.  You
don't run into the ambiguity of not knowing what view transform to use.  You
don't need to introduce a new structure and concept into the library.
   - Troy:  Doug's proposal works better for DCCs.
   - Thomas:  Could you create an issue on GitHub for this?
   - Doug:  Yes, definitely.
   - *Update:*  Done:  Issue #926
   - Matthias:  Will there be recommendations for how to build view transforms? 
Currently LUTs output to display space which tends to be perceptually uniform
but the view transforms will have to get back to display-linear space.  May want
to warn people about that.  For example, a gamma encoding could be put after the
LUT.
   - Doug:  Good point.
   - Doug:  Going back to Mark's point, we should think more about introducing a
transform that could connect arbitrary color spaces.  It would also solve
Kevin's viewing environment point if the way to solve that is to have multiple
reference spaces.  My initial concern is that it is less clear since there are
not explicit scene and display-referred reference spaces.  Also the routing may
get complex.  Our SynColor CMS actually allows arbitrary connections between
color spaces or as many reference spaces as you want.  So we have that type of
routing algorithm, but it is complex.  One of the motivations for this proposal
is that it is simpler.
   - Michael:  One of the nice things about OCIO's current design is its
simplicity, that every color space is connected to every other one through a
single reference space.  If that is no longer the case, and if it is not
apparent in the config, we need to introduce error handling.  There's a level of
complexity that needs to be handled smoothly.
   - Doug:  OCIO v1 does have an issue today where getProcessor will throw if
the conversion requires inverting a Lut3D.  With the proposal being presented,
all conversions would succeed.
   - Patrick:  We need to consider the complexity on both sides, both the config
and the code that does the routing.  A DCC does not want to have a case where a
conversion may not be performed due to a routing issue.  Sanity check could look
at this.
   - Matthias:  I like the idea of being able to look at the config and
immediately know what it does.  If we allow arbitrary connections, it becomes
impossible without other tools.
   - Kevin:  We would need a conversion from a config to the dot graphviz
format.  
<https://www.graphviz.org/doc/info/lang.html>
   - Doug covered the getDisplay/getView API.  Would be largely unchanged but
may want to allow better filtering.
   - Kevin:  Would that apply to Looks?  That is, for the Look section of the
config, how would display-referred looks be distinguished from scene-referred
ones?  For example for the OCIOLookTransform tool?  Would like the approach to
be generalized so that it applies whatever type of object you are looking at.
   - Mark:  Do many others use the Looks?  We don't since the DCC support is
rubbish, we use contexts.
   - Troy:  I use them a lot.
   - Michael:  They get used a lot for shot grades at Sony and some other
places.
   - Doug:  We will think about filtering Looks as well as Views.  The Look
process space may help in that regard.
   - Matthias:  With the inverse LUT solver, OCIO would be able to calculate the
inverse.  In some cases it would be useful to be able to restrict certain
directions from artists.
   - Doug:  Yes, that came up before.  We will look into that and make a
proposal.
   - Thomas:  What about moving the OCIO Configs repo issue, could we bump that
with the Academy?  It's hard to maintain this way.
   - Michael:  Yes, let's discuss with Sean at the next TSC mtg.
   - Dennis:  It would be nice to get an Outlook calendar invite for the
meetings.
   - Doug:  I'll try to do that next time.
   - Troy:  This is a great proposal.  Would also be wonderful to have display
chromaticities and transfer function.  The OCIO website describes it as a CMS
but it is not without the ability to better handle displays.  E.g., sometimes
need to composite in display linear.
   - Doug:  We will loop back to the chromaticity feature at a future meeting. 
You are not the only one that has requested that.
   - Troy:  The display stuff is necessary to avoid problems with HDR monitors.
   - Doug:  Yes, agreed, e.g. putting SDR stuff up on HDR monitors in an SDR
luminance range.
   - Troy:  Data is also important.
   - Doug:  Yes, we have view transforms for data in SynColor.  We allow things
to be flagged as data but do allow processing if needed.
   - Troy:  Glad to see this happening finally.
