# Preparing the Sources


Additional to the software mentioned in README you'll need the
following programs installed on your system:

  cmake >= 2.8

Getting started
---------------

If these preliminaries are met, you should run

  dunecontrol all

which will find all installed dune modules as well as all dune modules
(not installed) which sources reside in a subdirectory of the current
directory. Note that if dune is not installed properly you will either
have to add the directory where the dunecontrol script resides (probably
./dune-common/bin) to your path or specify the relative path of the script.

On your project and all uninstalled DUNE source modules found the script
will then calls the GNU autoconf/automake to create a ./configure-script
and the Makefiles. Afterwards that configure script will be called and the
modules will be build using make all

Most probably you'll have to provide additional information to dunecontrol
(e. g. compilers, configure options) and/or make options.

The most convenient way is to use options files in this case. The files
defining three variables:

AUTOGEN_FLAGS    flags passed to autogen
CONFIGURE_FLAGS  flags passed to configure
MAKE_FLAGS       flags passed to make

An example options file might look like this:

#use this options to autogen, configure and make if no other options are given
AUTOGEN_FLAGS="--ac=2.50 --ac=1.8" #Forces automake 2,50 and autoconf 1.8
CONFIGURE_FLAGS="CXX=g++-3.4 --prefix=/install/path" #force g++-3.4 as compiler
MAKE_FLAGS=install #Per default run make install instead of simply make

If you save this information into example.opts you can path the opts file to
dunecontrol via the --opts option, e. g.

  dunecontrol --opts=example.opts all

To get a full list of available configure flags just run

  dunecontrol configure --help

after running at least
  dunecontrol autogen

More info
---------

See

     dunecontrol --help

for further options.


The full build-system is described in the dune-common/doc/buildsystem (SVN version) or under share/doc/dune-common/buildsystem if you installed DUNE!

$Id: duneproject 5489 2009-03-25 11:19:24Z sander $
