// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/breadcrumbs/core/application_breadcrumbs_not_user_action.inc"

#include <string>
#include <vector>

#include "testing/platform_test.h"

// Tests that kNotUserTriggeredActions array was correctly generated by
// generate_not_user_triggered_actions.py
using ApplicationBreadcrumbsNotUserActions = PlatformTest;

// Tests that kNotUserTriggeredActions array is not too big.
TEST_F(ApplicationBreadcrumbsNotUserActions, Size) {
  // At the time of writing this code there were 44 actions. It's better to fail
  // the test if this list grows to 200 to verify that list is not unreasonably
  // large.
  EXPECT_LT(
      std::end(kNotUserTriggeredActions) - std::begin(kNotUserTriggeredActions),
      200);
}

// Tests that each string in kNotUserTriggeredActions array is not too long but
// longer than 0.
TEST_F(ApplicationBreadcrumbsNotUserActions, StringLength) {
  for (const char* action : kNotUserTriggeredActions) {
    EXPECT_GT(strlen(action), 0U);
    // At the time of writing this test the longest action had 54 characters.
    // Action names longer than 100 characters seem unnecessary long or there
    // might be a bug in generate_not_user_triggered_actions.py script.
    EXPECT_LT(strlen(action), 100U) << " for " << action;
  }
}

// Tests that kNotUserTriggeredActions array is sorted to make the binary search
// possible.
TEST_F(ApplicationBreadcrumbsNotUserActions, Sorting) {
  // Use vector of strings, so std::is_sorted can compare strings, not pointers.
  std::vector<std::string> actions(std::begin(kNotUserTriggeredActions),
                                   std::end(kNotUserTriggeredActions));
  EXPECT_TRUE(std::is_sorted(actions.begin(), actions.end()));
}
