% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCWL.R
\name{runCWLBatch}
\alias{runCWLBatch}
\title{run CWL with batchtools}
\usage{
runCWLBatch(
  cwl,
  outdir = getwd(),
  inputList,
  paramList = list(),
  BPPARAM = BatchtoolsParam(workers = lengths(inputList)[1]),
  ...
)
}
\arguments{
\item{cwl}{A `cwlProcess` or `cwlWorkflow` object.}

\item{outdir}{Directory to output results}

\item{inputList}{An input list to run in parallel. The list names
must be in the inputs of cwl. Jobs will be submitted in
parallel for each element in the list. The output directory of
each job will be made using the name of each element under the
`outdir`.}

\item{paramList}{A parameter list for the cwl. The list names must
be in the inputs of cwl.}

\item{BPPARAM}{The options for `BiocParallelParam`.}

\item{...}{The options from runCWL.}
}
\value{
Results from computing nodes and logs from cwltool.
}
\description{
run CWL with batchtools
}
