#! /bin/sh

# Test representation of a table with URLs

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
SRC_DB_DIR=db
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

TMP_TEST_DB=samples.db
TMP_DB_FILE=${TMP_DB_DIR}/samples.db
TMP_DB_META=${TMP_DB_DIR}/restful.db
TMP_DB_FILE_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/${TMP_TEST_DB}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin
mkdir ${TMP_DIR}/tests

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tests/inputs ${TMP_DIR}/tests

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

sqlite3 ${TMP_DB_FILE} < tests/inputs/samples-r92.sql
sqlite3 ${TMP_DB_FILE} <<END
    create view sample_experiment_epma_epma_mineral as
    select SolsaID, measurement_date, analytical_conditions, formula_struct,
           experiment_epma.uuid as experiment_epma_uuid,
           epma_mineral.uuid as epma_mineral_uuid
        from sample join experiment_epma on sample.id = sample_id
                    join epma_mineral on experiment_id = experiment_epma.id;
END

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} < tests/inputs/samples-metadata-r92.sql
sqlite3 ${TMP_DB_META} "update description set dbname = '${TMP_DB_FILE_ABS}'"

export REQUEST_URI='/~saulius/restful/website/samples.db/sample_experiment_epma_epma_mineral'
export HTTP_HOST=test.domain.net
export REQUEST_METHOD=post
export QUERY_STRING=""
export REMOTE_USER=tester

${INPUT_SCRIPT} \
    column%3Asample_experiment_epma_epma_mineral%3A0.SolsaID=VU-TEST-0001 \
    column%3Asample_experiment_epma_epma_mineral%3A0.analytical_conditions=dark \
    column%3Asample_experiment_epma_epma_mineral%3A0.experiment_epma_uuid=aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa \
    column%3Asample_experiment_epma_epma_mineral%3A0.epma_mineral_uuid=aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaab \
    Save=Save

sqlite3 ${TMP_DB_FILE} "select * from sample"
sqlite3 ${TMP_DB_FILE} "select * from experiment_epma"
sqlite3 ${TMP_DB_FILE} "select * from epma_mineral"
sqlite3 ${TMP_DB_FILE} "select * from sample_experiment_epma_epma_mineral"

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
