/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __VAR_H_INCLUDED
#define __VAR_H_INCLUDED

#include "segment.h"

struct var {
		/* PC Intern, pp. 107 */
		/* PC Profibuch, pp. 41 */
		/* PC Hardware, pp. 1028 */
		unsigned char reserved0[0x10];

/* 40:0010 */	unsigned short sys_conf;	/* See bios/var.h */

		unsigned char reserved1[0x49 - 0x12];

/* 40:0049 */	unsigned char vid_mode;		/* mode */
/* 40:004a */	unsigned short vid_columns;	/* columns */
/* 40:004c */	unsigned short vid_pagesize;	/* size of video page */
/* 40:004e */	unsigned short vid_pageoff;	/* offset of curr. page */
/* 40:0050 */	struct {
			unsigned char x;
			unsigned char y;
		} curspos[8];		 	/* cursor positions */
/* 40:0060 */	unsigned char curs_end;		/* cursor end line */
/* 40:0061 */	unsigned char curs_start;	/* cursor start line */
/* 40:0062 */	unsigned char curr_page;	/* current page */
/* 40:0063 */	unsigned char vid_io[2];	/* controller IO address */
/* 40:0065 */	unsigned char vid_mode_r;	/* copy of mode register */
/* 40:0066 */	unsigned char vid_col_r;	/* copy of color register */

		unsigned char reserved2[0x84 - 0x67];

/* 40:0084 */	unsigned char vid_rows;		/* rows */
/* 40:0085 */	unsigned char vid_cheight[2];	/* character height */
/* 40:0087 */	unsigned char video_ctl;
/* 40:0088 */	unsigned char switches;
/* 40:0089 */	unsigned char modeset_ctl;

		unsigned char reserved3[0xb9 - 0x8a];

#if 0	/* FIXME VOSSI */
/* 40:00b9 */	unsigned char vbe_flag;
/* 40:00ba */	unsigned char vbe_mode;
#else
/* 40:00ba */	unsigned char vbe_mode[2];
#endif
} PACKED;

#define VAR_SEG	0x0040
#define VAR	((struct var *) 0)

#define var_put(var, value) \
	if (sizeof(VAR->var) == 1) { \
		put_byte(VAR_SEG, (unsigned char *) &VAR->var, (unsigned char) (value)); \
	} else if (sizeof(VAR->var) == 2) { \
		put_word(VAR_SEG, (unsigned short *) &VAR->var, (unsigned short) (value)); \
	} else { \
		assert(0); \
	}

#define var_get(var) \
	( \
		(sizeof(VAR->var) == 1) ? \
			get_byte(VAR_SEG, (unsigned char *) &VAR->var) \
		: (sizeof(VAR->var) == 2) ? \
			get_word(VAR_SEG, (unsigned short *) &VAR->var) \
		: \
			-1 \
	)

#endif /* __VAR_H_INCLUDED */
