/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.LocatorHandle;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class FontSizeHandle
extends LocatorHandle {
    public FontSizeHandle(Figure figure, Locator locator) {
        super(figure, locator);
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.setUndoActivity(this.createUndoActivity(drawingView));
        this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.owner()));
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        TextFigure textFigure = (TextFigure)this.owner();
        UndoActivity undoActivity = (UndoActivity)this.getUndoActivity();
        int n5 = undoActivity.getFont().getSize() + n2 - n4;
        textFigure.setFont(new Font(undoActivity.getFont().getName(), undoActivity.getFont().getStyle(), n5));
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        TextFigure textFigure = (TextFigure)this.owner();
        UndoActivity undoActivity = (UndoActivity)this.getUndoActivity();
        if (textFigure.getFont().getSize() == undoActivity.getOldFontSize()) {
            this.setUndoActivity(null);
        } else {
            undoActivity.setFont(textFigure.getFont());
        }
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.yellow);
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected Undoable createUndoActivity(DrawingView drawingView) {
        TextFigure textFigure = (TextFigure)this.owner();
        return new UndoActivity(drawingView, textFigure.getFont());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Font myFont;
        private int myOldFontSize;

        public UndoActivity(DrawingView drawingView, Font font) {
            super(drawingView);
            this.setFont(font);
            this.setOldFontSize(this.getFont().getSize());
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.swapFont();
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            this.swapFont();
            return true;
        }

        protected void swapFont() {
            this.setOldFontSize(this.replaceFontSize());
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                ((TextFigure)figureEnumeration.nextFigure()).setFont(this.getFont());
            }
        }

        private int replaceFontSize() {
            int n = this.getFont().getSize();
            this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), this.getOldFontSize()));
            return n;
        }

        protected void setFont(Font font) {
            this.myFont = font;
        }

        public Font getFont() {
            return this.myFont;
        }

        protected void setOldFontSize(int n) {
            this.myOldFontSize = n;
        }

        public int getOldFontSize() {
            return this.myOldFontSize;
        }
    }
}

