"use strict";

var helpers = require("../../helpers/helpers");

exports["Pacific/Fiji"] = {

	"guess:by:offset" : helpers.makeTestGuess("Pacific/Fiji", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("Pacific/Fiji", { abbr: true }),

	"1998" : helpers.makeTestYear("Pacific/Fiji", [
		["1998-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["1998-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"1999" : helpers.makeTestYear("Pacific/Fiji", [
		["1999-02-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["1999-02-27T14:00:00+00:00", "02:00:00", "+12", -720],
		["1999-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["1999-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2000" : helpers.makeTestYear("Pacific/Fiji", [
		["2000-02-26T13:59:59+00:00", "02:59:59", "+13", -780],
		["2000-02-26T14:00:00+00:00", "02:00:00", "+12", -720]
	]),

	"2009" : helpers.makeTestYear("Pacific/Fiji", [
		["2009-11-28T13:59:59+00:00", "01:59:59", "+12", -720],
		["2009-11-28T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2010" : helpers.makeTestYear("Pacific/Fiji", [
		["2010-03-27T13:59:59+00:00", "02:59:59", "+13", -780],
		["2010-03-27T14:00:00+00:00", "02:00:00", "+12", -720],
		["2010-10-23T13:59:59+00:00", "01:59:59", "+12", -720],
		["2010-10-23T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2011" : helpers.makeTestYear("Pacific/Fiji", [
		["2011-03-05T13:59:59+00:00", "02:59:59", "+13", -780],
		["2011-03-05T14:00:00+00:00", "02:00:00", "+12", -720],
		["2011-10-22T13:59:59+00:00", "01:59:59", "+12", -720],
		["2011-10-22T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2012" : helpers.makeTestYear("Pacific/Fiji", [
		["2012-01-21T13:59:59+00:00", "02:59:59", "+13", -780],
		["2012-01-21T14:00:00+00:00", "02:00:00", "+12", -720],
		["2012-10-20T13:59:59+00:00", "01:59:59", "+12", -720],
		["2012-10-20T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2013" : helpers.makeTestYear("Pacific/Fiji", [
		["2013-01-19T13:59:59+00:00", "02:59:59", "+13", -780],
		["2013-01-19T14:00:00+00:00", "02:00:00", "+12", -720],
		["2013-10-26T13:59:59+00:00", "01:59:59", "+12", -720],
		["2013-10-26T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2014" : helpers.makeTestYear("Pacific/Fiji", [
		["2014-01-18T12:59:59+00:00", "01:59:59", "+13", -780],
		["2014-01-18T13:00:00+00:00", "01:00:00", "+12", -720],
		["2014-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2014-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2015" : helpers.makeTestYear("Pacific/Fiji", [
		["2015-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2015-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2015-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2015-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2016" : helpers.makeTestYear("Pacific/Fiji", [
		["2016-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2016-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2016-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2016-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2017" : helpers.makeTestYear("Pacific/Fiji", [
		["2017-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2017-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2017-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2017-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2018" : helpers.makeTestYear("Pacific/Fiji", [
		["2018-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2018-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2018-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2018-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2019" : helpers.makeTestYear("Pacific/Fiji", [
		["2019-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2019-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2019-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2019-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2020" : helpers.makeTestYear("Pacific/Fiji", [
		["2020-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2020-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2020-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2020-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2021" : helpers.makeTestYear("Pacific/Fiji", [
		["2021-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2021-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2021-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2021-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2022" : helpers.makeTestYear("Pacific/Fiji", [
		["2022-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2022-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2022-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2022-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2023" : helpers.makeTestYear("Pacific/Fiji", [
		["2023-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2023-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2023-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2023-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2024" : helpers.makeTestYear("Pacific/Fiji", [
		["2024-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2024-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2024-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2024-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2025" : helpers.makeTestYear("Pacific/Fiji", [
		["2025-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2025-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2025-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2025-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2026" : helpers.makeTestYear("Pacific/Fiji", [
		["2026-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2026-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2026-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2026-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2027" : helpers.makeTestYear("Pacific/Fiji", [
		["2027-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2027-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2027-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2027-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2028" : helpers.makeTestYear("Pacific/Fiji", [
		["2028-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2028-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2028-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2028-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2029" : helpers.makeTestYear("Pacific/Fiji", [
		["2029-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2029-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2029-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2029-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2030" : helpers.makeTestYear("Pacific/Fiji", [
		["2030-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2030-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2030-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2030-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2031" : helpers.makeTestYear("Pacific/Fiji", [
		["2031-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2031-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2031-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2031-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2032" : helpers.makeTestYear("Pacific/Fiji", [
		["2032-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2032-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2032-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2032-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2033" : helpers.makeTestYear("Pacific/Fiji", [
		["2033-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2033-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2033-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2033-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2034" : helpers.makeTestYear("Pacific/Fiji", [
		["2034-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2034-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2034-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2034-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2035" : helpers.makeTestYear("Pacific/Fiji", [
		["2035-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2035-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2035-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2035-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2036" : helpers.makeTestYear("Pacific/Fiji", [
		["2036-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2036-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2036-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2036-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2037" : helpers.makeTestYear("Pacific/Fiji", [
		["2037-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2037-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2037-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2037-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2038" : helpers.makeTestYear("Pacific/Fiji", [
		["2038-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2038-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2038-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2038-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2039" : helpers.makeTestYear("Pacific/Fiji", [
		["2039-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2039-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2039-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2039-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2040" : helpers.makeTestYear("Pacific/Fiji", [
		["2040-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2040-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2040-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2040-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2041" : helpers.makeTestYear("Pacific/Fiji", [
		["2041-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2041-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2041-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2041-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2042" : helpers.makeTestYear("Pacific/Fiji", [
		["2042-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2042-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2042-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2042-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2043" : helpers.makeTestYear("Pacific/Fiji", [
		["2043-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2043-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2043-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2043-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2044" : helpers.makeTestYear("Pacific/Fiji", [
		["2044-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2044-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2044-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2044-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2045" : helpers.makeTestYear("Pacific/Fiji", [
		["2045-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2045-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2045-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2045-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2046" : helpers.makeTestYear("Pacific/Fiji", [
		["2046-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2046-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2046-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2046-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2047" : helpers.makeTestYear("Pacific/Fiji", [
		["2047-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2047-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2047-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2047-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2048" : helpers.makeTestYear("Pacific/Fiji", [
		["2048-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2048-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2048-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2048-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2049" : helpers.makeTestYear("Pacific/Fiji", [
		["2049-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2049-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2049-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2049-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2050" : helpers.makeTestYear("Pacific/Fiji", [
		["2050-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2050-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2050-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2050-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2051" : helpers.makeTestYear("Pacific/Fiji", [
		["2051-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2051-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2051-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2051-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2052" : helpers.makeTestYear("Pacific/Fiji", [
		["2052-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2052-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2052-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2052-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2053" : helpers.makeTestYear("Pacific/Fiji", [
		["2053-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2053-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2053-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2053-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2054" : helpers.makeTestYear("Pacific/Fiji", [
		["2054-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2054-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2054-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2054-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2055" : helpers.makeTestYear("Pacific/Fiji", [
		["2055-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2055-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2055-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2055-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2056" : helpers.makeTestYear("Pacific/Fiji", [
		["2056-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2056-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2056-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2056-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2057" : helpers.makeTestYear("Pacific/Fiji", [
		["2057-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2057-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2057-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2057-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2058" : helpers.makeTestYear("Pacific/Fiji", [
		["2058-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2058-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2058-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2058-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2059" : helpers.makeTestYear("Pacific/Fiji", [
		["2059-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2059-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2059-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2059-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2060" : helpers.makeTestYear("Pacific/Fiji", [
		["2060-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2060-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2060-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2060-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2061" : helpers.makeTestYear("Pacific/Fiji", [
		["2061-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2061-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2061-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2061-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2062" : helpers.makeTestYear("Pacific/Fiji", [
		["2062-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2062-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2062-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2062-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2063" : helpers.makeTestYear("Pacific/Fiji", [
		["2063-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2063-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2063-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2063-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2064" : helpers.makeTestYear("Pacific/Fiji", [
		["2064-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2064-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2064-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2064-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2065" : helpers.makeTestYear("Pacific/Fiji", [
		["2065-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2065-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2065-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2065-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2066" : helpers.makeTestYear("Pacific/Fiji", [
		["2066-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2066-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2066-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2066-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2067" : helpers.makeTestYear("Pacific/Fiji", [
		["2067-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2067-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2067-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2067-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2068" : helpers.makeTestYear("Pacific/Fiji", [
		["2068-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2068-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2068-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2068-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2069" : helpers.makeTestYear("Pacific/Fiji", [
		["2069-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2069-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2069-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2069-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2070" : helpers.makeTestYear("Pacific/Fiji", [
		["2070-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2070-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2070-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2070-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2071" : helpers.makeTestYear("Pacific/Fiji", [
		["2071-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2071-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2071-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2071-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2072" : helpers.makeTestYear("Pacific/Fiji", [
		["2072-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2072-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2072-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2072-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2073" : helpers.makeTestYear("Pacific/Fiji", [
		["2073-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2073-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2073-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2073-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2074" : helpers.makeTestYear("Pacific/Fiji", [
		["2074-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2074-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2074-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2074-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2075" : helpers.makeTestYear("Pacific/Fiji", [
		["2075-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2075-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2075-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2075-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2076" : helpers.makeTestYear("Pacific/Fiji", [
		["2076-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2076-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2076-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2076-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2077" : helpers.makeTestYear("Pacific/Fiji", [
		["2077-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2077-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2077-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2077-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2078" : helpers.makeTestYear("Pacific/Fiji", [
		["2078-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2078-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2078-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2078-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2079" : helpers.makeTestYear("Pacific/Fiji", [
		["2079-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2079-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2079-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2079-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2080" : helpers.makeTestYear("Pacific/Fiji", [
		["2080-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2080-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2080-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2080-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2081" : helpers.makeTestYear("Pacific/Fiji", [
		["2081-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2081-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2081-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2081-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2082" : helpers.makeTestYear("Pacific/Fiji", [
		["2082-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2082-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2082-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2082-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2083" : helpers.makeTestYear("Pacific/Fiji", [
		["2083-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2083-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2083-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2083-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2084" : helpers.makeTestYear("Pacific/Fiji", [
		["2084-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2084-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2084-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2084-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2085" : helpers.makeTestYear("Pacific/Fiji", [
		["2085-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2085-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2085-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2085-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2086" : helpers.makeTestYear("Pacific/Fiji", [
		["2086-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2086-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2086-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2086-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2087" : helpers.makeTestYear("Pacific/Fiji", [
		["2087-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2087-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2087-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2087-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2088" : helpers.makeTestYear("Pacific/Fiji", [
		["2088-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2088-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2088-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2088-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2089" : helpers.makeTestYear("Pacific/Fiji", [
		["2089-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2089-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2089-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2089-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2090" : helpers.makeTestYear("Pacific/Fiji", [
		["2090-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2090-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2090-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2090-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2091" : helpers.makeTestYear("Pacific/Fiji", [
		["2091-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2091-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2091-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2091-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2092" : helpers.makeTestYear("Pacific/Fiji", [
		["2092-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2092-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2092-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2092-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2093" : helpers.makeTestYear("Pacific/Fiji", [
		["2093-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2093-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2093-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2093-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2094" : helpers.makeTestYear("Pacific/Fiji", [
		["2094-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2094-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2094-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2094-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2095" : helpers.makeTestYear("Pacific/Fiji", [
		["2095-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2095-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2095-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2095-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2096" : helpers.makeTestYear("Pacific/Fiji", [
		["2096-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2096-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2096-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2096-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2097" : helpers.makeTestYear("Pacific/Fiji", [
		["2097-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2097-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2097-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2097-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2098" : helpers.makeTestYear("Pacific/Fiji", [
		["2098-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2098-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2098-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2098-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2099" : helpers.makeTestYear("Pacific/Fiji", [
		["2099-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2099-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2099-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2099-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2100" : helpers.makeTestYear("Pacific/Fiji", [
		["2100-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2100-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2100-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2100-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2101" : helpers.makeTestYear("Pacific/Fiji", [
		["2101-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2101-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2101-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2101-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2102" : helpers.makeTestYear("Pacific/Fiji", [
		["2102-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2102-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2102-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2102-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2103" : helpers.makeTestYear("Pacific/Fiji", [
		["2103-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2103-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2103-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2103-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2104" : helpers.makeTestYear("Pacific/Fiji", [
		["2104-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2104-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2104-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2104-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2105" : helpers.makeTestYear("Pacific/Fiji", [
		["2105-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2105-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2105-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2105-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2106" : helpers.makeTestYear("Pacific/Fiji", [
		["2106-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2106-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2106-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2106-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2107" : helpers.makeTestYear("Pacific/Fiji", [
		["2107-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2107-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2107-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2107-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2108" : helpers.makeTestYear("Pacific/Fiji", [
		["2108-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2108-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2108-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2108-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2109" : helpers.makeTestYear("Pacific/Fiji", [
		["2109-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2109-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2109-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2109-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2110" : helpers.makeTestYear("Pacific/Fiji", [
		["2110-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2110-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2110-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2110-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2111" : helpers.makeTestYear("Pacific/Fiji", [
		["2111-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2111-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2111-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2111-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2112" : helpers.makeTestYear("Pacific/Fiji", [
		["2112-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2112-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2112-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2112-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2113" : helpers.makeTestYear("Pacific/Fiji", [
		["2113-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2113-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2113-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2113-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2114" : helpers.makeTestYear("Pacific/Fiji", [
		["2114-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2114-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2114-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2114-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2115" : helpers.makeTestYear("Pacific/Fiji", [
		["2115-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2115-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2115-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2115-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2116" : helpers.makeTestYear("Pacific/Fiji", [
		["2116-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2116-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2116-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2116-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2117" : helpers.makeTestYear("Pacific/Fiji", [
		["2117-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2117-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2117-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2117-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2118" : helpers.makeTestYear("Pacific/Fiji", [
		["2118-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2118-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2118-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2118-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2119" : helpers.makeTestYear("Pacific/Fiji", [
		["2119-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2119-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2119-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2119-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2120" : helpers.makeTestYear("Pacific/Fiji", [
		["2120-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2120-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2120-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2120-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2121" : helpers.makeTestYear("Pacific/Fiji", [
		["2121-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2121-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2121-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2121-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2122" : helpers.makeTestYear("Pacific/Fiji", [
		["2122-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2122-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2122-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2122-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2123" : helpers.makeTestYear("Pacific/Fiji", [
		["2123-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2123-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2123-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2123-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2124" : helpers.makeTestYear("Pacific/Fiji", [
		["2124-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2124-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2124-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2124-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2125" : helpers.makeTestYear("Pacific/Fiji", [
		["2125-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2125-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2125-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2125-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2126" : helpers.makeTestYear("Pacific/Fiji", [
		["2126-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2126-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2126-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2126-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2127" : helpers.makeTestYear("Pacific/Fiji", [
		["2127-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2127-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2127-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2127-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2128" : helpers.makeTestYear("Pacific/Fiji", [
		["2128-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2128-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2128-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2128-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2129" : helpers.makeTestYear("Pacific/Fiji", [
		["2129-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2129-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2129-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2129-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2130" : helpers.makeTestYear("Pacific/Fiji", [
		["2130-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2130-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2130-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2130-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2131" : helpers.makeTestYear("Pacific/Fiji", [
		["2131-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2131-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2131-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2131-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2132" : helpers.makeTestYear("Pacific/Fiji", [
		["2132-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2132-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2132-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2132-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2133" : helpers.makeTestYear("Pacific/Fiji", [
		["2133-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2133-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2133-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2133-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2134" : helpers.makeTestYear("Pacific/Fiji", [
		["2134-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2134-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2134-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2134-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2135" : helpers.makeTestYear("Pacific/Fiji", [
		["2135-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2135-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2135-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2135-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2136" : helpers.makeTestYear("Pacific/Fiji", [
		["2136-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2136-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2136-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2136-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2137" : helpers.makeTestYear("Pacific/Fiji", [
		["2137-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2137-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2137-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2137-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2138" : helpers.makeTestYear("Pacific/Fiji", [
		["2138-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2138-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2138-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2138-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2139" : helpers.makeTestYear("Pacific/Fiji", [
		["2139-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2139-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2139-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2139-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2140" : helpers.makeTestYear("Pacific/Fiji", [
		["2140-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2140-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2140-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2140-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2141" : helpers.makeTestYear("Pacific/Fiji", [
		["2141-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2141-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2141-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2141-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2142" : helpers.makeTestYear("Pacific/Fiji", [
		["2142-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2142-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2142-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2142-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2143" : helpers.makeTestYear("Pacific/Fiji", [
		["2143-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2143-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2143-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2143-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2144" : helpers.makeTestYear("Pacific/Fiji", [
		["2144-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2144-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2144-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2144-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2145" : helpers.makeTestYear("Pacific/Fiji", [
		["2145-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2145-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2145-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2145-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2146" : helpers.makeTestYear("Pacific/Fiji", [
		["2146-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2146-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2146-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2146-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2147" : helpers.makeTestYear("Pacific/Fiji", [
		["2147-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2147-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2147-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2147-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2148" : helpers.makeTestYear("Pacific/Fiji", [
		["2148-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2148-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2148-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2148-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2149" : helpers.makeTestYear("Pacific/Fiji", [
		["2149-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2149-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2149-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2149-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2150" : helpers.makeTestYear("Pacific/Fiji", [
		["2150-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2150-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2150-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2150-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2151" : helpers.makeTestYear("Pacific/Fiji", [
		["2151-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2151-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2151-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2151-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2152" : helpers.makeTestYear("Pacific/Fiji", [
		["2152-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2152-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2152-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2152-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2153" : helpers.makeTestYear("Pacific/Fiji", [
		["2153-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2153-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2153-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2153-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2154" : helpers.makeTestYear("Pacific/Fiji", [
		["2154-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2154-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2154-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2154-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2155" : helpers.makeTestYear("Pacific/Fiji", [
		["2155-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2155-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2155-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2155-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2156" : helpers.makeTestYear("Pacific/Fiji", [
		["2156-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2156-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2156-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2156-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2157" : helpers.makeTestYear("Pacific/Fiji", [
		["2157-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2157-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2157-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2157-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2158" : helpers.makeTestYear("Pacific/Fiji", [
		["2158-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2158-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2158-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2158-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2159" : helpers.makeTestYear("Pacific/Fiji", [
		["2159-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2159-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2159-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2159-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2160" : helpers.makeTestYear("Pacific/Fiji", [
		["2160-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2160-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2160-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2160-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2161" : helpers.makeTestYear("Pacific/Fiji", [
		["2161-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2161-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2161-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2161-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2162" : helpers.makeTestYear("Pacific/Fiji", [
		["2162-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2162-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2162-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2162-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2163" : helpers.makeTestYear("Pacific/Fiji", [
		["2163-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2163-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2163-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2163-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2164" : helpers.makeTestYear("Pacific/Fiji", [
		["2164-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2164-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2164-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2164-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2165" : helpers.makeTestYear("Pacific/Fiji", [
		["2165-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2165-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2165-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2165-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2166" : helpers.makeTestYear("Pacific/Fiji", [
		["2166-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2166-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2166-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2166-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2167" : helpers.makeTestYear("Pacific/Fiji", [
		["2167-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2167-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2167-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2167-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2168" : helpers.makeTestYear("Pacific/Fiji", [
		["2168-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2168-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2168-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2168-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2169" : helpers.makeTestYear("Pacific/Fiji", [
		["2169-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2169-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2169-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2169-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2170" : helpers.makeTestYear("Pacific/Fiji", [
		["2170-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2170-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2170-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2170-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2171" : helpers.makeTestYear("Pacific/Fiji", [
		["2171-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2171-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2171-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2171-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2172" : helpers.makeTestYear("Pacific/Fiji", [
		["2172-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2172-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2172-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2172-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2173" : helpers.makeTestYear("Pacific/Fiji", [
		["2173-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2173-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2173-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2173-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2174" : helpers.makeTestYear("Pacific/Fiji", [
		["2174-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2174-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2174-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2174-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2175" : helpers.makeTestYear("Pacific/Fiji", [
		["2175-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2175-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2175-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2175-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2176" : helpers.makeTestYear("Pacific/Fiji", [
		["2176-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2176-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2176-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2176-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2177" : helpers.makeTestYear("Pacific/Fiji", [
		["2177-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2177-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2177-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2177-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2178" : helpers.makeTestYear("Pacific/Fiji", [
		["2178-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2178-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2178-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2178-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2179" : helpers.makeTestYear("Pacific/Fiji", [
		["2179-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2179-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2179-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2179-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2180" : helpers.makeTestYear("Pacific/Fiji", [
		["2180-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2180-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2180-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2180-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2181" : helpers.makeTestYear("Pacific/Fiji", [
		["2181-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2181-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2181-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2181-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2182" : helpers.makeTestYear("Pacific/Fiji", [
		["2182-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2182-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2182-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2182-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2183" : helpers.makeTestYear("Pacific/Fiji", [
		["2183-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2183-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2183-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2183-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2184" : helpers.makeTestYear("Pacific/Fiji", [
		["2184-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2184-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2184-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2184-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2185" : helpers.makeTestYear("Pacific/Fiji", [
		["2185-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2185-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2185-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2185-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2186" : helpers.makeTestYear("Pacific/Fiji", [
		["2186-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2186-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2186-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2186-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2187" : helpers.makeTestYear("Pacific/Fiji", [
		["2187-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2187-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2187-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2187-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2188" : helpers.makeTestYear("Pacific/Fiji", [
		["2188-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2188-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2188-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2188-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2189" : helpers.makeTestYear("Pacific/Fiji", [
		["2189-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2189-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2189-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2189-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2190" : helpers.makeTestYear("Pacific/Fiji", [
		["2190-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2190-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2190-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2190-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2191" : helpers.makeTestYear("Pacific/Fiji", [
		["2191-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2191-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2191-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2191-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2192" : helpers.makeTestYear("Pacific/Fiji", [
		["2192-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2192-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2192-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2192-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2193" : helpers.makeTestYear("Pacific/Fiji", [
		["2193-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2193-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2193-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2193-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2194" : helpers.makeTestYear("Pacific/Fiji", [
		["2194-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2194-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2194-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2194-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2195" : helpers.makeTestYear("Pacific/Fiji", [
		["2195-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2195-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2195-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2195-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2196" : helpers.makeTestYear("Pacific/Fiji", [
		["2196-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2196-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2196-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2196-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2197" : helpers.makeTestYear("Pacific/Fiji", [
		["2197-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2197-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2197-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2197-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2198" : helpers.makeTestYear("Pacific/Fiji", [
		["2198-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2198-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2198-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2198-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2199" : helpers.makeTestYear("Pacific/Fiji", [
		["2199-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2199-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2199-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2199-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2200" : helpers.makeTestYear("Pacific/Fiji", [
		["2200-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2200-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2200-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2200-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2201" : helpers.makeTestYear("Pacific/Fiji", [
		["2201-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2201-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2201-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2201-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2202" : helpers.makeTestYear("Pacific/Fiji", [
		["2202-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2202-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2202-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2202-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2203" : helpers.makeTestYear("Pacific/Fiji", [
		["2203-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2203-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2203-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2203-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2204" : helpers.makeTestYear("Pacific/Fiji", [
		["2204-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2204-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2204-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2204-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2205" : helpers.makeTestYear("Pacific/Fiji", [
		["2205-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2205-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2205-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2205-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2206" : helpers.makeTestYear("Pacific/Fiji", [
		["2206-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2206-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2206-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2206-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2207" : helpers.makeTestYear("Pacific/Fiji", [
		["2207-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2207-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2207-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2207-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2208" : helpers.makeTestYear("Pacific/Fiji", [
		["2208-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2208-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2208-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2208-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2209" : helpers.makeTestYear("Pacific/Fiji", [
		["2209-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2209-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2209-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2209-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2210" : helpers.makeTestYear("Pacific/Fiji", [
		["2210-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2210-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2210-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2210-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2211" : helpers.makeTestYear("Pacific/Fiji", [
		["2211-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2211-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2211-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2211-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2212" : helpers.makeTestYear("Pacific/Fiji", [
		["2212-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2212-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2212-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2212-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2213" : helpers.makeTestYear("Pacific/Fiji", [
		["2213-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2213-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2213-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2213-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2214" : helpers.makeTestYear("Pacific/Fiji", [
		["2214-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2214-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2214-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2214-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2215" : helpers.makeTestYear("Pacific/Fiji", [
		["2215-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2215-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2215-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2215-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2216" : helpers.makeTestYear("Pacific/Fiji", [
		["2216-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2216-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2216-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2216-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2217" : helpers.makeTestYear("Pacific/Fiji", [
		["2217-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2217-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2217-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2217-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2218" : helpers.makeTestYear("Pacific/Fiji", [
		["2218-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2218-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2218-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2218-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2219" : helpers.makeTestYear("Pacific/Fiji", [
		["2219-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2219-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2219-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2219-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2220" : helpers.makeTestYear("Pacific/Fiji", [
		["2220-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2220-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2220-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2220-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2221" : helpers.makeTestYear("Pacific/Fiji", [
		["2221-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2221-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2221-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2221-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2222" : helpers.makeTestYear("Pacific/Fiji", [
		["2222-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2222-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2222-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2222-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2223" : helpers.makeTestYear("Pacific/Fiji", [
		["2223-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2223-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2223-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2223-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2224" : helpers.makeTestYear("Pacific/Fiji", [
		["2224-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2224-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2224-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2224-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2225" : helpers.makeTestYear("Pacific/Fiji", [
		["2225-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2225-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2225-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2225-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2226" : helpers.makeTestYear("Pacific/Fiji", [
		["2226-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2226-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2226-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2226-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2227" : helpers.makeTestYear("Pacific/Fiji", [
		["2227-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2227-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2227-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2227-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2228" : helpers.makeTestYear("Pacific/Fiji", [
		["2228-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2228-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2228-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2228-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2229" : helpers.makeTestYear("Pacific/Fiji", [
		["2229-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2229-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2229-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2229-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2230" : helpers.makeTestYear("Pacific/Fiji", [
		["2230-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2230-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2230-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2230-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2231" : helpers.makeTestYear("Pacific/Fiji", [
		["2231-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2231-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2231-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2231-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2232" : helpers.makeTestYear("Pacific/Fiji", [
		["2232-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2232-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2232-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2232-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2233" : helpers.makeTestYear("Pacific/Fiji", [
		["2233-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2233-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2233-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2233-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2234" : helpers.makeTestYear("Pacific/Fiji", [
		["2234-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2234-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2234-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2234-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2235" : helpers.makeTestYear("Pacific/Fiji", [
		["2235-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2235-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2235-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2235-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2236" : helpers.makeTestYear("Pacific/Fiji", [
		["2236-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2236-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2236-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2236-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2237" : helpers.makeTestYear("Pacific/Fiji", [
		["2237-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2237-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2237-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2237-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2238" : helpers.makeTestYear("Pacific/Fiji", [
		["2238-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2238-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2238-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2238-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2239" : helpers.makeTestYear("Pacific/Fiji", [
		["2239-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2239-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2239-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2239-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2240" : helpers.makeTestYear("Pacific/Fiji", [
		["2240-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2240-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2240-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2240-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2241" : helpers.makeTestYear("Pacific/Fiji", [
		["2241-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2241-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2241-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2241-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2242" : helpers.makeTestYear("Pacific/Fiji", [
		["2242-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2242-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2242-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2242-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2243" : helpers.makeTestYear("Pacific/Fiji", [
		["2243-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2243-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2243-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2243-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2244" : helpers.makeTestYear("Pacific/Fiji", [
		["2244-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2244-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2244-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2244-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2245" : helpers.makeTestYear("Pacific/Fiji", [
		["2245-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2245-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2245-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2245-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2246" : helpers.makeTestYear("Pacific/Fiji", [
		["2246-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2246-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2246-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2246-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2247" : helpers.makeTestYear("Pacific/Fiji", [
		["2247-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2247-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2247-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2247-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2248" : helpers.makeTestYear("Pacific/Fiji", [
		["2248-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2248-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2248-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2248-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2249" : helpers.makeTestYear("Pacific/Fiji", [
		["2249-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2249-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2249-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2249-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2250" : helpers.makeTestYear("Pacific/Fiji", [
		["2250-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2250-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2250-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2250-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2251" : helpers.makeTestYear("Pacific/Fiji", [
		["2251-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2251-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2251-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2251-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2252" : helpers.makeTestYear("Pacific/Fiji", [
		["2252-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2252-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2252-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2252-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2253" : helpers.makeTestYear("Pacific/Fiji", [
		["2253-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2253-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2253-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2253-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2254" : helpers.makeTestYear("Pacific/Fiji", [
		["2254-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2254-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2254-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2254-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2255" : helpers.makeTestYear("Pacific/Fiji", [
		["2255-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2255-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2255-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2255-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2256" : helpers.makeTestYear("Pacific/Fiji", [
		["2256-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2256-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2256-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2256-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2257" : helpers.makeTestYear("Pacific/Fiji", [
		["2257-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2257-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2257-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2257-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2258" : helpers.makeTestYear("Pacific/Fiji", [
		["2258-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2258-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2258-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2258-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2259" : helpers.makeTestYear("Pacific/Fiji", [
		["2259-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2259-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2259-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2259-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2260" : helpers.makeTestYear("Pacific/Fiji", [
		["2260-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2260-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2260-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2260-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2261" : helpers.makeTestYear("Pacific/Fiji", [
		["2261-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2261-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2261-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2261-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2262" : helpers.makeTestYear("Pacific/Fiji", [
		["2262-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2262-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2262-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2262-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2263" : helpers.makeTestYear("Pacific/Fiji", [
		["2263-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2263-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2263-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2263-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2264" : helpers.makeTestYear("Pacific/Fiji", [
		["2264-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2264-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2264-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2264-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2265" : helpers.makeTestYear("Pacific/Fiji", [
		["2265-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2265-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2265-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2265-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2266" : helpers.makeTestYear("Pacific/Fiji", [
		["2266-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2266-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2266-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2266-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2267" : helpers.makeTestYear("Pacific/Fiji", [
		["2267-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2267-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2267-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2267-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2268" : helpers.makeTestYear("Pacific/Fiji", [
		["2268-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2268-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2268-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2268-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2269" : helpers.makeTestYear("Pacific/Fiji", [
		["2269-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2269-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2269-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2269-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2270" : helpers.makeTestYear("Pacific/Fiji", [
		["2270-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2270-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2270-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2270-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2271" : helpers.makeTestYear("Pacific/Fiji", [
		["2271-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2271-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2271-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2271-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2272" : helpers.makeTestYear("Pacific/Fiji", [
		["2272-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2272-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2272-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2272-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2273" : helpers.makeTestYear("Pacific/Fiji", [
		["2273-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2273-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2273-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2273-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2274" : helpers.makeTestYear("Pacific/Fiji", [
		["2274-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2274-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2274-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2274-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2275" : helpers.makeTestYear("Pacific/Fiji", [
		["2275-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2275-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2275-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2275-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2276" : helpers.makeTestYear("Pacific/Fiji", [
		["2276-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2276-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2276-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2276-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2277" : helpers.makeTestYear("Pacific/Fiji", [
		["2277-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2277-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2277-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2277-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2278" : helpers.makeTestYear("Pacific/Fiji", [
		["2278-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2278-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2278-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2278-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2279" : helpers.makeTestYear("Pacific/Fiji", [
		["2279-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2279-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2279-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2279-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2280" : helpers.makeTestYear("Pacific/Fiji", [
		["2280-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2280-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2280-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2280-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2281" : helpers.makeTestYear("Pacific/Fiji", [
		["2281-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2281-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2281-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2281-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2282" : helpers.makeTestYear("Pacific/Fiji", [
		["2282-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2282-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2282-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2282-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2283" : helpers.makeTestYear("Pacific/Fiji", [
		["2283-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2283-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2283-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2283-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2284" : helpers.makeTestYear("Pacific/Fiji", [
		["2284-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2284-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2284-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2284-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2285" : helpers.makeTestYear("Pacific/Fiji", [
		["2285-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2285-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2285-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2285-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2286" : helpers.makeTestYear("Pacific/Fiji", [
		["2286-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2286-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2286-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2286-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2287" : helpers.makeTestYear("Pacific/Fiji", [
		["2287-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2287-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2287-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2287-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2288" : helpers.makeTestYear("Pacific/Fiji", [
		["2288-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2288-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2288-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2288-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2289" : helpers.makeTestYear("Pacific/Fiji", [
		["2289-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2289-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2289-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2289-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2290" : helpers.makeTestYear("Pacific/Fiji", [
		["2290-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2290-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2290-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2290-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2291" : helpers.makeTestYear("Pacific/Fiji", [
		["2291-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2291-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2291-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2291-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2292" : helpers.makeTestYear("Pacific/Fiji", [
		["2292-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2292-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2292-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2292-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2293" : helpers.makeTestYear("Pacific/Fiji", [
		["2293-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2293-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2293-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2293-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2294" : helpers.makeTestYear("Pacific/Fiji", [
		["2294-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2294-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2294-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2294-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2295" : helpers.makeTestYear("Pacific/Fiji", [
		["2295-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2295-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2295-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2295-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2296" : helpers.makeTestYear("Pacific/Fiji", [
		["2296-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2296-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2296-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2296-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2297" : helpers.makeTestYear("Pacific/Fiji", [
		["2297-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2297-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2297-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2297-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2298" : helpers.makeTestYear("Pacific/Fiji", [
		["2298-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2298-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2298-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2298-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2299" : helpers.makeTestYear("Pacific/Fiji", [
		["2299-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2299-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2299-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2299-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2300" : helpers.makeTestYear("Pacific/Fiji", [
		["2300-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2300-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2300-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2300-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2301" : helpers.makeTestYear("Pacific/Fiji", [
		["2301-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2301-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2301-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2301-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2302" : helpers.makeTestYear("Pacific/Fiji", [
		["2302-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2302-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2302-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2302-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2303" : helpers.makeTestYear("Pacific/Fiji", [
		["2303-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2303-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2303-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2303-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2304" : helpers.makeTestYear("Pacific/Fiji", [
		["2304-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2304-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2304-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2304-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2305" : helpers.makeTestYear("Pacific/Fiji", [
		["2305-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2305-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2305-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2305-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2306" : helpers.makeTestYear("Pacific/Fiji", [
		["2306-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2306-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2306-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2306-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2307" : helpers.makeTestYear("Pacific/Fiji", [
		["2307-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2307-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2307-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2307-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2308" : helpers.makeTestYear("Pacific/Fiji", [
		["2308-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2308-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2308-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2308-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2309" : helpers.makeTestYear("Pacific/Fiji", [
		["2309-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2309-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2309-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2309-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2310" : helpers.makeTestYear("Pacific/Fiji", [
		["2310-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2310-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2310-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2310-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2311" : helpers.makeTestYear("Pacific/Fiji", [
		["2311-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2311-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2311-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2311-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2312" : helpers.makeTestYear("Pacific/Fiji", [
		["2312-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2312-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2312-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2312-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2313" : helpers.makeTestYear("Pacific/Fiji", [
		["2313-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2313-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2313-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2313-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2314" : helpers.makeTestYear("Pacific/Fiji", [
		["2314-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2314-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2314-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2314-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2315" : helpers.makeTestYear("Pacific/Fiji", [
		["2315-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2315-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2315-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2315-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2316" : helpers.makeTestYear("Pacific/Fiji", [
		["2316-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2316-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2316-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2316-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2317" : helpers.makeTestYear("Pacific/Fiji", [
		["2317-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2317-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2317-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2317-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2318" : helpers.makeTestYear("Pacific/Fiji", [
		["2318-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2318-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2318-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2318-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2319" : helpers.makeTestYear("Pacific/Fiji", [
		["2319-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2319-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2319-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2319-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2320" : helpers.makeTestYear("Pacific/Fiji", [
		["2320-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2320-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2320-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2320-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2321" : helpers.makeTestYear("Pacific/Fiji", [
		["2321-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2321-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2321-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2321-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2322" : helpers.makeTestYear("Pacific/Fiji", [
		["2322-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2322-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2322-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2322-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2323" : helpers.makeTestYear("Pacific/Fiji", [
		["2323-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2323-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2323-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2323-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2324" : helpers.makeTestYear("Pacific/Fiji", [
		["2324-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2324-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2324-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2324-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2325" : helpers.makeTestYear("Pacific/Fiji", [
		["2325-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2325-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2325-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2325-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2326" : helpers.makeTestYear("Pacific/Fiji", [
		["2326-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2326-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2326-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2326-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2327" : helpers.makeTestYear("Pacific/Fiji", [
		["2327-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2327-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2327-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2327-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2328" : helpers.makeTestYear("Pacific/Fiji", [
		["2328-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2328-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2328-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2328-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2329" : helpers.makeTestYear("Pacific/Fiji", [
		["2329-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2329-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2329-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2329-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2330" : helpers.makeTestYear("Pacific/Fiji", [
		["2330-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2330-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2330-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2330-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2331" : helpers.makeTestYear("Pacific/Fiji", [
		["2331-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2331-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2331-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2331-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2332" : helpers.makeTestYear("Pacific/Fiji", [
		["2332-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2332-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2332-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2332-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2333" : helpers.makeTestYear("Pacific/Fiji", [
		["2333-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2333-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2333-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2333-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2334" : helpers.makeTestYear("Pacific/Fiji", [
		["2334-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2334-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2334-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2334-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2335" : helpers.makeTestYear("Pacific/Fiji", [
		["2335-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2335-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2335-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2335-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2336" : helpers.makeTestYear("Pacific/Fiji", [
		["2336-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2336-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2336-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2336-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2337" : helpers.makeTestYear("Pacific/Fiji", [
		["2337-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2337-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2337-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2337-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2338" : helpers.makeTestYear("Pacific/Fiji", [
		["2338-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2338-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2338-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2338-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2339" : helpers.makeTestYear("Pacific/Fiji", [
		["2339-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2339-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2339-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2339-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2340" : helpers.makeTestYear("Pacific/Fiji", [
		["2340-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2340-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2340-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2340-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2341" : helpers.makeTestYear("Pacific/Fiji", [
		["2341-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2341-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2341-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2341-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2342" : helpers.makeTestYear("Pacific/Fiji", [
		["2342-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2342-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2342-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2342-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2343" : helpers.makeTestYear("Pacific/Fiji", [
		["2343-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2343-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2343-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2343-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2344" : helpers.makeTestYear("Pacific/Fiji", [
		["2344-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2344-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2344-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2344-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2345" : helpers.makeTestYear("Pacific/Fiji", [
		["2345-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2345-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2345-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2345-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2346" : helpers.makeTestYear("Pacific/Fiji", [
		["2346-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2346-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2346-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2346-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2347" : helpers.makeTestYear("Pacific/Fiji", [
		["2347-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2347-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2347-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2347-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2348" : helpers.makeTestYear("Pacific/Fiji", [
		["2348-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2348-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2348-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2348-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2349" : helpers.makeTestYear("Pacific/Fiji", [
		["2349-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2349-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2349-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2349-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2350" : helpers.makeTestYear("Pacific/Fiji", [
		["2350-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2350-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2350-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2350-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2351" : helpers.makeTestYear("Pacific/Fiji", [
		["2351-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2351-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2351-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2351-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2352" : helpers.makeTestYear("Pacific/Fiji", [
		["2352-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2352-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2352-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2352-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2353" : helpers.makeTestYear("Pacific/Fiji", [
		["2353-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2353-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2353-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2353-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2354" : helpers.makeTestYear("Pacific/Fiji", [
		["2354-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2354-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2354-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2354-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2355" : helpers.makeTestYear("Pacific/Fiji", [
		["2355-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2355-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2355-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2355-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2356" : helpers.makeTestYear("Pacific/Fiji", [
		["2356-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2356-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2356-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2356-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2357" : helpers.makeTestYear("Pacific/Fiji", [
		["2357-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2357-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2357-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2357-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2358" : helpers.makeTestYear("Pacific/Fiji", [
		["2358-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2358-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2358-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2358-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2359" : helpers.makeTestYear("Pacific/Fiji", [
		["2359-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2359-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2359-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2359-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2360" : helpers.makeTestYear("Pacific/Fiji", [
		["2360-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2360-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2360-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2360-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2361" : helpers.makeTestYear("Pacific/Fiji", [
		["2361-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2361-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2361-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2361-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2362" : helpers.makeTestYear("Pacific/Fiji", [
		["2362-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2362-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2362-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2362-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2363" : helpers.makeTestYear("Pacific/Fiji", [
		["2363-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2363-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2363-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2363-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2364" : helpers.makeTestYear("Pacific/Fiji", [
		["2364-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2364-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2364-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2364-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2365" : helpers.makeTestYear("Pacific/Fiji", [
		["2365-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2365-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2365-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2365-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2366" : helpers.makeTestYear("Pacific/Fiji", [
		["2366-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2366-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2366-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2366-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2367" : helpers.makeTestYear("Pacific/Fiji", [
		["2367-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2367-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2367-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2367-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2368" : helpers.makeTestYear("Pacific/Fiji", [
		["2368-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2368-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2368-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2368-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2369" : helpers.makeTestYear("Pacific/Fiji", [
		["2369-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2369-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2369-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2369-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2370" : helpers.makeTestYear("Pacific/Fiji", [
		["2370-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2370-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2370-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2370-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2371" : helpers.makeTestYear("Pacific/Fiji", [
		["2371-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2371-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2371-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2371-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2372" : helpers.makeTestYear("Pacific/Fiji", [
		["2372-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2372-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2372-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2372-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2373" : helpers.makeTestYear("Pacific/Fiji", [
		["2373-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2373-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2373-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2373-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2374" : helpers.makeTestYear("Pacific/Fiji", [
		["2374-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2374-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2374-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2374-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2375" : helpers.makeTestYear("Pacific/Fiji", [
		["2375-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2375-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2375-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2375-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2376" : helpers.makeTestYear("Pacific/Fiji", [
		["2376-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2376-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2376-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2376-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2377" : helpers.makeTestYear("Pacific/Fiji", [
		["2377-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2377-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2377-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2377-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2378" : helpers.makeTestYear("Pacific/Fiji", [
		["2378-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2378-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2378-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2378-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2379" : helpers.makeTestYear("Pacific/Fiji", [
		["2379-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2379-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2379-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2379-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2380" : helpers.makeTestYear("Pacific/Fiji", [
		["2380-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2380-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2380-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2380-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2381" : helpers.makeTestYear("Pacific/Fiji", [
		["2381-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2381-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2381-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2381-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2382" : helpers.makeTestYear("Pacific/Fiji", [
		["2382-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2382-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2382-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2382-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2383" : helpers.makeTestYear("Pacific/Fiji", [
		["2383-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2383-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2383-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2383-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2384" : helpers.makeTestYear("Pacific/Fiji", [
		["2384-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2384-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2384-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2384-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2385" : helpers.makeTestYear("Pacific/Fiji", [
		["2385-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2385-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2385-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2385-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2386" : helpers.makeTestYear("Pacific/Fiji", [
		["2386-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2386-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2386-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2386-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2387" : helpers.makeTestYear("Pacific/Fiji", [
		["2387-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2387-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2387-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2387-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2388" : helpers.makeTestYear("Pacific/Fiji", [
		["2388-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2388-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2388-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2388-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2389" : helpers.makeTestYear("Pacific/Fiji", [
		["2389-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2389-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2389-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2389-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2390" : helpers.makeTestYear("Pacific/Fiji", [
		["2390-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2390-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2390-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2390-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2391" : helpers.makeTestYear("Pacific/Fiji", [
		["2391-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2391-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2391-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2391-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2392" : helpers.makeTestYear("Pacific/Fiji", [
		["2392-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2392-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2392-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2392-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2393" : helpers.makeTestYear("Pacific/Fiji", [
		["2393-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2393-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2393-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2393-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2394" : helpers.makeTestYear("Pacific/Fiji", [
		["2394-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2394-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2394-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2394-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2395" : helpers.makeTestYear("Pacific/Fiji", [
		["2395-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2395-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2395-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2395-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2396" : helpers.makeTestYear("Pacific/Fiji", [
		["2396-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2396-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2396-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2396-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2397" : helpers.makeTestYear("Pacific/Fiji", [
		["2397-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2397-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2397-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2397-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2398" : helpers.makeTestYear("Pacific/Fiji", [
		["2398-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2398-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2398-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2398-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2399" : helpers.makeTestYear("Pacific/Fiji", [
		["2399-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2399-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2399-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2399-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2400" : helpers.makeTestYear("Pacific/Fiji", [
		["2400-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2400-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2400-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2400-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2401" : helpers.makeTestYear("Pacific/Fiji", [
		["2401-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2401-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2401-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2401-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2402" : helpers.makeTestYear("Pacific/Fiji", [
		["2402-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2402-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2402-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2402-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2403" : helpers.makeTestYear("Pacific/Fiji", [
		["2403-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2403-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2403-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2403-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2404" : helpers.makeTestYear("Pacific/Fiji", [
		["2404-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2404-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2404-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2404-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2405" : helpers.makeTestYear("Pacific/Fiji", [
		["2405-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2405-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2405-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2405-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2406" : helpers.makeTestYear("Pacific/Fiji", [
		["2406-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2406-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2406-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2406-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2407" : helpers.makeTestYear("Pacific/Fiji", [
		["2407-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2407-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2407-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2407-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2408" : helpers.makeTestYear("Pacific/Fiji", [
		["2408-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2408-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2408-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2408-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2409" : helpers.makeTestYear("Pacific/Fiji", [
		["2409-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2409-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2409-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2409-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2410" : helpers.makeTestYear("Pacific/Fiji", [
		["2410-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2410-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2410-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2410-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2411" : helpers.makeTestYear("Pacific/Fiji", [
		["2411-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2411-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2411-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2411-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2412" : helpers.makeTestYear("Pacific/Fiji", [
		["2412-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2412-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2412-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2412-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2413" : helpers.makeTestYear("Pacific/Fiji", [
		["2413-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2413-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2413-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2413-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2414" : helpers.makeTestYear("Pacific/Fiji", [
		["2414-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2414-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2414-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2414-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2415" : helpers.makeTestYear("Pacific/Fiji", [
		["2415-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2415-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2415-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2415-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2416" : helpers.makeTestYear("Pacific/Fiji", [
		["2416-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2416-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2416-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2416-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2417" : helpers.makeTestYear("Pacific/Fiji", [
		["2417-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2417-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2417-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2417-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2418" : helpers.makeTestYear("Pacific/Fiji", [
		["2418-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2418-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2418-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2418-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2419" : helpers.makeTestYear("Pacific/Fiji", [
		["2419-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2419-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2419-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2419-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2420" : helpers.makeTestYear("Pacific/Fiji", [
		["2420-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2420-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2420-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2420-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2421" : helpers.makeTestYear("Pacific/Fiji", [
		["2421-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2421-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2421-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2421-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2422" : helpers.makeTestYear("Pacific/Fiji", [
		["2422-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2422-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2422-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2422-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2423" : helpers.makeTestYear("Pacific/Fiji", [
		["2423-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2423-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2423-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2423-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2424" : helpers.makeTestYear("Pacific/Fiji", [
		["2424-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2424-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2424-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2424-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2425" : helpers.makeTestYear("Pacific/Fiji", [
		["2425-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2425-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2425-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2425-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2426" : helpers.makeTestYear("Pacific/Fiji", [
		["2426-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2426-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2426-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2426-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2427" : helpers.makeTestYear("Pacific/Fiji", [
		["2427-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2427-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2427-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2427-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2428" : helpers.makeTestYear("Pacific/Fiji", [
		["2428-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2428-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2428-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2428-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2429" : helpers.makeTestYear("Pacific/Fiji", [
		["2429-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2429-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2429-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2429-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2430" : helpers.makeTestYear("Pacific/Fiji", [
		["2430-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2430-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2430-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2430-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2431" : helpers.makeTestYear("Pacific/Fiji", [
		["2431-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2431-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2431-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2431-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2432" : helpers.makeTestYear("Pacific/Fiji", [
		["2432-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2432-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2432-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2432-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2433" : helpers.makeTestYear("Pacific/Fiji", [
		["2433-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2433-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2433-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2433-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2434" : helpers.makeTestYear("Pacific/Fiji", [
		["2434-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2434-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2434-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2434-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2435" : helpers.makeTestYear("Pacific/Fiji", [
		["2435-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2435-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2435-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2435-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2436" : helpers.makeTestYear("Pacific/Fiji", [
		["2436-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2436-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2436-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2436-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2437" : helpers.makeTestYear("Pacific/Fiji", [
		["2437-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2437-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2437-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2437-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2438" : helpers.makeTestYear("Pacific/Fiji", [
		["2438-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2438-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2438-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2438-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2439" : helpers.makeTestYear("Pacific/Fiji", [
		["2439-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2439-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2439-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2439-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2440" : helpers.makeTestYear("Pacific/Fiji", [
		["2440-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2440-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2440-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2440-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2441" : helpers.makeTestYear("Pacific/Fiji", [
		["2441-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2441-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2441-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2441-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2442" : helpers.makeTestYear("Pacific/Fiji", [
		["2442-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2442-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2442-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2442-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2443" : helpers.makeTestYear("Pacific/Fiji", [
		["2443-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2443-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2443-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2443-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2444" : helpers.makeTestYear("Pacific/Fiji", [
		["2444-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2444-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2444-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2444-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2445" : helpers.makeTestYear("Pacific/Fiji", [
		["2445-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2445-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2445-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2445-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2446" : helpers.makeTestYear("Pacific/Fiji", [
		["2446-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2446-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2446-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2446-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2447" : helpers.makeTestYear("Pacific/Fiji", [
		["2447-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2447-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2447-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2447-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2448" : helpers.makeTestYear("Pacific/Fiji", [
		["2448-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2448-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2448-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2448-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2449" : helpers.makeTestYear("Pacific/Fiji", [
		["2449-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2449-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2449-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2449-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2450" : helpers.makeTestYear("Pacific/Fiji", [
		["2450-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2450-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2450-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2450-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2451" : helpers.makeTestYear("Pacific/Fiji", [
		["2451-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2451-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2451-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2451-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2452" : helpers.makeTestYear("Pacific/Fiji", [
		["2452-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2452-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2452-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2452-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2453" : helpers.makeTestYear("Pacific/Fiji", [
		["2453-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2453-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2453-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2453-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2454" : helpers.makeTestYear("Pacific/Fiji", [
		["2454-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2454-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2454-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2454-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2455" : helpers.makeTestYear("Pacific/Fiji", [
		["2455-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2455-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2455-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2455-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2456" : helpers.makeTestYear("Pacific/Fiji", [
		["2456-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2456-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2456-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2456-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2457" : helpers.makeTestYear("Pacific/Fiji", [
		["2457-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2457-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2457-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2457-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2458" : helpers.makeTestYear("Pacific/Fiji", [
		["2458-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2458-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2458-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2458-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2459" : helpers.makeTestYear("Pacific/Fiji", [
		["2459-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2459-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2459-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2459-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2460" : helpers.makeTestYear("Pacific/Fiji", [
		["2460-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2460-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2460-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2460-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2461" : helpers.makeTestYear("Pacific/Fiji", [
		["2461-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2461-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2461-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2461-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2462" : helpers.makeTestYear("Pacific/Fiji", [
		["2462-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2462-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2462-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2462-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2463" : helpers.makeTestYear("Pacific/Fiji", [
		["2463-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2463-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2463-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2463-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2464" : helpers.makeTestYear("Pacific/Fiji", [
		["2464-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2464-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2464-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2464-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2465" : helpers.makeTestYear("Pacific/Fiji", [
		["2465-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2465-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2465-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2465-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2466" : helpers.makeTestYear("Pacific/Fiji", [
		["2466-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2466-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2466-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2466-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2467" : helpers.makeTestYear("Pacific/Fiji", [
		["2467-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2467-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2467-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2467-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2468" : helpers.makeTestYear("Pacific/Fiji", [
		["2468-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2468-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2468-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2468-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2469" : helpers.makeTestYear("Pacific/Fiji", [
		["2469-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2469-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2469-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2469-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2470" : helpers.makeTestYear("Pacific/Fiji", [
		["2470-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2470-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2470-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2470-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2471" : helpers.makeTestYear("Pacific/Fiji", [
		["2471-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2471-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2471-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2471-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2472" : helpers.makeTestYear("Pacific/Fiji", [
		["2472-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2472-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2472-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2472-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2473" : helpers.makeTestYear("Pacific/Fiji", [
		["2473-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2473-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2473-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2473-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2474" : helpers.makeTestYear("Pacific/Fiji", [
		["2474-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2474-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2474-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2474-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2475" : helpers.makeTestYear("Pacific/Fiji", [
		["2475-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2475-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2475-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2475-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2476" : helpers.makeTestYear("Pacific/Fiji", [
		["2476-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2476-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2476-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2476-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2477" : helpers.makeTestYear("Pacific/Fiji", [
		["2477-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2477-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2477-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2477-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2478" : helpers.makeTestYear("Pacific/Fiji", [
		["2478-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2478-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2478-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2478-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2479" : helpers.makeTestYear("Pacific/Fiji", [
		["2479-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2479-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2479-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2479-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2480" : helpers.makeTestYear("Pacific/Fiji", [
		["2480-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2480-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2480-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2480-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2481" : helpers.makeTestYear("Pacific/Fiji", [
		["2481-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2481-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2481-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2481-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2482" : helpers.makeTestYear("Pacific/Fiji", [
		["2482-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2482-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2482-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2482-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2483" : helpers.makeTestYear("Pacific/Fiji", [
		["2483-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2483-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2483-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2483-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2484" : helpers.makeTestYear("Pacific/Fiji", [
		["2484-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2484-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2484-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2484-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2485" : helpers.makeTestYear("Pacific/Fiji", [
		["2485-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2485-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2485-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2485-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2486" : helpers.makeTestYear("Pacific/Fiji", [
		["2486-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2486-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2486-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2486-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2487" : helpers.makeTestYear("Pacific/Fiji", [
		["2487-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2487-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2487-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2487-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2488" : helpers.makeTestYear("Pacific/Fiji", [
		["2488-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2488-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2488-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2488-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2489" : helpers.makeTestYear("Pacific/Fiji", [
		["2489-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2489-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2489-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2489-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2490" : helpers.makeTestYear("Pacific/Fiji", [
		["2490-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2490-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2490-11-04T13:59:59+00:00", "01:59:59", "+12", -720],
		["2490-11-04T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2491" : helpers.makeTestYear("Pacific/Fiji", [
		["2491-01-13T13:59:59+00:00", "02:59:59", "+13", -780],
		["2491-01-13T14:00:00+00:00", "02:00:00", "+12", -720],
		["2491-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2491-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2492" : helpers.makeTestYear("Pacific/Fiji", [
		["2492-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2492-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2492-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2492-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2493" : helpers.makeTestYear("Pacific/Fiji", [
		["2493-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2493-01-17T14:00:00+00:00", "02:00:00", "+12", -720],
		["2493-10-31T13:59:59+00:00", "01:59:59", "+12", -720],
		["2493-10-31T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2494" : helpers.makeTestYear("Pacific/Fiji", [
		["2494-01-16T13:59:59+00:00", "02:59:59", "+13", -780],
		["2494-01-16T14:00:00+00:00", "02:00:00", "+12", -720],
		["2494-11-06T13:59:59+00:00", "01:59:59", "+12", -720],
		["2494-11-06T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2495" : helpers.makeTestYear("Pacific/Fiji", [
		["2495-01-15T13:59:59+00:00", "02:59:59", "+13", -780],
		["2495-01-15T14:00:00+00:00", "02:00:00", "+12", -720],
		["2495-11-05T13:59:59+00:00", "01:59:59", "+12", -720],
		["2495-11-05T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2496" : helpers.makeTestYear("Pacific/Fiji", [
		["2496-01-14T13:59:59+00:00", "02:59:59", "+13", -780],
		["2496-01-14T14:00:00+00:00", "02:00:00", "+12", -720],
		["2496-11-03T13:59:59+00:00", "01:59:59", "+12", -720],
		["2496-11-03T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2497" : helpers.makeTestYear("Pacific/Fiji", [
		["2497-01-12T13:59:59+00:00", "02:59:59", "+13", -780],
		["2497-01-12T14:00:00+00:00", "02:00:00", "+12", -720],
		["2497-11-02T13:59:59+00:00", "01:59:59", "+12", -720],
		["2497-11-02T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2498" : helpers.makeTestYear("Pacific/Fiji", [
		["2498-01-18T13:59:59+00:00", "02:59:59", "+13", -780],
		["2498-01-18T14:00:00+00:00", "02:00:00", "+12", -720],
		["2498-11-01T13:59:59+00:00", "01:59:59", "+12", -720],
		["2498-11-01T14:00:00+00:00", "03:00:00", "+13", -780]
	]),

	"2499" : helpers.makeTestYear("Pacific/Fiji", [
		["2499-01-17T13:59:59+00:00", "02:59:59", "+13", -780],
		["2499-01-17T14:00:00+00:00", "02:00:00", "+12", -720]
	])
};