/*
 * This file is part of the xTuple ERP: PostBooks Edition, a free and
 * open source Enterprise Resource Planning software suite,
 * Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
 * It is licensed to you under the Common Public Attribution License
 * version 1.0, the full text of which (including xTuple-specific Exhibits)
 * is available at www.xtuple.com/CPAL.  By using this software, you agree
 * to be bound by its terms.
 */

#include "configureWO.h"

#include <QValidator>
#include <QVariant>

#include "guiclient.h"

configureWO::configureWO(QWidget* parent, const char* name, bool /*modal*/, Qt::WindowFlags fl)
    : XAbstractConfigure(parent, fl)
{
  XSqlQuery configureconfigureWO;
  setupUi(this);

  if (name)
    setObjectName(name);

  connect(_autoExplode, SIGNAL(toggled(bool)), _WOExplosionGroup, SLOT(setDisabled(bool)));
  connect(_autoExplode, SIGNAL(toggled(bool)), _multiLevel, SLOT(setChecked(bool)));

  _nextWoNumber->setValidator(omfgThis->orderVal());

  configureconfigureWO.exec( "SELECT orderseq_number "
          "FROM orderseq "
          "WHERE (orderseq_name='WoNumber')" );
  if (configureconfigureWO.first())
    _nextWoNumber->setText(configureconfigureWO.value("orderseq_number").toString());

  _autoExplode->setChecked(_metrics->boolean("AutoExplodeWO"));
  _issueToExplodedWO->setChecked(_metrics->boolean("IssueToExplodedWO"));
  _workOrderChangeLog->setChecked(_metrics->boolean("WorkOrderChangeLog"));

  _woNumGeneration->append(0, tr("Automatic"),                  "A");
  _woNumGeneration->append(1, tr("Manual"),                     "M");
  _woNumGeneration->append(2, tr("Automatic, Allow Override"),  "O");

  _woNumGeneration->setCode(_metrics->value("WONumberGeneration"));

  if (_metrics->value("ExplodeWOEffective") == "E")
    _explodeDateEffective->setChecked(true);
  else
    _startDateEffective->setChecked(true);

  if (_metrics->value("WOExplosionLevel") == "S")
    _singleLevel->setChecked(true);
  else if (_metrics->value("WOExplosionLevel") == "M")
    _multiLevel->setChecked(true);

  _materialVariances->setChecked(_metrics->boolean("PostMaterialVariances"));
  
  if (_metrics->value("JobItemCosDefault") == "P")
    _proportional->setChecked(true);
  else
    _todate->setChecked(true);
    
  this->setWindowTitle("Manufacture Configuration");
}

configureWO::~configureWO()
{
  // no need to delete child widgets, Qt does it all for us
}

void configureWO::languageChange()
{
  retranslateUi(this);
}

bool configureWO::sSave()
{
  XSqlQuery configureSave;
  emit saving();

  configureSave.prepare("SELECT setNextWoNumber(:woNumber) AS result;");
  configureSave.bindValue(":woNumber", _nextWoNumber->text().toInt());
  configureSave.exec();

  _metrics->set("AutoExplodeWO", _autoExplode->isChecked());
  _metrics->set("IssueToExplodedWO", _issueToExplodedWO->isChecked());
  _metrics->set("WorkOrderChangeLog", _workOrderChangeLog->isChecked());

  _metrics->set("WONumberGeneration", _woNumGeneration->code());

  _metrics->set("ExplodeWOEffective", ((_explodeDateEffective->isChecked()) ? QString("E") : QString("S")));
  _metrics->set("WOExplosionLevel", ((_singleLevel->isChecked()) ? QString("S") : QString("M")));
  _metrics->set("PostMaterialVariances", _materialVariances->isChecked());

  if (_todate->isChecked())
    _metrics->set("JobItemCosDefault", QString("D"));
  else 
    _metrics->set("JobItemCosDefault", QString("P"));

  return true;
}

