#ifndef LOG_H
#define LOG_H

#include <systemd/sd-journal.h>

#ifdef __cplusplus
extern "C" {
#endif

#define log_debug(...) sd_journal_print_with_location(LOG_DEBUG, "CODE_FILE=" __FILE__, "CODE_LINE=" _SD_STRINGIFY(__LINE__), __func__, __VA_ARGS__)
#define log_info(...) sd_journal_print_with_location(LOG_INFO, "CODE_FILE=" __FILE__, "CODE_LINE=" _SD_STRINGIFY(__LINE__), __func__, __VA_ARGS__)
#define log_notice(...)  sd_journal_print_with_location(LOG_NOTICE, "CODE_FILE=" __FILE__, "CODE_LINE=" _SD_STRINGIFY(__LINE__), __func__, __VA_ARGS__)
#define log_warn(...)  sd_journal_print_with_location(LOG_WARNING, "CODE_FILE=" __FILE__, "CODE_LINE=" _SD_STRINGIFY(__LINE__), __func__, __VA_ARGS__)
#define log_error(...) sd_journal_print_with_location(LOG_ERR, "CODE_FILE=" __FILE__, "CODE_LINE=" _SD_STRINGIFY(__LINE__), __func__, __VA_ARGS__)
#define log_crit(...) sd_journal_print_with_location(LOG_CRIT, "CODE_FILE=" __FILE__, "CODE_LINE=" _SD_STRINGIFY(__LINE__), __func__, __VA_ARGS__)
#define log_alert(...) sd_journal_print_with_location(LOG_ALERT, "CODE_FILE=" __FILE__, "CODE_LINE=" _SD_STRINGIFY(__LINE__), __func__, __VA_ARGS__)
#define log_emerg(...) sd_journal_print_with_location(LOG_EMERG, "CODE_FILE=" __FILE__, "CODE_LINE=" _SD_STRINGIFY(__LINE__), __func__, __VA_ARGS__)

#ifdef __cplusplus
}
#endif

#endif /* LOG_H */