/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.server;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import org.emboss.jemboss.programs.RunEmbossApplication2;

public class JembossThread
extends Thread {
    private RunEmbossApplication2 rea;
    private String project;

    public JembossThread(RunEmbossApplication2 rea, String project) {
        this.rea = rea;
        this.project = project;
    }

    public void run() {
        this.rea.waitFor();
        this.createFinishedFile();
        try {
            String stderr = this.rea.getProcessStderr();
            if (stderr.length() > 0) {
                this.createStderrFile(stderr);
            }
        }
        catch (Exception e) {
            System.err.println("Problem while capturing stderr output: " + e.getMessage());
        }
    }

    private void createStderrFile(String stderr) {
        File stderrfile = new File(this.project + File.separator + "stderrfile");
        try {
            PrintWriter fout = new PrintWriter(new FileWriter(stderrfile));
            fout.println(stderr);
            fout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createFinishedFile() {
        File finished = new File(this.project + File.separator + ".finished");
        try {
            PrintWriter fout = new PrintWriter(new FileWriter(finished));
            fout.println(new Date().toString());
            fout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

