/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.tests;

import gr.zeus.tests.JInternalFrameGenerator;
import gr.zeus.ui.JIConsole;
import gr.zeus.ui.mdi.WindowManager;
import gr.zeus.util.GUIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class JDesktopTester
extends JFrame {
    private JIConsole m_consoleInternalFrame = new JIConsole();
    private WindowManager m_windowManager = null;
    private JCheckBoxMenuItem autoPositionMenuItem;
    private JCheckBoxMenuItem m_closePolicyMenuItem;
    private JCheckBoxMenuItem m_deiconifiablePolicyMenuItem;
    private JDesktopPane m_desktopPane;
    private JCheckBoxMenuItem m_outlineDragModeMenuItem;
    private JMenu m_windowMenu;
    private JMenuItem showConsoleMenuItem;

    public JDesktopTester() {
        this.initComponents();
        this.m_consoleInternalFrame.setPreferredSize(new Dimension(400, 400));
        this.m_consoleInternalFrame.setBounds(50, 50, 450, 450);
        this.m_consoleInternalFrame.setVisible(true);
        this.m_desktopPane.add((Component)this.m_consoleInternalFrame, JLayeredPane.DEFAULT_LAYER);
        this.init_console();
        JInternalFrame jif1 = new JInternalFrame();
        jif1.setTitle(null);
        jif1.getContentPane().add(new JLabel("null title"));
        jif1.setResizable(true);
        jif1.setMaximizable(true);
        jif1.setClosable(true);
        jif1.setIconifiable(true);
        jif1.setDefaultCloseOperation(2);
        jif1.setPreferredSize(new Dimension(200, 200));
        jif1.setBounds(0, 0, 200, 200);
        jif1.setVisible(true);
        this.m_desktopPane.add((Component)jif1, JLayeredPane.DEFAULT_LAYER);
        JInternalFrame jif2 = new JInternalFrame();
        jif2.setTitle("");
        jif2.getContentPane().add(new JLabel("empty title"));
        jif2.setResizable(true);
        jif2.setMaximizable(true);
        jif2.setClosable(true);
        jif2.setIconifiable(true);
        jif2.setDefaultCloseOperation(1);
        jif2.setPreferredSize(new Dimension(200, 200));
        jif2.setBounds(20, 20, 220, 220);
        jif2.setVisible(true);
        this.m_desktopPane.add((Component)jif2, JLayeredPane.DEFAULT_LAYER);
        this.m_windowManager = new WindowManager(this.m_desktopPane, this.m_windowMenu);
        this.m_outlineDragModeMenuItem.setSelected(this.m_windowManager.getOutlineDragMode());
        this.m_deiconifiablePolicyMenuItem.setSelected(this.m_windowManager.getDeiconifiablePolicy());
        this.m_closePolicyMenuItem.setSelected(this.m_windowManager.getClosePolicy());
        this.autoPositionMenuItem.setSelected(this.m_windowManager.getAutoPositionPolicy());
        GUIUtils.maximizeJFrame(this);
    }

    private void init_console() {
        System.out.println("Hello and goodbye from stdout");
        System.err.println("Hello and goodbye from stderr");
        JIConsole.getConsole().setBackgroundColor(Color.DARK_GRAY);
        JIConsole.getConsole().setForegroundColor(Color.YELLOW);
        JIConsole.getConsole().setSelectedTextColor(Color.DARK_GRAY);
        JIConsole.getConsole().setSelectionColor(Color.YELLOW);
        JIConsole.getConsole().setAppendFirstTime(false);
        JIConsole.getConsole().setAutoSave(true);
        JIConsole.getConsole().startConsole();
        System.out.println("This is the very first message logged to JConsole (stdout)");
        System.err.println("This is the very first message logged to JConsole (stderr)");
    }

    private void initComponents() {
        this.m_desktopPane = new JDesktopPane();
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem newJInternalFrameMenuItem = new JMenuItem();
        JMenuItem countFramesMenuItem = new JMenuItem();
        this.showConsoleMenuItem = new JMenuItem();
        JMenuItem exitMenuItem = new JMenuItem();
        this.m_windowMenu = new JMenu();
        this.m_outlineDragModeMenuItem = new JCheckBoxMenuItem();
        this.m_deiconifiablePolicyMenuItem = new JCheckBoxMenuItem();
        this.autoPositionMenuItem = new JCheckBoxMenuItem();
        this.m_closePolicyMenuItem = new JCheckBoxMenuItem();
        JSeparator jSeparator1 = new JSeparator();
        JMenuItem cascadeMenuItem = new JMenuItem();
        JMenuItem tileHMenuItem = new JMenuItem();
        JMenuItem tileVMenuItem = new JMenuItem();
        JMenuItem tileMenuItem = new JMenuItem();
        JMenuItem nextMenuItem = new JMenuItem();
        JMenuItem previousMenuItem = new JMenuItem();
        JSeparator jSeparator2 = new JSeparator();
        JMenuItem minimizeMenuItem = new JMenuItem();
        JMenuItem minimizeAllMenuItem = new JMenuItem();
        JMenuItem restoreMenuItem = new JMenuItem();
        JMenuItem restoreAllMenuItem = new JMenuItem();
        JMenuItem maximizeMenuItem = new JMenuItem();
        JMenuItem maximizeAllMenuItem = new JMenuItem();
        JMenuItem resetMenuItem = new JMenuItem();
        JMenuItem resetAllMenuItem = new JMenuItem();
        JSeparator jSeparator3 = new JSeparator();
        JMenuItem hideMenuItem = new JMenuItem();
        JMenuItem hideAllMenuItem = new JMenuItem();
        JMenuItem closeMenuItem = new JMenuItem();
        JMenuItem closeAllMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("WindowManager Tester");
        this.getContentPane().add((Component)this.m_desktopPane, "Center");
        fileMenu.setText("File");
        newJInternalFrameMenuItem.setText("Open");
        newJInternalFrameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.newJInternalFrameMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(newJInternalFrameMenuItem);
        countFramesMenuItem.setText("Count Frames");
        countFramesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.countFramesMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(countFramesMenuItem);
        this.showConsoleMenuItem.setText("Show Console");
        this.showConsoleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.showConsoleMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(this.showConsoleMenuItem);
        exitMenuItem.setText("Exit");
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.exitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitMenuItem);
        menuBar.add(fileMenu);
        this.m_windowMenu.setText("Window");
        this.m_outlineDragModeMenuItem.setText("Outline Drag Mode");
        this.m_outlineDragModeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.m_outlineDragModeMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(this.m_outlineDragModeMenuItem);
        this.m_deiconifiablePolicyMenuItem.setText("De-iconify during cascade / tile");
        this.m_deiconifiablePolicyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.m_deiconifiablePolicyMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(this.m_deiconifiablePolicyMenuItem);
        this.autoPositionMenuItem.setText("Auto Position Frames");
        this.autoPositionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.autoPositionMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(this.autoPositionMenuItem);
        this.m_closePolicyMenuItem.setText("Default Close Operation vs Close");
        this.m_closePolicyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.m_closePolicyMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(this.m_closePolicyMenuItem);
        this.m_windowMenu.add(jSeparator1);
        cascadeMenuItem.setText("Cascade");
        cascadeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.cascadeMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(cascadeMenuItem);
        tileHMenuItem.setText("Tile Horizontal");
        tileHMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.tileHMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(tileHMenuItem);
        tileVMenuItem.setText("Tile Vertical");
        tileVMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.tileVMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(tileVMenuItem);
        tileMenuItem.setText("Tile");
        tileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.tileMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(tileMenuItem);
        nextMenuItem.setText("Next Window");
        nextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.nextMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(nextMenuItem);
        previousMenuItem.setText("Previous Window");
        previousMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.previousMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(previousMenuItem);
        this.m_windowMenu.add(jSeparator2);
        minimizeMenuItem.setText("Minimize");
        minimizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.minimizeMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(minimizeMenuItem);
        minimizeAllMenuItem.setText("Minimize All");
        minimizeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.minimizeAllMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(minimizeAllMenuItem);
        restoreMenuItem.setText("Restore");
        restoreMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.restoreMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(restoreMenuItem);
        restoreAllMenuItem.setText("Restore All");
        restoreAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.restoreAllMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(restoreAllMenuItem);
        maximizeMenuItem.setText("Maximize");
        maximizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.maximizeMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(maximizeMenuItem);
        maximizeAllMenuItem.setText("Maximize All");
        maximizeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.maximizeAllMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(maximizeAllMenuItem);
        resetMenuItem.setText("Reset Window");
        resetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.resetMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(resetMenuItem);
        resetAllMenuItem.setText("Reset All Windows");
        resetAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.resetAllMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(resetAllMenuItem);
        this.m_windowMenu.add(jSeparator3);
        hideMenuItem.setText("Hide");
        hideMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.hideMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(hideMenuItem);
        hideAllMenuItem.setText("Hide All");
        hideAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.hideAllMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(hideAllMenuItem);
        closeMenuItem.setText("Close");
        closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.closeMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(closeMenuItem);
        closeAllMenuItem.setText("Close All");
        closeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDesktopTester.this.closeAllMenuItemActionPerformed(evt);
            }
        });
        this.m_windowMenu.add(closeAllMenuItem);
        menuBar.add(this.m_windowMenu);
        this.setJMenuBar(menuBar);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 800) / 2, (screenSize.height - 600) / 2, 800, 600);
    }

    private void showConsoleMenuItemActionPerformed(ActionEvent evt) {
        this.m_consoleInternalFrame.setVisible(true);
    }

    private void autoPositionMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.setAutoPositionPolicy(this.autoPositionMenuItem.isSelected());
    }

    private void m_closePolicyMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.setClosePolicy(this.m_closePolicyMenuItem.isSelected());
    }

    private void hideAllMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.hideAll();
    }

    private void m_outlineDragModeMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.setOutlineDragMode(this.m_outlineDragModeMenuItem.isSelected());
    }

    private void resetAllMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.resetAll();
    }

    private void resetMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.reset();
    }

    private void maximizeAllMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.maximizeAll();
    }

    private void restoreAllMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.restoreAll();
    }

    private void countFramesMenuItemActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "All Frames: " + this.m_windowManager.countFrames() + " Visible Frames: " + this.m_windowManager.countVisibleFrames(), "Info", 1);
        System.out.println("All Frames: " + this.m_windowManager.countFrames() + " Visible Frames: " + this.m_windowManager.countVisibleFrames());
    }

    private void m_deiconifiablePolicyMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.setDeiconifiablePolicy(this.m_deiconifiablePolicyMenuItem.isSelected());
    }

    private void maximizeMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.maximize();
    }

    private void restoreMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.restore();
    }

    private void minimizeAllMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.minimizeAll();
    }

    private void minimizeMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.minimize();
    }

    private void closeAllMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.closeAll();
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.close();
    }

    private void hideMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.hide();
    }

    private void previousMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.selectPrevious();
    }

    private void nextMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.selectNext();
    }

    private void tileMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.tile();
    }

    private void tileVMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.tileVertically();
    }

    private void tileHMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.tileHorizontally();
    }

    private void cascadeMenuItemActionPerformed(ActionEvent evt) {
        this.m_windowManager.cascade();
    }

    private void newJInternalFrameMenuItemActionPerformed(ActionEvent evt) {
        JInternalFrameGenerator gen = new JInternalFrameGenerator((Frame)new JFrame(), true);
        gen.setVisible(true);
        int ret = gen.getReturnStatus();
        if (ret == 1) {
            JInternalFrame jif = gen.getNewFrame();
            this.m_desktopPane.add((Component)jif, JLayeredPane.DEFAULT_LAYER);
            jif.toFront();
        }
        System.out.println("Created new JInternalFrame");
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.out.println("Exiting...");
        System.exit(0);
    }

    private static void init_lnf() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JIConsole.getConsole().updateLNF();
        }
        catch (Exception e) {
            System.err.println("Cannot initialize the look & feel");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JDesktopTester.init_lnf();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JDesktopTester().setVisible(true);
            }
        });
    }
}

