# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ApplicationServerConfiguration(_serialization.Model):
    """Gets or sets the application server configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar subnet_id: The subnet id. Required.
    :vartype subnet_id: str
    :ivar virtual_machine_configuration: Gets or sets the virtual machine configuration. Required.
    :vartype virtual_machine_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineConfiguration
    :ivar instance_count: The number of app server instances. Required.
    :vartype instance_count: int
    """

    _validation = {
        "subnet_id": {"required": True},
        "virtual_machine_configuration": {"required": True},
        "instance_count": {"required": True},
    }

    _attribute_map = {
        "subnet_id": {"key": "subnetId", "type": "str"},
        "virtual_machine_configuration": {"key": "virtualMachineConfiguration", "type": "VirtualMachineConfiguration"},
        "instance_count": {"key": "instanceCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        subnet_id: str,
        virtual_machine_configuration: "_models.VirtualMachineConfiguration",
        instance_count: int,
        **kwargs: Any
    ) -> None:
        """
        :keyword subnet_id: The subnet id. Required.
        :paramtype subnet_id: str
        :keyword virtual_machine_configuration: Gets or sets the virtual machine configuration.
         Required.
        :paramtype virtual_machine_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineConfiguration
        :keyword instance_count: The number of app server instances. Required.
        :paramtype instance_count: int
        """
        super().__init__(**kwargs)
        self.subnet_id = subnet_id
        self.virtual_machine_configuration = virtual_machine_configuration
        self.instance_count = instance_count


class ApplicationServerFullResourceNames(_serialization.Model):
    """The full resource names object for application layer resources. The number of entries in this
    list should be equal to the number VMs to be created for application layer.

    :ivar virtual_machines: The list of virtual machine naming details.
    :vartype virtual_machines:
     list[~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineResourceNames]
    :ivar availability_set_name: The full name for availability set. In case name is not provided,
     it will be defaulted to {SID}-App-AvSet.
    :vartype availability_set_name: str
    """

    _attribute_map = {
        "virtual_machines": {"key": "virtualMachines", "type": "[VirtualMachineResourceNames]"},
        "availability_set_name": {"key": "availabilitySetName", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_machines: Optional[List["_models.VirtualMachineResourceNames"]] = None,
        availability_set_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_machines: The list of virtual machine naming details.
        :paramtype virtual_machines:
         list[~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineResourceNames]
        :keyword availability_set_name: The full name for availability set. In case name is not
         provided, it will be defaulted to {SID}-App-AvSet.
        :paramtype availability_set_name: str
        """
        super().__init__(**kwargs)
        self.virtual_machines = virtual_machines
        self.availability_set_name = availability_set_name


class ApplicationServerVmDetails(_serialization.Model):
    """The Application Server VM Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Defines the type of application server VM. Known values are: "Active", "Standby",
     and "Unknown".
    :vartype type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.ApplicationServerVirtualMachineType
    :ivar virtual_machine_id:
    :vartype virtual_machine_id: str
    :ivar storage_details: Storage details of all the Storage Accounts attached to the App Virtual
     Machine. For e.g. NFS on AFS Shared Storage.
    :vartype storage_details:
     list[~azure.mgmt.workloadssapvirtualinstance.models.StorageInformation]
    """

    _validation = {
        "type": {"readonly": True},
        "virtual_machine_id": {"readonly": True},
        "storage_details": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "storage_details": {"key": "storageDetails", "type": "[StorageInformation]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.virtual_machine_id = None
        self.storage_details = None


class CentralServerConfiguration(_serialization.Model):
    """Gets or sets the central server configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar subnet_id: The subnet id. Required.
    :vartype subnet_id: str
    :ivar virtual_machine_configuration: Gets or sets the virtual machine configuration. Required.
    :vartype virtual_machine_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineConfiguration
    :ivar instance_count: The number of central server VMs. Required.
    :vartype instance_count: int
    """

    _validation = {
        "subnet_id": {"required": True},
        "virtual_machine_configuration": {"required": True},
        "instance_count": {"required": True},
    }

    _attribute_map = {
        "subnet_id": {"key": "subnetId", "type": "str"},
        "virtual_machine_configuration": {"key": "virtualMachineConfiguration", "type": "VirtualMachineConfiguration"},
        "instance_count": {"key": "instanceCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        subnet_id: str,
        virtual_machine_configuration: "_models.VirtualMachineConfiguration",
        instance_count: int,
        **kwargs: Any
    ) -> None:
        """
        :keyword subnet_id: The subnet id. Required.
        :paramtype subnet_id: str
        :keyword virtual_machine_configuration: Gets or sets the virtual machine configuration.
         Required.
        :paramtype virtual_machine_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineConfiguration
        :keyword instance_count: The number of central server VMs. Required.
        :paramtype instance_count: int
        """
        super().__init__(**kwargs)
        self.subnet_id = subnet_id
        self.virtual_machine_configuration = virtual_machine_configuration
        self.instance_count = instance_count


class CentralServerFullResourceNames(_serialization.Model):
    """The full resource names object for central server layer resources.

    :ivar virtual_machines: The list of names for all ASCS virtual machines to be deployed. The
     number of entries in this list should be equal to the number VMs to be created for ASCS layer.
     At maximum, there can be two virtual machines at this layer: ASCS and ERS.
    :vartype virtual_machines:
     list[~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineResourceNames]
    :ivar availability_set_name: The full name for availability set. In case name is not provided,
     it will be defaulted to {SID}-ASCS-AvSet.
    :vartype availability_set_name: str
    :ivar load_balancer: The resource names object for load balancer and related resources.
    :vartype load_balancer:
     ~azure.mgmt.workloadssapvirtualinstance.models.LoadBalancerResourceNames
    """

    _validation = {
        "virtual_machines": {"max_items": 2, "min_items": 0},
    }

    _attribute_map = {
        "virtual_machines": {"key": "virtualMachines", "type": "[VirtualMachineResourceNames]"},
        "availability_set_name": {"key": "availabilitySetName", "type": "str"},
        "load_balancer": {"key": "loadBalancer", "type": "LoadBalancerResourceNames"},
    }

    def __init__(
        self,
        *,
        virtual_machines: Optional[List["_models.VirtualMachineResourceNames"]] = None,
        availability_set_name: Optional[str] = None,
        load_balancer: Optional["_models.LoadBalancerResourceNames"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_machines: The list of names for all ASCS virtual machines to be deployed. The
         number of entries in this list should be equal to the number VMs to be created for ASCS layer.
         At maximum, there can be two virtual machines at this layer: ASCS and ERS.
        :paramtype virtual_machines:
         list[~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineResourceNames]
        :keyword availability_set_name: The full name for availability set. In case name is not
         provided, it will be defaulted to {SID}-ASCS-AvSet.
        :paramtype availability_set_name: str
        :keyword load_balancer: The resource names object for load balancer and related resources.
        :paramtype load_balancer:
         ~azure.mgmt.workloadssapvirtualinstance.models.LoadBalancerResourceNames
        """
        super().__init__(**kwargs)
        self.virtual_machines = virtual_machines
        self.availability_set_name = availability_set_name
        self.load_balancer = load_balancer


class CentralServerVmDetails(_serialization.Model):
    """The SAP Central Services Instance VM details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Defines the type of central server VM. Known values are: "Primary", "Secondary",
     "Unknown", "ASCS", "ERSInactive", "ERS", and "Standby".
    :vartype type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.CentralServerVirtualMachineType
    :ivar virtual_machine_id:
    :vartype virtual_machine_id: str
    :ivar storage_details: Storage details of all the Storage Accounts attached to the ASCS Virtual
     Machine. For e.g. NFS on AFS Shared Storage.
    :vartype storage_details:
     list[~azure.mgmt.workloadssapvirtualinstance.models.StorageInformation]
    """

    _validation = {
        "type": {"readonly": True},
        "virtual_machine_id": {"readonly": True},
        "storage_details": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "storage_details": {"key": "storageDetails", "type": "[StorageInformation]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.virtual_machine_id = None
        self.storage_details = None


class FileShareConfiguration(_serialization.Model):
    """File Share configuration details, populated with information on storage configuration mounted
    on the VIS. The createAndMount option is selected in case of missing input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CreateAndMountFileShareConfiguration, MountFileShareConfiguration, SkipFileShareConfiguration

    All required parameters must be populated in order to send to Azure.

    :ivar configuration_type: The type of file share config. Required. Known values are: "Skip",
     "CreateAndMount", and "Mount".
    :vartype configuration_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.ConfigurationType
    """

    _validation = {
        "configuration_type": {"required": True},
    }

    _attribute_map = {
        "configuration_type": {"key": "configurationType", "type": "str"},
    }

    _subtype_map = {
        "configuration_type": {
            "CreateAndMount": "CreateAndMountFileShareConfiguration",
            "Mount": "MountFileShareConfiguration",
            "Skip": "SkipFileShareConfiguration",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.configuration_type: Optional[str] = None


class CreateAndMountFileShareConfiguration(FileShareConfiguration):
    """Gets or sets the file share configuration where the transport directory fileshare is created
    and mounted as a part of the create infra flow. Please pre-create the resource group you intend
    to place the transport directory in. The storage account and fileshare will be auto-created by
    the ACSS and doesn't need to be pre-created.

    All required parameters must be populated in order to send to Azure.

    :ivar configuration_type: The type of file share config. Required. Known values are: "Skip",
     "CreateAndMount", and "Mount".
    :vartype configuration_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.ConfigurationType
    :ivar resource_group: The name of transport file share resource group. This should be pre
     created by the customer. The app rg is used in case of missing input.
    :vartype resource_group: str
    :ivar storage_account_name: The name of file share storage account name . A custom name is used
     in case of missing input.
    :vartype storage_account_name: str
    """

    _validation = {
        "configuration_type": {"required": True},
    }

    _attribute_map = {
        "configuration_type": {"key": "configurationType", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "storage_account_name": {"key": "storageAccountName", "type": "str"},
    }

    def __init__(
        self, *, resource_group: Optional[str] = None, storage_account_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_group: The name of transport file share resource group. This should be pre
         created by the customer. The app rg is used in case of missing input.
        :paramtype resource_group: str
        :keyword storage_account_name: The name of file share storage account name . A custom name is
         used in case of missing input.
        :paramtype storage_account_name: str
        """
        super().__init__(**kwargs)
        self.configuration_type: str = "CreateAndMount"
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name


class DatabaseConfiguration(_serialization.Model):
    """Gets or sets the database configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar database_type: The database type. Known values are: "HANA" and "DB2".
    :vartype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
    :ivar subnet_id: The subnet id. Required.
    :vartype subnet_id: str
    :ivar virtual_machine_configuration: Gets or sets the virtual machine configuration. Required.
    :vartype virtual_machine_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineConfiguration
    :ivar instance_count: The number of database VMs. Required.
    :vartype instance_count: int
    :ivar disk_configuration: Gets or sets the disk configuration.
    :vartype disk_configuration: ~azure.mgmt.workloadssapvirtualinstance.models.DiskConfiguration
    """

    _validation = {
        "subnet_id": {"required": True},
        "virtual_machine_configuration": {"required": True},
        "instance_count": {"required": True},
    }

    _attribute_map = {
        "database_type": {"key": "databaseType", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "virtual_machine_configuration": {"key": "virtualMachineConfiguration", "type": "VirtualMachineConfiguration"},
        "instance_count": {"key": "instanceCount", "type": "int"},
        "disk_configuration": {"key": "diskConfiguration", "type": "DiskConfiguration"},
    }

    def __init__(
        self,
        *,
        subnet_id: str,
        virtual_machine_configuration: "_models.VirtualMachineConfiguration",
        instance_count: int,
        database_type: Optional[Union[str, "_models.SAPDatabaseType"]] = None,
        disk_configuration: Optional["_models.DiskConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword database_type: The database type. Known values are: "HANA" and "DB2".
        :paramtype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
        :keyword subnet_id: The subnet id. Required.
        :paramtype subnet_id: str
        :keyword virtual_machine_configuration: Gets or sets the virtual machine configuration.
         Required.
        :paramtype virtual_machine_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineConfiguration
        :keyword instance_count: The number of database VMs. Required.
        :paramtype instance_count: int
        :keyword disk_configuration: Gets or sets the disk configuration.
        :paramtype disk_configuration: ~azure.mgmt.workloadssapvirtualinstance.models.DiskConfiguration
        """
        super().__init__(**kwargs)
        self.database_type = database_type
        self.subnet_id = subnet_id
        self.virtual_machine_configuration = virtual_machine_configuration
        self.instance_count = instance_count
        self.disk_configuration = disk_configuration


class DatabaseServerFullResourceNames(_serialization.Model):
    """The full resource names object for database layer resources. The number of entries in this list
    should be equal to the number VMs to be created for database layer.

    :ivar virtual_machines: The list of virtual machine naming details.
    :vartype virtual_machines:
     list[~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineResourceNames]
    :ivar availability_set_name: The full name for availability set. In case name is not provided,
     it will be defaulted to {SID}-DB-AvSet.
    :vartype availability_set_name: str
    :ivar load_balancer: The resource names object for load balancer and related resources.
    :vartype load_balancer:
     ~azure.mgmt.workloadssapvirtualinstance.models.LoadBalancerResourceNames
    """

    _validation = {
        "virtual_machines": {"max_items": 2, "min_items": 0},
    }

    _attribute_map = {
        "virtual_machines": {"key": "virtualMachines", "type": "[VirtualMachineResourceNames]"},
        "availability_set_name": {"key": "availabilitySetName", "type": "str"},
        "load_balancer": {"key": "loadBalancer", "type": "LoadBalancerResourceNames"},
    }

    def __init__(
        self,
        *,
        virtual_machines: Optional[List["_models.VirtualMachineResourceNames"]] = None,
        availability_set_name: Optional[str] = None,
        load_balancer: Optional["_models.LoadBalancerResourceNames"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_machines: The list of virtual machine naming details.
        :paramtype virtual_machines:
         list[~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineResourceNames]
        :keyword availability_set_name: The full name for availability set. In case name is not
         provided, it will be defaulted to {SID}-DB-AvSet.
        :paramtype availability_set_name: str
        :keyword load_balancer: The resource names object for load balancer and related resources.
        :paramtype load_balancer:
         ~azure.mgmt.workloadssapvirtualinstance.models.LoadBalancerResourceNames
        """
        super().__init__(**kwargs)
        self.virtual_machines = virtual_machines
        self.availability_set_name = availability_set_name
        self.load_balancer = load_balancer


class DatabaseVmDetails(_serialization.Model):
    """Database VM details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar virtual_machine_id:
    :vartype virtual_machine_id: str
    :ivar status: Defines the SAP Instance status. Known values are: "Starting", "Running",
     "Stopping", "Offline", "PartiallyRunning", "Unavailable", and "SoftShutdown".
    :vartype status: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceStatus
    :ivar storage_details: Storage details of all the Storage Accounts attached to the Database
     Virtual Machine. For e.g. NFS on AFS Shared Storage.
    :vartype storage_details:
     list[~azure.mgmt.workloadssapvirtualinstance.models.StorageInformation]
    """

    _validation = {
        "virtual_machine_id": {"readonly": True},
        "status": {"readonly": True},
        "storage_details": {"readonly": True},
    }

    _attribute_map = {
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "storage_details": {"key": "storageDetails", "type": "[StorageInformation]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.virtual_machine_id = None
        self.status = None
        self.storage_details = None


class DeployerVmPackages(_serialization.Model):
    """Defines the url and storage account ID where deployer VM packages are uploaded.

    :ivar url: The URL to the deployer VM packages file.
    :vartype url: str
    :ivar storage_account_id: The deployer VM packages storage account id.
    :vartype storage_account_id: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
    }

    def __init__(self, *, url: Optional[str] = None, storage_account_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword url: The URL to the deployer VM packages file.
        :paramtype url: str
        :keyword storage_account_id: The deployer VM packages storage account id.
        :paramtype storage_account_id: str
        """
        super().__init__(**kwargs)
        self.url = url
        self.storage_account_id = storage_account_id


class SAPConfiguration(_serialization.Model):
    """The SAP Configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DeploymentConfiguration, DeploymentWithOSConfiguration, DiscoveryConfiguration

    All required parameters must be populated in order to send to Azure.

    :ivar configuration_type: The configuration Type. Required. Known values are: "Deployment",
     "Discovery", and "DeploymentWithOSConfig".
    :vartype configuration_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPConfigurationType
    """

    _validation = {
        "configuration_type": {"required": True},
    }

    _attribute_map = {
        "configuration_type": {"key": "configurationType", "type": "str"},
    }

    _subtype_map = {
        "configuration_type": {
            "Deployment": "DeploymentConfiguration",
            "DeploymentWithOSConfig": "DeploymentWithOSConfiguration",
            "Discovery": "DiscoveryConfiguration",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.configuration_type: Optional[str] = None


class DeploymentConfiguration(SAPConfiguration):
    """Deployment Configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar configuration_type: The configuration Type. Required. Known values are: "Deployment",
     "Discovery", and "DeploymentWithOSConfig".
    :vartype configuration_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPConfigurationType
    :ivar app_location: The geo-location where the SAP system is to be created.
    :vartype app_location: str
    :ivar infrastructure_configuration: The infrastructure configuration.
    :vartype infrastructure_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.InfrastructureConfiguration
    :ivar software_configuration: The software configuration.
    :vartype software_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.SoftwareConfiguration
    """

    _validation = {
        "configuration_type": {"required": True},
    }

    _attribute_map = {
        "configuration_type": {"key": "configurationType", "type": "str"},
        "app_location": {"key": "appLocation", "type": "str"},
        "infrastructure_configuration": {"key": "infrastructureConfiguration", "type": "InfrastructureConfiguration"},
        "software_configuration": {"key": "softwareConfiguration", "type": "SoftwareConfiguration"},
    }

    def __init__(
        self,
        *,
        app_location: Optional[str] = None,
        infrastructure_configuration: Optional["_models.InfrastructureConfiguration"] = None,
        software_configuration: Optional["_models.SoftwareConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword app_location: The geo-location where the SAP system is to be created.
        :paramtype app_location: str
        :keyword infrastructure_configuration: The infrastructure configuration.
        :paramtype infrastructure_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.InfrastructureConfiguration
        :keyword software_configuration: The software configuration.
        :paramtype software_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.SoftwareConfiguration
        """
        super().__init__(**kwargs)
        self.configuration_type: str = "Deployment"
        self.app_location = app_location
        self.infrastructure_configuration = infrastructure_configuration
        self.software_configuration = software_configuration


class DeploymentWithOSConfiguration(SAPConfiguration):
    """Deployment along with OS Configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar configuration_type: The configuration Type. Required. Known values are: "Deployment",
     "Discovery", and "DeploymentWithOSConfig".
    :vartype configuration_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPConfigurationType
    :ivar app_location: The geo-location where the SAP system is to be created.
    :vartype app_location: str
    :ivar infrastructure_configuration: The infrastructure configuration.
    :vartype infrastructure_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.InfrastructureConfiguration
    :ivar software_configuration: The software configuration.
    :vartype software_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.SoftwareConfiguration
    :ivar os_sap_configuration: The OS and SAP configuration.
    :vartype os_sap_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.OsSapConfiguration
    """

    _validation = {
        "configuration_type": {"required": True},
    }

    _attribute_map = {
        "configuration_type": {"key": "configurationType", "type": "str"},
        "app_location": {"key": "appLocation", "type": "str"},
        "infrastructure_configuration": {"key": "infrastructureConfiguration", "type": "InfrastructureConfiguration"},
        "software_configuration": {"key": "softwareConfiguration", "type": "SoftwareConfiguration"},
        "os_sap_configuration": {"key": "osSapConfiguration", "type": "OsSapConfiguration"},
    }

    def __init__(
        self,
        *,
        app_location: Optional[str] = None,
        infrastructure_configuration: Optional["_models.InfrastructureConfiguration"] = None,
        software_configuration: Optional["_models.SoftwareConfiguration"] = None,
        os_sap_configuration: Optional["_models.OsSapConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword app_location: The geo-location where the SAP system is to be created.
        :paramtype app_location: str
        :keyword infrastructure_configuration: The infrastructure configuration.
        :paramtype infrastructure_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.InfrastructureConfiguration
        :keyword software_configuration: The software configuration.
        :paramtype software_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.SoftwareConfiguration
        :keyword os_sap_configuration: The OS and SAP configuration.
        :paramtype os_sap_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.OsSapConfiguration
        """
        super().__init__(**kwargs)
        self.configuration_type: str = "DeploymentWithOSConfig"
        self.app_location = app_location
        self.infrastructure_configuration = infrastructure_configuration
        self.software_configuration = software_configuration
        self.os_sap_configuration = os_sap_configuration


class DiscoveryConfiguration(SAPConfiguration):
    """Discovery Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar configuration_type: The configuration Type. Required. Known values are: "Deployment",
     "Discovery", and "DeploymentWithOSConfig".
    :vartype configuration_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPConfigurationType
    :ivar central_server_vm_id: The virtual machine ID of the Central Server.
    :vartype central_server_vm_id: str
    :ivar managed_rg_storage_account_name: The custom storage account name for the storage account
     created by the service in the managed resource group created as part of VIS
     deployment.:code:`<br>`:code:`<br>`Refer to the storage account naming rules `here
     <https://learn.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftstorage>`_.:code:`<br>`:code:`<br>`If
     not provided, the service will create the storage account with a random name.
    :vartype managed_rg_storage_account_name: str
    :ivar app_location: The geo-location where the SAP system exists.
    :vartype app_location: str
    """

    _validation = {
        "configuration_type": {"required": True},
        "managed_rg_storage_account_name": {"max_length": 24, "min_length": 3},
        "app_location": {"readonly": True},
    }

    _attribute_map = {
        "configuration_type": {"key": "configurationType", "type": "str"},
        "central_server_vm_id": {"key": "centralServerVmId", "type": "str"},
        "managed_rg_storage_account_name": {"key": "managedRgStorageAccountName", "type": "str"},
        "app_location": {"key": "appLocation", "type": "str"},
    }

    def __init__(
        self,
        *,
        central_server_vm_id: Optional[str] = None,
        managed_rg_storage_account_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword central_server_vm_id: The virtual machine ID of the Central Server.
        :paramtype central_server_vm_id: str
        :keyword managed_rg_storage_account_name: The custom storage account name for the storage
         account created by the service in the managed resource group created as part of VIS
         deployment.:code:`<br>`:code:`<br>`Refer to the storage account naming rules `here
         <https://learn.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftstorage>`_.:code:`<br>`:code:`<br>`If
         not provided, the service will create the storage account with a random name.
        :paramtype managed_rg_storage_account_name: str
        """
        super().__init__(**kwargs)
        self.configuration_type: str = "Discovery"
        self.central_server_vm_id = central_server_vm_id
        self.managed_rg_storage_account_name = managed_rg_storage_account_name
        self.app_location = None


class DiskConfiguration(_serialization.Model):
    """The Disk Configuration Details.

    :ivar disk_volume_configurations: The disk configuration for the db volume. For HANA, Required
     volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume :
     ['backup'].
    :vartype disk_volume_configurations: dict[str,
     ~azure.mgmt.workloadssapvirtualinstance.models.DiskVolumeConfiguration]
    """

    _attribute_map = {
        "disk_volume_configurations": {"key": "diskVolumeConfigurations", "type": "{DiskVolumeConfiguration}"},
    }

    def __init__(
        self,
        *,
        disk_volume_configurations: Optional[Dict[str, "_models.DiskVolumeConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_volume_configurations: The disk configuration for the db volume. For HANA,
         Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume
         : ['backup'].
        :paramtype disk_volume_configurations: dict[str,
         ~azure.mgmt.workloadssapvirtualinstance.models.DiskVolumeConfiguration]
        """
        super().__init__(**kwargs)
        self.disk_volume_configurations = disk_volume_configurations


class DiskDetails(_serialization.Model):
    """The supported disk size details for a disk type.

    :ivar sku: The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS,
     Premium_ZRS.
    :vartype sku: ~azure.mgmt.workloadssapvirtualinstance.models.DiskSku
    :ivar size_gb: The disk size in GB.
    :vartype size_gb: int
    :ivar minimum_supported_disk_count: The minimum supported disk count.
    :vartype minimum_supported_disk_count: int
    :ivar maximum_supported_disk_count: The maximum supported disk count.
    :vartype maximum_supported_disk_count: int
    :ivar iops_read_write: The disk Iops.
    :vartype iops_read_write: int
    :ivar mbps_read_write: The disk provisioned throughput in MBps.
    :vartype mbps_read_write: int
    :ivar disk_tier: The disk tier, e.g. P10, E10.
    :vartype disk_tier: str
    """

    _attribute_map = {
        "sku": {"key": "sku", "type": "DiskSku"},
        "size_gb": {"key": "sizeGB", "type": "int"},
        "minimum_supported_disk_count": {"key": "minimumSupportedDiskCount", "type": "int"},
        "maximum_supported_disk_count": {"key": "maximumSupportedDiskCount", "type": "int"},
        "iops_read_write": {"key": "iopsReadWrite", "type": "int"},
        "mbps_read_write": {"key": "mbpsReadWrite", "type": "int"},
        "disk_tier": {"key": "diskTier", "type": "str"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.DiskSku"] = None,
        size_gb: Optional[int] = None,
        minimum_supported_disk_count: Optional[int] = None,
        maximum_supported_disk_count: Optional[int] = None,
        iops_read_write: Optional[int] = None,
        mbps_read_write: Optional[int] = None,
        disk_tier: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS,
         Premium_ZRS.
        :paramtype sku: ~azure.mgmt.workloadssapvirtualinstance.models.DiskSku
        :keyword size_gb: The disk size in GB.
        :paramtype size_gb: int
        :keyword minimum_supported_disk_count: The minimum supported disk count.
        :paramtype minimum_supported_disk_count: int
        :keyword maximum_supported_disk_count: The maximum supported disk count.
        :paramtype maximum_supported_disk_count: int
        :keyword iops_read_write: The disk Iops.
        :paramtype iops_read_write: int
        :keyword mbps_read_write: The disk provisioned throughput in MBps.
        :paramtype mbps_read_write: int
        :keyword disk_tier: The disk tier, e.g. P10, E10.
        :paramtype disk_tier: str
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.size_gb = size_gb
        self.minimum_supported_disk_count = minimum_supported_disk_count
        self.maximum_supported_disk_count = maximum_supported_disk_count
        self.iops_read_write = iops_read_write
        self.mbps_read_write = mbps_read_write
        self.disk_tier = disk_tier


class DiskSku(_serialization.Model):
    """The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS, Premium_ZRS.

    :ivar name: Defines the disk sku name. Known values are: "Standard_LRS", "Premium_LRS",
     "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype name: str or ~azure.mgmt.workloadssapvirtualinstance.models.DiskSkuName
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[Union[str, "_models.DiskSkuName"]] = None, **kwargs: Any) -> None:
        """
        :keyword name: Defines the disk sku name. Known values are: "Standard_LRS", "Premium_LRS",
         "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", "StandardSSD_ZRS", and "PremiumV2_LRS".
        :paramtype name: str or ~azure.mgmt.workloadssapvirtualinstance.models.DiskSkuName
        """
        super().__init__(**kwargs)
        self.name = name


class DiskVolumeConfiguration(_serialization.Model):
    """The disk configuration required for the selected volume.

    :ivar count: The total number of disks required for the concerned volume.
    :vartype count: int
    :ivar size_gb: The disk size in GB.
    :vartype size_gb: int
    :ivar sku: The disk SKU details.
    :vartype sku: ~azure.mgmt.workloadssapvirtualinstance.models.DiskSku
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "size_gb": {"key": "sizeGB", "type": "int"},
        "sku": {"key": "sku", "type": "DiskSku"},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        size_gb: Optional[int] = None,
        sku: Optional["_models.DiskSku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: The total number of disks required for the concerned volume.
        :paramtype count: int
        :keyword size_gb: The disk size in GB.
        :paramtype size_gb: int
        :keyword sku: The disk SKU details.
        :paramtype sku: ~azure.mgmt.workloadssapvirtualinstance.models.DiskSku
        """
        super().__init__(**kwargs)
        self.count = count
        self.size_gb = size_gb
        self.sku = sku


class EnqueueReplicationServerProperties(_serialization.Model):
    """Defines the SAP Enqueue Replication Server (ERS) properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ers_version: Defines the type of Enqueue Replication Server. Known values are:
     "EnqueueReplicator1" and "EnqueueReplicator2".
    :vartype ers_version: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.EnqueueReplicationServerType
    :ivar instance_no: ERS Instance Number.
    :vartype instance_no: str
    :ivar hostname: ERS SAP Hostname.
    :vartype hostname: str
    :ivar kernel_version: ERS SAP Kernel Version.
    :vartype kernel_version: str
    :ivar kernel_patch: ERS SAP Kernel Patch level.
    :vartype kernel_patch: str
    :ivar ip_address: ERS SAP IP Address.
    :vartype ip_address: str
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    """

    _validation = {
        "ers_version": {"readonly": True},
        "instance_no": {"readonly": True},
        "hostname": {"readonly": True},
        "kernel_version": {"readonly": True},
        "kernel_patch": {"readonly": True},
        "ip_address": {"readonly": True},
        "health": {"readonly": True},
    }

    _attribute_map = {
        "ers_version": {"key": "ersVersion", "type": "str"},
        "instance_no": {"key": "instanceNo", "type": "str"},
        "hostname": {"key": "hostname", "type": "str"},
        "kernel_version": {"key": "kernelVersion", "type": "str"},
        "kernel_patch": {"key": "kernelPatch", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "health": {"key": "health", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.ers_version = None
        self.instance_no = None
        self.hostname = None
        self.kernel_version = None
        self.kernel_patch = None
        self.ip_address = None
        self.health = None


class EnqueueServerProperties(_serialization.Model):
    """Defines the SAP Enqueue Server properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hostname: Enqueue Server SAP Hostname.
    :vartype hostname: str
    :ivar ip_address: Enqueue Server SAP IP Address.
    :vartype ip_address: str
    :ivar port: Enqueue Server Port.
    :vartype port: int
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    """

    _validation = {
        "hostname": {"readonly": True},
        "ip_address": {"readonly": True},
        "port": {"readonly": True},
        "health": {"readonly": True},
    }

    _attribute_map = {
        "hostname": {"key": "hostname", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "health": {"key": "health", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.hostname = None
        self.ip_address = None
        self.port = None
        self.health = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDefinition(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.workloadssapvirtualinstance.models.ErrorDefinition]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDefinition]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.workloadssapvirtualinstance.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.workloadssapvirtualinstance.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.workloadssapvirtualinstance.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.workloadssapvirtualinstance.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class SoftwareConfiguration(_serialization.Model):
    """The SAP Software configuration Input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExternalInstallationSoftwareConfiguration, SAPInstallWithoutOSConfigSoftwareConfiguration,
    ServiceInitiatedSoftwareConfiguration

    All required parameters must be populated in order to send to Azure.

    :ivar software_installation_type: The SAP software installation Type. Required. Known values
     are: "ServiceInitiated", "SAPInstallWithoutOSConfig", and "External".
    :vartype software_installation_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPSoftwareInstallationType
    """

    _validation = {
        "software_installation_type": {"required": True},
    }

    _attribute_map = {
        "software_installation_type": {"key": "softwareInstallationType", "type": "str"},
    }

    _subtype_map = {
        "software_installation_type": {
            "External": "ExternalInstallationSoftwareConfiguration",
            "SAPInstallWithoutOSConfig": "SAPInstallWithoutOSConfigSoftwareConfiguration",
            "ServiceInitiated": "ServiceInitiatedSoftwareConfiguration",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.software_installation_type: Optional[str] = None


class ExternalInstallationSoftwareConfiguration(SoftwareConfiguration):
    """The SAP Software configuration Input when the software is installed externally outside the
    service.

    All required parameters must be populated in order to send to Azure.

    :ivar software_installation_type: The SAP software installation Type. Required. Known values
     are: "ServiceInitiated", "SAPInstallWithoutOSConfig", and "External".
    :vartype software_installation_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPSoftwareInstallationType
    :ivar central_server_vm_id: The resource ID of the virtual machine containing the central
     server instance.
    :vartype central_server_vm_id: str
    """

    _validation = {
        "software_installation_type": {"required": True},
    }

    _attribute_map = {
        "software_installation_type": {"key": "softwareInstallationType", "type": "str"},
        "central_server_vm_id": {"key": "centralServerVmId", "type": "str"},
    }

    def __init__(self, *, central_server_vm_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword central_server_vm_id: The resource ID of the virtual machine containing the central
         server instance.
        :paramtype central_server_vm_id: str
        """
        super().__init__(**kwargs)
        self.software_installation_type: str = "External"
        self.central_server_vm_id = central_server_vm_id


class GatewayServerProperties(_serialization.Model):
    """Defines the SAP Gateway Server properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar port: Gateway Port.
    :vartype port: int
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    """

    _validation = {
        "port": {"readonly": True},
        "health": {"readonly": True},
    }

    _attribute_map = {
        "port": {"key": "port", "type": "int"},
        "health": {"key": "health", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.port = None
        self.health = None


class HighAvailabilityConfiguration(_serialization.Model):
    """Gets or sets the high availability configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar high_availability_type: The high availability type. Required. Known values are:
     "AvailabilitySet" and "AvailabilityZone".
    :vartype high_availability_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPHighAvailabilityType
    """

    _validation = {
        "high_availability_type": {"required": True},
    }

    _attribute_map = {
        "high_availability_type": {"key": "highAvailabilityType", "type": "str"},
    }

    def __init__(self, *, high_availability_type: Union[str, "_models.SAPHighAvailabilityType"], **kwargs: Any) -> None:
        """
        :keyword high_availability_type: The high availability type. Required. Known values are:
         "AvailabilitySet" and "AvailabilityZone".
        :paramtype high_availability_type: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPHighAvailabilityType
        """
        super().__init__(**kwargs)
        self.high_availability_type = high_availability_type


class HighAvailabilitySoftwareConfiguration(_serialization.Model):
    """Gets or sets the HA software configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar fencing_client_id: The fencing client id. Required.
    :vartype fencing_client_id: str
    :ivar fencing_client_password: The fencing client id secret/password. The secret should never
     expire. This will be used pacemaker to start/stop the cluster VMs. Required.
    :vartype fencing_client_password: str
    """

    _validation = {
        "fencing_client_id": {"required": True},
        "fencing_client_password": {"required": True},
    }

    _attribute_map = {
        "fencing_client_id": {"key": "fencingClientId", "type": "str"},
        "fencing_client_password": {"key": "fencingClientPassword", "type": "str"},
    }

    def __init__(self, *, fencing_client_id: str, fencing_client_password: str, **kwargs: Any) -> None:
        """
        :keyword fencing_client_id: The fencing client id. Required.
        :paramtype fencing_client_id: str
        :keyword fencing_client_password: The fencing client id secret/password. The secret should
         never expire. This will be used pacemaker to start/stop the cluster VMs. Required.
        :paramtype fencing_client_password: str
        """
        super().__init__(**kwargs)
        self.fencing_client_id = fencing_client_id
        self.fencing_client_password = fencing_client_password


class ImageReference(_serialization.Model):
    """Specifies information about the image to use. You can specify information about platform
    images, marketplace images, or virtual machine images. This element is required when you want
    to use a platform image, marketplace image, or virtual machine image, but is not used in other
    creation operations. NOTE: Image reference publisher and offer can only be set when you create
    the scale set.

    :ivar publisher: The image publisher.
    :vartype publisher: str
    :ivar offer: Specifies the offer of the platform image or marketplace image used to create the
     virtual machine.
    :vartype offer: str
    :ivar sku: The image SKU.
    :vartype sku: str
    :ivar version: Specifies the version of the platform image or marketplace image used to create
     the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and
     Build are decimal numbers. Specify 'latest' to use the latest version of an image available at
     deploy time. Even if you use 'latest', the VM image will not automatically update after deploy
     time even if a new version becomes available.
    :vartype version: str
    :ivar id: Specifies the ARM resource ID of the Azure Compute Gallery image version used for
     creating ACSS VMs. You will need to provide this input when you choose to deploy virtual
     machines in ACSS with OS image from the Azure Compute gallery.
    :vartype id: str
    """

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher: The image publisher.
        :paramtype publisher: str
        :keyword offer: Specifies the offer of the platform image or marketplace image used to create
         the virtual machine.
        :paramtype offer: str
        :keyword sku: The image SKU.
        :paramtype sku: str
        :keyword version: Specifies the version of the platform image or marketplace image used to
         create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major,
         Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image
         available at deploy time. Even if you use 'latest', the VM image will not automatically update
         after deploy time even if a new version becomes available.
        :paramtype version: str
        :keyword id: Specifies the ARM resource ID of the Azure Compute Gallery image version used for
         creating ACSS VMs. You will need to provide this input when you choose to deploy virtual
         machines in ACSS with OS image from the Azure Compute gallery.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version
        self.id = id


class InfrastructureConfiguration(_serialization.Model):
    """Deploy SAP Infrastructure Details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SingleServerConfiguration, ThreeTierConfiguration

    All required parameters must be populated in order to send to Azure.

    :ivar deployment_type: The type of SAP deployment, single server or Three tier. Required. Known
     values are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    :ivar app_resource_group: The application resource group where SAP system resources will be
     deployed. Required.
    :vartype app_resource_group: str
    """

    _validation = {
        "deployment_type": {"required": True},
        "app_resource_group": {"required": True},
    }

    _attribute_map = {
        "deployment_type": {"key": "deploymentType", "type": "str"},
        "app_resource_group": {"key": "appResourceGroup", "type": "str"},
    }

    _subtype_map = {
        "deployment_type": {"SingleServer": "SingleServerConfiguration", "ThreeTier": "ThreeTierConfiguration"}
    }

    def __init__(self, *, app_resource_group: str, **kwargs: Any) -> None:
        """
        :keyword app_resource_group: The application resource group where SAP system resources will be
         deployed. Required.
        :paramtype app_resource_group: str
        """
        super().__init__(**kwargs)
        self.deployment_type: Optional[str] = None
        self.app_resource_group = app_resource_group


class OSConfiguration(_serialization.Model):
    """Defines the OS configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    LinuxConfiguration, WindowsConfiguration

    All required parameters must be populated in order to send to Azure.

    :ivar os_type: The OS Type. Required. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.OSType
    """

    _validation = {
        "os_type": {"required": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
    }

    _subtype_map = {"os_type": {"Linux": "LinuxConfiguration", "Windows": "WindowsConfiguration"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.os_type: Optional[str] = None


class LinuxConfiguration(OSConfiguration):
    """Specifies the Linux operating system settings on the virtual machine.
    :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
    Azure-Endorsed Distributions
    <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.

    All required parameters must be populated in order to send to Azure.

    :ivar os_type: The OS Type. Required. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.OSType
    :ivar disable_password_authentication: Specifies whether password authentication should be
     disabled.
    :vartype disable_password_authentication: bool
    :ivar ssh: Specifies the ssh key configuration for a Linux OS. (This property is deprecated,
     please use 'sshKeyPair' instead).
    :vartype ssh: ~azure.mgmt.workloadssapvirtualinstance.models.SshConfiguration
    :ivar ssh_key_pair: The SSH Key-pair used to authenticate with the VM's.
    :vartype ssh_key_pair: ~azure.mgmt.workloadssapvirtualinstance.models.SshKeyPair
    """

    _validation = {
        "os_type": {"required": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "disable_password_authentication": {"key": "disablePasswordAuthentication", "type": "bool"},
        "ssh": {"key": "ssh", "type": "SshConfiguration"},
        "ssh_key_pair": {"key": "sshKeyPair", "type": "SshKeyPair"},
    }

    def __init__(
        self,
        *,
        disable_password_authentication: Optional[bool] = None,
        ssh: Optional["_models.SshConfiguration"] = None,
        ssh_key_pair: Optional["_models.SshKeyPair"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disable_password_authentication: Specifies whether password authentication should be
         disabled.
        :paramtype disable_password_authentication: bool
        :keyword ssh: Specifies the ssh key configuration for a Linux OS. (This property is deprecated,
         please use 'sshKeyPair' instead).
        :paramtype ssh: ~azure.mgmt.workloadssapvirtualinstance.models.SshConfiguration
        :keyword ssh_key_pair: The SSH Key-pair used to authenticate with the VM's.
        :paramtype ssh_key_pair: ~azure.mgmt.workloadssapvirtualinstance.models.SshKeyPair
        """
        super().__init__(**kwargs)
        self.os_type: str = "Linux"
        self.disable_password_authentication = disable_password_authentication
        self.ssh = ssh
        self.ssh_key_pair = ssh_key_pair


class LoadBalancerDetails(_serialization.Model):
    """The Load Balancer details such as Load Balancer ID.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class LoadBalancerResourceNames(_serialization.Model):
    """The resource names object for load balancer and related resources.

    :ivar load_balancer_name: The full resource name for load balancer. If this value is not
     provided, load balancer will be name as {ASCS/DB}-loadBalancer.
    :vartype load_balancer_name: str
    :ivar frontend_ip_configuration_names: The list of frontend IP configuration names. If provided
     as input, size of this list should be 2 for cs layer and should be 1 for database layer.
    :vartype frontend_ip_configuration_names: list[str]
    :ivar backend_pool_names: The list of backend pool names. Currently, ACSS deploys only one
     backend pool and hence, size of this list should be 1.
    :vartype backend_pool_names: list[str]
    :ivar health_probe_names: The list of health probe names. If provided as input, size of this
     list should be 2 for cs layer and should be 1 for database layer.
    :vartype health_probe_names: list[str]
    """

    _validation = {
        "frontend_ip_configuration_names": {"max_items": 2, "min_items": 0},
        "backend_pool_names": {"max_items": 1, "min_items": 0},
        "health_probe_names": {"max_items": 2, "min_items": 0},
    }

    _attribute_map = {
        "load_balancer_name": {"key": "loadBalancerName", "type": "str"},
        "frontend_ip_configuration_names": {"key": "frontendIpConfigurationNames", "type": "[str]"},
        "backend_pool_names": {"key": "backendPoolNames", "type": "[str]"},
        "health_probe_names": {"key": "healthProbeNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        load_balancer_name: Optional[str] = None,
        frontend_ip_configuration_names: Optional[List[str]] = None,
        backend_pool_names: Optional[List[str]] = None,
        health_probe_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword load_balancer_name: The full resource name for load balancer. If this value is not
         provided, load balancer will be name as {ASCS/DB}-loadBalancer.
        :paramtype load_balancer_name: str
        :keyword frontend_ip_configuration_names: The list of frontend IP configuration names. If
         provided as input, size of this list should be 2 for cs layer and should be 1 for database
         layer.
        :paramtype frontend_ip_configuration_names: list[str]
        :keyword backend_pool_names: The list of backend pool names. Currently, ACSS deploys only one
         backend pool and hence, size of this list should be 1.
        :paramtype backend_pool_names: list[str]
        :keyword health_probe_names: The list of health probe names. If provided as input, size of this
         list should be 2 for cs layer and should be 1 for database layer.
        :paramtype health_probe_names: list[str]
        """
        super().__init__(**kwargs)
        self.load_balancer_name = load_balancer_name
        self.frontend_ip_configuration_names = frontend_ip_configuration_names
        self.backend_pool_names = backend_pool_names
        self.health_probe_names = health_probe_names


class ManagedRGConfiguration(_serialization.Model):
    """Managed resource group configuration.

    :ivar name: Managed resource group name.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Managed resource group name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class MessageServerProperties(_serialization.Model):
    """Defines the SAP message server properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ms_port: message server port.
    :vartype ms_port: int
    :ivar internal_ms_port: message server internal MS port.
    :vartype internal_ms_port: int
    :ivar http_port: message server HTTP Port.
    :vartype http_port: int
    :ivar https_port: message server HTTPS Port.
    :vartype https_port: int
    :ivar hostname: message server SAP Hostname.
    :vartype hostname: str
    :ivar ip_address: message server IP Address.
    :vartype ip_address: str
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    """

    _validation = {
        "ms_port": {"readonly": True},
        "internal_ms_port": {"readonly": True},
        "http_port": {"readonly": True},
        "https_port": {"readonly": True},
        "hostname": {"readonly": True},
        "ip_address": {"readonly": True},
        "health": {"readonly": True},
    }

    _attribute_map = {
        "ms_port": {"key": "msPort", "type": "int"},
        "internal_ms_port": {"key": "internalMsPort", "type": "int"},
        "http_port": {"key": "httpPort", "type": "int"},
        "https_port": {"key": "httpsPort", "type": "int"},
        "hostname": {"key": "hostname", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "health": {"key": "health", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.ms_port = None
        self.internal_ms_port = None
        self.http_port = None
        self.https_port = None
        self.hostname = None
        self.ip_address = None
        self.health = None


class MountFileShareConfiguration(FileShareConfiguration):
    """Gets or sets the file share configuration where the transport directory fileshare already
    exists, and user wishes to mount the fileshare as a part of the create infra flow.

    All required parameters must be populated in order to send to Azure.

    :ivar configuration_type: The type of file share config. Required. Known values are: "Skip",
     "CreateAndMount", and "Mount".
    :vartype configuration_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.ConfigurationType
    :ivar id: The fileshare resource ID. Required.
    :vartype id: str
    :ivar private_endpoint_id: The private endpoint resource ID. Required.
    :vartype private_endpoint_id: str
    """

    _validation = {
        "configuration_type": {"required": True},
        "id": {"required": True},
        "private_endpoint_id": {"required": True},
    }

    _attribute_map = {
        "configuration_type": {"key": "configurationType", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "private_endpoint_id": {"key": "privateEndpointId", "type": "str"},
    }

    def __init__(
        self, *, id: str, private_endpoint_id: str, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: The fileshare resource ID. Required.
        :paramtype id: str
        :keyword private_endpoint_id: The private endpoint resource ID. Required.
        :paramtype private_endpoint_id: str
        """
        super().__init__(**kwargs)
        self.configuration_type: str = "Mount"
        self.id = id
        self.private_endpoint_id = private_endpoint_id


class NetworkConfiguration(_serialization.Model):
    """Defines the network configuration type for SAP system infrastructure that is being deployed.

    :ivar is_secondary_ip_enabled: Specifies whether a secondary IP address should be added to the
     network interface on all VMs of the SAP system being deployed.
    :vartype is_secondary_ip_enabled: bool
    """

    _attribute_map = {
        "is_secondary_ip_enabled": {"key": "isSecondaryIpEnabled", "type": "bool"},
    }

    def __init__(self, *, is_secondary_ip_enabled: bool = False, **kwargs: Any) -> None:
        """
        :keyword is_secondary_ip_enabled: Specifies whether a secondary IP address should be added to
         the network interface on all VMs of the SAP system being deployed.
        :paramtype is_secondary_ip_enabled: bool
        """
        super().__init__(**kwargs)
        self.is_secondary_ip_enabled = is_secondary_ip_enabled


class NetworkInterfaceResourceNames(_serialization.Model):
    """The resource names object for network interface and related resources.

    :ivar network_interface_name: The full name for network interface. If name is not provided,
     service uses a default name based on the deployment type. For SingleServer, default name is
     {SID}-Nic. In case of HA-AvZone systems, default name will be {SID}-{App/ASCS/DB}-Zone{A/B}-Nic
     with an incrementor at the end in case of more than 1 instance per layer. For distributed and
     HA-AvSet systems, default name will be {SID}-{App/ASCS/DB}-Nic with an incrementor at the end
     in case of more than 1 instance per layer.
    :vartype network_interface_name: str
    """

    _attribute_map = {
        "network_interface_name": {"key": "networkInterfaceName", "type": "str"},
    }

    def __init__(self, *, network_interface_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword network_interface_name: The full name for network interface. If name is not provided,
         service uses a default name based on the deployment type. For SingleServer, default name is
         {SID}-Nic. In case of HA-AvZone systems, default name will be {SID}-{App/ASCS/DB}-Zone{A/B}-Nic
         with an incrementor at the end in case of more than 1 instance per layer. For distributed and
         HA-AvSet systems, default name will be {SID}-{App/ASCS/DB}-Nic with an incrementor at the end
         in case of more than 1 instance per layer.
        :paramtype network_interface_name: str
        """
        super().__init__(**kwargs)
        self.network_interface_name = network_interface_name


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.workloadssapvirtualinstance.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.workloadssapvirtualinstance.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.workloadssapvirtualinstance.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.workloadssapvirtualinstance.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationStatusResult(_serialization.Model):
    """The current status of an async operation.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.workloadssapvirtualinstance.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.workloadssapvirtualinstance.models.ErrorDetail
    """

    _validation = {
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword percent_complete: Percent of the operation that is complete.
        :paramtype percent_complete: float
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword operations: The operations list.
        :paramtype operations:
         list[~azure.mgmt.workloadssapvirtualinstance.models.OperationStatusResult]
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.workloadssapvirtualinstance.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.percent_complete = percent_complete
        self.start_time = start_time
        self.end_time = end_time
        self.operations = operations
        self.error = error


class OSProfile(_serialization.Model):
    """Specifies the operating system settings for the virtual machine. Some of the settings cannot be
    changed once VM is provisioned.

    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     This property cannot be updated after the VM is created. :code:`<br>`:code:`<br>`
     **Windows-only restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1",
     "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
     "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character
     :code:`<br>`:code:`<br>` **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>`
     **Max-length (Windows):** 20 characters.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
     :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess Extension
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
    :vartype admin_password: str
    :ivar os_configuration: Specifies Windows operating system settings on the virtual machine.
    :vartype os_configuration: ~azure.mgmt.workloadssapvirtualinstance.models.OSConfiguration
    """

    _attribute_map = {
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
        "os_configuration": {"key": "osConfiguration", "type": "OSConfiguration"},
    }

    def __init__(
        self,
        *,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        os_configuration: Optional["_models.OSConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword admin_username: Specifies the name of the administrator account.
         :code:`<br>`:code:`<br>` This property cannot be updated after the VM is created.
         :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
         :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
         "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
         "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
         "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
         :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
         characters.
        :paramtype admin_username: str
        :keyword admin_password: Specifies the password of the administrator account.
         :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
         **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
         characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
         :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
         fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
         digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
         **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
         "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
         resetting the password, see `How to reset the Remote Desktop service or its login password in a
         Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
         :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
         repair disks on Azure Linux VMs using the VMAccess Extension
         <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
        :paramtype admin_password: str
        :keyword os_configuration: Specifies Windows operating system settings on the virtual machine.
        :paramtype os_configuration: ~azure.mgmt.workloadssapvirtualinstance.models.OSConfiguration
        """
        super().__init__(**kwargs)
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.os_configuration = os_configuration


class OsSapConfiguration(_serialization.Model):
    """Defines the OS and SAP Configurations for Deployment.

    :ivar deployer_vm_packages: The url and storage account ID where deployer VM packages are
     uploaded.
    :vartype deployer_vm_packages:
     ~azure.mgmt.workloadssapvirtualinstance.models.DeployerVmPackages
    :ivar sap_fqdn: The FQDN to set for the SAP system.
    :vartype sap_fqdn: str
    """

    _attribute_map = {
        "deployer_vm_packages": {"key": "deployerVmPackages", "type": "DeployerVmPackages"},
        "sap_fqdn": {"key": "sapFqdn", "type": "str"},
    }

    def __init__(
        self,
        *,
        deployer_vm_packages: Optional["_models.DeployerVmPackages"] = None,
        sap_fqdn: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword deployer_vm_packages: The url and storage account ID where deployer VM packages are
         uploaded.
        :paramtype deployer_vm_packages:
         ~azure.mgmt.workloadssapvirtualinstance.models.DeployerVmPackages
        :keyword sap_fqdn: The FQDN to set for the SAP system.
        :paramtype sap_fqdn: str
        """
        super().__init__(**kwargs)
        self.deployer_vm_packages = deployer_vm_packages
        self.sap_fqdn = sap_fqdn


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadssapvirtualinstance.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadssapvirtualinstance.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class SAPApplicationServerInstance(TrackedResource):
    """Define the SAP Application Server Instance resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadssapvirtualinstance.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Defines the SAP Application Server instance properties.
    :vartype properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPApplicationServerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "SAPApplicationServerProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SAPApplicationServerProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Defines the SAP Application Server instance properties.
        :paramtype properties:
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPApplicationServerProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class SAPApplicationServerInstanceList(_serialization.Model):
    """Defines the collection of SAP Application Server Instance resources.

    :ivar value: Gets the list of SAP Application Server instance resources.
    :vartype value:
     list[~azure.mgmt.workloadssapvirtualinstance.models.SAPApplicationServerInstance]
    :ivar next_link: Gets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SAPApplicationServerInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SAPApplicationServerInstance"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets the list of SAP Application Server instance resources.
        :paramtype value:
         list[~azure.mgmt.workloadssapvirtualinstance.models.SAPApplicationServerInstance]
        :keyword next_link: Gets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SAPApplicationServerProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Defines the SAP Application Server instance properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar instance_no: Application server Instance Number.
    :vartype instance_no: str
    :ivar subnet: Application server Subnet.
    :vartype subnet: str
    :ivar hostname: Application server instance SAP hostname.
    :vartype hostname: str
    :ivar kernel_version: Application server instance SAP Kernel Version.
    :vartype kernel_version: str
    :ivar kernel_patch: Application server instance SAP Kernel Patch level.
    :vartype kernel_patch: str
    :ivar ip_address: Application server instance SAP IP Address.
    :vartype ip_address: str
    :ivar gateway_port: Application server instance gateway Port.
    :vartype gateway_port: int
    :ivar icm_http_port: Application server instance ICM HTTP Port.
    :vartype icm_http_port: int
    :ivar icm_https_port: Application server instance ICM HTTPS Port.
    :vartype icm_https_port: int
    :ivar dispatcher_status: Application server instance dispatcher status.
    :vartype dispatcher_status: str
    :ivar load_balancer_details: The Load Balancer details such as LoadBalancer ID attached to
     Application Server Virtual Machines.
    :vartype load_balancer_details:
     ~azure.mgmt.workloadssapvirtualinstance.models.LoadBalancerDetails
    :ivar vm_details: The list of virtual machines.
    :vartype vm_details:
     list[~azure.mgmt.workloadssapvirtualinstance.models.ApplicationServerVmDetails]
    :ivar status: Defines the SAP Instance status. Known values are: "Starting", "Running",
     "Stopping", "Offline", "PartiallyRunning", "Unavailable", and "SoftShutdown".
    :vartype status: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceStatus
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    :ivar provisioning_state: Defines the provisioning states. Known values are: "Succeeded",
     "Updating", "Creating", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SapVirtualInstanceProvisioningState
    :ivar errors: Defines the Application Instance errors.
    :vartype errors: ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceError
    """

    _validation = {
        "instance_no": {"readonly": True},
        "subnet": {"readonly": True},
        "hostname": {"readonly": True},
        "kernel_version": {"readonly": True},
        "kernel_patch": {"readonly": True},
        "ip_address": {"readonly": True},
        "gateway_port": {"readonly": True},
        "icm_http_port": {"readonly": True},
        "icm_https_port": {"readonly": True},
        "dispatcher_status": {"readonly": True},
        "load_balancer_details": {"readonly": True},
        "vm_details": {"readonly": True},
        "status": {"readonly": True},
        "health": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "instance_no": {"key": "instanceNo", "type": "str"},
        "subnet": {"key": "subnet", "type": "str"},
        "hostname": {"key": "hostname", "type": "str"},
        "kernel_version": {"key": "kernelVersion", "type": "str"},
        "kernel_patch": {"key": "kernelPatch", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "gateway_port": {"key": "gatewayPort", "type": "int"},
        "icm_http_port": {"key": "icmHttpPort", "type": "int"},
        "icm_https_port": {"key": "icmHttpsPort", "type": "int"},
        "dispatcher_status": {"key": "dispatcherStatus", "type": "str"},
        "load_balancer_details": {"key": "loadBalancerDetails", "type": "LoadBalancerDetails"},
        "vm_details": {"key": "vmDetails", "type": "[ApplicationServerVmDetails]"},
        "status": {"key": "status", "type": "str"},
        "health": {"key": "health", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "errors": {"key": "errors", "type": "SAPVirtualInstanceError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_no = None
        self.subnet = None
        self.hostname = None
        self.kernel_version = None
        self.kernel_patch = None
        self.ip_address = None
        self.gateway_port = None
        self.icm_http_port = None
        self.icm_https_port = None
        self.dispatcher_status = None
        self.load_balancer_details = None
        self.vm_details = None
        self.status = None
        self.health = None
        self.provisioning_state = None
        self.errors = None


class SAPAvailabilityZoneDetailsRequest(_serialization.Model):
    """The SAP request to get list of availability zones.

    All required parameters must be populated in order to send to Azure.

    :ivar app_location: The geo-location where the SAP resources will be created. Required.
    :vartype app_location: str
    :ivar sap_product: Defines the SAP Product type. Required. Known values are: "ECC", "S4HANA",
     and "Other".
    :vartype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
    :ivar database_type: The database type. Eg: HANA, DB2, etc. Required. Known values are: "HANA"
     and "DB2".
    :vartype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
    """

    _validation = {
        "app_location": {"required": True},
        "sap_product": {"required": True},
        "database_type": {"required": True},
    }

    _attribute_map = {
        "app_location": {"key": "appLocation", "type": "str"},
        "sap_product": {"key": "sapProduct", "type": "str"},
        "database_type": {"key": "databaseType", "type": "str"},
    }

    def __init__(
        self,
        *,
        app_location: str,
        sap_product: Union[str, "_models.SAPProductType"],
        database_type: Union[str, "_models.SAPDatabaseType"],
        **kwargs: Any
    ) -> None:
        """
        :keyword app_location: The geo-location where the SAP resources will be created. Required.
        :paramtype app_location: str
        :keyword sap_product: Defines the SAP Product type. Required. Known values are: "ECC",
         "S4HANA", and "Other".
        :paramtype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
        :keyword database_type: The database type. Eg: HANA, DB2, etc. Required. Known values are:
         "HANA" and "DB2".
        :paramtype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
        """
        super().__init__(**kwargs)
        self.app_location = app_location
        self.sap_product = sap_product
        self.database_type = database_type


class SAPAvailabilityZoneDetailsResult(_serialization.Model):
    """The list of supported availability zone pairs which are part of SAP HA deployment.

    :ivar availability_zone_pairs: Gets the list of availability zone pairs.
    :vartype availability_zone_pairs:
     list[~azure.mgmt.workloadssapvirtualinstance.models.SAPAvailabilityZonePair]
    """

    _attribute_map = {
        "availability_zone_pairs": {"key": "availabilityZonePairs", "type": "[SAPAvailabilityZonePair]"},
    }

    def __init__(
        self, *, availability_zone_pairs: Optional[List["_models.SAPAvailabilityZonePair"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword availability_zone_pairs: Gets the list of availability zone pairs.
        :paramtype availability_zone_pairs:
         list[~azure.mgmt.workloadssapvirtualinstance.models.SAPAvailabilityZonePair]
        """
        super().__init__(**kwargs)
        self.availability_zone_pairs = availability_zone_pairs


class SAPAvailabilityZonePair(_serialization.Model):
    """The SAP Availability Zone Pair.

    :ivar zone_a: The zone A.
    :vartype zone_a: int
    :ivar zone_b: The zone B.
    :vartype zone_b: int
    """

    _attribute_map = {
        "zone_a": {"key": "zoneA", "type": "int"},
        "zone_b": {"key": "zoneB", "type": "int"},
    }

    def __init__(self, *, zone_a: Optional[int] = None, zone_b: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword zone_a: The zone A.
        :paramtype zone_a: int
        :keyword zone_b: The zone B.
        :paramtype zone_b: int
        """
        super().__init__(**kwargs)
        self.zone_a = zone_a
        self.zone_b = zone_b


class SAPCentralInstanceList(_serialization.Model):
    """Defines the collection of SAP Central Services Instance resources.

    :ivar value: Gets the list of SAP central services instance resources.
    :vartype value: list[~azure.mgmt.workloadssapvirtualinstance.models.SAPCentralServerInstance]
    :ivar next_link: Gets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SAPCentralServerInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SAPCentralServerInstance"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets the list of SAP central services instance resources.
        :paramtype value: list[~azure.mgmt.workloadssapvirtualinstance.models.SAPCentralServerInstance]
        :keyword next_link: Gets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SAPCentralServerInstance(TrackedResource):
    """Define the SAP Central Services Instance resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadssapvirtualinstance.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Defines the SAP Central Services Instance properties.
    :vartype properties: ~azure.mgmt.workloadssapvirtualinstance.models.SAPCentralServerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "SAPCentralServerProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SAPCentralServerProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Defines the SAP Central Services Instance properties.
        :paramtype properties:
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPCentralServerProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class SAPCentralServerProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Defines the SAP Central Services Instance properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar instance_no: The central services instance number.
    :vartype instance_no: str
    :ivar subnet: The central services instance subnet.
    :vartype subnet: str
    :ivar message_server_properties: Defines the SAP message server properties.
    :vartype message_server_properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.MessageServerProperties
    :ivar enqueue_server_properties: Defines the SAP Enqueue Server properties.
    :vartype enqueue_server_properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.EnqueueServerProperties
    :ivar gateway_server_properties: Defines the SAP Gateway Server properties.
    :vartype gateway_server_properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.GatewayServerProperties
    :ivar enqueue_replication_server_properties: Defines the SAP Enqueue Replication Server (ERS)
     properties.
    :vartype enqueue_replication_server_properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.EnqueueReplicationServerProperties
    :ivar kernel_version: The central services instance Kernel Version.
    :vartype kernel_version: str
    :ivar kernel_patch: The central services instance Kernel Patch level.
    :vartype kernel_patch: str
    :ivar load_balancer_details: The Load Balancer details such as LoadBalancer ID attached to ASCS
     Virtual Machines.
    :vartype load_balancer_details:
     ~azure.mgmt.workloadssapvirtualinstance.models.LoadBalancerDetails
    :ivar vm_details: The list of virtual machines corresponding to the Central Services instance.
    :vartype vm_details:
     list[~azure.mgmt.workloadssapvirtualinstance.models.CentralServerVmDetails]
    :ivar status: Defines the SAP Instance status. Known values are: "Starting", "Running",
     "Stopping", "Offline", "PartiallyRunning", "Unavailable", and "SoftShutdown".
    :vartype status: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceStatus
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    :ivar provisioning_state: Defines the provisioning states. Known values are: "Succeeded",
     "Updating", "Creating", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SapVirtualInstanceProvisioningState
    :ivar errors: Defines the errors related to SAP Central Services Instance resource.
    :vartype errors: ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceError
    """

    _validation = {
        "instance_no": {"readonly": True},
        "subnet": {"readonly": True},
        "kernel_version": {"readonly": True},
        "kernel_patch": {"readonly": True},
        "load_balancer_details": {"readonly": True},
        "vm_details": {"readonly": True},
        "status": {"readonly": True},
        "health": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "instance_no": {"key": "instanceNo", "type": "str"},
        "subnet": {"key": "subnet", "type": "str"},
        "message_server_properties": {"key": "messageServerProperties", "type": "MessageServerProperties"},
        "enqueue_server_properties": {"key": "enqueueServerProperties", "type": "EnqueueServerProperties"},
        "gateway_server_properties": {"key": "gatewayServerProperties", "type": "GatewayServerProperties"},
        "enqueue_replication_server_properties": {
            "key": "enqueueReplicationServerProperties",
            "type": "EnqueueReplicationServerProperties",
        },
        "kernel_version": {"key": "kernelVersion", "type": "str"},
        "kernel_patch": {"key": "kernelPatch", "type": "str"},
        "load_balancer_details": {"key": "loadBalancerDetails", "type": "LoadBalancerDetails"},
        "vm_details": {"key": "vmDetails", "type": "[CentralServerVmDetails]"},
        "status": {"key": "status", "type": "str"},
        "health": {"key": "health", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "errors": {"key": "errors", "type": "SAPVirtualInstanceError"},
    }

    def __init__(
        self,
        *,
        message_server_properties: Optional["_models.MessageServerProperties"] = None,
        enqueue_server_properties: Optional["_models.EnqueueServerProperties"] = None,
        gateway_server_properties: Optional["_models.GatewayServerProperties"] = None,
        enqueue_replication_server_properties: Optional["_models.EnqueueReplicationServerProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword message_server_properties: Defines the SAP message server properties.
        :paramtype message_server_properties:
         ~azure.mgmt.workloadssapvirtualinstance.models.MessageServerProperties
        :keyword enqueue_server_properties: Defines the SAP Enqueue Server properties.
        :paramtype enqueue_server_properties:
         ~azure.mgmt.workloadssapvirtualinstance.models.EnqueueServerProperties
        :keyword gateway_server_properties: Defines the SAP Gateway Server properties.
        :paramtype gateway_server_properties:
         ~azure.mgmt.workloadssapvirtualinstance.models.GatewayServerProperties
        :keyword enqueue_replication_server_properties: Defines the SAP Enqueue Replication Server
         (ERS) properties.
        :paramtype enqueue_replication_server_properties:
         ~azure.mgmt.workloadssapvirtualinstance.models.EnqueueReplicationServerProperties
        """
        super().__init__(**kwargs)
        self.instance_no = None
        self.subnet = None
        self.message_server_properties = message_server_properties
        self.enqueue_server_properties = enqueue_server_properties
        self.gateway_server_properties = gateway_server_properties
        self.enqueue_replication_server_properties = enqueue_replication_server_properties
        self.kernel_version = None
        self.kernel_patch = None
        self.load_balancer_details = None
        self.vm_details = None
        self.status = None
        self.health = None
        self.provisioning_state = None
        self.errors = None


class SAPDatabaseInstance(TrackedResource):
    """Define the Database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadssapvirtualinstance.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Defines the Database properties.
    :vartype properties: ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "SAPDatabaseProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SAPDatabaseProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Defines the Database properties.
        :paramtype properties: ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class SAPDatabaseInstanceList(_serialization.Model):
    """Defines the collection of SAP Database Instances.

    :ivar value: Gets the list of SAP Database instances.
    :vartype value: list[~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseInstance]
    :ivar next_link: Gets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SAPDatabaseInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SAPDatabaseInstance"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets the list of SAP Database instances.
        :paramtype value: list[~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseInstance]
        :keyword next_link: Gets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SAPDatabaseProperties(_serialization.Model):
    """Defines the Database properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subnet: Database subnet.
    :vartype subnet: str
    :ivar database_sid: Database SID name.
    :vartype database_sid: str
    :ivar database_type: Database type, that is if the DB is HANA, DB2, Oracle, SAP ASE, Max DB or
     MS SQL Server.
    :vartype database_type: str
    :ivar ip_address: Database IP Address.
    :vartype ip_address: str
    :ivar load_balancer_details: The Load Balancer details such as LoadBalancer ID attached to
     Database Virtual Machines.
    :vartype load_balancer_details:
     ~azure.mgmt.workloadssapvirtualinstance.models.LoadBalancerDetails
    :ivar vm_details: The list of virtual machines corresponding to the Database resource.
    :vartype vm_details: list[~azure.mgmt.workloadssapvirtualinstance.models.DatabaseVmDetails]
    :ivar status: Defines the SAP Instance status. Known values are: "Starting", "Running",
     "Stopping", "Offline", "PartiallyRunning", "Unavailable", and "SoftShutdown".
    :vartype status: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceStatus
    :ivar provisioning_state: Defines the provisioning states. Known values are: "Succeeded",
     "Updating", "Creating", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SapVirtualInstanceProvisioningState
    :ivar errors: Defines the errors related to Database resource.
    :vartype errors: ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceError
    """

    _validation = {
        "subnet": {"readonly": True},
        "database_sid": {"readonly": True},
        "database_type": {"readonly": True},
        "ip_address": {"readonly": True},
        "load_balancer_details": {"readonly": True},
        "vm_details": {"readonly": True},
        "status": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "subnet": {"key": "subnet", "type": "str"},
        "database_sid": {"key": "databaseSid", "type": "str"},
        "database_type": {"key": "databaseType", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "load_balancer_details": {"key": "loadBalancerDetails", "type": "LoadBalancerDetails"},
        "vm_details": {"key": "vmDetails", "type": "[DatabaseVmDetails]"},
        "status": {"key": "status", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "errors": {"key": "errors", "type": "SAPVirtualInstanceError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.subnet = None
        self.database_sid = None
        self.database_type = None
        self.ip_address = None
        self.load_balancer_details = None
        self.vm_details = None
        self.status = None
        self.provisioning_state = None
        self.errors = None


class SAPDiskConfiguration(_serialization.Model):
    """The SAP Disk Configuration contains 'recommended disk' details and list of supported disks
    detail for a volume type.

    :ivar recommended_configuration: The recommended disk details for a given VM Sku.
    :vartype recommended_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.DiskVolumeConfiguration
    :ivar supported_configurations: The list of supported disks for a given VM Sku.
    :vartype supported_configurations:
     list[~azure.mgmt.workloadssapvirtualinstance.models.DiskDetails]
    """

    _attribute_map = {
        "recommended_configuration": {"key": "recommendedConfiguration", "type": "DiskVolumeConfiguration"},
        "supported_configurations": {"key": "supportedConfigurations", "type": "[DiskDetails]"},
    }

    def __init__(
        self,
        *,
        recommended_configuration: Optional["_models.DiskVolumeConfiguration"] = None,
        supported_configurations: Optional[List["_models.DiskDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recommended_configuration: The recommended disk details for a given VM Sku.
        :paramtype recommended_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.DiskVolumeConfiguration
        :keyword supported_configurations: The list of supported disks for a given VM Sku.
        :paramtype supported_configurations:
         list[~azure.mgmt.workloadssapvirtualinstance.models.DiskDetails]
        """
        super().__init__(**kwargs)
        self.recommended_configuration = recommended_configuration
        self.supported_configurations = supported_configurations


class SAPDiskConfigurationsRequest(_serialization.Model):
    """The SAP request to get list of disk configurations.

    All required parameters must be populated in order to send to Azure.

    :ivar app_location: The geo-location where the SAP resources will be created. Required.
    :vartype app_location: str
    :ivar environment: Defines the environment type - Production/Non Production. Required. Known
     values are: "NonProd" and "Prod".
    :vartype environment: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPEnvironmentType
    :ivar sap_product: Defines the SAP Product type. Required. Known values are: "ECC", "S4HANA",
     and "Other".
    :vartype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
    :ivar database_type: The database type. Eg: HANA, DB2, etc. Required. Known values are: "HANA"
     and "DB2".
    :vartype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
    :ivar deployment_type: The deployment type. Eg: SingleServer/ThreeTier. Required. Known values
     are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    :ivar db_vm_sku: The VM SKU for database instance. Required.
    :vartype db_vm_sku: str
    """

    _validation = {
        "app_location": {"required": True},
        "environment": {"required": True},
        "sap_product": {"required": True},
        "database_type": {"required": True},
        "deployment_type": {"required": True},
        "db_vm_sku": {"required": True},
    }

    _attribute_map = {
        "app_location": {"key": "appLocation", "type": "str"},
        "environment": {"key": "environment", "type": "str"},
        "sap_product": {"key": "sapProduct", "type": "str"},
        "database_type": {"key": "databaseType", "type": "str"},
        "deployment_type": {"key": "deploymentType", "type": "str"},
        "db_vm_sku": {"key": "dbVmSku", "type": "str"},
    }

    def __init__(
        self,
        *,
        app_location: str,
        environment: Union[str, "_models.SAPEnvironmentType"],
        sap_product: Union[str, "_models.SAPProductType"],
        database_type: Union[str, "_models.SAPDatabaseType"],
        deployment_type: Union[str, "_models.SAPDeploymentType"],
        db_vm_sku: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword app_location: The geo-location where the SAP resources will be created. Required.
        :paramtype app_location: str
        :keyword environment: Defines the environment type - Production/Non Production. Required. Known
         values are: "NonProd" and "Prod".
        :paramtype environment: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPEnvironmentType
        :keyword sap_product: Defines the SAP Product type. Required. Known values are: "ECC",
         "S4HANA", and "Other".
        :paramtype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
        :keyword database_type: The database type. Eg: HANA, DB2, etc. Required. Known values are:
         "HANA" and "DB2".
        :paramtype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
        :keyword deployment_type: The deployment type. Eg: SingleServer/ThreeTier. Required. Known
         values are: "SingleServer" and "ThreeTier".
        :paramtype deployment_type: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
        :keyword db_vm_sku: The VM SKU for database instance. Required.
        :paramtype db_vm_sku: str
        """
        super().__init__(**kwargs)
        self.app_location = app_location
        self.environment = environment
        self.sap_product = sap_product
        self.database_type = database_type
        self.deployment_type = deployment_type
        self.db_vm_sku = db_vm_sku


class SAPDiskConfigurationsResult(_serialization.Model):
    """The list of disk configuration for vmSku which are part of SAP deployment.

    :ivar volume_configurations: The disk configuration for the db volume. For HANA, Required
     volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume :
     ['backup'].
    :vartype volume_configurations: dict[str,
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDiskConfiguration]
    """

    _attribute_map = {
        "volume_configurations": {"key": "volumeConfigurations", "type": "{SAPDiskConfiguration}"},
    }

    def __init__(
        self, *, volume_configurations: Optional[Dict[str, "_models.SAPDiskConfiguration"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword volume_configurations: The disk configuration for the db volume. For HANA, Required
         volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume :
         ['backup'].
        :paramtype volume_configurations: dict[str,
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPDiskConfiguration]
        """
        super().__init__(**kwargs)
        self.volume_configurations = volume_configurations


class SAPInstallWithoutOSConfigSoftwareConfiguration(SoftwareConfiguration):
    """The SAP Software configuration Input when the software is to be installed by service without OS
    Configurations.

    All required parameters must be populated in order to send to Azure.

    :ivar software_installation_type: The SAP software installation Type. Required. Known values
     are: "ServiceInitiated", "SAPInstallWithoutOSConfig", and "External".
    :vartype software_installation_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPSoftwareInstallationType
    :ivar bom_url: The URL to the SAP Build of Materials(BOM) file. Required.
    :vartype bom_url: str
    :ivar sap_bits_storage_account_id: The SAP bits storage account id. Required.
    :vartype sap_bits_storage_account_id: str
    :ivar software_version: The software version to install. Required.
    :vartype software_version: str
    :ivar high_availability_software_configuration: Gets or sets the HA software configuration.
    :vartype high_availability_software_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.HighAvailabilitySoftwareConfiguration
    """

    _validation = {
        "software_installation_type": {"required": True},
        "bom_url": {"required": True},
        "sap_bits_storage_account_id": {"required": True},
        "software_version": {"required": True},
    }

    _attribute_map = {
        "software_installation_type": {"key": "softwareInstallationType", "type": "str"},
        "bom_url": {"key": "bomUrl", "type": "str"},
        "sap_bits_storage_account_id": {"key": "sapBitsStorageAccountId", "type": "str"},
        "software_version": {"key": "softwareVersion", "type": "str"},
        "high_availability_software_configuration": {
            "key": "highAvailabilitySoftwareConfiguration",
            "type": "HighAvailabilitySoftwareConfiguration",
        },
    }

    def __init__(
        self,
        *,
        bom_url: str,
        sap_bits_storage_account_id: str,
        software_version: str,
        high_availability_software_configuration: Optional["_models.HighAvailabilitySoftwareConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bom_url: The URL to the SAP Build of Materials(BOM) file. Required.
        :paramtype bom_url: str
        :keyword sap_bits_storage_account_id: The SAP bits storage account id. Required.
        :paramtype sap_bits_storage_account_id: str
        :keyword software_version: The software version to install. Required.
        :paramtype software_version: str
        :keyword high_availability_software_configuration: Gets or sets the HA software configuration.
        :paramtype high_availability_software_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.HighAvailabilitySoftwareConfiguration
        """
        super().__init__(**kwargs)
        self.software_installation_type: str = "SAPInstallWithoutOSConfig"
        self.bom_url = bom_url
        self.sap_bits_storage_account_id = sap_bits_storage_account_id
        self.software_version = software_version
        self.high_availability_software_configuration = high_availability_software_configuration


class SAPSizingRecommendationRequest(_serialization.Model):
    """The SAP Sizing Recommendation request.

    All required parameters must be populated in order to send to Azure.

    :ivar app_location: The geo-location where the resource is to be created. Required.
    :vartype app_location: str
    :ivar environment: Defines the environment type - Production/Non Production. Required. Known
     values are: "NonProd" and "Prod".
    :vartype environment: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPEnvironmentType
    :ivar sap_product: Defines the SAP Product type. Required. Known values are: "ECC", "S4HANA",
     and "Other".
    :vartype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
    :ivar deployment_type: The deployment type. Eg: SingleServer/ThreeTier. Required. Known values
     are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    :ivar saps: The SAP Application Performance Standard measurement. Required.
    :vartype saps: int
    :ivar db_memory: The database memory configuration. Required.
    :vartype db_memory: int
    :ivar database_type: The database type. Required. Known values are: "HANA" and "DB2".
    :vartype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
    :ivar db_scale_method: The DB scale method. "ScaleUp"
    :vartype db_scale_method: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseScaleMethod
    :ivar high_availability_type: The high availability type. Known values are: "AvailabilitySet"
     and "AvailabilityZone".
    :vartype high_availability_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPHighAvailabilityType
    """

    _validation = {
        "app_location": {"required": True},
        "environment": {"required": True},
        "sap_product": {"required": True},
        "deployment_type": {"required": True},
        "saps": {"required": True},
        "db_memory": {"required": True},
        "database_type": {"required": True},
    }

    _attribute_map = {
        "app_location": {"key": "appLocation", "type": "str"},
        "environment": {"key": "environment", "type": "str"},
        "sap_product": {"key": "sapProduct", "type": "str"},
        "deployment_type": {"key": "deploymentType", "type": "str"},
        "saps": {"key": "saps", "type": "int"},
        "db_memory": {"key": "dbMemory", "type": "int"},
        "database_type": {"key": "databaseType", "type": "str"},
        "db_scale_method": {"key": "dbScaleMethod", "type": "str"},
        "high_availability_type": {"key": "highAvailabilityType", "type": "str"},
    }

    def __init__(
        self,
        *,
        app_location: str,
        environment: Union[str, "_models.SAPEnvironmentType"],
        sap_product: Union[str, "_models.SAPProductType"],
        deployment_type: Union[str, "_models.SAPDeploymentType"],
        saps: int,
        db_memory: int,
        database_type: Union[str, "_models.SAPDatabaseType"],
        db_scale_method: Optional[Union[str, "_models.SAPDatabaseScaleMethod"]] = None,
        high_availability_type: Optional[Union[str, "_models.SAPHighAvailabilityType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword app_location: The geo-location where the resource is to be created. Required.
        :paramtype app_location: str
        :keyword environment: Defines the environment type - Production/Non Production. Required. Known
         values are: "NonProd" and "Prod".
        :paramtype environment: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPEnvironmentType
        :keyword sap_product: Defines the SAP Product type. Required. Known values are: "ECC",
         "S4HANA", and "Other".
        :paramtype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
        :keyword deployment_type: The deployment type. Eg: SingleServer/ThreeTier. Required. Known
         values are: "SingleServer" and "ThreeTier".
        :paramtype deployment_type: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
        :keyword saps: The SAP Application Performance Standard measurement. Required.
        :paramtype saps: int
        :keyword db_memory: The database memory configuration. Required.
        :paramtype db_memory: int
        :keyword database_type: The database type. Required. Known values are: "HANA" and "DB2".
        :paramtype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
        :keyword db_scale_method: The DB scale method. "ScaleUp"
        :paramtype db_scale_method: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseScaleMethod
        :keyword high_availability_type: The high availability type. Known values are:
         "AvailabilitySet" and "AvailabilityZone".
        :paramtype high_availability_type: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPHighAvailabilityType
        """
        super().__init__(**kwargs)
        self.app_location = app_location
        self.environment = environment
        self.sap_product = sap_product
        self.deployment_type = deployment_type
        self.saps = saps
        self.db_memory = db_memory
        self.database_type = database_type
        self.db_scale_method = db_scale_method
        self.high_availability_type = high_availability_type


class SAPSizingRecommendationResult(_serialization.Model):
    """The SAP sizing recommendation result.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SingleServerRecommendationResult, ThreeTierRecommendationResult

    All required parameters must be populated in order to send to Azure.

    :ivar deployment_type: The type of SAP deployment, single server or Three tier. Required. Known
     values are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    """

    _validation = {
        "deployment_type": {"required": True},
    }

    _attribute_map = {
        "deployment_type": {"key": "deploymentType", "type": "str"},
    }

    _subtype_map = {
        "deployment_type": {
            "SingleServer": "SingleServerRecommendationResult",
            "ThreeTier": "ThreeTierRecommendationResult",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.deployment_type: Optional[str] = None


class SAPSupportedResourceSkusResult(_serialization.Model):
    """The list of supported SKUs for different resources which are part of SAP deployment.

    :ivar supported_skus: Gets the list of SAP supported SKUs.
    :vartype supported_skus: list[~azure.mgmt.workloadssapvirtualinstance.models.SAPSupportedSku]
    """

    _attribute_map = {
        "supported_skus": {"key": "supportedSkus", "type": "[SAPSupportedSku]"},
    }

    def __init__(self, *, supported_skus: Optional[List["_models.SAPSupportedSku"]] = None, **kwargs: Any) -> None:
        """
        :keyword supported_skus: Gets the list of SAP supported SKUs.
        :paramtype supported_skus: list[~azure.mgmt.workloadssapvirtualinstance.models.SAPSupportedSku]
        """
        super().__init__(**kwargs)
        self.supported_skus = supported_skus


class SAPSupportedSku(_serialization.Model):
    """The SAP supported SKU.

    :ivar vm_sku: The VM Sku.
    :vartype vm_sku: str
    :ivar is_app_server_certified: True if the Sku is certified for App server in the SAP system.
    :vartype is_app_server_certified: bool
    :ivar is_database_certified: True if the Sku is certified for Database server in the SAP
     system.
    :vartype is_database_certified: bool
    """

    _attribute_map = {
        "vm_sku": {"key": "vmSku", "type": "str"},
        "is_app_server_certified": {"key": "isAppServerCertified", "type": "bool"},
        "is_database_certified": {"key": "isDatabaseCertified", "type": "bool"},
    }

    def __init__(
        self,
        *,
        vm_sku: Optional[str] = None,
        is_app_server_certified: Optional[bool] = None,
        is_database_certified: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_sku: The VM Sku.
        :paramtype vm_sku: str
        :keyword is_app_server_certified: True if the Sku is certified for App server in the SAP
         system.
        :paramtype is_app_server_certified: bool
        :keyword is_database_certified: True if the Sku is certified for Database server in the SAP
         system.
        :paramtype is_database_certified: bool
        """
        super().__init__(**kwargs)
        self.vm_sku = vm_sku
        self.is_app_server_certified = is_app_server_certified
        self.is_database_certified = is_database_certified


class SAPSupportedSkusRequest(_serialization.Model):
    """The SAP request to get list of supported SKUs.

    All required parameters must be populated in order to send to Azure.

    :ivar app_location: The geo-location where the resource is to be created. Required.
    :vartype app_location: str
    :ivar environment: Defines the environment type - Production/Non Production. Required. Known
     values are: "NonProd" and "Prod".
    :vartype environment: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPEnvironmentType
    :ivar sap_product: Defines the SAP Product type. Required. Known values are: "ECC", "S4HANA",
     and "Other".
    :vartype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
    :ivar deployment_type: The deployment type. Eg: SingleServer/ThreeTier. Required. Known values
     are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    :ivar database_type: The database type. Eg: HANA, DB2, etc. Required. Known values are: "HANA"
     and "DB2".
    :vartype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
    :ivar high_availability_type: The high availability type. Known values are: "AvailabilitySet"
     and "AvailabilityZone".
    :vartype high_availability_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPHighAvailabilityType
    """

    _validation = {
        "app_location": {"required": True},
        "environment": {"required": True},
        "sap_product": {"required": True},
        "deployment_type": {"required": True},
        "database_type": {"required": True},
    }

    _attribute_map = {
        "app_location": {"key": "appLocation", "type": "str"},
        "environment": {"key": "environment", "type": "str"},
        "sap_product": {"key": "sapProduct", "type": "str"},
        "deployment_type": {"key": "deploymentType", "type": "str"},
        "database_type": {"key": "databaseType", "type": "str"},
        "high_availability_type": {"key": "highAvailabilityType", "type": "str"},
    }

    def __init__(
        self,
        *,
        app_location: str,
        environment: Union[str, "_models.SAPEnvironmentType"],
        sap_product: Union[str, "_models.SAPProductType"],
        deployment_type: Union[str, "_models.SAPDeploymentType"],
        database_type: Union[str, "_models.SAPDatabaseType"],
        high_availability_type: Optional[Union[str, "_models.SAPHighAvailabilityType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword app_location: The geo-location where the resource is to be created. Required.
        :paramtype app_location: str
        :keyword environment: Defines the environment type - Production/Non Production. Required. Known
         values are: "NonProd" and "Prod".
        :paramtype environment: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPEnvironmentType
        :keyword sap_product: Defines the SAP Product type. Required. Known values are: "ECC",
         "S4HANA", and "Other".
        :paramtype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
        :keyword deployment_type: The deployment type. Eg: SingleServer/ThreeTier. Required. Known
         values are: "SingleServer" and "ThreeTier".
        :paramtype deployment_type: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
        :keyword database_type: The database type. Eg: HANA, DB2, etc. Required. Known values are:
         "HANA" and "DB2".
        :paramtype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
        :keyword high_availability_type: The high availability type. Known values are:
         "AvailabilitySet" and "AvailabilityZone".
        :paramtype high_availability_type: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPHighAvailabilityType
        """
        super().__init__(**kwargs)
        self.app_location = app_location
        self.environment = environment
        self.sap_product = sap_product
        self.deployment_type = deployment_type
        self.database_type = database_type
        self.high_availability_type = high_availability_type


class SAPVirtualInstance(TrackedResource):
    """Define the Virtual Instance for SAP solutions resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadssapvirtualinstance.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Managed service identity (user assigned identities).
    :vartype identity: ~azure.mgmt.workloadssapvirtualinstance.models.UserAssignedServiceIdentity
    :ivar properties: Defines the Virtual Instance for SAP solutions resource properties. Required.
    :vartype properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "UserAssignedServiceIdentity"},
        "properties": {"key": "properties", "type": "SAPVirtualInstanceProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.SAPVirtualInstanceProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.UserAssignedServiceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Managed service identity (user assigned identities).
        :paramtype identity: ~azure.mgmt.workloadssapvirtualinstance.models.UserAssignedServiceIdentity
        :keyword properties: Defines the Virtual Instance for SAP solutions resource properties.
         Required.
        :paramtype properties:
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.properties = properties


class SAPVirtualInstanceError(_serialization.Model):
    """An error response from the Virtual Instance for SAP Workload service.

    :ivar properties: The Virtual Instance for SAP error body.
    :vartype properties: ~azure.mgmt.workloadssapvirtualinstance.models.ErrorDefinition
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ErrorDefinition"},
    }

    def __init__(self, *, properties: Optional["_models.ErrorDefinition"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The Virtual Instance for SAP error body.
        :paramtype properties: ~azure.mgmt.workloadssapvirtualinstance.models.ErrorDefinition
        """
        super().__init__(**kwargs)
        self.properties = properties


class SAPVirtualInstanceList(_serialization.Model):
    """Defines the collection of Virtual Instance for SAP solutions resources.

    :ivar value: Gets the list of Virtual Instances for SAP solutions resources.
    :vartype value: list[~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstance]
    :ivar next_link: Gets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SAPVirtualInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SAPVirtualInstance"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets the list of Virtual Instances for SAP solutions resources.
        :paramtype value: list[~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstance]
        :keyword next_link: Gets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SAPVirtualInstanceProperties(_serialization.Model):
    """Defines the Virtual Instance for SAP solutions resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar environment: Defines the environment type - Production/Non Production. Required. Known
     values are: "NonProd" and "Prod".
    :vartype environment: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPEnvironmentType
    :ivar sap_product: Defines the SAP Product type. Required. Known values are: "ECC", "S4HANA",
     and "Other".
    :vartype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
    :ivar managed_resources_network_access_type: Specifies the network access configuration for the
     resources that will be deployed in the Managed Resource Group. The options to choose from are
     Public and Private. If 'Private' is chosen, the Storage Account service tag should be enabled
     on the subnets in which the SAP VMs exist. This is required for establishing connectivity
     between VM extensions and the managed resource group storage account. This setting is currently
     applicable only to Storage Account. Learn more here
     https://go.microsoft.com/fwlink/?linkid=2247228. Known values are: "Public" and "Private".
    :vartype managed_resources_network_access_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.ManagedResourcesNetworkAccessType
    :ivar configuration: Defines if the SAP system is being created using Azure Center for SAP
     solutions (ACSS) or if an existing SAP system is being registered with ACSS. Required.
    :vartype configuration: ~azure.mgmt.workloadssapvirtualinstance.models.SAPConfiguration
    :ivar managed_resource_group_configuration: Managed resource group configuration.
    :vartype managed_resource_group_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.ManagedRGConfiguration
    :ivar status: Defines the SAP Instance status. Known values are: "Starting", "Running",
     "Stopping", "Offline", "PartiallyRunning", "Unavailable", and "SoftShutdown".
    :vartype status: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceStatus
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    :ivar state: Defines the Virtual Instance for SAP state. Known values are:
     "InfrastructureDeploymentPending", "InfrastructureDeploymentInProgress",
     "InfrastructureDeploymentFailed", "SoftwareInstallationPending",
     "SoftwareInstallationInProgress", "SoftwareInstallationFailed", "SoftwareDetectionInProgress",
     "SoftwareDetectionFailed", "DiscoveryPending", "DiscoveryInProgress", "DiscoveryFailed",
     "RegistrationComplete", and "ACSSInstallationBlocked".
    :vartype state: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceState
    :ivar provisioning_state: Defines the provisioning states. Known values are: "Succeeded",
     "Updating", "Creating", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SapVirtualInstanceProvisioningState
    :ivar errors: Indicates any errors on the Virtual Instance for SAP solutions resource.
    :vartype errors: ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceError
    """

    _validation = {
        "environment": {"required": True},
        "sap_product": {"required": True},
        "configuration": {"required": True},
        "status": {"readonly": True},
        "health": {"readonly": True},
        "state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "environment": {"key": "environment", "type": "str"},
        "sap_product": {"key": "sapProduct", "type": "str"},
        "managed_resources_network_access_type": {"key": "managedResourcesNetworkAccessType", "type": "str"},
        "configuration": {"key": "configuration", "type": "SAPConfiguration"},
        "managed_resource_group_configuration": {
            "key": "managedResourceGroupConfiguration",
            "type": "ManagedRGConfiguration",
        },
        "status": {"key": "status", "type": "str"},
        "health": {"key": "health", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "errors": {"key": "errors", "type": "SAPVirtualInstanceError"},
    }

    def __init__(
        self,
        *,
        environment: Union[str, "_models.SAPEnvironmentType"],
        sap_product: Union[str, "_models.SAPProductType"],
        configuration: "_models.SAPConfiguration",
        managed_resources_network_access_type: Optional[Union[str, "_models.ManagedResourcesNetworkAccessType"]] = None,
        managed_resource_group_configuration: Optional["_models.ManagedRGConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword environment: Defines the environment type - Production/Non Production. Required. Known
         values are: "NonProd" and "Prod".
        :paramtype environment: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.SAPEnvironmentType
        :keyword sap_product: Defines the SAP Product type. Required. Known values are: "ECC",
         "S4HANA", and "Other".
        :paramtype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
        :keyword managed_resources_network_access_type: Specifies the network access configuration for
         the resources that will be deployed in the Managed Resource Group. The options to choose from
         are Public and Private. If 'Private' is chosen, the Storage Account service tag should be
         enabled on the subnets in which the SAP VMs exist. This is required for establishing
         connectivity between VM extensions and the managed resource group storage account. This setting
         is currently applicable only to Storage Account. Learn more here
         https://go.microsoft.com/fwlink/?linkid=2247228. Known values are: "Public" and "Private".
        :paramtype managed_resources_network_access_type: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.ManagedResourcesNetworkAccessType
        :keyword configuration: Defines if the SAP system is being created using Azure Center for SAP
         solutions (ACSS) or if an existing SAP system is being registered with ACSS. Required.
        :paramtype configuration: ~azure.mgmt.workloadssapvirtualinstance.models.SAPConfiguration
        :keyword managed_resource_group_configuration: Managed resource group configuration.
        :paramtype managed_resource_group_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.ManagedRGConfiguration
        """
        super().__init__(**kwargs)
        self.environment = environment
        self.sap_product = sap_product
        self.managed_resources_network_access_type = managed_resources_network_access_type
        self.configuration = configuration
        self.managed_resource_group_configuration = managed_resource_group_configuration
        self.status = None
        self.health = None
        self.state = None
        self.provisioning_state = None
        self.errors = None


class ServiceInitiatedSoftwareConfiguration(SoftwareConfiguration):
    """The SAP Software configuration Input when the software is to be installed by service.

    All required parameters must be populated in order to send to Azure.

    :ivar software_installation_type: The SAP software installation Type. Required. Known values
     are: "ServiceInitiated", "SAPInstallWithoutOSConfig", and "External".
    :vartype software_installation_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPSoftwareInstallationType
    :ivar bom_url: The URL to the SAP Build of Materials(BOM) file. Required.
    :vartype bom_url: str
    :ivar software_version: The software version to install. Required.
    :vartype software_version: str
    :ivar sap_bits_storage_account_id: The SAP bits storage account id. Required.
    :vartype sap_bits_storage_account_id: str
    :ivar sap_fqdn: The FQDN to set for the SAP system during install. Required.
    :vartype sap_fqdn: str
    :ivar ssh_private_key: The SSH private key. Required.
    :vartype ssh_private_key: str
    :ivar high_availability_software_configuration: Gets or sets the HA software configuration.
    :vartype high_availability_software_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.HighAvailabilitySoftwareConfiguration
    """

    _validation = {
        "software_installation_type": {"required": True},
        "bom_url": {"required": True},
        "software_version": {"required": True},
        "sap_bits_storage_account_id": {"required": True},
        "sap_fqdn": {"required": True},
        "ssh_private_key": {"required": True},
    }

    _attribute_map = {
        "software_installation_type": {"key": "softwareInstallationType", "type": "str"},
        "bom_url": {"key": "bomUrl", "type": "str"},
        "software_version": {"key": "softwareVersion", "type": "str"},
        "sap_bits_storage_account_id": {"key": "sapBitsStorageAccountId", "type": "str"},
        "sap_fqdn": {"key": "sapFqdn", "type": "str"},
        "ssh_private_key": {"key": "sshPrivateKey", "type": "str"},
        "high_availability_software_configuration": {
            "key": "highAvailabilitySoftwareConfiguration",
            "type": "HighAvailabilitySoftwareConfiguration",
        },
    }

    def __init__(
        self,
        *,
        bom_url: str,
        software_version: str,
        sap_bits_storage_account_id: str,
        sap_fqdn: str,
        ssh_private_key: str,
        high_availability_software_configuration: Optional["_models.HighAvailabilitySoftwareConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bom_url: The URL to the SAP Build of Materials(BOM) file. Required.
        :paramtype bom_url: str
        :keyword software_version: The software version to install. Required.
        :paramtype software_version: str
        :keyword sap_bits_storage_account_id: The SAP bits storage account id. Required.
        :paramtype sap_bits_storage_account_id: str
        :keyword sap_fqdn: The FQDN to set for the SAP system during install. Required.
        :paramtype sap_fqdn: str
        :keyword ssh_private_key: The SSH private key. Required.
        :paramtype ssh_private_key: str
        :keyword high_availability_software_configuration: Gets or sets the HA software configuration.
        :paramtype high_availability_software_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.HighAvailabilitySoftwareConfiguration
        """
        super().__init__(**kwargs)
        self.software_installation_type: str = "ServiceInitiated"
        self.bom_url = bom_url
        self.software_version = software_version
        self.sap_bits_storage_account_id = sap_bits_storage_account_id
        self.sap_fqdn = sap_fqdn
        self.ssh_private_key = ssh_private_key
        self.high_availability_software_configuration = high_availability_software_configuration


class SharedStorageResourceNames(_serialization.Model):
    """The resource names object for shared storage.

    :ivar shared_storage_account_name: The full name of the shared storage account. If it is not
     provided, it will be defaulted to {SID}nfs{guid of 15 chars}.
    :vartype shared_storage_account_name: str
    :ivar shared_storage_account_private_end_point_name: The full name of private end point for the
     shared storage account. If it is not provided, it will be defaulted to {storageAccountName}_pe.
    :vartype shared_storage_account_private_end_point_name: str
    """

    _attribute_map = {
        "shared_storage_account_name": {"key": "sharedStorageAccountName", "type": "str"},
        "shared_storage_account_private_end_point_name": {
            "key": "sharedStorageAccountPrivateEndPointName",
            "type": "str",
        },
    }

    def __init__(
        self,
        *,
        shared_storage_account_name: Optional[str] = None,
        shared_storage_account_private_end_point_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword shared_storage_account_name: The full name of the shared storage account. If it is not
         provided, it will be defaulted to {SID}nfs{guid of 15 chars}.
        :paramtype shared_storage_account_name: str
        :keyword shared_storage_account_private_end_point_name: The full name of private end point for
         the shared storage account. If it is not provided, it will be defaulted to
         {storageAccountName}_pe.
        :paramtype shared_storage_account_private_end_point_name: str
        """
        super().__init__(**kwargs)
        self.shared_storage_account_name = shared_storage_account_name
        self.shared_storage_account_private_end_point_name = shared_storage_account_private_end_point_name


class SingleServerConfiguration(InfrastructureConfiguration):
    """Gets or sets the single server configuration. For prerequisites for creating the
    infrastructure, please see `here
    <https://go.microsoft.com/fwlink/?linkid=2212611&clcid=0x409>`_.

    All required parameters must be populated in order to send to Azure.

    :ivar deployment_type: The type of SAP deployment, single server or Three tier. Required. Known
     values are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    :ivar app_resource_group: The application resource group where SAP system resources will be
     deployed. Required.
    :vartype app_resource_group: str
    :ivar network_configuration: Network configuration for the server.
    :vartype network_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.NetworkConfiguration
    :ivar database_type: The database type. Known values are: "HANA" and "DB2".
    :vartype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
    :ivar subnet_id: The subnet id. Required.
    :vartype subnet_id: str
    :ivar virtual_machine_configuration: Gets or sets the virtual machine configuration. Required.
    :vartype virtual_machine_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineConfiguration
    :ivar db_disk_configuration: Gets or sets the disk configuration.
    :vartype db_disk_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.DiskConfiguration
    :ivar custom_resource_names: The set of custom names to be used for underlying azure resources
     that are part of the SAP system.
    :vartype custom_resource_names:
     ~azure.mgmt.workloadssapvirtualinstance.models.SingleServerCustomResourceNames
    """

    _validation = {
        "deployment_type": {"required": True},
        "app_resource_group": {"required": True},
        "subnet_id": {"required": True},
        "virtual_machine_configuration": {"required": True},
    }

    _attribute_map = {
        "deployment_type": {"key": "deploymentType", "type": "str"},
        "app_resource_group": {"key": "appResourceGroup", "type": "str"},
        "network_configuration": {"key": "networkConfiguration", "type": "NetworkConfiguration"},
        "database_type": {"key": "databaseType", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "virtual_machine_configuration": {"key": "virtualMachineConfiguration", "type": "VirtualMachineConfiguration"},
        "db_disk_configuration": {"key": "dbDiskConfiguration", "type": "DiskConfiguration"},
        "custom_resource_names": {"key": "customResourceNames", "type": "SingleServerCustomResourceNames"},
    }

    def __init__(
        self,
        *,
        app_resource_group: str,
        subnet_id: str,
        virtual_machine_configuration: "_models.VirtualMachineConfiguration",
        network_configuration: Optional["_models.NetworkConfiguration"] = None,
        database_type: Optional[Union[str, "_models.SAPDatabaseType"]] = None,
        db_disk_configuration: Optional["_models.DiskConfiguration"] = None,
        custom_resource_names: Optional["_models.SingleServerCustomResourceNames"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword app_resource_group: The application resource group where SAP system resources will be
         deployed. Required.
        :paramtype app_resource_group: str
        :keyword network_configuration: Network configuration for the server.
        :paramtype network_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.NetworkConfiguration
        :keyword database_type: The database type. Known values are: "HANA" and "DB2".
        :paramtype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
        :keyword subnet_id: The subnet id. Required.
        :paramtype subnet_id: str
        :keyword virtual_machine_configuration: Gets or sets the virtual machine configuration.
         Required.
        :paramtype virtual_machine_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineConfiguration
        :keyword db_disk_configuration: Gets or sets the disk configuration.
        :paramtype db_disk_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.DiskConfiguration
        :keyword custom_resource_names: The set of custom names to be used for underlying azure
         resources that are part of the SAP system.
        :paramtype custom_resource_names:
         ~azure.mgmt.workloadssapvirtualinstance.models.SingleServerCustomResourceNames
        """
        super().__init__(app_resource_group=app_resource_group, **kwargs)
        self.deployment_type: str = "SingleServer"
        self.network_configuration = network_configuration
        self.database_type = database_type
        self.subnet_id = subnet_id
        self.virtual_machine_configuration = virtual_machine_configuration
        self.db_disk_configuration = db_disk_configuration
        self.custom_resource_names = custom_resource_names


class SingleServerCustomResourceNames(_serialization.Model):
    """The resource-names input to specify custom names for underlying azure resources that are part
    of a single server SAP system.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SingleServerFullResourceNames

    All required parameters must be populated in order to send to Azure.

    :ivar naming_pattern_type: The pattern type to be used for resource naming. Required.
     "FullResourceName"
    :vartype naming_pattern_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.NamingPatternType
    """

    _validation = {
        "naming_pattern_type": {"required": True},
    }

    _attribute_map = {
        "naming_pattern_type": {"key": "namingPatternType", "type": "str"},
    }

    _subtype_map = {"naming_pattern_type": {"FullResourceName": "SingleServerFullResourceNames"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.naming_pattern_type: Optional[str] = None


class SingleServerFullResourceNames(SingleServerCustomResourceNames):
    """The resource name object where the specified values will be full resource names of the
    corresponding resources in a single server SAP system.

    All required parameters must be populated in order to send to Azure.

    :ivar naming_pattern_type: The pattern type to be used for resource naming. Required.
     "FullResourceName"
    :vartype naming_pattern_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.NamingPatternType
    :ivar virtual_machine: The resource names object for virtual machine and related resources.
    :vartype virtual_machine:
     ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineResourceNames
    """

    _validation = {
        "naming_pattern_type": {"required": True},
    }

    _attribute_map = {
        "naming_pattern_type": {"key": "namingPatternType", "type": "str"},
        "virtual_machine": {"key": "virtualMachine", "type": "VirtualMachineResourceNames"},
    }

    def __init__(
        self, *, virtual_machine: Optional["_models.VirtualMachineResourceNames"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword virtual_machine: The resource names object for virtual machine and related resources.
        :paramtype virtual_machine:
         ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineResourceNames
        """
        super().__init__(**kwargs)
        self.naming_pattern_type: str = "FullResourceName"
        self.virtual_machine = virtual_machine


class SingleServerRecommendationResult(SAPSizingRecommendationResult):
    """The recommended configuration for a single server SAP system.

    All required parameters must be populated in order to send to Azure.

    :ivar deployment_type: The type of SAP deployment, single server or Three tier. Required. Known
     values are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    :ivar vm_sku: The recommended VM SKU for single server.
    :vartype vm_sku: str
    """

    _validation = {
        "deployment_type": {"required": True},
    }

    _attribute_map = {
        "deployment_type": {"key": "deploymentType", "type": "str"},
        "vm_sku": {"key": "vmSku", "type": "str"},
    }

    def __init__(self, *, vm_sku: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword vm_sku: The recommended VM SKU for single server.
        :paramtype vm_sku: str
        """
        super().__init__(**kwargs)
        self.deployment_type: str = "SingleServer"
        self.vm_sku = vm_sku


class SkipFileShareConfiguration(FileShareConfiguration):
    """Gets or sets the file share configuration for scenarios where transport directory fileshare is
    not created or required.

    All required parameters must be populated in order to send to Azure.

    :ivar configuration_type: The type of file share config. Required. Known values are: "Skip",
     "CreateAndMount", and "Mount".
    :vartype configuration_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.ConfigurationType
    """

    _validation = {
        "configuration_type": {"required": True},
    }

    _attribute_map = {
        "configuration_type": {"key": "configurationType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.configuration_type: str = "Skip"


class SshConfiguration(_serialization.Model):
    """SSH configuration for Linux based VMs running on Azure.

    :ivar public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :vartype public_keys: list[~azure.mgmt.workloadssapvirtualinstance.models.SshPublicKey]
    """

    _attribute_map = {
        "public_keys": {"key": "publicKeys", "type": "[SshPublicKey]"},
    }

    def __init__(self, *, public_keys: Optional[List["_models.SshPublicKey"]] = None, **kwargs: Any) -> None:
        """
        :keyword public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        :paramtype public_keys: list[~azure.mgmt.workloadssapvirtualinstance.models.SshPublicKey]
        """
        super().__init__(**kwargs)
        self.public_keys = public_keys


class SshKeyPair(_serialization.Model):
    """The SSH Key-pair used to authenticate with the VM. The key needs to be at least 2048-bit and in
    ssh-rsa format. :code:`<br>`:code:`<br>` For creating ssh keys, see `Create SSH keys on Linux
    and Mac for Linux VMs in Azure
    <https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed>`_.

    :ivar public_key: SSH public key.
    :vartype public_key: str
    :ivar private_key: SSH private key.
    :vartype private_key: str
    """

    _attribute_map = {
        "public_key": {"key": "publicKey", "type": "str"},
        "private_key": {"key": "privateKey", "type": "str"},
    }

    def __init__(self, *, public_key: Optional[str] = None, private_key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword public_key: SSH public key.
        :paramtype public_key: str
        :keyword private_key: SSH private key.
        :paramtype private_key: str
        """
        super().__init__(**kwargs)
        self.public_key = public_key
        self.private_key = private_key


class SshPublicKey(_serialization.Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the
    public key is placed.

    :ivar key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
     ssh keys, see `Create SSH keys on Linux and Mac for Linux VMs in Azure
     <https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed>`_.
    :vartype key_data: str
    """

    _attribute_map = {
        "key_data": {"key": "keyData", "type": "str"},
    }

    def __init__(self, *, key_data: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key_data: SSH public key certificate used to authenticate with the VM through ssh. The
         key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
         ssh keys, see `Create SSH keys on Linux and Mac for Linux VMs in Azure
         <https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed>`_.
        :paramtype key_data: str
        """
        super().__init__(**kwargs)
        self.key_data = key_data


class StartRequest(_serialization.Model):
    """Start SAP instance(s) request body.

    :ivar start_vm: The boolean value indicates whether to start the virtual machines before
     starting the SAP instances.
    :vartype start_vm: bool
    """

    _attribute_map = {
        "start_vm": {"key": "startVm", "type": "bool"},
    }

    def __init__(self, *, start_vm: bool = False, **kwargs: Any) -> None:
        """
        :keyword start_vm: The boolean value indicates whether to start the virtual machines before
         starting the SAP instances.
        :paramtype start_vm: bool
        """
        super().__init__(**kwargs)
        self.start_vm = start_vm


class StopRequest(_serialization.Model):
    """Stop SAP instance(s) request body.

    :ivar soft_stop_timeout_seconds: This parameter defines how long (in seconds) the soft shutdown
     waits until the RFC/HTTP clients no longer consider the server for calls with load balancing.
     Value 0 means that the kernel does not wait, but goes directly into the next shutdown state,
     i.e. hard stop.
    :vartype soft_stop_timeout_seconds: int
    :ivar deallocate_vm: The boolean value indicates whether to Stop and deallocate the virtual
     machines along with the SAP instances.
    :vartype deallocate_vm: bool
    """

    _attribute_map = {
        "soft_stop_timeout_seconds": {"key": "softStopTimeoutSeconds", "type": "int"},
        "deallocate_vm": {"key": "deallocateVm", "type": "bool"},
    }

    def __init__(self, *, soft_stop_timeout_seconds: int = 0, deallocate_vm: bool = False, **kwargs: Any) -> None:
        """
        :keyword soft_stop_timeout_seconds: This parameter defines how long (in seconds) the soft
         shutdown waits until the RFC/HTTP clients no longer consider the server for calls with load
         balancing. Value 0 means that the kernel does not wait, but goes directly into the next
         shutdown state, i.e. hard stop.
        :paramtype soft_stop_timeout_seconds: int
        :keyword deallocate_vm: The boolean value indicates whether to Stop and deallocate the virtual
         machines along with the SAP instances.
        :paramtype deallocate_vm: bool
        """
        super().__init__(**kwargs)
        self.soft_stop_timeout_seconds = soft_stop_timeout_seconds
        self.deallocate_vm = deallocate_vm


class StorageConfiguration(_serialization.Model):
    """Gets or sets the storage configuration.

    :ivar transport_file_share_configuration: The properties of the transport directory attached to
     the VIS. The default for transportFileShareConfiguration is the createAndMount flow if storage
     configuration is missing.
    :vartype transport_file_share_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.FileShareConfiguration
    """

    _attribute_map = {
        "transport_file_share_configuration": {
            "key": "transportFileShareConfiguration",
            "type": "FileShareConfiguration",
        },
    }

    def __init__(
        self, *, transport_file_share_configuration: Optional["_models.FileShareConfiguration"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword transport_file_share_configuration: The properties of the transport directory attached
         to the VIS. The default for transportFileShareConfiguration is the createAndMount flow if
         storage configuration is missing.
        :paramtype transport_file_share_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.FileShareConfiguration
        """
        super().__init__(**kwargs)
        self.transport_file_share_configuration = transport_file_share_configuration


class StorageInformation(_serialization.Model):
    """Storage details of all the Storage accounts attached to the VM. For e.g. NFS on AFS Shared
    Storage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class ThreeTierConfiguration(InfrastructureConfiguration):
    """Gets or sets the three tier SAP configuration. For prerequisites for creating the
    infrastructure, please see `here
    <https://go.microsoft.com/fwlink/?linkid=2212611&clcid=0x409>`_.

    All required parameters must be populated in order to send to Azure.

    :ivar deployment_type: The type of SAP deployment, single server or Three tier. Required. Known
     values are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    :ivar app_resource_group: The application resource group where SAP system resources will be
     deployed. Required.
    :vartype app_resource_group: str
    :ivar network_configuration: Network configuration common to all servers.
    :vartype network_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.NetworkConfiguration
    :ivar central_server: The central server configuration. Required.
    :vartype central_server:
     ~azure.mgmt.workloadssapvirtualinstance.models.CentralServerConfiguration
    :ivar application_server: The application server configuration. Required.
    :vartype application_server:
     ~azure.mgmt.workloadssapvirtualinstance.models.ApplicationServerConfiguration
    :ivar database_server: The database configuration. Required.
    :vartype database_server: ~azure.mgmt.workloadssapvirtualinstance.models.DatabaseConfiguration
    :ivar high_availability_config: The high availability configuration.
    :vartype high_availability_config:
     ~azure.mgmt.workloadssapvirtualinstance.models.HighAvailabilityConfiguration
    :ivar storage_configuration: The storage configuration.
    :vartype storage_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.StorageConfiguration
    :ivar custom_resource_names: The set of custom names to be used for underlying azure resources
     that are part of the SAP system.
    :vartype custom_resource_names:
     ~azure.mgmt.workloadssapvirtualinstance.models.ThreeTierCustomResourceNames
    """

    _validation = {
        "deployment_type": {"required": True},
        "app_resource_group": {"required": True},
        "central_server": {"required": True},
        "application_server": {"required": True},
        "database_server": {"required": True},
    }

    _attribute_map = {
        "deployment_type": {"key": "deploymentType", "type": "str"},
        "app_resource_group": {"key": "appResourceGroup", "type": "str"},
        "network_configuration": {"key": "networkConfiguration", "type": "NetworkConfiguration"},
        "central_server": {"key": "centralServer", "type": "CentralServerConfiguration"},
        "application_server": {"key": "applicationServer", "type": "ApplicationServerConfiguration"},
        "database_server": {"key": "databaseServer", "type": "DatabaseConfiguration"},
        "high_availability_config": {"key": "highAvailabilityConfig", "type": "HighAvailabilityConfiguration"},
        "storage_configuration": {"key": "storageConfiguration", "type": "StorageConfiguration"},
        "custom_resource_names": {"key": "customResourceNames", "type": "ThreeTierCustomResourceNames"},
    }

    def __init__(
        self,
        *,
        app_resource_group: str,
        central_server: "_models.CentralServerConfiguration",
        application_server: "_models.ApplicationServerConfiguration",
        database_server: "_models.DatabaseConfiguration",
        network_configuration: Optional["_models.NetworkConfiguration"] = None,
        high_availability_config: Optional["_models.HighAvailabilityConfiguration"] = None,
        storage_configuration: Optional["_models.StorageConfiguration"] = None,
        custom_resource_names: Optional["_models.ThreeTierCustomResourceNames"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword app_resource_group: The application resource group where SAP system resources will be
         deployed. Required.
        :paramtype app_resource_group: str
        :keyword network_configuration: Network configuration common to all servers.
        :paramtype network_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.NetworkConfiguration
        :keyword central_server: The central server configuration. Required.
        :paramtype central_server:
         ~azure.mgmt.workloadssapvirtualinstance.models.CentralServerConfiguration
        :keyword application_server: The application server configuration. Required.
        :paramtype application_server:
         ~azure.mgmt.workloadssapvirtualinstance.models.ApplicationServerConfiguration
        :keyword database_server: The database configuration. Required.
        :paramtype database_server:
         ~azure.mgmt.workloadssapvirtualinstance.models.DatabaseConfiguration
        :keyword high_availability_config: The high availability configuration.
        :paramtype high_availability_config:
         ~azure.mgmt.workloadssapvirtualinstance.models.HighAvailabilityConfiguration
        :keyword storage_configuration: The storage configuration.
        :paramtype storage_configuration:
         ~azure.mgmt.workloadssapvirtualinstance.models.StorageConfiguration
        :keyword custom_resource_names: The set of custom names to be used for underlying azure
         resources that are part of the SAP system.
        :paramtype custom_resource_names:
         ~azure.mgmt.workloadssapvirtualinstance.models.ThreeTierCustomResourceNames
        """
        super().__init__(app_resource_group=app_resource_group, **kwargs)
        self.deployment_type: str = "ThreeTier"
        self.network_configuration = network_configuration
        self.central_server = central_server
        self.application_server = application_server
        self.database_server = database_server
        self.high_availability_config = high_availability_config
        self.storage_configuration = storage_configuration
        self.custom_resource_names = custom_resource_names


class ThreeTierCustomResourceNames(_serialization.Model):
    """The resource-names input to specify custom names for underlying azure resources that are part
    of a three tier SAP system.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ThreeTierFullResourceNames

    All required parameters must be populated in order to send to Azure.

    :ivar naming_pattern_type: The pattern type to be used for resource naming. Required.
     "FullResourceName"
    :vartype naming_pattern_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.NamingPatternType
    """

    _validation = {
        "naming_pattern_type": {"required": True},
    }

    _attribute_map = {
        "naming_pattern_type": {"key": "namingPatternType", "type": "str"},
    }

    _subtype_map = {"naming_pattern_type": {"FullResourceName": "ThreeTierFullResourceNames"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.naming_pattern_type: Optional[str] = None


class ThreeTierFullResourceNames(ThreeTierCustomResourceNames):
    """The resource name object where the specified values will be full resource names of the
    corresponding resources in a three tier SAP system.

    All required parameters must be populated in order to send to Azure.

    :ivar naming_pattern_type: The pattern type to be used for resource naming. Required.
     "FullResourceName"
    :vartype naming_pattern_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.NamingPatternType
    :ivar central_server: The full resource names object for central server layer resources.
    :vartype central_server:
     ~azure.mgmt.workloadssapvirtualinstance.models.CentralServerFullResourceNames
    :ivar application_server: The full resource names object for application layer resources. The
     number of entries in this list should be equal to the number VMs to be created for application
     layer.
    :vartype application_server:
     ~azure.mgmt.workloadssapvirtualinstance.models.ApplicationServerFullResourceNames
    :ivar database_server: The full resource names object for database layer resources. The number
     of entries in this list should be equal to the number VMs to be created for database layer.
    :vartype database_server:
     ~azure.mgmt.workloadssapvirtualinstance.models.DatabaseServerFullResourceNames
    :ivar shared_storage: The resource names object for shared storage.
    :vartype shared_storage:
     ~azure.mgmt.workloadssapvirtualinstance.models.SharedStorageResourceNames
    """

    _validation = {
        "naming_pattern_type": {"required": True},
    }

    _attribute_map = {
        "naming_pattern_type": {"key": "namingPatternType", "type": "str"},
        "central_server": {"key": "centralServer", "type": "CentralServerFullResourceNames"},
        "application_server": {"key": "applicationServer", "type": "ApplicationServerFullResourceNames"},
        "database_server": {"key": "databaseServer", "type": "DatabaseServerFullResourceNames"},
        "shared_storage": {"key": "sharedStorage", "type": "SharedStorageResourceNames"},
    }

    def __init__(
        self,
        *,
        central_server: Optional["_models.CentralServerFullResourceNames"] = None,
        application_server: Optional["_models.ApplicationServerFullResourceNames"] = None,
        database_server: Optional["_models.DatabaseServerFullResourceNames"] = None,
        shared_storage: Optional["_models.SharedStorageResourceNames"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword central_server: The full resource names object for central server layer resources.
        :paramtype central_server:
         ~azure.mgmt.workloadssapvirtualinstance.models.CentralServerFullResourceNames
        :keyword application_server: The full resource names object for application layer resources.
         The number of entries in this list should be equal to the number VMs to be created for
         application layer.
        :paramtype application_server:
         ~azure.mgmt.workloadssapvirtualinstance.models.ApplicationServerFullResourceNames
        :keyword database_server: The full resource names object for database layer resources. The
         number of entries in this list should be equal to the number VMs to be created for database
         layer.
        :paramtype database_server:
         ~azure.mgmt.workloadssapvirtualinstance.models.DatabaseServerFullResourceNames
        :keyword shared_storage: The resource names object for shared storage.
        :paramtype shared_storage:
         ~azure.mgmt.workloadssapvirtualinstance.models.SharedStorageResourceNames
        """
        super().__init__(**kwargs)
        self.naming_pattern_type: str = "FullResourceName"
        self.central_server = central_server
        self.application_server = application_server
        self.database_server = database_server
        self.shared_storage = shared_storage


class ThreeTierRecommendationResult(SAPSizingRecommendationResult):
    """The recommended configuration for a three tier SAP system.

    All required parameters must be populated in order to send to Azure.

    :ivar deployment_type: The type of SAP deployment, single server or Three tier. Required. Known
     values are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    :ivar db_vm_sku: The database VM SKU.
    :vartype db_vm_sku: str
    :ivar database_instance_count: The database server instance count.
    :vartype database_instance_count: int
    :ivar central_server_vm_sku: The central server VM SKU.
    :vartype central_server_vm_sku: str
    :ivar central_server_instance_count: The central server instance count.
    :vartype central_server_instance_count: int
    :ivar application_server_vm_sku: The application server VM SKU.
    :vartype application_server_vm_sku: str
    :ivar application_server_instance_count: The application server instance count.
    :vartype application_server_instance_count: int
    """

    _validation = {
        "deployment_type": {"required": True},
    }

    _attribute_map = {
        "deployment_type": {"key": "deploymentType", "type": "str"},
        "db_vm_sku": {"key": "dbVmSku", "type": "str"},
        "database_instance_count": {"key": "databaseInstanceCount", "type": "int"},
        "central_server_vm_sku": {"key": "centralServerVmSku", "type": "str"},
        "central_server_instance_count": {"key": "centralServerInstanceCount", "type": "int"},
        "application_server_vm_sku": {"key": "applicationServerVmSku", "type": "str"},
        "application_server_instance_count": {"key": "applicationServerInstanceCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        db_vm_sku: Optional[str] = None,
        database_instance_count: Optional[int] = None,
        central_server_vm_sku: Optional[str] = None,
        central_server_instance_count: Optional[int] = None,
        application_server_vm_sku: Optional[str] = None,
        application_server_instance_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword db_vm_sku: The database VM SKU.
        :paramtype db_vm_sku: str
        :keyword database_instance_count: The database server instance count.
        :paramtype database_instance_count: int
        :keyword central_server_vm_sku: The central server VM SKU.
        :paramtype central_server_vm_sku: str
        :keyword central_server_instance_count: The central server instance count.
        :paramtype central_server_instance_count: int
        :keyword application_server_vm_sku: The application server VM SKU.
        :paramtype application_server_vm_sku: str
        :keyword application_server_instance_count: The application server instance count.
        :paramtype application_server_instance_count: int
        """
        super().__init__(**kwargs)
        self.deployment_type: str = "ThreeTier"
        self.db_vm_sku = db_vm_sku
        self.database_instance_count = database_instance_count
        self.central_server_vm_sku = central_server_vm_sku
        self.central_server_instance_count = central_server_instance_count
        self.application_server_vm_sku = application_server_vm_sku
        self.application_server_instance_count = application_server_instance_count


class UpdateSAPApplicationInstanceRequest(_serialization.Model):
    """Defines the request body for updating SAP Application Instance.

    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Gets or sets the Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class UpdateSAPCentralInstanceRequest(_serialization.Model):
    """Defines the request body for updating SAP Central Instance.

    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Gets or sets the Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class UpdateSAPDatabaseInstanceRequest(_serialization.Model):
    """Defines the request body for updating SAP Database Instance.

    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Gets or sets the Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class UpdateSAPVirtualInstanceProperties(_serialization.Model):
    """Defines the properties to be updated for Virtual Instance for SAP.

    :ivar managed_resources_network_access_type: Specifies the network access configuration for the
     resources that will be deployed in the Managed Resource Group. The options to choose from are
     Public and Private. If 'Private' is chosen, the Storage Account service tag should be enabled
     on the subnets in which the SAP VMs exist. This is required for establishing connectivity
     between VM extensions and the managed resource group storage account. This setting is currently
     applicable only to Storage Account. Learn more here
     https://go.microsoft.com/fwlink/?linkid=2247228. Known values are: "Public" and "Private".
    :vartype managed_resources_network_access_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.ManagedResourcesNetworkAccessType
    """

    _attribute_map = {
        "managed_resources_network_access_type": {"key": "managedResourcesNetworkAccessType", "type": "str"},
    }

    def __init__(
        self,
        *,
        managed_resources_network_access_type: Optional[Union[str, "_models.ManagedResourcesNetworkAccessType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_resources_network_access_type: Specifies the network access configuration for
         the resources that will be deployed in the Managed Resource Group. The options to choose from
         are Public and Private. If 'Private' is chosen, the Storage Account service tag should be
         enabled on the subnets in which the SAP VMs exist. This is required for establishing
         connectivity between VM extensions and the managed resource group storage account. This setting
         is currently applicable only to Storage Account. Learn more here
         https://go.microsoft.com/fwlink/?linkid=2247228. Known values are: "Public" and "Private".
        :paramtype managed_resources_network_access_type: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.ManagedResourcesNetworkAccessType
        """
        super().__init__(**kwargs)
        self.managed_resources_network_access_type = managed_resources_network_access_type


class UpdateSAPVirtualInstanceRequest(_serialization.Model):
    """Defines the request body for updating Virtual Instance for SAP.

    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity (user assigned identities).
    :vartype identity: ~azure.mgmt.workloadssapvirtualinstance.models.UserAssignedServiceIdentity
    :ivar properties: Defines the properties to be updated for Virtual Instance for SAP.
    :vartype properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.UpdateSAPVirtualInstanceProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "UserAssignedServiceIdentity"},
        "properties": {"key": "properties", "type": "UpdateSAPVirtualInstanceProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.UserAssignedServiceIdentity"] = None,
        properties: Optional["_models.UpdateSAPVirtualInstanceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Gets or sets the Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed service identity (user assigned identities).
        :paramtype identity: ~azure.mgmt.workloadssapvirtualinstance.models.UserAssignedServiceIdentity
        :keyword properties: Defines the properties to be updated for Virtual Instance for SAP.
        :paramtype properties:
         ~azure.mgmt.workloadssapvirtualinstance.models.UpdateSAPVirtualInstanceProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.properties = properties


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class UserAssignedServiceIdentity(_serialization.Model):
    """Managed service identity (user assigned identities).

    All required parameters must be populated in order to send to Azure.

    :ivar type: Type of manage identity. Required. Known values are: "None" and "UserAssigned".
    :vartype type: str or ~azure.mgmt.workloadssapvirtualinstance.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: User assigned identities dictionary.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.workloadssapvirtualinstance.models.UserAssignedIdentity]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of manage identity. Required. Known values are: "None" and "UserAssigned".
        :paramtype type: str or
         ~azure.mgmt.workloadssapvirtualinstance.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: User assigned identities dictionary.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.workloadssapvirtualinstance.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class VirtualMachineConfiguration(_serialization.Model):
    """Defines the virtual machine configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar vm_size: The virtual machine size. Required.
    :vartype vm_size: str
    :ivar image_reference: The image reference. Required.
    :vartype image_reference: ~azure.mgmt.workloadssapvirtualinstance.models.ImageReference
    :ivar os_profile: The OS profile. Required.
    :vartype os_profile: ~azure.mgmt.workloadssapvirtualinstance.models.OSProfile
    """

    _validation = {
        "vm_size": {"required": True},
        "image_reference": {"required": True},
        "os_profile": {"required": True},
    }

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_profile": {"key": "osProfile", "type": "OSProfile"},
    }

    def __init__(
        self, *, vm_size: str, image_reference: "_models.ImageReference", os_profile: "_models.OSProfile", **kwargs: Any
    ) -> None:
        """
        :keyword vm_size: The virtual machine size. Required.
        :paramtype vm_size: str
        :keyword image_reference: The image reference. Required.
        :paramtype image_reference: ~azure.mgmt.workloadssapvirtualinstance.models.ImageReference
        :keyword os_profile: The OS profile. Required.
        :paramtype os_profile: ~azure.mgmt.workloadssapvirtualinstance.models.OSProfile
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size
        self.image_reference = image_reference
        self.os_profile = os_profile


class VirtualMachineResourceNames(_serialization.Model):
    """The resource names object for virtual machine and related resources.

    :ivar vm_name: The full name for virtual machine. The length of this field can be upto 64
     characters. If name is not provided, service uses a default name based on the deployment type.
     For SingleServer, default name is {SID}vm. In case of HA-AvZone systems, default name will be
     {SID}{app/ascs/db}z{a/b}vm with an incrementor at the end in case of more than 1 vm per layer.
     For distributed and HA-AvSet systems, default name will be {SID}{app/ascs/db}vm with an
     incrementor at the end in case of more than 1 vm per layer.
    :vartype vm_name: str
    :ivar host_name: The full name for virtual-machine's host (computer name). Currently, ACSS only
     supports host names which are less than or equal to 13 characters long. If this value is not
     provided, vmName will be used as host name.
    :vartype host_name: str
    :ivar network_interfaces: The list of network interface name objects for the selected virtual
     machine. Currently, only one network interface is supported per virtual machine.
    :vartype network_interfaces:
     list[~azure.mgmt.workloadssapvirtualinstance.models.NetworkInterfaceResourceNames]
    :ivar os_disk_name: The full name for OS disk attached to the VM. If this value is not
     provided, it will be named by ARM as per its default naming standards (prefixed with vm name).
     There is only one OS disk attached per Virtual Machine.
    :vartype os_disk_name: str
    :ivar data_disk_names: The full resource names for virtual machine data disks. This is a
     dictionary containing list of names of data disks per volume. Currently supported volumes for
     database layer are ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For
     application and cs layers, only 'default' volume is supported.
    :vartype data_disk_names: dict[str, list[str]]
    """

    _validation = {
        "network_interfaces": {"max_items": 1, "min_items": 0},
    }

    _attribute_map = {
        "vm_name": {"key": "vmName", "type": "str"},
        "host_name": {"key": "hostName", "type": "str"},
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterfaceResourceNames]"},
        "os_disk_name": {"key": "osDiskName", "type": "str"},
        "data_disk_names": {"key": "dataDiskNames", "type": "{[str]}"},
    }

    def __init__(
        self,
        *,
        vm_name: Optional[str] = None,
        host_name: Optional[str] = None,
        network_interfaces: Optional[List["_models.NetworkInterfaceResourceNames"]] = None,
        os_disk_name: Optional[str] = None,
        data_disk_names: Optional[Dict[str, List[str]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_name: The full name for virtual machine. The length of this field can be upto 64
         characters. If name is not provided, service uses a default name based on the deployment type.
         For SingleServer, default name is {SID}vm. In case of HA-AvZone systems, default name will be
         {SID}{app/ascs/db}z{a/b}vm with an incrementor at the end in case of more than 1 vm per layer.
         For distributed and HA-AvSet systems, default name will be {SID}{app/ascs/db}vm with an
         incrementor at the end in case of more than 1 vm per layer.
        :paramtype vm_name: str
        :keyword host_name: The full name for virtual-machine's host (computer name). Currently, ACSS
         only supports host names which are less than or equal to 13 characters long. If this value is
         not provided, vmName will be used as host name.
        :paramtype host_name: str
        :keyword network_interfaces: The list of network interface name objects for the selected
         virtual machine. Currently, only one network interface is supported per virtual machine.
        :paramtype network_interfaces:
         list[~azure.mgmt.workloadssapvirtualinstance.models.NetworkInterfaceResourceNames]
        :keyword os_disk_name: The full name for OS disk attached to the VM. If this value is not
         provided, it will be named by ARM as per its default naming standards (prefixed with vm name).
         There is only one OS disk attached per Virtual Machine.
        :paramtype os_disk_name: str
        :keyword data_disk_names: The full resource names for virtual machine data disks. This is a
         dictionary containing list of names of data disks per volume. Currently supported volumes for
         database layer are ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For
         application and cs layers, only 'default' volume is supported.
        :paramtype data_disk_names: dict[str, list[str]]
        """
        super().__init__(**kwargs)
        self.vm_name = vm_name
        self.host_name = host_name
        self.network_interfaces = network_interfaces
        self.os_disk_name = os_disk_name
        self.data_disk_names = data_disk_names


class WindowsConfiguration(OSConfiguration):
    """Specifies Windows operating system settings on the virtual machine.

    All required parameters must be populated in order to send to Azure.

    :ivar os_type: The OS Type. Required. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.OSType
    """

    _validation = {
        "os_type": {"required": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.os_type: str = "Windows"
