% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchReduce.R
\name{batchReduce}
\alias{batchReduce}
\title{Reduce Operation for Batch Systems}
\usage{
batchReduce(
  fun,
  xs,
  init = NULL,
  chunks = seq_along(xs),
  more.args = list(),
  reg = getDefaultRegistry()
)
}
\arguments{
\item{fun}{[\code{function(aggr, x, ...)}]\cr
Function to reduce \code{xs} with.}

\item{xs}{[\code{vector}]\cr
Vector to reduce.}

\item{init}{[ANY]\cr
Initial object for reducing. See \code{\link[base]{Reduce}}.}

\item{chunks}{[\code{integer(length(xs))}]\cr
Group for each element of \code{xs}. Can be generated with \code{\link{chunk}}.}

\item{more.args}{[\code{list}]\cr
A list of additional arguments passed to \code{fun}.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{\link{data.table}}] with ids of added jobs stored in column \dQuote{job.id}.
}
\description{
A parallel and asynchronous \code{\link[base]{Reduce}} for batch systems.
Note that this function only defines the computational jobs.
Each job reduces a certain number of elements on one slave.
The actual computation is started with \code{\link{submitJobs}}.
Results and partial results can be collected with \code{\link{reduceResultsList}}, \code{\link{reduceResults}} or
\code{\link{loadResult}}.
}
\examples{
\dontshow{ batchtools:::example_push_temp(1) }
# define function to reduce on slave, we want to sum a vector
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
xs = 1:100
f = function(aggr, x) aggr + x

# sum 20 numbers on each slave process, i.e. 5 jobs
chunks = chunk(xs, chunk.size = 5)
batchReduce(fun = f, 1:100, init = 0, chunks = chunks, reg = tmp)
submitJobs(reg = tmp)
waitForJobs(reg = tmp)

# now reduce one final time on master
reduceResults(fun = function(aggr, job, res) f(aggr, res), reg = tmp)
}
\seealso{
\code{\link{batchMap}}
}
