// SPDX-FileCopyrightText: 2016 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include "suspenddialog.h"
#if (defined QT_DEBUG) && (defined CHECK_ACCESSIBLENAME)
#include "../common/accessibilitycheckerex.h"
#endif

#include <DApplication>

#include <QTranslator>

int main(int argc, char *argv[])
{
    DApplication app(argc, argv);
    app.setOrganizationName("deepin");
    app.setApplicationName("dde-suspend-dialog");

    QTranslator translator;
    if (translator.load("/usr/share/dde-session-ui/translations/dde-session-ui_" + QLocale::system().name())) {
        app.installTranslator(&translator);
    }

    if (!app.setSingleInstance(app.applicationName(), DApplication::UserScope)) {
        return -1;
    }

    Manager manager;
    QObject::connect(&manager, &Manager::finished, [] (const int code) {
        if (code == 0) {
            qApp->exit(1);
        } else {
            qApp->exit(0);
        }
    });
#if (defined QT_DEBUG) && (defined CHECK_ACCESSIBLENAME)
    AccessibilityCheckerEx checker;
    checker.setOutputFormat(DAccessibilityChecker::FullFormat);
    checker.start();
#endif
    return app.exec();
}
