#pragma once

/****************************************************************************************
 ** GitQlient is an application to manage and operate one or several Git repositories. With
 ** GitQlient you will be able to add commits, branches and manage all the options Git provides.
 ** Copyright (C) 2021  Francesc Martinez
 **
 ** LinkedIn: www.linkedin.com/in/cescmm/
 ** Web: www.francescmm.com
 **
 ** This program is free software; you can redistribute it and/or
 ** modify it under the terms of the GNU Lesser General Public
 ** License as published by the Free Software Foundation; either
 ** version 2 of the License, or (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 ** Lesser General Public License for more details.
 **
 ** You should have received a copy of the GNU Lesser General Public
 ** License along with this library; if not, write to the Free Software
 ** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ***************************************************************************************/

#include <QColor>

static const QColor textColorDark(255, 255, 255);
static const QColor textColorBright(0, 0, 0);
static const QColor gitQlientOrange(216, 144, 0); //#D89000
static const QColor graphSelectionColorDark(80, 81, 82); //#505152
static const QColor graphSelectionColorBright(198, 198, 199); //#C6C6C7
static const QColor graphHoverColorDark(64, 65, 66); //#404142
static const QColor graphHoverColorBright(239, 239, 239); //#EFEFEF
static const QColor graphBackgroundColorDark(46, 47, 48); //#2E2F30
static const QColor graphBackgroundColorBright(255, 255, 255); //#FFFFFF
static const QColor graphBlueDark(87, 155, 213); //#579BD5
static const QColor graphBlueBright(50, 92, 199); //#325CC7
static const QColor graphRed(255, 34, 34); //#FF2222
static const QColor graphGreen(101, 149, 43); //#65952B
static const QColor graphOrange(255, 147, 32); //#FF9320
static const QColor graphGrey(132, 132, 132); //#848484
static const QColor graphPink(255, 121, 198); //#FF79C6
static const QColor graphPastel(205, 144, 119); //#CD9077
static const QColor graphCurrentBranch(0, 91, 150); //#005B96
static const QColor graphLocalBranch(100, 151, 177); //#6497B1
static const QColor graphRemoteBranch(1, 31, 75); //#011F4B
static const QColor graphDetached(133, 30, 62); //#851E3E
static const QColor graphTag(222, 195, 195); //#DEC3C3
static const QColor highlightCommentStart(64, 65, 66); //#404142
static const QColor highlightCommentEnd(96, 97, 98); //#606162
static const QColor jenkinsResultSuccess(0, 175, 24); //#00AF18
static const QColor jenkinsResultFailure(193, 32, 32); //#C12020
static const QColor jenkinsResultAborted(91, 91, 91); //#5B5B5B
static const QColor jenkinsResultNotBuilt(200, 200, 200); //#C8C8C8
