#include "meetingassistant.h"
#include <QtDBus>

using namespace uos_ai;
MeetingAssistant::MeetingAssistant()
{
    if (true)
    {
        return;
    }
    
    connect(&m_audioInterface, &AudioInterface::sigMeetingSceneChanged, this, &MeetingAssistant::onMeetingSceneChanged);
    m_audioInterface.moveToThread(&workThread);


    connect(&m_meetingMonitor, &MeetingMonitor::sigIsMileMeetingRunning, this, &MeetingAssistant::onIsMileMeetingRunning);
    connect(this, &MeetingAssistant::sigStartAiMeeting, &m_meetingMonitor, &MeetingMonitor::onStartAiMeeting);
    m_meetingMonitor.moveToThread(&workThread);

    workThread.start();
}

MeetingAssistant::MeetAssistantStatus MeetingAssistant::getNowMeetAssistantStatus()
{
    if (true)
    {
        return HideAll;
    }
    
    if(m_isDetectedMeetingScene){
        if(m_meetingAssistantRunning){
            return ShowIcon;
        }else {
            return ShowAll;
        }
    }else {
        if(m_meetingAssistantRunning){
            return ShowIcon;
        }else {
            return HideAll;
        }
    }
}

void MeetingAssistant::onMeetingSceneChanged(bool isMeetingScene)
{
    m_isDetectedMeetingScene = isMeetingScene;
    statusChanged(MeetingSceneRole);
}

void MeetingAssistant::onIsMileMeetingRunning(bool isRunning)
{
    m_meetingAssistantRunning = isRunning;
    statusChanged(MeetingAssistantRole);
}

void MeetingAssistant::onClickRecommend()
{
    emit sigStartAiMeeting();
}

void MeetingAssistant::statusChanged(Role role)
{
    //会议场景变化，给qml发信号
    if(m_isDetectedMeetingScene){  //检测到会议场景
        if(m_meetingAssistantRunning){
            //给qml发送信号：AI Bar显示会议助手图标
            emit sigMeetAssistantStatusChanged(ShowIcon);
        }else {
            //给qml发送信号：AI Bar显示会议助手图标 + 显示推荐交互
            if(role == MeetingSceneRole){
                emit sigMeetAssistantStatusChanged(ShowAll);
            }
        }
    }else {
        if(m_meetingAssistantRunning){
            //给qml发送信号：AI Bar显示会议助手图标
            emit sigMeetAssistantStatusChanged(ShowIcon);
        }else {
            //给qml发送信号：AI Bar隐藏会议助手图标
            emit sigMeetAssistantStatusChanged(HideAll);
        }
    }
}
