#ifndef WORDWIZARDITEM_H
#define WORDWIZARDITEM_H

#include <DWidget>
#include <DLabel>
#include <DSwitchButton>

DWIDGET_USE_NAMESPACE

class WordWizardItem: public DWidget
{
    Q_OBJECT
public:
    explicit WordWizardItem(DWidget *parent = nullptr);
    void setSwitchChecked(bool);
    ~WordWizardItem();

private:
    void initUI();
    void initConnect();

public:
    void setText(const QString &theme, const QString &summary);

signals:
    void signalSwitchChanged(bool);

private slots:

private:
    DLabel *m_pLabelTheme = nullptr;
    DLabel *m_pLabelSummary = nullptr;
    DSwitchButton *m_pBtnSwitch = nullptr;
};

#endif // WORDWIZARDITEM_H
