/*
 * Copyright (C) 2016 ~ 2018 Deepin Technology Co., Ltd.
 *               2016 ~ 2018 dragondjf
 *
 * Author:     dragondjf<dingjiangfeng@deepin.com>
 *
 * Maintainer: dragondjf<dingjiangfeng@deepin.com>
 *             zccrs<zhangjide@deepin.com>
 *             Tangtong<tangtong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SINGLETONAPP_H
#define SINGLETONAPP_H

#include <QObject>
#include <QLocalServer>

class SingletonApp : public QObject
{
    Q_OBJECT
public:
    void initConnections();
    QString getServerPathByKey(const QString& key);
    QString getUserId();
    QString getServerRootPath();
    static SingletonApp* instance();

signals:

public slots:
    bool setSingletonApplication(const QString& key);
    void readData();
    void handleConnection();

private:
    QLocalServer m_server;
    QString m_key;
    explicit SingletonApp(QObject *parent = 0);
};

#endif // SINGLETONAPP_H
