#!/bin/bash
#
# Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# generate fstab

readonly GENFSTAB="./genfstab"
[ -f "${GENFSTAB}" ] || \
  echo "require genfstab but it's not found. Abort!"
umount -v /target/media/cdrom
"${GENFSTAB}" -p -U /target > /target/etc/fstab

if [ -d /target/data/ ];then
  sed -i '$!N;/\n.*home/!P;D' /target/etc/fstab
  sed -i '/home/d' /target/etc/fstab

  sed -i '$!N;/\n.*opt/!P;D' /target/etc/fstab
  sed -i '/opt/d' /target/etc/fstab

  sed -i '$!N;/\n.*root/!P;D' /target/etc/fstab
  sed -i '/root/d' /target/etc/fstab

  sed -i '$!N;/\n.*var/!P;D' /target/etc/fstab
  sed -i '/var/d' /target/etc/fstab

  echo "/data/home /home none defaults,bind 0 0" >> /target/etc/fstab
  echo "/data/opt /opt none defaults,bind 0 0" >> /target/etc/fstab
  echo "/data/root /root none defaults,bind 0 0" >> /target/etc/fstab
  echo "/data/var /var none defaults,bind 0 0" >> /target/etc/fstab
fi

echo "Content of /etc/fstab"
cat /target/etc/fstab



