package log

import (
	"os"

	logging "github.com/op/go-logging"
)

// Logger are dispard
var Logger = initlog()

var priLogger = initprilog()

// Example format string. Everything except the message has a custom color
// which is dependent on the log level. Many fields have a custom output
// formatting too, eg. the time returns the hour down to the milli second.
var format = logging.MustStringFormatter(
	// Timeformat "2006-01-02T15:04:05.999Z-07:00".
	//"%{color}%{level:.4s} %{time:15:04:05.000} %{shortfile:-14s}▶ %{shortfunc:-16s}▶ %{id:06x}%{color:reset} %{message}",
	"%{color}[%{level:.3s}] %{time:2006/01/02 - 15:04:05} | %{shortfile:s} | %{shortfunc:s} | %{id:06x}%{color:reset} %{message}",
)
var formatSyslog = logging.MustStringFormatter(
	// Timeformat "2006-01-02T15:04:05.999Z-07:00".
	//"%{color}%{level:.4s} %{time:15:04:05.000} %{shortfile:-14s}▶ %{shortfunc:-16s}▶ %{id:06x}%{color:reset} %{message}",
	"%{color}[%{level:.3s}] %{shortfile:s}:%{color:reset} %{message}",
)

func initlog() *logging.Logger {
	log := logging.MustGetLogger("deepin-sync-daemon")
	// For demo purposes, create one backend for os.Stderr.
	backendAll := logging.NewLogBackend(os.Stderr, "", 0)

	// For messages written to backend2 we want to add some additional
	// information to the output, including the used log level and the name of
	// the function.
	backendFormatter := logging.NewBackendFormatter(backendAll, format)

	// Set the backends to be used.
	logging.SetBackend(backendFormatter)
	return log
}

func initprilog() *logging.Logger {
	log := logging.MustGetLogger("deepin-sync-daemon")

	// For demo purposes, create one backend for os.Stderr.
	backendAll := logging.NewLogBackend(os.Stderr, "", 0)
	backendSyslog, _ := logging.NewSyslogBackend("deepin-sync-daemon")

	// For messages written to backend2 we want to add some additional
	// information to the output, including the used log level and the name of
	// the function.
	backendAllFormatter := logging.NewBackendFormatter(backendAll, format)
	backendSyslogFormatter := logging.NewBackendFormatter(backendSyslog, formatSyslog)

	// Set the backends to be used.
	logging.SetBackend(backendAllFormatter, backendSyslogFormatter)

	log.ExtraCalldepth = 1

	return log
}

// Fatal is equivalent to l.Critical(fmt.Sprint()) followed by a call to os.Exit(1).
func Fatal(args ...interface{}) {
	priLogger.Fatal(args...)
}

// Fatalf is equivalent to l.Critical followed by a call to os.Exit(1).
func Fatalf(format string, args ...interface{}) {
	priLogger.Fatalf(format, args...)
}

// Panic is equivalent to l.Critical(fmt.Sprint()) followed by a call to panic().
func Panic(args ...interface{}) {
	priLogger.Panic(args...)
}

// Panicf is equivalent to l.Critical followed by a call to panic().
func Panicf(format string, args ...interface{}) {
	priLogger.Panicf(format, args...)
}

// Critical logs a message using CRITICAL as log level.
func Critical(args ...interface{}) {
	priLogger.Critical(args...)
}

// Criticalf logs a message using CRITICAL as log level.
func Criticalf(format string, args ...interface{}) {
	priLogger.Criticalf(format, args...)
}

// Error logs a message using ERROR as log level.
func Error(args ...interface{}) {
	priLogger.Error(args...)
}

// Errorf logs a message using ERROR as log level.
func Errorf(format string, args ...interface{}) {
	priLogger.Errorf(format, args...)
}

// Warning logs a message using WARNING as log level.
func Warning(args ...interface{}) {
	priLogger.Warning(args...)
}

// Warningf logs a message using WARNING as log level.
func Warningf(format string, args ...interface{}) {
	priLogger.Warningf(format, args...)
}

// Notice logs a message using NOTICE as log level.
func Notice(args ...interface{}) {
	priLogger.Notice(args...)
}

// Noticef logs a message using NOTICE as log level.
func Noticef(format string, args ...interface{}) {
	priLogger.Noticef(format, args...)
}

// Info logs a message using INFO as log level.
func Info(args ...interface{}) {
	priLogger.Info(args...)
}

// Infof logs a message using INFO as log level.
func Infof(format string, args ...interface{}) {
	priLogger.Infof(format, args...)
}

// Debug logs a message using DEBUG as log level.
func Debug(args ...interface{}) {
	priLogger.Debug(args...)
}

// Debugf logs a message using DEBUG as log level.
func Debugf(format string, args ...interface{}) {
	priLogger.Debugf(format, args...)
}
