/*
 * Copyright (C) 2014-2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * For infos look at:
 * "KL02 Sub-Family Reference Manual for 48 MHz devices 32 pin package
 * Reference Manual".
 *
 * "22: Oscillator (OSC)"
 */

#ifdef INCLUDE

#include <assert.h>
#include <stdio.h>

#endif /* INCLUDE */
#ifdef STATE

struct {
	/* 22.7.1.1 */
	uint8_t erclken;
	uint8_t erefsten;
	uint8_t scp;
} NAME;

#endif /* STATE */
#ifdef EXPORT

/*forward*/ static void
NAME_(st)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val);
/*forward*/ static void
NAME_(ld)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp);
/*forward*/ static void
NAME_(reset)(struct cpssp *cpssp);
/*forward*/ static void
NAME_(create)(struct cpssp *cpssp);
/*forward*/ static void
NAME_(destroy)(struct cpssp *cpssp);

#endif /* EXPORT */
#ifdef BEHAVIOR

static void
NAME_(ld)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	addr &= 0x1000 - 1;
	*valp = 0;

	switch (addr) {
	case 0:
		if ((bs >> 0) & 1) {
			/* OSC Control Register */
			*valp |= cpssp->NAME.erclken << 7;
			/* 6: reserved */
			*valp |= cpssp->NAME.erefsten << 5;
			/* 4: reserved */
			*valp |= cpssp->NAME.scp << 0;
		}
		if ((bs >> 1) & 1) {
			/* reserved */
		}
		if ((bs >> 2) & 1) {
			/* reserved */
		}
		if ((bs >> 3) & 1) {
			/* reserved */
		}
		break;

	default:
		fprintf(stderr, "WARNING: %s: addr=0x%08lx bs=0x%x\n",
				__FUNCTION__, addr, bs);
		*valp = 0;
		break;
	}
}

static void
NAME_(st)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val)
{
	addr &= 0x1000 - 1;

	switch (addr) {
	case 0:
		if ((bs >> 0) & 1) {
			/* OSC Control Register */
			cpssp->NAME.erclken = (val >> 7) & 1;
			/* 6: reserved */
			cpssp->NAME.erefsten = (val >> 5) & 1;
			/* 4: reserved */
			cpssp->NAME.scp = (val >> 0) & 0xf;
		}
		if ((bs >> 1) & 1) {
			/* reserved */
		}
		if ((bs >> 2) & 1) {
			/* reserved */
		}
		if ((bs >> 3) & 1) {
			/* reserved */
		}
		break;

	default:
		fprintf(stderr, "WARNING: %s: addr=0x%08lx bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, val);
		break;
	}
}

static void
NAME_(exclk)(struct cpssp *cpssp)
{
	NAME_(oscclk)(cpssp);
	if (cpssp->NAME.erclken) {
		NAME_(oscerclk)(cpssp);
	}
	NAME_(erclk32k)(cpssp);
}

static void
NAME_(reset)(struct cpssp *cpssp)
{
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */
