/*
  Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE
#endif /* INCLUDE */
#ifdef STATE

struct {
	int current_voltage;
	int channel_number;
} NAME;

#endif /* STATE */
#ifdef EXPORT

/*forward*/ static char
NAME_(get_channel_type)(struct cpssp *cpssp);
/*forward*/ static void
NAME_(voltage_changed)(void *_cpssp, unsigned int val);
/*forward*/ static void
NAME_(create)(struct cpssp *cpssp, int channel_number);

#endif /* EXPORT */
#ifdef BEHAVIOR

static char
NAME_(get_channel_type)(struct cpssp *cpssp)
{
	return 'v';
}

static void
NAME_(voltage_changed)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;
	int mV;

	if (val == -1) {
		return;
	}

	mV = SIG_mV(val);

	if (cpssp->trigger_level <= mV
	 && cpssp->NAME.current_voltage < cpssp->trigger_level) {
		/* positive edge */
		if (cpssp->running
		 && cpssp->trigger_armed
		 && cpssp->trigger_edge) {
			register_trigger(cpssp, cpssp->NAME.channel_number);
		}
	} else if (mV <= cpssp->trigger_level
		&& cpssp->trigger_level < cpssp->NAME.current_voltage) {
		/* negative edge */
		if (cpssp->running
		 && cpssp->trigger_armed
		 && cpssp->trigger_edge) {
			register_trigger(cpssp, cpssp->NAME.channel_number);
		}
	}

	cpssp->channel_values[cpssp->NAME.channel_number] = mV;
	cpssp->NAME.current_voltage = mV;
}

static void
NAME_(create)(struct cpssp *cpssp, int channel_number)
{
	cpssp->NAME.channel_number = channel_number;
}

#endif /* BEHAVIOUR */
