/*
  Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE
#endif /* INCLUDE */
#ifdef STATE

struct {
	int pixel[SCREEN_HEIGHT + SUB_SCREEN_HEIGHT][SCREEN_WIDTH + SUB_SCREEN_LEFT];

} NAME;

#endif /* STATE */
#ifdef EXPORT

/*static*/ static bool
NAME_(subtract_samples)(
	struct cpssp *cpssp,
	int channel,
	long long samples_to_subtract,
	int start_buffer_pos,
	int *dest_buffer_pos,
	long long start_sample_pos,
	long long *dest_sample_pos,
	long long *remaining_samples
);
/*forward*/ static void
NAME_(wipe_screen)(struct cpssp *cpssp);
/*forward*/ static void
NAME_(draw_pixels)(void *_cpssp);
/*forward*/ static void
NAME_(update_pixel_buffer)(struct cpssp *cpssp);
/*forward*/ static void
NAME_(scroll_left)(void *_cpssp, unsigned int val);
/*forward*/ static void
NAME_(scroll_right)(void *_cpssp, unsigned int val);

#endif /* EXPORT */
#ifdef BEHAVIOR

static
#include "font_8x16.c"

static const int NAME_(channel_colors)[] = {
	0xff0000, 0x00ff00, 0x0000ff, 0xffff00, 0x00ffff,
	0xff00ff, 0xaa0000, 0x00aa00, 0x0000aa, 0xaaaa00,
};


/*TODO replace long long sample positions with int*/
static bool
NAME_(add_samples)(
	struct cpssp *cpssp,
	int channel,
	long long samples_to_add,
	int start_buffer_pos,
	int *dest_buffer_pos,
	long long start_sample_pos,
	long long *dest_sample_pos
)
{
	struct RLE_buffer_item item;
	long long diff;
	int buffer_pos = start_buffer_pos;
	long long sample_pos = start_sample_pos + samples_to_add;
	*dest_buffer_pos = start_buffer_pos;
	*dest_sample_pos = sample_pos;
	item = cpssp->RLE_buffer[channel][start_buffer_pos];
	if (item.sample_count == -1) {
		/* TODO what to do */
		return false;
	}
	while (item.sample_count < sample_pos) {
		diff = sample_pos - item.sample_count;
		buffer_pos++;
		if (RLE_BUFFER_SIZE == buffer_pos) {
			buffer_pos = 0;
		}
		item = cpssp->RLE_buffer[channel][buffer_pos];
		if (item.sample_count == -1) {
			/* reached end of data no need to scroll */
			*dest_buffer_pos = start_buffer_pos;
			*dest_sample_pos = start_sample_pos;
			return false;
		}
		sample_pos = diff;
		*dest_buffer_pos = buffer_pos;
		*dest_sample_pos = sample_pos;
	}
	return true;
}

/*TODO replace long long sample positions with int*/
static bool
NAME_(subtract_samples)(
	struct cpssp *cpssp,
	int channel,
	long long samples_to_subtract,
	int start_buffer_pos,
	int *dest_buffer_pos,
	long long start_sample_pos,
	long long *dest_sample_pos,
	long long *remaining_samples
)
{
	struct RLE_buffer_item item;
	long long diff;
	int buffer_pos = start_buffer_pos;
	long long sample_pos = start_sample_pos - samples_to_subtract;
	*dest_buffer_pos = start_buffer_pos;
	*dest_sample_pos = sample_pos;
	*remaining_samples = 0; /* optimism ftw */
	item = cpssp->RLE_buffer[channel][start_buffer_pos];
	if (item.sample_count == -1) {
		/* TODO what to do */
		return false;
	}
	while (sample_pos < 0) {
		buffer_pos--;
		if (buffer_pos < 0) {
			buffer_pos = RLE_BUFFER_SIZE - 1;
		}
		item = cpssp->RLE_buffer[channel][buffer_pos];
		if (item.sample_count == -1) {
			*dest_buffer_pos = 0;
			*dest_sample_pos = 0;
			*remaining_samples = sample_pos * (-1);
			return false;
		}
		diff = sample_pos + (item.sample_count);
		sample_pos = diff;
		*dest_buffer_pos = buffer_pos;
		*dest_sample_pos = sample_pos;
	}
	return true;
}

static void
NAME_(wipe_screen)(struct cpssp *cpssp)
{
	int row, column;

	for(row = 0; row < SCREEN_HEIGHT + SUB_SCREEN_HEIGHT; row++) {
		for(column = 0; column < SCREEN_WIDTH + SUB_SCREEN_LEFT; column++) {
			cpssp->NAME.pixel[row][column] = 0x000000;
		}
	}
}

static void
NAME_(draw_pixels)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	int row, column;
	int r,g,b;
	int color;

	sig_opt_rgb_size_set(cpssp->port_monitor, cpssp,
			SCREEN_WIDTH + SUB_SCREEN_LEFT,
			SCREEN_HEIGHT + SUB_SCREEN_HEIGHT);

	for (row = 0; row < SCREEN_HEIGHT; row++) {
		for (column = 0; column < SCREEN_WIDTH + SUB_SCREEN_LEFT; column++) {
			if (cpssp->NAME.pixel[row][column] != 0x000000) {
				color = cpssp->NAME.pixel[row][column];
				r = (color >> 16) & 0xff;
				g = (color >> 8) & 0xff;
				b = color & 0xff;
				sig_opt_rgb_pixel_set(cpssp->port_monitor, cpssp,
					column, row, r, g, b);
			} else if (column % GRID_STEP == 0
				 || row % GRID_STEP == 0) {
				sig_opt_rgb_pixel_set(cpssp->port_monitor, cpssp,
					column, row, 100, 100, 100);
			} else {
				sig_opt_rgb_pixel_set(cpssp->port_monitor, cpssp,
					column, row, 0, 0, 0);
			}
		}
	}
	for (row = SCREEN_HEIGHT; row < SCREEN_HEIGHT + SUB_SCREEN_HEIGHT; row++) {
		for (column = 0; column < SCREEN_WIDTH + SUB_SCREEN_LEFT; column++) {
			if (cpssp->NAME.pixel[row][column] != 0x000000) {
				sig_opt_rgb_pixel_set(cpssp->port_monitor, cpssp,
					column, row, 255, 255, 255);
			} else {
				sig_opt_rgb_pixel_set(cpssp->port_monitor, cpssp,
					column, row, 0, 0, 0);
			}
		}
	}

	sig_opt_rgb_sync(cpssp->port_monitor, cpssp);
	time_call_after(TIME_HZ / 5, NAME_(draw_pixels), cpssp);
}

static void
NAME_(set_line_pixels)(
	struct cpssp *cpssp,
	int column,
	int last_value,
	int current_value,
	int channel
)
{
	int on_screen_y = 0;

	if (last_value == -1
	 || column == 0) {
		/* set just one pixel */
		cpssp->NAME.pixel[on_screen_y][column]
				= NAME_(channel_colors)[channel];
	} else if (last_value < current_value) {
		on_screen_y = current_value;

		while (0 <= on_screen_y
		    && on_screen_y < SCREEN_HEIGHT) {
			cpssp->NAME.pixel[on_screen_y][column]
					= NAME_(channel_colors)[channel];
			if (on_screen_y == last_value) {
				cpssp->NAME.pixel[on_screen_y][column]
						= NAME_(channel_colors)[channel];
				break;
			}
			on_screen_y--;
		}
	} else {
		on_screen_y = last_value;
		while (0 <= on_screen_y
		    && on_screen_y < SCREEN_HEIGHT) {
			cpssp->NAME.pixel[on_screen_y][column]
					= NAME_(channel_colors)[channel];
			if (on_screen_y == current_value) {
				cpssp->NAME.pixel[on_screen_y][column]
						= NAME_(channel_colors)[channel];
				break;
			}
			on_screen_y--;
		}
	}
	cpssp->last_on_screen_y[channel] = current_value;
}

static void
NAME_(update_pixel_buffer)(struct cpssp *cpssp)
{
	int column, row;
	int channel_zero_line;
	int on_screen_y;
	int channel;
	int channel_event_pointer;
	struct RLE_buffer_item buffer_item;
	struct event_measure_point upcoming_event;
	long long samples_to_skip;
	int buffer_read_pos;
	long long sample_pos;
	double time_hz_d = (double) TIME_HZ;
	double sample_rate_d = (double) cpssp->sample_rate;
	double ticks_per_sample = time_hz_d / sample_rate_d;

	for (channel = 0; channel < NUMBER_ANALOG_CHANNELS; channel++) {
		/* prepare voltage display */
		int dest_buffer_pos;
		long long dest_sample_pos;
		long long remaining_samples;
		buffer_read_pos = cpssp->center_buffer_pos[channel];
		sample_pos = cpssp->center_sample_pos[channel];
		double skip = ((double)SCREEN_WIDTH)/2.0;
		skip *= (double) cpssp->pixel_step_d;
		NAME_(subtract_samples)(cpssp, channel, (int)skip,
			buffer_read_pos, &dest_buffer_pos, sample_pos,
			&dest_sample_pos, &remaining_samples);

		if (cpssp->first_buffer_pos[channel] <= cpssp->last_buffer_pos[channel]) {
			if (dest_buffer_pos < cpssp->first_buffer_pos[channel]
					||  cpssp->last_buffer_pos[channel] < dest_buffer_pos) {
				/* overflow */
				dest_buffer_pos = cpssp->first_buffer_pos[channel];
				dest_sample_pos = cpssp->first_sample_pos[channel];
			} else if (dest_buffer_pos == cpssp->first_buffer_pos[channel]
					&& dest_sample_pos < cpssp->first_sample_pos[channel]) {
				/* overflow */
				dest_buffer_pos = cpssp->first_buffer_pos[channel];
				dest_sample_pos = cpssp->first_sample_pos[channel];
			}
		} else {
			if (dest_buffer_pos < cpssp->first_buffer_pos[channel]
					&& cpssp->last_buffer_pos[channel] < dest_buffer_pos) {
				/* overflow */
				dest_buffer_pos = cpssp->first_buffer_pos[channel];
				dest_sample_pos = cpssp->first_sample_pos[channel];
			} else if (dest_buffer_pos == cpssp->first_buffer_pos[channel]
					&& dest_sample_pos < cpssp->first_sample_pos[channel]) {
				/* overflow */
				dest_buffer_pos = cpssp->first_buffer_pos[channel];
				dest_sample_pos = cpssp->first_sample_pos[channel];
			}
		}
		cpssp->RLE_buffer_read_pos[channel] = dest_buffer_pos;
		cpssp->buffer_item_skipped_samples[channel] = dest_sample_pos;
		cpssp->last_on_screen_y[channel] = - 1;

	}
	for (channel = 0; channel < NUMBER_DIGITAL_CHANNELS; channel++) {
		/* prepare event display */
		buffer_item = cpssp->RLE_buffer[0][cpssp->RLE_buffer_read_pos[0]];
		int sample_pos = cpssp->buffer_item_skipped_samples[0];
		if (buffer_item.sample_count == -1) {
			continue;
		}
		long long ticks = buffer_item.time_stamp - cpssp->start_time;

		ticks += (cpssp->call_after_ticks * sample_pos) ;

		channel_event_pointer = 0;
		upcoming_event = cpssp->event_buffer[channel][channel_event_pointer];
		cpssp->digital_channel_hi[channel] = false;
		while (upcoming_event.time_stamp != 0
			&& upcoming_event.time_stamp
				< buffer_item.time_stamp + (sample_pos * cpssp->call_after_ticks)) {
			/* skip those events that are left of screen */

			if (upcoming_event.hi == true) {
				cpssp->digital_channel_hi[channel] = true;
			} else {
				cpssp->digital_channel_hi[channel] = false;
			}
			channel_event_pointer++;
			upcoming_event = cpssp->event_buffer[channel][channel_event_pointer];
		}
		if (channel_event_pointer == 0 && upcoming_event.time_stamp != 0) {
			/* first event */
			cpssp->digital_channel_hi[channel] = !upcoming_event.hi;
		}
		cpssp->event_pointer[channel] = channel_event_pointer;
	}

	/* prepare legend */
	buffer_item = cpssp->RLE_buffer[0][cpssp->RLE_buffer_read_pos[0]];

	if (buffer_item.sample_count != -1) {
		int skipped_samples_d = cpssp->buffer_item_skipped_samples[0];
		long long time_stamp_d =  buffer_item.time_stamp;
		long long start_time_d =  cpssp->start_time;
		long long ticks = (time_stamp_d
				+ skipped_samples_d * (long long)ticks_per_sample)
				- start_time_d;
		if (cpssp->pixel_step_d < 1) {
			int add =(int)(cpssp->pixel_step_overflow[channel]
					* (double)round(ticks_per_sample));
			ticks += add;
		}
		double ticks_d = (double) ticks;
		double start_time = ticks_d/time_hz_d;
		if (start_time < 0) {
			start_time = 0;
		}
		cpssp->screen_start_time = start_time;

	}
	for (column = 0; column < SCREEN_WIDTH; column++) {
		for (channel = 0; channel < NUMBER_ANALOG_CHANNELS; channel++) {
			/* draw analog signal */
			buffer_read_pos = cpssp->RLE_buffer_read_pos[channel];
			if (buffer_read_pos >= RLE_BUFFER_SIZE) {
				continue;
			}
			buffer_item = cpssp->RLE_buffer[channel][buffer_read_pos];
			if (buffer_item.sample_count == -1) {
				continue;
			}
			samples_to_skip = cpssp->buffer_item_skipped_samples[channel];
			while (buffer_item.sample_count < samples_to_skip) {
				/* bucket overflow */
				samples_to_skip -= buffer_item.sample_count;
				buffer_read_pos++;
				buffer_read_pos %= RLE_BUFFER_SIZE;
				buffer_item = cpssp->RLE_buffer[channel][buffer_read_pos];
				if (buffer_item.sample_count == -1) {
					break;
				} else if (samples_to_skip <= buffer_item.sample_count) {
					break;
				} else {
					/* do nothing */
				}
			}
			if (buffer_item.sample_count == -1 || buffer_read_pos >= RLE_BUFFER_SIZE) {
				continue;
			}
			cpssp->RLE_buffer_read_pos[channel] = buffer_read_pos;

			if (1 <= cpssp->pixel_step_d) {
				samples_to_skip += cpssp->pixel_step;
			} else {
				cpssp->pixel_step_overflow[channel] += cpssp->pixel_step_d;
				if (cpssp->pixel_step_overflow[channel] >= 1.0) {
					samples_to_skip++;
					cpssp->pixel_step_overflow[channel] -= 1.0;
				}
			}
			cpssp->buffer_item_skipped_samples[channel] = samples_to_skip;

			channel_zero_line = SCREEN_HEIGHT / 2 + cpssp->vertical_offset[channel];

			on_screen_y = channel_zero_line;

			if (buffer_item.sample_count != -1) {
				on_screen_y -= buffer_item.value / cpssp->scale_factor[channel];
				if (column == (SCREEN_WIDTH/2) - 1) {
					cpssp->center_buffer_pos[channel] = buffer_read_pos;
					cpssp->center_sample_pos[channel] = samples_to_skip;
				}
			}

			NAME_(set_line_pixels)(cpssp, column + SUB_SCREEN_LEFT,
					cpssp->last_on_screen_y[channel],
					on_screen_y, channel);
		}
		for (channel = 0; channel < NUMBER_DIGITAL_CHANNELS; channel++) {
			/* draw digital graph */
			channel_zero_line = SCREEN_HEIGHT / 2 + cpssp->vertical_offset[channel + NUMBER_ANALOG_CHANNELS];
			channel_event_pointer = cpssp->event_pointer[channel];
			if (channel_event_pointer >= EVENT_BUFFER_SIZE - 1) {
				continue;
			}
			int color = 0xffffff;

			if (cpssp->registered_events[channel] < channel_event_pointer) {
				/* no more events for this channel */
				continue;
			}

			upcoming_event = cpssp->event_buffer[channel][channel_event_pointer];
			buffer_item = cpssp->RLE_buffer[0][cpssp->RLE_buffer_read_pos[0]];
			if (buffer_item.sample_count == -1) {
				continue;
			}
			samples_to_skip = cpssp->buffer_item_skipped_samples[0];
			while (upcoming_event.time_stamp != 0
				&& upcoming_event.time_stamp < buffer_item.time_stamp +
							(samples_to_skip * cpssp->call_after_ticks)) {
				int offset;

				for(offset = 0; offset < GRID_STEP; offset++) {
					cpssp->NAME.pixel[channel_zero_line - offset][column + SUB_SCREEN_LEFT] = color;
				}
				if (upcoming_event.hi == true) {
					cpssp->digital_channel_hi[channel] = true;
				} else {
					cpssp->digital_channel_hi[channel] = false;
				}
				channel_event_pointer++;
				cpssp->event_pointer[channel] = channel_event_pointer;
				upcoming_event = cpssp->event_buffer[channel][channel_event_pointer];
			}
			if (cpssp->digital_channel_hi[channel] == true) {

				cpssp->NAME.pixel[channel_zero_line - GRID_STEP][column + SUB_SCREEN_LEFT] = color;
			} else {

				cpssp->NAME.pixel[channel_zero_line][column + SUB_SCREEN_LEFT] = color;
			}
		}
	}

	/* draw legend */
	int FONT_HEIGHT = 16;
	int FONT_WIDTH = 8;
	for (row = SCREEN_HEIGHT + 2; row < SCREEN_HEIGHT + 2 + FONT_HEIGHT; row++) {
		double time_stamp_val = cpssp->screen_start_time;
		for (column = 0; column <= SCREEN_WIDTH; column += (SCREEN_WIDTH / 2)) {
			int start_pos;
			char time_stamp[35];
			memset(time_stamp, '\0', sizeof(time_stamp));
			sprintf(time_stamp, "%.9lf", time_stamp_val);
			if (column == 0) {
				start_pos = 0;
			} else if (column == SCREEN_WIDTH / 2) {
				start_pos = column - (strlen(time_stamp)/2) * FONT_WIDTH;
			} else {
				start_pos = column - strlen(time_stamp) * FONT_WIDTH;
			}
			int c_p = 0;
			int x;
			int on_screen_x;
			char c = time_stamp[c_p];
			while (c != '\0') {
				on_screen_x = start_pos + SUB_SCREEN_LEFT;
				char bits =
				font_8x16[(c * FONT_HEIGHT)
						+ (row % SCREEN_HEIGHT)];
				for (x = FONT_WIDTH - 1; 0 <= x; x--) {
					if (bits & (1 << x)) {
						cpssp->NAME.pixel[row][on_screen_x + c_p * FONT_WIDTH]  = 0xffffff;
					} else {
						cpssp->NAME.pixel[row][on_screen_x + c_p * FONT_WIDTH]  = 0x000000;
					}
					on_screen_x++;
				}
				c_p++;
				c = time_stamp[c_p];
			}
			int tps = round(cpssp->ticks_per_sample);
			double tps_d = (double)tps;
			double a = ((double)SCREEN_WIDTH/2.0) * cpssp->pixel_step_d * tps_d;
			a /= time_hz_d;
			time_stamp_val += a;

		}
	}
	for (channel = 0; channel < NUMBER_ANALOG_CHANNELS + NUMBER_DIGITAL_CHANNELS; channel++) {
		int offset;
		int FONT_HEIGHT = 16;
		int FONT_WIDTH = 8;
		int screen_zero_line = SCREEN_HEIGHT / 2;
		offset = cpssp->vertical_offset[channel];
		offset += screen_zero_line;
		offset -= FONT_HEIGHT;
		if (offset < 0 || SCREEN_HEIGHT <= offset) {
			continue;
		}
		char channel_name[10];
		memset(channel_name, '\0', 6);
		if (channel < NUMBER_ANALOG_CHANNELS) {
			channel_name[0] = 'C';
			channel_name[1] = 'H';
			sprintf(channel_name+2, "%d\0", channel+1);
		} else {
			channel_name[0] = 'D';
			sprintf(channel_name+1, "%d\0", channel - NUMBER_ANALOG_CHANNELS + 1);
		}
		for (row = offset; row < offset + FONT_HEIGHT; row++) {
			int c_p = 0;
			char c = channel_name[c_p];
			int x;
			int on_screen_x;
			int color;
			while (c != '\0') {
				on_screen_x = 0;
				char bits = font_8x16[(c * FONT_HEIGHT) + (row - offset)];
				color = 0xffffff;
				for (x = FONT_WIDTH - 1; 0 <= x; x--) {
					if (bits & (1 << x)) {
						if (channel < NUMBER_ANALOG_CHANNELS) {
							color = NAME_(channel_colors)[channel];
						}
						cpssp->NAME.pixel[row]
							[on_screen_x + c_p * FONT_WIDTH] = color;
					} else {
						cpssp->NAME.pixel[row]
							[on_screen_x + c_p * FONT_WIDTH]  = 0x000000;
					}
					on_screen_x++;
				}
				c_p++;
				c = channel_name[c_p];
			}
		}
	}
}

static void
NAME_(scroll_left)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;
	int channel;
	int mV = SIG_mV(val);
	struct RLE_buffer_item item;
	long long sample_count;
	int buffer_pos;

	if (mV < 0) {
		return;
	}
	for (channel = 0; channel < NUMBER_ANALOG_CHANNELS; channel++) {
		buffer_pos = cpssp->center_buffer_pos[channel];
		item = cpssp->RLE_buffer[channel][buffer_pos];
		cpssp->last_on_screen_y[channel] = -1;
		/*if (item.time_stamp == 0) {*/
		if (item.sample_count == -1) {
			/* tbd */
		} else {
			int dest_buffer_pos;
			long long dest_sample_pos;
			long long remaining_samples;
			sample_count = cpssp->center_sample_pos[channel];
			double skip = ((double)SCREEN_WIDTH)/2.0;
			skip *= cpssp->pixel_step_d;

			NAME_(subtract_samples)(cpssp, channel,
					(int) skip, buffer_pos,
					&dest_buffer_pos,
					cpssp->center_sample_pos[channel],
					&dest_sample_pos, &remaining_samples);
			cpssp->center_buffer_pos[channel] = dest_buffer_pos;
			cpssp->center_sample_pos[channel] = dest_sample_pos;
			cpssp->last_on_screen_y[channel] = - 1;
		}
	}
	for (channel = 0; channel < NUMBER_DIGITAL_CHANNELS; channel++) {
		cpssp->event_pointer[channel] = 0;
		cpssp->digital_channel_hi[channel] = false;
	}
	NAME_(wipe_screen)(cpssp);
	NAME_(update_pixel_buffer)(cpssp);
}

static void
NAME_(scroll_right)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;
	int channel;
	struct RLE_buffer_item item;
	unsigned long long sample_count;
	int buffer_pos;
	int mV = SIG_mV(val);
	if (mV > 0) {
		for (channel = 0; channel < NUMBER_ANALOG_CHANNELS; channel++) {
			int dest_buffer_pos;
			long long dest_sample_pos;

			cpssp->last_on_screen_y[channel] = -1;
			buffer_pos = cpssp->center_buffer_pos[channel];
			item = cpssp->RLE_buffer[channel][buffer_pos];
			/*if (item.time_stamp == 0) {*/
			if (item.sample_count == -1) {
				fprintf(stderr, "ITEM NULL\n");
			} else {
				sample_count = cpssp->center_sample_pos[channel];
				double skip = ((double)SCREEN_WIDTH)/2.0;
				skip *= cpssp->pixel_step_d;
				bool f = NAME_(add_samples)(cpssp,
					channel,
					(int)skip,
					buffer_pos,
					&dest_buffer_pos,
					cpssp->center_sample_pos[channel],
					&dest_sample_pos);
				if (f == false) {
					/*TODO what to do*/
				}
				cpssp->center_buffer_pos[channel] = dest_buffer_pos;
				cpssp->center_sample_pos[channel] = dest_sample_pos;
			}
		}
		for (channel = 0; channel < NUMBER_DIGITAL_CHANNELS; channel++) {
			cpssp->event_pointer[channel] = 0;
			cpssp->digital_channel_hi[channel] = false;
		}
		NAME_(wipe_screen)(cpssp);
		NAME_(update_pixel_buffer)(cpssp);
	}
}

#endif /* BEHAVIOUR */
