--
-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.
--

library expect;
use expect.types.all;
use expect.procedures.all;
library ieee;
use ieee.std_logic_1164.ALL;

entity user is
	port(
		power_switch : out boolean;
		power_button : out boolean;
		reset_button : out boolean;

		floppy : out cstring;
		cdrom : out cstring;
		image : out cstring;

		key : out boolean_array(0 to 127);

		mouse_dx : out integer;
		mouse_dy : out integer;
		mouse_dz : out integer;
		mouse_button1 : out boolean;
		mouse_button2 : out boolean;
		mouse_button3 : out boolean;
		mouse_button4 : out boolean;
		mouse_button5 : out boolean;

		screen_shot : out boolean;
		rec : out boolean;

		opt_screen : in opt_rgb
	);
end user;

architecture behaviour of user is
	signal int_text0 : cstring;
	signal int_text1 : cstring;
	signal int_text2 : cstring;
	signal int_text3 : cstring;
	signal int_text0_state : boolean;
	signal int_text1_state : boolean;
	signal int_text2_state : boolean;
	signal int_text3_state : boolean;
	signal int_asc_text0 : cstring;
	signal int_asc_text1 : cstring;
	signal int_asc_text2 : cstring;
	signal int_asc_text3 : cstring;
	signal int_asc_text0_state : boolean;
	signal int_asc_text1_state : boolean;
	signal int_asc_text2_state : boolean;
	signal int_asc_text3_state : boolean;
	signal int_slot0 : match;
	signal int_slot1 : match;
	signal int_slot2 : match;
	signal int_slot3 : match;
	signal int_slot4 : match;
	signal int_slot5 : match;
	signal int_slot6 : match;
	signal int_slot7 : match;
	signal int_slot8 : match;
	signal int_slot9 : match;
	signal int_slot10 : match;
	signal int_slot11 : match;
	signal int_slot12 : match;
	signal int_slot13 : match;
	signal int_slot14 : match;
	signal int_slot15 : match;
	signal mouse_pointerdir : cstring;
	signal mouse_match : boolean;
	signal mouse_event : boolean;
	signal mouse_x : integer;
	signal mouse_y : integer;

	signal gfx_pattern0 : cstring;
	signal gfx_pattern1 : cstring;
	signal gfx_pattern2 : cstring;
	signal gfx_pattern3 : cstring;
	signal gfx_match0 : integer_array(1 to 4);
	signal gfx_match1 : integer_array(1 to 4);
	signal gfx_match2 : integer_array(1 to 4);
	signal gfx_match3 : integer_array(1 to 4);

	-- set to true, if some input should be performed regularly
	-- to eventually wake up from an activated screen saver.
	signal wakeup_screensaver : boolean := false;
begin
	patternmatcher : patternm 
		port map (
			video => opt_screen,
			text0 => int_text0,
			text0_state => int_text0_state,
			text1 => int_text1, 
			text1_state => int_text1_state,
			text2 => int_text2,
			text2_state => int_text2_state,
			text3 => int_text3, 
			text3_state => int_text3_state,
			asc_text0 => int_asc_text0,
			asc_text0_state => int_asc_text0_state,
			asc_text1 => int_asc_text1, 
			asc_text1_state => int_asc_text1_state,
			asc_text2 => int_asc_text2,
			asc_text2_state => int_asc_text2_state,
			asc_text3 => int_asc_text3, 
			asc_text3_state => int_asc_text3_state,
			slot0 => int_slot0,
			slot1 => int_slot1,
			slot2 => int_slot2,
			slot3 => int_slot3,
			slot4 => int_slot4,
			slot5 => int_slot5,
			slot6 => int_slot6,
			slot7 => int_slot7,
			slot8 => int_slot8,
			slot9 => int_slot9,
			slot10 => int_slot10,
			slot11 => int_slot11,
			slot12 => int_slot12,
			slot13 => int_slot13,
			slot14 => int_slot14,
			slot15 => int_slot15,
			pattern_rectangle0 => gfx_pattern0,
			pattern_rectangle1 => gfx_pattern1,
			pattern_rectangle2 => gfx_pattern2,
			pattern_rectangle3 => gfx_pattern3,
			match_rectangle0_x => gfx_match0(1),
			match_rectangle0_y => gfx_match0(2),
			match_rectangle0_w => gfx_match0(3),
			match_rectangle0_h => gfx_match0(4),
			match_rectangle1_x => gfx_match1(1),
			match_rectangle1_y => gfx_match1(2),
			match_rectangle1_w => gfx_match1(3),
			match_rectangle1_h => gfx_match1(4),
			match_rectangle2_x => gfx_match2(1),
			match_rectangle2_y => gfx_match2(2),
			match_rectangle2_w => gfx_match2(3),
			match_rectangle2_h => gfx_match2(4),
			match_rectangle3_x => gfx_match3(1),
			match_rectangle3_y => gfx_match3(2),
			match_rectangle3_w => gfx_match3(3),
			match_rectangle3_h => gfx_match3(4)
		);

	mouse_matcher : mouse_matcher
		port map (
			pointerdir => mouse_pointerdir,
			match_state => mouse_match,
			event => mouse_event,
			x => mouse_x,
			y => mouse_y,
			slot0 => int_slot4,
			slot1 => int_slot5,
			slot2 => int_slot6,
			slot3 => int_slot7,
			slot4 => int_slot8,
			slot5 => int_slot9,
			slot6 => int_slot10,
			slot7 => int_slot11,
			slot8 => int_slot12,
			slot9 => int_slot13,
			slot10 => int_slot14,
			slot11 => int_slot15
		);

	-- perform some activity, in case wakeup_screensaver is true
	-- this helps in case the screensaver starts while waiting on an
	-- image.
	perform_activity : process
		variable state : integer := 0;
	begin
		-- dummy loop, since expect doesn't repeat processes
		while true loop
			wait on wakeup_screensaver;
			while wakeup_screensaver loop
				-- don't immediately perform activity
				wait on wakeup_screensaver for 300 sec;

				if wakeup_screensaver then
					-- perform some activity
					case state is
					when 0 =>
						-- press shift key
						key(42) <= true;
						wait for 100 ms;
						key(42) <= false;
						state := 1;

					when 1 =>
						-- press alt key
						key(56) <= true;
						wait for 100 ms;
						key(56) <= false;
						state := 0;

					end case;
				end if;
			end loop;
		end loop;
	end process perform_activity;

	installation_script : process
		variable x : integer;
		variable y : integer;
	begin
