/* barchair.c
**
**    code for burlap sofa 3d-model
**
**    foobillard++ started at 12/2010
**    Copyright (C) 2010 - 2013 Holger Schaekel (foobillardplus@go4more.de)
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License Version 2 as
**    published by the Free Software Foundation;
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
* Exported from Blender */

#define VERTEX_COUNT 8399
#define FACES_COUNT 11920
#ifndef VERTEX_STRUCT
#define VERTEX_STRUCT
struct vertex_struct{
	float x, y, z;
	float nx,ny,nz;
	float u,v;
};
#endif
struct vertex_struct vertexs[]=
{
{-0.509231, 0.361411, -0.247258, -0.680288, 0.729179, -0.073916, 0.860068, 0.487563},
{-0.511845, 0.356654, -0.249193, -0.943175, 0.316385, -0.101535, 0.868797, 0.497612},
{-0.511948, 0.354515, -0.222083, -0.944456, 0.325449, 0.045137, 0.795001, 0.499869},
{-0.508196, 0.361152, -0.222340, -0.730461, 0.679281, 0.070589, 0.789831, 0.484604},
{-0.501007, 0.365814, -0.223183, -0.379131, 0.924314, 0.043062, 0.766994, 0.472105},
{-0.502950, 0.364520, -0.245936, -0.323893, 0.942747, -0.079134, 0.855700, 0.469608},
{-0.501231, 0.362920, -0.259170, -0.271798, 0.946898, -0.171697, 0.897532, 0.464644},
{-0.505888, 0.360520, -0.264680, -0.511246, 0.796991, -0.321543, 0.915056, 0.477967},
{-0.507464, 0.356705, -0.267142, -0.770196, 0.362529, -0.524705, 0.926413, 0.483828},
{-0.512619, 0.349458, -0.249607, -0.990600, 0.051759, -0.126560, 1.801477, -1.231161},
{-0.513197, 0.346119, -0.222084, -0.997131, 0.075106, -0.005127, 1.715053, -1.219963},
{-0.511948, 0.354515, -0.222083, -0.944456, 0.325449, 0.045137, 1.745693, -1.258804},
{-0.511845, 0.356654, -0.249193, -0.943175, 0.316385, -0.101535, 1.801973, -1.255356},
{-0.507464, 0.356705, -0.267142, -0.770196, 0.362529, -0.524705, 1.875737, -1.255529},
{-0.508061, 0.350283, -0.267430, -0.813105, 0.072481, -0.577563, 1.872948, -1.233576},
{-0.508064, 0.341175, -0.268009, -0.830897, 0.088931, -0.549242, 1.874999, -1.207984},
{-0.512298, 0.339381, -0.250042, -0.991913, -0.019654, -0.125156, 1.803588, -1.202247},
{-0.512869, 0.334862, -0.222484, -0.998840, -0.030396, -0.036561, 1.717135, -1.187657},
{-0.514030, 0.336861, -0.184941, -0.986084, 0.135350, 0.096408, 1.598726, -1.191199},
{-0.511753, 0.346955, -0.186630, -0.912564, 0.374981, 0.163030, 1.603935, -1.220374},
{-0.514564, 0.324387, -0.185316, -0.999115, 0.001740, 0.041993, 1.600597, -1.155362},
{-0.510379, 0.314500, -0.152535, -0.878780, 0.023286, 0.476577, 1.469017, -1.114214},
{-0.509217, 0.327594, -0.152344, -0.834986, 0.208716, 0.509110, 1.467448, -1.153651},
{-0.506567, 0.338733, -0.156019, -0.698416, 0.506088, 0.505997, 1.480169, -1.188595},
{-0.507160, 0.356718, -0.192069, -0.709861, 0.674520, 0.202582, 1.621521, -1.248898},
{-0.508196, 0.361152, -0.222340, -0.730461, 0.679281, 0.070589, 1.724381, -1.269496},
{-0.501931, 0.351368, -0.166793, -0.483322, 0.756035, 0.441298, 1.518661, -1.228300},
{-0.496119, 0.359166, -0.179472, -0.303201, 0.886380, 0.349773, 1.570040, -1.270384},
{-0.499208, 0.364036, -0.197779, -0.377117, 0.905850, 0.192846, 1.645297, -1.277096},
{-0.501007, 0.365814, -0.223183, -0.379131, 0.924314, 0.043062, 1.720553, -1.283809},
{0.121812, 0.355156, -0.191205, 0.645558, 0.734733, 0.208167, 2.081672, 0.486392},
{0.123728, 0.350037, -0.187858, 0.924100, 0.300882, 0.235481, 2.072276, 0.471863},
{0.127743, 0.352299, -0.221816, 0.980987, 0.174413, -0.084811, 2.211982, 0.483656},
{0.126685, 0.356513, -0.222216, 0.756798, 0.652120, -0.043977, 2.200025, 0.490165},
{0.122309, 0.358871, -0.222736, 0.261879, 0.965026, -0.008789, 2.198996, 0.499869},
{0.116569, 0.358063, -0.194733, 0.225379, 0.966643, 0.121616, 2.095541, 0.497638},
{0.108356, 0.356048, -0.174341, 0.162175, 0.968902, 0.186773, 1.992087, 0.495406},
{0.110486, 0.353355, -0.163319, 0.404950, 0.851131, 0.333995, 1.963319, 0.482618},
{0.112987, 0.347418, -0.156903, 0.739372, 0.451552, 0.499374, 1.943592, 0.465587},
{0.124642, 0.342690, -0.187650, 0.973052, 0.079134, 0.216468, 2.071828, 0.450769},
{0.128074, 0.345871, -0.222183, 0.992950, 0.047639, -0.108371, 2.180831, 0.458212},
{0.114196, 0.338828, -0.156116, 0.851711, 0.088321, 0.516465, 1.941944, 0.440067},
{0.115252, 0.327310, -0.157815, 0.860927, 0.044374, 0.506729, 1.948517, 0.406149},
{0.125449, 0.332170, -0.188829, 0.976501, 0.064638, 0.205451, 2.075430, 0.420486},
{0.128339, 0.336109, -0.223066, 0.990509, 0.060579, -0.123142, 2.183217, 0.430121},
{0.120234, 0.346615, -0.245542, 0.864528, 0.050722, -0.499954, 2.248073, 0.459138},
{0.120709, 0.353386, -0.244366, 0.857662, 0.178625, -0.482131, 2.245798, 0.483535},
{0.119662, 0.336631, -0.247342, 0.861812, 0.102725, -0.496658, 2.252754, 0.430355},
{0.106617, 0.336015, -0.262269, 0.639149, 0.207587, -0.740532, 2.303165, 0.425889},
{0.107930, 0.346509, -0.259321, 0.632282, 0.122990, -0.764885, 2.294433, 0.456805},
{0.109115, 0.353975, -0.257369, 0.603687, 0.326151, -0.727409, 2.290543, 0.486609},
{0.120377, 0.356755, -0.242958, 0.637562, 0.683950, -0.354503, 0.847797, -1.321880},
{0.126685, 0.356513, -0.222216, 0.756798, 0.652120, -0.043977, 0.798589, -1.356092},
{0.127743, 0.352299, -0.221816, 0.980987, 0.174413, -0.084811, 0.799231, -1.359837},
{0.120709, 0.353386, -0.244366, 0.857662, 0.178625, -0.482131, 0.852716, -1.324043},
{0.109115, 0.353975, -0.257369, 0.603687, 0.326151, -0.727409, 0.894019, -1.290887},
{0.109335, 0.356732, -0.254921, 0.386151, 0.805689, -0.449141, 0.885495, -1.290124},
{0.109482, 0.357486, -0.250717, 0.143315, 0.974059, -0.175085, 0.872191, -1.290532},
{0.117046, 0.358140, -0.241845, 0.211005, 0.966308, -0.147343, 0.844191, -1.312266},
{0.122309, 0.358871, -0.222736, 0.261879, 0.965026, -0.008789, 0.773616, -1.344967},
{-0.431909, 0.370508, -0.246501, -0.034852, 0.994537, -0.098270, 0.857191, 0.265646},
{-0.469097, 0.368619, -0.248542, -0.064394, 0.992615, -0.102603, 0.863695, 0.372458},
{-0.468041, 0.369741, -0.226106, -0.052889, 0.998352, 0.021302, 0.792892, 0.369412},
{-0.431325, 0.371371, -0.225188, -0.036653, 0.998718, 0.034791, 0.789945, 0.263951},
{-0.389740, 0.372579, -0.223345, -0.019990, 0.998840, 0.043489, 0.784115, 0.144483},
{-0.390023, 0.371936, -0.243522, -0.016388, 0.995453, -0.093631, 0.847767, 0.145317},
{-0.389714, 0.369564, -0.258473, -0.009644, 0.982757, -0.184545, 0.895058, 0.144385},
{-0.431781, 0.368006, -0.262330, -0.031617, 0.981994, -0.186193, 0.907260, 0.265233},
{-0.469410, 0.365947, -0.265272, -0.067995, 0.976806, -0.202979, 0.916615, 0.373308},
{-0.491175, 0.366773, -0.247359, -0.144139, 0.984466, -0.099948, 0.860054, 0.435843},
{-0.489445, 0.368283, -0.224938, -0.132603, 0.991028, 0.015900, 0.789273, 0.430872},
{-0.492480, 0.363951, -0.264287, -0.156468, 0.967193, -0.199957, 0.913608, 0.439541},
{-0.486856, 0.366790, -0.200285, -0.111728, 0.978545, 0.173070, 0.711658, 0.423335},
{-0.465203, 0.367456, -0.200418, -0.034486, 0.982910, 0.180700, 0.712067, 0.361133},
{-0.499208, 0.364036, -0.197779, -0.377117, 0.905850, 0.192846, 0.708822, 0.465135},
{-0.496119, 0.359166, -0.179472, -0.303201, 0.886380, 0.349773, 0.639441, 0.466274},
{-0.485713, 0.360686, -0.176544, -0.104465, 0.914884, 0.389904, 0.637228, 0.419811},
{-0.463103, 0.360462, -0.175455, -0.024812, 0.911954, 0.409528, 0.633844, 0.354828},
{-0.429348, 0.368506, -0.199013, -0.035401, 0.980132, 0.195074, 0.707623, 0.258126},
{-0.427595, 0.361120, -0.173635, -0.036409, 0.905209, 0.423322, 0.628117, 0.252807},
{-0.387736, 0.361990, -0.171768, -0.029756, 0.900357, 0.434095, 0.597353, 0.107602},
{-0.388799, 0.369422, -0.197069, -0.024293, 0.979461, 0.200110, 0.701495, 0.141627},
{-0.494661, -0.341939, -0.256264, -0.229560, -0.866543, -0.443159, 1.366125, -1.289243},
{-0.470329, -0.340271, -0.259625, 0.009033, -0.895291, -0.445357, 1.375003, -1.219146},
{-0.472677, -0.345984, -0.232859, 0.018586, -0.999542, -0.023133, 1.294287, -1.227070},
{-0.498038, -0.346555, -0.229765, -0.177435, -0.984100, -0.000946, 1.285765, -1.300076},
{-0.512618, -0.340940, -0.227905, -0.689200, -0.719932, -0.081637, 1.278652, -1.352138},
{-0.508374, -0.335909, -0.253992, -0.693686, -0.576128, -0.432234, 1.357396, -1.338477},
{-0.503102, -0.323548, -0.268520, -0.615101, -0.391339, -0.684439, 1.433367, -1.323045},
{-0.492316, -0.326436, -0.275463, -0.291757, -0.485366, -0.824152, 1.443031, -1.276234},
{-0.468576, -0.324250, -0.278531, -0.042024, -0.496353, -0.867061, 1.450903, -1.209027},
{-0.431498, -0.337265, -0.263439, 0.013153, -0.872860, -0.487777, 1.384178, -1.107322},
{-0.432764, -0.344504, -0.237150, 0.014740, -0.995697, -0.091372, 1.305627, -1.112176},
{-0.430369, -0.320735, -0.281142, -0.016266, -0.467299, -0.883938, 1.455190, -1.101026},
{-0.387205, -0.317890, -0.283006, -0.019196, -0.437391, -0.899045, 1.456842, -0.978584},
{-0.387850, -0.335012, -0.266611, -0.012421, -0.847255, -0.530992, 1.391540, -0.981710},
{-0.388301, -0.343582, -0.241083, -0.010620, -0.989776, -0.142186, 1.315955, -0.984240},
{-0.433099, -0.342245, -0.207458, -0.013215, -0.979400, 0.201453, 1.211996, -1.114141},
{-0.473609, -0.340999, -0.204622, -0.016053, -0.958312, 0.285195, 1.203943, -1.230602},
{-0.388381, -0.343270, -0.210293, -0.010712, -0.989135, 0.146397, 1.219804, -0.985582},
{-0.388418, -0.336147, -0.181416, -0.017945, -0.919492, 0.392651, 1.126432, -0.986490},
{-0.433390, -0.333424, -0.180418, -0.049959, -0.895993, 0.441206, 1.123569, -1.115650},
{-0.474492, -0.329822, -0.179751, -0.061495, -0.862484, 0.502304, 1.121198, -1.233650},
{-0.500033, -0.339810, -0.202768, -0.149480, -0.932279, 0.329356, 1.198499, -1.306555},
{-0.501975, -0.327210, -0.179467, -0.165838, -0.832698, 0.528275, 1.120022, -1.312539},
{-0.513808, -0.325714, -0.183099, -0.434431, -0.772637, 0.462844, 1.119444, -1.371873},
{-0.515671, -0.334481, -0.200687, -0.585376, -0.771722, 0.248421, 1.194361, -1.362255},
{-0.427684, 0.348420, -0.154712, -0.026368, 0.759209, 0.650288, 0.569317, 0.252629},
{-0.464259, 0.347458, -0.155193, -0.023041, 0.775353, 0.631092, 0.570841, 0.357705},
{-0.465936, 0.333529, -0.141221, -0.032441, 0.611530, 0.790551, 0.515449, 0.365173},
{-0.428093, 0.334442, -0.141732, -0.008637, 0.616718, 0.787103, 0.520871, 0.255023},
{-0.386596, 0.335699, -0.142752, -0.010681, 0.602374, 0.798120, 0.531965, 0.126832},
{-0.387084, 0.349805, -0.154516, -0.024049, 0.738121, 0.674215, 0.569611, 0.129602},
{-0.488319, 0.348361, -0.156860, -0.146336, 0.786279, 0.600238, 0.576000, 0.426878},
{-0.491694, 0.334609, -0.143433, -0.252541, 0.588122, 0.768303, 0.521373, 0.439242},
{-0.501931, 0.351368, -0.166793, -0.483322, 0.756035, 0.441298, 0.582976, 0.478100},
{-0.506567, 0.338733, -0.156019, -0.698416, 0.506088, 0.505997, 0.532970, 0.495270},
{-0.492857, 0.324222, -0.138460, -0.368389, 0.263375, 0.891568, -1.234692, 0.537088},
{-0.465402, 0.323761, -0.135127, -0.069247, 0.334300, 0.939879, -1.236810, 0.615949},
{-0.465936, 0.333529, -0.141221, -0.032441, 0.611530, 0.790551, -1.260699, 0.610398},
{-0.491694, 0.334609, -0.143433, -0.252541, 0.588122, 0.768303, -1.262072, 0.536285},
{-0.506567, 0.338733, -0.156019, -0.698416, 0.506088, 0.505997, -1.268976, 0.480098},
{-0.509217, 0.327594, -0.152344, -0.834986, 0.208716, 0.509110, -1.233036, 0.473524},
{-0.510379, 0.314500, -0.152535, -0.878780, 0.023286, 0.476577, -1.189596, 0.469807},
{-0.493313, 0.311743, -0.138135, -0.419935, 0.033204, 0.906919, -1.195345, 0.537171},
{-0.464933, 0.311653, -0.133573, -0.116398, 0.088717, 0.989227, -1.198817, 0.618631},
{-0.427303, 0.323224, -0.134181, -0.017670, 0.414563, 0.909818, -1.239854, 0.725406},
{-0.428093, 0.334442, -0.141732, -0.008637, 0.616718, 0.787103, -1.270391, 0.720361},
{-0.426810, 0.309762, -0.130302, -0.060091, 0.184149, 0.981048, -1.197737, 0.728286},
{-0.385721, 0.307322, -0.127831, -0.044099, 0.261849, 0.964080, -1.195245, 0.846528},
{-0.386021, 0.322506, -0.133919, -0.014466, 0.459670, 0.887936, -1.242678, 0.844029},
{-0.386596, 0.335699, -0.142752, -0.010681, 0.602374, 0.798120, -1.292700, 0.815337},
{-0.430683, 0.358534, -0.280093, -0.052065, 0.378399, -0.924161, 0.533352, 2.125214},
{-0.470693, 0.354714, -0.278198, -0.092715, 0.201025, -0.975158, 0.544312, 2.240208},
{-0.470563, 0.360258, -0.277176, -0.084597, 0.514786, -0.853114, 0.523335, 2.240282},
{-0.431300, 0.363188, -0.277399, -0.038820, 0.716819, -0.696158, 0.515646, 2.127235},
{-0.387677, 0.365047, -0.276246, 0.005127, 0.856014, -0.516892, 0.507107, 1.992629},
{-0.386269, 0.361292, -0.280941, -0.013337, 0.581561, -0.813379, 0.520835, 1.988041},
{-0.384999, 0.353884, -0.283731, -0.027863, 0.254128, -0.966735, 0.532243, 1.959638},
{-0.430022, 0.350711, -0.282014, -0.053743, 0.241432, -0.968902, 0.558093, 2.123561},
{-0.470590, 0.346562, -0.279606, -0.109775, 0.252663, -0.961272, 0.570062, 2.240147},
{-0.495286, 0.352000, -0.275469, -0.341502, 0.108890, -0.933531, 0.552158, 2.310845},
{-0.494827, 0.358002, -0.275114, -0.327799, 0.399884, -0.855922, 0.529324, 2.310210},
{-0.495382, 0.343476, -0.276401, -0.372662, 0.213630, -0.903012, 0.579058, 2.311351},
{-0.508064, 0.341175, -0.268009, -0.830897, 0.088931, -0.549242, 0.586568, 2.359866},
{-0.508061, 0.350283, -0.267430, -0.813105, 0.072481, -0.577563, 0.558446, 2.359304},
{-0.507464, 0.356705, -0.267142, -0.770196, 0.362529, -0.524705, 0.534464, 2.358580},
{-0.493795, 0.361507, -0.272463, -0.238838, 0.837367, -0.491623, 0.939543, 0.443259},
{-0.470017, 0.363581, -0.273842, -0.076357, 0.881680, -0.465560, 0.943789, 0.374997},
{-0.470563, 0.360258, -0.277176, -0.084597, 0.514786, -0.853114, 0.958091, 0.377105},
{-0.494827, 0.358002, -0.275114, -0.327799, 0.399884, -0.855922, 0.951669, 0.446988},
{-0.431622, 0.365955, -0.272054, -0.031617, 0.935087, -0.352947, 0.938052, 0.264733},
{-0.431300, 0.363188, -0.277399, -0.038820, 0.716819, -0.696158, 0.959205, 0.264190},
{-0.388879, 0.367536, -0.269069, 0.001953, 0.955992, -0.293374, 0.928600, 0.141945},
{-0.387677, 0.365047, -0.276246, 0.005127, 0.856014, -0.516892, 0.960716, 0.162135},
{0.048673, 0.358543, -0.195244, -0.000366, 0.992920, 0.118564, 0.697149, -1.115868},
{0.084563, 0.358526, -0.195106, -0.009766, 0.996002, 0.088778, 0.696771, -1.219006},
{0.090385, 0.359956, -0.222516, 0.008240, 0.999908, 0.008972, 0.783093, -1.235636},
{0.051949, 0.360413, -0.222411, 0.010254, 0.999817, 0.015259, 0.782670, -1.125168},
{0.001751, 0.361164, -0.221961, 0.015412, 0.999786, 0.013367, 0.781126, -0.980893},
{0.001211, 0.359037, -0.195308, 0.012757, 0.989624, 0.142918, 0.697245, -0.979463},
{0.000769, 0.353418, -0.169806, -0.005676, 0.939360, 0.342875, 0.617225, -0.978418},
{0.045093, 0.353969, -0.168887, -0.034333, 0.959593, 0.279214, 0.614361, -1.105777},
{0.077955, 0.355122, -0.168160, -0.043458, 0.975890, 0.213782, 0.612043, -1.200177},
{0.105674, 0.358776, -0.195485, 0.027039, 0.996490, 0.079165, 0.697980, -1.279663},
{0.112024, 0.359731, -0.222730, 0.044160, 0.998993, -0.001312, 0.783816, -1.297824},
{0.097976, 0.356118, -0.168874, 0.021973, 0.982879, 0.182836, 0.614256, -1.257680},
{0.108356, 0.356048, -0.174341, 0.162175, 0.968902, 0.186773, 0.618735, -1.296734},
{0.116569, 0.358063, -0.194733, 0.225379, 0.966643, 0.121616, 0.699983, -1.319080},
{0.108523, 0.358957, -0.241556, 0.055605, 0.994446, -0.088992, 0.843212, -1.287748},
{0.088620, 0.359411, -0.241866, 0.016144, 0.997436, -0.069582, 0.844126, -1.230539},
{0.102179, 0.357723, -0.253374, 0.065767, 0.990966, -0.116642, 0.880539, -1.269534},
{0.084371, 0.358253, -0.254534, 0.019898, 0.996368, -0.082766, 0.884132, -1.218340},
{0.051148, 0.359707, -0.242548, 0.008789, 0.997375, -0.071780, 0.846200, -1.122848},
{0.048922, 0.358227, -0.256913, 0.004608, 0.997040, -0.076662, 0.891581, -1.116467},
{0.000793, 0.358210, -0.258291, 0.005585, 0.996460, -0.083773, 0.895851, -0.978158},
{0.001404, 0.360132, -0.242507, 0.010193, 0.996246, -0.085818, 0.845966, -0.979887},
{0.051779, -0.335277, -0.267493, -0.023713, -0.836726, -0.547075, 1.379542, 0.281541},
{0.088716, -0.337987, -0.266147, -0.018830, -0.860927, -0.508347, 1.375358, 0.387532},
{0.093959, -0.344168, -0.241464, 0.020631, -0.998810, -0.043672, 1.301101, 0.401478},
{0.055044, -0.343492, -0.243125, 0.003418, -0.990539, -0.137089, 1.307280, 0.289745},
{0.004594, -0.343040, -0.244892, 0.014344, -0.977050, -0.212439, 1.314287, 0.144863},
{0.003315, -0.333040, -0.268916, 0.002899, -0.812159, -0.583392, 1.384574, 0.142417},
{0.002288, -0.315155, -0.284135, 0.014405, -0.416761, -0.908872, 1.442835, 0.138127},
{0.048538, -0.318072, -0.282852, 0.008667, -0.409406, -0.912290, 1.441016, 0.268750},
{0.083165, -0.321443, -0.281630, 0.013855, -0.399762, -0.916501, 1.439979, 0.366129},
{0.107879, -0.338651, -0.265567, 0.310739, -0.775994, -0.548875, 1.373214, 0.442550},
{0.114020, -0.343613, -0.240854, 0.340129, -0.939848, -0.030671, 1.298261, 0.459117},
{0.101107, -0.322757, -0.280985, 0.292642, -0.321848, -0.900418, 1.438925, 0.416870},
{0.108765, -0.319452, -0.275650, 0.603839, -0.186865, -0.774865, 1.437861, 0.444293},
{0.116318, -0.331480, -0.264984, 0.731162, -0.396802, -0.554857, 1.372089, 0.472081},
{0.123255, -0.336578, -0.241090, 0.806909, -0.579516, -0.114078, 1.297090, 0.489709},
{0.113717, -0.336073, -0.212015, 0.348430, -0.873806, 0.339152, 1.204823, 0.457461},
{0.093927, -0.338784, -0.212275, 0.102939, -0.953215, 0.284219, 1.207569, 0.400510},
{0.123022, -0.329570, -0.212121, 0.743065, -0.615345, 0.263039, 1.203638, 0.487019},
{0.120126, -0.320537, -0.193683, 0.657765, -0.611591, 0.439589, 1.100958, 0.474169},
{0.112090, -0.322539, -0.187365, 0.385937, -0.749748, 0.537492, 1.102142, 0.446694},
{0.092304, -0.327072, -0.186429, 0.180792, -0.832820, 0.523179, 1.104401, 0.392086},
{0.055072, -0.342370, -0.213199, 0.069796, -0.983398, 0.167302, 1.213441, 0.288773},
{0.054059, -0.334370, -0.185608, 0.132694, -0.888974, 0.438246, 1.108813, 0.283214},
{0.004274, -0.340402, -0.185177, 0.060274, -0.927122, 0.369793, 1.098961, 0.181787},
{0.004580, -0.345390, -0.214287, 0.037294, -0.996368, 0.076449, 1.219950, 0.143622},
{0.097434, 0.351782, -0.151951, 0.104678, 0.901669, 0.419477, 0.561196, -1.256290},
{0.077362, 0.349748, -0.150203, -0.066988, 0.879360, 0.471389, 0.555791, -1.198678},
{0.079291, 0.342226, -0.140221, -0.009461, 0.568651, 0.822504, 0.513779, -1.205844},
{0.099841, 0.345258, -0.143363, 0.328898, 0.551927, 0.766259, 0.523468, -1.265196},
{0.112987, 0.347418, -0.156903, 0.739372, 0.451552, 0.499374, 0.539829, -1.306642},
{0.110486, 0.353355, -0.163319, 0.404950, 0.851131, 0.333995, 0.570923, -1.296228},
{0.044980, 0.346564, -0.151178, -0.077670, 0.839839, 0.537217, 0.559032, -1.105719},
{0.046336, 0.336990, -0.140461, -0.073550, 0.591235, 0.803095, 0.517432, -1.110679},
{0.001406, 0.343970, -0.152711, -0.032075, 0.797754, 0.602100, 0.563969, -0.980576},
{0.002507, 0.332265, -0.141577, -0.037660, 0.605426, 0.794977, 0.524095, -0.984337},
{0.047160, 0.325906, -0.135080, -0.000092, 0.304422, 0.952513, -1.306525, 2.087607},
{0.080246, 0.332379, -0.137202, 0.110141, 0.169378, 0.979369, -1.330855, 2.181917},
{0.079291, 0.342226, -0.140221, -0.009461, 0.568651, 0.822504, -1.365505, 2.179337},
{0.046336, 0.336990, -0.140461, -0.073550, 0.591235, 0.803095, -1.343589, 2.084708},
{0.002507, 0.332265, -0.141577, -0.037660, 0.605426, 0.794977, -1.321881, 1.958894},
{0.003458, 0.319873, -0.133957, -0.006958, 0.410779, 0.911679, -1.282220, 1.962774},
{0.004230, 0.305411, -0.128931, 0.037690, 0.243385, 0.969176, -1.237056, 1.966558},
{0.047866, 0.312455, -0.132620, 0.077914, 0.148534, 0.985809, -1.264385, 2.091114},
{0.081093, 0.319891, -0.137364, 0.190252, 0.040712, 0.980865, -1.291608, 2.185746},
{0.100995, 0.336039, -0.141758, 0.483322, 0.096255, 0.870113, -1.344661, 2.241136},
{0.099841, 0.345258, -0.143363, 0.328898, 0.551927, 0.766259, -1.377995, 2.238425},
{0.102011, 0.324030, -0.143211, 0.523637, 0.005951, 0.851894, -1.306868, 2.245410},
{0.115252, 0.327310, -0.157815, 0.860927, 0.044374, 0.506729, -1.316146, 2.287590},
{0.114196, 0.338828, -0.156116, 0.851711, 0.088321, 0.516465, -1.353204, 2.282808},
{0.112987, 0.347418, -0.156903, 0.739372, 0.451552, 0.499374, -1.385771, 2.279742},
{0.097968, 0.347135, -0.265118, 0.363689, 0.228187, -0.903104, 0.582423, 0.605859},
{0.080669, 0.348360, -0.268907, 0.214515, 0.306192, -0.927458, 0.578231, 0.655671},
{0.082067, 0.355459, -0.266008, 0.161260, 0.649831, -0.742759, 0.548397, 0.650321},
{0.099448, 0.354745, -0.262685, 0.322916, 0.503677, -0.801233, 0.550443, 0.599974},
{0.109115, 0.353975, -0.257369, 0.603687, 0.326151, -0.727409, 0.553132, 0.574726},
{0.107930, 0.346509, -0.259321, 0.632282, 0.122990, -0.764885, 0.585727, 0.580562},
{0.106617, 0.336015, -0.262269, 0.639149, 0.207587, -0.740532, 0.619519, 0.585397},
{0.096404, 0.336540, -0.268460, 0.366802, 0.302622, -0.879665, 0.615888, 0.610714},
{0.079260, 0.338150, -0.272070, 0.210974, 0.305094, -0.928648, 0.610481, 0.660065},
{0.046351, 0.350047, -0.276662, 0.181158, 0.388073, -0.903623, 0.572262, 0.754511},
{0.047333, 0.355880, -0.273032, 0.114841, 0.783502, -0.610645, 0.547634, 0.750863},
{0.045422, 0.340784, -0.279257, 0.181219, 0.248726, -0.951445, 0.601522, 0.757483},
{0.000025, 0.343530, -0.286262, 0.105777, 0.211798, -0.971557, 0.591908, 0.888111},
{0.000198, 0.351767, -0.283978, 0.099551, 0.511155, -0.853664, 0.565875, 0.887345},
{0.000416, 0.356260, -0.279315, 0.052187, 0.887051, -0.458693, 0.546761, 0.886353},
{0.047920, 0.357779, -0.266762, 0.025788, 0.983856, -0.176977, 0.922657, -1.113581},
{0.082744, 0.357846, -0.261899, 0.060640, 0.958220, -0.279427, 0.907376, -1.213661},
{0.082067, 0.355459, -0.266008, 0.161260, 0.649831, -0.742759, 0.922239, -1.212743},
{0.047333, 0.355880, -0.273032, 0.114841, 0.783502, -0.610645, 0.946580, -1.112443},
{0.000416, 0.356260, -0.279315, 0.052187, 0.887051, -0.458693, 0.968452, -0.977173},
{0.000539, 0.357664, -0.270656, 0.011170, 0.993683, -0.111637, 0.934868, -0.977418},
{0.100003, 0.357297, -0.259593, 0.175176, 0.906949, -0.383038, 0.900172, -1.263280},
{0.099448, 0.354745, -0.262685, 0.322916, 0.503677, -0.801233, 0.910956, -1.263005},
{-0.519747, -0.258205, -0.253130, -0.973601, -0.038148, -0.225013, 1.844280, 0.227427},
{-0.518250, -0.287858, -0.253523, -0.951170, -0.072176, -0.300027, 1.847844, 0.312548},
{-0.522822, -0.299037, -0.226943, -0.988159, -0.052461, -0.144017, 1.763913, 0.346355},
{-0.522609, -0.270190, -0.225728, -0.994293, 0.006134, -0.106418, 1.758245, 0.263540},
{-0.522187, -0.239257, -0.223865, -0.996307, -0.015595, -0.084292, 1.750451, 0.174759},
{-0.520658, -0.227563, -0.252495, -0.984741, -0.028321, -0.171667, 1.840035, 0.139459},
{-0.516692, -0.215803, -0.271622, -0.814600, -0.040162, -0.578600, 1.917017, 0.094381},
{-0.514282, -0.245611, -0.271145, -0.775201, -0.071322, -0.627644, 1.916849, 0.179329},
{-0.510507, -0.275256, -0.271439, -0.736595, -0.068606, -0.672811, 1.920379, 0.264420},
{-0.515348, -0.315821, -0.253444, -0.909818, -0.206824, -0.359752, 1.850160, 0.392791},
{-0.520185, -0.323860, -0.227317, -0.954680, -0.256111, -0.151494, 1.767379, 0.417560},
{-0.507146, -0.305206, -0.272283, -0.703452, -0.160649, -0.692312, 1.926413, 0.352199},
{-0.503102, -0.323548, -0.268520, -0.615101, -0.391339, -0.684439, 1.933699, 0.441322},
{-0.508374, -0.335909, -0.253992, -0.693686, -0.576128, -0.432234, 1.851852, 0.470595},
{-0.512618, -0.340940, -0.227905, -0.689200, -0.719932, -0.081637, 1.769743, 0.482961},
{-0.523822, -0.320818, -0.197172, -0.930692, -0.357128, 0.079012, 1.671540, 0.410682},
{-0.526667, -0.300112, -0.193265, -0.997040, -0.076785, 0.002289, 1.657190, 0.351517},
{-0.515671, -0.334481, -0.200687, -0.585376, -0.771722, 0.248421, 1.687109, 0.461512},
{-0.513808, -0.325714, -0.183099, -0.434431, -0.772637, 0.462844, 1.604213, 0.423156},
{-0.520683, -0.314888, -0.172817, -0.670186, -0.558794, 0.488388, 1.569173, 0.387981},
{-0.523772, -0.297580, -0.164958, -0.833338, -0.247719, 0.494095, 1.539072, 0.342358},
{-0.526388, -0.273655, -0.190009, -0.999817, 0.013245, -0.011383, 1.645280, 0.275681},
{-0.524209, -0.273644, -0.159747, -0.874203, -0.075198, 0.479629, 1.518848, 0.275838},
{-0.523434, -0.245635, -0.156964, -0.882138, -0.018860, 0.470595, 1.508270, 0.196464},
{-0.525430, -0.243968, -0.187496, -0.999969, 0.001190, -0.003723, 1.635662, 0.190501},
{0.121085, -0.310685, -0.263624, 0.826106, -0.101321, -0.554277, 2.275456, -1.143106},
{0.123484, -0.282447, -0.261527, 0.808222, 0.001373, -0.588824, 2.273345, -1.063673},
{0.133310, -0.291437, -0.241953, 0.969115, -0.062349, -0.238502, 2.247898, -1.068983},
{0.129696, -0.317815, -0.241968, 0.953795, -0.223975, -0.200201, 2.213624, -1.162461},
{0.123255, -0.336578, -0.241090, 0.806909, -0.579516, -0.114078, 2.205457, -1.233196},
{0.116318, -0.331480, -0.264984, 0.731162, -0.396802, -0.554857, 2.277567, -1.222539},
{0.108765, -0.319452, -0.275650, 0.603839, -0.186865, -0.774865, 2.341444, -1.193425},
{0.109416, -0.301238, -0.277026, 0.612384, 0.007324, -0.790490, 2.322685, -1.108726},
{0.110785, -0.272633, -0.272355, 0.572863, 0.074404, -0.816248, 2.303927, -1.024026},
{0.124820, -0.252947, -0.258729, 0.807520, 0.034150, -0.588794, 2.159658, 0.540025},
{0.134068, -0.261553, -0.239510, 0.976684, 0.021577, -0.213538, 2.191912, 0.500512},
{0.133310, -0.291437, -0.241953, 0.969115, -0.062349, -0.238502, 2.299043, 0.499869},
{0.123484, -0.282447, -0.261527, 0.808222, 0.001373, -0.588824, 2.254732, 0.543139},
{0.110785, -0.272633, -0.272355, 0.572863, 0.074404, -0.816248, 2.244689, 0.576151},
{0.112461, -0.244954, -0.269016, 0.555528, 0.049348, -0.830012, 2.134449, 0.575706},
{0.113646, -0.216986, -0.267256, 0.586932, 0.020783, -0.809351, 2.025166, 0.564230},
{0.125359, -0.223224, -0.255903, 0.837397, 0.038575, -0.545183, 2.064584, 0.536911},
{0.133534, -0.231005, -0.235549, 0.985595, 0.037538, -0.164769, 2.084780, 0.501156},
{0.134461, -0.266882, -0.208450, 0.993072, 0.019562, 0.115604, 2.115749, -1.014411},
{0.134654, -0.293082, -0.211436, 0.990081, -0.100894, 0.097720, 2.123732, -1.089840},
{0.134068, -0.261553, -0.239510, 0.976684, 0.021577, -0.213538, 2.232721, -1.005620},
{0.133534, -0.231005, -0.235549, 0.985595, 0.037538, -0.164769, 2.234032, -0.927914},
{0.132394, -0.238419, -0.203826, 0.988006, 0.029206, 0.151585, 2.101644, -0.932407},
{0.124278, -0.244449, -0.173596, 0.892178, -0.014008, 0.451399, 1.982059, -0.951358},
{0.127525, -0.270310, -0.178784, 0.893460, -0.024384, 0.448469, 1.998776, -1.023201},
{0.128649, -0.292313, -0.182934, 0.879208, -0.165716, 0.446638, 2.010846, -1.082243},
{0.130421, -0.314609, -0.212294, 0.938780, -0.312784, 0.144200, 2.122588, -1.151765},
{0.124772, -0.309149, -0.186183, 0.794580, -0.414411, 0.443678, 2.016950, -1.126045},
{0.120126, -0.320537, -0.193683, 0.657765, -0.611591, 0.439589, 2.020070, -1.162226},
{0.123022, -0.329570, -0.212121, 0.743065, -0.615345, 0.263039, 2.116880, -1.206939},
{-0.509200, -0.275202, -0.148720, -0.351634, -0.168706, 0.920774, 0.341235, 0.546083},
{-0.508121, -0.297936, -0.154489, -0.312510, -0.378918, 0.871029, 0.423160, 0.549460},
{-0.479037, -0.300436, -0.152729, -0.085757, -0.409101, 0.908444, 0.426038, 0.634383},
{-0.480360, -0.278303, -0.146810, -0.086947, -0.198187, 0.976287, 0.347347, 0.629228},
{-0.481106, -0.252059, -0.143630, -0.101291, -0.103214, 0.989471, 0.264573, 0.624121},
{-0.509251, -0.248195, -0.145843, -0.373577, -0.065584, 0.925260, 0.255992, 0.542886},
{-0.523434, -0.245635, -0.156964, -0.882138, -0.018860, 0.470595, 0.249092, 0.484336},
{-0.524209, -0.273644, -0.159747, -0.874203, -0.075198, 0.479629, 0.336569, 0.484310},
{-0.523772, -0.297580, -0.164958, -0.833338, -0.247719, 0.494095, 0.421578, 0.484681},
{-0.505192, -0.314263, -0.164056, -0.236427, -0.652608, 0.719840, 1.066030, -1.321887},
{-0.476691, -0.316955, -0.163082, -0.083377, -0.679800, 0.728599, 1.063285, -1.240122},
{-0.479037, -0.300436, -0.152729, -0.085757, -0.409101, 0.908444, 1.017786, -1.248307},
{-0.508121, -0.297936, -0.154489, -0.312510, -0.378918, 0.871029, 1.024280, -1.332917},
{-0.523772, -0.297580, -0.164958, -0.833338, -0.247719, 0.494095, 1.030344, -1.397477},
{-0.520683, -0.314888, -0.172817, -0.670186, -0.558794, 0.488388, 1.068820, -1.384038},
{-0.434521, -0.320978, -0.162085, -0.069674, -0.712577, 0.698080, 1.060629, -1.119131},
{-0.435840, -0.304335, -0.150549, -0.075137, -0.442701, 0.893490, 1.010433, -1.123598},
{-0.388742, -0.324282, -0.161623, -0.030580, -0.747459, 0.663564, 1.059183, -0.987722},
{-0.389135, -0.307950, -0.148944, -0.043367, -0.485214, 0.873287, 1.004995, -0.989115},
{-0.436691, -0.282920, -0.143899, -0.081393, -0.231544, 0.969390, 0.356354, 0.755118},
{-0.435840, -0.304335, -0.150549, -0.075137, -0.442701, 0.893490, 0.431509, 0.759592},
{-0.389135, -0.307950, -0.148944, -0.043367, -0.485214, 0.873287, 0.436121, 0.894528},
{-0.389382, -0.287427, -0.141408, -0.054231, -0.271645, 0.960845, 0.364593, 0.891451},
{-0.389445, -0.263105, -0.136374, -0.067415, -0.185400, 0.980316, 0.287681, 0.888502},
{-0.437223, -0.257634, -0.139820, -0.098483, -0.146367, 0.984283, 0.276519, 0.750723},
{-0.493416, -0.300521, -0.280562, -0.310099, -0.102268, -0.945158, 2.294430, 2.318402},
{-0.497147, -0.269910, -0.279123, -0.304239, -0.012970, -0.952483, 2.197776, 2.328365},
{-0.472753, -0.267900, -0.281332, -0.067476, 0.032105, -0.997192, 2.192131, 2.258297},
{-0.469426, -0.298311, -0.283190, -0.073580, -0.062075, -0.995331, 2.288157, 2.249505},
{-0.468576, -0.324250, -0.278531, -0.042024, -0.496353, -0.867061, 2.385706, 2.244117},
{-0.492316, -0.326436, -0.275463, -0.291757, -0.485366, -0.824152, 2.392688, 2.311077},
{-0.503102, -0.323548, -0.268520, -0.615101, -0.391339, -0.684439, 2.397477, 2.357620},
{-0.507146, -0.305206, -0.272283, -0.703452, -0.160649, -0.692312, 2.299341, 2.365737},
{-0.510507, -0.275256, -0.271439, -0.736595, -0.068606, -0.672811, 2.202700, 2.374777},
{-0.502693, -0.240321, -0.278705, -0.311075, -0.044282, -0.949339, 2.104328, 2.343605},
{-0.478426, -0.238462, -0.280686, -0.055940, -0.009064, -0.998383, 2.099149, 2.273899},
{-0.514282, -0.245611, -0.271145, -0.775201, -0.071322, -0.627644, 2.109046, 2.385665},
{-0.516692, -0.215803, -0.271622, -0.814600, -0.040162, -0.578600, 2.015736, 2.392602},
{-0.506140, -0.210896, -0.279483, -0.329539, -0.048341, -0.942869, 2.011487, 2.352858},
{-0.481858, -0.209184, -0.281372, -0.049959, -0.048036, -0.997589, 2.006769, 2.283107},
{-0.434929, -0.236160, -0.281964, -0.027772, 0.000519, -0.999603, 2.093049, 2.148898},
{-0.431907, -0.265305, -0.282825, -0.034944, 0.047609, -0.998230, 2.185043, 2.140918},
{-0.436703, -0.207010, -0.282583, -0.023896, -0.046846, -0.998596, 2.001111, 2.153343},
{-0.386093, -0.204997, -0.283803, -0.032563, -0.045167, -0.998444, 1.996102, 2.007910},
{-0.386151, -0.234221, -0.283172, -0.033753, 0.001495, -0.999420, 2.088223, 2.008730},
{-0.386113, -0.263238, -0.284037, -0.032197, 0.050569, -0.998199, 2.179739, 2.009318},
{-0.430446, -0.295122, -0.285077, -0.037599, -0.041627, -0.998413, 2.279161, 2.137485},
{-0.386545, -0.292546, -0.286398, -0.027955, -0.031343, -0.999115, 2.272207, 2.011318},
{-0.387205, -0.317890, -0.283006, -0.019196, -0.437391, -0.899045, 2.365152, 2.014024},
{-0.430369, -0.320735, -0.281142, -0.016266, -0.467299, -0.883938, 2.374340, 2.136326},
{0.053870, -0.284075, -0.149374, 0.175024, -0.292337, 0.940153, 0.300067, 2.164020},
{0.054479, -0.305163, -0.157396, 0.169683, -0.440626, 0.881466, 0.366903, 2.168206},
{0.093272, -0.298339, -0.163378, 0.249245, -0.374859, 0.892941, 0.340999, 2.278905},
{0.091729, -0.277245, -0.156296, 0.274026, -0.250832, 0.928404, 0.274315, 2.272045},
{0.089268, -0.252110, -0.149644, 0.289773, -0.209998, 0.933744, 0.195038, 2.262103},
{0.052668, -0.259330, -0.142811, 0.171728, -0.227180, 0.958586, 0.221869, 2.157740},
{0.005714, -0.265985, -0.138101, 0.082583, -0.225166, 0.970794, 0.248322, 2.023600},
{0.005750, -0.290235, -0.144345, 0.087527, -0.314402, 0.945219, 0.325081, 2.026477},
{0.005326, -0.311087, -0.152940, 0.084384, -0.487289, 0.869137, 0.417118, 1.994516},
{0.054201, -0.321948, -0.168240, 0.161107, -0.679617, 0.715629, 0.420462, 2.169394},
{0.092775, -0.314269, -0.171776, 0.224403, -0.611469, 0.758751, 0.391746, 2.279340},
{0.004678, -0.328389, -0.165640, 0.075350, -0.730308, 0.678915, 0.454837, 2.035078},
{0.004274, -0.340402, -0.185177, 0.060274, -0.927122, 0.369793, 0.507107, 2.034757},
{0.054059, -0.334370, -0.185608, 0.132694, -0.888974, 0.438246, 0.467381, 2.169084},
{0.092304, -0.327072, -0.186429, 0.180792, -0.832820, 0.523179, 0.434524, 2.276562},
{0.114261, -0.309519, -0.175217, 0.467513, -0.531785, 0.706137, 0.374348, 2.340544},
{0.116425, -0.294060, -0.169402, 0.533586, -0.281137, 0.797632, 0.325036, 2.344974},
{0.112090, -0.322539, -0.187365, 0.385937, -0.749748, 0.537492, 0.415406, 2.330344},
{0.120126, -0.320537, -0.193683, 0.657765, -0.611591, 0.439589, 0.403157, 2.357279},
{0.124772, -0.309149, -0.186183, 0.794580, -0.414411, 0.443678, 0.362609, 2.377378},
{0.128649, -0.292313, -0.182934, 0.879208, -0.165716, 0.446638, 0.314044, 2.388728},
{0.114781, -0.273210, -0.163749, 0.569750, -0.151830, 0.807642, 0.259218, 2.337864},
{0.127525, -0.270310, -0.178784, 0.893460, -0.024384, 0.448469, 0.249448, 2.382580},
{0.124278, -0.244449, -0.173596, 0.892178, -0.014008, 0.451399, 0.171100, 2.368746},
{0.111520, -0.248082, -0.157720, 0.592456, -0.128819, 0.795221, 0.180096, 2.325633},
{0.048581, -0.292220, -0.285748, 0.067598, -0.010773, -0.997650, 2.282334, 0.760934},
{0.049997, -0.262670, -0.282964, 0.110691, 0.072695, -0.991180, 2.189120, 0.756085},
{0.083815, -0.266422, -0.278717, 0.130650, 0.112491, -0.985015, 2.201691, 0.658850},
{0.082274, -0.295733, -0.283221, 0.081118, 0.035920, -0.996033, 2.294201, 0.664110},
{0.083165, -0.321443, -0.281630, 0.013855, -0.399762, -0.916501, 2.389834, 0.669124},
{0.048538, -0.318072, -0.282852, 0.008667, -0.409406, -0.912290, 2.377535, 0.766588},
{0.002288, -0.315155, -0.284135, 0.014405, -0.416761, -0.908872, 2.366353, 0.897297},
{0.003060, -0.289149, -0.288323, 0.041444, -0.054537, -0.997620, 2.271562, 0.891757},
{0.004220, -0.259337, -0.287200, 0.064211, 0.037416, -0.997223, 2.177560, 0.887697},
{0.050876, -0.234376, -0.281283, 0.132176, 0.038545, -0.990448, 2.099880, 0.752849},
{0.085564, -0.239075, -0.275913, 0.154790, 0.058626, -0.986175, 2.115428, 0.653098},
{0.004359, -0.230029, -0.286488, 0.075076, 0.023133, -0.996887, 2.085137, 0.886595},
{0.004338, -0.200787, -0.286126, 0.076540, 0.006531, -0.997040, 1.992926, 0.885970},
{0.051397, -0.206108, -0.280625, 0.135594, 0.004883, -0.990722, 2.010746, 0.750677},
{0.086803, -0.211648, -0.274838, 0.158208, 0.004700, -0.987365, 2.028949, 0.648866},
{0.102734, -0.241466, -0.273284, 0.294565, 0.062746, -0.953551, 2.123328, 0.603724},
{0.100820, -0.268518, -0.276632, 0.290231, 0.120151, -0.949370, 2.208671, 0.609963},
{0.104174, -0.214201, -0.271975, 0.308878, 0.007233, -0.951048, 2.037359, 0.598912},
{0.099516, -0.297497, -0.281936, 0.289315, 0.053346, -0.955718, 2.300166, 0.614561},
{0.109416, -0.301238, -0.277026, 0.612384, 0.007324, -0.790490, 2.303182, 0.588649},
{0.108765, -0.319452, -0.275650, 0.603839, -0.186865, -0.774865, 2.395942, 0.590889},
{0.101107, -0.322757, -0.280985, 0.292642, -0.321848, -0.900418, 2.394737, 0.618338},
{-0.522238, -0.115118, -0.252545, -0.962706, 0.005860, -0.270394, 1.832384, -0.183548},
{-0.522538, -0.160719, -0.251694, -0.971526, -0.007050, -0.236732, 1.832643, -0.052477},
{-0.526658, -0.172586, -0.219938, -0.995270, -0.032563, -0.091281, 1.732605, -0.016410},
{-0.527586, -0.128147, -0.220228, -0.994720, -0.005737, -0.102206, 1.730352, -0.144071},
{-0.527133, -0.072462, -0.221289, -0.993927, 0.013489, -0.109012, 1.730537, -0.286175},
{-0.521273, -0.058449, -0.253559, -0.959563, 0.013611, -0.281106, 1.832480, -0.328499},
{-0.510877, -0.046084, -0.277184, -0.751640, 0.009461, -0.659444, 1.930179, -0.376977},
{-0.512124, -0.103131, -0.276411, -0.758171, 0.004608, -0.651997, 1.930968, -0.230623},
{-0.513842, -0.149431, -0.274902, -0.779565, 0.004700, -0.626301, 1.928049, -0.096661},
{-0.521800, -0.196634, -0.251847, -0.981780, -0.021699, -0.188726, 1.835675, 0.050675},
{-0.524198, -0.208172, -0.221543, -0.995361, -0.045869, -0.084231, 1.740604, 0.085654},
{-0.515955, -0.185366, -0.273090, -0.810297, -0.003876, -0.585955, 1.922075, 0.007029},
{-0.526239, -0.213573, -0.185821, -0.999207, -0.031587, 0.023865, 1.628192, 0.103300},
{-0.527780, -0.178777, -0.185117, -0.997986, -0.031526, 0.054689, 1.623302, 0.003422},
{-0.522887, -0.216109, -0.156389, -0.878445, -0.008942, 0.477706, 1.507108, 0.112278},
{-0.522897, -0.182127, -0.156942, -0.870235, -0.009796, 0.492508, 1.509366, 0.015136},
{-0.529014, -0.135885, -0.185518, -0.997772, -0.012909, 0.065096, 1.621424, -0.119790},
{-0.523797, -0.140746, -0.157541, -0.864254, -0.008148, 0.502945, 1.509049, -0.103106},
{-0.524234, -0.089149, -0.157557, -0.862178, 0.003021, 0.506577, 1.505429, -0.232304},
{-0.529220, -0.082178, -0.186111, -0.998047, 0.010041, 0.061617, 1.620105, -0.256162},
{0.125365, -0.194318, -0.253723, 0.866573, 0.027009, -0.498276, 2.253630, -0.808215},
{0.125282, -0.160678, -0.252320, 0.880062, 0.008515, -0.474746, 2.250995, -0.711484},
{0.133445, -0.170103, -0.227210, 0.992767, -0.002197, -0.119938, 2.178094, -0.737265},
{0.133273, -0.202634, -0.230978, 0.991180, 0.020203, -0.130924, 2.187931, -0.830927},
{0.125359, -0.223224, -0.255903, 0.837397, 0.038575, -0.545183, 2.258050, -0.890195},
{0.113646, -0.216986, -0.267256, 0.586932, 0.020783, -0.809351, 2.293420, -0.872469},
{0.113540, -0.187513, -0.267318, 0.633290, 0.002747, -0.773858, 2.300424, -0.784064},
{0.112938, -0.152352, -0.268095, 0.665090, -0.001892, -0.746727, 2.306474, -0.681730},
{0.125549, -0.116755, -0.251828, 0.880886, 0.000488, -0.473312, 2.251930, -0.585250},
{0.134212, -0.127079, -0.225658, 0.992431, -0.009186, -0.122410, 2.176024, -0.613556},
{0.112634, -0.107321, -0.268480, 0.675161, 0.002106, -0.737663, 2.310616, -0.551538},
{0.111950, -0.050841, -0.268547, 0.672628, 0.011933, -0.739860, 2.313060, -0.406995},
{0.125426, -0.060745, -0.251734, 0.877377, 0.009919, -0.479690, 2.254154, -0.442267},
{0.134617, -0.071515, -0.225254, 0.992096, 0.004975, -0.125248, 2.177599, -0.471835},
{0.131365, -0.133767, -0.190630, 0.981658, -0.020234, 0.189428, 2.065681, -0.631051},
{0.130571, -0.176894, -0.193031, 0.982147, -0.021210, 0.186834, 2.070350, -0.755097},
{0.131920, -0.078445, -0.189710, 0.981262, 0.001160, 0.192602, 2.065744, -0.489996},
{0.121649, -0.083429, -0.157168, 0.885189, -0.002960, 0.465163, 1.936240, -0.502454},
{0.121165, -0.138445, -0.158573, 0.887234, -0.032044, 0.460158, 1.938118, -0.643140},
{0.120575, -0.181804, -0.161594, 0.888089, -0.046571, 0.457259, 1.945184, -0.768954},
{0.131006, -0.210100, -0.198058, 0.984466, -0.000732, 0.175481, 2.084424, -0.850759},
{0.121787, -0.216043, -0.167234, 0.890378, -0.040559, 0.453352, 1.962013, -0.869151},
{-0.509208, -0.145142, -0.145421, -0.428266, -0.001892, 0.903623, -0.068683, 0.531488},
{-0.509002, -0.185469, -0.145122, -0.420637, -0.001923, 0.907193, 0.058315, 0.536585},
{-0.481955, -0.190033, -0.140295, -0.165838, -0.024598, 0.985839, 0.069082, 0.614717},
{-0.481556, -0.150821, -0.139914, -0.185278, -0.008087, 0.982635, -0.054518, 0.611476},
{-0.480456, -0.101765, -0.139477, -0.191748, -0.010773, 0.981353, -0.189526, 0.609846},
{-0.508872, -0.094925, -0.145158, -0.426649, -0.006348, 0.904386, -0.207246, 0.527535},
{-0.524234, -0.089149, -0.157557, -0.862178, 0.003021, 0.506577, -0.220779, 0.467988},
{-0.523797, -0.140746, -0.157541, -0.864254, -0.008148, 0.502945, -0.079180, 0.475716},
{-0.522897, -0.182127, -0.156942, -0.870235, -0.009796, 0.492508, 0.050275, 0.483406},
{-0.509101, -0.219052, -0.144953, -0.398785, -0.018494, 0.916837, 0.164113, 0.540052},
{-0.481721, -0.223207, -0.141496, -0.132878, -0.058931, 0.989349, 0.173632, 0.619108},
{-0.522887, -0.216109, -0.156389, -0.878445, -0.008942, 0.477706, 0.156680, 0.485157},
{-0.437586, -0.229379, -0.136000, -0.124424, -0.108676, 0.986236, 0.187325, 0.746483},
{-0.437616, -0.197047, -0.133098, -0.147282, -0.059023, 0.987304, 0.085304, 0.742754},
{-0.389285, -0.235377, -0.131203, -0.080905, -0.146947, 0.985809, 0.200001, 0.885809},
{-0.389000, -0.203686, -0.127000, -0.089877, -0.087313, 0.992096, 0.099883, 0.883045},
{-0.437148, -0.159532, -0.131776, -0.161351, -0.022065, 0.986633, -0.033016, 0.739891},
{-0.388686, -0.167480, -0.124873, -0.095889, -0.036287, 0.994720, -0.014342, 0.879879},
{-0.388392, -0.120865, -0.123904, -0.098910, -0.015320, 0.994964, -0.141594, 0.876201},
{-0.436305, -0.111930, -0.131076, -0.167272, -0.012574, 0.985809, -0.163430, 0.737683},
{-0.503572, -0.180778, -0.281629, -0.327342, -0.035829, -0.944212, 1.916656, 2.344858},
{-0.498992, -0.144979, -0.284078, -0.309793, -0.024323, -0.950468, 1.803977, 2.330954},
{-0.473040, -0.143598, -0.285955, -0.048677, -0.047212, -0.997681, 1.800344, 2.256413},
{-0.478458, -0.179252, -0.283507, -0.048128, -0.064486, -0.996734, 1.912548, 2.272720},
{-0.515955, -0.185366, -0.273090, -0.810297, -0.003876, -0.585955, 1.920126, 2.389789},
{-0.513842, -0.149431, -0.274902, -0.779565, 0.004700, -0.626301, 1.806713, 2.382419},
{-0.496400, -0.098514, -0.285765, -0.299326, -0.012024, -0.954070, 1.657593, 2.322492},
{-0.470417, -0.097151, -0.287578, -0.049165, -0.021180, -0.998535, 1.654016, 2.247859},
{-0.512124, -0.103131, -0.276411, -0.758171, 0.004608, -0.651997, 1.659989, 2.375686},
{-0.510877, -0.046084, -0.277184, -0.751640, 0.009461, -0.659444, 1.499533, 2.370509},
{-0.495178, -0.041314, -0.286428, -0.297250, 0.002564, -0.954772, 1.496998, 2.317826},
{-0.469470, -0.039756, -0.288204, -0.050661, -0.001129, -0.998688, 1.492799, 2.243977},
{-0.429526, -0.094923, -0.288822, -0.026124, -0.021668, -0.999420, 1.648078, 2.130347},
{-0.431041, -0.141522, -0.287264, -0.024476, -0.049715, -0.998444, 1.794916, 2.135722},
{-0.429045, -0.037026, -0.289426, -0.028748, -0.002686, -0.999573, 1.485269, 2.127794},
{-0.384233, -0.033736, -0.290574, -0.032594, -0.005036, -0.999451, 1.476079, 1.998987},
{-0.384296, -0.092261, -0.289895, -0.027894, -0.022553, -0.999329, 1.640880, 2.000352},
{-0.384574, -0.139225, -0.288359, -0.026246, -0.048799, -0.998444, 1.788901, 2.002181},
{-0.434420, -0.177174, -0.284767, -0.023072, -0.068514, -0.997375, 1.907164, 2.146169},
{-0.385370, -0.175068, -0.285930, -0.028687, -0.066164, -0.997375, 1.901818, 2.005213},
{0.049926, -0.159640, -0.128029, 0.111209, -0.052248, 0.992401, -0.092724, 2.138574},
{0.050034, -0.198957, -0.131051, 0.132267, -0.113742, 0.984649, 0.031303, 2.143308},
{0.085637, -0.190537, -0.136492, 0.277596, -0.116214, 0.953612, 0.000727, 2.244662},
{0.085814, -0.149012, -0.133065, 0.261391, -0.054323, 0.963683, -0.130311, 2.240495},
{0.085996, -0.095960, -0.131432, 0.250069, -0.017487, 0.968047, -0.277870, 2.235769},
{0.049961, -0.108930, -0.126545, 0.100375, -0.019227, 0.994751, -0.232875, 2.133691},
{0.003833, -0.120744, -0.124163, 0.037355, -0.020356, 0.999084, -0.190137, 2.002523},
{0.003866, -0.169311, -0.125505, 0.042085, -0.048555, 0.997925, -0.056752, 2.007361},
{0.004158, -0.206642, -0.128047, 0.054262, -0.103488, 0.993133, 0.060968, 2.012398},
{0.051169, -0.231572, -0.136341, 0.156499, -0.182562, 0.970641, 0.134224, 2.150266},
{0.087013, -0.224055, -0.142531, 0.290689, -0.180059, 0.939695, 0.106509, 2.252420},
{0.004978, -0.238494, -0.132457, 0.070284, -0.169744, 0.982971, 0.161472, 2.018359},
{0.108837, -0.219786, -0.150777, 0.603839, -0.125706, 0.787103, 0.090875, 2.314697},
{0.107374, -0.185585, -0.144711, 0.604724, -0.091189, 0.791162, -0.017050, 2.306611},
{0.121787, -0.216043, -0.167234, 0.890378, -0.040559, 0.453352, 0.081281, 2.357035},
{0.120575, -0.181804, -0.161594, 0.888089, -0.046571, 0.457259, -0.028429, 2.348857},
{0.107771, -0.142737, -0.141315, 0.600909, -0.047884, 0.797845, -0.152283, 2.302929},
{0.121165, -0.138445, -0.158573, 0.887234, -0.032044, 0.460158, -0.166448, 2.345619},
{0.121649, -0.083429, -0.157168, 0.885189, -0.002960, 0.465163, -0.320757, 2.341618},
{0.108116, -0.088364, -0.139691, 0.594836, -0.011353, 0.803735, -0.304024, 2.298524},
{0.051740, -0.176639, -0.280907, 0.127903, -0.016297, -0.991638, 1.917849, 0.749020},
{0.051786, -0.141064, -0.281643, 0.121067, -0.017853, -0.992462, 1.805705, 0.748094},
{0.086237, -0.146374, -0.276797, 0.142674, -0.022248, -0.989502, 1.823187, 0.649052},
{0.086818, -0.182095, -0.275522, 0.149541, -0.025971, -0.988403, 1.935792, 0.648164},
{0.005014, -0.171170, -0.286057, 0.073702, -0.008026, -0.997223, 1.899561, 0.883340},
{0.005647, -0.135526, -0.286376, 0.072268, -0.015717, -0.997253, 1.787203, 0.880711},
{0.051414, -0.094476, -0.282343, 0.122166, -0.010285, -0.992431, 1.658828, 0.748112},
{0.085690, -0.100440, -0.277498, 0.143742, -0.007660, -0.989563, 1.678369, 0.649590},
{0.005492, -0.088202, -0.287177, 0.075808, -0.015015, -0.996979, 1.638012, 0.880089},
{0.004767, -0.029584, -0.287946, 0.083346, -0.007263, -0.996490, 1.472903, 0.880991},
{0.050527, -0.036599, -0.282783, 0.128941, -0.001495, -0.991638, 1.496042, 0.749483},
{0.084725, -0.043259, -0.277713, 0.149236, 0.002045, -0.988769, 1.517765, 0.651193},
{0.102722, -0.103302, -0.274957, 0.353557, -0.003143, -0.935392, 1.687754, 0.600627},
{0.103272, -0.148860, -0.274268, 0.344340, -0.018036, -0.938658, 1.831389, 0.600072},
{0.101791, -0.046509, -0.275087, 0.355968, 0.007477, -0.934446, 1.528374, 0.602138},
{0.111950, -0.050841, -0.268547, 0.672628, 0.011933, -0.739860, 1.533425, 0.577701},
{0.112634, -0.107321, -0.268480, 0.675161, 0.002106, -0.737663, 1.692061, 0.576442},
{0.112938, -0.152352, -0.268095, 0.665090, -0.001892, -0.746727, 1.834952, 0.576123},
{0.104055, -0.184579, -0.272788, 0.327647, -0.022492, -0.944517, 1.943985, 0.598598},
{0.113540, -0.187513, -0.267318, 0.633290, 0.002747, -0.773858, 1.947304, 0.574676},
{-0.055317, 0.360974, -0.240646, 0.014649, 0.994568, -0.103000, 0.839955, -0.816866},
{-0.110361, 0.362256, -0.237964, 0.023957, 0.991791, -0.125370, 0.831328, -0.658652},
{-0.110279, 0.363832, -0.219159, 0.036775, 0.999268, -0.008789, 0.771939, -0.658878},
{-0.055172, 0.362270, -0.220716, 0.023164, 0.999695, 0.005188, 0.777038, -0.817284},
{-0.055055, 0.358763, -0.256445, 0.010071, 0.995239, -0.096774, 0.889908, -0.817653},
{-0.109896, 0.359771, -0.253003, 0.016205, 0.992798, -0.118595, 0.878906, -0.660036},
{-0.155075, 0.364000, -0.235460, 0.037721, 0.987976, -0.149846, 0.823247, -0.530110},
{-0.155031, 0.365949, -0.217775, 0.048128, 0.998566, -0.022980, 0.767364, -0.530213},
{-0.155000, 0.361118, -0.249594, 0.028504, 0.988098, -0.151128, 0.867998, -0.530386},
{-0.200745, 0.363178, -0.248273, 0.047212, 0.980987, -0.188208, 0.863625, -0.398868},
{-0.200476, 0.366281, -0.234634, 0.049562, 0.986602, -0.155278, 0.820421, -0.399575},
{-0.200449, 0.368258, -0.217272, 0.044710, 0.998779, -0.020478, 0.765555, -0.399626},
{-0.154862, 0.364574, -0.193118, 0.053316, 0.987671, 0.146977, 0.689725, -0.530792},
{-0.109680, 0.362069, -0.193845, 0.044649, 0.987548, 0.150670, 0.692256, -0.660705},
{-0.200622, 0.366975, -0.192857, 0.038789, 0.987762, 0.150975, 0.688672, -0.399219},
{-0.200980, 0.360993, -0.168558, 0.030122, 0.908353, 0.417066, 0.600783, -0.398583},
{-0.154566, 0.358661, -0.168652, 0.048555, 0.913205, 0.404584, 0.601209, -0.531608},
{-0.108597, 0.356079, -0.169078, 0.042909, 0.918607, 0.392804, 0.591637, -0.622425},
{-0.054615, 0.360218, -0.194709, 0.027284, 0.987915, 0.152562, 0.695188, -0.819003},
{-0.053640, 0.354226, -0.169666, 0.022919, 0.925474, 0.378033, 0.616647, -0.822040},
{-0.257580, 0.369178, -0.236988, 0.050996, 0.990112, -0.130467, 0.827559, -0.235381},
{-0.313126, 0.371585, -0.240186, 0.036042, 0.994232, -0.100772, 0.837391, -0.075679},
{-0.313073, 0.372015, -0.220146, 0.021943, 0.999176, 0.034028, 0.774188, -0.075857},
{-0.257555, 0.370396, -0.218361, 0.034059, 0.999390, 0.005432, 0.768754, -0.235453},
{-0.257509, 0.366329, -0.251097, 0.058382, 0.973662, -0.220313, 0.872228, -0.235645},
{-0.312600, 0.369110, -0.254949, 0.047639, 0.971770, -0.230995, 0.884098, -0.077237},
{-0.353851, 0.372400, -0.241890, 0.008637, 0.995849, -0.090457, 0.842647, 0.041381},
{-0.353729, 0.372768, -0.221736, 0.002533, 0.998932, 0.045900, 0.779086, 0.041001},
{-0.353327, 0.370060, -0.256709, 0.018983, 0.977508, -0.209967, 0.889523, 0.039834},
{-0.353067, 0.369686, -0.195585, -0.006226, 0.980407, 0.196753, 0.696853, 0.038948},
{-0.312493, 0.369362, -0.194410, 0.008118, 0.982757, 0.184576, 0.693233, -0.077660},
{-0.352071, 0.362404, -0.170539, -0.015259, 0.898465, 0.438704, 0.605283, 0.036058},
{-0.311588, 0.362420, -0.169691, -0.003143, 0.899869, 0.436110, 0.603402, -0.080275},
{-0.257422, 0.368514, -0.193394, 0.019562, 0.985900, 0.166051, 0.690174, -0.235945},
{-0.257273, 0.362098, -0.168967, 0.008362, 0.903684, 0.428083, 0.601708, -0.236647},
{-0.349069, -0.335600, -0.268045, -0.034639, -0.827448, -0.560411, 1.394974, -0.870246},
{-0.307895, -0.337165, -0.268705, -0.029328, -0.815607, -0.577837, 1.396370, -0.751966},
{-0.308128, -0.346417, -0.244144, -0.026124, -0.988922, -0.146001, 1.324114, -0.753860},
{-0.349290, -0.344679, -0.243101, -0.031373, -0.987457, -0.154546, 1.321442, -0.872111},
{-0.348595, -0.317715, -0.283835, -0.025056, -0.418836, -0.907682, 1.456808, -0.868057},
{-0.307502, -0.318477, -0.284352, -0.023255, -0.412519, -0.910642, 1.456349, -0.749755},
{-0.257064, -0.337841, -0.269555, -0.013703, -0.807459, -0.589740, 1.397616, -0.605903},
{-0.257212, -0.347417, -0.245151, -0.011872, -0.989654, -0.142827, 1.325998, -0.607556},
{-0.256890, -0.318444, -0.285281, -0.016236, -0.412610, -0.910733, 1.456725, -0.603986},
{-0.203498, -0.317960, -0.286025, -0.003388, -0.414289, -0.910123, 1.456434, -0.450393},
{-0.203496, -0.337761, -0.270229, 0.000793, -0.801294, -0.598254, 1.397868, -0.451953},
{-0.203546, -0.347676, -0.245917, -0.001129, -0.988159, -0.153264, 1.326691, -0.453332},
{-0.257251, -0.344529, -0.214593, -0.004547, -0.980163, 0.198096, 1.229363, -0.608681},
{-0.308205, -0.344121, -0.213441, -0.003357, -0.983856, 0.178930, 1.227303, -0.755118},
{-0.203545, -0.345045, -0.215397, -0.008423, -0.981384, 0.191717, 1.230294, -0.454351},
{-0.203512, -0.335507, -0.186003, -0.013611, -0.923582, 0.383129, 1.134181, -0.454989},
{-0.257261, -0.334871, -0.185218, 0.002197, -0.923032, 0.384655, 1.133252, -0.609438},
{-0.308236, -0.335111, -0.184035, 0.016633, -0.924833, 0.379955, 1.131402, -0.755963},
{-0.349332, -0.343799, -0.212148, -0.005768, -0.988922, 0.148289, 1.224512, -0.873330},
{-0.349328, -0.336123, -0.182695, 0.014679, -0.926450, 0.376110, 1.129086, -0.874121},
{-0.154108, -0.337058, -0.270361, 0.015503, -0.797296, -0.603351, 1.396283, -0.310010},
{-0.104538, -0.335734, -0.270133, 0.026612, -0.795740, -0.605029, 1.393276, -0.167540},
{-0.104474, -0.346037, -0.246182, 0.020234, -0.978423, -0.205573, 1.323398, -0.168591},
{-0.154132, -0.347194, -0.246237, 0.009827, -0.984405, -0.175481, 1.325791, -0.311319},
{-0.154060, -0.317369, -0.285987, 0.010743, -0.415265, -0.909604, 1.453975, -0.308618},
{-0.104445, -0.316504, -0.285516, 0.018983, -0.416578, -0.908872, 1.450269, -0.166618},
{-0.050427, -0.333794, -0.269724, 0.025636, -0.798761, -0.601062, 1.389262, -0.012004},
{-0.050071, -0.344271, -0.245822, 0.023774, -0.973083, -0.229102, 1.319612, -0.012223},
{-0.050517, -0.315199, -0.284961, 0.020234, -0.418409, -0.908017, 1.446238, -0.012349},
{-0.050124, -0.346402, -0.215036, 0.007477, -0.997711, 0.066805, 1.224611, -0.013573},
{-0.104538, -0.346229, -0.215479, -0.006561, -0.993713, 0.111576, 1.227753, -0.169902},
{-0.050136, -0.341137, -0.185415, -0.005890, -0.936949, 0.349376, 1.129786, -0.014502},
{-0.104488, -0.339177, -0.185885, -0.028901, -0.932310, 0.360454, 1.132177, -0.170590},
{-0.154159, -0.345694, -0.215646, -0.010590, -0.986938, 0.160741, 1.229702, -0.312459},
{-0.154100, -0.337121, -0.186154, -0.026734, -0.926664, 0.374920, 1.133733, -0.313063},
{-0.052244, 0.343702, -0.152631, 0.012970, 0.770501, 0.637287, 0.563654, -0.826413},
{-0.107062, 0.344974, -0.151916, 0.032380, 0.755028, 0.654836, 0.560713, -0.657738},
{-0.105334, 0.331267, -0.140013, 0.023377, 0.601978, 0.798120, 0.519115, -0.665299},
{-0.050664, 0.330766, -0.141059, 0.008393, 0.608051, 0.793847, 0.523436, -0.831453},
{-0.154140, 0.346995, -0.151542, 0.033692, 0.740440, 0.671255, -1.347255, 1.507351},
{-0.153659, 0.332544, -0.139546, 0.021149, 0.590899, 0.806421, -1.302506, 1.510228},
{-0.105334, 0.331267, -0.140013, 0.023377, 0.601978, 0.798120, -1.315290, 1.679587},
{-0.107062, 0.344974, -0.151916, 0.032380, 0.755028, 0.654836, -1.345000, 1.631700},
{-0.108597, 0.356079, -0.169078, 0.042909, 0.918607, 0.392804, -1.386928, 1.623202},
{-0.154566, 0.358661, -0.168652, 0.048555, 0.913205, 0.404584, -1.392202, 1.504448},
{-0.200980, 0.360993, -0.168558, 0.030122, 0.908353, 0.417066, -1.394477, 1.371312},
{-0.201509, 0.348873, -0.151543, 0.017945, 0.728385, 0.684927, -1.347351, 1.371113},
{-0.202115, 0.333886, -0.139558, 0.009888, 0.582934, 0.812433, -1.300779, 1.370929},
{-0.153198, 0.318274, -0.130424, 0.015656, 0.467391, 0.883877, -1.258154, 1.513055},
{-0.103673, 0.317475, -0.131024, 0.021088, 0.468398, 0.883236, -1.261683, 1.655370},
{-0.202705, 0.319303, -0.130346, 0.007019, 0.467635, 0.883877, -1.255317, 1.370772},
{-0.203207, 0.303584, -0.123589, 0.005554, 0.319285, 0.947630, -1.206140, 1.371020},
{-0.152846, 0.302676, -0.123783, 0.014191, 0.316050, 0.948607, -1.209454, 1.515745},
{-0.102346, 0.302045, -0.124542, 0.023438, 0.309122, 0.950713, -1.213624, 1.660841},
{-0.049137, 0.317535, -0.132403, 0.015625, 0.458083, 0.888730, -1.268489, 1.811986},
{-0.050664, 0.330766, -0.141059, 0.008393, 0.608051, 0.793847, -1.310016, 1.806253},
{-0.047914, 0.302449, -0.126248, 0.030152, 0.291849, 0.955962, -1.221480, 1.817123},
{-0.257199, 0.349711, -0.151957, 0.000458, 0.722739, 0.691092, -1.343127, 1.211100},
{-0.310563, 0.349986, -0.152704, -0.009735, 0.721763, 0.692038, -1.337394, 1.057836},
{-0.309536, 0.335033, -0.140772, -0.011780, 0.586413, 0.809900, -1.291128, 1.062338},
{-0.257178, 0.334580, -0.139951, -0.002228, 0.582812, 0.812586, -1.296180, 1.212733},
{-0.257273, 0.362098, -0.168967, 0.008362, 0.903684, 0.428083, -1.390753, 1.209412},
{-0.311588, 0.362420, -0.169691, -0.003143, 0.899869, 0.436110, -1.384299, 1.053150},
{-0.350951, 0.350172, -0.153701, -0.018128, 0.725211, 0.688253, -1.332960, 0.941844},
{-0.349876, 0.335651, -0.142069, -0.016541, 0.591174, 0.806330, -1.288043, 0.946438},
{-0.352071, 0.362404, -0.170539, -0.015259, 0.898465, 0.438704, -1.378384, 0.936929},
{-0.387736, 0.361990, -0.171768, -0.029756, 0.900357, 0.434095, -1.372737, 0.840728},
{-0.387084, 0.349805, -0.154516, -0.024049, 0.738121, 0.674215, -1.329176, 0.844489},
{-0.349017, 0.321503, -0.132639, -0.020875, 0.475539, 0.879421, -1.244140, 0.950392},
{-0.308627, 0.320537, -0.131218, -0.013520, 0.476791, 0.878903, -1.246144, 1.066474},
{-0.348443, 0.305584, -0.125668, -0.036164, 0.300424, 0.953093, -1.194480, 0.953752},
{-0.307951, 0.304498, -0.124140, -0.019044, 0.313944, 0.949217, -1.196123, 1.070135},
{-0.257185, 0.319930, -0.130532, -0.002258, 0.472121, 0.881527, -1.250592, 1.214256},
{-0.257224, 0.304011, -0.123577, -0.003693, 0.318735, 0.947813, -1.200853, 1.215854},
{-0.052607, 0.353087, -0.286450, 0.027100, 0.631336, -0.775018, 0.560430, 1.039138},
{-0.106097, 0.354078, -0.285794, -0.004944, 0.718253, -0.695730, 0.555456, 1.200410},
{-0.107496, 0.357524, -0.278464, 0.002411, 0.959532, -0.281472, 0.541245, 1.206585},
{-0.053516, 0.356856, -0.280414, 0.013886, 0.939390, -0.342479, 0.544379, 1.041544},
{-0.051800, 0.345474, -0.289328, 0.033204, 0.226051, -0.973540, 0.584539, 1.037092},
{-0.104893, 0.346896, -0.289630, -0.005585, 0.281961, -0.959380, 0.565124, 1.229917},
{-0.154303, 0.354810, -0.283724, -0.012665, 0.774163, -0.632832, 0.976017, -0.532513},
{-0.154561, 0.358127, -0.275597, 0.003174, 0.964507, -0.263955, 0.950175, -0.531687},
{-0.107496, 0.357524, -0.278464, 0.002411, 0.959532, -0.281472, 0.972906, -0.699801},
{-0.106097, 0.354078, -0.285794, -0.004944, 0.718253, -0.695730, 0.984882, -0.663464},
{-0.104893, 0.346896, -0.289630, -0.005585, 0.281961, -0.959380, 1.002557, -0.670056},
{-0.154095, 0.348075, -0.288344, -0.020356, 0.351543, -0.935911, 0.995811, -0.533381},
{-0.203382, 0.349313, -0.286713, -0.012207, 0.407971, -0.912900, 0.990734, -0.391288},
{-0.202738, 0.355677, -0.281459, -0.000336, 0.808374, -0.588641, 0.968745, -0.393304},
{-0.202010, 0.358933, -0.273026, 0.014710, 0.959014, -0.282968, 0.941943, -0.395314},
{-0.154811, 0.359695, -0.263597, 0.018372, 0.992309, -0.122318, 0.912238, -0.530945},
{-0.108852, 0.358808, -0.267019, 0.011505, 0.995483, -0.094089, 0.923155, -0.663037},
{-0.201301, 0.361081, -0.261517, 0.032929, 0.982513, -0.183203, 0.905518, -0.397308},
{-0.054393, 0.358069, -0.270057, 0.009369, 0.995972, -0.088961, 0.932867, -0.819549},
{-0.053516, 0.356856, -0.280414, 0.013886, 0.939390, -0.342479, 0.972328, -0.821998},
{-0.256914, 0.357073, -0.280219, 0.017792, 0.823115, -0.567553, 0.964657, -0.237579},
{-0.308325, 0.358839, -0.279932, 0.034364, 0.806360, -0.590381, 0.963556, -0.089788},
{-0.309932, 0.361938, -0.272364, 0.049135, 0.921476, -0.385235, 0.939485, -0.085090},
{-0.257146, 0.360211, -0.271964, 0.030519, 0.942167, -0.333720, 0.938422, -0.236834},
{-0.256730, 0.350911, -0.285983, 0.001282, 0.429456, -0.903073, 0.988996, -0.238359},
{-0.306946, 0.352583, -0.285563, 0.004089, 0.401746, -0.915708, 0.987703, -0.094610},
{-0.348463, 0.360820, -0.280530, 0.028840, 0.732505, -0.680135, 0.965245, 0.025618},
{-0.350331, 0.364090, -0.274179, 0.047700, 0.904080, -0.424635, 0.945002, 0.031076},
{-0.346838, 0.354041, -0.284863, -0.007172, 0.325663, -0.945433, 0.983961, 0.019945},
{-0.384999, 0.353884, -0.283731, -0.027863, 0.254128, -0.966735, 0.978994, 0.119904},
{-0.386269, 0.361292, -0.280941, -0.013337, 0.581561, -0.813379, 0.968330, 0.124831},
{-0.352054, 0.367230, -0.266856, 0.037873, 0.946013, -0.321848, 0.921701, 0.036107},
{-0.311446, 0.365628, -0.264855, 0.052675, 0.939055, -0.339640, 0.915564, -0.080640},
{-0.257354, 0.363319, -0.262506, 0.047456, 0.959929, -0.276101, 0.908398, -0.236159},
{-0.349411, -0.324814, -0.162253, 0.010926, -0.776910, 0.629475, 1.060065, -0.874705},
{-0.308335, -0.324219, -0.163368, 0.017945, -0.798090, 0.602222, 1.061874, -0.756615},
{-0.308470, -0.310154, -0.149650, 0.009125, -0.561754, 0.827235, 1.005533, -0.757170},
{-0.349528, -0.309598, -0.148911, -0.005310, -0.528062, 0.849147, 1.004246, -0.875186},
{-0.257318, -0.324138, -0.164362, 0.005432, -0.808618, 0.588275, 1.063211, -0.609985},
{-0.257412, -0.310491, -0.150359, 0.006684, -0.578722, 0.815485, 1.006203, -0.610428},
{-0.203462, -0.324701, -0.165070, -0.008759, -0.807245, 0.590136, 1.063858, -0.455230},
{-0.203408, -0.310832, -0.150943, 0.000855, -0.578143, 0.815912, 1.006429, -0.455271},
{-0.257529, -0.292095, -0.141540, 0.006531, -0.338511, 0.940916, 0.363111, 1.270611},
{-0.308611, -0.291626, -0.141090, 0.002533, -0.327891, 0.944700, 0.367881, 1.123864},
{-0.308470, -0.310154, -0.149650, 0.009125, -0.561754, 0.827235, 0.433618, 1.126657},
{-0.257412, -0.310491, -0.150359, 0.006684, -0.578722, 0.815485, 0.428902, 1.273362},
{-0.203408, -0.310832, -0.150943, 0.000855, -0.578143, 0.815912, 0.423551, 1.428469},
{-0.203361, -0.292103, -0.141968, 0.005341, -0.340983, 0.940031, 0.356511, 1.426167},
{-0.203358, -0.268799, -0.136006, 0.005066, -0.214850, 0.976623, 0.282741, 1.423511},
{-0.257630, -0.269012, -0.135692, 0.005829, -0.213172, 0.976989, 0.290058, 1.267682},
{-0.308691, -0.268542, -0.135380, 0.000885, -0.211615, 0.977325, 0.294830, 1.120998},
{-0.349625, -0.290199, -0.140759, -0.017304, -0.305643, 0.951964, 0.368405, 1.005921},
{-0.349528, -0.309598, -0.148911, -0.005310, -0.528062, 0.849147, 0.436424, 1.008631},
{-0.349615, -0.266657, -0.135251, -0.023164, -0.205969, 0.978271, 0.293911, 1.003266},
{-0.153867, -0.326038, -0.165325, -0.021149, -0.795587, 0.605457, 1.063599, -0.312761},
{-0.104083, -0.327747, -0.165259, -0.024781, -0.778344, 0.627308, 1.062508, -0.169774},
{-0.103439, -0.312054, -0.151476, -0.007874, -0.542711, 0.839839, 1.005793, -0.168206},
{-0.153513, -0.311397, -0.151304, -0.005310, -0.564287, 0.825556, 1.006384, -0.312007},
{-0.049659, -0.329426, -0.165005, -0.000458, -0.759056, 0.650990, 1.060658, -0.013461},
{-0.048903, -0.312667, -0.151494, 0.013642, -0.518052, 0.855220, 1.004380, -0.011436},
{0.004678, -0.328389, -0.165640, 0.075350, -0.730308, 0.678915, 1.058429, 0.149515},
{0.005326, -0.311087, -0.152940, 0.084384, -0.487289, 0.869137, 1.002557, 0.151819},
{-0.048080, -0.292259, -0.142569, 0.021119, -0.326182, 0.945067, 0.337963, 1.872104},
{-0.102675, -0.292210, -0.142411, 0.001251, -0.334117, 0.942503, 0.344505, 1.715319},
{-0.103439, -0.312054, -0.151476, -0.007874, -0.542711, 0.839839, 0.414059, 1.715466},
{-0.048903, -0.312667, -0.151494, 0.013642, -0.518052, 0.855220, 0.408506, 1.872193},
{-0.047602, -0.268321, -0.136393, 0.021027, -0.220649, 0.975097, 0.262127, 1.870739},
{-0.102150, -0.268488, -0.136227, 0.002472, -0.218451, 0.975829, 0.269342, 1.714113},
{-0.153089, -0.292150, -0.142235, 0.002503, -0.339213, 0.940703, 0.350498, 1.570538},
{-0.153513, -0.311397, -0.151304, -0.005310, -0.564287, 0.825556, 0.418839, 1.571697},
{-0.152800, -0.268636, -0.136141, 0.002808, -0.216773, 0.976196, 0.276025, 1.568679},
{-0.346043, -0.233447, -0.284940, -0.045778, -0.004151, -0.998932, 2.086865, 1.893521},
{-0.305820, -0.232796, -0.287024, -0.045473, -0.010102, -0.998901, 2.085908, 1.777994},
{-0.306348, -0.262711, -0.287056, -0.039308, 0.024201, -0.998932, 2.180218, 1.780201},
{-0.346871, -0.262811, -0.285405, -0.037111, 0.040223, -0.998474, 2.179441, 1.896591},
{-0.345448, -0.203768, -0.285716, -0.046052, -0.041261, -0.998077, 1.993329, 1.891151},
{-0.305429, -0.202556, -0.287866, -0.043306, -0.034639, -0.998444, 1.990600, 1.776199},
{-0.256698, -0.231225, -0.289180, -0.033296, -0.009095, -0.999390, 2.082282, 1.636875},
{-0.256710, -0.261627, -0.289117, -0.033204, 0.012543, -0.999359, 2.178136, 1.637611},
{-0.256697, -0.200594, -0.289797, -0.027772, -0.025117, -0.999298, 1.985722, 1.636186},
{-0.204299, -0.198898, -0.290760, -0.002197, -0.013581, -0.999878, 1.981749, 1.485614},
{-0.204131, -0.229662, -0.290555, -0.009613, -0.000305, -0.999939, 2.078746, 1.485833},
{-0.203888, -0.260301, -0.290670, -0.013764, 0.009369, -0.999847, 2.175358, 1.485846},
{-0.256774, -0.291870, -0.289810, -0.025269, -0.071322, -0.997101, 2.273510, 1.638515},
{-0.306947, -0.292465, -0.288317, -0.027894, -0.053804, -0.998138, 2.274054, 1.782653},
{-0.203653, -0.290937, -0.291000, -0.010559, -0.083041, -0.996460, 2.271968, 1.485889},
{-0.203498, -0.317960, -0.286025, -0.003388, -0.414289, -0.910123, 2.368578, 1.485946},
{-0.256890, -0.318444, -0.285281, -0.016236, -0.412610, -0.910733, 2.368644, 1.639502},
{-0.307502, -0.318477, -0.284352, -0.023255, -0.412519, -0.910642, 2.367654, 1.785228},
{-0.347791, -0.292176, -0.287329, -0.026124, -0.037172, -0.998962, 2.272063, 1.899981},
{-0.348595, -0.317715, -0.283835, -0.025056, -0.418836, -0.907682, 2.364707, 1.903530},
{-0.153577, -0.229035, -0.290293, 0.012207, 0.011658, -0.999847, 2.078060, 1.340541},
{-0.102484, -0.228871, -0.289335, 0.016053, 0.019135, -0.999664, 2.078827, 1.193686},
{-0.103170, -0.258944, -0.290119, 0.014344, 0.017365, -0.999725, 2.173649, 1.196377},
{-0.153809, -0.259476, -0.290798, 0.006775, 0.013001, -0.999878, 2.174047, 1.341928},
{-0.153284, -0.198484, -0.290008, 0.018921, -0.002472, -0.999817, 1.981732, 1.338983},
{-0.101799, -0.198700, -0.288734, 0.018403, 0.005188, -0.999817, 1.983698, 1.191000},
{-0.048300, -0.228698, -0.288619, 0.026612, 0.019440, -0.999451, 2.079653, 1.037955},
{-0.048665, -0.258496, -0.289253, 0.025605, 0.021455, -0.999420, 2.173612, 1.039714},
{-0.047993, -0.198893, -0.288135, 0.025910, 0.007691, -0.999634, 1.985670, 1.036370},
{-0.049667, -0.288715, -0.289752, 0.021088, -0.077761, -0.996734, 2.268879, 1.043308},
{-0.103906, -0.289531, -0.290512, 0.013977, -0.085086, -0.996246, 2.270083, 1.199212},
{-0.050517, -0.315199, -0.284961, 0.020234, -0.418409, -0.908017, 2.364800, 1.047820},
{-0.104445, -0.316504, -0.285516, 0.018983, -0.416578, -0.908872, 2.367321, 1.202119},
{-0.153966, -0.290215, -0.291081, 0.006287, -0.086703, -0.996185, 2.270969, 1.343097},
{-0.154060, -0.317369, -0.285987, 0.010743, -0.415265, -0.909604, 2.368359, 1.344156},
{-0.349408, -0.239009, -0.129843, -0.022462, -0.159642, 0.986908, 0.206466, 1.000717},
{-0.308642, -0.240809, -0.130213, 0.004547, -0.155614, 0.987793, 0.207151, 1.117986},
{-0.308501, -0.208517, -0.126153, 0.010376, -0.095584, 0.995361, 0.105164, 1.114740},
{-0.349120, -0.207125, -0.125470, -0.017975, -0.097842, 0.995025, 0.105724, 0.997936},
{-0.257677, -0.241307, -0.130606, 0.006348, -0.151311, 0.988433, 0.202484, 1.264399},
{-0.257671, -0.209020, -0.126696, 0.007996, -0.092074, 0.995697, 0.100536, 1.260770},
{-0.203438, -0.241203, -0.130918, 0.004456, -0.150517, 0.988586, 0.195513, 1.420146},
{-0.203537, -0.209136, -0.127064, 0.004669, -0.090670, 0.995849, 0.094275, 1.416239},
{-0.257610, -0.172189, -0.124378, 0.009369, -0.044862, 0.998932, -0.015636, 1.256805},
{-0.308305, -0.171755, -0.123765, 0.013306, -0.045473, 0.998871, -0.010812, 1.111171},
{-0.203593, -0.172419, -0.124808, 0.004944, -0.044496, 0.998993, -0.021521, 1.411952},
{-0.203638, -0.124677, -0.123525, 0.004028, -0.020814, 0.999756, -0.152301, 1.407171},
{-0.257536, -0.124475, -0.123099, 0.009278, -0.019562, 0.999756, -0.146344, 1.252369},
{-0.308099, -0.124267, -0.122499, 0.013062, -0.018586, 0.999725, -0.140825, 1.107142},
{-0.348867, -0.170870, -0.123066, -0.016480, -0.043977, 0.998871, -0.008660, 0.994585},
{-0.348687, -0.124021, -0.121906, -0.017518, -0.017335, 0.999695, -0.136650, 0.990553},
{-0.152849, -0.241196, -0.131046, 0.001831, -0.151280, 0.988464, 0.189285, 1.565422},
{-0.102226, -0.241162, -0.131085, 0.001068, -0.153478, 0.988128, 0.182962, 1.710790},
{-0.102497, -0.209519, -0.127234, -0.000519, -0.092227, 0.995727, 0.083083, 1.706435},
{-0.153012, -0.209369, -0.127226, 0.001282, -0.090762, 0.995849, 0.088813, 1.561358},
{-0.047885, -0.240976, -0.131130, 0.016694, -0.158818, 0.987152, 0.175704, 1.866818},
{-0.048397, -0.209387, -0.127141, 0.011170, -0.095798, 0.995331, 0.076014, 1.861778},
{-0.048606, -0.172715, -0.124787, 0.007813, -0.046632, 0.998871, -0.039624, 1.857055},
{-0.102560, -0.172846, -0.124923, -0.001434, -0.045991, 0.998932, -0.032579, 1.702134},
{-0.048568, -0.124869, -0.123419, 0.007843, -0.022065, 0.999725, -0.170751, 1.852499},
{-0.102456, -0.125018, -0.123502, -0.001526, -0.023164, 0.999725, -0.163655, 1.697770},
{-0.153066, -0.172692, -0.124960, 0.000732, -0.045137, 0.998962, -0.026857, 1.557081},
{-0.153046, -0.124906, -0.123598, -0.000580, -0.022462, 0.999725, -0.157788, 1.552482},
{-0.345296, -0.089597, -0.291194, -0.032777, -0.024720, -0.999146, 1.633520, 1.888265},
{-0.305174, -0.086798, -0.292519, -0.027833, -0.026795, -0.999237, 1.625764, 1.772954},
{-0.305172, -0.135088, -0.290858, -0.028382, -0.039460, -0.998810, 1.777972, 1.774007},
{-0.345219, -0.137182, -0.289590, -0.031922, -0.044923, -0.998474, 1.783507, 1.889089},
{-0.345361, -0.030492, -0.292126, -0.038972, -0.008362, -0.999176, 1.466898, 1.887264},
{-0.305208, -0.027145, -0.293732, -0.032777, -0.012085, -0.999359, 1.457424, 1.771860},
{-0.256579, -0.083731, -0.293667, -0.014496, -0.027650, -0.999512, 1.617378, 1.633283},
{-0.256627, -0.132640, -0.292060, -0.015778, -0.034272, -0.999268, 1.771538, 1.634494},
{-0.256553, -0.023542, -0.295041, -0.017426, -0.015442, -0.999725, 1.447353, 1.632010},
{-0.204134, -0.021055, -0.295464, 0.005921, -0.018067, -0.999817, 1.440870, 1.481339},
{-0.204171, -0.081497, -0.293999, 0.007752, -0.027833, -0.999573, 1.611692, 1.482645},
{-0.204243, -0.130717, -0.292470, 0.007019, -0.030641, -0.999481, 1.766830, 1.483936},
{-0.256670, -0.169663, -0.290763, -0.020844, -0.033723, -0.999207, 1.888230, 1.635427},
{-0.305235, -0.171831, -0.289225, -0.035340, -0.044771, -0.998352, 1.893770, 1.774979},
{-0.204311, -0.167883, -0.291394, 0.003754, -0.025422, -0.999664, 1.883979, 1.484953},
{-0.345222, -0.173459, -0.287515, -0.038606, -0.057039, -0.997620, 1.897826, 1.889862},
{-0.152608, -0.081196, -0.292876, 0.026917, -0.027741, -0.999237, 1.612034, 1.334430},
{-0.100504, -0.082333, -0.291153, 0.029298, -0.025849, -0.999207, 1.616903, 1.184676},
{-0.100546, -0.130825, -0.289728, 0.025636, -0.024842, -0.999359, 1.769754, 1.185866},
{-0.152679, -0.130195, -0.291361, 0.026002, -0.028382, -0.999237, 1.766476, 1.335716},
{-0.152689, -0.021054, -0.294411, 0.026887, -0.019349, -0.999420, 1.442158, 1.333474},
{-0.100784, -0.022729, -0.292626, 0.033082, -0.018067, -0.999268, 1.448717, 1.184299},
{-0.046476, -0.084411, -0.289683, 0.036775, -0.021027, -0.999084, 1.624800, 1.029420},
{-0.046450, -0.132358, -0.288569, 0.031190, -0.019105, -0.999329, 1.775941, 1.030416},
{-0.046985, -0.025266, -0.290848, 0.043855, -0.013581, -0.998932, 1.458047, 1.029701},
{-0.047166, -0.168649, -0.288086, 0.027314, -0.007813, -0.999573, 1.890332, 1.033295},
{-0.101065, -0.167816, -0.288894, 0.021821, -0.013550, -0.999664, 1.886346, 1.188183},
{-0.152945, -0.167414, -0.290384, 0.023652, -0.019440, -0.999512, 1.883790, 1.337304},
{-0.511621, 0.325984, -0.252038, -0.994385, -0.000244, -0.105808, 1.810914, -1.163893},
{-0.511706, 0.308634, -0.254473, -0.993896, 0.058657, -0.093387, 1.819688, -1.114183},
{-0.512038, 0.300526, -0.224055, -0.998108, 0.059816, -0.013672, 1.724544, -1.089126},
{-0.511890, 0.319644, -0.223425, -0.999023, -0.022858, -0.037111, 1.721341, -1.144023},
{-0.507856, 0.329303, -0.271346, -0.852382, 0.138615, -0.504166, 1.886726, -1.175113},
{-0.507796, 0.313567, -0.275663, -0.859767, 0.123997, -0.495346, 1.902991, -1.131721},
{-0.513666, 0.286701, -0.256222, -0.989776, 0.077822, -0.119297, 1.826147, -1.051201},
{-0.515089, 0.277568, -0.223518, -0.995117, 0.098086, -0.007813, 1.723615, -1.023030},
{-0.508242, 0.292870, -0.279183, -0.842402, 0.074374, -0.533677, 1.918654, -1.074570},
{-0.508867, 0.253753, -0.280711, -0.808679, 0.015595, -0.588031, 1.928135, -0.982224},
{-0.516096, 0.246476, -0.256809, -0.984100, 0.038697, -0.173223, 1.829631, -0.953538},
{-0.518911, 0.236448, -0.222695, -0.997803, 0.056734, -0.033479, 1.722384, -0.922668},
{-0.516163, 0.265219, -0.184339, -0.992370, 0.092532, 0.081423, 1.601036, -0.985256},
{-0.513876, 0.287353, -0.186113, -0.997314, 0.053652, 0.049532, 1.605716, -1.049031},
{-0.519459, 0.224988, -0.182809, -0.994446, 0.058901, 0.086917, 1.597651, -0.887426},
{-0.513965, 0.214880, -0.150213, -0.859890, 0.044649, 0.508499, 1.464175, -0.850000},
{-0.511854, 0.253866, -0.151634, -0.870022, 0.077670, 0.486770, 1.468433, -0.942680},
{-0.510712, 0.274866, -0.153494, -0.887997, 0.050600, 0.457015, 1.475048, -1.001417},
{-0.513928, 0.307480, -0.186073, -0.999603, -0.014832, 0.023804, 1.604249, -1.106853},
{-0.510549, 0.296000, -0.153356, -0.892361, -0.000153, 0.451277, 1.473396, -1.061033},
{-0.517592, 0.174250, -0.255758, -0.975585, 0.012818, -0.219123, 1.829484, -0.799789},
{-0.518712, 0.089244, -0.254356, -0.967864, 0.011933, -0.251106, 1.828761, -0.627267},
{-0.523278, 0.076426, -0.222386, -0.996033, 0.023530, -0.085696, 1.728004, -0.588440},
{-0.521370, 0.162845, -0.222468, -0.997681, 0.026582, -0.062288, 1.724680, -0.764971},
{-0.509345, 0.182761, -0.279052, -0.778802, -0.009186, -0.627155, 1.925854, -0.833249},
{-0.509754, 0.099128, -0.276860, -0.761101, -0.002808, -0.648579, 1.921566, -0.665752},
{-0.520019, 0.010675, -0.253893, -0.961943, 0.015839, -0.272774, 1.830516, -0.473287},
{-0.525448, -0.003141, -0.222001, -0.994415, 0.023469, -0.102725, 1.729856, -0.431570},
{-0.510176, 0.022091, -0.276785, -0.753136, 0.009095, -0.657796, 1.925026, -0.517841},
{-0.527676, -0.014938, -0.185985, -0.997803, 0.025788, 0.060549, 1.616892, -0.395523},
{-0.525156, 0.063443, -0.185141, -0.997345, 0.028993, 0.066530, 1.611341, -0.548930},
{-0.522858, -0.024516, -0.156360, -0.862453, 0.012879, 0.505936, 1.497777, -0.362311},
{-0.520259, 0.052134, -0.154285, -0.861690, 0.016053, 0.507126, 1.486724, -0.509078},
{-0.522437, 0.150574, -0.183579, -0.996399, 0.032685, 0.078097, 1.603006, -0.727441},
{-0.517031, 0.139784, -0.151666, -0.858730, 0.020569, 0.511979, 1.472898, -0.688553},
{0.124170, 0.009155, -0.251529, 0.873135, 0.017121, -0.487136, 2.255388, -0.295291},
{0.122539, 0.088960, -0.251667, 0.871609, 0.011475, -0.490066, 2.257639, -0.137829},
{0.132268, 0.079445, -0.224791, 0.991699, 0.014863, -0.127628, 2.180267, -0.163769},
{0.133706, -0.001367, -0.224929, 0.991913, 0.016938, -0.125584, 2.178696, -0.324136},
{0.110209, 0.018664, -0.268368, 0.665944, 0.015015, -0.745842, 2.314013, -0.261608},
{0.108305, 0.097304, -0.268751, 0.662587, 0.003632, -0.748955, 2.317081, -0.108528},
{0.121289, 0.174687, -0.252607, 0.875973, 0.003571, -0.482315, 2.262916, 0.036610},
{0.131093, 0.166999, -0.224948, 0.991150, 0.008881, -0.132298, 2.183268, 0.015959},
{0.107133, 0.181184, -0.270506, 0.669576, -0.008850, -0.742637, 2.325867, 0.059091},
{0.106459, 0.251556, -0.272516, 0.681143, -0.012818, -0.731986, 2.335516, 0.205822},
{0.120473, 0.246918, -0.253701, 0.882260, -0.000275, -0.470717, 2.268563, 0.190222},
{0.130349, 0.241135, -0.225207, 0.990356, 0.003723, -0.138340, 2.186480, 0.175086},
{0.128490, 0.160470, -0.188994, 0.981780, 0.005554, 0.189856, 2.070223, -0.001029},
{0.129199, 0.072143, -0.188884, 0.979705, 0.013550, 0.199835, 2.067035, -0.182984},
{0.128383, 0.235574, -0.189332, 0.984313, 0.000092, 0.176305, 2.074134, 0.160880},
{0.118680, 0.230656, -0.157431, 0.882870, 0.001282, 0.469588, 1.946657, 0.147139},
{0.118124, 0.154953, -0.156612, 0.881649, 0.003143, 0.471816, 1.940480, -0.016186},
{0.118347, 0.066229, -0.156193, 0.880062, 0.011841, 0.474654, 1.935872, -0.198838},
{0.130770, -0.008652, -0.189126, 0.979827, 0.016755, 0.199133, 2.065869, -0.343307},
{0.120116, -0.014218, -0.156376, 0.881405, 0.015687, 0.472060, 1.934975, -0.357640},
{0.120143, 0.286234, -0.254300, 0.885250, 0.011322, -0.464919, 2.271926, 0.285203},
{0.119989, 0.307010, -0.253557, 0.881863, 0.067263, -0.466659, 2.270616, 0.344936},
{0.130030, 0.303626, -0.225143, 0.989349, 0.037568, -0.140477, 2.189009, 0.336690},
{0.130204, 0.281691, -0.225373, 0.989715, 0.006256, -0.142857, 2.188687, 0.273652},
{0.106049, 0.289671, -0.273665, 0.688681, 0.015778, -0.724845, 2.341174, 0.296235},
{0.105901, 0.309290, -0.272535, 0.684652, 0.128269, -0.717460, 2.338106, 0.351490},
{0.119705, 0.323619, -0.250626, 0.868465, 0.128544, -0.478774, 2.262247, 0.392804},
{0.129200, 0.321896, -0.224213, 0.988433, 0.073702, -0.132420, 2.186565, 0.389230},
{0.106016, 0.324173, -0.267705, 0.656911, 0.245460, -0.712851, 2.321580, 0.392746},
{0.127042, 0.317530, -0.189641, 0.977905, 0.077883, 0.193854, 2.078184, 0.378391},
{0.128430, 0.298973, -0.189990, 0.983306, 0.039338, 0.177496, 2.079170, 0.325059},
{0.117291, 0.312588, -0.158855, 0.861751, 0.078463, 0.501175, 1.953454, 0.363919},
{0.119045, 0.294288, -0.159108, 0.871914, 0.049867, 0.487106, 1.955214, 0.311737},
{0.128620, 0.276698, -0.189775, 0.985443, 0.004364, 0.169866, 2.077468, 0.261066},
{0.119248, 0.272039, -0.158448, 0.880306, 0.013184, 0.474166, 1.952258, 0.247962},
{-0.494566, 0.291714, -0.138650, -0.446547, 0.006623, 0.894711, -1.132063, 0.535815},
{-0.496034, 0.268815, -0.139042, -0.449049, 0.029054, 0.893002, -1.059721, 0.534163},
{-0.469287, 0.266507, -0.133569, -0.162450, 0.002533, 0.986694, -1.056063, 0.611176},
{-0.466811, 0.290705, -0.133223, -0.151891, 0.021882, 0.988128, -1.132617, 0.615577},
{-0.510549, 0.296000, -0.153356, -0.892361, -0.000153, 0.451277, -1.131157, 0.471802},
{-0.510712, 0.274866, -0.153494, -0.887997, 0.050600, 0.457015, -1.065815, 0.475221},
{-0.497133, 0.247726, -0.138349, -0.420667, 0.037080, 0.906430, -0.993191, 0.533358},
{-0.470612, 0.244650, -0.134105, -0.149052, -0.004547, 0.988800, -0.987014, 0.609819},
{-0.511854, 0.253866, -0.151634, -0.870022, 0.077670, 0.486770, -1.001666, 0.475772},
{-0.513965, 0.214880, -0.150213, -0.859890, 0.044649, 0.508499, -0.900122, 0.474149},
{-0.498654, 0.208907, -0.137971, -0.395367, 0.012604, 0.918424, -0.890428, 0.532627},
{-0.471796, 0.204948, -0.134771, -0.137059, -0.005982, 0.990539, -0.881445, 0.610166},
{-0.430905, 0.242494, -0.128522, -0.127995, -0.017212, 0.991607, -0.985430, 0.724029},
{-0.429913, 0.265250, -0.127885, -0.123447, 0.004852, 0.992309, -1.057279, 0.724329},
{-0.431659, 0.200880, -0.129301, -0.129337, -0.006958, 0.991546, -0.873888, 0.725825},
{-0.387510, 0.197875, -0.124146, -0.088900, -0.007874, 0.996002, -0.870151, 0.852889},
{-0.387137, 0.241124, -0.123407, -0.094150, -0.021332, 0.995300, -0.986798, 0.849817},
{-0.386653, 0.264453, -0.122957, -0.093661, 0.016388, 0.995453, -1.060375, 0.848595},
{-0.428114, 0.289055, -0.128341, -0.102481, 0.064241, 0.992645, -1.132463, 0.726837},
{-0.386056, 0.287245, -0.124304, -0.077303, 0.109806, 0.990936, -1.132167, 0.847774},
{-0.501389, 0.132819, -0.139306, -0.396710, -0.002991, 0.917936, -0.709383, 0.531195},
{-0.504500, 0.044335, -0.141485, -0.412732, -0.007599, 0.910794, -0.508880, 0.529379},
{-0.476275, 0.037271, -0.136539, -0.170812, -0.011017, 0.985229, -0.490389, 0.611173},
{-0.473847, 0.127214, -0.135505, -0.147618, -0.006470, 0.989013, -0.695337, 0.610874},
{-0.517031, 0.139784, -0.151666, -0.858730, 0.020569, 0.511979, -0.722595, 0.471041},
{-0.520259, 0.052134, -0.154285, -0.861690, 0.016053, 0.507126, -0.525091, 0.467888},
{-0.507149, -0.031673, -0.143641, -0.422987, -0.009247, 0.906064, -0.347740, 0.527495},
{-0.478587, -0.039062, -0.138108, -0.187506, -0.015046, 0.982116, -0.328301, 0.610287},
{-0.522858, -0.024516, -0.156360, -0.862453, 0.012879, 0.505936, -0.363617, 0.466124},
{-0.435209, -0.049338, -0.130038, -0.163976, -0.010651, 0.986389, -0.301739, 0.735920},
{-0.433981, 0.028166, -0.129243, -0.152135, -0.003357, 0.988342, -0.467337, 0.733570},
{-0.388168, -0.057951, -0.123176, -0.096561, -0.007355, 0.995270, -0.280794, 0.871900},
{-0.387975, 0.020900, -0.122995, -0.090823, 0.001160, 0.995849, -0.450470, 0.866434},
{-0.432741, 0.120505, -0.129269, -0.137883, 0.001251, 0.990417, -0.679622, 0.729605},
{-0.387773, 0.115321, -0.123663, -0.087130, 0.004791, 0.996185, -0.669149, 0.859262},
{-0.494705, 0.026692, -0.285805, -0.296793, 0.005860, -0.954894, 1.341691, 2.315309},
{-0.494698, 0.103309, -0.285711, -0.294809, -0.011170, -0.955473, 1.178941, 2.314093},
{-0.469149, 0.105663, -0.287505, -0.046663, -0.009430, -0.998840, 1.172230, 2.240683},
{-0.469078, 0.028745, -0.287661, -0.052400, 0.004913, -0.998596, 1.335933, 2.241685},
{-0.510176, 0.022091, -0.276785, -0.753136, 0.009095, -0.657796, 1.344919, 2.367807},
{-0.509754, 0.099128, -0.276860, -0.761101, -0.002808, -0.648579, 1.182607, 2.366082},
{-0.494871, 0.186346, -0.287958, -0.297861, -0.024445, -0.954283, 0.996018, 2.313329},
{-0.469585, 0.188313, -0.289293, -0.032533, -0.022156, -0.999207, 0.990504, 2.240668},
{-0.509345, 0.182761, -0.279052, -0.778802, -0.009186, -0.627155, 0.999053, 2.363832},
{-0.508867, 0.253753, -0.280711, -0.808679, 0.015595, -0.588031, 0.835751, 2.361806},
{-0.495077, 0.256964, -0.289961, -0.320139, -0.002380, -0.947356, 0.832533, 2.312791},
{-0.470056, 0.258567, -0.291123, -0.023896, -0.006775, -0.999664, 0.828158, 2.240895},
{-0.428900, 0.191971, -0.289876, -0.010987, -0.012482, -0.999847, 0.980034, 2.123693},
{-0.428712, 0.110066, -0.288841, -0.026643, -0.004913, -0.999603, 1.159426, 2.124429},
{-0.429135, 0.261018, -0.290758, 0.008942, 0.003998, -0.999939, 0.821469, 2.123235},
{-0.383655, 0.263470, -0.290263, -0.005493, 0.021668, -0.999725, 0.814894, 1.992474},
{-0.383747, 0.195866, -0.290456, -0.021943, -0.001801, -0.999756, 0.968931, 1.993873},
{-0.383897, 0.114825, -0.290158, -0.033845, -0.000580, -0.999420, 1.145614, 1.995586},
{-0.428767, 0.032518, -0.289062, -0.031434, 0.003998, -0.999481, 1.325112, 2.125809},
{-0.384079, 0.036792, -0.290429, -0.036653, 0.002808, -0.999298, 1.312827, 1.997344},
{-0.495167, 0.296328, -0.289132, -0.363689, 0.076846, -0.928312, 0.728099, 2.312255},
{-0.495223, 0.317216, -0.285922, -0.400159, 0.203162, -0.893613, 0.662143, 2.311824},
{-0.470291, 0.319809, -0.288861, -0.065065, 0.190863, -0.979430, 0.654697, 2.240223},
{-0.470228, 0.298296, -0.291091, -0.034516, 0.061007, -0.997528, 0.722593, 2.240616},
{-0.508242, 0.292870, -0.279183, -0.842402, 0.074374, -0.533677, 0.734195, 2.360752},
{-0.507796, 0.313567, -0.275663, -0.859767, 0.123997, -0.495346, 0.671047, 2.360306},
{-0.495328, 0.332407, -0.280782, -0.400281, 0.294076, -0.867916, 0.614091, 2.311600},
{-0.470434, 0.335412, -0.284097, -0.099979, 0.301737, -0.948119, 0.605355, 2.240109},
{-0.507856, 0.329303, -0.271346, -0.852382, 0.138615, -0.504166, 0.622970, 2.360106},
{-0.429570, 0.338435, -0.285043, -0.024842, 0.208045, -0.977783, 0.596902, 2.122647},
{-0.429307, 0.321573, -0.288094, 0.011902, 0.137333, -0.990448, 0.650165, 2.122385},
{-0.384215, 0.340436, -0.285197, -0.014924, 0.110019, -0.993805, 0.591761, 1.992278},
{-0.383802, 0.322391, -0.286429, 0.005829, 0.091647, -0.995758, 0.648706, 1.991548},
{-0.429216, 0.299993, -0.290082, 0.022065, 0.058290, -0.998047, 0.718267, 2.122690},
{-0.383644, 0.301190, -0.288519, 0.007965, 0.070223, -0.997497, 0.715618, 1.991656},
{0.048868, 0.295778, -0.130667, 0.120701, 0.098758, 0.987732, -1.212090, 2.095834},
{0.049646, 0.276083, -0.129190, 0.137059, 0.059938, 0.988739, -1.150230, 2.100256},
{0.084074, 0.285688, -0.135952, 0.242531, 0.060610, 0.968230, -1.184312, 2.198115},
{0.082696, 0.304443, -0.136920, 0.225227, 0.061129, 0.972381, -1.243167, 2.192072},
{0.004795, 0.287495, -0.125574, 0.069277, 0.132115, 0.988800, -1.180885, 1.970150},
{0.005080, 0.266912, -0.123783, 0.081851, 0.050172, 0.995361, -1.116186, 1.973250},
{0.049682, 0.253576, -0.128155, 0.134098, 0.029267, 0.990509, -1.079392, 2.102865},
{0.084244, 0.263279, -0.134536, 0.248695, 0.041841, 0.967650, -1.113824, 2.201096},
{0.005012, 0.244450, -0.123452, 0.076052, 0.005097, 0.997070, -1.045438, 1.975561},
{0.004700, 0.201627, -0.123622, 0.061129, -0.000092, 0.998108, -0.930174, 1.978754},
{0.049285, 0.211019, -0.127326, 0.121616, 0.012818, 0.992462, -0.965019, 2.105774},
{0.083756, 0.221193, -0.133023, 0.249062, 0.019868, 0.968261, -1.000963, 2.203682},
{0.105945, 0.268500, -0.142335, 0.568407, 0.033357, 0.822047, -1.132471, 2.262905},
{0.105733, 0.290808, -0.143510, 0.553331, 0.057161, 0.830988, -1.202651, 2.259817},
{0.105346, 0.226801, -0.140860, 0.578570, 0.013306, 0.815516, -1.020811, 2.265134},
{0.118680, 0.230656, -0.157431, 0.882870, 0.001282, 0.469588, -1.032611, 2.308357},
{0.119248, 0.272039, -0.158448, 0.880306, 0.013184, 0.474166, -1.143225, 2.306504},
{0.119045, 0.294288, -0.159108, 0.871914, 0.049867, 0.487106, -1.213118, 2.303441},
{0.104006, 0.309136, -0.143798, 0.537065, 0.057497, 0.841548, -1.260157, 2.252811},
{0.117291, 0.312588, -0.158855, 0.861751, 0.078463, 0.501175, -1.270105, 2.295801},
{0.048763, 0.131178, -0.126467, 0.109989, 0.007660, 0.993896, -0.772552, 2.111096},
{0.048594, 0.038606, -0.125881, 0.102603, 0.003296, 0.994690, -0.559700, 2.118157},
{0.083196, 0.052774, -0.130945, 0.245582, 0.006653, 0.969329, -0.608280, 2.215990},
{0.083155, 0.143408, -0.131759, 0.247291, 0.010010, 0.968871, -0.814988, 2.208544},
{0.004253, 0.119958, -0.123331, 0.049440, 0.003327, 0.998749, -0.731927, 1.984501},
{0.003879, 0.025626, -0.123076, 0.043001, -0.000183, 0.999054, -0.513484, 1.991176},
{0.049255, -0.042139, -0.125868, 0.098666, -0.004242, 0.995086, -0.384171, 2.126287},
{0.084633, -0.027856, -0.130781, 0.245369, 0.000305, 0.969420, -0.433217, 2.226333},
{0.003788, -0.055186, -0.123353, 0.038667, -0.007904, 0.999207, -0.337634, 1.997155},
{0.106495, -0.019585, -0.138939, 0.589068, 0.008759, 0.808008, -0.461472, 2.288269},
{0.104730, 0.060877, -0.138964, 0.586230, 0.009857, 0.810053, -0.635972, 2.277002},
{0.120116, -0.014218, -0.156376, 0.881405, 0.015687, 0.472060, -0.479333, 2.331151},
{0.118347, 0.066229, -0.156193, 0.880062, 0.011841, 0.474654, -0.653220, 2.319604},
{0.104644, 0.150299, -0.139670, 0.583819, 0.007080, 0.811823, -0.838865, 2.269562},
{0.118124, 0.154953, -0.156612, 0.881649, 0.003143, 0.471816, -0.853461, 2.312365},
{0.049029, 0.032844, -0.282738, 0.134495, 0.000885, -0.990905, 1.336170, 0.752615},
{0.047472, 0.110070, -0.283026, 0.133885, -0.008484, -0.990936, 1.171471, 0.755895},
{0.080993, 0.104090, -0.277843, 0.148015, -0.009339, -0.988922, 1.191030, 0.659531},
{0.082895, 0.026208, -0.277533, 0.152165, 0.002747, -0.988342, 1.357805, 0.655276},
{0.003686, 0.039941, -0.288167, 0.090274, -0.002838, -0.995911, 1.312791, 0.882931},
{0.002550, 0.116578, -0.288519, 0.091678, -0.008362, -0.995727, 1.149963, 0.885016},
{0.046406, 0.191297, -0.284467, 0.127110, -0.017579, -0.991699, 0.994206, 0.757708},
{0.079814, 0.186518, -0.279529, 0.137730, -0.021699, -0.990204, 1.009983, 0.661650},
{0.001658, 0.196532, -0.289679, 0.086276, -0.012757, -0.996185, 0.976707, 0.886350},
{0.000987, 0.262483, -0.290563, 0.076205, 0.001068, -0.997070, 0.827895, 0.887220},
{0.045695, 0.258769, -0.285903, 0.115879, -0.012238, -0.993164, 0.840612, 0.758674},
{0.079100, 0.255385, -0.281415, 0.123783, -0.022919, -0.992035, 0.852004, 0.662609},
{0.096682, 0.184137, -0.277178, 0.342479, -0.020020, -0.939299, 1.017854, 0.613152},
{0.097864, 0.101091, -0.275280, 0.347209, -0.005585, -0.937742, 1.200844, 0.611033},
{0.096011, 0.253680, -0.279353, 0.338939, -0.024262, -0.940489, 0.857755, 0.613982},
{0.106459, 0.251556, -0.272516, 0.681143, -0.012818, -0.731986, 0.860686, 0.589074},
{0.107133, 0.181184, -0.270506, 0.669576, -0.008850, -0.742637, 1.021770, 0.588435},
{0.108305, 0.097304, -0.268751, 0.662587, 0.003632, -0.748955, 1.205785, 0.586469},
{0.099869, 0.022915, -0.274889, 0.353252, 0.008148, -0.935484, 1.368544, 0.606484},
{0.110209, 0.018664, -0.268368, 0.665944, 0.015015, -0.745842, 1.373835, 0.581967},
{0.045202, 0.294730, -0.286177, 0.106479, 0.028077, -0.993896, 0.746931, 0.759416},
{0.044957, 0.313298, -0.285084, 0.115421, 0.116214, -0.986480, 0.688347, 0.759653},
{0.078378, 0.311731, -0.281193, 0.130802, 0.161260, -0.978179, 0.694029, 0.663521},
{0.078591, 0.292587, -0.282322, 0.114750, 0.019959, -0.993164, 0.754431, 0.663387},
{0.000513, 0.297108, -0.290082, 0.066805, 0.040864, -0.996918, 0.738403, 0.887911},
{0.000205, 0.315037, -0.288926, 0.068728, 0.076113, -0.994720, 0.681831, 0.888341},
{0.044994, 0.328592, -0.282421, 0.148717, 0.207495, -0.966857, 0.640047, 0.759103},
{0.078548, 0.326430, -0.276971, 0.173009, 0.307016, -0.935820, 0.647563, 0.662547},
{0.000035, 0.330899, -0.287782, 0.087161, 0.111759, -0.989898, 0.631780, 0.888425},
{0.095593, 0.325034, -0.274276, 0.355876, 0.334574, -0.872555, 0.652322, 0.613508},
{0.095362, 0.310630, -0.279378, 0.347636, 0.175695, -0.920988, 0.697884, 0.614680},
{0.106016, 0.324173, -0.267705, 0.656911, 0.245460, -0.712851, 0.655703, 0.588228},
{0.105901, 0.309290, -0.272535, 0.684652, 0.128269, -0.717460, 0.700825, 0.589485},
{0.095536, 0.291345, -0.280579, 0.338450, 0.017731, -0.940794, 0.758730, 0.614664},
{0.106049, 0.289671, -0.273665, 0.688681, 0.015778, -0.724845, 0.761428, 0.589595},
{-0.257490, -0.059536, -0.122307, 0.007294, -0.008728, 0.999908, -0.291901, 1.247330},
{-0.257465, 0.021127, -0.121891, 0.003937, -0.003143, 0.999969, -0.467282, 1.241176},
{-0.307805, 0.020450, -0.121581, 0.006745, -0.000549, 0.999969, -0.458983, 1.096689},
{-0.307928, -0.059793, -0.121806, 0.011078, -0.006928, 0.999908, -0.284926, 1.102514},
{-0.203708, -0.059537, -0.122593, 0.001648, -0.010834, 0.999939, -0.298487, 1.401778},
{-0.203770, 0.021373, -0.121995, -0.000671, -0.004822, 0.999969, -0.474647, 1.395343},
{-0.257454, 0.116017, -0.121740, 0.000061, -0.004975, 0.999969, -0.687464, 1.233396},
{-0.307743, 0.115248, -0.121718, -0.000824, -0.001495, 0.999969, -0.678864, 1.089068},
{-0.203795, 0.116428, -0.121715, -0.001556, -0.006134, 0.999969, -0.695349, 1.387439},
{-0.203801, 0.198885, -0.120850, -0.000946, -0.031648, 0.999481, -0.896092, 1.380293},
{-0.257443, 0.198345, -0.120951, -0.003357, -0.030671, 0.999512, -0.887798, 1.226313},
{-0.307690, 0.197585, -0.121255, -0.010743, -0.024751, 0.999634, -0.879213, 1.082109},
{-0.348645, 0.114292, -0.121753, -0.026032, 0.002991, 0.999634, -0.670827, 0.971720},
{-0.348613, 0.019351, -0.121195, -0.019593, 0.001679, 0.999786, -0.450532, 0.979624},
{-0.348616, 0.197102, -0.121892, -0.037812, -0.015046, 0.999146, -0.872628, 0.964643},
{-0.348614, -0.060350, -0.121264, -0.017914, -0.006104, 0.999817, -0.278207, 0.985734},
{-0.257420, 0.241321, -0.118618, -0.005860, -0.057527, 0.998321, -1.003637, 1.222250},
{-0.257375, 0.263909, -0.117151, -0.007599, 0.011200, 0.999878, -1.074886, 1.219839},
{-0.307543, 0.263124, -0.117927, -0.027467, 0.012726, 0.999512, -1.066205, 1.075869},
{-0.307594, 0.240445, -0.119228, -0.020936, -0.049104, 0.998566, -0.994677, 1.078272},
{-0.203806, 0.242004, -0.118500, 0.000275, -0.058077, 0.998291, -1.012378, 1.376134},
{-0.203744, 0.264524, -0.117069, 0.001831, 0.013642, 0.999878, -1.083417, 1.373779},
{-0.257299, 0.285071, -0.118961, -0.006714, 0.160558, 0.986999, -1.141455, 1.217711},
{-0.307626, 0.284918, -0.119637, -0.026002, 0.151555, 0.988098, -1.134748, 1.073212},
{-0.203549, 0.285188, -0.118964, 0.003754, 0.165929, 0.986114, -1.148422, 1.372049},
{-0.348220, 0.285754, -0.121410, -0.053285, 0.138188, 0.988952, -1.132291, 0.956566},
{-0.348250, 0.263525, -0.119749, -0.059572, 0.017945, 0.998047, -1.062359, 0.958948},
{-0.348433, 0.240410, -0.120567, -0.051851, -0.033540, 0.998077, -0.989472, 0.961013},
{-0.048340, -0.059752, -0.122391, 0.010468, -0.011048, 0.999878, -0.316906, 1.847963},
{-0.047990, 0.021086, -0.121835, 0.014039, -0.002960, 0.999878, -0.492885, 1.842720},
{-0.101941, 0.020949, -0.121588, 0.000763, -0.004700, 0.999969, -0.485843, 1.687805},
{-0.102231, -0.059915, -0.122323, -0.000824, -0.012848, 0.999908, -0.309778, 1.693224},
{-0.047591, 0.116098, -0.121886, 0.018342, -0.000305, 0.999817, -0.713485, 1.836042},
{-0.101644, 0.116059, -0.121499, 0.003906, -0.003082, 0.999969, -0.706749, 1.680819},
{-0.047234, 0.198363, -0.121764, 0.026673, -0.012726, 0.999542, -0.913625, 1.829966},
{-0.101401, 0.198349, -0.121062, 0.009888, -0.022614, 0.999664, -0.906969, 1.674411},
{-0.152786, 0.116306, -0.121538, -0.001556, -0.005219, 0.999969, -0.701240, 1.533932},
{-0.152898, 0.021180, -0.121768, -0.003204, -0.005371, 0.999969, -0.480299, 1.541450},
{-0.152688, 0.198704, -0.120822, 0.002167, -0.028962, 0.999573, -0.901804, 1.527090},
{-0.152987, -0.059753, -0.122495, -0.002411, -0.012574, 0.999908, -0.304042, 1.547452},
{-0.047011, 0.240962, -0.120692, 0.039125, -0.020508, 0.998993, -1.028224, 1.826532},
{-0.046992, 0.263090, -0.120289, 0.046876, 0.036531, 0.998230, -1.097959, 1.824108},
{-0.101319, 0.262648, -0.118279, 0.025605, 0.024415, 0.999359, -1.090014, 1.668130},
{-0.101270, 0.240751, -0.119284, 0.018494, -0.041108, 0.998962, -1.020978, 1.670730},
{-0.047246, 0.283943, -0.122175, 0.042940, 0.151219, 0.987548, -1.163508, 1.821068},
{-0.101620, 0.283424, -0.120163, 0.026765, 0.160283, 0.986694, -1.155315, 1.664964},
{-0.152688, 0.284239, -0.119229, 0.013794, 0.165258, 0.986145, -1.151665, 1.518212},
{-0.152648, 0.263615, -0.117326, 0.011109, 0.017304, 0.999786, -1.086813, 1.520615},
{-0.152645, 0.241455, -0.118637, 0.006623, -0.053224, 0.998535, -1.016927, 1.523112},
{-0.256663, 0.338735, -0.287971, -0.012574, 0.104038, -0.994476, 0.600485, 1.625884},
{-0.256633, 0.322271, -0.288887, -0.019684, 0.092074, -0.995544, 0.652423, 1.626209},
{-0.305646, 0.321786, -0.287829, -0.025758, 0.076327, -0.996734, 0.652661, 1.767025},
{-0.306117, 0.339422, -0.287258, -0.018342, 0.081484, -0.996490, 0.597027, 1.767952},
{-0.306946, 0.352583, -0.285563, 0.004089, 0.401746, -0.915708, 0.544639, 1.769172},
{-0.256730, 0.350911, -0.285983, 0.001282, 0.429456, -0.903073, 0.552609, 1.625555},
{-0.203382, 0.349313, -0.286713, -0.012207, 0.407971, -0.912900, 0.560455, 1.472760},
{-0.203838, 0.337837, -0.288688, -0.016175, 0.108768, -0.993927, 0.604694, 1.474134},
{-0.204107, 0.322330, -0.289804, -0.014557, 0.099155, -0.994964, 0.653615, 1.475303},
{-0.256561, 0.303247, -0.291438, -0.024934, 0.102329, -0.994415, 0.712484, 1.626529},
{-0.305342, 0.302106, -0.290089, -0.031220, 0.091647, -0.995300, 0.714787, 1.766685},
{-0.204191, 0.303868, -0.292484, -0.012665, 0.106143, -0.994263, 0.711902, 1.476065},
{-0.204193, 0.269150, -0.295203, -0.010620, 0.046510, -0.998840, 0.801743, 1.476820},
{-0.256510, 0.268090, -0.294094, -0.027802, 0.046083, -0.998535, 0.803706, 1.627141},
{-0.305196, 0.266416, -0.292500, -0.036103, 0.041414, -0.998474, 0.807686, 1.767028},
{-0.345028, 0.301657, -0.288819, -0.022217, 0.081606, -0.996399, 0.715145, 1.880691},
{-0.345308, 0.322144, -0.286675, -0.020295, 0.072054, -0.997192, 0.650480, 1.880950},
{-0.344960, 0.265072, -0.291033, -0.029817, 0.034333, -0.998962, 0.810858, 1.881272},
{-0.345849, 0.340377, -0.286134, -0.022462, 0.071474, -0.997162, 0.592960, 1.882065},
{-0.346838, 0.354041, -0.284863, -0.007172, 0.325663, -0.945433, 0.539014, 1.883608},
{-0.256543, 0.203230, -0.295327, -0.028840, 0.010956, -0.999512, 0.949124, 1.628342},
{-0.256588, 0.124397, -0.295665, -0.027467, 0.001617, -0.999603, 1.118868, 1.629726},
{-0.305248, 0.121158, -0.293809, -0.041627, 0.002716, -0.999115, 1.127775, 1.769563},
{-0.305199, 0.200751, -0.293521, -0.040010, 0.009278, -0.999146, 0.955637, 1.768152},
{-0.204214, 0.204872, -0.296438, -0.007141, 0.009980, -0.999908, 0.945325, 1.477973},
{-0.204219, 0.126571, -0.296661, -0.002808, -0.000855, -0.999969, 1.113387, 1.479224},
{-0.256574, 0.047320, -0.295638, -0.022919, -0.004425, -0.999725, 1.283063, 1.630886},
{-0.305241, 0.043683, -0.294021, -0.038759, -0.001038, -0.999237, 1.293232, 1.770764},
{-0.204171, 0.049782, -0.296343, 0.001923, -0.007935, -0.999939, 1.276669, 1.480272},
{-0.345324, 0.040343, -0.292183, -0.044404, 0.001282, -0.998993, 1.302677, 1.885957},
{-0.345213, 0.118244, -0.291894, -0.044435, 0.002075, -0.998993, 1.135877, 1.884407},
{-0.345057, 0.198544, -0.291784, -0.038392, 0.005463, -0.999237, 0.961519, 1.882678},
{-0.051225, 0.332729, -0.290209, 0.028382, 0.059542, -0.997803, 0.624766, 1.035765},
{-0.050773, 0.316654, -0.290594, 0.024445, 0.057741, -0.998016, 0.675473, 1.034848},
{-0.103601, 0.318442, -0.290869, 0.003113, 0.063936, -0.997925, 0.668486, 1.186621},
{-0.104122, 0.334405, -0.290593, -0.002930, 0.056185, -0.998413, 0.618134, 1.187742},
{-0.050330, 0.299053, -0.291977, 0.028565, 0.057527, -0.997925, 0.731019, 1.034031},
{-0.103143, 0.300844, -0.292640, 0.011780, 0.077212, -0.996918, 0.724036, 1.185772},
{-0.049837, 0.265179, -0.293139, 0.037751, 0.015137, -0.999146, 0.818166, 1.033290},
{-0.102703, 0.267140, -0.294425, 0.020753, 0.028779, -0.999359, 0.810664, 1.185203},
{-0.153741, 0.302758, -0.292846, 0.001434, 0.096255, -0.995331, 0.716708, 1.331131},
{-0.153904, 0.320693, -0.290535, -0.007508, 0.085055, -0.996338, 0.660085, 1.331107},
{-0.153540, 0.268648, -0.295213, 0.008484, 0.040223, -0.999146, 0.804626, 1.331277},
{-0.153992, 0.336251, -0.289824, -0.016877, 0.084140, -0.996307, 0.611010, 1.330975},
{-0.154095, 0.348075, -0.288344, -0.020356, 0.351543, -0.935911, 0.565709, 1.330790},
{-0.049230, 0.200281, -0.292857, 0.047182, -0.006958, -0.998840, 0.963674, 1.032602},
{-0.048521, 0.121161, -0.292012, 0.052248, -0.008087, -0.998596, 1.134305, 1.031785},
{-0.101744, 0.124254, -0.294255, 0.035798, -0.006684, -0.999329, 1.123252, 1.184731},
{-0.102236, 0.202856, -0.294746, 0.029908, -0.000427, -0.999542, 0.954251, 1.184924},
{-0.047719, 0.044618, -0.291484, 0.050417, -0.007172, -0.998688, 1.296822, 1.030653},
{-0.101229, 0.047596, -0.293604, 0.036256, -0.010071, -0.999268, 1.286121, 1.184420},
{-0.152885, 0.049596, -0.295445, 0.025758, -0.010224, -0.999603, 1.278545, 1.332871},
{-0.153124, 0.126291, -0.295998, 0.022370, -0.003998, -0.999725, 1.115564, 1.332385},
{-0.153338, 0.204567, -0.296092, 0.016114, 0.005768, -0.999847, 0.947584, 1.331774},
{-1.173160, 0.361411, -0.247258, -0.680288, 0.729179, -0.073916, 0.838824, 0.480009},
{-1.175774, 0.356654, -0.249193, -0.943175, 0.316385, -0.101535, 0.847015, 0.489418},
{-1.175877, 0.354515, -0.222083, -0.944456, 0.325449, 0.045137, 0.777765, 0.491530},
{-1.172125, 0.361152, -0.222340, -0.730461, 0.679281, 0.070589, 0.772914, 0.477238},
{-1.164936, 0.365814, -0.223183, -0.379131, 0.924314, 0.043062, 0.751484, 0.465535},
{-1.166879, 0.364520, -0.245936, -0.323893, 0.942747, -0.079134, 0.834725, 0.463198},
{-1.165159, 0.362920, -0.259170, -0.271798, 0.946898, -0.171697, 0.873980, 0.458550},
{-1.169817, 0.360520, -0.264680, -0.511246, 0.796991, -0.321543, 0.890424, 0.471024},
{-1.171393, 0.356705, -0.267142, -0.770196, 0.362529, -0.524705, 0.901082, 0.476512},
{-1.176548, 0.349458, -0.249607, -0.990600, 0.051759, -0.126560, 1.722326, -1.129205},
{-1.177126, 0.346119, -0.222084, -0.997131, 0.075106, -0.005127, 1.641204, -1.118721},
{-1.175877, 0.354515, -0.222083, -0.944456, 0.325449, 0.045137, 1.669955, -1.155084},
{-1.175774, 0.356654, -0.249193, -0.943175, 0.316385, -0.101535, 1.722796, -1.151858},
{-1.171393, 0.356705, -0.267142, -0.770196, 0.362529, -0.524705, 1.792030, -1.152019},
{-1.171990, 0.350283, -0.267430, -0.813105, 0.072481, -0.577563, 1.789412, -1.131465},
{-1.171993, 0.341175, -0.268009, -0.830897, 0.088931, -0.549242, 1.791335, -1.107504},
{-1.176227, 0.339381, -0.250042, -0.991913, -0.019654, -0.125156, 1.724299, -1.102132},
{-1.176798, 0.334862, -0.222484, -0.998840, -0.030396, -0.036561, 1.643149, -1.088472},
{-1.177959, 0.336861, -0.184941, -0.986084, 0.135319, 0.096408, 1.532012, -1.091790},
{-1.175682, 0.346955, -0.186630, -0.912564, 0.374981, 0.163030, 1.536875, -1.119099},
{-1.178493, 0.324387, -0.185316, -0.999115, 0.001740, 0.041993, 1.533771, -1.058239},
{-1.174308, 0.314500, -0.152535, -0.878780, 0.023286, 0.476577, 1.410278, -1.019718},
{-1.173146, 0.327594, -0.152344, -0.834986, 0.208716, 0.509110, 1.408785, -1.056637},
{-1.170496, 0.338733, -0.156019, -0.698416, 0.506088, 0.505997, 1.420683, -1.089343},
{-1.171089, 0.356718, -0.192069, -0.709861, 0.674520, 0.202582, 1.553325, -1.145792},
{-1.172125, 0.361152, -0.222340, -0.730461, 0.679281, 0.070589, 1.649899, -1.165082},
{-1.165860, 0.351368, -0.166793, -0.483322, 0.756035, 0.441298, 1.456752, -1.126501},
{-1.160048, 0.359166, -0.179472, -0.303201, 0.886380, 0.349773, 1.504905, -1.165885},
{-1.163137, 0.364036, -0.197779, -0.377117, 0.905850, 0.192846, 1.575570, -1.172175},
{-1.164936, 0.365814, -0.223183, -0.379131, 0.924314, 0.043062, 1.646235, -1.178465},
{-0.542117, 0.355156, -0.191205, 0.645589, 0.734733, 0.208167, 1.985111, 0.479219},
{-0.540201, 0.350037, -0.187858, 0.924100, 0.300882, 0.235481, 1.976245, 0.465643},
{-0.536186, 0.352299, -0.221816, 0.980987, 0.174413, -0.084811, 2.107384, 0.476315},
{-0.537244, 0.356513, -0.222216, 0.756798, 0.652120, -0.043977, 2.096181, 0.482443},
{-0.541620, 0.358871, -0.222736, 0.261879, 0.965026, -0.008789, 2.095249, 0.491530},
{-0.547360, 0.358063, -0.194733, 0.225379, 0.966643, 0.121616, 1.998165, 0.489709},
{-0.555573, 0.356048, -0.174341, 0.162175, 0.968902, 0.186773, 1.901081, 0.487887},
{-0.553443, 0.353355, -0.163319, 0.404950, 0.851131, 0.333995, 1.874040, 0.475994},
{-0.550942, 0.347418, -0.156903, 0.739372, 0.451552, 0.499374, 1.855470, 0.460103},
{-0.539287, 0.342690, -0.187650, 0.973052, 0.079165, 0.216468, 1.975757, 0.445895},
{-0.535855, 0.345871, -0.222183, 0.992950, 0.047639, -0.108371, 2.078072, 0.452574},
{-0.549733, 0.338828, -0.156116, 0.851711, 0.088321, 0.516465, 1.853841, 0.436216},
{-0.548677, 0.327310, -0.157815, 0.860927, 0.044374, 0.506729, 1.859902, 0.404443},
{-0.538480, 0.332170, -0.188829, 0.976501, 0.064638, 0.205451, 1.979041, 0.417533},
{-0.535590, 0.336109, -0.223066, 0.990509, 0.060579, -0.123142, 2.080222, 0.426268},
{-0.543695, 0.346615, -0.245542, 0.864528, 0.050722, -0.499954, 2.141186, 0.453254},
{-0.543220, 0.353386, -0.244366, 0.857662, 0.178625, -0.482131, 2.139127, 0.476104},
{-0.544267, 0.336631, -0.247342, 0.861812, 0.102725, -0.496658, 2.145488, 0.426293},
{-0.557312, 0.336015, -0.262269, 0.639149, 0.207587, -0.740532, 2.192796, 0.421963},
{-0.555999, 0.346509, -0.259321, 0.632282, 0.122990, -0.764885, 2.184698, 0.450934},
{-0.554814, 0.353975, -0.257369, 0.603687, 0.326151, -0.727409, 2.181140, 0.478850},
{-0.543552, 0.356755, -0.242958, 0.637562, 0.683950, -0.354503, 0.827309, -1.214133},
{-0.537244, 0.356513, -0.222216, 0.756798, 0.652120, -0.043977, 0.781132, -1.246165},
{-0.536186, 0.352299, -0.221816, 0.980987, 0.174413, -0.084811, 0.781734, -1.249671},
{-0.543220, 0.353386, -0.244366, 0.857662, 0.178625, -0.482131, 0.831925, -1.216158},
{-0.554814, 0.353975, -0.257369, 0.603687, 0.326151, -0.727409, 0.870684, -1.185115},
{-0.554594, 0.356732, -0.254921, 0.386151, 0.805689, -0.449141, 0.862684, -1.184401},
{-0.554447, 0.357486, -0.250717, 0.143315, 0.974059, -0.175085, 0.850200, -1.184783},
{-0.546883, 0.358140, -0.241845, 0.211005, 0.966308, -0.147343, 0.823925, -1.205131},
{-0.541620, 0.358871, -0.222736, 0.261879, 0.965026, -0.008789, 0.757698, -1.235749},
{-1.095838, 0.370508, -0.246501, -0.034852, 0.994537, -0.098270, 0.836124, 0.272233},
{-1.133026, 0.368619, -0.248542, -0.064394, 0.992615, -0.102603, 0.842227, 0.372238},
{-1.131970, 0.369741, -0.226106, -0.052889, 0.998352, 0.021302, 0.775786, 0.369386},
{-1.095254, 0.371371, -0.225188, -0.036653, 0.998718, 0.034791, 0.773020, 0.270645},
{-1.053669, 0.372579, -0.223345, -0.019990, 0.998840, 0.043489, 0.767550, 0.158790},
{-1.053952, 0.371936, -0.243522, -0.016388, 0.995453, -0.093631, 0.827280, 0.159571},
{-1.053643, 0.369564, -0.258473, -0.009644, 0.982757, -0.184545, 0.871658, 0.158699},
{-1.095710, 0.368006, -0.262330, -0.031617, 0.981994, -0.186193, 0.883109, 0.271846},
{-1.133339, 0.365947, -0.265272, -0.067995, 0.976806, -0.202979, 0.891887, 0.373034},
{-1.155104, 0.366773, -0.247359, -0.144139, 0.984466, -0.099948, 0.838810, 0.431584},
{-1.153374, 0.368283, -0.224938, -0.132603, 0.991028, 0.015900, 0.772390, 0.426930},
{-1.156409, 0.363951, -0.264287, -0.156468, 0.967223, -0.199957, 0.889065, 0.435046},
{-1.150785, 0.366790, -0.200285, -0.111728, 0.978545, 0.173070, 0.699556, 0.419873},
{-1.129132, 0.367456, -0.200418, -0.034486, 0.982910, 0.180700, 0.699941, 0.361634},
{-1.163137, 0.364036, -0.197779, -0.377117, 0.905850, 0.192846, 0.696895, 0.459010},
{-1.160048, 0.359166, -0.179472, -0.303201, 0.886380, 0.349773, 0.631788, 0.460077},
{-1.149642, 0.360686, -0.176544, -0.104465, 0.914884, 0.389904, 0.629711, 0.416574},
{-1.127032, 0.360462, -0.175455, -0.024812, 0.911954, 0.409528, 0.626535, 0.355732},
{-1.093277, 0.368506, -0.199013, -0.035401, 0.980132, 0.195074, 0.695770, 0.265191},
{-1.091524, 0.361120, -0.173635, -0.036409, 0.905209, 0.423322, 0.621162, 0.260211},
{-1.051665, 0.361990, -0.171768, -0.029756, 0.900357, 0.434095, 0.592292, 0.124259},
{-1.052729, 0.369422, -0.197069, -0.024293, 0.979461, 0.200110, 0.690019, 0.156116},
{-1.158590, -0.341939, -0.256264, -0.229560, -0.866543, -0.443159, 1.313707, -1.183576},
{-1.134259, -0.340271, -0.259625, 0.009033, -0.895291, -0.445357, 1.322038, -1.117946},
{-1.136606, -0.345984, -0.232859, 0.018586, -0.999542, -0.023133, 1.246295, -1.125365},
{-1.161967, -0.346555, -0.229765, -0.177435, -0.984100, -0.000946, 1.238298, -1.193718},
{-1.176547, -0.340940, -0.227905, -0.689200, -0.719932, -0.081637, 1.231623, -1.242462},
{-1.172303, -0.335909, -0.253992, -0.693686, -0.576128, -0.432234, 1.305516, -1.229672},
{-1.167032, -0.323548, -0.268520, -0.615101, -0.391339, -0.684439, 1.376807, -1.215223},
{-1.156245, -0.326436, -0.275463, -0.291757, -0.485366, -0.824152, 1.385876, -1.171396},
{-1.132505, -0.324250, -0.278531, -0.042024, -0.496353, -0.867061, 1.393263, -1.108471},
{-1.095427, -0.337265, -0.263439, 0.013153, -0.872860, -0.487777, 1.330649, -1.013247},
{-1.096693, -0.344504, -0.237150, 0.014740, -0.995697, -0.091372, 1.256936, -1.017792},
{-1.094298, -0.320735, -0.281142, -0.016266, -0.467299, -0.883938, 1.397286, -1.007352},
{-1.051134, -0.317890, -0.283006, -0.019196, -0.437391, -0.899045, 1.398836, -0.892713},
{-1.051779, -0.335012, -0.266611, -0.012421, -0.847255, -0.530992, 1.337557, -0.895639},
{-1.052230, -0.343582, -0.241083, -0.010620, -0.989776, -0.142186, 1.266628, -0.898009},
{-1.097028, -0.342245, -0.207458, -0.013215, -0.979400, 0.201453, 1.169073, -1.019632},
{-1.137538, -0.340999, -0.204622, -0.016053, -0.958312, 0.285195, 1.161516, -1.128671},
{-1.052310, -0.343270, -0.210293, -0.010712, -0.989135, 0.146397, 1.176400, -0.899265},
{-1.052347, -0.336147, -0.181416, -0.017945, -0.919492, 0.392651, 1.088780, -0.900115},
{-1.097319, -0.333424, -0.180418, -0.049959, -0.895993, 0.441206, 1.086093, -1.021044},
{-1.138421, -0.329822, -0.179751, -0.061495, -0.862484, 0.502304, 1.083869, -1.131525},
{-1.163962, -0.339810, -0.202768, -0.149480, -0.932279, 0.329356, 1.156408, -1.199785},
{-1.165904, -0.327210, -0.179467, -0.165838, -0.832698, 0.528275, 1.082765, -1.205387},
{-1.177737, -0.325714, -0.183099, -0.434431, -0.772637, 0.462844, 1.082222, -1.260941},
{-1.179600, -0.334481, -0.200687, -0.585376, -0.771722, 0.248421, 1.152524, -1.251935},
{-1.091613, 0.348420, -0.154712, -0.026368, 0.759209, 0.650288, 0.565984, 0.260045},
{-1.128188, 0.347458, -0.155193, -0.023041, 0.775353, 0.631092, 0.567414, 0.358425},
{-1.129866, 0.333529, -0.141221, -0.032441, 0.611530, 0.790551, 0.515434, 0.365417},
{-1.092022, 0.334442, -0.141732, -0.008637, 0.616718, 0.787103, 0.520522, 0.262286},
{-1.050525, 0.335699, -0.142752, -0.010681, 0.602374, 0.798120, 0.530932, 0.142264},
{-1.051013, 0.349805, -0.154516, -0.024049, 0.738121, 0.674215, 0.566260, 0.144858},
{-1.152248, 0.348361, -0.156860, -0.146336, 0.786279, 0.600238, 0.572255, 0.423191},
{-1.155623, 0.334609, -0.143433, -0.252541, 0.588122, 0.768303, 0.520993, 0.434766},
{-1.165860, 0.351368, -0.166793, -0.483322, 0.756035, 0.441298, 0.578801, 0.471149},
{-1.170496, 0.338733, -0.156019, -0.698416, 0.506088, 0.505997, 0.531875, 0.487224},
{-1.156786, 0.324222, -0.138460, -0.368389, 0.263375, 0.891568, -1.139105, 0.553345},
{-1.129331, 0.323761, -0.135127, -0.069247, 0.334300, 0.939879, -1.140446, 0.627143},
{-1.129866, 0.333529, -0.141221, -0.032441, 0.611530, 0.790551, -1.162909, 0.622141},
{-1.155623, 0.334609, -0.143433, -0.252541, 0.588122, 0.768303, -1.164804, 0.552793},
{-1.170496, 0.338733, -0.156019, -0.698416, 0.506088, 0.505997, -1.171744, 0.500291},
{-1.173146, 0.327594, -0.152344, -0.834986, 0.208716, 0.509110, -1.138072, 0.493890},
{-1.174308, 0.314500, -0.152535, -0.878780, 0.023286, 0.476577, -1.097340, 0.490117},
{-1.157242, 0.311743, -0.138135, -0.419935, 0.033204, 0.906919, -1.102182, 0.553148},
{-1.128862, 0.311653, -0.133573, -0.116398, 0.088717, 0.989227, -1.104772, 0.629371},
{-1.091232, 0.323224, -0.134181, -0.017670, 0.414563, 0.909818, -1.142405, 0.729625},
{-1.092022, 0.334442, -0.141732, -0.008637, 0.616718, 0.787103, -1.171103, 0.725182},
{-1.090739, 0.309762, -0.130302, -0.060091, 0.184149, 0.981048, -1.102859, 0.731976},
{-1.049650, 0.307322, -0.127831, -0.044099, 0.261849, 0.964080, -1.099552, 0.842624},
{-1.049950, 0.322506, -0.133919, -0.014466, 0.459670, 0.887936, -1.144084, 0.840698},
{-1.050525, 0.335699, -0.142752, -0.010681, 0.602374, 0.798120, -1.191260, 0.814337},
{-1.094612, 0.358534, -0.280093, -0.052065, 0.378399, -0.924161, 0.533491, 2.049922},
{-1.134622, 0.354714, -0.278198, -0.092715, 0.201025, -0.975158, 0.544867, 2.157497},
{-1.134492, 0.360258, -0.277176, -0.084597, 0.514786, -0.853114, 0.525182, 2.157732},
{-1.095229, 0.363188, -0.277399, -0.038820, 0.716819, -0.696158, 0.516895, 2.051953},
{-1.051606, 0.365047, -0.276246, 0.005127, 0.856014, -0.516892, 0.507606, 1.925997},
{-1.050198, 0.361292, -0.280941, -0.013337, 0.581561, -0.813379, 0.520445, 1.921593},
{-1.048928, 0.353884, -0.283731, -0.027863, 0.254128, -0.966735, 0.530881, 1.894912},
{-1.093951, 0.350711, -0.282014, -0.053743, 0.241432, -0.968902, 0.556692, 2.048180},
{-1.134519, 0.346562, -0.279606, -0.109775, 0.252663, -0.961272, 0.569029, 2.157237},
{-1.159215, 0.352000, -0.275469, -0.341502, 0.108890, -0.933531, 0.552898, 2.223568},
{-1.158756, 0.358002, -0.275114, -0.327799, 0.399884, -0.855922, 0.531466, 2.223154},
{-1.159311, 0.343476, -0.276401, -0.372662, 0.213630, -0.903012, 0.578145, 2.223831},
{-1.171993, 0.341175, -0.268009, -0.830897, 0.088931, -0.549242, 0.585651, 2.269193},
{-1.171990, 0.350283, -0.267430, -0.813105, 0.072481, -0.577563, 0.559257, 2.268887},
{-1.171393, 0.356705, -0.267142, -0.770196, 0.362529, -0.524705, 0.536747, 2.268398},
{-1.157724, 0.361507, -0.272463, -0.238838, 0.837367, -0.491623, 0.913403, 0.438528},
{-1.133946, 0.363581, -0.273842, -0.076357, 0.881680, -0.465560, 0.917387, 0.374615},
{-1.134492, 0.360258, -0.277176, -0.084597, 0.514786, -0.853114, 0.930808, 0.376589},
{-1.158756, 0.358002, -0.275114, -0.327799, 0.399884, -0.855922, 0.924782, 0.442019},
{-1.095551, 0.365955, -0.272054, -0.031617, 0.935087, -0.352947, 0.912004, 0.271378},
{-1.095229, 0.363188, -0.277399, -0.038820, 0.716819, -0.696158, 0.931854, 0.270869},
{-1.052808, 0.367536, -0.269069, 0.001953, 0.955992, -0.293374, 0.903134, 0.156414},
{-1.051606, 0.365047, -0.276246, 0.005127, 0.856014, -0.516892, 0.933272, 0.175317},
{-0.615256, 0.358543, -0.195244, -0.000366, 0.992920, 0.118564, 0.685941, -1.021249},
{-0.579366, 0.358526, -0.195106, -0.009766, 0.996002, 0.088778, 0.685586, -1.117814},
{-0.573544, 0.359956, -0.222516, 0.008240, 0.999908, 0.008972, 0.766591, -1.133384},
{-0.611980, 0.360413, -0.222411, 0.010254, 0.999817, 0.015259, 0.766194, -1.029955},
{-0.662178, 0.361164, -0.221961, 0.015412, 0.999786, 0.013367, 0.764745, -0.894874},
{-0.662718, 0.359037, -0.195308, 0.012757, 0.989624, 0.142918, 0.686031, -0.893536},
{-0.663160, 0.353418, -0.169806, -0.005676, 0.939360, 0.342875, 0.610940, -0.892557},
{-0.618836, 0.353969, -0.168887, -0.034333, 0.959593, 0.279214, 0.608253, -1.011800},
{-0.585974, 0.355122, -0.168160, -0.043458, 0.975890, 0.213782, 0.606077, -1.100185},
{-0.558255, 0.358776, -0.195485, 0.027039, 0.996490, 0.079165, 0.686721, -1.174606},
{-0.551905, 0.359731, -0.222730, 0.044160, 0.998993, -0.001312, 0.767269, -1.191610},
{-0.565953, 0.356118, -0.168874, 0.021973, 0.982879, 0.182836, 0.608154, -1.154024},
{-0.555573, 0.356048, -0.174341, 0.162175, 0.968902, 0.186773, 0.612358, -1.190589},
{-0.547360, 0.358063, -0.194733, 0.225379, 0.966643, 0.121616, 0.688600, -1.211512},
{-0.555406, 0.358957, -0.241556, 0.055605, 0.994446, -0.088992, 0.823006, -1.182176},
{-0.575309, 0.359411, -0.241866, 0.016144, 0.997436, -0.069582, 0.823864, -1.128612},
{-0.561749, 0.357723, -0.253374, 0.065767, 0.990966, -0.116642, 0.858034, -1.165123},
{-0.579558, 0.358253, -0.254534, 0.019898, 0.996368, -0.082766, 0.861406, -1.117190},
{-0.612781, 0.359707, -0.242548, 0.008789, 0.997375, -0.071780, 0.825810, -1.027784},
{-0.615007, 0.358227, -0.256913, 0.004608, 0.997040, -0.076662, 0.868396, -1.021810},
{-0.663136, 0.358210, -0.258291, 0.005585, 0.996460, -0.083773, 0.872403, -0.892314},
{-0.662525, 0.360132, -0.242507, 0.010193, 0.996246, -0.085818, 0.825590, -0.893933},
{-0.612150, -0.335277, -0.267493, -0.023713, -0.836726, -0.547075, 1.326298, 0.287115},
{-0.575213, -0.337987, -0.266147, -0.018830, -0.860927, -0.508347, 1.322372, 0.386351},
{-0.569970, -0.344168, -0.241464, 0.020631, -0.998810, -0.043672, 1.252689, 0.399409},
{-0.608885, -0.343492, -0.243125, 0.003418, -0.990539, -0.137089, 1.258487, 0.294796},
{-0.659335, -0.343040, -0.244892, 0.014344, -0.977050, -0.212439, 1.265063, 0.159146},
{-0.660614, -0.333040, -0.268916, 0.002899, -0.812159, -0.583392, 1.331020, 0.156856},
{-0.661641, -0.315155, -0.284135, 0.014405, -0.416761, -0.908872, 1.385692, 0.152840},
{-0.615391, -0.318072, -0.282852, 0.008667, -0.409406, -0.912290, 1.383985, 0.275139},
{-0.580764, -0.321443, -0.281630, 0.013855, -0.399762, -0.916501, 1.383012, 0.366312},
{-0.556050, -0.338651, -0.265567, 0.310739, -0.775994, -0.548875, 1.320360, 0.437863},
{-0.549909, -0.343613, -0.240854, 0.340129, -0.939848, -0.030671, 1.250024, 0.453375},
{-0.562822, -0.322757, -0.280985, 0.292642, -0.321848, -0.900418, 1.382022, 0.413820},
{-0.555164, -0.319452, -0.275650, 0.603839, -0.186865, -0.774865, 1.381024, 0.439496},
{-0.547611, -0.331480, -0.264984, 0.731162, -0.396802, -0.554857, 1.319304, 0.465513},
{-0.540674, -0.336578, -0.241090, 0.806909, -0.579516, -0.114078, 1.248925, 0.482018},
{-0.550212, -0.336073, -0.212015, 0.348430, -0.873806, 0.339152, 1.162341, 0.451825},
{-0.570002, -0.338784, -0.212275, 0.102939, -0.953215, 0.284219, 1.164919, 0.398503},
{-0.540907, -0.329570, -0.212121, 0.743065, -0.615345, 0.263039, 1.161230, 0.479499},
{-0.543803, -0.320537, -0.193683, 0.657765, -0.611591, 0.439589, 1.064876, 0.467468},
{-0.551839, -0.322539, -0.187365, 0.385937, -0.749748, 0.537492, 1.065986, 0.441743},
{-0.571625, -0.327072, -0.186429, 0.180792, -0.832820, 0.523179, 1.068106, 0.390615},
{-0.608857, -0.342370, -0.213199, 0.069796, -0.983398, 0.167302, 1.170429, 0.293886},
{-0.609870, -0.334370, -0.185608, 0.132694, -0.888974, 0.438246, 1.072246, 0.288681},
{-0.659655, -0.340402, -0.185177, 0.060274, -0.927122, 0.369793, 1.063001, 0.193718},
{-0.659349, -0.345390, -0.214287, 0.037294, -0.996368, 0.076449, 1.176537, 0.157984},
{-0.566495, 0.351782, -0.151951, 0.104678, 0.901669, 0.419477, 0.558363, -1.152722},
{-0.586567, 0.349748, -0.150203, -0.066988, 0.879360, 0.471389, 0.553291, -1.098782},
{-0.584638, 0.342226, -0.140221, -0.009461, 0.568651, 0.822504, 0.513866, -1.105491},
{-0.564088, 0.345258, -0.143363, 0.328898, 0.551927, 0.766259, 0.522959, -1.161061},
{-0.550942, 0.347418, -0.156903, 0.739372, 0.451552, 0.499374, 0.538312, -1.199866},
{-0.553443, 0.353355, -0.163319, 0.404950, 0.851131, 0.333995, 0.567491, -1.190115},
{-0.618949, 0.346564, -0.151178, -0.077670, 0.839839, 0.537217, 0.556332, -1.011747},
{-0.617593, 0.336990, -0.140461, -0.073550, 0.591235, 0.803095, 0.517294, -1.016390},
{-0.662523, 0.343970, -0.152711, -0.032075, 0.797754, 0.602100, 0.560965, -0.894578},
{-0.661422, 0.332265, -0.141577, -0.037660, 0.605426, 0.794977, 0.523547, -0.898099},
{-0.616769, 0.325906, -0.135080, -0.000092, 0.304422, 0.952513, -1.193810, 2.005414},
{-0.583683, 0.332379, -0.137202, 0.110141, 0.169378, 0.979369, -1.215869, 2.093906},
{-0.584638, 0.342226, -0.140221, -0.009461, 0.568651, 0.822504, -1.248404, 2.091722},
{-0.617593, 0.336990, -0.140461, -0.073550, 0.591235, 0.803095, -1.228614, 2.002993},
{-0.661422, 0.332265, -0.141577, -0.037660, 0.605426, 0.794977, -1.209275, 1.885084},
{-0.660471, 0.319873, -0.133957, -0.006958, 0.410779, 0.911679, -1.172025, 1.888359},
{-0.659699, 0.305411, -0.128931, 0.037690, 0.243385, 0.969176, -1.129612, 1.891518},
{-0.616063, 0.312455, -0.132620, 0.077914, 0.148534, 0.985809, -1.154237, 2.008371},
{-0.582836, 0.319891, -0.137364, 0.190252, 0.040712, 0.980865, -1.179009, 2.097223},
{-0.562934, 0.336039, -0.141758, 0.483322, 0.096255, 0.870113, -1.228340, 2.149508},
{-0.564088, 0.345258, -0.143363, 0.328898, 0.551927, 0.766259, -1.259641, 2.147172},
{-0.561918, 0.324030, -0.143211, 0.523637, 0.005951, 0.851894, -1.192841, 2.153271},
{-0.548677, 0.327310, -0.157815, 0.860927, 0.044374, 0.506729, -1.201204, 2.192917},
{-0.549733, 0.338828, -0.156116, 0.851711, 0.088321, 0.516465, -1.236017, 2.188665},
{-0.550942, 0.347418, -0.156903, 0.739372, 0.451552, 0.499374, -1.266601, 2.185983},
{-0.565961, 0.347135, -0.265118, 0.363689, 0.228187, -0.903104, 0.565118, 0.627057},
{-0.583260, 0.348360, -0.268907, 0.214515, 0.306192, -0.927458, 0.561658, 0.673726},
{-0.581862, 0.355459, -0.266008, 0.161260, 0.649831, -0.742759, 0.533611, 0.668952},
{-0.564481, 0.354745, -0.262685, 0.322916, 0.503677, -0.801233, 0.535053, 0.621799},
{-0.554814, 0.353975, -0.257369, 0.603687, 0.326151, -0.727409, 0.537336, 0.598138},
{-0.555999, 0.346509, -0.259321, 0.632282, 0.122990, -0.764885, 0.567978, 0.603347},
{-0.557312, 0.336015, -0.262269, 0.639149, 0.207587, -0.740532, 0.599733, 0.607608},
{-0.567525, 0.336540, -0.268460, 0.366802, 0.302622, -0.879665, 0.596567, 0.631339},
{-0.584669, 0.338150, -0.272070, 0.210974, 0.305094, -0.928648, 0.591963, 0.677586},
{-0.617578, 0.350047, -0.276662, 0.181158, 0.388073, -0.903623, 0.556997, 0.766312},
{-0.616596, 0.355880, -0.273032, 0.114841, 0.783502, -0.610645, 0.533853, 0.763090},
{-0.618507, 0.340784, -0.279257, 0.181219, 0.248726, -0.951445, 0.584482, 0.768864},
{-0.663904, 0.343530, -0.286262, 0.105777, 0.211798, -0.971557, 0.576703, 0.891240},
{-0.663731, 0.351767, -0.283978, 0.099551, 0.511155, -0.853664, 0.552266, 0.890727},
{-0.663513, 0.356260, -0.279315, 0.052187, 0.887051, -0.458693, 0.534320, 0.889948},
{-0.616009, 0.357779, -0.266762, 0.025788, 0.983856, -0.176977, 0.897557, -1.019108},
{-0.581185, 0.357846, -0.261899, 0.060640, 0.958220, -0.279427, 0.883218, -1.112810},
{-0.581862, 0.355459, -0.266008, 0.161260, 0.649831, -0.742759, 0.897166, -1.111950},
{-0.616596, 0.355880, -0.273032, 0.114841, 0.783502, -0.610645, 0.920007, -1.018042},
{-0.663513, 0.356260, -0.279315, 0.052187, 0.887051, -0.458693, 0.940531, -0.891392},
{-0.663390, 0.357664, -0.270656, 0.011170, 0.993683, -0.111637, 0.909016, -0.891621},
{-0.563926, 0.357297, -0.259593, 0.175176, 0.906949, -0.383038, 0.876457, -1.159267},
{-0.564481, 0.354745, -0.262685, 0.322916, 0.503677, -0.801233, 0.886578, -1.159010},
{-1.180378, -0.258627, -0.253130, -0.990753, 0.032929, -0.131596, 1.763156, 0.237473},
{-1.181354, -0.287964, -0.253523, -0.967040, -0.018983, -0.253792, 1.765908, 0.316397},
{-1.185595, -0.299222, -0.226943, -0.992706, 0.027406, -0.117161, 1.687255, 0.348239},
{-1.181914, -0.270929, -0.225728, -0.992950, 0.105228, -0.054323, 1.682737, 0.272090},
{-1.178798, -0.240365, -0.223865, -0.999084, 0.008423, -0.041780, 1.676039, 0.189881},
{-1.179256, -0.228196, -0.252495, -0.996551, -0.005280, -0.082675, 1.759654, 0.155615},
{-1.177613, -0.215962, -0.271622, -0.864620, -0.021851, -0.501907, 1.831296, 0.111785},
{-1.176429, -0.245716, -0.271145, -0.822779, -0.035951, -0.567186, 1.830840, 0.191363},
{-1.173990, -0.275282, -0.271439, -0.760186, -0.044527, -0.648122, 1.833835, 0.271079},
{-1.179277, -0.315821, -0.253444, -0.915860, -0.193518, -0.351756, 1.767845, 0.391278},
{-1.184114, -0.323860, -0.227317, -0.960784, -0.234718, -0.147557, 1.690198, 0.414454},
{-1.171075, -0.305206, -0.272283, -0.708457, -0.154942, -0.688498, 1.839357, 0.353288},
{-1.167032, -0.323548, -0.268520, -0.615101, -0.391339, -0.684439, 1.846143, 0.436743},
{-1.172303, -0.335909, -0.253992, -0.693686, -0.576128, -0.432234, 1.769375, 0.464137},
{-1.176547, -0.340940, -0.227905, -0.689200, -0.719932, -0.081637, 1.692355, 0.475702},
{-1.187751, -0.320818, -0.197172, -0.941160, -0.329051, 0.076998, 1.600282, 0.408004},
{-1.189330, -0.300323, -0.193265, -0.999695, 0.024201, 0.001892, 1.587149, 0.353130},
{-1.179600, -0.334481, -0.200687, -0.585376, -0.771722, 0.248421, 1.614831, 0.455610},
{-1.177737, -0.325714, -0.183099, -0.434431, -0.772637, 0.462844, 1.537056, 0.419689},
{-1.184612, -0.314888, -0.172817, -0.681845, -0.539994, 0.493393, 1.504232, 0.386740},
{-1.186458, -0.297765, -0.164958, -0.850124, -0.159642, 0.501755, 1.476316, 0.344544},
{-1.185251, -0.274499, -0.190009, -0.991180, 0.132298, -0.003449, 1.576845, 0.283718},
{-1.183167, -0.274382, -0.159747, -0.876553, 0.034333, 0.480026, 1.458218, 0.283853},
{-1.179571, -0.246743, -0.156964, -0.887661, 0.002686, 0.460433, 1.448949, 0.210590},
{-1.181378, -0.245234, -0.187496, -0.999603, 0.027436, 0.001770, 1.568480, 0.205018},
{-0.542844, -0.310685, -0.263624, 0.826106, -0.101321, -0.554277, 2.161800, -1.046957},
{-0.540444, -0.282447, -0.261527, 0.808222, 0.001373, -0.588824, 2.160068, -0.972577},
{-0.530619, -0.291437, -0.241953, 0.969115, -0.062349, -0.238502, 2.136160, -0.977471},
{-0.534233, -0.317815, -0.241968, 0.953795, -0.223975, -0.200201, 2.103704, -1.064905},
{-0.540674, -0.336578, -0.241090, 0.806909, -0.579516, -0.114078, 2.095820, -1.131114},
{-0.547611, -0.331480, -0.264984, 0.731162, -0.396802, -0.554857, 2.163532, -1.121336},
{-0.555164, -0.319452, -0.275650, 0.603839, -0.186865, -0.774865, 2.223579, -1.094257},
{-0.554513, -0.301238, -0.277026, 0.612384, 0.007324, -0.790490, 2.206244, -1.014905},
{-0.553144, -0.272633, -0.272355, 0.572863, 0.074404, -0.816248, 2.188908, -0.935552},
{-0.539109, -0.252947, -0.258729, 0.806360, 0.032044, -0.590503, 2.044503, 0.553016},
{-0.529861, -0.261553, -0.239510, 0.976348, 0.017518, -0.215400, 2.074389, 0.515768},
{-0.530619, -0.291437, -0.241953, 0.969115, -0.062349, -0.238502, 2.174911, 0.514323},
{-0.540444, -0.282447, -0.261527, 0.808222, 0.001373, -0.588824, 2.133747, 0.555184},
{-0.553144, -0.272633, -0.272355, 0.572863, 0.074404, -0.816248, 2.124640, 0.586171},
{-0.551468, -0.244954, -0.269016, 0.554674, 0.048738, -0.830622, 2.021189, 0.586621},
{-0.550243, -0.216986, -0.267256, 0.582080, 0.018128, -0.812922, 1.918533, 0.576736},
{-0.538411, -0.223224, -0.255903, 0.831813, 0.029695, -0.554216, 1.955259, 0.550848},
{-0.530116, -0.231005, -0.235549, 0.984527, 0.020905, -0.173833, 1.973866, 0.517212},
{-0.529468, -0.266882, -0.208450, 0.993286, 0.014466, 0.114719, 2.012318, -0.926022},
{-0.529275, -0.293082, -0.211436, 0.990081, -0.100894, 0.097720, 2.019570, -0.996666},
{-0.529861, -0.261553, -0.239510, 0.976348, 0.017518, -0.215400, 2.122115, -0.918102},
{-0.530116, -0.231005, -0.235549, 0.984527, 0.020905, -0.173833, 2.123596, -0.845354},
{-0.531215, -0.238419, -0.203826, 0.988983, 0.009125, 0.147618, 1.999532, -0.849207},
{-0.539372, -0.244449, -0.173596, 0.891293, -0.031190, 0.452345, 1.887252, -0.866634},
{-0.536404, -0.270310, -0.178784, 0.893338, -0.028840, 0.448408, 1.902521, -0.933942},
{-0.535280, -0.292313, -0.182934, 0.879208, -0.165716, 0.446638, 1.913659, -0.989253},
{-0.533508, -0.314609, -0.212294, 0.938780, -0.312784, 0.144200, 2.018304, -1.054646},
{-0.539157, -0.309149, -0.186183, 0.794580, -0.414411, 0.443678, 1.919252, -1.030283},
{-0.543803, -0.320537, -0.193683, 0.657765, -0.611591, 0.439589, 1.922073, -1.064174},
{-0.540907, -0.329570, -0.212121, 0.743065, -0.615345, 0.263039, 2.012779, -1.106294},
{-1.168439, -0.275624, -0.148720, -0.356273, -0.127049, 0.925687, 0.340588, 0.563727},
{-1.170878, -0.298042, -0.154489, -0.317240, -0.349376, 0.881619, 0.416673, 0.553736},
{-1.141999, -0.300463, -0.152729, -0.085726, -0.403729, 0.910825, 0.420070, 0.633192},
{-1.140421, -0.278409, -0.146810, -0.088168, -0.190863, 0.977630, 0.346145, 0.639265},
{-1.139185, -0.252217, -0.143630, -0.105625, -0.103397, 0.989013, 0.268405, 0.640341},
{-1.165955, -0.248828, -0.145843, -0.383984, -0.059114, 0.921415, 0.260965, 0.568118},
{-1.179571, -0.246743, -0.156964, -0.887661, 0.002686, 0.460433, 0.255813, 0.515454},
{-1.183167, -0.274382, -0.159747, -0.876553, 0.034333, 0.480026, 0.336918, 0.506993},
{-1.186458, -0.297765, -0.164958, -0.850124, -0.159642, 0.501755, 0.414658, 0.493127},
{-1.169121, -0.314263, -0.164056, -0.238350, -0.647084, 0.724174, 1.032099, -1.214140},
{-1.140620, -0.316955, -0.163082, -0.083285, -0.678732, 0.729637, 1.029522, -1.137585},
{-1.141999, -0.300463, -0.152729, -0.085726, -0.403729, 0.910825, 0.986827, -1.145249},
{-1.170878, -0.298042, -0.154489, -0.317240, -0.349376, 0.881619, 0.992921, -1.224467},
{-1.186458, -0.297765, -0.164958, -0.850124, -0.159642, 0.501755, 0.998611, -1.284913},
{-1.184612, -0.314888, -0.172817, -0.681845, -0.539994, 0.493393, 1.034717, -1.272331},
{-1.098450, -0.320978, -0.162085, -0.069765, -0.711936, 0.698752, 1.027030, -1.024303},
{-1.099230, -0.304335, -0.150549, -0.075838, -0.439344, 0.895077, 0.979927, -1.028486},
{-1.052671, -0.324282, -0.161623, -0.030641, -0.747276, 0.663778, 1.025673, -0.901268},
{-1.052929, -0.307950, -0.148944, -0.043825, -0.484237, 0.873806, 0.974824, -0.902573},
{-1.098463, -0.282920, -0.143899, -0.083743, -0.226966, 0.970275, 0.355473, 0.752410},
{-1.099230, -0.304335, -0.150549, -0.075838, -0.439344, 0.895077, 0.426230, 0.750343},
{-1.052929, -0.307950, -0.148944, -0.043825, -0.484237, 0.873806, 0.431663, 0.876615},
{-1.052772, -0.287427, -0.141408, -0.055605, -0.270241, 0.961180, 0.364470, 0.875604},
{-1.052565, -0.263105, -0.136374, -0.069796, -0.185461, 0.980163, 0.292250, 0.874024},
{-1.097917, -0.257634, -0.139820, -0.103122, -0.146611, 0.983795, 0.280424, 0.751685},
{-1.157345, -0.300521, -0.280562, -0.311563, -0.101016, -0.944823, 2.187847, 2.216942},
{-1.160884, -0.269910, -0.279123, -0.312479, -0.008179, -0.949858, 2.097244, 2.226515},
{-1.136634, -0.267900, -0.281332, -0.067934, 0.032411, -0.997131, 2.091283, 2.161346},
{-1.133355, -0.298311, -0.283190, -0.073672, -0.061953, -0.995331, 2.181308, 2.152488},
{-1.132505, -0.324250, -0.278531, -0.042024, -0.496353, -0.867061, 2.272794, 2.146677},
{-1.156245, -0.326436, -0.275463, -0.291757, -0.485366, -0.824152, 2.279979, 2.209311},
{-1.167032, -0.323548, -0.268520, -0.615101, -0.391339, -0.684439, 2.284913, 2.252849},
{-1.171075, -0.305206, -0.272283, -0.708457, -0.154942, -0.688498, 2.192903, 2.261220},
{-1.173990, -0.275282, -0.271439, -0.760186, -0.044527, -0.648122, 2.102303, 2.269413},
{-1.165856, -0.240321, -0.278705, -0.333781, -0.037263, -0.941893, 2.009698, 2.239972},
{-1.142164, -0.238462, -0.280686, -0.057009, -0.008667, -0.998321, 2.004180, 2.176297},
{-1.176429, -0.245716, -0.271145, -0.822779, -0.035951, -0.567186, 2.014522, 2.277252},
{-1.177613, -0.215962, -0.271622, -0.864620, -0.021851, -0.501907, 1.927026, 2.281389},
{-1.168728, -0.210896, -0.279483, -0.364177, -0.042421, -0.930326, 1.922667, 2.247819},
{-1.145451, -0.209184, -0.281372, -0.051546, -0.047700, -0.997528, 1.917582, 2.185258},
{-1.098858, -0.236160, -0.281964, -0.027833, 0.000549, -0.999603, 1.997271, 2.059830},
{-1.095836, -0.265305, -0.282825, -0.034974, 0.047609, -0.998230, 2.083519, 2.051635},
{-1.100631, -0.207010, -0.282583, -0.023988, -0.046846, -0.998596, 1.911043, 2.064714},
{-1.050022, -0.204997, -0.283803, -0.032563, -0.045167, -0.998444, 1.904963, 1.928594},
{-1.050080, -0.234221, -0.283172, -0.033753, 0.001495, -0.999420, 1.991413, 1.928637},
{-1.050042, -0.263238, -0.284037, -0.032197, 0.050569, -0.998199, 2.077294, 1.928468},
{-1.094375, -0.295122, -0.285077, -0.037599, -0.041627, -0.998413, 2.171803, 2.047681},
{-1.050474, -0.292546, -0.286398, -0.027955, -0.031343, -0.999115, 2.164082, 1.929614},
{-1.051134, -0.317890, -0.283006, -0.019196, -0.437391, -0.899045, 2.251324, 1.931416},
{-1.094298, -0.320735, -0.281142, -0.016266, -0.467299, -0.883938, 2.261106, 2.045848},
{-0.610059, -0.284075, -0.149374, 0.174993, -0.292398, 0.940123, 0.314392, 2.066115},
{-0.609450, -0.305163, -0.157396, 0.169683, -0.440626, 0.881466, 0.377141, 2.069690},
{-0.570657, -0.298339, -0.163378, 0.249245, -0.374859, 0.892941, 0.353738, 2.173594},
{-0.572200, -0.277245, -0.156296, 0.273812, -0.251228, 0.928373, 0.291110, 2.167527},
{-0.574621, -0.252110, -0.149644, 0.288461, -0.211615, 0.933805, 0.216635, 2.158775},
{-0.611261, -0.259330, -0.142811, 0.171575, -0.227332, 0.958556, 0.240963, 2.060678},
{-0.658215, -0.265985, -0.138101, 0.082583, -0.225166, 0.970794, 0.264688, 1.934843},
{-0.658179, -0.290235, -0.144345, 0.087527, -0.314402, 0.945219, 0.336739, 1.937100},
{-0.658603, -0.311087, -0.152940, 0.084384, -0.487289, 0.869137, 0.422840, 1.906671},
{-0.609728, -0.321948, -0.168240, 0.161107, -0.679617, 0.715629, 0.427406, 2.070591},
{-0.571154, -0.314269, -0.171776, 0.224403, -0.611469, 0.758751, 0.401359, 2.173773},
{-0.659251, -0.328389, -0.165640, 0.075350, -0.730308, 0.678915, 0.458563, 1.944554},
{-0.659655, -0.340402, -0.185177, 0.060274, -0.927122, 0.369793, 0.507606, 1.944119},
{-0.609870, -0.334370, -0.185608, 0.132694, -0.888974, 0.438246, 0.471428, 2.070156},
{-0.571625, -0.327072, -0.186429, 0.180792, -0.832820, 0.523179, 0.441477, 2.171010},
{-0.549668, -0.309519, -0.175217, 0.467513, -0.531785, 0.706137, 0.385534, 2.231243},
{-0.547504, -0.294060, -0.169402, 0.533586, -0.281137, 0.797632, 0.339299, 2.235645},
{-0.551839, -0.322539, -0.187365, 0.385937, -0.749748, 0.537492, 0.423977, 2.221497},
{-0.543803, -0.320537, -0.193683, 0.657765, -0.611591, 0.439589, 0.412704, 2.246801},
{-0.539157, -0.309149, -0.186183, 0.794580, -0.414411, 0.443678, 0.374820, 2.265857},
{-0.535280, -0.292313, -0.182934, 0.879208, -0.165716, 0.446638, 0.329342, 2.276771},
{-0.549148, -0.273210, -0.163749, 0.569170, -0.153966, 0.807642, 0.277480, 2.229360},
{-0.536404, -0.270310, -0.178784, 0.893338, -0.028840, 0.448408, 0.268677, 2.271402},
{-0.539372, -0.244449, -0.173596, 0.891293, -0.031190, 0.452345, 0.195016, 2.259774},
{-0.552249, -0.248082, -0.157720, 0.589038, -0.137211, 0.796350, 0.203121, 2.218794},
{-0.615348, -0.292220, -0.285748, 0.067598, -0.010773, -0.997650, 2.161721, 0.758877},
{-0.613932, -0.262670, -0.282964, 0.110691, 0.072695, -0.991180, 2.074206, 0.755070},
{-0.580114, -0.266422, -0.278717, 0.130650, 0.112491, -0.985015, 2.085078, 0.663936},
{-0.581655, -0.295733, -0.283221, 0.081118, 0.035920, -0.996033, 2.171937, 0.668133},
{-0.580764, -0.321443, -0.281630, 0.013855, -0.399762, -0.916501, 2.261725, 0.672076},
{-0.615391, -0.318072, -0.282852, 0.008667, -0.409406, -0.912290, 2.251109, 0.763422},
{-0.661641, -0.315155, -0.284135, 0.014405, -0.416761, -0.908872, 2.241856, 0.885885},
{-0.660869, -0.289149, -0.288323, 0.041444, -0.054537, -0.997620, 2.152855, 0.881444},
{-0.659709, -0.259337, -0.287200, 0.064211, 0.037416, -0.997223, 2.064609, 0.878382},
{-0.613053, -0.234376, -0.281283, 0.132176, 0.038545, -0.990448, 1.990436, 0.752742},
{-0.578365, -0.239075, -0.275913, 0.154820, 0.058626, -0.986175, 2.004078, 0.659229},
{-0.659570, -0.230029, -0.286488, 0.075076, 0.023133, -0.996887, 1.977873, 0.878077},
{-0.659591, -0.200787, -0.286126, 0.076540, 0.006531, -0.997040, 1.891340, 0.878216},
{-0.612532, -0.206108, -0.280625, 0.135594, 0.004883, -0.990722, 1.906775, 0.751409},
{-0.577126, -0.211648, -0.274838, 0.158208, 0.004700, -0.987365, 1.922889, 0.655946},
{-0.561195, -0.241466, -0.273284, 0.294351, 0.062655, -0.953612, 2.011022, 0.612940},
{-0.563109, -0.268518, -0.276632, 0.290231, 0.120151, -0.949370, 2.091164, 0.618111},
{-0.559755, -0.214201, -0.271975, 0.307566, 0.006928, -0.951476, 1.930305, 0.609111},
{-0.564413, -0.297497, -0.281936, 0.289315, 0.053346, -0.955718, 2.177065, 0.621696},
{-0.554513, -0.301238, -0.277026, 0.612384, 0.007324, -0.790490, 2.179648, 0.597413},
{-0.555164, -0.319452, -0.275650, 0.603839, -0.186865, -0.774865, 2.266714, 0.598781},
{-0.562822, -0.322757, -0.280985, 0.292642, -0.321848, -0.900418, 2.265844, 0.624489},
{-1.183103, -0.115118, -0.252545, -0.964843, 0.001312, -0.262734, 1.752000, -0.148455},
{-1.182961, -0.160824, -0.251694, -0.974822, -0.029359, -0.220985, 1.752333, -0.025464},
{-1.186750, -0.172771, -0.219938, -0.993408, -0.069857, -0.090823, 1.658553, 0.008496},
{-1.188451, -0.128147, -0.220228, -0.994598, -0.013764, -0.102756, 1.656286, -0.111509},
{-1.187998, -0.072462, -0.221289, -0.993927, 0.013489, -0.109012, 1.656474, -0.244559},
{-1.182138, -0.058449, -0.253559, -0.961486, 0.013672, -0.274422, 1.752097, -0.284168},
{-1.172125, -0.046084, -0.277184, -0.767296, 0.009796, -0.641194, 1.843711, -0.329534},
{-1.173372, -0.103131, -0.276411, -0.774773, 0.003937, -0.632221, 1.844451, -0.192509},
{-1.174980, -0.149458, -0.274902, -0.802118, -0.000977, -0.597156, 1.841720, -0.067087},
{-1.180898, -0.197056, -0.251847, -0.988495, -0.047700, -0.143376, 1.755465, 0.071931},
{-1.181971, -0.208911, -0.221543, -0.993255, -0.092318, -0.069918, 1.666557, 0.105488},
{-1.176761, -0.185472, -0.273090, -0.846797, -0.007538, -0.531816, 1.836129, 0.029989},
{-1.183571, -0.214418, -0.185821, -0.995819, -0.089236, 0.017884, 1.561161, 0.122275},
{-1.187762, -0.178988, -0.185117, -0.995972, -0.077395, 0.044618, 1.555985, 0.027130},
{-1.180504, -0.216848, -0.156389, -0.888607, -0.066073, 0.453810, 1.447521, 0.130677},
{-1.183237, -0.182311, -0.156942, -0.883572, -0.054659, 0.465072, 1.449024, 0.038100},
{-1.189879, -0.135885, -0.185518, -0.998077, -0.022919, 0.057314, 1.554049, -0.088778},
{-1.185045, -0.140746, -0.157541, -0.877895, -0.018006, 0.478500, 1.448551, -0.073154},
{-1.185482, -0.089149, -0.157557, -0.874905, 0.003357, 0.484237, 1.445182, -0.194124},
{-1.190085, -0.082178, -0.186111, -0.998413, 0.010071, 0.055147, 1.552833, -0.216463},
{-0.537925, -0.194318, -0.253723, 0.854915, 0.014405, -0.518509, 2.142753, -0.733342},
{-0.537530, -0.160678, -0.252320, 0.864681, 0.001251, -0.502274, 2.140871, -0.642766},
{-0.528529, -0.170103, -0.227210, 0.989868, -0.015595, -0.140965, 2.072862, -0.666696},
{-0.529539, -0.202634, -0.230978, 0.988861, -0.003052, -0.148656, 2.081302, -0.754420},
{-0.538411, -0.223224, -0.255903, 0.831813, 0.029695, -0.554216, 2.146263, -0.810112},
{-0.550243, -0.216986, -0.267256, 0.582080, 0.018128, -0.812922, 2.179524, -0.793621},
{-0.550229, -0.187513, -0.267318, 0.621845, -0.001221, -0.783105, 2.186379, -0.710870},
{-0.550712, -0.152352, -0.268095, 0.648671, -0.004395, -0.761040, 2.192382, -0.615074},
{-0.537103, -0.116755, -0.251828, 0.862667, -0.004089, -0.505722, 2.142242, -0.524577},
{-0.527483, -0.127079, -0.225658, 0.989074, -0.017579, -0.146214, 2.071477, -0.550863},
{-0.550976, -0.107321, -0.268480, 0.655416, 0.000488, -0.755242, 2.196683, -0.493190},
{-0.551560, -0.050841, -0.268547, 0.645436, 0.008240, -0.763726, 2.200132, -0.358262},
{-0.536827, -0.060745, -0.251734, 0.851283, -0.000946, -0.524644, 2.145242, -0.392582},
{-0.526379, -0.071515, -0.225254, 0.987030, -0.014435, -0.159825, 2.104965, -0.382709},
{-0.530011, -0.133767, -0.190630, 0.981750, -0.030274, 0.187719, 1.968060, -0.566948},
{-0.531124, -0.176894, -0.193031, 0.982238, -0.037568, 0.183752, 1.971861, -0.683103},
{-0.528657, -0.078445, -0.189710, 0.981780, -0.021241, 0.188726, 1.969039, -0.434878},
{-0.539348, -0.083429, -0.157168, 0.871853, -0.021149, 0.489273, 1.847474, -0.446201},
{-0.540529, -0.138445, -0.158573, 0.877071, -0.040742, 0.478591, 1.848319, -0.577932},
{-0.541399, -0.181804, -0.161594, 0.880245, -0.061007, 0.470534, 1.854362, -0.695750},
{-0.531647, -0.210100, -0.198058, 0.985015, -0.028687, 0.169897, 1.984199, -0.772712},
{-0.541025, -0.216043, -0.167234, 0.886074, -0.064486, 0.458968, 1.869270, -0.789610},
{-1.171605, -0.145142, -0.145421, -0.450819, -0.007294, 0.892575, -0.045144, 0.544308},
{-1.170418, -0.185575, -0.145122, -0.444777, -0.025605, 0.895260, 0.074291, 0.550849},
{-1.144582, -0.190059, -0.140295, -0.172613, -0.032594, 0.984436, 0.084913, 0.620591},
{-1.145102, -0.150821, -0.139914, -0.190588, -0.010010, 0.981597, -0.031089, 0.615927},
{-1.144002, -0.101765, -0.139477, -0.196509, -0.010651, 0.980438, -0.157791, 0.615322},
{-1.171269, -0.094925, -0.145158, -0.447584, -0.005951, 0.894192, -0.175200, 0.541556},
{-1.185482, -0.089149, -0.157557, -0.874905, 0.003357, 0.484237, -0.188528, 0.490082},
{-1.185045, -0.140746, -0.157541, -0.877895, -0.018006, 0.478500, -0.055592, 0.496346},
{-1.183237, -0.182311, -0.156942, -0.883572, -0.054659, 0.465072, 0.066490, 0.505036},
{-1.167575, -0.219474, -0.144953, -0.419050, -0.047731, 0.906674, 0.174263, 0.561305},
{-1.141590, -0.223313, -0.141496, -0.139836, -0.068148, 0.987823, 0.183036, 0.631423},
{-1.180504, -0.216848, -0.156389, -0.888607, -0.066073, 0.453810, 0.167981, 0.513104},
{-1.099358, -0.229379, -0.136000, -0.129551, -0.114383, 0.984924, 0.196793, 0.745374},
{-1.101006, -0.197047, -0.133098, -0.150426, -0.063753, 0.986541, 0.101177, 0.738192},
{-1.052675, -0.235377, -0.131203, -0.083163, -0.148686, 0.985351, 0.209978, 0.871307},
{-1.052794, -0.203686, -0.127000, -0.090976, -0.088717, 0.991882, 0.116046, 0.868259},
{-1.101077, -0.159532, -0.131776, -0.162603, -0.023194, 0.986389, -0.009824, 0.734856},
{-1.052614, -0.167480, -0.124873, -0.096103, -0.036622, 0.994690, 0.008848, 0.865687},
{-1.052321, -0.120865, -0.123904, -0.098910, -0.015320, 0.994964, -0.110592, 0.863104},
{-1.100234, -0.111930, -0.131076, -0.168035, -0.012543, 0.985687, -0.132219, 0.733675},
{-1.165969, -0.180778, -0.281629, -0.359264, -0.032624, -0.932646, 1.833606, 2.240560},
{-1.161389, -0.144979, -0.284078, -0.332621, -0.023103, -0.942747, 1.727741, 2.228428},
{-1.136586, -0.143598, -0.285955, -0.050447, -0.047029, -0.997589, 1.723630, 2.161761},
{-1.142004, -0.179252, -0.283507, -0.049898, -0.064180, -0.996673, 1.829071, 2.176146},
{-1.176761, -0.185472, -0.273090, -0.846797, -0.007538, -0.531816, 1.837283, 2.278476},
{-1.174980, -0.149458, -0.274902, -0.802118, -0.000977, -0.597156, 1.730791, 2.272469},
{-1.158797, -0.098514, -0.285765, -0.317850, -0.011414, -0.948057, 1.590300, 2.221658},
{-1.133963, -0.097151, -0.287578, -0.050905, -0.021119, -0.998474, 1.586240, 2.154903},
{-1.173372, -0.103131, -0.276411, -0.774773, 0.003937, -0.632221, 1.593048, 2.267319},
{-1.172125, -0.046084, -0.277184, -0.767296, 0.009796, -0.641194, 1.442434, 2.263734},
{-1.157575, -0.041314, -0.286428, -0.315073, 0.002869, -0.949034, 1.439562, 2.218553},
{-1.133016, -0.039756, -0.288204, -0.052431, -0.001099, -0.998596, 1.434925, 2.152537},
{-1.093455, -0.094923, -0.288822, -0.026276, -0.021668, -0.999390, 1.579555, 2.045962},
{-1.094970, -0.141522, -0.287264, -0.024628, -0.049715, -0.998444, 1.717393, 2.049839},
{-1.092974, -0.037026, -0.289426, -0.028901, -0.002686, -0.999573, 1.426759, 2.044852},
{-1.048162, -0.033736, -0.290574, -0.032594, -0.005036, -0.999451, 1.416913, 1.924330},
{-1.048225, -0.092261, -0.289895, -0.027894, -0.022553, -0.999329, 1.571568, 1.924312},
{-1.048503, -0.139225, -0.288359, -0.026246, -0.048799, -0.998444, 1.710482, 1.924860},
{-1.098349, -0.177174, -0.284767, -0.023164, -0.068484, -0.997375, 1.822819, 2.058737},
{-1.049299, -0.175068, -0.285930, -0.028687, -0.066164, -0.997375, 1.816467, 1.926811},
{-0.614003, -0.159640, -0.128029, 0.110538, -0.052309, 0.992462, -0.054395, 2.044683},
{-0.613895, -0.198957, -0.131051, 0.131657, -0.113865, 0.984710, 0.062026, 2.048306},
{-0.578013, -0.190537, -0.136492, 0.271432, -0.117618, 0.955229, 0.034138, 2.144235},
{-0.577796, -0.149012, -0.133065, 0.253670, -0.055055, 0.965697, -0.088861, 2.141293},
{-0.577514, -0.095960, -0.131432, 0.239967, -0.019074, 0.970580, -0.227374, 2.138128},
{-0.613968, -0.108930, -0.126545, 0.099490, -0.019349, 0.994842, -0.185949, 2.041053},
{-0.660096, -0.120744, -0.124163, 0.037355, -0.020356, 0.999084, -0.146918, 1.917923},
{-0.660063, -0.169311, -0.125505, 0.042085, -0.048555, 0.997925, -0.021714, 1.921556},
{-0.659771, -0.206642, -0.128047, 0.054262, -0.103488, 0.993133, 0.088791, 1.925498},
{-0.612760, -0.231572, -0.136341, 0.156102, -0.182775, 0.970672, 0.158660, 2.054190},
{-0.576756, -0.224055, -0.142531, 0.286966, -0.182409, 0.940397, 0.133474, 2.150537},
{-0.658951, -0.238494, -0.132457, 0.070284, -0.169744, 0.982971, 0.183149, 1.930452},
{-0.554453, -0.219786, -0.150777, 0.594378, -0.137608, 0.792291, 0.119267, 2.210356},
{-0.555438, -0.185585, -0.144711, 0.589221, -0.098514, 0.801904, 0.017885, 2.204727},
{-0.541025, -0.216043, -0.167234, 0.886074, -0.064486, 0.458968, 0.110550, 2.251911},
{-0.541399, -0.181804, -0.161594, 0.880245, -0.061007, 0.470534, 0.007449, 2.247501},
{-0.554881, -0.142737, -0.141315, 0.581164, -0.052065, 0.812098, -0.109058, 2.202590},
{-0.540529, -0.138445, -0.158573, 0.877071, -0.040742, 0.478591, -0.122120, 2.246231},
{-0.539348, -0.083429, -0.157168, 0.871853, -0.021149, 0.489273, -0.267024, 2.245670},
{-0.554137, -0.088364, -0.139691, 0.568529, -0.019959, 0.822382, -0.251519, 2.200559},
{-0.612189, -0.176639, -0.280907, 0.127903, -0.016297, -0.991638, 1.819590, 0.750589},
{-0.612143, -0.141064, -0.281643, 0.121067, -0.017853, -0.992462, 1.714350, 0.750604},
{-0.577692, -0.146374, -0.276797, 0.142674, -0.022248, -0.989502, 1.729813, 0.657739},
{-0.577111, -0.182095, -0.275522, 0.149541, -0.025971, -0.988403, 1.835468, 0.656022},
{-0.658915, -0.171170, -0.286057, 0.073702, -0.008026, -0.997223, 1.803705, 0.876488},
{-0.658282, -0.135526, -0.286376, 0.072268, -0.015717, -0.997253, 1.698248, 0.874911},
{-0.612515, -0.094476, -0.282343, 0.122166, -0.010285, -0.992431, 1.576527, 0.751776},
{-0.578239, -0.100440, -0.277498, 0.143742, -0.007660, -0.989563, 1.593927, 0.659382},
{-0.658437, -0.088202, -0.287177, 0.075808, -0.015015, -0.996979, 1.558248, 0.875502},
{-0.659162, -0.029584, -0.287946, 0.083346, -0.007263, -0.996490, 1.403325, 0.877645},
{-0.613402, -0.036599, -0.282783, 0.128941, -0.001495, -0.991638, 1.423789, 0.754339},
{-0.579204, -0.043259, -0.277713, 0.149236, 0.002045, -0.988769, 1.443238, 0.662145},
{-0.561207, -0.103302, -0.274957, 0.346446, -0.003418, -0.938047, 1.602268, 0.613466},
{-0.560657, -0.148860, -0.274268, 0.338694, -0.018433, -0.940703, 1.737044, 0.611818},
{-0.562138, -0.046509, -0.275087, 0.346202, 0.006867, -0.938108, 1.452727, 0.616135},
{-0.551560, -0.050841, -0.268547, 0.645436, 0.008240, -0.763726, 1.504392, 0.580298},
{-0.550976, -0.107321, -0.268480, 0.655416, 0.000488, -0.755242, 1.606080, 0.590790},
{-0.550712, -0.152352, -0.268095, 0.648671, -0.004395, -0.761040, 1.740159, 0.589367},
{-0.559874, -0.184579, -0.272788, 0.324137, -0.023041, -0.945708, 1.842685, 0.609551},
{-0.550229, -0.187513, -0.267318, 0.621845, -0.001221, -0.783105, 1.845572, 0.587129},
{-0.719246, 0.360974, -0.240646, 0.014649, 0.994568, -0.103000, 0.819950, -0.741300},
{-0.774290, 0.362256, -0.237964, 0.023957, 0.991791, -0.125370, 0.811854, -0.593168},
{-0.774208, 0.363832, -0.219159, 0.036775, 0.999268, -0.008789, 0.756124, -0.593379},
{-0.719101, 0.362270, -0.220716, 0.023164, 0.999695, 0.005188, 0.760908, -0.741691},
{-0.718984, 0.358763, -0.256445, 0.010071, 0.995239, -0.096774, 0.866826, -0.742037},
{-0.773825, 0.359771, -0.253003, 0.016205, 0.992798, -0.118595, 0.856501, -0.594463},
{-0.819004, 0.364000, -0.235460, 0.037721, 0.987976, -0.149846, 0.804271, -0.472816},
{-0.818960, 0.365949, -0.217775, 0.048128, 0.998566, -0.022980, 0.751830, -0.472913},
{-0.818929, 0.361118, -0.249594, 0.028504, 0.988098, -0.151128, 0.846265, -0.473075},
{-0.864674, 0.363178, -0.248273, 0.047212, 0.980987, -0.188208, 0.842162, -0.349937},
{-0.864405, 0.366281, -0.234634, 0.049562, 0.986602, -0.155278, 0.801619, -0.350599},
{-0.864378, 0.368258, -0.217272, 0.044710, 0.998779, -0.020478, 0.750133, -0.350647},
{-0.818791, 0.364574, -0.193118, 0.053316, 0.987671, 0.146977, 0.678975, -0.473454},
{-0.773610, 0.362069, -0.193845, 0.044649, 0.987548, 0.150670, 0.681350, -0.595090},
{-0.864551, 0.366975, -0.192857, 0.038789, 0.987762, 0.150975, 0.677987, -0.350266},
{-0.864909, 0.360993, -0.168558, 0.030122, 0.908353, 0.417066, 0.595511, -0.349670},
{-0.818495, 0.358661, -0.168652, 0.048555, 0.913205, 0.404584, 0.595911, -0.474219},
{-0.772526, 0.356079, -0.169078, 0.042909, 0.918607, 0.392804, 0.586928, -0.559249},
{-0.718544, 0.360218, -0.194709, 0.027284, 0.987915, 0.152562, 0.684101, -0.743300},
{-0.717569, 0.354226, -0.169666, 0.022919, 0.925474, 0.378033, 0.610398, -0.746144},
{-0.921509, 0.369178, -0.236988, 0.050996, 0.990112, -0.130467, 0.808318, -0.196868},
{-0.977055, 0.371585, -0.240186, 0.036042, 0.994232, -0.100772, 0.817544, -0.047343},
{-0.977003, 0.372015, -0.220146, 0.021943, 0.999176, 0.034028, 0.758235, -0.047509},
{-0.921484, 0.370396, -0.218361, 0.034059, 0.999390, 0.005432, 0.753135, -0.196936},
{-0.921438, 0.366329, -0.251097, 0.058382, 0.973662, -0.220313, 0.850235, -0.197115},
{-0.976529, 0.369110, -0.254949, 0.047639, 0.971770, -0.230995, 0.861374, -0.048801},
{-1.017780, 0.372400, -0.241890, 0.008637, 0.995849, -0.090457, 0.822476, 0.062258},
{-1.017658, 0.372768, -0.221736, 0.002533, 0.998932, 0.045900, 0.762831, 0.061902},
{-1.017256, 0.370060, -0.256709, 0.018983, 0.977508, -0.209967, 0.866464, 0.060810},
{-1.016996, 0.369686, -0.195585, -0.006226, 0.980407, 0.196753, 0.685663, 0.059980},
{-0.976422, 0.369362, -0.194410, 0.008118, 0.982757, 0.184576, 0.682266, -0.049197},
{-1.016001, 0.362404, -0.170539, -0.015259, 0.898465, 0.438704, 0.599734, 0.057274},
{-0.975517, 0.362420, -0.169691, -0.003143, 0.899869, 0.436110, 0.597969, -0.051646},
{-0.921351, 0.368514, -0.193394, 0.019562, 0.985900, 0.166051, 0.679396, -0.197396},
{-0.921202, 0.362098, -0.168967, 0.008362, 0.903684, 0.428083, 0.596379, -0.198054},
{-1.012998, -0.335600, -0.268045, -0.034639, -0.827448, -0.560411, 1.340780, -0.791278},
{-0.971824, -0.337165, -0.268705, -0.029328, -0.815607, -0.577837, 1.342090, -0.680535},
{-0.972057, -0.346417, -0.244144, -0.026124, -0.988922, -0.146001, 1.274285, -0.682308},
{-1.013219, -0.344679, -0.243101, -0.031373, -0.987457, -0.154546, 1.271777, -0.793025},
{-1.012524, -0.317715, -0.283835, -0.025056, -0.418836, -0.907682, 1.398804, -0.789229},
{-0.971431, -0.318477, -0.284352, -0.023255, -0.412519, -0.910642, 1.398374, -0.678465},
{-0.920993, -0.337841, -0.269555, -0.013703, -0.807459, -0.589740, 1.343259, -0.543779},
{-0.921141, -0.347417, -0.245151, -0.011872, -0.989654, -0.142827, 1.276053, -0.545327},
{-0.920820, -0.318444, -0.285281, -0.016236, -0.412610, -0.910733, 1.398726, -0.541985},
{-0.867427, -0.317960, -0.286025, -0.003388, -0.414289, -0.910123, 1.398453, -0.398179},
{-0.867425, -0.337761, -0.270229, 0.000793, -0.801294, -0.598254, 1.343495, -0.399639},
{-0.867475, -0.347676, -0.245917, -0.001129, -0.988159, -0.153264, 1.276703, -0.400931},
{-0.921180, -0.344529, -0.214593, -0.004547, -0.980163, 0.198096, 1.185370, -0.546381},
{-0.972134, -0.344121, -0.213441, -0.003357, -0.983856, 0.178930, 1.183437, -0.683487},
{-0.867474, -0.345045, -0.215397, -0.008423, -0.981384, 0.191717, 1.186244, -0.401884},
{-0.867441, -0.335507, -0.186003, -0.013611, -0.923582, 0.383129, 1.096052, -0.402483},
{-0.921190, -0.334871, -0.185218, 0.002197, -0.923032, 0.384655, 1.095180, -0.547089},
{-0.972165, -0.335111, -0.184035, 0.016633, -0.924833, 0.379955, 1.093444, -0.684278},
{-1.013261, -0.343799, -0.212148, -0.005768, -0.988922, 0.148289, 1.180818, -0.794165},
{-1.013257, -0.336123, -0.182695, 0.014679, -0.926450, 0.376110, 1.091270, -0.794906},
{-0.818037, -0.337058, -0.270361, 0.015503, -0.797296, -0.603351, 1.342008, -0.266742},
{-0.768467, -0.335734, -0.270133, 0.026612, -0.795740, -0.605029, 1.339186, -0.133350},
{-0.768403, -0.346037, -0.246182, 0.020234, -0.978423, -0.205573, 1.273613, -0.134334},
{-0.818061, -0.347194, -0.246237, 0.009827, -0.984405, -0.175481, 1.275859, -0.267967},
{-0.817989, -0.317369, -0.285987, 0.010743, -0.415265, -0.909604, 1.396146, -0.265438},
{-0.768374, -0.316504, -0.285516, 0.018983, -0.416578, -0.908872, 1.392668, -0.132486},
{-0.714356, -0.333794, -0.269724, 0.025636, -0.798761, -0.601062, 1.335419, 0.012275},
{-0.714000, -0.344271, -0.245822, 0.023774, -0.973083, -0.229102, 1.270060, 0.012070},
{-0.714446, -0.315199, -0.284961, 0.020234, -0.418409, -0.908017, 1.388885, 0.011952},
{-0.714053, -0.346402, -0.215036, 0.007477, -0.997711, 0.066805, 1.180911, 0.010806},
{-0.768467, -0.346229, -0.215479, -0.006561, -0.993713, 0.111576, 1.183859, -0.135561},
{-0.714065, -0.341137, -0.185415, -0.005890, -0.936949, 0.349376, 1.091927, 0.009936},
{-0.768417, -0.339177, -0.185885, -0.028901, -0.932310, 0.360454, 1.094171, -0.136206},
{-0.818088, -0.345694, -0.215646, -0.010590, -0.986938, 0.160741, 1.185689, -0.269035},
{-0.818029, -0.337121, -0.186154, -0.026734, -0.926664, 0.374920, 1.095631, -0.269600},
{-0.716173, 0.343702, -0.152631, 0.012970, 0.770501, 0.637287, 0.560670, -0.750238},
{-0.770991, 0.344974, -0.151916, 0.032380, 0.755028, 0.654836, 0.557910, -0.592312},
{-0.769263, 0.331267, -0.140013, 0.023377, 0.601978, 0.798120, 0.518874, -0.599391},
{-0.714593, 0.330766, -0.141059, 0.008393, 0.608051, 0.793847, 0.522928, -0.754957},
{-0.818069, 0.346995, -0.151542, 0.033692, 0.740440, 0.671255, -1.236787, 1.462685},
{-0.817588, 0.332544, -0.139546, 0.021149, 0.590899, 0.806421, -1.194769, 1.464898},
{-0.769263, 0.331267, -0.140013, 0.023377, 0.601978, 0.798120, -1.205379, 1.623577},
{-0.770991, 0.344974, -0.151916, 0.032380, 0.755028, 0.654836, -1.233652, 1.579090},
{-0.772526, 0.356079, -0.169078, 0.042909, 0.918607, 0.392804, -1.273069, 1.571618},
{-0.818495, 0.358661, -0.168652, 0.048555, 0.913205, 0.404584, -1.278991, 1.460471},
{-0.864909, 0.360993, -0.168558, 0.030122, 0.908353, 0.417066, -1.282216, 1.335842},
{-0.865438, 0.348873, -0.151543, 0.017945, 0.728385, 0.684927, -1.237993, 1.335138},
{-0.866044, 0.333886, -0.139558, 0.009888, 0.582934, 0.812433, -1.194290, 1.334472},
{-0.817127, 0.318274, -0.130424, 0.015656, 0.467391, 0.883877, -1.153124, 1.467107},
{-0.767602, 0.317475, -0.131024, 0.021088, 0.468398, 0.883236, -1.155271, 1.600378},
{-0.866634, 0.319303, -0.130346, 0.007019, 0.467635, 0.883877, -1.151628, 1.333880},
{-0.867136, 0.303584, -0.123589, 0.005554, 0.319285, 0.947630, -1.105478, 1.333676},
{-0.816775, 0.302676, -0.123783, 0.014191, 0.316050, 0.948607, -1.107402, 1.469195},
{-0.766275, 0.302045, -0.124542, 0.023438, 0.309122, 0.950713, -1.110127, 1.605076},
{-0.713066, 0.317535, -0.132403, 0.015625, 0.458083, 0.888730, -1.160375, 1.747072},
{-0.714593, 0.330766, -0.141059, 0.008393, 0.608051, 0.793847, -1.199391, 1.742094},
{-0.711843, 0.302449, -0.126248, 0.030152, 0.291849, 0.955962, -1.116220, 1.751469},
{-0.921128, 0.349711, -0.151957, 0.000458, 0.722739, 0.691092, -1.235340, 1.185308},
{-0.974492, 0.349986, -0.152704, -0.009735, 0.721763, 0.692038, -1.231215, 1.041791},
{-0.973465, 0.335033, -0.140772, -0.011780, 0.586413, 0.809900, -1.187761, 1.045515},
{-0.921107, 0.334580, -0.139951, -0.002228, 0.582812, 0.812586, -1.191270, 1.186341},
{-0.921202, 0.362098, -0.168967, 0.008362, 0.903684, 0.428083, -1.280048, 1.184248},
{-0.975517, 0.362420, -0.169691, -0.003143, 0.899869, 0.436110, -1.275272, 1.037917},
{-1.014880, 0.350172, -0.153701, -0.018128, 0.725211, 0.688253, -1.228005, 0.933181},
{-1.013805, 0.335651, -0.142069, -0.016541, 0.591174, 0.806330, -1.185816, 0.937005},
{-1.016001, 0.362404, -0.170539, -0.015259, 0.898465, 0.438704, -1.270673, 0.929077},
{-1.051665, 0.361990, -0.171768, -0.029756, 0.900357, 0.434095, -1.266162, 0.838982},
{-1.051013, 0.349805, -0.154516, -0.024049, 0.738121, 0.674215, -1.225252, 0.842026},
{-1.012946, 0.321503, -0.132639, -0.020875, 0.475539, 0.879421, -1.144584, 0.940268},
{-0.972556, 0.320537, -0.131218, -0.013520, 0.476791, 0.878903, -1.145513, 1.048939},
{-1.012372, 0.305584, -0.125668, -0.036164, 0.300424, 0.953093, -1.097955, 0.942972},
{-0.971880, 0.304498, -0.124140, -0.019044, 0.313944, 0.949217, -1.098543, 1.051921},
{-0.921114, 0.319930, -0.130532, -0.002258, 0.472121, 0.881527, -1.148476, 1.187317},
{-0.921153, 0.304011, -0.123577, -0.003693, 0.318735, 0.947813, -1.101787, 1.188370},
{-0.716536, 0.353087, -0.286450, 0.027100, 0.631336, -0.775018, 0.548598, 1.032884},
{-0.770026, 0.354078, -0.285794, -0.004944, 0.718253, -0.695730, 0.545461, 1.183912},
{-0.771425, 0.357524, -0.278464, 0.002411, 0.959532, -0.281472, 0.532183, 1.189805},
{-0.717445, 0.356856, -0.280414, 0.013886, 0.939390, -0.342479, 0.533559, 1.035262},
{-0.715729, 0.345474, -0.289328, 0.033204, 0.226051, -0.973540, 0.571203, 1.030779},
{-0.768822, 0.346896, -0.289630, -0.005585, 0.281961, -0.959380, 0.554815, 1.211462},
{-0.818232, 0.354810, -0.283724, -0.012665, 0.774163, -0.632832, 0.947631, -0.475066},
{-0.818490, 0.358127, -0.275597, 0.003174, 0.964507, -0.263955, 0.923381, -0.474293},
{-0.771425, 0.357524, -0.278464, 0.002411, 0.959532, -0.281472, 0.944711, -0.631694},
{-0.770026, 0.354078, -0.285794, -0.004944, 0.718253, -0.695730, 0.955949, -0.597673},
{-0.768822, 0.346896, -0.289630, -0.005585, 0.281961, -0.959380, 0.972536, -0.603845},
{-0.818024, 0.348075, -0.288344, -0.020356, 0.351543, -0.935911, 0.966205, -0.475879},
{-0.867311, 0.349313, -0.286713, -0.012207, 0.407971, -0.912900, 0.961441, -0.342840},
{-0.866667, 0.355677, -0.281459, -0.000336, 0.808374, -0.588641, 0.940806, -0.344728},
{-0.865939, 0.358933, -0.273026, 0.014710, 0.959014, -0.282968, 0.915655, -0.346609},
{-0.818740, 0.359695, -0.263597, 0.018372, 0.992309, -0.122318, 0.887780, -0.473598},
{-0.772781, 0.358808, -0.267019, 0.011505, 0.995483, -0.094089, 0.898025, -0.597273},
{-0.865230, 0.361081, -0.261517, 0.032929, 0.982513, -0.183203, 0.881474, -0.348477},
{-0.718322, 0.358069, -0.270057, 0.009369, 0.995972, -0.088961, 0.907138, -0.743812},
{-0.717445, 0.356856, -0.280414, 0.013886, 0.939390, -0.342479, 0.944169, -0.746105},
{-0.920843, 0.357073, -0.280219, 0.017792, 0.823115, -0.567553, 0.936970, -0.198926},
{-0.972254, 0.358839, -0.279932, 0.034364, 0.806360, -0.590381, 0.935937, -0.060553},
{-0.973861, 0.361938, -0.272364, 0.049135, 0.921476, -0.385235, 0.913349, -0.056154},
{-0.921075, 0.360211, -0.271964, 0.030519, 0.942167, -0.333720, 0.912352, -0.198229},
{-0.920659, 0.350911, -0.285983, 0.001282, 0.429456, -0.903073, 0.959810, -0.199656},
{-0.970875, 0.352583, -0.285563, 0.004089, 0.401746, -0.915708, 0.958596, -0.065067},
{-1.012392, 0.360820, -0.280530, 0.028840, 0.732505, -0.680135, 0.937522, 0.047499},
{-1.014261, 0.364090, -0.274179, 0.047700, 0.904080, -0.424635, 0.918526, 0.052610},
{-1.010767, 0.354041, -0.284863, -0.007172, 0.325663, -0.945433, 0.955085, 0.042188},
{-1.048928, 0.353884, -0.283731, -0.027863, 0.254128, -0.966735, 0.950424, 0.135777},
{-1.050198, 0.361292, -0.280941, -0.013337, 0.581561, -0.813379, 0.940416, 0.140391},
{-1.015983, 0.367230, -0.266856, 0.037873, 0.946013, -0.321848, 0.896660, 0.057320},
{-0.975375, 0.365628, -0.264855, 0.052675, 0.939055, -0.339640, 0.890901, -0.051988},
{-0.921283, 0.363319, -0.262506, 0.047456, 0.959929, -0.276101, 0.884177, -0.197597},
{-1.013340, -0.324814, -0.162253, 0.010926, -0.776910, 0.629475, 1.026501, -0.795453},
{-0.972264, -0.324219, -0.163368, 0.017945, -0.798090, 0.602222, 1.028199, -0.684888},
{-0.972399, -0.310154, -0.149650, 0.009125, -0.561754, 0.827235, 0.975329, -0.685408},
{-1.013457, -0.309598, -0.148911, -0.005371, -0.528001, 0.849208, 0.974121, -0.795903},
{-0.921247, -0.324138, -0.164362, 0.005432, -0.808618, 0.588275, 1.029453, -0.547602},
{-0.921341, -0.310491, -0.150359, 0.006684, -0.578722, 0.815485, 0.975957, -0.548017},
{-0.867391, -0.324701, -0.165070, -0.008759, -0.807245, 0.590136, 1.030060, -0.402707},
{-0.867337, -0.310832, -0.150943, 0.000855, -0.578143, 0.815912, 0.976169, -0.402746},
{-0.921458, -0.292095, -0.141540, 0.006531, -0.338511, 0.940916, 0.366234, 1.229142},
{-0.972540, -0.291626, -0.141090, 0.002533, -0.327891, 0.944700, 0.369509, 1.091716},
{-0.972399, -0.310154, -0.149650, 0.009125, -0.561754, 0.827235, 0.431216, 1.093966},
{-0.921341, -0.310491, -0.150359, 0.006684, -0.578722, 0.815485, 0.427992, 1.231357},
{-0.867337, -0.310832, -0.150943, 0.000855, -0.578143, 0.815912, 0.424241, 1.376615},
{-0.867290, -0.292103, -0.141968, 0.005341, -0.340983, 0.940031, 0.361315, 1.374828},
{-0.867287, -0.268799, -0.136006, 0.005066, -0.214850, 0.976623, 0.292072, 1.372763},
{-0.921559, -0.269012, -0.135692, 0.005829, -0.213172, 0.976989, 0.297661, 1.226818},
{-0.972620, -0.268542, -0.135380, 0.000885, -0.211615, 0.977325, 0.300938, 1.089453},
{-1.013554, -0.290199, -0.140759, -0.017518, -0.305521, 0.951994, 0.369035, 0.981288},
{-1.013457, -0.309598, -0.148911, -0.005371, -0.528001, 0.849208, 0.432882, 0.983438},
{-1.013544, -0.266657, -0.135251, -0.023530, -0.205969, 0.978271, 0.299111, 0.979234},
{-0.817796, -0.326038, -0.165325, -0.021149, -0.795587, 0.605457, 1.029818, -0.269318},
{-0.768012, -0.327747, -0.165259, -0.024781, -0.778344, 0.627308, 1.028794, -0.135442},
{-0.767368, -0.312054, -0.151476, -0.007874, -0.542711, 0.839839, 0.975572, -0.133974},
{-0.817442, -0.311397, -0.151304, -0.005310, -0.564287, 0.825556, 0.976127, -0.268611},
{-0.713588, -0.329426, -0.165005, -0.000458, -0.759056, 0.650990, 1.027058, 0.010911},
{-0.712832, -0.312667, -0.151494, 0.013642, -0.518052, 0.855220, 0.974247, 0.012807},
{-0.659251, -0.328389, -0.165640, 0.075350, -0.730308, 0.678915, 1.024966, 0.163501},
{-0.658603, -0.311087, -0.152940, 0.084384, -0.487289, 0.869137, 0.972536, 0.165659},
{-0.712009, -0.292259, -0.142569, 0.021119, -0.326182, 0.945067, 0.347563, 1.792459},
{-0.766604, -0.292210, -0.142411, 0.001251, -0.334117, 0.942503, 0.352417, 1.645627},
{-0.767368, -0.312054, -0.151476, -0.007874, -0.542711, 0.839839, 0.417684, 1.645384},
{-0.712832, -0.312667, -0.151494, 0.013642, -0.518052, 0.855220, 0.413757, 1.792153},
{-0.711531, -0.268321, -0.136393, 0.021027, -0.220649, 0.975097, 0.276391, 1.791613},
{-0.766079, -0.268488, -0.136227, 0.002472, -0.218451, 0.975829, 0.281878, 1.644925},
{-0.817018, -0.292150, -0.142235, 0.002503, -0.339213, 0.940703, 0.356855, 1.510037},
{-0.817442, -0.311397, -0.151304, -0.005310, -0.564287, 0.825556, 0.420992, 1.510748},
{-0.816729, -0.268636, -0.136141, 0.002808, -0.216773, 0.976196, 0.286958, 1.508720},
{-1.009972, -0.233447, -0.284940, -0.045778, -0.004151, -0.998932, 1.989047, 1.820785},
{-0.969749, -0.232796, -0.287024, -0.045473, -0.010102, -0.998901, 1.987053, 1.712632},
{-0.970277, -0.262711, -0.287056, -0.039308, 0.024201, -0.998932, 2.075570, 1.713956},
{-1.010800, -0.262811, -0.285405, -0.037111, 0.040223, -0.998474, 2.075945, 1.822931},
{-1.009377, -0.203768, -0.285716, -0.046052, -0.041261, -0.998077, 1.901254, 1.819302},
{-0.969358, -0.202556, -0.287866, -0.043306, -0.034639, -0.998444, 1.897603, 1.711701},
{-0.920627, -0.231225, -0.289180, -0.033296, -0.009095, -0.999390, 1.982313, 1.580539},
{-0.920639, -0.261627, -0.289117, -0.033204, 0.012543, -0.999359, 2.072265, 1.580475},
{-0.920626, -0.200594, -0.289797, -0.027772, -0.025117, -0.999298, 1.891699, 1.580654},
{-0.868228, -0.198898, -0.290760, -0.002197, -0.013581, -0.999878, 1.886542, 1.439714},
{-0.868060, -0.229662, -0.290555, -0.009613, -0.000305, -0.999939, 1.977563, 1.439157},
{-0.867817, -0.260301, -0.290670, -0.013764, 0.009369, -0.999847, 2.068219, 1.438409},
{-0.920703, -0.291870, -0.289810, -0.025269, -0.071322, -0.997101, 2.161768, 1.580571},
{-0.970876, -0.292465, -0.288317, -0.027894, -0.053804, -0.998138, 2.163646, 1.715514},
{-0.867582, -0.290937, -0.291000, -0.010559, -0.083041, -0.996460, 2.158875, 1.437689},
{-0.867427, -0.317960, -0.286025, -0.003388, -0.414289, -0.910123, 2.249530, 1.436983},
{-0.920820, -0.318444, -0.285281, -0.016236, -0.412610, -0.910733, 2.251048, 1.580747},
{-0.971431, -0.318477, -0.284352, -0.023255, -0.412519, -0.910642, 2.251502, 1.717190},
{-1.011720, -0.292176, -0.287329, -0.026124, -0.037172, -0.998962, 2.162890, 1.825377},
{-1.012524, -0.317715, -0.283835, -0.025056, -0.418836, -0.907682, 2.249858, 1.827971},
{-0.817506, -0.229035, -0.290293, 0.012207, 0.011658, -0.999847, 1.975540, 1.303134},
{-0.766413, -0.228871, -0.289335, 0.016053, 0.019135, -0.999664, 1.974866, 1.165636},
{-0.767099, -0.258944, -0.290119, 0.014344, 0.017365, -0.999725, 2.063869, 1.167411},
{-0.817738, -0.259476, -0.290798, 0.006775, 0.013001, -0.999878, 2.065624, 1.303678},
{-0.817213, -0.198484, -0.290008, 0.018921, -0.002472, -0.999817, 1.885135, 1.302433},
{-0.765728, -0.198700, -0.288734, 0.018403, 0.005188, -0.999786, 1.885575, 1.163870},
{-0.712228, -0.228698, -0.288619, 0.026612, 0.019440, -0.999451, 1.974163, 1.019829},
{-0.712594, -0.258496, -0.289253, 0.025605, 0.021455, -0.999420, 2.062347, 1.020737},
{-0.711922, -0.198893, -0.288135, 0.025910, 0.007691, -0.999634, 1.885958, 1.019084},
{-0.713596, -0.288715, -0.289752, 0.021088, -0.077761, -0.996734, 2.151776, 1.023353},
{-0.767835, -0.289531, -0.290512, 0.013977, -0.085086, -0.996246, 2.154385, 1.169307},
{-0.714446, -0.315199, -0.284961, 0.020234, -0.418409, -0.908017, 2.241827, 1.026822},
{-0.768374, -0.316504, -0.285516, 0.018983, -0.416578, -0.908872, 2.245657, 1.171263},
{-0.817895, -0.290215, -0.291081, 0.006287, -0.086703, -0.996185, 2.156582, 1.304010},
{-0.817989, -0.317369, -0.285987, 0.010743, -0.415265, -0.909604, 2.247979, 1.304236},
{-1.013336, -0.239009, -0.129843, -0.022767, -0.159764, 0.986877, 0.217036, 0.977371},
{-0.972571, -0.240809, -0.130213, 0.004547, -0.155614, 0.987793, 0.218639, 1.087161},
{-0.972430, -0.208517, -0.126153, 0.010376, -0.095584, 0.995361, 0.122911, 1.084765},
{-1.013049, -0.207125, -0.125470, -0.018097, -0.097934, 0.995025, 0.122481, 0.975397},
{-0.921606, -0.241307, -0.130606, 0.006348, -0.151311, 0.988433, 0.215459, 1.224273},
{-0.921600, -0.209020, -0.126696, 0.007996, -0.092074, 0.995697, 0.119765, 1.221520},
{-0.867367, -0.241203, -0.130918, 0.004456, -0.150517, 0.988586, 0.210193, 1.370139},
{-0.867466, -0.209136, -0.127064, 0.004669, -0.090670, 0.995849, 0.115163, 1.367121},
{-0.921539, -0.172189, -0.124378, 0.009369, -0.044862, 0.998932, 0.010721, 1.218573},
{-0.972234, -0.171755, -0.123765, 0.013306, -0.045473, 0.998871, 0.014055, 1.082186},
{-0.867522, -0.172419, -0.124808, 0.004944, -0.044496, 0.998993, 0.006468, 1.363871},
{-0.867567, -0.124677, -0.123525, 0.004028, -0.020814, 0.999756, -0.116290, 1.360275},
{-0.921465, -0.124475, -0.123099, 0.009278, -0.019562, 0.999756, -0.111968, 1.215300},
{-0.972028, -0.124267, -0.122499, 0.013062, -0.018586, 0.999725, -0.107979, 1.079289},
{-1.012796, -0.170870, -0.123066, -0.016511, -0.043977, 0.998871, 0.015119, 0.973010},
{-1.012616, -0.124021, -0.121906, -0.017518, -0.017335, 0.999695, -0.105016, 0.970099},
{-0.816778, -0.241196, -0.131046, 0.001831, -0.151280, 0.988464, 0.205539, 1.506193},
{-0.766155, -0.241162, -0.131085, 0.001068, -0.153478, 0.988128, 0.200796, 1.642333},
{-0.766426, -0.209519, -0.127234, -0.000519, -0.092227, 0.995727, 0.107037, 1.638887},
{-0.816941, -0.209369, -0.127226, 0.001282, -0.090762, 0.995849, 0.111227, 1.503024},
{-0.711814, -0.240976, -0.131130, 0.016694, -0.158818, 0.987152, 0.195264, 1.788460},
{-0.712326, -0.209387, -0.127141, 0.011170, -0.095798, 0.995331, 0.101677, 1.784369},
{-0.712535, -0.172715, -0.124787, 0.007813, -0.046632, 0.998871, -0.006873, 1.780708},
{-0.766488, -0.172846, -0.124923, -0.001434, -0.045991, 0.998932, -0.001531, 1.635622},
{-0.712497, -0.124869, -0.123419, 0.007843, -0.022065, 0.999725, -0.129955, 1.777324},
{-0.766385, -0.125018, -0.123502, -0.001526, -0.023164, 0.999725, -0.124564, 1.632416},
{-0.816995, -0.172692, -0.124960, 0.000732, -0.045137, 0.998962, 0.002650, 1.499782},
{-0.816975, -0.124906, -0.123598, -0.000580, -0.022462, 0.999725, -0.120249, 1.496357},
{-1.009225, -0.089597, -0.291194, -0.032777, -0.024720, -0.999146, 1.563599, 1.819430},
{-0.969103, -0.086798, -0.292519, -0.027833, -0.026795, -0.999237, 1.555227, 1.711533},
{-0.969101, -0.135088, -0.290858, -0.028382, -0.039460, -0.998810, 1.698063, 1.711321},
{-1.009148, -0.137182, -0.289590, -0.031922, -0.044923, -0.998474, 1.704348, 1.819022},
{-1.009290, -0.030492, -0.292126, -0.038972, -0.008362, -0.999176, 1.407239, 1.819803},
{-0.969137, -0.027145, -0.293732, -0.032777, -0.012085, -0.999359, 1.397254, 1.711832},
{-0.920508, -0.083731, -0.293667, -0.014496, -0.027650, -0.999512, 1.546034, 1.580834},
{-0.920556, -0.132640, -0.292060, -0.015778, -0.034272, -0.999268, 1.690701, 1.580755},
{-0.920482, -0.023542, -0.295041, -0.017426, -0.015442, -0.999725, 1.386478, 1.580978},
{-0.868063, -0.021055, -0.295464, 0.005921, -0.018067, -0.999817, 1.378965, 1.439966},
{-0.868100, -0.081497, -0.293999, 0.007752, -0.027833, -0.999573, 1.539269, 1.439845},
{-0.868172, -0.130717, -0.292470, 0.007019, -0.030641, -0.999481, 1.684855, 1.439833},
{-0.920599, -0.169663, -0.290763, -0.020844, -0.033723, -0.999207, 1.800209, 1.580710},
{-0.969164, -0.171831, -0.289225, -0.035340, -0.044771, -0.998352, 1.806731, 1.711320},
{-0.868240, -0.167883, -0.291394, 0.003754, -0.025422, -0.999664, 1.794793, 1.439865},
{-1.009151, -0.173459, -0.287515, -0.038606, -0.057039, -0.997620, 1.811627, 1.818846},
{-0.816537, -0.081196, -0.292876, 0.026917, -0.027741, -0.999237, 1.538183, 1.301078},
{-0.764433, -0.082333, -0.291153, 0.029298, -0.025849, -0.999207, 1.541331, 1.160834},
{-0.764475, -0.130825, -0.289728, 0.025636, -0.024842, -0.999359, 1.684771, 1.160746},
{-0.816608, -0.130195, -0.291361, 0.026002, -0.028382, -0.999237, 1.683117, 1.301067},
{-0.816618, -0.021054, -0.294411, 0.026887, -0.019349, -0.999420, 1.378771, 1.301519},
{-0.764713, -0.022729, -0.292626, 0.033082, -0.018067, -0.999268, 1.383510, 1.161804},
{-0.710405, -0.084411, -0.289683, 0.036775, -0.021027, -0.999084, 1.547268, 1.015415},
{-0.710379, -0.132358, -0.288569, 0.031190, -0.019105, -0.999329, 1.689101, 1.015159},
{-0.710913, -0.025266, -0.290848, 0.043855, -0.013581, -0.998932, 1.390797, 1.016990},
{-0.711095, -0.168649, -0.288086, 0.027314, -0.007813, -0.999573, 1.796468, 1.016954},
{-0.764994, -0.167816, -0.288894, 0.021821, -0.013550, -0.999664, 1.794198, 1.161999},
{-0.816874, -0.167414, -0.290384, 0.023652, -0.019440, -0.999512, 1.793214, 1.301631},
{-1.175550, 0.325984, -0.252038, -0.994385, -0.000244, -0.105808, 1.731162, -1.066219},
{-1.175635, 0.308634, -0.254473, -0.993896, 0.058657, -0.093387, 1.739393, -1.019677},
{-1.175967, 0.300526, -0.224055, -0.998108, 0.059816, -0.013672, 1.650080, -0.996216},
{-1.175819, 0.319644, -0.223425, -0.999023, -0.022858, -0.037111, 1.647079, -1.047615},
{-1.171785, 0.329303, -0.271346, -0.852382, 0.138615, -0.504166, 1.802339, -1.076727},
{-1.171725, 0.313567, -0.275663, -0.859767, 0.123997, -0.495346, 1.817600, -1.036100},
{-1.177595, 0.286701, -0.256222, -0.989990, 0.073305, -0.120365, 1.745474, -0.960713},
{-1.179018, 0.277568, -0.223518, -0.995575, 0.093417, -0.009217, 1.649240, -0.934340},
{-1.172171, 0.292870, -0.279183, -0.842647, 0.070986, -0.533738, 1.832295, -0.982590},
{-1.172461, 0.253753, -0.280711, -0.810358, 0.006836, -0.585864, 1.841267, -0.896138},
{-1.179642, 0.246476, -0.256809, -0.984100, 0.026582, -0.175512, 1.748849, -0.869292},
{-1.182457, 0.236448, -0.222695, -0.998321, 0.044221, -0.037294, 1.648207, -0.840395},
{-1.180092, 0.265219, -0.184339, -0.992920, 0.087924, 0.079836, 1.534181, -0.898975},
{-1.177805, 0.287353, -0.186113, -0.997314, 0.053652, 0.049532, 1.538553, -0.958680},
{-1.183005, 0.224988, -0.182809, -0.995514, 0.046876, 0.082156, 1.531119, -0.807400},
{-1.177559, 0.214880, -0.150213, -0.863857, 0.035768, 0.502426, 1.405809, -0.772354},
{-1.175783, 0.253866, -0.151634, -0.871181, 0.074160, 0.485305, 1.409710, -0.859113},
{-1.174641, 0.274866, -0.153494, -0.887997, 0.050600, 0.457015, 1.415919, -0.914106},
{-1.177857, 0.307480, -0.186073, -0.999603, -0.014801, 0.023804, 1.537184, -1.012818},
{-1.174478, 0.296000, -0.153356, -0.892361, -0.000153, 0.451277, 1.414382, -0.969925},
{-1.179989, 0.174250, -0.255758, -0.975433, -0.001068, -0.220161, 1.748963, -0.725376},
{-1.179960, 0.089244, -0.254356, -0.968596, 0.003296, -0.248573, 1.748527, -0.563882},
{-1.184526, 0.076426, -0.222386, -0.995911, 0.014496, -0.088931, 1.654000, -0.527543},
{-1.183767, 0.162845, -0.222468, -0.997650, 0.012146, -0.067049, 1.650626, -0.692788},
{-1.171933, 0.182761, -0.279052, -0.784845, -0.018891, -0.619373, 1.839362, -0.756689},
{-1.171337, 0.099128, -0.276860, -0.772759, -0.008728, -0.634602, 1.835570, -0.599898},
{-1.180884, 0.010675, -0.253893, -0.963561, 0.013550, -0.267037, 1.750256, -0.419729},
{-1.186313, -0.003141, -0.222001, -0.994385, 0.021058, -0.103610, 1.655831, -0.380685},
{-1.171424, 0.022091, -0.276785, -0.768059, 0.007569, -0.640309, 1.838885, -0.461422},
{-1.188541, -0.014938, -0.185985, -0.998260, 0.023530, 0.053682, 1.549814, -0.346940},
{-1.186404, 0.063443, -0.185141, -0.998047, 0.020417, 0.058718, 1.544505, -0.490555},
{-1.184106, -0.024516, -0.156360, -0.874660, 0.011872, 0.484542, 1.438002, -0.315845},
{-1.181843, 0.052134, -0.154285, -0.872677, 0.010315, 0.488144, 1.427526, -0.453242},
{-1.184834, 0.150574, -0.183579, -0.997284, 0.018983, 0.070803, 1.536417, -0.657650},
{-1.179619, 0.139784, -0.151666, -0.866573, 0.010834, 0.498886, 1.414271, -0.621238},
{-0.536886, 0.009155, -0.251529, 0.833735, 0.002411, -0.552141, 1.342747, 0.547561},
{-0.537321, 0.088960, -0.251667, 0.820917, 0.001679, -0.571032, 1.180593, 0.548909},
{-0.524539, 0.079445, -0.224791, 0.981750, -0.001038, -0.190100, 1.211312, 0.493817},
{-0.525196, -0.001367, -0.224929, 0.984252, -0.008759, -0.176519, 1.377973, 0.496658},
{-0.526379, -0.071515, -0.225254, 0.987030, -0.014435, -0.159825, 1.534640, 0.501786},
{-0.536827, -0.060745, -0.251734, 0.851283, -0.000946, -0.524644, 1.496154, 0.546795},
{-0.553002, 0.018664, -0.268368, 0.625721, 0.009827, -0.779962, 1.315145, 0.591488},
{-0.554606, 0.097304, -0.268751, 0.610706, -0.000305, -0.791833, 1.156453, 0.595988},
{-0.538171, 0.174687, -0.252607, 0.823817, 0.003204, -0.566820, 1.000942, 0.551421},
{-0.525016, 0.166999, -0.224948, 0.980743, 0.010712, -0.194983, 1.024663, 0.495552},
{-0.555678, 0.181184, -0.270506, 0.614704, -0.010010, -0.788690, 0.982291, 0.599115},
{-0.556492, 0.251556, -0.272516, 0.635365, -0.007294, -0.772149, 0.784904, 0.595961},
{-0.539546, 0.246918, -0.253701, 0.840938, 0.020203, -0.540696, 0.812543, 0.554513},
{-0.526737, 0.241135, -0.225207, 0.981658, 0.042604, -0.185644, 0.828020, 0.499574},
{-0.526502, 0.160470, -0.188994, 0.981689, 0.008332, 0.190222, 1.978100, 0.022943},
{-0.526591, 0.072143, -0.188884, 0.980468, -0.004181, 0.196570, 1.974058, -0.147411},
{-0.524539, 0.079445, -0.224791, 0.981750, -0.001038, -0.190100, 2.097190, -0.132912},
{-0.525016, 0.166999, -0.224948, 0.980743, 0.010712, -0.194983, 2.099897, 0.036794},
{-0.526737, 0.241135, -0.225207, 0.981658, 0.042604, -0.185644, 2.116977, 0.174212},
{-0.527726, 0.235574, -0.189332, 0.982116, 0.044710, 0.182836, 1.981623, 0.174518},
{-0.538406, 0.230656, -0.157431, 0.850429, 0.036500, 0.524766, 1.861956, 0.161988},
{-0.537985, 0.154953, -0.156612, 0.847896, 0.005799, 0.530106, 1.856303, 0.009093},
{-0.538460, 0.066229, -0.156193, 0.850887, -0.002014, 0.525315, 1.850927, -0.161911},
{-0.527413, -0.008652, -0.189126, 0.980926, -0.012604, 0.193854, 1.971038, -0.297525},
{-0.525196, -0.001367, -0.224929, 0.984252, -0.008759, -0.176519, 2.093913, -0.284449},
{-0.538786, -0.014218, -0.156376, 0.861110, -0.007813, 0.508347, 1.848163, -0.310601},
{-0.541552, 0.286234, -0.254300, 0.861415, 0.065523, -0.503586, 2.164340, 0.290351},
{-0.543381, 0.307010, -0.253557, 0.870693, 0.118351, -0.477309, 2.162310, 0.346272},
{-0.532921, 0.303626, -0.225143, 0.982116, 0.123936, -0.141575, 2.085938, 0.338781},
{-0.529815, 0.281691, -0.225373, 0.981536, 0.100986, -0.162297, 2.087170, 0.279777},
{-0.539546, 0.246918, -0.253701, 0.840938, 0.020203, -0.540696, 2.163370, 0.228888},
{-0.556492, 0.251556, -0.272516, 0.635365, -0.007294, -0.772149, 2.224421, 0.242192},
{-0.557321, 0.289671, -0.273665, 0.661336, 0.033235, -0.749321, 2.228055, 0.300469},
{-0.557888, 0.309290, -0.272535, 0.673269, 0.145604, -0.724876, 2.225352, 0.352211},
{-0.544224, 0.323619, -0.250626, 0.865505, 0.143590, -0.479812, 2.154277, 0.391109},
{-0.534729, 0.321896, -0.224213, 0.986358, 0.098575, -0.131657, 2.083233, 0.387974},
{-0.557913, 0.324173, -0.267705, 0.654317, 0.250618, -0.713431, 2.209973, 0.390882},
{-0.536887, 0.317530, -0.189641, 0.974700, 0.105228, 0.197089, 1.981490, 0.378114},
{-0.534382, 0.298973, -0.189990, 0.972503, 0.135533, 0.189215, 1.982906, 0.328186},
{-0.546638, 0.312588, -0.158855, 0.857173, 0.099551, 0.505234, 1.864398, 0.364893},
{-0.543906, 0.294288, -0.159108, 0.853328, 0.124332, 0.506272, 1.866543, 0.316039},
{-0.530840, 0.276698, -0.189775, 0.976653, 0.110996, 0.183874, 1.983088, 0.268293},
{-0.540771, 0.272039, -0.158448, 0.851680, 0.096194, 0.515091, 1.865549, 0.256354},
{-1.158495, 0.291714, -0.138650, -0.446547, 0.006623, 0.894711, -1.042811, 0.551451},
{-1.159963, 0.268815, -0.139042, -0.449049, 0.029054, 0.893002, -0.974941, 0.549413},
{-1.133216, 0.266507, -0.133569, -0.162450, 0.002533, 0.986694, -0.970877, 0.621409},
{-1.130740, 0.290705, -0.133223, -0.151891, 0.021882, 0.988128, -1.042676, 0.626051},
{-1.174478, 0.296000, -0.153356, -0.892361, -0.000153, 0.451277, -1.042486, 0.491598},
{-1.174641, 0.274866, -0.153494, -0.887997, 0.050600, 0.457015, -0.981144, 0.494349},
{-1.161062, 0.247726, -0.138349, -0.421613, 0.035890, 0.906034, -0.912518, 0.548192},
{-1.134541, 0.244650, -0.134105, -0.149174, -0.004669, 0.988769, -0.906094, 0.619672},
{-1.175783, 0.253866, -0.151634, -0.871181, 0.074160, 0.485305, -0.920943, 0.494389},
{-1.177559, 0.214880, -0.150213, -0.863857, 0.035768, 0.502426, -0.825705, 0.493173},
{-1.162391, 0.208907, -0.137971, -0.399823, 0.009705, 0.916532, -0.816111, 0.547310},
{-1.135677, 0.204948, -0.134771, -0.137730, -0.006287, 0.990417, -0.807033, 0.619409},
{-1.094834, 0.242494, -0.128522, -0.127995, -0.017243, 0.991607, -0.903671, 0.726505},
{-1.093842, 0.265250, -0.127885, -0.123447, 0.004852, 0.992309, -0.971089, 0.727271},
{-1.095588, 0.200880, -0.129301, -0.129460, -0.007019, 0.991546, -0.798989, 0.727431},
{-1.051439, 0.197875, -0.124146, -0.088900, -0.007874, 0.996002, -0.794439, 0.846291},
{-1.051066, 0.241124, -0.123407, -0.094150, -0.021332, 0.995300, -0.903923, 0.844205},
{-1.050582, 0.264453, -0.122957, -0.093661, 0.016388, 0.995453, -0.972975, 0.843561},
{-1.092043, 0.289055, -0.128341, -0.102481, 0.064241, 0.992645, -1.041620, 0.730143},
{-1.049985, 0.287245, -0.124304, -0.077303, 0.109806, 0.990936, -1.040350, 0.843306},
{-1.164552, 0.132819, -0.139306, -0.407422, -0.006043, 0.913205, -0.646289, 0.546290},
{-1.167089, 0.044335, -0.141485, -0.429518, -0.009125, 0.902982, -0.458211, 0.544788},
{-1.139868, 0.037271, -0.136539, -0.174352, -0.011170, 0.984619, -0.440096, 0.618462},
{-1.137585, 0.127214, -0.135505, -0.149571, -0.006806, 0.988708, -0.632402, 0.619190},
{-1.179619, 0.139784, -0.151666, -0.866573, 0.010834, 0.498886, -0.659250, 0.492161},
{-1.181843, 0.052134, -0.154285, -0.872677, 0.010315, 0.488144, -0.474050, 0.490990},
{-1.169546, -0.031673, -0.143641, -0.442793, -0.009095, 0.896542, -0.307035, 0.542463},
{-1.142133, -0.039062, -0.138108, -0.192022, -0.014985, 0.981262, -0.288009, 0.616670},
{-1.184106, -0.024516, -0.156360, -0.874660, 0.011872, 0.484542, -0.322578, 0.489297},
{-1.099138, -0.049338, -0.130038, -0.164739, -0.010651, 0.986267, -0.262018, 0.732960},
{-1.097910, 0.028166, -0.129243, -0.152745, -0.003388, 0.988250, -0.417430, 0.731887},
{-1.052097, -0.057951, -0.123176, -0.096561, -0.007355, 0.995270, -0.241248, 0.860023},
{-1.051904, 0.020900, -0.122995, -0.090823, 0.001160, 0.995849, -0.400512, 0.856070},
{-1.096670, 0.120505, -0.129269, -0.138218, 0.001190, 0.990387, -0.616664, 0.729635},
{-1.051702, 0.115321, -0.123663, -0.087130, 0.004791, 0.996185, -0.605773, 0.850869},
{-1.157102, 0.026692, -0.285805, -0.314097, 0.005432, -0.949339, 1.293804, 2.217417},
{-1.157286, 0.103309, -0.285711, -0.309153, -0.012970, -0.950896, 1.141075, 2.218074},
{-1.132742, 0.105663, -0.287505, -0.048036, -0.009522, -0.998779, 1.134085, 2.152102},
{-1.132624, 0.028745, -0.287661, -0.054170, 0.004883, -0.998505, 1.287706, 2.151625},
{-1.171424, 0.022091, -0.276785, -0.768059, 0.007569, -0.640309, 1.297325, 2.262421},
{-1.171337, 0.099128, -0.276860, -0.772759, -0.008728, -0.634602, 1.145003, 2.263112},
{-1.158034, 0.186346, -0.287958, -0.306467, -0.027375, -0.951476, 0.969423, 2.220343},
{-1.133323, 0.188313, -0.289293, -0.033204, -0.022279, -0.999176, 0.963562, 2.153905},
{-1.171933, 0.182761, -0.279052, -0.784845, -0.018891, -0.619373, 0.972747, 2.265541},
{-1.172461, 0.253753, -0.280711, -0.810358, 0.006836, -0.585864, 0.819496, 2.268020},
{-1.158815, 0.256964, -0.289961, -0.323222, -0.005066, -0.946287, 0.816013, 2.222671},
{-1.133937, 0.258567, -0.291123, -0.024110, -0.006897, -0.999664, 0.811226, 2.155780},
{-1.092829, 0.191971, -0.289876, -0.011017, -0.012482, -0.999847, 0.952628, 2.044986},
{-1.092641, 0.110066, -0.288841, -0.026765, -0.004944, -0.999603, 1.120969, 2.044264},
{-1.093064, 0.261018, -0.290758, 0.008942, 0.003998, -0.999939, 0.803834, 2.045804},
{-1.047584, 0.263470, -0.290263, -0.005493, 0.021668, -0.999725, 0.796423, 1.923432},
{-1.047676, 0.195866, -0.290456, -0.021943, -0.001801, -0.999756, 0.940978, 1.923531},
{-1.047826, 0.114825, -0.290158, -0.033845, -0.000580, -0.999420, 1.106786, 1.923745},
{-1.092696, 0.032518, -0.289062, -0.031587, 0.003998, -0.999481, 1.276454, 2.044253},
{-1.048008, 0.036792, -0.290429, -0.036653, 0.002808, -0.999298, 1.263708, 1.924076},
{-1.159096, 0.296328, -0.289132, -0.364177, 0.075777, -0.928220, 0.718012, 2.223506},
{-1.159152, 0.317216, -0.285922, -0.400159, 0.203162, -0.893613, 0.656116, 2.223621},
{-1.134220, 0.319809, -0.288861, -0.065065, 0.190863, -0.979430, 0.648451, 2.156644},
{-1.134157, 0.298296, -0.291091, -0.034547, 0.060945, -0.997528, 0.712166, 2.156478},
{-1.172171, 0.292870, -0.279183, -0.842647, 0.070986, -0.533738, 0.724191, 2.268862},
{-1.171725, 0.313567, -0.275663, -0.859767, 0.123997, -0.495346, 0.664929, 2.268941},
{-1.159257, 0.332407, -0.280782, -0.400281, 0.294076, -0.867916, 0.611023, 2.223788},
{-1.134362, 0.335412, -0.284097, -0.099979, 0.301737, -0.948119, 0.602148, 2.156925},
{-1.171785, 0.329303, -0.271346, -0.852382, 0.138615, -0.504166, 0.619812, 2.269131},
{-1.093498, 0.338435, -0.285043, -0.024842, 0.208045, -0.977783, 0.593101, 2.047019},
{-1.093236, 0.321573, -0.288094, 0.011902, 0.137333, -0.990448, 0.643080, 2.046355},
{-1.048144, 0.340436, -0.285197, -0.014924, 0.110019, -0.993805, 0.587040, 1.925003},
{-1.047731, 0.322391, -0.286429, 0.005829, 0.091647, -0.995758, 0.640469, 1.923872},
{-1.093145, 0.299993, -0.290082, 0.022065, 0.058290, -0.998047, 0.706987, 2.046106},
{-1.047573, 0.301190, -0.288519, 0.007965, 0.070223, -0.997497, 0.703258, 1.923447},
{-0.615061, 0.295778, -0.130667, 0.120579, 0.098910, 0.987732, -1.105127, 2.012403},
{-0.614283, 0.276083, -0.129190, 0.136387, 0.060488, 0.988800, -1.047042, 2.016096},
{-0.579716, 0.285688, -0.135952, 0.236671, 0.066073, 0.969329, -1.078236, 2.108420},
{-0.581233, 0.304443, -0.136920, 0.224128, 0.062624, 0.972533, -1.133501, 2.102806},
{-0.659134, 0.287495, -0.125574, 0.069277, 0.132115, 0.988800, -1.076872, 1.894446},
{-0.658849, 0.266912, -0.123783, 0.081851, 0.050172, 0.995361, -1.016135, 1.896879},
{-0.614247, 0.253576, -0.128155, 0.132633, 0.029878, 0.990692, -0.980548, 2.018036},
{-0.579126, 0.263279, -0.134536, 0.235206, 0.048097, 0.970733, -1.012106, 2.111833},
{-0.658917, 0.244450, -0.123452, 0.076052, 0.005097, 0.997070, -0.949728, 1.898551},
{-0.659230, 0.201627, -0.123622, 0.061129, -0.000092, 0.998108, -0.841542, 1.900750},
{-0.614644, 0.211019, -0.127326, 0.119572, 0.013092, 0.992737, -0.873200, 2.019962},
{-0.579196, 0.221193, -0.133023, 0.229072, 0.022645, 0.973113, -0.906218, 2.114584},
{-0.555750, 0.268500, -0.142335, 0.528428, 0.069582, 0.846095, -1.029253, 2.174447},
{-0.557637, 0.290808, -0.143510, 0.534135, 0.089480, 0.840632, -1.094980, 2.167549},
{-0.554673, 0.226801, -0.140860, 0.522904, 0.029023, 0.851894, -0.924610, 2.180251},
{-0.538406, 0.230656, -0.157431, 0.850429, 0.036500, 0.524766, -0.935690, 2.231442},
{-0.540771, 0.272039, -0.158448, 0.851680, 0.096194, 0.515091, -1.039195, 2.221471},
{-0.543906, 0.294288, -0.159108, 0.853328, 0.124332, 0.506272, -1.104498, 2.210080},
{-0.559923, 0.309136, -0.143798, 0.533097, 0.066591, 0.843410, -1.148949, 2.159887},
{-0.546638, 0.312588, -0.158855, 0.857173, 0.099551, 0.505234, -1.157933, 2.200308},
{-0.615166, 0.131178, -0.126467, 0.107791, 0.007660, 0.994140, -0.692550, 2.023608},
{-0.615335, 0.038606, -0.125881, 0.100742, 0.003204, 0.994903, -0.492758, 2.028747},
{-0.579715, 0.052774, -0.130945, 0.225196, 0.005463, 0.974273, -0.537638, 2.123484},
{-0.579657, 0.143408, -0.131759, 0.224708, 0.010315, 0.974364, -0.731677, 2.118213},
{-0.659676, 0.119958, -0.123331, 0.049440, 0.003327, 0.998749, -0.655465, 1.904763},
{-0.660050, 0.025626, -0.123076, 0.043001, -0.000183, 0.999054, -0.450430, 1.909507},
{-0.614674, -0.042139, -0.125868, 0.097354, -0.004395, 0.995209, -0.327980, 2.035152},
{-0.578578, -0.027856, -0.130781, 0.230323, -0.001740, 0.973083, -0.373251, 2.131156},
{-0.660141, -0.055186, -0.123353, 0.038667, -0.007904, 0.999207, -0.285369, 1.913900},
{-0.554561, -0.019585, -0.138939, 0.549516, -0.002411, 0.835475, -0.399458, 2.195249},
{-0.555129, 0.060877, -0.138964, 0.531785, 0.003479, 0.846828, -0.563405, 2.189119},
{-0.538786, -0.014218, -0.156376, 0.861110, -0.007813, 0.508347, -0.416133, 2.243385},
{-0.538460, 0.066229, -0.156193, 0.850887, -0.002014, 0.525315, -0.579617, 2.240204},
{-0.554816, 0.150299, -0.139670, 0.522629, 0.008545, 0.852504, -0.753892, 2.184631},
{-0.537985, 0.154953, -0.156612, 0.847896, 0.005799, 0.530106, -0.767650, 2.236955},
{-0.614900, 0.032844, -0.282738, 0.134495, 0.000885, -0.990905, 1.273801, 0.758529},
{-0.616457, 0.110070, -0.283026, 0.133885, -0.008484, -0.990936, 1.119286, 0.762895},
{-0.582936, 0.104090, -0.277843, 0.148015, -0.009339, -0.988922, 1.136723, 0.672522},
{-0.581034, 0.026208, -0.277533, 0.152165, 0.002747, -0.988342, 1.293177, 0.667226},
{-0.660243, 0.039941, -0.288167, 0.090274, -0.002838, -0.995911, 1.253101, 0.880721},
{-0.661379, 0.116578, -0.288519, 0.091678, -0.008362, -0.995727, 1.100331, 0.883953},
{-0.617523, 0.191297, -0.284467, 0.127110, -0.017579, -0.991699, 0.952965, 0.765987},
{-0.584115, 0.186518, -0.279529, 0.137761, -0.021699, -0.990204, 0.966857, 0.675929},
{-0.662271, 0.196532, -0.289679, 0.086276, -0.012757, -0.996185, 0.937766, 0.886565},
{-0.662942, 0.262483, -0.290563, 0.076205, 0.001068, -0.997070, 0.798136, 0.888550},
{-0.618234, 0.258769, -0.285903, 0.115879, -0.012238, -0.993164, 0.808849, 0.768100},
{-0.584829, 0.255385, -0.281415, 0.123783, -0.022919, -0.992035, 0.818625, 0.678070},
{-0.567247, 0.184137, -0.277178, 0.322275, -0.020386, -0.946410, 0.973781, 0.630462},
{-0.566065, 0.101091, -0.275280, 0.328532, -0.006378, -0.944456, 1.145471, 0.627039},
{-0.567918, 0.253680, -0.279353, 0.321482, -0.023774, -0.946593, 0.823560, 0.632498},
{-0.564060, 0.022915, -0.274889, 0.338908, 0.007233, -0.940764, 1.302790, 0.621461},
{-0.618727, 0.294730, -0.286177, 0.106479, 0.028077, -0.993896, 0.720949, 0.769531},
{-0.618972, 0.313298, -0.285084, 0.115421, 0.116214, -0.986480, 0.665979, 0.770213},
{-0.585551, 0.311731, -0.281193, 0.130802, 0.161260, -0.978179, 0.670397, 0.680166},
{-0.585338, 0.292587, -0.282322, 0.114750, 0.019959, -0.993164, 0.727075, 0.679566},
{-0.663416, 0.297108, -0.290082, 0.066805, 0.040864, -0.996918, 0.714167, 0.889901},
{-0.663724, 0.315037, -0.288926, 0.068728, 0.076113, -0.994720, 0.661086, 0.890748},
{-0.618935, 0.328592, -0.282421, 0.148717, 0.207495, -0.966857, 0.620650, 0.770078},
{-0.585381, 0.326430, -0.276971, 0.173009, 0.307016, -0.935820, 0.626785, 0.679619},
{-0.663894, 0.330899, -0.287782, 0.087161, 0.111759, -0.989898, 0.614121, 0.891220},
{-0.568336, 0.325034, -0.274276, 0.355144, 0.335246, -0.872616, 0.630784, 0.633670},
{-0.568567, 0.310630, -0.279378, 0.343425, 0.177831, -0.922178, 0.673550, 0.634408},
{-0.557913, 0.324173, -0.267705, 0.654317, 0.250618, -0.713431, 0.633716, 0.609975},
{-0.557888, 0.309290, -0.272535, 0.673269, 0.145604, -0.724876, 0.676071, 0.610797},
{-0.568393, 0.291345, -0.280579, 0.327616, 0.019776, -0.944578, 0.730646, 0.633916},
{-0.557321, 0.289671, -0.273665, 0.661336, 0.033235, -0.749321, 0.732940, 0.610424},
{-0.921419, -0.059536, -0.122307, 0.007294, -0.008728, 0.999908, -0.248596, 1.211571},
{-0.921394, 0.021127, -0.121891, 0.003937, -0.003143, 0.999969, -0.413218, 1.207010},
{-0.971734, 0.020450, -0.121581, 0.006745, -0.000549, 0.999969, -0.406615, 1.071677},
{-0.971857, -0.059793, -0.121806, 0.011078, -0.006928, 0.999908, -0.243237, 1.075937},
{-0.867637, -0.059537, -0.122593, 0.001648, -0.010834, 0.999939, -0.253511, 1.356217},
{-0.867699, 0.021373, -0.121995, -0.000671, -0.004822, 0.999969, -0.418867, 1.351396},
{-0.921383, 0.116017, -0.121740, 0.000061, -0.004975, 0.999969, -0.619894, 1.201237},
{-0.971672, 0.115248, -0.121718, -0.000824, -0.001495, 0.999969, -0.613006, 1.066055},
{-0.867724, 0.116428, -0.121715, -0.001556, -0.006134, 0.999969, -0.626032, 1.345509},
{-0.867730, 0.198885, -0.120850, -0.000946, -0.031648, 0.999481, -0.814462, 1.340186},
{-0.921372, 0.198345, -0.120951, -0.003357, -0.030671, 0.999512, -0.807940, 1.195971},
{-0.971619, 0.197585, -0.121255, -0.010743, -0.024751, 0.999634, -0.801065, 1.060911},
{-1.012574, 0.114292, -0.121753, -0.026032, 0.002991, 0.999634, -0.606426, 0.956137},
{-1.012542, 0.019351, -0.121195, -0.019593, 0.001679, 0.999786, -0.399643, 0.962015},
{-1.012545, 0.197102, -0.121892, -0.037812, -0.015046, 0.999146, -0.795848, 0.950901},
{-1.012543, -0.060350, -0.121264, -0.017914, -0.006104, 0.999817, -0.237888, 0.966552},
{-0.921349, 0.241321, -0.118618, -0.005860, -0.057527, 0.998321, -0.916672, 1.192930},
{-0.921304, 0.263909, -0.117151, -0.007599, 0.011200, 0.999878, -0.983550, 1.191141},
{-0.971472, 0.263124, -0.117927, -0.027467, 0.012726, 0.999512, -0.976583, 1.056306},
{-0.971523, 0.240445, -0.119228, -0.020936, -0.049104, 0.998566, -0.909444, 1.058083},
{-0.867735, 0.242004, -0.118500, 0.000275, -0.058077, 0.998291, -0.923614, 1.337057},
{-0.867673, 0.264524, -0.117069, 0.001831, 0.013642, 0.999878, -0.990295, 1.335321},
{-0.921228, 0.285071, -0.118961, -0.006714, 0.160558, 0.986999, -1.046034, 1.189633},
{-0.971555, 0.284918, -0.119637, -0.026002, 0.151555, 0.988098, -1.040925, 1.054314},
{-0.867478, 0.285188, -0.118964, 0.003754, 0.165929, 0.986114, -1.051308, 1.334175},
{-1.012149, 0.285754, -0.121410, -0.053285, 0.138188, 0.988952, -1.039574, 0.945117},
{-1.012179, 0.263525, -0.119749, -0.059572, 0.017945, 0.998047, -0.973933, 0.946843},
{-1.012362, 0.240410, -0.120567, -0.051851, -0.033540, 0.998077, -0.905521, 0.948287},
{-0.712269, -0.059752, -0.122391, 0.010468, -0.011048, 0.999878, -0.267140, 1.774068},
{-0.711919, 0.021086, -0.121835, 0.014039, -0.002960, 0.999878, -0.432316, 1.770360},
{-0.765870, 0.020949, -0.121588, 0.000763, -0.004700, 0.999969, -0.426977, 1.625275},
{-0.766160, -0.059915, -0.122323, -0.000824, -0.012848, 0.999908, -0.261718, 1.629148},
{-0.711520, 0.116098, -0.121886, 0.018342, -0.000305, 0.999817, -0.639376, 1.765625},
{-0.765573, 0.116059, -0.121499, 0.003906, -0.003082, 0.999969, -0.634326, 1.620251},
{-0.711163, 0.198363, -0.121764, 0.026673, -0.012726, 0.999542, -0.827231, 1.761312},
{-0.765330, 0.198349, -0.121062, 0.009888, -0.022614, 0.999664, -0.822259, 1.615623},
{-0.816715, 0.116306, -0.121538, -0.001556, -0.005219, 0.999969, -0.630360, 1.482696},
{-0.816827, 0.021180, -0.121768, -0.003204, -0.005371, 0.999969, -0.422974, 1.488219},
{-0.816617, 0.198704, -0.120822, 0.002167, -0.028962, 0.999573, -0.818619, 1.477658},
{-0.816916, -0.059753, -0.122495, -0.002411, -0.012574, 0.999908, -0.257530, 1.492637},
{-0.710940, 0.240962, -0.120692, 0.039125, -0.020508, 0.998993, -0.934795, 1.758868},
{-0.710922, 0.263090, -0.120289, 0.046876, 0.036531, 0.998230, -1.000253, 1.757073},
{-0.765248, 0.262648, -0.118279, 0.025605, 0.024415, 0.999359, -0.994074, 1.610960},
{-0.765199, 0.240751, -0.119284, 0.018494, -0.041108, 0.998962, -0.929272, 1.612934},
{-0.711175, 0.283943, -0.122175, 0.042940, 0.151219, 0.987548, -1.061786, 1.754705},
{-0.765549, 0.283424, -0.120163, 0.026765, 0.160283, 0.986694, -1.055377, 1.608472},
{-0.816617, 0.284239, -0.119229, 0.013794, 0.165258, 0.986145, -1.053153, 1.471042},
{-0.816577, 0.263615, -0.117326, 0.011109, 0.017304, 0.999786, -0.992279, 1.472818},
{-0.816574, 0.241455, -0.118637, 0.006623, -0.053224, 0.998535, -0.926679, 1.474695},
{-0.920592, 0.338735, -0.287971, -0.012574, 0.104038, -0.994476, 0.591752, 1.581903},
{-0.920562, 0.322271, -0.288887, -0.019684, 0.092074, -0.995544, 0.640491, 1.581799},
{-0.969575, 0.321786, -0.287829, -0.025758, 0.076327, -0.996734, 0.642050, 1.713634},
{-0.970046, 0.339422, -0.287258, -0.018342, 0.081484, -0.996490, 0.589854, 1.714940},
{-0.970875, 0.352583, -0.285563, 0.004089, 0.401746, -0.915708, 0.540707, 1.716494},
{-0.920659, 0.350911, -0.285983, 0.001282, 0.429456, -0.903073, 0.546824, 1.581971},
{-0.867311, 0.349313, -0.286713, -0.012207, 0.407971, -0.912900, 0.552736, 1.438857},
{-0.867766, 0.337837, -0.288688, -0.016175, 0.108768, -0.993927, 0.594261, 1.439795},
{-0.868036, 0.322330, -0.289804, -0.014557, 0.099155, -0.994964, 0.640179, 1.440506},
{-0.920490, 0.303247, -0.291438, -0.024934, 0.102329, -0.994415, 0.696854, 1.581626},
{-0.969271, 0.302106, -0.290089, -0.031220, 0.091647, -0.995300, 0.700345, 1.712827},
{-0.868120, 0.303868, -0.292484, -0.012665, 0.106143, -0.994263, 0.694881, 1.440761},
{-0.868122, 0.269150, -0.295203, -0.010620, 0.046510, -0.998840, 0.779192, 1.440762},
{-0.920439, 0.268090, -0.294094, -0.027802, 0.046083, -0.998535, 0.782459, 1.581482},
{-0.969125, 0.266416, -0.292500, -0.036103, 0.041414, -0.998474, 0.787521, 1.712418},
{-1.008957, 0.301657, -0.288819, -0.022217, 0.081606, -0.996399, 0.701762, 1.819561},
{-1.009237, 0.322144, -0.286675, -0.020295, 0.072054, -0.997192, 0.641084, 1.820312},
{-1.008889, 0.265072, -0.291033, -0.029817, 0.034333, -0.998962, 0.791581, 1.819352},
{-1.009778, 0.340377, -0.286134, -0.022462, 0.071474, -0.997162, 0.587121, 1.821808},
{-1.010767, 0.354041, -0.284863, -0.007172, 0.325663, -0.945433, 0.536515, 1.823677},
{-0.920472, 0.203230, -0.295327, -0.028840, 0.010956, -0.999512, 0.918926, 1.581463},
{-0.920517, 0.124397, -0.295665, -0.027467, 0.001617, -0.999603, 1.078220, 1.581424},
{-0.969176, 0.121158, -0.293809, -0.041627, 0.002716, -0.999115, 1.087903, 1.712274},
{-0.969128, 0.200751, -0.293521, -0.040010, 0.009278, -0.999146, 0.926364, 1.712308},
{-0.868143, 0.204872, -0.296438, -0.007141, 0.009980, -0.999908, 0.913935, 1.440712},
{-0.868147, 0.126571, -0.296661, -0.002808, -0.000855, -0.999969, 1.071649, 1.440561},
{-0.920503, 0.047320, -0.295638, -0.022919, -0.004425, -0.999725, 1.232305, 1.581219},
{-0.969170, 0.043683, -0.294021, -0.038759, -0.001038, -0.999237, 1.243173, 1.712098},
{-0.868100, 0.049782, -0.296343, 0.001923, -0.007935, -0.999939, 1.224876, 1.440258},
{-1.009253, 0.040343, -0.292183, -0.044404, 0.001282, -0.998993, 1.253128, 1.819871},
{-1.009142, 0.118244, -0.291894, -0.044435, 0.002075, -0.998993, 1.096595, 1.819732},
{-1.008986, 0.198544, -0.291784, -0.038392, 0.005463, -0.999237, 0.932969, 1.819484},
{-0.715154, 0.332729, -0.290209, 0.028382, 0.059542, -0.997803, 0.608938, 1.029220},
{-0.714702, 0.316654, -0.290594, 0.024445, 0.057741, -0.998016, 0.656511, 1.027963},
{-0.767530, 0.318442, -0.290869, 0.003113, 0.063936, -0.997925, 0.651395, 1.170114},
{-0.768051, 0.334405, -0.290593, -0.002930, 0.056185, -0.998413, 0.604157, 1.171559},
{-0.714259, 0.299053, -0.291977, 0.028565, 0.057527, -0.997925, 0.708626, 1.026762},
{-0.767072, 0.300844, -0.292640, 0.011780, 0.077212, -0.996918, 0.703513, 1.168882},
{-0.713766, 0.265179, -0.293139, 0.037751, 0.015137, -0.999146, 0.790394, 1.025383},
{-0.766632, 0.267140, -0.294425, 0.020753, 0.028779, -0.999359, 0.784796, 1.167668},
{-0.817670, 0.302758, -0.292846, 0.001434, 0.096255, -0.995331, 0.698016, 1.305030},
{-0.817833, 0.320693, -0.290535, -0.007508, 0.085055, -0.996338, 0.644882, 1.305453},
{-0.817469, 0.268648, -0.295213, 0.008484, 0.040223, -0.999146, 0.780516, 1.304476},
{-0.817921, 0.336251, -0.289824, -0.016877, 0.084140, -0.996307, 0.598830, 1.305716},
{-0.818024, 0.348075, -0.288344, -0.020356, 0.351543, -0.935911, 0.556320, 1.305899},
{-0.713159, 0.200281, -0.292857, 0.047182, -0.006958, -0.998840, 0.926925, 1.023594},
{-0.712450, 0.121161, -0.292012, 0.052248, -0.008087, -0.998596, 1.087030, 1.021487},
{-0.765673, 0.124254, -0.294255, 0.035798, -0.006684, -0.999329, 1.078111, 1.164768},
{-0.766165, 0.202856, -0.294746, 0.029908, -0.000427, -0.999542, 0.919530, 1.166278},
{-0.711648, 0.044618, -0.291484, 0.050417, -0.007172, -0.998688, 1.239519, 1.019149},
{-0.765158, 0.047596, -0.293604, 0.036256, -0.010071, -0.999268, 1.230937, 1.163196},
{-0.816814, 0.049596, -0.295445, 0.025758, -0.010224, -0.999603, 1.225238, 1.302242},
{-0.817053, 0.126291, -0.295998, 0.022370, -0.003998, -0.999725, 1.072299, 1.303068},
{-0.817267, 0.204567, -0.296092, 0.016114, 0.005768, -0.999847, 0.914668, 1.303817},
{-1.175245, 0.168795, -0.150662, 0.599750, 0.293832, 0.744255, 2.013423, 2.546580},
{-1.182435, 0.192602, -0.150006, 0.526749, 0.025971, 0.849605, 1.935451, 2.580742},
{-1.189867, 0.197515, -0.142808, 0.882962, 0.094882, 0.459700, 1.929981, 2.623082},
{-1.180312, 0.168963, -0.143709, 0.849208, 0.456404, 0.265542, 2.029510, 2.574643},
{-1.165346, 0.150233, -0.144286, 0.706015, 0.695029, 0.135838, 2.092025, 2.503083},
{-1.163157, 0.152012, -0.150898, 0.548296, 0.498947, 0.671102, 2.067409, 2.492256},
{-1.160594, 0.156612, -0.153749, 0.326762, 0.267098, 0.906552, 2.045620, 2.482450},
{-1.166660, 0.168647, -0.154608, 0.285257, 0.123325, 0.950468, 2.004336, 2.510418},
{-1.170890, 0.187894, -0.153984, 0.208594, -0.038697, 0.977233, 1.941161, 2.531212},
{-1.181905, 0.172235, -0.132924, 0.866878, 0.490921, -0.086459, 1.268722, -1.905625},
{-1.180312, 0.168963, -0.143709, 0.849208, 0.456404, 0.265542, 1.271701, -1.964071},
{-1.189867, 0.197515, -0.142808, 0.882962, 0.094882, 0.459700, 1.152362, -1.922492},
{-1.192342, 0.201861, -0.131421, 0.989532, 0.128025, 0.066286, 1.152956, -1.861861},
{-1.192014, 0.205880, -0.116420, 0.988800, 0.138462, -0.055574, 1.155729, -1.795012},
{-1.181583, 0.176150, -0.118664, 0.868496, 0.482345, -0.114170, 1.271022, -1.841953},
{-1.166151, 0.157150, -0.120501, 0.718070, 0.688833, -0.099277, 1.367889, -1.899843},
{-1.166148, 0.153410, -0.134108, 0.690451, 0.703055, -0.170141, 1.366644, -1.939671},
{-1.165346, 0.150233, -0.144286, 0.706015, 0.695029, 0.135838, 1.375638, -1.995702},
{-1.189061, 0.244436, -0.129762, 0.951598, -0.198035, 0.234962, 1.001499, -1.798663},
{-1.185966, 0.236929, -0.141327, 0.744407, -0.184362, 0.641743, 1.002218, -1.861016},
{-1.173067, 0.272385, -0.140093, 0.504257, -0.323130, 0.800806, 0.836671, -1.789591},
{-1.175922, 0.283307, -0.129093, 0.777795, -0.470534, 0.416639, 0.832196, -1.725747},
{-1.177084, 0.288322, -0.113802, 0.845973, -0.500626, 0.183416, 0.830628, -1.654775},
{-1.189595, 0.248848, -0.114302, 0.981994, -0.181677, 0.051454, 1.002630, -1.729529},
{-1.178920, 0.222970, -0.148292, 0.356334, -0.135472, 0.924467, 1.835140, 2.569568},
{-1.185966, 0.236929, -0.141327, 0.744407, -0.184362, 0.641743, 1.787961, 2.609876},
{-1.167944, 0.209923, -0.151896, 0.124638, -0.120457, 0.984832, 1.869993, 2.521235},
{-1.162185, 0.229917, -0.149560, 0.075259, -0.132267, 0.988342, 1.805646, 2.498816},
{-1.167817, 0.249501, -0.146577, 0.185766, -0.168767, 0.967956, 1.746300, 2.525217},
{-1.173067, 0.272385, -0.140093, 0.504257, -0.323130, 0.800806, 1.658108, 2.556178},
{-0.542117, 0.214737, -0.143080, -0.647603, -0.188910, 0.738151, 0.174831, -0.158651},
{-0.537244, 0.191154, -0.142145, -0.794916, 0.093417, 0.599445, 0.276795, -0.121601},
{-0.536186, 0.192506, -0.136864, -0.987701, 0.082736, 0.132420, 0.294175, -0.128629},
{-0.540201, 0.218438, -0.138065, -0.907712, -0.250252, 0.336711, 0.171286, -0.184247},
{-0.549665, 0.240498, -0.138720, -0.731590, -0.439985, 0.520676, 0.051039, -0.213246},
{-0.552166, 0.234780, -0.143294, -0.428449, -0.268593, 0.862697, 0.072868, -0.195701},
{-0.553587, 0.227102, -0.144861, -0.208533, -0.142430, 0.967559, 0.091131, -0.175544},
{-0.546722, 0.212063, -0.145500, -0.266305, -0.087130, 0.959929, 0.182071, -0.139979},
{-0.541461, 0.190611, -0.144852, -0.315470, 0.092746, 0.944365, 0.273010, -0.104415},
{-0.539287, 0.221000, -0.129234, -0.958739, -0.248848, 0.137364, 0.175128, -0.223692},
{-0.535855, 0.194474, -0.127916, -0.995483, 0.093692, 0.014801, 0.272855, -0.189554},
{-0.535590, 0.197246, -0.115065, -0.993713, 0.109043, 0.023988, 0.280212, -0.245627},
{-0.538481, 0.223955, -0.116418, -0.964202, -0.232063, 0.128208, 0.182583, -0.279850},
{-0.547401, 0.246169, -0.117235, -0.851253, -0.482498, 0.206153, 0.092489, -0.310116},
{-0.548456, 0.243471, -0.130037, -0.840419, -0.491806, 0.227515, 0.083815, -0.254416},
{-0.543695, 0.170656, -0.126234, -0.895657, 0.439528, -0.067721, 0.345673, -0.161854},
{-0.543220, 0.169870, -0.135079, -0.890164, 0.451308, 0.062319, 0.338746, -0.115339},
{-0.554814, 0.153465, -0.133517, -0.696249, 0.693838, 0.183813, 0.396911, -0.091891},
{-0.555999, 0.153001, -0.124815, -0.733024, 0.678701, -0.045076, 0.406037, -0.137373},
{-0.557312, 0.152252, -0.111882, -0.749779, 0.660878, 0.032472, 0.425083, -0.188018},
{-0.544267, 0.171747, -0.113328, -0.900754, 0.433729, -0.022126, 0.357686, -0.215739},
{-0.543552, 0.170868, -0.139890, -0.700705, 0.427839, 0.570879, 1.898856, -0.172630},
{-0.543220, 0.169870, -0.135079, -0.890164, 0.451308, 0.062319, 1.910665, -0.176623},
{-0.536186, 0.192506, -0.136864, -0.987701, 0.082736, 0.132420, 1.831957, -0.226703},
{-0.537244, 0.191154, -0.142145, -0.794916, 0.093417, 0.599445, 1.827429, -0.220589},
{-0.541461, 0.190611, -0.144852, -0.315470, 0.092746, 0.944365, 1.806371, -0.202771},
{-0.546883, 0.172257, -0.142122, -0.269723, 0.285867, 0.919492, 1.890393, -0.157654},
{-0.554447, 0.161699, -0.139782, -0.195929, 0.341380, 0.919248, 1.932392, -0.127079},
{-0.554594, 0.156405, -0.137762, -0.458449, 0.546037, 0.701163, 1.954387, -0.127601},
{-0.554814, 0.153465, -0.133517, -0.696249, 0.693838, 0.183813, 1.972508, -0.129728},
{-1.095838, 0.162122, -0.160028, 0.061373, 0.042177, 0.997192, 2.001250, 2.205932},
{-1.095254, 0.183664, -0.159468, 0.069552, -0.070620, 0.995056, 1.929180, 2.206353},
{-1.132646, 0.182420, -0.156951, 0.058687, -0.073366, 0.995575, 1.946030, 2.366517},
{-1.132878, 0.162236, -0.157617, 0.063997, 0.035554, 0.997314, 2.013208, 2.364798},
{-1.132224, 0.146681, -0.156128, 0.089908, 0.243080, 0.965819, 2.068789, 2.359488},
{-1.095710, 0.144702, -0.158137, 0.059786, 0.235298, 0.970061, 2.064059, 2.202539},
{-1.053643, 0.144479, -0.160119, 0.032380, 0.245308, 0.968871, 2.052292, 2.021945},
{-1.053952, 0.164026, -0.162570, 0.049104, 0.055727, 0.997223, 1.981193, 2.026531},
{-1.053669, 0.187104, -0.162231, 0.065554, -0.064089, 0.995758, 1.903538, 2.028509},
{-1.154511, 0.165436, -0.156368, 0.114231, 0.050630, 0.992157, 2.009251, 2.458059},
{-1.156076, 0.184165, -0.155711, 0.074313, -0.068484, 0.994873, 1.947356, 2.467304},
{-1.151952, 0.150956, -0.155025, 0.195837, 0.255531, 0.946745, 2.060508, 2.444733},
{-1.153065, 0.205150, -0.153383, 0.053713, -0.125828, 0.990570, 1.880191, 2.456852},
{-1.129702, 0.205654, -0.154435, 0.058077, -0.130192, 0.989776, 1.871625, 2.356636},
{-1.127174, 0.232960, -0.150663, 0.050600, -0.142582, 0.988464, 1.785990, 2.348864},
{-1.150212, 0.230367, -0.149936, 0.045503, -0.133549, 0.989990, 1.800928, 2.447451},
{-1.093277, 0.208436, -0.156735, 0.072390, -0.136509, 0.987976, 1.850186, 2.200801},
{-1.052729, 0.212667, -0.159361, 0.073733, -0.144444, 0.986755, 1.822349, 2.027500},
{-1.051665, 0.239305, -0.154668, 0.064943, -0.193945, 0.978851, 1.741104, 2.025748},
{-1.091524, 0.235951, -0.152491, 0.060732, -0.164403, 0.984497, 1.764941, 2.196298},
{-1.163909, 0.329983, 0.246200, 0.277047, 0.212073, -0.937132, 2.652307, -0.076005},
{-1.173535, 0.356353, 0.246386, 0.231574, 0.023347, -0.972533, 2.573194, -0.121740},
{-1.144448, 0.346017, 0.249539, 0.109867, 0.022736, -0.993683, 2.609120, 0.005206},
{-1.138888, 0.319684, 0.248176, 0.141240, 0.189001, -0.971740, 2.685706, 0.033416},
{-1.132585, 0.293484, 0.241450, 0.194098, 0.442671, -0.875393, 2.766662, 0.077344},
{-1.153266, 0.301936, 0.240700, 0.338176, 0.427076, -0.838557, 2.743129, -0.005835},
{-1.164939, 0.308109, 0.236588, 0.517380, 0.432142, -0.738578, 2.724252, -0.051973},
{-1.177650, 0.331295, 0.240313, 0.545030, 0.328990, -0.771111, 2.627106, -0.150962},
{-1.190851, 0.358606, 0.240089, 0.595813, 0.102237, -0.796564, 2.547132, -0.216530},
{-1.098067, 0.303893, 0.250753, 0.141881, 0.250435, -0.957671, 2.735500, 0.211764},
{-1.100653, 0.329670, 0.253945, 0.115238, 0.064119, -0.991241, 2.664778, 0.196463},
{-1.053220, 0.314228, 0.258578, 0.112735, 0.104770, -0.988067, 2.764716, 0.460519},
{-1.052439, 0.289649, 0.253542, 0.127720, 0.327342, -0.936216, 2.793492, 0.424575},
{-1.051299, 0.269589, 0.243388, 0.130131, 0.553697, -0.822443, 2.837011, 0.428913},
{-1.094958, 0.280794, 0.242337, 0.173040, 0.495346, -0.851253, 2.799509, 0.234607},
{-1.099668, 0.357064, 0.253879, 0.084964, -0.133702, -0.987365, 2.580627, 0.196248},
{-1.142886, 0.367493, 0.248767, 0.081942, -0.189795, -0.978362, 2.541277, 0.008433},
{-1.139758, 0.383569, 0.243145, 0.066378, -0.581683, -0.810663, 2.477796, 0.019240},
{-1.097978, 0.380843, 0.247920, 0.057436, -0.492843, -0.868191, 2.492907, 0.199607},
{-1.052512, 0.375821, 0.252593, 0.022187, -0.435102, -0.900082, 2.514349, 0.396221},
{-1.052970, 0.345807, 0.259035, 0.074587, -0.108676, -0.991241, 2.622206, 0.399184},
{-1.172153, 0.373610, 0.245295, 0.188269, -0.270486, -0.944121, 2.517496, -0.118605},
{-1.189974, 0.375250, 0.239254, 0.569048, -0.356670, -0.740898, 2.501498, -0.215255},
{-1.182348, 0.382628, 0.236141, 0.406323, -0.701926, -0.584948, 2.468307, -0.194477},
{-1.167952, 0.384436, 0.240085, 0.169774, -0.672842, -0.720023, 2.470978, -0.102320},
{-1.091613, 0.265719, -0.147395, 0.033876, -0.206854, 0.977752, 1.674117, 2.199866},
{-1.092022, 0.292213, -0.140883, 0.009735, -0.344035, 0.938902, 1.580504, 2.207469},
{-1.129865, 0.293496, -0.140355, 0.055116, -0.358348, 0.931944, 1.576633, 2.372874},
{-1.128188, 0.265361, -0.146225, 0.038362, -0.176427, 0.983551, 1.685121, 2.356914},
{-1.051013, 0.265614, -0.148858, 0.041047, -0.250160, 0.967315, 1.663282, 2.025500},
{-1.050525, 0.289938, -0.141426, 0.018281, -0.356212, 0.934202, 1.587171, 2.026003},
{-1.152248, 0.261793, -0.145920, 0.074435, -0.169012, 0.982788, 1.702738, 2.459848},
{-1.155623, 0.289064, -0.139930, 0.223426, -0.377178, 0.898770, 1.595083, 2.483144},
{-1.156786, 0.301820, -0.130563, 0.423017, -0.683279, 0.595080, 0.040366, 0.090882},
{-1.155623, 0.289064, -0.139930, 0.223426, -0.377178, 0.898770, -0.007312, 0.090675},
{-1.129865, 0.293496, -0.140355, 0.055116, -0.358348, 0.931944, -0.001485, 0.202659},
{-1.129331, 0.308007, -0.132288, 0.129734, -0.683157, 0.718619, 0.041372, 0.211295},
{-1.128862, 0.315854, -0.119291, 0.218726, -0.861019, 0.459090, 0.098879, 0.214373},
{-1.157242, 0.307573, -0.116411, 0.508866, -0.796228, 0.327128, 0.100040, 0.089005},
{-1.177084, 0.288322, -0.113802, 0.845973, -0.500626, 0.183416, 0.105381, -0.016002},
{-1.175922, 0.283307, -0.129093, 0.777795, -0.470534, 0.416639, 0.040433, -0.007671},
{-1.173067, 0.272385, -0.140093, 0.504257, -0.323130, 0.800806, -0.017982, 0.004236},
{-1.091232, 0.309902, -0.132388, 0.033143, -0.591632, 0.805506, 0.044524, 0.375427},
{-1.092022, 0.292213, -0.140883, 0.009735, -0.344035, 0.938902, -0.005346, 0.365735},
{-1.050525, 0.289938, -0.141426, 0.018281, -0.356212, 0.934202, -0.011004, 0.544275},
{-1.049950, 0.310623, -0.131870, 0.027467, -0.526414, 0.849757, 0.048933, 0.552654},
{-1.049650, 0.327729, -0.118870, 0.082827, -0.716727, 0.692404, 0.116063, 0.558621},
{-1.090739, 0.322420, -0.119604, 0.114475, -0.795068, 0.595599, 0.106077, 0.380461},
{-1.094612, 0.124207, -0.135644, 0.232246, 0.972655, -0.000305, -1.744587, 2.354029},
{-1.095229, 0.125327, -0.146057, 0.172552, 0.899411, 0.401593, -1.789844, 2.358319},
{-1.133056, 0.133767, -0.145348, 0.266945, 0.942228, 0.202246, -1.769863, 2.520780},
{-1.133186, 0.135554, -0.135247, 0.305155, 0.941465, -0.143101, -1.720609, 2.519250},
{-1.133082, 0.137867, -0.121744, 0.326640, 0.943876, -0.048799, -1.649131, 2.569403},
{-1.093951, 0.125667, -0.121936, 0.243446, 0.966857, -0.076846, -1.693435, 2.350084},
{-1.048928, 0.114920, -0.121556, 0.150548, 0.985229, -0.081484, -1.742172, 2.106170},
{-1.050198, 0.114949, -0.135492, 0.112583, 0.975036, 0.191321, -1.772399, 2.149561},
{-1.051606, 0.119532, -0.146322, 0.051393, 0.820643, 0.569109, -1.812596, 2.157498},
{-1.153470, 0.143235, -0.134808, 0.483261, 0.852840, -0.197729, -1.704299, 2.605976},
{-1.153011, 0.140285, -0.144795, 0.480300, 0.870907, 0.103702, -1.755422, 2.606522},
{-1.165346, 0.150233, -0.144286, 0.706015, 0.695029, 0.135838, -1.743751, 2.653904},
{-1.166148, 0.153410, -0.134108, 0.690451, 0.703055, -0.170141, -1.691823, 2.653456},
{-1.166151, 0.157150, -0.120501, 0.718070, 0.688833, -0.099277, -1.639895, 2.653008},
{-1.153566, 0.146376, -0.121397, 0.523301, 0.849940, -0.060976, -1.653176, 2.605431},
{-1.151978, 0.142715, -0.151351, 0.366436, 0.626331, 0.688009, 2.095758, 2.442944},
{-1.153011, 0.140285, -0.144795, 0.480300, 0.870907, 0.103702, 2.123006, 2.446924},
{-1.133056, 0.133767, -0.145348, 0.266945, 0.942228, 0.202246, 2.140032, 2.359920},
{-1.132509, 0.137334, -0.152173, 0.172399, 0.637501, 0.750877, 2.108402, 2.358599},
{-1.095551, 0.132298, -0.153518, 0.093356, 0.564714, 0.819971, 2.115270, 2.199175},
{-1.095229, 0.125327, -0.146057, 0.172552, 0.899411, 0.401593, 2.160681, 2.195825},
{-1.051606, 0.119532, -0.146322, 0.051393, 0.820643, 0.569109, 2.184797, 2.041385},
{-1.052808, 0.129512, -0.154617, 0.024354, 0.524522, 0.851009, 2.113810, 2.015133},
{-0.622833, 0.218267, -0.148437, -0.034364, -0.047212, 0.998291, 1.737307, 0.176830},
{-0.621473, 0.193605, -0.148582, -0.038362, 0.047700, 0.998108, 1.820386, 0.167519},
{-0.575119, 0.192186, -0.146947, -0.035585, 0.069491, 0.996918, 1.818983, -0.032407},
{-0.578069, 0.215066, -0.147199, -0.032197, -0.035218, 0.998840, 1.741487, -0.016434},
{-0.581804, 0.236098, -0.145771, -0.037904, -0.118473, 0.992218, 1.673753, 0.002321},
{-0.624498, 0.241540, -0.146496, -0.035646, -0.126438, 0.991302, 1.662568, 0.186893},
{-0.677239, 0.246719, -0.147785, -0.043703, -0.139714, 0.989196, 1.653209, 0.414758},
{-0.677275, 0.221736, -0.150314, -0.045625, -0.061617, 0.997040, 1.732925, 0.411889},
{-0.677215, 0.195885, -0.150889, -0.047334, 0.028840, 0.998444, 1.819447, 0.408088},
{-0.555702, 0.212585, -0.146547, -0.077914, -0.039735, 0.996155, 1.746630, -0.113131},
{-0.551267, 0.191072, -0.146078, -0.077120, 0.084475, 0.993408, 1.819619, -0.135343},
{-0.546722, 0.212063, -0.145500, -0.266305, -0.087130, 0.959929, 1.752254, -0.161544},
{-0.553587, 0.227102, -0.144861, -0.208533, -0.142430, 0.967559, 1.693732, -0.125525},
{-0.561484, 0.232078, -0.145396, -0.095553, -0.122379, 0.987854, 1.683982, -0.085732},
{-0.555406, 0.172642, -0.143232, -0.082430, 0.217689, 0.972503, 1.888622, -0.120713},
{-0.577842, 0.172134, -0.144275, -0.049959, 0.183050, 0.981811, 1.892852, -0.024065},
{-0.582091, 0.156273, -0.140680, -0.070528, 0.261177, 0.962706, 1.954652, -0.008753},
{-0.561750, 0.158611, -0.139708, -0.101871, 0.294137, 0.950285, 1.944503, -0.096118},
{-0.622911, 0.170844, -0.146308, -0.048860, 0.149388, 0.987548, 1.902389, 0.170034},
{-0.677720, 0.170927, -0.149027, -0.049348, 0.125797, 0.990814, 1.907896, 0.406363},
{-0.678332, 0.148267, -0.145226, -0.051424, 0.221198, 0.973846, 1.992418, 0.405025},
{-0.625137, 0.151443, -0.142628, -0.063540, 0.235450, 0.969787, 1.975950, 0.176129},
{-0.622281, 0.284968, 0.255501, -0.033723, 0.424879, -0.904599, -0.125594, 0.278718},
{-0.619015, 0.304993, 0.261799, -0.053499, 0.194952, -0.979339, -0.066307, 0.255663},
{-0.572503, 0.310782, 0.260358, -0.056673, 0.095431, -0.993805, -0.060910, 0.050356},
{-0.577745, 0.290112, 0.256450, -0.029145, 0.343944, -0.938505, -0.117586, 0.086414},
{-0.583296, 0.270936, 0.246620, -0.034089, 0.611805, -0.790246, -0.184299, 0.112551},
{-0.625522, 0.267334, 0.244389, -0.031831, 0.620777, -0.783319, -0.194485, 0.294879},
{-0.676837, 0.263763, 0.242619, -0.035585, 0.634205, -0.772301, -0.202158, 0.516318},
{-0.675810, 0.279767, 0.255056, -0.044740, 0.504746, -0.862087, -0.131096, 0.509732},
{-0.674531, 0.298817, 0.263597, -0.056001, 0.272835, -0.960418, -0.069200, 0.499517},
{-0.556050, 0.292029, 0.256460, -0.213385, 0.355876, -0.909818, -0.116285, -0.007189},
{-0.549909, 0.312544, 0.259144, -0.280068, 0.060915, -0.958037, -0.062185, -0.049620},
{-0.540674, 0.308402, 0.253722, -0.678335, 0.130161, -0.723106, -0.090662, -0.090192},
{-0.547611, 0.288426, 0.251184, -0.516709, 0.448683, -0.729148, -0.141869, -0.042876},
{-0.555164, 0.274547, 0.244405, -0.407575, 0.618458, -0.671834, -0.188644, -0.008754},
{-0.562822, 0.272600, 0.247402, -0.196570, 0.623493, -0.756676, -0.180568, 0.024173},
{-0.550212, 0.330339, 0.256994, -0.354534, -0.268166, -0.895749, 2.603997, 2.566354},
{-0.549909, 0.312544, 0.259144, -0.280068, 0.060915, -0.958037, 2.665168, 2.584240},
{-0.572503, 0.310782, 0.260358, -0.056673, 0.095431, -0.993805, 2.679187, 2.484911},
{-0.572535, 0.330784, 0.259678, -0.108524, -0.185461, -0.976623, 2.611952, 2.470191},
{-0.573201, 0.347259, 0.253325, -0.192755, -0.554491, -0.809534, 2.545902, 2.464594},
{-0.551200, 0.343441, 0.249940, -0.433943, -0.568926, -0.698538, 2.546580, 2.559911},
{-0.543519, 0.337890, 0.246841, -0.712180, -0.439650, -0.547197, 2.549288, 2.603098},
{-0.540907, 0.326977, 0.251564, -0.747551, -0.222236, -0.625904, 2.602511, 2.610734},
{-0.540674, 0.308402, 0.253722, -0.678335, 0.130161, -0.723106, 2.661108, 2.631584},
{-0.618988, 0.329293, 0.264026, -0.082736, -0.070437, -0.994049, 2.632844, 2.270464},
{-0.619015, 0.304993, 0.261799, -0.053499, 0.194952, -0.979339, 2.713125, 2.281611},
{-0.674531, 0.298817, 0.263597, -0.056001, 0.272835, -0.960418, 2.750045, 2.039787},
{-0.674545, 0.326657, 0.268177, -0.057436, -0.005982, -0.998321, 2.657857, 2.031718},
{-0.674692, 0.356117, 0.264154, -0.066469, -0.384228, -0.920804, 2.557746, 2.026264},
{-0.619362, 0.352608, 0.259075, -0.137120, -0.449751, -0.882534, 2.549283, 2.265019},
{-0.561389, 0.244447, -0.143386, -0.213080, -0.299356, 0.930021, 1.646004, -0.084798},
{-0.558981, 0.251519, -0.138864, -0.455000, -0.597217, 0.660512, 1.620361, -0.097098},
{-0.579510, 0.260106, -0.138555, -0.230262, -0.597430, 0.768120, 1.596167, -0.007043},
{-0.581439, 0.250609, -0.143400, -0.087191, -0.292276, 0.952330, 1.629172, 0.002327},
{-0.552166, 0.234780, -0.143294, -0.428449, -0.268593, 0.862697, 1.659460, -0.123332},
{-0.549665, 0.240498, -0.138720, -0.731590, -0.439985, 0.520676, 1.637312, -0.138050},
{-0.623972, 0.260135, -0.143378, -0.061556, -0.259377, 0.963805, 1.605587, 0.186634},
{-0.622617, 0.274863, -0.137853, -0.150365, -0.484176, 0.861934, 1.557486, 0.181214},
{-0.675341, 0.288891, -0.137442, -0.090030, -0.404828, 0.909909, 1.522982, 0.410650},
{-0.676443, 0.269075, -0.143782, -0.051637, -0.245155, 0.968078, 1.585175, 0.413689},
{-0.621793, 0.286537, -0.128694, -0.278634, -0.675466, 0.682699, 0.053499, 2.378833},
{-0.622617, 0.274863, -0.137853, -0.150365, -0.484176, 0.861934, 0.001268, 2.374164},
{-0.579510, 0.260106, -0.138555, -0.230262, -0.597430, 0.768120, -0.018983, 2.601898},
{-0.578555, 0.266097, -0.129707, -0.380810, -0.780725, 0.495376, 0.024688, 2.602896},
{-0.577708, 0.271235, -0.116901, -0.463454, -0.795251, 0.390851, 0.077273, 2.605958},
{-0.621087, 0.296557, -0.115925, -0.380352, -0.752586, 0.537492, 0.112406, 2.383813},
{-0.673618, 0.321215, -0.115134, -0.241523, -0.706809, 0.664876, 0.138882, 2.168037},
{-0.674390, 0.306258, -0.127899, -0.161840, -0.574816, 0.802087, 0.074856, 2.160849},
{-0.675341, 0.288891, -0.137442, -0.090030, -0.404828, 0.909909, 0.015745, 2.152506},
{-0.557828, 0.255123, -0.130175, -0.600299, -0.726371, 0.334635, 0.030241, -0.271872},
{-0.578555, 0.266097, -0.129707, -0.380810, -0.780725, 0.495376, -0.004463, -0.282694},
{-0.579510, 0.260106, -0.138555, -0.230262, -0.597430, 0.768120, -0.010447, -0.235274},
{-0.558981, 0.251519, -0.138864, -0.455000, -0.597217, 0.660512, 0.022079, -0.225566},
{-0.556812, 0.258184, -0.117367, -0.639729, -0.714469, 0.283212, 0.037619, -0.328134},
{-0.577708, 0.271235, -0.116901, -0.463454, -0.795251, 0.390851, 0.000362, -0.340029},
{-0.565961, 0.144961, -0.124284, -0.495407, 0.867031, 0.052736, 0.625466, -0.136139},
{-0.564481, 0.146228, -0.132982, -0.423597, 0.824549, 0.375042, 0.625806, -0.179809},
{-0.584395, 0.139993, -0.132846, -0.255043, 0.795007, 0.550340, 0.591013, -0.177181},
{-0.585793, 0.137135, -0.123881, -0.348979, 0.918912, 0.183721, 0.590418, -0.134536},
{-0.587202, 0.135496, -0.110987, -0.356883, 0.930540, 0.081912, 0.589822, -0.091891},
{-0.567525, 0.143559, -0.111403, -0.504868, 0.857479, 0.099002, 0.625127, -0.092469},
{-0.557312, 0.152252, -0.111882, -0.749779, 0.660878, 0.032472, 0.660432, -0.093047},
{-0.555999, 0.153001, -0.124815, -0.733024, 0.678701, -0.045076, 0.660515, -0.137742},
{-0.554814, 0.153465, -0.133517, -0.696249, 0.693838, 0.183813, 0.660599, -0.182437},
{-0.627708, 0.120119, -0.122845, -0.306742, 0.890927, 0.334849, 2.122000, 0.178790},
{-0.585793, 0.137135, -0.123881, -0.348979, 0.918912, 0.183721, 2.035207, -0.045691},
{-0.584395, 0.139993, -0.132846, -0.255043, 0.795007, 0.550340, 2.014892, -0.059656},
{-0.626727, 0.126592, -0.132484, -0.197760, 0.684652, 0.701498, 2.080703, 0.177416},
{-0.678709, 0.114380, -0.132537, -0.105502, 0.589282, 0.800958, 2.132625, 0.399313},
{-0.678927, 0.103788, -0.122106, -0.185797, 0.857875, 0.479049, 2.189307, 0.396659},
{-0.679100, 0.100539, -0.108693, -0.221747, 0.973083, -0.062655, 2.241600, 0.394216},
{-0.628637, 0.117892, -0.109733, -0.333262, 0.942808, -0.001221, 2.160445, 0.180924},
{-0.587202, 0.135496, -0.110987, -0.356883, 0.930540, 0.081912, 2.058545, -0.039516},
{-0.626139, 0.136863, -0.138549, -0.100192, 0.399243, 0.911344, 2.033704, 0.177559},
{-0.583718, 0.145966, -0.137658, -0.127079, 0.461257, 0.878079, 1.995942, -0.003817},
{-0.678586, 0.129313, -0.139987, -0.061678, 0.363445, 0.929533, 2.067161, 0.402389},
{-0.563926, 0.150292, -0.137207, -0.229957, 0.524155, 0.819971, 1.978126, -0.088433},
{-0.564481, 0.146228, -0.132982, -0.423597, 0.824549, 0.375042, 2.000621, -0.089204},
{-1.185735, 0.290064, 0.182347, 0.914609, 0.380535, -0.136479, 1.195557, -0.458233},
{-1.197131, 0.326719, 0.183823, 0.986938, 0.137516, 0.083743, 1.053169, -0.405465},
{-1.200812, 0.338223, 0.206834, 0.980041, 0.177526, -0.089145, 1.034294, -0.296443},
{-1.186711, 0.303904, 0.205823, 0.844508, 0.431562, -0.317057, 1.170943, -0.343884},
{-1.167968, 0.274624, 0.205098, 0.685812, 0.559313, -0.465590, 1.325416, -0.394202},
{-1.169868, 0.259790, 0.181136, 0.762902, 0.556078, -0.329722, 1.351394, -0.513538},
{-1.170346, 0.246373, 0.155156, 0.822352, 0.519517, -0.231880, 1.371345, -0.638856},
{-1.183225, 0.278005, 0.156461, 0.948851, 0.311563, -0.050661, 1.212168, -0.579924},
{-1.191933, 0.316543, 0.157981, 0.990112, 0.106204, 0.091494, 1.065202, -0.524150},
{-1.184634, 0.320125, 0.225999, 0.732994, 0.418989, -0.535844, 1.136395, -0.239545},
{-1.199331, 0.350708, 0.226247, 0.892453, 0.176244, -0.415204, 1.012066, -0.200222},
{-1.190851, 0.358606, 0.240089, 0.595813, 0.102237, -0.796564, 0.988160, -0.110402},
{-1.177650, 0.331295, 0.240313, 0.545030, 0.328990, -0.771111, 1.096878, -0.140211},
{-1.164939, 0.308109, 0.236588, 0.517380, 0.432142, -0.738578, 1.234133, -0.178241},
{-1.165233, 0.292453, 0.225824, 0.601245, 0.510330, -0.614826, 1.283707, -0.283950},
{-1.198853, 0.372245, 0.226438, 0.898679, -0.344859, -0.270974, 0.933705, -0.171065},
{-1.200432, 0.366221, 0.208012, 0.956664, -0.275307, 0.094516, 0.933292, -0.254756},
{-1.189233, 0.385723, 0.209089, 0.669179, -0.739219, 0.075442, 0.850112, -0.215947},
{-1.187388, 0.385569, 0.226889, 0.559709, -0.786920, -0.259682, 0.878327, -0.146991},
{-1.182348, 0.382628, 0.236141, 0.406323, -0.701926, -0.584948, 0.913414, -0.091891},
{-1.189974, 0.375250, 0.239254, 0.569048, -0.356670, -0.740898, 0.936518, -0.097036},
{-1.196353, 0.358802, 0.185143, 0.948210, -0.221809, 0.227241, 0.937681, -0.357772},
{-1.191092, 0.350511, 0.159127, 0.966887, -0.183325, 0.177465, 0.942657, -0.474691},
{-1.182000, 0.375795, 0.159921, 0.785211, -0.577929, 0.222297, 0.832323, -0.428390},
{-1.185942, 0.382322, 0.186159, 0.725791, -0.646992, 0.233589, 0.835642, -0.312616},
{-0.542844, 0.277009, 0.236279, -0.665151, 0.541429, -0.514176, -0.214518, -0.061434},
{-0.534233, 0.296478, 0.239652, -0.878445, 0.219825, -0.424238, -0.166871, -0.117288},
{-0.530619, 0.283353, 0.218750, -0.944304, 0.253731, -0.209418, -0.270562, -0.131342},
{-0.540444, 0.263895, 0.214657, -0.729057, 0.596332, -0.335887, -0.313695, -0.069175},
{-0.553144, 0.252151, 0.210458, -0.492538, 0.778436, -0.389111, -0.347238, -0.013240},
{-0.554513, 0.263480, 0.232119, -0.453413, 0.715262, -0.531754, -0.251017, -0.009798},
{-0.539109, 0.255202, 0.189234, -0.795312, 0.573534, -0.196173, -0.418861, -0.072415},
{-0.529861, 0.275608, 0.192829, -0.974303, 0.217841, -0.057131, -0.381487, -0.132789},
{-0.530396, 0.271564, 0.164828, -0.987396, 0.157964, -0.007874, -0.496030, -0.127933},
{-0.538571, 0.248850, 0.162058, -0.858608, 0.496017, -0.129368, -0.527023, -0.073405},
{-0.550283, 0.234406, 0.160618, -0.647053, 0.716178, -0.261483, -0.580349, -0.030755},
{-0.551468, 0.243155, 0.186397, -0.558672, 0.773095, -0.300241, -0.448100, -0.018021},
{-0.529468, 0.306317, 0.196335, -0.993408, -0.100742, 0.054506, 0.314102, -1.666343},
{-0.529861, 0.275608, 0.192829, -0.974303, 0.217841, -0.057131, 0.438622, -1.599030},
{-0.530619, 0.283353, 0.218750, -0.944304, 0.253731, -0.209418, 0.443249, -1.721542},
{-0.529275, 0.311761, 0.220233, -0.992584, -0.082644, -0.088961, 0.326364, -1.771074},
{-0.534163, 0.338150, 0.220534, -0.919736, -0.388195, -0.057924, 0.205281, -1.848623},
{-0.535128, 0.335257, 0.198887, -0.923643, -0.366375, 0.112430, 0.209874, -1.719899},
{-0.538375, 0.331935, 0.173369, -0.918088, -0.374615, 0.129307, 0.183885, -1.612009},
{-0.531535, 0.302920, 0.169418, -0.987121, -0.141057, 0.075137, 0.288258, -1.552579},
{-0.530396, 0.271564, 0.164828, -0.987396, 0.157964, -0.007874, 0.431341, -1.495831},
{-0.533508, 0.319716, 0.238976, -0.939756, -0.122990, -0.318918, 0.317067, -1.859035},
{-0.534233, 0.296478, 0.239652, -0.878445, 0.219825, -0.424238, 0.411440, -1.832586},
{-0.540674, 0.308402, 0.253722, -0.678335, 0.130161, -0.723106, 0.361413, -1.937897},
{-0.540907, 0.326977, 0.251564, -0.747551, -0.222236, -0.625904, 0.296989, -1.938611},
{-0.543519, 0.337890, 0.246841, -0.712180, -0.439650, -0.547197, 0.232566, -1.939326},
{-0.538518, 0.339817, 0.237359, -0.842250, -0.425672, -0.330729, 0.222693, -1.885484},
{-1.168439, 0.393285, 0.186718, 0.358196, -0.921293, 0.151219, 1.339196, 0.028007},
{-1.140421, 0.398790, 0.187662, 0.179174, -0.981903, 0.061251, 1.349647, 0.150160},
{-1.141999, 0.398559, 0.210897, 0.132267, -0.981903, -0.135502, 1.447801, 0.133986},
{-1.170878, 0.394556, 0.209795, 0.288919, -0.956542, -0.038759, 1.439566, 0.005979},
{-1.189233, 0.385723, 0.209089, 0.669179, -0.739219, 0.075442, 1.434150, -0.091891},
{-1.185942, 0.382322, 0.186159, 0.725791, -0.646992, 0.233589, 1.332205, -0.064032},
{-1.182000, 0.375795, 0.159921, 0.785211, -0.577929, 0.222297, 1.225881, -0.045301},
{-1.165955, 0.388284, 0.160387, 0.431135, -0.876705, 0.213141, 1.234158, 0.040741},
{-1.139185, 0.395473, 0.161359, 0.236335, -0.960326, 0.147832, 1.246416, 0.158193},
{-1.169121, 0.391512, 0.227918, 0.213996, -0.911283, -0.351756, 2.419405, -0.108606},
{-1.170878, 0.394556, 0.209795, 0.288919, -0.956542, -0.038759, 2.365304, -0.126177},
{-1.141999, 0.398559, 0.210897, 0.132267, -0.981903, -0.135502, 2.350786, 0.000160},
{-1.140620, 0.393705, 0.229957, 0.088534, -0.888516, -0.450148, 2.414296, 0.013769},
{-1.187388, 0.385569, 0.226889, 0.559709, -0.786920, -0.259682, 2.425658, -0.201540},
{-1.189233, 0.385723, 0.209089, 0.669179, -0.739219, 0.075442, 2.378281, -0.222522},
{-1.098450, 0.395775, 0.233436, 0.064913, -0.830683, -0.552904, 2.411473, 0.195027},
{-1.099230, 0.403570, 0.213160, 0.105472, -0.966399, -0.234352, 2.333183, 0.186479},
{-1.052929, 0.407178, 0.215657, 0.047548, -0.938383, -0.342265, 2.319392, 0.387589},
{-1.052671, 0.395708, 0.236928, 0.007874, -0.766442, -0.642262, 2.414795, 0.392175},
{-1.098463, 0.405935, 0.189828, 0.149907, -0.988342, -0.025971, 1.367014, 0.332541},
{-1.099230, 0.403570, 0.213160, 0.105472, -0.966399, -0.234352, 1.461675, 0.322268},
{-1.097917, 0.404857, 0.163670, 0.196966, -0.978362, 0.063234, 1.266635, 0.338465},
{-1.052565, 0.412917, 0.166515, 0.127567, -0.991791, -0.007233, 1.287669, 0.535652},
{-1.052772, 0.411946, 0.192398, 0.093112, -0.989166, -0.113437, 1.384888, 0.530425},
{-1.052929, 0.407178, 0.215657, 0.047548, -0.938383, -0.342265, 1.475458, 0.524595},
{-1.151600, 0.279648, 0.225848, 0.392376, 0.606098, -0.691824, -0.192249, 2.561228},
{-1.131919, 0.272410, 0.226132, 0.231941, 0.665365, -0.709525, -0.205194, 2.477010},
{-1.134120, 0.255241, 0.205004, 0.239296, 0.784265, -0.572375, -0.309019, 2.489370},
{-1.154421, 0.261743, 0.204776, 0.429975, 0.708182, -0.559984, -0.297061, 2.576311},
{-1.167968, 0.274624, 0.205098, 0.685812, 0.559313, -0.465590, -0.287773, 2.623095},
{-1.165233, 0.292453, 0.225824, 0.601245, 0.510330, -0.614826, -0.182691, 2.607111},
{-1.164939, 0.308109, 0.236588, 0.517380, 0.432142, -0.738578, -0.080670, 2.590811},
{-1.153266, 0.301936, 0.240700, 0.338176, 0.427076, -0.838557, -0.090406, 2.546128},
{-1.132585, 0.293484, 0.241450, 0.194098, 0.442671, -0.875393, -0.104488, 2.464862},
{-1.157238, 0.246846, 0.180612, 0.461837, 0.757164, -0.461928, -0.407810, 2.591362},
{-1.136418, 0.240760, 0.180849, 0.235511, 0.841151, -0.486770, -0.419082, 2.502151},
{-1.137552, 0.227234, 0.154977, 0.231605, 0.858303, -0.457869, -0.533751, 2.509963},
{-1.158674, 0.233124, 0.154656, 0.492172, 0.770562, -0.404920, -0.523078, 2.600499},
{-1.170346, 0.246373, 0.155156, 0.822352, 0.519517, -0.231880, -0.514913, 2.647847},
{-1.169868, 0.259790, 0.181136, 0.762902, 0.556078, -0.329722, -0.398976, 2.638445},
{-1.095985, 0.231055, 0.181923, 0.203864, 0.854152, -0.478378, -0.435233, 2.328686},
{-1.095118, 0.245096, 0.205929, 0.203711, 0.803735, -0.558977, -0.326314, 2.322115},
{-1.049862, 0.235575, 0.207182, 0.150060, 0.814570, -0.560259, -0.341952, 2.127848},
{-1.049362, 0.221586, 0.183293, 0.159429, 0.863186, -0.478988, -0.450498, 2.128519},
{-1.048945, 0.208165, 0.157440, 0.160039, 0.873196, -0.460280, -0.565061, 2.129641},
{-1.096323, 0.217679, 0.156131, 0.201514, 0.865139, -0.459243, -0.549437, 2.333051},
{-1.094375, 0.261435, 0.226731, 0.195227, 0.695059, -0.691916, -0.224910, 2.316126},
{-1.094958, 0.280794, 0.242337, 0.173040, 0.495346, -0.851253, -0.127263, 2.310428},
{-1.051299, 0.269589, 0.243388, 0.130131, 0.553697, -0.822443, -0.132272, 2.166896},
{-1.050474, 0.251570, 0.227574, 0.136784, 0.716117, -0.684408, -0.242463, 2.127751},
{-0.615083, 0.384871, 0.198616, -0.365032, -0.927061, -0.085269, 1.398285, 2.395846},
{-0.567072, 0.363075, 0.199285, -0.444563, -0.895413, 0.024110, 1.376559, 2.644896},
{-0.566487, 0.362228, 0.221733, -0.378307, -0.908261, -0.178564, 1.471599, 2.653904},
{-0.615113, 0.380445, 0.222346, -0.298502, -0.901089, -0.314463, 1.491335, 2.396064},
{-0.672682, 0.396753, 0.222700, -0.168432, -0.886807, -0.430280, 1.505341, 2.152627},
{-0.672098, 0.404687, 0.197956, -0.223640, -0.957152, -0.183874, 1.414039, 2.159178},
{-0.672134, 0.407110, 0.171627, -0.254097, -0.966582, -0.033570, 1.316626, 2.163996},
{-0.616284, 0.385428, 0.172438, -0.405133, -0.913877, 0.025422, 1.299456, 2.394918},
{-0.569533, 0.361595, 0.173429, -0.489029, -0.867367, 0.092166, 1.276116, 2.636593},
{-0.617305, 0.369674, 0.243840, -0.213355, -0.766076, -0.606250, 2.459158, 2.270976},
{-0.615113, 0.380445, 0.222346, -0.298502, -0.901089, -0.314463, 2.365752, 2.282634},
{-0.566487, 0.362228, 0.221733, -0.378307, -0.908261, -0.178564, 2.419726, 2.499011},
{-0.569857, 0.357348, 0.240212, -0.288675, -0.824122, -0.487289, 2.482221, 2.477242},
{-0.673809, 0.380022, 0.246880, -0.104495, -0.714225, -0.692038, 2.441789, 2.026036},
{-0.672682, 0.396753, 0.222700, -0.168432, -0.886807, -0.430280, 2.317909, 2.028421},
{-0.547115, 0.349879, 0.237911, -0.545701, -0.736717, -0.399243, 2.496670, 2.576356},
{-0.543035, 0.351551, 0.221081, -0.643117, -0.760826, -0.086612, 2.450513, 2.604244},
{-0.534163, 0.338150, 0.220534, -0.919736, -0.388195, -0.057924, 2.469707, 2.653904},
{-0.538518, 0.339817, 0.237359, -0.842250, -0.425672, -0.330729, 2.506810, 2.621894},
{-0.544042, 0.350356, 0.199623, -0.686209, -0.719687, 0.105380, 0.146229, -1.745942},
{-0.543035, 0.351551, 0.221081, -0.643117, -0.760826, -0.086612, 0.172791, -1.845722},
{-0.566487, 0.362228, 0.221733, -0.378307, -0.908261, -0.178564, 0.132760, -1.859802},
{-0.567072, 0.363075, 0.199285, -0.444563, -0.895413, 0.024110, 0.102875, -1.758228},
{-0.569533, 0.361595, 0.173429, -0.489029, -0.867367, 0.092166, 0.072186, -1.650795},
{-0.547302, 0.347629, 0.174223, -0.709983, -0.690176, 0.139775, 0.118331, -1.639409},
{-0.625479, 0.250204, 0.227723, -0.069491, 0.750664, -0.656972, -0.282581, 0.297249},
{-0.584188, 0.255419, 0.229535, -0.084353, 0.795282, -0.600330, -0.271087, 0.118850},
{-0.582647, 0.242851, 0.207909, -0.153539, 0.870846, -0.466903, -0.369286, 0.114760},
{-0.624062, 0.234804, 0.206864, -0.130497, 0.838282, -0.529344, -0.382800, 0.293865},
{-0.674905, 0.226915, 0.206202, -0.087191, 0.808893, -0.581408, -0.393839, 0.513538},
{-0.676065, 0.245060, 0.226349, -0.052126, 0.707633, -0.704611, -0.291553, 0.515648},
{-0.623183, 0.222360, 0.183177, -0.174505, 0.887783, -0.425825, -0.488061, 0.292767},
{-0.580898, 0.232520, 0.184457, -0.201941, 0.896542, -0.394208, -0.470234, 0.109730},
{-0.579658, 0.222428, 0.159293, -0.216956, 0.897855, -0.383068, -0.576824, 0.106996},
{-0.622662, 0.211322, 0.157470, -0.188269, 0.903745, -0.384381, -0.598105, 0.293242},
{-0.674787, 0.200745, 0.155689, -0.119175, 0.915098, -0.385174, -0.617530, 0.518730},
{-0.674765, 0.212584, 0.182130, -0.112003, 0.885464, -0.450942, -0.503575, 0.515801},
{-0.561195, 0.237523, 0.185167, -0.331126, 0.871578, -0.361461, -0.461069, 0.024414},
{-0.563109, 0.246884, 0.208658, -0.275216, 0.863460, -0.422681, -0.361600, 0.030232},
{-0.559755, 0.227860, 0.160019, -0.380322, 0.853694, -0.355693, -0.566899, 0.020783},
{-0.564413, 0.258064, 0.230436, -0.224799, 0.798700, -0.558123, -0.265220, 0.033399},
{-1.177113, 0.243000, 0.076393, 0.955657, 0.278390, -0.095889, 1.253738, -0.953526},
{-1.187063, 0.286025, 0.076806, 0.985351, 0.156590, -0.067446, 1.087991, -0.896559},
{-1.187407, 0.298713, 0.102293, 0.991028, 0.130222, -0.029633, 1.070446, -0.775397},
{-1.178543, 0.255952, 0.101808, 0.962279, 0.264779, -0.062136, 1.234223, -0.832451},
{-1.166416, 0.219420, 0.101807, 0.866329, 0.471541, -0.164586, 1.418614, -0.893661},
{-1.164300, 0.206603, 0.076477, 0.861202, 0.478408, -0.171545, 1.438607, -1.014208},
{-1.162826, 0.195801, 0.052482, 0.854366, 0.494858, -0.158483, 1.450174, -1.126251},
{-1.176026, 0.230591, 0.052565, 0.951598, 0.293741, -0.090274, 1.272790, -1.067423},
{-1.186634, 0.272784, 0.053113, 0.984313, 0.171239, -0.042238, 1.109695, -1.011079},
{-1.180704, 0.267128, 0.129056, 0.961974, 0.270852, -0.034913, 1.222712, -0.706291},
{-1.188861, 0.308047, 0.130078, 0.993774, 0.106845, 0.031129, 1.066905, -0.649361},
{-1.168813, 0.232797, 0.128373, 0.856594, 0.485183, -0.175420, 1.394973, -0.767053},
{-1.189122, 0.341867, 0.131258, 0.987304, -0.138951, 0.076815, 0.944006, -0.600095},
{-1.189230, 0.332097, 0.103535, 0.995758, -0.090396, 0.016083, 0.947895, -0.726650},
{-1.183685, 0.356047, 0.104687, 0.873104, -0.469619, 0.130741, 0.845957, -0.682057},
{-1.181892, 0.366570, 0.132198, 0.839961, -0.519456, 0.156896, 0.837562, -0.554662},
{-1.190202, 0.320426, 0.077956, 0.998627, -0.051881, -0.001801, 0.960488, -0.847022},
{-1.190570, 0.308890, 0.054190, 0.998688, -0.031190, 0.040590, 0.975179, -0.959703},
{-1.186085, 0.336438, 0.055263, 0.890866, -0.421522, 0.169195, 0.854953, -0.910812},
{-1.185446, 0.345627, 0.079084, 0.887326, -0.439467, 0.139592, 0.852105, -0.801199},
{-0.538564, 0.242757, 0.135179, -0.900601, 0.420972, -0.108036, 0.440979, -1.325767},
{-0.530656, 0.269542, 0.137685, -0.993439, 0.113559, -0.012940, 0.363442, -1.374791},
{-0.530404, 0.266829, 0.111170, -0.994720, 0.094272, -0.040498, 0.339071, -1.263463},
{-0.538614, 0.236155, 0.108830, -0.917570, 0.379772, -0.117588, 0.429753, -1.209395},
{-0.551003, 0.212858, 0.107079, -0.767052, 0.601947, -0.221870, 0.511052, -1.156719},
{-0.550389, 0.223815, 0.133805, -0.722983, 0.647725, -0.240181, 0.503969, -1.283596},
{-0.550283, 0.234406, 0.160618, -0.647053, 0.716178, -0.261483, 0.494603, -1.414661},
{-0.538571, 0.248850, 0.162058, -0.858608, 0.496017, -0.129368, 0.455190, -1.442723},
{-0.538247, 0.228275, 0.083246, -0.919950, 0.370586, -0.127750, 0.424496, -1.094193},
{-0.529400, 0.260712, 0.085053, -0.994079, 0.093692, -0.054781, 0.327978, -1.148656},
{-0.528835, 0.252860, 0.059742, -0.994995, 0.098422, -0.016877, 0.323258, -1.034583},
{-0.538304, 0.219940, 0.058520, -0.920896, 0.376629, -0.100131, 0.421297, -0.981827},
{-0.552049, 0.194141, 0.057108, -0.788873, 0.590594, -0.169866, 0.512069, -0.926444},
{-0.551342, 0.203013, 0.081562, -0.783624, 0.586688, -0.204077, 0.513571, -1.038221},
{-0.532144, 0.292403, 0.086142, -0.978637, -0.204443, 0.021393, 0.216577, -1.200104},
{-0.533253, 0.298418, 0.113628, -0.980102, -0.197333, 0.021241, 0.229626, -1.320311},
{-0.541966, 0.324983, 0.115412, -0.907804, -0.412976, 0.073031, 0.128219, -1.367512},
{-0.541041, 0.318527, 0.086662, -0.902799, -0.422163, 0.081820, 0.114798, -1.241552},
{-0.540335, 0.310660, 0.059525, -0.893246, -0.423505, 0.150639, 0.107984, -1.120059},
{-0.531378, 0.284604, 0.059841, -0.975372, -0.205878, 0.078860, 0.210688, -1.082085},
{-0.532923, 0.301106, 0.141618, -0.983276, -0.175665, 0.047853, 0.256810, -1.437519},
{-0.540866, 0.328982, 0.144929, -0.913907, -0.394360, 0.095950, 0.153957, -1.492772},
{-1.171712, 0.361049, 0.079429, 0.576708, -0.773400, 0.263009, 0.898341, 0.017827},
{-1.144888, 0.374043, 0.079856, 0.379559, -0.880734, 0.283181, 0.914565, 0.137855},
{-1.144528, 0.382260, 0.105166, 0.354289, -0.904233, 0.238350, 1.019185, 0.138728},
{-1.170445, 0.370506, 0.104901, 0.558641, -0.794488, 0.238075, 1.004899, 0.023049},
{-1.183685, 0.356047, 0.104687, 0.873104, -0.469619, 0.130741, 0.995075, -0.054051},
{-1.185446, 0.345627, 0.079084, 0.887326, -0.439467, 0.139592, 0.886824, -0.064433},
{-1.186085, 0.336438, 0.055263, 0.890866, -0.421522, 0.169195, 0.786995, -0.069397},
{-1.171430, 0.352954, 0.055798, 0.584185, -0.769463, 0.258126, 0.800246, 0.019497},
{-1.143681, 0.366519, 0.056493, 0.391614, -0.878842, 0.272408, 0.818120, 0.143673},
{-1.167575, 0.380138, 0.132500, 0.506851, -0.833766, 0.218818, 1.119782, 0.034888},
{-1.141590, 0.389683, 0.133097, 0.302438, -0.934843, 0.185827, 1.133032, 0.149945},
{-1.181892, 0.366570, 0.132198, 0.839961, -0.519456, 0.156896, 1.110799, -0.044823},
{-1.099358, 0.402320, 0.134921, 0.247688, -0.963042, 0.105533, 1.154819, 0.335694},
{-1.100952, 0.398096, 0.106475, 0.289224, -0.940428, 0.178625, 1.042397, 0.331566},
{-1.052769, 0.411320, 0.108382, 0.174993, -0.976562, 0.125095, 1.065354, 0.543051},
{-1.052675, 0.412999, 0.137377, 0.154759, -0.986999, 0.043001, 1.177152, 0.539673},
{-1.100863, 0.391959, 0.081229, 0.314524, -0.915494, 0.250832, 0.940199, 0.333420},
{-1.099913, 0.385213, 0.058046, 0.326243, -0.906003, 0.269539, 0.845238, 0.338412},
{-1.052173, 0.400936, 0.059617, 0.195746, -0.942442, 0.271035, 0.869497, 0.549021},
{-1.052516, 0.407010, 0.082932, 0.189520, -0.957884, 0.215644, 0.964290, 0.546351},
{-1.157351, 0.218743, 0.128210, 0.517167, 0.770592, -0.372387, -0.641450, 2.597840},
{-1.136259, 0.212933, 0.128698, 0.233009, 0.861476, -0.451125, -0.651390, 2.507414},
{-1.133981, 0.198993, 0.102682, 0.238166, 0.870205, -0.431257, -0.767577, 2.500577},
{-1.154806, 0.204724, 0.102015, 0.529618, 0.772423, -0.350475, -0.758429, 2.589870},
{-1.166416, 0.219420, 0.101807, 0.866329, 0.471541, -0.164586, -0.752159, 2.638484},
{-1.168813, 0.232797, 0.128373, 0.856594, 0.485183, -0.175420, -0.634194, 2.645983},
{-1.152575, 0.192086, 0.076815, 0.530442, 0.782861, -0.325144, -0.869519, 2.583071},
{-1.132161, 0.186550, 0.077597, 0.242897, 0.887173, -0.392254, -0.877891, 2.495523},
{-1.131030, 0.176450, 0.053568, 0.249733, 0.912717, -0.323313, -0.980447, 2.493179},
{-1.151114, 0.181900, 0.052799, 0.529435, 0.803034, -0.273415, -0.972204, 2.579309},
{-1.162826, 0.195801, 0.052482, 0.854366, 0.494858, -0.158483, -0.967240, 2.626313},
{-1.164300, 0.206603, 0.076477, 0.861202, 0.478408, -0.171545, -0.864147, 2.630982},
{-1.093281, 0.177096, 0.079014, 0.212958, 0.892056, -0.398572, -0.892263, 2.328706},
{-1.094208, 0.189356, 0.104057, 0.207160, 0.873928, -0.439650, -0.782485, 2.329927},
{-1.048322, 0.179980, 0.105122, 0.151860, 0.881771, -0.446516, -0.798609, 2.132947},
{-1.048220, 0.167731, 0.080003, 0.156987, 0.898556, -0.409772, -0.908561, 2.135283},
{-1.048154, 0.157460, 0.055669, 0.168279, 0.921842, -0.349071, -1.012394, 2.137560},
{-1.092714, 0.167017, 0.054839, 0.221076, 0.916288, -0.333934, -0.995251, 2.328793},
{-1.095476, 0.203332, 0.129969, 0.202429, 0.864589, -0.459822, -0.666699, 2.332421},
{-1.048581, 0.193877, 0.131158, 0.154759, 0.872921, -0.462630, -0.682603, 2.131092},
{-0.618906, 0.376958, 0.086590, -0.442793, -0.876125, 0.190497, 0.964708, 2.393514},
{-0.572702, 0.350208, 0.086662, -0.534165, -0.824122, 0.188208, 0.933899, 2.630896},
{-0.573093, 0.355972, 0.115154, -0.530900, -0.835780, 0.139958, 1.048800, 2.626907},
{-0.618889, 0.381911, 0.114264, -0.439680, -0.888882, 0.128544, 1.074893, 2.391283},
{-0.673693, 0.405280, 0.113562, -0.274422, -0.954314, 0.118015, 1.094270, 2.165488},
{-0.673991, 0.401012, 0.086628, -0.276589, -0.941740, 0.191321, 0.987596, 2.166667},
{-0.674028, 0.394893, 0.061325, -0.278390, -0.925169, 0.257851, 0.885197, 2.167994},
{-0.618810, 0.370202, 0.060568, -0.441450, -0.859188, 0.258614, 0.858924, 2.395274},
{-0.572378, 0.342813, 0.059835, -0.529405, -0.807825, 0.259041, 0.823546, 2.633502},
{-0.617784, 0.384588, 0.143600, -0.428236, -0.900540, 0.074618, 1.189067, 2.392574},
{-0.571788, 0.359497, 0.144731, -0.516984, -0.848964, 0.109256, 1.164867, 2.629702},
{-0.672870, 0.407310, 0.142695, -0.268410, -0.962249, 0.044527, 1.206992, 2.165348},
{-0.549985, 0.344704, 0.145571, -0.723930, -0.678610, 0.123936, 0.087759, -1.519371},
{-0.571788, 0.359497, 0.144731, -0.516984, -0.848964, 0.109256, 0.039887, -1.531644},
{-0.573093, 0.355972, 0.115154, -0.530900, -0.835780, 0.139958, 0.012507, -1.406725},
{-0.551349, 0.340582, 0.115729, -0.727928, -0.674398, 0.123478, 0.061653, -1.392637},
{-0.550654, 0.334263, 0.086760, -0.726249, -0.670705, 0.150548, 0.047151, -1.266017},
{-0.572702, 0.350208, 0.086662, -0.534165, -0.824122, 0.188208, -0.003430, -1.281990},
{-0.572378, 0.342813, 0.059835, -0.529405, -0.807825, 0.259041, -0.011759, -1.161510},
{-0.550111, 0.326514, 0.059505, -0.715995, -0.661367, 0.223304, 0.039546, -1.144235},
{-0.622319, 0.200138, 0.130556, -0.182043, 0.907682, -0.378033, -0.712675, 0.294583},
{-0.579643, 0.210574, 0.132531, -0.209937, 0.895535, -0.392315, -0.691948, 0.109792},
{-0.580264, 0.198542, 0.105632, -0.201972, 0.901669, -0.382275, -0.807802, 0.115350},
{-0.622317, 0.189060, 0.103700, -0.173650, 0.909146, -0.378521, -0.826828, 0.297381},
{-0.673519, 0.179674, 0.101508, -0.117130, 0.916776, -0.381756, -0.845794, 0.518828},
{-0.674111, 0.190074, 0.128435, -0.117832, 0.922269, -0.368053, -0.732476, 0.518618},
{-0.622820, 0.178337, 0.078171, -0.176580, 0.911832, -0.370556, -0.935622, 0.302226},
{-0.580931, 0.187913, 0.080058, -0.205267, 0.911161, -0.357219, -0.916582, 0.120900},
{-0.581974, 0.178641, 0.055664, -0.215644, 0.921812, -0.322031, -1.018846, 0.127881},
{-0.623793, 0.168639, 0.053923, -0.189123, 0.922178, -0.337260, -1.038089, 0.308928},
{-0.674603, 0.158338, 0.052016, -0.140233, 0.921598, -0.361827, -1.057614, 0.528741},
{-0.673796, 0.168650, 0.076049, -0.124668, 0.911344, -0.392254, -0.954865, 0.522722},
{-0.561337, 0.192848, 0.080844, -0.463424, 0.829951, -0.310465, -0.907252, 0.036055},
{-0.560689, 0.203398, 0.106386, -0.446364, 0.826777, -0.342296, -0.798722, 0.030595},
{-0.551003, 0.212858, 0.107079, -0.767052, 0.601947, -0.221870, -0.794614, -0.005524},
{-0.551342, 0.203013, 0.081562, -0.783624, 0.586688, -0.204077, -0.902779, -0.000550},
{-0.552049, 0.194141, 0.057108, -0.788873, 0.590594, -0.169866, -1.004475, 0.005737},
{-0.562333, 0.183758, 0.056441, -0.473098, 0.837916, -0.272134, -1.009249, 0.042815},
{-0.559874, 0.215777, 0.133268, -0.418653, 0.833338, -0.360912, -0.682360, 0.024173},
{-0.550389, 0.223815, 0.133805, -0.722983, 0.647725, -0.240181, -0.678341, -0.011860},
{-0.729376, 0.174540, -0.152125, -0.054353, 0.118046, 0.991516, 1.900031, 0.629702},
{-0.729231, 0.199585, -0.153776, -0.061007, 0.017335, 0.997955, 1.811782, 0.632950},
{-0.776741, 0.203590, -0.157149, -0.077578, 0.010651, 0.996918, 1.801195, 0.838564},
{-0.776823, 0.179591, -0.155594, -0.066652, 0.120792, 0.990417, 1.885696, 0.835212},
{-0.776357, 0.156294, -0.151423, -0.046297, 0.234352, 0.971038, 1.972897, 0.829079},
{-0.729115, 0.150890, -0.148153, -0.042390, 0.222297, 0.974029, 1.988075, 0.624437},
{-0.819004, 0.183986, -0.159424, -0.070833, 0.125919, 0.989502, 1.871794, 1.018052},
{-0.818960, 0.206785, -0.160920, -0.076876, 0.004151, 0.997009, 1.791490, 1.021385},
{-0.864378, 0.207367, -0.164009, -0.044832, -0.007233, 0.998962, 1.792652, 1.217461},
{-0.864405, 0.184807, -0.162678, -0.054109, 0.123600, 0.990844, 1.871812, 1.214119},
{-0.864674, 0.162815, -0.158262, -0.056520, 0.273171, 0.960295, 1.955225, 1.211283},
{-0.818929, 0.161458, -0.155053, -0.053896, 0.252632, 0.966033, 1.956861, 1.013666},
{-0.818791, 0.229772, -0.159641, -0.073519, -0.109867, 0.991211, 1.716033, 1.023652},
{-0.776142, 0.227803, -0.156029, -0.077883, -0.092257, 0.992676, 1.721178, 0.839186},
{-0.775059, 0.251784, -0.152551, -0.068117, -0.184484, 0.980468, 1.646532, 0.837219},
{-0.818495, 0.252784, -0.155755, -0.061556, -0.213416, 0.975005, 1.645642, 1.024852},
{-0.864909, 0.252406, -0.158196, -0.023621, -0.235054, 0.971679, 1.651551, 1.224946},
{-0.864551, 0.229860, -0.162478, -0.034364, -0.127262, 0.991241, 1.719440, 1.221078},
{-0.728674, 0.225019, -0.152883, -0.061342, -0.076388, 0.995178, 1.727179, 0.633970},
{-0.727700, 0.249948, -0.149849, -0.055574, -0.158879, 0.985717, 1.648458, 0.632694},
{-0.921509, 0.179136, -0.164422, -0.031312, 0.109165, 0.993500, 1.899239, 1.459311},
{-0.921484, 0.203534, -0.165340, -0.009339, -0.024445, 0.999634, 1.814665, 1.462837},
{-0.977003, 0.197617, -0.165283, 0.017914, -0.041780, 0.998962, 1.846177, 1.700812},
{-0.977055, 0.171614, -0.164864, -0.007324, 0.089694, 0.995941, 1.935208, 1.697276},
{-0.976529, 0.149111, -0.161188, -0.039460, 0.294992, 0.954650, 2.018722, 1.691095},
{-0.921438, 0.156795, -0.160269, -0.054415, 0.291482, 0.955016, 1.983244, 1.455013},
{-1.017780, 0.166884, -0.164214, 0.023347, 0.071810, 0.997131, 1.960853, 1.871664},
{-1.017658, 0.191948, -0.164208, 0.046358, -0.054781, 0.997406, 1.875836, 1.874682},
{-1.017256, 0.145478, -0.161137, -0.005707, 0.273476, 0.961852, 2.039458, 1.865768},
{-1.016996, 0.217513, -0.161391, 0.060457, -0.150304, 0.986755, 1.794588, 1.874882},
{-0.976422, 0.222462, -0.162735, 0.034700, -0.149968, 0.988067, 1.766853, 1.701317},
{-0.975517, 0.246695, -0.157771, 0.039430, -0.235511, 0.971038, 1.694340, 1.699854},
{-1.016001, 0.242991, -0.156442, 0.058809, -0.219611, 0.973785, 1.717802, 1.873209},
{-0.921351, 0.227000, -0.163304, 0.006348, -0.141575, 0.989898, 1.739092, 1.465174},
{-0.921202, 0.250105, -0.158611, 0.014557, -0.241493, 0.970275, 1.670020, 1.466857},
{-1.012998, 0.283987, 0.256154, 0.088260, 0.398785, -0.912778, -0.089669, 1.961706},
{-1.013219, 0.306606, 0.262407, 0.091311, 0.136998, -0.986328, -0.025358, 1.960898},
{-0.972057, 0.302935, 0.265454, 0.063753, 0.166814, -0.983917, -0.021332, 1.783537},
{-0.971824, 0.282369, 0.258313, 0.055910, 0.456587, -0.887875, -0.088426, 1.784325},
{-0.971431, 0.264747, 0.245719, 0.039857, 0.619037, -0.784326, -0.162896, 1.784936},
{-1.012524, 0.265591, 0.244631, 0.069887, 0.596240, -0.799738, -0.161637, 1.961948},
{-1.052439, 0.289649, 0.253542, 0.127720, 0.327342, -0.936216, -0.093058, 2.118337},
{-1.053220, 0.314228, 0.258578, 0.112735, 0.104770, -0.988067, -0.031733, 2.117264},
{-0.920993, 0.280251, 0.259746, 0.038026, 0.501816, -0.864101, -0.091476, 1.565447},
{-0.921141, 0.299348, 0.267737, 0.042482, 0.201178, -0.978607, -0.022004, 1.564182},
{-0.867475, 0.296539, 0.269008, 0.021058, 0.237922, -0.971038, -0.026865, 1.333019},
{-0.867425, 0.278383, 0.260326, 0.016266, 0.535295, -0.844478, -0.097389, 1.334817},
{-0.867427, 0.261463, 0.246346, 0.010346, 0.639576, -0.768609, -0.175574, 1.337172},
{-0.920820, 0.263005, 0.246301, 0.029908, 0.631123, -0.775079, -0.168321, 1.567033},
{-0.921180, 0.324315, 0.267940, 0.026673, -0.133915, -0.990631, 2.694135, 0.970186},
{-0.921141, 0.299348, 0.267737, 0.042482, 0.201178, -0.978607, 2.788670, 0.974689},
{-0.972057, 0.302935, 0.265454, 0.063753, 0.166814, -0.983917, 2.778961, 0.754835},
{-0.972134, 0.330343, 0.265382, 0.034822, -0.130284, -0.990844, 2.675496, 0.749800},
{-0.972165, 0.359573, 0.257321, -0.018464, -0.408124, -0.912717, 2.566099, 0.744843},
{-0.921190, 0.352332, 0.259664, -0.002350, -0.406781, -0.913511, 2.587918, 0.965522},
{-0.867441, 0.347919, 0.261916, 0.015412, -0.401288, -0.915799, 2.600520, 1.197680},
{-0.867474, 0.320330, 0.269907, 0.020875, -0.117496, -0.992828, 2.704727, 1.202088},
{-0.867475, 0.296539, 0.269008, 0.021058, 0.237922, -0.971038, 2.793584, 1.206329},
{-1.013261, 0.337203, 0.262642, 0.052339, -0.114444, -0.992035, 2.652675, 0.571583},
{-1.013219, 0.306606, 0.262407, 0.091311, 0.136998, -0.986328, 2.765424, 0.577026},
{-1.013257, 0.368067, 0.255345, -0.015595, -0.412152, -0.910947, 2.540161, 0.566521},
{-0.818037, 0.277513, 0.259925, -0.008911, 0.556322, -0.830897, -0.104735, 1.122182},
{-0.818061, 0.295200, 0.269020, -0.003967, 0.269936, -0.962859, -0.035406, 1.120232},
{-0.770935, 0.295073, 0.267926, -0.028413, 0.293344, -0.955565, -0.046849, 0.917159},
{-0.771000, 0.277368, 0.258638, -0.030732, 0.563036, -0.825831, -0.113802, 0.919682},
{-0.770906, 0.261667, 0.244762, -0.028199, 0.649983, -0.759392, -0.189572, 0.921522},
{-0.817989, 0.261220, 0.245819, -0.012421, 0.646840, -0.762505, -0.182319, 1.124285},
{-0.724487, 0.277677, 0.256558, -0.044740, 0.550066, -0.833918, -0.124877, 0.719459},
{-0.724131, 0.295894, 0.265878, -0.047670, 0.301065, -0.952391, -0.060414, 0.715135},
{-0.724577, 0.262195, 0.243219, -0.036042, 0.645558, -0.762841, -0.198353, 0.722033},
{-0.724184, 0.323666, 0.270275, -0.025880, -0.006592, -0.999634, 2.678172, 1.818499},
{-0.724131, 0.295894, 0.265878, -0.047670, 0.301065, -0.952391, 2.773012, 1.824881},
{-0.770935, 0.295073, 0.267926, -0.028413, 0.293344, -0.955565, 2.785938, 1.622813},
{-0.770999, 0.321064, 0.270960, -0.002594, -0.043062, -0.999054, 2.693465, 1.617359},
{-0.770950, 0.350632, 0.264812, 0.033784, -0.377514, -0.925352, 2.587749, 1.612712},
{-0.724196, 0.354413, 0.265528, 0.005249, -0.368389, -0.929624, 2.572315, 1.813408},
{-0.818088, 0.319599, 0.270876, 0.011750, -0.084872, -0.996307, 2.703410, 1.414850},
{-0.818061, 0.295200, 0.269020, -0.003967, 0.269936, -0.962859, 2.792734, 1.419500},
{-0.818029, 0.347910, 0.263620, 0.030366, -0.391095, -0.919828, 2.598807, 1.410440},
{-0.726304, 0.273475, -0.145075, -0.049409, -0.254677, 0.965758, 1.577858, 0.629057},
{-0.724724, 0.295290, -0.138007, -0.053438, -0.382580, 0.922361, 1.511317, 0.624239},
{-0.771795, 0.297197, -0.139236, -0.040834, -0.391858, 0.919095, 1.512881, 0.827157},
{-0.773524, 0.275087, -0.147032, -0.052858, -0.280251, 0.958464, 1.578142, 0.832801},
{-0.818069, 0.275660, -0.149428, -0.044801, -0.311075, 0.949309, 1.580534, 1.024982},
{-0.817588, 0.297750, -0.140818, -0.030732, -0.409650, 0.911710, 1.518068, 1.024579},
{-0.866044, 0.297294, -0.142107, -0.009949, -0.418165, 0.908292, 1.527519, 1.233252},
{-0.865438, 0.275125, -0.151268, -0.014740, -0.330088, 0.943815, 1.588360, 1.229042},
{-0.817127, 0.318402, -0.130084, -0.024476, -0.521287, 0.852992, 0.073335, 1.553822},
{-0.817588, 0.297750, -0.140818, -0.030732, -0.409650, 0.911710, 0.007826, 1.545925},
{-0.771795, 0.297197, -0.139236, -0.040834, -0.391858, 0.919095, 0.014541, 1.742021},
{-0.770134, 0.317594, -0.128928, -0.038728, -0.520127, 0.853175, 0.078809, 1.754848},
{-0.768807, 0.335497, -0.115949, -0.046327, -0.662862, 0.747276, 0.146734, 1.765531},
{-0.816775, 0.336652, -0.117047, -0.024964, -0.655049, 0.755150, 0.141799, 1.560454},
{-0.867136, 0.336690, -0.118044, -0.008972, -0.651326, 0.758721, 0.135991, 1.344657},
{-0.866634, 0.318188, -0.131121, -0.009095, -0.519822, 0.854213, 0.067148, 1.341599},
{-0.866044, 0.297294, -0.142107, -0.009949, -0.418165, 0.908292, 0.000959, 1.338019},
{-0.723196, 0.315078, -0.128088, -0.074282, -0.529496, 0.845027, 0.081304, 1.955022},
{-0.724724, 0.295290, -0.138007, -0.053438, -0.382580, 0.922361, 0.018675, 1.943003},
{-0.721973, 0.332273, -0.115227, -0.107944, -0.677725, 0.727317, 0.148043, 1.965001},
{-0.921128, 0.273414, -0.151561, 0.014924, -0.327342, 0.944762, 1.604948, 1.468421},
{-0.921107, 0.296176, -0.142457, 0.010468, -0.409650, 0.912168, 1.541878, 1.469926},
{-0.973465, 0.294257, -0.142258, 0.027863, -0.392438, 0.919340, 1.559092, 1.694669},
{-0.974492, 0.270860, -0.150940, 0.034791, -0.310739, 0.949828, 1.625738, 1.697488},
{-1.014880, 0.267794, -0.150039, 0.046052, -0.286416, 0.956969, 1.646169, 1.870611},
{-1.013805, 0.291399, -0.141899, 0.034730, -0.374737, 0.926450, 1.577111, 1.867549},
{-1.012946, 0.313283, -0.131740, 0.039308, -0.502853, 0.863460, 0.053705, 0.712355},
{-1.013805, 0.291399, -0.141899, 0.034730, -0.374737, 0.926450, -0.010569, 0.702649},
{-0.973465, 0.294257, -0.142258, 0.027863, -0.392438, 0.919340, -0.007093, 0.876535},
{-0.972556, 0.316186, -0.131738, 0.026093, -0.503067, 0.863826, 0.058386, 0.886693},
{-0.971880, 0.335378, -0.118563, 0.034822, -0.657918, 0.752251, 0.128366, 0.895054},
{-1.012372, 0.332241, -0.118611, 0.066683, -0.673116, 0.736503, 0.123263, 0.720201},
{-0.921114, 0.317635, -0.131602, 0.006165, -0.511856, 0.859004, 0.062516, 1.107832},
{-0.921107, 0.296176, -0.142457, 0.010468, -0.409650, 0.912168, -0.003632, 1.101607},
{-0.921153, 0.336563, -0.118462, 0.007141, -0.652211, 0.757958, 0.132061, 1.113031},
{-0.726667, 0.098020, -0.122594, -0.057680, 0.816889, 0.573870, 2.217646, 0.601303},
{-0.727576, 0.111713, -0.133646, -0.031251, 0.535630, 0.843867, 2.149441, 0.609365},
{-0.773958, 0.114564, -0.135514, -0.003601, 0.512650, 0.858577, 2.145531, 0.809665},
{-0.772559, 0.098709, -0.123974, 0.004334, 0.775170, 0.631703, 2.221935, 0.799088},
{-0.771354, 0.092250, -0.110125, 0.012757, 0.999603, -0.023927, 2.294281, 0.788446},
{-0.725860, 0.093228, -0.108923, -0.075411, 0.994995, -0.065249, 2.281265, 0.593212},
{-0.818232, 0.101751, -0.125910, 0.024964, 0.746269, 0.665151, 2.217094, 0.996380},
{-0.818490, 0.118904, -0.137843, -0.001099, 0.512345, 0.858760, 2.135275, 1.002307},
{-0.865939, 0.122966, -0.140243, -0.007782, 0.544603, 0.838649, 2.126417, 1.207475},
{-0.866667, 0.106173, -0.128123, 0.034272, 0.746025, 0.664998, 2.207586, 1.205801},
{-0.867311, 0.097749, -0.114184, 0.079531, 0.993408, 0.082278, 2.286729, 1.204146},
{-0.818024, 0.093896, -0.112006, 0.053957, 0.997986, 0.033052, 2.295488, 0.990457},
{-0.818740, 0.139285, -0.147709, -0.027528, 0.380322, 0.924406, 2.046610, 1.008244},
{-0.775313, 0.134188, -0.144697, -0.021638, 0.360332, 0.932554, 2.061014, 0.820113},
{-0.865230, 0.142024, -0.150536, -0.039979, 0.422285, 0.905576, 2.041195, 1.209185},
{-0.728453, 0.129643, -0.142080, -0.030000, 0.353832, 0.934812, 2.072064, 0.617367},
{-0.920843, 0.111002, -0.130334, 0.030519, 0.785943, 0.617512, 2.197876, 1.439975},
{-0.921075, 0.124983, -0.142322, -0.022279, 0.618000, 0.785821, 2.126700, 1.445353},
{-0.973861, 0.124472, -0.144087, -0.052614, 0.698843, 0.713309, 2.135701, 1.672702},
{-0.972254, 0.114150, -0.132426, -0.002960, 0.853633, 0.520798, 2.193537, 1.661991},
{-0.970875, 0.108505, -0.118278, 0.060335, 0.996094, 0.064364, 2.253185, 1.650900},
{-0.920659, 0.103391, -0.116276, 0.085360, 0.991424, 0.098910, 2.269845, 1.434414},
{-1.012392, 0.113531, -0.134283, -0.000580, 0.926115, 0.377178, 2.200143, 1.834936},
{-1.014261, 0.120951, -0.145543, -0.048402, 0.756462, 0.652211, 2.152996, 1.846284},
{-1.050198, 0.114949, -0.135492, 0.112583, 0.975036, 0.191321, 2.212222, 1.983346},
{-1.048928, 0.114920, -0.121556, 0.150548, 0.985229, -0.081484, 2.241302, 1.973507},
{-1.010767, 0.110774, -0.120187, 0.064913, 0.997742, -0.016022, 2.245100, 1.823240},
{-1.015983, 0.130883, -0.154704, -0.040040, 0.539750, 0.840846, 2.101470, 1.856935},
{-0.975375, 0.134761, -0.153969, -0.062807, 0.542650, 0.837581, 2.081491, 1.682654},
{-0.921283, 0.139495, -0.152601, -0.054445, 0.489944, 0.870022, 2.057110, 1.450363},
{-1.013340, 0.391485, 0.239005, -0.045320, -0.704337, -0.708396, 2.428117, 0.562221},
{-1.013457, 0.406973, 0.217461, -0.013398, -0.897214, -0.441328, 2.316308, 0.558301},
{-0.972399, 0.404909, 0.218787, -0.029267, -0.855617, -0.516709, 2.317636, 0.735328},
{-0.972264, 0.385610, 0.240493, -0.044862, -0.655202, -0.754082, 2.444834, 0.740046},
{-0.921247, 0.380583, 0.242216, -0.019929, -0.625446, -0.779992, 2.458338, 0.960534},
{-0.921341, 0.402938, 0.219850, -0.018952, -0.827937, -0.560472, 2.317078, 0.955385},
{-0.867337, 0.401491, 0.220728, -0.005005, -0.818628, -0.574297, 2.315360, 1.188028},
{-0.867391, 0.377469, 0.243927, 0.005066, -0.616382, -0.787408, 2.465615, 1.192937},
{-0.921458, 0.413268, 0.196822, -0.013276, -0.965545, -0.259835, 1.408437, 1.093374},
{-0.921341, 0.402938, 0.219850, -0.018952, -0.827937, -0.560472, 1.492614, 1.088665},
{-0.972399, 0.404909, 0.218787, -0.029267, -0.855617, -0.516709, 1.488247, 0.870246},
{-0.972540, 0.413925, 0.196094, -0.008087, -0.972503, -0.232704, 1.404262, 0.874688},
{-0.972620, 0.416532, 0.170923, -0.001648, -0.998596, -0.052705, 1.311431, 0.879215},
{-0.921559, 0.416125, 0.171563, -0.010559, -0.998413, -0.055208, 1.315529, 1.097920},
{-0.867287, 0.415487, 0.171569, -0.009156, -0.998260, -0.058046, 1.317114, 1.330402},
{-0.867290, 0.412497, 0.197109, -0.009796, -0.962706, -0.270272, 1.410944, 1.325315},
{-0.867337, 0.401491, 0.220728, -0.005005, -0.818628, -0.574297, 1.496711, 1.319726},
{-1.013554, 0.414047, 0.194553, 0.025330, -0.982513, -0.184362, 1.396858, 0.699090},
{-1.013457, 0.406973, 0.217461, -0.013398, -0.897214, -0.441328, 1.483422, 0.694739},
{-1.013544, 0.416136, 0.169087, 0.042817, -0.998138, -0.043092, 1.302373, 0.703847},
{-0.817796, 0.377333, 0.245379, 0.028138, -0.625843, -0.779412, 2.463647, 1.406508},
{-0.817442, 0.400997, 0.221499, 0.009278, -0.825526, -0.564257, 2.313207, 1.402814},
{-0.769901, 0.401166, 0.222128, 0.017335, -0.842921, -0.537736, 2.310098, 1.607460},
{-0.770545, 0.379066, 0.246550, 0.039949, -0.647298, -0.761162, 2.455545, 1.609682},
{-0.723719, 0.381558, 0.247417, 0.003937, -0.676565, -0.736351, 2.444422, 1.810898},
{-0.722963, 0.401705, 0.222578, -0.031220, -0.866207, -0.498672, 2.305511, 1.809679},
{-0.722139, 0.411461, 0.197644, -0.063112, -0.969176, -0.238136, 1.417847, 1.947275},
{-0.722963, 0.401705, 0.222578, -0.031220, -0.866207, -0.498672, 1.507888, 1.937996},
{-0.769901, 0.401166, 0.222128, 0.017335, -0.842921, -0.537736, 1.504507, 1.736672},
{-0.769136, 0.411731, 0.197496, -0.001099, -0.965697, -0.259621, 1.415638, 1.745867},
{-0.768612, 0.414983, 0.171423, -0.004975, -0.997894, -0.064425, 1.320081, 1.753376},
{-0.721662, 0.414626, 0.171377, -0.076510, -0.995178, -0.061220, 1.321457, 1.954577},
{-0.817018, 0.412030, 0.197326, -0.003754, -0.963012, -0.269326, 1.413341, 1.540680},
{-0.817442, 0.400997, 0.221499, 0.009278, -0.825526, -0.564257, 1.500729, 1.533155},
{-0.816729, 0.415188, 0.171505, -0.005188, -0.998077, -0.061434, 1.318632, 1.547102},
{-1.009973, 0.216202, 0.184416, 0.104831, 0.865261, -0.490188, -0.459111, 1.959201},
{-1.010800, 0.230947, 0.208398, 0.088717, 0.810541, -0.578906, -0.348936, 1.959873},
{-0.970277, 0.228274, 0.209255, 0.060427, 0.797815, -0.599841, -0.354041, 1.785477},
{-0.969749, 0.212651, 0.185009, 0.072573, 0.863582, -0.498917, -0.466603, 1.786186},
{-0.969358, 0.198555, 0.158334, 0.071017, 0.890744, -0.448897, -0.585228, 1.787531},
{-1.009377, 0.202398, 0.158224, 0.106815, 0.882534, -0.457900, -0.575543, 1.959611},
{-0.920627, 0.208678, 0.184790, 0.051088, 0.866695, -0.496200, -0.478501, 1.574929},
{-0.920639, 0.224615, 0.209433, 0.046632, 0.789331, -0.612140, -0.364043, 1.571951},
{-0.867817, 0.221688, 0.209093, 0.015992, 0.788903, -0.614246, -0.374940, 1.344684},
{-0.868060, 0.205957, 0.184127, 0.012787, 0.875546, -0.482894, -0.490175, 1.348770},
{-0.868228, 0.192702, 0.156597, 0.002472, 0.908963, -0.416822, -0.610372, 1.352522},
{-0.920626, 0.194810, 0.157620, 0.044771, 0.899594, -0.434370, -0.598461, 1.577975},
{-0.920703, 0.243592, 0.229733, 0.034486, 0.691916, -0.721122, -0.259913, 1.569260},
{-0.970876, 0.246178, 0.229429, 0.043306, 0.705313, -0.707541, -0.252120, 1.785190},
{-0.867582, 0.241377, 0.229551, 0.011414, 0.684011, -0.729362, -0.269082, 1.340639},
{-1.011720, 0.247661, 0.228591, 0.070467, 0.717765, -0.692679, -0.248919, 1.961063},
{-0.817506, 0.206166, 0.183394, -0.022858, 0.884793, -0.465377, -0.496993, 1.131053},
{-0.817738, 0.221208, 0.208400, -0.015870, 0.792962, -0.609027, -0.382732, 1.129066},
{-0.769632, 0.222116, 0.207515, -0.029389, 0.795923, -0.604663, -0.388694, 0.921844},
{-0.768946, 0.207644, 0.182690, -0.030488, 0.889737, -0.455397, -0.501391, 0.921820},
{-0.768261, 0.195876, 0.155249, -0.033876, 0.921018, -0.388012, -0.618851, 0.921771},
{-0.817213, 0.193767, 0.155780, -0.033387, 0.916105, -0.399518, -0.616090, 1.132755},
{-0.722359, 0.208731, 0.182118, -0.048463, 0.888455, -0.456374, -0.505802, 0.721110},
{-0.722724, 0.223352, 0.206600, -0.045808, 0.797296, -0.601825, -0.394100, 0.719766},
{-0.722053, 0.196899, 0.155083, -0.048006, 0.921781, -0.384686, -0.621888, 0.722668},
{-0.723726, 0.242630, 0.226767, -0.038057, 0.686880, -0.725730, -0.289855, 0.721104},
{-0.770368, 0.241687, 0.227963, -0.028657, 0.682669, -0.730155, -0.282978, 0.921994},
{-0.817895, 0.241005, 0.228926, -0.014344, 0.682028, -0.731162, -0.276412, 1.126695},
{-1.013337, 0.416672, 0.139869, 0.043123, -0.998779, 0.023225, 1.192044, 0.709417},
{-1.013031, 0.415236, 0.110443, 0.037446, -0.993805, 0.104343, 1.078877, 0.714671},
{-0.972414, 0.414470, 0.112137, -0.018372, -0.993866, 0.108798, 1.086175, 0.888292},
{-0.972571, 0.416604, 0.141783, -0.008057, -0.999451, 0.031556, 1.200908, 0.883912},
{-0.921606, 0.416061, 0.142502, -0.011750, -0.999115, 0.040101, 1.205158, 1.102140},
{-0.921593, 0.413647, 0.112942, -0.015046, -0.993011, 0.116977, 1.090456, 1.105780},
{-0.867469, 0.413007, 0.113285, -0.008789, -0.992645, 0.120518, 1.093312, 1.337577},
{-0.867367, 0.415462, 0.142608, -0.008271, -0.999084, 0.041810, 1.207161, 1.334483},
{-0.921512, 0.409455, 0.086188, -0.018097, -0.981170, 0.192175, 0.984557, 1.108586},
{-0.972167, 0.410459, 0.085448, -0.023957, -0.981445, 0.190130, 0.980718, 0.891871},
{-0.971927, 0.404639, 0.060760, -0.023957, -0.963347, 0.267159, 0.880975, 0.894409},
{-0.921426, 0.403574, 0.061281, -0.018311, -0.964538, 0.263283, 0.883915, 1.110478},
{-0.867583, 0.402805, 0.061730, -0.007843, -0.966155, 0.257759, 0.887025, 1.341003},
{-0.867532, 0.408708, 0.086663, -0.009400, -0.981048, 0.193487, 0.987795, 1.339705},
{-1.012726, 0.411410, 0.084351, 0.036653, -0.980041, 0.195288, 0.975879, 0.718480},
{-1.012511, 0.405585, 0.060363, 0.038514, -0.961821, 0.270913, 0.878789, 0.720805},
{-0.816778, 0.415228, 0.142685, -0.003388, -0.999176, 0.040315, 1.209283, 1.551320},
{-0.816941, 0.412793, 0.113595, -0.002136, -0.992737, 0.120090, 1.096336, 1.554124},
{-0.768956, 0.412833, 0.113731, 0.001251, -0.993164, 0.116489, 1.098859, 1.759892},
{-0.768687, 0.415145, 0.142679, -0.002197, -0.999329, 0.035951, 1.211145, 1.757514},
{-0.721944, 0.415001, 0.142535, -0.078433, -0.996368, 0.032899, 1.212366, 1.957925},
{-0.722460, 0.412958, 0.113552, -0.076754, -0.990509, 0.113926, 1.100215, 1.959352},
{-0.722683, 0.408870, 0.086859, -0.076296, -0.978881, 0.189520, 0.994643, 1.960890},
{-0.769009, 0.408664, 0.087049, 0.003327, -0.982055, 0.188482, 0.993253, 1.762124},
{-0.768899, 0.402987, 0.061887, 0.003510, -0.968719, 0.248085, 0.891852, 1.764232},
{-0.722654, 0.403094, 0.061728, -0.079073, -0.964141, 0.253273, 0.893258, 1.962609},
{-0.816994, 0.408527, 0.086967, -0.000763, -0.981506, 0.191351, 0.990832, 1.556306},
{-0.816974, 0.402750, 0.061909, 0.001892, -0.968017, 0.250862, 0.889723, 1.557976},
{-1.009259, 0.162461, 0.079505, 0.087252, 0.901639, -0.423566, -0.922714, 1.967922},
{-1.009157, 0.175029, 0.104858, 0.084201, 0.890957, -0.446150, -0.811408, 1.964663},
{-0.969104, 0.172300, 0.103747, 0.046937, 0.897244, -0.438978, -0.823566, 1.792437},
{-0.969113, 0.159395, 0.078089, 0.046419, 0.899655, -0.434095, -0.936530, 1.795343},
{-0.969152, 0.147973, 0.053676, 0.057283, 0.922391, -0.381909, -1.042568, 1.798168},
{-1.009342, 0.151639, 0.055116, 0.100955, 0.925077, -0.366100, -1.027654, 1.970885},
{-0.920493, 0.156640, 0.076326, 0.022492, 0.898221, -0.438948, -0.951819, 1.586266},
{-0.920552, 0.169586, 0.102269, 0.025300, 0.902371, -0.430189, -0.837765, 1.583630},
{-0.868166, 0.168316, 0.100794, -0.012604, 0.905850, -0.423383, -0.849877, 1.358193},
{-0.868078, 0.155476, 0.074748, -0.014100, 0.897519, -0.440718, -0.964119, 1.360701},
{-0.868030, 0.143572, 0.050322, -0.010437, 0.913236, -0.407270, -1.071022, 1.363192},
{-0.920460, 0.144880, 0.051846, 0.028840, 0.917753, -0.396039, -1.058673, 1.588810},
{-0.920599, 0.182045, 0.129740, 0.034394, 0.908933, -0.415479, -0.719098, 1.580871},
{-0.969164, 0.185229, 0.130870, 0.058779, 0.899197, -0.433515, -0.705340, 1.789724},
{-0.868240, 0.180440, 0.128448, -0.006867, 0.915677, -0.401807, -0.731117, 1.355565},
{-1.009151, 0.188508, 0.131401, 0.095126, 0.886685, -0.452467, -0.694330, 1.961662},
{-0.816544, 0.157178, 0.073888, -0.046602, 0.896329, -0.440901, -0.968966, 1.138653},
{-0.816610, 0.169917, 0.099687, -0.045351, 0.906980, -0.418653, -0.855772, 1.136076},
{-0.767022, 0.172733, 0.099297, -0.047609, 0.910581, -0.410535, -0.856895, 0.922287},
{-0.767025, 0.160296, 0.073804, -0.054872, 0.898923, -0.434645, -0.968486, 0.925115},
{-0.767335, 0.148622, 0.050028, -0.063326, 0.911039, -0.407361, -1.072660, 0.929081},
{-0.816630, 0.145263, 0.049802, -0.046785, 0.909726, -0.412549, -1.074667, 1.141695},
{-0.720654, 0.163378, 0.074559, -0.071474, 0.906095, -0.416974, -0.964803, 0.725079},
{-0.720540, 0.175109, 0.099972, -0.059694, 0.916532, -0.395428, -0.854693, 0.721833},
{-0.721222, 0.152323, 0.050742, -0.087191, 0.917142, -0.388836, -1.068057, 0.730111},
{-0.721226, 0.185987, 0.127257, -0.051637, 0.927274, -0.370708, -0.739286, 0.721969},
{-0.767527, 0.184416, 0.126948, -0.040254, 0.923551, -0.381298, -0.738851, 0.921549},
{-0.816874, 0.181899, 0.127431, -0.041353, 0.919248, -0.391461, -0.736915, 1.134270},
{-1.180907, 0.178245, -0.101284, 0.890500, 0.445784, -0.090701, 1.283877, -1.767832},
{-1.191035, 0.209813, -0.098380, 0.987030, 0.134770, -0.087130, 1.162859, -1.715728},
{-1.189101, 0.215634, -0.078278, 0.982971, 0.124180, -0.135228, 1.166246, -1.625386},
{-1.179604, 0.180990, -0.081361, 0.911771, 0.386700, -0.138127, 1.297803, -1.682345},
{-1.165535, 0.156396, -0.083759, 0.809137, 0.584582, -0.059420, 1.435724, -1.717697},
{-1.165943, 0.157063, -0.103602, 0.766961, 0.641560, -0.011414, 1.371576, -1.803251},
{-1.177401, 0.186854, -0.059471, 0.930876, 0.320688, -0.174993, 1.303313, -1.584577},
{-1.185908, 0.225314, -0.057093, 0.981170, 0.114994, -0.155126, 1.157788, -1.525364},
{-1.183102, 0.235897, -0.035258, 0.987304, 0.115787, -0.108463, 1.146437, -1.421541},
{-1.175285, 0.194754, -0.036709, 0.947935, 0.275826, -0.159032, 1.302283, -1.480568},
{-1.164190, 0.163538, -0.037817, 0.840785, 0.504898, -0.195196, 1.458374, -1.538445},
{-1.164941, 0.158395, -0.061324, 0.833125, 0.535936, -0.136509, 1.442958, -1.640149},
{-1.185642, 0.268956, -0.054876, 0.993439, -0.111850, -0.023621, 1.000506, -1.458867},
{-1.187519, 0.259778, -0.075341, 0.989624, -0.141667, -0.023103, 1.009064, -1.555107},
{-1.177069, 0.299329, -0.073462, 0.881100, -0.453902, 0.132603, 0.839068, -1.478167},
{-1.177171, 0.306386, -0.053308, 0.888699, -0.433943, 0.147862, 0.837345, -1.388730},
{-1.177906, 0.313374, -0.032836, 0.893765, -0.418561, 0.161077, 0.835972, -1.297725},
{-1.184393, 0.278391, -0.033884, 0.996826, -0.078799, 0.010224, 0.991082, -1.360209},
{-1.188959, 0.253518, -0.095656, 0.986511, -0.163610, 0.000183, 1.007462, -1.646836},
{-1.177253, 0.293485, -0.094442, 0.866482, -0.480636, 0.134739, 0.834874, -1.569549},
{-1.174243, 0.203608, -0.014170, 0.955138, 0.268014, -0.125736, 1.296591, -1.376359},
{-1.182330, 0.244426, -0.013208, 0.990539, 0.130039, -0.043336, 1.141144, -1.319797},
{-1.183102, 0.252519, 0.008850, 0.988525, 0.150914, -0.002503, 1.136154, -1.218793},
{-1.174154, 0.212633, 0.008105, 0.954772, 0.282632, -0.092074, 1.289159, -1.273127},
{-1.162606, 0.181629, 0.007830, 0.844020, 0.500839, -0.191656, 1.445845, -1.326300},
{-1.163316, 0.172300, -0.014757, 0.839930, 0.494797, -0.222877, 1.454229, -1.431914},
{-1.174894, 0.221048, 0.030076, 0.952391, 0.295633, -0.074404, 1.282911, -1.172052},
{-1.184925, 0.261793, 0.030709, 0.985809, 0.167821, 0.000702, 1.125710, -1.117189},
{-1.162352, 0.188469, 0.029921, 0.849727, 0.504593, -0.152623, 1.448540, -1.227347},
{-1.188864, 0.299526, 0.031905, 0.995239, -0.026032, 0.093875, 0.985364, -1.063188},
{-1.186485, 0.291861, 0.010160, 0.995025, -0.032929, 0.093905, 0.990510, -1.162139},
{-1.181943, 0.324136, 0.011429, 0.898068, -0.395947, 0.191412, 0.848546, -1.104325},
{-1.184507, 0.329610, 0.033098, 0.893490, -0.404584, 0.194861, 0.853446, -1.009618},
{-1.184834, 0.285420, -0.011987, 0.996979, -0.050874, 0.058229, 0.990083, -1.261223},
{-1.179619, 0.319007, -0.010903, 0.898282, -0.403180, 0.174627, 0.841213, -1.201642},
{-0.539626, 0.211976, 0.034745, -0.920988, 0.383282, -0.069399, 0.416244, -0.873968},
{-0.529905, 0.244936, 0.035644, -0.994629, 0.099277, 0.028413, 0.318008, -0.925453},
{-0.531581, 0.236935, 0.012129, -0.994720, 0.098941, 0.027039, 0.312912, -0.818621},
{-0.541357, 0.204006, 0.011482, -0.919858, 0.384655, -0.076601, 0.411283, -0.768206},
{-0.555635, 0.178137, 0.010582, -0.783502, 0.599322, -0.164006, 0.502585, -0.715345},
{-0.553766, 0.186107, 0.033568, -0.788324, 0.597705, -0.145695, 0.507088, -0.819734},
{-0.542640, 0.195656, -0.011711, -0.919584, 0.379833, -0.100314, 0.408360, -0.662127},
{-0.532836, 0.228847, -0.011431, -0.994690, 0.102878, 0.000580, 0.308655, -0.711441},
{-0.533580, 0.220818, -0.034620, -0.993652, 0.109684, -0.024720, 0.305400, -0.605810},
{-0.543455, 0.187234, -0.034384, -0.920194, 0.372662, -0.119633, 0.407016, -0.558009},
{-0.557470, 0.160518, -0.034377, -0.779809, 0.587390, -0.216407, 0.505145, -0.507967},
{-0.556795, 0.169455, -0.012215, -0.779778, 0.594348, -0.196600, 0.502518, -0.610533},
{-0.535439, 0.259891, -0.011758, -0.972747, -0.210578, 0.096774, 0.197857, -0.756193},
{-0.534625, 0.268317, 0.011861, -0.967223, -0.216071, 0.133183, 0.200401, -0.864148},
{-0.544194, 0.293826, 0.011360, -0.877224, -0.432661, 0.207953, 0.098466, -0.900617},
{-0.544528, 0.284833, -0.012218, -0.883328, -0.436964, 0.169591, 0.098608, -0.791948},
{-0.543972, 0.275619, -0.035619, -0.885311, -0.437452, 0.157476, 0.101007, -0.683597},
{-0.535546, 0.251418, -0.035125, -0.977355, -0.198645, 0.072665, 0.196809, -0.649128},
{-0.532738, 0.276565, 0.035404, -0.967620, -0.210944, 0.138493, 0.204987, -0.971439},
{-0.542091, 0.302431, 0.034850, -0.878689, -0.425092, 0.217109, 0.102066, -1.008201},
{-0.543786, 0.179049, -0.056086, -0.921659, 0.370983, -0.113559, 0.406795, -0.458126},
{-0.533725, 0.212994, -0.057018, -0.992798, 0.115329, -0.031800, 0.303312, -0.503627},
{-0.533899, 0.206137, -0.078284, -0.992889, 0.118809, -0.000458, 0.299312, -0.407455},
{-0.543940, 0.173168, -0.076757, -0.921659, 0.384289, -0.053163, 0.400234, -0.365803},
{-0.558028, 0.146631, -0.075608, -0.790368, 0.610218, -0.053926, 0.499560, -0.322386},
{-0.557880, 0.151781, -0.055463, -0.785668, 0.589923, -0.186163, 0.508722, -0.410315},
{-0.544224, 0.171659, -0.096337, -0.911679, 0.410840, 0.005737, 0.379869, -0.284365},
{-0.534729, 0.201011, -0.098078, -0.992401, 0.117954, 0.034608, 0.290322, -0.319858},
{-0.557913, 0.148459, -0.094947, -0.770012, 0.633931, 0.071963, 0.463969, -0.248988},
{-0.536887, 0.228835, -0.099450, -0.967437, -0.211127, 0.139439, 0.189880, -0.355583},
{-0.535499, 0.235304, -0.079544, -0.974883, -0.196356, 0.104953, 0.195197, -0.445575},
{-0.543607, 0.257882, -0.080374, -0.868343, -0.450850, 0.206580, 0.104993, -0.476258},
{-0.545362, 0.251064, -0.100304, -0.854427, -0.464003, 0.233680, 0.100323, -0.385686},
{-0.535309, 0.243027, -0.057911, -0.978698, -0.192328, 0.071718, 0.196715, -0.544506},
{-0.543404, 0.266351, -0.058575, -0.880673, -0.441908, 0.170598, 0.104178, -0.576964},
{-1.158495, 0.313837, -0.096069, 0.551347, -0.789300, 0.270119, 0.183709, 0.082958},
{-1.130740, 0.323999, -0.098630, 0.285928, -0.889981, 0.355174, 0.185686, 0.206333},
{-1.133216, 0.331510, -0.075123, 0.322245, -0.897885, 0.299844, 0.282612, 0.195048},
{-1.159963, 0.320191, -0.073552, 0.578387, -0.775109, 0.254189, 0.275716, 0.075695},
{-1.177069, 0.299329, -0.073462, 0.881100, -0.453902, 0.132603, 0.266984, -0.016587},
{-1.177253, 0.293485, -0.094442, 0.866482, -0.480636, 0.134739, 0.183397, -0.017179},
{-1.161062, 0.326212, -0.052875, 0.581744, -0.772668, 0.254006, 0.360405, 0.070166},
{-1.134541, 0.337452, -0.053587, 0.332133, -0.903165, 0.271920, 0.370474, 0.188386},
{-1.135677, 0.343110, -0.032425, 0.336192, -0.898282, 0.282846, 0.456627, 0.182482},
{-1.162391, 0.331986, -0.032367, 0.579272, -0.773522, 0.256996, 0.444193, 0.063576},
{-1.177906, 0.313374, -0.032836, 0.893765, -0.418561, 0.161077, 0.431850, -0.026345},
{-1.177171, 0.306386, -0.053308, 0.888699, -0.433943, 0.147862, 0.348646, -0.019610},
{-1.094834, 0.349127, -0.055450, 0.250984, -0.926328, 0.280892, 0.377165, 0.363495},
{-1.093842, 0.342430, -0.077688, 0.236335, -0.912687, 0.333293, 0.285838, 0.368544},
{-1.050582, 0.351617, -0.080129, 0.177770, -0.915220, 0.361522, 0.287896, 0.558008},
{-1.051066, 0.358848, -0.057463, 0.178777, -0.942808, 0.281320, 0.381422, 0.555281},
{-1.051439, 0.365872, -0.033738, 0.168676, -0.934385, 0.313761, 0.478755, 0.552790},
{-1.095588, 0.355624, -0.032961, 0.258003, -0.916807, 0.304758, 0.469243, 0.359355},
{-1.092043, 0.333395, -0.100222, 0.194250, -0.878170, 0.437086, 0.190995, 0.376184},
{-1.049985, 0.341319, -0.101111, 0.145940, -0.846400, 0.512101, 0.197580, 0.559763},
{-1.164552, 0.337602, -0.010352, 0.588366, -0.766991, 0.255928, 0.533498, 0.053131},
{-1.137585, 0.349767, -0.010042, 0.353221, -0.887722, 0.295236, 0.548425, 0.173470},
{-1.139815, 0.356198, 0.012567, 0.378582, -0.884976, 0.271035, 0.640829, 0.162951},
{-1.167115, 0.342822, 0.012049, 0.598621, -0.762139, 0.246467, 0.623843, 0.040746},
{-1.181943, 0.324136, 0.011429, 0.898068, -0.395947, 0.191412, 0.609540, -0.049485},
{-1.179619, 0.319007, -0.010903, 0.898282, -0.403180, 0.174627, 0.520062, -0.036891},
{-1.169653, 0.347409, 0.033718, 0.595203, -0.765954, 0.242958, 0.710753, 0.028335},
{-1.141919, 0.361177, 0.034404, 0.393597, -0.884548, 0.250221, 0.728801, 0.152529},
{-1.184507, 0.329610, 0.033098, 0.893490, -0.404584, 0.194861, 0.696543, -0.062367},
{-1.098924, 0.379167, 0.035791, 0.320444, -0.906522, 0.274789, 0.754525, 0.343702},
{-1.097857, 0.372543, 0.013527, 0.297433, -0.902066, 0.312662, 0.663182, 0.349106},
{-1.051880, 0.385649, 0.014259, 0.173132, -0.919462, 0.352977, 0.681465, 0.551266},
{-1.051999, 0.393964, 0.037025, 0.188330, -0.932096, 0.309275, 0.776511, 0.550510},
{-1.096670, 0.364062, -0.009679, 0.272195, -0.901181, 0.337230, 0.566335, 0.354441},
{-1.051702, 0.375545, -0.009580, 0.164281, -0.916013, 0.365917, 0.580491, 0.551738},
{-1.150880, 0.175234, 0.030158, 0.526444, 0.814997, -0.242042, -1.063965, 2.580453},
{-1.130822, 0.169540, 0.030718, 0.255654, 0.927519, -0.272561, -1.073361, 2.494468},
{-1.131214, 0.163219, 0.008230, 0.245582, 0.921995, -0.299295, -1.163942, 2.498273},
{-1.151422, 0.168933, 0.007928, 0.512162, 0.809107, -0.288034, -1.153580, 2.584881},
{-1.162606, 0.181629, 0.007830, 0.844020, 0.500839, -0.191656, -1.147644, 2.632011},
{-1.162352, 0.188469, 0.029921, 0.849727, 0.504593, -0.152623, -1.058524, 2.627311},
{-1.152289, 0.159840, -0.014853, 0.494339, 0.804956, -0.328043, -1.249826, 2.590973},
{-1.131886, 0.154885, -0.014713, 0.217994, 0.917081, -0.333720, -1.259501, 2.503475},
{-1.132501, 0.146155, -0.038095, 0.201697, 0.931089, -0.303873, -1.357294, 2.508492},
{-1.153069, 0.150824, -0.038161, 0.503342, 0.818262, -0.277535, -1.347819, 2.596721},
{-1.164190, 0.163538, -0.037817, 0.840785, 0.504898, -0.195196, -1.341123, 2.644407},
{-1.163316, 0.172300, -0.014757, 0.839930, 0.494797, -0.222877, -1.244249, 2.638448},
{-1.092829, 0.146096, -0.014590, 0.195044, 0.938536, -0.284707, -1.277372, 2.335932},
{-1.092597, 0.153160, 0.008563, 0.221656, 0.935514, -0.275063, -1.183160, 2.332710},
{-1.047824, 0.143031, 0.008648, 0.173803, 0.952055, -0.251747, -1.203936, 2.140657},
{-1.047676, 0.137247, -0.014640, 0.153813, 0.960875, -0.230262, -1.296508, 2.142148},
{-1.047584, 0.132209, -0.037912, 0.123722, 0.971313, -0.202948, -1.387763, 2.143820},
{-1.093064, 0.139075, -0.037973, 0.159246, 0.951079, -0.264657, -1.372327, 2.339175},
{-1.092522, 0.159586, 0.031530, 0.228309, 0.932829, -0.278695, -1.090669, 2.330230},
{-1.048003, 0.149498, 0.031984, 0.177343, 0.941496, -0.286538, -1.110042, 2.139239},
{-1.153350, 0.144754, -0.061967, 0.537522, 0.826197, -0.168645, -1.442676, 2.600120},
{-1.132721, 0.138645, -0.061902, 0.218482, 0.951231, -0.217597, -1.454580, 2.511743},
{-1.132784, 0.134504, -0.084614, 0.261422, 0.963042, -0.064455, -1.563807, 2.567250},
{-1.153406, 0.142396, -0.084644, 0.563707, 0.825617, -0.023896, -1.535964, 2.602344},
{-1.165535, 0.156396, -0.083759, 0.809137, 0.584582, -0.059420, -1.517513, 2.649596},
{-1.164941, 0.158395, -0.061324, 0.833125, 0.535936, -0.136509, -1.431054, 2.647674},
{-1.153512, 0.144516, -0.104565, 0.554735, 0.829463, 0.065096, 1.427017, -1.822089},
{-1.153406, 0.142396, -0.084644, 0.563707, 0.825617, -0.023896, 1.464416, -1.751757},
{-1.132784, 0.134504, -0.084614, 0.261422, 0.963042, -0.064455, 1.511071, -1.764073},
{-1.132926, 0.135881, -0.104714, 0.305399, 0.950896, 0.049593, 1.466328, -1.832638},
{-1.133082, 0.137867, -0.121744, 0.326640, 0.943876, -0.048799, 1.421586, -1.901202},
{-1.153566, 0.146376, -0.121397, 0.523301, 0.849940, -0.060976, 1.389617, -1.892421},
{-1.093499, 0.126434, -0.104591, 0.200110, 0.977203, -0.070681, -1.630493, 2.346829},
{-1.132926, 0.135881, -0.104714, 0.305399, 0.950896, 0.049593, -1.610436, 2.556473},
{-1.093236, 0.128232, -0.084269, 0.146214, 0.979278, -0.140080, -1.555213, 2.344097},
{-1.047731, 0.123722, -0.083533, 0.100314, 0.973876, -0.203650, -1.564286, 2.148396},
{-1.048144, 0.118607, -0.103944, 0.133641, 0.971129, -0.197516, -1.645449, 2.152047},
{-1.093145, 0.132783, -0.061631, 0.133763, 0.966674, -0.218238, -1.467049, 2.341721},
{-1.047573, 0.127978, -0.061199, 0.097934, 0.977355, -0.187536, -1.477706, 2.145778},
{-0.620085, 0.306325, -0.099572, -0.439497, -0.779870, 0.445631, 0.184666, 2.389413},
{-0.576105, 0.278171, -0.100184, -0.502853, -0.778069, 0.376415, 0.147690, 2.613149},
{-0.574728, 0.286511, -0.080503, -0.524522, -0.776147, 0.349895, 0.231383, 2.619775},
{-0.619307, 0.315763, -0.080282, -0.467818, -0.802301, 0.370647, 0.267722, 2.393477},
{-0.672768, 0.344132, -0.080213, -0.330943, -0.858119, 0.392529, 0.295281, 2.175271},
{-0.673053, 0.333801, -0.099128, -0.301737, -0.796747, 0.523545, 0.212737, 2.172917},
{-0.619271, 0.324793, -0.058701, -0.472182, -0.819910, 0.323679, 0.359020, 2.393849},
{-0.574557, 0.295860, -0.058806, -0.532701, -0.781182, 0.325510, 0.323800, 2.621145},
{-0.575046, 0.305719, -0.035789, -0.533403, -0.785363, 0.314035, 0.421643, 2.619570},
{-0.619668, 0.333882, -0.035581, -0.463729, -0.827662, 0.316050, 0.456202, 2.392151},
{-0.673149, 0.360111, -0.035468, -0.311136, -0.897732, 0.311777, 0.481701, 2.173020},
{-0.672836, 0.352325, -0.058719, -0.328837, -0.891476, 0.311594, 0.385374, 2.174882},
{-0.552878, 0.280171, -0.058818, -0.690451, -0.669088, 0.274880, 0.042875, -0.597203},
{-0.574557, 0.295860, -0.058806, -0.532701, -0.781182, 0.325510, -0.002811, -0.611331},
{-0.574728, 0.286511, -0.080503, -0.524522, -0.776147, 0.349895, 0.002123, -0.509270},
{-0.553089, 0.271084, -0.080614, -0.674612, -0.674520, 0.299753, 0.045804, -0.495600},
{-0.553476, 0.290009, -0.035821, -0.700369, -0.665090, 0.259072, 0.037753, -0.704849},
{-0.575046, 0.305719, -0.035789, -0.533403, -0.785363, 0.314035, -0.009225, -0.719494},
{-0.554816, 0.263630, -0.100489, -0.655751, -0.686880, 0.313273, 0.043430, -0.404310},
{-0.576105, 0.278171, -0.100184, -0.502853, -0.778069, 0.376415, 0.002869, -0.417196},
{-0.620190, 0.343496, -0.011675, -0.455214, -0.829432, 0.323679, 0.556911, 2.390002},
{-0.575647, 0.315590, -0.012149, -0.532365, -0.786157, 0.313883, 0.521615, 2.617362},
{-0.575534, 0.325230, 0.011678, -0.527818, -0.784173, 0.326273, 0.622009, 2.618399},
{-0.620329, 0.353090, 0.012441, -0.447981, -0.831599, 0.328196, 0.658408, 2.389456},
{-0.673971, 0.378625, 0.013135, -0.289346, -0.897061, 0.333964, 0.685386, 2.169273},
{-0.673596, 0.369218, -0.011283, -0.297037, -0.894009, 0.335368, 0.582946, 2.170952},
{-0.619577, 0.362119, 0.036187, -0.441969, -0.840999, 0.311991, 0.757951, 2.392567},
{-0.573883, 0.334396, 0.035257, -0.524400, -0.789788, 0.318094, 0.721118, 2.626557},
{-0.674068, 0.387306, 0.037083, -0.282785, -0.908322, 0.308084, 0.785298, 2.168574},
{-0.551930, 0.318104, 0.034806, -0.702414, -0.650563, 0.288705, 0.034130, -1.032016},
{-0.573883, 0.334396, 0.035257, -0.524400, -0.789788, 0.318094, -0.016314, -1.049358},
{-0.575534, 0.325230, 0.011678, -0.527818, -0.784173, 0.326273, -0.017173, -0.940494},
{-0.553993, 0.309136, 0.011308, -0.701468, -0.652577, 0.286416, 0.031824, -0.923862},
{-0.554178, 0.299718, -0.012339, -0.704398, -0.660360, 0.260201, 0.033551, -0.814271},
{-0.575647, 0.315590, -0.012149, -0.532365, -0.786157, 0.313883, -0.014411, -0.829877},
{-0.625204, 0.160631, 0.030916, -0.198798, 0.931883, -0.303385, -1.133263, 0.317292},
{-0.583726, 0.170677, 0.032308, -0.221046, 0.928739, -0.297586, -1.115155, 0.137732},
{-0.585509, 0.163100, 0.009567, -0.215064, 0.926969, -0.307352, -1.208626, 0.147644},
{-0.626631, 0.153342, 0.008563, -0.198126, 0.933317, -0.299387, -1.224898, 0.325622},
{-0.676615, 0.142952, 0.007392, -0.156682, 0.942808, -0.294137, -1.242031, 0.541830},
{-0.675602, 0.150075, 0.029371, -0.153783, 0.935728, -0.317331, -1.151965, 0.535323},
{-0.627653, 0.145801, -0.013721, -0.187811, 0.932615, -0.308084, -1.316749, 0.332221},
{-0.586648, 0.154984, -0.012982, -0.199469, 0.922452, -0.330515, -1.302375, 0.154811},
{-0.587362, 0.146685, -0.034884, -0.177923, 0.921659, -0.344737, -1.394170, 0.160117},
{-0.628364, 0.138431, -0.035297, -0.169927, 0.935789, -0.308847, -1.405821, 0.337414},
{-0.678138, 0.129797, -0.035903, -0.129032, 0.955901, -0.263741, -1.418010, 0.552537},
{-0.677467, 0.136055, -0.014643, -0.147465, 0.948088, -0.281686, -1.331927, 0.547624},
{-0.567247, 0.159383, -0.012559, -0.449812, 0.839564, -0.304483, -1.295221, 0.070864},
{-0.566098, 0.167933, 0.010091, -0.464705, 0.843287, -0.269936, -1.200382, 0.063613},
{-0.555635, 0.178137, 0.010582, -0.783502, 0.599322, -0.164006, -1.196152, 0.026556},
{-0.556795, 0.169455, -0.012215, -0.779778, 0.594348, -0.196600, -1.291678, 0.033649},
{-0.557470, 0.160518, -0.034377, -0.779809, 0.587390, -0.216407, -1.385362, 0.038563},
{-0.567918, 0.150525, -0.034561, -0.435377, 0.838954, -0.326426, -1.388316, 0.076036},
{-0.564190, 0.175755, 0.032974, -0.474166, 0.844111, -0.250130, -1.106008, 0.053132},
{-0.553766, 0.186107, 0.033568, -0.788324, 0.597705, -0.145695, -1.101342, 0.016013},
{-0.628858, 0.131656, -0.055525, -0.157201, 0.940764, -0.300394, -1.489120, 0.341529},
{-0.587870, 0.138560, -0.055687, -0.166906, 0.937315, -0.305856, -1.481779, 0.164444},
{-0.588084, 0.133195, -0.075489, -0.204810, 0.966918, -0.151982, -1.581227, 0.112288},
{-0.629102, 0.125594, -0.074733, -0.186377, 0.942228, -0.278237, -1.567614, 0.344441},
{-0.678920, 0.118011, -0.074171, -0.119907, 0.912168, -0.391827, -1.573874, 0.559583},
{-0.678612, 0.124590, -0.055560, -0.111332, 0.951476, -0.286843, -1.496638, 0.556403},
{-0.629065, 0.120361, -0.093249, -0.267678, 0.941588, -0.204321, -1.642274, 0.346026},
{-0.587914, 0.133178, -0.094389, -0.289804, 0.956877, 0.019654, -1.625253, 0.121126},
{-0.587202, 0.135496, -0.110987, -0.356883, 0.930540, 0.081912, -1.682989, 0.120269},
{-0.628637, 0.117892, -0.109733, -0.333262, 0.942808, -0.001221, -1.715016, 0.346946},
{-0.679100, 0.100539, -0.108693, -0.221747, 0.973083, -0.062655, -1.740027, 0.565138},
{-0.679090, 0.107637, -0.092299, -0.168950, 0.896969, -0.408460, -1.655783, 0.562441},
{-0.568336, 0.139088, -0.094627, -0.483230, 0.867489, 0.117954, 0.552124, -0.167336},
{-0.587914, 0.133178, -0.094389, -0.289804, 0.956877, 0.019654, 0.587149, -0.174345},
{-0.588084, 0.133195, -0.075489, -0.204810, 0.966918, -0.151982, 0.589822, -0.232065},
{-0.568567, 0.136757, -0.075483, -0.458693, 0.885220, -0.076937, 0.555106, -0.230415},
{-0.558028, 0.146631, -0.075608, -0.790368, 0.610218, -0.053926, 0.520391, -0.228764},
{-0.557913, 0.148459, -0.094947, -0.770012, 0.633931, 0.071963, 0.517099, -0.160328},
{-0.557312, 0.152252, -0.111882, -0.749779, 0.660878, 0.032472, 0.513808, -0.091891},
{-0.567525, 0.143559, -0.111403, -0.504868, 0.857479, 0.099002, 0.549142, -0.104258},
{-0.587202, 0.135496, -0.110987, -0.356883, 0.930540, 0.081912, 0.584476, -0.116625},
{-0.568393, 0.141776, -0.055498, -0.434248, 0.856746, -0.278176, -1.477457, 0.080279},
{-0.568567, 0.136757, -0.075483, -0.458693, 0.885220, -0.076937, -1.564620, 0.084058},
{-0.557880, 0.151781, -0.055463, -0.785668, 0.589923, -0.186163, -1.474642, 0.042574},
{-0.558028, 0.146631, -0.075608, -0.790368, 0.610218, -0.053926, -1.561722, 0.046133},
{-0.921393, 0.396090, 0.037265, -0.014466, -0.949004, 0.314859, 0.784984, 1.111376},
{-0.971790, 0.397077, 0.037118, -0.020539, -0.945616, 0.324564, 0.783386, 0.895667},
{-0.971718, 0.388364, 0.013587, -0.012452, -0.935911, 0.351909, 0.685022, 0.896182},
{-0.921388, 0.387634, 0.013325, -0.007721, -0.941862, 0.335795, 0.685329, 1.111766},
{-0.867702, 0.387373, 0.013220, 0.001282, -0.945647, 0.325144, 0.686861, 1.341901},
{-0.867647, 0.395542, 0.037476, -0.003327, -0.952788, 0.303537, 0.787416, 1.341608},
{-0.921383, 0.378834, -0.011353, -0.000305, -0.949736, 0.313028, 0.582517, 1.112134},
{-0.971672, 0.379091, -0.010765, 0.001648, -0.942412, 0.334422, 0.582957, 0.896489},
{-0.971619, 0.371201, -0.035337, 0.020051, -0.967345, 0.252663, 0.481494, 0.897403},
{-0.921372, 0.371499, -0.036230, 0.005676, -0.973540, 0.228401, 0.480474, 1.113129},
{-0.867730, 0.371500, -0.036801, 0.001679, -0.974578, 0.223975, 0.480505, 1.343248},
{-0.867724, 0.378755, -0.011717, 0.002960, -0.952055, 0.305826, 0.583253, 1.342262},
{-1.012574, 0.379275, -0.010057, 0.049898, -0.931303, 0.360790, 0.584157, 0.721056},
{-1.012524, 0.389313, 0.014089, 0.038636, -0.930387, 0.364513, 0.686240, 0.721487},
{-1.012545, 0.370194, -0.034518, 0.072329, -0.954039, 0.290750, 0.481880, 0.721382},
{-1.012473, 0.398151, 0.037253, 0.037477, -0.944273, 0.326914, 0.783346, 0.721605},
{-0.921349, 0.367440, -0.060766, 0.010681, -0.980285, 0.197241, 0.383131, 1.115399},
{-0.971523, 0.366639, -0.059528, 0.039644, -0.975158, 0.217780, 0.384938, 0.899739},
{-0.971472, 0.361170, -0.082125, 0.052736, -0.931364, 0.360149, 0.293491, 0.901282},
{-0.921304, 0.362301, -0.083382, 0.014588, -0.933622, 0.357921, 0.291951, 1.117049},
{-0.867673, 0.362237, -0.084026, -0.003510, -0.932096, 0.362133, 0.291639, 1.347108},
{-0.867735, 0.367418, -0.061497, -0.000641, -0.980682, 0.195563, 0.382531, 1.345414},
{-0.921228, 0.351731, -0.102501, 0.012665, -0.807367, 0.589892, 0.208400, 1.116182},
{-0.971555, 0.350561, -0.101914, 0.048952, -0.815271, 0.576952, 0.207351, 0.899818},
{-0.867478, 0.351684, -0.102610, -0.006897, -0.801965, 0.597278, 0.210140, 1.346675},
{-1.012149, 0.347066, -0.101563, 0.100375, -0.824854, 0.556352, 0.203388, 0.724327},
{-1.012179, 0.357736, -0.081324, 0.113834, -0.923032, 0.367473, 0.291293, 0.725261},
{-1.012362, 0.364230, -0.058625, 0.099063, -0.961913, 0.254707, 0.384191, 0.723531},
{-0.722417, 0.395989, 0.037433, -0.084964, -0.949522, 0.301920, 0.793671, 1.964575},
{-0.768680, 0.396152, 0.037497, 0.001770, -0.955809, 0.293863, 0.792185, 1.766240},
{-0.768399, 0.388218, 0.013226, -0.001953, -0.945036, 0.326945, 0.691829, 1.768065},
{-0.722054, 0.387742, 0.013302, -0.091800, -0.937834, 0.334697, 0.693523, 1.966608},
{-0.721650, 0.378542, -0.011338, -0.099796, -0.936277, 0.336741, 0.590456, 1.968524},
{-0.768106, 0.379245, -0.011581, -0.008698, -0.945952, 0.324137, 0.588362, 1.769620},
{-0.767863, 0.371295, -0.036169, -0.021302, -0.965758, 0.258461, 0.486784, 1.771329},
{-0.721293, 0.370022, -0.035719, -0.115940, -0.949644, 0.290994, 0.489079, 1.970465},
{-0.816715, 0.379104, -0.011750, 0.003082, -0.950316, 0.311197, 0.585581, 1.561145},
{-0.816827, 0.387832, 0.013193, 0.006470, -0.946593, 0.322306, 0.689319, 1.560248},
{-0.816617, 0.371610, -0.036655, -0.003998, -0.972137, 0.234352, 0.483267, 1.562452},
{-0.816916, 0.395783, 0.037532, 0.005280, -0.955565, 0.294717, 0.789959, 1.559240},
{-0.721071, 0.363813, -0.059072, -0.139775, -0.950133, 0.278726, 0.393996, 1.972573},
{-0.767731, 0.366433, -0.059785, -0.039766, -0.971099, 0.235267, 0.392100, 1.773611},
{-0.767781, 0.360696, -0.081439, -0.055269, -0.923185, 0.380322, 0.303949, 1.774475},
{-0.721052, 0.356911, -0.080556, -0.153325, -0.905545, 0.395520, 0.305279, 1.973250},
{-0.721306, 0.346307, -0.099329, -0.140172, -0.808008, 0.572192, 0.222998, 1.970902},
{-0.768081, 0.350125, -0.100140, -0.056063, -0.805963, 0.589251, 0.221970, 1.771928},
{-0.816617, 0.351533, -0.101528, -0.026521, -0.802240, 0.596393, 0.216174, 1.564554},
{-0.816577, 0.362087, -0.082987, -0.022217, -0.929380, 0.368419, 0.297520, 1.566006},
{-0.816574, 0.367358, -0.060882, -0.012879, -0.978271, 0.206793, 0.386899, 1.564689},
{-0.920592, 0.107988, -0.099785, 0.082614, 0.934568, -0.345988, -1.660028, 1.603181},
{-0.970046, 0.112246, -0.100933, 0.075838, 0.954833, -0.287240, -1.652488, 1.815940},
{-0.969575, 0.119115, -0.081315, 0.060854, 0.963103, -0.262062, -1.571200, 1.811959},
{-0.920562, 0.116418, -0.081152, 0.056887, 0.950926, -0.304117, -1.579579, 1.601047},
{-0.868036, 0.114093, -0.080661, 0.043275, 0.932646, -0.358104, -1.586483, 1.374948},
{-0.867766, 0.103796, -0.098432, 0.071657, 0.902737, -0.424116, -1.667035, 1.375881},
{-0.867311, 0.097749, -0.114184, 0.079531, 0.993408, 0.082278, -1.748654, 1.376574},
{-0.920659, 0.103391, -0.116276, 0.085360, 0.991424, 0.098910, -1.741006, 1.605338},
{-0.970875, 0.108505, -0.118278, 0.060335, 0.996094, 0.064364, -1.734002, 1.820358},
{-0.920490, 0.120305, -0.060668, 0.046724, 0.988525, -0.143406, -1.500189, 1.598959},
{-0.969271, 0.122855, -0.060349, 0.056337, 0.987426, -0.147557, -1.490365, 1.808851},
{-0.969125, 0.125417, -0.038353, 0.064333, 0.989288, -0.130955, -1.407835, 1.806443},
{-0.920439, 0.122339, -0.038905, 0.049837, 0.992279, -0.113559, -1.419366, 1.597018},
{-0.868122, 0.120234, -0.039191, 0.018159, 0.993652, -0.110904, -1.428645, 1.371861},
{-0.868120, 0.118418, -0.060662, 0.024537, 0.987823, -0.153478, -1.508067, 1.373536},
{-1.008957, 0.125041, -0.060649, 0.070132, 0.984375, -0.161321, -1.484175, 1.979640},
{-1.009237, 0.121117, -0.082328, 0.070925, 0.968902, -0.236946, -1.567859, 1.982713},
{-1.008889, 0.128182, -0.038031, 0.084841, 0.983825, -0.157567, -1.398450, 1.977477},
{-1.009778, 0.114832, -0.102522, 0.082858, 0.963012, -0.256355, -1.650205, 1.986990},
{-1.010767, 0.110774, -0.120187, 0.064913, 0.997742, -0.016022, -1.731882, 1.991869},
{-0.920472, 0.125210, -0.016437, 0.053255, 0.985565, -0.160497, -1.334622, 1.595321},
{-0.969128, 0.128755, -0.015647, 0.073275, 0.982543, -0.170873, -1.321460, 1.804560},
{-0.969179, 0.133302, 0.007367, 0.076144, 0.970275, -0.229621, -1.231950, 1.802770},
{-0.920513, 0.129547, 0.006274, 0.050417, 0.971038, -0.233406, -1.246549, 1.593526},
{-0.868142, 0.127435, 0.005401, 0.005982, 0.969176, -0.246193, -1.257929, 1.368176},
{-0.868143, 0.123000, -0.017003, 0.013367, 0.986297, -0.164342, -1.345077, 1.370140},
{-0.920488, 0.135976, 0.028765, 0.040620, 0.947172, -0.318094, -1.155741, 1.591293},
{-0.969181, 0.139492, 0.030289, 0.070009, 0.950407, -0.302988, -1.140013, 1.800642},
{-0.868078, 0.134259, 0.027525, -0.002808, 0.942137, -0.335154, -1.167768, 1.365772},
{-1.009287, 0.143399, 0.031466, 0.112247, 0.949217, -0.293863, -1.125635, 1.973000},
{-1.009151, 0.137104, 0.008204, 0.112735, 0.965148, -0.236061, -1.218972, 1.974579},
{-1.008986, 0.132118, -0.015021, 0.101962, 0.976012, -0.192267, -1.309980, 1.975930},
{-0.725285, 0.102006, -0.092631, -0.052461, 0.861385, -0.505203, -1.662269, 0.761890},
{-0.770584, 0.100813, -0.094018, 0.015534, 0.854946, -0.518448, -1.665120, 0.957203},
{-0.770063, 0.113450, -0.076313, 0.002350, 0.898862, -0.438215, -1.580940, 0.952684},
{-0.724832, 0.114507, -0.074757, -0.042299, 0.896176, -0.441603, -1.577707, 0.757665},
{-0.725860, 0.093228, -0.108923, -0.075411, 0.994995, -0.065249, -1.751006, 0.766362},
{-0.771354, 0.092250, -0.110125, 0.012757, 0.999603, -0.023927, -1.753413, 0.962099},
{-0.724390, 0.120888, -0.056335, -0.054842, 0.964293, -0.259041, -1.501494, 0.753932},
{-0.769605, 0.119212, -0.057672, -0.021912, 0.975158, -0.220313, -1.504989, 0.948916},
{-0.769165, 0.122134, -0.037812, -0.043580, 0.984741, -0.168310, -1.429474, 0.945366},
{-0.723896, 0.124818, -0.036808, -0.076632, 0.973540, -0.215155, -1.425473, 0.750094},
{-0.817670, 0.118221, -0.059389, -0.001373, 0.983428, -0.181219, -1.508423, 1.156153},
{-0.817833, 0.113208, -0.078665, 0.024689, 0.913297, -0.406507, -1.585401, 1.158636},
{-0.817469, 0.120386, -0.038716, -0.017914, 0.991272, -0.130436, -1.431273, 1.153632},
{-0.817921, 0.101407, -0.096231, 0.049196, 0.871853, -0.487259, -1.667720, 1.161211},
{-0.818024, 0.093896, -0.112006, 0.053957, 0.997986, 0.033052, -1.752710, 1.163832},
{-0.723290, 0.129966, -0.015615, -0.095828, 0.963256, -0.250801, -1.341491, 0.745553},
{-0.768698, 0.126254, -0.016450, -0.061068, 0.974334, -0.216651, -1.346606, 0.941497},
{-0.768221, 0.131856, 0.005601, -0.071291, 0.957701, -0.278726, -1.258796, 0.937416},
{-0.722610, 0.136221, 0.006363, -0.105289, 0.951537, -0.288827, -1.252860, 0.740552},
{-0.721897, 0.143472, 0.028246, -0.101199, 0.936735, -0.335002, -1.162896, 0.735337},
{-0.767750, 0.139227, 0.027527, -0.070803, 0.935362, -0.346477, -1.168455, 0.933229},
{-0.816821, 0.135750, 0.027200, -0.045717, 0.937010, -0.346202, -1.171043, 1.144895},
{-0.817055, 0.128566, 0.005229, -0.040834, 0.963866, -0.263161, -1.261248, 1.148048},
{-0.817267, 0.123640, -0.016960, -0.030763, 0.982238, -0.184912, -1.348437, 1.150946},
{0.263352, 0.487151, -0.525891, 0.038942, 0.014740, -0.999115, 0.666667, 0.666667},
{0.260762, 0.477631, -0.525891, 0.034944, 0.005951, -0.999359, 0.500000, 0.500000},
{0.231061, 0.465280, -0.525891, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000},
{0.255842, 0.490061, -0.525891, 0.022248, 0.022248, -0.999481, 0.500000, 1.000000},
{0.269351, 0.503570, -0.524845, 0.197760, 0.197760, -0.960082, 1.000000, 1.000000},
{0.275460, 0.495353, -0.524845, 0.271065, 0.103183, -0.956999, 1.000000, 0.500000},
{0.276766, 0.484199, -0.524845, 0.306345, 0.047578, -0.950713, 1.000000, 0.000000},
{0.265666, 0.472164, -0.525891, 0.045564, 0.001404, -0.998932, 0.666667, 0.666667},
{0.261341, 0.465280, -0.525891, 0.036836, 0.000000, -0.999298, 0.500000, 0.500000},
{0.260762, 0.477631, -0.525891, 0.034944, 0.005951, -0.999359, 0.500000, 1.000000},
{0.276766, 0.484199, -0.524845, 0.306345, 0.047578, -0.950713, 1.000000, 1.000000},
{0.278643, 0.474745, -0.524845, 0.311838, 0.011902, -0.950041, 1.000000, 0.500000},
{0.277562, 0.465280, -0.524845, 0.318735, 0.000000, -0.947813, 1.000000, 0.000000},
{0.265666, 0.458397, -0.525891, 0.045564, -0.001404, -0.998932, 0.666667, 0.666667},
{0.260762, 0.452929, -0.525891, 0.034944, -0.005951, -0.999359, 0.500000, 0.500000},
{0.261341, 0.465280, -0.525891, 0.036836, 0.000000, -0.999298, 0.500000, 1.000000},
{0.277562, 0.465280, -0.524845, 0.318735, 0.000000, -0.947813, 1.000000, 1.000000},
{0.278643, 0.455816, -0.524845, 0.311838, -0.011902, -0.950041, 1.000000, 0.500000},
{0.276766, 0.446362, -0.524845, 0.306345, -0.047578, -0.950713, 1.000000, 0.000000},
{0.263352, 0.443409, -0.525891, 0.038942, -0.014740, -0.999115, 0.666667, 0.666667},
{0.255842, 0.440499, -0.525891, 0.022248, -0.022248, -0.999481, 0.500000, 0.500000},
{0.260762, 0.452929, -0.525891, 0.034944, -0.005951, -0.999359, 0.500000, 1.000000},
{0.276766, 0.446362, -0.524845, 0.306345, -0.047578, -0.950713, 1.000000, 1.000000},
{0.275460, 0.435208, -0.524845, 0.271065, -0.103183, -0.956999, 1.000000, 0.500000},
{0.269351, 0.426991, -0.524845, 0.197760, -0.197760, -0.960082, 1.000000, 0.000000},
{0.252932, 0.432990, -0.525891, 0.014740, -0.038942, -0.999115, 0.666667, 0.666667},
{0.243413, 0.435580, -0.525891, 0.005951, -0.034944, -0.999359, 0.500000, 0.500000},
{0.255842, 0.440499, -0.525891, 0.022248, -0.022248, -0.999481, 0.500000, 1.000000},
{0.269351, 0.426991, -0.524845, 0.197760, -0.197760, -0.960082, 1.000000, 1.000000},
{0.261134, 0.420882, -0.524845, 0.103183, -0.271065, -0.956999, 1.000000, 0.500000},
{0.249980, 0.419576, -0.524845, 0.047578, -0.306345, -0.950713, 1.000000, 0.000000},
{0.237945, 0.430676, -0.525891, 0.001404, -0.045564, -0.998932, 0.666667, 0.666667},
{0.231061, 0.435001, -0.525891, 0.000000, -0.036836, -0.999298, 0.500000, 0.500000},
{0.243413, 0.435580, -0.525891, 0.005951, -0.034944, -0.999359, 0.500000, 1.000000},
{0.249980, 0.419576, -0.524845, 0.047578, -0.306345, -0.950713, 1.000000, 1.000000},
{0.240526, 0.417699, -0.524845, 0.011902, -0.311838, -0.950041, 1.000000, 0.500000},
{0.231061, 0.418780, -0.524845, 0.000000, -0.318735, -0.947813, 1.000000, 0.000000},
{0.224178, 0.430676, -0.525891, -0.001404, -0.045564, -0.998932, 0.666667, 0.666667},
{0.218710, 0.435580, -0.525891, -0.005951, -0.034944, -0.999359, 0.500000, 0.500000},
{0.231061, 0.435001, -0.525891, 0.000000, -0.036836, -0.999298, 0.500000, 1.000000},
{0.231061, 0.418780, -0.524845, 0.000000, -0.318735, -0.947813, 1.000000, 1.000000},
{0.221597, 0.417699, -0.524845, -0.011902, -0.311838, -0.950041, 1.000000, 0.500000},
{0.212143, 0.419576, -0.524845, -0.047578, -0.306345, -0.950713, 1.000000, 0.000000},
{0.209190, 0.432990, -0.525891, -0.014740, -0.038942, -0.999115, 0.666667, 0.666667},
{0.206280, 0.440499, -0.525891, -0.022248, -0.022248, -0.999481, 0.500000, 0.500000},
{0.218710, 0.435580, -0.525891, -0.005951, -0.034944, -0.999359, 0.500000, 1.000000},
{0.212143, 0.419576, -0.524845, -0.047578, -0.306345, -0.950713, 1.000000, 1.000000},
{0.200989, 0.420882, -0.524845, -0.103183, -0.271065, -0.956999, 1.000000, 0.500000},
{0.192772, 0.426991, -0.524845, -0.197760, -0.197760, -0.960082, 1.000000, 0.000000},
{0.198771, 0.443409, -0.525891, -0.038942, -0.014740, -0.999115, 0.666667, 0.666667},
{0.201361, 0.452929, -0.525891, -0.034944, -0.005951, -0.999359, 0.500000, 0.500000},
{0.206280, 0.440499, -0.525891, -0.022248, -0.022248, -0.999481, 0.500000, 1.000000},
{0.192772, 0.426991, -0.524845, -0.197760, -0.197760, -0.960082, 1.000000, 1.000000},
{0.186663, 0.435208, -0.524845, -0.271065, -0.103183, -0.956999, 1.000000, 0.500000},
{0.185357, 0.446362, -0.524845, -0.306345, -0.047578, -0.950713, 1.000000, 0.000000},
{0.196457, 0.458397, -0.525891, -0.045564, -0.001404, -0.998932, 0.666667, 0.666667},
{0.200782, 0.465280, -0.525891, -0.036836, 0.000000, -0.999298, 0.500000, 0.500000},
{0.201361, 0.452929, -0.525891, -0.034944, -0.005951, -0.999359, 0.500000, 1.000000},
{0.185357, 0.446362, -0.524845, -0.306345, -0.047578, -0.950713, 1.000000, 1.000000},
{0.183480, 0.455816, -0.524845, -0.311838, -0.011902, -0.950041, 1.000000, 0.500000},
{0.184561, 0.465280, -0.524845, -0.318735, 0.000000, -0.947813, 1.000000, 0.000000},
{0.196457, 0.472164, -0.525891, -0.045564, 0.001404, -0.998932, 0.666667, 0.666667},
{0.201361, 0.477631, -0.525891, -0.034944, 0.005951, -0.999359, 0.500000, 0.500000},
{0.200782, 0.465280, -0.525891, -0.036836, 0.000000, -0.999298, 0.500000, 1.000000},
{0.184561, 0.465280, -0.524845, -0.318735, 0.000000, -0.947813, 1.000000, 1.000000},
{0.183480, 0.474745, -0.524845, -0.311838, 0.011902, -0.950041, 1.000000, 0.500000},
{0.185357, 0.484199, -0.524845, -0.306345, 0.047578, -0.950713, 1.000000, 0.000000},
{0.198771, 0.487151, -0.525891, -0.038942, 0.014740, -0.999115, 0.666667, 0.666667},
{0.206280, 0.490061, -0.525891, -0.022248, 0.022248, -0.999481, 0.500000, 0.500000},
{0.201361, 0.477631, -0.525891, -0.034944, 0.005951, -0.999359, 0.500000, 1.000000},
{0.185357, 0.484199, -0.524845, -0.306345, 0.047578, -0.950713, 1.000000, 1.000000},
{0.186663, 0.495353, -0.524845, -0.271065, 0.103183, -0.956999, 1.000000, 0.500000},
{0.192772, 0.503570, -0.524845, -0.197760, 0.197760, -0.960082, 1.000000, 0.000000},
{0.209190, 0.497570, -0.525891, -0.014740, 0.038942, -0.999115, 0.666667, 0.666667},
{0.218710, 0.494981, -0.525891, -0.005951, 0.034944, -0.999359, 0.500000, 0.500000},
{0.206280, 0.490061, -0.525891, -0.022248, 0.022248, -0.999481, 0.500000, 1.000000},
{0.192772, 0.503570, -0.524845, -0.197760, 0.197760, -0.960082, 1.000000, 1.000000},
{0.200989, 0.509679, -0.524845, -0.103183, 0.271065, -0.956999, 1.000000, 0.500000},
{0.212143, 0.510985, -0.524845, -0.047578, 0.306345, -0.950713, 1.000000, 0.000000},
{0.224178, 0.499885, -0.525891, -0.001404, 0.045564, -0.998932, 0.666667, 0.666667},
{0.231061, 0.495560, -0.525891, 0.000000, 0.036836, -0.999298, 0.500000, 0.500000},
{0.218710, 0.494981, -0.525891, -0.005951, 0.034944, -0.999359, 0.500000, 1.000000},
{0.212143, 0.510985, -0.524845, -0.047578, 0.306345, -0.950713, 1.000000, 1.000000},
{0.221597, 0.512862, -0.524845, -0.011902, 0.311838, -0.950041, 1.000000, 0.500000},
{0.231061, 0.511781, -0.524845, 0.000000, 0.318735, -0.947813, 1.000000, 0.000000},
{0.237945, 0.499885, -0.525891, 0.001404, 0.045564, -0.998932, 0.666667, 0.666667},
{0.243413, 0.494981, -0.525891, 0.005951, 0.034944, -0.999359, 0.500000, 0.500000},
{0.231061, 0.495560, -0.525891, 0.000000, 0.036836, -0.999298, 0.500000, 1.000000},
{0.231061, 0.511781, -0.524845, 0.000000, 0.318735, -0.947813, 1.000000, 1.000000},
{0.240526, 0.512862, -0.524845, 0.011902, 0.311838, -0.950041, 1.000000, 0.500000},
{0.249980, 0.510985, -0.524845, 0.047578, 0.306345, -0.950713, 1.000000, 0.000000},
{0.252932, 0.497570, -0.525891, 0.014740, 0.038942, -0.999115, 0.666667, 0.666667},
{0.249980, 0.510985, -0.524845, 0.047578, 0.306345, -0.950713, 0.000000, 1.000000},
{0.261134, 0.509679, -0.524845, 0.103183, 0.271065, -0.956999, 0.500000, 1.000000},
{0.255842, 0.490061, -0.525891, 0.022248, 0.022248, -0.999481, 1.000000, 0.500000},
{0.231061, 0.465280, -0.525891, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000},
{0.279497, 0.498087, -0.521706, 0.808832, 0.309824, -0.499741, 0.500000, 0.500000},
{0.275460, 0.495353, -0.524845, 0.271065, 0.103183, -0.956999, 0.000000, 0.500000},
{0.269351, 0.503570, -0.524845, 0.197760, 0.197760, -0.960082, 0.000000, 1.000000},
{0.273853, 0.508072, -0.521706, 0.605670, 0.605670, -0.516007, 0.500000, 1.000000},
{0.273853, 0.508072, -0.511596, 0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{0.279497, 0.498087, -0.511596, 0.933500, 0.358531, 0.000000, 1.000000, 0.500000},
{0.282101, 0.486388, -0.511596, 0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{0.282101, 0.486388, -0.521706, 0.864650, 0.131108, -0.484939, 0.500000, 0.000000},
{0.276766, 0.484199, -0.524845, 0.306345, 0.047578, -0.950713, 0.000000, 0.000000},
{0.282969, 0.475605, -0.521706, 0.875942, 0.034852, -0.481124, 0.500000, 0.500000},
{0.278643, 0.474745, -0.524845, 0.311838, 0.011902, -0.950041, 0.000000, 0.500000},
{0.276766, 0.484199, -0.524845, 0.306345, 0.047578, -0.950713, 0.000000, 1.000000},
{0.282101, 0.486388, -0.521706, 0.864650, 0.131108, -0.484939, 0.500000, 1.000000},
{0.282101, 0.486388, -0.511596, 0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{0.282969, 0.475605, -0.511596, 0.999176, 0.040132, 0.000000, 1.000000, 0.500000},
{0.282969, 0.465280, -0.511596, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{0.282969, 0.465280, -0.521706, 0.878658, 0.000000, -0.477401, 0.500000, 0.000000},
{0.277562, 0.465280, -0.524845, 0.318735, 0.000000, -0.947813, 0.000000, 0.000000},
{0.282969, 0.454955, -0.521706, 0.875942, -0.034852, -0.481124, 0.500000, 0.500000},
{0.278643, 0.455816, -0.524845, 0.311838, -0.011902, -0.950041, 0.000000, 0.500000},
{0.277562, 0.465280, -0.524845, 0.318735, 0.000000, -0.947813, 0.000000, 1.000000},
{0.282969, 0.465280, -0.521706, 0.878658, 0.000000, -0.477401, 0.500000, 1.000000},
{0.282969, 0.465280, -0.511596, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{0.282969, 0.454955, -0.511596, 0.999176, -0.040132, 0.000000, 1.000000, 0.500000},
{0.282101, 0.444173, -0.511596, 0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{0.282101, 0.444173, -0.521706, 0.864620, -0.131108, -0.484939, 0.500000, 0.000000},
{0.276766, 0.446362, -0.524845, 0.306345, -0.047578, -0.950713, 0.000000, 0.000000},
{0.279496, 0.432474, -0.521706, 0.808832, -0.309824, -0.499741, 0.500000, 0.500000},
{0.275460, 0.435208, -0.524845, 0.271065, -0.103183, -0.956999, 0.000000, 0.500000},
{0.276766, 0.446362, -0.524845, 0.306345, -0.047578, -0.950713, 0.000000, 1.000000},
{0.282101, 0.444173, -0.521706, 0.864620, -0.131108, -0.484939, 0.500000, 1.000000},
{0.282101, 0.444173, -0.511596, 0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{0.279496, 0.432474, -0.511596, 0.933500, -0.358531, 0.000000, 1.000000, 0.500000},
{0.273853, 0.422489, -0.511596, 0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{0.273853, 0.422489, -0.521706, 0.605670, -0.605670, -0.516007, 0.500000, 0.000000},
{0.269351, 0.426991, -0.524845, 0.197760, -0.197760, -0.960082, 0.000000, 0.000000},
{0.263868, 0.416845, -0.521706, 0.309824, -0.808832, -0.499741, 0.500000, 0.500000},
{0.261134, 0.420882, -0.524845, 0.103183, -0.271065, -0.956999, 0.000000, 0.500000},
{0.269351, 0.426991, -0.524845, 0.197760, -0.197760, -0.960082, 0.000000, 1.000000},
{0.273853, 0.422489, -0.521706, 0.605670, -0.605670, -0.516007, 0.500000, 1.000000},
{0.273853, 0.422489, -0.511596, 0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{0.263868, 0.416845, -0.511596, 0.358531, -0.933500, 0.000000, 1.000000, 0.500000},
{0.252169, 0.414241, -0.511596, 0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{0.252169, 0.414241, -0.521706, 0.131108, -0.864650, -0.484939, 0.500000, 0.000000},
{0.249980, 0.419576, -0.524845, 0.047578, -0.306345, -0.950713, 0.000000, 0.000000},
{0.241386, 0.413373, -0.521706, 0.034852, -0.875942, -0.481124, 0.500000, 0.500000},
{0.240526, 0.417699, -0.524845, 0.011902, -0.311838, -0.950041, 0.000000, 0.500000},
{0.249980, 0.419576, -0.524845, 0.047578, -0.306345, -0.950713, 0.000000, 1.000000},
{0.252169, 0.414241, -0.521706, 0.131108, -0.864650, -0.484939, 0.500000, 1.000000},
{0.252169, 0.414241, -0.511596, 0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{0.241386, 0.413373, -0.511596, 0.040132, -0.999176, 0.000000, 1.000000, 0.500000},
{0.231061, 0.413373, -0.511596, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000},
{0.231061, 0.413373, -0.521706, 0.000000, -0.878658, -0.477401, 0.500000, 0.000000},
{0.231061, 0.418780, -0.524845, 0.000000, -0.318735, -0.947813, 0.000000, 0.000000},
{0.220736, 0.413373, -0.521706, -0.034852, -0.875942, -0.481124, 0.500000, 0.500000},
{0.221597, 0.417699, -0.524845, -0.011902, -0.311838, -0.950041, 0.000000, 0.500000},
{0.231061, 0.418780, -0.524845, 0.000000, -0.318735, -0.947813, 0.000000, 1.000000},
{0.231061, 0.413373, -0.521706, 0.000000, -0.878658, -0.477401, 0.500000, 1.000000},
{0.231061, 0.413373, -0.511596, 0.000000, -1.000000, 0.000000, 1.000000, 1.000000},
{0.220736, 0.413373, -0.511596, -0.040132, -0.999176, 0.000000, 1.000000, 0.500000},
{0.209954, 0.414241, -0.511596, -0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{0.209954, 0.414241, -0.521706, -0.131108, -0.864650, -0.484939, 0.500000, 0.000000},
{0.212143, 0.419576, -0.524845, -0.047578, -0.306345, -0.950713, 0.000000, 0.000000},
{0.198255, 0.416845, -0.521706, -0.309824, -0.808832, -0.499741, 0.500000, 0.500000},
{0.200989, 0.420882, -0.524845, -0.103183, -0.271065, -0.956999, 0.000000, 0.500000},
{0.212143, 0.419576, -0.524845, -0.047578, -0.306345, -0.950713, 0.000000, 1.000000},
{0.209954, 0.414241, -0.521706, -0.131108, -0.864650, -0.484939, 0.500000, 1.000000},
{0.209954, 0.414241, -0.511596, -0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{0.198255, 0.416845, -0.511596, -0.358531, -0.933500, 0.000000, 1.000000, 0.500000},
{0.188270, 0.422489, -0.511596, -0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{0.188270, 0.422489, -0.521706, -0.605670, -0.605670, -0.516007, 0.500000, 0.000000},
{0.192772, 0.426991, -0.524845, -0.197760, -0.197760, -0.960082, 0.000000, 0.000000},
{0.182626, 0.432474, -0.521706, -0.808832, -0.309824, -0.499741, 0.500000, 0.500000},
{0.186663, 0.435208, -0.524845, -0.271065, -0.103183, -0.956999, 0.000000, 0.500000},
{0.192772, 0.426991, -0.524845, -0.197760, -0.197760, -0.960082, 0.000000, 1.000000},
{0.188270, 0.422489, -0.521706, -0.605670, -0.605670, -0.516007, 0.500000, 1.000000},
{0.188270, 0.422489, -0.511596, -0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{0.182626, 0.432474, -0.511596, -0.933500, -0.358531, 0.000000, 1.000000, 0.500000},
{0.180022, 0.444173, -0.511596, -0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{0.180022, 0.444173, -0.521706, -0.864620, -0.131108, -0.484939, 0.500000, 0.000000},
{0.185357, 0.446362, -0.524845, -0.306345, -0.047578, -0.950713, 0.000000, 0.000000},
{0.179154, 0.454955, -0.521706, -0.875942, -0.034852, -0.481124, 0.500000, 0.500000},
{0.183480, 0.455816, -0.524845, -0.311838, -0.011902, -0.950041, 0.000000, 0.500000},
{0.185357, 0.446362, -0.524845, -0.306345, -0.047578, -0.950713, 0.000000, 1.000000},
{0.180022, 0.444173, -0.521706, -0.864620, -0.131108, -0.484939, 0.500000, 1.000000},
{0.180022, 0.444173, -0.511596, -0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{0.179154, 0.454955, -0.511596, -0.999176, -0.040132, 0.000000, 1.000000, 0.500000},
{0.179154, 0.465280, -0.511596, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{0.179154, 0.465280, -0.521706, -0.878658, 0.000000, -0.477401, 0.500000, 0.000000},
{0.184561, 0.465280, -0.524845, -0.318735, 0.000000, -0.947813, 0.000000, 0.000000},
{0.179154, 0.475605, -0.521706, -0.875942, 0.034852, -0.481124, 0.500000, 0.500000},
{0.183480, 0.474745, -0.524845, -0.311838, 0.011902, -0.950041, 0.000000, 0.500000},
{0.184561, 0.465280, -0.524845, -0.318735, 0.000000, -0.947813, 0.000000, 1.000000},
{0.179154, 0.465280, -0.521706, -0.878658, 0.000000, -0.477401, 0.500000, 1.000000},
{0.179154, 0.465280, -0.511596, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{0.179154, 0.475605, -0.511596, -0.999176, 0.040132, 0.000000, 1.000000, 0.500000},
{0.180022, 0.486388, -0.511596, -0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{0.180022, 0.486388, -0.521706, -0.864620, 0.131108, -0.484939, 0.500000, 0.000000},
{0.185357, 0.484199, -0.524845, -0.306345, 0.047578, -0.950713, 0.000000, 0.000000},
{0.182626, 0.498087, -0.521706, -0.808832, 0.309824, -0.499741, 0.500000, 0.500000},
{0.186663, 0.495353, -0.524845, -0.271065, 0.103183, -0.956999, 0.000000, 0.500000},
{0.185357, 0.484199, -0.524845, -0.306345, 0.047578, -0.950713, 0.000000, 1.000000},
{0.180022, 0.486388, -0.521706, -0.864620, 0.131108, -0.484939, 0.500000, 1.000000},
{0.180022, 0.486388, -0.511596, -0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{0.182626, 0.498087, -0.511596, -0.933500, 0.358531, 0.000000, 1.000000, 0.500000},
{0.188270, 0.508072, -0.511596, -0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{0.188270, 0.508072, -0.521706, -0.605670, 0.605670, -0.516007, 0.500000, 0.000000},
{0.192772, 0.503570, -0.524845, -0.197760, 0.197760, -0.960082, 0.000000, 0.000000},
{0.198255, 0.513716, -0.521706, -0.309824, 0.808832, -0.499741, 0.500000, 0.500000},
{0.200989, 0.509679, -0.524845, -0.103183, 0.271065, -0.956999, 0.000000, 0.500000},
{0.192772, 0.503570, -0.524845, -0.197760, 0.197760, -0.960082, 0.000000, 1.000000},
{0.188270, 0.508072, -0.521706, -0.605670, 0.605670, -0.516007, 0.500000, 1.000000},
{0.188270, 0.508072, -0.511596, -0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{0.198255, 0.513716, -0.511596, -0.358531, 0.933500, 0.000000, 1.000000, 0.500000},
{0.209954, 0.516320, -0.511596, -0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{0.209954, 0.516320, -0.521706, -0.131108, 0.864620, -0.484939, 0.500000, 0.000000},
{0.212143, 0.510985, -0.524845, -0.047578, 0.306345, -0.950713, 0.000000, 0.000000},
{0.220737, 0.517188, -0.521706, -0.034852, 0.875942, -0.481124, 0.500000, 0.500000},
{0.221597, 0.512862, -0.524845, -0.011902, 0.311838, -0.950041, 0.000000, 0.500000},
{0.212143, 0.510985, -0.524845, -0.047578, 0.306345, -0.950713, 0.000000, 1.000000},
{0.209954, 0.516320, -0.521706, -0.131108, 0.864620, -0.484939, 0.500000, 1.000000},
{0.209954, 0.516320, -0.511596, -0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{0.220737, 0.517188, -0.511596, -0.040132, 0.999176, 0.000000, 1.000000, 0.500000},
{0.231062, 0.517188, -0.511596, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000},
{0.231062, 0.517188, -0.521706, 0.000000, 0.878658, -0.477401, 0.500000, 0.000000},
{0.231061, 0.511781, -0.524845, 0.000000, 0.318735, -0.947813, 0.000000, 0.000000},
{0.241387, 0.517188, -0.521706, 0.034852, 0.875942, -0.481124, 0.500000, 0.500000},
{0.240526, 0.512862, -0.524845, 0.011902, 0.311838, -0.950041, 0.000000, 0.500000},
{0.231061, 0.511781, -0.524845, 0.000000, 0.318735, -0.947813, 0.000000, 1.000000},
{0.231062, 0.517188, -0.521706, 0.000000, 0.878658, -0.477401, 0.500000, 1.000000},
{0.231062, 0.517188, -0.511596, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000},
{0.241387, 0.517188, -0.511596, 0.040132, 0.999176, 0.000000, 1.000000, 0.500000},
{0.252169, 0.516320, -0.511596, 0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{0.252169, 0.516320, -0.521706, 0.131108, 0.864620, -0.484939, 0.500000, 0.000000},
{0.249980, 0.510985, -0.524845, 0.047578, 0.306345, -0.950713, 0.000000, 0.000000},
{0.263868, 0.513716, -0.521706, 0.309824, 0.808832, -0.499741, 0.500000, 0.500000},
{0.263868, 0.513716, -0.511596, 0.358531, 0.933500, 0.000000, 0.000000, 0.500000},
{0.273853, 0.508072, -0.511596, 0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{0.261134, 0.509679, -0.524845, 0.103183, 0.271065, -0.956999, 1.000000, 0.500000},
{0.252169, 0.516320, -0.511596, 0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{0.279497, 0.498087, -0.489637, 0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{0.279497, 0.498087, -0.511596, 0.933500, 0.358531, 0.000000, 0.000000, 0.500000},
{0.273853, 0.508072, -0.489637, 0.707083, 0.707083, 0.000000, 0.500000, 1.000000},
{0.273853, 0.508072, -0.468359, 0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{0.279497, 0.498087, -0.468359, 0.933500, 0.358531, 0.000000, 1.000000, 0.500000},
{0.282101, 0.486388, -0.468359, 0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{0.282101, 0.486388, -0.489637, 0.988800, 0.149113, 0.000000, 0.500000, 0.000000},
{0.282101, 0.486388, -0.511596, 0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{0.279497, 0.498087, -0.460287, 0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{0.279497, 0.498087, -0.468359, 0.933500, 0.358531, 0.000000, 0.000000, 0.500000},
{0.273853, 0.508072, -0.468359, 0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{0.273853, 0.508072, -0.460287, 0.707083, 0.707083, 0.000000, 0.500000, 1.000000},
{0.273853, 0.508072, -0.458820, 0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{0.279497, 0.498087, -0.458820, 0.933500, 0.358531, 0.000000, 1.000000, 0.500000},
{0.282101, 0.486388, -0.458820, 0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{0.282101, 0.486388, -0.460287, 0.988800, 0.149113, 0.000000, 0.500000, 0.000000},
{0.282101, 0.486388, -0.468359, 0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{0.282969, 0.475605, -0.489637, 0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{0.282969, 0.475605, -0.511596, 0.999176, 0.040132, 0.000000, 0.000000, 0.500000},
{0.282101, 0.486388, -0.511596, 0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{0.282101, 0.486388, -0.489637, 0.988800, 0.149113, 0.000000, 0.500000, 1.000000},
{0.282101, 0.486388, -0.468359, 0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{0.282969, 0.475605, -0.468359, 0.999176, 0.040132, 0.000000, 1.000000, 0.500000},
{0.282969, 0.465280, -0.468359, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{0.282969, 0.465280, -0.489637, 1.000000, 0.000000, 0.000000, 0.500000, 0.000000},
{0.282969, 0.465280, -0.511596, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{0.282969, 0.475605, -0.460287, 0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{0.282969, 0.475605, -0.468359, 0.999176, 0.040132, 0.000000, 0.000000, 0.500000},
{0.282101, 0.486388, -0.468359, 0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{0.282101, 0.486388, -0.460287, 0.988800, 0.149113, 0.000000, 0.500000, 1.000000},
{0.282101, 0.486388, -0.458820, 0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{0.282969, 0.475605, -0.458820, 0.999176, 0.040132, 0.000000, 1.000000, 0.500000},
{0.282969, 0.465280, -0.458820, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{0.282969, 0.465280, -0.460287, 1.000000, 0.000000, 0.000000, 0.500000, 0.000000},
{0.282969, 0.465280, -0.468359, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{0.282969, 0.454955, -0.489637, 0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{0.282969, 0.454955, -0.511596, 0.999176, -0.040132, 0.000000, 0.000000, 0.500000},
{0.282969, 0.465280, -0.511596, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{0.282969, 0.465280, -0.489637, 1.000000, 0.000000, 0.000000, 0.500000, 1.000000},
{0.282969, 0.465280, -0.468359, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{0.282969, 0.454955, -0.468359, 0.999176, -0.040132, 0.000000, 1.000000, 0.500000},
{0.282101, 0.444173, -0.468359, 0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{0.282101, 0.444173, -0.489637, 0.988800, -0.149113, 0.000000, 0.500000, 0.000000},
{0.282101, 0.444173, -0.511596, 0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{0.282969, 0.454955, -0.460287, 0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{0.282969, 0.454955, -0.468359, 0.999176, -0.040132, 0.000000, 0.000000, 0.500000},
{0.282969, 0.465280, -0.468359, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{0.282969, 0.465280, -0.460287, 1.000000, 0.000000, 0.000000, 0.500000, 1.000000},
{0.282969, 0.465280, -0.458820, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{0.282969, 0.454955, -0.458820, 0.999176, -0.040132, 0.000000, 1.000000, 0.500000},
{0.282101, 0.444173, -0.458820, 0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{0.282101, 0.444173, -0.460287, 0.988800, -0.149113, 0.000000, 0.500000, 0.000000},
{0.282101, 0.444173, -0.468359, 0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{0.279496, 0.432474, -0.489637, 0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{0.279496, 0.432474, -0.511596, 0.933500, -0.358531, 0.000000, 0.000000, 0.500000},
{0.282101, 0.444173, -0.511596, 0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{0.282101, 0.444173, -0.489637, 0.988800, -0.149113, 0.000000, 0.500000, 1.000000},
{0.282101, 0.444173, -0.468359, 0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{0.279496, 0.432474, -0.468359, 0.933500, -0.358531, 0.000000, 1.000000, 0.500000},
{0.273853, 0.422488, -0.468359, 0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{0.273853, 0.422489, -0.489637, 0.707083, -0.707083, 0.000000, 0.500000, 0.000000},
{0.273853, 0.422489, -0.511596, 0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{0.279496, 0.432474, -0.460287, 0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{0.279496, 0.432474, -0.468359, 0.933500, -0.358531, 0.000000, 0.000000, 0.500000},
{0.282101, 0.444173, -0.468359, 0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{0.282101, 0.444173, -0.460287, 0.988800, -0.149113, 0.000000, 0.500000, 1.000000},
{0.282101, 0.444173, -0.458820, 0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{0.279496, 0.432474, -0.458820, 0.933500, -0.358531, 0.000000, 1.000000, 0.500000},
{0.273853, 0.422488, -0.458820, 0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{0.273853, 0.422488, -0.460287, 0.707083, -0.707083, 0.000000, 0.500000, 0.000000},
{0.273853, 0.422488, -0.468359, 0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{0.263868, 0.416845, -0.489637, 0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{0.263868, 0.416845, -0.511596, 0.358531, -0.933500, 0.000000, 0.000000, 0.500000},
{0.273853, 0.422489, -0.511596, 0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{0.273853, 0.422489, -0.489637, 0.707083, -0.707083, 0.000000, 0.500000, 1.000000},
{0.273853, 0.422488, -0.468359, 0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{0.263868, 0.416845, -0.468359, 0.358531, -0.933500, 0.000000, 1.000000, 0.500000},
{0.252169, 0.414241, -0.468359, 0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{0.252169, 0.414241, -0.489637, 0.149113, -0.988800, 0.000000, 0.500000, 0.000000},
{0.252169, 0.414241, -0.511596, 0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{0.263868, 0.416845, -0.460287, 0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{0.263868, 0.416845, -0.468359, 0.358531, -0.933500, 0.000000, 0.000000, 0.500000},
{0.273853, 0.422488, -0.468359, 0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{0.273853, 0.422488, -0.460287, 0.707083, -0.707083, 0.000000, 0.500000, 1.000000},
{0.273853, 0.422488, -0.458820, 0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{0.263868, 0.416845, -0.458820, 0.358531, -0.933500, 0.000000, 1.000000, 0.500000},
{0.252169, 0.414241, -0.458820, 0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{0.252169, 0.414241, -0.460287, 0.149113, -0.988800, 0.000000, 0.500000, 0.000000},
{0.252169, 0.414241, -0.468359, 0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{0.241386, 0.413373, -0.489637, 0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{0.241386, 0.413373, -0.511596, 0.040132, -0.999176, 0.000000, 0.000000, 0.500000},
{0.252169, 0.414241, -0.511596, 0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{0.252169, 0.414241, -0.489637, 0.149113, -0.988800, 0.000000, 0.500000, 1.000000},
{0.252169, 0.414241, -0.468359, 0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{0.241386, 0.413373, -0.468359, 0.040132, -0.999176, 0.000000, 1.000000, 0.500000},
{0.231061, 0.413373, -0.468359, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000},
{0.231061, 0.413373, -0.489637, 0.000000, -1.000000, 0.000000, 0.500000, 0.000000},
{0.231061, 0.413373, -0.511596, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000},
{0.241386, 0.413373, -0.460287, 0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{0.241386, 0.413373, -0.468359, 0.040132, -0.999176, 0.000000, 0.000000, 0.500000},
{0.252169, 0.414241, -0.468359, 0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{0.252169, 0.414241, -0.460287, 0.149113, -0.988800, 0.000000, 0.500000, 1.000000},
{0.252169, 0.414241, -0.458820, 0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{0.241386, 0.413373, -0.458820, 0.040132, -0.999176, 0.000000, 1.000000, 0.500000},
{0.231061, 0.413373, -0.458820, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000},
{0.231061, 0.413373, -0.460287, 0.000000, -1.000000, 0.000000, 0.500000, 0.000000},
{0.231061, 0.413373, -0.468359, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000},
{0.220736, 0.413373, -0.489637, -0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{0.220736, 0.413373, -0.511596, -0.040132, -0.999176, 0.000000, 0.000000, 0.500000},
{0.231061, 0.413373, -0.511596, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000},
{0.231061, 0.413373, -0.489637, 0.000000, -1.000000, 0.000000, 0.500000, 1.000000},
{0.231061, 0.413373, -0.468359, 0.000000, -1.000000, 0.000000, 1.000000, 1.000000},
{0.220736, 0.413373, -0.468359, -0.040132, -0.999176, 0.000000, 1.000000, 0.500000},
{0.209954, 0.414241, -0.468359, -0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{0.209954, 0.414241, -0.489637, -0.149113, -0.988800, 0.000000, 0.500000, 0.000000},
{0.209954, 0.414241, -0.511596, -0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{0.220736, 0.413373, -0.460287, -0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{0.220736, 0.413373, -0.468359, -0.040132, -0.999176, 0.000000, 0.000000, 0.500000},
{0.231061, 0.413373, -0.468359, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000},
{0.231061, 0.413373, -0.460287, 0.000000, -1.000000, 0.000000, 0.500000, 1.000000},
{0.231061, 0.413373, -0.458820, 0.000000, -1.000000, 0.000000, 1.000000, 1.000000},
{0.220736, 0.413373, -0.458820, -0.040132, -0.999176, 0.000000, 1.000000, 0.500000},
{0.209954, 0.414241, -0.458820, -0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{0.209954, 0.414241, -0.460287, -0.149113, -0.988800, 0.000000, 0.500000, 0.000000},
{0.209954, 0.414241, -0.468359, -0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{0.198255, 0.416845, -0.489637, -0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{0.198255, 0.416845, -0.511596, -0.358531, -0.933500, 0.000000, 0.000000, 0.500000},
{0.209954, 0.414241, -0.511596, -0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{0.209954, 0.414241, -0.489637, -0.149113, -0.988800, 0.000000, 0.500000, 1.000000},
{0.209954, 0.414241, -0.468359, -0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{0.198255, 0.416845, -0.468359, -0.358531, -0.933500, 0.000000, 1.000000, 0.500000},
{0.188269, 0.422489, -0.468359, -0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{0.188270, 0.422489, -0.489637, -0.707083, -0.707083, 0.000000, 0.500000, 0.000000},
{0.188270, 0.422489, -0.511596, -0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{0.198255, 0.416845, -0.460287, -0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{0.198255, 0.416845, -0.468359, -0.358531, -0.933500, 0.000000, 0.000000, 0.500000},
{0.209954, 0.414241, -0.468359, -0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{0.209954, 0.414241, -0.460287, -0.149113, -0.988800, 0.000000, 0.500000, 1.000000},
{0.209954, 0.414241, -0.458820, -0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{0.198255, 0.416845, -0.458820, -0.358531, -0.933500, 0.000000, 1.000000, 0.500000},
{0.188269, 0.422489, -0.458820, -0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{0.188269, 0.422489, -0.460287, -0.707083, -0.707083, 0.000000, 0.500000, 0.000000},
{0.188269, 0.422489, -0.468359, -0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{0.182626, 0.432474, -0.489637, -0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{0.182626, 0.432474, -0.511596, -0.933500, -0.358531, 0.000000, 0.000000, 0.500000},
{0.188270, 0.422489, -0.511596, -0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{0.188270, 0.422489, -0.489637, -0.707083, -0.707083, 0.000000, 0.500000, 1.000000},
{0.188269, 0.422489, -0.468359, -0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{0.182626, 0.432474, -0.468359, -0.933500, -0.358531, 0.000000, 1.000000, 0.500000},
{0.180022, 0.444173, -0.468359, -0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{0.180022, 0.444173, -0.489637, -0.988800, -0.149113, 0.000000, 0.500000, 0.000000},
{0.180022, 0.444173, -0.511596, -0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{0.182626, 0.432474, -0.460287, -0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{0.182626, 0.432474, -0.468359, -0.933500, -0.358531, 0.000000, 0.000000, 0.500000},
{0.188269, 0.422489, -0.468359, -0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{0.188269, 0.422489, -0.460287, -0.707083, -0.707083, 0.000000, 0.500000, 1.000000},
{0.188269, 0.422489, -0.458820, -0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{0.182626, 0.432474, -0.458820, -0.933500, -0.358531, 0.000000, 1.000000, 0.500000},
{0.180022, 0.444173, -0.458820, -0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{0.180022, 0.444173, -0.460287, -0.988800, -0.149113, 0.000000, 0.500000, 0.000000},
{0.180022, 0.444173, -0.468359, -0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{0.179154, 0.454956, -0.489637, -0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{0.179154, 0.454955, -0.511596, -0.999176, -0.040132, 0.000000, 0.000000, 0.500000},
{0.180022, 0.444173, -0.511596, -0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{0.180022, 0.444173, -0.489637, -0.988800, -0.149113, 0.000000, 0.500000, 1.000000},
{0.180022, 0.444173, -0.468359, -0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{0.179154, 0.454956, -0.468359, -0.999176, -0.040132, 0.000000, 1.000000, 0.500000},
{0.179154, 0.465281, -0.468359, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{0.179154, 0.465281, -0.489637, -1.000000, 0.000000, 0.000000, 0.500000, 0.000000},
{0.179154, 0.465280, -0.511596, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{0.179154, 0.454956, -0.460287, -0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{0.179154, 0.454956, -0.468359, -0.999176, -0.040132, 0.000000, 0.000000, 0.500000},
{0.180022, 0.444173, -0.468359, -0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{0.180022, 0.444173, -0.460287, -0.988800, -0.149113, 0.000000, 0.500000, 1.000000},
{0.180022, 0.444173, -0.458820, -0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{0.179154, 0.454956, -0.458820, -0.999176, -0.040132, 0.000000, 1.000000, 0.500000},
{0.179154, 0.465281, -0.458820, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{0.179154, 0.465281, -0.460287, -1.000000, 0.000000, 0.000000, 0.500000, 0.000000},
{0.179154, 0.465281, -0.468359, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{0.179154, 0.475605, -0.489637, -0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{0.179154, 0.475605, -0.511596, -0.999176, 0.040132, 0.000000, 0.000000, 0.500000},
{0.179154, 0.465280, -0.511596, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{0.179154, 0.465281, -0.489637, -1.000000, 0.000000, 0.000000, 0.500000, 1.000000},
{0.179154, 0.465281, -0.468359, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{0.179154, 0.475606, -0.468359, -0.999176, 0.040132, 0.000000, 1.000000, 0.500000},
{0.180022, 0.486388, -0.468359, -0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{0.180022, 0.486388, -0.489637, -0.988800, 0.149113, 0.000000, 0.500000, 0.000000},
{0.180022, 0.486388, -0.511596, -0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{0.179154, 0.475606, -0.460287, -0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{0.179154, 0.475606, -0.468359, -0.999176, 0.040132, 0.000000, 0.000000, 0.500000},
{0.179154, 0.465281, -0.468359, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{0.179154, 0.465281, -0.460287, -1.000000, 0.000000, 0.000000, 0.500000, 1.000000},
{0.179154, 0.465281, -0.458820, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{0.179154, 0.475606, -0.458820, -0.999176, 0.040132, 0.000000, 1.000000, 0.500000},
{0.180022, 0.486388, -0.458820, -0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{0.180022, 0.486388, -0.460287, -0.988800, 0.149113, 0.000000, 0.500000, 0.000000},
{0.180022, 0.486388, -0.468359, -0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{0.182626, 0.498087, -0.489637, -0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{0.182626, 0.498087, -0.511596, -0.933500, 0.358531, 0.000000, 0.000000, 0.500000},
{0.180022, 0.486388, -0.511596, -0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{0.180022, 0.486388, -0.489637, -0.988800, 0.149113, 0.000000, 0.500000, 1.000000},
{0.180022, 0.486388, -0.468359, -0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{0.182626, 0.498087, -0.468359, -0.933500, 0.358531, 0.000000, 1.000000, 0.500000},
{0.188270, 0.508072, -0.468359, -0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{0.188270, 0.508072, -0.489637, -0.707083, 0.707083, 0.000000, 0.500000, 0.000000},
{0.188270, 0.508072, -0.511596, -0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{0.182626, 0.498087, -0.460287, -0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{0.182626, 0.498087, -0.468359, -0.933500, 0.358531, 0.000000, 0.000000, 0.500000},
{0.180022, 0.486388, -0.468359, -0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{0.180022, 0.486388, -0.460287, -0.988800, 0.149113, 0.000000, 0.500000, 1.000000},
{0.180022, 0.486388, -0.458820, -0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{0.182626, 0.498087, -0.458820, -0.933500, 0.358531, 0.000000, 1.000000, 0.500000},
{0.188270, 0.508072, -0.458820, -0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{0.188270, 0.508072, -0.460287, -0.707083, 0.707083, 0.000000, 0.500000, 0.000000},
{0.188270, 0.508072, -0.468359, -0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{0.198255, 0.513716, -0.489637, -0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{0.198255, 0.513716, -0.511596, -0.358531, 0.933500, 0.000000, 0.000000, 0.500000},
{0.188270, 0.508072, -0.511596, -0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{0.188270, 0.508072, -0.489637, -0.707083, 0.707083, 0.000000, 0.500000, 1.000000},
{0.188270, 0.508072, -0.468359, -0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{0.198255, 0.513716, -0.468359, -0.358531, 0.933500, 0.000000, 1.000000, 0.500000},
{0.209954, 0.516320, -0.468359, -0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{0.209954, 0.516320, -0.489637, -0.149113, 0.988800, 0.000000, 0.500000, 0.000000},
{0.209954, 0.516320, -0.511596, -0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{0.198255, 0.513716, -0.460287, -0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{0.198255, 0.513716, -0.468359, -0.358531, 0.933500, 0.000000, 0.000000, 0.500000},
{0.188270, 0.508072, -0.468359, -0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{0.188270, 0.508072, -0.460287, -0.707083, 0.707083, 0.000000, 0.500000, 1.000000},
{0.188270, 0.508072, -0.458820, -0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{0.198255, 0.513716, -0.458820, -0.358531, 0.933500, 0.000000, 1.000000, 0.500000},
{0.209954, 0.516320, -0.458820, -0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{0.209954, 0.516320, -0.460287, -0.149113, 0.988800, 0.000000, 0.500000, 0.000000},
{0.209954, 0.516320, -0.468359, -0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{0.220737, 0.517188, -0.489637, -0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{0.220737, 0.517188, -0.511596, -0.040132, 0.999176, 0.000000, 0.000000, 0.500000},
{0.209954, 0.516320, -0.511596, -0.149113, 0.988800, 0.000000, 0.000000, 1.000000},
{0.209954, 0.516320, -0.489637, -0.149113, 0.988800, 0.000000, 0.500000, 1.000000},
{0.209954, 0.516320, -0.468359, -0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{0.220737, 0.517188, -0.468359, -0.040132, 0.999176, 0.000000, 1.000000, 0.500000},
{0.231062, 0.517188, -0.468359, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000},
{0.231062, 0.517188, -0.489637, 0.000000, 1.000000, 0.000000, 0.500000, 0.000000},
{0.231062, 0.517188, -0.511596, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000},
{0.220737, 0.517188, -0.460287, -0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{0.220737, 0.517188, -0.468359, -0.040132, 0.999176, 0.000000, 0.000000, 0.500000},
{0.209954, 0.516320, -0.468359, -0.149113, 0.988800, 0.000000, 0.000000, 1.000000},
{0.209954, 0.516320, -0.460287, -0.149113, 0.988800, 0.000000, 0.500000, 1.000000},
{0.209954, 0.516320, -0.458820, -0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{0.220737, 0.517188, -0.458820, -0.040132, 0.999176, 0.000000, 1.000000, 0.500000},
{0.231062, 0.517188, -0.458820, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000},
{0.231062, 0.517188, -0.460287, 0.000000, 1.000000, 0.000000, 0.500000, 0.000000},
{0.231062, 0.517188, -0.468359, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000},
{0.241387, 0.517188, -0.489637, 0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{0.241387, 0.517188, -0.511596, 0.040132, 0.999176, 0.000000, 0.000000, 0.500000},
{0.231062, 0.517188, -0.511596, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000},
{0.231062, 0.517188, -0.489637, 0.000000, 1.000000, 0.000000, 0.500000, 1.000000},
{0.231062, 0.517188, -0.468359, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000},
{0.241387, 0.517188, -0.468359, 0.040132, 0.999176, 0.000000, 1.000000, 0.500000},
{0.252169, 0.516320, -0.468359, 0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{0.252169, 0.516320, -0.489637, 0.149113, 0.988800, 0.000000, 0.500000, 0.000000},
{0.241387, 0.517188, -0.460287, 0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{0.241387, 0.517188, -0.468359, 0.040132, 0.999176, 0.000000, 0.000000, 0.500000},
{0.231062, 0.517188, -0.468359, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000},
{0.231062, 0.517188, -0.460287, 0.000000, 1.000000, 0.000000, 0.500000, 1.000000},
{0.231062, 0.517188, -0.458820, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000},
{0.241387, 0.517188, -0.458820, 0.040132, 0.999176, 0.000000, 1.000000, 0.500000},
{0.252169, 0.516320, -0.458820, 0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{0.252169, 0.516320, -0.460287, 0.149113, 0.988800, 0.000000, 0.500000, 0.000000},
{0.252169, 0.516320, -0.468359, 0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{0.263868, 0.513716, -0.460287, 0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{0.263868, 0.513716, -0.458820, 0.358531, 0.933500, 0.000000, 0.000000, 0.500000},
{0.273853, 0.508072, -0.458820, 0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{0.263868, 0.513716, -0.468359, 0.358531, 0.933500, 0.000000, 1.000000, 0.500000},
{0.252169, 0.516320, -0.458820, 0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{0.263868, 0.513716, -0.489637, 0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{0.263868, 0.513716, -0.468359, 0.358531, 0.933500, 0.000000, 0.000000, 0.500000},
{0.263868, 0.513716, -0.511596, 0.358531, 0.933500, 0.000000, 1.000000, 0.500000},
{-1.308993, 0.487151, -0.525891, -0.038942, 0.014740, -0.999115, 0.666667, 0.666667},
{-1.306404, 0.477631, -0.525891, -0.034944, 0.005951, -0.999359, 0.500000, 0.500000},
{-1.322407, 0.484199, -0.524845, -0.306345, 0.047578, -0.950713, 0.000000, 1.000000},
{-1.321102, 0.495353, -0.524845, -0.271065, 0.103183, -0.956999, 0.500000, 1.000000},
{-1.314992, 0.503570, -0.524845, -0.197760, 0.197760, -0.960082, 1.000000, 1.000000},
{-1.301484, 0.490061, -0.525891, -0.022248, 0.022248, -0.999481, 1.000000, 0.500000},
{-1.276703, 0.465280, -0.525891, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000},
{-1.311308, 0.472164, -0.525891, -0.045564, 0.001404, -0.998932, 0.666667, 0.666667},
{-1.276703, 0.465280, -0.525891, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000},
{-1.306982, 0.465280, -0.525891, -0.036836, 0.000000, -0.999298, 0.500000, 1.000000},
{-1.323203, 0.465280, -0.524845, -0.318735, 0.000000, -0.947813, 1.000000, 1.000000},
{-1.324284, 0.474745, -0.524845, -0.311838, 0.011902, -0.950041, 1.000000, 0.500000},
{-1.322407, 0.484199, -0.524845, -0.306345, 0.047578, -0.950713, 1.000000, 0.000000},
{-1.311308, 0.458397, -0.525891, -0.045564, -0.001404, -0.998932, 0.666667, 0.666667},
{-1.306982, 0.465280, -0.525891, -0.036836, 0.000000, -0.999298, 0.500000, 0.500000},
{-1.306403, 0.452929, -0.525891, -0.034944, -0.005951, -0.999359, 0.500000, 1.000000},
{-1.322407, 0.446362, -0.524845, -0.306345, -0.047578, -0.950713, 1.000000, 1.000000},
{-1.324284, 0.455816, -0.524845, -0.311838, -0.011902, -0.950041, 1.000000, 0.500000},
{-1.323203, 0.465280, -0.524845, -0.318735, 0.000000, -0.947813, 1.000000, 0.000000},
{-1.308993, 0.443409, -0.525891, -0.038942, -0.014740, -0.999115, 0.666667, 0.666667},
{-1.306403, 0.452929, -0.525891, -0.034944, -0.005951, -0.999359, 0.500000, 0.500000},
{-1.301484, 0.440499, -0.525891, -0.022248, -0.022248, -0.999481, 0.500000, 1.000000},
{-1.314992, 0.426991, -0.524845, -0.197760, -0.197760, -0.960082, 1.000000, 1.000000},
{-1.321102, 0.435208, -0.524845, -0.271065, -0.103183, -0.956999, 1.000000, 0.500000},
{-1.322407, 0.446362, -0.524845, -0.306345, -0.047578, -0.950713, 1.000000, 0.000000},
{-1.298574, 0.432990, -0.525891, -0.014740, -0.038942, -0.999115, 0.666667, 0.666667},
{-1.301484, 0.440499, -0.525891, -0.022248, -0.022248, -0.999481, 0.500000, 0.500000},
{-1.289054, 0.435580, -0.525891, -0.005951, -0.034944, -0.999359, 0.500000, 1.000000},
{-1.295622, 0.419576, -0.524845, -0.047578, -0.306345, -0.950713, 1.000000, 1.000000},
{-1.306776, 0.420882, -0.524845, -0.103183, -0.271065, -0.956999, 1.000000, 0.500000},
{-1.314992, 0.426991, -0.524845, -0.197760, -0.197760, -0.960082, 1.000000, 0.000000},
{-1.283586, 0.430676, -0.525891, -0.001404, -0.045564, -0.998932, 0.666667, 0.666667},
{-1.289054, 0.435580, -0.525891, -0.005951, -0.034944, -0.999359, 0.500000, 0.500000},
{-1.276703, 0.435001, -0.525891, 0.000000, -0.036836, -0.999298, 0.500000, 1.000000},
{-1.276703, 0.418780, -0.524845, 0.000000, -0.318705, -0.947844, 1.000000, 1.000000},
{-1.286168, 0.417699, -0.524845, -0.011902, -0.311838, -0.950041, 1.000000, 0.500000},
{-1.295622, 0.419576, -0.524845, -0.047578, -0.306345, -0.950713, 1.000000, 0.000000},
{-1.269820, 0.430676, -0.525891, 0.001404, -0.045564, -0.998932, 0.666667, 0.666667},
{-1.276703, 0.435001, -0.525891, 0.000000, -0.036836, -0.999298, 0.500000, 0.500000},
{-1.264352, 0.435580, -0.525891, 0.005951, -0.034944, -0.999359, 0.500000, 1.000000},
{-1.257784, 0.419576, -0.524845, 0.047578, -0.306345, -0.950713, 1.000000, 1.000000},
{-1.267238, 0.417699, -0.524845, 0.011902, -0.311838, -0.950041, 1.000000, 0.500000},
{-1.276703, 0.418780, -0.524845, 0.000000, -0.318705, -0.947844, 1.000000, 0.000000},
{-1.254832, 0.432990, -0.525891, 0.014740, -0.038942, -0.999115, 0.666667, 0.666667},
{-1.264352, 0.435580, -0.525891, 0.005951, -0.034944, -0.999359, 0.500000, 0.500000},
{-1.251922, 0.440499, -0.525891, 0.022248, -0.022248, -0.999481, 0.500000, 1.000000},
{-1.238414, 0.426991, -0.524845, 0.197760, -0.197760, -0.960082, 1.000000, 1.000000},
{-1.246630, 0.420882, -0.524845, 0.103183, -0.271065, -0.956999, 1.000000, 0.500000},
{-1.257784, 0.419576, -0.524845, 0.047578, -0.306345, -0.950713, 1.000000, 0.000000},
{-1.244413, 0.443409, -0.525891, 0.038942, -0.014740, -0.999115, 0.666667, 0.666667},
{-1.251922, 0.440499, -0.525891, 0.022248, -0.022248, -0.999481, 0.500000, 0.500000},
{-1.247002, 0.452929, -0.525891, 0.034944, -0.005951, -0.999359, 0.500000, 1.000000},
{-1.230999, 0.446362, -0.524845, 0.306345, -0.047578, -0.950713, 1.000000, 1.000000},
{-1.232304, 0.435208, -0.524845, 0.271065, -0.103183, -0.956999, 1.000000, 0.500000},
{-1.238414, 0.426991, -0.524845, 0.197760, -0.197760, -0.960082, 1.000000, 0.000000},
{-1.242098, 0.458397, -0.525891, 0.045564, -0.001404, -0.998932, 0.666667, 0.666667},
{-1.247002, 0.452929, -0.525891, 0.034944, -0.005951, -0.999359, 0.500000, 0.500000},
{-1.246424, 0.465280, -0.525891, 0.036836, 0.000000, -0.999298, 0.500000, 1.000000},
{-1.230203, 0.465280, -0.524845, 0.318705, 0.000000, -0.947844, 1.000000, 1.000000},
{-1.229121, 0.455816, -0.524845, 0.311838, -0.011902, -0.950041, 1.000000, 0.500000},
{-1.230999, 0.446362, -0.524845, 0.306345, -0.047578, -0.950713, 1.000000, 0.000000},
{-1.242098, 0.472164, -0.525891, 0.045564, 0.001404, -0.998932, 0.666667, 0.666667},
{-1.246424, 0.465280, -0.525891, 0.036836, 0.000000, -0.999298, 0.500000, 0.500000},
{-1.247002, 0.477632, -0.525891, 0.034944, 0.005951, -0.999359, 0.500000, 1.000000},
{-1.230999, 0.484199, -0.524845, 0.306345, 0.047578, -0.950713, 1.000000, 1.000000},
{-1.229121, 0.474745, -0.524845, 0.311838, 0.011902, -0.950041, 1.000000, 0.500000},
{-1.230203, 0.465280, -0.524845, 0.318705, 0.000000, -0.947844, 1.000000, 0.000000},
{-1.244413, 0.487151, -0.525891, 0.038942, 0.014740, -0.999115, 0.666667, 0.666667},
{-1.247002, 0.477632, -0.525891, 0.034944, 0.005951, -0.999359, 0.500000, 0.500000},
{-1.251922, 0.490061, -0.525891, 0.022248, 0.022248, -0.999481, 0.500000, 1.000000},
{-1.238414, 0.503570, -0.524845, 0.197760, 0.197760, -0.960082, 1.000000, 1.000000},
{-1.232304, 0.495353, -0.524845, 0.271065, 0.103183, -0.956999, 1.000000, 0.500000},
{-1.230999, 0.484199, -0.524845, 0.306345, 0.047578, -0.950713, 1.000000, 0.000000},
{-1.254832, 0.497570, -0.525891, 0.014740, 0.038942, -0.999115, 0.666667, 0.666667},
{-1.251922, 0.490061, -0.525891, 0.022248, 0.022248, -0.999481, 0.500000, 0.500000},
{-1.264352, 0.494981, -0.525891, 0.005951, 0.034944, -0.999359, 0.500000, 1.000000},
{-1.257784, 0.510985, -0.524845, 0.047578, 0.306345, -0.950713, 1.000000, 1.000000},
{-1.246630, 0.509679, -0.524845, 0.103183, 0.271065, -0.956999, 1.000000, 0.500000},
{-1.238414, 0.503570, -0.524845, 0.197760, 0.197760, -0.960082, 1.000000, 0.000000},
{-1.269820, 0.499885, -0.525891, 0.001404, 0.045564, -0.998932, 0.666667, 0.666667},
{-1.264352, 0.494981, -0.525891, 0.005951, 0.034944, -0.999359, 0.500000, 0.500000},
{-1.276703, 0.495560, -0.525891, 0.000000, 0.036836, -0.999298, 0.500000, 1.000000},
{-1.276703, 0.511781, -0.524845, 0.000000, 0.318705, -0.947844, 1.000000, 1.000000},
{-1.267238, 0.512862, -0.524845, 0.011902, 0.311838, -0.950041, 1.000000, 0.500000},
{-1.257784, 0.510985, -0.524845, 0.047578, 0.306345, -0.950713, 1.000000, 0.000000},
{-1.283586, 0.499885, -0.525891, -0.001404, 0.045564, -0.998932, 0.666667, 0.666667},
{-1.276703, 0.495560, -0.525891, 0.000000, 0.036836, -0.999298, 0.500000, 0.500000},
{-1.289054, 0.494981, -0.525891, -0.005951, 0.034944, -0.999359, 0.500000, 1.000000},
{-1.295622, 0.510985, -0.524845, -0.047578, 0.306345, -0.950713, 1.000000, 1.000000},
{-1.286168, 0.512862, -0.524845, -0.011902, 0.311838, -0.950041, 1.000000, 0.500000},
{-1.276703, 0.511781, -0.524845, 0.000000, 0.318705, -0.947844, 1.000000, 0.000000},
{-1.298574, 0.497570, -0.525891, -0.014740, 0.038942, -0.999115, 0.666667, 0.666667},
{-1.289054, 0.494981, -0.525891, -0.005951, 0.034944, -0.999359, 0.500000, 0.500000},
{-1.301484, 0.490061, -0.525891, -0.022248, 0.022248, -0.999481, 0.500000, 1.000000},
{-1.306776, 0.509679, -0.524845, -0.103183, 0.271065, -0.956999, 1.000000, 0.500000},
{-1.295622, 0.510985, -0.524845, -0.047578, 0.306345, -0.950713, 1.000000, 0.000000},
{-1.325138, 0.498087, -0.521706, -0.808832, 0.309824, -0.499771, 0.500000, 0.500000},
{-1.319495, 0.508072, -0.521706, -0.605670, 0.605670, -0.516007, 0.000000, 0.500000},
{-1.314992, 0.503570, -0.524845, -0.197760, 0.197760, -0.960082, 0.000000, 1.000000},
{-1.322407, 0.484199, -0.524845, -0.306345, 0.047578, -0.950713, 1.000000, 1.000000},
{-1.327742, 0.486388, -0.521706, -0.864620, 0.131108, -0.484939, 1.000000, 0.500000},
{-1.327742, 0.486388, -0.511596, -0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{-1.325138, 0.498087, -0.511596, -0.933500, 0.358531, 0.000000, 0.500000, 0.000000},
{-1.319495, 0.508072, -0.511596, -0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{-1.328610, 0.475605, -0.521706, -0.875942, 0.034852, -0.481124, 0.500000, 0.500000},
{-1.327742, 0.486388, -0.521706, -0.864620, 0.131108, -0.484939, 0.000000, 0.500000},
{-1.324284, 0.474745, -0.524845, -0.311838, 0.011902, -0.950041, 0.500000, 1.000000},
{-1.328610, 0.465280, -0.521706, -0.878658, 0.000000, -0.477401, 1.000000, 0.500000},
{-1.328610, 0.465280, -0.511596, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{-1.328610, 0.475605, -0.511596, -0.999176, 0.040132, 0.000000, 0.500000, 0.000000},
{-1.327742, 0.486388, -0.511596, -0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{-1.328610, 0.454955, -0.521706, -0.875942, -0.034852, -0.481124, 0.500000, 0.500000},
{-1.328610, 0.465280, -0.521706, -0.878658, 0.000000, -0.477401, 0.000000, 0.500000},
{-1.323203, 0.465280, -0.524845, -0.318735, 0.000000, -0.947813, 0.000000, 1.000000},
{-1.324284, 0.455816, -0.524845, -0.311838, -0.011902, -0.950041, 0.500000, 1.000000},
{-1.327742, 0.444173, -0.521706, -0.864620, -0.131108, -0.484939, 1.000000, 0.500000},
{-1.327742, 0.444173, -0.511596, -0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{-1.328610, 0.454955, -0.511596, -0.999176, -0.040132, 0.000000, 0.500000, 0.000000},
{-1.328610, 0.465280, -0.511596, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.325138, 0.432474, -0.521706, -0.808832, -0.309824, -0.499771, 0.500000, 0.500000},
{-1.327742, 0.444173, -0.521706, -0.864620, -0.131108, -0.484939, 0.000000, 0.500000},
{-1.322407, 0.446362, -0.524845, -0.306345, -0.047578, -0.950713, 0.000000, 1.000000},
{-1.321102, 0.435208, -0.524845, -0.271065, -0.103183, -0.956999, 0.500000, 1.000000},
{-1.319495, 0.422489, -0.521706, -0.605670, -0.605670, -0.516007, 1.000000, 0.500000},
{-1.319495, 0.422489, -0.511596, -0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{-1.325138, 0.432474, -0.511596, -0.933500, -0.358531, 0.000000, 0.500000, 0.000000},
{-1.327742, 0.444173, -0.511596, -0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{-1.309509, 0.416845, -0.521706, -0.309824, -0.808832, -0.499771, 0.500000, 0.500000},
{-1.319495, 0.422489, -0.521706, -0.605670, -0.605670, -0.516007, 0.000000, 0.500000},
{-1.314992, 0.426991, -0.524845, -0.197760, -0.197760, -0.960082, 0.000000, 1.000000},
{-1.306776, 0.420882, -0.524845, -0.103183, -0.271065, -0.956999, 0.500000, 1.000000},
{-1.297811, 0.414241, -0.521706, -0.131108, -0.864620, -0.484939, 1.000000, 0.500000},
{-1.297811, 0.414241, -0.511596, -0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{-1.309509, 0.416845, -0.511596, -0.358531, -0.933500, 0.000000, 0.500000, 0.000000},
{-1.319495, 0.422489, -0.511596, -0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{-1.287028, 0.413373, -0.521706, -0.034852, -0.875942, -0.481124, 0.500000, 0.500000},
{-1.297811, 0.414241, -0.521706, -0.131108, -0.864620, -0.484939, 0.000000, 0.500000},
{-1.295622, 0.419576, -0.524845, -0.047578, -0.306345, -0.950713, 0.000000, 1.000000},
{-1.286168, 0.417699, -0.524845, -0.011902, -0.311838, -0.950041, 0.500000, 1.000000},
{-1.276703, 0.413373, -0.521706, 0.000000, -0.878658, -0.477401, 1.000000, 0.500000},
{-1.276703, 0.413373, -0.511596, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000},
{-1.287028, 0.413373, -0.511596, -0.040132, -0.999176, 0.000000, 0.500000, 0.000000},
{-1.297811, 0.414241, -0.511596, -0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{-1.266378, 0.413373, -0.521706, 0.034852, -0.875942, -0.481124, 0.500000, 0.500000},
{-1.276703, 0.413373, -0.521706, 0.000000, -0.878658, -0.477401, 0.000000, 0.500000},
{-1.276703, 0.418780, -0.524845, 0.000000, -0.318705, -0.947844, 0.000000, 1.000000},
{-1.267238, 0.417699, -0.524845, 0.011902, -0.311838, -0.950041, 0.500000, 1.000000},
{-1.255595, 0.414241, -0.521706, 0.131108, -0.864620, -0.484939, 1.000000, 0.500000},
{-1.255595, 0.414241, -0.511596, 0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{-1.266378, 0.413373, -0.511596, 0.040132, -0.999176, 0.000000, 0.500000, 0.000000},
{-1.276703, 0.413373, -0.511596, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000},
{-1.243896, 0.416845, -0.521706, 0.309824, -0.808832, -0.499771, 0.500000, 0.500000},
{-1.255595, 0.414241, -0.521706, 0.131108, -0.864620, -0.484939, 0.000000, 0.500000},
{-1.257784, 0.419576, -0.524845, 0.047578, -0.306345, -0.950713, 0.000000, 1.000000},
{-1.246630, 0.420882, -0.524845, 0.103183, -0.271065, -0.956999, 0.500000, 1.000000},
{-1.233911, 0.422489, -0.521706, 0.605670, -0.605670, -0.516007, 1.000000, 0.500000},
{-1.233911, 0.422489, -0.511596, 0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{-1.243896, 0.416845, -0.511596, 0.358531, -0.933500, 0.000000, 0.500000, 0.000000},
{-1.255595, 0.414241, -0.511596, 0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{-1.228268, 0.432474, -0.521706, 0.808832, -0.309793, -0.499741, 0.500000, 0.500000},
{-1.233911, 0.422489, -0.521706, 0.605670, -0.605670, -0.516007, 0.000000, 0.500000},
{-1.238414, 0.426991, -0.524845, 0.197760, -0.197760, -0.960082, 0.000000, 1.000000},
{-1.232304, 0.435208, -0.524845, 0.271065, -0.103183, -0.956999, 0.500000, 1.000000},
{-1.225664, 0.444173, -0.521706, 0.864620, -0.131108, -0.484939, 1.000000, 0.500000},
{-1.225664, 0.444173, -0.511596, 0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{-1.228268, 0.432474, -0.511596, 0.933500, -0.358531, 0.000000, 0.500000, 0.000000},
{-1.233911, 0.422489, -0.511596, 0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{-1.224796, 0.454955, -0.521706, 0.875942, -0.034852, -0.481124, 0.500000, 0.500000},
{-1.225664, 0.444173, -0.521706, 0.864620, -0.131108, -0.484939, 0.000000, 0.500000},
{-1.230999, 0.446362, -0.524845, 0.306345, -0.047578, -0.950713, 0.000000, 1.000000},
{-1.229121, 0.455816, -0.524845, 0.311838, -0.011902, -0.950041, 0.500000, 1.000000},
{-1.224796, 0.465280, -0.521706, 0.878658, 0.000000, -0.477401, 1.000000, 0.500000},
{-1.224796, 0.465280, -0.511596, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{-1.224796, 0.454955, -0.511596, 0.999176, -0.040132, 0.000000, 0.500000, 0.000000},
{-1.225664, 0.444173, -0.511596, 0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{-1.224796, 0.475605, -0.521706, 0.875942, 0.034852, -0.481124, 0.500000, 0.500000},
{-1.224796, 0.465280, -0.521706, 0.878658, 0.000000, -0.477401, 0.000000, 0.500000},
{-1.230203, 0.465280, -0.524845, 0.318705, 0.000000, -0.947844, 0.000000, 1.000000},
{-1.229121, 0.474745, -0.524845, 0.311838, 0.011902, -0.950041, 0.500000, 1.000000},
{-1.225664, 0.486388, -0.521706, 0.864620, 0.131108, -0.484939, 1.000000, 0.500000},
{-1.225664, 0.486388, -0.511596, 0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{-1.224796, 0.475605, -0.511596, 0.999176, 0.040132, 0.000000, 0.500000, 0.000000},
{-1.224796, 0.465280, -0.511596, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.228268, 0.498087, -0.521706, 0.808832, 0.309793, -0.499741, 0.500000, 0.500000},
{-1.225664, 0.486388, -0.521706, 0.864620, 0.131108, -0.484939, 0.000000, 0.500000},
{-1.230999, 0.484199, -0.524845, 0.306345, 0.047578, -0.950713, 0.000000, 1.000000},
{-1.232304, 0.495353, -0.524845, 0.271065, 0.103183, -0.956999, 0.500000, 1.000000},
{-1.233911, 0.508072, -0.521706, 0.605670, 0.605670, -0.516007, 1.000000, 0.500000},
{-1.233911, 0.508072, -0.511596, 0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{-1.228268, 0.498087, -0.511596, 0.933500, 0.358531, 0.000000, 0.500000, 0.000000},
{-1.225664, 0.486388, -0.511596, 0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{-1.243896, 0.513716, -0.521706, 0.309793, 0.808832, -0.499771, 0.500000, 0.500000},
{-1.233911, 0.508072, -0.521706, 0.605670, 0.605670, -0.516007, 0.000000, 0.500000},
{-1.238414, 0.503570, -0.524845, 0.197760, 0.197760, -0.960082, 0.000000, 1.000000},
{-1.246630, 0.509679, -0.524845, 0.103183, 0.271065, -0.956999, 0.500000, 1.000000},
{-1.255595, 0.516320, -0.521706, 0.131108, 0.864620, -0.484939, 1.000000, 0.500000},
{-1.255595, 0.516320, -0.511596, 0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{-1.243896, 0.513716, -0.511596, 0.358531, 0.933500, 0.000000, 0.500000, 0.000000},
{-1.233911, 0.508072, -0.511596, 0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{-1.266378, 0.517188, -0.521706, 0.034852, 0.875942, -0.481124, 0.500000, 0.500000},
{-1.255595, 0.516320, -0.521706, 0.131108, 0.864620, -0.484939, 0.000000, 0.500000},
{-1.257784, 0.510985, -0.524845, 0.047578, 0.306345, -0.950713, 0.000000, 1.000000},
{-1.267238, 0.512862, -0.524845, 0.011902, 0.311838, -0.950041, 0.500000, 1.000000},
{-1.276703, 0.517188, -0.521706, 0.000000, 0.878658, -0.477401, 1.000000, 0.500000},
{-1.276703, 0.517188, -0.511596, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000},
{-1.266378, 0.517188, -0.511596, 0.040132, 0.999176, 0.000000, 0.500000, 0.000000},
{-1.255595, 0.516320, -0.511596, 0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{-1.287028, 0.517188, -0.521706, -0.034852, 0.875942, -0.481124, 0.500000, 0.500000},
{-1.276703, 0.517188, -0.521706, 0.000000, 0.878658, -0.477401, 0.000000, 0.500000},
{-1.276703, 0.511781, -0.524845, 0.000000, 0.318705, -0.947844, 0.000000, 1.000000},
{-1.286168, 0.512862, -0.524845, -0.011902, 0.311838, -0.950041, 0.500000, 1.000000},
{-1.297811, 0.516320, -0.521706, -0.131108, 0.864620, -0.484939, 1.000000, 0.500000},
{-1.297811, 0.516320, -0.511596, -0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{-1.287028, 0.517188, -0.511596, -0.040132, 0.999176, 0.000000, 0.500000, 0.000000},
{-1.276703, 0.517188, -0.511596, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000},
{-1.309509, 0.513716, -0.521706, -0.309824, 0.808832, -0.499771, 0.500000, 0.500000},
{-1.297811, 0.516320, -0.521706, -0.131108, 0.864620, -0.484939, 0.000000, 0.500000},
{-1.295622, 0.510985, -0.524845, -0.047578, 0.306345, -0.950713, 0.000000, 1.000000},
{-1.306776, 0.509679, -0.524845, -0.103183, 0.271065, -0.956999, 0.500000, 1.000000},
{-1.319495, 0.508072, -0.521706, -0.605670, 0.605670, -0.516007, 1.000000, 0.500000},
{-1.319495, 0.508072, -0.511596, -0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{-1.309510, 0.513716, -0.511596, -0.358531, 0.933500, 0.000000, 0.500000, 0.000000},
{-1.297811, 0.516320, -0.511596, -0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{-1.325138, 0.498087, -0.489637, -0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{-1.319495, 0.508072, -0.489637, -0.707083, 0.707083, 0.000000, 0.000000, 0.500000},
{-1.319495, 0.508072, -0.511596, -0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{-1.325138, 0.498087, -0.511596, -0.933500, 0.358531, 0.000000, 0.500000, 1.000000},
{-1.327742, 0.486388, -0.511596, -0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{-1.327742, 0.486388, -0.489637, -0.988800, 0.149113, 0.000000, 1.000000, 0.500000},
{-1.327742, 0.486388, -0.468359, -0.988800, 0.149083, 0.000000, 1.000000, 0.000000},
{-1.325138, 0.498087, -0.468359, -0.933500, 0.358531, 0.000000, 0.500000, 0.000000},
{-1.319495, 0.508072, -0.468359, -0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{-1.325138, 0.498087, -0.460287, -0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{-1.319495, 0.508072, -0.460287, -0.707083, 0.707083, 0.000000, 0.000000, 0.500000},
{-1.319495, 0.508072, -0.468359, -0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{-1.325138, 0.498087, -0.468359, -0.933500, 0.358531, 0.000000, 0.500000, 1.000000},
{-1.327742, 0.486388, -0.468359, -0.988800, 0.149083, 0.000000, 1.000000, 1.000000},
{-1.327742, 0.486388, -0.460287, -0.988800, 0.149083, 0.000000, 1.000000, 0.500000},
{-1.327742, 0.486388, -0.458820, -0.988800, 0.149083, 0.000000, 1.000000, 0.000000},
{-1.325138, 0.498087, -0.458820, -0.933500, 0.358531, 0.000000, 0.500000, 0.000000},
{-1.319495, 0.508072, -0.458820, -0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{-1.328610, 0.475605, -0.489637, -0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{-1.327742, 0.486388, -0.489637, -0.988800, 0.149113, 0.000000, 0.000000, 0.500000},
{-1.327742, 0.486388, -0.511596, -0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{-1.328610, 0.475605, -0.511596, -0.999176, 0.040132, 0.000000, 0.500000, 1.000000},
{-1.328610, 0.465280, -0.511596, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{-1.328610, 0.465280, -0.489637, -1.000000, 0.000000, 0.000000, 1.000000, 0.500000},
{-1.328610, 0.465280, -0.468359, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{-1.328610, 0.475605, -0.468359, -0.999176, 0.040132, 0.000000, 0.500000, 0.000000},
{-1.327742, 0.486388, -0.468359, -0.988800, 0.149083, 0.000000, 0.000000, 0.000000},
{-1.328610, 0.475605, -0.460287, -0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{-1.327742, 0.486388, -0.460287, -0.988800, 0.149083, 0.000000, 0.000000, 0.500000},
{-1.327742, 0.486388, -0.468359, -0.988800, 0.149083, 0.000000, 0.000000, 1.000000},
{-1.328610, 0.475605, -0.468359, -0.999176, 0.040132, 0.000000, 0.500000, 1.000000},
{-1.328610, 0.465280, -0.468359, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{-1.328610, 0.465280, -0.460287, -1.000000, 0.000000, 0.000000, 1.000000, 0.500000},
{-1.328610, 0.465280, -0.458820, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{-1.328610, 0.475605, -0.458820, -0.999176, 0.040132, 0.000000, 0.500000, 0.000000},
{-1.327742, 0.486388, -0.458820, -0.988800, 0.149083, 0.000000, 0.000000, 0.000000},
{-1.328610, 0.454955, -0.489637, -0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{-1.328610, 0.465280, -0.489637, -1.000000, 0.000000, 0.000000, 0.000000, 0.500000},
{-1.328610, 0.465280, -0.511596, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{-1.328610, 0.454955, -0.511596, -0.999176, -0.040132, 0.000000, 0.500000, 1.000000},
{-1.327742, 0.444173, -0.511596, -0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{-1.327742, 0.444173, -0.489637, -0.988800, -0.149113, 0.000000, 1.000000, 0.500000},
{-1.327742, 0.444173, -0.468359, -0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{-1.328610, 0.454955, -0.468359, -0.999176, -0.040132, 0.000000, 0.500000, 0.000000},
{-1.328610, 0.465280, -0.468359, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.328610, 0.454955, -0.460287, -0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{-1.328610, 0.465280, -0.460287, -1.000000, 0.000000, 0.000000, 0.000000, 0.500000},
{-1.328610, 0.465280, -0.468359, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{-1.328610, 0.454955, -0.468359, -0.999176, -0.040132, 0.000000, 0.500000, 1.000000},
{-1.327742, 0.444173, -0.468359, -0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{-1.327742, 0.444173, -0.460287, -0.988800, -0.149113, 0.000000, 1.000000, 0.500000},
{-1.327742, 0.444173, -0.458820, -0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{-1.328610, 0.454955, -0.458820, -0.999176, -0.040132, 0.000000, 0.500000, 0.000000},
{-1.328610, 0.465280, -0.458820, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.325138, 0.432474, -0.489637, -0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{-1.327742, 0.444173, -0.489637, -0.988800, -0.149113, 0.000000, 0.000000, 0.500000},
{-1.327742, 0.444173, -0.511596, -0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{-1.325138, 0.432474, -0.511596, -0.933500, -0.358531, 0.000000, 0.500000, 1.000000},
{-1.319495, 0.422489, -0.511596, -0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{-1.319495, 0.422489, -0.489637, -0.707083, -0.707083, 0.000000, 1.000000, 0.500000},
{-1.319495, 0.422488, -0.468359, -0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{-1.325138, 0.432474, -0.468359, -0.933500, -0.358531, 0.000000, 0.500000, 0.000000},
{-1.327742, 0.444173, -0.468359, -0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{-1.325138, 0.432474, -0.460287, -0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{-1.327742, 0.444173, -0.460287, -0.988800, -0.149113, 0.000000, 0.000000, 0.500000},
{-1.327742, 0.444173, -0.468359, -0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{-1.325138, 0.432474, -0.468359, -0.933500, -0.358531, 0.000000, 0.500000, 1.000000},
{-1.319495, 0.422488, -0.468359, -0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{-1.319495, 0.422488, -0.460287, -0.707083, -0.707083, 0.000000, 1.000000, 0.500000},
{-1.319495, 0.422488, -0.458820, -0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{-1.325138, 0.432474, -0.458820, -0.933500, -0.358531, 0.000000, 0.500000, 0.000000},
{-1.327742, 0.444173, -0.458820, -0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{-1.309509, 0.416845, -0.489637, -0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{-1.319495, 0.422489, -0.489637, -0.707083, -0.707083, 0.000000, 0.000000, 0.500000},
{-1.319495, 0.422489, -0.511596, -0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{-1.309509, 0.416845, -0.511596, -0.358531, -0.933500, 0.000000, 0.500000, 1.000000},
{-1.297811, 0.414241, -0.511596, -0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{-1.297811, 0.414241, -0.489637, -0.149113, -0.988800, 0.000000, 1.000000, 0.500000},
{-1.297811, 0.414241, -0.468359, -0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{-1.309509, 0.416845, -0.468359, -0.358531, -0.933500, 0.000000, 0.500000, 0.000000},
{-1.319495, 0.422488, -0.468359, -0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{-1.309509, 0.416845, -0.460287, -0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{-1.319495, 0.422488, -0.460287, -0.707083, -0.707083, 0.000000, 0.000000, 0.500000},
{-1.319495, 0.422488, -0.468359, -0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{-1.309509, 0.416845, -0.468359, -0.358531, -0.933500, 0.000000, 0.500000, 1.000000},
{-1.297811, 0.414241, -0.468359, -0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{-1.297811, 0.414241, -0.460287, -0.149113, -0.988800, 0.000000, 1.000000, 0.500000},
{-1.297811, 0.414241, -0.458820, -0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{-1.309509, 0.416845, -0.458820, -0.358531, -0.933500, 0.000000, 0.500000, 0.000000},
{-1.319495, 0.422488, -0.458820, -0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{-1.287028, 0.413373, -0.489637, -0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{-1.297811, 0.414241, -0.489637, -0.149113, -0.988800, 0.000000, 0.000000, 0.500000},
{-1.297811, 0.414241, -0.511596, -0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{-1.287028, 0.413373, -0.511596, -0.040132, -0.999176, 0.000000, 0.500000, 1.000000},
{-1.276703, 0.413373, -0.511596, 0.000000, -1.000000, 0.000000, 1.000000, 1.000000},
{-1.276703, 0.413373, -0.489637, 0.000000, -1.000000, 0.000000, 1.000000, 0.500000},
{-1.276703, 0.413373, -0.468359, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000},
{-1.287028, 0.413373, -0.468359, -0.040132, -0.999176, 0.000000, 0.500000, 0.000000},
{-1.297811, 0.414241, -0.468359, -0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{-1.287028, 0.413373, -0.460287, -0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{-1.297811, 0.414241, -0.460287, -0.149113, -0.988800, 0.000000, 0.000000, 0.500000},
{-1.297811, 0.414241, -0.468359, -0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{-1.287028, 0.413373, -0.468359, -0.040132, -0.999176, 0.000000, 0.500000, 1.000000},
{-1.276703, 0.413373, -0.468359, 0.000000, -1.000000, 0.000000, 1.000000, 1.000000},
{-1.276703, 0.413373, -0.460287, 0.000000, -1.000000, 0.000000, 1.000000, 0.500000},
{-1.276703, 0.413373, -0.458820, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000},
{-1.287028, 0.413373, -0.458820, -0.040132, -0.999176, 0.000000, 0.500000, 0.000000},
{-1.297811, 0.414241, -0.458820, -0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{-1.266378, 0.413373, -0.489637, 0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{-1.276703, 0.413373, -0.489637, 0.000000, -1.000000, 0.000000, 0.000000, 0.500000},
{-1.276703, 0.413373, -0.511596, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000},
{-1.266378, 0.413373, -0.511596, 0.040132, -0.999176, 0.000000, 0.500000, 1.000000},
{-1.255595, 0.414241, -0.511596, 0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{-1.255595, 0.414241, -0.489637, 0.149113, -0.988800, 0.000000, 1.000000, 0.500000},
{-1.255595, 0.414241, -0.468359, 0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{-1.266378, 0.413373, -0.468359, 0.040132, -0.999176, 0.000000, 0.500000, 0.000000},
{-1.276703, 0.413373, -0.468359, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000},
{-1.266378, 0.413373, -0.460287, 0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{-1.276703, 0.413373, -0.460287, 0.000000, -1.000000, 0.000000, 0.000000, 0.500000},
{-1.276703, 0.413373, -0.468359, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000},
{-1.266378, 0.413373, -0.468359, 0.040132, -0.999176, 0.000000, 0.500000, 1.000000},
{-1.255595, 0.414241, -0.468359, 0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{-1.255595, 0.414241, -0.460287, 0.149113, -0.988800, 0.000000, 1.000000, 0.500000},
{-1.255595, 0.414241, -0.458820, 0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{-1.266378, 0.413373, -0.458820, 0.040132, -0.999176, 0.000000, 0.500000, 0.000000},
{-1.276703, 0.413373, -0.458820, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000},
{-1.243896, 0.416845, -0.489637, 0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{-1.255595, 0.414241, -0.489637, 0.149113, -0.988800, 0.000000, 0.000000, 0.500000},
{-1.255595, 0.414241, -0.511596, 0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{-1.243896, 0.416845, -0.511596, 0.358531, -0.933500, 0.000000, 0.500000, 1.000000},
{-1.233911, 0.422489, -0.511596, 0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{-1.233911, 0.422489, -0.489637, 0.707083, -0.707083, 0.000000, 1.000000, 0.500000},
{-1.233911, 0.422489, -0.468359, 0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{-1.243896, 0.416845, -0.468359, 0.358531, -0.933500, 0.000000, 0.500000, 0.000000},
{-1.255595, 0.414241, -0.468359, 0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{-1.243896, 0.416845, -0.460287, 0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{-1.255595, 0.414241, -0.460287, 0.149113, -0.988800, 0.000000, 0.000000, 0.500000},
{-1.255595, 0.414241, -0.468359, 0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{-1.243896, 0.416845, -0.468359, 0.358531, -0.933500, 0.000000, 0.500000, 1.000000},
{-1.233911, 0.422489, -0.468359, 0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{-1.233911, 0.422489, -0.460287, 0.707083, -0.707083, 0.000000, 1.000000, 0.500000},
{-1.233911, 0.422489, -0.458820, 0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{-1.243896, 0.416845, -0.458820, 0.358531, -0.933500, 0.000000, 0.500000, 0.000000},
{-1.255595, 0.414241, -0.458820, 0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{-1.228268, 0.432474, -0.489637, 0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{-1.233911, 0.422489, -0.489637, 0.707083, -0.707083, 0.000000, 0.000000, 0.500000},
{-1.233911, 0.422489, -0.511596, 0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{-1.228268, 0.432474, -0.511596, 0.933500, -0.358531, 0.000000, 0.500000, 1.000000},
{-1.225664, 0.444173, -0.511596, 0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{-1.225664, 0.444173, -0.489637, 0.988800, -0.149113, 0.000000, 1.000000, 0.500000},
{-1.225664, 0.444173, -0.468359, 0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{-1.228268, 0.432474, -0.468359, 0.933500, -0.358531, 0.000000, 0.500000, 0.000000},
{-1.233911, 0.422489, -0.468359, 0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{-1.228268, 0.432474, -0.460287, 0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{-1.233911, 0.422489, -0.460287, 0.707083, -0.707083, 0.000000, 0.000000, 0.500000},
{-1.233911, 0.422489, -0.468359, 0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{-1.228268, 0.432474, -0.468359, 0.933500, -0.358531, 0.000000, 0.500000, 1.000000},
{-1.225664, 0.444173, -0.468359, 0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{-1.225664, 0.444173, -0.460287, 0.988800, -0.149113, 0.000000, 1.000000, 0.500000},
{-1.225664, 0.444173, -0.458820, 0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{-1.228268, 0.432474, -0.458820, 0.933500, -0.358531, 0.000000, 0.500000, 0.000000},
{-1.233911, 0.422489, -0.458820, 0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{-1.224796, 0.454956, -0.489637, 0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{-1.225664, 0.444173, -0.489637, 0.988800, -0.149113, 0.000000, 0.000000, 0.500000},
{-1.225664, 0.444173, -0.511596, 0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{-1.224796, 0.454955, -0.511596, 0.999176, -0.040132, 0.000000, 0.500000, 1.000000},
{-1.224796, 0.465280, -0.511596, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{-1.224796, 0.465281, -0.489637, 1.000000, 0.000000, 0.000000, 1.000000, 0.500000},
{-1.224796, 0.465281, -0.468359, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{-1.224796, 0.454956, -0.468359, 0.999176, -0.040132, 0.000000, 0.500000, 0.000000},
{-1.225664, 0.444173, -0.468359, 0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{-1.224796, 0.454956, -0.460287, 0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{-1.225664, 0.444173, -0.460287, 0.988800, -0.149113, 0.000000, 0.000000, 0.500000},
{-1.225664, 0.444173, -0.468359, 0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{-1.224796, 0.454956, -0.468359, 0.999176, -0.040132, 0.000000, 0.500000, 1.000000},
{-1.224796, 0.465281, -0.468359, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{-1.224796, 0.465281, -0.460287, 1.000000, 0.000000, 0.000000, 1.000000, 0.500000},
{-1.224796, 0.465281, -0.458820, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{-1.224796, 0.454956, -0.458820, 0.999176, -0.040132, 0.000000, 0.500000, 0.000000},
{-1.225664, 0.444173, -0.458820, 0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{-1.224796, 0.475605, -0.489637, 0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{-1.224796, 0.465281, -0.489637, 1.000000, 0.000000, 0.000000, 0.000000, 0.500000},
{-1.224796, 0.465280, -0.511596, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{-1.224796, 0.475605, -0.511596, 0.999176, 0.040132, 0.000000, 0.500000, 1.000000},
{-1.225664, 0.486388, -0.511596, 0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{-1.225664, 0.486388, -0.489637, 0.988800, 0.149113, 0.000000, 1.000000, 0.500000},
{-1.225664, 0.486388, -0.468359, 0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{-1.224796, 0.475606, -0.468359, 0.999176, 0.040132, 0.000000, 0.500000, 0.000000},
{-1.224796, 0.465281, -0.468359, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.224796, 0.475606, -0.460287, 0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{-1.224796, 0.465281, -0.460287, 1.000000, 0.000000, 0.000000, 0.000000, 0.500000},
{-1.224796, 0.465281, -0.468359, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{-1.224796, 0.475606, -0.468359, 0.999176, 0.040132, 0.000000, 0.500000, 1.000000},
{-1.225664, 0.486388, -0.468359, 0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{-1.225664, 0.486388, -0.460287, 0.988800, 0.149113, 0.000000, 1.000000, 0.500000},
{-1.225664, 0.486388, -0.458820, 0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{-1.224796, 0.475606, -0.458820, 0.999176, 0.040132, 0.000000, 0.500000, 0.000000},
{-1.224796, 0.465281, -0.458820, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.228268, 0.498087, -0.489637, 0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{-1.225664, 0.486388, -0.489637, 0.988800, 0.149113, 0.000000, 0.000000, 0.500000},
{-1.225664, 0.486388, -0.511596, 0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{-1.228268, 0.498087, -0.511596, 0.933500, 0.358531, 0.000000, 0.500000, 1.000000},
{-1.233911, 0.508072, -0.511596, 0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{-1.233911, 0.508072, -0.489637, 0.707083, 0.707083, 0.000000, 1.000000, 0.500000},
{-1.233911, 0.508072, -0.468359, 0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{-1.228268, 0.498087, -0.468359, 0.933500, 0.358531, 0.000000, 0.500000, 0.000000},
{-1.225664, 0.486388, -0.468359, 0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{-1.228268, 0.498087, -0.460287, 0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{-1.225664, 0.486388, -0.460287, 0.988800, 0.149113, 0.000000, 0.000000, 0.500000},
{-1.225664, 0.486388, -0.468359, 0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{-1.228268, 0.498087, -0.468359, 0.933500, 0.358531, 0.000000, 0.500000, 1.000000},
{-1.233911, 0.508072, -0.468359, 0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{-1.233911, 0.508072, -0.460287, 0.707083, 0.707083, 0.000000, 1.000000, 0.500000},
{-1.233911, 0.508072, -0.458820, 0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{-1.228268, 0.498087, -0.458820, 0.933500, 0.358531, 0.000000, 0.500000, 0.000000},
{-1.225664, 0.486388, -0.458820, 0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{-1.243897, 0.513716, -0.489637, 0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{-1.233911, 0.508072, -0.489637, 0.707083, 0.707083, 0.000000, 0.000000, 0.500000},
{-1.233911, 0.508072, -0.511596, 0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{-1.243896, 0.513716, -0.511596, 0.358531, 0.933500, 0.000000, 0.500000, 1.000000},
{-1.255595, 0.516320, -0.511596, 0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{-1.255595, 0.516320, -0.489637, 0.149113, 0.988800, 0.000000, 1.000000, 0.500000},
{-1.255595, 0.516320, -0.468359, 0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{-1.243897, 0.513716, -0.468359, 0.358531, 0.933500, 0.000000, 0.500000, 0.000000},
{-1.233911, 0.508072, -0.468359, 0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{-1.243897, 0.513716, -0.460287, 0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{-1.233911, 0.508072, -0.460287, 0.707083, 0.707083, 0.000000, 0.000000, 0.500000},
{-1.233911, 0.508072, -0.468359, 0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{-1.243897, 0.513716, -0.468359, 0.358531, 0.933500, 0.000000, 0.500000, 1.000000},
{-1.255595, 0.516320, -0.468359, 0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{-1.255595, 0.516320, -0.460287, 0.149113, 0.988800, 0.000000, 1.000000, 0.500000},
{-1.255595, 0.516320, -0.458820, 0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{-1.243897, 0.513716, -0.458820, 0.358531, 0.933500, 0.000000, 0.500000, 0.000000},
{-1.233911, 0.508072, -0.458820, 0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{-1.266378, 0.517188, -0.489637, 0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{-1.255595, 0.516320, -0.489637, 0.149113, 0.988800, 0.000000, 0.000000, 0.500000},
{-1.255595, 0.516320, -0.511596, 0.149113, 0.988800, 0.000000, 0.000000, 1.000000},
{-1.266378, 0.517188, -0.511596, 0.040132, 0.999176, 0.000000, 0.500000, 1.000000},
{-1.276703, 0.517188, -0.511596, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000},
{-1.276703, 0.517188, -0.489637, 0.000000, 1.000000, 0.000000, 1.000000, 0.500000},
{-1.276703, 0.517188, -0.468359, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000},
{-1.266378, 0.517188, -0.468359, 0.040132, 0.999176, 0.000000, 0.500000, 0.000000},
{-1.255595, 0.516320, -0.468359, 0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{-1.266378, 0.517188, -0.460287, 0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{-1.255595, 0.516320, -0.460287, 0.149113, 0.988800, 0.000000, 0.000000, 0.500000},
{-1.255595, 0.516320, -0.468359, 0.149113, 0.988800, 0.000000, 0.000000, 1.000000},
{-1.266378, 0.517188, -0.468359, 0.040132, 0.999176, 0.000000, 0.500000, 1.000000},
{-1.276703, 0.517188, -0.468359, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000},
{-1.276703, 0.517188, -0.460287, 0.000000, 1.000000, 0.000000, 1.000000, 0.500000},
{-1.276703, 0.517188, -0.458820, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000},
{-1.266378, 0.517188, -0.458820, 0.040132, 0.999176, 0.000000, 0.500000, 0.000000},
{-1.255595, 0.516320, -0.458820, 0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{-1.287028, 0.517188, -0.489637, -0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{-1.276703, 0.517188, -0.489637, 0.000000, 1.000000, 0.000000, 0.000000, 0.500000},
{-1.276703, 0.517188, -0.511596, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000},
{-1.287028, 0.517188, -0.511596, -0.040132, 0.999176, 0.000000, 0.500000, 1.000000},
{-1.297811, 0.516320, -0.511596, -0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{-1.297811, 0.516320, -0.489637, -0.149113, 0.988800, 0.000000, 1.000000, 0.500000},
{-1.297811, 0.516320, -0.468359, -0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{-1.287028, 0.517188, -0.468359, -0.040132, 0.999176, 0.000000, 0.500000, 0.000000},
{-1.276703, 0.517188, -0.468359, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000},
{-1.287028, 0.517188, -0.460287, -0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{-1.276703, 0.517188, -0.460287, 0.000000, 1.000000, 0.000000, 0.000000, 0.500000},
{-1.276703, 0.517188, -0.468359, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000},
{-1.287028, 0.517188, -0.468359, -0.040132, 0.999176, 0.000000, 0.500000, 1.000000},
{-1.297811, 0.516320, -0.468359, -0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{-1.297811, 0.516320, -0.460287, -0.149113, 0.988800, 0.000000, 1.000000, 0.500000},
{-1.297811, 0.516320, -0.458820, -0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{-1.287028, 0.517188, -0.458820, -0.040132, 0.999176, 0.000000, 0.500000, 0.000000},
{-1.276703, 0.517188, -0.458820, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000},
{-1.309510, 0.513716, -0.460287, -0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{-1.319495, 0.508072, -0.458820, -0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{-1.309510, 0.513716, -0.458820, -0.358531, 0.933500, 0.000000, 0.500000, 1.000000},
{-1.297811, 0.516320, -0.458820, -0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{-1.309510, 0.513716, -0.468359, -0.358531, 0.933500, 0.000000, 0.500000, 0.000000},
{-1.309510, 0.513716, -0.489637, -0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{-1.309510, 0.513716, -0.468359, -0.358531, 0.933500, 0.000000, 0.500000, 1.000000},
{-1.308993, -0.248276, -0.525891, -0.038942, 0.014740, -0.999115, 0.666667, 0.666667},
{-1.306404, -0.257796, -0.525891, -0.034944, 0.005951, -0.999359, 0.500000, 0.500000},
{-1.322407, -0.251229, -0.524845, -0.306345, 0.047578, -0.950713, 0.000000, 1.000000},
{-1.321102, -0.240075, -0.524845, -0.271065, 0.103183, -0.956999, 0.500000, 1.000000},
{-1.314992, -0.231858, -0.524845, -0.197760, 0.197760, -0.960082, 1.000000, 1.000000},
{-1.301484, -0.245366, -0.525891, -0.022248, 0.022248, -0.999481, 1.000000, 0.500000},
{-1.276703, -0.270147, -0.525891, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000},
{-1.311308, -0.263264, -0.525891, -0.045564, 0.001404, -0.998932, 0.666667, 0.666667},
{-1.276703, -0.270147, -0.525891, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000},
{-1.306982, -0.270147, -0.525891, -0.036836, 0.000000, -0.999298, 0.500000, 1.000000},
{-1.323203, -0.270147, -0.524845, -0.318735, 0.000000, -0.947813, 1.000000, 1.000000},
{-1.324284, -0.260683, -0.524845, -0.311838, 0.011902, -0.950041, 1.000000, 0.500000},
{-1.322407, -0.251229, -0.524845, -0.306345, 0.047578, -0.950713, 1.000000, 0.000000},
{-1.311308, -0.277031, -0.525891, -0.045564, -0.001404, -0.998932, 0.666667, 0.666667},
{-1.306982, -0.270147, -0.525891, -0.036836, 0.000000, -0.999298, 0.500000, 0.500000},
{-1.306403, -0.282498, -0.525891, -0.034944, -0.005951, -0.999359, 0.500000, 1.000000},
{-1.322407, -0.289066, -0.524845, -0.306345, -0.047578, -0.950713, 1.000000, 1.000000},
{-1.324284, -0.279612, -0.524845, -0.311838, -0.011902, -0.950041, 1.000000, 0.500000},
{-1.323203, -0.270147, -0.524845, -0.318735, 0.000000, -0.947813, 1.000000, 0.000000},
{-1.308993, -0.292018, -0.525891, -0.038942, -0.014740, -0.999115, 0.666667, 0.666667},
{-1.306403, -0.282498, -0.525891, -0.034944, -0.005951, -0.999359, 0.500000, 0.500000},
{-1.301484, -0.294928, -0.525891, -0.022248, -0.022248, -0.999481, 0.500000, 1.000000},
{-1.314992, -0.308436, -0.524845, -0.197760, -0.197760, -0.960082, 1.000000, 1.000000},
{-1.321102, -0.300220, -0.524845, -0.271065, -0.103183, -0.956999, 1.000000, 0.500000},
{-1.322407, -0.289066, -0.524845, -0.306345, -0.047578, -0.950713, 1.000000, 0.000000},
{-1.298574, -0.302437, -0.525891, -0.014740, -0.038942, -0.999115, 0.666667, 0.666667},
{-1.301484, -0.294928, -0.525891, -0.022248, -0.022248, -0.999481, 0.500000, 0.500000},
{-1.289054, -0.299848, -0.525891, -0.005951, -0.034944, -0.999359, 0.500000, 1.000000},
{-1.295622, -0.315852, -0.524845, -0.047578, -0.306345, -0.950713, 1.000000, 1.000000},
{-1.306776, -0.314546, -0.524845, -0.103183, -0.271065, -0.956999, 1.000000, 0.500000},
{-1.314992, -0.308436, -0.524845, -0.197760, -0.197760, -0.960082, 1.000000, 0.000000},
{-1.283586, -0.304752, -0.525891, -0.001404, -0.045564, -0.998932, 0.666667, 0.666667},
{-1.289054, -0.299848, -0.525891, -0.005951, -0.034944, -0.999359, 0.500000, 0.500000},
{-1.276703, -0.300427, -0.525891, 0.000000, -0.036836, -0.999298, 0.500000, 1.000000},
{-1.276703, -0.316647, -0.524845, 0.000000, -0.318705, -0.947844, 1.000000, 1.000000},
{-1.286168, -0.317729, -0.524845, -0.011902, -0.311838, -0.950041, 1.000000, 0.500000},
{-1.295622, -0.315852, -0.524845, -0.047578, -0.306345, -0.950713, 1.000000, 0.000000},
{-1.269820, -0.304752, -0.525891, 0.001404, -0.045564, -0.998932, 0.666667, 0.666667},
{-1.276703, -0.300427, -0.525891, 0.000000, -0.036836, -0.999298, 0.500000, 0.500000},
{-1.264352, -0.299848, -0.525891, 0.005951, -0.034944, -0.999359, 0.500000, 1.000000},
{-1.257784, -0.315852, -0.524845, 0.047578, -0.306345, -0.950713, 1.000000, 1.000000},
{-1.267238, -0.317729, -0.524845, 0.011902, -0.311838, -0.950041, 1.000000, 0.500000},
{-1.276703, -0.316647, -0.524845, 0.000000, -0.318705, -0.947844, 1.000000, 0.000000},
{-1.254832, -0.302437, -0.525891, 0.014740, -0.038942, -0.999115, 0.666667, 0.666667},
{-1.264352, -0.299848, -0.525891, 0.005951, -0.034944, -0.999359, 0.500000, 0.500000},
{-1.251922, -0.294928, -0.525891, 0.022248, -0.022248, -0.999481, 0.500000, 1.000000},
{-1.238414, -0.308437, -0.524845, 0.197760, -0.197760, -0.960082, 1.000000, 1.000000},
{-1.246630, -0.314546, -0.524845, 0.103183, -0.271065, -0.956999, 1.000000, 0.500000},
{-1.257784, -0.315852, -0.524845, 0.047578, -0.306345, -0.950713, 1.000000, 0.000000},
{-1.244413, -0.292018, -0.525891, 0.038942, -0.014740, -0.999115, 0.666667, 0.666667},
{-1.251922, -0.294928, -0.525891, 0.022248, -0.022248, -0.999481, 0.500000, 0.500000},
{-1.247002, -0.282498, -0.525891, 0.034944, -0.005951, -0.999359, 0.500000, 1.000000},
{-1.230999, -0.289066, -0.524845, 0.306345, -0.047578, -0.950713, 1.000000, 1.000000},
{-1.232304, -0.300220, -0.524845, 0.271065, -0.103183, -0.956999, 1.000000, 0.500000},
{-1.238414, -0.308437, -0.524845, 0.197760, -0.197760, -0.960082, 1.000000, 0.000000},
{-1.242098, -0.277031, -0.525891, 0.045564, -0.001404, -0.998932, 0.666667, 0.666667},
{-1.247002, -0.282498, -0.525891, 0.034944, -0.005951, -0.999359, 0.500000, 0.500000},
{-1.246424, -0.270147, -0.525891, 0.036836, 0.000000, -0.999298, 0.500000, 1.000000},
{-1.230203, -0.270147, -0.524845, 0.318705, 0.000000, -0.947844, 1.000000, 1.000000},
{-1.229121, -0.279612, -0.524845, 0.311838, -0.011902, -0.950041, 1.000000, 0.500000},
{-1.230999, -0.289066, -0.524845, 0.306345, -0.047578, -0.950713, 1.000000, 0.000000},
{-1.242098, -0.263264, -0.525891, 0.045564, 0.001404, -0.998932, 0.666667, 0.666667},
{-1.246424, -0.270147, -0.525891, 0.036836, 0.000000, -0.999298, 0.500000, 0.500000},
{-1.247002, -0.257796, -0.525891, 0.034944, 0.005951, -0.999359, 0.500000, 1.000000},
{-1.230999, -0.251229, -0.524845, 0.306345, 0.047578, -0.950713, 1.000000, 1.000000},
{-1.229121, -0.260683, -0.524845, 0.311838, 0.011902, -0.950041, 1.000000, 0.500000},
{-1.230203, -0.270147, -0.524845, 0.318705, 0.000000, -0.947844, 1.000000, 0.000000},
{-1.244413, -0.248276, -0.525891, 0.038942, 0.014740, -0.999115, 0.666667, 0.666667},
{-1.247002, -0.257796, -0.525891, 0.034944, 0.005951, -0.999359, 0.500000, 0.500000},
{-1.251922, -0.245366, -0.525891, 0.022248, 0.022248, -0.999481, 0.500000, 1.000000},
{-1.238414, -0.231858, -0.524845, 0.197760, 0.197760, -0.960082, 1.000000, 1.000000},
{-1.232304, -0.240075, -0.524845, 0.271065, 0.103183, -0.956999, 1.000000, 0.500000},
{-1.230999, -0.251229, -0.524845, 0.306345, 0.047578, -0.950713, 1.000000, 0.000000},
{-1.254832, -0.237857, -0.525891, 0.014740, 0.038942, -0.999115, 0.666667, 0.666667},
{-1.251922, -0.245366, -0.525891, 0.022248, 0.022248, -0.999481, 0.500000, 0.500000},
{-1.264352, -0.240447, -0.525891, 0.005951, 0.034944, -0.999359, 0.500000, 1.000000},
{-1.257784, -0.224443, -0.524845, 0.047578, 0.306345, -0.950713, 1.000000, 1.000000},
{-1.246630, -0.225748, -0.524845, 0.103183, 0.271065, -0.956999, 1.000000, 0.500000},
{-1.238414, -0.231858, -0.524845, 0.197760, 0.197760, -0.960082, 1.000000, 0.000000},
{-1.269820, -0.235543, -0.525891, 0.001404, 0.045564, -0.998932, 0.666667, 0.666667},
{-1.264352, -0.240447, -0.525891, 0.005951, 0.034944, -0.999359, 0.500000, 0.500000},
{-1.276703, -0.239868, -0.525891, 0.000000, 0.036836, -0.999298, 0.500000, 1.000000},
{-1.276703, -0.223647, -0.524845, 0.000000, 0.318735, -0.947813, 1.000000, 1.000000},
{-1.267238, -0.222566, -0.524845, 0.011902, 0.311838, -0.950041, 1.000000, 0.500000},
{-1.257784, -0.224443, -0.524845, 0.047578, 0.306345, -0.950713, 1.000000, 0.000000},
{-1.283586, -0.235543, -0.525891, -0.001404, 0.045564, -0.998932, 0.666667, 0.666667},
{-1.276703, -0.239868, -0.525891, 0.000000, 0.036836, -0.999298, 0.500000, 0.500000},
{-1.289054, -0.240447, -0.525891, -0.005951, 0.034944, -0.999359, 0.500000, 1.000000},
{-1.295622, -0.224443, -0.524845, -0.047578, 0.306345, -0.950713, 1.000000, 1.000000},
{-1.286168, -0.222566, -0.524845, -0.011902, 0.311838, -0.950041, 1.000000, 0.500000},
{-1.276703, -0.223647, -0.524845, 0.000000, 0.318735, -0.947813, 1.000000, 0.000000},
{-1.298574, -0.237857, -0.525891, -0.014740, 0.038942, -0.999115, 0.666667, 0.666667},
{-1.289054, -0.240447, -0.525891, -0.005951, 0.034944, -0.999359, 0.500000, 0.500000},
{-1.301484, -0.245366, -0.525891, -0.022248, 0.022248, -0.999481, 0.500000, 1.000000},
{-1.306776, -0.225749, -0.524845, -0.103183, 0.271065, -0.956999, 1.000000, 0.500000},
{-1.295622, -0.224443, -0.524845, -0.047578, 0.306345, -0.950713, 1.000000, 0.000000},
{-1.325138, -0.237341, -0.521706, -0.808832, 0.309793, -0.499771, 0.500000, 0.500000},
{-1.319495, -0.227355, -0.521706, -0.605670, 0.605670, -0.516007, 0.000000, 0.500000},
{-1.314992, -0.231858, -0.524845, -0.197760, 0.197760, -0.960082, 0.000000, 1.000000},
{-1.322407, -0.251229, -0.524845, -0.306345, 0.047578, -0.950713, 1.000000, 1.000000},
{-1.327742, -0.249040, -0.521706, -0.864620, 0.131108, -0.484939, 1.000000, 0.500000},
{-1.327742, -0.249040, -0.511596, -0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{-1.325138, -0.237341, -0.511596, -0.933500, 0.358531, 0.000000, 0.500000, 0.000000},
{-1.319495, -0.227355, -0.511596, -0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{-1.328610, -0.259822, -0.521706, -0.875942, 0.034852, -0.481124, 0.500000, 0.500000},
{-1.327742, -0.249040, -0.521706, -0.864620, 0.131108, -0.484939, 0.000000, 0.500000},
{-1.324284, -0.260683, -0.524845, -0.311838, 0.011902, -0.950041, 0.500000, 1.000000},
{-1.328610, -0.270147, -0.521706, -0.878658, 0.000000, -0.477401, 1.000000, 0.500000},
{-1.328610, -0.270147, -0.511596, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{-1.328610, -0.259822, -0.511596, -0.999176, 0.040132, 0.000000, 0.500000, 0.000000},
{-1.327742, -0.249040, -0.511596, -0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{-1.328610, -0.280472, -0.521706, -0.875942, -0.034852, -0.481124, 0.500000, 0.500000},
{-1.328610, -0.270147, -0.521706, -0.878658, 0.000000, -0.477401, 0.000000, 0.500000},
{-1.323203, -0.270147, -0.524845, -0.318735, 0.000000, -0.947813, 0.000000, 1.000000},
{-1.324284, -0.279612, -0.524845, -0.311838, -0.011902, -0.950041, 0.500000, 1.000000},
{-1.327742, -0.291255, -0.521706, -0.864620, -0.131108, -0.484939, 1.000000, 0.500000},
{-1.327742, -0.291255, -0.511596, -0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{-1.328610, -0.280472, -0.511596, -0.999176, -0.040132, 0.000000, 0.500000, 0.000000},
{-1.328610, -0.270147, -0.511596, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.325138, -0.302954, -0.521706, -0.808832, -0.309824, -0.499741, 0.500000, 0.500000},
{-1.327742, -0.291255, -0.521706, -0.864620, -0.131108, -0.484939, 0.000000, 0.500000},
{-1.322407, -0.289066, -0.524845, -0.306345, -0.047578, -0.950713, 0.000000, 1.000000},
{-1.321102, -0.300220, -0.524845, -0.271065, -0.103183, -0.956999, 0.500000, 1.000000},
{-1.319495, -0.312939, -0.521706, -0.605670, -0.605670, -0.516007, 1.000000, 0.500000},
{-1.319495, -0.312939, -0.511596, -0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{-1.325138, -0.302954, -0.511596, -0.933500, -0.358531, 0.000000, 0.500000, 0.000000},
{-1.327742, -0.291255, -0.511596, -0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{-1.309509, -0.318582, -0.521706, -0.309824, -0.808832, -0.499741, 0.500000, 0.500000},
{-1.319495, -0.312939, -0.521706, -0.605670, -0.605670, -0.516007, 0.000000, 0.500000},
{-1.314992, -0.308436, -0.524845, -0.197760, -0.197760, -0.960082, 0.000000, 1.000000},
{-1.306776, -0.314546, -0.524845, -0.103183, -0.271065, -0.956999, 0.500000, 1.000000},
{-1.297811, -0.321186, -0.521706, -0.131108, -0.864620, -0.484939, 1.000000, 0.500000},
{-1.297811, -0.321186, -0.511596, -0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{-1.309509, -0.318582, -0.511596, -0.358531, -0.933500, 0.000000, 0.500000, 0.000000},
{-1.319495, -0.312939, -0.511596, -0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{-1.287028, -0.322055, -0.521706, -0.034852, -0.875942, -0.481124, 0.500000, 0.500000},
{-1.297811, -0.321186, -0.521706, -0.131108, -0.864620, -0.484939, 0.000000, 0.500000},
{-1.295622, -0.315852, -0.524845, -0.047578, -0.306345, -0.950713, 0.000000, 1.000000},
{-1.286168, -0.317729, -0.524845, -0.011902, -0.311838, -0.950041, 0.500000, 1.000000},
{-1.276703, -0.322055, -0.521706, 0.000000, -0.878658, -0.477401, 1.000000, 0.500000},
{-1.276703, -0.322055, -0.511596, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000},
{-1.287028, -0.322055, -0.511596, -0.040132, -0.999176, 0.000000, 0.500000, 0.000000},
{-1.297811, -0.321186, -0.511596, -0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{-1.266378, -0.322055, -0.521706, 0.034852, -0.875942, -0.481124, 0.500000, 0.500000},
{-1.276703, -0.322055, -0.521706, 0.000000, -0.878658, -0.477401, 0.000000, 0.500000},
{-1.276703, -0.316647, -0.524845, 0.000000, -0.318705, -0.947844, 0.000000, 1.000000},
{-1.267238, -0.317729, -0.524845, 0.011902, -0.311838, -0.950041, 0.500000, 1.000000},
{-1.255595, -0.321186, -0.521706, 0.131108, -0.864620, -0.484939, 1.000000, 0.500000},
{-1.255595, -0.321186, -0.511596, 0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{-1.266378, -0.322055, -0.511596, 0.040132, -0.999176, 0.000000, 0.500000, 0.000000},
{-1.276703, -0.322055, -0.511596, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000},
{-1.243896, -0.318582, -0.521706, 0.309824, -0.808832, -0.499741, 0.500000, 0.500000},
{-1.255595, -0.321186, -0.521706, 0.131108, -0.864620, -0.484939, 0.000000, 0.500000},
{-1.257784, -0.315852, -0.524845, 0.047578, -0.306345, -0.950713, 0.000000, 1.000000},
{-1.246630, -0.314546, -0.524845, 0.103183, -0.271065, -0.956999, 0.500000, 1.000000},
{-1.233911, -0.312939, -0.521706, 0.605670, -0.605670, -0.516007, 1.000000, 0.500000},
{-1.233911, -0.312939, -0.511596, 0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{-1.243896, -0.318582, -0.511596, 0.358531, -0.933500, 0.000000, 0.500000, 0.000000},
{-1.255595, -0.321186, -0.511596, 0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{-1.228268, -0.302954, -0.521706, 0.808832, -0.309793, -0.499741, 0.500000, 0.500000},
{-1.233911, -0.312939, -0.521706, 0.605670, -0.605670, -0.516007, 0.000000, 0.500000},
{-1.238414, -0.308437, -0.524845, 0.197760, -0.197760, -0.960082, 0.000000, 1.000000},
{-1.232304, -0.300220, -0.524845, 0.271065, -0.103183, -0.956999, 0.500000, 1.000000},
{-1.225664, -0.291255, -0.521706, 0.864620, -0.131108, -0.484939, 1.000000, 0.500000},
{-1.225664, -0.291255, -0.511596, 0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{-1.228268, -0.302954, -0.511596, 0.933500, -0.358531, 0.000000, 0.500000, 0.000000},
{-1.233911, -0.312939, -0.511596, 0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{-1.224796, -0.280472, -0.521706, 0.875942, -0.034852, -0.481124, 0.500000, 0.500000},
{-1.225664, -0.291255, -0.521706, 0.864620, -0.131108, -0.484939, 0.000000, 0.500000},
{-1.230999, -0.289066, -0.524845, 0.306345, -0.047578, -0.950713, 0.000000, 1.000000},
{-1.229121, -0.279612, -0.524845, 0.311838, -0.011902, -0.950041, 0.500000, 1.000000},
{-1.224796, -0.270147, -0.521706, 0.878658, 0.000000, -0.477401, 1.000000, 0.500000},
{-1.224796, -0.270147, -0.511596, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{-1.224796, -0.280472, -0.511596, 0.999176, -0.040132, 0.000000, 0.500000, 0.000000},
{-1.225664, -0.291255, -0.511596, 0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{-1.224796, -0.259822, -0.521706, 0.875942, 0.034852, -0.481124, 0.500000, 0.500000},
{-1.224796, -0.270147, -0.521706, 0.878658, 0.000000, -0.477401, 0.000000, 0.500000},
{-1.230203, -0.270147, -0.524845, 0.318705, 0.000000, -0.947844, 0.000000, 1.000000},
{-1.229121, -0.260683, -0.524845, 0.311838, 0.011902, -0.950041, 0.500000, 1.000000},
{-1.225664, -0.249039, -0.521706, 0.864620, 0.131108, -0.484939, 1.000000, 0.500000},
{-1.225664, -0.249039, -0.511596, 0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{-1.224796, -0.259822, -0.511596, 0.999176, 0.040132, 0.000000, 0.500000, 0.000000},
{-1.224796, -0.270147, -0.511596, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.228268, -0.237341, -0.521706, 0.808832, 0.309793, -0.499741, 0.500000, 0.500000},
{-1.225664, -0.249039, -0.521706, 0.864620, 0.131108, -0.484939, 0.000000, 0.500000},
{-1.230999, -0.251229, -0.524845, 0.306345, 0.047578, -0.950713, 0.000000, 1.000000},
{-1.232304, -0.240075, -0.524845, 0.271065, 0.103183, -0.956999, 0.500000, 1.000000},
{-1.233911, -0.227355, -0.521706, 0.605670, 0.605670, -0.516007, 1.000000, 0.500000},
{-1.233911, -0.227355, -0.511596, 0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{-1.228268, -0.237341, -0.511596, 0.933500, 0.358531, 0.000000, 0.500000, 0.000000},
{-1.225664, -0.249039, -0.511596, 0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{-1.243896, -0.221712, -0.521706, 0.309793, 0.808832, -0.499771, 0.500000, 0.500000},
{-1.233911, -0.227355, -0.521706, 0.605670, 0.605670, -0.516007, 0.000000, 0.500000},
{-1.238414, -0.231858, -0.524845, 0.197760, 0.197760, -0.960082, 0.000000, 1.000000},
{-1.246630, -0.225748, -0.524845, 0.103183, 0.271065, -0.956999, 0.500000, 1.000000},
{-1.255595, -0.219108, -0.521706, 0.131108, 0.864620, -0.484939, 1.000000, 0.500000},
{-1.255595, -0.219108, -0.511596, 0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{-1.243896, -0.221712, -0.511596, 0.358531, 0.933500, 0.000000, 0.500000, 0.000000},
{-1.233911, -0.227355, -0.511596, 0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{-1.266378, -0.218240, -0.521706, 0.034852, 0.875942, -0.481124, 0.500000, 0.500000},
{-1.255595, -0.219108, -0.521706, 0.131108, 0.864620, -0.484939, 0.000000, 0.500000},
{-1.257784, -0.224443, -0.524845, 0.047578, 0.306345, -0.950713, 0.000000, 1.000000},
{-1.267238, -0.222566, -0.524845, 0.011902, 0.311838, -0.950041, 0.500000, 1.000000},
{-1.276703, -0.218240, -0.521706, 0.000000, 0.878658, -0.477401, 1.000000, 0.500000},
{-1.276703, -0.218240, -0.511596, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000},
{-1.266378, -0.218240, -0.511596, 0.040132, 0.999176, 0.000000, 0.500000, 0.000000},
{-1.255595, -0.219108, -0.511596, 0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{-1.287028, -0.218240, -0.521706, -0.034852, 0.875942, -0.481124, 0.500000, 0.500000},
{-1.276703, -0.218240, -0.521706, 0.000000, 0.878658, -0.477401, 0.000000, 0.500000},
{-1.276703, -0.223647, -0.524845, 0.000000, 0.318735, -0.947813, 0.000000, 1.000000},
{-1.286168, -0.222566, -0.524845, -0.011902, 0.311838, -0.950041, 0.500000, 1.000000},
{-1.297811, -0.219108, -0.521706, -0.131108, 0.864620, -0.484939, 1.000000, 0.500000},
{-1.297811, -0.219108, -0.511596, -0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{-1.287028, -0.218240, -0.511596, -0.040132, 0.999176, 0.000000, 0.500000, 0.000000},
{-1.276703, -0.218240, -0.511596, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000},
{-1.309509, -0.221712, -0.521706, -0.309824, 0.808832, -0.499771, 0.500000, 0.500000},
{-1.297811, -0.219108, -0.521706, -0.131108, 0.864620, -0.484939, 0.000000, 0.500000},
{-1.295622, -0.224443, -0.524845, -0.047578, 0.306345, -0.950713, 0.000000, 1.000000},
{-1.306776, -0.225749, -0.524845, -0.103183, 0.271065, -0.956999, 0.500000, 1.000000},
{-1.319495, -0.227355, -0.521706, -0.605670, 0.605670, -0.516007, 1.000000, 0.500000},
{-1.319495, -0.227355, -0.511596, -0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{-1.309510, -0.221712, -0.511596, -0.358531, 0.933500, 0.000000, 0.500000, 0.000000},
{-1.297811, -0.219108, -0.511596, -0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{-1.325138, -0.237341, -0.489637, -0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{-1.319495, -0.227355, -0.489637, -0.707083, 0.707083, 0.000000, 0.000000, 0.500000},
{-1.319495, -0.227355, -0.511596, -0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{-1.325138, -0.237341, -0.511596, -0.933500, 0.358531, 0.000000, 0.500000, 1.000000},
{-1.327742, -0.249040, -0.511596, -0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{-1.327742, -0.249040, -0.489637, -0.988800, 0.149113, 0.000000, 1.000000, 0.500000},
{-1.327742, -0.249040, -0.468359, -0.988800, 0.149083, 0.000000, 1.000000, 0.000000},
{-1.325138, -0.237341, -0.468359, -0.933500, 0.358531, 0.000000, 0.500000, 0.000000},
{-1.319495, -0.227355, -0.468359, -0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{-1.325138, -0.237341, -0.460287, -0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{-1.319495, -0.227356, -0.460287, -0.707083, 0.707083, 0.000000, 0.000000, 0.500000},
{-1.319495, -0.227355, -0.468359, -0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{-1.325138, -0.237341, -0.468359, -0.933500, 0.358531, 0.000000, 0.500000, 1.000000},
{-1.327742, -0.249040, -0.468359, -0.988800, 0.149083, 0.000000, 1.000000, 1.000000},
{-1.327742, -0.249040, -0.460287, -0.988800, 0.149083, 0.000000, 1.000000, 0.500000},
{-1.327742, -0.249040, -0.458820, -0.988800, 0.149083, 0.000000, 1.000000, 0.000000},
{-1.325138, -0.237341, -0.458820, -0.933500, 0.358531, 0.000000, 0.500000, 0.000000},
{-1.319495, -0.227355, -0.458820, -0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{-1.328610, -0.259822, -0.489637, -0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{-1.327742, -0.249040, -0.489637, -0.988800, 0.149113, 0.000000, 0.000000, 0.500000},
{-1.327742, -0.249040, -0.511596, -0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{-1.328610, -0.259822, -0.511596, -0.999176, 0.040132, 0.000000, 0.500000, 1.000000},
{-1.328610, -0.270147, -0.511596, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{-1.328610, -0.270147, -0.489637, -1.000000, 0.000000, 0.000000, 1.000000, 0.500000},
{-1.328610, -0.270147, -0.468359, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{-1.328610, -0.259822, -0.468359, -0.999176, 0.040132, 0.000000, 0.500000, 0.000000},
{-1.327742, -0.249040, -0.468359, -0.988800, 0.149083, 0.000000, 0.000000, 0.000000},
{-1.328610, -0.259822, -0.460287, -0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{-1.327742, -0.249040, -0.460287, -0.988800, 0.149083, 0.000000, 0.000000, 0.500000},
{-1.327742, -0.249040, -0.468359, -0.988800, 0.149083, 0.000000, 0.000000, 1.000000},
{-1.328610, -0.259822, -0.468359, -0.999176, 0.040132, 0.000000, 0.500000, 1.000000},
{-1.328610, -0.270147, -0.468359, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{-1.328610, -0.270147, -0.460287, -1.000000, 0.000000, 0.000000, 1.000000, 0.500000},
{-1.328610, -0.270147, -0.458820, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{-1.328610, -0.259822, -0.458820, -0.999176, 0.040132, 0.000000, 0.500000, 0.000000},
{-1.327742, -0.249040, -0.458820, -0.988800, 0.149083, 0.000000, 0.000000, 0.000000},
{-1.328610, -0.280472, -0.489637, -0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{-1.328610, -0.270147, -0.489637, -1.000000, 0.000000, 0.000000, 0.000000, 0.500000},
{-1.328610, -0.270147, -0.511596, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{-1.328610, -0.280472, -0.511596, -0.999176, -0.040132, 0.000000, 0.500000, 1.000000},
{-1.327742, -0.291255, -0.511596, -0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{-1.327742, -0.291255, -0.489637, -0.988800, -0.149113, 0.000000, 1.000000, 0.500000},
{-1.327742, -0.291255, -0.468359, -0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{-1.328610, -0.280472, -0.468359, -0.999176, -0.040132, 0.000000, 0.500000, 0.000000},
{-1.328610, -0.270147, -0.468359, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.328610, -0.280472, -0.460287, -0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{-1.328610, -0.270147, -0.460287, -1.000000, 0.000000, 0.000000, 0.000000, 0.500000},
{-1.328610, -0.270147, -0.468359, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{-1.328610, -0.280472, -0.468359, -0.999176, -0.040132, 0.000000, 0.500000, 1.000000},
{-1.327742, -0.291255, -0.468359, -0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{-1.327742, -0.291255, -0.460287, -0.988800, -0.149113, 0.000000, 1.000000, 0.500000},
{-1.327742, -0.291255, -0.458820, -0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{-1.328610, -0.280472, -0.458820, -0.999176, -0.040132, 0.000000, 0.500000, 0.000000},
{-1.328610, -0.270147, -0.458820, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.325138, -0.302954, -0.489637, -0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{-1.327742, -0.291255, -0.489637, -0.988800, -0.149113, 0.000000, 0.000000, 0.500000},
{-1.327742, -0.291255, -0.511596, -0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{-1.325138, -0.302954, -0.511596, -0.933500, -0.358531, 0.000000, 0.500000, 1.000000},
{-1.319495, -0.312939, -0.511596, -0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{-1.319495, -0.312939, -0.489637, -0.707083, -0.707083, 0.000000, 1.000000, 0.500000},
{-1.319495, -0.312939, -0.468359, -0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{-1.325138, -0.302954, -0.468359, -0.933500, -0.358531, 0.000000, 0.500000, 0.000000},
{-1.327742, -0.291255, -0.468359, -0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{-1.325138, -0.302954, -0.460287, -0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{-1.327742, -0.291255, -0.460287, -0.988800, -0.149113, 0.000000, 0.000000, 0.500000},
{-1.327742, -0.291255, -0.468359, -0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{-1.325138, -0.302954, -0.468359, -0.933500, -0.358531, 0.000000, 0.500000, 1.000000},
{-1.319495, -0.312939, -0.468359, -0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{-1.319495, -0.312939, -0.460287, -0.707083, -0.707083, 0.000000, 1.000000, 0.500000},
{-1.319495, -0.312939, -0.458820, -0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{-1.325138, -0.302954, -0.458820, -0.933500, -0.358531, 0.000000, 0.500000, 0.000000},
{-1.327742, -0.291255, -0.458820, -0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{-1.309509, -0.318582, -0.489637, -0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{-1.319495, -0.312939, -0.489637, -0.707083, -0.707083, 0.000000, 0.000000, 0.500000},
{-1.319495, -0.312939, -0.511596, -0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{-1.309509, -0.318582, -0.511596, -0.358531, -0.933500, 0.000000, 0.500000, 1.000000},
{-1.297811, -0.321186, -0.511596, -0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{-1.297811, -0.321186, -0.489637, -0.149113, -0.988800, 0.000000, 1.000000, 0.500000},
{-1.297811, -0.321186, -0.468359, -0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{-1.309509, -0.318582, -0.468359, -0.358531, -0.933500, 0.000000, 0.500000, 0.000000},
{-1.319495, -0.312939, -0.468359, -0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{-1.309509, -0.318582, -0.460287, -0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{-1.319495, -0.312939, -0.460287, -0.707083, -0.707083, 0.000000, 0.000000, 0.500000},
{-1.319495, -0.312939, -0.468359, -0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{-1.309509, -0.318582, -0.468359, -0.358531, -0.933500, 0.000000, 0.500000, 1.000000},
{-1.297811, -0.321186, -0.468359, -0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{-1.297811, -0.321186, -0.460287, -0.149113, -0.988800, 0.000000, 1.000000, 0.500000},
{-1.297811, -0.321186, -0.458820, -0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{-1.309509, -0.318582, -0.458820, -0.358531, -0.933500, 0.000000, 0.500000, 0.000000},
{-1.319495, -0.312939, -0.458820, -0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{-1.287028, -0.322055, -0.489637, -0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{-1.297811, -0.321186, -0.489637, -0.149113, -0.988800, 0.000000, 0.000000, 0.500000},
{-1.297811, -0.321186, -0.511596, -0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{-1.287028, -0.322055, -0.511596, -0.040132, -0.999176, 0.000000, 0.500000, 1.000000},
{-1.276703, -0.322055, -0.511596, 0.000000, -1.000000, 0.000000, 1.000000, 1.000000},
{-1.276703, -0.322055, -0.489637, 0.000000, -1.000000, 0.000000, 1.000000, 0.500000},
{-1.276703, -0.322055, -0.468359, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000},
{-1.287028, -0.322055, -0.468359, -0.040132, -0.999176, 0.000000, 0.500000, 0.000000},
{-1.297811, -0.321186, -0.468359, -0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{-1.287028, -0.322055, -0.460287, -0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{-1.297811, -0.321186, -0.460287, -0.149113, -0.988800, 0.000000, 0.000000, 0.500000},
{-1.297811, -0.321186, -0.468359, -0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{-1.287028, -0.322055, -0.468359, -0.040132, -0.999176, 0.000000, 0.500000, 1.000000},
{-1.276703, -0.322055, -0.468359, 0.000000, -1.000000, 0.000000, 1.000000, 1.000000},
{-1.276703, -0.322055, -0.460287, 0.000000, -1.000000, 0.000000, 1.000000, 0.500000},
{-1.276703, -0.322055, -0.458820, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000},
{-1.287028, -0.322055, -0.458820, -0.040132, -0.999176, 0.000000, 0.500000, 0.000000},
{-1.297811, -0.321186, -0.458820, -0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{-1.266378, -0.322055, -0.489637, 0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{-1.276703, -0.322055, -0.489637, 0.000000, -1.000000, 0.000000, 0.000000, 0.500000},
{-1.276703, -0.322055, -0.511596, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000},
{-1.266378, -0.322055, -0.511596, 0.040132, -0.999176, 0.000000, 0.500000, 1.000000},
{-1.255595, -0.321186, -0.511596, 0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{-1.255595, -0.321186, -0.489637, 0.149113, -0.988800, 0.000000, 1.000000, 0.500000},
{-1.255595, -0.321186, -0.468359, 0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{-1.266378, -0.322055, -0.468359, 0.040132, -0.999176, 0.000000, 0.500000, 0.000000},
{-1.276703, -0.322055, -0.468359, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000},
{-1.266378, -0.322055, -0.460287, 0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{-1.276703, -0.322055, -0.460287, 0.000000, -1.000000, 0.000000, 0.000000, 0.500000},
{-1.276703, -0.322055, -0.468359, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000},
{-1.266378, -0.322055, -0.468359, 0.040132, -0.999176, 0.000000, 0.500000, 1.000000},
{-1.255595, -0.321186, -0.468359, 0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{-1.255595, -0.321186, -0.460287, 0.149113, -0.988800, 0.000000, 1.000000, 0.500000},
{-1.255595, -0.321186, -0.458820, 0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{-1.266378, -0.322055, -0.458820, 0.040132, -0.999176, 0.000000, 0.500000, 0.000000},
{-1.276703, -0.322055, -0.458820, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000},
{-1.243896, -0.318582, -0.489637, 0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{-1.255595, -0.321186, -0.489637, 0.149113, -0.988800, 0.000000, 0.000000, 0.500000},
{-1.255595, -0.321186, -0.511596, 0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{-1.243896, -0.318582, -0.511596, 0.358531, -0.933500, 0.000000, 0.500000, 1.000000},
{-1.233911, -0.312939, -0.511596, 0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{-1.233911, -0.312939, -0.489637, 0.707083, -0.707083, 0.000000, 1.000000, 0.500000},
{-1.233911, -0.312939, -0.468359, 0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{-1.243896, -0.318582, -0.468359, 0.358531, -0.933500, 0.000000, 0.500000, 0.000000},
{-1.255595, -0.321186, -0.468359, 0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{-1.243896, -0.318582, -0.460287, 0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{-1.255595, -0.321186, -0.460287, 0.149113, -0.988800, 0.000000, 0.000000, 0.500000},
{-1.255595, -0.321186, -0.468359, 0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{-1.243896, -0.318582, -0.468359, 0.358531, -0.933500, 0.000000, 0.500000, 1.000000},
{-1.233911, -0.312939, -0.468359, 0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{-1.233911, -0.312939, -0.460287, 0.707083, -0.707083, 0.000000, 1.000000, 0.500000},
{-1.233911, -0.312939, -0.458820, 0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{-1.243896, -0.318582, -0.458820, 0.358531, -0.933500, 0.000000, 0.500000, 0.000000},
{-1.255595, -0.321186, -0.458820, 0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{-1.228268, -0.302954, -0.489637, 0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{-1.233911, -0.312939, -0.489637, 0.707083, -0.707083, 0.000000, 0.000000, 0.500000},
{-1.233911, -0.312939, -0.511596, 0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{-1.228268, -0.302954, -0.511596, 0.933500, -0.358531, 0.000000, 0.500000, 1.000000},
{-1.225664, -0.291255, -0.511596, 0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{-1.225664, -0.291255, -0.489637, 0.988800, -0.149113, 0.000000, 1.000000, 0.500000},
{-1.225664, -0.291255, -0.468359, 0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{-1.228268, -0.302954, -0.468359, 0.933500, -0.358531, 0.000000, 0.500000, 0.000000},
{-1.233911, -0.312939, -0.468359, 0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{-1.228268, -0.302954, -0.460287, 0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{-1.233911, -0.312939, -0.460287, 0.707083, -0.707083, 0.000000, 0.000000, 0.500000},
{-1.233911, -0.312939, -0.468359, 0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{-1.228268, -0.302954, -0.468359, 0.933500, -0.358531, 0.000000, 0.500000, 1.000000},
{-1.225664, -0.291255, -0.468359, 0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{-1.225664, -0.291255, -0.460287, 0.988800, -0.149113, 0.000000, 1.000000, 0.500000},
{-1.225664, -0.291255, -0.458820, 0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{-1.228268, -0.302954, -0.458820, 0.933500, -0.358531, 0.000000, 0.500000, 0.000000},
{-1.233911, -0.312939, -0.458820, 0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{-1.224796, -0.280472, -0.489637, 0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{-1.225664, -0.291255, -0.489637, 0.988800, -0.149113, 0.000000, 0.000000, 0.500000},
{-1.225664, -0.291255, -0.511596, 0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{-1.224796, -0.280472, -0.511596, 0.999176, -0.040132, 0.000000, 0.500000, 1.000000},
{-1.224796, -0.270147, -0.511596, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{-1.224796, -0.270147, -0.489637, 1.000000, 0.000000, 0.000000, 1.000000, 0.500000},
{-1.224796, -0.270147, -0.468359, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{-1.224796, -0.280472, -0.468359, 0.999176, -0.040132, 0.000000, 0.500000, 0.000000},
{-1.225664, -0.291255, -0.468359, 0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{-1.224796, -0.280472, -0.460287, 0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{-1.225664, -0.291255, -0.460287, 0.988800, -0.149113, 0.000000, 0.000000, 0.500000},
{-1.225664, -0.291255, -0.468359, 0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{-1.224796, -0.280472, -0.468359, 0.999176, -0.040132, 0.000000, 0.500000, 1.000000},
{-1.224796, -0.270147, -0.468359, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{-1.224796, -0.270147, -0.460287, 1.000000, 0.000000, 0.000000, 1.000000, 0.500000},
{-1.224796, -0.270147, -0.458820, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{-1.224796, -0.280472, -0.458820, 0.999176, -0.040132, 0.000000, 0.500000, 0.000000},
{-1.225664, -0.291255, -0.458820, 0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{-1.224796, -0.259822, -0.489637, 0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{-1.224796, -0.270147, -0.489637, 1.000000, 0.000000, 0.000000, 0.000000, 0.500000},
{-1.224796, -0.270147, -0.511596, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{-1.224796, -0.259822, -0.511596, 0.999176, 0.040132, 0.000000, 0.500000, 1.000000},
{-1.225664, -0.249039, -0.511596, 0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{-1.225664, -0.249039, -0.489637, 0.988800, 0.149113, 0.000000, 1.000000, 0.500000},
{-1.225664, -0.249039, -0.468359, 0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{-1.224796, -0.259822, -0.468359, 0.999176, 0.040132, 0.000000, 0.500000, 0.000000},
{-1.224796, -0.270147, -0.468359, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.224796, -0.259822, -0.460287, 0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{-1.224796, -0.270147, -0.460287, 1.000000, 0.000000, 0.000000, 0.000000, 0.500000},
{-1.224796, -0.270147, -0.468359, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{-1.224796, -0.259822, -0.468359, 0.999176, 0.040132, 0.000000, 0.500000, 1.000000},
{-1.225664, -0.249039, -0.468359, 0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{-1.225664, -0.249039, -0.460287, 0.988800, 0.149113, 0.000000, 1.000000, 0.500000},
{-1.225664, -0.249039, -0.458820, 0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{-1.224796, -0.259822, -0.458820, 0.999176, 0.040132, 0.000000, 0.500000, 0.000000},
{-1.224796, -0.270147, -0.458820, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.228268, -0.237341, -0.489637, 0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{-1.225664, -0.249039, -0.489637, 0.988800, 0.149113, 0.000000, 0.000000, 0.500000},
{-1.225664, -0.249039, -0.511596, 0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{-1.228268, -0.237341, -0.511596, 0.933500, 0.358531, 0.000000, 0.500000, 1.000000},
{-1.233911, -0.227355, -0.511596, 0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{-1.233911, -0.227355, -0.489637, 0.707083, 0.707083, 0.000000, 1.000000, 0.500000},
{-1.233911, -0.227355, -0.468359, 0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{-1.228268, -0.237341, -0.468359, 0.933500, 0.358531, 0.000000, 0.500000, 0.000000},
{-1.225664, -0.249039, -0.468359, 0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{-1.228268, -0.237341, -0.460287, 0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{-1.225664, -0.249039, -0.460287, 0.988800, 0.149113, 0.000000, 0.000000, 0.500000},
{-1.225664, -0.249039, -0.468359, 0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{-1.228268, -0.237341, -0.468359, 0.933500, 0.358531, 0.000000, 0.500000, 1.000000},
{-1.233911, -0.227355, -0.468359, 0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{-1.233911, -0.227355, -0.460287, 0.707083, 0.707083, 0.000000, 1.000000, 0.500000},
{-1.233911, -0.227355, -0.458820, 0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{-1.228268, -0.237341, -0.458820, 0.933500, 0.358531, 0.000000, 0.500000, 0.000000},
{-1.225664, -0.249039, -0.458820, 0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{-1.243897, -0.221712, -0.489637, 0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{-1.233911, -0.227355, -0.489637, 0.707083, 0.707083, 0.000000, 0.000000, 0.500000},
{-1.233911, -0.227355, -0.511596, 0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{-1.243896, -0.221712, -0.511596, 0.358531, 0.933500, 0.000000, 0.500000, 1.000000},
{-1.255595, -0.219108, -0.511596, 0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{-1.255595, -0.219108, -0.489637, 0.149113, 0.988800, 0.000000, 1.000000, 0.500000},
{-1.255595, -0.219108, -0.468359, 0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{-1.243897, -0.221712, -0.468359, 0.358531, 0.933500, 0.000000, 0.500000, 0.000000},
{-1.233911, -0.227355, -0.468359, 0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{-1.243897, -0.221712, -0.460287, 0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{-1.233911, -0.227355, -0.460287, 0.707083, 0.707083, 0.000000, 0.000000, 0.500000},
{-1.233911, -0.227355, -0.468359, 0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{-1.243897, -0.221712, -0.468359, 0.358531, 0.933500, 0.000000, 0.500000, 1.000000},
{-1.255595, -0.219108, -0.468359, 0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{-1.255595, -0.219108, -0.460287, 0.149113, 0.988800, 0.000000, 1.000000, 0.500000},
{-1.255595, -0.219108, -0.458820, 0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{-1.243897, -0.221712, -0.458820, 0.358531, 0.933500, 0.000000, 0.500000, 0.000000},
{-1.233911, -0.227355, -0.458820, 0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{-1.266378, -0.218240, -0.489637, 0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{-1.255595, -0.219108, -0.489637, 0.149113, 0.988800, 0.000000, 0.000000, 0.500000},
{-1.255595, -0.219108, -0.511596, 0.149113, 0.988800, 0.000000, 0.000000, 1.000000},
{-1.266378, -0.218240, -0.511596, 0.040132, 0.999176, 0.000000, 0.500000, 1.000000},
{-1.276703, -0.218240, -0.511596, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000},
{-1.276703, -0.218240, -0.489637, 0.000000, 1.000000, 0.000000, 1.000000, 0.500000},
{-1.276703, -0.218240, -0.468359, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000},
{-1.266378, -0.218240, -0.468359, 0.040132, 0.999176, 0.000000, 0.500000, 0.000000},
{-1.255595, -0.219108, -0.468359, 0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{-1.266378, -0.218240, -0.460287, 0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{-1.255595, -0.219108, -0.460287, 0.149113, 0.988800, 0.000000, 0.000000, 0.500000},
{-1.255595, -0.219108, -0.468359, 0.149113, 0.988800, 0.000000, 0.000000, 1.000000},
{-1.266378, -0.218240, -0.468359, 0.040132, 0.999176, 0.000000, 0.500000, 1.000000},
{-1.276703, -0.218240, -0.468359, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000},
{-1.276703, -0.218240, -0.460287, 0.000000, 1.000000, 0.000000, 1.000000, 0.500000},
{-1.276703, -0.218240, -0.458820, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000},
{-1.266378, -0.218240, -0.458820, 0.040132, 0.999176, 0.000000, 0.500000, 0.000000},
{-1.255595, -0.219108, -0.458820, 0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{-1.287028, -0.218240, -0.489637, -0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{-1.276703, -0.218240, -0.489637, 0.000000, 1.000000, 0.000000, 0.000000, 0.500000},
{-1.276703, -0.218240, -0.511596, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000},
{-1.287028, -0.218240, -0.511596, -0.040132, 0.999176, 0.000000, 0.500000, 1.000000},
{-1.297811, -0.219108, -0.511596, -0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{-1.297811, -0.219108, -0.489637, -0.149113, 0.988800, 0.000000, 1.000000, 0.500000},
{-1.297811, -0.219108, -0.468359, -0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{-1.287028, -0.218240, -0.468359, -0.040132, 0.999176, 0.000000, 0.500000, 0.000000},
{-1.276703, -0.218240, -0.468359, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000},
{-1.287028, -0.218240, -0.460287, -0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{-1.276703, -0.218240, -0.460287, 0.000000, 1.000000, 0.000000, 0.000000, 0.500000},
{-1.276703, -0.218240, -0.468359, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000},
{-1.287028, -0.218240, -0.468359, -0.040132, 0.999176, 0.000000, 0.500000, 1.000000},
{-1.297811, -0.219108, -0.468359, -0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{-1.297811, -0.219108, -0.460287, -0.149113, 0.988800, 0.000000, 1.000000, 0.500000},
{-1.297811, -0.219108, -0.458820, -0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{-1.287028, -0.218240, -0.458820, -0.040132, 0.999176, 0.000000, 0.500000, 0.000000},
{-1.276703, -0.218240, -0.458820, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000},
{-1.309510, -0.221712, -0.460287, -0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{-1.319495, -0.227355, -0.458820, -0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{-1.309510, -0.221712, -0.458820, -0.358531, 0.933500, 0.000000, 0.500000, 1.000000},
{-1.297811, -0.219108, -0.458820, -0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{-1.309510, -0.221712, -0.468359, -0.358531, 0.933500, 0.000000, 0.500000, 0.000000},
{-1.309510, -0.221712, -0.489637, -0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{-1.309510, -0.221712, -0.468359, -0.358531, 0.933500, 0.000000, 0.500000, 1.000000},
{-0.204419, 0.058329, -0.096188, -0.618549, 0.775018, 0.129154, 0.500000, 0.500000},
{-0.213817, 0.049708, -0.107289, -0.658071, 0.307077, -0.687460, 0.000000, 0.500000},
{-0.212477, 0.038005, -0.101284, -0.980956, -0.137944, 0.136570, 0.000000, 1.000000},
{-0.207398, 0.043769, -0.091846, -0.761254, 0.035676, 0.647420, 0.500000, 1.000000},
{-0.181707, 0.049457, -0.071257, -0.738060, 0.104892, 0.666494, 1.000000, 1.000000},
{-0.180255, 0.063485, -0.076629, -0.605396, 0.747063, 0.274483, 1.000000, 0.500000},
{-0.167394, 0.066930, -0.083999, -0.201972, 0.917753, -0.341899, 1.000000, 0.000000},
{-0.187830, 0.059093, -0.102022, -0.091464, 0.793420, -0.601733, 0.500000, 0.000000},
{-0.194542, 0.049254, -0.108670, -0.104312, 0.463057, -0.880154, 0.000000, 0.000000},
{0.023599, -0.178176, -0.126642, 0.764489, -0.640797, 0.069857, 0.500000, 0.500000},
{0.014710, -0.190370, -0.142052, 0.294809, -0.801843, -0.519700, 0.000000, 0.500000},
{0.017921, -0.174350, -0.143188, 0.541978, -0.173132, -0.822321, 0.000000, 1.000000},
{0.027723, -0.163711, -0.134980, 0.846156, -0.174993, -0.503342, 0.500000, 1.000000},
{0.040817, -0.140428, -0.110348, 0.876339, -0.283670, -0.389233, 1.000000, 1.000000},
{0.035200, -0.154643, -0.100659, 0.748222, -0.662679, 0.031312, 1.000000, 0.500000},
{0.020704, -0.161288, -0.090569, 0.327586, -0.868465, 0.372051, 1.000000, 0.000000},
{0.009833, -0.182615, -0.116718, 0.187170, -0.884121, 0.428083, 0.500000, 0.000000},
{0.005656, -0.187711, -0.130516, -0.146458, -0.982482, 0.114933, 0.000000, 0.000000},
{-0.195140, 0.023219, -0.112044, -0.386700, -0.140782, -0.911374, 0.500000, 0.500000},
{-0.162282, -0.012485, -0.115706, -0.374676, -0.193915, -0.906613, 0.000000, 0.500000},
{-0.175382, -0.020729, -0.103884, -0.754540, -0.542833, -0.368725, 0.000000, 1.000000},
{-0.205140, 0.016014, -0.102787, -0.861110, -0.470717, -0.192083, 0.500000, 1.000000},
{-0.212477, 0.038005, -0.101284, -0.980956, -0.137944, 0.136570, 1.000000, 1.000000},
{-0.213817, 0.049708, -0.107289, -0.658071, 0.307077, -0.687460, 1.000000, 0.500000},
{-0.194542, 0.049254, -0.108670, -0.104312, 0.463057, -0.880154, 1.000000, 0.000000},
{-0.176169, 0.034183, -0.114866, -0.100497, 0.191992, -0.976226, 0.500000, 0.000000},
{-0.142608, 0.002155, -0.120982, -0.150334, 0.071963, -0.985992, 0.000000, 0.000000},
{-0.026015, 0.163187, 0.117209, 0.421583, 0.310862, 0.851802, 0.500000, 0.500000},
{-0.045977, 0.181446, 0.118635, -0.143468, 0.695181, 0.704337, 0.000000, 0.500000},
{-0.049029, 0.164035, 0.118021, -0.420209, -0.030061, 0.906919, 0.000000, 1.000000},
{-0.037418, 0.147228, 0.118521, -0.125309, -0.189520, 0.973815, 0.500000, 1.000000},
{-0.012758, 0.113651, 0.110837, -0.065188, -0.178808, 0.981719, 1.000000, 1.000000},
{0.000820, 0.131745, 0.109908, 0.428205, 0.248360, 0.868862, 1.000000, 0.500000},
{0.007114, 0.140520, 0.096165, 0.690909, 0.645466, 0.325510, 1.000000, 0.000000},
{-0.020180, 0.169554, 0.103800, 0.626637, 0.754570, 0.194708, 0.500000, 0.000000},
{-0.037044, 0.178929, 0.106912, 0.275399, 0.961272, 0.006867, 0.000000, 0.000000},
{-0.160830, 0.047101, -0.110444, -0.009278, 0.512467, -0.858638, 0.500000, 0.500000},
{-0.128307, 0.023826, -0.119575, -0.000671, 0.309549, -0.950865, 0.000000, 0.500000},
{-0.142608, 0.002155, -0.120982, -0.150334, 0.071963, -0.985992, 0.000000, 1.000000},
{-0.176169, 0.034183, -0.114866, -0.100497, 0.191992, -0.976226, 0.500000, 1.000000},
{-0.194542, 0.049254, -0.108670, -0.104312, 0.463057, -0.880154, 1.000000, 1.000000},
{-0.187830, 0.059093, -0.102022, -0.091464, 0.793420, -0.601733, 1.000000, 0.500000},
{-0.143362, 0.063678, -0.095720, -0.028474, 0.752007, -0.658498, 0.500000, 0.000000},
{-0.112110, 0.049055, -0.107490, 0.122776, 0.547838, -0.827509, 0.000000, 0.000000},
{-0.193566, 0.014373, -0.087900, -0.737877, -0.331339, 0.587970, 0.500000, 0.500000},
{-0.169959, -0.023217, -0.085653, -0.791528, -0.494034, 0.359661, 0.000000, 0.500000},
{-0.154113, -0.016989, -0.060199, -0.771020, -0.316599, 0.552477, 0.000000, 1.000000},
{-0.171509, 0.020959, -0.065533, -0.727470, -0.196600, 0.657338, 0.500000, 1.000000},
{-0.207398, 0.043769, -0.091846, -0.761254, 0.035676, 0.647420, 1.000000, 0.500000},
{-0.212477, 0.038005, -0.101284, -0.980956, -0.137944, 0.136570, 1.000000, 0.000000},
{-0.205140, 0.016014, -0.102787, -0.861110, -0.470717, -0.192083, 0.500000, 0.000000},
{-0.175382, -0.020729, -0.103884, -0.754540, -0.542833, -0.368725, 0.000000, 0.000000},
{-0.002128, -0.176658, -0.143353, -0.389447, -0.440657, -0.808740, 0.500000, 0.500000},
{-0.026853, -0.148572, -0.138516, -0.452406, -0.340434, -0.824244, 0.000000, 0.500000},
{-0.014189, -0.134751, -0.144103, -0.080172, 0.008484, -0.996734, 0.000000, 1.000000},
{0.008428, -0.162573, -0.147513, 0.121647, -0.018555, -0.992370, 0.500000, 1.000000},
{0.017921, -0.174350, -0.143188, 0.541978, -0.173132, -0.822321, 1.000000, 1.000000},
{0.014710, -0.190370, -0.142052, 0.294809, -0.801843, -0.519700, 1.000000, 0.500000},
{0.005656, -0.187711, -0.130516, -0.146458, -0.982482, 0.114933, 1.000000, 0.000000},
{-0.009462, -0.181476, -0.129251, -0.557085, -0.815485, -0.156835, 0.500000, 0.000000},
{-0.035777, -0.155692, -0.123684, -0.638417, -0.681051, -0.358562, 0.000000, 0.000000},
{0.166365, -0.023466, 0.100690, 0.245064, 0.160344, 0.956145, 0.500000, 0.500000},
{0.134477, 0.005518, 0.099495, 0.224403, 0.247444, 0.942534, 0.000000, 0.500000},
{0.115464, -0.014823, 0.097948, -0.127018, -0.215247, 0.968230, 0.000000, 1.000000},
{0.144346, -0.039947, 0.098500, -0.156865, -0.262581, 0.952055, 0.500000, 1.000000},
{0.161138, -0.050743, 0.096468, -0.009644, -0.495224, 0.868679, 1.000000, 1.000000},
{0.183396, -0.045689, 0.098050, 0.570421, -0.372662, 0.731925, 1.000000, 0.500000},
{0.184878, -0.033734, 0.090142, 0.996368, 0.053835, 0.065645, 1.000000, 0.000000},
{0.178311, -0.014203, 0.090350, 0.793878, 0.539964, 0.279519, 0.500000, 0.000000},
{0.145221, 0.015062, 0.086599, 0.644337, 0.685659, 0.338572, 0.000000, 0.000000},
{0.020686, -0.142635, -0.139491, 0.533494, 0.106326, -0.839076, 0.500000, 0.500000},
{0.027723, -0.163711, -0.134980, 0.846156, -0.174993, -0.503342, 0.000000, 0.500000},
{-0.014189, -0.134751, -0.144103, -0.080172, 0.008484, -0.996734, 1.000000, 1.000000},
{0.002505, -0.115474, -0.140543, 0.255593, 0.194861, -0.946928, 1.000000, 0.500000},
{0.024126, -0.092793, -0.125832, 0.488021, 0.256508, -0.834254, 1.000000, 0.000000},
{0.038249, -0.119981, -0.119868, 0.726432, 0.034608, -0.686361, 0.500000, 0.000000},
{0.040817, -0.140428, -0.110348, 0.876339, -0.283670, -0.389233, 0.000000, 0.000000},
{-0.012055, -0.173613, -0.107446, -0.304697, -0.886715, 0.347636, 0.500000, 0.500000},
{0.009833, -0.182615, -0.116718, 0.187170, -0.884121, 0.428083, 0.000000, 0.500000},
{0.020704, -0.161288, -0.090569, 0.327586, -0.868465, 0.372051, 0.000000, 1.000000},
{-0.003364, -0.159027, -0.079841, -0.054842, -0.891140, 0.450392, 0.500000, 1.000000},
{-0.035033, -0.147949, -0.069502, -0.295419, -0.875332, 0.382702, 1.000000, 1.000000},
{-0.041254, -0.154869, -0.099508, -0.521867, -0.844935, 0.117008, 1.000000, 0.500000},
{-0.035777, -0.155692, -0.123684, -0.638417, -0.681051, -0.358562, 1.000000, 0.000000},
{-0.057120, 0.173591, 0.105114, -0.740226, 0.664144, 0.104587, 0.500000, 0.500000},
{-0.070223, 0.151465, 0.077469, -0.789880, 0.612568, 0.028596, 0.000000, 0.500000},
{-0.075530, 0.131873, 0.081294, -0.863582, 0.048463, 0.501816, 0.000000, 1.000000},
{-0.060753, 0.155024, 0.109455, -0.762688, -0.022187, 0.646352, 0.500000, 1.000000},
{-0.049029, 0.164035, 0.118021, -0.420209, -0.030061, 0.906919, 1.000000, 1.000000},
{-0.045977, 0.181446, 0.118635, -0.143468, 0.695181, 0.704337, 1.000000, 0.500000},
{-0.037044, 0.178929, 0.106912, 0.275399, 0.961272, 0.006867, 1.000000, 0.000000},
{-0.043503, 0.177363, 0.094723, -0.094546, 0.936338, -0.338084, 0.500000, 0.000000},
{-0.056339, 0.157692, 0.067094, -0.305216, 0.880001, -0.363872, 0.000000, 0.000000},
{0.172270, -0.056280, 0.085267, 0.617389, -0.786615, 0.005676, 0.500000, 0.500000},
{0.183396, -0.045689, 0.098050, 0.570421, -0.372662, 0.731925, 0.000000, 0.500000},
{0.161138, -0.050743, 0.096468, -0.009644, -0.495224, 0.868679, 0.000000, 1.000000},
{0.150079, -0.063110, 0.087428, 0.054140, -0.805017, 0.590716, 0.500000, 1.000000},
{0.128959, -0.075613, 0.062698, 0.209876, -0.910398, 0.356517, 1.000000, 1.000000},
{0.146463, -0.066685, 0.059563, 0.629933, -0.765374, -0.131687, 1.000000, 0.500000},
{0.153229, -0.051872, 0.049780, 0.817133, -0.335398, -0.468795, 1.000000, 0.000000},
{0.181435, -0.040259, 0.078287, 0.867519, -0.207129, -0.452193, 0.500000, 0.000000},
{0.184878, -0.033734, 0.090142, 0.996368, 0.053835, 0.065645, 0.000000, 0.000000},
{-0.022107, 0.166309, 0.084097, 0.393262, 0.865932, -0.309000, 0.500000, 0.500000},
{-0.034062, 0.154268, 0.055196, 0.128483, 0.880734, -0.455824, 0.000000, 0.500000},
{-0.056339, 0.157692, 0.067094, -0.305216, 0.880001, -0.363872, 0.000000, 1.000000},
{-0.043503, 0.177363, 0.094723, -0.094546, 0.936338, -0.338084, 0.500000, 1.000000},
{-0.037044, 0.178929, 0.106912, 0.275399, 0.961272, 0.006867, 1.000000, 1.000000},
{-0.020180, 0.169554, 0.103800, 0.626637, 0.754570, 0.194708, 1.000000, 0.500000},
{0.005929, 0.143797, 0.075195, 0.609149, 0.773614, -0.174413, 0.500000, 0.000000},
{-0.004990, 0.138619, 0.044602, 0.437696, 0.783959, -0.440199, 0.000000, 0.000000},
{-0.052197, 0.121694, 0.101930, -0.488601, -0.322062, 0.810846, 0.500000, 0.500000},
{-0.037418, 0.147228, 0.118521, -0.125309, -0.189520, 0.973815, 0.000000, 0.500000},
{-0.075530, 0.131873, 0.081294, -0.863582, 0.048463, 0.501816, 1.000000, 1.000000},
{-0.072077, 0.095203, 0.073541, -0.661946, -0.256813, 0.704154, 1.000000, 0.500000},
{-0.058955, 0.051568, 0.066377, -0.560015, -0.259468, 0.786767, 1.000000, 0.000000},
{-0.033424, 0.082416, 0.093367, -0.390210, -0.302652, 0.869533, 0.500000, 0.000000},
{-0.012758, 0.113651, 0.110837, -0.065188, -0.178808, 0.981719, 0.000000, 0.000000},
{0.170031, -0.017250, 0.069515, 0.809961, 0.350261, -0.470351, 0.500000, 0.500000},
{0.149236, -0.030311, 0.037893, 0.818934, 0.118625, -0.561480, 0.000000, 0.500000},
{0.132990, -0.002148, 0.029287, 0.720054, 0.453810, -0.524918, 0.000000, 1.000000},
{0.144691, 0.011289, 0.063108, 0.714591, 0.617847, -0.327952, 0.500000, 1.000000},
{0.145221, 0.015062, 0.086599, 0.644337, 0.685659, 0.338572, 1.000000, 1.000000},
{0.178311, -0.014203, 0.090350, 0.793878, 0.539964, 0.279519, 1.000000, 0.500000},
{0.153229, -0.051872, 0.049780, 0.817133, -0.335398, -0.468795, 0.000000, 0.000000},
{0.122406, -0.058549, 0.081744, -0.250679, -0.553209, 0.794397, 0.500000, 0.500000},
{0.144346, -0.039947, 0.098500, -0.156865, -0.262581, 0.952055, 0.000000, 0.500000},
{0.091187, -0.043443, 0.078111, -0.217017, -0.478011, 0.851100, 0.500000, 1.000000},
{0.066381, -0.073922, 0.049771, -0.146947, -0.635395, 0.758049, 1.000000, 1.000000},
{0.100741, -0.079515, 0.054642, -0.130131, -0.743492, 0.655934, 1.000000, 0.500000},
{0.128959, -0.075613, 0.062698, 0.209876, -0.910398, 0.356517, 1.000000, 0.000000},
{0.150079, -0.063110, 0.087428, 0.054140, -0.805017, 0.590716, 0.500000, 0.000000},
{0.161138, -0.050743, 0.096468, -0.009644, -0.495224, 0.868679, 0.000000, 0.000000},
{-0.154633, 0.079580, -0.046498, -0.717612, 0.677114, 0.162694, 0.500000, 0.500000},
{-0.180255, 0.063485, -0.076629, -0.605396, 0.747063, 0.274483, 0.000000, 0.500000},
{-0.181707, 0.049457, -0.071257, -0.738060, 0.104892, 0.666494, 0.000000, 1.000000},
{-0.157142, 0.065265, -0.040711, -0.833369, 0.130436, 0.537034, 0.500000, 1.000000},
{-0.131239, 0.086620, -0.002504, -0.851192, 0.154393, 0.501602, 1.000000, 1.000000},
{-0.126816, 0.102195, -0.008036, -0.736076, 0.663137, 0.135502, 1.000000, 0.500000},
{-0.112758, 0.109039, -0.016329, -0.369457, 0.891873, -0.260781, 1.000000, 0.000000},
{-0.141822, 0.085118, -0.054402, -0.336558, 0.895108, -0.292306, 0.500000, 0.000000},
{-0.167394, 0.066930, -0.083999, -0.201972, 0.917753, -0.341899, 0.000000, 0.000000},
{-0.096067, 0.126912, 0.036520, -0.748222, 0.651967, 0.122684, 0.500000, 0.500000},
{-0.126816, 0.102195, -0.008036, -0.736076, 0.663137, 0.135502, 0.000000, 0.500000},
{-0.131239, 0.086620, -0.002504, -0.851192, 0.154393, 0.501602, 0.000000, 1.000000},
{-0.101530, 0.108947, 0.041069, -0.849574, 0.124790, 0.512467, 0.500000, 1.000000},
{-0.070223, 0.151465, 0.077469, -0.789880, 0.612568, 0.028596, 1.000000, 0.500000},
{-0.056339, 0.157692, 0.067094, -0.305216, 0.880001, -0.363872, 1.000000, 0.000000},
{-0.081844, 0.134074, 0.027123, -0.355663, 0.895138, -0.268746, 0.500000, 0.000000},
{-0.112758, 0.109039, -0.016329, -0.369457, 0.891873, -0.260781, 0.000000, 0.000000},
{0.119452, -0.088352, 0.018158, 0.707205, -0.703421, -0.070894, 0.500000, 0.500000},
{0.146463, -0.066685, 0.059563, 0.629933, -0.765374, -0.131687, 0.000000, 0.500000},
{0.128959, -0.075613, 0.062698, 0.209876, -0.910398, 0.356517, 0.000000, 1.000000},
{0.104612, -0.097493, 0.023141, 0.347606, -0.890561, 0.293344, 0.500000, 1.000000},
{0.076994, -0.121937, -0.020791, 0.386792, -0.896969, 0.213904, 1.000000, 1.000000},
{0.090826, -0.113497, -0.027919, 0.702109, -0.703146, -0.112186, 1.000000, 0.500000},
{0.096715, -0.098492, -0.037140, 0.845149, -0.362621, -0.392682, 1.000000, 0.000000},
{0.125362, -0.073577, 0.008246, 0.863277, -0.346355, -0.367107, 0.500000, 0.000000},
{0.060176, -0.134338, -0.067638, 0.685293, -0.718375, -0.119419, 0.500000, 0.500000},
{0.090826, -0.113497, -0.027919, 0.702109, -0.703146, -0.112186, 0.000000, 0.500000},
{0.076994, -0.121937, -0.020791, 0.386792, -0.896969, 0.213904, 0.000000, 1.000000},
{0.046058, -0.142132, -0.058643, 0.359508, -0.908414, 0.213263, 0.500000, 1.000000},
{0.020704, -0.161288, -0.090569, 0.327586, -0.868465, 0.372051, 1.000000, 1.000000},
{0.040817, -0.140428, -0.110348, 0.876339, -0.283670, -0.389233, 1.000000, 0.000000},
{0.066174, -0.119732, -0.077203, 0.825678, -0.371319, -0.424635, 0.500000, 0.000000},
{0.096715, -0.098492, -0.037140, 0.845149, -0.362621, -0.392682, 0.000000, 0.000000},
{-0.118003, 0.085615, -0.067631, -0.084689, 0.845363, -0.527421, 0.500000, 0.500000},
{-0.143362, 0.063678, -0.095720, -0.028474, 0.752007, -0.658498, 0.000000, 0.500000},
{-0.167394, 0.066930, -0.083999, -0.201972, 0.917753, -0.341899, 0.000000, 1.000000},
{-0.141822, 0.085118, -0.054402, -0.336558, 0.895108, -0.292306, 0.500000, 1.000000},
{-0.112758, 0.109039, -0.016329, -0.369457, 0.891873, -0.260781, 1.000000, 1.000000},
{-0.088427, 0.110082, -0.029789, -0.076968, 0.881405, -0.466018, 1.000000, 0.500000},
{-0.057062, 0.098960, -0.043005, 0.245735, 0.751122, -0.612690, 1.000000, 0.000000},
{-0.086747, 0.074368, -0.080732, 0.191992, 0.690695, -0.697134, 0.500000, 0.000000},
{-0.058307, 0.134246, 0.014193, -0.013947, 0.893460, -0.448897, 0.500000, 0.500000},
{-0.088427, 0.110082, -0.029789, -0.076968, 0.881405, -0.466018, 0.000000, 0.500000},
{-0.112758, 0.109039, -0.016329, -0.369457, 0.891873, -0.260781, 0.000000, 1.000000},
{-0.081844, 0.134074, 0.027123, -0.355663, 0.895138, -0.268746, 0.500000, 1.000000},
{-0.056339, 0.157692, 0.067094, -0.305216, 0.880001, -0.363872, 1.000000, 1.000000},
{-0.034062, 0.154268, 0.055196, 0.128483, 0.880734, -0.455824, 1.000000, 0.500000},
{-0.004990, 0.138619, 0.044602, 0.437696, 0.783959, -0.440199, 1.000000, 0.000000},
{-0.027899, 0.122025, 0.001987, 0.317667, 0.774773, -0.546617, 0.500000, 0.000000},
{-0.057062, 0.098960, -0.043005, 0.245735, 0.751122, -0.612690, 0.000000, 0.000000},
{-0.098786, 0.076369, 0.039457, -0.735343, -0.162145, 0.657979, 0.500000, 0.500000},
{-0.072077, 0.095203, 0.073541, -0.661946, -0.256813, 0.704154, 0.000000, 0.500000},
{-0.126666, 0.059384, 0.002669, -0.783044, -0.116245, 0.610981, 1.000000, 0.500000},
{-0.114073, 0.021214, 0.008412, -0.738731, -0.190039, 0.646596, 1.000000, 0.000000},
{-0.087124, 0.034633, 0.038750, -0.660085, -0.202399, 0.723380, 0.500000, 0.000000},
{-0.058955, 0.051568, 0.066377, -0.560015, -0.259468, 0.786767, 0.000000, 0.000000},
{-0.150058, 0.038439, -0.033836, -0.789972, -0.137761, 0.597400, 0.500000, 0.500000},
{-0.126666, 0.059384, 0.002669, -0.783044, -0.116245, 0.610981, 0.000000, 0.500000},
{-0.171509, 0.020959, -0.065533, -0.727470, -0.196600, 0.657338, 1.000000, 0.500000},
{-0.154113, -0.016989, -0.060199, -0.771020, -0.316599, 0.552477, 1.000000, 0.000000},
{-0.135943, 0.000914, -0.026707, -0.781335, -0.226569, 0.581500, 0.500000, 0.000000},
{-0.114073, 0.021214, 0.008412, -0.738731, -0.190039, 0.646596, 0.000000, 0.000000},
{0.064717, -0.097747, -0.089219, 0.782922, -0.038728, -0.620869, 0.500000, 0.500000},
{0.038249, -0.119981, -0.119868, 0.726432, 0.034608, -0.686361, 0.000000, 0.500000},
{0.024126, -0.092793, -0.125832, 0.488021, 0.256508, -0.834254, 0.000000, 1.000000},
{0.051565, -0.068762, -0.097967, 0.614521, 0.279458, -0.737693, 0.500000, 1.000000},
{0.081404, -0.044618, -0.059905, 0.684042, 0.311624, -0.659505, 1.000000, 1.000000},
{0.094909, -0.075070, -0.050037, 0.825831, -0.030213, -0.563097, 1.000000, 0.500000},
{0.123638, -0.051088, -0.004812, 0.849666, 0.013733, -0.527116, 0.500000, 0.500000},
{0.094909, -0.075070, -0.050037, 0.825831, -0.030213, -0.563097, 0.000000, 0.500000},
{0.081404, -0.044618, -0.059905, 0.684042, 0.311624, -0.659505, 0.000000, 1.000000},
{0.110220, -0.021598, -0.014602, 0.720359, 0.361339, -0.591998, 0.500000, 1.000000},
{0.132990, -0.002148, 0.029287, 0.720054, 0.453810, -0.524918, 1.000000, 1.000000},
{0.149236, -0.030311, 0.037893, 0.818934, 0.118625, -0.561480, 1.000000, 0.500000},
{0.079548, -0.103083, 0.021412, 0.034883, -0.838557, 0.543657, 0.500000, 0.500000},
{0.100741, -0.079515, 0.054642, -0.130131, -0.743492, 0.655934, 0.000000, 0.500000},
{0.066381, -0.073922, 0.049771, -0.146947, -0.635395, 0.758049, 0.000000, 1.000000},
{0.045779, -0.099843, 0.022715, -0.075991, -0.744957, 0.662740, 0.500000, 1.000000},
{0.022869, -0.120898, -0.005465, -0.074404, -0.823695, 0.562120, 1.000000, 1.000000},
{0.054972, -0.125667, -0.014171, 0.104038, -0.893277, 0.437239, 1.000000, 0.500000},
{0.076994, -0.121937, -0.020791, 0.386792, -0.896969, 0.213904, 1.000000, 0.000000},
{0.104612, -0.097493, 0.023141, 0.347606, -0.890561, 0.293344, 0.500000, 0.000000},
{0.128959, -0.075613, 0.062698, 0.209876, -0.910398, 0.356517, 0.000000, 0.000000},
{0.023157, -0.143680, -0.048335, 0.065889, -0.913205, 0.402081, 0.500000, 0.500000},
{0.054972, -0.125667, -0.014171, 0.104038, -0.893277, 0.437239, 0.000000, 0.500000},
{0.022869, -0.120898, -0.005465, -0.074404, -0.823695, 0.562120, 0.000000, 1.000000},
{-0.008864, -0.136779, -0.037179, -0.142552, -0.863369, 0.483963, 0.500000, 1.000000},
{-0.003364, -0.159027, -0.079841, -0.054842, -0.891140, 0.450392, 1.000000, 0.500000},
{0.046058, -0.142132, -0.058643, 0.359508, -0.908414, 0.213263, 0.500000, 0.000000},
{0.076994, -0.121937, -0.020791, 0.386792, -0.896969, 0.213904, 0.000000, 0.000000},
{-0.059399, -0.117644, -0.135513, -0.401196, -0.339152, -0.850856, 0.500000, 0.500000},
{-0.035777, -0.155692, -0.123684, -0.638417, -0.681051, -0.358562, 0.000000, 1.000000},
{-0.070526, -0.126200, -0.120087, -0.602283, -0.649434, -0.464125, 0.500000, 1.000000},
{-0.108146, -0.093409, -0.116144, -0.640980, -0.581286, -0.501175, 1.000000, 1.000000},
{-0.095064, -0.084246, -0.131474, -0.407086, -0.267129, -0.873440, 1.000000, 0.500000},
{-0.078052, -0.069429, -0.136890, -0.140141, 0.027772, -0.989715, 1.000000, 0.000000},
{-0.044511, -0.103474, -0.141204, -0.107761, -0.005860, -0.994140, 0.500000, 0.000000},
{-0.014189, -0.134751, -0.144103, -0.080172, 0.008484, -0.996734, 0.000000, 0.000000},
{-0.129141, -0.048749, -0.123527, -0.414197, -0.198645, -0.888211, 0.500000, 0.500000},
{-0.095064, -0.084246, -0.131474, -0.407086, -0.267129, -0.873440, 0.000000, 0.500000},
{-0.108146, -0.093409, -0.116144, -0.640980, -0.581286, -0.501175, 0.000000, 1.000000},
{-0.143074, -0.057728, -0.109540, -0.705252, -0.529252, -0.471633, 0.500000, 1.000000},
{-0.175382, -0.020729, -0.103884, -0.754540, -0.542833, -0.368725, 1.000000, 1.000000},
{-0.162282, -0.012485, -0.115706, -0.374676, -0.193915, -0.906613, 1.000000, 0.500000},
{-0.142608, 0.002155, -0.120982, -0.150334, 0.071963, -0.985992, 1.000000, 0.000000},
{-0.110327, -0.033301, -0.129237, -0.173498, 0.053682, -0.983367, 0.500000, 0.000000},
{-0.078052, -0.069429, -0.136890, -0.140141, 0.027772, -0.989715, 0.000000, 0.000000},
{0.032582, 0.100047, 0.105798, 0.357372, 0.290963, 0.887448, 0.500000, 0.500000},
{0.000820, 0.131745, 0.109908, 0.428205, 0.248360, 0.868862, 0.000000, 0.500000},
{-0.012758, 0.113651, 0.110837, -0.065188, -0.178808, 0.981719, 0.000000, 1.000000},
{0.017330, 0.080233, 0.107875, -0.065157, -0.105258, 0.992279, 0.500000, 1.000000},
{0.050286, 0.047229, 0.105997, -0.017823, -0.114902, 0.993194, 1.000000, 1.000000},
{0.066806, 0.068222, 0.103285, 0.334727, 0.288003, 0.897214, 1.000000, 0.500000},
{0.075201, 0.077829, 0.089484, 0.640950, 0.665456, 0.382488, 1.000000, 0.000000},
{0.039808, 0.109637, 0.091966, 0.650838, 0.655477, 0.383007, 0.500000, 0.000000},
{0.007114, 0.140520, 0.096165, 0.690909, 0.645466, 0.325510, 0.000000, 0.000000},
{0.101031, 0.036397, 0.100772, 0.302530, 0.259957, 0.916990, 0.500000, 0.500000},
{0.066806, 0.068222, 0.103285, 0.334727, 0.288003, 0.897214, 0.000000, 0.500000},
{0.050286, 0.047229, 0.105997, -0.017823, -0.114902, 0.993194, 0.000000, 1.000000},
{0.083554, 0.014890, 0.101568, -0.027406, -0.184851, 0.982360, 0.500000, 1.000000},
{0.115464, -0.014823, 0.097948, -0.127018, -0.215247, 0.968230, 1.000000, 1.000000},
{0.134477, 0.005518, 0.099495, 0.224403, 0.247444, 0.942534, 1.000000, 0.500000},
{0.145221, 0.015062, 0.086599, 0.644337, 0.685659, 0.338572, 1.000000, 0.000000},
{0.110595, 0.046022, 0.087003, 0.641957, 0.673513, 0.366344, 0.500000, 0.000000},
{0.075201, 0.077829, 0.089484, 0.640950, 0.665456, 0.382488, 0.000000, 0.000000},
{-0.026801, -0.082753, -0.138499, 0.138005, 0.215705, -0.966643, 0.500000, 0.500000},
{0.002505, -0.115474, -0.140543, 0.255593, 0.194861, -0.946928, 0.000000, 0.500000},
{-0.044511, -0.103474, -0.141204, -0.107761, -0.005860, -0.994140, 0.500000, 1.000000},
{-0.078052, -0.069429, -0.136890, -0.140141, 0.027772, -0.989715, 1.000000, 1.000000},
{-0.061322, -0.046630, -0.133962, 0.088748, 0.228431, -0.969481, 1.000000, 0.500000},
{-0.041340, -0.020138, -0.120168, 0.291604, 0.391186, -0.872860, 1.000000, 0.000000},
{-0.004920, -0.058356, -0.124854, 0.335032, 0.366771, -0.867855, 0.500000, 0.000000},
{0.024126, -0.092793, -0.125832, 0.488021, 0.256508, -0.834254, 0.000000, 0.000000},
{-0.095147, -0.009261, -0.127534, 0.038240, 0.239082, -0.970214, 0.500000, 0.500000},
{-0.061322, -0.046630, -0.133962, 0.088748, 0.228431, -0.969481, 0.000000, 0.500000},
{-0.078052, -0.069429, -0.136890, -0.140141, 0.027772, -0.989715, 0.000000, 1.000000},
{-0.110327, -0.033301, -0.129237, -0.173498, 0.053682, -0.983367, 0.500000, 1.000000},
{-0.142608, 0.002155, -0.120982, -0.150334, 0.071963, -0.985992, 1.000000, 1.000000},
{-0.128307, 0.023826, -0.119575, -0.000671, 0.309549, -0.950865, 1.000000, 0.500000},
{-0.112110, 0.049055, -0.107490, 0.122776, 0.547838, -0.827509, 1.000000, 0.000000},
{-0.077586, 0.018391, -0.115010, 0.246956, 0.420087, -0.873196, 0.500000, 0.000000},
{-0.041340, -0.020138, -0.120168, 0.291604, 0.391186, -0.872860, 0.000000, 0.000000},
{-0.076950, -0.130083, -0.093585, -0.606922, -0.793970, -0.034944, 0.500000, 0.500000},
{-0.041254, -0.154869, -0.099508, -0.521867, -0.844935, 0.117008, 0.000000, 0.500000},
{-0.035033, -0.147949, -0.069502, -0.295419, -0.875332, 0.382702, 0.000000, 1.000000},
{-0.072334, -0.128142, -0.060579, -0.482589, -0.816675, 0.316385, 0.500000, 1.000000},
{-0.107801, -0.098864, -0.055325, -0.680258, -0.653920, 0.331034, 1.000000, 1.000000},
{-0.113088, -0.099248, -0.089333, -0.717826, -0.695120, -0.038881, 1.000000, 0.500000},
{-0.108146, -0.093409, -0.116144, -0.640980, -0.581286, -0.501175, 1.000000, 0.000000},
{-0.070526, -0.126200, -0.120087, -0.602283, -0.649434, -0.464125, 0.500000, 0.000000},
{-0.143612, -0.062359, -0.086410, -0.802820, -0.586322, 0.108066, 0.500000, 0.500000},
{-0.113088, -0.099248, -0.089333, -0.717826, -0.695120, -0.038881, 0.000000, 0.500000},
{-0.107801, -0.098864, -0.055325, -0.680258, -0.653920, 0.331034, 0.000000, 1.000000},
{-0.133969, -0.059371, -0.055997, -0.788324, -0.446516, 0.423200, 0.500000, 1.000000},
{-0.154113, -0.016989, -0.060199, -0.771020, -0.316599, 0.552477, 1.000000, 1.000000},
{-0.169959, -0.023217, -0.085653, -0.791528, -0.494034, 0.359661, 1.000000, 0.500000},
{-0.175382, -0.020729, -0.103884, -0.754540, -0.542833, -0.368725, 1.000000, 0.000000},
{-0.143074, -0.057728, -0.109540, -0.705252, -0.529252, -0.471633, 0.500000, 0.000000},
{-0.108146, -0.093409, -0.116144, -0.640980, -0.581286, -0.501175, 0.000000, 0.000000},
{0.039468, 0.113195, 0.069977, 0.667776, 0.733390, -0.127110, 0.500000, 0.500000},
{0.005929, 0.143797, 0.075195, 0.609149, 0.773614, -0.174413, 0.000000, 0.500000},
{0.007114, 0.140520, 0.096165, 0.690909, 0.645466, 0.325510, 0.000000, 1.000000},
{0.039808, 0.109637, 0.091966, 0.650838, 0.655477, 0.383007, 0.500000, 1.000000},
{0.075201, 0.077829, 0.089484, 0.640950, 0.665456, 0.382488, 1.000000, 1.000000},
{0.075759, 0.078548, 0.066600, 0.673330, 0.721366, -0.161901, 1.000000, 0.500000},
{0.066137, 0.070321, 0.033744, 0.609912, 0.653340, -0.448439, 1.000000, 0.000000},
{0.029275, 0.108170, 0.038140, 0.584796, 0.686148, -0.432630, 0.500000, 0.000000},
{0.112051, 0.043901, 0.063224, 0.677053, 0.701346, -0.222938, 0.500000, 0.500000},
{0.075759, 0.078548, 0.066600, 0.673330, 0.721366, -0.161901, 0.000000, 0.500000},
{0.075201, 0.077829, 0.089484, 0.640950, 0.665456, 0.382488, 0.000000, 1.000000},
{0.110595, 0.046022, 0.087003, 0.641957, 0.673513, 0.366344, 0.500000, 1.000000},
{0.144691, 0.011289, 0.063108, 0.714591, 0.617847, -0.327952, 1.000000, 0.500000},
{0.132990, -0.002148, 0.029287, 0.720054, 0.453810, -0.524918, 1.000000, 0.000000},
{0.103000, 0.032472, 0.029349, 0.628803, 0.614399, -0.476516, 0.500000, 0.000000},
{0.066137, 0.070321, 0.033744, 0.609912, 0.653340, -0.448439, 0.000000, 0.000000},
{-0.006408, 0.046004, 0.094595, -0.325022, -0.236305, 0.915677, 0.500000, 0.500000},
{-0.033424, 0.082416, 0.093367, -0.390210, -0.302652, 0.869533, 0.000000, 0.500000},
{-0.058955, 0.051568, 0.066377, -0.560015, -0.259468, 0.786767, 0.000000, 1.000000},
{-0.035253, 0.011083, 0.071970, -0.473220, -0.247078, 0.845546, 0.500000, 1.000000},
{-0.004331, -0.024735, 0.075579, -0.280892, -0.399396, 0.872677, 1.000000, 1.000000},
{0.025354, 0.012355, 0.095615, -0.184545, -0.300912, 0.935606, 1.000000, 0.500000},
{0.050286, 0.047229, 0.105997, -0.017823, -0.114902, 0.993194, 1.000000, 0.000000},
{0.017330, 0.080233, 0.107875, -0.065157, -0.105258, 0.992279, 0.500000, 0.000000},
{0.058361, -0.018634, 0.086428, -0.116367, -0.424787, 0.897763, 0.500000, 0.500000},
{0.025354, 0.012355, 0.095615, -0.184545, -0.300912, 0.935606, 0.000000, 0.500000},
{-0.004331, -0.024735, 0.075579, -0.280892, -0.399396, 0.872677, 0.000000, 1.000000},
{0.030452, -0.054366, 0.062464, -0.116031, -0.564409, 0.817255, 0.500000, 1.000000},
{0.091187, -0.043443, 0.078111, -0.217017, -0.478011, 0.851100, 1.000000, 0.500000},
{0.115464, -0.014823, 0.097948, -0.127018, -0.215247, 0.968230, 1.000000, 0.000000},
{0.083554, 0.014890, 0.101568, -0.027406, -0.184851, 0.982360, 0.500000, 0.000000},
{0.050286, 0.047229, 0.105997, -0.017823, -0.114902, 0.993194, 0.000000, 0.000000},
{-0.051626, 0.044676, -0.088256, 0.376751, 0.536271, -0.755272, 0.500000, 0.500000},
{-0.086747, 0.074368, -0.080732, 0.191992, 0.690695, -0.697134, 0.000000, 0.500000},
{-0.057062, 0.098960, -0.043005, 0.245735, 0.751122, -0.612690, 0.000000, 1.000000},
{-0.021906, 0.069309, -0.050567, 0.450453, 0.597736, -0.663137, 0.500000, 1.000000},
{0.015147, 0.030393, -0.055302, 0.496078, 0.553697, -0.668783, 1.000000, 1.000000},
{-0.014573, 0.005760, -0.092991, 0.420667, 0.493973, -0.760918, 1.000000, 0.500000},
{0.022479, -0.033156, -0.097727, 0.461226, 0.456496, -0.760796, 0.500000, 0.500000},
{-0.014573, 0.005760, -0.092991, 0.420667, 0.493973, -0.760918, 0.000000, 0.500000},
{0.015147, 0.030393, -0.055302, 0.496078, 0.553697, -0.668783, 0.000000, 1.000000},
{0.052200, -0.008523, -0.060038, 0.536241, 0.510910, -0.671834, 0.500000, 1.000000},
{0.051565, -0.068762, -0.097967, 0.614521, 0.279458, -0.737693, 1.000000, 0.500000},
{0.006939, 0.092007, -0.005238, 0.510758, 0.638630, -0.575518, 0.500000, 0.500000},
{-0.027899, 0.122025, 0.001987, 0.317667, 0.774773, -0.546617, 0.000000, 0.500000},
{-0.004990, 0.138619, 0.044602, 0.437696, 0.783959, -0.440199, 0.000000, 1.000000},
{0.029275, 0.108170, 0.038140, 0.584796, 0.686148, -0.432630, 0.500000, 1.000000},
{0.066137, 0.070321, 0.033744, 0.609912, 0.653340, -0.448439, 1.000000, 1.000000},
{0.043992, 0.053091, -0.009974, 0.551958, 0.598559, -0.580523, 1.000000, 0.500000},
{0.015147, 0.030393, -0.055302, 0.496078, 0.553697, -0.668783, 1.000000, 0.000000},
{-0.021906, 0.069309, -0.050567, 0.450453, 0.597736, -0.663137, 0.500000, 0.000000},
{0.081045, 0.014175, -0.014709, 0.587115, 0.556017, -0.588305, 0.500000, 0.500000},
{0.043992, 0.053091, -0.009974, 0.551958, 0.598559, -0.580523, 0.000000, 0.500000},
{0.066137, 0.070321, 0.033744, 0.609912, 0.653340, -0.448439, 0.000000, 1.000000},
{0.103000, 0.032472, 0.029349, 0.628803, 0.614399, -0.476516, 0.500000, 1.000000},
{0.110220, -0.021598, -0.014602, 0.720359, 0.361339, -0.591998, 1.000000, 0.500000},
{0.081404, -0.044618, -0.059905, 0.684042, 0.311624, -0.659505, 1.000000, 0.000000},
{0.052200, -0.008523, -0.060038, 0.536241, 0.510910, -0.671834, 0.500000, 0.000000},
{0.015147, 0.030393, -0.055302, 0.496078, 0.553697, -0.668783, 0.000000, 0.000000},
{-0.065830, -0.010805, 0.046011, -0.579943, -0.257729, 0.772790, 0.500000, 0.500000},
{-0.087124, 0.034633, 0.038750, -0.660085, -0.202399, 0.723380, 0.000000, 0.500000},
{-0.114073, 0.021214, 0.008412, -0.738731, -0.190039, 0.646596, 0.000000, 1.000000},
{-0.094434, -0.027163, 0.015654, -0.674337, -0.289773, 0.679159, 0.500000, 1.000000},
{-0.064546, -0.073074, 0.017717, -0.485580, -0.533647, 0.692373, 1.000000, 1.000000},
{-0.035111, -0.052372, 0.049329, -0.383862, -0.476791, 0.790735, 1.000000, 0.500000},
{-0.004331, -0.024735, 0.075579, -0.280892, -0.399396, 0.872677, 1.000000, 0.000000},
{-0.035253, 0.011083, 0.071970, -0.473220, -0.247078, 0.845546, 0.500000, 0.000000},
{0.004826, -0.082496, 0.036792, -0.156529, -0.664968, 0.730277, 0.500000, 0.500000},
{-0.035111, -0.052372, 0.049329, -0.383862, -0.476791, 0.790735, 0.000000, 0.500000},
{-0.064546, -0.073074, 0.017717, -0.485580, -0.533647, 0.692373, 0.000000, 1.000000},
{-0.021208, -0.103843, 0.007921, -0.234718, -0.735405, 0.635639, 0.500000, 1.000000},
{0.045779, -0.099843, 0.022715, -0.075991, -0.744957, 0.662740, 1.000000, 0.500000},
{0.066381, -0.073922, 0.049771, -0.146947, -0.635395, 0.758049, 1.000000, 0.000000},
{0.030452, -0.054366, 0.062464, -0.116031, -0.564409, 0.817255, 0.500000, 0.000000},
{-0.004331, -0.024735, 0.075579, -0.280892, -0.399396, 0.872677, 0.000000, 0.000000},
{-0.117361, -0.045496, -0.020162, -0.746696, -0.341716, 0.570635, 0.500000, 0.500000},
{-0.135943, 0.000914, -0.026707, -0.781335, -0.226569, 0.581500, 0.000000, 0.500000},
{-0.090198, -0.089355, -0.018405, -0.583544, -0.583148, 0.565142, 1.000000, 0.500000},
{-0.064546, -0.073074, 0.017717, -0.485580, -0.533647, 0.692373, 1.000000, 0.000000},
{-0.094434, -0.027163, 0.015654, -0.674337, -0.289773, 0.679159, 0.500000, 0.000000},
{-0.050341, -0.119227, -0.025640, -0.336619, -0.780877, 0.526200, 0.500000, 0.500000},
{-0.090198, -0.089355, -0.018405, -0.583544, -0.583148, 0.565142, 0.000000, 0.500000},
{-0.008864, -0.136779, -0.037179, -0.142552, -0.863369, 0.483963, 1.000000, 0.500000},
{0.022869, -0.120898, -0.005465, -0.074404, -0.823695, 0.562120, 1.000000, 0.000000},
{-0.021208, -0.103843, 0.007921, -0.234718, -0.735405, 0.635639, 0.500000, 0.000000},
{-0.064546, -0.073074, 0.017717, -0.485580, -0.533647, 0.692373, 0.000000, 0.000000},
{-1.184336, 0.081545, 0.148713, -0.193030, 0.514389, 0.835536, 0.500000, 0.500000},
{-1.203438, 0.072238, 0.145537, -0.834803, 0.206336, 0.510361, 0.000000, 0.500000},
{-1.195402, 0.059572, 0.143103, -0.344981, -0.434370, 0.832026, 0.000000, 1.000000},
{-1.179471, 0.064861, 0.147066, 0.056887, -0.344676, 0.936979, 0.500000, 1.000000},
{-1.146996, 0.070800, 0.141270, 0.081484, -0.268044, 0.959929, 1.000000, 1.000000},
{-1.151218, 0.086023, 0.142661, -0.036744, 0.522355, 0.851924, 1.000000, 0.500000},
{-1.151418, 0.091959, 0.129574, -0.208258, 0.960479, 0.184515, 1.000000, 0.000000},
{-1.185733, 0.086478, 0.133018, -0.398022, 0.917173, 0.017579, 0.500000, 0.000000},
{-1.198416, 0.075871, 0.129571, -0.727500, 0.679159, -0.097049, 0.000000, 0.000000},
{-1.107288, -0.116549, -0.132262, 0.006745, -0.567583, -0.823267, 0.500000, 0.500000},
{-1.129229, -0.117752, -0.129714, -0.506699, -0.534379, -0.676473, 0.000000, 0.500000},
{-1.124544, -0.105829, -0.131914, -0.464156, 0.056734, -0.883908, 0.000000, 1.000000},
{-1.108270, -0.100620, -0.136478, -0.140385, 0.020539, -0.989868, 0.500000, 1.000000},
{-1.071540, -0.091986, -0.135975, -0.003784, -0.034516, -0.999390, 1.000000, 1.000000},
{-1.071247, -0.110234, -0.131037, 0.105106, -0.549608, -0.828761, 1.000000, 0.500000},
{-1.072569, -0.121666, -0.116053, 0.121250, -0.921506, -0.368847, 1.000000, 0.000000},
{-1.106868, -0.126223, -0.118738, -0.003754, -0.957091, -0.289682, 0.500000, 0.000000},
{-1.122612, -0.123258, -0.119843, -0.329264, -0.922849, -0.199774, 0.000000, 0.000000},
{-1.206177, 0.049703, 0.116714, -0.996277, -0.074801, 0.042116, 0.500000, 0.500000},
{-1.198082, 0.020434, 0.074349, -0.980560, -0.128330, -0.148289, 0.000000, 0.500000},
{-1.192299, 0.008994, 0.089869, -0.672018, -0.643574, 0.366253, 0.000000, 1.000000},
{-1.197919, 0.039129, 0.127523, -0.538011, -0.604358, 0.587573, 0.500000, 1.000000},
{-1.195402, 0.059572, 0.143103, -0.344981, -0.434370, 0.832026, 1.000000, 1.000000},
{-1.203438, 0.072238, 0.145537, -0.834803, 0.206336, 0.510361, 1.000000, 0.500000},
{-1.198416, 0.075871, 0.129571, -0.727500, 0.679159, -0.097049, 1.000000, 0.000000},
{-1.200046, 0.064446, 0.104561, -0.808039, 0.492996, -0.322428, 0.500000, 0.000000},
{-1.189126, 0.037473, 0.060459, -0.817621, 0.370708, -0.440474, 0.000000, 0.000000},
{-0.857958, 0.150502, 0.140762, 0.959655, 0.255989, 0.116153, 0.500000, 0.500000},
{-0.867829, 0.165374, 0.170205, 0.620838, 0.442122, 0.647328, 0.000000, 0.500000},
{-0.870361, 0.147403, 0.164821, 0.476913, -0.356945, 0.803186, 0.000000, 1.000000},
{-0.861874, 0.130243, 0.145623, 0.725455, -0.449416, 0.521256, 0.500000, 1.000000},
{-0.857179, 0.104327, 0.102762, 0.815851, -0.402081, 0.415540, 1.000000, 1.000000},
{-0.853006, 0.128191, 0.097082, 0.973968, 0.223121, 0.039216, 1.000000, 0.500000},
{-0.867379, 0.148375, 0.090078, 0.682394, 0.695700, -0.224219, 1.000000, 0.000000},
{-0.871308, 0.167563, 0.131776, 0.600971, 0.784448, -0.153081, 0.500000, 0.000000},
{-0.876443, 0.171726, 0.153716, 0.385357, 0.915189, 0.117832, 0.000000, 0.000000},
{-1.180616, 0.078563, 0.100898, -0.498672, 0.798761, -0.336558, 0.500000, 0.500000},
{-1.171002, 0.059705, 0.059377, -0.569170, 0.659413, -0.491073, 0.000000, 0.500000},
{-1.189126, 0.037473, 0.060459, -0.817621, 0.370708, -0.440474, 0.000000, 1.000000},
{-1.200046, 0.064446, 0.104561, -0.808039, 0.492996, -0.322428, 0.500000, 1.000000},
{-1.198416, 0.075871, 0.129571, -0.727500, 0.679159, -0.097049, 1.000000, 1.000000},
{-1.185733, 0.086478, 0.133018, -0.398022, 0.917173, 0.017579, 1.000000, 0.500000},
{-1.148236, 0.092398, 0.101964, -0.326823, 0.926145, -0.188177, 0.500000, 0.000000},
{-1.141211, 0.082138, 0.063800, -0.384228, 0.813562, -0.436384, 0.000000, 0.000000},
{-1.174185, 0.037517, 0.127158, 0.000275, -0.621601, 0.783288, 0.500000, 0.500000},
{-1.166208, 0.003559, 0.095837, -0.190985, -0.704489, 0.683523, 0.000000, 0.500000},
{-1.126735, 0.004990, 0.100319, -0.085788, -0.592608, 0.800867, 0.000000, 1.000000},
{-1.138112, 0.042502, 0.125445, 0.032991, -0.527573, 0.848842, 0.500000, 1.000000},
{-1.179471, 0.064861, 0.147066, 0.056887, -0.344676, 0.936979, 1.000000, 0.500000},
{-1.195402, 0.059572, 0.143103, -0.344981, -0.434370, 0.832026, 1.000000, 0.000000},
{-1.197919, 0.039129, 0.127523, -0.538011, -0.604358, 0.587573, 0.500000, 0.000000},
{-1.192299, 0.008994, 0.089869, -0.672018, -0.643574, 0.366253, 0.000000, 0.000000},
{-1.136150, -0.111372, -0.117942, -0.927610, -0.292428, -0.232368, 0.500000, 0.500000},
{-1.139842, -0.095931, -0.094705, -0.972137, -0.203772, -0.115726, 0.000000, 0.500000},
{-1.134864, -0.080435, -0.103721, -0.819208, 0.316904, -0.477920, 0.000000, 1.000000},
{-1.131024, -0.097460, -0.125707, -0.717765, 0.278726, -0.638020, 0.500000, 1.000000},
{-1.124544, -0.105829, -0.131914, -0.464156, 0.056734, -0.883908, 1.000000, 1.000000},
{-1.129229, -0.117752, -0.129714, -0.506699, -0.534379, -0.676473, 1.000000, 0.500000},
{-1.122612, -0.123258, -0.119843, -0.329264, -0.922849, -0.199774, 1.000000, 0.000000},
{-1.127408, -0.121618, -0.108029, -0.567003, -0.814722, 0.121189, 0.500000, 0.000000},
{-1.131538, -0.107301, -0.082483, -0.700583, -0.683554, 0.204718, 0.000000, 0.000000},
{-0.786181, -0.015769, -0.098709, 0.969176, 0.007660, 0.246193, 0.500000, 0.500000},
{-0.801501, 0.012337, -0.062030, 0.942045, 0.097293, 0.320963, 0.000000, 0.500000},
{-0.815627, -0.011961, -0.052669, 0.695486, -0.428114, 0.577013, 0.000000, 1.000000},
{-0.800796, -0.035612, -0.086262, 0.677877, -0.516648, 0.522965, 0.500000, 1.000000},
{-0.795177, -0.043200, -0.106165, 0.661763, -0.698813, 0.271432, 1.000000, 1.000000},
{-0.782555, -0.035330, -0.122987, 0.880581, -0.381726, -0.280801, 1.000000, 0.500000},
{-0.788716, -0.021090, -0.124037, 0.553758, 0.271065, -0.787286, 1.000000, 0.000000},
{-0.790098, -0.001831, -0.111360, 0.682943, 0.587451, -0.434095, 0.500000, 0.000000},
{-0.807740, 0.027487, -0.075319, 0.703330, 0.656240, -0.273171, 0.000000, 0.000000},
{-1.109751, -0.082947, -0.130161, -0.358257, 0.406476, -0.840449, 0.500000, 0.500000},
{-1.108270, -0.100620, -0.136478, -0.140385, 0.020539, -0.989868, 0.000000, 0.500000},
{-1.134864, -0.080435, -0.103721, -0.819208, 0.316904, -0.477920, 1.000000, 1.000000},
{-1.115313, -0.061065, -0.110353, -0.521867, 0.528214, -0.669759, 1.000000, 0.500000},
{-1.082424, -0.041384, -0.114157, -0.305155, 0.579852, -0.755364, 1.000000, 0.000000},
{-1.074501, -0.068774, -0.132167, -0.158055, 0.349864, -0.923338, 0.500000, 0.000000},
{-1.071540, -0.091986, -0.135975, -0.003784, -0.034516, -0.999390, 0.000000, 0.000000},
{-1.107072, -0.125131, -0.097129, -0.169713, -0.974792, 0.144658, 0.500000, 0.500000},
{-1.106868, -0.126223, -0.118738, -0.003754, -0.957091, -0.289682, 0.000000, 0.500000},
{-1.072569, -0.121666, -0.116053, 0.121250, -0.921506, -0.368847, 0.000000, 1.000000},
{-1.074453, -0.124426, -0.089721, 0.016053, -0.999481, 0.027131, 0.500000, 1.000000},
{-1.079396, -0.118314, -0.053546, -0.128819, -0.965178, 0.227546, 1.000000, 1.000000},
{-1.111241, -0.114290, -0.066234, -0.359691, -0.891018, 0.276925, 1.000000, 0.500000},
{-1.131538, -0.107301, -0.082483, -0.700583, -0.683554, 0.204718, 1.000000, 0.000000},
{-0.890447, 0.164738, 0.169280, -0.168676, 0.438734, 0.882626, 0.500000, 0.500000},
{-0.929237, 0.151890, 0.156619, -0.315226, 0.423780, 0.849117, 0.000000, 0.500000},
{-0.929261, 0.130851, 0.157719, -0.062227, -0.249580, 0.966338, 0.000000, 1.000000},
{-0.888418, 0.143445, 0.168486, 0.040193, -0.367016, 0.929319, 0.500000, 1.000000},
{-0.870361, 0.147403, 0.164821, 0.476913, -0.356945, 0.803186, 1.000000, 1.000000},
{-0.867829, 0.165374, 0.170205, 0.620838, 0.442122, 0.647328, 1.000000, 0.500000},
{-0.876443, 0.171726, 0.153716, 0.385357, 0.915189, 0.117832, 1.000000, 0.000000},
{-0.893498, 0.175715, 0.151690, -0.090976, 0.962462, 0.255593, 0.500000, 0.000000},
{-0.931319, 0.163757, 0.140409, -0.350444, 0.871517, 0.342936, 0.000000, 0.000000},
{-0.800844, -0.044436, -0.123714, 0.246620, -0.624226, -0.741264, 0.500000, 0.500000},
{-0.782555, -0.035330, -0.122987, 0.880581, -0.381726, -0.280801, 0.000000, 0.500000},
{-0.795177, -0.043200, -0.106165, 0.661763, -0.698813, 0.271432, 0.000000, 1.000000},
{-0.810714, -0.054824, -0.105768, 0.411908, -0.911069, 0.014924, 0.500000, 1.000000},
{-0.848542, -0.064914, -0.104084, 0.300668, -0.921873, -0.244392, 1.000000, 1.000000},
{-0.839794, -0.052682, -0.117942, 0.137242, -0.580126, -0.802850, 1.000000, 0.500000},
{-0.843876, -0.034939, -0.123414, 0.001465, -0.020539, -0.999786, 1.000000, 0.000000},
{-0.802174, -0.025619, -0.129361, 0.062319, 0.107639, -0.992218, 0.500000, 0.000000},
{-0.788716, -0.021090, -0.124037, 0.553758, 0.271065, -0.787286, 0.000000, 0.000000},
{-0.894152, 0.173834, 0.121202, 0.119907, 0.979583, -0.161260, 0.500000, 0.500000},
{-0.931124, 0.167679, 0.112261, -0.240883, 0.967834, -0.072268, 0.000000, 0.500000},
{-0.931319, 0.163757, 0.140409, -0.350444, 0.871517, 0.342936, 0.000000, 1.000000},
{-0.893498, 0.175715, 0.151690, -0.090976, 0.962462, 0.255593, 0.500000, 1.000000},
{-0.876443, 0.171726, 0.153716, 0.385357, 0.915189, 0.117832, 1.000000, 1.000000},
{-0.871308, 0.167563, 0.131776, 0.600971, 0.784448, -0.153081, 1.000000, 0.500000},
{-0.890333, 0.160417, 0.081715, 0.267373, 0.901761, -0.339579, 0.500000, 0.000000},
{-0.926846, 0.159725, 0.074367, -0.128208, 0.922758, -0.363384, 0.000000, 0.000000},
{-0.890832, 0.114378, 0.143822, 0.272683, -0.648976, 0.710227, 0.500000, 0.500000},
{-0.861874, 0.130243, 0.145623, 0.725455, -0.449416, 0.521256, 0.000000, 0.500000},
{-0.929261, 0.130851, 0.157719, -0.062227, -0.249580, 0.966338, 1.000000, 1.000000},
{-0.935773, 0.099418, 0.140539, 0.168584, -0.551714, 0.816767, 1.000000, 0.500000},
{-0.936934, 0.060310, 0.111819, 0.310770, -0.546525, 0.777612, 1.000000, 0.000000},
{-0.889868, 0.081249, 0.107154, 0.444746, -0.613178, 0.652821, 0.500000, 0.000000},
{-0.857179, 0.104327, 0.102762, 0.815851, -0.402081, 0.415540, 0.000000, 0.000000},
{-0.813842, -0.001103, -0.116070, 0.089511, 0.570330, -0.816492, 0.500000, 0.500000},
{-0.854958, -0.010090, -0.118551, -0.017365, 0.390393, -0.920469, 0.000000, 0.500000},
{-0.870147, 0.021960, -0.100001, 0.000153, 0.614551, -0.788842, 0.000000, 1.000000},
{-0.830927, 0.029645, -0.088589, 0.206183, 0.719016, -0.663686, 0.500000, 1.000000},
{-0.807740, 0.027487, -0.075319, 0.703330, 0.656240, -0.273171, 1.000000, 1.000000},
{-0.790098, -0.001831, -0.111360, 0.682943, 0.587451, -0.434095, 1.000000, 0.500000},
{-0.843876, -0.034939, -0.123414, 0.001465, -0.020539, -0.999786, 0.000000, 0.000000},
{-0.832646, -0.054054, -0.082161, 0.438185, -0.777490, 0.451064, 0.500000, 0.500000},
{-0.800796, -0.035612, -0.086262, 0.677877, -0.516648, 0.522965, 0.000000, 0.500000},
{-0.853535, -0.041564, -0.051184, 0.508744, -0.680685, 0.527055, 0.500000, 1.000000},
{-0.901460, -0.071839, -0.053325, 0.464614, -0.798456, 0.382824, 1.000000, 1.000000},
{-0.875955, -0.073231, -0.083790, 0.388043, -0.890561, 0.237190, 1.000000, 0.500000},
{-0.848542, -0.064914, -0.104084, 0.300668, -0.921873, -0.244392, 1.000000, 0.000000},
{-0.810714, -0.054824, -0.105768, 0.411908, -0.911069, 0.014924, 0.500000, 0.000000},
{-0.795177, -0.043200, -0.106165, 0.661763, -0.698813, 0.271432, 0.000000, 0.000000},
{-1.106430, 0.094069, 0.143803, -0.165349, 0.486190, 0.858058, 0.500000, 0.500000},
{-1.151218, 0.086023, 0.142661, -0.036744, 0.522355, 0.851924, 0.000000, 0.500000},
{-1.146996, 0.070800, 0.141270, 0.081484, -0.268044, 0.959929, 0.000000, 1.000000},
{-1.103080, 0.078835, 0.143876, -0.041719, -0.214637, 0.975768, 0.500000, 1.000000},
{-1.049266, 0.091458, 0.149498, -0.032350, -0.153691, 0.987579, 1.000000, 1.000000},
{-1.051417, 0.107998, 0.147936, -0.205206, 0.481063, 0.852290, 1.000000, 0.500000},
{-1.050390, 0.117656, 0.133956, -0.307993, 0.881741, 0.357280, 1.000000, 0.000000},
{-1.105590, 0.101770, 0.130881, -0.251656, 0.919370, 0.302286, 0.500000, 0.000000},
{-1.151418, 0.091959, 0.129574, -0.208258, 0.960479, 0.184515, 0.000000, 0.000000},
{-0.987623, 0.130124, 0.150856, -0.230110, 0.463271, 0.855800, 0.500000, 0.500000},
{-1.051417, 0.107998, 0.147936, -0.205206, 0.481063, 0.852290, 0.000000, 0.500000},
{-1.049266, 0.091458, 0.149498, -0.032350, -0.153691, 0.987579, 0.000000, 1.000000},
{-0.987101, 0.111159, 0.152751, -0.002319, -0.161534, 0.986847, 0.500000, 1.000000},
{-0.929237, 0.151890, 0.156619, -0.315226, 0.423780, 0.849117, 1.000000, 0.500000},
{-0.931319, 0.163757, 0.140409, -0.350444, 0.871517, 0.342936, 1.000000, 0.000000},
{-0.987958, 0.141361, 0.135815, -0.347728, 0.859340, 0.374950, 0.500000, 0.000000},
{-1.050390, 0.117656, 0.133956, -0.307993, 0.881741, 0.357280, 0.000000, 0.000000},
{-0.898149, -0.069661, -0.122723, 0.232337, -0.519303, -0.822382, 0.500000, 0.500000},
{-0.839794, -0.052682, -0.117942, 0.137242, -0.580126, -0.802850, 0.000000, 0.500000},
{-0.848542, -0.064914, -0.104084, 0.300668, -0.921873, -0.244392, 0.000000, 1.000000},
{-0.904708, -0.082849, -0.109872, 0.321360, -0.861629, -0.392743, 0.500000, 1.000000},
{-0.967374, -0.101558, -0.116379, 0.241218, -0.845271, -0.476730, 1.000000, 1.000000},
{-0.963146, -0.088240, -0.129943, 0.184423, -0.505661, -0.842769, 1.000000, 0.500000},
{-0.964518, -0.069754, -0.134160, 0.078921, -0.042085, -0.995972, 1.000000, 0.000000},
{-0.901499, -0.051788, -0.127473, 0.104862, -0.038972, -0.993713, 0.500000, 0.000000},
{-1.022023, -0.101281, -0.131489, 0.110538, -0.526109, -0.843165, 0.500000, 0.500000},
{-0.963146, -0.088240, -0.129943, 0.184423, -0.505661, -0.842769, 0.000000, 0.500000},
{-0.967374, -0.101558, -0.116379, 0.241218, -0.845271, -0.476730, 0.000000, 1.000000},
{-1.024699, -0.113971, -0.116853, 0.147282, -0.878750, -0.453963, 0.500000, 1.000000},
{-1.072569, -0.121666, -0.116053, 0.121250, -0.921506, -0.368847, 1.000000, 1.000000},
{-1.071540, -0.091986, -0.135975, -0.003784, -0.034516, -0.999390, 1.000000, 0.000000},
{-1.022410, -0.082425, -0.136098, 0.022034, -0.050996, -0.998444, 0.500000, 0.000000},
{-0.964518, -0.069754, -0.134160, 0.078921, -0.042085, -0.995972, 0.000000, 0.000000},
{-1.103258, 0.106291, 0.103997, -0.292734, 0.954344, -0.059023, 0.500000, 0.500000},
{-1.148236, 0.092398, 0.101964, -0.326823, 0.926145, -0.188177, 0.000000, 0.500000},
{-1.151418, 0.091959, 0.129574, -0.208258, 0.960479, 0.184515, 0.000000, 1.000000},
{-1.105590, 0.101770, 0.130881, -0.251656, 0.919370, 0.302286, 0.500000, 1.000000},
{-1.050390, 0.117656, 0.133956, -0.307993, 0.881741, 0.357280, 1.000000, 1.000000},
{-1.048520, 0.123545, 0.106299, -0.329508, 0.944060, -0.011719, 1.000000, 0.500000},
{-1.042893, 0.117887, 0.068284, -0.306131, 0.880734, -0.361339, 1.000000, 0.000000},
{-1.097253, 0.099782, 0.066425, -0.292886, 0.876431, -0.382153, 0.500000, 0.000000},
{-0.986861, 0.147462, 0.108174, -0.349651, 0.936735, -0.014405, 0.500000, 0.500000},
{-1.048520, 0.123545, 0.106299, -0.329508, 0.944060, -0.011719, 0.000000, 0.500000},
{-1.050390, 0.117656, 0.133956, -0.307993, 0.881741, 0.357280, 0.000000, 1.000000},
{-0.987958, 0.141361, 0.135815, -0.347728, 0.859340, 0.374950, 0.500000, 1.000000},
{-0.931319, 0.163757, 0.140409, -0.350444, 0.871517, 0.342936, 1.000000, 1.000000},
{-0.931124, 0.167679, 0.112261, -0.240883, 0.967834, -0.072268, 1.000000, 0.500000},
{-0.926846, 0.159725, 0.074367, -0.128208, 0.922758, -0.363384, 1.000000, 0.000000},
{-0.981895, 0.141708, 0.070410, -0.305307, 0.882839, -0.356822, 0.500000, 0.000000},
{-1.042893, 0.117887, 0.068284, -0.306131, 0.880734, -0.361339, 0.000000, 0.000000},
{-0.987638, 0.081876, 0.140955, 0.146367, -0.445906, 0.883023, 0.500000, 0.500000},
{-0.935773, 0.099418, 0.140539, 0.168584, -0.551714, 0.816767, 0.000000, 0.500000},
{-1.041602, 0.064919, 0.139902, 0.046724, -0.417829, 0.907315, 1.000000, 0.500000},
{-1.032090, 0.027834, 0.120289, 0.080142, -0.485458, 0.870540, 1.000000, 0.000000},
{-0.984236, 0.042863, 0.118316, 0.228584, -0.487075, 0.842891, 0.500000, 0.000000},
{-0.936934, 0.060310, 0.111819, 0.310770, -0.546525, 0.777612, 0.000000, 0.000000},
{-1.092839, 0.051715, 0.132212, -0.026704, -0.460036, 0.887478, 0.500000, 0.500000},
{-1.041602, 0.064919, 0.139902, 0.046724, -0.417829, 0.907315, 0.000000, 0.500000},
{-1.138112, 0.042502, 0.125445, 0.032991, -0.527573, 0.848842, 1.000000, 0.500000},
{-1.126735, 0.004990, 0.100319, -0.085788, -0.592608, 0.800867, 1.000000, 0.000000},
{-1.080810, 0.014145, 0.111380, -0.054720, -0.519913, 0.852443, 0.500000, 0.000000},
{-1.032090, 0.027834, 0.120289, 0.080142, -0.485458, 0.870540, 0.000000, 0.000000},
{-1.027441, -0.055877, -0.132587, -0.072298, 0.310800, -0.947691, 0.500000, 0.500000},
{-1.074501, -0.068774, -0.132167, -0.158055, 0.349864, -0.923338, 0.000000, 0.500000},
{-1.082424, -0.041384, -0.114157, -0.305155, 0.579852, -0.755364, 0.000000, 1.000000},
{-1.037432, -0.024952, -0.114687, -0.177587, 0.594836, -0.783959, 0.500000, 1.000000},
{-0.983675, -0.009414, -0.112391, -0.125614, 0.585925, -0.800562, 1.000000, 1.000000},
{-0.971845, -0.042104, -0.130381, -0.018494, 0.303720, -0.952574, 1.000000, 0.500000},
{-0.910988, -0.025299, -0.124512, 0.008515, 0.312754, -0.949767, 0.500000, 0.500000},
{-0.971845, -0.042104, -0.130381, -0.018494, 0.303720, -0.952574, 0.000000, 0.500000},
{-0.983675, -0.009414, -0.112391, -0.125614, 0.585925, -0.800562, 0.000000, 1.000000},
{-0.924488, 0.007582, -0.107715, -0.083468, 0.574023, -0.814539, 0.500000, 1.000000},
{-0.870147, 0.021960, -0.100001, 0.000153, 0.614551, -0.788842, 1.000000, 1.000000},
{-0.854958, -0.010090, -0.118551, -0.017365, 0.390393, -0.920469, 1.000000, 0.500000},
{-0.924947, -0.095278, -0.088532, 0.371868, -0.928190, 0.012757, 0.500000, 0.500000},
{-0.875955, -0.073231, -0.083790, 0.388043, -0.890561, 0.237190, 0.000000, 0.500000},
{-0.901460, -0.071839, -0.053325, 0.464614, -0.798456, 0.382824, 0.000000, 1.000000},
{-0.945639, -0.098152, -0.054842, 0.401227, -0.876156, 0.267037, 0.500000, 1.000000},
{-0.989494, -0.115977, -0.054737, 0.238075, -0.950804, 0.198065, 1.000000, 1.000000},
{-0.976842, -0.113705, -0.092118, 0.248482, -0.960631, -0.124180, 1.000000, 0.500000},
{-0.967374, -0.101558, -0.116379, 0.241218, -0.845271, -0.476730, 1.000000, 0.000000},
{-0.904708, -0.082849, -0.109872, 0.321360, -0.861629, -0.392743, 0.500000, 0.000000},
{-0.848542, -0.064914, -0.104084, 0.300668, -0.921873, -0.244392, 0.000000, 0.000000},
{-1.028860, -0.122019, -0.090282, 0.103122, -0.989654, -0.099521, 0.500000, 0.500000},
{-0.976842, -0.113705, -0.092118, 0.248482, -0.960631, -0.124180, 0.000000, 0.500000},
{-0.989494, -0.115977, -0.054737, 0.238075, -0.950804, 0.198065, 0.000000, 1.000000},
{-1.036446, -0.120787, -0.052010, 0.040956, -0.982208, 0.183264, 0.500000, 1.000000},
{-1.074453, -0.124426, -0.089721, 0.016053, -0.999481, 0.027131, 1.000000, 0.500000},
{-1.024699, -0.113971, -0.116853, 0.147282, -0.878750, -0.453963, 0.500000, 0.000000},
{-0.967374, -0.101558, -0.116379, 0.241218, -0.845271, -0.476730, 0.000000, 0.000000},
{-1.152095, -0.069953, -0.057759, -0.957183, -0.215979, -0.192724, 0.500000, 0.500000},
{-1.131538, -0.107301, -0.082483, -0.700583, -0.683554, 0.204718, 0.000000, 1.000000},
{-1.144554, -0.082846, -0.043245, -0.750969, -0.645100, 0.140873, 0.500000, 1.000000},
{-1.161909, -0.052862, 0.002489, -0.769768, -0.621937, 0.143468, 1.000000, 1.000000},
{-1.168507, -0.039110, -0.013782, -0.956206, -0.190039, -0.222541, 1.000000, 0.500000},
{-1.161495, -0.022752, -0.025611, -0.825343, 0.279000, -0.490860, 1.000000, 0.000000},
{-1.146401, -0.053891, -0.068130, -0.828700, 0.270943, -0.489700, 0.500000, 0.000000},
{-1.134864, -0.080435, -0.103721, -0.819208, 0.316904, -0.477920, 0.000000, 0.000000},
{-1.184681, -0.009076, 0.030553, -0.964232, -0.154241, -0.215491, 0.500000, 0.500000},
{-1.168507, -0.039110, -0.013782, -0.956206, -0.190039, -0.222541, 0.000000, 0.500000},
{-1.161909, -0.052862, 0.002489, -0.769768, -0.621937, 0.143468, 0.000000, 1.000000},
{-1.179060, -0.021959, 0.047526, -0.747276, -0.626392, 0.221656, 0.500000, 1.000000},
{-1.192299, 0.008994, 0.089869, -0.672018, -0.643574, 0.366253, 1.000000, 1.000000},
{-1.198082, 0.020434, 0.074349, -0.980560, -0.128330, -0.148289, 1.000000, 0.500000},
{-1.189126, 0.037473, 0.060459, -0.817621, 0.370708, -0.440474, 1.000000, 0.000000},
{-1.176006, 0.008055, 0.017160, -0.820124, 0.314280, -0.478103, 0.500000, 0.000000},
{-1.161495, -0.022752, -0.025611, -0.825343, 0.279000, -0.490860, 0.000000, 0.000000},
{-0.845143, 0.106509, 0.055297, 0.969726, 0.219001, 0.107913, 0.500000, 0.500000},
{-0.853006, 0.128191, 0.097082, 0.973968, 0.223121, 0.039216, 0.000000, 0.500000},
{-0.857179, 0.104327, 0.102762, 0.815851, -0.402081, 0.415540, 0.000000, 1.000000},
{-0.849917, 0.080717, 0.062968, 0.848628, -0.306375, 0.431166, 0.500000, 1.000000},
{-0.840388, 0.054523, 0.024345, 0.843562, -0.284951, 0.455153, 1.000000, 1.000000},
{-0.833772, 0.080968, 0.015030, 0.965331, 0.188879, 0.179968, 1.000000, 0.500000},
{-0.842708, 0.096882, 0.003924, 0.724082, 0.649434, -0.232185, 1.000000, 0.000000},
{-0.857216, 0.125186, 0.046846, 0.710501, 0.671682, -0.209662, 0.500000, 0.000000},
{-0.867379, 0.148375, 0.090078, 0.682394, 0.695700, -0.224219, 0.000000, 0.000000},
{-0.818295, 0.047080, -0.024098, 0.955718, 0.141697, 0.257820, 0.500000, 0.500000},
{-0.833772, 0.080968, 0.015030, 0.965331, 0.188879, 0.179968, 0.000000, 0.500000},
{-0.840388, 0.054523, 0.024345, 0.843562, -0.284951, 0.455153, 0.000000, 1.000000},
{-0.828892, 0.020857, -0.015000, 0.779626, -0.352306, 0.517716, 0.500000, 1.000000},
{-0.815627, -0.011961, -0.052669, 0.695486, -0.428114, 0.577013, 1.000000, 1.000000},
{-0.801501, 0.012337, -0.062030, 0.942045, 0.097293, 0.320963, 1.000000, 0.500000},
{-0.807740, 0.027487, -0.075319, 0.703330, 0.656240, -0.273171, 1.000000, 0.000000},
{-0.825746, 0.062354, -0.036844, 0.726859, 0.636067, -0.258919, 0.500000, 0.000000},
{-0.842708, 0.096882, 0.003924, 0.724082, 0.649434, -0.232185, 0.000000, 0.000000},
{-1.128533, -0.032509, -0.074097, -0.586505, 0.532304, -0.610431, 0.500000, 0.500000},
{-1.115313, -0.061065, -0.110353, -0.521867, 0.528214, -0.669759, 0.000000, 0.500000},
{-1.146401, -0.053891, -0.068130, -0.828700, 0.270943, -0.489700, 0.500000, 1.000000},
{-1.161495, -0.022752, -0.025611, -0.825343, 0.279000, -0.490860, 1.000000, 1.000000},
{-1.144653, -0.000484, -0.029463, -0.595599, 0.543779, -0.591174, 1.000000, 0.500000},
{-1.115068, 0.022284, -0.028854, -0.378674, 0.693258, -0.613147, 1.000000, 0.000000},
{-1.097598, -0.010602, -0.076488, -0.371990, 0.669515, -0.642903, 0.500000, 0.000000},
{-1.082424, -0.041384, -0.114157, -0.305155, 0.579852, -0.755364, 0.000000, 0.000000},
{-1.158912, 0.031805, 0.015475, -0.590716, 0.576830, -0.564165, 0.500000, 0.500000},
{-1.144653, -0.000484, -0.029463, -0.595599, 0.543779, -0.591174, 0.000000, 0.500000},
{-1.161495, -0.022752, -0.025611, -0.825343, 0.279000, -0.490860, 0.000000, 1.000000},
{-1.176006, 0.008055, 0.017160, -0.820124, 0.314280, -0.478103, 0.500000, 1.000000},
{-1.189126, 0.037473, 0.060459, -0.817621, 0.370708, -0.440474, 1.000000, 1.000000},
{-1.171002, 0.059705, 0.059377, -0.569170, 0.659413, -0.491073, 1.000000, 0.500000},
{-1.141211, 0.082138, 0.063800, -0.384228, 0.813562, -0.436384, 1.000000, 0.000000},
{-1.129880, 0.055982, 0.019051, -0.380566, 0.722770, -0.576830, 0.500000, 0.000000},
{-1.115068, 0.022284, -0.028854, -0.378674, 0.693258, -0.613147, 0.000000, 0.000000},
{-1.122717, -0.094720, -0.024848, -0.476302, -0.827540, 0.297067, 0.500000, 0.500000},
{-1.111241, -0.114290, -0.066234, -0.359691, -0.891018, 0.276925, 0.000000, 0.500000},
{-1.079396, -0.118314, -0.053546, -0.128819, -0.965178, 0.227546, 0.000000, 1.000000},
{-1.089895, -0.103131, -0.009033, -0.231513, -0.902737, 0.362560, 0.500000, 1.000000},
{-1.102819, -0.076957, 0.035323, -0.266793, -0.792077, 0.548997, 1.000000, 1.000000},
{-1.137920, -0.067314, 0.019667, -0.496261, -0.774071, 0.393078, 1.000000, 0.500000},
{-1.161909, -0.052862, 0.002489, -0.769768, -0.621937, 0.143468, 1.000000, 0.000000},
{-1.144554, -0.082846, -0.043245, -0.750969, -0.645100, 0.140873, 0.500000, 0.000000},
{-1.153268, -0.032970, 0.059951, -0.391491, -0.735618, 0.552751, 0.500000, 0.500000},
{-1.137920, -0.067314, 0.019667, -0.496261, -0.774071, 0.393078, 0.000000, 0.500000},
{-1.102819, -0.076957, 0.035323, -0.266793, -0.792077, 0.548997, 0.000000, 1.000000},
{-1.115035, -0.037873, 0.071026, -0.209204, -0.660390, 0.721183, 0.500000, 1.000000},
{-1.126735, 0.004990, 0.100319, -0.085788, -0.592608, 0.800867, 1.000000, 1.000000},
{-1.166208, 0.003559, 0.095837, -0.190985, -0.704489, 0.683523, 1.000000, 0.500000},
{-1.192299, 0.008994, 0.089869, -0.672018, -0.643574, 0.366253, 1.000000, 0.000000},
{-1.179060, -0.021959, 0.047526, -0.747276, -0.626392, 0.221656, 0.500000, 0.000000},
{-1.161909, -0.052862, 0.002489, -0.769768, -0.621937, 0.143468, 0.000000, 0.000000},
{-0.879970, 0.136786, 0.037127, 0.312510, 0.847499, -0.428968, 0.500000, 0.500000},
{-0.890333, 0.160417, 0.081715, 0.267373, 0.901761, -0.339579, 0.000000, 0.500000},
{-0.867379, 0.148375, 0.090078, 0.682394, 0.695700, -0.224219, 0.000000, 1.000000},
{-0.857216, 0.125186, 0.046846, 0.710501, 0.671682, -0.209662, 0.500000, 1.000000},
{-0.842708, 0.096882, 0.003924, 0.724082, 0.649434, -0.232185, 1.000000, 1.000000},
{-0.865286, 0.105010, -0.008640, 0.306314, 0.800928, -0.514420, 1.000000, 0.500000},
{-0.902594, 0.101471, -0.019026, -0.050752, 0.778069, -0.626087, 1.000000, 0.000000},
{-0.916680, 0.135966, 0.028919, -0.074587, 0.839869, -0.537584, 0.500000, 0.000000},
{-0.848506, 0.067156, -0.051662, 0.283395, 0.757012, -0.588702, 0.500000, 0.500000},
{-0.865286, 0.105010, -0.008640, 0.306314, 0.800928, -0.514420, 0.000000, 0.500000},
{-0.842708, 0.096882, 0.003924, 0.724082, 0.649434, -0.232185, 0.000000, 1.000000},
{-0.825746, 0.062354, -0.036844, 0.726859, 0.636067, -0.258919, 0.500000, 1.000000},
{-0.830927, 0.029645, -0.088589, 0.206183, 0.719016, -0.663686, 1.000000, 0.500000},
{-0.870147, 0.021960, -0.100001, 0.000153, 0.614551, -0.788842, 1.000000, 0.000000},
{-0.886555, 0.061309, -0.064413, -0.017640, 0.720450, -0.693258, 0.500000, 0.000000},
{-0.902594, 0.101471, -0.019026, -0.050752, 0.778069, -0.626087, 0.000000, 0.000000},
{-0.877705, 0.047772, 0.070347, 0.583911, -0.503006, 0.637165, 0.500000, 0.500000},
{-0.889868, 0.081249, 0.107154, 0.444746, -0.613178, 0.652821, 0.000000, 0.500000},
{-0.936934, 0.060310, 0.111819, 0.310770, -0.546525, 0.777612, 0.000000, 1.000000},
{-0.920901, 0.016245, 0.078298, 0.415876, -0.515732, 0.749016, 0.500000, 1.000000},
{-0.904482, -0.024823, 0.038526, 0.509049, -0.617115, 0.599994, 1.000000, 1.000000},
{-0.864467, 0.014805, 0.031540, 0.667653, -0.503952, 0.547899, 1.000000, 0.500000},
{-0.840388, 0.054523, 0.024345, 0.843562, -0.284951, 0.455153, 1.000000, 0.000000},
{-0.849917, 0.080717, 0.062968, 0.848628, -0.306375, 0.431166, 0.500000, 0.000000},
{-0.860276, -0.016793, -0.011127, 0.630329, -0.599445, 0.493271, 0.500000, 0.500000},
{-0.864467, 0.014805, 0.031540, 0.667653, -0.503952, 0.547899, 0.000000, 0.500000},
{-0.904482, -0.024823, 0.038526, 0.509049, -0.617115, 0.599994, 0.000000, 1.000000},
{-0.904485, -0.054944, -0.008951, 0.527940, -0.733268, 0.428388, 0.500000, 1.000000},
{-0.853535, -0.041564, -0.051184, 0.508744, -0.680685, 0.527055, 1.000000, 0.500000},
{-0.815627, -0.011961, -0.052669, 0.695486, -0.428114, 0.577013, 1.000000, 0.000000},
{-0.828892, 0.020857, -0.015000, 0.779626, -0.352306, 0.517716, 0.500000, 0.000000},
{-0.840388, 0.054523, 0.024345, 0.843562, -0.284951, 0.455153, 0.000000, 0.000000},
{-1.085393, 0.074392, 0.021440, -0.264260, 0.778283, -0.569536, 0.500000, 0.500000},
{-1.097253, 0.099782, 0.066425, -0.292886, 0.876431, -0.382153, 0.000000, 0.500000},
{-1.042893, 0.117887, 0.068284, -0.306131, 0.880734, -0.361339, 0.000000, 1.000000},
{-1.030593, 0.092902, 0.023228, -0.268715, 0.778436, -0.567248, 0.500000, 1.000000},
{-1.014766, 0.058400, -0.025360, -0.247627, 0.747765, -0.616016, 1.000000, 1.000000},
{-1.069827, 0.040138, -0.027299, -0.252937, 0.752312, -0.608295, 1.000000, 0.500000},
{-1.052700, 0.007039, -0.076133, -0.239113, 0.728080, -0.642384, 0.500000, 0.500000},
{-1.069827, 0.040138, -0.027299, -0.252937, 0.752312, -0.608295, 0.000000, 0.500000},
{-1.014766, 0.058400, -0.025360, -0.247627, 0.747765, -0.616016, 0.000000, 1.000000},
{-0.998554, 0.024191, -0.073975, -0.208716, 0.723624, -0.657826, 0.500000, 1.000000},
{-1.037432, -0.024952, -0.114687, -0.177587, 0.594836, -0.783959, 1.000000, 0.500000},
{-0.970622, 0.117383, 0.025004, -0.262459, 0.784448, -0.561876, 0.500000, 0.500000},
{-0.981895, 0.141708, 0.070410, -0.305307, 0.882839, -0.356822, 0.000000, 0.500000},
{-0.926846, 0.159725, 0.074367, -0.128208, 0.922758, -0.363384, 0.000000, 1.000000},
{-0.916680, 0.135966, 0.028919, -0.074587, 0.839869, -0.537584, 0.500000, 1.000000},
{-0.902594, 0.101471, -0.019026, -0.050752, 0.778069, -0.626087, 1.000000, 1.000000},
{-0.955721, 0.082390, -0.023601, -0.231361, 0.738884, -0.632862, 1.000000, 0.500000},
{-1.014766, 0.058400, -0.025360, -0.247627, 0.747765, -0.616016, 1.000000, 0.000000},
{-1.030593, 0.092902, 0.023228, -0.268715, 0.778436, -0.567248, 0.500000, 0.000000},
{-0.939871, 0.044634, -0.070959, -0.172430, 0.702689, -0.690237, 0.500000, 0.500000},
{-0.955721, 0.082390, -0.023601, -0.231361, 0.738884, -0.632862, 0.000000, 0.500000},
{-0.902594, 0.101471, -0.019026, -0.050752, 0.778069, -0.626087, 0.000000, 1.000000},
{-0.886555, 0.061309, -0.064413, -0.017640, 0.720450, -0.693258, 0.500000, 1.000000},
{-0.924488, 0.007582, -0.107715, -0.083468, 0.574023, -0.814539, 1.000000, 0.500000},
{-0.983675, -0.009414, -0.112391, -0.125614, 0.585925, -0.800562, 1.000000, 0.000000},
{-0.998554, 0.024191, -0.073975, -0.208716, 0.723624, -0.657826, 0.500000, 0.000000},
{-1.014766, 0.058400, -0.025360, -0.247627, 0.747765, -0.616016, 0.000000, 0.000000},
{-0.971898, -0.005291, 0.087684, 0.283700, -0.532121, 0.797693, 0.500000, 0.500000},
{-0.984236, 0.042863, 0.118316, 0.228584, -0.487075, 0.842891, 0.000000, 0.500000},
{-1.032090, 0.027834, 0.120289, 0.080142, -0.485458, 0.870540, 0.000000, 1.000000},
{-1.024395, -0.020347, 0.091801, 0.115574, -0.564959, 0.816950, 0.500000, 1.000000},
{-1.015721, -0.067043, 0.051935, 0.169744, -0.733238, 0.658406, 1.000000, 1.000000},
{-0.958909, -0.050998, 0.047213, 0.342479, -0.687643, 0.640187, 1.000000, 0.500000},
{-0.904482, -0.024823, 0.038526, 0.509049, -0.617115, 0.599994, 1.000000, 0.000000},
{-0.920901, 0.016245, 0.078298, 0.415876, -0.515732, 0.749016, 0.500000, 0.000000},
{-0.953558, -0.082672, -0.004945, 0.391430, -0.814783, 0.427595, 0.500000, 0.500000},
{-0.958909, -0.050998, 0.047213, 0.342479, -0.687643, 0.640187, 0.000000, 0.500000},
{-1.015721, -0.067043, 0.051935, 0.169744, -0.733238, 0.658406, 0.000000, 1.000000},
{-1.003270, -0.099671, -0.001816, 0.214393, -0.873836, 0.436384, 0.500000, 1.000000},
{-0.945639, -0.098152, -0.054842, 0.401227, -0.876156, 0.267037, 1.000000, 0.500000},
{-0.901460, -0.071839, -0.053325, 0.464614, -0.798456, 0.382824, 1.000000, 0.000000},
{-0.904485, -0.054944, -0.008951, 0.527940, -0.733268, 0.428388, 0.500000, 0.000000},
{-0.904482, -0.024823, 0.038526, 0.509049, -0.617115, 0.599994, 0.000000, 0.000000},
{-1.072093, -0.032437, 0.083946, -0.067476, -0.598559, 0.798212, 0.500000, 0.500000},
{-1.080810, 0.014145, 0.111380, -0.054720, -0.519913, 0.852443, 0.000000, 0.500000},
{-1.062889, -0.076281, 0.047025, -0.037324, -0.770501, 0.636311, 1.000000, 0.500000},
{-1.015721, -0.067043, 0.051935, 0.169744, -0.733238, 0.658406, 1.000000, 0.000000},
{-1.024395, -0.020347, 0.091801, 0.115574, -0.564959, 0.816950, 0.500000, 0.000000},
{-1.049398, -0.105636, -0.002267, 0.002014, -0.912534, 0.408948, 0.500000, 0.500000},
{-1.062889, -0.076281, 0.047025, -0.037324, -0.770501, 0.636311, 0.000000, 0.500000},
{-1.036446, -0.120787, -0.052010, 0.040956, -0.982208, 0.183264, 1.000000, 0.500000},
{-0.989494, -0.115977, -0.054737, 0.238075, -0.950804, 0.198065, 1.000000, 0.000000},
{-1.003270, -0.099671, -0.001816, 0.214393, -0.873836, 0.436384, 0.500000, 0.000000},
{-1.015721, -0.067043, 0.051935, 0.169744, -0.733238, 0.658406, 0.000000, 0.000000},
{-1.230800, 0.021430, 0.050860, 0.090762, -0.018860, 0.995666, -5.005184, -4.245559},
{-1.230800, 0.285447, 0.055928, 0.108829, -0.018433, 0.993866, -4.181390, -4.248281},
{-1.277325, 0.284886, 0.057215, 0.000275, -0.020051, 0.999786, -4.183800, -4.430465},
{-1.277326, 0.018983, 0.051867, 0.000244, -0.020447, 0.999786, -5.014484, -4.427721},
{-1.277326, -0.248141, 0.046058, 0.000214, -0.027802, 0.999603, -5.849655, -4.424961},
{-1.230800, -0.243806, 0.045333, 0.073550, -0.026276, 0.996918, -5.833465, -4.242823},
{-1.196307, -0.237304, 0.041275, 0.404340, -0.019593, 0.914396, -5.801609, -4.062828},
{-1.196307, 0.025101, 0.045388, 0.469527, -0.012329, 0.882809, -4.987108, -4.065519},
{-1.196307, 0.286285, 0.049041, 0.525407, -0.011658, 0.850734, -4.177094, -4.068196},
{-1.324919, 0.021430, 0.050860, -0.087039, -0.018860, 0.996002, -5.006234, -4.614124},
{-1.324919, 0.285447, 0.055928, -0.104404, -0.018433, 0.994354, -4.182440, -4.616845},
{-1.361015, 0.286285, 0.049041, -0.512436, -0.011750, 0.858608, -4.179195, -4.805325},
{-1.361015, 0.025101, 0.045388, -0.456496, -0.012360, 0.889615, -4.989208, -4.802649},
{-1.361015, -0.237304, 0.041275, -0.391552, -0.019684, 0.919919, -5.803708, -4.799958},
{-1.324919, -0.243806, 0.045333, -0.070528, -0.026276, 0.997131, -5.834515, -4.611388},
{-1.230800, -0.337743, 0.042144, 0.110813, -0.314859, 0.942625, -6.129787, -4.241844},
{-1.277326, -0.342707, 0.042775, 0.000488, -0.305490, 0.952178, -6.148274, -4.423975},
{-1.277326, -0.348921, 0.038639, 0.001038, -0.817499, 0.575884, -6.178617, -4.423876},
{-1.230800, -0.343957, 0.038007, 0.176916, -0.806024, 0.564776, -6.160130, -4.241745},
{-1.205250, -0.336830, 0.035655, 0.326456, -0.779565, 0.534471, -6.123679, -4.061765},
{-1.196307, -0.330297, 0.038564, 0.384594, -0.378979, 0.841670, -6.093337, -4.061864},
{-1.324919, -0.337743, 0.042144, -0.106510, -0.315134, 0.943022, -6.130836, -4.610409},
{-1.361015, -0.330297, 0.038564, -0.371197, -0.381085, 0.846736, -6.095436, -4.798995},
{-1.351657, -0.336830, 0.035655, -0.313730, -0.783197, 0.536790, -6.125778, -4.798894},
{-1.324919, -0.343957, 0.038007, -0.170385, -0.807031, 0.565355, -6.161179, -4.610309},
{-1.230800, -0.332496, -0.468528, 0.009064, -0.021180, -0.999725, -3.155515, 1.302940},
{-1.230800, -0.342172, -0.468150, 0.034028, -0.178655, -0.983306, -3.202423, 1.303096},
{-1.277325, -0.346239, -0.468150, 0.000153, -0.172857, -0.984924, -3.218807, 1.485342},
{-1.277325, -0.334820, -0.468528, 0.000000, -0.017884, -0.999817, -3.163447, 1.485159},
{-1.277325, -0.236979, -0.468528, 0.000000, 0.000000, -1.000000, -2.853143, 1.484133},
{-1.230800, -0.236398, -0.468528, 0.010529, 0.000610, -0.999939, -2.851549, 1.301936},
{-1.196307, -0.235526, -0.467910, 0.103977, 0.003754, -0.994568, -2.847837, 1.121823},
{-1.196307, -0.329010, -0.468143, 0.066622, -0.048738, -0.996582, -3.139127, 1.122786},
{-1.205250, -0.336048, -0.467853, 0.069185, -0.173406, -0.982391, -3.169133, 1.122885},
{-1.324919, -0.332496, -0.468528, -0.008667, -0.021180, -0.999725, -3.154466, 1.671506},
{-1.324919, -0.342172, -0.468150, -0.032716, -0.178655, -0.983337, -3.201375, 1.671660},
{-1.351657, -0.336048, -0.467853, -0.066134, -0.173467, -0.982604, -3.167035, 1.860015},
{-1.361015, -0.329010, -0.468143, -0.063692, -0.048738, -0.996765, -3.137028, 1.859916},
{-1.361015, -0.235526, -0.467910, -0.099490, 0.003754, -0.995025, -2.845737, 1.858954},
{-1.324919, -0.236398, -0.468528, -0.010071, 0.000610, -0.999939, -2.850499, 1.670501},
{-1.230800, 0.026095, -0.468528, 0.018799, 0.000641, -0.999817, -2.033467, 1.299233},
{-1.277325, 0.026095, -0.468528, 0.000000, 0.000000, -1.000000, -2.032948, 1.481423},
{-1.277325, 0.286217, -0.468528, 0.000000, 0.000000, -1.000000, -1.223488, 1.478748},
{-1.230800, 0.286217, -0.468528, 0.027070, 0.000641, -0.999603, -1.224007, 1.296558},
{-1.196307, 0.286219, -0.466545, 0.250740, 0.003662, -0.968017, -1.224519, 1.116460},
{-1.196307, 0.026096, -0.467228, 0.180029, 0.003784, -0.983642, -2.033980, 1.119135},
{-1.324919, 0.026095, -0.468528, -0.017975, 0.000641, -0.999817, -2.032417, 1.667798},
{-1.361015, 0.026096, -0.467228, -0.172674, 0.003784, -0.984954, -2.031880, 1.856265},
{-1.361015, 0.286219, -0.466545, -0.241096, 0.003693, -0.970489, -1.222420, 1.853590},
{-1.324919, 0.286217, -0.468528, -0.025880, 0.000641, -0.999664, -1.222957, 1.665123},
{-1.230800, 0.375721, 0.057737, 0.105838, -0.037568, 0.993652, -3.898532, -4.249216},
{-1.230800, 0.399455, 0.058312, 0.073428, -0.045412, 0.996246, -3.812211, -4.249500},
{-1.277325, 0.399515, 0.059520, 0.000244, -0.018830, 0.999817, -3.812375, -4.431692},
{-1.277325, 0.375790, 0.059118, 0.000305, -0.020508, 0.999786, -3.898645, -4.431407},
{-1.196307, 0.375616, 0.050368, 0.521104, -0.132633, 0.843104, -3.898830, -4.069116},
{-1.190729, 0.392028, 0.052618, 0.303598, -0.269814, 0.913785, -3.889513, -4.060338},
{-1.324919, 0.375721, 0.057737, -0.111850, -0.021790, 0.993469, -3.899582, -4.617780},
{-1.324919, 0.399455, 0.058312, -0.107212, -0.023316, 0.993957, -3.813261, -4.618065},
{-1.361015, 0.399363, 0.051185, -0.536210, -0.025880, 0.843654, -3.814509, -4.806530},
{-1.361015, 0.375616, 0.050368, -0.536027, -0.019257, 0.843959, -3.900931, -4.806244},
{-1.230800, 0.375202, -0.468528, 0.026734, -0.006165, -0.999603, -0.945907, 1.295640},
{-1.277325, 0.375202, -0.468528, 0.000000, 0.000000, -1.000000, -0.945388, 1.477830},
{-1.277325, 0.399008, -0.468528, 0.000000, 0.000000, -1.000000, -0.858827, 1.477544},
{-1.230800, 0.399008, -0.468528, 0.015931, -0.009003, -0.999817, -0.859346, 1.295354},
{-1.190729, 0.391668, -0.467104, 0.149266, -0.126835, -0.980621, -0.937130, 1.106704},
{-1.196307, 0.375203, -0.466310, 0.269570, -0.062410, -0.960936, -0.946420, 1.115542},
{-1.324919, 0.375202, -0.468528, -0.029878, 0.000366, -0.999542, -0.944857, 1.664204},
{-1.361015, 0.375203, -0.466310, -0.273507, 0.002136, -0.961852, -0.944320, 1.852671},
{-1.361015, 0.399009, -0.466299, -0.280648, 0.000427, -0.959807, -0.857759, 1.852385},
{-1.324919, 0.399008, -0.468528, -0.030824, 0.000061, -0.999512, -0.858296, 1.663918},
{-1.230800, -0.346029, 0.029639, 0.188879, -0.973540, 0.128574, -6.023802, -4.853763},
{-1.230800, -0.343957, 0.038007, 0.176916, -0.806024, 0.564776, -6.023685, -4.812706},
{-1.277326, -0.348921, 0.038639, 0.001038, -0.817499, 0.575884, -5.854510, -4.810799},
{-1.277326, -0.350993, 0.030270, 0.001190, -0.992706, 0.120365, -5.854628, -4.851855},
{-1.277326, -0.350933, -0.008227, 0.001160, -0.999969, -0.001434, -5.855056, -5.002313},
{-1.230800, -0.345989, -0.008819, 0.185705, -0.982574, -0.001038, -6.024229, -5.003769},
{-1.196307, -0.336502, -0.009250, 0.441481, -0.897244, -0.000366, -6.191465, -5.007247},
{-1.196307, -0.336511, 0.029186, 0.412915, -0.889035, 0.197699, -6.191041, -4.858144},
{-1.205250, -0.336830, 0.035655, 0.326456, -0.779565, 0.534471, -6.190925, -4.817087},
{-1.324919, -0.346029, 0.029639, -0.182012, -0.974822, 0.128758, -5.681582, -4.854894},
{-1.324919, -0.343957, 0.038007, -0.170385, -0.807031, 0.565355, -5.681466, -4.813838},
{-1.351657, -0.336830, 0.035655, -0.313730, -0.783197, 0.536790, -5.506486, -4.819352},
{-1.361015, -0.336511, 0.029186, -0.398328, -0.895383, 0.199011, -5.506602, -4.860407},
{-1.361015, -0.336502, -0.009250, -0.426588, -0.904416, -0.000366, -5.507026, -5.009510},
{-1.324919, -0.345989, -0.008819, -0.178961, -0.983825, -0.001038, -5.682009, -5.004901},
{-1.230800, 0.548575, 0.040035, 0.001251, 0.892361, 0.451308, 1.552603, 1.296875},
{-1.230800, 0.548575, -0.005626, 0.000000, 1.000000, 0.000000, 1.386580, 1.297424},
{-1.277325, 0.548575, -0.005626, 0.000000, 1.000000, 0.000000, 1.387233, 1.479613},
{-1.277325, 0.548575, 0.040035, 0.000000, 0.893124, 0.449782, 1.553122, 1.479065},
{-1.277325, 0.527402, 0.055814, 0.000061, 0.345317, 0.938475, 1.630910, 1.478807},
{-1.230800, 0.527394, 0.055641, 0.008179, 0.341319, 0.939879, 1.630390, 1.296617},
{-1.194058, 0.527381, 0.055382, 0.008942, 0.334086, 0.942473, 1.629980, 1.152737},
{-1.194058, 0.548575, 0.040035, 0.001373, 0.890957, 0.454054, 1.552192, 1.152994},
{-1.194058, 0.548575, -0.005626, 0.000000, 1.000000, 0.000000, 1.386170, 1.153543},
{-1.324919, 0.548575, 0.040035, -0.251503, 0.849971, 0.462844, 1.553653, 1.665439},
{-1.324919, 0.527394, 0.055641, -0.148778, 0.319376, 0.935850, 1.631441, 1.665182},
{-1.324919, 0.548575, -0.005626, -0.262429, 0.964934, 0.000000, 1.388163, 1.665986},
{-1.361015, 0.527372, -0.006334, -0.817743, 0.575549, -0.000031, 1.389232, 1.854451},
{-1.361015, 0.527376, 0.039268, -0.759636, 0.491165, 0.426221, 1.554189, 1.853905},
{-1.351657, 0.510896, 0.050687, -0.456374, 0.246986, 0.854793, 1.631978, 1.853648},
{-1.230800, -0.345397, -0.467017, 0.143925, -0.797357, -0.586047, -6.029339, -6.798649},
{-1.230800, -0.345436, -0.435896, 0.177831, -0.984039, -0.001160, -6.028991, -6.676187},
{-1.277325, -0.350104, -0.435857, 0.001099, -0.999969, -0.001587, -5.859825, -6.676893},
{-1.277325, -0.350046, -0.467017, 0.000885, -0.806879, -0.590686, -5.860173, -6.799213},
{-1.277325, -0.346239, -0.468150, 0.000153, -0.172857, -0.984924, -5.860190, -6.805130},
{-1.230800, -0.342172, -0.468150, 0.034028, -0.178655, -0.983306, -6.029356, -6.804565},
{-1.205250, -0.336048, -0.467853, 0.069185, -0.173406, -0.982391, -6.196580, -6.804001},
{-1.196307, -0.336362, -0.467010, 0.330882, -0.714621, -0.616260, -6.196564, -6.798087},
{-1.196307, -0.336371, -0.435912, 0.433027, -0.901364, -0.000427, -6.196215, -6.675340},
{-1.324919, -0.345397, -0.467017, -0.138615, -0.798273, -0.586108, -5.687123, -6.799780},
{-1.324919, -0.345436, -0.435896, -0.171331, -0.985198, -0.001160, -5.686774, -6.677318},
{-1.361015, -0.336371, -0.435912, -0.418317, -0.908292, -0.000427, -5.511780, -6.677602},
{-1.361015, -0.336361, -0.467010, -0.319315, -0.719626, -0.616535, -5.512130, -6.800348},
{-1.351657, -0.336048, -0.467853, -0.066134, -0.173467, -0.982604, -5.512148, -6.806263},
{-1.324919, -0.342172, -0.468150, -0.032716, -0.178655, -0.983337, -5.687140, -6.805696},
{-1.230800, 0.548575, -0.459519, 0.000000, 0.807154, -0.590289, -0.263792, 1.302876},
{-1.230800, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.296548, 1.302984},
{-1.277325, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.296029, 1.485174},
{-1.277325, 0.548575, -0.459520, 0.000000, 0.807154, -0.590289, -0.263273, 1.485066},
{-1.277325, 0.548575, -0.423734, 0.000000, 1.000000, 0.000000, -0.133023, 1.484636},
{-1.230800, 0.548575, -0.423734, 0.000000, 1.000000, 0.000000, -0.133676, 1.302446},
{-1.194058, 0.548575, -0.423734, 0.000000, 1.000000, 0.000000, -0.134086, 1.158566},
{-1.194058, 0.548575, -0.459519, 0.000000, 0.807154, -0.590289, -0.264202, 1.158995},
{-1.194058, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.296958, 1.159103},
{-1.324919, 0.548575, -0.459519, -0.217261, 0.766717, -0.604083, -0.262742, 1.671440},
{-1.324919, 0.527330, -0.466276, -0.063662, 0.159795, -0.985076, -0.295498, 1.671549},
{-1.351657, 0.510807, -0.464530, -0.227638, 0.131993, -0.964721, -0.294961, 1.860015},
{-1.361015, 0.527331, -0.459531, -0.668966, 0.446944, -0.593860, -0.262205, 1.859907},
{-1.361015, 0.527334, -0.423800, -0.818049, 0.575121, -0.000031, -0.131022, 1.859474},
{-1.324919, 0.548575, -0.423734, -0.262795, 0.964843, 0.000000, -0.132093, 1.671009},
{-1.230800, 0.463850, 0.059673, 0.032411, 0.013886, 0.999359, -3.578029, -4.250274},
{-1.230800, 0.527394, 0.055641, 0.008179, 0.341319, 0.939879, -3.269917, -4.251291},
{-1.277325, 0.527402, 0.055814, 0.000061, 0.345317, 0.938475, -3.270436, -4.433482},
{-1.277325, 0.463884, 0.060363, 0.000153, 0.025147, 0.999664, -3.578345, -4.432465},
{-1.194058, 0.463798, 0.058638, 0.051485, -0.010895, 0.998596, -3.577924, -4.106392},
{-1.194058, 0.527381, 0.055382, 0.008942, 0.334086, 0.942473, -3.269507, -4.107410},
{-1.324919, 0.463850, 0.059673, -0.102664, 0.024873, 0.994385, -3.579079, -4.618839},
{-1.324919, 0.527394, 0.055641, -0.148778, 0.319376, 0.935850, -3.270967, -4.619858},
{-1.351657, 0.510896, 0.050687, -0.456374, 0.246986, 0.854793, -3.271504, -4.808325},
{-1.361015, 0.463797, 0.053306, -0.514420, 0.046266, 0.856258, -3.580022, -4.807305},
{-1.230800, 0.463596, -0.468528, 0.004395, 0.015137, -0.999847, -0.624502, 1.294578},
{-1.277325, 0.463596, -0.468528, 0.000000, 0.017640, -0.999817, -0.623983, 1.476768},
{-1.277325, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.314997, 1.475747},
{-1.230800, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.315516, 1.293556},
{-1.194058, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.315926, 1.149675},
{-1.194058, 0.463596, -0.468528, 0.012055, 0.008606, -0.999878, -0.624912, 1.150697},
{-1.324919, 0.463596, -0.468528, -0.034059, 0.019410, -0.999207, -0.623452, 1.663143},
{-1.361015, 0.463597, -0.466288, -0.266518, 0.035340, -0.963164, -0.622915, 1.851609},
{-1.351657, 0.510807, -0.464530, -0.227638, 0.131993, -0.964721, -0.313930, 1.850588},
{-1.324919, 0.527330, -0.466276, -0.063662, 0.159795, -0.985076, -0.314466, 1.662122},
{-1.184809, -0.327815, 0.030352, 0.796899, -0.465987, 0.384411, -3.335956, -7.184839},
{-1.184809, -0.327818, -0.008177, 0.895108, -0.445814, -0.000031, -3.475498, -7.185308},
{-1.184809, -0.235146, -0.007443, 1.000000, 0.000000, 0.000000, -3.474138, -6.871353},
{-1.184809, -0.235139, 0.032001, 0.907804, -0.007080, 0.419294, -3.330853, -6.870851},
{-1.196307, -0.237304, 0.041275, 0.404340, -0.019593, 0.914396, -3.287653, -6.870700},
{-1.196307, -0.330297, 0.038564, 0.384594, -0.378979, 0.841670, -3.297675, -7.184711},
{-1.205250, -0.336830, 0.035655, 0.326456, -0.779565, 0.534471, -3.304928, -7.217184},
{-1.196307, -0.336511, 0.029186, 0.412915, -0.889035, 0.197699, -3.343050, -7.217308},
{-1.196307, -0.336502, -0.009250, 0.441481, -0.897244, -0.000366, -3.481493, -7.217764},
{-1.184809, 0.026321, 0.032997, 0.930326, -0.003265, 0.366680, -3.329734, -5.993823},
{-1.184809, 0.026304, -0.008894, 1.000000, 0.000000, 0.000000, -3.482049, -5.994393},
{-1.184809, 0.286534, -0.010783, 1.000000, 0.000000, 0.000000, -3.491269, -5.122213},
{-1.184809, 0.286560, 0.033527, 0.946806, -0.002686, 0.321726, -3.330290, -5.121579},
{-1.196307, 0.286285, 0.049041, 0.525407, -0.011658, 0.850734, -3.258198, -5.121310},
{-1.196307, 0.025101, 0.045388, 0.469527, -0.012329, 0.882809, -3.272096, -5.993612},
{-1.373047, 0.026321, 0.032997, -0.926145, -0.003357, 0.377117, -0.412040, -6.037777},
{-1.373047, 0.026304, -0.008894, -1.000000, 0.000000, 0.000000, -0.564355, -6.037205},
{-1.373047, -0.235146, -0.007443, -1.000000, 0.000000, 0.000000, -0.556446, -5.160246},
{-1.373047, -0.235138, 0.032001, -0.903104, -0.007233, 0.429334, -0.413160, -5.160748},
{-1.361015, -0.237304, 0.041275, -0.391552, -0.019684, 0.919919, -0.369960, -5.160900},
{-1.361015, 0.025101, 0.045388, -0.456496, -0.012360, 0.889615, -0.354403, -6.037989},
{-1.361015, 0.286285, 0.049041, -0.512436, -0.011750, 0.858608, -0.340505, -6.910291},
{-1.373047, 0.286560, 0.033527, -0.943205, -0.002777, 0.332102, -0.412597, -6.910021},
{-1.373047, 0.286534, -0.010783, -1.000000, 0.000000, 0.000000, -0.573707, -6.909385},
{-1.373047, -0.327815, 0.030352, -0.787317, -0.475417, 0.392499, -0.418262, -4.846760},
{-1.373047, -0.327818, -0.008177, -0.890194, -0.455519, -0.000031, -0.557805, -4.846289},
{-1.361015, -0.336502, -0.009250, -0.426588, -0.904416, -0.000366, -0.563800, -4.813833},
{-1.361015, -0.336511, 0.029186, -0.398328, -0.895383, 0.199011, -0.425356, -4.814291},
{-1.351657, -0.336830, 0.035655, -0.313730, -0.783197, 0.536790, -0.387236, -4.814416},
{-1.361015, -0.330297, 0.038564, -0.371197, -0.381085, 0.846736, -0.379981, -4.846889},
{-1.184809, -0.327847, -0.466987, 0.640461, -0.332560, -0.692221, -5.144297, -7.190940},
{-1.196307, -0.329010, -0.468143, 0.066622, -0.048738, -0.996582, -5.149900, -7.190962},
{-1.196307, -0.235526, -0.467910, 0.103977, 0.003754, -0.994568, -5.150795, -6.877245},
{-1.184809, -0.235234, -0.466057, 0.770592, 0.004059, -0.637287, -5.141810, -6.877209},
{-1.184809, -0.235227, -0.434275, 1.000000, 0.000000, 0.000000, -5.026110, -6.876799},
{-1.184809, -0.327845, -0.435805, 0.893246, -0.449507, -0.000031, -5.030369, -7.190554},
{-1.196307, -0.336371, -0.435912, 0.433027, -0.901364, -0.000427, -5.030342, -7.222883},
{-1.196307, -0.336362, -0.467010, 0.330882, -0.714621, -0.616260, -5.144315, -7.223259},
{-1.205250, -0.336048, -0.467853, 0.069185, -0.173406, -0.982391, -5.149807, -7.223278},
{-1.184809, 0.026099, -0.463328, 0.812799, 0.003784, -0.582476, -5.134385, -6.000653},
{-1.196307, 0.026096, -0.467228, 0.180029, 0.003784, -0.983642, -5.153292, -6.000731},
{-1.196307, 0.286219, -0.466545, 0.250740, 0.003662, -0.968017, -5.155775, -5.128951},
{-1.184809, 0.286222, -0.460596, 0.848018, 0.003479, -0.529923, -5.126934, -5.128835},
{-1.184809, 0.286247, -0.425791, 1.000000, 0.000000, 0.000000, -5.000249, -5.128322},
{-1.184809, 0.026115, -0.430021, 1.000000, 0.000000, 0.000000, -5.013277, -6.000191},
{-1.373047, 0.026099, -0.463328, -0.808863, 0.003845, -0.587939, -2.216690, -6.030945},
{-1.361015, 0.026096, -0.467228, -0.172674, 0.003784, -0.984954, -2.235597, -6.030869},
{-1.361015, -0.235526, -0.467910, -0.099490, 0.003754, -0.995025, -2.233100, -5.154355},
{-1.373047, -0.235234, -0.466057, -0.767968, 0.004059, -0.640431, -2.224115, -5.154390},
{-1.373047, -0.235227, -0.434275, -1.000000, 0.000000, 0.000000, -2.108416, -5.154799},
{-1.373047, 0.026115, -0.430021, -1.000000, 0.000000, 0.000000, -2.095584, -6.031407},
{-1.373047, 0.286247, -0.425791, -1.000000, 0.000000, 0.000000, -2.082687, -6.903276},
{-1.373047, 0.286223, -0.460596, -0.843318, 0.003510, -0.537339, -2.209240, -6.902764},
{-1.361015, 0.286219, -0.466545, -0.241096, 0.003693, -0.970489, -2.238080, -6.902648},
{-1.373047, -0.327847, -0.466987, -0.633564, -0.338511, -0.695669, -2.226603, -4.840659},
{-1.361015, -0.329010, -0.468143, -0.063692, -0.048738, -0.996765, -2.232206, -4.840639},
{-1.351657, -0.336048, -0.467853, -0.066134, -0.173467, -0.982604, -2.232115, -4.808322},
{-1.361015, -0.336361, -0.467010, -0.319315, -0.719626, -0.616535, -2.226621, -4.808340},
{-1.361015, -0.336371, -0.435912, -0.418317, -0.908292, -0.000427, -2.112648, -4.808716},
{-1.373047, -0.327845, -0.435805, -0.888363, -0.459120, -0.000031, -2.112675, -4.841044},
{-0.844819, 0.378979, 0.033900, 0.000000, -0.899655, 0.436537, 3.462613, -1.999278},
{-0.844819, 0.400184, 0.050626, 0.000000, -0.383801, 0.923399, 3.539904, -1.999533},
{-1.088567, 0.400184, 0.050626, 0.000000, -0.383801, 0.923399, 3.537185, -2.954041},
{-1.088567, 0.378980, 0.033900, 0.000000, -0.899655, 0.436537, 3.459895, -2.953785},
{-1.088567, 0.378952, -0.011291, 0.000000, -0.999969, 0.000641, 3.295710, -2.953242},
{-0.844819, 0.378952, -0.011291, 0.000000, -0.999969, 0.000641, 3.298297, -1.998735},
{-0.522820, 0.378952, -0.011291, 0.000000, -0.999969, 0.000641, 3.301889, -0.737802},
{-0.522820, 0.378979, 0.033900, 0.000000, -0.899655, 0.436537, 3.466205, -0.738345},
{-0.522820, 0.400184, 0.050626, 0.000000, -0.383801, 0.923399, 3.543496, -0.738600},
{-1.175813, 0.378980, 0.033900, 0.125584, -0.901730, 0.413556, 3.458922, -3.295440},
{-1.175813, 0.400184, 0.050626, 0.110904, -0.387585, 0.915098, 3.536212, -3.295695},
{-1.190729, 0.392028, 0.052618, 0.303598, -0.269814, 0.913785, 3.536112, -3.330924},
{-1.182560, 0.378129, 0.033870, 0.550523, -0.754204, 0.357799, 3.458823, -3.330668},
{-1.182560, 0.378101, -0.011309, 0.468093, -0.883663, 0.000580, 3.295560, -3.330129},
{-1.175813, 0.378952, -0.011291, 0.062685, -0.998016, 0.000641, 3.295133, -3.294898},
{-0.844819, 0.548575, 0.040035, 0.000000, 0.890011, 0.455916, 1.548296, -0.214614},
{-0.844819, 0.548575, -0.005626, 0.000000, 1.000000, 0.000000, 1.382273, -0.214066},
{-1.088567, 0.548575, -0.005626, 0.000000, 1.000000, 0.000000, 1.384993, 0.740441},
{-1.088567, 0.548575, 0.040035, 0.000000, 0.890011, 0.455916, 1.551015, 0.739893},
{-1.088567, 0.527377, 0.055296, 0.000000, 0.329264, 0.944212, 1.628803, 0.739635},
{-0.844819, 0.527376, 0.055296, 0.000000, 0.329264, 0.944212, 1.626084, -0.214872},
{-0.522820, 0.527376, 0.055296, 0.000000, 0.329264, 0.944212, 1.622492, -1.475805},
{-0.522820, 0.548575, 0.040035, 0.000000, 0.890011, 0.455916, 1.544704, -1.475548},
{-0.522820, 0.548575, -0.005626, 0.000000, 1.000000, 0.000000, 1.378681, -1.474999},
{-1.175813, 0.548575, 0.040035, 0.000549, 0.890164, 0.455611, 1.551988, 1.081548},
{-1.175813, 0.548575, -0.005626, 0.000000, 1.000000, 0.000000, 1.385966, 1.082096},
{-1.175813, 0.527377, 0.055296, 0.003601, 0.330058, 0.943937, 1.629776, 1.081291},
{-0.844819, 0.378623, -0.459614, 0.000000, -0.806513, -0.591205, 1.668184, -1.993349},
{-0.844819, 0.378648, -0.424258, 0.000000, -0.999969, 0.000702, 1.796737, -1.993773},
{-1.088567, 0.378648, -0.424258, 0.000000, -0.999969, 0.000702, 1.794149, -2.948281},
{-1.088567, 0.378623, -0.459614, 0.000000, -0.806513, -0.591205, 1.665465, -2.947856},
{-1.088567, 0.399864, -0.466299, 0.000000, -0.169134, -0.985565, 1.633051, -2.947750},
{-0.844819, 0.399863, -0.466300, 0.000000, -0.169134, -0.985565, 1.635770, -1.993242},
{-0.522820, 0.399863, -0.466299, 0.000000, -0.169134, -0.985565, 1.639362, -0.732308},
{-0.522820, 0.378623, -0.459614, 0.000000, -0.806513, -0.591205, 1.671776, -0.732415},
{-0.522820, 0.378648, -0.424258, 0.000000, -0.999969, 0.000702, 1.800329, -0.732840},
{-1.175813, 0.378623, -0.459614, 0.092380, -0.809687, -0.579516, 1.664491, -3.289511},
{-1.175813, 0.378648, -0.424258, 0.062868, -0.998016, 0.000702, 1.793570, -3.289937},
{-1.182560, 0.377795, -0.424277, 0.468825, -0.883267, 0.000641, 1.793996, -3.325167},
{-1.182560, 0.377769, -0.459624, 0.469649, -0.686605, -0.554918, 1.664391, -3.324739},
{-1.190729, 0.391668, -0.467104, 0.149266, -0.126835, -0.980621, 1.631978, -3.324632},
{-1.175813, 0.399864, -0.466300, 0.051851, -0.175970, -0.983001, 1.632078, -3.289404},
{-0.844819, 0.548575, -0.459520, 0.000000, 0.807154, -0.590289, -0.268098, -0.208612},
{-0.844819, 0.548575, -0.423734, 0.000000, 1.000000, 0.000000, -0.137981, -0.209041},
{-0.522820, 0.548575, -0.423734, 0.000000, 1.000000, 0.000000, -0.141573, -1.469976},
{-0.522820, 0.548575, -0.459520, 0.000000, 0.807154, -0.590289, -0.271690, -1.469546},
{-0.522820, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.304446, -1.469438},
{-0.844819, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.300853, -0.208504},
{-1.088567, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.298134, 0.746004},
{-1.088567, 0.548575, -0.459519, 0.000000, 0.807154, -0.590289, -0.265379, 0.745896},
{-1.088567, 0.548575, -0.423734, 0.000000, 1.000000, 0.000000, -0.135262, 0.745466},
{-1.175813, 0.548575, -0.459519, 0.000000, 0.807154, -0.590289, -0.264406, 1.087550},
{-1.175813, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.297161, 1.087658},
{-1.175813, 0.548575, -0.423734, 0.000000, 1.000000, 0.000000, -0.134289, 1.087120},
{-0.844819, 0.463781, 0.058292, 0.000000, -0.036409, 0.999329, -3.574131, -2.738785},
{-0.844819, 0.527376, 0.055296, 0.000000, 0.329264, 0.944212, -3.265612, -2.739803},
{-1.088567, 0.527377, 0.055296, 0.000000, 0.329264, 0.944212, -3.268331, -3.694310},
{-1.088567, 0.463781, 0.058292, 0.000000, -0.036409, 0.999329, -3.576849, -3.693292},
{-1.088567, 0.400184, 0.050626, 0.000000, -0.383801, 0.923399, -3.885368, -3.692273},
{-0.844819, 0.400184, 0.050626, 0.000000, -0.383801, 0.923399, -3.882649, -2.737766},
{-0.522820, 0.400184, 0.050626, 0.000000, -0.383801, 0.923399, -3.879057, -1.476832},
{-0.522820, 0.463781, 0.058292, 0.000000, -0.036409, 0.999329, -3.570539, -1.477851},
{-0.522820, 0.527376, 0.055296, 0.000000, 0.329264, 0.944212, -3.262021, -1.478871},
{-1.175813, 0.463781, 0.058292, 0.026490, -0.030457, 0.999176, -3.577822, -4.034946},
{-1.175813, 0.527377, 0.055296, 0.003601, 0.330058, 0.943937, -3.269304, -4.035964},
{-1.175813, 0.400184, 0.050626, 0.110904, -0.387585, 0.915098, -3.886341, -4.033928},
{-0.844819, 0.463596, -0.468528, 0.000000, 0.000183, -1.000000, -0.628808, -0.216910},
{-0.844819, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.319822, -0.217932},
{-0.522820, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.323415, -1.478865},
{-0.522820, 0.463596, -0.468528, 0.000000, 0.000183, -1.000000, -0.632400, -1.477844},
{-0.522820, 0.399863, -0.466299, 0.000000, -0.169134, -0.985565, -0.941385, -1.476823},
{-0.844819, 0.399863, -0.466300, 0.000000, -0.169134, -0.985565, -0.937793, -0.215889},
{-1.088567, 0.399864, -0.466299, 0.000000, -0.169134, -0.985565, -0.935074, 0.738618},
{-1.088567, 0.463596, -0.468528, 0.000000, 0.000183, -1.000000, -0.626088, 0.737597},
{-1.088567, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.317102, 0.736575},
{-1.175813, 0.463596, -0.468528, 0.007660, 0.002380, -0.999939, -0.625115, 1.079251},
{-1.175813, 0.399864, -0.466300, 0.051851, -0.175970, -0.983001, -0.934101, 1.080273},
{-1.175813, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.316129, 1.078230},
{-1.184809, 0.375576, 0.033782, 0.905789, -0.285287, 0.313181, -3.330215, -4.821943},
{-1.196307, 0.375616, 0.050368, 0.521104, -0.132633, 0.843104, -3.253153, -4.821655},
{-1.184809, 0.375547, -0.011364, 0.935514, -0.353191, 0.000214, -3.493841, -4.822596},
{-1.182560, 0.378101, -0.011309, 0.468093, -0.883663, 0.000580, -3.493088, -4.809259},
{-1.182560, 0.378129, 0.033870, 0.550523, -0.754204, 0.357799, -3.329825, -4.808612},
{-1.190729, 0.392028, 0.052618, 0.303598, -0.269814, 0.913785, -3.252535, -4.808325},
{-1.373047, 0.375576, 0.033782, -0.949889, -0.006836, 0.312479, -0.412522, -7.209656},
{-1.373047, 0.375547, -0.011364, -1.000000, 0.000000, 0.000000, -0.576674, -7.209000},
{-1.361015, 0.375616, 0.050368, -0.536027, -0.019257, 0.843959, -0.335460, -7.209946},
{-1.361015, 0.399363, 0.051185, -0.536210, -0.025880, 0.843654, -0.332382, -7.302965},
{-1.373047, 0.399328, 0.034637, -0.950743, -0.010773, 0.309732, -0.409678, -7.302679},
{-1.373047, 0.399304, -0.010601, -1.000000, 0.000000, 0.000000, -0.574033, -7.302039},
{-1.184809, 0.375207, -0.459657, 0.810511, -0.264229, -0.522691, -5.124371, -4.829311},
{-1.184809, 0.375234, -0.424332, 0.935759, -0.352580, 0.000244, -4.995402, -4.828783},
{-1.196307, 0.375203, -0.466310, 0.269570, -0.062410, -0.960936, -5.156628, -4.829441},
{-1.190729, 0.391668, -0.467104, 0.149266, -0.126835, -0.980621, -5.156665, -4.816066},
{-1.182560, 0.377769, -0.459624, 0.469649, -0.686605, -0.554918, -5.124251, -4.815937},
{-1.182560, 0.377795, -0.424277, 0.468825, -0.883267, 0.000641, -4.994645, -4.815409},
{-1.373047, 0.375208, -0.459657, -0.858608, 0.001984, -0.512589, -2.206677, -7.202287},
{-1.361015, 0.375203, -0.466310, -0.273507, 0.002136, -0.961852, -2.238934, -7.202157},
{-1.373047, 0.375234, -0.424332, -1.000000, 0.000000, 0.000000, -2.078235, -7.202813},
{-1.373047, 0.399036, -0.424211, -1.000000, 0.000000, 0.000000, -2.077928, -7.296021},
{-1.373047, 0.399013, -0.459613, -0.861904, 0.000397, -0.507035, -2.206782, -7.295507},
{-1.361015, 0.399009, -0.466299, -0.280648, 0.000427, -0.959807, -2.239199, -7.295382},
{-1.373047, 0.463777, 0.036967, -0.939665, 0.082614, 0.331919, -0.401925, -7.555088},
{-1.361015, 0.527376, 0.039268, -0.759636, 0.491165, 0.426221, -0.391718, -7.887190},
{-1.361015, 0.527372, -0.006334, -0.817743, 0.575549, -0.000031, -0.556674, -7.886644},
{-1.373047, 0.463763, -0.008459, -0.995605, 0.093326, 0.000000, -0.566561, -7.554489},
{-1.361015, 0.463797, 0.053306, -0.514420, 0.046266, 0.856258, -0.324385, -7.555361},
{-1.351657, 0.510896, 0.050687, -0.456374, 0.246986, 0.854793, -0.313930, -7.887446},
{-1.373047, 0.463599, -0.459567, -0.849055, 0.082705, -0.521744, -2.207335, -7.548424},
{-1.373047, 0.463612, -0.423996, -0.995636, 0.093173, 0.000000, -2.077467, -7.548903},
{-1.361015, 0.527334, -0.423800, -0.818049, 0.575121, -0.000031, -2.076929, -7.881622},
{-1.361015, 0.527331, -0.459531, -0.668966, 0.446944, -0.593860, -2.208111, -7.881189},
{-1.351657, 0.510807, -0.464530, -0.227638, 0.131993, -0.964721, -2.240867, -7.881081},
{-1.361015, 0.463597, -0.466288, -0.266518, 0.035340, -0.963164, -2.239919, -7.548306},
{0.327406, 0.463599, -0.459566, 0.849055, 0.082705, -0.521744, -0.280397, -5.144282},
{0.327406, 0.463612, -0.423996, 0.995636, 0.093173, 0.000000, -0.150529, -5.143804},
{0.327406, 0.399036, -0.424211, 1.000000, 0.000000, 0.000000, -0.150990, -5.396685},
{0.327406, 0.399013, -0.459613, 0.861904, 0.000397, -0.507035, -0.279844, -5.397199},
{0.315374, 0.399009, -0.466299, 0.280618, 0.000427, -0.959807, -0.312261, -5.397326},
{0.315374, 0.463597, -0.466288, 0.266518, 0.035340, -0.963164, -0.312981, -5.144402},
{0.306016, 0.510807, -0.464530, 0.227638, 0.131993, -0.964721, -0.313930, -4.811626},
{0.315374, 0.527331, -0.459531, 0.668966, 0.446944, -0.593860, -0.281174, -4.811519},
{0.315374, 0.527334, -0.423800, 0.818049, 0.575121, -0.000031, -0.149991, -4.811085},
{0.327406, 0.463777, 0.036967, 0.939665, 0.082614, 0.331919, 1.525013, -5.137619},
{0.327406, 0.463763, -0.008459, 0.995605, 0.093326, 0.000000, 1.360377, -5.138217},
{0.315374, 0.527372, -0.006334, 0.817743, 0.575549, -0.000031, 1.370264, -4.806063},
{0.315374, 0.527376, 0.039268, 0.759636, 0.491165, 0.426221, 1.535220, -4.805517},
{0.306016, 0.510896, 0.050687, 0.456374, 0.246986, 0.854793, 1.613008, -4.805259},
{0.315374, 0.463797, 0.053306, 0.514420, 0.046266, 0.856258, 1.602552, -5.137346},
{0.315374, 0.399363, 0.051185, 0.536210, -0.025880, 0.843654, 1.594555, -5.389745},
{0.327406, 0.399328, 0.034637, 0.950743, -0.010773, 0.309732, 1.517260, -5.390028},
{0.327406, 0.399304, -0.010601, 1.000000, 0.000000, 0.000000, 1.352905, -5.390666},
{0.327406, 0.375207, -0.459657, 0.858608, 0.001984, -0.512589, -0.279739, -5.490421},
{0.327406, 0.286223, -0.460596, 0.843318, 0.003510, -0.537339, -0.282302, -5.789944},
{0.315374, 0.286219, -0.466545, 0.241096, 0.003693, -0.970489, -0.311142, -5.790061},
{0.315374, 0.375203, -0.466310, 0.273507, 0.002136, -0.961852, -0.311995, -5.490551},
{0.327406, 0.375234, -0.424332, 1.000000, 0.000000, 0.000000, -0.151297, -5.489894},
{0.327406, 0.286247, -0.425791, 1.000000, 0.000000, 0.000000, -0.155749, -5.789432},
{0.139169, 0.375207, -0.459657, -0.810511, -0.264229, -0.522691, 1.645303, -7.199225},
{0.139169, 0.286223, -0.460596, -0.848018, 0.003479, -0.529923, 1.642740, -6.899703},
{0.139169, 0.286247, -0.425791, -1.000000, 0.000000, 0.000000, 1.769424, -6.900216},
{0.139169, 0.375234, -0.424332, -0.935759, -0.352580, 0.000244, 1.774271, -7.199755},
{0.136920, 0.377795, -0.424277, -0.468825, -0.883267, 0.000641, 1.775026, -7.213129},
{0.136920, 0.377769, -0.459624, -0.469649, -0.686605, -0.554918, 1.645421, -7.212601},
{0.145088, 0.391668, -0.467104, -0.149266, -0.126835, -0.980621, 1.613008, -7.212473},
{0.150667, 0.375203, -0.466310, -0.269570, -0.062410, -0.960936, 1.613046, -7.199097},
{0.150667, 0.286219, -0.466545, -0.250740, 0.003662, -0.968017, 1.613900, -6.899587},
{0.327406, 0.375576, 0.033782, 0.949889, -0.006836, 0.312479, 1.514415, -5.483052},
{0.327406, 0.286560, 0.033527, 0.943205, -0.002777, 0.332102, 1.514341, -5.782687},
{0.327406, 0.286534, -0.010783, 1.000000, 0.000000, 0.000000, 1.353231, -5.783321},
{0.327406, 0.375547, -0.011364, 1.000000, 0.000000, 0.000000, 1.350264, -5.483706},
{0.315374, 0.375616, 0.050368, 0.536027, -0.019257, 0.843959, 1.591476, -5.482764},
{0.315374, 0.286285, 0.049041, 0.512436, -0.011750, 0.858608, 1.586431, -5.782419},
{0.139169, 0.375576, 0.033782, -0.905789, -0.285287, 0.313181, 3.439456, -7.206595},
{0.139169, 0.286560, 0.033527, -0.946806, -0.002686, 0.321726, 3.439382, -6.906959},
{0.150667, 0.286285, 0.049041, -0.525407, -0.011658, 0.850734, 3.511475, -6.907228},
{0.150666, 0.375616, 0.050368, -0.521104, -0.132633, 0.843104, 3.516519, -7.206882},
{0.145088, 0.392028, 0.052618, -0.303598, -0.269814, 0.913785, 3.517137, -7.220215},
{0.136920, 0.378129, 0.033870, -0.550523, -0.754204, 0.357799, 3.439846, -7.219928},
{0.136920, 0.378101, -0.011309, -0.468093, -0.883663, 0.000580, 3.276582, -7.219280},
{0.139169, 0.375547, -0.011364, -0.935514, -0.353191, 0.000214, 3.275831, -7.205943},
{0.139169, 0.286534, -0.010783, -1.000000, 0.000000, 0.000000, 3.278403, -6.906324},
{0.130173, 0.463596, -0.468528, -0.007660, 0.002380, -0.999939, -0.639684, -4.034940},
{0.148418, 0.463596, -0.468528, -0.012055, 0.008606, -0.999878, -0.639887, -4.106386},
{0.145088, 0.391668, -0.467104, -0.149266, -0.126835, -0.980621, -0.951850, -4.060330},
{0.130173, 0.399864, -0.466300, -0.051851, -0.175970, -0.983001, -0.948670, -4.033919},
{0.042926, 0.399864, -0.466299, 0.000000, -0.169134, -0.985565, -0.947696, -3.692265},
{0.042926, 0.463596, -0.468528, 0.000000, 0.000183, -1.000000, -0.638711, -3.693286},
{0.042926, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.329725, -3.694307},
{0.130173, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.330698, -4.035961},
{0.148418, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.330902, -4.107407},
{-0.200822, 0.463596, -0.468528, 0.000000, 0.000183, -1.000000, -0.635992, -2.738778},
{-0.200822, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.327007, -2.739799},
{-0.200822, 0.399863, -0.466300, 0.000000, -0.169134, -0.985565, -0.944977, -2.737757},
{0.130173, 0.463781, 0.058292, -0.026490, -0.030457, 0.999176, -3.563254, 1.079244},
{0.148417, 0.463798, 0.058638, -0.051485, -0.010895, 0.998596, -3.562948, 1.150690},
{0.148417, 0.527381, 0.055382, -0.008942, 0.334086, 0.942473, -3.254531, 1.149671},
{0.130173, 0.527377, 0.055296, -0.003601, 0.330058, 0.943937, -3.254735, 1.078224},
{0.042926, 0.527377, 0.055296, 0.000000, 0.329264, 0.944212, -3.255709, 0.736570},
{0.042926, 0.463781, 0.058292, 0.000000, -0.036409, 0.999329, -3.564227, 0.737590},
{0.042926, 0.400184, 0.050626, 0.000000, -0.383801, 0.923399, -3.872745, 0.738609},
{0.130173, 0.400184, 0.050626, -0.110904, -0.387585, 0.915098, -3.871772, 1.080264},
{0.145088, 0.392028, 0.052618, -0.303598, -0.269814, 0.913785, -3.874794, 1.106695},
{-0.200822, 0.463781, 0.058292, 0.000000, -0.036409, 0.999329, -3.566947, -0.216918},
{-0.200822, 0.527377, 0.055296, 0.000000, 0.329264, 0.944212, -3.258429, -0.217937},
{-0.200822, 0.400184, 0.050626, 0.000000, -0.383801, 0.923399, -3.875464, -0.215898},
{0.130173, 0.548575, -0.459519, 0.000000, 0.807154, -0.590289, -0.278974, -4.026642},
{0.148418, 0.548575, -0.459519, 0.000000, 0.807154, -0.590289, -0.279178, -4.098087},
{0.148418, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.311934, -4.097978},
{0.130173, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.311730, -4.026533},
{0.042926, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.310757, -3.684880},
{0.042926, 0.548575, -0.459519, 0.000000, 0.807154, -0.590289, -0.278001, -3.684988},
{0.042926, 0.548575, -0.423734, 0.000000, 1.000000, 0.000000, -0.147884, -3.685417},
{0.130173, 0.548575, -0.423734, 0.000000, 1.000000, 0.000000, -0.148857, -4.027072},
{0.148417, 0.548575, -0.423734, 0.000000, 1.000000, 0.000000, -0.149061, -4.098517},
{-0.200822, 0.548575, -0.459520, 0.000000, 0.807154, -0.590289, -0.275282, -2.730480},
{-0.200822, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.308038, -2.730372},
{-0.200822, 0.548575, -0.423734, 0.000000, 1.000000, 0.000000, -0.145165, -2.730910},
{0.130173, 0.378623, -0.459614, -0.092380, -0.809687, -0.579516, 1.679059, 1.824680},
{0.136920, 0.377769, -0.459624, -0.469649, -0.686605, -0.554918, 1.679160, 1.859908},
{0.136920, 0.377795, -0.424277, -0.468825, -0.883267, 0.000641, 1.808765, 1.859481},
{0.130173, 0.378648, -0.424258, -0.062868, -0.998016, 0.000702, 1.808138, 1.824254},
{0.042926, 0.378648, -0.424258, 0.000000, -0.999969, 0.000702, 1.806771, 1.482601},
{0.042926, 0.378623, -0.459614, 0.000000, -0.806513, -0.591205, 1.678086, 1.483026},
{0.042926, 0.399864, -0.466299, 0.000000, -0.169134, -0.985565, 1.645672, 1.483133},
{0.130173, 0.399864, -0.466300, -0.051851, -0.175970, -0.983001, 1.646645, 1.824787},
{0.145088, 0.391668, -0.467104, -0.149266, -0.126835, -0.980621, 1.646746, 1.860015},
{-0.200822, 0.378623, -0.459614, 0.000000, -0.806513, -0.591205, 1.675367, 0.528519},
{-0.200822, 0.378648, -0.424258, 0.000000, -0.999969, 0.000702, 1.803920, 0.528094},
{-0.200822, 0.399863, -0.466300, 0.000000, -0.169134, -0.985565, 1.642953, 0.528626},
{0.130173, 0.548575, 0.040035, -0.000549, 0.890164, 0.455611, 1.537420, -4.032643},
{0.148417, 0.548575, 0.040035, -0.001373, 0.890957, 0.454054, 1.537216, -4.104090},
{0.148417, 0.548575, -0.005626, 0.000000, 1.000000, 0.000000, 1.371194, -4.103540},
{0.130173, 0.548575, -0.005626, 0.000000, 1.000000, 0.000000, 1.371397, -4.032094},
{0.042926, 0.548575, -0.005626, 0.000000, 1.000000, 0.000000, 1.372371, -3.690440},
{0.042926, 0.548575, 0.040035, 0.000000, 0.890011, 0.455916, 1.538393, -3.690989},
{0.042926, 0.527377, 0.055296, 0.000000, 0.329264, 0.944212, 1.616181, -3.691246},
{0.130173, 0.527377, 0.055296, -0.003601, 0.330058, 0.943937, 1.615208, -4.032901},
{0.148417, 0.527381, 0.055382, -0.008942, 0.334086, 0.942473, 1.615005, -4.104347},
{-0.200822, 0.548575, 0.040035, 0.000000, 0.890011, 0.455916, 1.541112, -2.736481},
{-0.200822, 0.548575, -0.005626, 0.000000, 1.000000, 0.000000, 1.375090, -2.735932},
{-0.200822, 0.527377, 0.055296, 0.000000, 0.329264, 0.944212, 1.618900, -2.736738},
{0.130173, 0.378980, 0.033900, -0.125584, -0.901730, 0.413556, 3.473490, 1.818751},
{0.136920, 0.378129, 0.033870, -0.550523, -0.754204, 0.357799, 3.473591, 1.853980},
{0.145088, 0.392028, 0.052618, -0.303598, -0.269814, 0.913785, 3.550881, 1.853726},
{0.130173, 0.400184, 0.050626, -0.110904, -0.387585, 0.915098, 3.550781, 1.818496},
{0.042926, 0.400184, 0.050626, 0.000000, -0.383801, 0.923399, 3.549808, 1.476841},
{0.042926, 0.378980, 0.033900, 0.000000, -0.899655, 0.436537, 3.472517, 1.477096},
{0.042926, 0.378952, -0.011291, 0.000000, -0.999969, 0.000641, 3.308332, 1.477638},
{0.130173, 0.378952, -0.011291, -0.062685, -0.998016, 0.000641, 3.309700, 1.819292},
{0.136920, 0.378101, -0.011309, -0.468093, -0.883663, 0.000580, 3.310328, 1.854519},
{-0.200822, 0.378979, 0.033900, 0.000000, -0.899655, 0.436537, 3.469797, 0.522589},
{-0.200822, 0.400184, 0.050626, 0.000000, -0.383801, 0.923399, 3.547088, 0.522334},
{-0.200822, 0.378952, -0.011291, 0.000000, -0.999969, 0.000641, 3.305481, 0.523132},
{0.327407, -0.327847, -0.466987, 0.633564, -0.338511, -0.695669, -0.299665, -7.852051},
{0.315375, -0.336361, -0.467010, 0.319315, -0.719626, -0.616535, -0.299683, -7.884369},
{0.306016, -0.336048, -0.467853, 0.066134, -0.173467, -0.982604, -0.305176, -7.884387},
{0.315375, -0.329010, -0.468143, 0.063692, -0.048738, -0.996765, -0.305269, -7.852072},
{0.315375, -0.235526, -0.467910, 0.099490, 0.003754, -0.995025, -0.306162, -7.538357},
{0.327407, -0.235234, -0.466057, 0.767968, 0.004059, -0.640431, -0.297178, -7.538321},
{0.327407, -0.235227, -0.434275, 1.000000, 0.000000, 0.000000, -0.181478, -7.537910},
{0.327407, -0.327845, -0.435805, 0.888363, -0.459120, -0.000031, -0.185738, -7.851665},
{0.315375, -0.336371, -0.435912, 0.418317, -0.908292, -0.000427, -0.185710, -7.883991},
{0.327406, 0.026099, -0.463328, 0.808863, 0.003845, -0.587939, -0.289752, -6.661764},
{0.315374, 0.026096, -0.467228, 0.172674, 0.003784, -0.984954, -0.308659, -6.661841},
{0.327406, 0.026115, -0.430021, 1.000000, 0.000000, 0.000000, -0.168646, -6.661301},
{0.139169, 0.026099, -0.463328, -0.812799, 0.003784, -0.582507, 1.635289, -6.027884},
{0.150667, 0.026096, -0.467228, -0.180029, 0.003784, -0.983642, 1.616382, -6.027807},
{0.150667, -0.235526, -0.467910, -0.103977, 0.003754, -0.994568, 1.618878, -5.151293},
{0.139169, -0.235234, -0.466057, -0.770592, 0.004059, -0.637287, 1.627863, -5.151329},
{0.139169, -0.235227, -0.434275, -1.000000, 0.000000, 0.000000, 1.743563, -5.151738},
{0.139169, 0.026115, -0.430021, -1.000000, 0.000000, 0.000000, 1.756396, -6.028346},
{0.139169, -0.327847, -0.466987, -0.640461, -0.332560, -0.692221, 1.625376, -4.837597},
{0.150667, -0.329010, -0.468143, -0.066622, -0.048738, -0.996582, 1.619772, -4.837576},
{0.159609, -0.336048, -0.467853, -0.069185, -0.173406, -0.982391, 1.619865, -4.805259},
{0.150667, -0.336361, -0.467010, -0.330882, -0.714621, -0.616260, 1.625358, -4.805277},
{0.150667, -0.336371, -0.435912, -0.433027, -0.901364, -0.000427, 1.739331, -4.805654},
{0.139169, -0.327845, -0.435805, -0.893246, -0.449507, -0.000031, 1.739304, -4.837983},
{0.327407, -0.327815, 0.030352, 0.787317, -0.475417, 0.392499, 1.508676, -7.845948},
{0.315375, -0.336511, 0.029186, 0.398328, -0.895383, 0.199011, 1.501583, -7.878420},
{0.315375, -0.336502, -0.009250, 0.426588, -0.904416, -0.000366, 1.363139, -7.878877},
{0.327407, -0.327818, -0.008177, 0.890194, -0.455519, -0.000031, 1.369133, -7.846418},
{0.327407, -0.235146, -0.007443, 1.000000, 0.000000, 0.000000, 1.370492, -7.532460},
{0.327407, -0.235138, 0.032001, 0.903104, -0.007233, 0.429334, 1.513777, -7.531959},
{0.315375, -0.237304, 0.041275, 0.391552, -0.019684, 0.919919, 1.556978, -7.531810},
{0.315375, -0.330297, 0.038564, 0.371197, -0.381085, 0.846736, 1.546957, -7.845820},
{0.306016, -0.336830, 0.035655, 0.313730, -0.783197, 0.536790, 1.539703, -7.878293},
{0.327406, 0.026321, 0.032997, 0.926145, -0.003357, 0.377117, 1.514897, -6.654930},
{0.327406, 0.026304, -0.008894, 1.000000, 0.000000, 0.000000, 1.362582, -6.655500},
{0.315375, 0.025101, 0.045388, 0.456496, -0.012360, 0.889615, 1.572534, -6.654721},
{0.139169, 0.026321, 0.032997, -0.930326, -0.003265, 0.366680, 3.439939, -6.034716},
{0.139169, 0.026304, -0.008894, -1.000000, 0.000000, 0.000000, 3.287623, -6.034144},
{0.139169, -0.235146, -0.007443, -1.000000, 0.000000, 0.000000, 3.295533, -5.157185},
{0.139169, -0.235139, 0.032001, -0.907804, -0.007080, 0.419294, 3.438819, -5.157687},
{0.150667, -0.237304, 0.041275, -0.404340, -0.019593, 0.914396, 3.482020, -5.157839},
{0.150667, 0.025101, 0.045388, -0.469527, -0.012329, 0.882809, 3.497577, -6.034926},
{0.139169, -0.327815, 0.030352, -0.796899, -0.465987, 0.384411, 3.433717, -4.843699},
{0.139169, -0.327818, -0.008177, -0.895108, -0.445814, -0.000031, 3.294174, -4.843228},
{0.150667, -0.336502, -0.009250, -0.441481, -0.897244, -0.000366, 3.288180, -4.810773},
{0.150667, -0.336511, 0.029186, -0.412915, -0.889035, 0.197699, 3.426624, -4.811230},
{0.159609, -0.336830, 0.035655, -0.326456, -0.779565, 0.534471, 3.464746, -4.811356},
{0.150667, -0.330297, 0.038564, -0.384594, -0.378979, 0.841670, 3.471999, -4.843828},
{0.279279, 0.463596, -0.468528, 0.034059, 0.019410, -0.999207, -0.641347, -4.618833},
{0.315374, 0.463597, -0.466288, 0.266518, 0.035340, -0.963164, -0.641884, -4.807300},
{0.315374, 0.399009, -0.466299, 0.280618, 0.000427, -0.959807, -0.876728, -4.806524},
{0.279279, 0.399008, -0.468528, 0.030824, 0.000061, -0.999512, -0.876191, -4.618057},
{0.231685, 0.399008, -0.468528, 0.000000, 0.000000, -1.000000, -0.875660, -4.431682},
{0.231685, 0.463596, -0.468528, 0.000000, 0.017640, -0.999817, -0.640816, -4.432457},
{0.231685, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.331831, -4.433478},
{0.279279, 0.527330, -0.466276, 0.063662, 0.159795, -0.985076, -0.332362, -4.619853},
{0.306016, 0.510807, -0.464530, 0.227638, 0.131993, -0.964721, -0.332898, -4.808321},
{0.185160, 0.463596, -0.468528, -0.004395, 0.015137, -0.999847, -0.640297, -4.250267},
{0.185160, 0.399008, -0.468528, -0.015931, -0.009003, -0.999817, -0.875141, -4.249491},
{0.185160, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.331312, -4.251287},
{0.279279, 0.463850, 0.059673, 0.102664, 0.024873, 0.994385, -3.561185, 1.663136},
{0.315374, 0.463797, 0.053306, 0.514420, 0.046266, 0.856258, -3.561054, 1.851604},
{0.306016, 0.510896, 0.050687, 0.456374, 0.246986, 0.854793, -3.252535, 1.850585},
{0.279279, 0.527394, 0.055641, 0.148778, 0.319376, 0.935850, -3.253072, 1.662118},
{0.231685, 0.527402, 0.055814, -0.000061, 0.345317, 0.938475, -3.253603, 1.475743},
{0.231685, 0.463884, 0.060363, -0.000153, 0.025147, 0.999664, -3.561513, 1.476760},
{0.231685, 0.399515, 0.059520, -0.000244, -0.018830, 0.999817, -3.795543, 1.477533},
{0.279279, 0.399455, 0.058312, 0.107212, -0.023316, 0.993957, -3.795367, 1.663909},
{0.315374, 0.399363, 0.051185, 0.536210, -0.025880, 0.843654, -3.795541, 1.852379},
{0.185160, 0.463850, 0.059673, -0.032411, 0.013886, 0.999359, -3.562234, 1.294570},
{0.185160, 0.527394, 0.055641, -0.008179, 0.341319, 0.939879, -3.254122, 1.293552},
{0.185160, 0.399455, 0.058312, -0.073428, -0.045412, 0.996246, -3.796417, 1.295344},
{0.279279, 0.548575, -0.459520, 0.217261, 0.766717, -0.604083, -0.280637, -4.610534},
{0.315374, 0.527331, -0.459531, 0.668966, 0.446944, -0.593860, -0.281174, -4.799001},
{0.306016, 0.510807, -0.464530, 0.227638, 0.131993, -0.964721, -0.313930, -4.798893},
{0.279279, 0.527330, -0.466276, 0.063662, 0.159795, -0.985076, -0.313393, -4.610426},
{0.231685, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.312862, -4.424051},
{0.231685, 0.548575, -0.459520, 0.000000, 0.807154, -0.590289, -0.280106, -4.424159},
{0.231685, 0.548575, -0.423734, 0.000000, 1.000000, 0.000000, -0.149857, -4.424589},
{0.279279, 0.548575, -0.423734, 0.262795, 0.964843, 0.000000, -0.149987, -4.610966},
{0.315374, 0.527334, -0.423800, 0.818049, 0.575121, -0.000031, -0.149991, -4.799435},
{0.185160, 0.548575, -0.459519, 0.000000, 0.807154, -0.590289, -0.279587, -4.241968},
{0.185160, 0.527330, -0.466276, 0.000000, 0.170751, -0.985290, -0.312343, -4.241859},
{0.185160, 0.548575, -0.423734, 0.000000, 1.000000, 0.000000, -0.149471, -4.242398},
{0.279279, -0.345397, -0.467017, 0.138615, -0.798273, -0.586108, -2.743075, -4.814805},
{0.315375, -0.336361, -0.467010, 0.319315, -0.719626, -0.616535, -2.568081, -4.814238},
{0.315375, -0.336371, -0.435912, 0.418317, -0.908292, -0.000427, -2.567731, -4.936985},
{0.279279, -0.345436, -0.435896, 0.171331, -0.985198, -0.001160, -2.742726, -4.937266},
{0.231685, -0.350104, -0.435857, -0.001099, -0.999969, -0.001587, -2.915779, -4.937690},
{0.231685, -0.350046, -0.467017, -0.000885, -0.806879, -0.590686, -2.916126, -4.815371},
{0.231685, -0.346239, -0.468150, -0.000153, -0.172857, -0.984924, -2.916143, -4.809455},
{0.279279, -0.342172, -0.468150, 0.032716, -0.178655, -0.983337, -2.743092, -4.808889},
{0.306016, -0.336048, -0.467853, 0.066134, -0.173467, -0.982604, -2.568098, -4.808322},
{0.185160, -0.345397, -0.467017, -0.143925, -0.797357, -0.586047, -3.085294, -4.815935},
{0.185160, -0.345436, -0.435896, -0.177831, -0.984039, -0.001160, -3.084945, -4.938397},
{0.150667, -0.336371, -0.435912, -0.433027, -0.901364, -0.000427, -3.252170, -4.939245},
{0.150667, -0.336361, -0.467010, -0.330882, -0.714621, -0.616260, -3.252519, -4.816498},
{0.159609, -0.336048, -0.467853, -0.069185, -0.173406, -0.982391, -3.252535, -4.810581},
{0.185160, -0.342172, -0.468150, -0.034028, -0.178625, -0.983306, -3.085310, -4.810019},
{0.279279, 0.548575, 0.040035, 0.251503, 0.849971, 0.462844, 1.535757, -4.616536},
{0.231685, 0.548575, 0.040035, 0.000000, 0.893124, 0.449782, 1.536288, -4.430161},
{0.231685, 0.527402, 0.055814, -0.000061, 0.345317, 0.938475, 1.614076, -4.430418},
{0.279279, 0.527394, 0.055641, 0.148778, 0.319376, 0.935850, 1.613545, -4.616793},
{0.315374, 0.527376, 0.039268, 0.759636, 0.491165, 0.426221, 1.535220, -4.805003},
{0.315374, 0.527372, -0.006334, 0.817743, 0.575549, -0.000031, 1.370264, -4.804459},
{0.279279, 0.548575, -0.005626, 0.262429, 0.964934, 0.000000, 1.370267, -4.615989},
{0.231685, 0.548575, -0.005626, 0.000000, 1.000000, 0.000000, 1.370399, -4.429612},
{0.185160, 0.548575, 0.040035, -0.001251, 0.892361, 0.451308, 1.536807, -4.247971},
{0.185160, 0.548575, -0.005626, 0.000000, 1.000000, 0.000000, 1.370784, -4.247422},
{0.185160, 0.527394, 0.055641, -0.008179, 0.341319, 0.939879, 1.614595, -4.248228},
{0.279279, -0.346029, 0.029639, 0.182012, -0.974822, 0.128758, -2.737534, -6.759690},
{0.315375, -0.336511, 0.029186, 0.398328, -0.895383, 0.199011, -2.562554, -6.754177},
{0.306016, -0.336830, 0.035655, 0.313730, -0.783197, 0.536790, -2.562437, -6.795233},
{0.279279, -0.343957, 0.038007, 0.170385, -0.807031, 0.565355, -2.737418, -6.800747},
{0.231685, -0.348921, 0.038639, -0.001038, -0.817499, 0.575884, -2.910463, -6.803787},
{0.231685, -0.350993, 0.030270, -0.001190, -0.992706, 0.120365, -2.910579, -6.762731},
{0.231685, -0.350933, -0.008227, -0.001160, -0.999969, -0.001434, -2.911008, -6.612272},
{0.279279, -0.345989, -0.008819, 0.178961, -0.983825, -0.001038, -2.737962, -6.609684},
{0.315375, -0.336502, -0.009250, 0.426588, -0.904416, -0.000366, -2.562978, -6.605074},
{0.185160, -0.346029, 0.029639, -0.188849, -0.973540, 0.128574, -3.079753, -6.760823},
{0.185160, -0.343957, 0.038007, -0.176916, -0.806024, 0.564776, -3.079637, -6.801879},
{0.159609, -0.336830, 0.035655, -0.326456, -0.779565, 0.534471, -3.246875, -6.797496},
{0.150667, -0.336511, 0.029186, -0.412915, -0.889035, 0.197699, -3.246992, -6.756440},
{0.150667, -0.336502, -0.009250, -0.441481, -0.897244, -0.000366, -3.247416, -6.607338},
{0.185160, -0.345989, -0.008819, -0.185705, -0.982574, -0.001038, -3.080181, -6.610816},
{0.279279, 0.375202, -0.468528, 0.029878, 0.000366, -0.999542, -0.962752, -4.617771},
{0.315374, 0.375203, -0.466310, 0.273507, 0.002136, -0.961852, -0.963289, -4.806239},
{0.315374, 0.286219, -0.466545, 0.241096, 0.003693, -0.970489, -1.241388, -4.805321},
{0.279279, 0.286217, -0.468528, 0.025880, 0.000641, -0.999664, -1.240852, -4.616853},
{0.231685, 0.286217, -0.468528, 0.000000, 0.000000, -1.000000, -1.240321, -4.430477},
{0.231685, 0.375202, -0.468528, 0.000000, 0.000000, -1.000000, -0.962221, -4.431396},
{0.185160, 0.375202, -0.468528, -0.026734, -0.006165, -0.999603, -0.961702, -4.249205},
{0.185160, 0.286217, -0.468528, -0.027070, 0.000641, -0.999603, -1.239802, -4.248286},
{0.150667, 0.286219, -0.466545, -0.250740, 0.003662, -0.968017, -1.239289, -4.068187},
{0.150667, 0.375203, -0.466310, -0.269570, -0.062410, -0.960936, -0.961189, -4.069106},
{0.279279, 0.375721, 0.057737, 0.111850, -0.021790, 0.993469, -3.881688, 1.664194},
{0.315374, 0.375616, 0.050368, 0.536027, -0.019257, 0.843959, -3.881963, 1.852664},
{0.231685, 0.375790, 0.059118, -0.000305, -0.020508, 0.999786, -3.881813, 1.477818},
{0.231685, 0.284886, 0.057215, -0.000275, -0.020051, 0.999786, -4.166968, 1.478761},
{0.279279, 0.285447, 0.055928, 0.104404, -0.018433, 0.994354, -4.164546, 1.665129},
{0.315374, 0.286285, 0.049041, 0.512436, -0.011750, 0.858608, -4.160226, 1.853583},
{0.185160, 0.375721, 0.057737, -0.105838, -0.037568, 0.993652, -3.882737, 1.295629},
{0.150666, 0.375616, 0.050368, -0.521104, -0.132633, 0.843104, -3.884061, 1.115533},
{0.150667, 0.286285, 0.049041, -0.525407, -0.011658, 0.850734, -4.162325, 1.116453},
{0.185160, 0.285447, 0.055928, -0.108829, -0.018433, 0.993866, -4.165596, 1.296564},
{0.279279, 0.026095, -0.468528, 0.017975, 0.000641, -0.999817, -2.050312, -4.614178},
{0.315374, 0.026096, -0.467228, 0.172674, 0.003784, -0.984954, -2.050848, -4.802646},
{0.315375, -0.235526, -0.467910, 0.099490, 0.003754, -0.995025, -2.864705, -4.799956},
{0.279279, -0.236398, -0.468528, 0.010071, 0.000610, -0.999939, -2.868394, -4.611475},
{0.231685, -0.236979, -0.468528, 0.000000, 0.000000, -1.000000, -2.869976, -4.425093},
{0.231685, 0.026095, -0.468528, 0.000000, 0.000000, -1.000000, -2.049781, -4.427803},
{0.185160, 0.026095, -0.468528, -0.018799, 0.000641, -0.999817, -2.049262, -4.245612},
{0.185160, -0.236398, -0.468528, -0.010529, 0.000610, -0.999939, -2.867344, -4.242909},
{0.150667, -0.235526, -0.467910, -0.103977, 0.003754, -0.994568, -2.862606, -4.062824},
{0.150667, 0.026096, -0.467228, -0.180029, 0.003784, -0.983642, -2.048749, -4.065513},
{0.279279, -0.332496, -0.468528, 0.008667, -0.021180, -0.999725, -3.172360, -4.610471},
{0.315375, -0.329010, -0.468143, 0.063692, -0.048738, -0.996765, -3.155996, -4.798993},
{0.306016, -0.336048, -0.467853, 0.066134, -0.173467, -0.982604, -3.186003, -4.798893},
{0.279279, -0.342172, -0.468150, 0.032716, -0.178655, -0.983337, -3.219269, -4.610316},
{0.231685, -0.346239, -0.468150, -0.000153, -0.172857, -0.984924, -3.235640, -4.423886},
{0.231685, -0.334820, -0.468528, 0.000000, -0.017884, -0.999817, -3.180280, -4.424068},
{0.185160, -0.332496, -0.468528, -0.009064, -0.021180, -0.999725, -3.171310, -4.241905},
{0.185160, -0.342172, -0.468150, -0.034028, -0.178625, -0.983306, -3.218219, -4.241751},
{0.159609, -0.336048, -0.467853, -0.069185, -0.173406, -0.982391, -3.183903, -4.061763},
{0.150667, -0.329010, -0.468143, -0.066622, -0.048738, -0.996582, -3.153896, -4.061862},
{0.279279, -0.337743, 0.042144, 0.106510, -0.315134, 0.943022, -6.112943, 1.671568},
{0.315375, -0.330297, 0.038564, 0.371197, -0.381085, 0.846736, -6.076466, 1.859915},
{0.315375, -0.237304, 0.041275, 0.391552, -0.019684, 0.919919, -5.784739, 1.858951},
{0.279279, -0.243806, 0.045333, 0.070528, -0.026276, 0.997131, -5.816621, 1.670589},
{0.231685, -0.248141, 0.046058, -0.000214, -0.027802, 0.999603, -5.832824, 1.484266},
{0.231685, -0.342707, 0.042775, -0.000488, -0.305490, 0.952178, -6.131444, 1.485253},
{0.231685, -0.348921, 0.038639, -0.001038, -0.817499, 0.575884, -6.161787, 1.485353},
{0.279279, -0.343957, 0.038007, 0.170385, -0.807031, 0.565355, -6.143285, 1.671668},
{0.306016, -0.336830, 0.035655, 0.313730, -0.783197, 0.536790, -6.106808, 1.860015},
{0.185160, -0.337743, 0.042144, -0.110813, -0.314859, 0.942625, -6.113993, 1.303003},
{0.185160, -0.243806, 0.045333, -0.073550, -0.026276, 0.996918, -5.817670, 1.302023},
{0.150667, -0.237304, 0.041275, -0.404340, -0.019593, 0.914396, -5.786838, 1.121820},
{0.150667, -0.330297, 0.038564, -0.384594, -0.378979, 0.841670, -6.078567, 1.122784},
{0.159609, -0.336830, 0.035655, -0.326456, -0.779565, 0.534471, -6.108909, 1.122885},
{0.185160, -0.343957, 0.038007, -0.176916, -0.806024, 0.564776, -6.144336, 1.303103},
{0.279279, 0.021430, 0.050860, 0.087039, -0.018860, 0.996002, -4.988339, 1.667852},
{0.315375, 0.025101, 0.045388, 0.456496, -0.012360, 0.889615, -4.970238, 1.856260},
{0.231685, 0.018983, 0.051867, -0.000244, -0.020447, 0.999786, -4.997652, 1.481506},
{0.185160, 0.021430, 0.050860, -0.090762, -0.018860, 0.995666, -4.989389, 1.299286},
{0.150667, 0.025101, 0.045388, -0.469527, -0.012329, 0.882809, -4.972337, 1.119129},
{-1.230800, -0.345869, -0.103222, 0.184027, -0.982910, -0.001160, -6.025276, -5.371676},
{-1.277326, -0.350754, -0.102750, 0.001160, -0.999969, -0.001587, -5.856107, -5.371575},
{-1.277326, -0.350516, -0.224680, 0.001129, -0.999969, -0.001617, -5.857466, -5.848455},
{-1.230800, -0.345711, -0.224993, 0.181768, -0.983337, -0.001190, -6.026631, -5.847343},
{-1.196307, -0.336436, -0.225216, 0.437269, -0.899319, -0.000427, -6.193852, -5.845686},
{-1.196307, -0.336474, -0.103565, 0.439711, -0.898129, -0.000427, -6.192505, -5.372443},
{-1.230800, -0.345554, -0.345553, 0.179510, -0.983734, -0.001190, -6.027979, -6.320632},
{-1.277325, -0.350280, -0.345397, 0.001129, -0.999969, -0.001617, -5.858813, -6.321767},
{-1.196307, -0.336399, -0.345656, 0.434828, -0.900479, -0.000427, -6.195200, -6.318929},
{-1.324919, -0.345869, -0.103222, -0.177343, -0.984130, -0.001160, -5.683057, -5.372808},
{-1.361015, -0.336473, -0.103565, -0.424848, -0.905240, -0.000427, -5.508066, -5.374706},
{-1.361015, -0.336436, -0.225216, -0.422437, -0.906369, -0.000427, -5.509415, -5.847949},
{-1.324919, -0.345711, -0.224993, -0.175146, -0.984527, -0.001190, -5.684412, -5.848475},
{-1.324919, -0.345554, -0.345553, -0.172948, -0.984924, -0.001190, -5.685760, -6.321764},
{-1.361015, -0.336398, -0.345656, -0.420057, -0.907468, -0.000427, -5.510764, -6.321191},
{-1.230800, 0.548575, -0.334396, 0.000000, 1.000000, 0.000000, 0.191162, 1.301373},
{-1.277325, 0.548575, -0.334396, 0.000000, 1.000000, 0.000000, 0.192214, 1.483561},
{-1.277325, 0.548575, -0.217694, 0.000000, 1.000000, 0.000000, 0.616811, 1.482159},
{-1.230800, 0.548575, -0.217694, 0.000000, 1.000000, 0.000000, 0.615492, 1.299971},
{-1.194058, 0.548575, -0.217694, 0.000000, 1.000000, 0.000000, 0.615082, 1.156090},
{-1.194058, 0.548575, -0.334396, 0.000000, 1.000000, 0.000000, 0.190752, 1.157492},
{-1.230800, 0.548575, -0.099820, 0.000000, 1.000000, 0.000000, 1.044088, 1.298555},
{-1.277325, 0.548575, -0.099820, 0.000000, 1.000000, 0.000000, 1.045140, 1.480744},
{-1.194058, 0.548575, -0.099820, 0.000000, 1.000000, 0.000000, 1.043677, 1.154674},
{-1.324919, 0.548575, -0.334396, -0.262703, 0.964843, 0.000000, 0.194344, 1.669930},
{-1.361015, 0.527342, -0.334599, -0.817957, 0.575213, -0.000031, 0.197013, 1.858390},
{-1.361015, 0.527353, -0.218078, -0.817896, 0.575335, -0.000031, 0.623476, 1.856981},
{-1.324919, 0.548575, -0.217694, -0.262612, 0.964873, 0.000000, 0.619741, 1.668525},
{-1.324919, 0.548575, -0.099820, -0.262520, 0.964904, 0.000000, 1.047270, 1.667113},
{-1.361015, 0.527364, -0.100386, -0.817805, 0.575457, -0.000031, 1.049938, 1.855572},
{-1.184809, -0.327839, -0.345342, 0.893643, -0.448714, -0.000031, -4.699793, -7.189439},
{-1.184809, -0.235210, -0.343869, 1.000000, 0.000000, 0.000000, -4.696980, -6.875643},
{-1.184809, -0.235187, -0.223547, 1.000000, 0.000000, 0.000000, -4.259211, -6.874107},
{-1.184809, -0.327832, -0.224631, 0.894162, -0.447676, -0.000031, -4.259786, -7.187955},
{-1.196307, -0.336436, -0.225216, 0.437269, -0.899319, -0.000427, -4.259996, -7.220337},
{-1.196307, -0.336399, -0.345656, 0.434828, -0.900479, -0.000427, -4.699409, -7.221788},
{-1.184809, -0.327824, -0.102707, 0.894711, -0.446608, -0.000031, -3.817565, -7.186462},
{-1.184809, -0.235164, -0.102016, 1.000000, 0.000000, 0.000000, -3.817594, -6.872558},
{-1.196307, -0.336474, -0.103565, 0.439711, -0.898129, -0.000427, -3.820583, -7.218884},
{-1.184809, 0.026155, -0.340498, 1.000000, 0.000000, 0.000000, -4.687771, -5.998957},
{-1.184809, 0.286308, -0.337239, 1.000000, 0.000000, 0.000000, -4.677877, -5.127016},
{-1.184809, 0.286389, -0.221231, 1.000000, 0.000000, 0.000000, -4.255806, -5.125305},
{-1.184809, 0.026208, -0.222274, 1.000000, 0.000000, 0.000000, -4.257904, -5.997329},
{-1.184809, 0.026262, -0.102862, 1.000000, 0.000000, 0.000000, -3.823718, -5.995685},
{-1.184809, 0.286470, -0.104057, 1.000000, 0.000000, 0.000000, -3.830022, -5.123580},
{-1.373047, 0.026155, -0.340498, -1.000000, 0.000000, 0.000000, -1.770077, -6.032641},
{-1.373047, -0.235210, -0.343869, -1.000000, 0.000000, 0.000000, -1.779286, -5.155954},
{-1.373047, -0.235187, -0.223547, -1.000000, 0.000000, 0.000000, -1.341517, -5.157491},
{-1.373047, 0.026208, -0.222274, -1.000000, 0.000000, 0.000000, -1.340211, -6.034269},
{-1.373047, 0.286389, -0.221231, -1.000000, 0.000000, 0.000000, -1.338903, -6.906290},
{-1.373047, 0.286308, -0.337239, -1.000000, 0.000000, 0.000000, -1.760711, -6.904581},
{-1.373047, 0.026262, -0.102862, -1.000000, 0.000000, 0.000000, -0.906025, -6.035913},
{-1.373047, -0.235164, -0.102016, -1.000000, 0.000000, 0.000000, -0.899901, -5.159040},
{-1.373047, 0.286470, -0.104057, -1.000000, 0.000000, 0.000000, -0.912855, -6.908016},
{-1.373047, -0.327839, -0.345342, -0.888760, -0.458357, -0.000031, -1.782099, -4.842159},
{-1.361015, -0.336398, -0.345656, -0.420057, -0.907468, -0.000427, -1.781715, -4.809810},
{-1.361015, -0.336436, -0.225216, -0.422437, -0.906369, -0.000427, -1.342302, -4.811261},
{-1.373047, -0.327832, -0.224631, -0.889279, -0.457320, -0.000031, -1.342092, -4.843643},
{-1.373047, -0.327824, -0.102707, -0.889828, -0.456282, -0.000031, -0.899871, -4.845135},
{-1.361015, -0.336473, -0.103565, -0.424848, -0.905240, -0.000427, -0.902889, -4.812713},
{-0.844819, 0.378885, -0.104351, 0.000000, -0.999969, 0.000702, 2.959930, -1.997617},
{-1.088567, 0.378885, -0.104351, 0.000000, -0.999969, 0.000702, 2.957737, -2.952125},
{-1.088567, 0.378799, -0.220765, 0.000000, -0.999969, 0.000732, 2.534713, -2.950728},
{-0.844819, 0.378799, -0.220766, 0.000000, -0.999969, 0.000732, 2.536643, -1.996218},
{-0.522820, 0.378799, -0.220766, 0.000000, -0.999969, 0.000732, 2.540235, -0.735285},
{-0.522820, 0.378885, -0.104351, 0.000000, -0.999969, 0.000702, 2.963521, -0.736683},
{-0.844819, 0.378713, -0.336022, 0.000000, -0.999969, 0.000732, 2.117567, -1.994833},
{-1.088567, 0.378713, -0.336022, 0.000000, -0.999969, 0.000732, 2.115375, -2.949342},
{-0.522820, 0.378713, -0.336022, 0.000000, -0.999969, 0.000732, 2.121159, -0.733900},
{-1.175813, 0.378885, -0.104351, 0.062746, -0.998016, 0.000702, 2.958344, -3.293785},
{-1.182560, 0.378033, -0.104367, 0.468245, -0.883572, 0.000641, 2.960351, -3.329021},
{-1.182560, 0.377946, -0.220783, 0.468459, -0.883450, 0.000641, 2.539169, -3.327629},
{-1.175813, 0.378799, -0.220766, 0.062777, -0.998016, 0.000732, 2.536109, -3.292390},
{-1.175813, 0.378713, -0.336022, 0.062838, -0.998016, 0.000732, 2.115981, -3.291002},
{-1.182560, 0.377860, -0.336041, 0.468673, -0.883358, 0.000641, 2.117986, -3.326237},
{-0.844819, 0.548575, -0.334396, 0.000000, 1.000000, 0.000000, 0.186856, -0.210115},
{-1.088567, 0.548575, -0.334396, 0.000000, 1.000000, 0.000000, 0.189575, 0.744392},
{-1.088567, 0.548575, -0.217694, 0.000000, 1.000000, 0.000000, 0.613905, 0.742990},
{-0.844819, 0.548575, -0.217694, 0.000000, 1.000000, 0.000000, 0.611186, -0.211517},
{-0.522820, 0.548575, -0.217694, 0.000000, 1.000000, 0.000000, 0.607594, -1.472451},
{-0.522820, 0.548575, -0.334396, 0.000000, 1.000000, 0.000000, 0.183264, -1.471049},
{-0.844819, 0.548575, -0.099820, 0.000000, 1.000000, 0.000000, 1.039781, -0.212934},
{-1.088567, 0.548575, -0.099820, 0.000000, 1.000000, 0.000000, 1.042500, 0.741573},
{-0.522820, 0.548575, -0.099820, 0.000000, 1.000000, 0.000000, 1.036189, -1.473867},
{-1.175813, 0.548575, -0.334396, 0.000000, 1.000000, 0.000000, 0.190548, 1.086047},
{-1.175813, 0.548575, -0.217694, 0.000000, 1.000000, 0.000000, 0.614879, 1.084645},
{-1.175813, 0.548575, -0.099820, 0.000000, 1.000000, 0.000000, 1.043474, 1.083228},
{-1.184809, 0.375478, -0.104414, 0.935575, -0.353069, 0.000244, -3.830593, -4.823977},
{-1.184809, 0.375389, -0.220836, 0.935636, -0.352886, 0.000244, -4.252854, -4.825720},
{-1.182560, 0.377946, -0.220783, 0.468459, -0.883450, 0.000641, -4.249476, -4.812354},
{-1.182560, 0.378033, -0.104367, 0.468245, -0.883572, 0.000641, -3.828296, -4.810627},
{-1.184809, 0.375301, -0.336100, 0.935697, -0.352702, 0.000244, -4.673010, -4.827454},
{-1.182560, 0.377860, -0.336041, 0.468673, -0.883358, 0.000641, -4.670657, -4.814081},
{-1.373047, 0.375301, -0.336100, -1.000000, 0.000000, 0.000000, -1.757423, -7.204136},
{-1.373047, 0.375389, -0.220836, -1.000000, 0.000000, 0.000000, -1.338320, -7.205865},
{-1.373047, 0.399168, -0.220399, -1.000000, 0.000000, 0.000000, -1.336197, -7.298991},
{-1.373047, 0.399093, -0.335838, -1.000000, 0.000000, 0.000000, -1.756202, -7.297308},
{-1.373047, 0.375478, -0.104414, -1.000000, 0.000000, 0.000000, -0.915005, -7.207611},
{-1.373047, 0.399244, -0.103800, -1.000000, 0.000000, 0.000000, -0.912506, -7.300689},
{-1.373047, 0.463730, -0.102085, -0.995636, 0.093295, 0.000000, -0.905391, -7.553238},
{-1.361015, 0.527364, -0.100386, -0.817805, 0.575457, -0.000031, -0.895968, -7.885524},
{-1.361015, 0.527353, -0.218078, -0.817896, 0.575335, -0.000031, -1.322431, -7.884115},
{-1.373047, 0.463687, -0.219230, -0.995636, 0.093234, 0.000000, -1.330266, -7.551666},
{-1.373047, 0.463644, -0.335209, -0.995636, 0.093204, 0.000000, -1.753034, -7.550102},
{-1.361015, 0.527342, -0.334599, -0.817957, 0.575213, -0.000031, -1.748893, -7.882706},
{0.327406, 0.463730, -0.102085, 0.995636, 0.093295, 0.000000, 1.021547, -5.139467},
{0.327406, 0.399244, -0.103800, 1.000000, 0.000000, 0.000000, 1.014432, -5.392016},
{0.327406, 0.399168, -0.220399, 1.000000, 0.000000, 0.000000, 0.590741, -5.393714},
{0.327406, 0.463687, -0.219230, 0.995636, 0.093234, 0.000000, 0.596672, -5.141040},
{0.315374, 0.527353, -0.218078, 0.817896, 0.575335, -0.000031, 0.604507, -4.808593},
{0.315374, 0.527364, -0.100386, 0.817805, 0.575457, -0.000031, 1.030970, -4.807184},
{0.327406, 0.463644, -0.335209, 0.995636, 0.093204, 0.000000, 0.173904, -5.142604},
{0.327406, 0.399093, -0.335838, 1.000000, 0.000000, 0.000000, 0.170736, -5.395397},
{0.315374, 0.527342, -0.334599, 0.817957, 0.575213, -0.000031, 0.178045, -4.810001},
{0.327406, 0.375301, -0.336100, 1.000000, 0.000000, 0.000000, 0.169515, -5.488570},
{0.327406, 0.375389, -0.220836, 1.000000, 0.000000, 0.000000, 0.588618, -5.486841},
{0.327406, 0.286389, -0.221231, 1.000000, 0.000000, 0.000000, 0.588035, -5.786417},
{0.327406, 0.286308, -0.337239, 1.000000, 0.000000, 0.000000, 0.166227, -5.788126},
{0.327406, 0.375478, -0.104414, 1.000000, 0.000000, 0.000000, 1.011933, -5.485094},
{0.327406, 0.286470, -0.104057, 1.000000, 0.000000, 0.000000, 1.014083, -5.784689},
{0.139169, 0.375478, -0.104414, -0.935575, -0.353069, 0.000244, 2.939079, -7.204560},
{0.136920, 0.378033, -0.104367, -0.468245, -0.883572, 0.000641, 2.941375, -7.217913},
{0.136920, 0.377946, -0.220783, -0.468459, -0.883450, 0.000641, 2.520195, -7.216185},
{0.139169, 0.375389, -0.220836, -0.935636, -0.352886, 0.000244, 2.516817, -7.202818},
{0.139169, 0.286389, -0.221231, -1.000000, 0.000000, 0.000000, 2.513866, -6.903232},
{0.139169, 0.286470, -0.104057, -1.000000, 0.000000, 0.000000, 2.939650, -6.904958},
{0.139169, 0.375301, -0.336100, -0.935728, -0.352702, 0.000244, 2.096662, -7.201084},
{0.136920, 0.377860, -0.336041, -0.468673, -0.883358, 0.000641, 2.099014, -7.214457},
{0.139169, 0.286308, -0.337239, -1.000000, 0.000000, 0.000000, 2.091795, -6.901522},
{0.130173, 0.548575, -0.334396, 0.000000, 1.000000, 0.000000, 0.175980, -4.028145},
{0.042926, 0.548575, -0.334396, 0.000000, 1.000000, 0.000000, 0.176953, -3.686490},
{0.042926, 0.548575, -0.217694, 0.000000, 1.000000, 0.000000, 0.601284, -3.687892},
{0.130173, 0.548575, -0.217694, 0.000000, 1.000000, 0.000000, 0.600310, -4.029547},
{0.148417, 0.548575, -0.217694, 0.000000, 1.000000, 0.000000, 0.600106, -4.100993},
{0.148417, 0.548575, -0.334396, 0.000000, 1.000000, 0.000000, 0.175776, -4.099591},
{0.130173, 0.548575, -0.099820, 0.000000, 1.000000, 0.000000, 1.028905, -4.030963},
{0.042926, 0.548575, -0.099820, 0.000000, 1.000000, 0.000000, 1.029879, -3.689308},
{0.148417, 0.548575, -0.099820, 0.000000, 1.000000, 0.000000, 1.028701, -4.102409},
{-0.200822, 0.548575, -0.334396, 0.000000, 1.000000, 0.000000, 0.179672, -2.731983},
{-0.200822, 0.548575, -0.217694, 0.000000, 1.000000, 0.000000, 0.604002, -2.733385},
{-0.200822, 0.548575, -0.099820, 0.000000, 1.000000, 0.000000, 1.032597, -2.734801},
{0.130173, 0.378885, -0.104351, -0.062746, -0.998016, 0.000702, 2.972912, 1.820405},
{0.042926, 0.378885, -0.104351, 0.000000, -0.999969, 0.000702, 2.970359, 1.478755},
{0.042926, 0.378799, -0.220766, 0.000000, -0.999969, 0.000732, 2.547335, 1.480153},
{0.130173, 0.378799, -0.220766, -0.062777, -0.998016, 0.000732, 2.550677, 1.821800},
{0.136920, 0.377946, -0.220783, -0.468459, -0.883450, 0.000641, 2.553937, 1.857019},
{0.136920, 0.378033, -0.104367, -0.468245, -0.883572, 0.000641, 2.975119, 1.855627},
{0.130173, 0.378713, -0.336022, -0.062838, -0.998016, 0.000732, 2.130549, 1.823189},
{0.042926, 0.378713, -0.336022, 0.000000, -0.999969, 0.000732, 2.127996, 1.481539},
{0.136920, 0.377860, -0.336041, -0.468673, -0.883358, 0.000641, 2.132755, 1.858410},
{-0.200822, 0.378885, -0.104351, 0.000000, -0.999969, 0.000702, 2.967113, 0.524250},
{-0.200822, 0.378799, -0.220766, 0.000000, -0.999969, 0.000732, 2.543826, 0.525649},
{-0.200822, 0.378713, -0.336022, 0.000000, -0.999969, 0.000732, 2.124751, 0.527034},
{0.327407, -0.327839, -0.345342, 0.888760, -0.458357, -0.000031, 0.144838, -7.850549},
{0.327407, -0.235210, -0.343869, 1.000000, 0.000000, 0.000000, 0.147651, -7.536753},
{0.327407, -0.235187, -0.223547, 1.000000, 0.000000, 0.000000, 0.585420, -7.535216},
{0.327407, -0.327832, -0.224631, 0.889279, -0.457320, -0.000031, 0.584845, -7.849064},
{0.315375, -0.336436, -0.225216, 0.422437, -0.906369, -0.000427, 0.584636, -7.881448},
{0.315375, -0.336398, -0.345656, 0.420057, -0.907468, -0.000427, 0.145223, -7.882898},
{0.327407, -0.327824, -0.102707, 0.889828, -0.456282, -0.000031, 1.027066, -7.847572},
{0.327407, -0.235164, -0.102016, 1.000000, 0.000000, 0.000000, 1.027037, -7.533666},
{0.315375, -0.336473, -0.103565, 0.424848, -0.905240, -0.000427, 1.024049, -7.879997},
{0.327406, 0.026155, -0.340498, 1.000000, 0.000000, 0.000000, 0.156860, -6.660066},
{0.327406, 0.026208, -0.222274, 1.000000, 0.000000, 0.000000, 0.586727, -6.658437},
{0.327406, 0.026262, -0.102862, 1.000000, 0.000000, 0.000000, 1.020913, -6.656792},
{0.139169, 0.026155, -0.340498, -1.000000, 0.000000, 0.000000, 2.081902, -6.029580},
{0.139169, -0.235210, -0.343869, -1.000000, 0.000000, 0.000000, 2.072693, -5.152894},
{0.139169, -0.235187, -0.223547, -1.000000, 0.000000, 0.000000, 2.510461, -5.154429},
{0.139169, 0.026208, -0.222274, -1.000000, 0.000000, 0.000000, 2.511767, -6.031208},
{0.139169, 0.026262, -0.102862, -1.000000, 0.000000, 0.000000, 2.945954, -6.032852},
{0.139169, -0.235164, -0.102016, -1.000000, 0.000000, 0.000000, 2.952078, -5.155979},
{0.139169, -0.327839, -0.345342, -0.893643, -0.448714, -0.000031, 2.069880, -4.839097},
{0.150667, -0.336398, -0.345656, -0.434828, -0.900479, -0.000427, 2.070265, -4.806747},
{0.150667, -0.336436, -0.225216, -0.437269, -0.899319, -0.000427, 2.509677, -4.808200},
{0.139169, -0.327832, -0.224631, -0.894162, -0.447676, -0.000031, 2.509887, -4.840582},
{0.139169, -0.327824, -0.102707, -0.894711, -0.446608, -0.000031, 2.952107, -4.842073},
{0.150667, -0.336473, -0.103565, -0.439711, -0.898129, -0.000427, 2.949090, -4.809652},
{0.279279, 0.548575, -0.334396, 0.262703, 0.964843, 0.000000, 0.176449, -4.612044},
{0.231685, 0.548575, -0.334396, 0.000000, 1.000000, 0.000000, 0.175381, -4.425663},
{0.231685, 0.548575, -0.217694, 0.000000, 1.000000, 0.000000, 0.599977, -4.427067},
{0.279279, 0.548575, -0.217694, 0.262612, 0.964873, 0.000000, 0.601846, -4.613450},
{0.315374, 0.527353, -0.218078, 0.817896, 0.575335, -0.000031, 0.604507, -4.801928},
{0.315374, 0.527342, -0.334599, 0.817957, 0.575213, -0.000031, 0.178045, -4.800519},
{0.279279, 0.548575, -0.099820, 0.262520, 0.964904, 0.000000, 1.029374, -4.614862},
{0.231685, 0.548575, -0.099820, 0.000000, 1.000000, 0.000000, 1.028306, -4.428482},
{0.315374, 0.527364, -0.100386, 0.817805, 0.575457, -0.000031, 1.030970, -4.803337},
{0.185160, 0.548575, -0.334396, 0.000000, 1.000000, 0.000000, 0.175366, -4.243472},
{0.185160, 0.548575, -0.217694, 0.000000, 1.000000, 0.000000, 0.599697, -4.244874},
{0.185160, 0.548575, -0.099820, 0.000000, 1.000000, 0.000000, 1.028292, -4.246290},
{0.279279, -0.345869, -0.103222, 0.177343, -0.984130, -0.001160, -2.739010, -6.241776},
{0.231685, -0.350754, -0.102750, -0.001160, -0.999969, -0.001587, -2.912060, -6.243009},
{0.231685, -0.350516, -0.224680, -0.001129, -0.999969, -0.001617, -2.913418, -5.766128},
{0.279279, -0.345711, -0.224993, 0.175146, -0.984527, -0.001190, -2.740365, -5.766109},
{0.315375, -0.336436, -0.225216, 0.422437, -0.906369, -0.000427, -2.565367, -5.766637},
{0.315375, -0.336473, -0.103565, 0.424848, -0.905240, -0.000427, -2.564019, -6.239879},
{0.279279, -0.345554, -0.345553, 0.172948, -0.984924, -0.001190, -2.741713, -5.292820},
{0.231685, -0.350280, -0.345397, -0.001129, -0.999969, -0.001617, -2.914767, -5.292815},
{0.315375, -0.336398, -0.345656, 0.420057, -0.907468, -0.000427, -2.566715, -5.293395},
{0.185160, -0.345869, -0.103222, -0.184027, -0.982910, -0.001160, -3.081229, -6.242909},
{0.150667, -0.336473, -0.103565, -0.439711, -0.898129, -0.000427, -3.248457, -6.242142},
{0.150667, -0.336436, -0.225216, -0.437269, -0.899319, -0.000427, -3.249805, -5.768899},
{0.185160, -0.345711, -0.224993, -0.181768, -0.983337, -0.001190, -3.082584, -5.767241},
{0.185160, -0.345554, -0.345553, -0.179510, -0.983734, -0.001190, -3.083932, -5.293951},
{0.150667, -0.336398, -0.345656, -0.434828, -0.900479, -0.000427, -3.251154, -5.295657},
{-1.177487, -0.313760, -0.452258, -0.989532, -0.082339, -0.118381, 2.720169, -3.871116},
{-1.175111, -0.329115, -0.452258, -0.837153, -0.482650, -0.257210, 2.719895, -3.791718},
{-1.175111, -0.333429, -0.425530, -0.866726, -0.496292, -0.049348, 2.872137, -3.772183},
{-1.177487, -0.316225, -0.425530, -0.997528, -0.069857, -0.005371, 2.872444, -3.861142},
{-1.177487, -0.221989, -0.425530, -1.000000, 0.000000, 0.000000, 2.873539, -4.178128},
{-1.177487, -0.221373, -0.452258, -0.995483, 0.000000, -0.094729, 2.721239, -4.180934},
{-1.175111, -0.220756, -0.464624, -0.814966, 0.000000, -0.579455, 2.649301, -4.184317},
{-1.175111, -0.311295, -0.464624, -0.804224, -0.122745, -0.581469, 2.648264, -3.884058},
{-1.173264, -0.322578, -0.461418, -0.716147, -0.396619, -0.574267, 2.648034, -3.817406},
{-1.177487, 0.014844, -0.452258, -0.995483, 0.000000, -0.094729, 2.723899, -4.951589},
{-1.177487, 0.014844, -0.425530, -1.000000, 0.000000, 0.000000, 2.876208, -4.951173},
{-1.177487, 0.251882, -0.425530, -1.000000, 0.000000, 0.000000, 2.878879, -5.725015},
{-1.177487, 0.251882, -0.452258, -0.995483, 0.000000, -0.094729, 2.726571, -5.725430},
{-1.175111, 0.251882, -0.464624, -0.814966, 0.000000, -0.579455, 2.654621, -5.725627},
{-1.175111, 0.014844, -0.464624, -0.814966, 0.000000, -0.579455, 2.651950, -4.951785},
{-1.177487, 0.346735, -0.452258, -0.992004, 0.072115, -0.103458, 2.727673, -6.044807},
{-1.175111, 0.364555, -0.452258, -0.873470, 0.459426, -0.161107, 2.727991, -6.136953},
{-1.173264, 0.359935, -0.461418, -0.780847, 0.370403, -0.503037, 2.656042, -6.137149},
{-1.175111, 0.346735, -0.464624, -0.817927, 0.102542, -0.566057, 2.655724, -6.045004},
{-1.177487, 0.346735, -0.425530, -0.997803, 0.066195, 0.000000, 2.879982, -6.044392},
{-1.175111, 0.364555, -0.425530, -0.875546, 0.483108, 0.000000, 2.880300, -6.136539},
{-1.177487, -0.317047, -0.378321, -0.997711, -0.067354, 0.000000, 3.185459, -3.857102},
{-1.175111, -0.334867, -0.378321, -0.872921, -0.487808, 0.000000, 3.185141, -3.764957},
{-1.175111, -0.333429, -0.331112, -0.866726, -0.496292, 0.049348, 3.498188, -3.770477},
{-1.177487, -0.316225, -0.331112, -0.997528, -0.069857, 0.005371, 3.498496, -3.859435},
{-1.177487, -0.221989, -0.331112, -1.000000, 0.000000, 0.000000, 3.499590, -4.176422},
{-1.177487, -0.222194, -0.378321, -1.000000, 0.000000, 0.000000, 3.186562, -4.176478},
{-1.177487, 0.014844, -0.378321, -1.000000, 0.000000, 0.000000, 3.189233, -4.950320},
{-1.177486, 0.014844, -0.331112, -1.000000, 0.000000, 0.000000, 3.502258, -4.949467},
{-1.177486, 0.251882, -0.331112, -1.000000, 0.000000, 0.000000, 3.504929, -5.723309},
{-1.177487, 0.251882, -0.378321, -1.000000, 0.000000, 0.000000, 3.191904, -5.724161},
{-1.177486, 0.346735, -0.378321, -0.997803, 0.066195, 0.000000, 3.193007, -6.043539},
{-1.177486, 0.346735, -0.331112, -0.997803, 0.066195, 0.000000, 3.506032, -6.042686},
{-1.175111, 0.364555, -0.331112, -0.875546, 0.483108, 0.000000, 3.506351, -6.134831},
{-1.175111, 0.364555, -0.378321, -0.875546, 0.483108, 0.000000, 3.193325, -6.135684},
{-1.177486, -0.313760, -0.304384, -0.989532, -0.082339, 0.118381, 3.650836, -3.868580},
{-1.175111, -0.329115, -0.304384, -0.837153, -0.482650, 0.257210, 3.650562, -3.789181},
{-1.173264, -0.322578, -0.295225, -0.716147, -0.396619, 0.574267, 3.722599, -3.814477},
{-1.175111, -0.311295, -0.292019, -0.804193, -0.122745, 0.581500, 3.722829, -3.881130},
{-1.175111, -0.220756, -0.292019, -0.814966, 0.000000, 0.579485, 3.723865, -4.181388},
{-1.177486, -0.221373, -0.304384, -0.995483, 0.000000, 0.094729, 3.651906, -4.178397},
{-1.177486, 0.014844, -0.304384, -0.995483, 0.000000, 0.094729, 3.654566, -4.949052},
{-1.175111, 0.014844, -0.292019, -0.814966, 0.000000, 0.579485, 3.726515, -4.948856},
{-1.175111, 0.251882, -0.292019, -0.814966, 0.000000, 0.579485, 3.729187, -5.722697},
{-1.177486, 0.251882, -0.304384, -0.995483, 0.000000, 0.094729, 3.657237, -5.722894},
{-1.177486, 0.346735, -0.304384, -0.992004, 0.072115, 0.103458, 3.658340, -6.042270},
{-1.175111, 0.346735, -0.292019, -0.817927, 0.102542, 0.566057, 3.730289, -6.042074},
{-1.173263, 0.359935, -0.295225, -0.780847, 0.370373, 0.503037, 3.730607, -6.134219},
{-1.175111, 0.364555, -0.304384, -0.873470, 0.459426, 0.161107, 3.658658, -6.134416},
{-1.167985, 0.370495, -0.304384, -0.353984, 0.908628, 0.221503, 3.658531, 1.277263},
{-1.081401, 0.370495, -0.304384, 0.000000, 0.975036, 0.222022, 3.657371, 0.941476},
{-1.081401, 0.370495, -0.331112, 0.000000, 1.000000, 0.000000, 3.505064, 0.941891},
{-1.167985, 0.370495, -0.331112, -0.340465, 0.940245, 0.000000, 3.506223, 1.277678},
{-1.175111, 0.364555, -0.331112, -0.875546, 0.483108, 0.000000, 3.506351, 1.314527},
{-1.175111, 0.364555, -0.304384, -0.873470, 0.459426, 0.161107, 3.658658, 1.314111},
{-1.173263, 0.359935, -0.295225, -0.780847, 0.370373, 0.503037, 3.730607, 1.313915},
{-1.167984, 0.364555, -0.292019, -0.347118, 0.574450, 0.741264, 3.730480, 1.277066},
{-1.081401, 0.364555, -0.292019, 0.000000, 0.624989, 0.780602, 3.729321, 0.941279},
{-1.167985, 0.370495, -0.378321, -0.340465, 0.940245, 0.000000, 3.193198, 1.278532},
{-1.081401, 0.370495, -0.378321, 0.000000, 1.000000, 0.000000, 3.192038, 0.942745},
{-1.081401, 0.370495, -0.425530, 0.000000, 1.000000, 0.000000, 2.879013, 0.943599},
{-1.167985, 0.370495, -0.425530, -0.340465, 0.940245, 0.000000, 2.880172, 1.279386},
{-1.175111, 0.364555, -0.425530, -0.875546, 0.483108, 0.000000, 2.880300, 1.316235},
{-1.175111, 0.364555, -0.378321, -0.875546, 0.483108, 0.000000, 3.193325, 1.315381},
{-1.167985, 0.370495, -0.452258, -0.353984, 0.908628, -0.221503, 2.727864, 1.279801},
{-1.081401, 0.370495, -0.452258, 0.000000, 0.975036, -0.222022, 2.726705, 0.944014},
{-1.081401, 0.364555, -0.464624, 0.000000, 0.624989, -0.780602, 2.654756, 0.944211},
{-1.167985, 0.364555, -0.464624, -0.347118, 0.574450, -0.741264, 2.655915, 1.279998},
{-1.173264, 0.359935, -0.461418, -0.780847, 0.370403, -0.503037, 2.656042, 1.316847},
{-1.175111, 0.364555, -0.452258, -0.873470, 0.459426, -0.161107, 2.727991, 1.316650},
{-1.167985, -0.334233, -0.304384, -0.308145, -0.868557, 0.388073, 4.750624, -3.724302},
{-1.175111, -0.329115, -0.304384, -0.837153, -0.482650, 0.257210, 4.750751, -3.761151},
{-1.175111, -0.333429, -0.331112, -0.866726, -0.496292, 0.049348, 4.598444, -3.761567},
{-1.167985, -0.339163, -0.331112, -0.329508, -0.938810, 0.100040, 4.598316, -3.724718},
{-1.081401, -0.339617, -0.331112, -0.005402, -0.994079, 0.108371, 4.597157, -3.388930},
{-1.081401, -0.334687, -0.304384, -0.004975, -0.916410, 0.400159, 4.749464, -3.388515},
{-1.081401, -0.325460, -0.292019, -0.003082, -0.567156, 0.823603, 4.821414, -3.388319},
{-1.167985, -0.325007, -0.292019, -0.287484, -0.543535, 0.788598, 4.822573, -3.724106},
{-1.173264, -0.322578, -0.295225, -0.716147, -0.396619, 0.574267, 4.822701, -3.760955},
{-1.167985, -0.340807, -0.378321, -0.338939, -0.940794, 0.000000, 4.285291, -3.725572},
{-1.175111, -0.334867, -0.378321, -0.872921, -0.487808, 0.000000, 4.285419, -3.762420},
{-1.175111, -0.333429, -0.425530, -0.866726, -0.496292, -0.049348, 3.972394, -3.763274},
{-1.167985, -0.339163, -0.425530, -0.329508, -0.938810, -0.100040, 3.972266, -3.726426},
{-1.081401, -0.339617, -0.425530, -0.005402, -0.994079, -0.108371, 3.971107, -3.390639},
{-1.081401, -0.341260, -0.378321, -0.005432, -0.999969, 0.000000, 4.284132, -3.389785},
{-1.167985, -0.334234, -0.452258, -0.308145, -0.868557, -0.388073, 3.819959, -3.726842},
{-1.175111, -0.329115, -0.452258, -0.837153, -0.482650, -0.257210, 3.820086, -3.763690},
{-1.173264, -0.322578, -0.461418, -0.716147, -0.396619, -0.574267, 3.748137, -3.763886},
{-1.167985, -0.325007, -0.464624, -0.287484, -0.543535, -0.788568, 3.748010, -3.727038},
{-1.081401, -0.325461, -0.464624, -0.003082, -0.567156, -0.823573, 3.746850, -3.391252},
{-1.081401, -0.334687, -0.452258, -0.004975, -0.916410, -0.400159, 3.818799, -3.391055},
{-1.167985, 0.346735, -0.468746, -0.276772, 0.117252, -0.953734, -0.117480, 1.279715},
{-1.175111, 0.346735, -0.464624, -0.817927, 0.102542, -0.566057, -0.117607, 1.316564},
{-1.173264, 0.359935, -0.461418, -0.780847, 0.370403, -0.503037, -0.013921, 1.316847},
{-1.167985, 0.364555, -0.464624, -0.347118, 0.574450, -0.741264, -0.013794, 1.279998},
{-1.081401, 0.364555, -0.464624, 0.000000, 0.624989, -0.780602, -0.012635, 0.944211},
{-1.081401, 0.346735, -0.468746, 0.000000, 0.113407, -0.993530, -0.116321, 0.943928},
{-1.081401, 0.251825, -0.468746, 0.000000, 0.000000, -1.000000, -0.475949, 0.942948},
{-1.167985, 0.251882, -0.468746, -0.259194, 0.000000, -0.965819, -0.476861, 1.278736},
{-1.175111, 0.251882, -0.464624, -0.814966, 0.000000, -0.579455, -0.476988, 1.315584},
{-1.167985, 0.014844, -0.468746, -0.259194, 0.000000, -0.965819, -1.347630, 1.276362},
{-1.081401, 0.014617, -0.468746, 0.000000, 0.000000, -1.000000, -1.347461, 0.940572},
{-1.081401, -0.220948, -0.468746, 0.000000, 0.000000, -1.000000, -2.211802, 0.938215},
{-1.167985, -0.220551, -0.468746, -0.259194, 0.000000, -0.965819, -2.211228, 1.274007},
{-1.175111, -0.220756, -0.464624, -0.814966, 0.000000, -0.579455, -2.211354, 1.310856},
{-1.175111, 0.014844, -0.464624, -0.814966, 0.000000, -0.579455, -1.347757, 1.313210},
{-1.167985, -0.310474, -0.468746, -0.266427, -0.141575, -0.953398, -2.549094, 1.273086},
{-1.081401, -0.310927, -0.468746, -0.000732, -0.137730, -0.990448, -2.549915, 0.937294},
{-1.081401, -0.325461, -0.464624, -0.003082, -0.567156, -0.823573, -2.624915, 0.937090},
{-1.167985, -0.325007, -0.464624, -0.287484, -0.543535, -0.788568, -2.624094, 1.272882},
{-1.173264, -0.322578, -0.461418, -0.716147, -0.396619, -0.574267, -2.624222, 1.309731},
{-1.175111, -0.311295, -0.464624, -0.804224, -0.122745, -0.581469, -2.549221, 1.309935},
{-1.167985, -0.310474, -0.287897, -0.266396, -0.141575, 0.953398, 0.085809, -3.724310},
{-1.081401, -0.310927, -0.287897, -0.000732, -0.137730, 0.990448, 0.084989, -3.388517},
{-1.081401, -0.220948, -0.287897, 0.000000, 0.000000, 1.000000, 0.423103, -3.389439},
{-1.167985, -0.220551, -0.287897, -0.259194, 0.000000, 0.965819, 0.423676, -3.725231},
{-1.175111, -0.220756, -0.292019, -0.814966, 0.000000, 0.579485, 0.423549, -3.762080},
{-1.175111, -0.311295, -0.292019, -0.804193, -0.122745, 0.581500, 0.085682, -3.761159},
{-1.173264, -0.322578, -0.295225, -0.716147, -0.396619, 0.574267, 0.010681, -3.760955},
{-1.167985, -0.325007, -0.292019, -0.287484, -0.543535, 0.788598, 0.010809, -3.724106},
{-1.081401, -0.325460, -0.292019, -0.003082, -0.567156, 0.823603, 0.009988, -3.388313},
{-1.167985, 0.014844, -0.287897, -0.259194, 0.000000, 0.965819, 1.287274, -3.727585},
{-1.081401, 0.014617, -0.287897, 0.000000, 0.000000, 1.000000, 1.287443, -3.391796},
{-1.081401, 0.251825, -0.287897, 0.000000, 0.000000, 1.000000, 2.158955, -3.394172},
{-1.167985, 0.251882, -0.287897, -0.259194, 0.000000, 0.965819, 2.158043, -3.729959},
{-1.175111, 0.251882, -0.292019, -0.814966, 0.000000, 0.579485, 2.157916, -3.766808},
{-1.175111, 0.014844, -0.292019, -0.814966, 0.000000, 0.579485, 1.287147, -3.764434},
{-1.167985, 0.346735, -0.287897, -0.276772, 0.117252, 0.953734, 2.517424, -3.730940},
{-1.081401, 0.346735, -0.287897, 0.000000, 0.113407, 0.993530, 2.518583, -3.395153},
{-1.081401, 0.364555, -0.292019, 0.000000, 0.624989, 0.780602, 2.622269, -3.395434},
{-1.167984, 0.364555, -0.292019, -0.347118, 0.574450, 0.741264, 2.621110, -3.731222},
{-1.173263, 0.359935, -0.295225, -0.780847, 0.370373, 0.503037, 2.620983, -3.768072},
{-1.175111, 0.346735, -0.292019, -0.817927, 0.102542, 0.566057, 2.517297, -3.767789},
{-0.840652, 0.370495, -0.304384, 0.000000, 0.975036, 0.222022, 3.654148, 0.007813},
{-0.522821, 0.370495, -0.304384, 0.000000, 0.975036, 0.222022, 3.649893, -1.224789},
{-0.522821, 0.370495, -0.331112, 0.000000, 1.000000, 0.000000, 3.497586, -1.224373},
{-0.840652, 0.370495, -0.331112, 0.000000, 1.000000, 0.000000, 3.501840, 0.008228},
{-0.840652, 0.364555, -0.292019, 0.000000, 0.624989, 0.780602, 3.726097, 0.007616},
{-0.522821, 0.364555, -0.292019, 0.000000, 0.624989, 0.780602, 3.721841, -1.224985},
{-0.840652, 0.370495, -0.378321, 0.000000, 1.000000, 0.000000, 3.188815, 0.009082},
{-0.522821, 0.370495, -0.378321, 0.000000, 1.000000, 0.000000, 3.184560, -1.223520},
{-0.522821, 0.370495, -0.425530, 0.000000, 1.000000, 0.000000, 2.871534, -1.222667},
{-0.840652, 0.370495, -0.425530, 0.000000, 1.000000, 0.000000, 2.875790, 0.009935},
{-0.840652, 0.370495, -0.452258, 0.000000, 0.975036, -0.222022, 2.723482, 0.010351},
{-0.522821, 0.370495, -0.452258, 0.000000, 0.975036, -0.222022, 2.719226, -1.222251},
{-0.522821, 0.364554, -0.464624, 0.000000, 0.624989, -0.780602, 2.647277, -1.222055},
{-0.840652, 0.364555, -0.464624, 0.000000, 0.624989, -0.780602, 2.651533, 0.010547},
{-0.840652, -0.336048, -0.304384, -0.003876, -0.916410, 0.400159, 4.746241, -2.454852},
{-0.840652, -0.340978, -0.331112, -0.004212, -0.994079, 0.108371, 4.593934, -2.455267},
{-0.522821, -0.341885, -0.331112, 0.000000, -0.994079, 0.108371, 4.589679, -1.222666},
{-0.522821, -0.336955, -0.304384, 0.000000, -0.916410, 0.400159, 4.741986, -1.222250},
{-0.522821, -0.327729, -0.292019, 0.000000, -0.567156, 0.823603, 4.813934, -1.222054},
{-0.840652, -0.326821, -0.292019, -0.002411, -0.567156, 0.823603, 4.818190, -2.454655},
{-0.840652, -0.342621, -0.378321, -0.004242, -0.999969, 0.000000, 4.280909, -2.456121},
{-0.840652, -0.340978, -0.425530, -0.004212, -0.994079, -0.108371, 3.967884, -2.456975},
{-0.522821, -0.341885, -0.425531, 0.000000, -0.994079, -0.108371, 3.963629, -1.224373},
{-0.522821, -0.343529, -0.378321, 0.000000, -1.000000, 0.000000, 4.276654, -1.223519},
{-0.840652, -0.336048, -0.452258, -0.003876, -0.916410, -0.400159, 3.815576, -2.457391},
{-0.840652, -0.326822, -0.464624, -0.002411, -0.567156, -0.823603, 3.743627, -2.457587},
{-0.522821, -0.327729, -0.464624, 0.000000, -0.567156, -0.823603, 3.739371, -1.224985},
{-0.522821, -0.336955, -0.452258, 0.000000, -0.916410, -0.400159, 3.811321, -1.224788},
{-0.840652, 0.346735, -0.468746, 0.000000, 0.113407, -0.993530, -0.113098, 0.010265},
{-0.522821, 0.346735, -0.468746, 0.000000, 0.113407, -0.993530, -0.108843, -1.222337},
{-0.522821, 0.251542, -0.468746, 0.000000, 0.000000, -1.000000, -0.469709, -1.223321},
{-0.840652, 0.251655, -0.468746, 0.000000, 0.000000, -1.000000, -0.473469, 0.009282},
{-0.840652, 0.364555, -0.464624, 0.000000, 0.624989, -0.780602, -0.009412, 0.010547},
{-0.522821, 0.364554, -0.464624, 0.000000, 0.624989, -0.780602, -0.005157, -1.222054},
{-0.840652, 0.013936, -0.468746, 0.000000, 0.000000, -1.000000, -1.347208, 0.006900},
{-0.522821, 0.013483, -0.468746, 0.000000, 0.000000, -1.000000, -1.344932, -1.225708},
{-0.522821, -0.222933, -0.468746, 0.000000, 0.000000, -1.000000, -2.212984, -1.228075},
{-0.840652, -0.222139, -0.468746, 0.000000, 0.000000, -1.000000, -2.213775, 0.004537},
{-0.840652, -0.312288, -0.468746, -0.000580, -0.137730, -0.990448, -2.552631, 0.003614},
{-0.522821, -0.313196, -0.468746, 0.000000, -0.137730, -0.990448, -2.552335, -1.229000},
{-0.522821, -0.327729, -0.464624, 0.000000, -0.567156, -0.823603, -2.627336, -1.229204},
{-0.840652, -0.326822, -0.464624, -0.002411, -0.567156, -0.823603, -2.627631, 0.003410},
{-0.840652, -0.312288, -0.287897, -0.000580, -0.137730, 0.990448, 0.082273, -2.454838},
{-0.522821, -0.313195, -0.287897, 0.000000, -0.137730, 0.990448, 0.082569, -1.222226},
{-0.522821, -0.222933, -0.287897, 0.000000, 0.000000, 1.000000, 0.421920, -1.223151},
{-0.840652, -0.222139, -0.287897, 0.000000, 0.000000, 1.000000, 0.421129, -2.455762},
{-0.840652, -0.326821, -0.292019, -0.002411, -0.567156, 0.823603, 0.007272, -2.454634},
{-0.522821, -0.327729, -0.292019, 0.000000, -0.567156, 0.823603, 0.007568, -1.222022},
{-0.840652, 0.013937, -0.287897, 0.000000, 0.000000, 1.000000, 1.287697, -2.458125},
{-0.522821, 0.013483, -0.287897, 0.000000, 0.000000, 1.000000, 1.289972, -1.225518},
{-0.522821, 0.251542, -0.287897, 0.000000, 0.000000, 1.000000, 2.165195, -1.227904},
{-0.840652, 0.251655, -0.287897, 0.000000, 0.000000, 1.000000, 2.161435, -2.460507},
{-0.840652, 0.346735, -0.287897, 0.000000, 0.113407, 0.993530, 2.521806, -2.461489},
{-0.522821, 0.346735, -0.287897, 0.000000, 0.113407, 0.993530, 2.526061, -1.228888},
{-0.522821, 0.364555, -0.292019, 0.000000, 0.624989, 0.780602, 2.629747, -1.229171},
{-0.840652, 0.364555, -0.292019, 0.000000, 0.624989, 0.780602, 2.625492, -2.461771},
{-0.204990, 0.346735, -0.287897, 0.000000, 0.113407, 0.993530, 2.530316, 0.003712},
{-0.204990, 0.364555, -0.292019, 0.000000, 0.624989, 0.780602, 2.634003, 0.003429},
{-0.204990, 0.251655, -0.287897, 0.000000, 0.000000, 1.000000, 2.169945, 0.004695},
{0.035759, 0.251825, -0.287897, 0.000000, 0.000000, 1.000000, 2.173911, 0.938356},
{0.035759, 0.346735, -0.287897, 0.000000, 0.113407, 0.993530, 2.533540, 0.937375},
{0.035759, 0.364555, -0.292019, 0.000000, 0.624989, 0.780602, 2.637226, 0.937092},
{-0.204990, 0.013937, -0.287897, 0.000000, 0.000000, 1.000000, 1.296207, 0.007078},
{-0.204990, -0.222139, -0.287897, 0.000000, 0.000000, 1.000000, 0.429640, 0.009440},
{0.035759, -0.220948, -0.287897, 0.000000, 0.000000, 1.000000, 0.438060, 0.943089},
{0.035759, 0.014617, -0.287897, 0.000000, 0.000000, 1.000000, 1.302400, 0.940732},
{-0.204990, -0.312288, -0.287897, 0.000580, -0.137730, 0.990448, 0.090783, 0.010364},
{-0.204990, -0.326821, -0.292019, 0.002411, -0.567156, 0.823603, 0.015783, 0.010569},
{0.035759, -0.325460, -0.292019, 0.003082, -0.567156, 0.823603, 0.024945, 0.944216},
{0.035759, -0.310927, -0.287897, 0.000732, -0.137730, 0.990448, 0.099946, 0.944011},
{-0.204989, -0.312288, -0.468746, 0.000580, -0.137730, -0.990448, -2.544120, -2.461592},
{-0.204989, -0.326822, -0.464624, 0.002411, -0.567156, -0.823603, -2.619121, -2.461797},
{-0.204989, -0.222139, -0.468746, 0.000000, 0.000000, -1.000000, -2.205264, -2.460668},
{0.035760, -0.220948, -0.468746, 0.000000, 0.000000, -1.000000, -2.196844, -3.394318},
{0.035760, -0.310927, -0.468746, 0.000732, -0.137730, -0.990448, -2.534958, -3.395240},
{0.035760, -0.325461, -0.464624, 0.003082, -0.567156, -0.823573, -2.609958, -3.395445},
{-0.204989, 0.013936, -0.468746, 0.000000, 0.000000, -1.000000, -1.338697, -2.458304},
{-0.204989, 0.251655, -0.468746, 0.000000, 0.000000, -1.000000, -0.464958, -2.455922},
{0.035760, 0.251825, -0.468746, 0.000000, 0.000000, -1.000000, -0.460992, -3.389584},
{0.035760, 0.014617, -0.468746, 0.000000, 0.000000, -1.000000, -1.332504, -3.391960},
{-0.204989, 0.346735, -0.468746, 0.000000, 0.113407, -0.993530, -0.104588, -2.454939},
{-0.204989, 0.364555, -0.464624, 0.000000, 0.624989, -0.780602, -0.000901, -2.454657},
{0.035760, 0.364555, -0.464624, 0.000000, 0.624989, -0.780602, 0.002322, -3.388320},
{0.035760, 0.346735, -0.468746, 0.000000, 0.113407, -0.993530, -0.101364, -3.388603},
{-0.204989, -0.336048, -0.452258, 0.003876, -0.916410, -0.400159, 3.807065, 0.007814},
{-0.204989, -0.326822, -0.464624, 0.002411, -0.567156, -0.823603, 3.735115, 0.007618},
{0.035760, -0.325461, -0.464624, 0.003082, -0.567156, -0.823573, 3.731892, 0.941282},
{0.035760, -0.334687, -0.452258, 0.004975, -0.916410, -0.400159, 3.803841, 0.941478},
{0.035760, -0.339617, -0.425530, 0.005402, -0.994079, -0.108371, 3.956150, 0.941894},
{-0.204989, -0.340978, -0.425530, 0.004212, -0.994079, -0.108371, 3.959373, 0.008230},
{-0.204989, -0.342621, -0.378321, 0.004242, -0.999969, 0.000000, 4.272398, 0.009083},
{0.035760, -0.341260, -0.378321, 0.005432, -0.999969, 0.000000, 4.269175, 0.942747},
{0.035759, -0.339617, -0.331112, 0.005402, -0.994079, 0.108371, 4.582200, 0.943599},
{-0.204989, -0.340978, -0.331112, 0.004212, -0.994079, 0.108371, 4.585423, 0.009936},
{-0.204990, -0.336048, -0.304384, 0.003876, -0.916410, 0.400159, 4.737731, 0.010351},
{0.035759, -0.334687, -0.304384, 0.004975, -0.916410, 0.400159, 4.734508, 0.944014},
{0.035759, -0.325460, -0.292019, 0.003082, -0.567156, 0.823603, 4.806457, 0.944210},
{-0.204990, -0.326821, -0.292019, 0.002411, -0.567156, 0.823603, 4.809680, 0.010547},
{-0.204989, 0.370495, -0.452258, 0.000000, 0.975036, -0.222022, 2.714971, -2.454853},
{-0.204989, 0.364555, -0.464624, 0.000000, 0.624989, -0.780602, 2.643022, -2.454657},
{-0.204989, 0.370495, -0.425530, 0.000000, 1.000000, 0.000000, 2.867280, -2.455268},
{0.035759, 0.370495, -0.425530, 0.000000, 1.000000, 0.000000, 2.864056, -3.388931},
{0.035759, 0.370495, -0.452258, 0.000000, 0.975036, -0.222022, 2.711748, -3.388516},
{0.035760, 0.364555, -0.464624, 0.000000, 0.624989, -0.780602, 2.639799, -3.388320},
{-0.204989, 0.370495, -0.378321, 0.000000, 1.000000, 0.000000, 3.180305, -2.456121},
{-0.204990, 0.370495, -0.331112, 0.000000, 1.000000, 0.000000, 3.493330, -2.456975},
{0.035759, 0.370495, -0.331112, 0.000000, 1.000000, 0.000000, 3.490107, -3.390638},
{0.035759, 0.370495, -0.378321, 0.000000, 1.000000, 0.000000, 3.177082, -3.389785},
{-0.204990, 0.370495, -0.304384, 0.000000, 0.975036, 0.222022, 3.645638, -2.457390},
{-0.204990, 0.364555, -0.292019, 0.000000, 0.624989, 0.780602, 3.717586, -2.457586},
{0.035759, 0.364555, -0.292019, 0.000000, 0.624989, 0.780602, 3.714362, -3.391249},
{0.035759, 0.370495, -0.304384, 0.000000, 0.975036, 0.222022, 3.642414, -3.391053},
{0.122343, 0.346735, -0.287897, 0.276772, 0.117252, 0.953734, 2.534699, 1.273163},
{0.122343, 0.364555, -0.292019, 0.347118, 0.574450, 0.741264, 2.638385, 1.272880},
{0.122343, 0.251882, -0.287897, 0.259194, 0.000000, 0.965819, 2.175318, 1.274143},
{0.129469, 0.251882, -0.292019, 0.814966, 0.000000, 0.579485, 2.175445, 1.310992},
{0.129469, 0.346735, -0.292019, 0.817927, 0.102542, 0.566057, 2.534826, 1.310012},
{0.127622, 0.359935, -0.295225, 0.780847, 0.370373, 0.503037, 2.638512, 1.309730},
{0.122343, 0.014844, -0.287897, 0.259194, 0.000000, 0.965819, 1.304549, 1.276517},
{0.122343, -0.220551, -0.287897, 0.259194, 0.000000, 0.965819, 0.440951, 1.278871},
{0.129470, -0.220756, -0.292019, 0.814966, 0.000000, 0.579485, 0.441079, 1.315721},
{0.129470, 0.014844, -0.292019, 0.814966, 0.000000, 0.579485, 1.304676, 1.313366},
{0.122343, -0.310474, -0.287897, 0.266396, -0.141575, 0.953398, 0.103085, 1.279793},
{0.122343, -0.325007, -0.292019, 0.287484, -0.543535, 0.788598, 0.028084, 1.279997},
{0.127622, -0.322578, -0.295225, 0.716117, -0.396619, 0.574267, 0.028211, 1.316847},
{0.129470, -0.311295, -0.292019, 0.804193, -0.122745, 0.581500, 0.103212, 1.316642},
{0.122344, -0.310474, -0.468746, 0.266396, -0.141575, -0.953398, -2.531819, -3.731021},
{0.122344, -0.325007, -0.464624, 0.287484, -0.543535, -0.788568, -2.606819, -3.731226},
{0.122344, -0.220551, -0.468746, 0.259194, 0.000000, -0.965819, -2.193952, -3.730099},
{0.129470, -0.220756, -0.464624, 0.814966, 0.000000, -0.579455, -2.193824, -3.766947},
{0.129470, -0.311295, -0.464624, 0.804224, -0.122745, -0.581500, -2.531691, -3.767869},
{0.127622, -0.322578, -0.461418, 0.716147, -0.396619, -0.574267, -2.606692, -3.768074},
{0.122344, 0.014844, -0.468746, 0.259194, 0.000000, -0.965819, -1.330354, -3.727744},
{0.122344, 0.251882, -0.468746, 0.259194, 0.000000, -0.965819, -0.459585, -3.725369},
{0.129470, 0.251882, -0.464624, 0.814966, 0.000000, -0.579455, -0.459458, -3.762218},
{0.129470, 0.014844, -0.464624, 0.814966, 0.000000, -0.579455, -1.330227, -3.764592},
{0.122344, 0.346735, -0.468746, 0.276772, 0.117252, -0.953734, -0.100205, -3.724390},
{0.122344, 0.364555, -0.464624, 0.347118, 0.574450, -0.741264, 0.003481, -3.724108},
{0.127622, 0.359935, -0.461418, 0.780847, 0.370373, -0.503037, 0.003609, -3.760956},
{0.129470, 0.346735, -0.464624, 0.817927, 0.102542, -0.566057, -0.100078, -3.761239},
{0.122344, -0.334234, -0.452258, 0.308145, -0.868557, -0.388073, 3.802683, 1.277266},
{0.122344, -0.325007, -0.464624, 0.287484, -0.543535, -0.788568, 3.730733, 1.277070},
{0.127622, -0.322578, -0.461418, 0.716147, -0.396619, -0.574267, 3.730607, 1.313918},
{0.129470, -0.329115, -0.452258, 0.837153, -0.482650, -0.257210, 3.802557, 1.314114},
{0.129470, -0.333429, -0.425530, 0.866726, -0.496292, -0.049348, 3.954865, 1.314529},
{0.122344, -0.339164, -0.425530, 0.329508, -0.938810, -0.100040, 3.954991, 1.277680},
{0.122344, -0.340807, -0.378321, 0.338939, -0.940794, 0.000000, 4.268016, 1.278533},
{0.129470, -0.334867, -0.378321, 0.872921, -0.487808, 0.000000, 4.267889, 1.315382},
{0.129470, -0.333429, -0.331112, 0.866726, -0.496292, 0.049348, 4.580914, 1.316235},
{0.122343, -0.339163, -0.331112, 0.329508, -0.938810, 0.100040, 4.581041, 1.279386},
{0.122343, -0.334233, -0.304384, 0.308145, -0.868557, 0.388073, 4.733349, 1.279801},
{0.129470, -0.329115, -0.304384, 0.837153, -0.482650, 0.257210, 4.733221, 1.316650},
{0.127622, -0.322578, -0.295225, 0.716117, -0.396619, 0.574267, 4.805170, 1.316847},
{0.122343, -0.325007, -0.292019, 0.287484, -0.543535, 0.788598, 4.805298, 1.279997},
{0.122343, 0.370495, -0.452258, 0.353984, 0.908628, -0.221503, 2.710588, -3.724303},
{0.122344, 0.364555, -0.464624, 0.347118, 0.574450, -0.741264, 2.638639, -3.724108},
{0.122343, 0.370495, -0.425530, 0.340465, 0.940245, 0.000000, 2.862896, -3.724718},
{0.129470, 0.364555, -0.425530, 0.875546, 0.483108, 0.000000, 2.862769, -3.761567},
{0.129470, 0.364555, -0.452258, 0.873470, 0.459426, -0.161107, 2.710461, -3.761152},
{0.127622, 0.359935, -0.461418, 0.780847, 0.370373, -0.503037, 2.638512, -3.760956},
{0.122343, 0.370495, -0.378321, 0.340465, 0.940245, 0.000000, 3.175922, -3.725572},
{0.122343, 0.370495, -0.331112, 0.340465, 0.940245, 0.000000, 3.488948, -3.726425},
{0.129470, 0.364555, -0.331112, 0.875546, 0.483108, 0.000000, 3.488820, -3.763273},
{0.129470, 0.364555, -0.378321, 0.875546, 0.483108, 0.000000, 3.175795, -3.762420},
{0.122343, 0.370495, -0.304384, 0.353984, 0.908628, 0.221503, 3.641255, -3.726840},
{0.122343, 0.364555, -0.292019, 0.347118, 0.574450, 0.741264, 3.713204, -3.727036},
{0.127622, 0.359935, -0.295225, 0.780847, 0.370373, 0.503037, 3.713078, -3.763885},
{0.129469, 0.364555, -0.304384, 0.873470, 0.459426, 0.161107, 3.641129, -3.763688},
{0.131845, 0.346735, -0.304384, 0.992004, 0.072115, 0.103458, 4.740912, -3.858765},
{0.129469, 0.346735, -0.292019, 0.817927, 0.102542, 0.566057, 4.812860, -3.858961},
{0.129469, 0.251882, -0.292019, 0.814966, 0.000000, 0.579485, 4.811758, -4.178339},
{0.131845, 0.251882, -0.304384, 0.995483, 0.000000, 0.094729, 4.739810, -4.178142},
{0.131845, 0.251882, -0.331112, 1.000000, 0.000000, 0.000000, 4.587502, -4.177726},
{0.131845, 0.346735, -0.331112, 0.997803, 0.066195, 0.000000, 4.588604, -3.858349},
{0.129470, 0.364555, -0.331112, 0.875546, 0.483108, 0.000000, 4.588922, -3.766205},
{0.129469, 0.364555, -0.304384, 0.873470, 0.459426, 0.161107, 4.741230, -3.766620},
{0.127622, 0.359935, -0.295225, 0.780847, 0.370373, 0.503037, 4.813179, -3.766816},
{0.131845, 0.014844, -0.304384, 0.995483, 0.000000, 0.094729, 4.737138, -4.951983},
{0.129470, 0.014844, -0.292019, 0.814966, 0.000000, 0.579485, 4.809087, -4.952180},
{0.129470, -0.220756, -0.292019, 0.814966, 0.000000, 0.579485, 4.806438, -5.719648},
{0.131845, -0.221373, -0.304384, 0.995483, 0.000000, 0.094729, 4.734478, -5.722638},
{0.131845, -0.221989, -0.331112, 1.000000, 0.000000, 0.000000, 4.582161, -5.724613},
{0.131845, 0.014844, -0.331112, 1.000000, 0.000000, 0.000000, 4.584831, -4.951567},
{0.131845, -0.313760, -0.304384, 0.989532, -0.082339, 0.118381, 4.733408, -6.032455},
{0.129470, -0.311295, -0.292019, 0.804193, -0.122745, 0.581500, 4.805401, -6.019905},
{0.127622, -0.322578, -0.295225, 0.716117, -0.396619, 0.574267, 4.805170, -6.086556},
{0.129470, -0.329115, -0.304384, 0.837153, -0.482650, 0.257210, 4.733133, -6.111854},
{0.129470, -0.333429, -0.331112, 0.866726, -0.496292, 0.049348, 4.580760, -6.130559},
{0.131845, -0.316225, -0.331112, 0.997528, -0.069857, 0.005371, 4.581067, -6.041600},
{0.131845, 0.346735, -0.378321, 0.997803, 0.066195, 0.000000, 4.275579, -3.857496},
{0.131845, 0.251882, -0.378321, 1.000000, 0.000000, 0.000000, 4.274477, -4.176873},
{0.131845, 0.251882, -0.425530, 1.000000, 0.000000, 0.000000, 3.961451, -4.176020},
{0.131845, 0.346735, -0.425530, 0.997803, 0.066195, 0.000000, 3.962553, -3.856643},
{0.129470, 0.364555, -0.425530, 0.875546, 0.483108, 0.000000, 3.962871, -3.764498},
{0.129470, 0.364555, -0.378321, 0.875546, 0.483108, 0.000000, 4.275897, -3.765352},
{0.131845, 0.014844, -0.378321, 1.000000, 0.000000, 0.000000, 4.271805, -4.950715},
{0.131845, -0.222194, -0.378321, 1.000000, 0.000000, 0.000000, 4.269134, -5.724556},
{0.131845, -0.221989, -0.425530, 1.000000, 0.000000, 0.000000, 3.956110, -5.722907},
{0.131845, 0.014844, -0.425530, 1.000000, 0.000000, 0.000000, 3.958779, -4.949862},
{0.131845, -0.317047, -0.378321, 0.997711, -0.067354, 0.000000, 4.268031, -6.043934},
{0.129470, -0.334867, -0.378321, 0.872921, -0.487808, 0.000000, 4.267713, -6.136079},
{0.129470, -0.333429, -0.425530, 0.866726, -0.496292, -0.049348, 3.954710, -6.128853},
{0.131845, -0.316225, -0.425530, 0.997528, -0.069857, -0.005371, 3.955017, -6.039895},
{0.131845, 0.346735, -0.452258, 0.992004, 0.072115, -0.103458, 3.810246, -3.856227},
{0.131845, 0.251882, -0.452258, 0.995483, 0.000000, -0.094729, 3.809143, -4.175604},
{0.129470, 0.251882, -0.464624, 0.814966, 0.000000, -0.579455, 3.737194, -4.175408},
{0.129470, 0.346735, -0.464624, 0.817927, 0.102542, -0.566057, 3.738297, -3.856031},
{0.127622, 0.359935, -0.461418, 0.780847, 0.370373, -0.503037, 3.738615, -3.763886},
{0.129470, 0.364555, -0.452258, 0.873470, 0.459426, -0.161107, 3.810564, -3.764083},
{0.131845, 0.014844, -0.452258, 0.995483, 0.000000, -0.094729, 3.806471, -4.949447},
{0.131845, -0.221373, -0.452258, 0.995483, 0.000000, -0.094729, 3.803811, -5.720102},
{0.129470, -0.220756, -0.464624, 0.814966, 0.000000, -0.579455, 3.731873, -5.716718},
{0.129470, 0.014844, -0.464624, 0.814966, 0.000000, -0.579455, 3.734522, -4.949250},
{0.131845, -0.313760, -0.452258, 0.989532, -0.082339, -0.118381, 3.802742, -6.029920},
{0.129470, -0.329115, -0.452258, 0.837153, -0.482650, -0.257210, 3.802468, -6.109318},
{0.127622, -0.322578, -0.461418, 0.716147, -0.396619, -0.574267, 3.730607, -6.083628},
{0.129470, -0.311295, -0.464624, 0.804224, -0.122745, -0.581500, 3.730837, -6.016976},
{0.112057, 0.168795, -0.150662, 0.568773, -0.374554, -0.732231, 3.573277, 1.445280},
{0.123394, 0.192602, -0.150274, 0.515000, -0.118809, -0.848903, 3.497106, 1.461781},
{0.131635, 0.197515, -0.143278, 0.842982, -0.222358, -0.489792, 3.484527, 1.502174},
{0.117424, 0.168963, -0.143784, 0.785546, -0.554003, -0.275613, 3.581182, 1.470520},
{0.099527, 0.150233, -0.144305, 0.672018, -0.727226, -0.139592, 3.642249, 1.426926},
{0.097263, 0.152012, -0.150898, 0.532182, -0.533433, -0.657399, 3.626025, 1.417387},
{0.095558, 0.156612, -0.153749, 0.330882, -0.304392, -0.893216, 3.609340, 1.406188},
{0.103330, 0.168647, -0.154608, 0.281961, -0.170171, -0.944182, 3.570622, 1.417706},
{0.111005, 0.187894, -0.154172, 0.205176, -0.010102, -0.978668, 3.508620, 1.423156},
{0.119917, 0.172235, -0.133224, 0.802911, -0.595233, 0.031404, 1.419057, -2.558964},
{0.117424, 0.168963, -0.143784, 0.785546, -0.554003, -0.275613, 1.422326, -2.609891},
{0.131635, 0.197515, -0.143278, 0.842982, -0.222358, -0.489792, 1.326769, -2.573308},
{0.135701, 0.201861, -0.132288, 0.954009, -0.263588, -0.142674, 1.326205, -2.520905},
{0.137238, 0.205594, -0.117753, 0.962188, -0.270760, -0.029420, 1.328266, -2.463300},
{0.120713, 0.175007, -0.119244, 0.810175, -0.586138, -0.000793, 1.423749, -2.504612},
{0.100836, 0.155437, -0.120646, 0.669027, -0.741997, -0.042146, 1.500290, -2.540495},
{0.100554, 0.153410, -0.134183, 0.655263, -0.745079, 0.124149, 1.492589, -2.591270},
{0.099527, 0.150233, -0.144305, 0.672018, -0.727226, -0.139592, 1.500196, -2.640942},
{0.137851, 0.244436, -0.131730, 0.942686, 0.089969, -0.321238, 1.194714, -2.471338},
{0.132894, 0.236929, -0.142830, 0.725516, 0.080416, -0.683432, 1.195836, -2.525662},
{0.123335, 0.272385, -0.142595, 0.477432, 0.261422, -0.838832, 1.047216, -2.472485},
{0.128020, 0.283307, -0.132053, 0.760582, 0.419568, -0.495437, 1.043903, -2.416018},
{0.130691, 0.288322, -0.117138, 0.843287, 0.471236, -0.258370, 1.042588, -2.353526},
{0.140256, 0.248848, -0.116739, 0.987884, 0.082614, -0.131230, 1.194898, -2.411128},
{0.124114, 0.222970, -0.149361, 0.354289, 0.066561, -0.932737, 3.398826, 1.461344},
{0.132894, 0.236929, -0.142830, 0.725516, 0.080416, -0.683432, 3.347309, 1.506286},
{0.111211, 0.209923, -0.152648, 0.121555, 0.078768, -0.989441, 3.437484, 1.419927},
{0.107229, 0.229917, -0.150883, 0.069552, 0.098209, -0.992706, 3.373142, 1.418293},
{0.115527, 0.249501, -0.148439, 0.175665, 0.126102, -0.976318, 3.312147, 1.446321},
{0.123335, 0.272385, -0.142595, 0.477432, 0.261422, -0.838832, 3.222301, 1.489294},
{-0.521085, 0.214737, -0.143080, -0.631245, 0.110538, -0.767632, 3.281792, -1.004393},
{-0.521564, 0.191154, -0.142145, -0.745720, -0.237739, -0.622364, 3.361994, -1.035164},
{-0.522622, 0.192457, -0.136864, -0.962035, -0.253365, -0.101321, 3.360285, -1.040065},
{-0.523000, 0.218438, -0.138065, -0.936583, 0.162633, -0.310343, 3.268611, -1.012749},
{-0.513948, 0.240498, -0.138720, -0.662282, 0.509964, -0.548845, 3.195631, -0.986481},
{-0.511447, 0.234780, -0.143294, -0.355754, 0.275918, -0.892911, 3.218310, -0.976114},
{-0.507374, 0.227102, -0.144861, -0.135441, 0.117100, -0.983825, 3.242822, -0.973095},
{-0.514319, 0.212063, -0.145500, -0.192511, 0.040864, -0.980438, 3.290240, -0.992785},
{-0.515736, 0.190611, -0.144852, -0.237281, -0.139225, -0.961394, 3.376871, -1.025671},
{-0.523914, 0.221000, -0.129234, -0.979736, 0.161718, -0.118015, 0.238192, -1.079019},
{-0.523000, 0.218438, -0.138065, -0.936583, 0.162633, -0.310343, 0.231484, -1.037960},
{-0.522622, 0.192457, -0.136864, -0.962035, -0.253365, -0.101321, 0.296568, -1.007224},
{-0.522953, 0.194277, -0.127916, -0.966765, -0.255287, 0.012757, 0.320022, -1.046654},
{-0.523219, 0.197105, -0.115065, -0.964171, -0.264718, 0.016480, 0.326902, -1.096315},
{-0.524721, 0.223955, -0.116418, -0.983306, 0.145787, -0.108615, 0.244405, -1.128833},
{-0.516213, 0.246169, -0.117235, -0.779778, 0.583911, -0.225715, 0.160795, -1.162750},
{-0.515157, 0.243471, -0.130037, -0.767418, 0.590808, -0.248970, 0.152944, -1.113801},
{-0.513948, 0.240498, -0.138720, -0.662282, 0.509964, -0.548845, 0.144102, -1.073823},
{-0.510168, 0.169867, -0.126234, -0.819849, -0.569292, 0.060854, 0.395017, -1.019120},
{-0.510643, 0.169672, -0.135079, -0.801111, -0.590381, -0.098209, 0.386793, -0.986527},
{-0.494792, 0.153119, -0.133517, -0.592883, -0.757744, -0.272530, 0.454030, -0.964261},
{-0.493607, 0.151619, -0.124815, -0.651753, -0.758385, 0.002564, 0.466593, -0.994001},
{-0.492294, 0.151266, -0.111882, -0.669668, -0.741142, 0.046968, 0.486330, -1.038276},
{-0.509596, 0.171183, -0.113328, -0.827113, -0.557451, 0.071444, 0.407173, -1.066596},
{-0.510311, 0.170868, -0.139890, -0.595538, -0.526200, -0.606952, 0.378074, -0.970776},
{-0.521564, 0.191154, -0.142145, -0.745720, -0.237739, -0.622364, 0.317055, -0.986740},
{-0.515736, 0.190611, -0.144852, -0.237281, -0.139225, -0.961394, 0.315244, -0.971383},
{-0.505986, 0.172257, -0.142122, -0.205390, -0.307962, -0.928953, 0.369108, -0.963445},
{-0.495619, 0.161699, -0.139782, -0.153356, -0.350566, -0.923856, 0.422971, -0.955508},
{-0.495012, 0.156405, -0.137762, -0.368084, -0.569933, -0.734581, 0.439094, -0.954812},
{0.034136, 0.162122, -0.160028, 0.063906, -0.044801, -0.996948, 3.573690, 1.146783},
{0.033857, 0.183664, -0.159544, 0.069338, 0.062105, -0.995636, 3.504194, 1.151251},
{0.070044, 0.182420, -0.157085, 0.057283, 0.058504, -0.996612, 3.518709, 1.312207},
{0.069354, 0.162236, -0.157617, 0.066317, -0.041780, -0.996918, 3.583820, 1.308506},
{0.068316, 0.146681, -0.156128, 0.096438, -0.245705, -0.964507, 3.634654, 1.304521},
{0.034008, 0.144702, -0.158137, 0.063204, -0.235572, -0.969787, 3.630663, 1.141647},
{-0.006096, 0.144479, -0.160119, 0.033723, -0.245338, -0.968841, 3.619611, 0.955727},
{-0.005787, 0.164026, -0.162570, 0.050539, -0.056520, -0.997101, 3.555596, 0.962147},
{-0.005994, 0.187104, -0.162250, 0.065676, 0.061098, -0.995941, 3.481092, 0.967302},
{0.090757, 0.165436, -0.156368, 0.115177, -0.068056, -0.990997, 3.578467, 1.385464},
{0.094491, 0.184165, -0.155869, 0.071078, 0.044679, -0.996460, 3.518002, 1.388070},
{0.086659, 0.150956, -0.155025, 0.205176, -0.271493, -0.940306, 3.625813, 1.382428},
{0.093885, 0.205150, -0.154014, 0.047426, 0.096438, -0.994201, 3.450424, 1.385560},
{0.068844, 0.205654, -0.154973, 0.050661, 0.107761, -0.992859, 3.444069, 1.312101},
{0.068665, 0.232960, -0.151788, 0.036409, 0.119785, -0.992126, 3.356986, 1.318243},
{0.093762, 0.230367, -0.151249, 0.035463, 0.105319, -0.993774, 3.369946, 1.391403},
{0.032792, 0.208436, -0.157040, 0.066164, 0.122837, -0.990204, 3.424843, 1.153405},
{-0.006706, 0.212667, -0.159438, 0.070315, 0.139317, -0.987732, 3.399384, 0.970981},
{-0.007436, 0.239305, -0.154828, 0.056520, 0.188086, -0.980499, 3.314867, 0.974735},
{0.032373, 0.235951, -0.153129, 0.046907, 0.149815, -0.987579, 3.337306, 1.158626},
{0.117464, 0.329983, 0.245046, 0.257393, -0.238624, 0.936369, 4.071019, -1.030247},
{0.131026, 0.356353, 0.245073, 0.209967, -0.038759, 0.976928, 3.988671, -1.067966},
{0.097440, 0.346017, 0.248463, 0.106052, -0.026124, 0.993988, 4.021969, -0.956406},
{0.089414, 0.319684, 0.247239, 0.138279, -0.197272, 0.970519, 4.103361, -0.927510},
{0.080161, 0.293484, 0.240684, 0.191290, -0.453444, 0.870479, 4.191242, -0.882268},
{0.102300, 0.301936, 0.239745, 0.319315, -0.456069, 0.830653, 4.166824, -0.970429},
{0.115685, 0.308109, 0.235536, 0.470260, -0.483932, 0.737968, 4.147578, -1.011582},
{0.132777, 0.331295, 0.239082, 0.488784, -0.387280, 0.781701, 4.046720, -1.083305},
{0.151186, 0.358606, 0.238691, 0.549272, -0.147923, 0.822413, 3.964492, -1.128154},
{0.044143, 0.303893, 0.250234, 0.139103, -0.254524, 0.956999, 4.151786, -0.725416},
{0.047915, 0.329670, 0.253348, 0.113193, -0.065737, 0.991363, 4.073508, -0.742104},
{-0.004278, 0.314228, 0.258428, 0.111606, -0.105319, 0.988128, 4.121986, -0.508057},
{-0.005355, 0.289649, 0.253412, 0.125980, -0.328715, 0.935972, 4.195084, -0.501788},
{-0.006859, 0.269589, 0.243282, 0.128361, -0.555223, 0.821711, 4.255191, -0.493391},
{0.039578, 0.280794, 0.241915, 0.169439, -0.500473, 0.848964, 4.226006, -0.700092},
{0.047133, 0.357064, 0.253268, 0.085147, 0.133549, 0.987365, 3.987113, -0.741519},
{0.096313, 0.367493, 0.247671, 0.079806, 0.188940, 0.978729, 3.953560, -0.952611},
{0.092602, 0.383569, 0.242088, 0.064547, 0.582080, 0.810541, 3.891641, -0.932470},
{0.045145, 0.380843, 0.247329, 0.059236, 0.492904, 0.868038, 3.896660, -0.732299},
{-0.005009, 0.375821, 0.252445, 0.025544, 0.435011, 0.900052, 3.886339, -0.545195},
{-0.004477, 0.345807, 0.258883, 0.075533, 0.108646, 0.991180, 4.022905, -0.510067},
{0.130373, 0.373610, 0.243967, 0.168432, 0.267190, 0.948790, 3.933236, -1.061487},
{0.151242, 0.375250, 0.237854, 0.533830, 0.362102, 0.764092, 3.919527, -1.119256},
{0.142030, 0.382628, 0.234812, 0.364513, 0.727897, 0.580737, 3.893193, -1.083485},
{0.125326, 0.384436, 0.238814, 0.150182, 0.678457, 0.719077, 3.891258, -1.032911},
{0.034029, 0.265719, -0.148425, 0.014039, 0.194433, -0.980804, 3.243252, 1.172292},
{0.035777, 0.292213, -0.142247, -0.013153, 0.334880, -0.942137, 3.160356, 1.185353},
{0.076468, 0.293496, -0.142758, 0.030152, 0.340770, -0.939634, 3.137401, 1.426726},
{0.072424, 0.265361, -0.148037, 0.018921, 0.156590, -0.987457, 3.254544, 1.340687},
{-0.007696, 0.265614, -0.149115, 0.028260, 0.244972, -0.969085, 3.231939, 0.980119},
{-0.007850, 0.289938, -0.141767, 0.003174, 0.352702, -0.935697, 3.156063, 0.985271},
{0.098943, 0.261793, -0.148019, 0.057802, 0.141606, -0.988220, 3.270781, 1.419066},
{0.105090, 0.289064, -0.142722, 0.191748, 0.345775, -0.918485, 3.162273, 1.457641},
{0.107864, 0.301820, -0.133757, 0.385113, 0.666707, -0.638081, 1.637113, -0.963243},
{0.105090, 0.289064, -0.142722, 0.191748, 0.345775, -0.918485, 1.599312, -0.956954},
{0.076468, 0.293496, -0.142758, 0.030152, 0.340770, -0.939634, 1.605544, -0.920622},
{0.077147, 0.308007, -0.134995, 0.099429, 0.673360, -0.732566, 1.634400, -0.915710},
{0.077456, 0.315854, -0.122192, 0.184423, 0.860866, -0.474197, 1.660271, -0.858522},
{0.109466, 0.307573, -0.119892, 0.472671, 0.799799, -0.369945, 1.684895, -0.971377},
{0.130691, 0.288322, -0.117138, 0.843287, 0.471236, -0.258370, 1.692047, -1.024906},
{0.128020, 0.283307, -0.132053, 0.760582, 0.419568, -0.495437, 1.639825, -1.010776},
{0.123335, 0.272385, -0.142595, 0.477432, 0.261422, -0.838832, 1.593080, -0.993286},
{0.035635, 0.309902, -0.133914, 0.008637, 0.586474, -0.809900, 3.106289, 1.188762},
{0.077147, 0.308007, -0.134995, 0.099429, 0.673360, -0.732566, 3.117857, 1.411951},
{-0.008262, 0.310623, -0.132251, 0.011414, 0.524644, -0.851222, 3.092703, 0.988330},
{-0.008464, 0.327729, -0.119277, 0.065889, 0.716392, -0.694540, 3.035601, 0.990344},
{0.035536, 0.322420, -0.121228, 0.087619, 0.794031, -0.601489, 3.066639, 1.187344},
{0.077456, 0.315854, -0.122192, 0.184423, 0.860866, -0.474197, 3.100977, 1.405246},
{0.032910, 0.124207, -0.135644, 0.243782, -0.969817, -0.001709, 0.166018, 1.215065},
{0.033527, 0.125327, -0.146057, 0.182257, -0.897763, -0.400952, 0.127868, 1.219506},
{0.069019, 0.133767, -0.145348, 0.287454, -0.936094, -0.202551, 0.144160, 1.388589},
{0.069149, 0.135554, -0.135247, 0.322977, -0.937712, 0.127812, 0.185088, 1.386859},
{0.069046, 0.137581, -0.121744, 0.318064, -0.948057, -0.001526, 0.228460, 1.384739},
{0.032249, 0.125667, -0.121936, 0.251106, -0.965514, 0.068514, 0.209282, 1.210774},
{-0.010811, 0.114920, -0.121556, 0.155950, -0.984344, 0.081729, 0.192626, 1.012804},
{-0.009541, 0.114949, -0.135492, 0.117252, -0.974548, -0.190954, 0.150504, 1.019487},
{-0.008133, 0.119532, -0.146322, 0.054109, -0.820582, -0.568926, 0.116195, 1.026901},
{0.087664, 0.143235, -0.134808, 0.490463, -0.856227, 0.162114, 0.197645, 1.468788},
{0.087205, 0.140285, -0.144795, 0.492386, -0.863826, -0.106326, 0.155403, 1.469530},
{0.099527, 0.150233, -0.144305, 0.672018, -0.727226, -0.139592, 0.164121, 1.506401},
{0.100554, 0.153410, -0.134183, 0.655263, -0.745079, 0.124149, 0.206945, 1.505785},
{0.100836, 0.155437, -0.120646, 0.669027, -0.741997, -0.042146, 0.249532, 1.504523},
{0.087761, 0.145233, -0.121397, 0.490860, -0.869533, -0.053987, 0.240725, 1.467446},
{0.086173, 0.142715, -0.151351, 0.378857, -0.628529, -0.679250, 3.654038, 1.383648},
{0.087205, 0.140285, -0.144795, 0.492386, -0.863826, -0.106326, 3.672701, 1.386996},
{0.069019, 0.133767, -0.145348, 0.287454, -0.936094, -0.202551, 3.688757, 1.304651},
{0.068473, 0.137334, -0.152173, 0.186316, -0.635792, -0.748985, 3.666462, 1.303776},
{0.033849, 0.132298, -0.153518, 0.098880, -0.564440, -0.819514, 3.672446, 1.137486},
{0.033527, 0.125327, -0.146057, 0.182257, -0.897763, -0.400952, 3.706634, 1.133812},
{-0.008133, 0.119532, -0.146322, 0.054109, -0.820582, -0.568926, 3.713215, 0.940257},
{-0.006931, 0.129512, -0.154617, 0.025758, -0.524552, -0.850948, 3.669856, 0.948255},
{-0.429666, 0.218267, -0.148437, -0.037294, 0.047212, -0.998169, 3.285807, -0.708920},
{-0.431026, 0.193605, -0.148582, -0.041810, -0.048006, -0.997955, 3.365141, -0.720481},
{-0.474053, 0.192186, -0.146947, -0.034913, -0.070925, -0.996857, 3.358911, -0.913767},
{-0.471652, 0.215066, -0.147199, -0.030152, 0.033753, -0.998962, 3.285491, -0.897553},
{-0.468302, 0.236098, -0.145771, -0.034089, 0.117496, -0.992462, 3.218820, -0.879434},
{-0.428001, 0.241540, -0.146496, -0.038575, 0.126347, -0.991211, 3.211705, -0.696691},
{-0.380199, 0.246719, -0.147785, -0.046449, 0.139683, -0.989074, 3.207740, -0.471630},
{-0.380163, 0.221736, -0.150314, -0.048402, 0.061678, -0.996918, 3.287531, -0.477763},
{-0.380224, 0.195885, -0.150889, -0.050233, -0.028871, -0.998291, 3.370839, -0.484637},
{-0.498856, 0.212585, -0.146547, -0.049898, 0.027497, -0.998352, 3.289221, -0.974673},
{-0.501094, 0.191072, -0.146078, -0.054811, -0.092410, -0.994201, 3.358147, -0.993273},
{-0.494617, 0.232078, -0.145396, -0.058565, 0.113773, -0.991760, 3.227620, -0.953537},
{-0.494482, 0.172642, -0.143232, -0.065706, -0.221229, -0.972991, 3.419475, -0.986379},
{-0.470711, 0.172134, -0.144275, -0.051149, -0.185369, -0.981323, 3.425270, -0.909740},
{-0.465973, 0.156273, -0.140680, -0.074618, -0.263955, -0.961608, 3.478750, -0.899365},
{-0.486181, 0.158611, -0.139708, -0.087954, -0.297861, -0.950530, 3.467227, -0.971950},
{-0.495619, 0.161699, -0.139782, -0.153356, -0.350566, -0.923856, 3.462793, -0.990065},
{-0.505986, 0.172257, -0.142122, -0.205390, -0.307962, -0.928953, 3.418084, -1.006991},
{-0.429588, 0.170844, -0.146308, -0.053713, -0.150212, -0.987182, 3.439872, -0.721046},
{-0.379718, 0.170927, -0.149027, -0.052583, -0.125919, -0.990631, 3.452305, -0.489299},
{-0.379107, 0.148267, -0.145226, -0.055147, -0.221320, -0.973632, 3.527095, -0.493111},
{-0.427361, 0.151443, -0.142628, -0.070437, -0.236335, -0.969085, 3.504450, -0.717840},
{-0.429280, 0.284968, 0.253064, -0.107578, -0.414075, 0.903836, 4.177323, 1.186567},
{-0.432272, 0.304993, 0.258951, -0.137059, -0.190008, 0.972137, 4.119009, 1.196275},
{-0.476307, 0.310782, 0.253400, -0.117832, -0.093936, 0.988556, 4.092335, 1.392833},
{-0.470618, 0.290112, 0.250213, -0.090304, -0.320933, 0.942778, 4.155094, 1.376221},
{-0.464185, 0.270936, 0.241790, -0.083224, -0.579974, 0.810327, 4.217585, 1.349624},
{-0.426165, 0.267334, 0.242557, -0.086123, -0.606220, 0.790613, 4.227448, 1.170803},
{-0.379737, 0.263763, 0.243484, -0.061800, -0.636372, 0.768853, 4.239873, 0.939309},
{-0.380559, 0.279767, 0.256116, -0.080844, -0.503952, 0.859920, 4.206395, 0.941792},
{-0.381755, 0.298817, 0.264585, -0.098666, -0.266427, 0.958770, 4.183081, 0.899609},
{-0.495099, 0.292029, 0.249041, -0.166234, -0.326640, 0.930387, 4.146549, 1.455633},
{-0.504340, 0.312544, 0.250996, -0.194311, -0.060854, 0.979034, 4.083170, 1.475792},
{-0.519615, 0.308402, 0.246127, -0.543901, -0.187994, 0.817805, 4.082760, 1.501952},
{-0.507080, 0.288426, 0.244286, -0.393750, -0.479995, 0.783898, 4.144846, 1.479923},
{-0.494923, 0.274547, 0.238562, -0.318339, -0.627369, 0.710654, 4.210674, 1.443900},
{-0.484721, 0.272600, 0.241476, -0.172765, -0.594531, 0.785241, 4.212848, 1.423099},
{-0.504718, 0.330339, 0.249152, -0.241462, 0.248726, 0.937956, 4.025632, 1.471202},
{-0.476181, 0.330784, 0.253003, -0.158055, 0.166021, 0.973357, 4.029039, 1.389474},
{-0.475080, 0.347259, 0.247402, -0.219092, 0.535020, 0.815912, 3.958963, 1.442475},
{-0.503154, 0.343441, 0.242918, -0.312174, 0.600818, 0.735893, 3.971015, 1.454237},
{-0.516435, 0.337890, 0.239851, -0.563189, 0.540666, 0.624866, 3.977303, 1.476040},
{-0.521230, 0.326977, 0.244095, -0.629597, 0.226600, 0.743126, 4.028160, 1.495993},
{-0.432201, 0.329293, 0.261118, -0.163579, 0.068270, 0.984130, 4.044313, 1.193873},
{-0.381890, 0.326657, 0.268801, -0.100314, 0.015839, 0.994812, 4.063555, 0.960407},
{-0.381979, 0.356117, 0.264299, -0.104404, 0.390271, 0.914731, 3.966977, 0.958144},
{-0.431755, 0.352608, 0.256281, -0.204291, 0.438887, 0.874996, 3.966841, 1.190104},
{-0.495227, 0.244447, -0.143386, -0.144139, 0.317881, -0.937071, 3.188268, -0.952819},
{-0.497635, 0.251519, -0.138864, -0.329783, 0.663686, -0.671346, 3.160040, -0.962311},
{-0.470725, 0.260106, -0.138555, -0.205786, 0.605609, -0.768670, 3.136873, -0.884270},
{-0.468796, 0.250609, -0.143400, -0.077181, 0.294259, -0.952574, 3.172707, -0.877744},
{-0.428526, 0.260135, -0.143378, -0.066195, 0.258919, -0.963622, 3.152669, -0.694124},
{-0.429882, 0.274863, -0.137853, -0.160894, 0.482528, -0.860958, 3.101166, -0.696388},
{-0.382097, 0.288891, -0.137442, -0.096927, 0.404126, -0.909543, 3.056289, -0.514032},
{-0.380995, 0.269075, -0.143782, -0.055239, 0.244911, -0.967956, 3.136823, -0.469190},
{-0.430706, 0.286537, -0.128694, -0.297098, 0.670583, -0.679708, 1.653203, 1.182513},
{-0.429882, 0.274863, -0.137853, -0.160894, 0.482528, -0.860958, 1.612145, 1.185135},
{-0.470725, 0.260106, -0.138555, -0.205786, 0.605609, -0.768670, 1.601713, 1.375778},
{-0.471680, 0.266097, -0.129707, -0.345775, 0.795709, -0.497208, 1.638979, 1.376080},
{-0.472527, 0.271235, -0.116901, -0.426466, 0.814539, -0.393200, 1.683045, 1.377474},
{-0.431412, 0.296557, -0.115925, -0.404065, 0.743492, -0.532792, 1.699944, 1.180665},
{-0.383820, 0.321215, -0.115134, -0.259041, 0.702719, -0.662587, 1.705322, 0.883945},
{-0.383048, 0.306258, -0.127899, -0.174200, 0.572863, -0.800897, 1.670797, 0.932901},
{-0.382097, 0.288891, -0.137442, -0.096927, 0.404126, -0.909543, 1.624855, 0.939148},
{-0.498788, 0.255123, -0.130175, -0.449538, 0.822352, -0.348766, 1.631497, 1.457559},
{-0.497635, 0.251519, -0.138864, -0.329783, 0.663686, -0.671346, 1.595837, 1.455732},
{-0.513948, 0.240498, -0.138720, -0.662282, 0.509964, -0.548845, 1.592239, 1.480341},
{-0.515157, 0.243471, -0.130037, -0.767418, 0.590808, -0.248970, 1.627385, 1.482994},
{-0.516213, 0.246169, -0.117235, -0.779778, 0.583911, -0.225715, 1.669838, 1.487247},
{-0.499804, 0.258184, -0.117367, -0.488052, 0.820307, -0.298135, 1.674383, 1.460745},
{-0.481317, 0.143382, -0.124284, -0.454665, -0.884976, -0.100345, 0.172135, -0.887378},
{-0.482796, 0.145833, -0.132982, -0.368450, -0.810846, -0.454634, 0.138621, -0.893373},
{-0.463506, 0.139647, -0.132846, -0.257820, -0.761406, -0.594775, 0.133746, -0.820081},
{-0.462108, 0.135753, -0.123881, -0.362468, -0.907529, -0.212012, 0.165864, -0.814834},
{-0.460699, 0.134510, -0.110987, -0.383801, -0.922727, 0.034608, 0.203162, -0.811172},
{-0.479752, 0.142432, -0.111403, -0.470962, -0.881924, 0.019684, 0.209692, -0.883116},
{-0.492294, 0.151266, -0.111882, -0.669668, -0.741142, 0.046968, 0.213135, -0.902672},
{-0.493607, 0.151619, -0.124815, -0.651753, -0.758385, 0.002564, 0.175232, -0.906895},
{-0.494792, 0.153119, -0.133517, -0.592883, -0.757744, -0.272530, 0.141018, -0.912840},
{-0.424790, 0.119329, -0.122845, -0.328410, -0.879421, -0.344554, 0.153241, -0.636235},
{-0.425772, 0.126394, -0.132484, -0.209326, -0.664541, -0.717307, 0.123917, -0.639140},
{-0.378729, 0.114331, -0.132537, -0.110965, -0.583300, -0.804590, 0.111610, -0.404374},
{-0.378511, 0.103591, -0.122106, -0.195227, -0.854671, -0.481002, 0.137444, -0.404609},
{-0.378338, 0.100399, -0.108693, -0.238472, -0.967162, 0.087588, 0.156393, -0.362065},
{-0.423861, 0.117329, -0.109733, -0.367443, -0.927244, 0.071657, 0.190455, -0.634454},
{-0.426360, 0.136863, -0.138549, -0.109928, -0.395032, -0.912046, 3.553326, -0.718092},
{-0.425772, 0.126394, -0.132484, -0.209326, -0.664541, -0.717307, 3.594349, -0.720073},
{-0.463506, 0.139647, -0.132846, -0.257820, -0.761406, -0.594775, 3.538966, -0.897483},
{-0.464183, 0.145966, -0.137658, -0.132664, -0.451186, -0.882473, 3.513533, -0.896537},
{-0.378852, 0.129313, -0.139987, -0.066256, -0.362346, -0.929655, 3.590374, -0.497435},
{-0.378729, 0.114331, -0.132537, -0.110965, -0.583300, -0.804590, 3.655464, -0.547771},
{-0.483351, 0.150292, -0.137207, -0.195776, -0.513810, -0.835231, 3.495425, -0.967945},
{-0.482796, 0.145833, -0.132982, -0.368450, -0.810846, -0.454634, 3.513845, -0.969151},
{-0.494792, 0.153119, -0.133517, -0.592883, -0.757744, -0.272530, 3.503854, -0.987950},
{-0.495012, 0.156405, -0.137762, -0.368084, -0.569933, -0.734581, 3.488159, -0.985834},
{0.136295, 0.290064, 0.181430, 0.841884, -0.529191, 0.105502, 1.352906, -1.273948},
{0.154832, 0.326719, 0.182635, 0.960204, -0.238655, -0.144993, 1.237812, -1.226472},
{0.160925, 0.338223, 0.205486, 0.961241, -0.268105, 0.063997, 1.222649, -1.128850},
{0.140421, 0.303904, 0.204697, 0.770592, -0.553453, 0.315928, 1.331377, -1.172593},
{0.114751, 0.274624, 0.204253, 0.623890, -0.642720, 0.444533, 1.451855, -1.220606},
{0.112868, 0.259790, 0.180543, 0.694296, -0.659505, 0.288003, 1.476640, -1.325062},
{0.109702, 0.246373, 0.154824, 0.750359, -0.625996, 0.212287, 1.495619, -1.435301},
{0.130214, 0.278005, 0.155800, 0.882656, -0.469466, 0.021912, 1.367103, -1.382345},
{0.146385, 0.316543, 0.157028, 0.962981, -0.213965, -0.163823, 1.246763, -1.333160},
{0.139839, 0.320125, 0.224773, 0.656789, -0.507645, 0.557543, 1.300532, -1.081190},
{0.160431, 0.350708, 0.224833, 0.861446, -0.251259, 0.441267, 1.202680, -1.044277},
{0.151186, 0.358606, 0.238691, 0.549272, -0.147923, 0.822413, 1.180308, -0.966229},
{0.132777, 0.331295, 0.239082, 0.488784, -0.387280, 0.781701, 1.265028, -0.994764},
{0.115685, 0.308109, 0.235536, 0.470260, -0.483932, 0.737968, 1.370279, -1.032290},
{0.114078, 0.292453, 0.224841, 0.543504, -0.571551, 0.614734, 1.414268, -1.124388},
{0.160851, 0.372245, 0.225032, 0.890988, 0.369610, 0.263619, 1.136598, -1.019933},
{0.161485, 0.366221, 0.206670, 0.941557, 0.295907, -0.160955, 1.137422, -1.093646},
{0.147994, 0.385723, 0.207856, 0.608173, 0.784082, -0.123661, 1.063946, -1.062711},
{0.147233, 0.385569, 0.225584, 0.508225, 0.829005, 0.233222, 1.086401, -1.001874},
{0.142030, 0.382628, 0.234812, 0.364513, 0.727897, 0.580737, 1.113521, -0.954116},
{0.151242, 0.375250, 0.237854, 0.533830, 0.362102, 0.764092, 1.136649, -0.955677},
{0.155429, 0.358802, 0.183933, 0.920316, 0.231910, -0.314951, 1.139997, -1.186271},
{0.147471, 0.350511, 0.158114, 0.942534, 0.183782, -0.278909, 1.142774, -1.291521},
{0.136602, 0.375795, 0.158982, 0.715506, 0.627186, -0.307627, 1.046961, -1.253654},
{0.142898, 0.382322, 0.185046, 0.659810, 0.691153, -0.294809, 1.050821, -1.149707},
{-0.510915, 0.277009, 0.230686, -0.557085, -0.631550, 0.539201, 0.497956, -2.439312},
{-0.525379, 0.296478, 0.233185, -0.824458, -0.347026, 0.446974, 0.440912, -2.475715},
{-0.525414, 0.283353, 0.213949, -0.901669, -0.398572, 0.167577, 0.457774, -2.388833},
{-0.510402, 0.263895, 0.210826, -0.631642, -0.701498, 0.329966, 0.514112, -2.350204},
{-0.493023, 0.252151, 0.207694, -0.417188, -0.819361, 0.393139, 0.555992, -2.314099},
{-0.493511, 0.263480, 0.227556, -0.372967, -0.744011, 0.554338, 0.547705, -2.399521},
{-0.494923, 0.274547, 0.238562, -0.318339, -0.627369, 0.710654, 0.535590, -2.481704},
{-0.507080, 0.288426, 0.244286, -0.393750, -0.479995, 0.783898, 0.472941, -2.524954},
{-0.519615, 0.308402, 0.246127, -0.543901, -0.187994, 0.817805, 0.413329, -2.558287},
{-0.509338, 0.255202, 0.187287, -0.699850, -0.690085, 0.184210, 0.512548, -2.254159},
{-0.523503, 0.275608, 0.190198, -0.930204, -0.366436, 0.019440, 0.453194, -2.293328},
{-0.521371, 0.271564, 0.164040, -0.951109, -0.308725, -0.004730, 0.434549, -2.194417},
{-0.508331, 0.248850, 0.161571, -0.769677, -0.623890, 0.135258, 0.501283, -2.153635},
{-0.492466, 0.234406, 0.160293, -0.557237, -0.784814, 0.271096, 0.556198, -2.121643},
{-0.492730, 0.243155, 0.185098, -0.477157, -0.827540, 0.295724, 0.556622, -2.222197},
{-0.528244, 0.306317, 0.193156, -0.991821, 0.029878, -0.124058, 0.363279, -2.346910},
{-0.530718, 0.311761, 0.215024, -0.999695, 0.023804, 0.000061, 0.372518, -2.432510},
{-0.525677, 0.338150, 0.215305, -0.849483, 0.526170, -0.038606, 0.272804, -2.478710},
{-0.522970, 0.335257, 0.195483, -0.853328, 0.484603, -0.192175, 0.258085, -2.407699},
{-0.518358, 0.331935, 0.171733, -0.856380, 0.487197, -0.170904, 0.241327, -2.350678},
{-0.524674, 0.302920, 0.168100, -0.992157, 0.064577, -0.106845, 0.344177, -2.252781},
{-0.529139, 0.319716, 0.232362, -0.944945, 0.097537, 0.312265, 0.369274, -2.505341},
{-0.521230, 0.326977, 0.244095, -0.629597, 0.226600, 0.743126, 0.359788, -2.571787},
{-0.516435, 0.337890, 0.239851, -0.563189, 0.540666, 0.624866, 0.309284, -2.575371},
{-0.522700, 0.339817, 0.230954, -0.756798, 0.575396, 0.310099, 0.290340, -2.531577},
{0.122052, 0.393285, 0.185697, 0.308329, 0.934721, -0.176550, 2.714849, -1.041810},
{0.089975, 0.398790, 0.186824, 0.158940, 0.984527, -0.073702, 2.722019, -0.945086},
{0.093280, 0.398559, 0.209944, 0.117985, 0.984527, 0.129368, 2.796063, -0.955599},
{0.126347, 0.394556, 0.208651, 0.250435, 0.967864, 0.021790, 2.789202, -1.056919},
{0.147994, 0.385723, 0.207856, 0.608173, 0.784082, -0.123661, 2.785058, -1.108907},
{0.142898, 0.382322, 0.185046, 0.659810, 0.691153, -0.294809, 2.710610, -1.090394},
{0.136602, 0.375795, 0.158982, 0.715506, 0.627186, -0.307627, 2.623093, -1.066094},
{0.116906, 0.388284, 0.159553, 0.364635, 0.894498, -0.258583, 2.628131, -1.021673},
{0.086014, 0.395473, 0.160705, 0.210150, 0.962188, -0.173132, 2.636327, -0.930366},
{0.125712, 0.391512, 0.226699, 0.186712, 0.921018, 0.341777, 2.845412, -1.051365},
{0.092873, 0.393705, 0.228939, 0.081301, 0.890378, 0.447859, 2.854271, -0.949831},
{0.092602, 0.383569, 0.242088, 0.064547, 0.582080, 0.810541, 2.904561, -0.935923},
{0.125326, 0.384436, 0.238814, 0.150182, 0.678457, 0.719077, 2.892550, -1.035480},
{0.142030, 0.382628, 0.234812, 0.364513, 0.727897, 0.580737, 2.883749, -1.085260},
{0.147233, 0.385569, 0.225584, 0.508225, 0.829005, 0.233222, 2.839424, -1.103151},
{0.045301, 0.395775, 0.232866, 0.063173, 0.831355, 0.552110, 2.868873, -0.748801},
{0.045527, 0.403570, 0.212627, 0.097690, 0.967925, 0.231361, 2.808357, -0.755615},
{-0.004810, 0.407178, 0.215524, 0.045869, 0.938719, 0.341594, 2.843613, -0.471266},
{-0.004930, 0.395708, 0.236785, 0.010163, 0.766411, 0.642232, 2.886346, -0.498022},
{-0.005009, 0.375821, 0.252445, 0.025544, 0.435011, 0.900052, 2.944632, -0.487929},
{0.045145, 0.380843, 0.247329, 0.059236, 0.492904, 0.868038, 2.922992, -0.736814},
{0.043750, 0.405935, 0.189362, 0.138310, 0.990204, 0.018677, 2.735048, -0.752082},
{0.041556, 0.404857, 0.163314, 0.185369, 0.979553, -0.078036, 2.650840, -0.745287},
{-0.005838, 0.412917, 0.166426, 0.123508, 0.992309, 0.002838, 2.666298, -0.537438},
{-0.005220, 0.411946, 0.192281, 0.088748, 0.989807, 0.111301, 2.748737, -0.537149},
{0.098153, 0.279648, 0.225025, 0.371929, -0.633259, 0.678671, 1.452964, 1.464948},
{0.077606, 0.272410, 0.225483, 0.229377, -0.675192, 0.701041, 1.443461, 1.375139},
{0.077788, 0.255241, 0.204490, 0.239570, -0.794946, 0.557360, 1.359319, 1.378182},
{0.098696, 0.261743, 0.204104, 0.409070, -0.741325, 0.532029, 1.368198, 1.469343},
{0.114751, 0.274624, 0.204253, 0.623890, -0.642720, 0.444533, 1.374870, 1.512478},
{0.114078, 0.292453, 0.224841, 0.543504, -0.571551, 0.614734, 1.459700, 1.507208},
{0.115685, 0.308109, 0.235536, 0.470260, -0.483932, 0.737968, 1.541614, 1.498470},
{0.102300, 0.301936, 0.239745, 0.319315, -0.456069, 0.830653, 1.534921, 1.457656},
{0.080161, 0.293484, 0.240684, 0.191290, -0.453444, 0.870479, 1.524689, 1.369977},
{0.097603, 0.246846, 0.180200, 0.439039, -0.793207, 0.421918, 1.277812, 1.467945},
{0.076745, 0.240760, 0.180558, 0.240303, -0.850459, 0.467879, 1.269346, 1.376988},
{0.075071, 0.227234, 0.154889, 0.240181, -0.861599, 0.447127, 1.175183, 1.373629},
{0.095593, 0.233124, 0.154493, 0.466567, -0.797662, 0.382092, 1.183266, 1.463304},
{0.109702, 0.246373, 0.154824, 0.750359, -0.625996, 0.212287, 1.189184, 1.505120},
{0.112868, 0.259790, 0.180543, 0.694296, -0.659505, 0.288003, 1.284208, 1.510812},
{0.036540, 0.231055, 0.181773, 0.207038, -0.858852, 0.468459, 1.256740, 1.189852},
{0.037564, 0.245096, 0.205652, 0.202704, -0.809381, 0.551134, 1.346025, 1.190969},
{-0.008840, 0.235575, 0.207113, 0.149541, -0.816279, 0.557909, 1.333787, 0.980097},
{-0.009813, 0.221586, 0.183255, 0.161016, -0.864620, 0.475906, 1.244632, 0.979174},
{-0.010619, 0.208165, 0.157430, 0.163396, -0.873470, 0.458571, 1.150206, 0.979158},
{0.035320, 0.217679, 0.156094, 0.207953, -0.866451, 0.453841, 1.162768, 1.188237},
{0.037981, 0.261435, 0.226377, 0.191687, -0.700095, 0.687826, 1.428423, 1.190232},
{0.039578, 0.280794, 0.241915, 0.169439, -0.500473, 0.848964, 1.507378, 1.188568},
{-0.006859, 0.269589, 0.243282, 0.128361, -0.555223, 0.821711, 1.491626, 0.982526},
{-0.007938, 0.251570, 0.227486, 0.135197, -0.717551, 0.683218, 1.414754, 0.981253},
{-0.434700, 0.384871, 0.197324, -0.403241, 0.912076, 0.073733, 2.756219, 1.169504},
{-0.478396, 0.363075, 0.196890, -0.420850, 0.905942, -0.045747, 2.743120, 1.374178},
{-0.480333, 0.362228, 0.217536, -0.361370, 0.917417, 0.166417, 2.827977, 1.379236},
{-0.435407, 0.380445, 0.220060, -0.337565, 0.888791, 0.309885, 2.831157, 1.179495},
{-0.384211, 0.396753, 0.222230, -0.194555, 0.882321, 0.428480, 2.844915, 0.931938},
{-0.384661, 0.404687, 0.197633, -0.249367, 0.951170, 0.181799, 2.767631, 0.928312},
{-0.384471, 0.407110, 0.171547, -0.281808, 0.958922, 0.031343, 2.685266, 0.924138},
{-0.432885, 0.385428, 0.172115, -0.447035, 0.893857, -0.033876, 2.675578, 1.160286},
{-0.474848, 0.361595, 0.172700, -0.465590, 0.878750, -0.104862, 2.643456, 1.418970},
{-0.433624, 0.369674, 0.241153, -0.261940, 0.752403, 0.604327, 3.900197, 1.195710},
{-0.435407, 0.380445, 0.220060, -0.337565, 0.888791, 0.309885, 3.838966, 1.206005},
{-0.480333, 0.362228, 0.217536, -0.361370, 0.917417, 0.166417, 3.906042, 1.469154},
{-0.477846, 0.357348, 0.234976, -0.288644, 0.822291, 0.490371, 3.935384, 1.450794},
{-0.383034, 0.380022, 0.246614, -0.134800, 0.713492, 0.687521, 3.876695, 0.960028},
{-0.384211, 0.396753, 0.222230, -0.194555, 0.882321, 0.428480, 3.789562, 0.963986},
{-0.506570, 0.349879, 0.231701, -0.408887, 0.830378, 0.378460, 2.847642, 1.463779},
{-0.477846, 0.357348, 0.234976, -0.288644, 0.822291, 0.490371, 2.856286, 1.436109},
{-0.509652, 0.351551, 0.216047, -0.492752, 0.869472, 0.034516, 2.798390, 1.473254},
{-0.525677, 0.338150, 0.215305, -0.849483, 0.526170, -0.038606, 2.791425, 1.504073},
{-0.522700, 0.339817, 0.230954, -0.756798, 0.575396, 0.310099, 2.838999, 1.491448},
{-0.516435, 0.337890, 0.239851, -0.563189, 0.540666, 0.624866, 2.879231, 1.466951},
{-0.503154, 0.343441, 0.242918, -0.312174, 0.600818, 0.735893, 2.889786, 1.444250},
{-0.475080, 0.347259, 0.247402, -0.219092, 0.535020, 0.815912, 2.900340, 1.421550},
{-0.507087, 0.350356, 0.196502, -0.537919, 0.829798, -0.148381, 2.734920, 1.462622},
{-0.502544, 0.347629, 0.172920, -0.568712, 0.806513, -0.161412, 2.664341, 1.441936},
{-0.518358, 0.331935, 0.171733, -0.856380, 0.487197, -0.170904, 2.659574, 1.469955},
{-0.522970, 0.335257, 0.195483, -0.853328, 0.484603, -0.192175, 2.729170, 1.492951},
{-0.425871, 0.250204, 0.226531, -0.106662, -0.738456, 0.665761, 1.368176, -0.683105},
{-0.462083, 0.255419, 0.226480, -0.118931, -0.772454, 0.623798, 1.369819, -0.857883},
{-0.462153, 0.242851, 0.206459, -0.182653, -0.860195, 0.476058, 1.294088, -0.855824},
{-0.426609, 0.234804, 0.206233, -0.161443, -0.831202, 0.531968, 1.288162, -0.683630},
{-0.381986, 0.226915, 0.206225, -0.102481, -0.809168, 0.578539, 1.284082, -0.471928},
{-0.380724, 0.245060, 0.226776, -0.070803, -0.709861, 0.700736, 1.368188, -0.469367},
{-0.379737, 0.263763, 0.243484, -0.061800, -0.636372, 0.768853, 1.460410, -0.508431},
{-0.426165, 0.267334, 0.242557, -0.086123, -0.606220, 0.790613, 1.445400, -0.680901},
{-0.464185, 0.270936, 0.241790, -0.083224, -0.579974, 0.810327, 1.443045, -0.859780},
{-0.426590, 0.222360, 0.182910, -0.206854, -0.882382, 0.422559, 1.202569, -0.680794},
{-0.462239, 0.232520, 0.183908, -0.231452, -0.890774, 0.391064, 1.213346, -0.853441},
{-0.462256, 0.222428, 0.159155, -0.246590, -0.891903, 0.379009, 1.126217, -0.850497},
{-0.426414, 0.211322, 0.157404, -0.222144, -0.897488, 0.380932, 1.112043, -0.677037},
{-0.381795, 0.200745, 0.155672, -0.135044, -0.913205, 0.384381, 1.099529, -0.465191},
{-0.381991, 0.212584, 0.182063, -0.127262, -0.884182, 0.449416, 1.193691, -0.469120},
{-0.480658, 0.237523, 0.184304, -0.309702, -0.881252, 0.357006, 1.218751, -0.923136},
{-0.480615, 0.246884, 0.206592, -0.260323, -0.864193, 0.430525, 1.297534, -0.925673},
{-0.493023, 0.252151, 0.207694, -0.417188, -0.819361, 0.393139, 1.299741, -0.944350},
{-0.492730, 0.243155, 0.185098, -0.477157, -0.827540, 0.295724, 1.221470, -0.941355},
{-0.492466, 0.234406, 0.160293, -0.557237, -0.784814, 0.271096, 1.135827, -0.938210},
{-0.480690, 0.227860, 0.159803, -0.349895, -0.866756, 0.355327, 1.132896, -0.920274},
{-0.480932, 0.258064, 0.226488, -0.209815, -0.785089, 0.582720, 1.371193, -0.929227},
{-0.484721, 0.272600, 0.241476, -0.172765, -0.594531, 0.785241, 1.442289, -0.933290},
{-0.494923, 0.274547, 0.238562, -0.318339, -0.627369, 0.710654, 1.442334, -0.954116},
{-0.493511, 0.263480, 0.227556, -0.372967, -0.744011, 0.554338, 1.372432, -0.948855},
{0.119480, 0.243000, 0.076296, 0.918943, -0.365856, 0.147160, 1.401689, -1.714239},
{0.133698, 0.286025, 0.076628, 0.969909, -0.229225, 0.081637, 1.267031, -1.663706},
{0.135470, 0.298713, 0.101903, 0.975341, -0.220618, -0.001190, 1.251594, -1.556782},
{0.121129, 0.255952, 0.101581, 0.922025, -0.377575, 0.085177, 1.385473, -1.607009},
{0.104023, 0.219420, 0.101736, 0.819514, -0.534745, 0.205878, 1.534858, -1.661406},
{0.102851, 0.206603, 0.076453, 0.823054, -0.522904, 0.221564, 1.550536, -1.768552},
{0.102271, 0.195801, 0.052444, 0.820490, -0.539109, 0.189978, 1.559455, -1.868162},
{0.118908, 0.230591, 0.052413, 0.914487, -0.375774, 0.149846, 1.417304, -1.815519},
{0.133285, 0.272784, 0.052838, 0.965941, -0.236946, 0.103854, 1.285284, -1.765541},
{0.124932, 0.267128, 0.128633, 0.910123, -0.413434, 0.026490, 1.375952, -1.494871},
{0.139814, 0.308047, 0.129410, 0.972777, -0.211127, -0.095309, 1.248098, -1.444932},
{0.106531, 0.232797, 0.128207, 0.795282, -0.574969, 0.192053, 1.515788, -1.548869},
{0.142400, 0.341867, 0.130508, 0.974609, 0.132694, -0.180212, 1.144209, -1.403108},
{0.139654, 0.332097, 0.103063, 0.991852, 0.081362, -0.097842, 1.148726, -1.514892},
{0.133015, 0.356047, 0.104236, 0.809656, 0.539628, -0.230689, 1.061363, -1.477172},
{0.133767, 0.366570, 0.131493, 0.769951, 0.581317, -0.263100, 1.052302, -1.365343},
{0.138672, 0.320426, 0.077728, 0.998474, 0.044038, -0.033174, 1.160752, -1.620732},
{0.138669, 0.308890, 0.053852, 0.999756, 0.021241, 0.001709, 1.173526, -1.720892},
{0.133371, 0.336438, 0.054915, 0.866298, 0.478256, -0.144200, 1.071898, -1.678907},
{0.132969, 0.345627, 0.078864, 0.840297, 0.505264, -0.196356, 1.068663, -1.581537},
{-0.507987, 0.242757, 0.135179, -0.823298, -0.548509, 0.145878, 0.488337, -2.051087},
{-0.520745, 0.269542, 0.137580, -0.964202, -0.262123, 0.039491, 0.409218, -2.097316},
{-0.521780, 0.266829, 0.111144, -0.964507, -0.237587, 0.115177, 0.385790, -1.999387},
{-0.508702, 0.236155, 0.108830, -0.845454, -0.498428, 0.191565, 0.476848, -1.948020},
{-0.492214, 0.212858, 0.107079, -0.679708, -0.676351, 0.283670, 0.567003, -1.897293},
{-0.492062, 0.223815, 0.133805, -0.633168, -0.723167, 0.275826, 0.561322, -2.010266},
{-0.510868, 0.228275, 0.083246, -0.846675, -0.481185, 0.227088, 0.469957, -1.845938},
{-0.524634, 0.260712, 0.085053, -0.958800, -0.231178, 0.165044, 0.372853, -1.897995},
{-0.527283, 0.252860, 0.059742, -0.963805, -0.232948, 0.129398, 0.366140, -1.796942},
{-0.512851, 0.219940, 0.058520, -0.851070, -0.485397, 0.200079, 0.465489, -1.746271},
{-0.494880, 0.194141, 0.057108, -0.705283, -0.663533, 0.249519, 0.566465, -1.692638},
{-0.493614, 0.203013, 0.081562, -0.697043, -0.658559, 0.283547, 0.568248, -1.791950},
{-0.526385, 0.292403, 0.086142, -0.989746, 0.122868, 0.072481, 0.278127, -1.946187},
{-0.523427, 0.298418, 0.113523, -0.992676, 0.113773, 0.039857, 0.292922, -2.052032},
{-0.515327, 0.324983, 0.115255, -0.853328, 0.518632, -0.053102, 0.215024, -2.095204},
{-0.518057, 0.318527, 0.086662, -0.847987, 0.527451, -0.051546, 0.200151, -1.984416},
{-0.520768, 0.310660, 0.059525, -0.839106, 0.528947, -0.126774, 0.191295, -1.876844},
{-0.529221, 0.284604, 0.059841, -0.991577, 0.128605, 0.013459, 0.270045, -1.841688},
{-0.522962, 0.301106, 0.141199, -0.994934, 0.094363, -0.033876, 0.317832, -2.154359},
{-0.515619, 0.328982, 0.144301, -0.858394, 0.503189, -0.099551, 0.237491, -2.204274},
{0.115155, 0.361049, 0.079298, 0.501114, 0.817164, -0.284738, 2.354913, -1.006441},
{0.084488, 0.374043, 0.079823, 0.356487, 0.891903, -0.278207, 2.364416, -0.919253},
{0.084282, 0.382260, 0.105030, 0.324351, 0.909207, -0.260964, 2.450048, -0.920990},
{0.114883, 0.370506, 0.104595, 0.466781, 0.833583, -0.295328, 2.441545, -1.008605},
{0.133015, 0.356047, 0.104236, 0.809656, 0.539628, -0.230689, 2.435946, -1.050102},
{0.132969, 0.345627, 0.078864, 0.840297, 0.505264, -0.196356, 2.348424, -1.047459},
{0.133371, 0.336438, 0.054915, 0.866298, 0.478256, -0.144200, 2.266290, -1.046680},
{0.115701, 0.352954, 0.055488, 0.531999, 0.814905, -0.229896, 2.273828, -1.005946},
{0.084959, 0.366519, 0.056260, 0.373180, 0.895383, -0.242927, 2.284454, -0.918775},
{0.114992, 0.380138, 0.131933, 0.420911, 0.861568, -0.283670, 2.534824, -1.012144},
{0.084454, 0.389683, 0.132715, 0.271554, 0.936705, -0.220893, 2.543178, -0.923514},
{0.133767, 0.366570, 0.131493, 0.769951, 0.581317, -0.263100, 2.529520, -1.054488},
{0.040532, 0.402320, 0.134729, 0.240394, 0.962584, -0.124821, 2.557632, -0.742316},
{0.040234, 0.398096, 0.106427, 0.287912, 0.938932, -0.188299, 2.464356, -0.741138},
{-0.006724, 0.411320, 0.108370, 0.177282, 0.975829, -0.127689, 2.479010, -0.537899},
{-0.006345, 0.412999, 0.137329, 0.153691, 0.986908, -0.048585, 2.572936, -0.537920},
{0.040220, 0.391959, 0.081229, 0.316263, 0.916959, -0.243141, 2.379945, -0.739723},
{0.040448, 0.385213, 0.057922, 0.325541, 0.911863, -0.249977, 2.301256, -0.738730},
{-0.007006, 0.400936, 0.059586, 0.196661, 0.943968, -0.264931, 2.316451, -0.535021},
{-0.006958, 0.407010, 0.082932, 0.192724, 0.957854, -0.212897, 2.394880, -0.536682},
{0.093385, 0.218743, 0.128162, 0.495071, -0.783319, 0.375835, 1.086021, 1.457971},
{0.073359, 0.212933, 0.128686, 0.243416, -0.858608, 0.451125, 1.078470, 1.370179},
{0.071985, 0.198993, 0.102679, 0.248512, -0.864528, 0.436781, 0.982814, 1.368004},
{0.091546, 0.204724, 0.102003, 0.515641, -0.773309, 0.368847, 0.989768, 1.454035},
{0.104023, 0.219420, 0.101736, 0.819514, -0.534745, 0.205878, 0.994272, 1.493042},
{0.106531, 0.232797, 0.128207, 0.795282, -0.574969, 0.192053, 1.091267, 1.498310},
{0.090642, 0.192086, 0.076815, 0.522324, -0.779351, 0.346019, 0.898195, 1.453582},
{0.071323, 0.186550, 0.077597, 0.251778, -0.881954, 0.398389, 0.891821, 1.368468},
{0.070910, 0.176450, 0.053568, 0.257912, -0.910367, 0.323527, 0.806839, 1.369802},
{0.090105, 0.181900, 0.052799, 0.524888, -0.804193, 0.278787, 0.813138, 1.454439},
{0.102271, 0.195801, 0.052444, 0.820490, -0.539109, 0.189978, 0.816649, 1.492570},
{0.102851, 0.206603, 0.076453, 0.823054, -0.522904, 0.221564, 0.902016, 1.491972},
{0.033364, 0.177096, 0.079014, 0.216865, -0.889523, 0.402051, 0.880344, 1.189902},
{0.033629, 0.189356, 0.104057, 0.212897, -0.870815, 0.443037, 0.970964, 1.187923},
{-0.011136, 0.179980, 0.105122, 0.154546, -0.880764, 0.447584, 0.957855, 0.983372},
{-0.011073, 0.167731, 0.080003, 0.158635, -0.897763, 0.410840, 0.867052, 0.986619},
{-0.011041, 0.157460, 0.055669, 0.169530, -0.921567, 0.349132, 0.780983, 0.989688},
{0.033185, 0.167017, 0.054839, 0.224189, -0.915433, 0.334178, 0.794968, 1.192152},
{0.034315, 0.203332, 0.129969, 0.209510, -0.862636, 0.460372, 1.066307, 1.187481},
{-0.011023, 0.193877, 0.131158, 0.158330, -0.872158, 0.462844, 1.053426, 0.980721},
{-0.431469, 0.376958, 0.086590, -0.482284, 0.859157, -0.170934, 2.396136, 1.152699},
{-0.473784, 0.350208, 0.086662, -0.508164, 0.844691, -0.168065, 2.378886, 1.412590},
{-0.471948, 0.355972, 0.115128, -0.507431, 0.852504, -0.125278, 2.474252, 1.403825},
{-0.430675, 0.381911, 0.114264, -0.482864, 0.868007, -0.115635, 2.487803, 1.149186},
{-0.383012, 0.405280, 0.113562, -0.303049, 0.946074, -0.114231, 2.498040, 0.914935},
{-0.382916, 0.401012, 0.086628, -0.303140, 0.934751, -0.185186, 2.409127, 0.914760},
{-0.383102, 0.394893, 0.061325, -0.302469, 0.919279, -0.251747, 2.324393, 0.916805},
{-0.432455, 0.370202, 0.060568, -0.476394, 0.845851, -0.239906, 2.308741, 1.158071},
{-0.475696, 0.342813, 0.059835, -0.500412, 0.831629, -0.240608, 2.287875, 1.422568},
{-0.431345, 0.384588, 0.143600, -0.472610, 0.878292, -0.072298, 2.583529, 1.152614},
{-0.472501, 0.359497, 0.144627, -0.494583, 0.862667, -0.105686, 2.571267, 1.406109},
{-0.383726, 0.407310, 0.142695, -0.297617, 0.953642, -0.044130, 2.592745, 0.918870},
{-0.499695, 0.344704, 0.145152, -0.587725, 0.799249, -0.125462, 0.191507, -2.229119},
{-0.472501, 0.359497, 0.144627, -0.494583, 0.862667, -0.105686, 0.162702, -2.241427},
{-0.471948, 0.355972, 0.115128, -0.507431, 0.852504, -0.125278, 0.138594, -2.130986},
{-0.499166, 0.340582, 0.115624, -0.593493, 0.795953, -0.119083, 0.168872, -2.118151},
{-0.502544, 0.347629, 0.172920, -0.568712, 0.806513, -0.161412, 0.217674, -2.339784},
{-0.474848, 0.361595, 0.172700, -0.465590, 0.878750, -0.104862, 0.190573, -2.351952},
{-0.501585, 0.334263, 0.086760, -0.591876, 0.792505, -0.146825, 0.153301, -2.006580},
{-0.473784, 0.350208, 0.086662, -0.508164, 0.844691, -0.168065, 0.122013, -2.020712},
{-0.475696, 0.342813, 0.059835, -0.500412, 0.831629, -0.240608, 0.112382, -1.914015},
{-0.504030, 0.326514, 0.059505, -0.581744, 0.782525, -0.221778, 0.143980, -1.898743},
{-0.426680, 0.200138, 0.130556, -0.214423, -0.900937, 0.377239, 1.017232, -0.674799},
{-0.462118, 0.210574, 0.132531, -0.237556, -0.888577, 0.392376, 1.031323, -0.846757},
{-0.462248, 0.198542, 0.105632, -0.226539, -0.893643, 0.387371, 0.935360, -0.844014},
{-0.427121, 0.189060, 0.103700, -0.202948, -0.902219, 0.380505, 0.922506, -0.673226},
{-0.383154, 0.179674, 0.101508, -0.131352, -0.914609, 0.382366, 0.909952, -0.463782},
{-0.382453, 0.190074, 0.128435, -0.133183, -0.920194, 0.368053, 1.004110, -0.464386},
{-0.427469, 0.178337, 0.078171, -0.203375, -0.904630, 0.374462, 0.832235, -0.671463},
{-0.463072, 0.187913, 0.080058, -0.226905, -0.902371, 0.366344, 0.845020, -0.844064},
{-0.463679, 0.178641, 0.055664, -0.235145, -0.913785, 0.331187, 0.759900, -0.843404},
{-0.427432, 0.168639, 0.053923, -0.214545, -0.915220, 0.341014, 0.747114, -0.668370},
{-0.382516, 0.158338, 0.052016, -0.153478, -0.919156, 0.362682, 0.734426, -0.455358},
{-0.383089, 0.168650, 0.076049, -0.138096, -0.908994, 0.393231, 0.819575, -0.460457},
{-0.481402, 0.192848, 0.080844, -0.419111, -0.839625, 0.345439, 0.851536, -0.913469},
{-0.480337, 0.203398, 0.106386, -0.404614, -0.837550, 0.367046, 0.941705, -0.912498},
{-0.492214, 0.212858, 0.107079, -0.679708, -0.676351, 0.283670, 0.944795, -0.929831},
{-0.493614, 0.203013, 0.081562, -0.697043, -0.658559, 0.283547, 0.854918, -0.931277},
{-0.494880, 0.194141, 0.057108, -0.705283, -0.663533, 0.249519, 0.770191, -0.932422},
{-0.482325, 0.183758, 0.056441, -0.428327, -0.849422, 0.308145, 0.766574, -0.914018},
{-0.480342, 0.215777, 0.133268, -0.381268, -0.846095, 0.372478, 1.038019, -0.915748},
{-0.492062, 0.223815, 0.133805, -0.633168, -0.723167, 0.275826, 1.041017, -0.933255},
{-0.329708, 0.174540, -0.152125, -0.055177, -0.118046, -0.991455, 3.451594, -0.283502},
{-0.329853, 0.199585, -0.153776, -0.061892, -0.017335, -0.997925, 3.370008, -0.277455},
{-0.282344, 0.203590, -0.157149, -0.077578, -0.010651, -0.996918, 3.366549, -0.094792},
{-0.282262, 0.179591, -0.155594, -0.066652, -0.120792, -0.990417, 3.444706, -0.100802},
{-0.282727, 0.156294, -0.151423, -0.046297, -0.234352, -0.971038, 3.521452, -0.108917},
{-0.329970, 0.150890, -0.148153, -0.043123, -0.222297, -0.973998, 3.529451, -0.290915},
{-0.240080, 0.183986, -0.159424, -0.070833, -0.125919, -0.989502, 3.438609, 0.061655},
{-0.240125, 0.206785, -0.160920, -0.076876, -0.004151, -0.997009, 3.364362, 0.067495},
{-0.194706, 0.207367, -0.164009, -0.044832, 0.007233, -0.998962, 3.371599, 0.241267},
{-0.194680, 0.184807, -0.162678, -0.054109, -0.123600, -0.990844, 3.445006, 0.235435},
{-0.194410, 0.162815, -0.158262, -0.056520, -0.273171, -0.960295, 3.517794, 0.230445},
{-0.240156, 0.161458, -0.155053, -0.053896, -0.252632, -0.966033, 3.513032, 0.055214},
{-0.240293, 0.229772, -0.159641, -0.073519, 0.109867, -0.991211, 3.290523, 0.072699},
{-0.282942, 0.227803, -0.156029, -0.077883, 0.092257, -0.992676, 3.288592, -0.090901},
{-0.284026, 0.251784, -0.152551, -0.068117, 0.184484, -0.980468, 3.212160, -0.089095},
{-0.240589, 0.252784, -0.155755, -0.061556, 0.213416, -0.975005, 3.217552, 0.077227},
{-0.194175, 0.252406, -0.158196, -0.023621, 0.235054, -0.971679, 3.228361, 0.254505},
{-0.194534, 0.229860, -0.162478, -0.034364, 0.127262, -0.991241, 3.299528, 0.247629},
{-0.330410, 0.225019, -0.152883, -0.062227, 0.076357, -0.995117, 3.288027, -0.273072},
{-0.331385, 0.249948, -0.149849, -0.056398, 0.158849, -0.985687, 3.208391, -0.270573},
{-0.137576, 0.179136, -0.164422, -0.031312, -0.109165, -0.993500, 3.475599, 0.452102},
{-0.137601, 0.203534, -0.165340, -0.009339, 0.024445, -0.999634, 3.396409, 0.458386},
{-0.082082, 0.197617, -0.165283, 0.017914, 0.041780, -0.998962, 3.428114, 0.668801},
{-0.082030, 0.171614, -0.164864, -0.007324, -0.089694, -0.995941, 3.512309, 0.662244},
{-0.082556, 0.149111, -0.161188, -0.039460, -0.294992, -0.954650, 3.586291, 0.654141},
{-0.137647, 0.156795, -0.160269, -0.054415, -0.291482, -0.955016, 3.549340, 0.445741},
{-0.041305, 0.166884, -0.164214, 0.023621, -0.071932, -0.997101, 3.537055, 0.816446},
{-0.041426, 0.191948, -0.164208, 0.046358, 0.054292, -0.997436, 3.456037, 0.822463},
{-0.041828, 0.145478, -0.161137, -0.005554, -0.273476, -0.961852, 3.607267, 0.808681},
{-0.042089, 0.217513, -0.161391, 0.059542, 0.149449, -0.986969, 3.374332, 0.826333},
{-0.082662, 0.222462, -0.162735, 0.034700, 0.149968, -0.988067, 3.348653, 0.672819},
{-0.083567, 0.246695, -0.157771, 0.039430, 0.235511, -0.971038, 3.272006, 0.675259},
{-0.043084, 0.242991, -0.156442, 0.056520, 0.218543, -0.974181, 3.293634, 0.828751},
{-0.137734, 0.227000, -0.163304, 0.006348, 0.141575, -0.989898, 3.321311, 0.463793},
{-0.137883, 0.250105, -0.158611, 0.014557, 0.241493, -0.970275, 3.248379, 0.468846},
{-0.046086, 0.283987, 0.256154, 0.087985, -0.398938, 0.912717, 4.212042, -0.334448},
{-0.045865, 0.306606, 0.262407, 0.091098, -0.137089, 0.986328, 4.146101, -0.337262},
{-0.087027, 0.302935, 0.265454, 0.063753, -0.166814, 0.983917, 4.184700, -0.143930},
{-0.087261, 0.282369, 0.258313, 0.055910, -0.456587, 0.887875, 4.215830, -0.195252},
{-0.087654, 0.264747, 0.245719, 0.039857, -0.619037, 0.784326, 4.259806, -0.192393},
{-0.046561, 0.265591, 0.244631, 0.069826, -0.596332, 0.799646, 4.262874, -0.331651},
{-0.138091, 0.280251, 0.259746, 0.038026, -0.501816, 0.864101, 1.533970, 0.468901},
{-0.087261, 0.282369, 0.258313, 0.055910, -0.456587, 0.887875, 1.538924, 0.681979},
{-0.087027, 0.302935, 0.265454, 0.063753, -0.166814, 0.983917, 1.592239, 0.682353},
{-0.137943, 0.299348, 0.267737, 0.042482, -0.201178, 0.978607, 1.589315, 0.468498},
{-0.191610, 0.296539, 0.269008, 0.021058, -0.237922, 0.971038, 1.584764, 0.262892},
{-0.191660, 0.278383, 0.260326, 0.016266, -0.535295, 0.844478, 1.528325, 0.263892},
{-0.191658, 0.261463, 0.246346, 0.010346, -0.639576, 0.768609, 1.465735, 0.265332},
{-0.138265, 0.263005, 0.246301, 0.029908, -0.631123, 0.775079, 1.472599, 0.469591},
{-0.087654, 0.264747, 0.245719, 0.039857, -0.619037, 0.784326, 1.499053, 0.716534},
{-0.137904, 0.324315, 0.267940, 0.026673, 0.133915, 0.990631, 4.088281, 0.013350},
{-0.137943, 0.299348, 0.267737, 0.042482, -0.201178, 0.978607, 4.179261, 0.015755},
{-0.086951, 0.330343, 0.265382, 0.034822, 0.130284, 0.990844, 4.070858, -0.182141},
{-0.086919, 0.359573, 0.257321, -0.018464, 0.408124, 0.912717, 3.972005, -0.184856},
{-0.137895, 0.352332, 0.259664, -0.002350, 0.406781, 0.913511, 3.993065, 0.010828},
{-0.191644, 0.347919, 0.261916, 0.015412, 0.401288, 0.915799, 4.004939, 0.216872},
{-0.191611, 0.320330, 0.269907, 0.020875, 0.117496, 0.992828, 4.098568, 0.219193},
{-0.191610, 0.296539, 0.269008, 0.021058, -0.237922, 0.971038, 4.184893, 0.221442},
{-0.045823, 0.337203, 0.262642, 0.052919, 0.114414, 0.992004, 4.049943, -0.340111},
{-0.045827, 0.368067, 0.255345, -0.013886, 0.412152, 0.910977, 3.946589, -0.342830},
{-0.241048, 0.277513, 0.259925, -0.006134, -0.556627, 0.830714, 1.521298, 0.075023},
{-0.241023, 0.295200, 0.269020, -0.000732, -0.269631, 0.962951, 1.576961, 0.073785},
{-0.287979, 0.295073, 0.268266, -0.015442, -0.291757, 0.956359, 1.567660, -0.105845},
{-0.287918, 0.277368, 0.258972, -0.019562, -0.564837, 0.824946, 1.513703, -0.104123},
{-0.288046, 0.261667, 0.245027, -0.020112, -0.653554, 0.756584, 1.452662, -0.103156},
{-0.241095, 0.261220, 0.245819, -0.010407, -0.647420, 0.762017, 1.459068, 0.076307},
{-0.333930, 0.277677, 0.257894, -0.040010, -0.553178, 0.832057, 1.506354, -0.279962},
{-0.334273, 0.295894, 0.267238, -0.042817, -0.296915, 0.953917, 1.558616, -0.283016},
{-0.381755, 0.298817, 0.264585, -0.098666, -0.266427, 0.958770, 1.549700, -0.458957},
{-0.380559, 0.279767, 0.256116, -0.080844, -0.503952, 0.859920, 1.499128, -0.454147},
{-0.333979, 0.262195, 0.244278, -0.032594, -0.652638, 0.756920, 1.446580, -0.278729},
{-0.334361, 0.323666, 0.271355, -0.022584, 0.016480, 0.999603, 4.078863, 0.765082},
{-0.334273, 0.295894, 0.267238, -0.042817, -0.296915, 0.953917, 4.180097, 0.768095},
{-0.287979, 0.295073, 0.268266, -0.015442, -0.291757, 0.956359, 4.185406, 0.590673},
{-0.287950, 0.321064, 0.271230, 0.008820, 0.047426, 0.998810, 4.090339, 0.587739},
{-0.288050, 0.350632, 0.264981, 0.041078, 0.381298, 0.923521, 3.991941, 0.585504},
{-0.334551, 0.354413, 0.266203, 0.005493, 0.377148, 0.926115, 3.977672, 0.763093},
{-0.240996, 0.319599, 0.270876, 0.014557, 0.085635, 0.996216, 4.098081, 0.408216},
{-0.241023, 0.295200, 0.269020, -0.000732, -0.269631, 0.962951, 4.186973, 0.410768},
{-0.241055, 0.347910, 0.263620, 0.032136, 0.391705, 0.919492, 4.002797, 0.405931},
{-0.332781, 0.273475, -0.145075, -0.050233, 0.254616, -0.965728, 3.133840, -0.270177},
{-0.334361, 0.295290, -0.138007, -0.054567, 0.382488, -0.922330, 3.065646, -0.271100},
{-0.287289, 0.297197, -0.139236, -0.040834, 0.391858, -0.919095, 3.069673, -0.090811},
{-0.285561, 0.275087, -0.147032, -0.052858, 0.280251, -0.958464, 3.138581, -0.089345},
{-0.241016, 0.275660, -0.149428, -0.044801, 0.311075, -0.949309, 3.145910, 0.081041},
{-0.241497, 0.297750, -0.140818, -0.030732, 0.409650, -0.911710, 3.077655, 0.084270},
{-0.193041, 0.297294, -0.142107, -0.009949, 0.418165, -0.908292, 3.089607, 0.269237},
{-0.193647, 0.275125, -0.151268, -0.014740, 0.330088, -0.943815, 3.157665, 0.261878},
{-0.241957, 0.318402, -0.130084, -0.024476, 0.521287, -0.852992, 3.014844, 0.087046},
{-0.288950, 0.317594, -0.128928, -0.038728, 0.520127, -0.853175, 3.007257, -0.092652},
{-0.290277, 0.335497, -0.115949, -0.046327, 0.662862, -0.747276, 2.948088, -0.094680},
{-0.242310, 0.336652, -0.117047, -0.024964, 0.655049, -0.755150, 2.954757, 0.089596},
{-0.191948, 0.336690, -0.118044, -0.008972, 0.651326, -0.758721, 2.965493, 0.282635},
{-0.192450, 0.318188, -0.131121, -0.009095, 0.519822, -0.854213, 3.026350, 0.276068},
{-0.335888, 0.315078, -0.128088, -0.076052, 0.529344, -0.844966, 3.005081, -0.272558},
{-0.383048, 0.306258, -0.127899, -0.174200, 0.572863, -0.800897, 3.005610, -0.452569},
{-0.383820, 0.321215, -0.115134, -0.259041, 0.702719, -0.662587, 2.952031, -0.451552},
{-0.337111, 0.332273, -0.115227, -0.110630, 0.677419, -0.727195, 2.948331, -0.274284},
{-0.137956, 0.273414, -0.151561, 0.014924, 0.327342, -0.944762, 3.175687, 0.474064},
{-0.137978, 0.296176, -0.142457, 0.010468, 0.409650, -0.912168, 3.105549, 0.479185},
{-0.085620, 0.294257, -0.142258, 0.027863, 0.392438, -0.919340, 3.123674, 0.678556},
{-0.084593, 0.270860, -0.150940, 0.034791, 0.310739, -0.949828, 3.196251, 0.677079},
{-0.044205, 0.267794, -0.150039, 0.042482, 0.285409, -0.957457, 3.215637, 0.830406},
{-0.045280, 0.291399, -0.141899, 0.030335, 0.374065, -0.926878, 3.142173, 0.831795},
{-0.046138, 0.313283, -0.131740, 0.034516, 0.502548, -0.863826, 3.075077, 0.833413},
{-0.086529, 0.316186, -0.131738, 0.026093, 0.503067, -0.863826, 3.056555, 0.679966},
{-0.087204, 0.335378, -0.118563, 0.034822, 0.657918, -0.752251, 2.992167, 0.681343},
{-0.046713, 0.332241, -0.118611, 0.061769, 0.673086, -0.736961, 3.011163, 0.835145},
{-0.137970, 0.317635, -0.131602, 0.006165, 0.511856, -0.859004, 3.040284, 0.483946},
{-0.137931, 0.336563, -0.118462, 0.007141, 0.652211, -0.757958, 2.977453, 0.488528},
{-0.332418, 0.098020, -0.122594, -0.058199, -0.816675, -0.574114, 3.709351, -0.315852},
{-0.331509, 0.111713, -0.133646, -0.031678, -0.534867, -0.844325, 3.661154, -0.308012},
{-0.285127, 0.114564, -0.135514, -0.003601, -0.512650, -0.858577, 3.661736, -0.130063},
{-0.286526, 0.098709, -0.123974, 0.004334, -0.775170, -0.631703, 3.716990, -0.140373},
{-0.287730, 0.092250, -0.110125, 0.012757, -0.999603, 0.023927, 3.766590, -0.150367},
{-0.333225, 0.093228, -0.108923, -0.077578, -0.994568, 0.069094, 3.751194, -0.323302},
{-0.378338, 0.100399, -0.108693, -0.238472, -0.967162, 0.087588, 3.730699, -0.493052},
{-0.378511, 0.103591, -0.122106, -0.195227, -0.854671, -0.481002, 3.697781, -0.491423},
{-0.240852, 0.101751, -0.125910, 0.024964, -0.746269, -0.665151, 3.716767, 0.034925},
{-0.240595, 0.118904, -0.137843, -0.001099, -0.512345, -0.858760, 3.656914, 0.041240},
{-0.193146, 0.122966, -0.140243, -0.007782, -0.544603, -0.838649, 3.653623, 0.223615},
{-0.192417, 0.106173, -0.128123, 0.034272, -0.746025, -0.664998, 3.712606, 0.221142},
{-0.191774, 0.097749, -0.114184, 0.079531, -0.993408, -0.082278, 3.768273, 0.218930},
{-0.241061, 0.093896, -0.112006, 0.053957, -0.997986, -0.033052, 3.771790, 0.028935},
{-0.240345, 0.139285, -0.147709, -0.027528, -0.380322, -0.924406, 3.587402, 0.048206},
{-0.283771, 0.134188, -0.144697, -0.021638, -0.360332, -0.932554, 3.595176, -0.119125},
{-0.193854, 0.142024, -0.150536, -0.039979, -0.422285, -0.905576, 3.588009, 0.226610},
{-0.330632, 0.129643, -0.142080, -0.030610, -0.353679, -0.934843, 3.600245, -0.299392},
{-0.138241, 0.111002, -0.130334, 0.030519, -0.785943, -0.617512, 3.708431, 0.429381},
{-0.138010, 0.124983, -0.142322, -0.022279, -0.618000, -0.785821, 3.658800, 0.434781},
{-0.085224, 0.124472, -0.144087, -0.052614, -0.698843, -0.713309, 3.682582, 0.689999},
{-0.086831, 0.114150, -0.132426, -0.002960, -0.853633, -0.520798, 3.704250, 0.648632},
{-0.088209, 0.108505, -0.118278, 0.060335, -0.996094, -0.064364, 3.743152, 0.636463},
{-0.138426, 0.103391, -0.116276, 0.085360, -0.991424, -0.098910, 3.757522, 0.423943},
{-0.046693, 0.113531, -0.134283, -0.000336, -0.926115, -0.377178, 0.148614, 0.866207},
{-0.086831, 0.114150, -0.132426, -0.002960, -0.853633, -0.520798, 0.153537, 0.734077},
{-0.085224, 0.124472, -0.144087, -0.052614, -0.698843, -0.713309, 0.128562, 0.744440},
{-0.044824, 0.120951, -0.145543, -0.048616, -0.756462, -0.652211, 0.118807, 0.875396},
{-0.048317, 0.110774, -0.120187, 0.065676, -0.997681, 0.016083, 0.187930, 0.858081},
{-0.088209, 0.108505, -0.118278, 0.060335, -0.996094, -0.064364, 0.170468, 0.673510},
{-0.043102, 0.130883, -0.154704, -0.040193, -0.539750, -0.840846, 3.656557, 0.799561},
{-0.044824, 0.120951, -0.145543, -0.048616, -0.756462, -0.652211, 3.695385, 0.789764},
{-0.083710, 0.134761, -0.153969, -0.062807, -0.542650, -0.837581, 3.635113, 0.645482},
{-0.137802, 0.139495, -0.152601, -0.054445, -0.489944, -0.870022, 3.608088, 0.440101},
{-0.045744, 0.391485, 0.239005, -0.043550, 0.704337, 0.708518, 3.859061, -0.345255},
{-0.045628, 0.406973, 0.217461, -0.012818, 0.897214, 0.441359, 3.779446, -0.347533},
{-0.086686, 0.404909, 0.218787, -0.029267, 0.855617, 0.516709, 3.780968, -0.190289},
{-0.086821, 0.385610, 0.240493, -0.044862, 0.655202, 0.754082, 3.875820, -0.187572},
{-0.004930, 0.395708, 0.236785, 0.010163, 0.766411, 0.642232, 3.840703, -0.483959},
{-0.004810, 0.407178, 0.215524, 0.045869, 0.938719, 0.341594, 3.777408, -0.485657},
{-0.137837, 0.380583, 0.242216, -0.019929, 0.625446, 0.779992, 3.889381, 0.008070},
{-0.137743, 0.402938, 0.219850, -0.018952, 0.827937, 0.560472, 3.781462, 0.005196},
{-0.191747, 0.401491, 0.220728, -0.005005, 0.818628, 0.574297, 3.781155, 0.211875},
{-0.191693, 0.377469, 0.243927, 0.005066, 0.616382, 0.787408, 3.896700, 0.214409},
{-0.137627, 0.413268, 0.196822, -0.013276, 0.965545, 0.259835, 2.766130, -0.025357},
{-0.137743, 0.402938, 0.219850, -0.018952, 0.827937, 0.560472, 2.838652, -0.020588},
{-0.086686, 0.404909, 0.218787, -0.029267, 0.855617, 0.516709, 2.835614, -0.214602},
{-0.086545, 0.413925, 0.196094, -0.008087, 0.972503, 0.232704, 2.763391, -0.219171},
{-0.086465, 0.416532, 0.170923, -0.001648, 0.998596, 0.052705, 2.684072, -0.222955},
{-0.137526, 0.416125, 0.171563, -0.010559, 0.998413, 0.055208, 2.686670, -0.029368},
{-0.191797, 0.415487, 0.171569, -0.009156, 0.998260, 0.058046, 2.687151, 0.176455},
{-0.191795, 0.412497, 0.197109, -0.009796, 0.962706, 0.270272, 2.767433, 0.180168},
{-0.191747, 0.401491, 0.220728, -0.005005, 0.818628, 0.574297, 2.841359, 0.184422},
{-0.045530, 0.414047, 0.194553, 0.024903, 0.982543, 0.184210, 2.757889, -0.374640},
{-0.045628, 0.406973, 0.217461, -0.012818, 0.897214, 0.441359, 2.831985, -0.370810},
{-0.045541, 0.416136, 0.169087, 0.042238, 0.998169, 0.042726, 2.677328, -0.377820},
{-0.241288, 0.377333, 0.245379, 0.028901, 0.626179, 0.779107, 3.894731, 0.404182},
{-0.241643, 0.400997, 0.221499, 0.009491, 0.825648, 0.564074, 3.780274, 0.402700},
{-0.289173, 0.401166, 0.222148, 0.018189, 0.843532, 0.536729, 3.778496, 0.584531},
{-0.288499, 0.379066, 0.246632, 0.043092, 0.649281, 0.759301, 3.886883, 0.584668},
{-0.335204, 0.381558, 0.247742, 0.001282, 0.680715, 0.732536, 3.876564, 0.763149},
{-0.336081, 0.401705, 0.222659, -0.035066, 0.867000, 0.497024, 3.775498, 0.764227},
{-0.336945, 0.411461, 0.197644, -0.066958, 0.968932, 0.238044, 2.770766, 0.730312},
{-0.336081, 0.401705, 0.222659, -0.035066, 0.867000, 0.497024, 2.848341, 0.731614},
{-0.289173, 0.401166, 0.222148, 0.018189, 0.843532, 0.536729, 2.846385, 0.553761},
{-0.289948, 0.411731, 0.197496, -0.001007, 0.965758, 0.259407, 2.769729, 0.552224},
{-0.290473, 0.414983, 0.171423, -0.004975, 0.997894, 0.064425, 2.687894, 0.550298},
{-0.337423, 0.414626, 0.171377, -0.080386, 0.994873, 0.061220, 2.688254, 0.728239},
{-0.242066, 0.412030, 0.197326, -0.003723, 0.963042, 0.269295, 2.768625, 0.370769},
{-0.241643, 0.400997, 0.221499, 0.009491, 0.825648, 0.564074, 2.843997, 0.373618},
{-0.242356, 0.415188, 0.171505, -0.005188, 0.998077, 0.061434, 2.687542, 0.368023},
{-0.049112, 0.216202, 0.184416, 0.105228, -0.865413, 0.489822, 1.237659, 0.817592},
{-0.048285, 0.230947, 0.208398, 0.088748, -0.810694, 0.578661, 1.328078, 0.817959},
{-0.088808, 0.228274, 0.209255, 0.060427, -0.797815, 0.599841, 1.323574, 0.662791},
{-0.089335, 0.212651, 0.185009, 0.072573, -0.863582, 0.498917, 1.231338, 0.663585},
{-0.089727, 0.198555, 0.158334, 0.071017, -0.890744, 0.448897, 1.133564, 0.665250},
{-0.049708, 0.202398, 0.158224, 0.107547, -0.882565, 0.457717, 1.141681, 0.818422},
{-0.138458, 0.208678, 0.184790, 0.051088, -0.866695, 0.496200, 1.221186, 0.475634},
{-0.138445, 0.224615, 0.209433, 0.046632, -0.789331, 0.612140, 1.314953, 0.472829},
{-0.191268, 0.221688, 0.209093, 0.015992, -0.788903, 0.614246, 1.305328, 0.270769},
{-0.191025, 0.205957, 0.184127, 0.012787, -0.875546, 0.482894, 1.210853, 0.274600},
{-0.190856, 0.192702, 0.156597, 0.002472, -0.908963, 0.416822, 1.111545, 0.278540},
{-0.138459, 0.194810, 0.157620, 0.044771, -0.899594, 0.434370, 1.122225, 0.478866},
{-0.138382, 0.243592, 0.229733, 0.034486, -0.691916, 0.721122, 1.399175, 0.470858},
{-0.088209, 0.246178, 0.229429, 0.043306, -0.705313, 0.707541, 1.406183, 0.662862},
{-0.191503, 0.241377, 0.229551, 0.011414, -0.684011, 0.729362, 1.390846, 0.267652},
{-0.047364, 0.247661, 0.228591, 0.070437, -0.717856, 0.692587, 1.409358, 0.819228},
{-0.046561, 0.265591, 0.244631, 0.069826, -0.596332, 0.799646, 1.486068, 0.820949},
{-0.241578, 0.206166, 0.183394, -0.022797, -0.884823, 0.465316, 1.203992, 0.081342},
{-0.241346, 0.221208, 0.208400, -0.015503, -0.793207, 0.608692, 1.297813, 0.079307},
{-0.289435, 0.222116, 0.207551, -0.027894, -0.797418, 0.602741, 1.291673, -0.104490},
{-0.290139, 0.207644, 0.182690, -0.030305, -0.889950, 0.454970, 1.198927, -0.104265},
{-0.290824, 0.195876, 0.155249, -0.033876, -0.921018, 0.388012, 1.101577, -0.103565},
{-0.241872, 0.193767, 0.155780, -0.033387, -0.916105, 0.399518, 1.105406, 0.083549},
{-0.336725, 0.208731, 0.182118, -0.050478, -0.888760, 0.455519, 1.193985, -0.282348},
{-0.336288, 0.223352, 0.206745, -0.046999, -0.800256, 0.597797, 1.286174, -0.283558},
{-0.337032, 0.196899, 0.155083, -0.050050, -0.921659, 0.384716, 1.097829, -0.280256},
{-0.335069, 0.242630, 0.227346, -0.036958, -0.693869, 0.719108, 1.371779, -0.281140},
{-0.288645, 0.241687, 0.228108, -0.024049, -0.686148, 0.727042, 1.377451, -0.103699},
{-0.241190, 0.241005, 0.228926, -0.013184, -0.682607, 0.730644, 1.383706, 0.077682},
{-0.045748, 0.416672, 0.139869, 0.042970, 0.998779, -0.023652, 2.583839, -0.379696},
{-0.046053, 0.415236, 0.110443, 0.037782, 0.993774, -0.104556, 2.488551, -0.380125},
{-0.086671, 0.414470, 0.112137, -0.018372, 0.993866, -0.108798, 2.494169, -0.225790},
{-0.086514, 0.416604, 0.141783, -0.008057, 0.999451, -0.031556, 2.590564, -0.225169},
{-0.137478, 0.416061, 0.142502, -0.011750, 0.999115, -0.040101, 2.593334, -0.031863},
{-0.137492, 0.413647, 0.112942, -0.015046, 0.993011, -0.116977, 2.497053, -0.032866},
{-0.191616, 0.413007, 0.113285, -0.008789, 0.992645, -0.120518, 2.498612, 0.172424},
{-0.191718, 0.415462, 0.142608, -0.008271, 0.999084, -0.041810, 2.594156, 0.173822},
{-0.137572, 0.409455, 0.086188, -0.018097, 0.981170, -0.192175, 2.408762, -0.032403},
{-0.086918, 0.410459, 0.085448, -0.023957, 0.981445, -0.190130, 2.406193, -0.224792},
{-0.087157, 0.404639, 0.060760, -0.023957, 0.963347, -0.267159, 2.323605, -0.222656},
{-0.137659, 0.403574, 0.061281, -0.018311, 0.964538, -0.263283, 2.325436, -0.030830},
{-0.191502, 0.402805, 0.061730, -0.007843, 0.966155, -0.257759, 2.327254, 0.173477},
{-0.191553, 0.408708, 0.086663, -0.009400, 0.981048, -0.193487, 2.410680, 0.172414},
{-0.046358, 0.411410, 0.084351, 0.037019, 0.980071, -0.195105, 2.402597, -0.378962},
{-0.046574, 0.405585, 0.060363, 0.038484, 0.961943, -0.270425, 2.322256, -0.376858},
{-0.242307, 0.415228, 0.142685, -0.003388, 0.999176, -0.040315, 2.595039, 0.365484},
{-0.242144, 0.412793, 0.113595, -0.002136, 0.992737, -0.120090, 2.500252, 0.363863},
{-0.290129, 0.412833, 0.113731, 0.001251, 0.993164, -0.116489, 2.501440, 0.545518},
{-0.290397, 0.415145, 0.142679, -0.002197, 0.999329, -0.035951, 2.595703, 0.547595},
{-0.337140, 0.415001, 0.142535, -0.082400, 0.996033, -0.032899, 2.595870, 0.724627},
{-0.336624, 0.412958, 0.113552, -0.080630, 0.990204, -0.113742, 2.501644, 0.721460},
{-0.336402, 0.408870, 0.086859, -0.079897, 0.978668, -0.189154, 2.413604, 0.720725},
{-0.290076, 0.408664, 0.087049, 0.003327, 0.982055, -0.188482, 2.413393, 0.545470},
{-0.290186, 0.402987, 0.061887, 0.003510, 0.968719, -0.248085, 2.329361, 0.546996},
{-0.336431, 0.403094, 0.061728, -0.082400, 0.963958, -0.252876, 2.329618, 0.722002},
{-0.242090, 0.408527, 0.086967, -0.000763, 0.981506, -0.191351, 2.412321, 0.363869},
{-0.242110, 0.402750, 0.061909, 0.001892, 0.968017, -0.250862, 2.328568, 0.365120},
{-0.049825, 0.162461, 0.079505, 0.087588, -0.901547, 0.423688, 0.855233, 0.827351},
{-0.049928, 0.175029, 0.104858, 0.084719, -0.890866, 0.446242, 0.947125, 0.823931},
{-0.089981, 0.172300, 0.103747, 0.046937, -0.897244, 0.438978, 0.936628, 0.670816},
{-0.089971, 0.159395, 0.078089, 0.046419, -0.899655, 0.434095, 0.843401, 0.673912},
{-0.089932, 0.147973, 0.053676, 0.057283, -0.922391, 0.381909, 0.755723, 0.676992},
{-0.049743, 0.151639, 0.055116, 0.101199, -0.925047, 0.366100, 0.768347, 0.830608},
{-0.138591, 0.156640, 0.076326, 0.022492, -0.898221, 0.438948, 0.830070, 0.488117},
{-0.138532, 0.169586, 0.102269, 0.025300, -0.902371, 0.430189, 0.924218, 0.485246},
{-0.190918, 0.168316, 0.100794, -0.012604, -0.905850, 0.423383, 0.913164, 0.285044},
{-0.191007, 0.155476, 0.074748, -0.014100, -0.897519, 0.440718, 0.818830, 0.287818},
{-0.191054, 0.143572, 0.050322, -0.010437, -0.913236, 0.407270, 0.730529, 0.290556},
{-0.138625, 0.144880, 0.051846, 0.028840, -0.917753, 0.396039, 0.741777, 0.490920},
{-0.138486, 0.182045, 0.129740, 0.034394, -0.908933, 0.415479, 1.022419, 0.482116},
{-0.089921, 0.185229, 0.130870, 0.058779, -0.899197, 0.433515, 1.034338, 0.667795},
{-0.190844, 0.180440, 0.128448, -0.006867, -0.915677, 0.401807, 1.011525, 0.281987},
{-0.049934, 0.188508, 0.131401, 0.095889, -0.886593, 0.452467, 1.043722, 0.820745},
{-0.242540, 0.157178, 0.073888, -0.046602, -0.896329, 0.440901, 0.813269, 0.090864},
{-0.242474, 0.169917, 0.099687, -0.045351, -0.906980, 0.418653, 0.906734, 0.088035},
{-0.292063, 0.172733, 0.099297, -0.047609, -0.910581, 0.410535, 0.904118, -0.101513},
{-0.292060, 0.160296, 0.073804, -0.054872, -0.898923, 0.434645, 0.811950, -0.098453},
{-0.291750, 0.148622, 0.050028, -0.063326, -0.911039, 0.407361, 0.725928, -0.094427},
{-0.242455, 0.145263, 0.049802, -0.046785, -0.909726, 0.412549, 0.726000, 0.094067},
{-0.338431, 0.163378, 0.074559, -0.073641, -0.905881, 0.417066, 0.813432, -0.275840},
{-0.338545, 0.175109, 0.099972, -0.061769, -0.916379, 0.395489, 0.904507, -0.279331},
{-0.337863, 0.152323, 0.050742, -0.089541, -0.916898, 0.388897, 0.728051, -0.270806},
{-0.337859, 0.185987, 0.127257, -0.053682, -0.927152, 0.370769, 1.000321, -0.280027},
{-0.291558, 0.184416, 0.126948, -0.040254, -0.923551, 0.381298, 1.001984, -0.102932},
{-0.242211, 0.181899, 0.127431, -0.041353, -0.919248, 0.391461, 1.005216, 0.085688},
{0.120989, 0.173676, -0.102101, 0.839381, -0.542985, -0.023743, 1.444366, -2.443411},
{0.137889, 0.208671, -0.100121, 0.965178, -0.260353, 0.024140, 1.335575, -2.395293},
{0.137278, 0.213920, -0.080350, 0.961150, -0.244362, 0.128208, 1.338511, -2.317298},
{0.120497, 0.174136, -0.082381, 0.862819, -0.490402, 0.122562, 1.462094, -2.370939},
{0.100662, 0.146114, -0.084014, 0.729270, -0.682730, 0.044832, 1.577022, -2.422288},
{0.100866, 0.150209, -0.103806, 0.691824, -0.707389, -0.144688, 1.538610, -2.487514},
{0.118993, 0.182285, -0.060666, 0.866573, -0.438337, 0.238472, 1.458123, -2.282777},
{0.135029, 0.224172, -0.059401, 0.953093, -0.233100, 0.192969, 1.327454, -2.229733},
{0.132836, 0.235612, -0.037625, 0.960418, -0.234016, 0.150945, 1.313489, -2.137806},
{0.117582, 0.193612, -0.037983, 0.884213, -0.412275, 0.219459, 1.445194, -2.187499},
{0.099974, 0.161824, -0.038135, 0.762688, -0.589312, 0.266396, 1.576347, -2.236671},
{0.100242, 0.151541, -0.061623, 0.741661, -0.628071, 0.235481, 1.585000, -2.334779},
{0.139581, 0.268956, -0.058132, 0.997620, 0.037904, 0.057253, 1.189201, -2.174604},
{0.141173, 0.259778, -0.078526, 0.998260, 0.055391, 0.020112, 1.197621, -2.259074},
{0.133192, 0.299329, -0.077428, 0.882748, 0.447554, -0.142888, 1.048077, -2.198559},
{0.132787, 0.306386, -0.057147, 0.889920, 0.440077, -0.119602, 1.047156, -2.118433},
{0.132410, 0.313374, -0.036297, 0.890316, 0.437391, -0.126469, 1.047326, -2.035810},
{0.138099, 0.278391, -0.036984, 0.999420, 0.020295, 0.026734, 1.180683, -2.087069},
{0.141381, 0.253518, -0.098533, 0.996246, 0.070376, -0.050233, 1.197693, -2.339144},
{0.132454, 0.293485, -0.098177, 0.866237, 0.462844, -0.188055, 1.045266, -2.278981},
{0.117370, 0.203608, -0.015359, 0.897946, -0.408460, 0.163823, 1.436047, -2.093683},
{0.132390, 0.244426, -0.015376, 0.966033, -0.242866, 0.088168, 1.307706, -2.046730},
{0.132760, 0.252519, 0.007158, 0.965331, -0.248970, 0.078066, 1.304240, -1.955252},
{0.117804, 0.212633, 0.007169, 0.903287, -0.407147, 0.135166, 1.429664, -2.001171},
{0.100812, 0.181629, 0.007596, 0.796838, -0.574999, 0.185400, 1.556763, -2.046023},
{0.100226, 0.172300, -0.015054, 0.781915, -0.577715, 0.234107, 1.564866, -2.139651},
{0.118333, 0.221048, 0.029565, 0.909513, -0.394665, 0.130253, 1.425022, -1.909806},
{0.133015, 0.261793, 0.029789, 0.964995, -0.245613, 0.091830, 1.297226, -1.862123},
{0.101542, 0.188469, 0.029793, 0.811640, -0.562456, 0.157567, 1.558245, -1.958089},
{0.138863, 0.299526, 0.030781, 0.999939, 0.005982, 0.007813, 1.180284, -1.815637},
{0.138849, 0.291861, 0.008073, 0.999939, 0.000031, -0.008576, 1.182168, -1.907198},
{0.134127, 0.324136, 0.009230, 0.892056, 0.437147, -0.114505, 1.061772, -1.858077},
{0.133965, 0.329610, 0.031926, 0.884732, 0.453780, -0.106296, 1.068768, -1.769751},
{0.138225, 0.285420, -0.014715, 0.999878, 0.005921, -0.013947, 1.180320, -1.997804},
{0.133232, 0.319007, -0.013841, 0.890957, 0.433882, -0.133824, 1.053411, -1.947894},
{-0.513020, 0.211976, 0.034745, -0.856471, -0.492569, 0.154149, 0.461273, -1.650448},
{-0.527706, 0.244936, 0.035644, -0.970183, -0.233009, 0.066347, 0.361379, -1.700032},
{-0.526928, 0.236935, 0.012129, -0.971587, -0.232246, 0.045289, 0.357710, -1.605048},
{-0.512202, 0.204006, 0.011482, -0.858180, -0.493515, 0.141179, 0.457813, -1.556403},
{-0.493668, 0.178137, 0.010582, -0.706290, -0.674551, 0.214698, 0.560287, -1.504892},
{-0.494628, 0.186107, 0.033568, -0.708579, -0.672597, 0.213233, 0.563062, -1.597755},
{-0.511223, 0.195656, -0.011711, -0.860134, -0.489944, 0.141636, 0.455611, -1.462071},
{-0.525973, 0.228847, -0.011431, -0.970183, -0.236671, 0.052126, 0.354272, -1.509775},
{-0.525229, 0.220973, -0.034620, -0.966765, -0.246681, 0.066866, 0.351070, -1.415917},
{-0.510408, 0.187855, -0.034384, -0.860714, -0.490646, 0.135533, 0.454226, -1.369498},
{-0.492136, 0.161605, -0.034377, -0.707480, -0.680837, 0.189489, 0.562256, -1.320375},
{-0.492810, 0.169455, -0.012215, -0.705893, -0.673513, 0.219123, 0.560391, -1.411639},
{-0.527762, 0.259891, -0.011758, -0.988830, 0.134465, -0.064211, 0.259813, -1.552022},
{-0.528289, 0.268317, 0.011861, -0.986358, 0.141423, -0.084201, 0.262353, -1.647962},
{-0.519143, 0.293826, 0.011360, -0.815607, 0.533372, -0.224219, 0.185132, -1.681667},
{-0.519086, 0.284833, -0.012218, -0.817713, 0.537645, -0.205542, 0.184298, -1.585096},
{-0.519642, 0.275619, -0.035619, -0.818293, 0.538530, -0.200903, 0.184266, -1.488871},
{-0.527656, 0.251418, -0.035125, -0.991638, 0.120792, -0.044984, 0.257662, -1.456929},
{-0.529316, 0.276565, 0.035404, -0.988342, 0.136387, -0.067232, 0.265276, -1.743398},
{-0.520417, 0.302431, 0.034850, -0.822626, 0.528031, -0.210700, 0.186876, -1.777422},
{-0.510077, 0.181533, -0.056086, -0.856075, -0.502396, 0.121281, 0.453214, -1.280731},
{-0.525084, 0.213615, -0.057018, -0.963134, -0.259194, 0.071841, 0.348111, -1.325181},
{-0.524910, 0.207019, -0.078284, -0.961882, -0.269539, 0.045961, 0.343572, -1.239830},
{-0.509923, 0.176697, -0.076757, -0.847468, -0.522660, 0.092654, 0.446421, -1.198866},
{-0.491578, 0.152806, -0.075608, -0.691458, -0.716361, 0.092990, 0.555690, -1.155587},
{-0.491726, 0.156127, -0.055463, -0.702109, -0.697745, 0.142003, 0.564768, -1.233480},
{-0.509639, 0.173353, -0.096337, -0.836940, -0.543107, 0.067263, 0.427691, -1.126999},
{-0.524080, 0.201434, -0.098078, -0.962249, -0.271676, 0.015015, 0.335627, -1.162124},
{-0.491693, 0.151424, -0.094947, -0.681082, -0.730094, 0.055513, 0.522787, -1.091329},
{-0.526314, 0.228835, -0.099450, -0.985015, 0.126621, -0.116977, 0.249628, -1.196156},
{-0.527702, 0.235304, -0.079544, -0.990295, 0.114048, -0.079287, 0.253562, -1.276164},
{-0.520006, 0.257882, -0.080374, -0.799280, 0.550432, -0.241127, 0.164008, -1.289545},
{-0.518252, 0.251064, -0.100304, -0.784326, 0.563463, -0.259346, 0.166660, -1.229642},
{-0.527893, 0.243027, -0.057911, -0.992676, 0.112400, -0.044008, 0.255909, -1.364032},
{-0.520209, 0.266351, -0.058575, -0.812708, 0.542528, -0.212439, 0.184926, -1.394155},
{0.112099, 0.313837, -0.099895, 0.511216, 0.804254, -0.302988, 1.752642, -0.983199},
{0.080391, 0.323999, -0.101795, 0.246254, 0.896908, -0.367260, 1.752753, -0.890701},
{0.083511, 0.331510, -0.078449, 0.280374, 0.911252, -0.301645, 1.831957, -0.904785},
{0.114345, 0.320191, -0.077573, 0.537309, 0.801508, -0.262307, 1.827909, -0.993420},
{0.133192, 0.299329, -0.077428, 0.882748, 0.447554, -0.142888, 1.823582, -1.035383},
{0.132454, 0.293485, -0.098177, 0.866237, 0.462844, -0.188055, 1.755224, -1.032316},
{0.114790, 0.326212, -0.056733, 0.542222, 0.806421, -0.235908, 1.898254, -0.996753},
{0.084373, 0.337452, -0.056797, 0.292520, 0.919797, -0.261452, 1.904858, -0.909589},
{0.084445, 0.343110, -0.035300, 0.299966, 0.915983, -0.266366, 1.977112, -0.911261},
{0.114806, 0.331986, -0.035805, 0.538835, 0.810297, -0.230293, 1.968747, -0.998322},
{0.132410, 0.313374, -0.036297, 0.890316, 0.437391, -0.126469, 1.961328, -1.038262},
{0.132787, 0.306386, -0.057147, 0.889920, 0.440077, -0.119602, 1.891348, -1.036486},
{0.040320, 0.349127, -0.057247, 0.223090, 0.934812, -0.276193, 1.910857, -0.727562},
{0.039567, 0.342430, -0.079545, 0.206336, 0.919553, -0.334422, 1.835445, -0.722805},
{-0.007300, 0.351617, -0.080593, 0.161046, 0.918027, -0.362255, 1.838185, -0.517913},
{-0.006876, 0.358848, -0.057912, 0.164006, 0.945860, -0.280038, 1.915135, -0.521693},
{-0.006650, 0.365872, -0.034141, 0.155431, 0.937468, -0.311411, 1.995469, -0.524518},
{0.040486, 0.355624, -0.034573, 0.232673, 0.926176, -0.296701, 1.987365, -0.729957},
{0.037410, 0.333395, -0.101989, 0.164556, 0.881436, -0.442671, 1.758252, -0.711444},
{0.035536, 0.322420, -0.121228, 0.087619, 0.794031, -0.601489, 1.680168, -0.696780},
{-0.008464, 0.327729, -0.119277, 0.065889, 0.716392, -0.694540, 1.693725, -0.503274},
{-0.007986, 0.341319, -0.101553, 0.128361, 0.847865, -0.514420, 1.765011, -0.511302},
{0.115769, 0.337602, -0.013219, 0.545915, 0.807642, -0.222755, 2.044460, -1.003252},
{0.085197, 0.349767, -0.012418, 0.320231, 0.906980, -0.273446, 2.054375, -0.915948},
{0.085841, 0.356198, 0.010851, 0.350902, 0.905881, -0.237098, 2.132749, -0.920065},
{0.116647, 0.342822, 0.009946, 0.557573, 0.807794, -0.191107, 2.121804, -1.007597},
{0.134127, 0.324136, 0.009230, 0.892056, 0.437147, -0.114505, 2.113217, -1.047855},
{0.133232, 0.319007, -0.013841, 0.890957, 0.433882, -0.133824, 2.036325, -1.043349},
{0.116411, 0.347409, 0.032609, 0.554277, 0.812647, -0.179724, 2.197193, -1.007413},
{0.085586, 0.361177, 0.033507, 0.372387, 0.904172, -0.209204, 2.208337, -0.920026},
{0.133965, 0.329610, 0.031926, 0.884732, 0.453780, -0.106296, 2.188880, -1.047889},
{0.040872, 0.379167, 0.035295, 0.313059, 0.915616, -0.252144, 2.225145, -0.738817},
{0.041137, 0.372543, 0.012576, 0.282205, 0.912870, -0.294961, 2.148410, -0.737985},
{-0.006614, 0.385649, 0.014021, 0.165410, 0.922849, -0.347758, 2.161411, -0.531720},
{-0.006827, 0.393964, 0.036901, 0.185125, 0.934965, -0.302530, 2.239630, -0.533669},
{0.040883, 0.364062, -0.011007, 0.250557, 0.911557, -0.325938, 2.067850, -0.734231},
{-0.006559, 0.375545, -0.009911, 0.152989, 0.919309, -0.362560, 2.078792, -0.528265},
{0.089368, 0.175234, 0.030158, 0.522111, -0.822352, 0.225990, 0.736431, 1.454430},
{0.070283, 0.169540, 0.030718, 0.265206, -0.927244, 0.264260, 0.729218, 1.370235},
{0.069621, 0.163219, 0.008230, 0.257637, -0.922422, 0.287637, 0.653393, 1.370503},
{0.088613, 0.168933, 0.007928, 0.506607, -0.820826, 0.263710, 0.661406, 1.454307},
{0.100812, 0.181629, 0.007596, 0.796838, -0.574999, 0.185400, 0.665711, 1.491919},
{0.101542, 0.188469, 0.029793, 0.811640, -0.562456, 0.157567, 0.740321, 1.492307},
{0.088022, 0.159840, -0.014853, 0.477767, -0.816523, 0.323985, 0.581392, 1.454820},
{0.069105, 0.154885, -0.014713, 0.225318, -0.916013, 0.331828, 0.573804, 1.371340},
{0.068778, 0.145870, -0.038095, 0.178930, -0.926572, 0.330729, 0.492086, 1.372943},
{0.087648, 0.149681, -0.038161, 0.441877, -0.831172, 0.337382, 0.498534, 1.456207},
{0.099974, 0.161824, -0.038135, 0.762688, -0.589312, 0.266396, 0.502123, 1.493308},
{0.100226, 0.172300, -0.015054, 0.781915, -0.577715, 0.234107, 0.585501, 1.492146},
{0.031824, 0.146096, -0.014590, 0.201819, -0.938292, 0.280740, 0.559260, 1.195553},
{0.032250, 0.153160, 0.008563, 0.227882, -0.935820, 0.268807, 0.637966, 1.194316},
{-0.011576, 0.143031, 0.008648, 0.176641, -0.952055, 0.249733, 0.621076, 0.993468},
{-0.011889, 0.137247, -0.014640, 0.157476, -0.960692, 0.228492, 0.543499, 0.995189},
{-0.012112, 0.132209, -0.037912, 0.127384, -0.971038, 0.202033, 0.466868, 0.997269},
{0.031536, 0.139075, -0.037973, 0.161473, -0.949950, 0.267373, 0.479923, 1.197351},
{0.032759, 0.159586, 0.031530, 0.232459, -0.933073, 0.274422, 0.715355, 1.193403},
{-0.011251, 0.149498, 0.031984, 0.179113, -0.941557, 0.285195, 0.699615, 0.991803},
{0.087545, 0.140184, -0.061967, 0.413221, -0.871334, 0.264534, 0.414977, 1.458708},
{0.068684, 0.137503, -0.061902, 0.143040, -0.955016, 0.259743, 0.409878, 1.375509},
{0.068747, 0.132791, -0.084614, 0.161443, -0.984924, 0.061983, 0.335361, 1.378615},
{0.087601, 0.135542, -0.084644, 0.419538, -0.907559, 0.016572, 0.340650, 1.461786},
{0.100662, 0.146114, -0.084014, 0.729270, -0.682730, 0.044832, 0.344175, 1.498812},
{0.100242, 0.151541, -0.061623, 0.741661, -0.628071, 0.235481, 0.418007, 1.495727},
{0.087706, 0.139947, -0.104565, 0.446730, -0.872860, -0.196173, 0.285480, 1.464905},
{0.068890, 0.134739, -0.104714, 0.240761, -0.964629, -0.107334, 0.276720, 1.381842},
{0.100866, 0.150209, -0.103806, 0.691824, -0.707389, -0.144688, 0.291646, 1.501971},
{0.031796, 0.126434, -0.104591, 0.197272, -0.978423, 0.061159, 0.262773, 1.206786},
{0.031534, 0.128232, -0.084269, 0.135807, -0.980834, 0.139653, 0.326542, 1.203158},
{-0.012008, 0.123722, -0.083533, 0.103671, -0.973510, 0.203650, 0.318358, 1.003445},
{-0.011595, 0.118607, -0.103944, 0.138188, -0.970489, 0.197577, 0.250377, 1.007582},
{0.031443, 0.132783, -0.061631, 0.127079, -0.966063, 0.224830, 0.400638, 1.199950},
{-0.012166, 0.127978, -0.061199, 0.101108, -0.977050, 0.187323, 0.391171, 1.000015},
{-0.432414, 0.306325, -0.099572, -0.465560, 0.767693, -0.440291, 1.758050, 1.180365},
{-0.474130, 0.278171, -0.100184, -0.465865, 0.798944, -0.380291, 1.740710, 1.381051},
{-0.475507, 0.286511, -0.080503, -0.486984, 0.797235, -0.356670, 1.819710, 1.450149},
{-0.433192, 0.315763, -0.080282, -0.494797, 0.788598, -0.365001, 1.825394, 1.179641},
{-0.384670, 0.344132, -0.080213, -0.352794, 0.850765, -0.389447, 1.840957, 0.939428},
{-0.384385, 0.333801, -0.099128, -0.322336, 0.790551, -0.520646, 1.774311, 0.942546},
{-0.433228, 0.324793, -0.058701, -0.499313, 0.805963, -0.317942, 1.899848, 1.176518},
{-0.475678, 0.295860, -0.058806, -0.494339, 0.802179, -0.334788, 1.879983, 1.438559},
{-0.475190, 0.305719, -0.035789, -0.494369, 0.806574, -0.324076, 1.959608, 1.432918},
{-0.432831, 0.333882, -0.035581, -0.490677, 0.814203, -0.310282, 1.979271, 1.171847},
{-0.384289, 0.360111, -0.035468, -0.332469, 0.891079, -0.308878, 1.993749, 0.932750},
{-0.384602, 0.352325, -0.058719, -0.350719, 0.884152, -0.308603, 1.914652, 0.936367},
{-0.503738, 0.280171, -0.058818, -0.538865, 0.778680, -0.321268, 0.143479, -1.412419},
{-0.475678, 0.295860, -0.058806, -0.494339, 0.802179, -0.334788, 0.116799, -1.424756},
{-0.475507, 0.286511, -0.080503, -0.486984, 0.797235, -0.356670, 0.121079, -1.329547},
{-0.503527, 0.271084, -0.080614, -0.523850, 0.783227, -0.334788, 0.146306, -1.317526},
{-0.503140, 0.290009, -0.035821, -0.549669, 0.776208, -0.308756, 0.141143, -1.508081},
{-0.475190, 0.305719, -0.035789, -0.494369, 0.806574, -0.324076, 0.113157, -1.520926},
{-0.501800, 0.263630, -0.100489, -0.505783, 0.794794, -0.335276, 1.731719, 1.466647},
{-0.503527, 0.271084, -0.080614, -0.523850, 0.783227, -0.334788, 1.796281, 1.473907},
{-0.518252, 0.251064, -0.100304, -0.784326, 0.563463, -0.259346, 1.726904, 1.494698},
{-0.520006, 0.257882, -0.080374, -0.799280, 0.550432, -0.241127, 1.791276, 1.503749},
{-0.432309, 0.343496, -0.011675, -0.482315, 0.816675, -0.316813, 2.061518, 1.166476},
{-0.474589, 0.315590, -0.012149, -0.493576, 0.808252, -0.320994, 2.041090, 1.427007},
{-0.474457, 0.325230, 0.011678, -0.491592, 0.808008, -0.324656, 2.123004, 1.423212},
{-0.432030, 0.353090, 0.012441, -0.476333, 0.819666, -0.318155, 2.144427, 1.162052},
{-0.383432, 0.378625, 0.013135, -0.310617, 0.891385, -0.330027, 2.160374, 0.923175},
{-0.383842, 0.369218, -0.011283, -0.318033, 0.887936, -0.332255, 2.076603, 0.927967},
{-0.432360, 0.362119, 0.036187, -0.472945, 0.829249, -0.297708, 2.225837, 1.160219},
{-0.475373, 0.334396, 0.035257, -0.492141, 0.814753, -0.306497, 2.203923, 1.423920},
{-0.383229, 0.387306, 0.037083, -0.305002, 0.902799, -0.303110, 2.242224, 0.919532},
{-0.503581, 0.318104, 0.034806, -0.566881, 0.769066, -0.295206, 0.140096, -1.798978},
{-0.475373, 0.334396, 0.035257, -0.492141, 0.814753, -0.306497, 0.109124, -1.814301},
{-0.474457, 0.325230, 0.011678, -0.491592, 0.808008, -0.324656, 0.109504, -1.717370},
{-0.502347, 0.309136, 0.011308, -0.559984, 0.767754, -0.311319, 0.139436, -1.702690},
{-0.502438, 0.299718, -0.012339, -0.556780, 0.773217, -0.303415, 0.139791, -1.605281},
{-0.474589, 0.315590, -0.012149, -0.493576, 0.808252, -0.320994, 0.110787, -1.619021},
{-0.426718, 0.160631, 0.030916, -0.223121, -0.925687, 0.305429, 0.667836, -0.662811},
{-0.463156, 0.170677, 0.032308, -0.238960, -0.922269, 0.303751, 0.679598, -0.838532},
{-0.462137, 0.163100, 0.009567, -0.231574, -0.922208, 0.309610, 0.601669, -0.831831},
{-0.425723, 0.153342, 0.008563, -0.221137, -0.928129, 0.299356, 0.591427, -0.656248},
{-0.380787, 0.142952, 0.007392, -0.169195, -0.940733, 0.293832, 0.580867, -0.443255},
{-0.381692, 0.150075, 0.029371, -0.166814, -0.933378, 0.317667, 0.655954, -0.449431},
{-0.424845, 0.145801, -0.013721, -0.212928, -0.931700, 0.294168, 0.514916, -0.650148},
{-0.461253, 0.154984, -0.012982, -0.218848, -0.925016, 0.310495, 0.523670, -0.825684},
{-0.460539, 0.147772, -0.034884, -0.212256, -0.941832, 0.260537, 0.447397, -0.820276},
{-0.424135, 0.139052, -0.035297, -0.208808, -0.944426, 0.253792, 0.440740, -0.644774},
{-0.379300, 0.129952, -0.035903, -0.150304, -0.958556, 0.241920, 0.433979, -0.432203},
{-0.379972, 0.136055, -0.014643, -0.161046, -0.947508, 0.276070, 0.505874, -0.437411},
{-0.480031, 0.159383, -0.012559, -0.410352, -0.862850, 0.295083, 0.528401, -0.896769},
{-0.480883, 0.167933, 0.010091, -0.421430, -0.859340, 0.289590, 0.607230, -0.902795},
{-0.493668, 0.178137, 0.010582, -0.706290, -0.674551, 0.214698, 0.610451, -0.921450},
{-0.492810, 0.169455, -0.012215, -0.705893, -0.673513, 0.219123, 0.531122, -0.915630},
{-0.492136, 0.161605, -0.034377, -0.707480, -0.680837, 0.189489, 0.453463, -0.910652},
{-0.479360, 0.151767, -0.034561, -0.404126, -0.880734, 0.246895, 0.451155, -0.891527},
{-0.481900, 0.175755, 0.032974, -0.430067, -0.858333, 0.279763, 0.685880, -0.909502},
{-0.494628, 0.186107, 0.033568, -0.708579, -0.672597, 0.213233, 0.689421, -0.928097},
{-0.423641, 0.134140, -0.055525, -0.217505, -0.947905, 0.232673, 0.371342, -0.640394},
{-0.460030, 0.142907, -0.055687, -0.220954, -0.954436, 0.200507, 0.374648, -0.815796},
{-0.459817, 0.139370, -0.075489, -0.261879, -0.947569, 0.183020, 0.308198, -0.812509},
{-0.423397, 0.129122, -0.074733, -0.252602, -0.922513, 0.291787, 0.305863, -0.637083},
{-0.378519, 0.118893, -0.074171, -0.157537, -0.905179, 0.394696, 0.303904, -0.424475},
{-0.378826, 0.125211, -0.055560, -0.145512, -0.954466, 0.260384, 0.368184, -0.427935},
{-0.423433, 0.122056, -0.093249, -0.315409, -0.899350, 0.302713, 0.243448, -0.634920},
{-0.459987, 0.136143, -0.094389, -0.332774, -0.930021, 0.155766, 0.250821, -0.810683},
{-0.378348, 0.108061, -0.092299, -0.194617, -0.876675, 0.439894, 0.236556, -0.421691},
{-0.478941, 0.142476, -0.094627, -0.448378, -0.891171, 0.068880, 0.255334, -0.882320},
{-0.478710, 0.143814, -0.075483, -0.415845, -0.901975, 0.116092, 0.310655, -0.884002},
{-0.491578, 0.152806, -0.075608, -0.691458, -0.716361, 0.092990, 0.313174, -0.903528},
{-0.491693, 0.151424, -0.094947, -0.681082, -0.730094, 0.055513, 0.258417, -0.901896},
{-0.478885, 0.146744, -0.055498, -0.402203, -0.898770, 0.174352, 0.377251, -0.887171},
{-0.491726, 0.156127, -0.055463, -0.702109, -0.697745, 0.142003, 0.379501, -0.906533},
{-0.137692, 0.396090, 0.037265, -0.014466, 0.949004, -0.314859, 2.244049, -0.028501},
{-0.087295, 0.397077, 0.037118, -0.020539, 0.945616, -0.324564, 2.243375, -0.219858},
{-0.087367, 0.388364, 0.013587, -0.012452, 0.935911, -0.351909, 2.162845, -0.216659},
{-0.137697, 0.387634, 0.013325, -0.007721, 0.941862, -0.335795, 2.162349, -0.025731},
{-0.191383, 0.387373, 0.013220, 0.001282, 0.945647, -0.325144, 2.162681, 0.177655},
{-0.191438, 0.395542, 0.037476, -0.003327, 0.952788, -0.303537, 2.245229, 0.175298},
{-0.137702, 0.378834, -0.011353, -0.000305, 0.949736, -0.313028, 2.078083, -0.022831},
{-0.087412, 0.379091, -0.010765, 0.001648, 0.942412, -0.334422, 2.079355, -0.213316},
{-0.087466, 0.371201, -0.035337, 0.020051, 0.967345, -0.252663, 1.995951, -0.210729},
{-0.137713, 0.371499, -0.036230, 0.005676, 0.973540, -0.228401, 1.994020, -0.020737},
{-0.191355, 0.371500, -0.036801, 0.001679, 0.974578, -0.223975, 1.993001, 0.182300},
{-0.191361, 0.378755, -0.011717, 0.002960, 0.952055, -0.305826, 2.077686, 0.180330},
{-0.046511, 0.379275, -0.010057, 0.047456, 0.931578, -0.360393, 2.081110, -0.368210},
{-0.046561, 0.389313, 0.014089, 0.036927, 0.930662, -0.363964, 2.164377, -0.371633},
{-0.046539, 0.370194, -0.034518, 0.069399, 0.954344, -0.290445, 1.997382, -0.365049},
{-0.046611, 0.398151, 0.037253, 0.036653, 0.944548, -0.326273, 2.243804, -0.374465},
{-0.137735, 0.367440, -0.060766, 0.010681, 0.980285, -0.197241, 1.912926, -0.020386},
{-0.087562, 0.366639, -0.059528, 0.039644, 0.975158, -0.217780, 1.915677, -0.209794},
{-0.087612, 0.361170, -0.082125, 0.052736, 0.931364, -0.360149, 1.840001, -0.208401},
{-0.137780, 0.362301, -0.083382, 0.014588, 0.933622, -0.357921, 1.837377, -0.019198},
{-0.191411, 0.362237, -0.084026, -0.003510, 0.932096, -0.362133, 1.836089, 0.183828},
{-0.191350, 0.367418, -0.061497, -0.000641, 0.980682, -0.195563, 1.911382, 0.182545},
{-0.137857, 0.351731, -0.102501, 0.012665, 0.807367, -0.589892, 1.769945, -0.014597},
{-0.087529, 0.350561, -0.101914, 0.048952, 0.815271, -0.576952, 1.770395, -0.204436},
{-0.087204, 0.335378, -0.118563, 0.034822, 0.657918, -0.752251, 1.703822, -0.199185},
{-0.137931, 0.336563, -0.118462, 0.007141, 0.652211, -0.757958, 1.706572, -0.008288},
{-0.191948, 0.336690, -0.118044, -0.008972, 0.651326, -0.758721, 1.709476, 0.195898},
{-0.191607, 0.351684, -0.102610, -0.006897, 0.801965, -0.597278, 1.770385, 0.188912},
{-0.046936, 0.347066, -0.101563, 0.095553, 0.825098, -0.556841, 1.768904, -0.356152},
{-0.046906, 0.357736, -0.081324, 0.109561, 0.923460, -0.367626, 1.839988, -0.360542},
{-0.046713, 0.332241, -0.118611, 0.061769, 0.673086, -0.736961, 1.700575, -0.350795},
{-0.046722, 0.364230, -0.058625, 0.095614, 0.962310, -0.254555, 1.916578, -0.363000},
{-0.336668, 0.395989, 0.037433, -0.088137, 0.949339, -0.301584, 2.247556, 0.724874},
{-0.290405, 0.396152, 0.037497, 0.001770, 0.955809, -0.293863, 2.247150, 0.549641},
{-0.290685, 0.388218, 0.013226, -0.001953, 0.945036, -0.326945, 2.164691, 0.553136},
{-0.337030, 0.387742, 0.013302, -0.094913, 0.937590, -0.334452, 2.165368, 0.728864},
{-0.337434, 0.378542, -0.011338, -0.102969, 0.936003, -0.336558, 2.081002, 0.733499},
{-0.290978, 0.379245, -0.011581, -0.008698, 0.945952, -0.324137, 2.079919, 0.557213},
{-0.291222, 0.371295, -0.036169, -0.021302, 0.965758, -0.258461, 1.996433, 0.560552},
{-0.337791, 0.370022, -0.035719, -0.119327, 0.949278, -0.290811, 1.997858, 0.737601},
{-0.242370, 0.379104, -0.011750, 0.003082, 0.950316, -0.311197, 2.078556, 0.373251},
{-0.242258, 0.387832, 0.013193, 0.006470, 0.946593, -0.322306, 2.163629, 0.370006},
{-0.242467, 0.371610, -0.036655, -0.003998, 0.972137, -0.234352, 1.994310, 0.375758},
{-0.242169, 0.395783, 0.037532, 0.005280, 0.955565, -0.294717, 2.246318, 0.367230},
{-0.338014, 0.363813, -0.059072, -0.143529, 0.949614, -0.278512, 1.919332, 0.739994},
{-0.291353, 0.366433, -0.059785, -0.039766, 0.971099, -0.235267, 1.917833, 0.561834},
{-0.291304, 0.360696, -0.081439, -0.055269, 0.923185, -0.380322, 1.845030, 0.563073},
{-0.338032, 0.356911, -0.080556, -0.157231, 0.904965, -0.395306, 1.846407, 0.742154},
{-0.337779, 0.346307, -0.099329, -0.143681, 0.807550, -0.571978, 1.780065, 0.745552},
{-0.291003, 0.350125, -0.100140, -0.056063, 0.805963, -0.589251, 1.778935, 0.566283},
{-0.290277, 0.335497, -0.115949, -0.046327, 0.662862, -0.747276, 1.716195, 0.570478},
{-0.337111, 0.332273, -0.115227, -0.110630, 0.677419, -0.727195, 1.717015, 0.749570},
{-0.242467, 0.351533, -0.101528, -0.026521, 0.802240, -0.596393, 1.774545, 0.381637},
{-0.242508, 0.362087, -0.082987, -0.022217, 0.929380, -0.368419, 1.840115, 0.377441},
{-0.242310, 0.336652, -0.117047, -0.024964, 0.655049, -0.755150, 1.713183, 0.387370},
{-0.242510, 0.367358, -0.060882, -0.012879, 0.978271, -0.206793, 1.914100, 0.376318},
{-0.138493, 0.107988, -0.099785, 0.082614, -0.934568, 0.345988, 0.237790, 0.510436},
{-0.089039, 0.112246, -0.100933, 0.075838, -0.954833, 0.287240, 0.244163, 0.699839},
{-0.089510, 0.119115, -0.081315, 0.060854, -0.963103, 0.262062, 0.311824, 0.695627},
{-0.138523, 0.116418, -0.081152, 0.056887, -0.950926, 0.304117, 0.304366, 0.508078},
{-0.191049, 0.114093, -0.080661, 0.043275, -0.932646, 0.358104, 0.298007, 0.307056},
{-0.191318, 0.103796, -0.098432, 0.071657, -0.902737, 0.424116, 0.231789, 0.308113},
{-0.191774, 0.097749, -0.114184, 0.079531, -0.993408, -0.082278, 0.165382, 0.308601},
{-0.138426, 0.103391, -0.116276, 0.085360, -0.991424, -0.098910, 0.171312, 0.512538},
{-0.138595, 0.120305, -0.060668, 0.046724, -0.988525, 0.143406, 0.371139, 0.505208},
{-0.089814, 0.122855, -0.060349, 0.056337, -0.987426, 0.147557, 0.379860, 0.691805},
{-0.089959, 0.125417, -0.038353, 0.064333, -0.989288, 0.130955, 0.449631, 0.688424},
{-0.138646, 0.122339, -0.038905, 0.049837, -0.992279, 0.113559, 0.439583, 0.502207},
{-0.190962, 0.120234, -0.039191, 0.018159, -0.993652, 0.110904, 0.431149, 0.302095},
{-0.190964, 0.118418, -0.060662, 0.024537, -0.987823, 0.153478, 0.363846, 0.304860},
{-0.050128, 0.125041, -0.060649, 0.070833, -0.984344, 0.161290, 0.385391, 0.843687},
{-0.049847, 0.121117, -0.082328, 0.071657, -0.968871, 0.236946, 0.314970, 0.847509},
{-0.050195, 0.128182, -0.038031, 0.085604, -0.983795, 0.157476, 0.457749, 0.840536},
{-0.049306, 0.114832, -0.102522, 0.083712, -0.962920, 0.256355, 0.246266, 0.852077},
{-0.138613, 0.125210, -0.016437, 0.053255, -0.985565, 0.160497, 0.511171, 0.499455},
{-0.089957, 0.128755, -0.015647, 0.073275, -0.982543, 0.170873, 0.522496, 0.685534},
{-0.089906, 0.133302, 0.007367, 0.076144, -0.970275, 0.229621, 0.597743, 0.682821},
{-0.138571, 0.129547, 0.006274, 0.050417, -0.971038, 0.233406, 0.585243, 0.496738},
{-0.190943, 0.127435, 0.005401, 0.005982, -0.969176, 0.246193, 0.575018, 0.296493},
{-0.190941, 0.123000, -0.017003, 0.013367, -0.986297, 0.164342, 0.501759, 0.299330},
{-0.138597, 0.135976, 0.028765, 0.040620, -0.947172, 0.318094, 0.661140, 0.493843},
{-0.089904, 0.139492, 0.030289, 0.070009, -0.950407, 0.302988, 0.674662, 0.679967},
{-0.191007, 0.134259, 0.027525, -0.002808, -0.942137, 0.335154, 0.650266, 0.293508},
{-0.049797, 0.143399, 0.031466, 0.112583, -0.949217, 0.293680, 0.686768, 0.833306},
{-0.049934, 0.137104, 0.008204, 0.113315, -0.965148, 0.235817, 0.608678, 0.835684},
{-0.050099, 0.132118, -0.015021, 0.102725, -0.975982, 0.192053, 0.532258, 0.837981},
{-0.333800, 0.102006, -0.092631, -0.057649, -0.858272, 0.509903, 0.233484, -0.237654},
{-0.288501, 0.100813, -0.094018, 0.015534, -0.854946, 0.518448, 0.232233, -0.064240},
{-0.289022, 0.113450, -0.076313, 0.002350, -0.898862, 0.438215, 0.300963, -0.068257},
{-0.334252, 0.114507, -0.074757, -0.050752, -0.895596, 0.441908, 0.302575, -0.241434},
{-0.333225, 0.093228, -0.108923, -0.077578, -0.994568, 0.069094, 0.161574, -0.233962},
{-0.287730, 0.092250, -0.110125, 0.012757, -0.999603, 0.023927, 0.160827, -0.060245},
{-0.334695, 0.120888, -0.056335, -0.062624, -0.965026, 0.254494, 0.366027, -0.245390},
{-0.289480, 0.119212, -0.057672, -0.021912, -0.975158, 0.220313, 0.364341, -0.072317},
{-0.289920, 0.122134, -0.037812, -0.043580, -0.984741, 0.168310, 0.428035, -0.076535},
{-0.335188, 0.124818, -0.036808, -0.081179, -0.973998, 0.211371, 0.429907, -0.249746},
{-0.241415, 0.118221, -0.059389, -0.001373, -0.983428, 0.181219, 0.362597, 0.111725},
{-0.241251, 0.113208, -0.078665, 0.024689, -0.913297, 0.406507, 0.298157, 0.114759},
{-0.241616, 0.120386, -0.038716, -0.017914, -0.991272, 0.130436, 0.427874, 0.108296},
{-0.241164, 0.101407, -0.096231, 0.049196, -0.871853, 0.487259, 0.230803, 0.117118},
{-0.241061, 0.093896, -0.112006, 0.053957, -0.997986, -0.033052, 0.161992, 0.119142},
{-0.335795, 0.129966, -0.015615, -0.098483, -0.963225, 0.249855, 0.500281, -0.254724},
{-0.290387, 0.126254, -0.016450, -0.061068, -0.974334, 0.216651, 0.497710, -0.081024},
{-0.290864, 0.131856, 0.005601, -0.071291, -0.957701, 0.278726, 0.571242, -0.085608},
{-0.336475, 0.136221, 0.006363, -0.107700, -0.951292, 0.288766, 0.574350, -0.260058},
{-0.337187, 0.143472, 0.028246, -0.103671, -0.936491, 0.335002, 0.649315, -0.265482},
{-0.291335, 0.139227, 0.027527, -0.070803, -0.935362, 0.346477, 0.646503, -0.090111},
{-0.242264, 0.135750, 0.027200, -0.045717, -0.937010, 0.346202, 0.646104, 0.097538},
{-0.242030, 0.128566, 0.005229, -0.040834, -0.963866, 0.263161, 0.570908, 0.101143},
{-0.241817, 0.123640, -0.016960, -0.030763, -0.982238, 0.184912, 0.497738, 0.104749},
{0.263352, -0.248276, -0.525891, 0.038942, 0.014740, -0.999115, 0.666667, 0.666667},
{0.260762, -0.257796, -0.525891, 0.034944, 0.005951, -0.999359, 0.500000, 0.500000},
{0.231061, -0.270147, -0.525891, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000},
{0.255842, -0.245366, -0.525891, 0.022248, 0.022248, -0.999481, 0.500000, 1.000000},
{0.269351, -0.231858, -0.524845, 0.197760, 0.197760, -0.960082, 1.000000, 1.000000},
{0.275460, -0.240075, -0.524845, 0.271065, 0.103183, -0.956999, 1.000000, 0.500000},
{0.276766, -0.251229, -0.524845, 0.306345, 0.047578, -0.950713, 1.000000, 0.000000},
{0.265666, -0.263264, -0.525891, 0.045564, 0.001404, -0.998932, 0.666667, 0.666667},
{0.261341, -0.270147, -0.525891, 0.036836, 0.000000, -0.999298, 0.500000, 0.500000},
{0.260762, -0.257796, -0.525891, 0.034944, 0.005951, -0.999359, 0.500000, 1.000000},
{0.276766, -0.251229, -0.524845, 0.306345, 0.047578, -0.950713, 1.000000, 1.000000},
{0.278643, -0.260683, -0.524845, 0.311838, 0.011902, -0.950041, 1.000000, 0.500000},
{0.277562, -0.270147, -0.524845, 0.318735, 0.000000, -0.947813, 1.000000, 0.000000},
{0.265666, -0.277031, -0.525891, 0.045564, -0.001404, -0.998932, 0.666667, 0.666667},
{0.260762, -0.282498, -0.525891, 0.034944, -0.005951, -0.999359, 0.500000, 0.500000},
{0.261341, -0.270147, -0.525891, 0.036836, 0.000000, -0.999298, 0.500000, 1.000000},
{0.277562, -0.270147, -0.524845, 0.318735, 0.000000, -0.947813, 1.000000, 1.000000},
{0.278643, -0.279612, -0.524845, 0.311838, -0.011902, -0.950041, 1.000000, 0.500000},
{0.276766, -0.289066, -0.524845, 0.306345, -0.047578, -0.950713, 1.000000, 0.000000},
{0.263352, -0.292018, -0.525891, 0.038942, -0.014740, -0.999115, 0.666667, 0.666667},
{0.255842, -0.294928, -0.525891, 0.022248, -0.022248, -0.999481, 0.500000, 0.500000},
{0.260762, -0.282498, -0.525891, 0.034944, -0.005951, -0.999359, 0.500000, 1.000000},
{0.276766, -0.289066, -0.524845, 0.306345, -0.047578, -0.950713, 1.000000, 1.000000},
{0.275460, -0.300220, -0.524845, 0.271065, -0.103183, -0.956999, 1.000000, 0.500000},
{0.269351, -0.308436, -0.524845, 0.197760, -0.197760, -0.960082, 1.000000, 0.000000},
{0.252932, -0.302437, -0.525891, 0.014740, -0.038942, -0.999115, 0.666667, 0.666667},
{0.243413, -0.299848, -0.525891, 0.005951, -0.034944, -0.999359, 0.500000, 0.500000},
{0.255842, -0.294928, -0.525891, 0.022248, -0.022248, -0.999481, 0.500000, 1.000000},
{0.269351, -0.308436, -0.524845, 0.197760, -0.197760, -0.960082, 1.000000, 1.000000},
{0.261134, -0.314546, -0.524845, 0.103183, -0.271065, -0.956999, 1.000000, 0.500000},
{0.249980, -0.315852, -0.524845, 0.047578, -0.306345, -0.950713, 1.000000, 0.000000},
{0.237945, -0.304752, -0.525891, 0.001404, -0.045564, -0.998932, 0.666667, 0.666667},
{0.231061, -0.300427, -0.525891, 0.000000, -0.036836, -0.999298, 0.500000, 0.500000},
{0.243413, -0.299848, -0.525891, 0.005951, -0.034944, -0.999359, 0.500000, 1.000000},
{0.249980, -0.315852, -0.524845, 0.047578, -0.306345, -0.950713, 1.000000, 1.000000},
{0.240526, -0.317729, -0.524845, 0.011902, -0.311838, -0.950041, 1.000000, 0.500000},
{0.231061, -0.316647, -0.524845, 0.000000, -0.318735, -0.947813, 1.000000, 0.000000},
{0.224178, -0.304752, -0.525891, -0.001404, -0.045564, -0.998932, 0.666667, 0.666667},
{0.218710, -0.299848, -0.525891, -0.005951, -0.034944, -0.999359, 0.500000, 0.500000},
{0.231061, -0.300427, -0.525891, 0.000000, -0.036836, -0.999298, 0.500000, 1.000000},
{0.231061, -0.316647, -0.524845, 0.000000, -0.318735, -0.947813, 1.000000, 1.000000},
{0.221597, -0.317729, -0.524845, -0.011902, -0.311838, -0.950041, 1.000000, 0.500000},
{0.212143, -0.315852, -0.524845, -0.047578, -0.306345, -0.950713, 1.000000, 0.000000},
{0.209190, -0.302437, -0.525891, -0.014740, -0.038942, -0.999115, 0.666667, 0.666667},
{0.206280, -0.294928, -0.525891, -0.022248, -0.022248, -0.999481, 0.500000, 0.500000},
{0.218710, -0.299848, -0.525891, -0.005951, -0.034944, -0.999359, 0.500000, 1.000000},
{0.212143, -0.315852, -0.524845, -0.047578, -0.306345, -0.950713, 1.000000, 1.000000},
{0.200989, -0.314546, -0.524845, -0.103183, -0.271065, -0.956999, 1.000000, 0.500000},
{0.192772, -0.308436, -0.524845, -0.197760, -0.197760, -0.960082, 1.000000, 0.000000},
{0.198771, -0.292018, -0.525891, -0.038942, -0.014740, -0.999115, 0.666667, 0.666667},
{0.201361, -0.282498, -0.525891, -0.034944, -0.005951, -0.999359, 0.500000, 0.500000},
{0.206280, -0.294928, -0.525891, -0.022248, -0.022248, -0.999481, 0.500000, 1.000000},
{0.192772, -0.308436, -0.524845, -0.197760, -0.197760, -0.960082, 1.000000, 1.000000},
{0.186663, -0.300220, -0.524845, -0.271065, -0.103183, -0.956999, 1.000000, 0.500000},
{0.185357, -0.289066, -0.524845, -0.306345, -0.047578, -0.950713, 1.000000, 0.000000},
{0.196457, -0.277031, -0.525891, -0.045564, -0.001404, -0.998932, 0.666667, 0.666667},
{0.200782, -0.270147, -0.525891, -0.036836, 0.000000, -0.999298, 0.500000, 0.500000},
{0.201361, -0.282498, -0.525891, -0.034944, -0.005951, -0.999359, 0.500000, 1.000000},
{0.185357, -0.289066, -0.524845, -0.306345, -0.047578, -0.950713, 1.000000, 1.000000},
{0.183480, -0.279612, -0.524845, -0.311838, -0.011902, -0.950041, 1.000000, 0.500000},
{0.184561, -0.270147, -0.524845, -0.318735, 0.000000, -0.947813, 1.000000, 0.000000},
{0.196457, -0.263264, -0.525891, -0.045564, 0.001404, -0.998932, 0.666667, 0.666667},
{0.201361, -0.257796, -0.525891, -0.034944, 0.005951, -0.999359, 0.500000, 0.500000},
{0.200782, -0.270147, -0.525891, -0.036836, 0.000000, -0.999298, 0.500000, 1.000000},
{0.184561, -0.270147, -0.524845, -0.318735, 0.000000, -0.947813, 1.000000, 1.000000},
{0.183480, -0.260683, -0.524845, -0.311838, 0.011902, -0.950041, 1.000000, 0.500000},
{0.185357, -0.251229, -0.524845, -0.306345, 0.047578, -0.950713, 1.000000, 0.000000},
{0.198771, -0.248276, -0.525891, -0.038942, 0.014740, -0.999115, 0.666667, 0.666667},
{0.206280, -0.245366, -0.525891, -0.022248, 0.022248, -0.999481, 0.500000, 0.500000},
{0.201361, -0.257796, -0.525891, -0.034944, 0.005951, -0.999359, 0.500000, 1.000000},
{0.185357, -0.251229, -0.524845, -0.306345, 0.047578, -0.950713, 1.000000, 1.000000},
{0.186663, -0.240075, -0.524845, -0.271065, 0.103183, -0.956999, 1.000000, 0.500000},
{0.192772, -0.231858, -0.524845, -0.197760, 0.197760, -0.960082, 1.000000, 0.000000},
{0.209190, -0.237857, -0.525891, -0.014740, 0.038942, -0.999115, 0.666667, 0.666667},
{0.218710, -0.240447, -0.525891, -0.005951, 0.034944, -0.999359, 0.500000, 0.500000},
{0.206280, -0.245366, -0.525891, -0.022248, 0.022248, -0.999481, 0.500000, 1.000000},
{0.192772, -0.231858, -0.524845, -0.197760, 0.197760, -0.960082, 1.000000, 1.000000},
{0.200989, -0.225748, -0.524845, -0.103183, 0.271065, -0.956999, 1.000000, 0.500000},
{0.212143, -0.224443, -0.524845, -0.047578, 0.306345, -0.950713, 1.000000, 0.000000},
{0.224178, -0.235543, -0.525891, -0.001404, 0.045564, -0.998932, 0.666667, 0.666667},
{0.231061, -0.239868, -0.525891, 0.000000, 0.036836, -0.999298, 0.500000, 0.500000},
{0.218710, -0.240447, -0.525891, -0.005951, 0.034944, -0.999359, 0.500000, 1.000000},
{0.212143, -0.224443, -0.524845, -0.047578, 0.306345, -0.950713, 1.000000, 1.000000},
{0.221597, -0.222566, -0.524845, -0.011902, 0.311838, -0.950041, 1.000000, 0.500000},
{0.231061, -0.223647, -0.524845, 0.000000, 0.318735, -0.947813, 1.000000, 0.000000},
{0.237945, -0.235543, -0.525891, 0.001404, 0.045564, -0.998932, 0.666667, 0.666667},
{0.243413, -0.240447, -0.525891, 0.005951, 0.034944, -0.999359, 0.500000, 0.500000},
{0.231061, -0.239868, -0.525891, 0.000000, 0.036836, -0.999298, 0.500000, 1.000000},
{0.231061, -0.223647, -0.524845, 0.000000, 0.318735, -0.947813, 1.000000, 1.000000},
{0.240526, -0.222566, -0.524845, 0.011902, 0.311838, -0.950041, 1.000000, 0.500000},
{0.249980, -0.224443, -0.524845, 0.047578, 0.306345, -0.950713, 1.000000, 0.000000},
{0.252932, -0.237857, -0.525891, 0.014740, 0.038942, -0.999115, 0.666667, 0.666667},
{0.249980, -0.224443, -0.524845, 0.047578, 0.306345, -0.950713, 0.000000, 1.000000},
{0.261134, -0.225749, -0.524845, 0.103183, 0.271065, -0.956999, 0.500000, 1.000000},
{0.255842, -0.245366, -0.525891, 0.022248, 0.022248, -0.999481, 1.000000, 0.500000},
{0.231061, -0.270147, -0.525891, 0.000000, 0.000000, -1.000000, 1.000000, 0.000000},
{0.279497, -0.237341, -0.521706, 0.808832, 0.309824, -0.499741, 0.500000, 0.500000},
{0.275460, -0.240075, -0.524845, 0.271065, 0.103183, -0.956999, 0.000000, 0.500000},
{0.269351, -0.231858, -0.524845, 0.197760, 0.197760, -0.960082, 0.000000, 1.000000},
{0.273853, -0.227355, -0.521706, 0.605670, 0.605670, -0.516007, 0.500000, 1.000000},
{0.273853, -0.227355, -0.511596, 0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{0.279497, -0.237341, -0.511596, 0.933500, 0.358531, 0.000000, 1.000000, 0.500000},
{0.282101, -0.249040, -0.511596, 0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{0.282101, -0.249039, -0.521706, 0.864650, 0.131108, -0.484939, 0.500000, 0.000000},
{0.276766, -0.251229, -0.524845, 0.306345, 0.047578, -0.950713, 0.000000, 0.000000},
{0.282969, -0.259822, -0.521706, 0.875942, 0.034852, -0.481124, 0.500000, 0.500000},
{0.278643, -0.260683, -0.524845, 0.311838, 0.011902, -0.950041, 0.000000, 0.500000},
{0.276766, -0.251229, -0.524845, 0.306345, 0.047578, -0.950713, 0.000000, 1.000000},
{0.282101, -0.249039, -0.521706, 0.864650, 0.131108, -0.484939, 0.500000, 1.000000},
{0.282101, -0.249040, -0.511596, 0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{0.282969, -0.259822, -0.511596, 0.999176, 0.040132, 0.000000, 1.000000, 0.500000},
{0.282969, -0.270147, -0.511596, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{0.282969, -0.270147, -0.521706, 0.878658, 0.000000, -0.477401, 0.500000, 0.000000},
{0.277562, -0.270147, -0.524845, 0.318735, 0.000000, -0.947813, 0.000000, 0.000000},
{0.282969, -0.280472, -0.521706, 0.875942, -0.034852, -0.481124, 0.500000, 0.500000},
{0.278643, -0.279612, -0.524845, 0.311838, -0.011902, -0.950041, 0.000000, 0.500000},
{0.277562, -0.270147, -0.524845, 0.318735, 0.000000, -0.947813, 0.000000, 1.000000},
{0.282969, -0.270147, -0.521706, 0.878658, 0.000000, -0.477401, 0.500000, 1.000000},
{0.282969, -0.270147, -0.511596, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{0.282969, -0.280472, -0.511596, 0.999176, -0.040132, 0.000000, 1.000000, 0.500000},
{0.282101, -0.291255, -0.511596, 0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{0.282101, -0.291255, -0.521706, 0.864620, -0.131108, -0.484939, 0.500000, 0.000000},
{0.276766, -0.289066, -0.524845, 0.306345, -0.047578, -0.950713, 0.000000, 0.000000},
{0.279496, -0.302954, -0.521706, 0.808832, -0.309824, -0.499741, 0.500000, 0.500000},
{0.275460, -0.300220, -0.524845, 0.271065, -0.103183, -0.956999, 0.000000, 0.500000},
{0.276766, -0.289066, -0.524845, 0.306345, -0.047578, -0.950713, 0.000000, 1.000000},
{0.282101, -0.291255, -0.521706, 0.864620, -0.131108, -0.484939, 0.500000, 1.000000},
{0.282101, -0.291255, -0.511596, 0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{0.279496, -0.302954, -0.511596, 0.933500, -0.358531, 0.000000, 1.000000, 0.500000},
{0.273853, -0.312939, -0.511596, 0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{0.273853, -0.312939, -0.521706, 0.605670, -0.605670, -0.516007, 0.500000, 0.000000},
{0.269351, -0.308436, -0.524845, 0.197760, -0.197760, -0.960082, 0.000000, 0.000000},
{0.263868, -0.318582, -0.521706, 0.309824, -0.808832, -0.499741, 0.500000, 0.500000},
{0.261134, -0.314546, -0.524845, 0.103183, -0.271065, -0.956999, 0.000000, 0.500000},
{0.269351, -0.308436, -0.524845, 0.197760, -0.197760, -0.960082, 0.000000, 1.000000},
{0.273853, -0.312939, -0.521706, 0.605670, -0.605670, -0.516007, 0.500000, 1.000000},
{0.273853, -0.312939, -0.511596, 0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{0.263868, -0.318582, -0.511596, 0.358531, -0.933500, 0.000000, 1.000000, 0.500000},
{0.252169, -0.321186, -0.511596, 0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{0.252169, -0.321186, -0.521706, 0.131108, -0.864650, -0.484939, 0.500000, 0.000000},
{0.249980, -0.315852, -0.524845, 0.047578, -0.306345, -0.950713, 0.000000, 0.000000},
{0.241386, -0.322054, -0.521706, 0.034852, -0.875942, -0.481124, 0.500000, 0.500000},
{0.240526, -0.317729, -0.524845, 0.011902, -0.311838, -0.950041, 0.000000, 0.500000},
{0.249980, -0.315852, -0.524845, 0.047578, -0.306345, -0.950713, 0.000000, 1.000000},
{0.252169, -0.321186, -0.521706, 0.131108, -0.864650, -0.484939, 0.500000, 1.000000},
{0.252169, -0.321186, -0.511596, 0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{0.241386, -0.322054, -0.511596, 0.040132, -0.999176, 0.000000, 1.000000, 0.500000},
{0.231061, -0.322054, -0.511596, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000},
{0.231061, -0.322054, -0.521706, 0.000000, -0.878658, -0.477401, 0.500000, 0.000000},
{0.231061, -0.316647, -0.524845, 0.000000, -0.318735, -0.947813, 0.000000, 0.000000},
{0.220736, -0.322054, -0.521706, -0.034852, -0.875942, -0.481124, 0.500000, 0.500000},
{0.221597, -0.317729, -0.524845, -0.011902, -0.311838, -0.950041, 0.000000, 0.500000},
{0.231061, -0.316647, -0.524845, 0.000000, -0.318735, -0.947813, 0.000000, 1.000000},
{0.231061, -0.322054, -0.521706, 0.000000, -0.878658, -0.477401, 0.500000, 1.000000},
{0.231061, -0.322054, -0.511596, 0.000000, -1.000000, 0.000000, 1.000000, 1.000000},
{0.220736, -0.322054, -0.511596, -0.040132, -0.999176, 0.000000, 1.000000, 0.500000},
{0.209954, -0.321186, -0.511596, -0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{0.209954, -0.321186, -0.521706, -0.131108, -0.864650, -0.484939, 0.500000, 0.000000},
{0.212143, -0.315852, -0.524845, -0.047578, -0.306345, -0.950713, 0.000000, 0.000000},
{0.198255, -0.318582, -0.521706, -0.309824, -0.808832, -0.499741, 0.500000, 0.500000},
{0.200989, -0.314546, -0.524845, -0.103183, -0.271065, -0.956999, 0.000000, 0.500000},
{0.212143, -0.315852, -0.524845, -0.047578, -0.306345, -0.950713, 0.000000, 1.000000},
{0.209954, -0.321186, -0.521706, -0.131108, -0.864650, -0.484939, 0.500000, 1.000000},
{0.209954, -0.321186, -0.511596, -0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{0.198255, -0.318582, -0.511596, -0.358531, -0.933500, 0.000000, 1.000000, 0.500000},
{0.188270, -0.312939, -0.511596, -0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{0.188270, -0.312939, -0.521706, -0.605670, -0.605670, -0.516007, 0.500000, 0.000000},
{0.192772, -0.308436, -0.524845, -0.197760, -0.197760, -0.960082, 0.000000, 0.000000},
{0.182626, -0.302954, -0.521706, -0.808832, -0.309824, -0.499741, 0.500000, 0.500000},
{0.186663, -0.300220, -0.524845, -0.271065, -0.103183, -0.956999, 0.000000, 0.500000},
{0.192772, -0.308436, -0.524845, -0.197760, -0.197760, -0.960082, 0.000000, 1.000000},
{0.188270, -0.312939, -0.521706, -0.605670, -0.605670, -0.516007, 0.500000, 1.000000},
{0.188270, -0.312939, -0.511596, -0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{0.182626, -0.302954, -0.511596, -0.933500, -0.358531, 0.000000, 1.000000, 0.500000},
{0.180022, -0.291255, -0.511596, -0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{0.180022, -0.291255, -0.521706, -0.864620, -0.131108, -0.484939, 0.500000, 0.000000},
{0.185357, -0.289066, -0.524845, -0.306345, -0.047578, -0.950713, 0.000000, 0.000000},
{0.179154, -0.280472, -0.521706, -0.875942, -0.034852, -0.481124, 0.500000, 0.500000},
{0.183480, -0.279612, -0.524845, -0.311838, -0.011902, -0.950041, 0.000000, 0.500000},
{0.185357, -0.289066, -0.524845, -0.306345, -0.047578, -0.950713, 0.000000, 1.000000},
{0.180022, -0.291255, -0.521706, -0.864620, -0.131108, -0.484939, 0.500000, 1.000000},
{0.180022, -0.291255, -0.511596, -0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{0.179154, -0.280472, -0.511596, -0.999176, -0.040132, 0.000000, 1.000000, 0.500000},
{0.179154, -0.270147, -0.511596, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{0.179154, -0.270147, -0.521706, -0.878658, 0.000000, -0.477401, 0.500000, 0.000000},
{0.184561, -0.270147, -0.524845, -0.318735, 0.000000, -0.947813, 0.000000, 0.000000},
{0.179154, -0.259822, -0.521706, -0.875942, 0.034852, -0.481124, 0.500000, 0.500000},
{0.183480, -0.260683, -0.524845, -0.311838, 0.011902, -0.950041, 0.000000, 0.500000},
{0.184561, -0.270147, -0.524845, -0.318735, 0.000000, -0.947813, 0.000000, 1.000000},
{0.179154, -0.270147, -0.521706, -0.878658, 0.000000, -0.477401, 0.500000, 1.000000},
{0.179154, -0.270147, -0.511596, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{0.179154, -0.259822, -0.511596, -0.999176, 0.040132, 0.000000, 1.000000, 0.500000},
{0.180022, -0.249039, -0.511596, -0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{0.180022, -0.249039, -0.521706, -0.864620, 0.131108, -0.484939, 0.500000, 0.000000},
{0.185357, -0.251229, -0.524845, -0.306345, 0.047578, -0.950713, 0.000000, 0.000000},
{0.182626, -0.237341, -0.521706, -0.808832, 0.309824, -0.499741, 0.500000, 0.500000},
{0.186663, -0.240075, -0.524845, -0.271065, 0.103183, -0.956999, 0.000000, 0.500000},
{0.185357, -0.251229, -0.524845, -0.306345, 0.047578, -0.950713, 0.000000, 1.000000},
{0.180022, -0.249039, -0.521706, -0.864620, 0.131108, -0.484939, 0.500000, 1.000000},
{0.180022, -0.249039, -0.511596, -0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{0.182626, -0.237341, -0.511596, -0.933500, 0.358531, 0.000000, 1.000000, 0.500000},
{0.188270, -0.227355, -0.511596, -0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{0.188270, -0.227355, -0.521706, -0.605670, 0.605670, -0.516007, 0.500000, 0.000000},
{0.192772, -0.231858, -0.524845, -0.197760, 0.197760, -0.960082, 0.000000, 0.000000},
{0.198255, -0.221712, -0.521706, -0.309824, 0.808832, -0.499741, 0.500000, 0.500000},
{0.200989, -0.225748, -0.524845, -0.103183, 0.271065, -0.956999, 0.000000, 0.500000},
{0.192772, -0.231858, -0.524845, -0.197760, 0.197760, -0.960082, 0.000000, 1.000000},
{0.188270, -0.227355, -0.521706, -0.605670, 0.605670, -0.516007, 0.500000, 1.000000},
{0.188270, -0.227355, -0.511596, -0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{0.198255, -0.221712, -0.511596, -0.358531, 0.933500, 0.000000, 1.000000, 0.500000},
{0.209954, -0.219108, -0.511596, -0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{0.209954, -0.219108, -0.521706, -0.131108, 0.864650, -0.484939, 0.500000, 0.000000},
{0.212143, -0.224443, -0.524845, -0.047578, 0.306345, -0.950713, 0.000000, 0.000000},
{0.220737, -0.218240, -0.521706, -0.034852, 0.875942, -0.481124, 0.500000, 0.500000},
{0.221597, -0.222566, -0.524845, -0.011902, 0.311838, -0.950041, 0.000000, 0.500000},
{0.212143, -0.224443, -0.524845, -0.047578, 0.306345, -0.950713, 0.000000, 1.000000},
{0.209954, -0.219108, -0.521706, -0.131108, 0.864650, -0.484939, 0.500000, 1.000000},
{0.209954, -0.219108, -0.511596, -0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{0.220737, -0.218240, -0.511596, -0.040132, 0.999176, 0.000000, 1.000000, 0.500000},
{0.231062, -0.218240, -0.511596, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000},
{0.231062, -0.218240, -0.521706, 0.000000, 0.878658, -0.477401, 0.500000, 0.000000},
{0.231061, -0.223647, -0.524845, 0.000000, 0.318735, -0.947813, 0.000000, 0.000000},
{0.241387, -0.218240, -0.521706, 0.034852, 0.875942, -0.481124, 0.500000, 0.500000},
{0.240526, -0.222566, -0.524845, 0.011902, 0.311838, -0.950041, 0.000000, 0.500000},
{0.231061, -0.223647, -0.524845, 0.000000, 0.318735, -0.947813, 0.000000, 1.000000},
{0.231062, -0.218240, -0.521706, 0.000000, 0.878658, -0.477401, 0.500000, 1.000000},
{0.231062, -0.218240, -0.511596, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000},
{0.241387, -0.218240, -0.511596, 0.040132, 0.999176, 0.000000, 1.000000, 0.500000},
{0.252169, -0.219108, -0.511596, 0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{0.252169, -0.219108, -0.521706, 0.131108, 0.864620, -0.484939, 0.500000, 0.000000},
{0.249980, -0.224443, -0.524845, 0.047578, 0.306345, -0.950713, 0.000000, 0.000000},
{0.263868, -0.221712, -0.521706, 0.309824, 0.808832, -0.499741, 0.500000, 0.500000},
{0.263868, -0.221712, -0.511596, 0.358531, 0.933500, 0.000000, 0.000000, 0.500000},
{0.273853, -0.227355, -0.511596, 0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{0.261134, -0.225749, -0.524845, 0.103183, 0.271065, -0.956999, 1.000000, 0.500000},
{0.252169, -0.219108, -0.511596, 0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{0.279497, -0.237341, -0.489637, 0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{0.279497, -0.237341, -0.511596, 0.933500, 0.358531, 0.000000, 0.000000, 0.500000},
{0.273853, -0.227355, -0.489637, 0.707083, 0.707083, 0.000000, 0.500000, 1.000000},
{0.273853, -0.227355, -0.468359, 0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{0.279497, -0.237341, -0.468359, 0.933500, 0.358531, 0.000000, 1.000000, 0.500000},
{0.282101, -0.249040, -0.468359, 0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{0.282101, -0.249040, -0.489637, 0.988800, 0.149113, 0.000000, 0.500000, 0.000000},
{0.282101, -0.249040, -0.511596, 0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{0.279497, -0.237341, -0.460287, 0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{0.279497, -0.237341, -0.468359, 0.933500, 0.358531, 0.000000, 0.000000, 0.500000},
{0.273853, -0.227355, -0.468359, 0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{0.273853, -0.227355, -0.460287, 0.707083, 0.707083, 0.000000, 0.500000, 1.000000},
{0.273853, -0.227355, -0.458820, 0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{0.279497, -0.237341, -0.458820, 0.933500, 0.358531, 0.000000, 1.000000, 0.500000},
{0.282101, -0.249040, -0.458820, 0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{0.282101, -0.249040, -0.460287, 0.988800, 0.149113, 0.000000, 0.500000, 0.000000},
{0.282101, -0.249040, -0.468359, 0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{0.282969, -0.259822, -0.489637, 0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{0.282969, -0.259822, -0.511596, 0.999176, 0.040132, 0.000000, 0.000000, 0.500000},
{0.282101, -0.249040, -0.511596, 0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{0.282101, -0.249040, -0.489637, 0.988800, 0.149113, 0.000000, 0.500000, 1.000000},
{0.282101, -0.249040, -0.468359, 0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{0.282969, -0.259822, -0.468359, 0.999176, 0.040132, 0.000000, 1.000000, 0.500000},
{0.282969, -0.270147, -0.468359, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{0.282969, -0.270147, -0.489637, 1.000000, 0.000000, 0.000000, 0.500000, 0.000000},
{0.282969, -0.270147, -0.511596, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{0.282969, -0.259822, -0.460287, 0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{0.282969, -0.259822, -0.468359, 0.999176, 0.040132, 0.000000, 0.000000, 0.500000},
{0.282101, -0.249040, -0.468359, 0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{0.282101, -0.249040, -0.460287, 0.988800, 0.149113, 0.000000, 0.500000, 1.000000},
{0.282101, -0.249040, -0.458820, 0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{0.282969, -0.259822, -0.458820, 0.999176, 0.040132, 0.000000, 1.000000, 0.500000},
{0.282969, -0.270147, -0.458820, 1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{0.282969, -0.270147, -0.460287, 1.000000, 0.000000, 0.000000, 0.500000, 0.000000},
{0.282969, -0.270147, -0.468359, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{0.282969, -0.280472, -0.489637, 0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{0.282969, -0.280472, -0.511596, 0.999176, -0.040132, 0.000000, 0.000000, 0.500000},
{0.282969, -0.270147, -0.511596, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{0.282969, -0.270147, -0.489637, 1.000000, 0.000000, 0.000000, 0.500000, 1.000000},
{0.282969, -0.270147, -0.468359, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{0.282969, -0.280472, -0.468359, 0.999176, -0.040132, 0.000000, 1.000000, 0.500000},
{0.282101, -0.291255, -0.468359, 0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{0.282101, -0.291255, -0.489637, 0.988800, -0.149113, 0.000000, 0.500000, 0.000000},
{0.282101, -0.291255, -0.511596, 0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{0.282969, -0.280472, -0.460287, 0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{0.282969, -0.280472, -0.468359, 0.999176, -0.040132, 0.000000, 0.000000, 0.500000},
{0.282969, -0.270147, -0.468359, 1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{0.282969, -0.270147, -0.460287, 1.000000, 0.000000, 0.000000, 0.500000, 1.000000},
{0.282969, -0.270147, -0.458820, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{0.282969, -0.280472, -0.458820, 0.999176, -0.040132, 0.000000, 1.000000, 0.500000},
{0.282101, -0.291255, -0.458820, 0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{0.282101, -0.291255, -0.460287, 0.988800, -0.149113, 0.000000, 0.500000, 0.000000},
{0.282101, -0.291255, -0.468359, 0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{0.279496, -0.302954, -0.489637, 0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{0.279496, -0.302954, -0.511596, 0.933500, -0.358531, 0.000000, 0.000000, 0.500000},
{0.282101, -0.291255, -0.511596, 0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{0.282101, -0.291255, -0.489637, 0.988800, -0.149113, 0.000000, 0.500000, 1.000000},
{0.282101, -0.291255, -0.468359, 0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{0.279496, -0.302954, -0.468359, 0.933500, -0.358531, 0.000000, 1.000000, 0.500000},
{0.273853, -0.312939, -0.468359, 0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{0.273853, -0.312939, -0.489637, 0.707083, -0.707083, 0.000000, 0.500000, 0.000000},
{0.273853, -0.312939, -0.511596, 0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{0.279496, -0.302954, -0.460287, 0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{0.279496, -0.302954, -0.468359, 0.933500, -0.358531, 0.000000, 0.000000, 0.500000},
{0.282101, -0.291255, -0.468359, 0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{0.282101, -0.291255, -0.460287, 0.988800, -0.149113, 0.000000, 0.500000, 1.000000},
{0.282101, -0.291255, -0.458820, 0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{0.279496, -0.302954, -0.458820, 0.933500, -0.358531, 0.000000, 1.000000, 0.500000},
{0.273853, -0.312939, -0.458820, 0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{0.273853, -0.312939, -0.460287, 0.707083, -0.707083, 0.000000, 0.500000, 0.000000},
{0.273853, -0.312939, -0.468359, 0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{0.263868, -0.318582, -0.489637, 0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{0.263868, -0.318582, -0.511596, 0.358531, -0.933500, 0.000000, 0.000000, 0.500000},
{0.273853, -0.312939, -0.511596, 0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{0.273853, -0.312939, -0.489637, 0.707083, -0.707083, 0.000000, 0.500000, 1.000000},
{0.273853, -0.312939, -0.468359, 0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{0.263868, -0.318582, -0.468359, 0.358531, -0.933500, 0.000000, 1.000000, 0.500000},
{0.252169, -0.321186, -0.468359, 0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{0.252169, -0.321186, -0.489637, 0.149113, -0.988800, 0.000000, 0.500000, 0.000000},
{0.252169, -0.321186, -0.511596, 0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{0.263868, -0.318582, -0.460287, 0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{0.263868, -0.318582, -0.468359, 0.358531, -0.933500, 0.000000, 0.000000, 0.500000},
{0.273853, -0.312939, -0.468359, 0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{0.273853, -0.312939, -0.460287, 0.707083, -0.707083, 0.000000, 0.500000, 1.000000},
{0.273853, -0.312939, -0.458820, 0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{0.263868, -0.318582, -0.458820, 0.358531, -0.933500, 0.000000, 1.000000, 0.500000},
{0.252169, -0.321186, -0.458820, 0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{0.252169, -0.321186, -0.460287, 0.149113, -0.988800, 0.000000, 0.500000, 0.000000},
{0.252169, -0.321186, -0.468359, 0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{0.241386, -0.322054, -0.489637, 0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{0.241386, -0.322054, -0.511596, 0.040132, -0.999176, 0.000000, 0.000000, 0.500000},
{0.252169, -0.321186, -0.511596, 0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{0.252169, -0.321186, -0.489637, 0.149113, -0.988800, 0.000000, 0.500000, 1.000000},
{0.252169, -0.321186, -0.468359, 0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{0.241386, -0.322054, -0.468359, 0.040132, -0.999176, 0.000000, 1.000000, 0.500000},
{0.231061, -0.322054, -0.468359, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000},
{0.231061, -0.322054, -0.489637, 0.000000, -1.000000, 0.000000, 0.500000, 0.000000},
{0.231061, -0.322054, -0.511596, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000},
{0.241386, -0.322054, -0.460287, 0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{0.241386, -0.322054, -0.468359, 0.040132, -0.999176, 0.000000, 0.000000, 0.500000},
{0.252169, -0.321186, -0.468359, 0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{0.252169, -0.321186, -0.460287, 0.149113, -0.988800, 0.000000, 0.500000, 1.000000},
{0.252169, -0.321186, -0.458820, 0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{0.241386, -0.322054, -0.458820, 0.040132, -0.999176, 0.000000, 1.000000, 0.500000},
{0.231061, -0.322054, -0.458820, 0.000000, -1.000000, 0.000000, 1.000000, 0.000000},
{0.231061, -0.322054, -0.460287, 0.000000, -1.000000, 0.000000, 0.500000, 0.000000},
{0.231061, -0.322054, -0.468359, 0.000000, -1.000000, 0.000000, 0.000000, 0.000000},
{0.220736, -0.322054, -0.489637, -0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{0.220736, -0.322054, -0.511596, -0.040132, -0.999176, 0.000000, 0.000000, 0.500000},
{0.231061, -0.322054, -0.511596, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000},
{0.231061, -0.322054, -0.489637, 0.000000, -1.000000, 0.000000, 0.500000, 1.000000},
{0.231061, -0.322054, -0.468359, 0.000000, -1.000000, 0.000000, 1.000000, 1.000000},
{0.220736, -0.322054, -0.468359, -0.040132, -0.999176, 0.000000, 1.000000, 0.500000},
{0.209954, -0.321186, -0.468359, -0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{0.209954, -0.321186, -0.489637, -0.149113, -0.988800, 0.000000, 0.500000, 0.000000},
{0.209954, -0.321186, -0.511596, -0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{0.220736, -0.322054, -0.460287, -0.040132, -0.999176, 0.000000, 0.500000, 0.500000},
{0.220736, -0.322054, -0.468359, -0.040132, -0.999176, 0.000000, 0.000000, 0.500000},
{0.231061, -0.322054, -0.468359, 0.000000, -1.000000, 0.000000, 0.000000, 1.000000},
{0.231061, -0.322054, -0.460287, 0.000000, -1.000000, 0.000000, 0.500000, 1.000000},
{0.231061, -0.322054, -0.458820, 0.000000, -1.000000, 0.000000, 1.000000, 1.000000},
{0.220736, -0.322054, -0.458820, -0.040132, -0.999176, 0.000000, 1.000000, 0.500000},
{0.209954, -0.321186, -0.458820, -0.149113, -0.988800, 0.000000, 1.000000, 0.000000},
{0.209954, -0.321186, -0.460287, -0.149113, -0.988800, 0.000000, 0.500000, 0.000000},
{0.209954, -0.321186, -0.468359, -0.149113, -0.988800, 0.000000, 0.000000, 0.000000},
{0.198255, -0.318582, -0.489637, -0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{0.198255, -0.318582, -0.511596, -0.358531, -0.933500, 0.000000, 0.000000, 0.500000},
{0.209954, -0.321186, -0.511596, -0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{0.209954, -0.321186, -0.489637, -0.149113, -0.988800, 0.000000, 0.500000, 1.000000},
{0.209954, -0.321186, -0.468359, -0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{0.198255, -0.318582, -0.468359, -0.358531, -0.933500, 0.000000, 1.000000, 0.500000},
{0.188269, -0.312939, -0.468359, -0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{0.188270, -0.312939, -0.489637, -0.707083, -0.707083, 0.000000, 0.500000, 0.000000},
{0.188270, -0.312939, -0.511596, -0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{0.198255, -0.318582, -0.460287, -0.358531, -0.933500, 0.000000, 0.500000, 0.500000},
{0.198255, -0.318582, -0.468359, -0.358531, -0.933500, 0.000000, 0.000000, 0.500000},
{0.209954, -0.321186, -0.468359, -0.149113, -0.988800, 0.000000, 0.000000, 1.000000},
{0.209954, -0.321186, -0.460287, -0.149113, -0.988800, 0.000000, 0.500000, 1.000000},
{0.209954, -0.321186, -0.458820, -0.149113, -0.988800, 0.000000, 1.000000, 1.000000},
{0.198255, -0.318582, -0.458820, -0.358531, -0.933500, 0.000000, 1.000000, 0.500000},
{0.188269, -0.312939, -0.458820, -0.707083, -0.707083, 0.000000, 1.000000, 0.000000},
{0.188269, -0.312939, -0.460287, -0.707083, -0.707083, 0.000000, 0.500000, 0.000000},
{0.188269, -0.312939, -0.468359, -0.707083, -0.707083, 0.000000, 0.000000, 0.000000},
{0.182626, -0.302954, -0.489637, -0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{0.182626, -0.302954, -0.511596, -0.933500, -0.358531, 0.000000, 0.000000, 0.500000},
{0.188270, -0.312939, -0.511596, -0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{0.188270, -0.312939, -0.489637, -0.707083, -0.707083, 0.000000, 0.500000, 1.000000},
{0.188269, -0.312939, -0.468359, -0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{0.182626, -0.302954, -0.468359, -0.933500, -0.358531, 0.000000, 1.000000, 0.500000},
{0.180022, -0.291255, -0.468359, -0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{0.180022, -0.291255, -0.489637, -0.988800, -0.149113, 0.000000, 0.500000, 0.000000},
{0.180022, -0.291255, -0.511596, -0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{0.182626, -0.302954, -0.460287, -0.933500, -0.358531, 0.000000, 0.500000, 0.500000},
{0.182626, -0.302954, -0.468359, -0.933500, -0.358531, 0.000000, 0.000000, 0.500000},
{0.188269, -0.312939, -0.468359, -0.707083, -0.707083, 0.000000, 0.000000, 1.000000},
{0.188269, -0.312939, -0.460287, -0.707083, -0.707083, 0.000000, 0.500000, 1.000000},
{0.188269, -0.312939, -0.458820, -0.707083, -0.707083, 0.000000, 1.000000, 1.000000},
{0.182626, -0.302954, -0.458820, -0.933500, -0.358531, 0.000000, 1.000000, 0.500000},
{0.180022, -0.291255, -0.458820, -0.988800, -0.149113, 0.000000, 1.000000, 0.000000},
{0.180022, -0.291255, -0.460287, -0.988800, -0.149113, 0.000000, 0.500000, 0.000000},
{0.180022, -0.291255, -0.468359, -0.988800, -0.149113, 0.000000, 0.000000, 0.000000},
{0.179154, -0.280472, -0.489637, -0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{0.179154, -0.280472, -0.511596, -0.999176, -0.040132, 0.000000, 0.000000, 0.500000},
{0.180022, -0.291255, -0.511596, -0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{0.180022, -0.291255, -0.489637, -0.988800, -0.149113, 0.000000, 0.500000, 1.000000},
{0.180022, -0.291255, -0.468359, -0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{0.179154, -0.280472, -0.468359, -0.999176, -0.040132, 0.000000, 1.000000, 0.500000},
{0.179154, -0.270147, -0.468359, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{0.179154, -0.270147, -0.489637, -1.000000, 0.000000, 0.000000, 0.500000, 0.000000},
{0.179154, -0.270147, -0.511596, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{0.179154, -0.280472, -0.460287, -0.999176, -0.040132, 0.000000, 0.500000, 0.500000},
{0.179154, -0.280472, -0.468359, -0.999176, -0.040132, 0.000000, 0.000000, 0.500000},
{0.180022, -0.291255, -0.468359, -0.988800, -0.149113, 0.000000, 0.000000, 1.000000},
{0.180022, -0.291255, -0.460287, -0.988800, -0.149113, 0.000000, 0.500000, 1.000000},
{0.180022, -0.291255, -0.458820, -0.988800, -0.149113, 0.000000, 1.000000, 1.000000},
{0.179154, -0.280472, -0.458820, -0.999176, -0.040132, 0.000000, 1.000000, 0.500000},
{0.179154, -0.270147, -0.458820, -1.000000, 0.000000, 0.000000, 1.000000, 0.000000},
{0.179154, -0.270147, -0.460287, -1.000000, 0.000000, 0.000000, 0.500000, 0.000000},
{0.179154, -0.270147, -0.468359, -1.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{0.179154, -0.259822, -0.489637, -0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{0.179154, -0.259822, -0.511596, -0.999176, 0.040132, 0.000000, 0.000000, 0.500000},
{0.179154, -0.270147, -0.511596, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{0.179154, -0.270147, -0.489637, -1.000000, 0.000000, 0.000000, 0.500000, 1.000000},
{0.179154, -0.270147, -0.468359, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{0.179154, -0.259822, -0.468359, -0.999176, 0.040132, 0.000000, 1.000000, 0.500000},
{0.180022, -0.249039, -0.468359, -0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{0.180022, -0.249039, -0.489637, -0.988800, 0.149113, 0.000000, 0.500000, 0.000000},
{0.180022, -0.249039, -0.511596, -0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{0.179154, -0.259822, -0.460287, -0.999176, 0.040132, 0.000000, 0.500000, 0.500000},
{0.179154, -0.259822, -0.468359, -0.999176, 0.040132, 0.000000, 0.000000, 0.500000},
{0.179154, -0.270147, -0.468359, -1.000000, 0.000000, 0.000000, 0.000000, 1.000000},
{0.179154, -0.270147, -0.460287, -1.000000, 0.000000, 0.000000, 0.500000, 1.000000},
{0.179154, -0.270147, -0.458820, -1.000000, 0.000000, 0.000000, 1.000000, 1.000000},
{0.179154, -0.259822, -0.458820, -0.999176, 0.040132, 0.000000, 1.000000, 0.500000},
{0.180022, -0.249039, -0.458820, -0.988800, 0.149113, 0.000000, 1.000000, 0.000000},
{0.180022, -0.249039, -0.460287, -0.988800, 0.149113, 0.000000, 0.500000, 0.000000},
{0.180022, -0.249039, -0.468359, -0.988800, 0.149113, 0.000000, 0.000000, 0.000000},
{0.182626, -0.237341, -0.489637, -0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{0.182626, -0.237341, -0.511596, -0.933500, 0.358531, 0.000000, 0.000000, 0.500000},
{0.180022, -0.249039, -0.511596, -0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{0.180022, -0.249039, -0.489637, -0.988800, 0.149113, 0.000000, 0.500000, 1.000000},
{0.180022, -0.249039, -0.468359, -0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{0.182626, -0.237341, -0.468359, -0.933500, 0.358531, 0.000000, 1.000000, 0.500000},
{0.188270, -0.227355, -0.468359, -0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{0.188270, -0.227355, -0.489637, -0.707083, 0.707083, 0.000000, 0.500000, 0.000000},
{0.188270, -0.227355, -0.511596, -0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{0.182626, -0.237341, -0.460287, -0.933500, 0.358531, 0.000000, 0.500000, 0.500000},
{0.182626, -0.237341, -0.468359, -0.933500, 0.358531, 0.000000, 0.000000, 0.500000},
{0.180022, -0.249039, -0.468359, -0.988800, 0.149113, 0.000000, 0.000000, 1.000000},
{0.180022, -0.249039, -0.460287, -0.988800, 0.149113, 0.000000, 0.500000, 1.000000},
{0.180022, -0.249039, -0.458820, -0.988800, 0.149113, 0.000000, 1.000000, 1.000000},
{0.182626, -0.237341, -0.458820, -0.933500, 0.358531, 0.000000, 1.000000, 0.500000},
{0.188270, -0.227355, -0.458820, -0.707083, 0.707083, 0.000000, 1.000000, 0.000000},
{0.188270, -0.227355, -0.460287, -0.707083, 0.707083, 0.000000, 0.500000, 0.000000},
{0.188270, -0.227355, -0.468359, -0.707083, 0.707083, 0.000000, 0.000000, 0.000000},
{0.198255, -0.221712, -0.489637, -0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{0.198255, -0.221712, -0.511596, -0.358531, 0.933500, 0.000000, 0.000000, 0.500000},
{0.188270, -0.227355, -0.511596, -0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{0.188270, -0.227355, -0.489637, -0.707083, 0.707083, 0.000000, 0.500000, 1.000000},
{0.188270, -0.227355, -0.468359, -0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{0.198255, -0.221712, -0.468359, -0.358531, 0.933500, 0.000000, 1.000000, 0.500000},
{0.209954, -0.219108, -0.468359, -0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{0.209954, -0.219108, -0.489637, -0.149113, 0.988800, 0.000000, 0.500000, 0.000000},
{0.209954, -0.219108, -0.511596, -0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{0.198255, -0.221712, -0.460287, -0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{0.198255, -0.221712, -0.468359, -0.358531, 0.933500, 0.000000, 0.000000, 0.500000},
{0.188270, -0.227355, -0.468359, -0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{0.188270, -0.227355, -0.460287, -0.707083, 0.707083, 0.000000, 0.500000, 1.000000},
{0.188270, -0.227355, -0.458820, -0.707083, 0.707083, 0.000000, 1.000000, 1.000000},
{0.198255, -0.221712, -0.458820, -0.358531, 0.933500, 0.000000, 1.000000, 0.500000},
{0.209954, -0.219108, -0.458820, -0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{0.209954, -0.219108, -0.460287, -0.149113, 0.988800, 0.000000, 0.500000, 0.000000},
{0.209954, -0.219108, -0.468359, -0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{0.220737, -0.218240, -0.489637, -0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{0.220737, -0.218240, -0.511596, -0.040132, 0.999176, 0.000000, 0.000000, 0.500000},
{0.209954, -0.219108, -0.511596, -0.149113, 0.988800, 0.000000, 0.000000, 1.000000},
{0.209954, -0.219108, -0.489637, -0.149113, 0.988800, 0.000000, 0.500000, 1.000000},
{0.209954, -0.219108, -0.468359, -0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{0.220737, -0.218240, -0.468359, -0.040132, 0.999176, 0.000000, 1.000000, 0.500000},
{0.231062, -0.218240, -0.468359, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000},
{0.231062, -0.218240, -0.489637, 0.000000, 1.000000, 0.000000, 0.500000, 0.000000},
{0.231062, -0.218240, -0.511596, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000},
{0.220737, -0.218240, -0.460287, -0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{0.220737, -0.218240, -0.468359, -0.040132, 0.999176, 0.000000, 0.000000, 0.500000},
{0.209954, -0.219108, -0.468359, -0.149113, 0.988800, 0.000000, 0.000000, 1.000000},
{0.209954, -0.219108, -0.460287, -0.149113, 0.988800, 0.000000, 0.500000, 1.000000},
{0.209954, -0.219108, -0.458820, -0.149113, 0.988800, 0.000000, 1.000000, 1.000000},
{0.220737, -0.218240, -0.458820, -0.040132, 0.999176, 0.000000, 1.000000, 0.500000},
{0.231062, -0.218240, -0.458820, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000},
{0.231062, -0.218240, -0.460287, 0.000000, 1.000000, 0.000000, 0.500000, 0.000000},
{0.231062, -0.218240, -0.468359, 0.000000, 1.000000, 0.000000, 0.000000, 0.000000},
{0.241387, -0.218240, -0.489637, 0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{0.241387, -0.218240, -0.511596, 0.040132, 0.999176, 0.000000, 0.000000, 0.500000},
{0.231062, -0.218240, -0.511596, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000},
{0.231062, -0.218240, -0.489637, 0.000000, 1.000000, 0.000000, 0.500000, 1.000000},
{0.231062, -0.218240, -0.468359, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000},
{0.241387, -0.218240, -0.468359, 0.040132, 0.999176, 0.000000, 1.000000, 0.500000},
{0.252169, -0.219108, -0.468359, 0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{0.252169, -0.219108, -0.489637, 0.149113, 0.988800, 0.000000, 0.500000, 0.000000},
{0.241387, -0.218240, -0.460287, 0.040132, 0.999176, 0.000000, 0.500000, 0.500000},
{0.241387, -0.218240, -0.468359, 0.040132, 0.999176, 0.000000, 0.000000, 0.500000},
{0.231062, -0.218240, -0.468359, 0.000000, 1.000000, 0.000000, 0.000000, 1.000000},
{0.231062, -0.218240, -0.460287, 0.000000, 1.000000, 0.000000, 0.500000, 1.000000},
{0.231062, -0.218240, -0.458820, 0.000000, 1.000000, 0.000000, 1.000000, 1.000000},
{0.241387, -0.218240, -0.458820, 0.040132, 0.999176, 0.000000, 1.000000, 0.500000},
{0.252169, -0.219108, -0.458820, 0.149113, 0.988800, 0.000000, 1.000000, 0.000000},
{0.252169, -0.219108, -0.460287, 0.149113, 0.988800, 0.000000, 0.500000, 0.000000},
{0.252169, -0.219108, -0.468359, 0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{0.263868, -0.221712, -0.460287, 0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{0.263868, -0.221712, -0.458820, 0.358531, 0.933500, 0.000000, 0.000000, 0.500000},
{0.273853, -0.227355, -0.458820, 0.707083, 0.707083, 0.000000, 0.000000, 1.000000},
{0.263868, -0.221712, -0.468359, 0.358531, 0.933500, 0.000000, 1.000000, 0.500000},
{0.252169, -0.219108, -0.458820, 0.149113, 0.988800, 0.000000, 0.000000, 0.000000},
{0.263868, -0.221712, -0.489637, 0.358531, 0.933500, 0.000000, 0.500000, 0.500000},
{0.263868, -0.221712, -0.468359, 0.358531, 0.933500, 0.000000, 0.000000, 0.500000},
{0.263868, -0.221712, -0.511596, 0.358531, 0.933500, 0.000000, 1.000000, 0.500000}
};

unsigned short indexes[]={0, 1, 2,0, 2, 3,0, 3, 4,0, 4, 5,
0, 5, 6,0, 6, 7,0, 7, 8,0, 8, 1,
9, 10, 11,9, 11, 12,9, 12, 13,9, 13, 14,
9, 14, 15,9, 15, 16,9, 16, 17,9, 17, 10,
18, 19, 11,18, 11, 10,18, 10, 17,18, 17, 20,
18, 20, 21,18, 21, 22,18, 22, 23,18, 23, 19,
24, 25, 11,24, 11, 19,24, 19, 23,24, 23, 26,
24, 26, 27,24, 27, 28,24, 28, 29,24, 29, 25,
30, 31, 32,30, 32, 33,30, 33, 34,30, 34, 35,
30, 35, 36,30, 36, 37,30, 37, 38,30, 38, 31,
39, 40, 32,39, 32, 31,39, 31, 38,39, 38, 41,
39, 41, 42,39, 42, 43,39, 43, 44,39, 44, 40,
45, 46, 32,45, 32, 40,45, 40, 44,45, 44, 47,
45, 47, 48,45, 48, 49,45, 49, 50,45, 50, 46,
51, 52, 53,51, 53, 54,51, 54, 55,51, 55, 56,
51, 56, 57,51, 57, 58,51, 58, 59,51, 59, 52,
60, 61, 62,60, 62, 63,60, 63, 64,60, 64, 65,
60, 65, 66,60, 66, 67,60, 67, 68,60, 68, 61,
69, 70, 62,69, 62, 61,69, 61, 68,69, 68, 71,
69, 71, 6,69, 6, 5,69, 5, 4,69, 4, 70,
72, 73, 62,72, 62, 70,72, 70, 4,72, 4, 74,
72, 74, 75,72, 75, 76,72, 76, 77,72, 77, 73,
78, 63, 62,78, 62, 73,78, 73, 77,78, 77, 79,
78, 79, 80,78, 80, 81,78, 81, 64,78, 64, 63,
82, 83, 84,82, 84, 85,82, 85, 86,82, 86, 87,
82, 87, 88,82, 88, 89,82, 89, 90,82, 90, 83,
91, 92, 84,91, 84, 83,91, 83, 90,91, 90, 93,
91, 93, 94,91, 94, 95,91, 95, 96,91, 96, 92,
97, 98, 84,97, 84, 92,97, 92, 96,97, 96, 99,
97, 99, 100,97, 100, 101,97, 101, 102,97, 102, 98,
103, 85, 84,103, 84, 98,103, 98, 102,103, 102, 104,
103, 104, 105,103, 105, 106,103, 106, 86,103, 86, 85,
107, 108, 109,107, 109, 110,107, 110, 111,107, 111, 112,
107, 112, 80,107, 80, 79,107, 79, 77,107, 77, 108,
113, 114, 109,113, 109, 108,113, 108, 77,113, 77, 76,
113, 76, 75,113, 75, 115,113, 115, 116,113, 116, 114,
117, 118, 119,117, 119, 120,117, 120, 121,117, 121, 122,
117, 122, 123,117, 123, 124,117, 124, 125,117, 125, 118,
126, 127, 119,126, 119, 118,126, 118, 125,126, 125, 128,
126, 128, 129,126, 129, 130,126, 130, 131,126, 131, 127,
132, 133, 134,132, 134, 135,132, 135, 136,132, 136, 137,
132, 137, 138,132, 138, 139,132, 139, 140,132, 140, 133,
141, 142, 134,141, 134, 133,141, 133, 140,141, 140, 143,
141, 143, 144,141, 144, 145,141, 145, 146,141, 146, 142,
147, 148, 149,147, 149, 150,147, 150, 8,147, 8, 7,
147, 7, 6,147, 6, 71,147, 71, 68,147, 68, 148,
151, 152, 149,151, 149, 148,151, 148, 68,151, 68, 67,
151, 67, 66,151, 66, 153,151, 153, 154,151, 154, 152,
155, 156, 157,155, 157, 158,155, 158, 159,155, 159, 160,
155, 160, 161,155, 161, 162,155, 162, 163,155, 163, 156,
164, 165, 157,164, 157, 156,164, 156, 163,164, 163, 166,
164, 166, 167,164, 167, 168,164, 168, 59,164, 59, 165,
169, 170, 157,169, 157, 165,169, 165, 59,169, 59, 58,
169, 58, 57,169, 57, 171,169, 171, 172,169, 172, 170,
173, 158, 157,173, 157, 170,173, 170, 172,173, 172, 174,
173, 174, 175,173, 175, 176,173, 176, 159,173, 159, 158,
177, 178, 179,177, 179, 180,177, 180, 181,177, 181, 182,
177, 182, 183,177, 183, 184,177, 184, 185,177, 185, 178,
186, 187, 179,186, 179, 178,186, 178, 185,186, 185, 188,
186, 188, 189,186, 189, 190,186, 190, 191,186, 191, 187,
192, 193, 179,192, 179, 187,192, 187, 191,192, 191, 194,
192, 194, 195,192, 195, 196,192, 196, 197,192, 197, 193,
198, 180, 179,198, 179, 193,198, 193, 197,198, 197, 199,
198, 199, 200,198, 200, 201,198, 201, 181,198, 181, 180,
202, 203, 204,202, 204, 205,202, 205, 206,202, 206, 207,
202, 207, 167,202, 167, 166,202, 166, 163,202, 163, 203,
208, 209, 204,208, 204, 203,208, 203, 163,208, 163, 162,
208, 162, 161,208, 161, 210,208, 210, 211,208, 211, 209,
212, 213, 214,212, 214, 215,212, 215, 216,212, 216, 217,
212, 217, 218,212, 218, 219,212, 219, 220,212, 220, 213,
221, 222, 214,221, 214, 213,221, 213, 220,221, 220, 223,
221, 223, 224,221, 224, 225,221, 225, 226,221, 226, 222,
227, 228, 229,227, 229, 230,227, 230, 231,227, 231, 232,
227, 232, 233,227, 233, 234,227, 234, 235,227, 235, 228,
236, 237, 229,236, 229, 228,236, 228, 235,236, 235, 238,
236, 238, 239,236, 239, 240,236, 240, 241,236, 241, 237,
242, 243, 244,242, 244, 245,242, 245, 246,242, 246, 247,
242, 247, 175,242, 175, 174,242, 174, 172,242, 172, 243,
248, 249, 244,248, 244, 243,248, 243, 172,248, 172, 171,
248, 171, 57,248, 57, 56,248, 56, 55,248, 55, 249,
250, 251, 252,250, 252, 253,250, 253, 254,250, 254, 255,
250, 255, 256,250, 256, 257,250, 257, 258,250, 258, 251,
259, 260, 252,259, 252, 251,259, 251, 258,259, 258, 261,
259, 261, 262,259, 262, 263,259, 263, 264,259, 264, 260,
265, 266, 252,265, 252, 260,265, 260, 264,265, 264, 267,
265, 267, 268,265, 268, 269,265, 269, 270,265, 270, 266,
271, 253, 252,271, 252, 266,271, 266, 270,271, 270, 272,
271, 272, 273,271, 273, 274,271, 274, 254,271, 254, 253,
275, 276, 277,275, 277, 278,275, 278, 279,275, 279, 280,
275, 280, 281,275, 281, 282,275, 282, 283,275, 283, 276,
284, 285, 286,284, 286, 287,284, 287, 288,284, 288, 289,
284, 289, 290,284, 290, 291,284, 291, 292,284, 292, 285,
293, 294, 277,293, 277, 295,293, 295, 296,293, 296, 297,
293, 297, 298,293, 298, 299,293, 299, 300,293, 300, 294,
301, 278, 277,301, 277, 294,301, 294, 300,301, 300, 302,
301, 302, 303,301, 303, 304,301, 304, 279,301, 279, 278,
305, 306, 307,305, 307, 308,305, 308, 309,305, 309, 310,
305, 310, 311,305, 311, 312,305, 312, 313,305, 313, 306,
314, 315, 316,314, 316, 317,314, 317, 318,314, 318, 319,
314, 319, 105,314, 105, 104,314, 104, 102,314, 102, 315,
320, 321, 316,320, 316, 315,320, 315, 102,320, 102, 101,
320, 101, 100,320, 100, 322,320, 322, 323,320, 323, 321,
324, 308, 307,324, 307, 325,324, 325, 326,324, 326, 327,
324, 327, 328,324, 328, 329,324, 329, 309,324, 309, 308,
330, 331, 332,330, 332, 333,330, 333, 334,330, 334, 335,
330, 335, 336,330, 336, 337,330, 337, 338,330, 338, 331,
339, 340, 332,339, 332, 331,339, 331, 338,339, 338, 341,
339, 341, 342,339, 342, 343,339, 343, 344,339, 344, 340,
345, 346, 332,345, 332, 340,345, 340, 344,345, 344, 347,
345, 347, 348,345, 348, 349,345, 349, 350,345, 350, 346,
351, 333, 332,351, 332, 346,351, 346, 350,351, 350, 352,
351, 352, 353,351, 353, 354,351, 354, 334,351, 334, 333,
355, 356, 357,355, 357, 358,355, 358, 359,355, 359, 360,
355, 360, 361,355, 361, 362,355, 362, 363,355, 363, 356,
364, 365, 357,364, 357, 356,364, 356, 363,364, 363, 366,
364, 366, 367,364, 367, 368,364, 368, 369,364, 369, 365,
370, 371, 357,370, 357, 365,370, 365, 369,370, 369, 372,
370, 372, 373,370, 373, 374,370, 374, 375,370, 375, 371,
376, 358, 357,376, 357, 371,376, 371, 375,376, 375, 377,
376, 377, 378,376, 378, 379,376, 379, 359,376, 359, 358,
380, 381, 382,380, 382, 383,380, 383, 384,380, 384, 385,
380, 385, 386,380, 386, 387,380, 387, 388,380, 388, 381,
389, 390, 382,389, 382, 381,389, 381, 388,389, 388, 391,
389, 391, 392,389, 392, 393,389, 393, 394,389, 394, 390,
395, 396, 382,395, 382, 390,395, 390, 394,395, 394, 397,
395, 397, 290,395, 290, 289,395, 289, 288,395, 288, 396,
398, 383, 382,398, 382, 396,398, 396, 288,398, 288, 399,
398, 399, 400,398, 400, 401,398, 401, 384,398, 384, 383,
402, 403, 404,402, 404, 405,402, 405, 406,402, 406, 407,
402, 407, 408,402, 408, 409,402, 409, 410,402, 410, 403,
411, 412, 404,411, 404, 403,411, 403, 410,411, 410, 413,
411, 413, 256,411, 256, 255,411, 255, 254,411, 254, 412,
414, 415, 404,414, 404, 412,414, 412, 254,414, 254, 274,
414, 274, 273,414, 273, 416,414, 416, 417,414, 417, 415,
418, 405, 404,418, 404, 415,418, 415, 417,418, 417, 419,
418, 419, 420,418, 420, 421,418, 421, 406,418, 406, 405,
422, 423, 424,422, 424, 425,422, 425, 296,422, 296, 426,
422, 426, 427,422, 427, 428,422, 428, 429,422, 429, 423,
430, 431, 424,430, 424, 423,430, 423, 429,430, 429, 432,
430, 432, 433,430, 433, 434,430, 434, 435,430, 435, 431,
436, 437, 424,436, 424, 431,436, 431, 435,436, 435, 438,
436, 438, 439,436, 439, 440,436, 440, 441,436, 441, 437,
442, 425, 424,442, 424, 437,442, 437, 441,442, 441, 443,
442, 443, 298,442, 298, 297,442, 297, 296,442, 296, 425,
444, 445, 446,444, 446, 447,444, 447, 448,444, 448, 449,
444, 449, 450,444, 450, 451,444, 451, 452,444, 452, 445,
453, 454, 446,453, 446, 445,453, 445, 452,453, 452, 455,
453, 455, 311,453, 311, 310,453, 310, 309,453, 309, 454,
456, 457, 446,456, 446, 454,456, 454, 309,456, 309, 329,
456, 329, 328,456, 328, 458,456, 458, 459,456, 459, 457,
460, 447, 446,460, 446, 457,460, 457, 459,460, 459, 461,
460, 461, 462,460, 462, 463,460, 463, 448,460, 448, 447,
464, 465, 466,464, 466, 467,464, 467, 344,464, 344, 343,
464, 343, 342,464, 342, 468,464, 468, 469,464, 469, 465,
470, 471, 466,470, 466, 465,470, 465, 469,470, 469, 472,
470, 472, 473,470, 473, 474,470, 474, 475,470, 475, 471,
476, 477, 466,476, 466, 471,476, 471, 475,476, 475, 478,
476, 478, 479,476, 479, 480,476, 480, 481,476, 481, 477,
482, 467, 466,482, 466, 477,482, 477, 481,482, 481, 483,
482, 483, 348,482, 348, 347,482, 347, 344,482, 344, 467,
484, 485, 486,484, 486, 487,484, 487, 488,484, 488, 489,
484, 489, 490,484, 490, 491,484, 491, 492,484, 492, 485,
493, 494, 486,493, 486, 485,493, 485, 492,493, 492, 495,
493, 495, 361,493, 361, 360,493, 360, 359,493, 359, 494,
496, 497, 486,496, 486, 494,496, 494, 359,496, 359, 379,
496, 379, 378,496, 378, 498,496, 498, 499,496, 499, 497,
500, 487, 486,500, 486, 497,500, 497, 499,500, 499, 501,
500, 501, 502,500, 502, 503,500, 503, 488,500, 488, 487,
504, 505, 506,504, 506, 507,504, 507, 394,504, 394, 393,
504, 393, 392,504, 392, 508,504, 508, 509,504, 509, 505,
510, 511, 506,510, 506, 505,510, 505, 509,510, 509, 512,
510, 512, 513,510, 513, 514,510, 514, 515,510, 515, 511,
516, 517, 506,516, 506, 511,516, 511, 515,516, 515, 518,
516, 518, 519,516, 519, 520,516, 520, 521,516, 521, 517,
522, 507, 506,522, 506, 517,522, 517, 521,522, 521, 523,
522, 523, 290,522, 290, 397,522, 397, 394,522, 394, 507,
524, 525, 526,524, 526, 527,524, 527, 159,524, 159, 176,
524, 176, 175,524, 175, 528,524, 528, 529,524, 529, 525,
530, 531, 526,530, 526, 525,530, 525, 529,530, 529, 532,
530, 532, 533,530, 533, 534,530, 534, 535,530, 535, 531,
536, 537, 526,536, 526, 531,536, 531, 535,536, 535, 538,
536, 538, 539,536, 539, 540,536, 540, 541,536, 541, 537,
542, 527, 526,542, 526, 537,542, 537, 541,542, 541, 543,
542, 543, 161,542, 161, 160,542, 160, 159,542, 159, 527,
544, 545, 546,544, 546, 547,544, 547, 535,544, 535, 534,
544, 534, 533,544, 533, 548,544, 548, 549,544, 549, 545,
550, 551, 546,550, 546, 545,550, 545, 549,550, 549, 552,
550, 552, 66,550, 66, 65,550, 65, 64,550, 64, 551,
553, 554, 546,553, 546, 551,553, 551, 64,553, 64, 81,
553, 81, 80,553, 80, 555,553, 555, 556,553, 556, 554,
557, 547, 546,557, 546, 554,557, 554, 556,557, 556, 558,
557, 558, 539,557, 539, 538,557, 538, 535,557, 535, 547,
559, 560, 561,559, 561, 562,559, 562, 96,559, 96, 95,
559, 95, 94,559, 94, 563,559, 563, 564,559, 564, 560,
565, 566, 561,565, 561, 560,565, 560, 564,565, 564, 567,
565, 567, 568,565, 568, 569,565, 569, 570,565, 570, 566,
571, 572, 561,571, 561, 566,571, 566, 570,571, 570, 573,
571, 573, 574,571, 574, 575,571, 575, 576,571, 576, 572,
577, 562, 561,577, 561, 572,577, 572, 576,577, 576, 578,
577, 578, 100,577, 100, 99,577, 99, 96,577, 96, 562,
579, 580, 581,579, 581, 582,579, 582, 570,579, 570, 569,
579, 569, 568,579, 568, 583,579, 583, 584,579, 584, 580,
585, 586, 581,585, 581, 580,585, 580, 584,585, 584, 587,
585, 587, 183,585, 183, 182,585, 182, 181,585, 181, 586,
588, 589, 581,588, 581, 586,588, 586, 181,588, 181, 201,
588, 201, 200,588, 200, 590,588, 590, 591,588, 591, 589,
592, 582, 581,592, 581, 589,592, 589, 591,592, 591, 593,
592, 593, 574,592, 574, 573,592, 573, 570,592, 570, 582,
594, 595, 596,594, 596, 597,594, 597, 211,594, 211, 210,
594, 210, 161,594, 161, 543,594, 543, 541,594, 541, 595,
598, 599, 600,598, 600, 601,598, 601, 602,598, 602, 603,
598, 603, 604,598, 604, 605,598, 605, 606,598, 606, 599,
607, 608, 600,607, 600, 599,607, 599, 606,607, 606, 609,
607, 609, 610,607, 610, 611,607, 611, 612,607, 612, 608,
613, 614, 600,613, 600, 608,613, 608, 612,613, 612, 615,
613, 615, 218,613, 218, 217,613, 217, 216,613, 216, 614,
616, 617, 618,616, 618, 619,616, 619, 606,616, 606, 605,
616, 605, 604,616, 604, 620,616, 620, 621,616, 621, 617,
622, 623, 618,622, 618, 617,622, 617, 621,622, 621, 624,
622, 624, 625,622, 625, 626,622, 626, 131,622, 131, 623,
627, 628, 618,627, 618, 623,627, 623, 131,627, 131, 130,
627, 130, 129,627, 129, 629,627, 629, 630,627, 630, 628,
631, 619, 618,631, 618, 628,631, 628, 630,631, 630, 632,
631, 632, 610,631, 610, 609,631, 609, 606,631, 606, 619,
633, 634, 635,633, 635, 636,633, 636, 241,633, 241, 240,
633, 240, 239,633, 239, 637,633, 637, 638,633, 638, 634,
639, 640, 641,639, 641, 642,639, 642, 643,639, 643, 644,
639, 644, 645,639, 645, 646,639, 646, 647,639, 647, 640,
648, 649, 641,648, 641, 640,648, 640, 647,648, 647, 650,
648, 650, 533,648, 533, 532,648, 532, 529,648, 529, 649,
651, 652, 641,651, 641, 649,651, 649, 529,651, 529, 528,
651, 528, 175,651, 175, 247,651, 247, 246,651, 246, 652,
653, 654, 655,653, 655, 656,653, 656, 647,653, 647, 646,
653, 646, 645,653, 645, 657,653, 657, 658,653, 658, 654,
659, 660, 655,659, 655, 654,659, 654, 658,659, 658, 661,
659, 661, 662,659, 662, 663,659, 663, 154,659, 154, 660,
664, 665, 655,664, 655, 660,664, 660, 154,664, 154, 153,
664, 153, 66,664, 66, 552,664, 552, 549,664, 549, 665,
666, 656, 655,666, 655, 665,666, 665, 549,666, 549, 548,
666, 548, 533,666, 533, 650,666, 650, 647,666, 647, 656,
667, 668, 669,667, 669, 670,667, 670, 323,667, 323, 322,
667, 322, 100,667, 100, 578,667, 578, 576,667, 576, 668,
671, 672, 669,671, 669, 668,671, 668, 576,671, 576, 575,
671, 575, 574,671, 574, 673,671, 673, 674,671, 674, 672,
675, 676, 677,675, 677, 678,675, 678, 679,675, 679, 680,
675, 680, 681,675, 681, 682,675, 682, 683,675, 683, 676,
684, 685, 677,684, 677, 676,684, 676, 683,684, 683, 686,
684, 686, 328,684, 328, 327,684, 327, 326,684, 326, 685,
687, 688, 689,687, 689, 690,687, 690, 674,687, 674, 673,
687, 673, 574,687, 574, 593,687, 593, 591,687, 591, 688,
691, 692, 689,691, 689, 688,691, 688, 591,691, 591, 590,
691, 590, 200,691, 200, 693,691, 693, 694,691, 694, 692,
695, 696, 697,695, 697, 698,695, 698, 363,695, 363, 362,
695, 362, 361,695, 361, 699,695, 699, 700,695, 700, 696,
701, 702, 697,701, 697, 696,701, 696, 700,701, 700, 703,
701, 703, 681,701, 681, 680,701, 680, 679,701, 679, 702,
704, 705, 706,704, 706, 707,704, 707, 350,704, 350, 349,
704, 349, 348,704, 348, 708,704, 708, 709,704, 709, 705,
710, 711, 706,710, 706, 705,710, 705, 709,710, 709, 712,
710, 712, 713,710, 713, 714,710, 714, 715,710, 715, 711,
716, 717, 706,716, 706, 711,716, 711, 715,716, 715, 718,
716, 718, 719,716, 719, 720,716, 720, 721,716, 721, 717,
722, 707, 706,722, 706, 717,722, 717, 721,722, 721, 723,
722, 723, 353,722, 353, 352,722, 352, 350,722, 350, 707,
724, 725, 726,724, 726, 727,724, 727, 715,724, 715, 714,
724, 714, 713,724, 713, 728,724, 728, 729,724, 729, 725,
730, 731, 726,730, 726, 725,730, 725, 729,730, 729, 732,
730, 732, 392,730, 392, 391,730, 391, 388,730, 388, 731,
733, 734, 726,733, 726, 731,733, 731, 388,733, 388, 387,
733, 387, 386,733, 386, 735,733, 735, 736,733, 736, 734,
737, 727, 726,737, 726, 734,737, 734, 736,737, 736, 738,
737, 738, 719,737, 719, 718,737, 718, 715,737, 715, 727,
739, 740, 741,739, 741, 742,739, 742, 459,739, 459, 458,
739, 458, 328,739, 328, 686,739, 686, 683,739, 683, 740,
743, 744, 741,743, 741, 740,743, 740, 683,743, 683, 682,
743, 682, 681,743, 681, 745,743, 745, 746,743, 746, 744,
747, 748, 741,747, 741, 744,747, 744, 746,747, 746, 749,
747, 749, 750,747, 750, 751,747, 751, 752,747, 752, 748,
753, 742, 741,753, 741, 748,753, 748, 752,753, 752, 754,
753, 754, 462,753, 462, 461,753, 461, 459,753, 459, 742,
755, 756, 757,755, 757, 758,755, 758, 746,755, 746, 745,
755, 745, 681,755, 681, 703,755, 703, 700,755, 700, 756,
759, 760, 757,759, 757, 756,759, 756, 700,759, 700, 699,
759, 699, 361,759, 361, 495,759, 495, 492,759, 492, 760,
761, 762, 757,761, 757, 760,761, 760, 492,761, 492, 491,
761, 491, 490,761, 490, 763,761, 763, 764,761, 764, 762,
765, 758, 757,765, 757, 762,765, 762, 764,765, 764, 766,
765, 766, 750,765, 750, 749,765, 749, 746,765, 746, 758,
767, 768, 769,767, 769, 770,767, 770, 481,767, 481, 480,
767, 480, 479,767, 479, 771,767, 771, 772,767, 772, 768,
773, 774, 769,773, 769, 768,773, 768, 772,773, 772, 775,
773, 775, 776,773, 776, 777,773, 777, 778,773, 778, 774,
779, 780, 769,779, 769, 774,779, 774, 778,779, 778, 781,
779, 781, 713,779, 713, 712,779, 712, 709,779, 709, 780,
782, 770, 769,782, 769, 780,782, 780, 709,782, 709, 708,
782, 708, 348,782, 348, 483,782, 483, 481,782, 481, 770,
783, 784, 785,783, 785, 786,783, 786, 778,783, 778, 777,
783, 777, 776,783, 776, 787,783, 787, 788,783, 788, 784,
789, 790, 785,789, 785, 784,789, 784, 788,789, 788, 791,
789, 791, 513,789, 513, 512,789, 512, 509,789, 509, 790,
792, 793, 785,792, 785, 790,792, 790, 509,792, 509, 508,
792, 508, 392,792, 392, 732,792, 732, 729,792, 729, 793,
794, 786, 785,794, 785, 793,794, 793, 729,794, 729, 728,
794, 728, 713,794, 713, 781,794, 781, 778,794, 778, 786,
795, 796, 797,795, 797, 798,795, 798, 17,795, 17, 16,
795, 16, 15,795, 15, 799,795, 799, 800,795, 800, 796,
801, 802, 797,801, 797, 796,801, 796, 800,801, 800, 803,
801, 803, 804,801, 804, 805,801, 805, 806,801, 806, 802,
807, 808, 797,807, 797, 802,807, 802, 806,807, 806, 809,
807, 809, 810,807, 810, 811,807, 811, 812,807, 812, 808,
813, 798, 797,813, 797, 808,813, 808, 812,813, 812, 814,
813, 814, 21,813, 21, 20,813, 20, 17,813, 17, 798,
815, 816, 817,815, 817, 818,815, 818, 806,815, 806, 805,
815, 805, 804,815, 804, 819,815, 819, 820,815, 820, 816,
821, 822, 817,821, 817, 816,821, 816, 820,821, 820, 823,
821, 823, 408,821, 408, 407,821, 407, 406,821, 406, 822,
824, 825, 817,824, 817, 822,824, 822, 406,824, 406, 421,
824, 421, 420,824, 420, 826,824, 826, 827,824, 827, 825,
828, 818, 817,828, 817, 825,828, 825, 827,828, 827, 829,
828, 829, 810,828, 810, 809,828, 809, 806,828, 806, 818,
830, 831, 832,830, 832, 833,830, 833, 435,830, 435, 434,
830, 434, 433,830, 433, 834,830, 834, 835,830, 835, 831,
836, 837, 832,836, 832, 831,836, 831, 835,836, 835, 838,
836, 838, 839,836, 839, 840,836, 840, 841,836, 841, 837,
842, 843, 832,842, 832, 837,842, 837, 841,842, 841, 844,
842, 844, 845,842, 845, 846,842, 846, 847,842, 847, 843,
848, 833, 832,848, 832, 843,848, 843, 847,848, 847, 849,
848, 849, 439,848, 439, 438,848, 438, 435,848, 435, 833,
850, 851, 852,850, 852, 853,850, 853, 841,850, 841, 840,
850, 840, 839,850, 839, 854,850, 854, 855,850, 855, 851,
856, 857, 852,856, 852, 851,856, 851, 855,856, 855, 858,
856, 858, 48,856, 48, 47,856, 47, 44,856, 44, 857,
859, 860, 852,859, 852, 857,859, 857, 44,859, 44, 43,
859, 43, 42,859, 42, 861,859, 861, 862,859, 862, 860,
863, 853, 852,863, 852, 860,863, 860, 862,863, 862, 864,
863, 864, 845,863, 845, 844,863, 844, 841,863, 841, 853,
865, 866, 867,865, 867, 868,865, 868, 125,865, 125, 124,
865, 124, 123,865, 123, 869,865, 869, 870,865, 870, 866,
871, 872, 867,871, 867, 866,871, 866, 870,871, 870, 873,
871, 873, 874,871, 874, 875,871, 875, 876,871, 876, 872,
877, 878, 867,877, 867, 872,877, 872, 876,877, 876, 879,
877, 879, 880,877, 880, 881,877, 881, 882,877, 882, 878,
883, 868, 867,883, 867, 878,883, 878, 882,883, 882, 884,
883, 884, 129,883, 129, 128,883, 128, 125,883, 125, 868,
885, 886, 887,885, 887, 888,885, 888, 876,885, 876, 875,
885, 875, 874,885, 874, 889,885, 889, 890,885, 890, 886,
891, 892, 887,891, 887, 886,891, 886, 890,891, 890, 893,
891, 893, 450,891, 450, 449,891, 449, 448,891, 448, 892,
894, 895, 887,894, 887, 892,894, 892, 448,894, 448, 463,
894, 463, 462,894, 462, 896,894, 896, 897,894, 897, 895,
898, 888, 887,898, 887, 895,898, 895, 897,898, 897, 899,
898, 899, 880,898, 880, 879,898, 879, 876,898, 876, 888,
900, 901, 902,900, 902, 903,900, 903, 475,900, 475, 474,
900, 474, 473,900, 473, 904,900, 904, 905,900, 905, 901,
906, 907, 902,906, 902, 901,906, 901, 905,906, 905, 908,
906, 908, 909,906, 909, 910,906, 910, 911,906, 911, 907,
912, 913, 902,912, 902, 907,912, 907, 911,912, 911, 914,
912, 914, 915,912, 915, 916,912, 916, 917,912, 917, 913,
918, 903, 902,918, 902, 913,918, 913, 917,918, 917, 919,
918, 919, 479,918, 479, 478,918, 478, 475,918, 475, 903,
920, 921, 922,920, 922, 923,920, 923, 911,920, 911, 910,
920, 910, 909,920, 909, 924,920, 924, 925,920, 925, 921,
926, 927, 922,926, 922, 921,926, 921, 925,926, 925, 928,
926, 928, 144,926, 144, 143,926, 143, 140,926, 140, 927,
929, 930, 922,929, 922, 927,929, 927, 140,929, 140, 139,
929, 139, 138,929, 138, 931,929, 931, 932,929, 932, 930,
933, 923, 922,933, 922, 930,933, 930, 932,933, 932, 934,
933, 934, 915,933, 915, 914,933, 914, 911,933, 911, 923,
935, 936, 937,935, 937, 938,935, 938, 220,935, 220, 219,
935, 219, 218,935, 218, 939,935, 939, 940,935, 940, 936,
941, 942, 937,941, 937, 936,941, 936, 940,941, 940, 943,
941, 943, 944,941, 944, 945,941, 945, 946,941, 946, 942,
947, 948, 937,947, 937, 942,947, 942, 946,947, 946, 949,
947, 949, 950,947, 950, 951,947, 951, 952,947, 952, 948,
953, 938, 937,953, 937, 948,953, 948, 952,953, 952, 954,
953, 954, 224,953, 224, 223,953, 223, 220,953, 220, 938,
955, 956, 957,955, 957, 958,955, 958, 946,955, 946, 945,
955, 945, 944,955, 944, 959,955, 959, 960,955, 960, 956,
961, 962, 957,961, 957, 956,961, 956, 960,961, 960, 963,
961, 963, 490,961, 490, 489,961, 489, 488,961, 488, 962,
964, 965, 957,964, 957, 962,964, 962, 488,964, 488, 503,
964, 503, 502,964, 502, 966,964, 966, 967,964, 967, 965,
968, 958, 957,968, 957, 965,968, 965, 967,968, 967, 969,
968, 969, 950,968, 950, 949,968, 949, 946,968, 946, 958,
970, 971, 972,970, 972, 973,970, 973, 515,970, 515, 514,
970, 514, 513,970, 513, 974,970, 974, 975,970, 975, 971,
976, 977, 972,976, 972, 971,976, 971, 975,976, 975, 978,
976, 978, 979,976, 979, 980,976, 980, 981,976, 981, 977,
982, 983, 972,982, 972, 977,982, 977, 981,982, 981, 984,
982, 984, 985,982, 985, 986,982, 986, 987,982, 987, 983,
988, 973, 972,988, 972, 983,988, 983, 987,988, 987, 989,
988, 989, 519,988, 519, 518,988, 518, 515,988, 515, 973,
990, 991, 992,990, 992, 993,990, 993, 981,990, 981, 980,
990, 980, 979,990, 979, 994,990, 994, 995,990, 995, 991,
996, 997, 992,996, 992, 991,996, 991, 995,996, 995, 998,
996, 998, 239,996, 239, 238,996, 238, 235,996, 235, 997,
999, 1000, 992,999, 992, 997,999, 997, 235,999, 235, 234,
999, 234, 233,999, 233, 1001,999, 1001, 1002,999, 1002, 1000,
1003, 993, 992,1003, 992, 1000,1003, 1000, 1002,1003, 1002, 1004,
1003, 1004, 985,1003, 985, 984,1003, 984, 981,1003, 981, 993,
1005, 1006, 1007,1005, 1007, 1008,1005, 1008, 752,1005, 752, 751,
1005, 751, 750,1005, 750, 1009,1005, 1009, 1010,1005, 1010, 1006,
1011, 1012, 1007,1011, 1007, 1006,1011, 1006, 1010,1011, 1010, 1013,
1011, 1013, 1014,1011, 1014, 1015,1011, 1015, 1016,1011, 1016, 1012,
1017, 1018, 1007,1017, 1007, 1012,1017, 1012, 1016,1017, 1016, 1019,
1017, 1019, 880,1017, 880, 899,1017, 899, 897,1017, 897, 1018,
1020, 1008, 1007,1020, 1007, 1018,1020, 1018, 897,1020, 897, 896,
1020, 896, 462,1020, 462, 754,1020, 754, 752,1020, 752, 1008,
1021, 1022, 1023,1021, 1023, 1024,1021, 1024, 1016,1021, 1016, 1015,
1021, 1015, 1014,1021, 1014, 1025,1021, 1025, 1026,1021, 1026, 1022,
1027, 1028, 1023,1027, 1023, 1022,1027, 1022, 1026,1027, 1026, 1029,
1027, 1029, 610,1027, 610, 632,1027, 632, 630,1027, 630, 1028,
1030, 1031, 1023,1030, 1023, 1028,1030, 1028, 630,1030, 630, 629,
1030, 629, 129,1030, 129, 884,1030, 884, 882,1030, 882, 1031,
1032, 1024, 1023,1032, 1023, 1031,1032, 1031, 882,1032, 882, 881,
1032, 881, 880,1032, 880, 1019,1032, 1019, 1016,1032, 1016, 1024,
1033, 1034, 1035,1033, 1035, 1036,1033, 1036, 764,1033, 764, 763,
1033, 763, 490,1033, 490, 963,1033, 963, 960,1033, 960, 1034,
1037, 1038, 1035,1037, 1035, 1034,1037, 1034, 960,1037, 960, 959,
1037, 959, 944,1037, 944, 1039,1037, 1039, 1040,1037, 1040, 1038,
1041, 1042, 1035,1041, 1035, 1038,1041, 1038, 1040,1041, 1040, 1043,
1041, 1043, 1014,1041, 1014, 1013,1041, 1013, 1010,1041, 1010, 1042,
1044, 1036, 1035,1044, 1035, 1042,1044, 1042, 1010,1044, 1010, 1009,
1044, 1009, 750,1044, 750, 766,1044, 766, 764,1044, 764, 1036,
1045, 1046, 1047,1045, 1047, 1048,1045, 1048, 1040,1045, 1040, 1039,
1045, 1039, 944,1045, 944, 943,1045, 943, 940,1045, 940, 1046,
1049, 1050, 1047,1049, 1047, 1046,1049, 1046, 940,1049, 940, 939,
1049, 939, 218,1049, 218, 615,1049, 615, 612,1049, 612, 1050,
1051, 1052, 1047,1051, 1047, 1050,1051, 1050, 612,1051, 612, 611,
1051, 611, 610,1051, 610, 1029,1051, 1029, 1026,1051, 1026, 1052,
1053, 1048, 1047,1053, 1047, 1052,1053, 1052, 1026,1053, 1026, 1025,
1053, 1025, 1014,1053, 1014, 1043,1053, 1043, 1040,1053, 1040, 1048,
1054, 1055, 1056,1054, 1056, 1057,1054, 1057, 1058,1054, 1058, 1059,
1054, 1059, 1060,1054, 1060, 1061,1054, 1061, 1062,1054, 1062, 1055,
1063, 1064, 1056,1063, 1056, 1055,1063, 1055, 1062,1063, 1062, 1065,
1063, 1065, 1066,1063, 1066, 1067,1063, 1067, 1068,1063, 1068, 1064,
1069, 1070, 1056,1069, 1056, 1064,1069, 1064, 1068,1069, 1068, 1071,
1069, 1071, 915,1069, 915, 934,1069, 934, 932,1069, 932, 1070,
1072, 1057, 1056,1072, 1056, 1070,1072, 1070, 932,1072, 932, 931,
1072, 931, 138,1072, 138, 1073,1072, 1073, 1058,1072, 1058, 1057,
1074, 1075, 1076,1074, 1076, 1077,1074, 1077, 1068,1074, 1068, 1067,
1074, 1067, 1066,1074, 1066, 1078,1074, 1078, 1079,1074, 1079, 1075,
1080, 1081, 1076,1080, 1076, 1075,1080, 1075, 1079,1080, 1079, 1082,
1080, 1082, 776,1080, 776, 775,1080, 775, 772,1080, 772, 1081,
1083, 1084, 1076,1083, 1076, 1081,1083, 1081, 772,1083, 772, 771,
1083, 771, 479,1083, 479, 919,1083, 919, 917,1083, 917, 1084,
1085, 1077, 1076,1085, 1076, 1084,1085, 1084, 917,1085, 917, 916,
1085, 916, 915,1085, 915, 1071,1085, 1071, 1068,1085, 1068, 1077,
1086, 1087, 1088,1086, 1088, 1089,1086, 1089, 638,1086, 638, 637,
1086, 637, 239,1086, 239, 998,1086, 998, 995,1086, 995, 1087,
1090, 1091, 1088,1090, 1088, 1087,1090, 1087, 995,1090, 995, 994,
1090, 994, 979,1090, 979, 1092,1090, 1092, 1093,1090, 1093, 1091,
1094, 1095, 1088,1094, 1088, 1091,1094, 1091, 1093,1094, 1093, 1096,
1094, 1096, 1066,1094, 1066, 1065,1094, 1065, 1062,1094, 1062, 1095,
1097, 1089, 1088,1097, 1088, 1095,1097, 1095, 1062,1097, 1062, 1061,
1097, 1061, 1060,1097, 1060, 1098,1097, 1098, 638,1097, 638, 1089,
1099, 1100, 1101,1099, 1101, 1102,1099, 1102, 1093,1099, 1093, 1092,
1099, 1092, 979,1099, 979, 978,1099, 978, 975,1099, 975, 1100,
1103, 1104, 1101,1103, 1101, 1100,1103, 1100, 975,1103, 975, 974,
1103, 974, 513,1103, 513, 791,1103, 791, 788,1103, 788, 1104,
1105, 1106, 1101,1105, 1101, 1104,1105, 1104, 788,1105, 788, 787,
1105, 787, 776,1105, 776, 1082,1105, 1082, 1079,1105, 1079, 1106,
1107, 1102, 1101,1107, 1101, 1106,1107, 1106, 1079,1107, 1079, 1078,
1107, 1078, 1066,1107, 1066, 1096,1107, 1096, 1093,1107, 1093, 1102,
1108, 1109, 1110,1108, 1110, 1111,1108, 1111, 1112,1108, 1112, 1113,
1108, 1113, 1114,1108, 1114, 1115,1108, 1115, 1116,1108, 1116, 1109,
1117, 1118, 1119,1117, 1119, 1120,1117, 1120, 1121,1117, 1121, 1122,
1117, 1122, 1123,1117, 1123, 1124,1117, 1124, 1125,1117, 1125, 1118,
1126, 1127, 1119,1126, 1119, 1118,1126, 1118, 1125,1126, 1125, 1128,
1126, 1128, 1129,1126, 1129, 1130,1126, 1130, 1131,1126, 1131, 1127,
1132, 1133, 1119,1132, 1119, 1127,1132, 1127, 1131,1132, 1131, 1134,
1132, 1134, 1135,1132, 1135, 1136,1132, 1136, 1137,1132, 1137, 1133,
1138, 1139, 1140,1138, 1140, 1141,1138, 1141, 1142,1138, 1142, 1143,
1138, 1143, 1144,1138, 1144, 1145,1138, 1145, 1146,1138, 1146, 1139,
1147, 1148, 1140,1147, 1140, 1139,1147, 1139, 1146,1147, 1146, 1149,
1147, 1149, 1150,1147, 1150, 1151,1147, 1151, 1152,1147, 1152, 1148,
1153, 1154, 1140,1153, 1140, 1148,1153, 1148, 1152,1153, 1152, 1155,
1153, 1155, 1156,1153, 1156, 1157,1153, 1157, 1158,1153, 1158, 1154,
1159, 1160, 1161,1159, 1161, 1162,1159, 1162, 1163,1159, 1163, 1164,
1159, 1164, 1165,1159, 1165, 1166,1159, 1166, 1167,1159, 1167, 1160,
1168, 1169, 1170,1168, 1170, 1171,1168, 1171, 1172,1168, 1172, 1173,
1168, 1173, 1174,1168, 1174, 1175,1168, 1175, 1176,1168, 1176, 1169,
1177, 1178, 1170,1177, 1170, 1169,1177, 1169, 1176,1177, 1176, 1179,
1177, 1179, 1114,1177, 1114, 1113,1177, 1113, 1112,1177, 1112, 1178,
1180, 1181, 1170,1180, 1170, 1178,1180, 1178, 1112,1180, 1112, 1182,
1180, 1182, 1183,1180, 1183, 1184,1180, 1184, 1185,1180, 1185, 1181,
1186, 1171, 1170,1186, 1170, 1181,1186, 1181, 1185,1186, 1185, 1187,
1186, 1187, 1188,1186, 1188, 1189,1186, 1189, 1172,1186, 1172, 1171,
1190, 1191, 1192,1190, 1192, 1193,1190, 1193, 1194,1190, 1194, 1195,
1190, 1195, 1196,1190, 1196, 1197,1190, 1197, 1198,1190, 1198, 1191,
1199, 1200, 1192,1199, 1192, 1191,1199, 1191, 1198,1199, 1198, 1201,
1199, 1201, 1202,1199, 1202, 1203,1199, 1203, 1204,1199, 1204, 1200,
1205, 1206, 1192,1205, 1192, 1200,1205, 1200, 1204,1205, 1204, 1207,
1205, 1207, 1208,1205, 1208, 1209,1205, 1209, 1210,1205, 1210, 1206,
1211, 1193, 1192,1211, 1192, 1206,1211, 1206, 1210,1211, 1210, 1212,
1211, 1212, 1213,1211, 1213, 1214,1211, 1214, 1194,1211, 1194, 1193,
1215, 1216, 1217,1215, 1217, 1218,1215, 1218, 1219,1215, 1219, 1220,
1215, 1220, 1188,1215, 1188, 1187,1215, 1187, 1185,1215, 1185, 1216,
1221, 1222, 1217,1221, 1217, 1216,1221, 1216, 1185,1221, 1185, 1184,
1221, 1184, 1183,1221, 1183, 1223,1221, 1223, 1224,1221, 1224, 1222,
1225, 1226, 1227,1225, 1227, 1228,1225, 1228, 1229,1225, 1229, 1230,
1225, 1230, 1231,1225, 1231, 1232,1225, 1232, 1233,1225, 1233, 1226,
1234, 1235, 1227,1234, 1227, 1226,1234, 1226, 1233,1234, 1233, 1236,
1234, 1236, 1237,1234, 1237, 1238,1234, 1238, 1239,1234, 1239, 1235,
1240, 1241, 1242,1240, 1242, 1243,1240, 1243, 1244,1240, 1244, 1245,
1240, 1245, 1246,1240, 1246, 1247,1240, 1247, 1248,1240, 1248, 1241,
1249, 1250, 1242,1249, 1242, 1241,1249, 1241, 1248,1249, 1248, 1251,
1249, 1251, 1252,1249, 1252, 1253,1249, 1253, 1254,1249, 1254, 1250,
1255, 1256, 1257,1255, 1257, 1258,1255, 1258, 1116,1255, 1116, 1115,
1255, 1115, 1114,1255, 1114, 1179,1255, 1179, 1176,1255, 1176, 1256,
1259, 1260, 1257,1259, 1257, 1256,1259, 1256, 1176,1259, 1176, 1175,
1259, 1175, 1174,1259, 1174, 1261,1259, 1261, 1262,1259, 1262, 1260,
1263, 1264, 1265,1263, 1265, 1266,1263, 1266, 1267,1263, 1267, 1268,
1263, 1268, 1269,1263, 1269, 1270,1263, 1270, 1271,1263, 1271, 1264,
1272, 1273, 1265,1272, 1265, 1264,1272, 1264, 1271,1272, 1271, 1274,
1272, 1274, 1275,1272, 1275, 1276,1272, 1276, 1167,1272, 1167, 1273,
1277, 1278, 1265,1277, 1265, 1273,1277, 1273, 1167,1277, 1167, 1166,
1277, 1166, 1165,1277, 1165, 1279,1277, 1279, 1280,1277, 1280, 1278,
1281, 1266, 1265,1281, 1265, 1278,1281, 1278, 1280,1281, 1280, 1282,
1281, 1282, 1283,1281, 1283, 1284,1281, 1284, 1267,1281, 1267, 1266,
1285, 1286, 1287,1285, 1287, 1288,1285, 1288, 1289,1285, 1289, 1290,
1285, 1290, 1291,1285, 1291, 1292,1285, 1292, 1293,1285, 1293, 1286,
1294, 1295, 1287,1294, 1287, 1286,1294, 1286, 1293,1294, 1293, 1296,
1294, 1296, 1297,1294, 1297, 1298,1294, 1298, 1299,1294, 1299, 1295,
1300, 1301, 1287,1300, 1287, 1295,1300, 1295, 1299,1300, 1299, 1302,
1300, 1302, 1303,1300, 1303, 1304,1300, 1304, 1305,1300, 1305, 1301,
1306, 1288, 1287,1306, 1287, 1301,1306, 1301, 1305,1306, 1305, 1307,
1306, 1307, 1308,1306, 1308, 1309,1306, 1309, 1289,1306, 1289, 1288,
1310, 1311, 1312,1310, 1312, 1313,1310, 1313, 1314,1310, 1314, 1315,
1310, 1315, 1275,1310, 1275, 1274,1310, 1274, 1271,1310, 1271, 1311,
1316, 1317, 1312,1316, 1312, 1311,1316, 1311, 1271,1316, 1271, 1270,
1316, 1270, 1269,1316, 1269, 1318,1316, 1318, 1319,1316, 1319, 1317,
1320, 1321, 1322,1320, 1322, 1323,1320, 1323, 1324,1320, 1324, 1325,
1320, 1325, 1326,1320, 1326, 1327,1320, 1327, 1328,1320, 1328, 1321,
1329, 1330, 1322,1329, 1322, 1321,1329, 1321, 1328,1329, 1328, 1331,
1329, 1331, 1332,1329, 1332, 1333,1329, 1333, 1334,1329, 1334, 1330,
1335, 1336, 1337,1335, 1337, 1338,1335, 1338, 1339,1335, 1339, 1340,
1335, 1340, 1341,1335, 1341, 1342,1335, 1342, 1343,1335, 1343, 1336,
1344, 1345, 1337,1344, 1337, 1336,1344, 1336, 1343,1344, 1343, 1346,
1344, 1346, 1347,1344, 1347, 1348,1344, 1348, 1349,1344, 1349, 1345,
1350, 1351, 1352,1350, 1352, 1353,1350, 1353, 1354,1350, 1354, 1355,
1350, 1355, 1283,1350, 1283, 1282,1350, 1282, 1280,1350, 1280, 1351,
1356, 1357, 1352,1356, 1352, 1351,1356, 1351, 1280,1356, 1280, 1279,
1356, 1279, 1165,1356, 1165, 1164,1356, 1164, 1163,1356, 1163, 1357,
1358, 1359, 1360,1358, 1360, 1361,1358, 1361, 1362,1358, 1362, 1363,
1358, 1363, 1364,1358, 1364, 1365,1358, 1365, 1366,1358, 1366, 1359,
1367, 1368, 1360,1367, 1360, 1359,1367, 1359, 1366,1367, 1366, 1369,
1367, 1369, 1370,1367, 1370, 1371,1367, 1371, 1372,1367, 1372, 1368,
1373, 1374, 1360,1373, 1360, 1368,1373, 1368, 1372,1373, 1372, 1375,
1373, 1375, 1376,1373, 1376, 1377,1373, 1377, 1378,1373, 1378, 1374,
1379, 1361, 1360,1379, 1360, 1374,1379, 1374, 1378,1379, 1378, 1380,
1379, 1380, 1381,1379, 1381, 1382,1379, 1382, 1362,1379, 1362, 1361,
1383, 1384, 1385,1383, 1385, 1386,1383, 1386, 1387,1383, 1387, 1388,
1383, 1388, 1389,1383, 1389, 1390,1383, 1390, 1391,1383, 1391, 1384,
1392, 1393, 1394,1392, 1394, 1395,1392, 1395, 1396,1392, 1396, 1397,
1392, 1397, 1398,1392, 1398, 1399,1392, 1399, 1400,1392, 1400, 1393,
1401, 1402, 1385,1401, 1385, 1403,1401, 1403, 1404,1401, 1404, 1405,
1401, 1405, 1406,1401, 1406, 1407,1401, 1407, 1408,1401, 1408, 1402,
1409, 1386, 1385,1409, 1385, 1402,1409, 1402, 1408,1409, 1408, 1410,
1409, 1410, 1411,1409, 1411, 1412,1409, 1412, 1387,1409, 1387, 1386,
1413, 1414, 1415,1413, 1415, 1416,1413, 1416, 1417,1413, 1417, 1418,
1413, 1418, 1419,1413, 1419, 1420,1413, 1420, 1421,1413, 1421, 1414,
1422, 1423, 1424,1422, 1424, 1425,1422, 1425, 1426,1422, 1426, 1427,
1422, 1427, 1213,1422, 1213, 1212,1422, 1212, 1210,1422, 1210, 1423,
1428, 1429, 1424,1428, 1424, 1423,1428, 1423, 1210,1428, 1210, 1209,
1428, 1209, 1208,1428, 1208, 1430,1428, 1430, 1431,1428, 1431, 1429,
1432, 1416, 1415,1432, 1415, 1433,1432, 1433, 1434,1432, 1434, 1435,
1432, 1435, 1436,1432, 1436, 1437,1432, 1437, 1417,1432, 1417, 1416,
1438, 1439, 1440,1438, 1440, 1441,1438, 1441, 1442,1438, 1442, 1443,
1438, 1443, 1444,1438, 1444, 1445,1438, 1445, 1446,1438, 1446, 1439,
1447, 1448, 1440,1447, 1440, 1439,1447, 1439, 1446,1447, 1446, 1449,
1447, 1449, 1450,1447, 1450, 1451,1447, 1451, 1452,1447, 1452, 1448,
1453, 1454, 1440,1453, 1440, 1448,1453, 1448, 1452,1453, 1452, 1455,
1453, 1455, 1456,1453, 1456, 1457,1453, 1457, 1458,1453, 1458, 1454,
1459, 1441, 1440,1459, 1440, 1454,1459, 1454, 1458,1459, 1458, 1460,
1459, 1460, 1461,1459, 1461, 1462,1459, 1462, 1442,1459, 1442, 1441,
1463, 1464, 1465,1463, 1465, 1466,1463, 1466, 1467,1463, 1467, 1468,
1463, 1468, 1469,1463, 1469, 1470,1463, 1470, 1471,1463, 1471, 1464,
1472, 1473, 1465,1472, 1465, 1464,1472, 1464, 1471,1472, 1471, 1474,
1472, 1474, 1475,1472, 1475, 1476,1472, 1476, 1477,1472, 1477, 1473,
1478, 1479, 1465,1478, 1465, 1473,1478, 1473, 1477,1478, 1477, 1480,
1478, 1480, 1481,1478, 1481, 1482,1478, 1482, 1483,1478, 1483, 1479,
1484, 1466, 1465,1484, 1465, 1479,1484, 1479, 1483,1484, 1483, 1485,
1484, 1485, 1486,1484, 1486, 1487,1484, 1487, 1467,1484, 1467, 1466,
1488, 1489, 1490,1488, 1490, 1491,1488, 1491, 1492,1488, 1492, 1493,
1488, 1493, 1494,1488, 1494, 1495,1488, 1495, 1496,1488, 1496, 1489,
1497, 1498, 1490,1497, 1490, 1489,1497, 1489, 1496,1497, 1496, 1499,
1497, 1499, 1500,1497, 1500, 1501,1497, 1501, 1502,1497, 1502, 1498,
1503, 1504, 1490,1503, 1490, 1498,1503, 1498, 1502,1503, 1502, 1505,
1503, 1505, 1398,1503, 1398, 1397,1503, 1397, 1396,1503, 1396, 1504,
1506, 1491, 1490,1506, 1490, 1504,1506, 1504, 1396,1506, 1396, 1507,
1506, 1507, 1508,1506, 1508, 1509,1506, 1509, 1492,1506, 1492, 1491,
1510, 1511, 1512,1510, 1512, 1513,1510, 1513, 1514,1510, 1514, 1515,
1510, 1515, 1516,1510, 1516, 1517,1510, 1517, 1518,1510, 1518, 1511,
1519, 1520, 1512,1519, 1512, 1511,1519, 1511, 1518,1519, 1518, 1521,
1519, 1521, 1364,1519, 1364, 1363,1519, 1363, 1362,1519, 1362, 1520,
1522, 1523, 1512,1522, 1512, 1520,1522, 1520, 1362,1522, 1362, 1382,
1522, 1382, 1381,1522, 1381, 1524,1522, 1524, 1525,1522, 1525, 1523,
1526, 1513, 1512,1526, 1512, 1523,1526, 1523, 1525,1526, 1525, 1527,
1526, 1527, 1528,1526, 1528, 1529,1526, 1529, 1514,1526, 1514, 1513,
1530, 1531, 1532,1530, 1532, 1533,1530, 1533, 1404,1530, 1404, 1534,
1530, 1534, 1535,1530, 1535, 1536,1530, 1536, 1537,1530, 1537, 1531,
1538, 1539, 1532,1538, 1532, 1531,1538, 1531, 1537,1538, 1537, 1540,
1538, 1540, 1541,1538, 1541, 1542,1538, 1542, 1543,1538, 1543, 1539,
1544, 1545, 1532,1544, 1532, 1539,1544, 1539, 1543,1544, 1543, 1546,
1544, 1546, 1547,1544, 1547, 1548,1544, 1548, 1549,1544, 1549, 1545,
1550, 1533, 1532,1550, 1532, 1545,1550, 1545, 1549,1550, 1549, 1551,
1550, 1551, 1406,1550, 1406, 1405,1550, 1405, 1404,1550, 1404, 1533,
1552, 1553, 1554,1552, 1554, 1555,1552, 1555, 1556,1552, 1556, 1557,
1552, 1557, 1558,1552, 1558, 1559,1552, 1559, 1560,1552, 1560, 1553,
1561, 1562, 1554,1561, 1554, 1553,1561, 1553, 1560,1561, 1560, 1563,
1561, 1563, 1419,1561, 1419, 1418,1561, 1418, 1417,1561, 1417, 1562,
1564, 1565, 1554,1564, 1554, 1562,1564, 1562, 1417,1564, 1417, 1437,
1564, 1437, 1436,1564, 1436, 1566,1564, 1566, 1567,1564, 1567, 1565,
1568, 1555, 1554,1568, 1554, 1565,1568, 1565, 1567,1568, 1567, 1569,
1568, 1569, 1570,1568, 1570, 1571,1568, 1571, 1556,1568, 1556, 1555,
1572, 1573, 1574,1572, 1574, 1575,1572, 1575, 1452,1572, 1452, 1451,
1572, 1451, 1450,1572, 1450, 1576,1572, 1576, 1577,1572, 1577, 1573,
1578, 1579, 1574,1578, 1574, 1573,1578, 1573, 1577,1578, 1577, 1580,
1578, 1580, 1581,1578, 1581, 1582,1578, 1582, 1583,1578, 1583, 1579,
1584, 1585, 1574,1584, 1574, 1579,1584, 1579, 1583,1584, 1583, 1586,
1584, 1586, 1587,1584, 1587, 1588,1584, 1588, 1589,1584, 1589, 1585,
1590, 1575, 1574,1590, 1574, 1585,1590, 1585, 1589,1590, 1589, 1591,
1590, 1591, 1456,1590, 1456, 1455,1590, 1455, 1452,1590, 1452, 1575,
1592, 1593, 1594,1592, 1594, 1595,1592, 1595, 1596,1592, 1596, 1597,
1592, 1597, 1598,1592, 1598, 1599,1592, 1599, 1600,1592, 1600, 1593,
1601, 1602, 1594,1601, 1594, 1593,1601, 1593, 1600,1601, 1600, 1603,
1601, 1603, 1469,1601, 1469, 1468,1601, 1468, 1467,1601, 1467, 1602,
1604, 1605, 1594,1604, 1594, 1602,1604, 1602, 1467,1604, 1467, 1487,
1604, 1487, 1486,1604, 1486, 1606,1604, 1606, 1607,1604, 1607, 1605,
1608, 1595, 1594,1608, 1594, 1605,1608, 1605, 1607,1608, 1607, 1609,
1608, 1609, 1610,1608, 1610, 1611,1608, 1611, 1596,1608, 1596, 1595,
1612, 1613, 1614,1612, 1614, 1615,1612, 1615, 1502,1612, 1502, 1501,
1612, 1501, 1500,1612, 1500, 1616,1612, 1616, 1617,1612, 1617, 1613,
1618, 1619, 1614,1618, 1614, 1613,1618, 1613, 1617,1618, 1617, 1620,
1618, 1620, 1621,1618, 1621, 1622,1618, 1622, 1623,1618, 1623, 1619,
1624, 1625, 1614,1624, 1614, 1619,1624, 1619, 1623,1624, 1623, 1626,
1624, 1626, 1627,1624, 1627, 1628,1624, 1628, 1629,1624, 1629, 1625,
1630, 1615, 1614,1630, 1614, 1625,1630, 1625, 1629,1630, 1629, 1631,
1630, 1631, 1398,1630, 1398, 1505,1630, 1505, 1502,1630, 1502, 1615,
1632, 1633, 1634,1632, 1634, 1635,1632, 1635, 1267,1632, 1267, 1284,
1632, 1284, 1283,1632, 1283, 1636,1632, 1636, 1637,1632, 1637, 1633,
1638, 1639, 1634,1638, 1634, 1633,1638, 1633, 1637,1638, 1637, 1640,
1638, 1640, 1641,1638, 1641, 1642,1638, 1642, 1643,1638, 1643, 1639,
1644, 1645, 1634,1644, 1634, 1639,1644, 1639, 1643,1644, 1643, 1646,
1644, 1646, 1647,1644, 1647, 1648,1644, 1648, 1649,1644, 1649, 1645,
1650, 1635, 1634,1650, 1634, 1645,1650, 1645, 1649,1650, 1649, 1651,
1650, 1651, 1269,1650, 1269, 1268,1650, 1268, 1267,1650, 1267, 1635,
1652, 1653, 1654,1652, 1654, 1655,1652, 1655, 1643,1652, 1643, 1642,
1652, 1642, 1641,1652, 1641, 1656,1652, 1656, 1657,1652, 1657, 1653,
1658, 1659, 1654,1658, 1654, 1653,1658, 1653, 1657,1658, 1657, 1660,
1658, 1660, 1174,1658, 1174, 1173,1658, 1173, 1172,1658, 1172, 1659,
1661, 1662, 1654,1661, 1654, 1659,1661, 1659, 1172,1661, 1172, 1189,
1661, 1189, 1188,1661, 1188, 1663,1661, 1663, 1664,1661, 1664, 1662,
1665, 1655, 1654,1665, 1654, 1662,1665, 1662, 1664,1665, 1664, 1666,
1665, 1666, 1647,1665, 1647, 1646,1665, 1646, 1643,1665, 1643, 1655,
1667, 1668, 1669,1667, 1669, 1670,1667, 1670, 1204,1667, 1204, 1203,
1667, 1203, 1202,1667, 1202, 1671,1667, 1671, 1672,1667, 1672, 1668,
1673, 1674, 1669,1673, 1669, 1668,1673, 1668, 1672,1673, 1672, 1675,
1673, 1675, 1676,1673, 1676, 1677,1673, 1677, 1678,1673, 1678, 1674,
1679, 1680, 1669,1679, 1669, 1674,1679, 1674, 1678,1679, 1678, 1681,
1679, 1681, 1682,1679, 1682, 1683,1679, 1683, 1684,1679, 1684, 1680,
1685, 1670, 1669,1685, 1669, 1680,1685, 1680, 1684,1685, 1684, 1686,
1685, 1686, 1208,1685, 1208, 1207,1685, 1207, 1204,1685, 1204, 1670,
1687, 1688, 1689,1687, 1689, 1690,1687, 1690, 1678,1687, 1678, 1677,
1687, 1677, 1676,1687, 1676, 1691,1687, 1691, 1692,1687, 1692, 1688,
1693, 1694, 1689,1693, 1689, 1688,1693, 1688, 1692,1693, 1692, 1695,
1693, 1695, 1291,1693, 1291, 1290,1693, 1290, 1289,1693, 1289, 1694,
1696, 1697, 1689,1696, 1689, 1694,1696, 1694, 1289,1696, 1289, 1309,
1696, 1309, 1308,1696, 1308, 1698,1696, 1698, 1699,1696, 1699, 1697,
1700, 1690, 1689,1700, 1689, 1697,1700, 1697, 1699,1700, 1699, 1701,
1700, 1701, 1682,1700, 1682, 1681,1700, 1681, 1678,1700, 1678, 1690,
1702, 1703, 1704,1702, 1704, 1705,1702, 1705, 1319,1702, 1319, 1318,
1702, 1318, 1269,1702, 1269, 1651,1702, 1651, 1649,1702, 1649, 1703,
1706, 1707, 1708,1706, 1708, 1709,1706, 1709, 1710,1706, 1710, 1711,
1706, 1711, 1712,1706, 1712, 1713,1706, 1713, 1714,1706, 1714, 1707,
1715, 1716, 1708,1715, 1708, 1707,1715, 1707, 1714,1715, 1714, 1717,
1715, 1717, 1718,1715, 1718, 1719,1715, 1719, 1720,1715, 1720, 1716,
1721, 1722, 1708,1721, 1708, 1716,1721, 1716, 1720,1721, 1720, 1723,
1721, 1723, 1326,1721, 1326, 1325,1721, 1325, 1324,1721, 1324, 1722,
1724, 1725, 1726,1724, 1726, 1727,1724, 1727, 1714,1724, 1714, 1713,
1724, 1713, 1712,1724, 1712, 1728,1724, 1728, 1729,1724, 1729, 1725,
1730, 1731, 1726,1730, 1726, 1725,1730, 1725, 1729,1730, 1729, 1732,
1730, 1732, 1733,1730, 1733, 1734,1730, 1734, 1239,1730, 1239, 1731,
1735, 1736, 1726,1735, 1726, 1731,1735, 1731, 1239,1735, 1239, 1238,
1735, 1238, 1237,1735, 1237, 1737,1735, 1737, 1738,1735, 1738, 1736,
1739, 1727, 1726,1739, 1726, 1736,1739, 1736, 1738,1739, 1738, 1740,
1739, 1740, 1718,1739, 1718, 1717,1739, 1717, 1714,1739, 1714, 1727,
1741, 1742, 1743,1741, 1743, 1744,1741, 1744, 1349,1741, 1349, 1348,
1741, 1348, 1347,1741, 1347, 1745,1741, 1745, 1746,1741, 1746, 1742,
1747, 1748, 1749,1747, 1749, 1750,1747, 1750, 1751,1747, 1751, 1752,
1747, 1752, 1753,1747, 1753, 1754,1747, 1754, 1755,1747, 1755, 1748,
1756, 1757, 1749,1756, 1749, 1748,1756, 1748, 1755,1756, 1755, 1758,
1756, 1758, 1641,1756, 1641, 1640,1756, 1640, 1637,1756, 1637, 1757,
1759, 1760, 1749,1759, 1749, 1757,1759, 1757, 1637,1759, 1637, 1636,
1759, 1636, 1283,1759, 1283, 1355,1759, 1355, 1354,1759, 1354, 1760,
1761, 1762, 1763,1761, 1763, 1764,1761, 1764, 1755,1761, 1755, 1754,
1761, 1754, 1753,1761, 1753, 1765,1761, 1765, 1766,1761, 1766, 1762,
1767, 1768, 1763,1767, 1763, 1762,1767, 1762, 1766,1767, 1766, 1769,
1767, 1769, 1770,1767, 1770, 1771,1767, 1771, 1262,1767, 1262, 1768,
1772, 1773, 1763,1772, 1763, 1768,1772, 1768, 1262,1772, 1262, 1261,
1772, 1261, 1174,1772, 1174, 1660,1772, 1660, 1657,1772, 1657, 1773,
1774, 1764, 1763,1774, 1763, 1773,1774, 1773, 1657,1774, 1657, 1656,
1774, 1656, 1641,1774, 1641, 1758,1774, 1758, 1755,1774, 1755, 1764,
1775, 1776, 1777,1775, 1777, 1778,1775, 1778, 1431,1775, 1431, 1430,
1775, 1430, 1208,1775, 1208, 1686,1775, 1686, 1684,1775, 1684, 1776,
1779, 1780, 1777,1779, 1777, 1776,1779, 1776, 1684,1779, 1684, 1683,
1779, 1683, 1682,1779, 1682, 1781,1779, 1781, 1782,1779, 1782, 1780,
1783, 1784, 1785,1783, 1785, 1786,1783, 1786, 1787,1783, 1787, 1788,
1783, 1788, 1789,1783, 1789, 1790,1783, 1790, 1791,1783, 1791, 1784,
1792, 1793, 1785,1792, 1785, 1784,1792, 1784, 1791,1792, 1791, 1794,
1792, 1794, 1436,1792, 1436, 1435,1792, 1435, 1434,1792, 1434, 1793,
1795, 1796, 1797,1795, 1797, 1798,1795, 1798, 1782,1795, 1782, 1781,
1795, 1781, 1682,1795, 1682, 1701,1795, 1701, 1699,1795, 1699, 1796,
1799, 1800, 1797,1799, 1797, 1796,1799, 1796, 1699,1799, 1699, 1698,
1799, 1698, 1308,1799, 1308, 1801,1799, 1801, 1802,1799, 1802, 1800,
1803, 1804, 1805,1803, 1805, 1806,1803, 1806, 1471,1803, 1471, 1470,
1803, 1470, 1469,1803, 1469, 1807,1803, 1807, 1808,1803, 1808, 1804,
1809, 1810, 1805,1809, 1805, 1804,1809, 1804, 1808,1809, 1808, 1811,
1809, 1811, 1789,1809, 1789, 1788,1809, 1788, 1787,1809, 1787, 1810,
1812, 1813, 1814,1812, 1814, 1815,1812, 1815, 1458,1812, 1458, 1457,
1812, 1457, 1456,1812, 1456, 1816,1812, 1816, 1817,1812, 1817, 1813,
1818, 1819, 1814,1818, 1814, 1813,1818, 1813, 1817,1818, 1817, 1820,
1818, 1820, 1821,1818, 1821, 1822,1818, 1822, 1823,1818, 1823, 1819,
1824, 1825, 1814,1824, 1814, 1819,1824, 1819, 1823,1824, 1823, 1826,
1824, 1826, 1827,1824, 1827, 1828,1824, 1828, 1829,1824, 1829, 1825,
1830, 1815, 1814,1830, 1814, 1825,1830, 1825, 1829,1830, 1829, 1831,
1830, 1831, 1461,1830, 1461, 1460,1830, 1460, 1458,1830, 1458, 1815,
1832, 1833, 1834,1832, 1834, 1835,1832, 1835, 1823,1832, 1823, 1822,
1832, 1822, 1821,1832, 1821, 1836,1832, 1836, 1837,1832, 1837, 1833,
1838, 1839, 1834,1838, 1834, 1833,1838, 1833, 1837,1838, 1837, 1840,
1838, 1840, 1500,1838, 1500, 1499,1838, 1499, 1496,1838, 1496, 1839,
1841, 1842, 1834,1841, 1834, 1839,1841, 1839, 1496,1841, 1496, 1495,
1841, 1495, 1494,1841, 1494, 1843,1841, 1843, 1844,1841, 1844, 1842,
1845, 1835, 1834,1845, 1834, 1842,1845, 1842, 1844,1845, 1844, 1846,
1845, 1846, 1827,1845, 1827, 1826,1845, 1826, 1823,1845, 1823, 1835,
1847, 1848, 1849,1847, 1849, 1850,1847, 1850, 1567,1847, 1567, 1566,
1847, 1566, 1436,1847, 1436, 1794,1847, 1794, 1791,1847, 1791, 1848,
1851, 1852, 1849,1851, 1849, 1848,1851, 1848, 1791,1851, 1791, 1790,
1851, 1790, 1789,1851, 1789, 1853,1851, 1853, 1854,1851, 1854, 1852,
1855, 1856, 1849,1855, 1849, 1852,1855, 1852, 1854,1855, 1854, 1857,
1855, 1857, 1858,1855, 1858, 1859,1855, 1859, 1860,1855, 1860, 1856,
1861, 1850, 1849,1861, 1849, 1856,1861, 1856, 1860,1861, 1860, 1862,
1861, 1862, 1570,1861, 1570, 1569,1861, 1569, 1567,1861, 1567, 1850,
1863, 1864, 1865,1863, 1865, 1866,1863, 1866, 1854,1863, 1854, 1853,
1863, 1853, 1789,1863, 1789, 1811,1863, 1811, 1808,1863, 1808, 1864,
1867, 1868, 1865,1867, 1865, 1864,1867, 1864, 1808,1867, 1808, 1807,
1867, 1807, 1469,1867, 1469, 1603,1867, 1603, 1600,1867, 1600, 1868,
1869, 1870, 1865,1869, 1865, 1868,1869, 1868, 1600,1869, 1600, 1599,
1869, 1599, 1598,1869, 1598, 1871,1869, 1871, 1872,1869, 1872, 1870,
1873, 1866, 1865,1873, 1865, 1870,1873, 1870, 1872,1873, 1872, 1874,
1873, 1874, 1858,1873, 1858, 1857,1873, 1857, 1854,1873, 1854, 1866,
1875, 1876, 1877,1875, 1877, 1878,1875, 1878, 1589,1875, 1589, 1588,
1875, 1588, 1587,1875, 1587, 1879,1875, 1879, 1880,1875, 1880, 1876,
1881, 1882, 1877,1881, 1877, 1876,1881, 1876, 1880,1881, 1880, 1883,
1881, 1883, 1884,1881, 1884, 1885,1881, 1885, 1886,1881, 1886, 1882,
1887, 1888, 1877,1887, 1877, 1882,1887, 1882, 1886,1887, 1886, 1889,
1887, 1889, 1821,1887, 1821, 1820,1887, 1820, 1817,1887, 1817, 1888,
1890, 1878, 1877,1890, 1877, 1888,1890, 1888, 1817,1890, 1817, 1816,
1890, 1816, 1456,1890, 1456, 1591,1890, 1591, 1589,1890, 1589, 1878,
1891, 1892, 1893,1891, 1893, 1894,1891, 1894, 1886,1891, 1886, 1885,
1891, 1885, 1884,1891, 1884, 1895,1891, 1895, 1896,1891, 1896, 1892,
1897, 1898, 1893,1897, 1893, 1892,1897, 1892, 1896,1897, 1896, 1899,
1897, 1899, 1621,1897, 1621, 1620,1897, 1620, 1617,1897, 1617, 1898,
1900, 1901, 1893,1900, 1893, 1898,1900, 1898, 1617,1900, 1617, 1616,
1900, 1616, 1500,1900, 1500, 1840,1900, 1840, 1837,1900, 1837, 1901,
1902, 1894, 1893,1902, 1893, 1901,1902, 1901, 1837,1902, 1837, 1836,
1902, 1836, 1821,1902, 1821, 1889,1902, 1889, 1886,1902, 1886, 1894,
1903, 1904, 1905,1903, 1905, 1906,1903, 1906, 1125,1903, 1125, 1124,
1903, 1124, 1123,1903, 1123, 1907,1903, 1907, 1908,1903, 1908, 1904,
1909, 1910, 1905,1909, 1905, 1904,1909, 1904, 1908,1909, 1908, 1911,
1909, 1911, 1912,1909, 1912, 1913,1909, 1913, 1914,1909, 1914, 1910,
1915, 1916, 1905,1915, 1905, 1910,1915, 1910, 1914,1915, 1914, 1917,
1915, 1917, 1918,1915, 1918, 1919,1915, 1919, 1920,1915, 1920, 1916,
1921, 1906, 1905,1921, 1905, 1916,1921, 1916, 1920,1921, 1920, 1922,
1921, 1922, 1129,1921, 1129, 1128,1921, 1128, 1125,1921, 1125, 1906,
1923, 1924, 1925,1923, 1925, 1926,1923, 1926, 1914,1923, 1914, 1913,
1923, 1913, 1912,1923, 1912, 1927,1923, 1927, 1928,1923, 1928, 1924,
1929, 1930, 1925,1929, 1925, 1924,1929, 1924, 1928,1929, 1928, 1931,
1929, 1931, 1516,1929, 1516, 1515,1929, 1515, 1514,1929, 1514, 1930,
1932, 1933, 1925,1932, 1925, 1930,1932, 1930, 1514,1932, 1514, 1529,
1932, 1529, 1528,1932, 1528, 1934,1932, 1934, 1935,1932, 1935, 1933,
1936, 1926, 1925,1936, 1925, 1933,1936, 1933, 1935,1936, 1935, 1937,
1936, 1937, 1918,1936, 1918, 1917,1936, 1917, 1914,1936, 1914, 1926,
1938, 1939, 1940,1938, 1940, 1941,1938, 1941, 1942,1938, 1942, 1943,
1938, 1943, 1627,1938, 1627, 1944,1938, 1944, 1945,1938, 1945, 1939,
1946, 1947, 1940,1946, 1940, 1939,1946, 1939, 1945,1946, 1945, 1948,
1946, 1948, 1949,1946, 1949, 1950,1946, 1950, 1951,1946, 1951, 1947,
1952, 1953, 1954,1952, 1954, 1955,1952, 1955, 1956,1952, 1956, 1957,
1952, 1957, 1958,1952, 1958, 1959,1952, 1959, 1960,1952, 1960, 1953,
1961, 1962, 1954,1961, 1954, 1953,1961, 1953, 1960,1961, 1960, 1963,
1961, 1963, 1547,1961, 1547, 1546,1961, 1546, 1543,1961, 1543, 1962,
1964, 1965, 1966,1964, 1966, 1967,1964, 1967, 1956,1964, 1956, 1968,
1964, 1968, 1969,1964, 1969, 1970,1964, 1970, 1971,1964, 1971, 1965,
1972, 1973, 1966,1972, 1966, 1965,1972, 1965, 1971,1972, 1971, 1974,
1972, 1974, 1156,1972, 1156, 1155,1972, 1155, 1152,1972, 1152, 1973,
1975, 1976, 1966,1975, 1966, 1973,1975, 1973, 1152,1975, 1152, 1151,
1975, 1151, 1150,1975, 1150, 1977,1975, 1977, 1978,1975, 1978, 1976,
1979, 1967, 1966,1979, 1966, 1976,1979, 1976, 1978,1979, 1978, 1980,
1979, 1980, 1958,1979, 1958, 1957,1979, 1957, 1956,1979, 1956, 1967,
1981, 1982, 1983,1981, 1983, 1984,1981, 1984, 1233,1981, 1233, 1232,
1981, 1232, 1231,1981, 1231, 1985,1981, 1985, 1986,1981, 1986, 1982,
1987, 1988, 1983,1987, 1983, 1982,1987, 1982, 1986,1987, 1986, 1989,
1987, 1989, 1990,1987, 1990, 1991,1987, 1991, 1992,1987, 1992, 1988,
1993, 1994, 1983,1993, 1983, 1988,1993, 1988, 1992,1993, 1992, 1995,
1993, 1995, 1996,1993, 1996, 1997,1993, 1997, 1998,1993, 1998, 1994,
1999, 1984, 1983,1999, 1983, 1994,1999, 1994, 1998,1999, 1998, 2000,
1999, 2000, 1237,1999, 1237, 1236,1999, 1236, 1233,1999, 1233, 1984,
2001, 2002, 2003,2001, 2003, 2004,2001, 2004, 1992,2001, 1992, 1991,
2001, 1991, 1990,2001, 1990, 2005,2001, 2005, 2006,2001, 2006, 2002,
2007, 2008, 2003,2007, 2003, 2002,2007, 2002, 2006,2007, 2006, 2009,
2007, 2009, 1558,2007, 1558, 1557,2007, 1557, 1556,2007, 1556, 2008,
2010, 2011, 2003,2010, 2003, 2008,2010, 2008, 1556,2010, 1556, 1571,
2010, 1571, 1570,2010, 1570, 2012,2010, 2012, 2013,2010, 2013, 2011,
2014, 2004, 2003,2014, 2003, 2011,2014, 2011, 2013,2014, 2013, 2015,
2014, 2015, 1996,2014, 1996, 1995,2014, 1995, 1992,2014, 1992, 2004,
2016, 2017, 2018,2016, 2018, 2019,2016, 2019, 1583,2016, 1583, 1582,
2016, 1582, 1581,2016, 1581, 2020,2016, 2020, 2021,2016, 2021, 2017,
2022, 2023, 2018,2022, 2018, 2017,2022, 2017, 2021,2022, 2021, 2024,
2022, 2024, 2025,2022, 2025, 2026,2022, 2026, 2027,2022, 2027, 2023,
2028, 2029, 2018,2028, 2018, 2023,2028, 2023, 2027,2028, 2027, 2030,
2028, 2030, 2031,2028, 2031, 2032,2028, 2032, 2033,2028, 2033, 2029,
2034, 2019, 2018,2034, 2018, 2029,2034, 2029, 2033,2034, 2033, 2035,
2034, 2035, 1587,2034, 1587, 1586,2034, 1586, 1583,2034, 1583, 2019,
2036, 2037, 2038,2036, 2038, 2039,2036, 2039, 2027,2036, 2027, 2026,
2036, 2026, 2025,2036, 2025, 2040,2036, 2040, 2041,2036, 2041, 2037,
2042, 2043, 2038,2042, 2038, 2037,2042, 2037, 2041,2042, 2041, 2044,
2042, 2044, 1252,2042, 1252, 1251,2042, 1251, 1248,2042, 1248, 2043,
2045, 2046, 2038,2045, 2038, 2043,2045, 2043, 1248,2045, 1248, 1247,
2045, 1247, 1246,2045, 1246, 2047,2045, 2047, 2048,2045, 2048, 2046,
2049, 2039, 2038,2049, 2038, 2046,2049, 2046, 2048,2049, 2048, 2050,
2049, 2050, 2031,2049, 2031, 2030,2049, 2030, 2027,2049, 2027, 2039,
2051, 2052, 2053,2051, 2053, 2054,2051, 2054, 1328,2051, 1328, 1327,
2051, 1327, 1326,2051, 1326, 2055,2051, 2055, 2056,2051, 2056, 2052,
2057, 2058, 2053,2057, 2053, 2052,2057, 2052, 2056,2057, 2056, 2059,
2057, 2059, 2060,2057, 2060, 2061,2057, 2061, 2062,2057, 2062, 2058,
2063, 2064, 2053,2063, 2053, 2058,2063, 2058, 2062,2063, 2062, 2065,
2063, 2065, 2066,2063, 2066, 2067,2063, 2067, 2068,2063, 2068, 2064,
2069, 2054, 2053,2069, 2053, 2064,2069, 2064, 2068,2069, 2068, 2070,
2069, 2070, 1332,2069, 1332, 1331,2069, 1331, 1328,2069, 1328, 2054,
2071, 2072, 2073,2071, 2073, 2074,2071, 2074, 2062,2071, 2062, 2061,
2071, 2061, 2060,2071, 2060, 2075,2071, 2075, 2076,2071, 2076, 2072,
2077, 2078, 2073,2077, 2073, 2072,2077, 2072, 2076,2077, 2076, 2079,
2077, 2079, 1598,2077, 1598, 1597,2077, 1597, 1596,2077, 1596, 2078,
2080, 2081, 2073,2080, 2073, 2078,2080, 2078, 1596,2080, 1596, 1611,
2080, 1611, 1610,2080, 1610, 2082,2080, 2082, 2083,2080, 2083, 2081,
2084, 2074, 2073,2084, 2073, 2081,2084, 2081, 2083,2084, 2083, 2085,
2084, 2085, 2066,2084, 2066, 2065,2084, 2065, 2062,2084, 2062, 2074,
2086, 2087, 2088,2086, 2088, 2089,2086, 2089, 1623,2086, 1623, 1622,
2086, 1622, 1621,2086, 1621, 2090,2086, 2090, 2091,2086, 2091, 2087,
2092, 2093, 2088,2092, 2088, 2087,2092, 2087, 2091,2092, 2091, 2094,
2092, 2094, 2095,2092, 2095, 2096,2092, 2096, 2097,2092, 2097, 2093,
2098, 2099, 2088,2098, 2088, 2093,2098, 2093, 2097,2098, 2097, 2100,
2098, 2100, 1949,2098, 1949, 1948,2098, 1948, 1945,2098, 1945, 2099,
2101, 2089, 2088,2101, 2088, 2099,2101, 2099, 1945,2101, 1945, 1944,
2101, 1944, 1627,2101, 1627, 1626,2101, 1626, 1623,2101, 1623, 2089,
2102, 2103, 2104,2102, 2104, 2105,2102, 2105, 2097,2102, 2097, 2096,
2102, 2096, 2095,2102, 2095, 2106,2102, 2106, 2107,2102, 2107, 2103,
2108, 2109, 2104,2108, 2104, 2103,2108, 2103, 2107,2108, 2107, 2110,
2108, 2110, 1347,2108, 1347, 1346,2108, 1346, 1343,2108, 1343, 2109,
2111, 2112, 2104,2111, 2104, 2109,2111, 2109, 1343,2111, 1343, 1342,
2111, 1342, 1341,2111, 1341, 2113,2111, 2113, 2114,2111, 2114, 2112,
2115, 2105, 2104,2115, 2104, 2112,2115, 2112, 2114,2115, 2114, 2116,
2115, 2116, 1949,2115, 1949, 2100,2115, 2100, 2097,2115, 2097, 2105,
2117, 2118, 2119,2117, 2119, 2120,2117, 2120, 1860,2117, 1860, 1859,
2117, 1859, 1858,2117, 1858, 2121,2117, 2121, 2122,2117, 2122, 2118,
2123, 2124, 2119,2123, 2119, 2118,2123, 2118, 2122,2123, 2122, 2125,
2123, 2125, 2126,2123, 2126, 2127,2123, 2127, 2128,2123, 2128, 2124,
2129, 2130, 2119,2129, 2119, 2124,2129, 2124, 2128,2129, 2128, 2131,
2129, 2131, 1996,2129, 1996, 2015,2129, 2015, 2013,2129, 2013, 2130,
2132, 2120, 2119,2132, 2119, 2130,2132, 2130, 2013,2132, 2013, 2012,
2132, 2012, 1570,2132, 1570, 1862,2132, 1862, 1860,2132, 1860, 2120,
2133, 2134, 2135,2133, 2135, 2136,2133, 2136, 2128,2133, 2128, 2127,
2133, 2127, 2126,2133, 2126, 2137,2133, 2137, 2138,2133, 2138, 2134,
2139, 2140, 2135,2139, 2135, 2134,2139, 2134, 2138,2139, 2138, 2141,
2139, 2141, 1718,2139, 1718, 1740,2139, 1740, 1738,2139, 1738, 2140,
2142, 2143, 2135,2142, 2135, 2140,2142, 2140, 1738,2142, 1738, 1737,
2142, 1737, 1237,2142, 1237, 2000,2142, 2000, 1998,2142, 1998, 2143,
2144, 2136, 2135,2144, 2135, 2143,2144, 2143, 1998,2144, 1998, 1997,
2144, 1997, 1996,2144, 1996, 2131,2144, 2131, 2128,2144, 2128, 2136,
2145, 2146, 2147,2145, 2147, 2148,2145, 2148, 1872,2145, 1872, 1871,
2145, 1871, 1598,2145, 1598, 2079,2145, 2079, 2076,2145, 2076, 2146,
2149, 2150, 2147,2149, 2147, 2146,2149, 2146, 2076,2149, 2076, 2075,
2149, 2075, 2060,2149, 2060, 2151,2149, 2151, 2152,2149, 2152, 2150,
2153, 2154, 2147,2153, 2147, 2150,2153, 2150, 2152,2153, 2152, 2155,
2153, 2155, 2126,2153, 2126, 2125,2153, 2125, 2122,2153, 2122, 2154,
2156, 2148, 2147,2156, 2147, 2154,2156, 2154, 2122,2156, 2122, 2121,
2156, 2121, 1858,2156, 1858, 1874,2156, 1874, 1872,2156, 1872, 2148,
2157, 2158, 2159,2157, 2159, 2160,2157, 2160, 2152,2157, 2152, 2151,
2157, 2151, 2060,2157, 2060, 2059,2157, 2059, 2056,2157, 2056, 2158,
2161, 2162, 2159,2161, 2159, 2158,2161, 2158, 2056,2161, 2056, 2055,
2161, 2055, 1326,2161, 1326, 1723,2161, 1723, 1720,2161, 1720, 2162,
2163, 2164, 2159,2163, 2159, 2162,2163, 2162, 1720,2163, 1720, 1719,
2163, 1719, 1718,2163, 1718, 2141,2163, 2141, 2138,2163, 2138, 2164,
2165, 2160, 2159,2165, 2159, 2164,2165, 2164, 2138,2165, 2138, 2137,
2165, 2137, 2126,2165, 2126, 2155,2165, 2155, 2152,2165, 2152, 2160,
2166, 2167, 2168,2166, 2168, 2169,2166, 2169, 2170,2166, 2170, 2171,
2166, 2171, 2172,2166, 2172, 2173,2166, 2173, 2174,2166, 2174, 2167,
2175, 2176, 2168,2175, 2168, 2167,2175, 2167, 2174,2175, 2174, 2177,
2175, 2177, 2178,2175, 2178, 2179,2175, 2179, 2180,2175, 2180, 2176,
2181, 2182, 2168,2181, 2168, 2176,2181, 2176, 2180,2181, 2180, 2183,
2181, 2183, 2031,2181, 2031, 2050,2181, 2050, 2048,2181, 2048, 2182,
2184, 2169, 2168,2184, 2168, 2182,2184, 2182, 2048,2184, 2048, 2047,
2184, 2047, 1246,2184, 1246, 2185,2184, 2185, 2170,2184, 2170, 2169,
2186, 2187, 2188,2186, 2188, 2189,2186, 2189, 2180,2186, 2180, 2179,
2186, 2179, 2178,2186, 2178, 2190,2186, 2190, 2191,2186, 2191, 2187,
2192, 2193, 2188,2192, 2188, 2187,2192, 2187, 2191,2192, 2191, 2194,
2192, 2194, 1884,2192, 1884, 1883,2192, 1883, 1880,2192, 1880, 2193,
2195, 2196, 2188,2195, 2188, 2193,2195, 2193, 1880,2195, 1880, 1879,
2195, 1879, 1587,2195, 1587, 2035,2195, 2035, 2033,2195, 2033, 2196,
2197, 2189, 2188,2197, 2188, 2196,2197, 2196, 2033,2197, 2033, 2032,
2197, 2032, 2031,2197, 2031, 2183,2197, 2183, 2180,2197, 2180, 2189,
2198, 2199, 2200,2198, 2200, 2201,2198, 2201, 1746,2198, 1746, 1745,
2198, 1745, 1347,2198, 1347, 2110,2198, 2110, 2107,2198, 2107, 2199,
2202, 2203, 2200,2202, 2200, 2199,2202, 2199, 2107,2202, 2107, 2106,
2202, 2106, 2095,2202, 2095, 2204,2202, 2204, 2205,2202, 2205, 2203,
2206, 2207, 2200,2206, 2200, 2203,2206, 2203, 2205,2206, 2205, 2208,
2206, 2208, 2178,2206, 2178, 2177,2206, 2177, 2174,2206, 2174, 2207,
2209, 2201, 2200,2209, 2200, 2207,2209, 2207, 2174,2209, 2174, 2173,
2209, 2173, 2172,2209, 2172, 2210,2209, 2210, 1746,2209, 1746, 2201,
2211, 2212, 2213,2211, 2213, 2214,2211, 2214, 2205,2211, 2205, 2204,
2211, 2204, 2095,2211, 2095, 2094,2211, 2094, 2091,2211, 2091, 2212,
2215, 2216, 2213,2215, 2213, 2212,2215, 2212, 2091,2215, 2091, 2090,
2215, 2090, 1621,2215, 1621, 1899,2215, 1899, 1896,2215, 1896, 2216,
2217, 2218, 2213,2217, 2213, 2216,2217, 2216, 1896,2217, 1896, 1895,
2217, 1895, 1884,2217, 1884, 2194,2217, 2194, 2191,2217, 2191, 2218,
2219, 2214, 2213,2219, 2213, 2218,2219, 2218, 2191,2219, 2191, 2190,
2219, 2190, 2178,2219, 2178, 2208,2219, 2208, 2205,2219, 2205, 2214,
2220, 2221, 2222,2220, 2222, 2223,2220, 2223, 2224,2220, 2224, 2225,
2220, 2225, 2226,2220, 2226, 2227,2220, 2227, 2228,2220, 2228, 2221,
2229, 2230, 2231,2229, 2231, 2232,2229, 2232, 2233,2229, 2233, 2234,
2229, 2234, 2235,2229, 2235, 2236,2229, 2236, 2237,2229, 2237, 2230,
2238, 2232, 2231,2238, 2231, 2239,2238, 2239, 2240,2238, 2240, 2241,
2238, 2241, 2242,2238, 2242, 2243,2238, 2243, 2233,2238, 2233, 2232,
2244, 2245, 2222,2244, 2222, 2221,2244, 2221, 2228,2244, 2228, 2246,
2244, 2246, 2247,2244, 2247, 2248,2244, 2248, 2249,2244, 2249, 2245,
2250, 2251, 2252,2250, 2252, 2253,2250, 2253, 2254,2250, 2254, 2255,
2250, 2255, 2256,2250, 2256, 2257,2250, 2257, 2258,2250, 2258, 2251,
2259, 2253, 2252,2259, 2252, 2260,2259, 2260, 2261,2259, 2261, 2262,
2259, 2262, 2263,2259, 2263, 2264,2259, 2264, 2254,2259, 2254, 2253,
2265, 2260, 2252,2265, 2252, 2266,2265, 2266, 2267,2265, 2267, 2268,
2265, 2268, 2269,2265, 2269, 2270,2265, 2270, 2261,2265, 2261, 2260,
2271, 2272, 2273,2271, 2273, 2274,2271, 2274, 2275,2271, 2275, 2276,
2271, 2276, 2277,2271, 2277, 2278,2271, 2278, 2279,2271, 2279, 2272,
2280, 2281, 2282,2280, 2282, 2283,2280, 2283, 2284,2280, 2284, 2285,
2280, 2285, 2286,2280, 2286, 2287,2280, 2287, 2288,2280, 2288, 2281,
2289, 2283, 2282,2289, 2282, 2290,2289, 2290, 2228,2289, 2228, 2227,
2289, 2227, 2226,2289, 2226, 2291,2289, 2291, 2284,2289, 2284, 2283,
2292, 2290, 2282,2292, 2282, 2293,2292, 2293, 2294,2292, 2294, 2295,
2292, 2295, 2247,2292, 2247, 2246,2292, 2246, 2228,2292, 2228, 2290,
2296, 2293, 2282,2296, 2282, 2281,2296, 2281, 2288,2296, 2288, 2297,
2296, 2297, 2298,2296, 2298, 2299,2296, 2299, 2294,2296, 2294, 2293,
2300, 2301, 2302,2300, 2302, 2303,2300, 2303, 2304,2300, 2304, 2305,
2300, 2305, 2306,2300, 2306, 2307,2300, 2307, 2308,2300, 2308, 2301,
2309, 2303, 2302,2309, 2302, 2310,2309, 2310, 2311,2309, 2311, 2312,
2309, 2312, 2313,2309, 2313, 2314,2309, 2314, 2304,2309, 2304, 2303,
2315, 2310, 2302,2315, 2302, 2316,2315, 2316, 2317,2315, 2317, 2318,
2315, 2318, 2319,2315, 2319, 2320,2315, 2320, 2311,2315, 2311, 2310,
2321, 2316, 2302,2321, 2302, 2301,2321, 2301, 2308,2321, 2308, 2322,
2321, 2322, 2323,2321, 2323, 2324,2321, 2324, 2317,2321, 2317, 2316,
2325, 2326, 2327,2325, 2327, 2328,2325, 2328, 2294,2325, 2294, 2299,
2325, 2299, 2298,2325, 2298, 2329,2325, 2329, 2330,2325, 2330, 2326,
2331, 2328, 2327,2331, 2327, 2332,2331, 2332, 2249,2331, 2249, 2248,
2331, 2248, 2247,2331, 2247, 2295,2331, 2295, 2294,2331, 2294, 2328,
2333, 2334, 2335,2333, 2335, 2336,2333, 2336, 2337,2333, 2337, 2338,
2333, 2338, 2339,2333, 2339, 2340,2333, 2340, 2341,2333, 2341, 2334,
2342, 2336, 2335,2342, 2335, 2343,2342, 2343, 2344,2342, 2344, 2345,
2342, 2345, 2346,2342, 2346, 2347,2342, 2347, 2337,2342, 2337, 2336,
2348, 2349, 2350,2348, 2350, 2351,2348, 2351, 2352,2348, 2352, 2353,
2348, 2353, 2354,2348, 2354, 2355,2348, 2355, 2356,2348, 2356, 2349,
2357, 2351, 2350,2357, 2350, 2358,2357, 2358, 2359,2357, 2359, 2360,
2357, 2360, 2361,2357, 2361, 2362,2357, 2362, 2352,2357, 2352, 2351,
2363, 2364, 2365,2363, 2365, 2366,2363, 2366, 2284,2363, 2284, 2291,
2363, 2291, 2226,2363, 2226, 2225,2363, 2225, 2224,2363, 2224, 2364,
2367, 2366, 2365,2367, 2365, 2368,2367, 2368, 2369,2367, 2369, 2370,
2367, 2370, 2286,2367, 2286, 2285,2367, 2285, 2284,2367, 2284, 2366,
2371, 2372, 2373,2371, 2373, 2374,2371, 2374, 2375,2371, 2375, 2376,
2371, 2376, 2377,2371, 2377, 2378,2371, 2378, 2379,2371, 2379, 2372,
2380, 2374, 2373,2380, 2373, 2381,2380, 2381, 2275,2380, 2275, 2382,
2380, 2382, 2383,2380, 2383, 2384,2380, 2384, 2375,2380, 2375, 2374,
2385, 2381, 2373,2385, 2373, 2386,2385, 2386, 2387,2385, 2387, 2388,
2385, 2388, 2277,2385, 2277, 2276,2385, 2276, 2275,2385, 2275, 2381,
2389, 2386, 2373,2389, 2373, 2372,2389, 2372, 2379,2389, 2379, 2390,
2389, 2390, 2391,2389, 2391, 2392,2389, 2392, 2387,2389, 2387, 2386,
2393, 2394, 2395,2393, 2395, 2396,2393, 2396, 2397,2393, 2397, 2398,
2393, 2398, 2399,2393, 2399, 2400,2393, 2400, 2401,2393, 2401, 2394,
2402, 2396, 2395,2402, 2395, 2403,2402, 2403, 2404,2402, 2404, 2405,
2402, 2405, 2406,2402, 2406, 2407,2402, 2407, 2397,2402, 2397, 2396,
2408, 2409, 2410,2408, 2410, 2411,2408, 2411, 2412,2408, 2412, 2413,
2408, 2413, 2414,2408, 2414, 2415,2408, 2415, 2416,2408, 2416, 2409,
2417, 2411, 2410,2417, 2410, 2418,2417, 2418, 2419,2417, 2419, 2420,
2417, 2420, 2421,2417, 2421, 2422,2417, 2422, 2412,2417, 2412, 2411,
2423, 2424, 2425,2423, 2425, 2426,2423, 2426, 2375,2423, 2375, 2384,
2423, 2384, 2383,2423, 2383, 2427,2423, 2427, 2428,2423, 2428, 2424,
2429, 2426, 2425,2429, 2425, 2430,2429, 2430, 2431,2429, 2431, 2432,
2429, 2432, 2377,2429, 2377, 2376,2429, 2376, 2375,2429, 2375, 2426,
2433, 2434, 2435,2433, 2435, 2436,2433, 2436, 2437,2433, 2437, 2438,
2433, 2438, 2439,2433, 2439, 2440,2433, 2440, 2441,2433, 2441, 2434,
2442, 2443, 2444,2442, 2444, 2445,2442, 2445, 2254,2442, 2254, 2264,
2442, 2264, 2263,2442, 2263, 2446,2442, 2446, 2447,2442, 2447, 2443,
2448, 2449, 2450,2448, 2450, 2451,2448, 2451, 2452,2448, 2452, 2453,
2448, 2453, 2454,2448, 2454, 2455,2448, 2455, 2456,2448, 2456, 2449,
2457, 2458, 2459,2457, 2459, 2460,2457, 2460, 2461,2457, 2461, 2462,
2457, 2462, 2463,2457, 2463, 2464,2457, 2464, 2465,2457, 2465, 2458,
2466, 2460, 2459,2466, 2459, 2467,2466, 2467, 2387,2466, 2387, 2392,
2466, 2392, 2391,2466, 2391, 2468,2466, 2468, 2461,2466, 2461, 2460,
2469, 2467, 2459,2469, 2459, 2470,2469, 2470, 2279,2469, 2279, 2278,
2469, 2278, 2277,2469, 2277, 2388,2469, 2388, 2387,2469, 2387, 2467,
2471, 2472, 2473,2471, 2473, 2474,2471, 2474, 2475,2471, 2475, 2476,
2471, 2476, 2477,2471, 2477, 2478,2471, 2478, 2479,2471, 2479, 2472,
2480, 2474, 2473,2480, 2473, 2481,2480, 2481, 2482,2480, 2482, 2483,
2480, 2483, 2484,2480, 2484, 2485,2480, 2485, 2475,2480, 2475, 2474,
2486, 2481, 2473,2486, 2473, 2487,2486, 2487, 2488,2486, 2488, 2489,
2486, 2489, 2490,2486, 2490, 2491,2486, 2491, 2482,2486, 2482, 2481,
2492, 2487, 2473,2492, 2473, 2472,2492, 2472, 2479,2492, 2479, 2493,
2492, 2493, 2494,2492, 2494, 2495,2492, 2495, 2488,2492, 2488, 2487,
2496, 2497, 2498,2496, 2498, 2499,2496, 2499, 2500,2496, 2500, 2501,
2496, 2501, 2406,2496, 2406, 2405,2496, 2405, 2404,2496, 2404, 2497,
2502, 2499, 2498,2502, 2498, 2503,2502, 2503, 2504,2502, 2504, 2505,
2502, 2505, 2506,2502, 2506, 2507,2502, 2507, 2500,2502, 2500, 2499,
2508, 2509, 2510,2508, 2510, 2511,2508, 2511, 2512,2508, 2512, 2513,
2508, 2513, 2514,2508, 2514, 2515,2508, 2515, 2516,2508, 2516, 2509,
2517, 2511, 2510,2517, 2510, 2518,2517, 2518, 2519,2517, 2519, 2520,
2517, 2520, 2521,2517, 2521, 2522,2517, 2522, 2512,2517, 2512, 2511,
2523, 2524, 2525,2523, 2525, 2526,2523, 2526, 2527,2523, 2527, 2528,
2523, 2528, 2529,2523, 2529, 2530,2523, 2530, 2531,2523, 2531, 2524,
2532, 2533, 2534,2532, 2534, 2535,2532, 2535, 2317,2532, 2317, 2324,
2532, 2324, 2323,2532, 2323, 2536,2532, 2536, 2537,2532, 2537, 2533,
2538, 2535, 2534,2538, 2534, 2539,2538, 2539, 2540,2538, 2540, 2541,
2538, 2541, 2319,2538, 2319, 2318,2538, 2318, 2317,2538, 2317, 2535,
2542, 2543, 2525,2542, 2525, 2524,2542, 2524, 2531,2542, 2531, 2544,
2542, 2544, 2545,2542, 2545, 2546,2542, 2546, 2547,2542, 2547, 2543,
2548, 2549, 2550,2548, 2550, 2551,2548, 2551, 2552,2548, 2552, 2553,
2548, 2553, 2554,2548, 2554, 2555,2548, 2555, 2556,2548, 2556, 2549,
2557, 2551, 2550,2557, 2550, 2558,2557, 2558, 2559,2557, 2559, 2560,
2557, 2560, 2561,2557, 2561, 2562,2557, 2562, 2552,2557, 2552, 2551,
2563, 2558, 2550,2563, 2550, 2564,2563, 2564, 2565,2563, 2565, 2566,
2563, 2566, 2567,2563, 2567, 2568,2563, 2568, 2559,2563, 2559, 2558,
2569, 2564, 2550,2569, 2550, 2549,2569, 2549, 2556,2569, 2556, 2570,
2569, 2570, 2571,2569, 2571, 2572,2569, 2572, 2565,2569, 2565, 2564,
2573, 2574, 2575,2573, 2575, 2576,2573, 2576, 2577,2573, 2577, 2578,
2573, 2578, 2579,2573, 2579, 2580,2573, 2580, 2581,2573, 2581, 2574,
2582, 2583, 2584,2582, 2584, 2585,2582, 2585, 2412,2582, 2412, 2422,
2582, 2422, 2421,2582, 2421, 2586,2582, 2586, 2587,2582, 2587, 2583,
2588, 2585, 2584,2588, 2584, 2589,2588, 2589, 2590,2588, 2590, 2591,
2588, 2591, 2414,2588, 2414, 2413,2588, 2413, 2412,2588, 2412, 2585,
2592, 2593, 2594,2592, 2594, 2595,2592, 2595, 2596,2592, 2596, 2597,
2592, 2597, 2514,2592, 2514, 2513,2592, 2513, 2512,2592, 2512, 2593,
2598, 2599, 2600,2598, 2600, 2601,2598, 2601, 2602,2598, 2602, 2603,
2598, 2603, 2399,2598, 2399, 2398,2598, 2398, 2397,2598, 2397, 2599,
2604, 2601, 2600,2604, 2600, 2605,2604, 2605, 2606,2604, 2606, 2607,
2604, 2607, 2608,2604, 2608, 2609,2604, 2609, 2602,2604, 2602, 2601,
2610, 2605, 2600,2610, 2600, 2611,2610, 2611, 2500,2610, 2500, 2507,
2610, 2507, 2506,2610, 2506, 2612,2610, 2612, 2606,2610, 2606, 2605,
2613, 2611, 2600,2613, 2600, 2599,2613, 2599, 2397,2613, 2397, 2407,
2613, 2407, 2406,2613, 2406, 2501,2613, 2501, 2500,2613, 2500, 2611,
2614, 2615, 2616,2614, 2616, 2617,2614, 2617, 2618,2614, 2618, 2619,
2614, 2619, 2620,2614, 2620, 2621,2614, 2621, 2622,2614, 2622, 2615,
2623, 2617, 2616,2623, 2616, 2624,2623, 2624, 2479,2623, 2479, 2478,
2623, 2478, 2477,2623, 2477, 2625,2623, 2625, 2618,2623, 2618, 2617,
2626, 2624, 2616,2626, 2616, 2627,2626, 2627, 2628,2626, 2628, 2629,
2626, 2629, 2494,2626, 2494, 2493,2626, 2493, 2479,2626, 2479, 2624,
2630, 2627, 2616,2630, 2616, 2615,2630, 2615, 2622,2630, 2622, 2631,
2630, 2631, 2632,2630, 2632, 2633,2630, 2633, 2628,2630, 2628, 2627,
2634, 2635, 2636,2634, 2636, 2637,2634, 2637, 2638,2634, 2638, 2639,
2634, 2639, 2640,2634, 2640, 2641,2634, 2641, 2516,2634, 2516, 2635,
2642, 2637, 2636,2642, 2636, 2643,2642, 2643, 2644,2642, 2644, 2645,
2642, 2645, 2646,2642, 2646, 2647,2642, 2647, 2638,2642, 2638, 2637,
2648, 2643, 2636,2648, 2636, 2649,2648, 2649, 2650,2648, 2650, 2651,
2648, 2651, 2652,2648, 2652, 2653,2648, 2653, 2644,2648, 2644, 2643,
2654, 2649, 2636,2654, 2636, 2635,2654, 2635, 2516,2654, 2516, 2515,
2654, 2515, 2514,2654, 2514, 2655,2654, 2655, 2650,2654, 2650, 2649,
2656, 2657, 2658,2656, 2658, 2659,2656, 2659, 2660,2656, 2660, 2661,
2656, 2661, 2662,2656, 2662, 2663,2656, 2663, 2664,2656, 2664, 2657,
2665, 2659, 2658,2665, 2658, 2666,2665, 2666, 2531,2665, 2531, 2530,
2665, 2530, 2529,2665, 2529, 2667,2665, 2667, 2660,2665, 2660, 2659,
2668, 2666, 2658,2668, 2658, 2669,2668, 2669, 2670,2668, 2670, 2671,
2668, 2671, 2545,2668, 2545, 2544,2668, 2544, 2531,2668, 2531, 2666,
2672, 2669, 2658,2672, 2658, 2657,2672, 2657, 2664,2672, 2664, 2673,
2672, 2673, 2674,2672, 2674, 2675,2672, 2675, 2670,2672, 2670, 2669,
2676, 2677, 2678,2676, 2678, 2679,2676, 2679, 2680,2676, 2680, 2681,
2676, 2681, 2561,2676, 2561, 2560,2676, 2560, 2559,2676, 2559, 2677,
2682, 2679, 2678,2682, 2678, 2683,2682, 2683, 2684,2682, 2684, 2685,
2682, 2685, 2686,2682, 2686, 2687,2682, 2687, 2680,2682, 2680, 2679,
2688, 2683, 2678,2688, 2678, 2689,2688, 2689, 2690,2688, 2690, 2691,
2688, 2691, 2692,2688, 2692, 2693,2688, 2693, 2684,2688, 2684, 2683,
2694, 2689, 2678,2694, 2678, 2677,2694, 2677, 2559,2694, 2559, 2568,
2694, 2568, 2567,2694, 2567, 2695,2694, 2695, 2690,2694, 2690, 2689,
2696, 2697, 2698,2696, 2698, 2699,2696, 2699, 2700,2696, 2700, 2701,
2696, 2701, 2702,2696, 2702, 2703,2696, 2703, 2704,2696, 2704, 2697,
2705, 2699, 2698,2705, 2698, 2706,2705, 2706, 2581,2705, 2581, 2580,
2705, 2580, 2579,2705, 2579, 2707,2705, 2707, 2700,2705, 2700, 2699,
2708, 2709, 2710,2708, 2710, 2711,2708, 2711, 2650,2708, 2650, 2655,
2708, 2655, 2514,2708, 2514, 2597,2708, 2597, 2596,2708, 2596, 2709,
2712, 2711, 2710,2712, 2710, 2713,2712, 2713, 2714,2712, 2714, 2715,
2712, 2715, 2652,2712, 2652, 2651,2712, 2651, 2650,2712, 2650, 2711,
2716, 2717, 2718,2716, 2718, 2719,2716, 2719, 2720,2716, 2720, 2721,
2716, 2721, 2608,2716, 2608, 2607,2716, 2607, 2606,2716, 2606, 2717,
2722, 2719, 2718,2722, 2718, 2723,2722, 2723, 2724,2722, 2724, 2725,
2722, 2725, 2726,2722, 2726, 2727,2722, 2727, 2720,2722, 2720, 2719,
2728, 2723, 2718,2728, 2718, 2729,2728, 2729, 2730,2728, 2730, 2731,
2728, 2731, 2732,2728, 2732, 2733,2728, 2733, 2724,2728, 2724, 2723,
2734, 2729, 2718,2734, 2718, 2717,2734, 2717, 2606,2734, 2606, 2612,
2734, 2612, 2506,2734, 2506, 2735,2734, 2735, 2730,2734, 2730, 2729,
2736, 2737, 2738,2736, 2738, 2739,2736, 2739, 2740,2736, 2740, 2741,
2736, 2741, 2391,2736, 2391, 2390,2736, 2390, 2379,2736, 2379, 2737,
2742, 2739, 2738,2742, 2738, 2743,2742, 2743, 2744,2742, 2744, 2745,
2742, 2745, 2746,2742, 2746, 2747,2742, 2747, 2740,2742, 2740, 2739,
2748, 2743, 2738,2748, 2738, 2749,2748, 2749, 2750,2748, 2750, 2751,
2748, 2751, 2752,2748, 2752, 2753,2748, 2753, 2744,2748, 2744, 2743,
2754, 2749, 2738,2754, 2738, 2737,2754, 2737, 2379,2754, 2379, 2378,
2754, 2378, 2377,2754, 2377, 2755,2754, 2755, 2750,2754, 2750, 2749,
2756, 2757, 2758,2756, 2758, 2759,2756, 2759, 2760,2756, 2760, 2761,
2756, 2761, 2746,2756, 2746, 2745,2756, 2745, 2744,2756, 2744, 2757,
2762, 2759, 2758,2762, 2758, 2763,2762, 2763, 2288,2762, 2288, 2287,
2762, 2287, 2286,2762, 2286, 2764,2762, 2764, 2760,2762, 2760, 2759,
2765, 2763, 2758,2765, 2758, 2766,2765, 2766, 2767,2765, 2767, 2768,
2765, 2768, 2298,2765, 2298, 2297,2765, 2297, 2288,2765, 2288, 2763,
2769, 2766, 2758,2769, 2758, 2757,2769, 2757, 2744,2769, 2744, 2753,
2769, 2753, 2752,2769, 2752, 2770,2769, 2770, 2767,2769, 2767, 2766,
2771, 2772, 2773,2771, 2773, 2774,2771, 2774, 2775,2771, 2775, 2776,
2771, 2776, 2571,2771, 2571, 2777,2771, 2777, 2778,2771, 2778, 2772,
2779, 2774, 2773,2779, 2773, 2780,2779, 2780, 2781,2779, 2781, 2782,
2779, 2782, 2783,2779, 2783, 2784,2779, 2784, 2775,2779, 2775, 2774,
2785, 2786, 2787,2785, 2787, 2788,2785, 2788, 2789,2785, 2789, 2790,
2785, 2790, 2791,2785, 2791, 2792,2785, 2792, 2793,2785, 2793, 2786,
2794, 2788, 2787,2794, 2787, 2795,2794, 2795, 2311,2794, 2311, 2320,
2794, 2320, 2319,2794, 2319, 2796,2794, 2796, 2789,2794, 2789, 2788,
2797, 2798, 2799,2797, 2799, 2800,2797, 2800, 2801,2797, 2801, 2802,
2797, 2802, 2783,2797, 2783, 2782,2797, 2782, 2781,2797, 2781, 2798,
2803, 2800, 2799,2803, 2799, 2804,2803, 2804, 2401,2803, 2401, 2400,
2803, 2400, 2399,2803, 2399, 2805,2803, 2805, 2801,2803, 2801, 2800,
2806, 2807, 2808,2806, 2808, 2809,2806, 2809, 2810,2806, 2810, 2811,
2806, 2811, 2421,2806, 2421, 2420,2806, 2420, 2419,2806, 2419, 2807,
2812, 2809, 2808,2812, 2808, 2813,2812, 2813, 2793,2812, 2793, 2792,
2812, 2792, 2791,2812, 2791, 2814,2812, 2814, 2810,2812, 2810, 2809,
2815, 2816, 2817,2815, 2817, 2818,2815, 2818, 2750,2815, 2750, 2755,
2815, 2755, 2377,2815, 2377, 2432,2815, 2432, 2431,2815, 2431, 2816,
2819, 2818, 2817,2819, 2817, 2820,2819, 2820, 2821,2819, 2821, 2822,
2819, 2822, 2752,2819, 2752, 2751,2819, 2751, 2750,2819, 2750, 2818,
2823, 2824, 2825,2823, 2825, 2826,2823, 2826, 2827,2823, 2827, 2828,
2823, 2828, 2829,2823, 2829, 2830,2823, 2830, 2831,2823, 2831, 2824,
2832, 2826, 2825,2832, 2825, 2833,2832, 2833, 2441,2832, 2441, 2440,
2832, 2440, 2439,2832, 2439, 2834,2832, 2834, 2827,2832, 2827, 2826,
2835, 2836, 2837,2835, 2837, 2838,2835, 2838, 2767,2835, 2767, 2770,
2835, 2770, 2752,2835, 2752, 2822,2835, 2822, 2821,2835, 2821, 2836,
2839, 2838, 2837,2839, 2837, 2840,2839, 2840, 2330,2839, 2330, 2329,
2839, 2329, 2298,2839, 2298, 2768,2839, 2768, 2767,2839, 2767, 2838,
2841, 2842, 2843,2841, 2843, 2844,2841, 2844, 2845,2841, 2845, 2846,
2841, 2846, 2346,2841, 2346, 2345,2841, 2345, 2344,2841, 2344, 2842,
2847, 2844, 2843,2847, 2843, 2848,2847, 2848, 2831,2847, 2831, 2830,
2847, 2830, 2829,2847, 2829, 2849,2847, 2849, 2845,2847, 2845, 2844,
2850, 2851, 2852,2850, 2852, 2853,2850, 2853, 2854,2850, 2854, 2855,
2850, 2855, 2463,2850, 2463, 2462,2850, 2462, 2461,2850, 2461, 2851,
2856, 2853, 2852,2856, 2852, 2857,2856, 2857, 2858,2856, 2858, 2859,
2856, 2859, 2860,2856, 2860, 2861,2856, 2861, 2854,2856, 2854, 2853,
2862, 2857, 2852,2862, 2852, 2863,2862, 2863, 2740,2862, 2740, 2747,
2862, 2747, 2746,2862, 2746, 2864,2862, 2864, 2858,2862, 2858, 2857,
2865, 2863, 2852,2865, 2852, 2851,2865, 2851, 2461,2865, 2461, 2468,
2865, 2468, 2391,2865, 2391, 2741,2865, 2741, 2740,2865, 2740, 2863,
2866, 2867, 2868,2866, 2868, 2869,2866, 2869, 2870,2866, 2870, 2871,
2866, 2871, 2860,2866, 2860, 2859,2866, 2859, 2858,2866, 2858, 2867,
2872, 2869, 2868,2872, 2868, 2873,2872, 2873, 2369,2872, 2369, 2874,
2872, 2874, 2875,2872, 2875, 2876,2872, 2876, 2870,2872, 2870, 2869,
2877, 2873, 2868,2877, 2868, 2878,2877, 2878, 2760,2877, 2760, 2764,
2877, 2764, 2286,2877, 2286, 2370,2877, 2370, 2369,2877, 2369, 2873,
2879, 2878, 2868,2879, 2868, 2867,2879, 2867, 2858,2879, 2858, 2864,
2879, 2864, 2746,2879, 2746, 2761,2879, 2761, 2760,2879, 2760, 2878,
2880, 2881, 2882,2880, 2882, 2883,2880, 2883, 2789,2880, 2789, 2796,
2880, 2796, 2319,2880, 2319, 2541,2880, 2541, 2540,2880, 2540, 2881,
2884, 2883, 2882,2884, 2882, 2885,2884, 2885, 2886,2884, 2886, 2887,
2884, 2887, 2791,2884, 2791, 2790,2884, 2790, 2789,2884, 2789, 2883,
2888, 2889, 2890,2888, 2890, 2891,2888, 2891, 2892,2888, 2892, 2893,
2888, 2893, 2894,2888, 2894, 2895,2888, 2895, 2896,2888, 2896, 2889,
2897, 2891, 2890,2897, 2890, 2898,2897, 2898, 2547,2897, 2547, 2546,
2897, 2546, 2545,2897, 2545, 2899,2897, 2899, 2892,2897, 2892, 2891,
2900, 2901, 2902,2900, 2902, 2903,2900, 2903, 2810,2900, 2810, 2814,
2900, 2814, 2791,2900, 2791, 2887,2900, 2887, 2886,2900, 2886, 2901,
2904, 2903, 2902,2904, 2902, 2905,2904, 2905, 2587,2904, 2587, 2586,
2904, 2586, 2421,2904, 2421, 2811,2904, 2811, 2810,2904, 2810, 2903,
2906, 2907, 2908,2906, 2908, 2909,2906, 2909, 2910,2906, 2910, 2911,
2906, 2911, 2579,2906, 2579, 2578,2906, 2578, 2577,2906, 2577, 2907,
2912, 2909, 2908,2912, 2908, 2913,2912, 2913, 2896,2912, 2896, 2895,
2912, 2895, 2894,2912, 2894, 2914,2912, 2914, 2910,2912, 2910, 2909,
2915, 2916, 2917,2915, 2917, 2918,2915, 2918, 2919,2915, 2919, 2920,
2915, 2920, 2567,2915, 2567, 2566,2915, 2566, 2565,2915, 2565, 2916,
2921, 2918, 2917,2921, 2917, 2922,2921, 2922, 2923,2921, 2923, 2924,
2921, 2924, 2925,2921, 2925, 2926,2921, 2926, 2919,2921, 2919, 2918,
2927, 2922, 2917,2927, 2917, 2928,2927, 2928, 2775,2927, 2775, 2784,
2927, 2784, 2783,2927, 2783, 2929,2927, 2929, 2923,2927, 2923, 2922,
2930, 2928, 2917,2930, 2917, 2916,2930, 2916, 2565,2930, 2565, 2572,
2930, 2572, 2571,2930, 2571, 2776,2930, 2776, 2775,2930, 2775, 2928,
2931, 2932, 2933,2931, 2933, 2934,2931, 2934, 2935,2931, 2935, 2936,
2931, 2936, 2925,2931, 2925, 2924,2931, 2924, 2923,2931, 2923, 2932,
2937, 2934, 2933,2937, 2933, 2938,2937, 2938, 2602,2937, 2602, 2609,
2937, 2609, 2608,2937, 2608, 2939,2937, 2939, 2935,2937, 2935, 2934,
2940, 2938, 2933,2940, 2933, 2941,2940, 2941, 2801,2940, 2801, 2805,
2940, 2805, 2399,2940, 2399, 2603,2940, 2603, 2602,2940, 2602, 2938,
2942, 2941, 2933,2942, 2933, 2932,2942, 2932, 2923,2942, 2923, 2929,
2942, 2929, 2783,2942, 2783, 2802,2942, 2802, 2801,2942, 2801, 2941,
2943, 2944, 2945,2943, 2945, 2946,2943, 2946, 2892,2943, 2892, 2899,
2943, 2899, 2545,2943, 2545, 2671,2943, 2671, 2670,2943, 2670, 2944,
2947, 2946, 2945,2947, 2945, 2948,2947, 2948, 2949,2947, 2949, 2950,
2947, 2950, 2894,2947, 2894, 2893,2947, 2893, 2892,2947, 2892, 2946,
2951, 2948, 2945,2951, 2945, 2952,2951, 2952, 2953,2951, 2953, 2954,
2951, 2954, 2955,2951, 2955, 2956,2951, 2956, 2949,2951, 2949, 2948,
2957, 2952, 2945,2957, 2945, 2944,2957, 2944, 2670,2957, 2670, 2675,
2957, 2675, 2674,2957, 2674, 2958,2957, 2958, 2953,2957, 2953, 2952,
2959, 2960, 2961,2959, 2961, 2962,2959, 2962, 2910,2959, 2910, 2914,
2959, 2914, 2894,2959, 2894, 2950,2959, 2950, 2949,2959, 2949, 2960,
2963, 2962, 2961,2963, 2961, 2964,2963, 2964, 2700,2963, 2700, 2707,
2963, 2707, 2579,2963, 2579, 2911,2963, 2911, 2910,2963, 2910, 2962,
2965, 2964, 2961,2965, 2961, 2966,2965, 2966, 2967,2965, 2967, 2968,
2965, 2968, 2702,2965, 2702, 2701,2965, 2701, 2700,2965, 2700, 2964,
2969, 2966, 2961,2969, 2961, 2960,2969, 2960, 2949,2969, 2949, 2956,
2969, 2956, 2955,2969, 2955, 2970,2969, 2970, 2967,2969, 2967, 2966,
2971, 2972, 2973,2971, 2973, 2974,2971, 2974, 2975,2971, 2975, 2976,
2971, 2976, 2692,2971, 2692, 2691,2971, 2691, 2690,2971, 2690, 2972,
2977, 2974, 2973,2977, 2973, 2978,2977, 2978, 2979,2977, 2979, 2980,
2977, 2980, 2981,2977, 2981, 2982,2977, 2982, 2975,2977, 2975, 2974,
2983, 2978, 2973,2983, 2973, 2984,2983, 2984, 2919,2983, 2919, 2926,
2983, 2926, 2925,2983, 2925, 2985,2983, 2985, 2979,2983, 2979, 2978,
2986, 2984, 2973,2986, 2973, 2972,2986, 2972, 2690,2986, 2690, 2695,
2986, 2695, 2567,2986, 2567, 2920,2986, 2920, 2919,2986, 2919, 2984,
2987, 2988, 2989,2987, 2989, 2990,2987, 2990, 2991,2987, 2991, 2992,
2987, 2992, 2981,2987, 2981, 2980,2987, 2980, 2979,2987, 2979, 2988,
2993, 2990, 2989,2993, 2989, 2994,2993, 2994, 2720,2993, 2720, 2727,
2993, 2727, 2726,2993, 2726, 2995,2993, 2995, 2991,2993, 2991, 2990,
2996, 2994, 2989,2996, 2989, 2997,2996, 2997, 2935,2996, 2935, 2939,
2996, 2939, 2608,2996, 2608, 2721,2996, 2721, 2720,2996, 2720, 2994,
2998, 2997, 2989,2998, 2989, 2988,2998, 2988, 2979,2998, 2979, 2985,
2998, 2985, 2925,2998, 2925, 2936,2998, 2936, 2935,2998, 2935, 2997,
2999, 3000, 3001,2999, 3001, 3002,2999, 3002, 3003,2999, 3003, 3004,
2999, 3004, 2235,2999, 2235, 2234,2999, 2234, 2233,2999, 2233, 3000,
3005, 3002, 3001,3005, 3001, 3006,3005, 3006, 3007,3005, 3007, 3008,
3005, 3008, 3009,3005, 3009, 3010,3005, 3010, 3003,3005, 3003, 3002,
3011, 3006, 3001,3011, 3001, 3012,3011, 3012, 3013,3011, 3013, 3014,
3011, 3014, 3015,3011, 3015, 3016,3011, 3016, 3007,3011, 3007, 3006,
3017, 3012, 3001,3017, 3001, 3000,3017, 3000, 2233,3017, 2233, 2243,
3017, 2243, 2242,3017, 2242, 3018,3017, 3018, 3013,3017, 3013, 3012,
3019, 3020, 3021,3019, 3021, 3022,3019, 3022, 3023,3019, 3023, 3024,
3019, 3024, 3009,3019, 3009, 3008,3019, 3008, 3007,3019, 3007, 3020,
3025, 3022, 3021,3025, 3021, 3026,3025, 3026, 2622,3025, 2622, 2621,
3025, 2621, 2620,3025, 2620, 3027,3025, 3027, 3023,3025, 3023, 3022,
3028, 3026, 3021,3028, 3021, 3029,3028, 3029, 3030,3028, 3030, 3031,
3028, 3031, 2632,3028, 2632, 2631,3028, 2631, 2622,3028, 2622, 3026,
3032, 3029, 3021,3032, 3021, 3020,3032, 3020, 3007,3032, 3007, 3016,
3032, 3016, 3015,3032, 3015, 3033,3032, 3033, 3030,3032, 3030, 3029,
3034, 3035, 3036,3034, 3036, 3037,3034, 3037, 3038,3034, 3038, 3039,
3034, 3039, 2646,3034, 2646, 2645,3034, 2645, 2644,3034, 2644, 3035,
3040, 3037, 3036,3040, 3036, 3041,3040, 3041, 3042,3040, 3042, 3043,
3040, 3043, 3044,3040, 3044, 3045,3040, 3045, 3038,3040, 3038, 3037,
3046, 3041, 3036,3046, 3036, 3047,3046, 3047, 3048,3046, 3048, 3049,
3046, 3049, 3050,3046, 3050, 3051,3046, 3051, 3042,3046, 3042, 3041,
3052, 3047, 3036,3052, 3036, 3035,3052, 3035, 2644,3052, 2644, 2653,
3052, 2653, 2652,3052, 2652, 3053,3052, 3053, 3048,3052, 3048, 3047,
3054, 3055, 3056,3054, 3056, 3057,3054, 3057, 3058,3054, 3058, 3059,
3054, 3059, 3044,3054, 3044, 3043,3054, 3043, 3042,3054, 3042, 3055,
3060, 3057, 3056,3060, 3056, 3061,3060, 3061, 2261,3060, 2261, 2270,
3060, 2270, 2269,3060, 2269, 3062,3060, 3062, 3058,3060, 3058, 3057,
3063, 3061, 3056,3063, 3056, 3064,3063, 3064, 3065,3063, 3065, 3066,
3063, 3066, 2263,3063, 2263, 2262,3063, 2262, 2261,3063, 2261, 3061,
3067, 3064, 3056,3067, 3056, 3055,3067, 3055, 3042,3067, 3042, 3051,
3067, 3051, 3050,3067, 3050, 3068,3067, 3068, 3065,3067, 3065, 3064,
3069, 3070, 3071,3069, 3071, 3072,3069, 3072, 3073,3069, 3073, 3074,
3069, 3074, 2339,3069, 2339, 2338,3069, 2338, 2337,3069, 2337, 3070,
3075, 3072, 3071,3075, 3071, 3076,3075, 3076, 3077,3075, 3077, 3078,
3075, 3078, 3079,3075, 3079, 3080,3075, 3080, 3073,3075, 3073, 3072,
3081, 3076, 3071,3081, 3071, 3082,3081, 3082, 3083,3081, 3083, 3084,
3081, 3084, 3085,3081, 3085, 3086,3081, 3086, 3077,3081, 3077, 3076,
3087, 3082, 3071,3087, 3071, 3070,3087, 3070, 2337,3087, 2337, 2347,
3087, 2347, 2346,3087, 2346, 3088,3087, 3088, 3083,3087, 3083, 3082,
3089, 3090, 3091,3089, 3091, 3092,3089, 3092, 3093,3089, 3093, 3094,
3089, 3094, 3079,3089, 3079, 3078,3089, 3078, 3077,3089, 3077, 3090,
3095, 3092, 3091,3095, 3091, 3096,3095, 3096, 2664,3095, 2664, 2663,
3095, 2663, 2662,3095, 2662, 3097,3095, 3097, 3093,3095, 3093, 3092,
3098, 3096, 3091,3098, 3091, 3099,3098, 3099, 3100,3098, 3100, 3101,
3098, 3101, 2674,3098, 2674, 2673,3098, 2673, 2664,3098, 2664, 3096,
3102, 3099, 3091,3102, 3091, 3090,3102, 3090, 3077,3102, 3077, 3086,
3102, 3086, 3085,3102, 3085, 3103,3102, 3103, 3100,3102, 3100, 3099,
3104, 3105, 3106,3104, 3106, 3107,3104, 3107, 3108,3104, 3108, 3109,
3104, 3109, 2686,3104, 2686, 2685,3104, 2685, 2684,3104, 2684, 3105,
3110, 3107, 3106,3110, 3106, 3111,3110, 3111, 3112,3110, 3112, 3113,
3110, 3113, 3114,3110, 3114, 3115,3110, 3115, 3108,3110, 3108, 3107,
3116, 3111, 3106,3116, 3106, 3117,3116, 3117, 3118,3116, 3118, 3119,
3116, 3119, 3120,3116, 3120, 3121,3116, 3121, 3112,3116, 3112, 3111,
3122, 3117, 3106,3122, 3106, 3105,3122, 3105, 2684,3122, 2684, 2693,
3122, 2693, 2692,3122, 2692, 3123,3122, 3123, 3118,3122, 3118, 3117,
3124, 3125, 3126,3124, 3126, 3127,3124, 3127, 3128,3124, 3128, 3129,
3124, 3129, 3114,3124, 3114, 3113,3124, 3113, 3112,3124, 3112, 3125,
3130, 3131, 3132,3130, 3132, 3133,3130, 3133, 3134,3130, 3134, 3135,
3130, 3135, 2235,3130, 2235, 3004,3130, 3004, 3003,3130, 3003, 3131,
3136, 3137, 3126,3136, 3126, 3138,3136, 3138, 3139,3136, 3139, 3140,
3136, 3140, 2354,3136, 2354, 2353,3136, 2353, 2352,3136, 2352, 3137,
3141, 3138, 3126,3141, 3126, 3125,3141, 3125, 3112,3141, 3112, 3121,
3141, 3121, 3120,3141, 3120, 3142,3141, 3142, 3139,3141, 3139, 3138,
3143, 3144, 3145,3143, 3145, 3146,3143, 3146, 3147,3143, 3147, 3148,
3143, 3148, 2439,3143, 2439, 2438,3143, 2438, 2437,3143, 2437, 3144,
3149, 3146, 3145,3149, 3145, 3150,3149, 3150, 3151,3149, 3151, 3152,
3149, 3152, 3153,3149, 3153, 3154,3149, 3154, 3147,3149, 3147, 3146,
3155, 3156, 3157,3155, 3157, 3158,3155, 3158, 3065,3155, 3065, 3068,
3155, 3068, 3050,3155, 3050, 3159,3155, 3159, 3160,3155, 3160, 3156,
3161, 3158, 3157,3161, 3157, 3162,3161, 3162, 2447,3161, 2447, 2446,
3161, 2446, 2263,3161, 2263, 3066,3161, 3066, 3065,3161, 3065, 3158,
3163, 3164, 3165,3163, 3165, 3166,3163, 3166, 3167,3163, 3167, 3168,
3163, 3168, 3153,3163, 3153, 3152,3163, 3152, 3151,3163, 3151, 3164,
3169, 3166, 3165,3169, 3165, 3170,3169, 3170, 2704,3169, 2704, 2703,
3169, 2703, 2702,3169, 2702, 3171,3169, 3171, 3167,3169, 3167, 3166,
3172, 3173, 3174,3172, 3174, 3175,3172, 3175, 3048,3172, 3048, 3053,
3172, 3053, 2652,3172, 2652, 2715,3172, 2715, 2714,3172, 2714, 3173,
3176, 3175, 3174,3176, 3174, 3177,3176, 3177, 3160,3176, 3160, 3159,
3176, 3159, 3050,3176, 3050, 3049,3176, 3049, 3048,3176, 3048, 3175,
3178, 3179, 3180,3178, 3180, 3181,3178, 3181, 3182,3178, 3182, 3183,
3178, 3183, 2726,3178, 2726, 2725,3178, 2725, 2724,3178, 2724, 3179,
3184, 3181, 3180,3184, 3180, 3185,3184, 3185, 3186,3184, 3186, 3187,
3184, 3187, 3188,3184, 3188, 3189,3184, 3189, 3182,3184, 3182, 3181,
3190, 3185, 3180,3190, 3180, 3191,3190, 3191, 3192,3190, 3192, 3193,
3190, 3193, 3194,3190, 3194, 3195,3190, 3195, 3186,3190, 3186, 3185,
3196, 3191, 3180,3196, 3180, 3179,3196, 3179, 2724,3196, 2724, 2733,
3196, 2733, 2732,3196, 2732, 3197,3196, 3197, 3192,3196, 3192, 3191,
3198, 3199, 3200,3198, 3200, 3201,3198, 3201, 3202,3198, 3202, 3203,
3198, 3203, 3188,3198, 3188, 3187,3198, 3187, 3186,3198, 3186, 3199,
3204, 3201, 3200,3204, 3200, 3205,3204, 3205, 3206,3204, 3206, 3207,
3204, 3207, 3208,3204, 3208, 3209,3204, 3209, 3202,3204, 3202, 3201,
3210, 3211, 3212,3210, 3212, 3213,3210, 3213, 3214,3210, 3214, 3215,
3210, 3215, 3216,3210, 3216, 3217,3210, 3217, 3218,3210, 3218, 3211,
3219, 3220, 3200,3219, 3200, 3199,3219, 3199, 3186,3219, 3186, 3195,
3219, 3195, 3194,3219, 3194, 3221,3219, 3221, 3222,3219, 3222, 3220,
3223, 3224, 3225,3223, 3225, 3226,3223, 3226, 3227,3223, 3227, 3228,
3223, 3228, 2955,3223, 2955, 2954,3223, 2954, 2953,3223, 2953, 3224,
3229, 3226, 3225,3229, 3225, 3230,3229, 3230, 3231,3229, 3231, 3232,
3229, 3232, 3233,3229, 3233, 3234,3229, 3234, 3227,3229, 3227, 3226,
3235, 3230, 3225,3235, 3225, 3236,3235, 3236, 3100,3235, 3100, 3103,
3235, 3103, 3085,3235, 3085, 3237,3235, 3237, 3231,3235, 3231, 3230,
3238, 3236, 3225,3238, 3225, 3224,3238, 3224, 2953,3238, 2953, 2958,
3238, 2958, 2674,3238, 2674, 3101,3238, 3101, 3100,3238, 3100, 3236,
3239, 3240, 3241,3239, 3241, 3242,3239, 3242, 3243,3239, 3243, 3244,
3239, 3244, 3233,3239, 3233, 3232,3239, 3232, 3231,3239, 3231, 3240,
3245, 3242, 3241,3245, 3241, 3246,3245, 3246, 2845,3245, 2845, 2849,
3245, 2849, 2829,3245, 2829, 3247,3245, 3247, 3243,3245, 3243, 3242,
3248, 3246, 3241,3248, 3241, 3249,3248, 3249, 3083,3248, 3083, 3088,
3248, 3088, 2346,3248, 2346, 2846,3248, 2846, 2845,3248, 2845, 3246,
3250, 3249, 3241,3250, 3241, 3240,3250, 3240, 3231,3250, 3231, 3237,
3250, 3237, 3085,3250, 3085, 3084,3250, 3084, 3083,3250, 3083, 3249,
3251, 3252, 3253,3251, 3253, 3254,3251, 3254, 3167,3251, 3167, 3171,
3251, 3171, 2702,3251, 2702, 2968,3251, 2968, 2967,3251, 2967, 3252,
3255, 3254, 3253,3255, 3253, 3256,3255, 3256, 3257,3255, 3257, 3258,
3255, 3258, 3153,3255, 3153, 3168,3255, 3168, 3167,3255, 3167, 3254,
3259, 3256, 3253,3259, 3253, 3260,3259, 3260, 3227,3259, 3227, 3234,
3259, 3234, 3233,3259, 3233, 3261,3259, 3261, 3257,3259, 3257, 3256,
3262, 3260, 3253,3262, 3253, 3252,3262, 3252, 2967,3262, 2967, 2970,
3262, 2970, 2955,3262, 2955, 3228,3262, 3228, 3227,3262, 3227, 3260,
3263, 3264, 3265,3263, 3265, 3266,3263, 3266, 3147,3263, 3147, 3154,
3263, 3154, 3153,3263, 3153, 3258,3263, 3258, 3257,3263, 3257, 3264,
3267, 3266, 3265,3267, 3265, 3268,3267, 3268, 2827,3267, 2827, 2834,
3267, 2834, 2439,3267, 2439, 3148,3267, 3148, 3147,3267, 3147, 3266,
3269, 3268, 3265,3269, 3265, 3270,3269, 3270, 3243,3269, 3243, 3247,
3269, 3247, 2829,3269, 2829, 2828,3269, 2828, 2827,3269, 2827, 3268,
3271, 3270, 3265,3271, 3265, 3264,3271, 3264, 3257,3271, 3257, 3261,
3271, 3261, 3233,3271, 3233, 3244,3271, 3244, 3243,3271, 3243, 3270,
3272, 3273, 3274,3272, 3274, 3275,3272, 3275, 3276,3272, 3276, 3277,
3272, 3277, 3278,3272, 3278, 3279,3272, 3279, 3280,3272, 3280, 3273,
3281, 3275, 3274,3281, 3274, 3282,3281, 3282, 3283,3281, 3283, 3284,
3281, 3284, 3285,3281, 3285, 3286,3281, 3286, 3276,3281, 3276, 3275,
3287, 3282, 3274,3287, 3274, 3288,3287, 3288, 3139,3287, 3139, 3142,
3287, 3142, 3120,3287, 3120, 3289,3287, 3289, 3283,3287, 3283, 3282,
3290, 3288, 3274,3290, 3274, 3273,3290, 3273, 3280,3290, 3280, 3291,
3290, 3291, 2354,3290, 2354, 3140,3290, 3140, 3139,3290, 3139, 3288,
3292, 3293, 3294,3292, 3294, 3295,3292, 3295, 3296,3292, 3296, 3297,
3292, 3297, 3285,3292, 3285, 3284,3292, 3284, 3283,3292, 3283, 3293,
3298, 3295, 3294,3298, 3294, 3299,3298, 3299, 2975,3298, 2975, 2982,
3298, 2982, 2981,3298, 2981, 3300,3298, 3300, 3296,3298, 3296, 3295,
3301, 3299, 3294,3301, 3294, 3302,3301, 3302, 3118,3301, 3118, 3123,
3301, 3123, 2692,3301, 2692, 2976,3301, 2976, 2975,3301, 2975, 3299,
3303, 3302, 3294,3303, 3294, 3293,3303, 3293, 3283,3303, 3283, 3289,
3303, 3289, 3120,3303, 3120, 3119,3303, 3119, 3118,3303, 3118, 3302,
3304, 3305, 3306,3304, 3306, 3307,3304, 3307, 3202,3304, 3202, 3209,
3304, 3209, 3208,3304, 3208, 3308,3304, 3308, 3309,3304, 3309, 3305,
3310, 3307, 3306,3310, 3306, 3311,3310, 3311, 3312,3310, 3312, 3313,
3310, 3313, 3188,3310, 3188, 3203,3310, 3203, 3202,3310, 3202, 3307,
3314, 3311, 3306,3314, 3306, 3315,3314, 3315, 3276,3314, 3276, 3286,
3314, 3286, 3285,3314, 3285, 3316,3314, 3316, 3312,3314, 3312, 3311,
3317, 3315, 3306,3317, 3306, 3305,3317, 3305, 3309,3317, 3309, 3318,
3317, 3318, 3278,3317, 3278, 3277,3317, 3277, 3276,3317, 3276, 3315,
3319, 3320, 3321,3319, 3321, 3322,3319, 3322, 3182,3319, 3182, 3189,
3319, 3189, 3188,3319, 3188, 3313,3319, 3313, 3312,3319, 3312, 3320,
3323, 3322, 3321,3323, 3321, 3324,3323, 3324, 2991,3323, 2991, 2995,
3323, 2995, 2726,3323, 2726, 3183,3323, 3183, 3182,3323, 3182, 3322,
3325, 3324, 3321,3325, 3321, 3326,3325, 3326, 3296,3325, 3296, 3300,
3325, 3300, 2981,3325, 2981, 2992,3325, 2992, 2991,3325, 2991, 3324,
3327, 3326, 3321,3327, 3321, 3320,3327, 3320, 3312,3327, 3312, 3316,
3327, 3316, 3285,3327, 3285, 3297,3327, 3297, 3296,3327, 3296, 3326,
3328, 3329, 3330,3328, 3330, 3331,3328, 3331, 3332,3328, 3332, 3333,
3328, 3333, 3334,3328, 3334, 3329,3335, 3336, 3330,3335, 3330, 3337,
3335, 3337, 3338,3335, 3338, 3339,3335, 3339, 3340,3335, 3340, 3336,
3341, 3342, 3330,3341, 3330, 3343,3341, 3343, 3344,3341, 3344, 3345,
3341, 3345, 3346,3341, 3346, 3342,3347, 3348, 3330,3347, 3330, 3349,
3347, 3349, 3350,3347, 3350, 3351,3347, 3351, 3352,3347, 3352, 3348,
3353, 3354, 3330,3353, 3330, 3355,3353, 3355, 3356,3353, 3356, 3357,
3353, 3357, 3358,3353, 3358, 3354,3359, 3360, 3330,3359, 3330, 3361,
3359, 3361, 3362,3359, 3362, 3363,3359, 3363, 3364,3359, 3364, 3360,
3365, 3366, 3330,3365, 3330, 3367,3365, 3367, 3368,3365, 3368, 3369,
3365, 3369, 3370,3365, 3370, 3366,3371, 3372, 3330,3371, 3330, 3373,
3371, 3373, 3374,3371, 3374, 3375,3371, 3375, 3376,3371, 3376, 3372,
3377, 3378, 3330,3377, 3330, 3379,3377, 3379, 3380,3377, 3380, 3381,
3377, 3381, 3382,3377, 3382, 3378,3383, 3384, 3330,3383, 3330, 3385,
3383, 3385, 3386,3383, 3386, 3387,3383, 3387, 3388,3383, 3388, 3384,
3389, 3390, 3330,3389, 3330, 3391,3389, 3391, 3392,3389, 3392, 3393,
3389, 3393, 3394,3389, 3394, 3390,3395, 3396, 3330,3395, 3330, 3397,
3395, 3397, 3398,3395, 3398, 3399,3395, 3399, 3400,3395, 3400, 3396,
3401, 3402, 3330,3401, 3330, 3403,3401, 3403, 3404,3401, 3404, 3405,
3401, 3405, 3406,3401, 3406, 3402,3407, 3408, 3330,3407, 3330, 3409,
3407, 3409, 3410,3407, 3410, 3411,3407, 3411, 3412,3407, 3412, 3408,
3413, 3414, 3330,3413, 3330, 3415,3413, 3415, 3416,3413, 3416, 3417,
3413, 3417, 3418,3413, 3418, 3414,3419, 3414, 3420,3419, 3420, 3421,
3419, 3421, 3332,3419, 3332, 3422,3419, 3422, 3423,3419, 3423, 3414,
3424, 3425, 3426,3424, 3426, 3427,3424, 3427, 3428,3424, 3428, 3429,
3424, 3429, 3430,3424, 3430, 3431,3424, 3431, 3432,3424, 3432, 3425,
3433, 3434, 3435,3433, 3435, 3436,3433, 3436, 3437,3433, 3437, 3438,
3433, 3438, 3439,3433, 3439, 3440,3433, 3440, 3441,3433, 3441, 3434,
3442, 3443, 3444,3442, 3444, 3445,3442, 3445, 3446,3442, 3446, 3447,
3442, 3447, 3448,3442, 3448, 3449,3442, 3449, 3450,3442, 3450, 3443,
3451, 3452, 3453,3451, 3453, 3454,3451, 3454, 3455,3451, 3455, 3456,
3451, 3456, 3457,3451, 3457, 3458,3451, 3458, 3459,3451, 3459, 3452,
3460, 3461, 3462,3460, 3462, 3463,3460, 3463, 3464,3460, 3464, 3465,
3460, 3465, 3466,3460, 3466, 3467,3460, 3467, 3468,3460, 3468, 3461,
3469, 3470, 3471,3469, 3471, 3472,3469, 3472, 3473,3469, 3473, 3474,
3469, 3474, 3475,3469, 3475, 3476,3469, 3476, 3477,3469, 3477, 3470,
3478, 3479, 3480,3478, 3480, 3481,3478, 3481, 3482,3478, 3482, 3483,
3478, 3483, 3484,3478, 3484, 3485,3478, 3485, 3486,3478, 3486, 3479,
3487, 3488, 3489,3487, 3489, 3490,3487, 3490, 3491,3487, 3491, 3492,
3487, 3492, 3493,3487, 3493, 3494,3487, 3494, 3495,3487, 3495, 3488,
3496, 3497, 3498,3496, 3498, 3499,3496, 3499, 3500,3496, 3500, 3501,
3496, 3501, 3502,3496, 3502, 3503,3496, 3503, 3504,3496, 3504, 3497,
3505, 3506, 3507,3505, 3507, 3508,3505, 3508, 3509,3505, 3509, 3510,
3505, 3510, 3511,3505, 3511, 3512,3505, 3512, 3513,3505, 3513, 3506,
3514, 3515, 3516,3514, 3516, 3517,3514, 3517, 3518,3514, 3518, 3519,
3514, 3519, 3520,3514, 3520, 3521,3514, 3521, 3522,3514, 3522, 3515,
3523, 3524, 3525,3523, 3525, 3526,3523, 3526, 3527,3523, 3527, 3528,
3523, 3528, 3529,3523, 3529, 3530,3523, 3530, 3531,3523, 3531, 3524,
3532, 3533, 3534,3532, 3534, 3535,3532, 3535, 3536,3532, 3536, 3537,
3532, 3537, 3538,3532, 3538, 3539,3532, 3539, 3540,3532, 3540, 3533,
3541, 3542, 3543,3541, 3543, 3544,3541, 3544, 3545,3541, 3545, 3546,
3541, 3546, 3547,3541, 3547, 3548,3541, 3548, 3549,3541, 3549, 3542,
3550, 3551, 3552,3550, 3552, 3553,3550, 3553, 3554,3550, 3554, 3555,
3550, 3555, 3556,3550, 3556, 3557,3550, 3557, 3558,3550, 3558, 3551,
3559, 3560, 3561,3559, 3561, 3427,3559, 3427, 3332,3559, 3332, 3562,
3559, 3562, 3418,3559, 3418, 3557,3559, 3557, 3563,3559, 3563, 3560,
3564, 3565, 3561,3564, 3561, 3566,3564, 3566, 3567,3564, 3567, 3568,
3564, 3568, 3569,3564, 3569, 3570,3564, 3570, 3571,3564, 3571, 3565,
3572, 3573, 3574,3572, 3574, 3575,3572, 3575, 3576,3572, 3576, 3577,
3572, 3577, 3578,3572, 3578, 3579,3572, 3579, 3580,3572, 3580, 3573,
3581, 3582, 3583,3581, 3583, 3584,3581, 3584, 3585,3581, 3585, 3586,
3581, 3586, 3587,3581, 3587, 3588,3581, 3588, 3589,3581, 3589, 3582,
3590, 3591, 3592,3590, 3592, 3593,3590, 3593, 3594,3590, 3594, 3595,
3590, 3595, 3596,3590, 3596, 3597,3590, 3597, 3598,3590, 3598, 3591,
3599, 3600, 3601,3599, 3601, 3602,3599, 3602, 3603,3599, 3603, 3604,
3599, 3604, 3605,3599, 3605, 3606,3599, 3606, 3607,3599, 3607, 3600,
3608, 3609, 3610,3608, 3610, 3611,3608, 3611, 3612,3608, 3612, 3613,
3608, 3613, 3614,3608, 3614, 3615,3608, 3615, 3616,3608, 3616, 3609,
3617, 3618, 3619,3617, 3619, 3620,3617, 3620, 3621,3617, 3621, 3622,
3617, 3622, 3623,3617, 3623, 3624,3617, 3624, 3625,3617, 3625, 3618,
3626, 3627, 3628,3626, 3628, 3629,3626, 3629, 3630,3626, 3630, 3631,
3626, 3631, 3632,3626, 3632, 3633,3626, 3633, 3634,3626, 3634, 3627,
3635, 3636, 3637,3635, 3637, 3638,3635, 3638, 3639,3635, 3639, 3640,
3635, 3640, 3641,3635, 3641, 3642,3635, 3642, 3643,3635, 3643, 3636,
3644, 3645, 3646,3644, 3646, 3647,3644, 3647, 3648,3644, 3648, 3649,
3644, 3649, 3650,3644, 3650, 3651,3644, 3651, 3652,3644, 3652, 3645,
3653, 3654, 3655,3653, 3655, 3656,3653, 3656, 3657,3653, 3657, 3658,
3653, 3658, 3659,3653, 3659, 3660,3653, 3660, 3661,3653, 3661, 3654,
3662, 3663, 3664,3662, 3664, 3665,3662, 3665, 3666,3662, 3666, 3667,
3662, 3667, 3668,3662, 3668, 3669,3662, 3669, 3670,3662, 3670, 3663,
3671, 3672, 3673,3671, 3673, 3674,3671, 3674, 3675,3671, 3675, 3676,
3671, 3676, 3677,3671, 3677, 3678,3671, 3678, 3679,3671, 3679, 3672,
3680, 3681, 3682,3680, 3682, 3683,3680, 3683, 3684,3680, 3684, 3685,
3680, 3685, 3686,3680, 3686, 3687,3680, 3687, 3688,3680, 3688, 3681,
3689, 3690, 3691,3689, 3691, 3692,3689, 3692, 3693,3689, 3693, 3694,
3689, 3694, 3695,3689, 3695, 3696,3689, 3696, 3697,3689, 3697, 3690,
3698, 3699, 3700,3698, 3700, 3701,3698, 3701, 3702,3698, 3702, 3703,
3698, 3703, 3704,3698, 3704, 3705,3698, 3705, 3706,3698, 3706, 3699,
3707, 3708, 3709,3707, 3709, 3710,3707, 3710, 3711,3707, 3711, 3712,
3707, 3712, 3713,3707, 3713, 3714,3707, 3714, 3715,3707, 3715, 3708,
3716, 3717, 3718,3716, 3718, 3719,3716, 3719, 3720,3716, 3720, 3721,
3716, 3721, 3722,3716, 3722, 3723,3716, 3723, 3724,3716, 3724, 3717,
3725, 3726, 3727,3725, 3727, 3728,3725, 3728, 3729,3725, 3729, 3730,
3725, 3730, 3731,3725, 3731, 3732,3725, 3732, 3733,3725, 3733, 3726,
3734, 3735, 3736,3734, 3736, 3737,3734, 3737, 3738,3734, 3738, 3739,
3734, 3739, 3740,3734, 3740, 3741,3734, 3741, 3742,3734, 3742, 3735,
3743, 3744, 3745,3743, 3745, 3746,3743, 3746, 3747,3743, 3747, 3748,
3743, 3748, 3749,3743, 3749, 3750,3743, 3750, 3751,3743, 3751, 3744,
3752, 3753, 3754,3752, 3754, 3755,3752, 3755, 3756,3752, 3756, 3757,
3752, 3757, 3758,3752, 3758, 3759,3752, 3759, 3760,3752, 3760, 3753,
3761, 3762, 3763,3761, 3763, 3764,3761, 3764, 3765,3761, 3765, 3766,
3761, 3766, 3767,3761, 3767, 3768,3761, 3768, 3769,3761, 3769, 3762,
3770, 3771, 3772,3770, 3772, 3773,3770, 3773, 3774,3770, 3774, 3775,
3770, 3775, 3776,3770, 3776, 3777,3770, 3777, 3778,3770, 3778, 3771,
3779, 3780, 3781,3779, 3781, 3782,3779, 3782, 3783,3779, 3783, 3784,
3779, 3784, 3785,3779, 3785, 3786,3779, 3786, 3787,3779, 3787, 3780,
3788, 3789, 3790,3788, 3790, 3791,3788, 3791, 3792,3788, 3792, 3793,
3788, 3793, 3794,3788, 3794, 3795,3788, 3795, 3796,3788, 3796, 3789,
3797, 3798, 3799,3797, 3799, 3800,3797, 3800, 3801,3797, 3801, 3802,
3797, 3802, 3803,3797, 3803, 3804,3797, 3804, 3805,3797, 3805, 3798,
3806, 3807, 3808,3806, 3808, 3809,3806, 3809, 3810,3806, 3810, 3811,
3806, 3811, 3812,3806, 3812, 3813,3806, 3813, 3814,3806, 3814, 3807,
3815, 3816, 3817,3815, 3817, 3818,3815, 3818, 3819,3815, 3819, 3820,
3815, 3820, 3821,3815, 3821, 3822,3815, 3822, 3563,3815, 3563, 3816,
3823, 3824, 3825,3823, 3825, 3826,3823, 3826, 3827,3823, 3827, 3828,
3823, 3828, 3829,3823, 3829, 3830,3823, 3830, 3831,3823, 3831, 3824,
3832, 3833, 3834,3832, 3834, 3575,3832, 3575, 3567,3832, 3567, 3835,
3832, 3835, 3821,3832, 3821, 3830,3832, 3830, 3836,3832, 3836, 3833,
3837, 3838, 3574,3837, 3574, 3566,3837, 3566, 3428,3837, 3428, 3839,
3837, 3839, 3556,3837, 3556, 3822,3837, 3822, 3831,3837, 3831, 3838,
3840, 3841, 3842,3840, 3842, 3843,3840, 3843, 3844,3840, 3844, 3845,
3840, 3845, 3846,3840, 3846, 3841,3847, 3841, 3848,3847, 3848, 3849,
3847, 3849, 3850,3847, 3850, 3851,3847, 3851, 3852,3847, 3852, 3841,
3853, 3854, 3848,3853, 3848, 3855,3853, 3855, 3856,3853, 3856, 3857,
3853, 3857, 3858,3853, 3858, 3854,3859, 3860, 3848,3859, 3848, 3861,
3859, 3861, 3862,3859, 3862, 3863,3859, 3863, 3864,3859, 3864, 3860,
3865, 3866, 3848,3865, 3848, 3867,3865, 3867, 3868,3865, 3868, 3869,
3865, 3869, 3870,3865, 3870, 3866,3871, 3872, 3848,3871, 3848, 3873,
3871, 3873, 3874,3871, 3874, 3875,3871, 3875, 3876,3871, 3876, 3872,
3877, 3878, 3848,3877, 3848, 3879,3877, 3879, 3880,3877, 3880, 3881,
3877, 3881, 3882,3877, 3882, 3878,3883, 3884, 3848,3883, 3848, 3885,
3883, 3885, 3886,3883, 3886, 3887,3883, 3887, 3888,3883, 3888, 3884,
3889, 3890, 3848,3889, 3848, 3891,3889, 3891, 3892,3889, 3892, 3893,
3889, 3893, 3894,3889, 3894, 3890,3895, 3896, 3848,3895, 3848, 3897,
3895, 3897, 3898,3895, 3898, 3899,3895, 3899, 3900,3895, 3900, 3896,
3901, 3902, 3848,3901, 3848, 3903,3901, 3903, 3904,3901, 3904, 3905,
3901, 3905, 3906,3901, 3906, 3902,3907, 3908, 3848,3907, 3848, 3909,
3907, 3909, 3910,3907, 3910, 3911,3907, 3911, 3912,3907, 3912, 3908,
3913, 3914, 3848,3913, 3848, 3915,3913, 3915, 3916,3913, 3916, 3917,
3913, 3917, 3918,3913, 3918, 3914,3919, 3920, 3848,3919, 3848, 3921,
3919, 3921, 3922,3919, 3922, 3923,3919, 3923, 3924,3919, 3924, 3920,
3925, 3926, 3848,3925, 3848, 3927,3925, 3927, 3928,3925, 3928, 3929,
3925, 3929, 3930,3925, 3930, 3926,3931, 3932, 3848,3931, 3848, 3933,
3931, 3933, 3844,3931, 3844, 3934,3931, 3934, 3935,3931, 3935, 3932,
3936, 3937, 3938,3936, 3938, 3843,3936, 3843, 3939,3936, 3939, 3940,
3936, 3940, 3941,3936, 3941, 3942,3936, 3942, 3943,3936, 3943, 3937,
3944, 3945, 3842,3944, 3842, 3946,3944, 3946, 3850,3944, 3850, 3947,
3944, 3947, 3948,3944, 3948, 3949,3944, 3949, 3950,3944, 3950, 3945,
3951, 3952, 3953,3951, 3953, 3954,3951, 3954, 3856,3951, 3856, 3955,
3951, 3955, 3956,3951, 3956, 3957,3951, 3957, 3958,3951, 3958, 3952,
3959, 3960, 3961,3959, 3961, 3962,3959, 3962, 3862,3959, 3862, 3963,
3959, 3963, 3964,3959, 3964, 3965,3959, 3965, 3966,3959, 3966, 3960,
3967, 3968, 3969,3967, 3969, 3970,3967, 3970, 3868,3967, 3868, 3971,
3967, 3971, 3972,3967, 3972, 3973,3967, 3973, 3974,3967, 3974, 3968,
3975, 3976, 3977,3975, 3977, 3978,3975, 3978, 3874,3975, 3874, 3979,
3975, 3979, 3980,3975, 3980, 3981,3975, 3981, 3982,3975, 3982, 3976,
3983, 3984, 3985,3983, 3985, 3986,3983, 3986, 3880,3983, 3880, 3987,
3983, 3987, 3988,3983, 3988, 3989,3983, 3989, 3990,3983, 3990, 3984,
3991, 3992, 3993,3991, 3993, 3994,3991, 3994, 3886,3991, 3886, 3995,
3991, 3995, 3996,3991, 3996, 3997,3991, 3997, 3998,3991, 3998, 3992,
3999, 4000, 4001,3999, 4001, 4002,3999, 4002, 3892,3999, 3892, 4003,
3999, 4003, 4004,3999, 4004, 4005,3999, 4005, 4006,3999, 4006, 4000,
4007, 4008, 4009,4007, 4009, 4010,4007, 4010, 3898,4007, 3898, 4011,
4007, 4011, 4012,4007, 4012, 4013,4007, 4013, 4014,4007, 4014, 4008,
4015, 4016, 4017,4015, 4017, 4018,4015, 4018, 3904,4015, 3904, 4019,
4015, 4019, 4020,4015, 4020, 4021,4015, 4021, 4022,4015, 4022, 4016,
4023, 4024, 4025,4023, 4025, 4026,4023, 4026, 3910,4023, 3910, 4027,
4023, 4027, 4028,4023, 4028, 4029,4023, 4029, 4030,4023, 4030, 4024,
4031, 4032, 4033,4031, 4033, 4034,4031, 4034, 3916,4031, 3916, 4035,
4031, 4035, 4036,4031, 4036, 4037,4031, 4037, 4038,4031, 4038, 4032,
4039, 4040, 4041,4039, 4041, 4042,4039, 4042, 3922,4039, 3922, 4043,
4039, 4043, 4044,4039, 4044, 4045,4039, 4045, 4046,4039, 4046, 4040,
4047, 4048, 4049,4047, 4049, 4050,4047, 4050, 3928,4047, 3928, 4051,
4047, 4051, 4052,4047, 4052, 4053,4047, 4053, 4054,4047, 4054, 4048,
4055, 4056, 4057,4055, 4057, 4058,4055, 4058, 3844,4055, 3844, 4059,
4055, 4059, 4060,4055, 4060, 4061,4055, 4061, 4062,4055, 4062, 4056,
4063, 4064, 4065,4063, 4065, 4066,4063, 4066, 4067,4063, 4067, 4068,
4063, 4068, 4069,4063, 4069, 4070,4063, 4070, 4071,4063, 4071, 4064,
4072, 4073, 4074,4072, 4074, 4075,4072, 4075, 4076,4072, 4076, 4077,
4072, 4077, 4078,4072, 4078, 4079,4072, 4079, 4080,4072, 4080, 4073,
4081, 4082, 4083,4081, 4083, 4084,4081, 4084, 4085,4081, 4085, 4086,
4081, 4086, 4087,4081, 4087, 4088,4081, 4088, 4089,4081, 4089, 4082,
4090, 4091, 4092,4090, 4092, 4093,4090, 4093, 4094,4090, 4094, 4095,
4090, 4095, 4096,4090, 4096, 4097,4090, 4097, 4098,4090, 4098, 4091,
4099, 4100, 4101,4099, 4101, 4102,4099, 4102, 4103,4099, 4103, 4104,
4099, 4104, 4105,4099, 4105, 4106,4099, 4106, 4107,4099, 4107, 4100,
4108, 4109, 4110,4108, 4110, 4111,4108, 4111, 4112,4108, 4112, 4113,
4108, 4113, 4114,4108, 4114, 4115,4108, 4115, 4116,4108, 4116, 4109,
4117, 4118, 4119,4117, 4119, 4120,4117, 4120, 4121,4117, 4121, 4122,
4117, 4122, 4123,4117, 4123, 4124,4117, 4124, 4125,4117, 4125, 4118,
4126, 4127, 4128,4126, 4128, 4129,4126, 4129, 4130,4126, 4130, 4131,
4126, 4131, 4132,4126, 4132, 4133,4126, 4133, 4134,4126, 4134, 4127,
4135, 4136, 4137,4135, 4137, 4138,4135, 4138, 4139,4135, 4139, 4140,
4135, 4140, 4141,4135, 4141, 4142,4135, 4142, 4143,4135, 4143, 4136,
4144, 4145, 4146,4144, 4146, 4147,4144, 4147, 4148,4144, 4148, 4149,
4144, 4149, 4150,4144, 4150, 4151,4144, 4151, 4152,4144, 4152, 4145,
4153, 4154, 4155,4153, 4155, 4156,4153, 4156, 4157,4153, 4157, 4158,
4153, 4158, 4159,4153, 4159, 4160,4153, 4160, 4161,4153, 4161, 4154,
4162, 4163, 4164,4162, 4164, 4165,4162, 4165, 4166,4162, 4166, 4167,
4162, 4167, 4168,4162, 4168, 4169,4162, 4169, 4170,4162, 4170, 4163,
4171, 4172, 4173,4171, 4173, 4174,4171, 4174, 4175,4171, 4175, 4176,
4171, 4176, 4177,4171, 4177, 4178,4171, 4178, 4179,4171, 4179, 4172,
4180, 4181, 4182,4180, 4182, 4183,4180, 4183, 4184,4180, 4184, 4185,
4180, 4185, 4186,4180, 4186, 4187,4180, 4187, 4188,4180, 4188, 4181,
4189, 4190, 4191,4189, 4191, 4192,4189, 4192, 4193,4189, 4193, 4194,
4189, 4194, 4195,4189, 4195, 4196,4189, 4196, 4197,4189, 4197, 4190,
4198, 4199, 4200,4198, 4200, 4201,4198, 4201, 4202,4198, 4202, 4203,
4198, 4203, 4204,4198, 4204, 4205,4198, 4205, 4206,4198, 4206, 4199,
4207, 4208, 4209,4207, 4209, 4210,4207, 4210, 4211,4207, 4211, 4212,
4207, 4212, 4213,4207, 4213, 4214,4207, 4214, 4215,4207, 4215, 4208,
4216, 4217, 4218,4216, 4218, 4219,4216, 4219, 4220,4216, 4220, 4221,
4216, 4221, 4222,4216, 4222, 4223,4216, 4223, 4224,4216, 4224, 4217,
4225, 4226, 4227,4225, 4227, 4228,4225, 4228, 4229,4225, 4229, 4230,
4225, 4230, 4231,4225, 4231, 4232,4225, 4232, 4233,4225, 4233, 4226,
4234, 4235, 4236,4234, 4236, 4237,4234, 4237, 4238,4234, 4238, 4239,
4234, 4239, 4240,4234, 4240, 4241,4234, 4241, 4242,4234, 4242, 4235,
4243, 4244, 4245,4243, 4245, 4246,4243, 4246, 4247,4243, 4247, 4248,
4243, 4248, 4249,4243, 4249, 4250,4243, 4250, 4251,4243, 4251, 4244,
4252, 4253, 4254,4252, 4254, 4255,4252, 4255, 4256,4252, 4256, 4257,
4252, 4257, 4258,4252, 4258, 4259,4252, 4259, 4260,4252, 4260, 4253,
4261, 4262, 4263,4261, 4263, 4264,4261, 4264, 4265,4261, 4265, 4266,
4261, 4266, 4267,4261, 4267, 4268,4261, 4268, 4269,4261, 4269, 4262,
4270, 4271, 4272,4270, 4272, 4273,4270, 4273, 4274,4270, 4274, 4275,
4270, 4275, 4276,4270, 4276, 4277,4270, 4277, 4278,4270, 4278, 4271,
4279, 4280, 4281,4279, 4281, 4282,4279, 4282, 4283,4279, 4283, 4284,
4279, 4284, 4285,4279, 4285, 4286,4279, 4286, 4287,4279, 4287, 4280,
4288, 4289, 4290,4288, 4290, 4291,4288, 4291, 4292,4288, 4292, 4293,
4288, 4293, 4294,4288, 4294, 4295,4288, 4295, 4296,4288, 4296, 4289,
4297, 4298, 4299,4297, 4299, 4300,4297, 4300, 4301,4297, 4301, 4302,
4297, 4302, 4303,4297, 4303, 4304,4297, 4304, 4305,4297, 4305, 4298,
4306, 4307, 4308,4306, 4308, 4309,4306, 4309, 4310,4306, 4310, 4311,
4306, 4311, 4312,4306, 4312, 4313,4306, 4313, 4314,4306, 4314, 4307,
4315, 4316, 4317,4315, 4317, 4318,4315, 4318, 4319,4315, 4319, 4320,
4315, 4320, 4321,4315, 4321, 4322,4315, 4322, 4323,4315, 4323, 4316,
4324, 4325, 4326,4324, 4326, 4327,4324, 4327, 4328,4324, 4328, 4329,
4324, 4329, 4330,4324, 4330, 4331,4324, 4331, 4332,4324, 4332, 4325,
4333, 4073, 4334,4333, 4334, 4335,4333, 4335, 4336,4333, 4336, 4329,
4333, 4329, 4321,4333, 4321, 4337,4333, 4337, 4071,4333, 4071, 4073,
4338, 4064, 4074,4338, 4074, 4339,4338, 4339, 4328,4338, 4328, 4320,
4338, 4320, 4052,4338, 4052, 4061,4338, 4061, 3943,4338, 3943, 4064,
4340, 4341, 4342,4340, 4342, 4343,4340, 4343, 4344,4340, 4344, 4345,
4340, 4345, 4346,4340, 4346, 4341,4347, 4341, 4348,4347, 4348, 4349,
4347, 4349, 4350,4347, 4350, 4351,4347, 4351, 4352,4347, 4352, 4341,
4353, 4354, 4348,4353, 4348, 4355,4353, 4355, 4356,4353, 4356, 4357,
4353, 4357, 4358,4353, 4358, 4354,4359, 4360, 4348,4359, 4348, 4361,
4359, 4361, 4362,4359, 4362, 4363,4359, 4363, 4364,4359, 4364, 4360,
4365, 4366, 4348,4365, 4348, 4367,4365, 4367, 4368,4365, 4368, 4369,
4365, 4369, 4370,4365, 4370, 4366,4371, 4372, 4348,4371, 4348, 4373,
4371, 4373, 4374,4371, 4374, 4375,4371, 4375, 4376,4371, 4376, 4372,
4377, 4378, 4348,4377, 4348, 4379,4377, 4379, 4380,4377, 4380, 4381,
4377, 4381, 4382,4377, 4382, 4378,4383, 4384, 4348,4383, 4348, 4385,
4383, 4385, 4386,4383, 4386, 4387,4383, 4387, 4388,4383, 4388, 4384,
4389, 4390, 4348,4389, 4348, 4391,4389, 4391, 4392,4389, 4392, 4393,
4389, 4393, 4394,4389, 4394, 4390,4395, 4396, 4348,4395, 4348, 4397,
4395, 4397, 4398,4395, 4398, 4399,4395, 4399, 4400,4395, 4400, 4396,
4401, 4402, 4348,4401, 4348, 4403,4401, 4403, 4404,4401, 4404, 4405,
4401, 4405, 4406,4401, 4406, 4402,4407, 4408, 4348,4407, 4348, 4409,
4407, 4409, 4410,4407, 4410, 4411,4407, 4411, 4412,4407, 4412, 4408,
4413, 4414, 4348,4413, 4348, 4415,4413, 4415, 4416,4413, 4416, 4417,
4413, 4417, 4418,4413, 4418, 4414,4419, 4420, 4348,4419, 4348, 4421,
4419, 4421, 4422,4419, 4422, 4423,4419, 4423, 4424,4419, 4424, 4420,
4425, 4426, 4348,4425, 4348, 4427,4425, 4427, 4428,4425, 4428, 4429,
4425, 4429, 4430,4425, 4430, 4426,4431, 4432, 4348,4431, 4348, 4433,
4431, 4433, 4344,4431, 4344, 4434,4431, 4434, 4435,4431, 4435, 4432,
4436, 4437, 4438,4436, 4438, 4343,4436, 4343, 4439,4436, 4439, 4440,
4436, 4440, 4441,4436, 4441, 4442,4436, 4442, 4443,4436, 4443, 4437,
4444, 4445, 4342,4444, 4342, 4446,4444, 4446, 4350,4444, 4350, 4447,
4444, 4447, 4448,4444, 4448, 4449,4444, 4449, 4450,4444, 4450, 4445,
4451, 4452, 4453,4451, 4453, 4454,4451, 4454, 4356,4451, 4356, 4455,
4451, 4455, 4456,4451, 4456, 4457,4451, 4457, 4458,4451, 4458, 4452,
4459, 4460, 4461,4459, 4461, 4462,4459, 4462, 4362,4459, 4362, 4463,
4459, 4463, 4464,4459, 4464, 4465,4459, 4465, 4466,4459, 4466, 4460,
4467, 4468, 4469,4467, 4469, 4470,4467, 4470, 4368,4467, 4368, 4471,
4467, 4471, 4472,4467, 4472, 4473,4467, 4473, 4474,4467, 4474, 4468,
4475, 4476, 4477,4475, 4477, 4478,4475, 4478, 4374,4475, 4374, 4479,
4475, 4479, 4480,4475, 4480, 4481,4475, 4481, 4482,4475, 4482, 4476,
4483, 4484, 4485,4483, 4485, 4486,4483, 4486, 4380,4483, 4380, 4487,
4483, 4487, 4488,4483, 4488, 4489,4483, 4489, 4490,4483, 4490, 4484,
4491, 4492, 4493,4491, 4493, 4494,4491, 4494, 4386,4491, 4386, 4495,
4491, 4495, 4496,4491, 4496, 4497,4491, 4497, 4498,4491, 4498, 4492,
4499, 4500, 4501,4499, 4501, 4502,4499, 4502, 4392,4499, 4392, 4503,
4499, 4503, 4504,4499, 4504, 4505,4499, 4505, 4506,4499, 4506, 4500,
4507, 4508, 4509,4507, 4509, 4510,4507, 4510, 4398,4507, 4398, 4511,
4507, 4511, 4512,4507, 4512, 4513,4507, 4513, 4514,4507, 4514, 4508,
4515, 4516, 4517,4515, 4517, 4518,4515, 4518, 4404,4515, 4404, 4519,
4515, 4519, 4520,4515, 4520, 4521,4515, 4521, 4522,4515, 4522, 4516,
4523, 4524, 4525,4523, 4525, 4526,4523, 4526, 4410,4523, 4410, 4527,
4523, 4527, 4528,4523, 4528, 4529,4523, 4529, 4530,4523, 4530, 4524,
4531, 4532, 4533,4531, 4533, 4534,4531, 4534, 4416,4531, 4416, 4535,
4531, 4535, 4536,4531, 4536, 4537,4531, 4537, 4538,4531, 4538, 4532,
4539, 4540, 4541,4539, 4541, 4542,4539, 4542, 4422,4539, 4422, 4543,
4539, 4543, 4544,4539, 4544, 4545,4539, 4545, 4546,4539, 4546, 4540,
4547, 4548, 4549,4547, 4549, 4550,4547, 4550, 4428,4547, 4428, 4551,
4547, 4551, 4552,4547, 4552, 4553,4547, 4553, 4554,4547, 4554, 4548,
4555, 4556, 4557,4555, 4557, 4558,4555, 4558, 4344,4555, 4344, 4559,
4555, 4559, 4560,4555, 4560, 4561,4555, 4561, 4562,4555, 4562, 4556,
4563, 4564, 4565,4563, 4565, 4566,4563, 4566, 4567,4563, 4567, 4568,
4563, 4568, 4569,4563, 4569, 4570,4563, 4570, 4571,4563, 4571, 4564,
4572, 4573, 4574,4572, 4574, 4575,4572, 4575, 4576,4572, 4576, 4577,
4572, 4577, 4578,4572, 4578, 4579,4572, 4579, 4580,4572, 4580, 4573,
4581, 4582, 4583,4581, 4583, 4584,4581, 4584, 4585,4581, 4585, 4586,
4581, 4586, 4587,4581, 4587, 4588,4581, 4588, 4589,4581, 4589, 4582,
4590, 4591, 4592,4590, 4592, 4593,4590, 4593, 4594,4590, 4594, 4595,
4590, 4595, 4596,4590, 4596, 4597,4590, 4597, 4598,4590, 4598, 4591,
4599, 4600, 4601,4599, 4601, 4602,4599, 4602, 4603,4599, 4603, 4604,
4599, 4604, 4605,4599, 4605, 4606,4599, 4606, 4607,4599, 4607, 4600,
4608, 4609, 4610,4608, 4610, 4611,4608, 4611, 4612,4608, 4612, 4613,
4608, 4613, 4614,4608, 4614, 4615,4608, 4615, 4616,4608, 4616, 4609,
4617, 4618, 4619,4617, 4619, 4620,4617, 4620, 4621,4617, 4621, 4622,
4617, 4622, 4623,4617, 4623, 4624,4617, 4624, 4625,4617, 4625, 4618,
4626, 4627, 4628,4626, 4628, 4629,4626, 4629, 4630,4626, 4630, 4631,
4626, 4631, 4632,4626, 4632, 4633,4626, 4633, 4634,4626, 4634, 4627,
4635, 4636, 4637,4635, 4637, 4638,4635, 4638, 4639,4635, 4639, 4640,
4635, 4640, 4641,4635, 4641, 4642,4635, 4642, 4643,4635, 4643, 4636,
4644, 4645, 4646,4644, 4646, 4647,4644, 4647, 4648,4644, 4648, 4649,
4644, 4649, 4650,4644, 4650, 4651,4644, 4651, 4652,4644, 4652, 4645,
4653, 4654, 4655,4653, 4655, 4656,4653, 4656, 4657,4653, 4657, 4658,
4653, 4658, 4659,4653, 4659, 4660,4653, 4660, 4661,4653, 4661, 4654,
4662, 4663, 4664,4662, 4664, 4665,4662, 4665, 4666,4662, 4666, 4667,
4662, 4667, 4668,4662, 4668, 4669,4662, 4669, 4670,4662, 4670, 4663,
4671, 4672, 4673,4671, 4673, 4674,4671, 4674, 4675,4671, 4675, 4676,
4671, 4676, 4677,4671, 4677, 4678,4671, 4678, 4679,4671, 4679, 4672,
4680, 4681, 4682,4680, 4682, 4683,4680, 4683, 4684,4680, 4684, 4685,
4680, 4685, 4686,4680, 4686, 4687,4680, 4687, 4688,4680, 4688, 4681,
4689, 4690, 4691,4689, 4691, 4692,4689, 4692, 4693,4689, 4693, 4694,
4689, 4694, 4695,4689, 4695, 4696,4689, 4696, 4697,4689, 4697, 4690,
4698, 4699, 4700,4698, 4700, 4701,4698, 4701, 4702,4698, 4702, 4703,
4698, 4703, 4704,4698, 4704, 4705,4698, 4705, 4706,4698, 4706, 4699,
4707, 4708, 4709,4707, 4709, 4710,4707, 4710, 4711,4707, 4711, 4712,
4707, 4712, 4713,4707, 4713, 4714,4707, 4714, 4715,4707, 4715, 4708,
4716, 4717, 4718,4716, 4718, 4719,4716, 4719, 4720,4716, 4720, 4721,
4716, 4721, 4722,4716, 4722, 4723,4716, 4723, 4724,4716, 4724, 4717,
4725, 4726, 4727,4725, 4727, 4728,4725, 4728, 4729,4725, 4729, 4730,
4725, 4730, 4731,4725, 4731, 4732,4725, 4732, 4733,4725, 4733, 4726,
4734, 4735, 4736,4734, 4736, 4737,4734, 4737, 4738,4734, 4738, 4739,
4734, 4739, 4740,4734, 4740, 4741,4734, 4741, 4742,4734, 4742, 4735,
4743, 4744, 4745,4743, 4745, 4746,4743, 4746, 4747,4743, 4747, 4748,
4743, 4748, 4749,4743, 4749, 4750,4743, 4750, 4751,4743, 4751, 4744,
4752, 4753, 4754,4752, 4754, 4755,4752, 4755, 4756,4752, 4756, 4757,
4752, 4757, 4758,4752, 4758, 4759,4752, 4759, 4760,4752, 4760, 4753,
4761, 4762, 4763,4761, 4763, 4764,4761, 4764, 4765,4761, 4765, 4766,
4761, 4766, 4767,4761, 4767, 4768,4761, 4768, 4769,4761, 4769, 4762,
4770, 4771, 4772,4770, 4772, 4773,4770, 4773, 4774,4770, 4774, 4775,
4770, 4775, 4776,4770, 4776, 4777,4770, 4777, 4778,4770, 4778, 4771,
4779, 4780, 4781,4779, 4781, 4782,4779, 4782, 4783,4779, 4783, 4784,
4779, 4784, 4785,4779, 4785, 4786,4779, 4786, 4787,4779, 4787, 4780,
4788, 4789, 4790,4788, 4790, 4791,4788, 4791, 4792,4788, 4792, 4793,
4788, 4793, 4794,4788, 4794, 4795,4788, 4795, 4796,4788, 4796, 4789,
4797, 4798, 4799,4797, 4799, 4800,4797, 4800, 4801,4797, 4801, 4802,
4797, 4802, 4803,4797, 4803, 4804,4797, 4804, 4805,4797, 4805, 4798,
4806, 4807, 4808,4806, 4808, 4809,4806, 4809, 4810,4806, 4810, 4811,
4806, 4811, 4812,4806, 4812, 4813,4806, 4813, 4814,4806, 4814, 4807,
4815, 4816, 4817,4815, 4817, 4818,4815, 4818, 4819,4815, 4819, 4820,
4815, 4820, 4821,4815, 4821, 4822,4815, 4822, 4823,4815, 4823, 4816,
4824, 4825, 4826,4824, 4826, 4827,4824, 4827, 4828,4824, 4828, 4829,
4824, 4829, 4830,4824, 4830, 4831,4824, 4831, 4832,4824, 4832, 4825,
4833, 4573, 4834,4833, 4834, 4835,4833, 4835, 4836,4833, 4836, 4829,
4833, 4829, 4821,4833, 4821, 4837,4833, 4837, 4571,4833, 4571, 4573,
4838, 4564, 4574,4838, 4574, 4839,4838, 4839, 4828,4838, 4828, 4820,
4838, 4820, 4552,4838, 4552, 4561,4838, 4561, 4443,4838, 4443, 4564,
4840, 4841, 4842,4840, 4842, 4843,4840, 4843, 4844,4840, 4844, 4845,
4840, 4845, 4846,4840, 4846, 4847,4840, 4847, 4848,4840, 4848, 4841,
4849, 4850, 4851,4849, 4851, 4852,4849, 4852, 4853,4849, 4853, 4854,
4849, 4854, 4855,4849, 4855, 4856,4849, 4856, 4857,4849, 4857, 4850,
4858, 4859, 4860,4858, 4860, 4861,4858, 4861, 4862,4858, 4862, 4863,
4858, 4863, 4864,4858, 4864, 4865,4858, 4865, 4866,4858, 4866, 4859,
4867, 4868, 4869,4867, 4869, 4870,4867, 4870, 4871,4867, 4871, 4872,
4867, 4872, 4873,4867, 4873, 4874,4867, 4874, 4875,4867, 4875, 4868,
4876, 4877, 4878,4876, 4878, 4879,4876, 4879, 4880,4876, 4880, 4881,
4876, 4881, 4846,4876, 4846, 4882,4876, 4882, 4883,4876, 4883, 4877,
4884, 4885, 4886,4884, 4886, 4887,4884, 4887, 4844,4884, 4844, 4888,
4884, 4888, 4889,4884, 4889, 4890,4884, 4890, 4891,4884, 4891, 4885,
4892, 4893, 4894,4892, 4894, 4895,4892, 4895, 4896,4892, 4896, 4897,
4892, 4897, 4898,4892, 4898, 4899,4892, 4899, 4900,4892, 4900, 4893,
4901, 4902, 4903,4901, 4903, 4904,4901, 4904, 4905,4901, 4905, 4906,
4901, 4906, 4907,4901, 4907, 4908,4901, 4908, 4909,4901, 4909, 4902,
4910, 4911, 4851,4910, 4851, 4895,4910, 4895, 4912,4910, 4912, 4913,
4910, 4913, 4914,4910, 4914, 4915,4910, 4915, 4916,4910, 4916, 4911,
4917, 4918, 4919,4917, 4919, 4920,4917, 4920, 4921,4917, 4921, 4922,
4917, 4922, 4923,4917, 4923, 4899,4917, 4899, 4857,4917, 4857, 4918,
4924, 4925, 4926,4924, 4926, 4927,4924, 4927, 4928,4924, 4928, 4929,
4924, 4929, 4930,4924, 4930, 4931,4924, 4931, 4932,4924, 4932, 4925,
4933, 4934, 4935,4933, 4935, 4936,4933, 4936, 4937,4933, 4937, 4938,
4933, 4938, 4939,4933, 4939, 4940,4933, 4940, 4941,4933, 4941, 4934,
4942, 4943, 4944,4942, 4944, 4945,4942, 4945, 4946,4942, 4946, 4947,
4942, 4947, 4873,4942, 4873, 4948,4942, 4948, 4949,4942, 4949, 4943,
4950, 4951, 4869,4950, 4869, 4927,4950, 4927, 4952,4950, 4952, 4953,
4950, 4953, 4954,4950, 4954, 4955,4950, 4955, 4956,4950, 4956, 4951,
4957, 4958, 4959,4957, 4959, 4960,4957, 4960, 4961,4957, 4961, 4962,
4957, 4962, 4907,4957, 4907, 4940,4957, 4940, 4963,4957, 4963, 4958,
4964, 4965, 4903,4964, 4903, 4966,4964, 4966, 4967,4964, 4967, 4968,
4964, 4968, 4969,4964, 4969, 4970,4964, 4970, 4971,4964, 4971, 4965,
4972, 4973, 4974,4972, 4974, 4975,4972, 4975, 4976,4972, 4976, 4977,
4972, 4977, 4978,4972, 4978, 4979,4972, 4979, 4980,4972, 4980, 4973,
4981, 4982, 4983,4981, 4983, 4984,4981, 4984, 4952,4981, 4952, 4985,
4981, 4985, 4986,4981, 4986, 4987,4981, 4987, 4988,4981, 4988, 4982,
4989, 4990, 4991,4989, 4991, 4992,4989, 4992, 4993,4989, 4993, 4994,
4989, 4994, 4995,4989, 4995, 4996,4989, 4996, 4963,4989, 4963, 4990,
4997, 4998, 4999,4997, 4999, 5000,4997, 5000, 5001,4997, 5001, 4854,
4997, 4854, 5002,4997, 5002, 5003,4997, 5003, 5004,4997, 5004, 4998,
5005, 5006, 5007,5005, 5007, 5008,5005, 5008, 5009,5005, 5009, 5010,
5005, 5010, 5011,5005, 5011, 5012,5005, 5012, 4883,5005, 4883, 5006,
5013, 5014, 5015,5013, 5015, 5016,5013, 5016, 5017,5013, 5017, 5018,
5013, 5018, 5019,5013, 5019, 5020,5013, 5020, 5021,5013, 5021, 5014,
5022, 5023, 4926,5022, 4926, 4984,5022, 4984, 4976,5022, 4976, 5024,
5022, 5024, 5025,5022, 5025, 5026,5022, 5026, 5027,5022, 5027, 5023,
5028, 5029, 4983,5028, 4983, 4975,5028, 4975, 4844,5028, 4844, 5030,
5028, 5030, 5031,5028, 5031, 5032,5028, 5032, 5033,5028, 5033, 5029,
5034, 5035, 5036,5034, 5036, 5037,5034, 5037, 5038,5034, 5038, 5039,
5034, 5039, 4995,5034, 4995, 5003,5034, 5003, 4916,5034, 4916, 5035,
5040, 5041, 5042,5040, 5042, 5043,5040, 5043, 5044,5040, 5044, 5045,
5040, 5045, 4939,5040, 4939, 4996,5040, 4996, 5004,5040, 5004, 5041,
5046, 5047, 5048,5046, 5048, 5049,5046, 5049, 5050,5046, 5050, 5051,
5046, 5051, 5052,5046, 5052, 5053,5046, 5053, 5054,5046, 5054, 5047,
5055, 5056, 5057,5055, 5057, 5058,5055, 5058, 4921,5055, 4921, 5059,
5055, 5059, 4855,5055, 4855, 5060,5055, 5060, 5061,5055, 5061, 5056,
5062, 4893, 5063,5062, 5063, 5064,5062, 5064, 5065,5062, 5065, 5066,
5062, 5066, 5067,5062, 5067, 5068,5062, 5068, 5069,5062, 5069, 4893,
5070, 5071, 5072,5070, 5072, 5073,5070, 5073, 5074,5070, 5074, 5075,
5070, 5075, 5076,5070, 5076, 5077,5070, 5077, 5078,5070, 5078, 5071,
5079, 5080, 5081,5079, 5081, 5082,5079, 5082, 5083,5079, 5083, 5084,
5079, 5084, 5085,5079, 5085, 5086,5079, 5086, 5087,5079, 5087, 5080,
5088, 5089, 5090,5088, 5090, 5091,5088, 5091, 5092,5088, 5092, 5093,
5088, 5093, 5094,5088, 5094, 5095,5088, 5095, 5096,5088, 5096, 5089,
5097, 5098, 4894,5097, 4894, 5099,5097, 5099, 5100,5097, 5100, 5101,
5097, 5101, 5102,5097, 5102, 5103,5097, 5103, 5104,5097, 5104, 5098,
5105, 5106, 5107,5105, 5107, 5108,5105, 5108, 5109,5105, 5109, 5110,
5105, 5110, 5111,5105, 5111, 5112,5105, 5112, 5113,5105, 5113, 5106,
5114, 5115, 5116,5114, 5116, 5117,5114, 5117, 5118,5114, 5118, 5119,
5114, 5119, 5120,5114, 5120, 5121,5114, 5121, 4900,5114, 4900, 5115,
5122, 5123, 5124,5122, 5124, 5125,5122, 5125, 5126,5122, 5126, 5127,
5122, 5127, 5128,5122, 5128, 5129,5122, 5129, 5130,5122, 5130, 5123,
5131, 5132, 5133,5131, 5133, 5134,5131, 5134, 5135,5131, 5135, 5136,
5131, 5136, 5137,5131, 5137, 5138,5131, 5138, 4949,5131, 4949, 5132,
5139, 5140, 5141,5139, 5141, 5142,5139, 5142, 4961,5139, 4961, 5143,
5139, 5143, 5144,5139, 5144, 5145,5139, 5145, 5146,5139, 5146, 5140,
5147, 5148, 5149,5147, 5149, 5150,5147, 5150, 5151,5147, 5151, 5152,
5147, 5152, 5153,5147, 5153, 5154,5147, 5154, 4956,5147, 4956, 5148,
5155, 5156, 5157,5155, 5157, 5158,5155, 5158, 4967,5155, 4967, 5159,
5155, 5159, 5160,5155, 5160, 5161,5155, 5161, 5162,5155, 5162, 5156,
5163, 5164, 5165,5163, 5165, 5166,5163, 5166, 5167,5163, 5167, 5168,
5163, 5168, 5102,5163, 5102, 5112,5163, 5112, 4883,5163, 4883, 5164,
5169, 5170, 5171,5169, 5171, 5172,5169, 5172, 5038,5169, 5038, 5173,
5169, 5173, 4914,5169, 4914, 5103,5169, 5103, 5113,5169, 5113, 5170,
5174, 5175, 5176,5174, 5176, 5177,5174, 5177, 5178,5174, 5178, 5179,
5174, 5179, 5180,5174, 5180, 5181,5174, 5181, 5021,5174, 5021, 5175,
5182, 5183, 5184,5182, 5184, 5185,5182, 5185, 5044,5182, 5044, 5186,
5182, 5186, 5187,5182, 5187, 5188,5182, 5188, 5189,5182, 5189, 5183,
5190, 5191, 5192,5190, 5192, 5193,5190, 5193, 5194,5190, 5194, 5195,
5190, 5195, 5196,5190, 5196, 5197,5190, 5197, 5027,5190, 5027, 5191,
5198, 5199, 5200,5198, 5200, 5201,5198, 5201, 5050,5198, 5050, 5202,
5198, 5202, 5203,5198, 5203, 5204,5198, 5204, 5205,5198, 5205, 5199,
5206, 5207, 4886,5206, 4886, 5125,5206, 5125, 5118,5206, 5118, 5208,
5206, 5208, 5209,5206, 5209, 5210,5206, 5210, 5033,5206, 5033, 5207,
5211, 5212, 5124,5211, 5124, 5117,5211, 5117, 4921,5211, 4921, 5213,
5211, 5213, 5214,5211, 5214, 5215,5211, 5215, 5216,5211, 5216, 5212,
5217, 5218, 5219,5217, 5219, 5220,5217, 5220, 5221,5217, 5221, 5222,
5217, 5222, 5223,5217, 5223, 5224,5217, 5224, 5225,5217, 5225, 5218,
5226, 5227, 5228,5226, 5228, 5229,5226, 5229, 5230,5226, 5230, 5231,
5226, 5231, 5232,5226, 5232, 5233,5226, 5233, 5234,5226, 5234, 5227,
5235, 5236, 5237,5235, 5237, 5238,5235, 5238, 5239,5235, 5239, 5240,
5235, 5240, 5241,5235, 5241, 5242,5235, 5242, 5243,5235, 5243, 5236,
5244, 5245, 5246,5244, 5246, 5247,5244, 5247, 5248,5244, 5248, 5249,
5244, 5249, 5250,5244, 5250, 5251,5244, 5251, 5252,5244, 5252, 5245,
5253, 5254, 5255,5253, 5255, 5256,5253, 5256, 5257,5253, 5257, 5258,
5253, 5258, 5223,5253, 5223, 5259,5253, 5259, 5260,5253, 5260, 5254,
5261, 5262, 5263,5261, 5263, 5264,5261, 5264, 5221,5261, 5221, 5265,
5261, 5265, 5266,5261, 5266, 5267,5261, 5267, 5268,5261, 5268, 5262,
5269, 5270, 5271,5269, 5271, 5272,5269, 5272, 5273,5269, 5273, 5274,
5269, 5274, 5275,5269, 5275, 5276,5269, 5276, 5277,5269, 5277, 5270,
5278, 5279, 5280,5278, 5280, 5281,5278, 5281, 5282,5278, 5282, 5283,
5278, 5283, 5284,5278, 5284, 5285,5278, 5285, 5286,5278, 5286, 5279,
5287, 5288, 5228,5287, 5228, 5272,5287, 5272, 5289,5287, 5289, 5290,
5287, 5290, 5291,5287, 5291, 5292,5287, 5292, 5293,5287, 5293, 5288,
5294, 5295, 5296,5294, 5296, 5297,5294, 5297, 5298,5294, 5298, 5299,
5294, 5299, 5300,5294, 5300, 5276,5294, 5276, 5234,5294, 5234, 5295,
5301, 5302, 5303,5301, 5303, 5304,5301, 5304, 5305,5301, 5305, 5306,
5301, 5306, 5307,5301, 5307, 5308,5301, 5308, 5309,5301, 5309, 5302,
5310, 5311, 5312,5310, 5312, 5313,5310, 5313, 5314,5310, 5314, 5315,
5310, 5315, 5316,5310, 5316, 5317,5310, 5317, 5318,5310, 5318, 5311,
5319, 5320, 5321,5319, 5321, 5322,5319, 5322, 5323,5319, 5323, 5324,
5319, 5324, 5250,5319, 5250, 5325,5319, 5325, 5326,5319, 5326, 5320,
5327, 5328, 5246,5327, 5246, 5304,5327, 5304, 5329,5327, 5329, 5330,
5327, 5330, 5331,5327, 5331, 5332,5327, 5332, 5333,5327, 5333, 5328,
5334, 5335, 5336,5334, 5336, 5337,5334, 5337, 5338,5334, 5338, 5339,
5334, 5339, 5284,5334, 5284, 5317,5334, 5317, 5340,5334, 5340, 5335,
5341, 5342, 5280,5341, 5280, 5343,5341, 5343, 5344,5341, 5344, 5345,
5341, 5345, 5346,5341, 5346, 5347,5341, 5347, 5348,5341, 5348, 5342,
5349, 5350, 5351,5349, 5351, 5352,5349, 5352, 5353,5349, 5353, 5354,
5349, 5354, 5355,5349, 5355, 5356,5349, 5356, 5357,5349, 5357, 5350,
5358, 5359, 5360,5358, 5360, 5361,5358, 5361, 5329,5358, 5329, 5362,
5358, 5362, 5363,5358, 5363, 5364,5358, 5364, 5365,5358, 5365, 5359,
5366, 5367, 5368,5366, 5368, 5369,5366, 5369, 5370,5366, 5370, 5371,
5366, 5371, 5372,5366, 5372, 5373,5366, 5373, 5340,5366, 5340, 5367,
5374, 5375, 5376,5374, 5376, 5377,5374, 5377, 5378,5374, 5378, 5231,
5374, 5231, 5379,5374, 5379, 5380,5374, 5380, 5381,5374, 5381, 5375,
5382, 5383, 5384,5382, 5384, 5385,5382, 5385, 5386,5382, 5386, 5387,
5382, 5387, 5388,5382, 5388, 5389,5382, 5389, 5260,5382, 5260, 5383,
5390, 5391, 5392,5390, 5392, 5393,5390, 5393, 5394,5390, 5394, 5395,
5390, 5395, 5396,5390, 5396, 5397,5390, 5397, 5398,5390, 5398, 5391,
5399, 5400, 5303,5399, 5303, 5361,5399, 5361, 5353,5399, 5353, 5401,
5399, 5401, 5402,5399, 5402, 5403,5399, 5403, 5404,5399, 5404, 5400,
5405, 5406, 5360,5405, 5360, 5352,5405, 5352, 5221,5405, 5221, 5407,
5405, 5407, 5408,5405, 5408, 5409,5405, 5409, 5410,5405, 5410, 5406,
5411, 5412, 5413,5411, 5413, 5414,5411, 5414, 5415,5411, 5415, 5416,
5411, 5416, 5372,5411, 5372, 5380,5411, 5380, 5293,5411, 5293, 5412,
5417, 5418, 5419,5417, 5419, 5420,5417, 5420, 5421,5417, 5421, 5422,
5417, 5422, 5316,5417, 5316, 5373,5417, 5373, 5381,5417, 5381, 5418,
5423, 5424, 5425,5423, 5425, 5426,5423, 5426, 5427,5423, 5427, 5428,
5423, 5428, 5429,5423, 5429, 5430,5423, 5430, 5431,5423, 5431, 5424,
5432, 5433, 5434,5432, 5434, 5435,5432, 5435, 5298,5432, 5298, 5436,
5432, 5436, 5232,5432, 5232, 5437,5432, 5437, 5438,5432, 5438, 5433,
5439, 5270, 5440,5439, 5440, 5441,5439, 5441, 5442,5439, 5442, 5443,
5439, 5443, 5444,5439, 5444, 5445,5439, 5445, 5446,5439, 5446, 5270,
5447, 5448, 5449,5447, 5449, 5450,5447, 5450, 5451,5447, 5451, 5452,
5447, 5452, 5453,5447, 5453, 5454,5447, 5454, 5455,5447, 5455, 5448,
5456, 5457, 5458,5456, 5458, 5459,5456, 5459, 5460,5456, 5460, 5461,
5456, 5461, 5462,5456, 5462, 5463,5456, 5463, 5464,5456, 5464, 5457,
5465, 5466, 5467,5465, 5467, 5468,5465, 5468, 5469,5465, 5469, 5470,
5465, 5470, 5471,5465, 5471, 5472,5465, 5472, 5473,5465, 5473, 5466,
5474, 5475, 5271,5474, 5271, 5476,5474, 5476, 5477,5474, 5477, 5478,
5474, 5478, 5479,5474, 5479, 5480,5474, 5480, 5481,5474, 5481, 5475,
5482, 5483, 5484,5482, 5484, 5485,5482, 5485, 5486,5482, 5486, 5487,
5482, 5487, 5488,5482, 5488, 5489,5482, 5489, 5490,5482, 5490, 5483,
5491, 5492, 5493,5491, 5493, 5494,5491, 5494, 5495,5491, 5495, 5496,
5491, 5496, 5497,5491, 5497, 5498,5491, 5498, 5277,5491, 5277, 5492,
5499, 5500, 5501,5499, 5501, 5502,5499, 5502, 5503,5499, 5503, 5504,
5499, 5504, 5505,5499, 5505, 5506,5499, 5506, 5507,5499, 5507, 5500,
5508, 5509, 5510,5508, 5510, 5511,5508, 5511, 5512,5508, 5512, 5513,
5508, 5513, 5514,5508, 5514, 5515,5508, 5515, 5326,5508, 5326, 5509,
5516, 5517, 5518,5516, 5518, 5519,5516, 5519, 5338,5516, 5338, 5520,
5516, 5520, 5521,5516, 5521, 5522,5516, 5522, 5523,5516, 5523, 5517,
5524, 5525, 5526,5524, 5526, 5527,5524, 5527, 5528,5524, 5528, 5529,
5524, 5529, 5530,5524, 5530, 5531,5524, 5531, 5333,5524, 5333, 5525,
5532, 5533, 5534,5532, 5534, 5535,5532, 5535, 5344,5532, 5344, 5536,
5532, 5536, 5537,5532, 5537, 5538,5532, 5538, 5539,5532, 5539, 5533,
5540, 5541, 5542,5540, 5542, 5543,5540, 5543, 5544,5540, 5544, 5545,
5540, 5545, 5479,5540, 5479, 5489,5540, 5489, 5260,5540, 5260, 5541,
5546, 5547, 5548,5546, 5548, 5549,5546, 5549, 5415,5546, 5415, 5550,
5546, 5550, 5291,5546, 5291, 5480,5546, 5480, 5490,5546, 5490, 5547,
5551, 5552, 5553,5551, 5553, 5554,5551, 5554, 5555,5551, 5555, 5556,
5551, 5556, 5557,5551, 5557, 5558,5551, 5558, 5398,5551, 5398, 5552,
5559, 5560, 5561,5559, 5561, 5562,5559, 5562, 5421,5559, 5421, 5563,
5559, 5563, 5564,5559, 5564, 5565,5559, 5565, 5566,5559, 5566, 5560,
5567, 5568, 5569,5567, 5569, 5570,5567, 5570, 5571,5567, 5571, 5572,
5567, 5572, 5573,5567, 5573, 5574,5567, 5574, 5404,5567, 5404, 5568,
5575, 5576, 5577,5575, 5577, 5578,5575, 5578, 5427,5575, 5427, 5579,
5575, 5579, 5580,5575, 5580, 5581,5575, 5581, 5582,5575, 5582, 5576,
5583, 5584, 5263,5583, 5263, 5502,5583, 5502, 5495,5583, 5495, 5585,
5583, 5585, 5586,5583, 5586, 5587,5583, 5587, 5410,5583, 5410, 5584,
5588, 5589, 5501,5588, 5501, 5494,5588, 5494, 5298,5588, 5298, 5590,
5588, 5590, 5591,5588, 5591, 5592,5588, 5592, 5593,5588, 5593, 5589,
5594, 5595, 5596,5594, 5596, 5597,5594, 5597, 5598,5594, 5598, 5599,
5594, 5599, 5600,5594, 5600, 5601,5594, 5601, 5602,5594, 5602, 5595,
5603, 5604, 5605,5603, 5605, 5606,5603, 5606, 5607,5603, 5607, 5608,
5603, 5608, 5598,5603, 5598, 5597,5603, 5597, 5596,5603, 5596, 5604,
5609, 5599, 5598,5609, 5598, 5610,5609, 5610, 5611,5609, 5611, 5612,
5609, 5612, 5613,5609, 5613, 5614,5609, 5614, 5600,5609, 5600, 5599,
5615, 5608, 5607,5615, 5607, 5616,5615, 5616, 5617,5615, 5617, 5618,
5615, 5618, 5611,5615, 5611, 5610,5615, 5610, 5598,5615, 5598, 5608,
5619, 5620, 5621,5619, 5621, 5622,5619, 5622, 5623,5619, 5623, 5624,
5619, 5624, 5625,5619, 5625, 5626,5619, 5626, 5627,5619, 5627, 5620,
5628, 5629, 5630,5628, 5630, 5631,5628, 5631, 5632,5628, 5632, 5633,
5628, 5633, 5623,5628, 5623, 5622,5628, 5622, 5621,5628, 5621, 5629,
5634, 5624, 5623,5634, 5623, 5635,5634, 5635, 5636,5634, 5636, 5637,
5634, 5637, 5638,5634, 5638, 5639,5634, 5639, 5625,5634, 5625, 5624,
5640, 5633, 5632,5640, 5632, 5641,5640, 5641, 5642,5640, 5642, 5643,
5640, 5643, 5636,5640, 5636, 5635,5640, 5635, 5623,5640, 5623, 5633,
5644, 5645, 5646,5644, 5646, 5647,5644, 5647, 5596,5644, 5596, 5595,
5644, 5595, 5602,5644, 5602, 5648,5644, 5648, 5649,5644, 5649, 5645,
5650, 5651, 5652,5650, 5652, 5653,5650, 5653, 5605,5650, 5605, 5604,
5650, 5604, 5596,5650, 5596, 5647,5650, 5647, 5646,5650, 5646, 5651,
5654, 5637, 5636,5654, 5636, 5655,5654, 5655, 5656,5654, 5656, 5657,
5654, 5657, 5658,5654, 5658, 5659,5654, 5659, 5638,5654, 5638, 5637,
5660, 5643, 5642,5660, 5642, 5661,5660, 5661, 5662,5660, 5662, 5663,
5660, 5663, 5656,5660, 5656, 5655,5660, 5655, 5636,5660, 5636, 5643,
5664, 5665, 5666,5664, 5666, 5667,5664, 5667, 5668,5664, 5668, 5669,
5664, 5669, 5670,5664, 5670, 5671,5664, 5671, 5672,5664, 5672, 5665,
5673, 5674, 5675,5673, 5675, 5676,5673, 5676, 5677,5673, 5677, 5678,
5673, 5678, 5668,5673, 5668, 5667,5673, 5667, 5666,5673, 5666, 5674,
5679, 5680, 5681,5679, 5681, 5682,5679, 5682, 5683,5679, 5683, 5684,
5679, 5684, 5685,5679, 5685, 5686,5679, 5686, 5687,5679, 5687, 5680,
5688, 5689, 5683,5688, 5683, 5682,5688, 5682, 5681,5688, 5681, 5690,
5688, 5690, 5691,5688, 5691, 5692,5688, 5692, 5693,5688, 5693, 5689,
5694, 5695, 5696,5694, 5696, 5697,5694, 5697, 5698,5694, 5698, 5699,
5694, 5699, 5700,5694, 5700, 5701,5694, 5701, 5702,5694, 5702, 5695,
5703, 5704, 5705,5703, 5705, 5706,5703, 5706, 5707,5703, 5707, 5708,
5703, 5708, 5698,5703, 5698, 5697,5703, 5697, 5696,5703, 5696, 5704,
5709, 5710, 5711,5709, 5711, 5712,5709, 5712, 5713,5709, 5713, 5714,
5709, 5714, 5715,5709, 5715, 5716,5709, 5716, 5717,5709, 5717, 5710,
5718, 5719, 5720,5718, 5720, 5721,5718, 5721, 5722,5718, 5722, 5723,
5718, 5723, 5713,5718, 5713, 5712,5718, 5712, 5711,5718, 5711, 5719,
5724, 5725, 5726,5724, 5726, 5727,5724, 5727, 5646,5724, 5646, 5645,
5724, 5645, 5649,5724, 5649, 5728,5724, 5728, 5729,5724, 5729, 5725,
5730, 5731, 5732,5730, 5732, 5733,5730, 5733, 5652,5730, 5652, 5651,
5730, 5651, 5646,5730, 5646, 5727,5730, 5727, 5726,5730, 5726, 5731,
5734, 5657, 5656,5734, 5656, 5735,5734, 5735, 5736,5734, 5736, 5737,
5734, 5737, 5738,5734, 5738, 5739,5734, 5739, 5658,5734, 5658, 5657,
5740, 5663, 5662,5740, 5662, 5741,5740, 5741, 5742,5740, 5742, 5743,
5740, 5743, 5736,5740, 5736, 5735,5740, 5735, 5656,5740, 5656, 5663,
5744, 5745, 5746,5744, 5746, 5747,5744, 5747, 5748,5744, 5748, 5749,
5744, 5749, 5750,5744, 5750, 5751,5744, 5751, 5752,5744, 5752, 5745,
5753, 5754, 5755,5753, 5755, 5756,5753, 5756, 5757,5753, 5757, 5758,
5753, 5758, 5748,5753, 5748, 5747,5753, 5747, 5746,5753, 5746, 5754,
5759, 5760, 5761,5759, 5761, 5762,5759, 5762, 5763,5759, 5763, 5764,
5759, 5764, 5765,5759, 5765, 5766,5759, 5766, 5767,5759, 5767, 5760,
5768, 5769, 5770,5768, 5770, 5771,5768, 5771, 5772,5768, 5772, 5773,
5768, 5773, 5763,5768, 5763, 5762,5768, 5762, 5761,5768, 5761, 5769,
5774, 5775, 5776,5774, 5776, 5777,5774, 5777, 5778,5774, 5778, 5779,
5774, 5779, 5780,5774, 5780, 5781,5774, 5781, 5782,5774, 5782, 5775,
5783, 5784, 5785,5783, 5785, 5786,5783, 5786, 5787,5783, 5787, 5788,
5783, 5788, 5778,5783, 5778, 5777,5783, 5777, 5776,5783, 5776, 5784,
5789, 5790, 5791,5789, 5791, 5792,5789, 5792, 5793,5789, 5793, 5794,
5789, 5794, 5795,5789, 5795, 5796,5789, 5796, 5797,5789, 5797, 5790,
5798, 5799, 5800,5798, 5800, 5801,5798, 5801, 5802,5798, 5802, 5803,
5798, 5803, 5793,5798, 5793, 5792,5798, 5792, 5791,5798, 5791, 5799,
5804, 5805, 5806,5804, 5806, 5807,5804, 5807, 5808,5804, 5808, 5809,
5804, 5809, 5810,5804, 5810, 5811,5804, 5811, 5812,5804, 5812, 5805,
5813, 5814, 5815,5813, 5815, 5816,5813, 5816, 5817,5813, 5817, 5818,
5813, 5818, 5808,5813, 5808, 5807,5813, 5807, 5806,5813, 5806, 5814,
5819, 5820, 5821,5819, 5821, 5822,5819, 5822, 5823,5819, 5823, 5824,
5819, 5824, 5825,5819, 5825, 5826,5819, 5826, 5827,5819, 5827, 5820,
5828, 5829, 5687,5828, 5687, 5686,5828, 5686, 5685,5828, 5685, 5830,
5828, 5830, 5823,5828, 5823, 5822,5828, 5822, 5821,5828, 5821, 5829,
5831, 5832, 5833,5831, 5833, 5834,5831, 5834, 5835,5831, 5835, 5836,
5831, 5836, 5837,5831, 5837, 5838,5831, 5838, 5839,5831, 5839, 5832,
5840, 5841, 5842,5840, 5842, 5843,5840, 5843, 5844,5840, 5844, 5845,
5840, 5845, 5835,5840, 5835, 5834,5840, 5834, 5833,5840, 5833, 5841,
5846, 5847, 5848,5846, 5848, 5849,5846, 5849, 5850,5846, 5850, 5851,
5846, 5851, 5852,5846, 5852, 5853,5846, 5853, 5854,5846, 5854, 5847,
5855, 5856, 5717,5855, 5717, 5716,5855, 5716, 5715,5855, 5715, 5857,
5855, 5857, 5854,5855, 5854, 5853,5855, 5853, 5852,5855, 5852, 5856,
5858, 5859, 5860,5858, 5860, 5861,5858, 5861, 5862,5858, 5862, 5863,
5858, 5863, 5864,5858, 5864, 5865,5858, 5865, 5866,5858, 5866, 5859,
5867, 5868, 5729,5867, 5729, 5728,5867, 5728, 5649,5867, 5649, 5869,
5867, 5869, 5862,5867, 5862, 5861,5867, 5861, 5860,5867, 5860, 5868,
5870, 5871, 5872,5870, 5872, 5873,5870, 5873, 5874,5870, 5874, 5875,
5870, 5875, 5876,5870, 5876, 5877,5870, 5877, 5878,5870, 5878, 5871,
5879, 5880, 5658,5879, 5658, 5739,5879, 5739, 5738,5879, 5738, 5881,
5879, 5881, 5878,5879, 5878, 5877,5879, 5877, 5876,5879, 5876, 5880,
5882, 5883, 5757,5882, 5757, 5756,5882, 5756, 5755,5882, 5755, 5884,
5882, 5884, 5885,5882, 5885, 5886,5882, 5886, 5887,5882, 5887, 5883,
5888, 5889, 5767,5888, 5767, 5766,5888, 5766, 5765,5888, 5765, 5890,
5888, 5890, 5891,5888, 5891, 5892,5888, 5892, 5893,5888, 5893, 5889,
5894, 5895, 5787,5894, 5787, 5786,5894, 5786, 5785,5894, 5785, 5896,
5894, 5896, 5897,5894, 5897, 5898,5894, 5898, 5899,5894, 5899, 5895,
5900, 5901, 5797,5900, 5797, 5796,5900, 5796, 5795,5900, 5795, 5902,
5900, 5902, 5903,5900, 5903, 5904,5900, 5904, 5905,5900, 5905, 5901,
5906, 5907, 5908,5906, 5908, 5909,5906, 5909, 5893,5906, 5893, 5892,
5906, 5892, 5891,5906, 5891, 5910,5906, 5910, 5911,5906, 5911, 5907,
5912, 5904, 5903,5912, 5903, 5913,5912, 5913, 5914,5912, 5914, 5915,
5912, 5915, 5916,5912, 5916, 5917,5912, 5917, 5905,5912, 5905, 5904,
5918, 5919, 5920,5918, 5920, 5921,5918, 5921, 5922,5918, 5922, 5923,
5918, 5923, 5924,5918, 5924, 5925,5918, 5925, 5926,5918, 5926, 5919,
5927, 5928, 5929,5927, 5929, 5930,5927, 5930, 5931,5927, 5931, 5932,
5927, 5932, 5933,5927, 5933, 5934,5927, 5934, 5935,5927, 5935, 5928,
5936, 5937, 5938,5936, 5938, 5939,5936, 5939, 5922,5936, 5922, 5921,
5936, 5921, 5920,5936, 5920, 5940,5936, 5940, 5941,5936, 5941, 5937,
5942, 5943, 5944,5942, 5944, 5945,5942, 5945, 5946,5942, 5946, 5947,
5942, 5947, 5948,5942, 5948, 5949,5942, 5949, 5950,5942, 5950, 5943,
5951, 5952, 5953,5951, 5953, 5954,5951, 5954, 5935,5951, 5935, 5934,
5951, 5934, 5933,5951, 5933, 5955,5951, 5955, 5956,5951, 5956, 5952,
5957, 5958, 5959,5957, 5959, 5960,5957, 5960, 5961,5957, 5961, 5962,
5957, 5962, 5963,5957, 5963, 5964,5957, 5964, 5965,5957, 5965, 5958,
5966, 5967, 5968,5966, 5968, 5969,5966, 5969, 5970,5966, 5970, 5971,
5966, 5971, 5972,5966, 5972, 5973,5966, 5973, 5974,5966, 5974, 5967,
5975, 5873, 5872,5975, 5872, 5976,5975, 5976, 5972,5975, 5972, 5971,
5975, 5971, 5970,5975, 5970, 5977,5975, 5977, 5874,5975, 5874, 5873,
5978, 5979, 5980,5978, 5980, 5981,5978, 5981, 5982,5978, 5982, 5983,
5978, 5983, 5984,5978, 5984, 5985,5978, 5985, 5986,5978, 5986, 5979,
5987, 5983, 5982,5987, 5982, 5988,5987, 5988, 5866,5987, 5866, 5865,
5987, 5865, 5864,5987, 5864, 5989,5987, 5989, 5984,5987, 5984, 5983,
5990, 5991, 5992,5990, 5992, 5993,5990, 5993, 5994,5990, 5994, 5995,
5990, 5995, 5996,5990, 5996, 5997,5990, 5997, 5998,5990, 5998, 5991,
5999, 5995, 5994,5999, 5994, 6000,5999, 6000, 5850,5999, 5850, 5849,
5999, 5849, 5848,5999, 5848, 6001,5999, 6001, 5996,5999, 5996, 5995,
6002, 6003, 6004,6002, 6004, 6005,6002, 6005, 6006,6002, 6006, 6007,
6002, 6007, 6008,6002, 6008, 6009,6002, 6009, 6010,6002, 6010, 6003,
6011, 6007, 6006,6011, 6006, 6012,6011, 6012, 5839,6011, 5839, 5838,
6011, 5838, 5837,6011, 5837, 6013,6011, 6013, 6008,6011, 6008, 6007,
6014, 6015, 6016,6014, 6016, 6017,6014, 6017, 6018,6014, 6018, 6019,
6014, 6019, 6020,6014, 6020, 6021,6014, 6021, 6022,6014, 6022, 6015,
6023, 6019, 6018,6023, 6018, 6024,6023, 6024, 5827,6023, 5827, 5826,
6023, 5826, 5825,6023, 5825, 6025,6023, 6025, 6020,6023, 6020, 6019,
6026, 6027, 6028,6026, 6028, 6029,6026, 6029, 6030,6026, 6030, 6031,
6026, 6031, 6032,6026, 6032, 6033,6026, 6033, 6034,6026, 6034, 6027,
6035, 6031, 6030,6035, 6030, 6036,6035, 6036, 5812,6035, 5812, 5811,
6035, 5811, 5810,6035, 5810, 6037,6035, 6037, 6032,6035, 6032, 6031,
6038, 6039, 6040,6038, 6040, 6041,6038, 6041, 6042,6038, 6042, 6043,
6038, 6043, 6044,6038, 6044, 6045,6038, 6045, 6046,6038, 6046, 6039,
6047, 6043, 6042,6047, 6042, 6048,6047, 6048, 5938,6047, 5938, 5937,
6047, 5937, 5941,6047, 5941, 6049,6047, 6049, 6044,6047, 6044, 6043,
6050, 5943, 5950,6050, 5950, 6051,6050, 6051, 6052,6050, 6052, 6053,
6050, 6053, 6054,6050, 6054, 6055,6050, 6055, 5944,6050, 5944, 5943,
6056, 6053, 6052,6056, 6052, 6057,6056, 6057, 6058,6056, 6058, 6059,
6056, 6059, 6060,6056, 6060, 6061,6056, 6061, 6054,6056, 6054, 6053,
6062, 6063, 6064,6062, 6064, 6065,6062, 6065, 6066,6062, 6066, 6067,
6062, 6067, 6068,6062, 6068, 6069,6062, 6069, 6070,6062, 6070, 6063,
6071, 6067, 6066,6071, 6066, 6072,6071, 6072, 5953,6071, 5953, 5952,
6071, 5952, 5956,6071, 5956, 6073,6071, 6073, 6068,6071, 6068, 6067,
6074, 5958, 5965,6074, 5965, 6075,6074, 6075, 6076,6074, 6076, 6077,
6074, 6077, 6078,6074, 6078, 6079,6074, 6079, 5959,6074, 5959, 5958,
6080, 6077, 6076,6080, 6076, 6081,6080, 6081, 6082,6080, 6082, 6083,
6080, 6083, 6084,6080, 6084, 6085,6080, 6085, 6078,6080, 6078, 6077,
6086, 6087, 6088,6086, 6088, 6089,6086, 6089, 6090,6086, 6090, 6091,
6086, 6091, 6092,6086, 6092, 6093,6086, 6093, 6094,6086, 6094, 6087,
6095, 6091, 6090,6095, 6090, 6096,6095, 6096, 5968,6095, 5968, 5967,
6095, 5967, 5974,6095, 5974, 6097,6095, 6097, 6092,6095, 6092, 6091,
6098, 6099, 6100,6098, 6100, 6101,6098, 6101, 6102,6098, 6102, 6103,
6098, 6103, 6104,6098, 6104, 6105,6098, 6105, 6106,6098, 6106, 6099,
6107, 6103, 6102,6107, 6102, 6108,6107, 6108, 5980,6107, 5980, 5979,
6107, 5979, 5986,6107, 5986, 6109,6107, 6109, 6104,6107, 6104, 6103,
6110, 6111, 6112,6110, 6112, 6113,6110, 6113, 6114,6110, 6114, 6115,
6110, 6115, 6116,6110, 6116, 6117,6110, 6117, 6118,6110, 6118, 6111,
6119, 6115, 6114,6119, 6114, 6120,6119, 6120, 5992,6119, 5992, 5991,
6119, 5991, 5998,6119, 5998, 6121,6119, 6121, 6116,6119, 6116, 6115,
6122, 6123, 6124,6122, 6124, 6125,6122, 6125, 6126,6122, 6126, 6127,
6122, 6127, 6128,6122, 6128, 6129,6122, 6129, 6130,6122, 6130, 6123,
6131, 6127, 6126,6131, 6126, 6132,6131, 6132, 6133,6131, 6133, 6134,
6131, 6134, 6135,6131, 6135, 6136,6131, 6136, 6128,6131, 6128, 6127,
6137, 6138, 6139,6137, 6139, 6140,6137, 6140, 5931,6137, 5931, 6141,
6137, 6141, 6142,6137, 6142, 6143,6137, 6143, 6144,6137, 6144, 6138,
6145, 6138, 6144,6145, 6144, 6146,6145, 6146, 6016,6145, 6016, 6015,
6145, 6015, 6022,6145, 6022, 6147,6145, 6147, 6139,6145, 6139, 6138,
6148, 6149, 6150,6148, 6150, 6151,6148, 6151, 6152,6148, 6152, 6153,
6148, 6153, 6154,6148, 6154, 6155,6148, 6155, 6156,6148, 6156, 6149,
6157, 6153, 6152,6157, 6152, 6158,6157, 6158, 6159,6157, 6159, 6160,
6157, 6160, 6161,6157, 6161, 6162,6157, 6162, 6154,6157, 6154, 6153,
6163, 6164, 6165,6163, 6165, 6166,6163, 6166, 6167,6163, 6167, 6168,
6163, 6168, 6090,6163, 6090, 6089,6163, 6089, 6088,6163, 6088, 6164,
6169, 6168, 6167,6169, 6167, 6170,6169, 6170, 6171,6169, 6171, 6172,
6169, 6172, 5968,6169, 5968, 6096,6169, 6096, 6090,6169, 6090, 6168,
6173, 6174, 6106,6173, 6106, 6105,6173, 6105, 6104,6173, 6104, 6175,
6173, 6175, 6176,6173, 6176, 6177,6173, 6177, 6178,6173, 6178, 6174,
6179, 6175, 6104,6179, 6104, 6109,6179, 6109, 5986,6179, 5986, 6180,
6179, 6180, 6181,6179, 6181, 6182,6179, 6182, 6176,6179, 6176, 6175,
6183, 6184, 6185,6183, 6185, 6186,6183, 6186, 6187,6183, 6187, 6188,
6183, 6188, 6167,6183, 6167, 6166,6183, 6166, 6165,6183, 6165, 6184,
6189, 6188, 6187,6189, 6187, 6190,6189, 6190, 6191,6189, 6191, 6192,
6189, 6192, 6171,6189, 6171, 6170,6189, 6170, 6167,6189, 6167, 6188,
6193, 6194, 6195,6193, 6195, 6196,6193, 6196, 6197,6193, 6197, 6198,
6193, 6198, 6187,6193, 6187, 6186,6193, 6186, 6185,6193, 6185, 6194,
6199, 6198, 6197,6199, 6197, 6200,6199, 6200, 6201,6199, 6201, 6202,
6199, 6202, 6191,6199, 6191, 6190,6199, 6190, 6187,6199, 6187, 6198,
6203, 6204, 6205,6203, 6205, 6206,6203, 6206, 6207,6203, 6207, 6208,
6203, 6208, 6209,6203, 6209, 6210,6203, 6210, 6211,6203, 6211, 6204,
6212, 6208, 6207,6212, 6207, 6213,6212, 6213, 6214,6212, 6214, 6215,
6212, 6215, 6216,6212, 6216, 6217,6212, 6217, 6209,6212, 6209, 6208,
6218, 6219, 6178,6218, 6178, 6177,6218, 6177, 6176,6218, 6176, 6220,
6218, 6220, 6207,6218, 6207, 6206,6218, 6206, 6205,6218, 6205, 6219,
6221, 6220, 6176,6221, 6176, 6182,6221, 6182, 6181,6221, 6181, 6222,
6221, 6222, 6214,6221, 6214, 6213,6221, 6213, 6207,6221, 6207, 6220,
6223, 5669, 5668,6223, 5668, 6224,6223, 6224, 6225,6223, 6225, 6226,
6223, 6226, 6227,6223, 6227, 6228,6223, 6228, 5670,6223, 5670, 5669,
6229, 6226, 6225,6229, 6225, 6230,6229, 6230, 5696,6229, 5696, 5695,
6229, 5695, 5702,6229, 5702, 6231,6229, 6231, 6227,6229, 6227, 6226,
6232, 5678, 5677,6232, 5677, 6233,6232, 6233, 6234,6232, 6234, 6235,
6232, 6235, 6225,6232, 6225, 6224,6232, 6224, 5668,6232, 5668, 5678,
6236, 6235, 6234,6236, 6234, 6237,6236, 6237, 5705,6236, 5705, 5704,
6236, 5704, 5696,6236, 5696, 6230,6236, 6230, 6225,6236, 6225, 6235,
6238, 5714, 5713,6238, 5713, 6239,6238, 6239, 6240,6238, 6240, 6241,
6238, 6241, 6242,6238, 6242, 6243,6238, 6243, 5715,6238, 5715, 5714,
6244, 6241, 6240,6244, 6240, 6245,6244, 6245, 5681,6244, 5681, 5680,
6244, 5680, 5687,6244, 5687, 6246,6244, 6246, 6242,6244, 6242, 6241,
6247, 5723, 5722,6247, 5722, 6248,6247, 6248, 6249,6247, 6249, 6250,
6247, 6250, 6240,6247, 6240, 6239,6247, 6239, 5713,6247, 5713, 5723,
6251, 6250, 6249,6251, 6249, 6252,6251, 6252, 5691,6251, 5691, 5690,
6251, 5690, 5681,6251, 5681, 6245,6251, 6245, 6240,6251, 6240, 6250,
6253, 5779, 5778,6253, 5778, 6254,6253, 6254, 6255,6253, 6255, 6256,
6253, 6256, 6257,6253, 6257, 6258,6253, 6258, 5780,6253, 5780, 5779,
6259, 6256, 6255,6259, 6255, 6260,6259, 6260, 5746,6259, 5746, 5745,
6259, 5745, 5752,6259, 5752, 6261,6259, 6261, 6257,6259, 6257, 6256,
6262, 5788, 5787,6262, 5787, 6263,6262, 6263, 6264,6262, 6264, 6265,
6262, 6265, 6255,6262, 6255, 6254,6262, 6254, 5778,6262, 5778, 5788,
6266, 6265, 6264,6266, 6264, 6267,6266, 6267, 5755,6266, 5755, 5754,
6266, 5754, 5746,6266, 5746, 6260,6266, 6260, 6255,6266, 6255, 6265,
6268, 5794, 5793,6268, 5793, 6269,6268, 6269, 6270,6268, 6270, 6271,
6268, 6271, 6272,6268, 6272, 6273,6268, 6273, 5795,6268, 5795, 5794,
6274, 6271, 6270,6274, 6270, 6275,6274, 6275, 5761,6274, 5761, 5760,
6274, 5760, 5767,6274, 5767, 6276,6274, 6276, 6272,6274, 6272, 6271,
6277, 5803, 5802,6277, 5802, 6278,6277, 6278, 6279,6277, 6279, 6280,
6277, 6280, 6270,6277, 6270, 6269,6277, 6269, 5793,6277, 5793, 5803,
6281, 6280, 6279,6281, 6279, 6282,6281, 6282, 5770,6281, 5770, 5769,
6281, 5769, 5761,6281, 5761, 6275,6281, 6275, 6270,6281, 6270, 6280,
6283, 5809, 5808,6283, 5808, 6284,6283, 6284, 6285,6283, 6285, 6286,
6283, 6286, 6287,6283, 6287, 6288,6283, 6288, 5810,6283, 5810, 5809,
6289, 6286, 6285,6289, 6285, 6290,6289, 6290, 5833,6289, 5833, 5832,
6289, 5832, 5839,6289, 5839, 6291,6289, 6291, 6287,6289, 6287, 6286,
6292, 5818, 5817,6292, 5817, 6293,6292, 6293, 6294,6292, 6294, 6295,
6292, 6295, 6285,6292, 6285, 6284,6292, 6284, 5808,6292, 5808, 5818,
6296, 6295, 6294,6296, 6294, 6297,6296, 6297, 5842,6296, 5842, 5841,
6296, 5841, 5833,6296, 5833, 6290,6296, 6290, 6285,6296, 6285, 6295,
6298, 5847, 5854,6298, 5854, 6299,6298, 6299, 6300,6298, 6300, 6301,
6298, 6301, 6302,6298, 6302, 6303,6298, 6303, 5848,6298, 5848, 5847,
6304, 6301, 6300,6304, 6300, 6305,6304, 6305, 5821,6304, 5821, 5820,
6304, 5820, 5827,6304, 5827, 6306,6304, 6306, 6302,6304, 6302, 6301,
6307, 5857, 5715,6307, 5715, 6243,6307, 6243, 6242,6307, 6242, 6308,
6307, 6308, 6300,6307, 6300, 6299,6307, 6299, 5854,6307, 5854, 5857,
6309, 6308, 6242,6309, 6242, 6246,6309, 6246, 5687,6309, 5687, 5829,
6309, 5829, 5821,6309, 5821, 6305,6309, 6305, 6300,6309, 6300, 6308,
6310, 5884, 5755,6310, 5755, 6267,6310, 6267, 6264,6310, 6264, 6311,
6310, 6311, 6312,6310, 6312, 6313,6310, 6313, 5885,6310, 5885, 5884,
6314, 6311, 6264,6314, 6264, 6263,6314, 6263, 5787,6314, 5787, 5895,
6314, 5895, 5899,6314, 5899, 6315,6314, 6315, 6312,6314, 6312, 6311,
6316, 5902, 5795,6316, 5795, 6273,6316, 6273, 6272,6316, 6272, 6317,
6316, 6317, 6318,6316, 6318, 6319,6316, 6319, 5903,6316, 5903, 5902,
6320, 6317, 6272,6320, 6272, 6276,6320, 6276, 5767,6320, 5767, 5889,
6320, 5889, 5893,6320, 5893, 6321,6320, 6321, 6318,6320, 6318, 6317,
6322, 5909, 5908,6322, 5908, 6323,6322, 6323, 6324,6322, 6324, 6325,
6322, 6325, 6318,6322, 6318, 6321,6322, 6321, 5893,6322, 5893, 5909,
6326, 6325, 6324,6326, 6324, 6327,6326, 6327, 5914,6326, 5914, 5913,
6326, 5913, 5903,6326, 5903, 6319,6326, 6319, 6318,6326, 6318, 6325,
6328, 5928, 5935,6328, 5935, 6329,6328, 6329, 6330,6328, 6330, 6331,
6328, 6331, 6332,6328, 6332, 6333,6328, 6333, 5929,6328, 5929, 5928,
6334, 6331, 6330,6334, 6330, 6335,6334, 6335, 5920,6334, 5920, 5919,
6334, 5919, 5926,6334, 5926, 6336,6334, 6336, 6332,6334, 6332, 6331,
6337, 5940, 5920,6337, 5920, 6335,6337, 6335, 6330,6337, 6330, 6338,
6337, 6338, 6339,6337, 6339, 6340,6337, 6340, 5941,6337, 5941, 5940,
6341, 6338, 6330,6341, 6330, 6329,6341, 6329, 5935,6341, 5935, 5954,
6341, 5954, 5953,6341, 5953, 6342,6341, 6342, 6339,6341, 6339, 6338,
6343, 5964, 5963,6343, 5963, 6344,6343, 6344, 6345,6343, 6345, 6346,
6343, 6346, 6347,6343, 6347, 6348,6343, 6348, 5965,6343, 5965, 5964,
6349, 6346, 6345,6349, 6345, 6350,6349, 6350, 5946,6349, 5946, 5945,
6349, 5945, 5944,6349, 5944, 6351,6349, 6351, 6347,6349, 6347, 6346,
6352, 5997, 5996,6352, 5996, 6353,6352, 6353, 6354,6352, 6354, 6355,
6352, 6355, 6356,6352, 6356, 6357,6352, 6357, 5998,6352, 5998, 5997,
6358, 6355, 6354,6358, 6354, 6359,6358, 6359, 6018,6358, 6018, 6017,
6358, 6017, 6016,6358, 6016, 6360,6358, 6360, 6356,6358, 6356, 6355,
6361, 6001, 5848,6361, 5848, 6303,6361, 6303, 6302,6361, 6302, 6362,
6361, 6362, 6354,6361, 6354, 6353,6361, 6353, 5996,6361, 5996, 6001,
6363, 6362, 6302,6363, 6302, 6306,6363, 6306, 5827,6363, 5827, 6024,
6363, 6024, 6018,6363, 6018, 6359,6363, 6359, 6354,6363, 6354, 6362,
6364, 6033, 6032,6364, 6032, 6365,6364, 6365, 6366,6364, 6366, 6367,
6364, 6367, 6368,6364, 6368, 6369,6364, 6369, 6034,6364, 6034, 6033,
6370, 6367, 6366,6370, 6366, 6371,6370, 6371, 6006,6370, 6006, 6005,
6370, 6005, 6004,6370, 6004, 6372,6370, 6372, 6368,6370, 6368, 6367,
6373, 6037, 5810,6373, 5810, 6288,6373, 6288, 6287,6373, 6287, 6374,
6373, 6374, 6366,6373, 6366, 6365,6373, 6365, 6032,6373, 6032, 6037,
6375, 6374, 6287,6375, 6287, 6291,6375, 6291, 5839,6375, 5839, 6012,
6375, 6012, 6006,6375, 6006, 6371,6375, 6371, 6366,6375, 6366, 6374,
6376, 6045, 6044,6376, 6044, 6377,6376, 6377, 6378,6376, 6378, 6379,
6376, 6379, 6380,6376, 6380, 6381,6376, 6381, 6046,6376, 6046, 6045,
6382, 6379, 6378,6382, 6378, 6383,6382, 6383, 6066,6382, 6066, 6065,
6382, 6065, 6064,6382, 6064, 6384,6382, 6384, 6380,6382, 6380, 6379,
6385, 6049, 5941,6385, 5941, 6340,6385, 6340, 6339,6385, 6339, 6386,
6385, 6386, 6378,6385, 6378, 6377,6385, 6377, 6044,6385, 6044, 6049,
6387, 6386, 6339,6387, 6339, 6342,6387, 6342, 5953,6387, 5953, 6072,
6387, 6072, 6066,6387, 6066, 6383,6387, 6383, 6378,6387, 6378, 6386,
6388, 6055, 6054,6388, 6054, 6389,6388, 6389, 6390,6388, 6390, 6391,
6388, 6391, 6347,6388, 6347, 6351,6388, 6351, 5944,6388, 5944, 6055,
6392, 6391, 6390,6392, 6390, 6393,6392, 6393, 6076,6392, 6076, 6075,
6392, 6075, 5965,6392, 5965, 6348,6392, 6348, 6347,6392, 6347, 6391,
6394, 6061, 6060,6394, 6060, 6395,6394, 6395, 6396,6394, 6396, 6397,
6394, 6397, 6390,6394, 6390, 6389,6394, 6389, 6054,6394, 6054, 6061,
6398, 6397, 6396,6398, 6396, 6399,6398, 6399, 6082,6398, 6082, 6081,
6398, 6081, 6076,6398, 6076, 6393,6398, 6393, 6390,6398, 6390, 6397,
6400, 6117, 6116,6400, 6116, 6401,6400, 6401, 6402,6400, 6402, 6403,
6400, 6403, 6404,6400, 6404, 6405,6400, 6405, 6118,6400, 6118, 6117,
6406, 6403, 6402,6406, 6402, 6407,6406, 6407, 6144,6406, 6144, 6143,
6406, 6143, 6142,6406, 6142, 6408,6406, 6408, 6404,6406, 6404, 6403,
6409, 6121, 5998,6409, 5998, 6357,6409, 6357, 6356,6409, 6356, 6410,
6409, 6410, 6402,6409, 6402, 6401,6409, 6401, 6116,6409, 6116, 6121,
6411, 6410, 6356,6411, 6356, 6360,6411, 6360, 6016,6411, 6016, 6146,
6411, 6146, 6144,6411, 6144, 6407,6411, 6407, 6402,6411, 6402, 6410,
6412, 6155, 6154,6412, 6154, 6413,6412, 6413, 6414,6412, 6414, 6415,
6412, 6415, 6416,6412, 6416, 6417,6412, 6417, 6156,6412, 6156, 6155,
6418, 6415, 6414,6418, 6414, 6419,6418, 6419, 6126,6418, 6126, 6125,
6418, 6125, 6124,6418, 6124, 6420,6418, 6420, 6416,6418, 6416, 6415,
6421, 6162, 6161,6421, 6161, 6422,6421, 6422, 6423,6421, 6423, 6424,
6421, 6424, 6414,6421, 6414, 6413,6421, 6413, 6154,6421, 6154, 6162,
6425, 6424, 6423,6425, 6423, 6426,6425, 6426, 6133,6425, 6133, 6132,
6425, 6132, 6126,6425, 6126, 6419,6425, 6419, 6414,6425, 6414, 6424,
6427, 6428, 6429,6427, 6429, 6430,6427, 6430, 6431,6427, 6431, 6432,
6427, 6432, 6433,6427, 6433, 6434,6427, 6434, 6435,6427, 6435, 6428,
6436, 6432, 6431,6436, 6431, 6437,6436, 6437, 6438,6436, 6438, 6439,
6436, 6439, 6440,6436, 6440, 6441,6436, 6441, 6433,6436, 6433, 6432,
6442, 6443, 6444,6442, 6444, 6445,6442, 6445, 6440,6442, 6440, 6439,
6442, 6439, 6438,6442, 6438, 6446,6442, 6446, 6447,6442, 6447, 6443,
6448, 6449, 6450,6448, 6450, 6451,6448, 6451, 6452,6448, 6452, 6453,
6448, 6453, 6431,6448, 6431, 6430,6448, 6430, 6429,6448, 6429, 6449,
6454, 6453, 6452,6454, 6452, 6455,6454, 6455, 6456,6454, 6456, 6457,
6454, 6457, 6438,6454, 6438, 6437,6454, 6437, 6431,6454, 6431, 6453,
6458, 6457, 6456,6458, 6456, 6459,6458, 6459, 6460,6458, 6460, 6461,
6458, 6461, 6447,6458, 6447, 6446,6458, 6446, 6438,6458, 6438, 6457,
6462, 6463, 6464,6462, 6464, 6465,6462, 6465, 6466,6462, 6466, 6467,
6462, 6467, 6452,6462, 6452, 6451,6462, 6451, 6450,6462, 6450, 6463,
6468, 6467, 6466,6468, 6466, 6469,6468, 6469, 6470,6468, 6470, 6471,
6468, 6471, 6456,6468, 6456, 6455,6468, 6455, 6452,6468, 6452, 6467,
6472, 6471, 6470,6472, 6470, 6473,6472, 6473, 6474,6472, 6474, 6475,
6472, 6475, 6460,6472, 6460, 6459,6472, 6459, 6456,6472, 6456, 6471,
6476, 6477, 6478,6476, 6478, 6479,6476, 6479, 6480,6476, 6480, 6481,
6476, 6481, 6482,6476, 6482, 6483,6476, 6483, 6484,6476, 6484, 6477,
6485, 6486, 6487,6485, 6487, 6488,6485, 6488, 6489,6485, 6489, 6490,
6485, 6490, 6480,6485, 6480, 6479,6485, 6479, 6478,6485, 6478, 6486,
6491, 6492, 6493,6491, 6493, 6494,6491, 6494, 6495,6491, 6495, 6496,
6491, 6496, 6489,6491, 6489, 6488,6491, 6488, 6487,6491, 6487, 6492,
6497, 6498, 6499,6497, 6499, 6500,6497, 6500, 6501,6497, 6501, 6502,
6497, 6502, 6503,6497, 6503, 6504,6497, 6504, 6505,6497, 6505, 6498,
6506, 6507, 6508,6506, 6508, 6509,6506, 6509, 6510,6506, 6510, 6511,
6506, 6511, 6501,6506, 6501, 6500,6506, 6500, 6499,6506, 6499, 6507,
6512, 6513, 6514,6512, 6514, 6515,6512, 6515, 6516,6512, 6516, 6517,
6512, 6517, 6510,6512, 6510, 6509,6512, 6509, 6508,6512, 6508, 6513,
6518, 6519, 6520,6518, 6520, 6521,6518, 6521, 6522,6518, 6522, 6523,
6518, 6523, 6524,6518, 6524, 6525,6518, 6525, 6526,6518, 6526, 6519,
6527, 6528, 6529,6527, 6529, 6530,6527, 6530, 6531,6527, 6531, 6532,
6527, 6532, 6526,6527, 6526, 6525,6527, 6525, 6524,6527, 6524, 6528,
6533, 6534, 6535,6533, 6535, 6536,6533, 6536, 6537,6533, 6537, 6538,
6533, 6538, 6531,6533, 6531, 6530,6533, 6530, 6529,6533, 6529, 6534,
6539, 6540, 6541,6539, 6541, 6542,6539, 6542, 6543,6539, 6543, 6544,
6539, 6544, 6545,6539, 6545, 6546,6539, 6546, 6547,6539, 6547, 6540,
6548, 6549, 6550,6548, 6550, 6551,6548, 6551, 6552,6548, 6552, 6553,
6548, 6553, 6543,6548, 6543, 6542,6548, 6542, 6541,6548, 6541, 6549,
6554, 6555, 6556,6554, 6556, 6557,6554, 6557, 6558,6554, 6558, 6559,
6554, 6559, 6552,6554, 6552, 6551,6554, 6551, 6550,6554, 6550, 6555,
6560, 6561, 6562,6560, 6562, 6563,6560, 6563, 6478,6560, 6478, 6477,
6560, 6477, 6484,6560, 6484, 6564,6560, 6564, 6565,6560, 6565, 6561,
6566, 6567, 6568,6566, 6568, 6569,6566, 6569, 6487,6566, 6487, 6486,
6566, 6486, 6478,6566, 6478, 6563,6566, 6563, 6562,6566, 6562, 6567,
6570, 6571, 6572,6570, 6572, 6573,6570, 6573, 6493,6570, 6493, 6492,
6570, 6492, 6487,6570, 6487, 6569,6570, 6569, 6568,6570, 6568, 6571,
6574, 6502, 6501,6574, 6501, 6575,6574, 6575, 6576,6574, 6576, 6577,
6574, 6577, 6578,6574, 6578, 6579,6574, 6579, 6503,6574, 6503, 6502,
6580, 6511, 6510,6580, 6510, 6581,6580, 6581, 6582,6580, 6582, 6583,
6580, 6583, 6576,6580, 6576, 6575,6580, 6575, 6501,6580, 6501, 6511,
6584, 6517, 6516,6584, 6516, 6585,6584, 6585, 6586,6584, 6586, 6587,
6584, 6587, 6582,6584, 6582, 6581,6584, 6581, 6510,6584, 6510, 6517,
6588, 6589, 6590,6588, 6590, 6591,6588, 6591, 6524,6588, 6524, 6523,
6588, 6523, 6522,6588, 6522, 6592,6588, 6592, 6593,6588, 6593, 6589,
6594, 6595, 6596,6594, 6596, 6597,6594, 6597, 6529,6594, 6529, 6528,
6594, 6528, 6524,6594, 6524, 6591,6594, 6591, 6590,6594, 6590, 6595,
6598, 6599, 6600,6598, 6600, 6601,6598, 6601, 6535,6598, 6535, 6534,
6598, 6534, 6529,6598, 6529, 6597,6598, 6597, 6596,6598, 6596, 6599,
6602, 6603, 6604,6602, 6604, 6605,6602, 6605, 6541,6602, 6541, 6540,
6602, 6540, 6547,6602, 6547, 6606,6602, 6606, 6607,6602, 6607, 6603,
6608, 6609, 6610,6608, 6610, 6611,6608, 6611, 6550,6608, 6550, 6549,
6608, 6549, 6541,6608, 6541, 6605,6608, 6605, 6604,6608, 6604, 6609,
6612, 6613, 6614,6612, 6614, 6615,6612, 6615, 6556,6612, 6556, 6555,
6612, 6555, 6550,6612, 6550, 6611,6612, 6611, 6610,6612, 6610, 6613,
6616, 6617, 6614,6616, 6614, 6613,6616, 6613, 6610,6616, 6610, 6618,
6616, 6618, 6619,6616, 6619, 6620,6616, 6620, 6621,6616, 6621, 6617,
6622, 6618, 6610,6622, 6610, 6609,6622, 6609, 6604,6622, 6604, 6623,
6622, 6623, 6624,6622, 6624, 6625,6622, 6625, 6619,6622, 6619, 6618,
6626, 6623, 6604,6626, 6604, 6603,6626, 6603, 6607,6626, 6607, 6627,
6626, 6627, 6628,6626, 6628, 6629,6626, 6629, 6624,6626, 6624, 6623,
6630, 6631, 6600,6630, 6600, 6599,6630, 6599, 6596,6630, 6596, 6632,
6630, 6632, 6633,6630, 6633, 6634,6630, 6634, 6635,6630, 6635, 6631,
6636, 6632, 6596,6636, 6596, 6595,6636, 6595, 6590,6636, 6590, 6637,
6636, 6637, 6638,6636, 6638, 6639,6636, 6639, 6633,6636, 6633, 6632,
6640, 6637, 6590,6640, 6590, 6589,6640, 6589, 6593,6640, 6593, 6641,
6640, 6641, 6642,6640, 6642, 6643,6640, 6643, 6638,6640, 6638, 6637,
6644, 6645, 6646,6644, 6646, 6647,6644, 6647, 6648,6644, 6648, 6649,
6644, 6649, 6582,6644, 6582, 6587,6644, 6587, 6586,6644, 6586, 6645,
6650, 6649, 6648,6650, 6648, 6651,6650, 6651, 6652,6650, 6652, 6653,
6650, 6653, 6576,6650, 6576, 6583,6650, 6583, 6582,6650, 6582, 6649,
6654, 6653, 6652,6654, 6652, 6655,6654, 6655, 6656,6654, 6656, 6657,
6654, 6657, 6578,6654, 6578, 6577,6654, 6577, 6576,6654, 6576, 6653,
6658, 6659, 6572,6658, 6572, 6571,6658, 6571, 6568,6658, 6568, 6660,
6658, 6660, 6661,6658, 6661, 6662,6658, 6662, 6663,6658, 6663, 6659,
6664, 6660, 6568,6664, 6568, 6567,6664, 6567, 6562,6664, 6562, 6665,
6664, 6665, 6666,6664, 6666, 6667,6664, 6667, 6661,6664, 6661, 6660,
6668, 6665, 6562,6668, 6562, 6561,6668, 6561, 6565,6668, 6565, 6669,
6668, 6669, 6670,6668, 6670, 6671,6668, 6671, 6666,6668, 6666, 6665,
6672, 6673, 6621,6672, 6621, 6620,6672, 6620, 6619,6672, 6619, 6674,
6672, 6674, 6675,6672, 6675, 6676,6672, 6676, 6677,6672, 6677, 6673,
6678, 6674, 6619,6678, 6619, 6625,6678, 6625, 6624,6678, 6624, 6679,
6678, 6679, 6680,6678, 6680, 6681,6678, 6681, 6675,6678, 6675, 6674,
6682, 6679, 6624,6682, 6624, 6629,6682, 6629, 6628,6682, 6628, 6683,
6682, 6683, 6684,6682, 6684, 6685,6682, 6685, 6680,6682, 6680, 6679,
6686, 6687, 6635,6686, 6635, 6634,6686, 6634, 6633,6686, 6633, 6688,
6686, 6688, 6689,6686, 6689, 6690,6686, 6690, 6691,6686, 6691, 6687,
6692, 6688, 6633,6692, 6633, 6639,6692, 6639, 6638,6692, 6638, 6693,
6692, 6693, 6694,6692, 6694, 6695,6692, 6695, 6689,6692, 6689, 6688,
6696, 6693, 6638,6696, 6638, 6643,6696, 6643, 6642,6696, 6642, 6697,
6696, 6697, 6698,6696, 6698, 6699,6696, 6699, 6694,6696, 6694, 6693,
6700, 6701, 6702,6700, 6702, 6703,6700, 6703, 6704,6700, 6704, 6705,
6700, 6705, 6648,6700, 6648, 6647,6700, 6647, 6646,6700, 6646, 6701,
6706, 6705, 6704,6706, 6704, 6707,6706, 6707, 6708,6706, 6708, 6709,
6706, 6709, 6652,6706, 6652, 6651,6706, 6651, 6648,6706, 6648, 6705,
6710, 6709, 6708,6710, 6708, 6711,6710, 6711, 6712,6710, 6712, 6713,
6710, 6713, 6656,6710, 6656, 6655,6710, 6655, 6652,6710, 6652, 6709,
6714, 6715, 6663,6714, 6663, 6662,6714, 6662, 6661,6714, 6661, 6716,
6714, 6716, 6717,6714, 6717, 6718,6714, 6718, 6719,6714, 6719, 6715,
6720, 6716, 6661,6720, 6661, 6667,6720, 6667, 6666,6720, 6666, 6721,
6720, 6721, 6722,6720, 6722, 6723,6720, 6723, 6717,6720, 6717, 6716,
6724, 6721, 6666,6724, 6666, 6671,6724, 6671, 6670,6724, 6670, 6725,
6724, 6725, 6726,6724, 6726, 6727,6724, 6727, 6722,6724, 6722, 6721,
6728, 6729, 6730,6728, 6730, 6731,6728, 6731, 6732,6728, 6732, 6733,
6728, 6733, 6734,6728, 6734, 6735,6728, 6735, 6736,6728, 6736, 6729,
6737, 6738, 6739,6737, 6739, 6740,6737, 6740, 6741,6737, 6741, 6742,
6737, 6742, 6732,6737, 6732, 6731,6737, 6731, 6730,6737, 6730, 6738,
6743, 6744, 6745,6743, 6745, 6746,6743, 6746, 6747,6743, 6747, 6748,
6743, 6748, 6741,6743, 6741, 6740,6743, 6740, 6739,6743, 6739, 6744,
6749, 6733, 6732,6749, 6732, 6750,6749, 6750, 6751,6749, 6751, 6752,
6749, 6752, 6753,6749, 6753, 6754,6749, 6754, 6734,6749, 6734, 6733,
6755, 6742, 6741,6755, 6741, 6756,6755, 6756, 6757,6755, 6757, 6758,
6755, 6758, 6751,6755, 6751, 6750,6755, 6750, 6732,6755, 6732, 6742,
6759, 6748, 6747,6759, 6747, 6760,6759, 6760, 6761,6759, 6761, 6762,
6759, 6762, 6757,6759, 6757, 6756,6759, 6756, 6741,6759, 6741, 6748,
6763, 6752, 6751,6763, 6751, 6764,6763, 6764, 6765,6763, 6765, 6766,
6763, 6766, 6767,6763, 6767, 6768,6763, 6768, 6753,6763, 6753, 6752,
6769, 6758, 6757,6769, 6757, 6770,6769, 6770, 6771,6769, 6771, 6772,
6769, 6772, 6765,6769, 6765, 6764,6769, 6764, 6751,6769, 6751, 6758,
6773, 6762, 6761,6773, 6761, 6774,6773, 6774, 6775,6773, 6775, 6776,
6773, 6776, 6771,6773, 6771, 6770,6773, 6770, 6757,6773, 6757, 6762,
6777, 6778, 6779,6777, 6779, 6780,6777, 6780, 6781,6777, 6781, 6782,
6777, 6782, 6783,6777, 6783, 6784,6777, 6784, 6785,6777, 6785, 6778,
6786, 6787, 6788,6786, 6788, 6789,6786, 6789, 6790,6786, 6790, 6791,
6786, 6791, 6792,6786, 6792, 6793,6786, 6793, 6794,6786, 6794, 6787,
6795, 6789, 6788,6795, 6788, 6796,6795, 6796, 6797,6795, 6797, 6798,
6795, 6798, 6799,6795, 6799, 6800,6795, 6800, 6790,6795, 6790, 6789,
6801, 6802, 6779,6801, 6779, 6778,6801, 6778, 6785,6801, 6785, 6803,
6801, 6803, 6804,6801, 6804, 6805,6801, 6805, 6806,6801, 6806, 6802,
6807, 6808, 6809,6807, 6809, 6810,6807, 6810, 6811,6807, 6811, 6812,
6807, 6812, 6813,6807, 6813, 6814,6807, 6814, 6815,6807, 6815, 6808,
6816, 6817, 6818,6816, 6818, 6819,6816, 6819, 6820,6816, 6820, 6821,
6816, 6821, 6822,6816, 6822, 6823,6816, 6823, 6824,6816, 6824, 6817,
6825, 6819, 6818,6825, 6818, 6826,6825, 6826, 6827,6825, 6827, 6828,
6825, 6828, 6829,6825, 6829, 6830,6825, 6830, 6820,6825, 6820, 6819,
6831, 6826, 6818,6831, 6818, 6832,6831, 6832, 6833,6831, 6833, 6834,
6831, 6834, 6835,6831, 6835, 6836,6831, 6836, 6827,6831, 6827, 6826,
6837, 6838, 6839,6837, 6839, 6840,6837, 6840, 6841,6837, 6841, 6842,
6837, 6842, 6843,6837, 6843, 6844,6837, 6844, 6845,6837, 6845, 6838,
6846, 6840, 6839,6846, 6839, 6847,6846, 6847, 6785,6846, 6785, 6784,
6846, 6784, 6783,6846, 6783, 6848,6846, 6848, 6841,6846, 6841, 6840,
6849, 6847, 6839,6849, 6839, 6850,6849, 6850, 6851,6849, 6851, 6852,
6849, 6852, 6804,6849, 6804, 6803,6849, 6803, 6785,6849, 6785, 6847,
6853, 6850, 6839,6853, 6839, 6838,6853, 6838, 6845,6853, 6845, 6854,
6853, 6854, 6855,6853, 6855, 6856,6853, 6856, 6851,6853, 6851, 6850,
6857, 6858, 6859,6857, 6859, 6860,6857, 6860, 6861,6857, 6861, 6862,
6857, 6862, 6863,6857, 6863, 6864,6857, 6864, 6865,6857, 6865, 6858,
6866, 6860, 6859,6866, 6859, 6867,6866, 6867, 6868,6866, 6868, 6869,
6866, 6869, 6870,6866, 6870, 6871,6866, 6871, 6861,6866, 6861, 6860,
6872, 6867, 6859,6872, 6859, 6873,6872, 6873, 6874,6872, 6874, 6875,
6872, 6875, 6876,6872, 6876, 6877,6872, 6877, 6868,6872, 6868, 6867,
6878, 6873, 6859,6878, 6859, 6858,6878, 6858, 6865,6878, 6865, 6879,
6878, 6879, 6880,6878, 6880, 6881,6878, 6881, 6874,6878, 6874, 6873,
6882, 6883, 6884,6882, 6884, 6885,6882, 6885, 6851,6882, 6851, 6856,
6882, 6856, 6855,6882, 6855, 6886,6882, 6886, 6887,6882, 6887, 6883,
6888, 6885, 6884,6888, 6884, 6889,6888, 6889, 6806,6888, 6806, 6805,
6888, 6805, 6804,6888, 6804, 6852,6888, 6852, 6851,6888, 6851, 6885,
6890, 6891, 6892,6890, 6892, 6893,6890, 6893, 6894,6890, 6894, 6895,
6890, 6895, 6896,6890, 6896, 6897,6890, 6897, 6898,6890, 6898, 6891,
6899, 6900, 6884,6899, 6884, 6883,6899, 6883, 6887,6899, 6887, 6901,
6899, 6901, 6902,6899, 6902, 6903,6899, 6903, 6904,6899, 6904, 6900,
6905, 6906, 6907,6905, 6907, 6908,6905, 6908, 6909,6905, 6909, 6910,
6905, 6910, 6911,6905, 6911, 6912,6905, 6912, 6913,6905, 6913, 6906,
6914, 6908, 6907,6914, 6907, 6915,6914, 6915, 6916,6914, 6916, 6917,
6914, 6917, 6918,6914, 6918, 6919,6914, 6919, 6909,6914, 6909, 6908,
6920, 6921, 6922,6920, 6922, 6923,6920, 6923, 6841,6920, 6841, 6848,
6920, 6848, 6783,6920, 6783, 6782,6920, 6782, 6781,6920, 6781, 6921,
6924, 6923, 6922,6924, 6922, 6925,6924, 6925, 6926,6924, 6926, 6927,
6924, 6927, 6843,6924, 6843, 6842,6924, 6842, 6841,6924, 6841, 6923,
6928, 6929, 6930,6928, 6930, 6931,6928, 6931, 6932,6928, 6932, 6933,
6928, 6933, 6934,6928, 6934, 6935,6928, 6935, 6936,6928, 6936, 6929,
6937, 6931, 6930,6937, 6930, 6938,6937, 6938, 6815,6937, 6815, 6814,
6937, 6814, 6813,6937, 6813, 6939,6937, 6939, 6932,6937, 6932, 6931,
6940, 6938, 6930,6940, 6930, 6941,6940, 6941, 6942,6940, 6942, 6943,
6940, 6943, 6944,6940, 6944, 6945,6940, 6945, 6815,6940, 6815, 6938,
6946, 6941, 6930,6946, 6930, 6929,6946, 6929, 6936,6946, 6936, 6947,
6946, 6947, 6948,6946, 6948, 6949,6946, 6949, 6942,6946, 6942, 6941,
6950, 6951, 6952,6950, 6952, 6953,6950, 6953, 6954,6950, 6954, 6955,
6950, 6955, 6956,6950, 6956, 6957,6950, 6957, 6958,6950, 6958, 6951,
6959, 6953, 6952,6959, 6952, 6960,6959, 6960, 6961,6959, 6961, 6962,
6959, 6962, 6963,6959, 6963, 6964,6959, 6964, 6954,6959, 6954, 6953,
6965, 6960, 6952,6965, 6952, 6966,6965, 6966, 6967,6965, 6967, 6968,
6965, 6968, 6969,6965, 6969, 6970,6965, 6970, 6961,6965, 6961, 6960,
6971, 6966, 6952,6971, 6952, 6951,6971, 6951, 6958,6971, 6958, 6972,
6971, 6972, 6973,6971, 6973, 6974,6971, 6974, 6967,6971, 6967, 6966,
6975, 6976, 6977,6975, 6977, 6978,6975, 6978, 6932,6975, 6932, 6939,
6975, 6939, 6813,6975, 6813, 6812,6975, 6812, 6811,6975, 6811, 6976,
6979, 6978, 6977,6979, 6977, 6980,6979, 6980, 6981,6979, 6981, 6982,
6979, 6982, 6934,6979, 6934, 6933,6979, 6933, 6932,6979, 6932, 6978,
6983, 6984, 6985,6983, 6985, 6986,6983, 6986, 6987,6983, 6987, 6988,
6983, 6988, 6989,6983, 6989, 6990,6983, 6990, 6991,6983, 6991, 6984,
6992, 6986, 6985,6992, 6985, 6993,6992, 6993, 6994,6992, 6994, 6995,
6992, 6995, 6996,6992, 6996, 6997,6992, 6997, 6987,6992, 6987, 6986,
6998, 6999, 7000,6998, 7000, 7001,6998, 7001, 7002,6998, 7002, 7003,
6998, 7003, 7004,6998, 7004, 7005,6998, 7005, 7006,6998, 7006, 6999,
7007, 7001, 7000,7007, 7000, 7008,7007, 7008, 7009,7007, 7009, 7010,
7007, 7010, 7011,7007, 7011, 7012,7007, 7012, 7002,7007, 7002, 7001,
7013, 7014, 7015,7013, 7015, 7016,7013, 7016, 6942,7013, 6942, 6949,
7013, 6949, 6948,7013, 6948, 7017,7013, 7017, 7018,7013, 7018, 7014,
7019, 7016, 7015,7019, 7015, 7020,7019, 7020, 7021,7019, 7021, 7022,
7019, 7022, 6944,7019, 6944, 6943,7019, 6943, 6942,7019, 6942, 7016,
7023, 7024, 7025,7023, 7025, 7026,7023, 7026, 7027,7023, 7027, 7028,
7023, 7028, 7029,7023, 7029, 7030,7023, 7030, 7031,7023, 7031, 7024,
7032, 7026, 7025,7032, 7025, 7033,7032, 7033, 7034,7032, 7034, 7035,
7032, 7035, 7036,7032, 7036, 7037,7032, 7037, 7027,7032, 7027, 7026,
7038, 7033, 7025,7038, 7025, 7039,7038, 7039, 7040,7038, 7040, 7041,
7038, 7041, 7042,7038, 7042, 7043,7038, 7043, 7034,7038, 7034, 7033,
7044, 7039, 7025,7044, 7025, 7024,7044, 7024, 7031,7044, 7031, 7045,
7044, 7045, 7046,7044, 7046, 7047,7044, 7047, 7040,7044, 7040, 7039,
7048, 7049, 7050,7048, 7050, 7051,7048, 7051, 7052,7048, 7052, 7053,
7048, 7053, 7054,7048, 7054, 7055,7048, 7055, 7056,7048, 7056, 7049,
7057, 7051, 7050,7057, 7050, 7058,7057, 7058, 7059,7057, 7059, 7060,
7057, 7060, 7061,7057, 7061, 7062,7057, 7062, 7052,7057, 7052, 7051,
7063, 7058, 7050,7063, 7050, 7064,7063, 7064, 7065,7063, 7065, 7066,
7063, 7066, 7067,7063, 7067, 7068,7063, 7068, 7059,7063, 7059, 7058,
7069, 7064, 7050,7069, 7050, 7049,7069, 7049, 7056,7069, 7056, 7070,
7069, 7070, 7071,7069, 7071, 7072,7069, 7072, 7065,7069, 7065, 7064,
7073, 7074, 7075,7073, 7075, 7076,7073, 7076, 7077,7073, 7077, 7078,
7073, 7078, 7079,7073, 7079, 7080,7073, 7080, 7081,7073, 7081, 7074,
7082, 7076, 7075,7082, 7075, 7083,7082, 7083, 7084,7082, 7084, 7085,
7082, 7085, 7086,7082, 7086, 7087,7082, 7087, 7077,7082, 7077, 7076,
7088, 7083, 7075,7088, 7075, 7089,7088, 7089, 7090,7088, 7090, 7091,
7088, 7091, 7092,7088, 7092, 7093,7088, 7093, 7084,7088, 7084, 7083,
7094, 7089, 7075,7094, 7075, 7074,7094, 7074, 7081,7094, 7081, 7095,
7094, 7095, 7096,7094, 7096, 7097,7094, 7097, 7090,7094, 7090, 7089,
7098, 7099, 7100,7098, 7100, 7101,7098, 7101, 7102,7098, 7102, 7103,
7098, 7103, 7104,7098, 7104, 7105,7098, 7105, 7106,7098, 7106, 7099,
7107, 7101, 7100,7107, 7100, 7108,7107, 7108, 7109,7107, 7109, 7110,
7107, 7110, 7111,7107, 7111, 7112,7107, 7112, 7102,7107, 7102, 7101,
7113, 7108, 7100,7113, 7100, 7114,7113, 7114, 7115,7113, 7115, 7116,
7113, 7116, 7117,7113, 7117, 7118,7113, 7118, 7109,7113, 7109, 7108,
7119, 7114, 7100,7119, 7100, 7099,7119, 7099, 7106,7119, 7106, 7120,
7119, 7120, 7121,7119, 7121, 7122,7119, 7122, 7115,7119, 7115, 7114,
7123, 7124, 7125,7123, 7125, 7126,7123, 7126, 7127,7123, 7127, 7128,
7123, 7128, 7129,7123, 7129, 7130,7123, 7130, 7131,7123, 7131, 7124,
7132, 7133, 7134,7132, 7134, 7135,7132, 7135, 6967,7132, 6967, 6974,
7132, 6974, 6973,7132, 6973, 7136,7132, 7136, 7137,7132, 7137, 7133,
7138, 7139, 7125,7138, 7125, 7140,7138, 7140, 7141,7138, 7141, 7142,
7138, 7142, 7143,7138, 7143, 7144,7138, 7144, 7145,7138, 7145, 7139,
7146, 7140, 7125,7146, 7125, 7124,7146, 7124, 7131,7146, 7131, 7147,
7146, 7147, 7148,7146, 7148, 7149,7146, 7149, 7141,7146, 7141, 7140,
7150, 7151, 7152,7150, 7152, 7153,7150, 7153, 7154,7150, 7154, 7155,
7150, 7155, 7156,7150, 7156, 7157,7150, 7157, 7158,7150, 7158, 7151,
7159, 7153, 7152,7159, 7152, 7160,7159, 7160, 7161,7159, 7161, 7162,
7159, 7162, 7163,7159, 7163, 7164,7159, 7164, 7154,7159, 7154, 7153,
7165, 7160, 7152,7165, 7152, 7166,7165, 7166, 7167,7165, 7167, 7168,
7165, 7168, 7169,7165, 7169, 7170,7165, 7170, 7161,7165, 7161, 7160,
7171, 7166, 7152,7171, 7152, 7151,7171, 7151, 7158,7171, 7158, 7172,
7171, 7172, 7173,7171, 7173, 7174,7171, 7174, 7167,7171, 7167, 7166,
7175, 7176, 7177,7175, 7177, 7178,7175, 7178, 7179,7175, 7179, 7180,
7175, 7180, 7181,7175, 7181, 7182,7175, 7182, 7183,7175, 7183, 7176,
7184, 7178, 7177,7184, 7177, 7185,7184, 7185, 7031,7184, 7031, 7030,
7184, 7030, 7029,7184, 7029, 7186,7184, 7186, 7179,7184, 7179, 7178,
7187, 7185, 7177,7187, 7177, 7188,7187, 7188, 7189,7187, 7189, 7190,
7187, 7190, 7046,7187, 7046, 7045,7187, 7045, 7031,7187, 7031, 7185,
7191, 7188, 7177,7191, 7177, 7176,7191, 7176, 7183,7191, 7183, 7192,
7191, 7192, 7193,7191, 7193, 7194,7191, 7194, 7189,7191, 7189, 7188,
7195, 7196, 7197,7195, 7197, 7198,7195, 7198, 7199,7195, 7199, 7200,
7195, 7200, 7061,7195, 7061, 7060,7195, 7060, 7059,7195, 7059, 7196,
7201, 7198, 7197,7201, 7197, 7202,7201, 7202, 7203,7201, 7203, 7204,
7201, 7204, 7205,7201, 7205, 7206,7201, 7206, 7199,7201, 7199, 7198,
7207, 7202, 7197,7207, 7197, 7208,7207, 7208, 7209,7207, 7209, 7210,
7207, 7210, 7211,7207, 7211, 7212,7207, 7212, 7203,7207, 7203, 7202,
7213, 7208, 7197,7213, 7197, 7196,7213, 7196, 7059,7213, 7059, 7068,
7213, 7068, 7067,7213, 7067, 7214,7213, 7214, 7209,7213, 7209, 7208,
7215, 7216, 7217,7215, 7217, 7218,7215, 7218, 7219,7215, 7219, 7220,
7215, 7220, 7221,7215, 7221, 7222,7215, 7222, 7223,7215, 7223, 7216,
7224, 7218, 7217,7224, 7217, 7225,7224, 7225, 7081,7224, 7081, 7080,
7224, 7080, 7079,7224, 7079, 7226,7224, 7226, 7219,7224, 7219, 7218,
7227, 7225, 7217,7227, 7217, 7228,7227, 7228, 7229,7227, 7229, 7230,
7227, 7230, 7096,7227, 7096, 7095,7227, 7095, 7081,7227, 7081, 7225,
7231, 7228, 7217,7231, 7217, 7216,7231, 7216, 7223,7231, 7223, 7232,
7231, 7232, 7233,7231, 7233, 7234,7231, 7234, 7229,7231, 7229, 7228,
7235, 7236, 7237,7235, 7237, 7238,7235, 7238, 7239,7235, 7239, 7240,
7235, 7240, 7111,7235, 7111, 7110,7235, 7110, 7109,7235, 7109, 7236,
7241, 7238, 7237,7241, 7237, 7242,7241, 7242, 7243,7241, 7243, 7244,
7241, 7244, 7245,7241, 7245, 7246,7241, 7246, 7239,7241, 7239, 7238,
7247, 7242, 7237,7247, 7237, 7248,7247, 7248, 7249,7247, 7249, 7250,
7247, 7250, 7251,7247, 7251, 7252,7247, 7252, 7243,7247, 7243, 7242,
7253, 7248, 7237,7253, 7237, 7236,7253, 7236, 7109,7253, 7109, 7118,
7253, 7118, 7117,7253, 7117, 7254,7253, 7254, 7249,7253, 7249, 7248,
7255, 7256, 7257,7255, 7257, 7258,7255, 7258, 7259,7255, 7259, 7260,
7255, 7260, 7261,7255, 7261, 7262,7255, 7262, 7263,7255, 7263, 7256,
7264, 7258, 7257,7264, 7257, 7265,7264, 7265, 7131,7264, 7131, 7130,
7264, 7130, 7129,7264, 7129, 7266,7264, 7266, 7259,7264, 7259, 7258,
7267, 7268, 7269,7267, 7269, 7270,7267, 7270, 7209,7267, 7209, 7214,
7267, 7214, 7067,7267, 7067, 7271,7267, 7271, 7272,7267, 7272, 7268,
7273, 7270, 7269,7273, 7269, 7274,7273, 7274, 7275,7273, 7275, 7276,
7273, 7276, 7211,7273, 7211, 7210,7273, 7210, 7209,7273, 7209, 7270,
7277, 7278, 7279,7277, 7279, 7280,7277, 7280, 7281,7277, 7281, 7282,
7277, 7282, 7163,7277, 7163, 7162,7277, 7162, 7161,7277, 7161, 7278,
7283, 7280, 7279,7283, 7279, 7284,7283, 7284, 7285,7283, 7285, 7286,
7283, 7286, 7287,7283, 7287, 7288,7283, 7288, 7281,7283, 7281, 7280,
7289, 7284, 7279,7289, 7279, 7290,7289, 7290, 7291,7289, 7291, 7292,
7289, 7292, 7293,7289, 7293, 7294,7289, 7294, 7285,7289, 7285, 7284,
7295, 7290, 7279,7295, 7279, 7278,7295, 7278, 7161,7295, 7161, 7170,
7295, 7170, 7169,7295, 7169, 7296,7295, 7296, 7291,7295, 7291, 7290,
7297, 7298, 7299,7297, 7299, 7300,7297, 7300, 7301,7297, 7301, 7302,
7297, 7302, 6948,7297, 6948, 6947,7297, 6947, 6936,7297, 6936, 7298,
7303, 7300, 7299,7303, 7299, 7304,7303, 7304, 7305,7303, 7305, 7306,
7303, 7306, 7307,7303, 7307, 7308,7303, 7308, 7301,7303, 7301, 7300,
7309, 7304, 7299,7309, 7299, 7310,7309, 7310, 7311,7309, 7311, 7312,
7309, 7312, 7313,7309, 7313, 7314,7309, 7314, 7305,7309, 7305, 7304,
7315, 7310, 7299,7315, 7299, 7298,7315, 7298, 6936,7315, 6936, 6935,
7315, 6935, 6934,7315, 6934, 7316,7315, 7316, 7311,7315, 7311, 7310,
7317, 7318, 7319,7317, 7319, 7320,7317, 7320, 7321,7317, 7321, 7322,
7317, 7322, 7307,7317, 7307, 7306,7317, 7306, 7305,7317, 7305, 7318,
7323, 7320, 7319,7323, 7319, 7324,7323, 7324, 6845,7323, 6845, 6844,
7323, 6844, 6843,7323, 6843, 7325,7323, 7325, 7321,7323, 7321, 7320,
7326, 7324, 7319,7326, 7319, 7327,7326, 7327, 7328,7326, 7328, 7329,
7326, 7329, 6855,7326, 6855, 6854,7326, 6854, 6845,7326, 6845, 7324,
7330, 7327, 7319,7330, 7319, 7318,7330, 7318, 7305,7330, 7305, 7314,
7330, 7314, 7313,7330, 7313, 7331,7330, 7331, 7328,7330, 7328, 7327,
7332, 7333, 7334,7332, 7334, 7335,7332, 7335, 7336,7332, 7336, 7337,
7332, 7337, 6870,7332, 6870, 6869,7332, 6869, 6868,7332, 6868, 7333,
7338, 7339, 7340,7338, 7340, 7341,7338, 7341, 7342,7338, 7342, 7343,
7338, 7343, 7344,7338, 7344, 7345,7338, 7345, 7346,7338, 7346, 7339,
7347, 7348, 7334,7347, 7334, 7349,7347, 7349, 7350,7347, 7350, 7351,
7347, 7351, 7352,7347, 7352, 7353,7347, 7353, 7354,7347, 7354, 7348,
7355, 7349, 7334,7355, 7334, 7333,7355, 7333, 6868,7355, 6868, 6877,
7355, 6877, 6876,7355, 6876, 7356,7355, 7356, 7350,7355, 7350, 7349,
7357, 7358, 7359,7357, 7359, 7360,7357, 7360, 7361,7357, 7361, 7362,
7357, 7362, 7344,7357, 7344, 7343,7357, 7343, 7342,7357, 7342, 7358,
7363, 7360, 7359,7363, 7359, 7364,7363, 7364, 7365,7363, 7365, 7366,
7363, 7366, 7156,7363, 7156, 7367,7363, 7367, 7361,7363, 7361, 7360,
7368, 7369, 7370,7368, 7370, 7371,7368, 7371, 7372,7368, 7372, 7373,
7368, 7373, 6973,7368, 6973, 6972,7368, 6972, 6958,7368, 6958, 7369,
7374, 7371, 7370,7374, 7370, 7375,7374, 7375, 7354,7374, 7354, 7353,
7374, 7353, 7352,7374, 7352, 7376,7374, 7376, 7372,7374, 7372, 7371,
7377, 7378, 7379,7377, 7379, 7380,7377, 7380, 7311,7377, 7311, 7316,
7377, 7316, 6934,7377, 6934, 6982,7377, 6982, 6981,7377, 6981, 7378,
7381, 7380, 7379,7381, 7379, 7382,7381, 7382, 7383,7381, 7383, 7384,
7381, 7384, 7313,7381, 7313, 7312,7381, 7312, 7311,7381, 7311, 7380,
7385, 7382, 7379,7385, 7379, 7386,7385, 7386, 7387,7385, 7387, 7388,
7385, 7388, 7389,7385, 7389, 7390,7385, 7390, 7383,7385, 7383, 7382,
7391, 7386, 7379,7391, 7379, 7378,7391, 7378, 6981,7391, 6981, 7392,
7391, 7392, 7393,7391, 7393, 7394,7391, 7394, 7387,7391, 7387, 7386,
7395, 7396, 7397,7395, 7397, 7398,7395, 7398, 7328,7395, 7328, 7331,
7395, 7331, 7313,7395, 7313, 7384,7395, 7384, 7383,7395, 7383, 7396,
7399, 7398, 7397,7399, 7397, 7400,7399, 7400, 6887,7399, 6887, 6886,
7399, 6886, 6855,7399, 6855, 7329,7399, 7329, 7328,7399, 7328, 7398,
7401, 7400, 7397,7401, 7397, 7402,7401, 7402, 7403,7401, 7403, 7404,
7401, 7404, 6902,7401, 6902, 6901,7401, 6901, 6887,7401, 6887, 7400,
7405, 7402, 7397,7405, 7397, 7396,7405, 7396, 7383,7405, 7383, 7390,
7405, 7390, 7389,7405, 7389, 7406,7405, 7406, 7403,7405, 7403, 7402,
7407, 7408, 7409,7407, 7409, 7410,7407, 7410, 7411,7407, 7411, 7412,
7407, 7412, 7413,7407, 7413, 7414,7407, 7414, 7018,7407, 7018, 7408,
7415, 7410, 7409,7415, 7409, 7416,7415, 7416, 7417,7415, 7417, 7418,
7415, 7418, 7419,7415, 7419, 7420,7415, 7420, 7411,7415, 7411, 7410,
7421, 7416, 7409,7421, 7409, 7422,7421, 7422, 7301,7421, 7301, 7308,
7421, 7308, 7307,7421, 7307, 7423,7421, 7423, 7417,7421, 7417, 7416,
7424, 7422, 7409,7424, 7409, 7408,7424, 7408, 7018,7424, 7018, 7017,
7424, 7017, 6948,7424, 6948, 7302,7424, 7302, 7301,7424, 7301, 7422,
7425, 7426, 7427,7425, 7427, 7428,7425, 7428, 7429,7425, 7429, 7430,
7425, 7430, 7419,7425, 7419, 7418,7425, 7418, 7417,7425, 7417, 7426,
7431, 7432, 7433,7431, 7433, 7434,7431, 7434, 6913,7431, 6913, 6912,
7431, 6912, 6911,7431, 6911, 7435,7431, 7435, 7436,7431, 7436, 7432,
7437, 7438, 7427,7437, 7427, 7439,7437, 7439, 7321,7437, 7321, 7325,
7437, 7325, 6843,7437, 6843, 6927,7437, 6927, 6926,7437, 6926, 7438,
7440, 7439, 7427,7440, 7427, 7426,7440, 7426, 7417,7440, 7417, 7423,
7440, 7423, 7307,7440, 7307, 7322,7440, 7322, 7321,7440, 7321, 7439,
7441, 7442, 7443,7441, 7443, 7444,7441, 7444, 7350,7441, 7350, 7356,
7441, 7356, 6876,7441, 6876, 7445,7441, 7445, 7446,7441, 7446, 7442,
7447, 7444, 7443,7447, 7443, 7448,7447, 7448, 7449,7447, 7449, 7450,
7447, 7450, 7352,7447, 7352, 7351,7447, 7351, 7350,7447, 7350, 7444,
7451, 7452, 7453,7451, 7453, 7454,7451, 7454, 7455,7451, 7455, 7456,
7451, 7456, 7457,7451, 7457, 7458,7451, 7458, 7459,7451, 7459, 7452,
7460, 7454, 7453,7460, 7453, 7461,7460, 7461, 7090,7460, 7090, 7097,
7460, 7097, 7096,7460, 7096, 7462,7460, 7462, 7455,7460, 7455, 7454,
7463, 7464, 7465,7463, 7465, 7466,7463, 7466, 7372,7463, 7372, 7376,
7463, 7376, 7352,7463, 7352, 7450,7463, 7450, 7449,7463, 7449, 7464,
7467, 7466, 7465,7467, 7465, 7468,7467, 7468, 7137,7467, 7137, 7136,
7467, 7136, 6973,7467, 6973, 7373,7467, 7373, 7372,7467, 7372, 7466,
7469, 7470, 7471,7469, 7471, 7472,7469, 7472, 7473,7469, 7473, 7474,
7469, 7474, 7129,7469, 7129, 7128,7469, 7128, 7127,7469, 7127, 7470,
7475, 7472, 7471,7475, 7471, 7476,7475, 7476, 7459,7475, 7459, 7458,
7475, 7458, 7457,7475, 7457, 7477,7475, 7477, 7473,7475, 7473, 7472,
7478, 7479, 7480,7478, 7480, 7481,7478, 7481, 7482,7478, 7482, 7483,
7478, 7483, 7117,7478, 7117, 7116,7478, 7116, 7115,7478, 7115, 7479,
7484, 7481, 7480,7484, 7480, 7485,7484, 7485, 7486,7484, 7486, 7487,
7484, 7487, 7488,7484, 7488, 7489,7484, 7489, 7482,7484, 7482, 7481,
7490, 7485, 7480,7490, 7480, 7491,7490, 7491, 7346,7490, 7346, 7345,
7490, 7345, 7344,7490, 7344, 7492,7490, 7492, 7486,7490, 7486, 7485,
7493, 7491, 7480,7493, 7480, 7479,7493, 7479, 7115,7493, 7115, 7122,
7493, 7122, 7121,7493, 7121, 7494,7493, 7494, 7346,7493, 7346, 7491,
7495, 7496, 7497,7495, 7497, 7498,7495, 7498, 7499,7495, 7499, 7500,
7495, 7500, 7488,7495, 7488, 7487,7495, 7487, 7486,7495, 7486, 7496,
7501, 7498, 7497,7501, 7497, 7502,7501, 7502, 7154,7501, 7154, 7164,
7501, 7164, 7163,7501, 7163, 7503,7501, 7503, 7499,7501, 7499, 7498,
7504, 7502, 7497,7504, 7497, 7505,7504, 7505, 7361,7504, 7361, 7367,
7504, 7367, 7156,7504, 7156, 7155,7504, 7155, 7154,7504, 7154, 7502,
7506, 7505, 7497,7506, 7497, 7496,7506, 7496, 7486,7506, 7486, 7492,
7506, 7492, 7344,7506, 7344, 7362,7506, 7362, 7361,7506, 7361, 7505,
7507, 7508, 7509,7507, 7509, 7510,7507, 7510, 7455,7507, 7455, 7462,
7507, 7462, 7096,7507, 7096, 7230,7507, 7230, 7229,7507, 7229, 7508,
7511, 7510, 7509,7511, 7509, 7512,7511, 7512, 7513,7511, 7513, 7514,
7511, 7514, 7457,7511, 7457, 7456,7511, 7456, 7455,7511, 7455, 7510,
7515, 7512, 7509,7515, 7509, 7516,7515, 7516, 7517,7515, 7517, 7518,
7515, 7518, 7519,7515, 7519, 7520,7515, 7520, 7513,7515, 7513, 7512,
7521, 7516, 7509,7521, 7509, 7508,7521, 7508, 7229,7521, 7229, 7234,
7521, 7234, 7233,7521, 7233, 7522,7521, 7522, 7517,7521, 7517, 7516,
7523, 7524, 7525,7523, 7525, 7526,7523, 7526, 7473,7523, 7473, 7477,
7523, 7477, 7457,7523, 7457, 7514,7523, 7514, 7513,7523, 7513, 7524,
7527, 7526, 7525,7527, 7525, 7528,7527, 7528, 7259,7527, 7259, 7266,
7527, 7266, 7129,7527, 7129, 7474,7527, 7474, 7473,7527, 7473, 7526,
7529, 7528, 7525,7529, 7525, 7530,7529, 7530, 7531,7529, 7531, 7532,
7529, 7532, 7261,7529, 7261, 7260,7529, 7260, 7259,7529, 7259, 7528,
7533, 7530, 7525,7533, 7525, 7524,7533, 7524, 7513,7533, 7513, 7520,
7533, 7520, 7519,7533, 7519, 7534,7533, 7534, 7531,7533, 7531, 7530,
7535, 7536, 7537,7535, 7537, 7538,7535, 7538, 7539,7535, 7539, 7540,
7535, 7540, 7251,7535, 7251, 7250,7535, 7250, 7249,7535, 7249, 7536,
7541, 7538, 7537,7541, 7537, 7542,7541, 7542, 7543,7541, 7543, 7544,
7541, 7544, 7545,7541, 7545, 7546,7541, 7546, 7539,7541, 7539, 7538,
7547, 7542, 7537,7547, 7537, 7548,7547, 7548, 7482,7547, 7482, 7489,
7547, 7489, 7488,7547, 7488, 7549,7547, 7549, 7543,7547, 7543, 7542,
7550, 7548, 7537,7550, 7537, 7536,7550, 7536, 7249,7550, 7249, 7254,
7550, 7254, 7117,7550, 7117, 7483,7550, 7483, 7482,7550, 7482, 7548,
7551, 7552, 7553,7551, 7553, 7554,7551, 7554, 7555,7551, 7555, 7556,
7551, 7556, 7545,7551, 7545, 7544,7551, 7544, 7543,7551, 7543, 7552,
7557, 7554, 7553,7557, 7553, 7558,7557, 7558, 7281,7557, 7281, 7288,
7557, 7288, 7287,7557, 7287, 7559,7557, 7559, 7555,7557, 7555, 7554,
7560, 7558, 7553,7560, 7553, 7561,7560, 7561, 7499,7560, 7499, 7503,
7560, 7503, 7163,7560, 7163, 7282,7560, 7282, 7281,7560, 7281, 7558,
7562, 7561, 7553,7562, 7553, 7552,7562, 7552, 7543,7562, 7543, 7549,
7562, 7549, 7488,7562, 7488, 7500,7562, 7500, 7499,7562, 7499, 7561,
7563, 7564, 7565,7563, 7565, 7566,7563, 7566, 7567,7563, 7567, 7568,
7563, 7568, 6792,7563, 6792, 6791,7563, 6791, 6790,7563, 6790, 7564,
7569, 7566, 7565,7569, 7565, 7570,7569, 7570, 7571,7569, 7571, 7572,
7569, 7572, 7573,7569, 7573, 7574,7569, 7574, 7567,7569, 7567, 7566,
7575, 7570, 7565,7575, 7565, 7576,7575, 7576, 7577,7575, 7577, 7578,
7575, 7578, 7579,7575, 7579, 7580,7575, 7580, 7571,7575, 7571, 7570,
7581, 7576, 7565,7581, 7565, 7564,7581, 7564, 6790,7581, 6790, 6800,
7581, 6800, 6799,7581, 6799, 7582,7581, 7582, 7577,7581, 7577, 7576,
7583, 7584, 7585,7583, 7585, 7586,7583, 7586, 7587,7583, 7587, 7588,
7583, 7588, 7573,7583, 7573, 7572,7583, 7572, 7571,7583, 7571, 7584,
7589, 7586, 7585,7589, 7585, 7590,7589, 7590, 7183,7589, 7183, 7182,
7589, 7182, 7181,7589, 7181, 7591,7589, 7591, 7587,7589, 7587, 7586,
7592, 7590, 7585,7592, 7585, 7593,7592, 7593, 7594,7592, 7594, 7595,
7592, 7595, 7193,7592, 7193, 7192,7592, 7192, 7183,7592, 7183, 7590,
7596, 7593, 7585,7596, 7585, 7584,7596, 7584, 7571,7596, 7571, 7580,
7596, 7580, 7579,7596, 7579, 7597,7596, 7597, 7594,7596, 7594, 7593,
7598, 7599, 7600,7598, 7600, 7601,7598, 7601, 7602,7598, 7602, 7603,
7598, 7603, 7205,7598, 7205, 7204,7598, 7204, 7203,7598, 7203, 7599,
7604, 7601, 7600,7604, 7600, 7605,7604, 7605, 7606,7604, 7606, 7607,
7604, 7607, 7608,7604, 7608, 7609,7604, 7609, 7602,7604, 7602, 7601,
7610, 7605, 7600,7610, 7600, 7611,7610, 7611, 7612,7610, 7612, 7613,
7610, 7613, 7614,7610, 7614, 7615,7610, 7615, 7606,7610, 7606, 7605,
7616, 7611, 7600,7616, 7600, 7599,7616, 7599, 7203,7616, 7203, 7212,
7616, 7212, 7211,7616, 7211, 7617,7616, 7617, 7612,7616, 7612, 7611,
7618, 7619, 7620,7618, 7620, 7621,7618, 7621, 7622,7618, 7622, 7623,
7618, 7623, 7608,7618, 7608, 7607,7618, 7607, 7606,7618, 7606, 7619,
7624, 7621, 7620,7624, 7620, 7625,7624, 7625, 6820,7624, 6820, 6830,
7624, 6830, 6829,7624, 6829, 7626,7624, 7626, 7622,7624, 7622, 7621,
7627, 7625, 7620,7627, 7620, 7628,7627, 7628, 7629,7627, 7629, 7630,
7627, 7630, 6822,7627, 6822, 6821,7627, 6821, 6820,7627, 6820, 7625,
7631, 7628, 7620,7631, 7620, 7619,7631, 7619, 7606,7631, 7606, 7615,
7631, 7615, 7614,7631, 7614, 7632,7631, 7632, 7629,7631, 7629, 7628,
7633, 7634, 7635,7633, 7635, 7636,7633, 7636, 7637,7633, 7637, 7638,
7633, 7638, 6896,7633, 6896, 6895,7633, 6895, 6894,7633, 6894, 7634,
7639, 7636, 7635,7639, 7635, 7640,7639, 7640, 7641,7639, 7641, 7642,
7639, 7642, 7643,7639, 7643, 7644,7639, 7644, 7637,7639, 7637, 7636,
7645, 7640, 7635,7645, 7635, 7646,7645, 7646, 7647,7645, 7647, 7648,
7645, 7648, 7649,7645, 7649, 7650,7645, 7650, 7641,7645, 7641, 7640,
7651, 7646, 7635,7651, 7635, 7634,7651, 7634, 6894,7651, 6894, 7652,
7651, 7652, 7653,7651, 7653, 7654,7651, 7654, 7647,7651, 7647, 7646,
7655, 7656, 7657,7655, 7657, 7658,7655, 7658, 7659,7655, 7659, 7660,
7655, 7660, 7643,7655, 7643, 7642,7655, 7642, 7641,7655, 7641, 7656,
7661, 7658, 7657,7661, 7657, 7662,7661, 7662, 7223,7661, 7223, 7222,
7661, 7222, 7221,7661, 7221, 7663,7661, 7663, 7659,7661, 7659, 7658,
7664, 7662, 7657,7664, 7657, 7665,7664, 7665, 7666,7664, 7666, 7667,
7664, 7667, 7233,7664, 7233, 7232,7664, 7232, 7223,7664, 7223, 7662,
7668, 7665, 7657,7668, 7657, 7656,7668, 7656, 7641,7668, 7641, 7650,
7668, 7650, 7649,7668, 7649, 7669,7668, 7669, 7666,7668, 7666, 7665,
7670, 7671, 7672,7670, 7672, 7673,7670, 7673, 7674,7670, 7674, 7675,
7670, 7675, 7245,7670, 7245, 7244,7670, 7244, 7243,7670, 7243, 7671,
7676, 7673, 7672,7676, 7672, 7677,7676, 7677, 7678,7676, 7678, 7679,
7676, 7679, 7680,7676, 7680, 7681,7676, 7681, 7674,7676, 7674, 7673,
7682, 7677, 7672,7682, 7672, 7683,7682, 7683, 7684,7682, 7684, 7685,
7682, 7685, 7686,7682, 7686, 7687,7682, 7687, 7678,7682, 7678, 7677,
7688, 7683, 7672,7688, 7672, 7671,7688, 7671, 7243,7688, 7243, 7252,
7688, 7252, 7251,7688, 7251, 7689,7688, 7689, 7684,7688, 7684, 7683,
7690, 7691, 7692,7690, 7692, 7693,7690, 7693, 7694,7690, 7694, 7695,
7690, 7695, 7680,7690, 7680, 7679,7690, 7679, 7678,7690, 7678, 7691,
7696, 7693, 7692,7696, 7692, 7697,7696, 7697, 6909,7696, 6909, 6919,
7696, 6919, 6918,7696, 6918, 7698,7696, 7698, 7694,7696, 7694, 7693,
7699, 7697, 7692,7699, 7692, 7700,7699, 7700, 7701,7699, 7701, 7702,
7699, 7702, 6911,7699, 6911, 6910,7699, 6910, 6909,7699, 6909, 7697,
7703, 7700, 7692,7703, 7692, 7691,7703, 7691, 7678,7703, 7678, 7687,
7703, 7687, 7686,7703, 7686, 7704,7703, 7704, 7701,7703, 7701, 7700,
7705, 7706, 7707,7705, 7707, 7708,7705, 7708, 7709,7705, 7709, 7710,
7705, 7710, 6989,7705, 6989, 6988,7705, 6988, 6987,7705, 6987, 7706,
7711, 7708, 7707,7711, 7707, 7712,7711, 7712, 7713,7711, 7713, 7714,
7711, 7714, 7715,7711, 7715, 7716,7711, 7716, 7709,7711, 7709, 7708,
7717, 7718, 7719,7717, 7719, 7720,7717, 7720, 7629,7717, 7629, 7632,
7717, 7632, 7614,7717, 7614, 7721,7717, 7721, 7722,7717, 7722, 7718,
7723, 7724, 7707,7723, 7707, 7706,7723, 7706, 6987,7723, 6987, 6997,
7723, 6997, 6996,7723, 6996, 7725,7723, 7725, 7726,7723, 7726, 7724,
7727, 7728, 7729,7727, 7729, 7730,7727, 7730, 7731,7727, 7731, 7732,
7727, 7732, 7715,7727, 7715, 7714,7727, 7714, 7713,7727, 7713, 7728,
7733, 7730, 7729,7733, 7729, 7734,7733, 7734, 7263,7733, 7263, 7262,
7733, 7262, 7261,7733, 7261, 7735,7733, 7735, 7731,7733, 7731, 7730,
7736, 7737, 7738,7736, 7738, 7739,7736, 7739, 7612,7736, 7612, 7617,
7736, 7617, 7211,7736, 7211, 7276,7736, 7276, 7275,7736, 7275, 7737,
7740, 7739, 7738,7740, 7738, 7741,7740, 7741, 7722,7740, 7722, 7721,
7740, 7721, 7614,7740, 7614, 7613,7740, 7613, 7612,7740, 7612, 7739,
7742, 7743, 7744,7742, 7744, 7745,7742, 7745, 7746,7742, 7746, 7747,
7742, 7747, 7287,7742, 7287, 7286,7742, 7286, 7285,7742, 7285, 7743,
7748, 7745, 7744,7748, 7744, 7749,7748, 7749, 7750,7748, 7750, 7751,
7748, 7751, 7752,7748, 7752, 7753,7748, 7753, 7746,7748, 7746, 7745,
7754, 7749, 7744,7754, 7744, 7755,7754, 7755, 7756,7754, 7756, 7757,
7754, 7757, 7758,7754, 7758, 7759,7754, 7759, 7750,7754, 7750, 7749,
7760, 7755, 7744,7760, 7744, 7743,7760, 7743, 7285,7760, 7285, 7294,
7760, 7294, 7293,7760, 7293, 7761,7760, 7761, 7756,7760, 7756, 7755,
7762, 7763, 7764,7762, 7764, 7765,7762, 7765, 7766,7762, 7766, 7767,
7762, 7767, 7752,7762, 7752, 7751,7762, 7751, 7750,7762, 7750, 7763,
7768, 7765, 7764,7768, 7764, 7769,7768, 7769, 7002,7768, 7002, 7012,
7768, 7012, 7011,7768, 7011, 7770,7768, 7770, 7766,7768, 7766, 7765,
7771, 7769, 7764,7771, 7764, 7772,7771, 7772, 7773,7771, 7773, 7774,
7771, 7774, 7004,7771, 7004, 7003,7771, 7003, 7002,7771, 7002, 7769,
7775, 7772, 7764,7775, 7764, 7763,7775, 7763, 7750,7775, 7750, 7759,
7775, 7759, 7758,7775, 7758, 7776,7775, 7776, 7773,7775, 7773, 7772,
7777, 7778, 7779,7777, 7779, 7780,7777, 7780, 7781,7777, 7781, 7782,
7777, 7782, 7519,7777, 7519, 7518,7777, 7518, 7517,7777, 7517, 7778,
7783, 7780, 7779,7783, 7779, 7784,7783, 7784, 7785,7783, 7785, 7786,
7783, 7786, 7787,7783, 7787, 7788,7783, 7788, 7781,7783, 7781, 7780,
7789, 7784, 7779,7789, 7779, 7790,7789, 7790, 7666,7789, 7666, 7669,
7789, 7669, 7649,7789, 7649, 7791,7789, 7791, 7785,7789, 7785, 7784,
7792, 7790, 7779,7792, 7779, 7778,7792, 7778, 7517,7792, 7517, 7522,
7792, 7522, 7233,7792, 7233, 7667,7792, 7667, 7666,7792, 7666, 7790,
7793, 7794, 7795,7793, 7795, 7796,7793, 7796, 7797,7793, 7797, 7798,
7793, 7798, 7787,7793, 7787, 7786,7793, 7786, 7785,7793, 7785, 7794,
7799, 7796, 7795,7799, 7795, 7800,7799, 7800, 7801,7799, 7801, 7802,
7799, 7802, 7803,7799, 7803, 7804,7799, 7804, 7797,7799, 7797, 7796,
7805, 7800, 7795,7805, 7795, 7806,7805, 7806, 7647,7805, 7647, 7654,
7805, 7654, 7653,7805, 7653, 7807,7805, 7807, 7801,7805, 7801, 7800,
7808, 7806, 7795,7808, 7795, 7794,7808, 7794, 7785,7808, 7785, 7791,
7808, 7791, 7649,7808, 7649, 7648,7808, 7648, 7647,7808, 7647, 7806,
7809, 7810, 7811,7809, 7811, 7812,7809, 7812, 7731,7809, 7731, 7735,
7809, 7735, 7261,7809, 7261, 7532,7809, 7532, 7531,7809, 7531, 7810,
7813, 7812, 7811,7813, 7811, 7814,7813, 7814, 7815,7813, 7815, 7816,
7813, 7816, 7715,7813, 7715, 7732,7813, 7732, 7731,7813, 7731, 7812,
7817, 7814, 7811,7817, 7811, 7818,7817, 7818, 7781,7817, 7781, 7788,
7817, 7788, 7787,7817, 7787, 7819,7817, 7819, 7815,7817, 7815, 7814,
7820, 7818, 7811,7820, 7811, 7810,7820, 7810, 7531,7820, 7531, 7534,
7820, 7534, 7519,7820, 7519, 7782,7820, 7782, 7781,7820, 7781, 7818,
7821, 7822, 7823,7821, 7823, 7824,7821, 7824, 7709,7821, 7709, 7716,
7821, 7716, 7715,7821, 7715, 7816,7821, 7816, 7815,7821, 7815, 7822,
7825, 7824, 7823,7825, 7823, 7826,7825, 7826, 7827,7825, 7827, 7828,
7825, 7828, 6989,7825, 6989, 7710,7825, 7710, 7709,7825, 7709, 7824,
7829, 7826, 7823,7829, 7823, 7830,7829, 7830, 7797,7829, 7797, 7804,
7829, 7804, 7803,7829, 7803, 7831,7829, 7831, 7827,7829, 7827, 7826,
7832, 7830, 7823,7832, 7823, 7822,7832, 7822, 7815,7832, 7815, 7819,
7832, 7819, 7787,7832, 7787, 7798,7832, 7798, 7797,7832, 7797, 7830,
7833, 7834, 7835,7833, 7835, 7836,7833, 7836, 7837,7833, 7837, 7838,
7833, 7838, 7839,7833, 7839, 7840,7833, 7840, 7436,7833, 7436, 7834,
7841, 7836, 7835,7841, 7835, 7842,7841, 7842, 7843,7841, 7843, 7844,
7841, 7844, 7845,7841, 7845, 7846,7841, 7846, 7837,7841, 7837, 7836,
7847, 7842, 7835,7847, 7835, 7848,7847, 7848, 7701,7847, 7701, 7704,
7847, 7704, 7686,7847, 7686, 7849,7847, 7849, 7843,7847, 7843, 7842,
7850, 7848, 7835,7850, 7835, 7834,7850, 7834, 7436,7850, 7436, 7435,
7850, 7435, 6911,7850, 6911, 7702,7850, 7702, 7701,7850, 7701, 7848,
7851, 7852, 7853,7851, 7853, 7854,7851, 7854, 7855,7851, 7855, 7856,
7851, 7856, 7845,7851, 7845, 7844,7851, 7844, 7843,7851, 7843, 7852,
7857, 7854, 7853,7857, 7853, 7858,7857, 7858, 7539,7857, 7539, 7546,
7857, 7546, 7545,7857, 7545, 7859,7857, 7859, 7855,7857, 7855, 7854,
7860, 7858, 7853,7860, 7853, 7861,7860, 7861, 7684,7860, 7684, 7689,
7860, 7689, 7251,7860, 7251, 7540,7860, 7540, 7539,7860, 7539, 7858,
7862, 7861, 7853,7862, 7853, 7852,7862, 7852, 7843,7862, 7843, 7849,
7862, 7849, 7686,7862, 7686, 7685,7862, 7685, 7684,7862, 7684, 7861,
7863, 7864, 7865,7863, 7865, 7866,7863, 7866, 7766,7863, 7766, 7770,
7863, 7770, 7011,7863, 7011, 7867,7863, 7867, 7868,7863, 7868, 7864,
7869, 7866, 7865,7869, 7865, 7870,7869, 7870, 7871,7869, 7871, 7872,
7869, 7872, 7752,7869, 7752, 7767,7869, 7767, 7766,7869, 7766, 7866,
7873, 7870, 7865,7873, 7865, 7874,7873, 7874, 7837,7873, 7837, 7846,
7873, 7846, 7845,7873, 7845, 7875,7873, 7875, 7871,7873, 7871, 7870,
7876, 7874, 7865,7876, 7865, 7864,7876, 7864, 7868,7876, 7868, 7877,
7876, 7877, 7839,7876, 7839, 7838,7876, 7838, 7837,7876, 7837, 7874,
7878, 7879, 7880,7878, 7880, 7881,7878, 7881, 7746,7878, 7746, 7753,
7878, 7753, 7752,7878, 7752, 7872,7878, 7872, 7871,7878, 7871, 7879,
7882, 7881, 7880,7882, 7880, 7883,7882, 7883, 7555,7882, 7555, 7559,
7882, 7559, 7287,7882, 7287, 7747,7882, 7747, 7746,7882, 7746, 7881,
7884, 7883, 7880,7884, 7880, 7885,7884, 7885, 7855,7884, 7855, 7859,
7884, 7859, 7545,7884, 7545, 7556,7884, 7556, 7555,7884, 7555, 7883,
7886, 7885, 7880,7886, 7880, 7879,7886, 7879, 7871,7886, 7871, 7875,
7886, 7875, 7845,7886, 7845, 7856,7886, 7856, 7855,7886, 7855, 7885,
7887, 7888, 7889,7887, 7889, 7890,7887, 7890, 7891,7887, 7891, 7892,
7887, 7892, 7893,7887, 7893, 7888,7894, 7895, 7889,7894, 7889, 7896,
7894, 7896, 7897,7894, 7897, 7898,7894, 7898, 7899,7894, 7899, 7895,
7900, 7901, 7889,7900, 7889, 7902,7900, 7902, 7903,7900, 7903, 7904,
7900, 7904, 7905,7900, 7905, 7901,7906, 7907, 7889,7906, 7889, 7908,
7906, 7908, 7909,7906, 7909, 7910,7906, 7910, 7911,7906, 7911, 7907,
7912, 7913, 7889,7912, 7889, 7914,7912, 7914, 7915,7912, 7915, 7916,
7912, 7916, 7917,7912, 7917, 7913,7918, 7919, 7889,7918, 7889, 7920,
7918, 7920, 7921,7918, 7921, 7922,7918, 7922, 7923,7918, 7923, 7919,
7924, 7925, 7889,7924, 7889, 7926,7924, 7926, 7927,7924, 7927, 7928,
7924, 7928, 7929,7924, 7929, 7925,7930, 7931, 7889,7930, 7889, 7932,
7930, 7932, 7933,7930, 7933, 7934,7930, 7934, 7935,7930, 7935, 7931,
7936, 7937, 7889,7936, 7889, 7938,7936, 7938, 7939,7936, 7939, 7940,
7936, 7940, 7941,7936, 7941, 7937,7942, 7943, 7889,7942, 7889, 7944,
7942, 7944, 7945,7942, 7945, 7946,7942, 7946, 7947,7942, 7947, 7943,
7948, 7949, 7889,7948, 7889, 7950,7948, 7950, 7951,7948, 7951, 7952,
7948, 7952, 7953,7948, 7953, 7949,7954, 7955, 7889,7954, 7889, 7956,
7954, 7956, 7957,7954, 7957, 7958,7954, 7958, 7959,7954, 7959, 7955,
7960, 7961, 7889,7960, 7889, 7962,7960, 7962, 7963,7960, 7963, 7964,
7960, 7964, 7965,7960, 7965, 7961,7966, 7967, 7889,7966, 7889, 7968,
7966, 7968, 7969,7966, 7969, 7970,7966, 7970, 7971,7966, 7971, 7967,
7972, 7973, 7889,7972, 7889, 7974,7972, 7974, 7975,7972, 7975, 7976,
7972, 7976, 7977,7972, 7977, 7973,7978, 7973, 7979,7978, 7979, 7980,
7978, 7980, 7891,7978, 7891, 7981,7978, 7981, 7982,7978, 7982, 7973,
7983, 7984, 7985,7983, 7985, 7986,7983, 7986, 7987,7983, 7987, 7988,
7983, 7988, 7989,7983, 7989, 7990,7983, 7990, 7991,7983, 7991, 7984,
7992, 7993, 7994,7992, 7994, 7995,7992, 7995, 7996,7992, 7996, 7997,
7992, 7997, 7998,7992, 7998, 7999,7992, 7999, 8000,7992, 8000, 7993,
8001, 8002, 8003,8001, 8003, 8004,8001, 8004, 8005,8001, 8005, 8006,
8001, 8006, 8007,8001, 8007, 8008,8001, 8008, 8009,8001, 8009, 8002,
8010, 8011, 8012,8010, 8012, 8013,8010, 8013, 8014,8010, 8014, 8015,
8010, 8015, 8016,8010, 8016, 8017,8010, 8017, 8018,8010, 8018, 8011,
8019, 8020, 8021,8019, 8021, 8022,8019, 8022, 8023,8019, 8023, 8024,
8019, 8024, 8025,8019, 8025, 8026,8019, 8026, 8027,8019, 8027, 8020,
8028, 8029, 8030,8028, 8030, 8031,8028, 8031, 8032,8028, 8032, 8033,
8028, 8033, 8034,8028, 8034, 8035,8028, 8035, 8036,8028, 8036, 8029,
8037, 8038, 8039,8037, 8039, 8040,8037, 8040, 8041,8037, 8041, 8042,
8037, 8042, 8043,8037, 8043, 8044,8037, 8044, 8045,8037, 8045, 8038,
8046, 8047, 8048,8046, 8048, 8049,8046, 8049, 8050,8046, 8050, 8051,
8046, 8051, 8052,8046, 8052, 8053,8046, 8053, 8054,8046, 8054, 8047,
8055, 8056, 8057,8055, 8057, 8058,8055, 8058, 8059,8055, 8059, 8060,
8055, 8060, 8061,8055, 8061, 8062,8055, 8062, 8063,8055, 8063, 8056,
8064, 8065, 8066,8064, 8066, 8067,8064, 8067, 8068,8064, 8068, 8069,
8064, 8069, 8070,8064, 8070, 8071,8064, 8071, 8072,8064, 8072, 8065,
8073, 8074, 8075,8073, 8075, 8076,8073, 8076, 8077,8073, 8077, 8078,
8073, 8078, 8079,8073, 8079, 8080,8073, 8080, 8081,8073, 8081, 8074,
8082, 8083, 8084,8082, 8084, 8085,8082, 8085, 8086,8082, 8086, 8087,
8082, 8087, 8088,8082, 8088, 8089,8082, 8089, 8090,8082, 8090, 8083,
8091, 8092, 8093,8091, 8093, 8094,8091, 8094, 8095,8091, 8095, 8096,
8091, 8096, 8097,8091, 8097, 8098,8091, 8098, 8099,8091, 8099, 8092,
8100, 8101, 8102,8100, 8102, 8103,8100, 8103, 8104,8100, 8104, 8105,
8100, 8105, 8106,8100, 8106, 8107,8100, 8107, 8108,8100, 8108, 8101,
8109, 8110, 8111,8109, 8111, 8112,8109, 8112, 8113,8109, 8113, 8114,
8109, 8114, 8115,8109, 8115, 8116,8109, 8116, 8117,8109, 8117, 8110,
8118, 8119, 8120,8118, 8120, 7986,8118, 7986, 7891,8118, 7891, 8121,
8118, 8121, 7977,8118, 7977, 8116,8118, 8116, 8122,8118, 8122, 8119,
8123, 8124, 8120,8123, 8120, 8125,8123, 8125, 8126,8123, 8126, 8127,
8123, 8127, 8128,8123, 8128, 8129,8123, 8129, 8130,8123, 8130, 8124,
8131, 8132, 8133,8131, 8133, 8134,8131, 8134, 8135,8131, 8135, 8136,
8131, 8136, 8137,8131, 8137, 8138,8131, 8138, 8139,8131, 8139, 8132,
8140, 8141, 8142,8140, 8142, 8143,8140, 8143, 8144,8140, 8144, 8145,
8140, 8145, 8146,8140, 8146, 8147,8140, 8147, 8148,8140, 8148, 8141,
8149, 8150, 8151,8149, 8151, 8152,8149, 8152, 8153,8149, 8153, 8154,
8149, 8154, 8155,8149, 8155, 8156,8149, 8156, 8157,8149, 8157, 8150,
8158, 8159, 8160,8158, 8160, 8161,8158, 8161, 8162,8158, 8162, 8163,
8158, 8163, 8164,8158, 8164, 8165,8158, 8165, 8166,8158, 8166, 8159,
8167, 8168, 8169,8167, 8169, 8170,8167, 8170, 8171,8167, 8171, 8172,
8167, 8172, 8173,8167, 8173, 8174,8167, 8174, 8175,8167, 8175, 8168,
8176, 8177, 8178,8176, 8178, 8179,8176, 8179, 8180,8176, 8180, 8181,
8176, 8181, 8182,8176, 8182, 8183,8176, 8183, 8184,8176, 8184, 8177,
8185, 8186, 8187,8185, 8187, 8188,8185, 8188, 8189,8185, 8189, 8190,
8185, 8190, 8191,8185, 8191, 8192,8185, 8192, 8193,8185, 8193, 8186,
8194, 8195, 8196,8194, 8196, 8197,8194, 8197, 8198,8194, 8198, 8199,
8194, 8199, 8200,8194, 8200, 8201,8194, 8201, 8202,8194, 8202, 8195,
8203, 8204, 8205,8203, 8205, 8206,8203, 8206, 8207,8203, 8207, 8208,
8203, 8208, 8209,8203, 8209, 8210,8203, 8210, 8211,8203, 8211, 8204,
8212, 8213, 8214,8212, 8214, 8215,8212, 8215, 8216,8212, 8216, 8217,
8212, 8217, 8218,8212, 8218, 8219,8212, 8219, 8220,8212, 8220, 8213,
8221, 8222, 8223,8221, 8223, 8224,8221, 8224, 8225,8221, 8225, 8226,
8221, 8226, 8227,8221, 8227, 8228,8221, 8228, 8229,8221, 8229, 8222,
8230, 8231, 8232,8230, 8232, 8233,8230, 8233, 8234,8230, 8234, 8235,
8230, 8235, 8236,8230, 8236, 8237,8230, 8237, 8238,8230, 8238, 8231,
8239, 8240, 8241,8239, 8241, 8242,8239, 8242, 8243,8239, 8243, 8244,
8239, 8244, 8245,8239, 8245, 8246,8239, 8246, 8247,8239, 8247, 8240,
8248, 8249, 8250,8248, 8250, 8251,8248, 8251, 8252,8248, 8252, 8253,
8248, 8253, 8254,8248, 8254, 8255,8248, 8255, 8256,8248, 8256, 8249,
8257, 8258, 8259,8257, 8259, 8260,8257, 8260, 8261,8257, 8261, 8262,
8257, 8262, 8263,8257, 8263, 8264,8257, 8264, 8265,8257, 8265, 8258,
8266, 8267, 8268,8266, 8268, 8269,8266, 8269, 8270,8266, 8270, 8271,
8266, 8271, 8272,8266, 8272, 8273,8266, 8273, 8274,8266, 8274, 8267,
8275, 8276, 8277,8275, 8277, 8278,8275, 8278, 8279,8275, 8279, 8280,
8275, 8280, 8281,8275, 8281, 8282,8275, 8282, 8283,8275, 8283, 8276,
8284, 8285, 8286,8284, 8286, 8287,8284, 8287, 8288,8284, 8288, 8289,
8284, 8289, 8290,8284, 8290, 8291,8284, 8291, 8292,8284, 8292, 8285,
8293, 8294, 8295,8293, 8295, 8296,8293, 8296, 8297,8293, 8297, 8298,
8293, 8298, 8299,8293, 8299, 8300,8293, 8300, 8301,8293, 8301, 8294,
8302, 8303, 8304,8302, 8304, 8305,8302, 8305, 8306,8302, 8306, 8307,
8302, 8307, 8308,8302, 8308, 8309,8302, 8309, 8310,8302, 8310, 8303,
8311, 8312, 8313,8311, 8313, 8314,8311, 8314, 8315,8311, 8315, 8316,
8311, 8316, 8317,8311, 8317, 8318,8311, 8318, 8319,8311, 8319, 8312,
8320, 8321, 8322,8320, 8322, 8323,8320, 8323, 8324,8320, 8324, 8325,
8320, 8325, 8326,8320, 8326, 8327,8320, 8327, 8328,8320, 8328, 8321,
8329, 8330, 8331,8329, 8331, 8332,8329, 8332, 8333,8329, 8333, 8334,
8329, 8334, 8335,8329, 8335, 8336,8329, 8336, 8337,8329, 8337, 8330,
8338, 8339, 8340,8338, 8340, 8341,8338, 8341, 8342,8338, 8342, 8343,
8338, 8343, 8344,8338, 8344, 8345,8338, 8345, 8346,8338, 8346, 8339,
8347, 8348, 8349,8347, 8349, 8350,8347, 8350, 8351,8347, 8351, 8352,
8347, 8352, 8353,8347, 8353, 8354,8347, 8354, 8355,8347, 8355, 8348,
8356, 8357, 8358,8356, 8358, 8359,8356, 8359, 8360,8356, 8360, 8361,
8356, 8361, 8362,8356, 8362, 8363,8356, 8363, 8364,8356, 8364, 8357,
8365, 8366, 8367,8365, 8367, 8368,8365, 8368, 8369,8365, 8369, 8370,
8365, 8370, 8371,8365, 8371, 8372,8365, 8372, 8373,8365, 8373, 8366,
8374, 8375, 8376,8374, 8376, 8377,8374, 8377, 8378,8374, 8378, 8379,
8374, 8379, 8380,8374, 8380, 8381,8374, 8381, 8122,8374, 8122, 8375,
8382, 8383, 8384,8382, 8384, 8385,8382, 8385, 8386,8382, 8386, 8387,
8382, 8387, 8388,8382, 8388, 8389,8382, 8389, 8390,8382, 8390, 8383,
8391, 8392, 8393,8391, 8393, 8134,8391, 8134, 8126,8391, 8126, 8394,
8391, 8394, 8380,8391, 8380, 8389,8391, 8389, 8395,8391, 8395, 8392,
8396, 8397, 8133,8396, 8133, 8125,8396, 8125, 7987,8396, 7987, 8398,
8396, 8398, 8115,8396, 8115, 8381,8396, 8381, 8390,8396, 8390, 8397
};
