library ieee;
use ieee.std_logic_1164.all;


library ieee;
use ieee.numeric_std.all;

entity quant26bt_neg is
	port (
		clk : in  std_logic;
		ra0_data : out std_logic_vector(31 downto 0);
		ra0_addr : in  std_logic_vector(4 downto 0)
	);
end quant26bt_neg;
architecture augh of quant26bt_neg is

	-- Embedded RAM

	type ram_type is array (0 to 31) of std_logic_vector(31 downto 0);
	signal ram : ram_type := ("00000000000000000000000000111111", "00000000000000000000000000111110", "00000000000000000000000000011111", "00000000000000000000000000011110", "00000000000000000000000000011101", "00000000000000000000000000011100", "00000000000000000000000000011011", "00000000000000000000000000011010", "00000000000000000000000000011001", "00000000000000000000000000011000", "00000000000000000000000000010111", "00000000000000000000000000010110", "00000000000000000000000000010101", "00000000000000000000000000010100", "00000000000000000000000000010011", "00000000000000000000000000010010", "00000000000000000000000000010001", "00000000000000000000000000010000", "00000000000000000000000000001111", "00000000000000000000000000001110", "00000000000000000000000000001101", "00000000000000000000000000001100", "00000000000000000000000000001011", "00000000000000000000000000001010", "00000000000000000000000000001001", "00000000000000000000000000001000", "00000000000000000000000000000111", "00000000000000000000000000000110", "00000000000000000000000000000101", "00000000000000000000000000000100", "00000000000000000000000000000100", "00000000000000000000000000000000");


	-- Little utility functions to make VHDL syntactically correct
	--   with the syntax to_integer(unsigned(vector)) when 'vector' is a std_logic.
	--   This happens when accessing arrays with <= 2 cells, for example.

	function to_integer(B: std_logic) return integer is
		variable V: std_logic_vector(0 to 0);
	begin
		V(0) := B;
		return to_integer(unsigned(V));
	end;

	function to_integer(V: std_logic_vector) return integer is
	begin
		return to_integer(unsigned(V));
	end;

begin

	-- The component is a ROM.
	-- There is no Write side.

	-- The Read side (the outputs)

	ra0_data <= ram( to_integer(ra0_addr) );

end architecture;
