/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef TeeBuffer_H
#define TeeBuffer_H

#include <iostream>
#include <streambuf>

using namespace std;

class TeeBuffer : public streambuf 
{
public:
	TeeBuffer(ostream&,ostream&);
	~TeeBuffer();

protected:
	int   overflow(int);
	int   sync();

private:
	// No copy allowed
	TeeBuffer(const TeeBuffer&);
	TeeBuffer& operator=(const TeeBuffer&);

	char buffer_[1024];
	ostream& one_;
	ostream& two_;

	void dumpBuffer(void);
};

inline void destroy(TeeBuffer**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(TeeBuffer);
//#endif

#endif
