/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MESSAGECONTROLPANEL_H
#define MESSAGECONTROLPANEL_H

#include <QWidget>

class QHBoxLayout;
class QLabel;
class QToolButton;
class MvQArrowSpinWidget;

class MessageControlPanel : public QWidget
{
   Q_OBJECT

public:
    MessageControlPanel(bool hasSubset,bool hasFilter,QWidget* parent=0);
    void setMessageValue(int num,bool b);
    void resetMessageNum(int num,bool b);
    void resetSubsetNum(int num,bool b);
    void setSubsetLabel(QString txt);
    void showSubsetControl(bool b);
    int messageValue() const;
    int subsetValue() const;
    void setFilterInfo(bool filtered,int oriNum,int num);
    void addOptionsAction(QAction*);
    void addButtonAction(QAction*);

signals:
    void messageChanged(int);
    void subsetChanged(int);

protected:
    void paintEvent(QPaintEvent *);

private:
    QHBoxLayout* layout_;
    MvQArrowSpinWidget *messageSpin_;
    QLabel *messageLabel_;
    MvQArrowSpinWidget *subsetSpin_;
    QLabel *subsetLabel_;
    QLabel *subsetTitleLabel_;
    QLabel* totalLabel_;
    QToolButton* optionsTb_;
    QList<QAction*> optionsActions_;
    QList<QAction*> buttonActions_;
};

#endif // MESSAGECONTROLPANEL_H
