FORCE=0

if test $# -ge 1 && test "$1" = "--force" ; then
  FORCE=1
  shift
fi

if test $# -lt 4 ; then
  echo "Options:"
  echo "  --force	Check again even if the arguments did not change"
  echo "Need 4 command line arguments:"
  echo "  - header checks output file"
  echo "  - kernel build path"
  echo "  - kernel headers path"
  echo "  - kernel release"
  exit -1
fi

CHECKS_NAME="$1"
LINUX_BUILD="$2"
LINUX_HDR="$3"
LINUX_RELEASE="$4"

CONFIG_LINE="Ran with BUILD=\"$LINUX_BUILD\" HDR=\"$LINUX_HDR\" RELEASE=\"$LINUX_RELEASE\""
if test "$FORCE" != 1 && grep "$CONFIG_LINE" "$CHECKS_NAME" >/dev/null 2>&1; then
  # no need to rerun
  exit 0
fi

# create the output file
CHECKS_DATE_PREFIX="This file has been first generated on "
TMP_CHECKS_NAME=${CHECKS_NAME}.tmp
rm -f ${TMP_CHECKS_NAME}

# add the header
echo "#ifndef __knem_checks_h__" >> ${TMP_CHECKS_NAME}
echo "#define __knem_checks_h__ 1" >> ${TMP_CHECKS_NAME}
echo "" >> ${TMP_CHECKS_NAME}

# what command line was used to generate with file
echo "/*" >> ${TMP_CHECKS_NAME}
echo " * ${CHECKS_DATE_PREFIX}"`date` >> ${TMP_CHECKS_NAME}
echo " * ${CONFIG_LINE}" >> ${TMP_CHECKS_NAME}
echo " * It checked kernel headers in ${LINUX_HDR}/include/" >> ${TMP_CHECKS_NAME}
echo " */" >> ${TMP_CHECKS_NAME}
echo "" >> ${TMP_CHECKS_NAME}

# remap_vmalloc_range and vmalloc_user appeared in 2.6.18
echo -n "  checking (in kernel headers) remap_vmalloc_range availability ... "
if grep "remap_vmalloc_range *(" ${LINUX_HDR}/include/linux/vmalloc.h > /dev/null ; then
  echo "#define KNEM_HAVE_REMAP_VMALLOC_RANGE 1" >> ${TMP_CHECKS_NAME}
  echo yes
else
  echo no
fi

# cpumask_scnprintf uses a cpumask pointer starting in 2.6.29
echo -n "  checking (in kernel headers) whether cpumask_scnprintf takes a cpumask pointer ... "
if sed -ne '/static inline int cpumask_scnprintf(/,/)/p' ${LINUX_HDR}/include/linux/cpumask.h | grep "const struct cpumask *" > /dev/null ; then
  echo "#define KNEM_CPUMASK_SCNPRINTF_USES_PTR 1" >> ${TMP_CHECKS_NAME}
  echo yes
else
  echo no
fi

# dmaengine API reworked in 2.6.29
echo -n "  checking (in kernel headers) the dmaengine interface ... "
if test -e ${LINUX_HDR}/include/linux/dmaengine.h > /dev/null ; then
  if grep dmaengine_get ${LINUX_HDR}/include/linux/dmaengine.h > /dev/null ; then
    echo "#define KNEM_HAVE_DMA_ENGINE_API 1" >> ${TMP_CHECKS_NAME}
    echo yes
  else
    echo "#define KNEM_HAVE_OLD_DMA_ENGINE_API 1" >> ${TMP_CHECKS_NAME}
    echo "yes, the old one"
  fi
else
  echo no
fi

# add the footer
echo "" >> ${TMP_CHECKS_NAME}
echo "#endif /* __knem_checks_h__ */" >> ${TMP_CHECKS_NAME}

# install final file
if diff -q ${CHECKS_NAME} ${TMP_CHECKS_NAME} --ignore-matching-lines="${CHECKS_DATE_PREFIX}" >/dev/null 2>&1; then
  echo "  driver/linux/${CHECKS_NAME} is unchanged"
  rm -f ${TMP_CHECKS_NAME}
else
  echo "  creating driver/linux/${CHECKS_NAME}"
  mv -f ${TMP_CHECKS_NAME} ${CHECKS_NAME}
fi
