% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image-interact-opts.R
\name{brushOpts}
\alias{brushOpts}
\title{Create an object representing brushing options}
\usage{
brushOpts(id = NULL, fill = "#9cf", stroke = "#036",
  opacity = 0.25, delay = 300, delayType = c("debounce", "throttle"),
  clip = TRUE, direction = c("xy", "x", "y"), resetOnNew = FALSE)
}
\arguments{
\item{id}{Input value name. For example, if the value is \code{"plot_brush"},
then the coordinates will be available as \code{input$plot_brush}. Multiple
\code{imageOutput}/\code{plotOutput} calls may share the same \code{id}
value; brushing one image or plot will cause any other brushes with the
same \code{id} to disappear.}

\item{fill}{Fill color of the brush.}

\item{stroke}{Outline color of the brush.}

\item{opacity}{Opacity of the brush}

\item{delay}{How long to delay (in milliseconds) when debouncing or
throttling, before sending the brush data to the server.}

\item{delayType}{The type of algorithm for limiting the number of brush
events. Use \code{"throttle"} to limit the number of brush events to one
every \code{delay} milliseconds. Use \code{"debounce"} to suspend events
while the cursor is moving, and wait until the cursor has been at rest for
\code{delay} milliseconds before sending an event.}

\item{clip}{Should the brush area be clipped to the plotting area? If FALSE,
then the user will be able to brush outside the plotting area, as long as
it is still inside the image.}

\item{direction}{The direction for brushing. If \code{"xy"}, the brush can be
drawn and moved in both x and y directions. If \code{"x"}, or \code{"y"},
the brush wil work horizontally or vertically.}

\item{resetOnNew}{When a new image is sent to the browser (via
\code{\link{renderImage}}), should the brush be reset? The default,
\code{FALSE}, is useful if you want to update the plot while keeping the
brush. Using \code{TRUE} is useful if you want to clear the brush whenever
the plot is updated.}
}
\description{
This generates an object representing brushing options, to be passed as the
\code{brush} argument of \code{\link{imageOutput}} or
\code{\link{plotOutput}}.
}
