/*
* Copyright (C) 2019 ~ 2019 Deepin Technology Co., Ltd.
*
* Author: zhanglei <zhanglei_hlj@nfschina.com>
*
* Maintainer: zhanglei <zhanglei_hlj@nfschina.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/


#include "mainwindow.h"
#include "log.h"

#include <DApplication>
#include <DMainWindow>
#include <DWidgetUtil>
#include <DApplicationSettings>
#include <QTranslator>
#include <QObject>
#include <QStandardPaths>

DWIDGET_USE_NAMESPACE

int main(int argc, char *argv[])
{
    DApplication::loadDXcbPlugin();
    QGuiApplication::setAttribute(Qt::AA_UseHighDpiPixmaps);
    DApplication a(argc, argv);
    a.loadTranslator();
    a.setOrganizationName("uos");
    a.setApplicationName("uos-downloadmanager");
    a.setApplicationVersion("1.0.26");
    a.setProductIcon(QIcon::fromTheme("ndm_preferencesystem"));
    auto uos_download_manager_name = QObject::tr("Uos Download Manager");
    a.setProductName(uos_download_manager_name);

    auto uos_download_manager_info = QObject::tr("This is a download manage application.");
    a.setApplicationDescription(uos_download_manager_info);

    a.setApplicationDisplayName(QCoreApplication::translate("Main", "Uos Download Management Application"));

    if (!a.setSingleInstance("uos-downloadmanager"))
        return 0;



    // 保存程序的窗口主题设置
    DApplicationSettings as;
    Q_UNUSED(as)
    QDir dirCheck;
    QString Log_path = QString("%1/%2/%3/Log/")
        .arg(QStandardPaths::writableLocation(QStandardPaths::ConfigLocation))
        .arg(qApp->organizationName())
        .arg(qApp->applicationName());
    setLogDir(Log_path);
    if (!dirCheck.exists(Log_path))
    {
        dirCheck.mkpath(Log_path);
    }
    //检查日志是否过期
    CheckLogTime();
    //磁盘剩余空间小于阈值，清除早期日志
    CheckFreeDisk();
    //创建新日志
    CreateNewLog();
    qInstallMessageHandler(customLogMessageHandler);
    MainWindow w;
    w.show();


    Dtk::Widget::moveToCenter(&w);
    return a.exec();


}
