/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.geom;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import org.j3d.geom.GeometryData;
import org.j3d.geom.TorusGenerator;

public class Torus
extends Shape3D {
    private static final float DEFAULT_ORADIUS = 1.0f;
    private static final float DEFAULT_IRADIUS = 0.25f;
    private static final int DEFAULT_OFACETS = 16;
    private static final int DEFAULT_IFACETS = 16;
    private TorusGenerator generator;
    private GeometryData data = new GeometryData();

    public Torus() {
        this(1.0f, 0.25f, 16, 16, null);
    }

    public Torus(Appearance appearance) {
        this(0.25f, 1.0f, 16, 16, appearance);
    }

    public Torus(int n, int n2) {
        this(0.25f, 1.0f, n, n2, null);
    }

    public Torus(float f, float f2) {
        this(f, f2, 16, 16, null);
    }

    public Torus(int n, int n2, Appearance appearance) {
        this(1.0f, 0.25f, n, n2, appearance);
    }

    public Torus(float f, float f2, Appearance appearance) {
        this(f, f2, 16, 16, appearance);
    }

    public Torus(float f, float f2, int n, int n2, Appearance appearance) {
        this.data.geometryType = 3;
        this.data.geometryComponents = 2;
        this.generator = new TorusGenerator(f, f2, n, n2);
        this.generator.generate(this.data);
        int n3 = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n3, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setCapability(13);
        if (appearance != null) {
            this.setAppearance(appearance);
        }
        this.setGeometry((Geometry)triangleStripArray);
    }

    public void setDimensions(float f, float f2) {
        if (!this.getCapability(13)) {
            return;
        }
        this.generator.setDimensions(f, f2);
        this.generator.generate(this.data);
        int n = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setGeometry((Geometry)triangleStripArray);
    }

    public void setFacetCount(int n, int n2) {
        if (!this.getCapability(13)) {
            return;
        }
        this.generator.setFacetCount(n, n2);
        this.generator.generate(this.data);
        int n3 = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n3, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setGeometry((Geometry)triangleStripArray);
    }
}

