/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: ximages.h                                                     *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : ximages.c header file                                    *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id$
 */

/*
   Copyright (C) 1997-2018 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef __XIMAGES_H__
#define __XIMAGES_H__

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

void XMdcRemovePreviousImages(void);
void XMdcImagesSetCursor(GtkWidget *widget, gpointer data);
gboolean XMdcImagesCallbackExpose(GtkWidget *widget, GdkEventExpose *event, Uint32 *nr);
gboolean XMdcImagesCallbackClicked(GtkWidget *widget, GdkEventButton *button, Uint32 *imagenr);
void XMdcBuildCurrentImages(void);
void XMdcDisplayImages(void);
void XMdcImagesView(GtkWidget *widget, gpointer data);

#endif

