/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "widget.h"
#include "ui_widget.h"
#include <QDebug>
#include <uaceExtDll/uaceExtDll.h>

#include <X11/Xlib.h>

#include <QLibrary>

Widget::Widget(QWidget *parent)
    : QWidget(parent)
    , ui(new Ui::Widget)
{
    // InitDtkWmDisplay();
    ui->setupUi(this);
    ui->lineEdit->setPlaceholderText("请输入十进制的窗口id");
    ui->lineEdit_2->setPlaceholderText("请输入十进制的窗口id");
    ui->lineEdit_3->setPlaceholderText("请输入十进制的窗口id");
    ui->lineEdit_4->setPlaceholderText("请输入十进制的窗口id");
    ui->lineEdit_5->setPlaceholderText("请输入十进制的窗口id");
    ui->lineEdit_6->setPlaceholderText("请输入十进制的窗口id");
    ui->lineEdit_16->setPlaceholderText("请输入十进制的窗口id");

    m_Display = XOpenDisplay(NULL);
    m_uaceExtDll = new QLibrary("uaceExtDll");
    if (m_uaceExtDll) {
        if (!m_uaceExtDll->load()) {
            qWarning() << "Can not load uaceExtDll";
            delete m_uaceExtDll;
            m_uaceExtDll = nullptr;
        } else {
            fuc_GetWindowPid = (GetWindowPidPtr)m_uaceExtDll->resolve("GetWindowPID");
            if (!fuc_GetWindowPid) {
                qWarning() << "Can not resolve GetWindowPID";
                m_uaceExtDll->unload();
                delete m_uaceExtDll;
                m_uaceExtDll = nullptr;
            }
        }
    }

    connect(&m_timer, &QTimer::timeout, this, &Widget::timerSlot);
    connect(&m_timer1, &QTimer::timeout, this, &Widget::timerSlot1);
    connect(ui->pushButton, &QPushButton::clicked, this, &Widget::onGetCompositorSwitchStatus);
    connect(ui->pushButton_2, &QPushButton::clicked, this, &Widget::onToggleMultitaskView);
    connect(ui->pushButton_3, &QPushButton::clicked, this, &Widget::onMinimizeWindow);
    connect(ui->pushButton_4, &QPushButton::clicked, this, &Widget::onMaximizeWindow);
    connect(ui->pushButton_5, &QPushButton::clicked, this, &Widget::onGetWindowText);
    connect(ui->pushButton_6, &QPushButton::clicked, this, &Widget::onGetWindowSize);
    connect(ui->pushButton_7, &QPushButton::clicked, this, &Widget::onGetWindowPosition);
    connect(ui->pushButton_8, &QPushButton::clicked, this, &Widget::onGetActiveWindowID);
    connect(ui->pushButton_9, &QPushButton::clicked, this, &Widget::onGetDesktopWindowID);
    connect(ui->pushButton_10, &QPushButton::clicked, this, &Widget::onGetChildWindowIDs);
    connect(ui->pushButton_11, &QPushButton::clicked, this, &Widget::onGetPointerPosition);
    connect(ui->pushButton_18, &QPushButton::clicked, this, &Widget::onGetWindowPid);
}

Widget::~Widget()
{
    if (m_Display) {
        XCloseDisplay(m_Display);
        m_Display = nullptr;
    }
    if (m_uaceExtDll) {
        m_uaceExtDll->unload();
        delete m_uaceExtDll;
        m_uaceExtDll = nullptr;
    }

    // DestoryDtkWmDisplay();
    delete ui;
}

void Widget::timerSlot() {}

void Widget::timerSlot1() {}

void Widget::onGetCompositorSwitchStatus() {}

void Widget::onToggleMultitaskView() {}

void Widget::onMinimizeWindow() {}

void Widget::onMaximizeWindow() {}

void Widget::onGetWindowText() {}

void Widget::onGetWindowSize() {}

void Widget::onGetWindowPosition() {}

void Widget::onGetActiveWindowID() {}

void Widget::onGetDesktopWindowID() {}

void Widget::onGetChildWindowIDs() {}

void Widget::onGetPointerPosition() {}

void Widget::onGetWindowPid()
{
    ulong id = ui->lineEdit_16->text().toULong();
    int pid = -1;
    Display *display = XOpenDisplay(NULL);
/*
    GetWindowPidPtr fucGetWindowPid = nullptr;
    QLibrary *uaceExtDll = new QLibrary("uaceExtDll");
    if (uaceExtDll) {
        if (!uaceExtDll->load()) {
            qWarning() << "Can not load uaceExtDll";
            delete uaceExtDll;
            uaceExtDll = nullptr;
        } else {
            fucGetWindowPid = (GetWindowPidPtr)uaceExtDll->resolve("GetWindowPID");
            if (!fucGetWindowPid) {
                qWarning() << "Can not resolve GetWindowPID";
                uaceExtDll->unload();
                delete uaceExtDll;
                uaceExtDll = nullptr;
            }
        }
    }

    qWarning() << __func__ << __LINE__ << "ut-gfx:wid=" << id;
    if (!display || !fucGetWindowPid) {
        qWarning() << "Can not open display";
        return;
    }

    qWarning() << __func__ << __LINE__ << "ut-gfx:wid=" << id;

    pid = fucGetWindowPid(display, id);
    qWarning() << __func__ << __LINE__ << "ut-gfx:wid=" << id << " pid " << pid;
    if (display) {
        XCloseDisplay(display);
        display = nullptr;
    }
    if (uaceExtDll) {
        uaceExtDll->unload();
        delete uaceExtDll;
        uaceExtDll = nullptr;
    }
    */
    if (pid <= 0) {
        pid = GetWindowPID(display, id);
    }

    qWarning() << __func__ << __LINE__ << "ut-gfx:wid=" << id << " pid " << pid;
    qInfo() << pid;
    QStringList list;
    ui->label_116->setText(QString("pid：%1").arg(pid));
}
