// SPDX-FileCopyrightText: 2011 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include "x11clipboard.h"
#include "clipboarddataprocess.h"
#include "systemclipboard.h"
#include "datamanage/clipdata.h"
#include "datamanage/clipdatarecord.h"
#include "datamanage/clipdataproperty.h"
#include "imageprocess.h"
#include "xwl/xwldatabridge.h"

X11Clipboard::X11Clipboard(SystemClipboard *clipboard)
{
    m_systemclipboard = clipboard;
    initXwl();
}

X11Clipboard::~X11Clipboard()
{
    if (m_XwlDataBrige) {
        // static_cast<XwlDataBridge*>(clip->xwl)->stop();
        delete m_XwlDataBrige;
        m_XwlDataBrige = nullptr;
    }
}

void X11Clipboard::initConnect()
{

}

void *x11_loop(void *arg)
{
    XwlDataBridge *t_data = (XwlDataBridge *)arg;
    t_data->eventLoop();
    return NULL;
}

void X11Clipboard::initXwl()
{
    m_XwlDataBrige = new XwlDataBridge(true);
    pthread_create(&m_xwldispatch, NULL, x11_loop, m_XwlDataBrige);
}

void X11Clipboard::setDataToClipboard(ClipData *vClip)
{
    ClipDataProperty *vClipProperty = vClip->getProperty();
    int vDataCount = vClip->getRecordCount();
    if (vDataCount < 1 || !vClipProperty)
        return;

    if (m_XwlDataBrige) {
        m_XwlDataBrige->setClipData(vClip);
    }

}

void X11Clipboard::clearClipboard()
{
    if (m_XwlDataBrige) {
        m_XwlDataBrige->setClipData(NULL);
    }
}
