/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef WMJACK_WAYLAND_CLIENT_MANAGEMENT_H
#define WMJACK_WAYLAND_CLIENT_MANAGEMENT_H

#ifdef __cplusplus
extern "C" {
#endif

#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <stdint.h>

#include "dtk_utils.h"
#include "dtk_wmjack.h"

typedef struct Dtk_Wayland_Client_Backend
{
    struct wl_display *display;
    pthread_mutex_t cond_lock;
    pthread_t dispatch;
    bool lock;

    void *client_management;
} WaylandClientBackend;

typedef struct Dtk_Wayland_Client_Backend *WaylandClientBackendPtr;

typedef struct dtk_client_management
{
    struct com_deepin_client_management *clientManagement;

    struct dtk_array *clients;
    uint32_t window_from_point;
    pthread_cond_t window_from_point_done;
    struct dtk_array *all_window_id;
    pthread_cond_t all_window_id_done;
    WindowState window_state;
    pthread_cond_t specific_window_state_done;
} ClientManagement;

struct dtk_array *get_client_all_window_states();

WindowState *get_client_window_state(int32_t windowId);

int32_t get_client_window_pid(int32_t windowId);

char* get_client_window_title(int32_t windowId);

Size get_client_window_size(int32_t windowId);

Position get_client_window_position(int32_t windowId);

uint32_t get_window_from_point();

void show_split_menu(int x, int y, int width, int height, uint32_t wid);

void hide_split_menu(bool delay);

WindowState get_specific_window_state(uint32_t wid);

int get_all_window_states_list(WindowState **states);

int init_wayland_client();

void destory_wayland_client();

#ifdef __cplusplus
}
#endif

#endif
