#pragma once

#include "interface/ModuleInterface.h"
#include "BackupWidget.h"
#include "SystemBackupWidget.h"
#include "SysBackupWidgetV20.h"
#include "UserDataBackupSelectWidget.h"
#include "UserDataBackupWidget.h"
#include "DataBackupWidget.h"
#include "common/ProgressWidget.h"
#include "common/ResultWidget.h"
#include "common/AuthorityUtils.h"
#include <QObject>
#include <QTimer>
#include <QJsonObject>

class FrameProxyInterface;
class QString;

class BackupModule : public QObject, public ModuleInterface
{
    Q_OBJECT
public:
    explicit BackupModule(FrameProxyInterface *frame, ComDeepinDaemonUosrecoveryInterface *interface,
                          QObject *parent = nullptr);
    ~BackupModule() override;

    void initialize() override;

    QString name() const override;

    QString icons() const override;

    QString text() const override;

    void active() override;

    void updateDestPartition(const QJsonObject &jsonObject);
    void setSystemSyncType(int type);
    void setUserDataSyncType(int type);
    void setSystemBackupSpaceTips(const QString &tips);
    void setSelinuxEnable(bool enable);
    void setLVM(bool isLVM);
    void setEncrypted(bool isEncrypted);
    void setDevice(bool isDevice);
    void setSupportV20BackupRestore(bool isSupport);
    void setFileMgrEncrypted(bool encrypt);
    void setMajorVersion(int version);
    void setMinorVersion(int version);

public Q_SLOTS:
    void onShowProgress(const QString &mainTitle, const QString &subTitle, const QString &warning);
    void updateProgress(const QString &progress);
    void onShowResult(bool success, int operateType, const QString &errorMsg = "");
    void onSystemBackup();
    void onStartSystemBackup(const QString &remark);
    void onDataBackup();
    void onStartDataBackup(const QString &remark);
    void onBack();
    void onBackHome();
    void onError(const QString &errMsg);
    void onSpaceChanged(const QString &space);
    void onCheckSpace();
    void onDataBackupCheckSpace(const QString &msg);
    void onReportCheckSpace(const QString &space);
    void onSuccess(const QString &msg);
    void onManualBackupV20(const QString &path);
    void onSystemBackupV20(const QString &path);
    void onCancelBackupV20();
    void onRequestRebootV20();
    void doAdminAuthorityTask(bool result, int type);
    void doCommonAuthorityTask(bool result, int type);

#ifdef UI_TEST
    void onTimeout();
#endif

private:
    QStringList getUsrDataSpecialExcludes();
    void showUserDataBackupWidget(const QString &comboBoxText);
    void systemBackup(int operateType, int errorCode);
    void showSysBackupWidgetV20();
    void doDataBackup();
    void checkAdminAuthority(AuthorityType type);
    void checkCommonAuthority(AuthorityType type);

private:
    BackupWidget *m_backupWidget = nullptr;
    ProgressWidget *m_progressWidget = nullptr;
    SystemBackupWidget *m_systemBackupWidget = nullptr;
    UserDataBackupSelectWidget *m_userDataBackupSelectWidget = nullptr;
    UserDataBackupWidget *m_userDataBackupWidget = nullptr;
    SysBackupWidgetV20 *m_sysBackWidgetV20 = nullptr;
    DataBackupWidget *m_dataBackupWidget = nullptr;
    ResultWidget *m_resultWidget = nullptr;
    AuthorityUtils *m_adminAuthUtils = nullptr;
    AuthorityUtils *m_commonAuthUtils = nullptr;
    QList<FileItem> m_fileItems;
    QList<FileItem> m_excludeFileItems;
    QStringList m_excludes;
    QString m_destUUID;
    QString m_curSysBackupReq = "";
    QString m_curSysOpID = "";
    QString m_curUserOpID = "";
    QString m_backupPath;
    SystemBackupRequest m_curSystemBackupRequest;
    int m_systemSyncType = -1;
    int m_userDataSyncType = -1;
    bool m_isSelinuxEnabled = false;
    bool m_isLVMOnly = false;
    bool m_isEncrypted = false;
    bool m_isDevice = false;
    bool m_isSupportV20BackupRestore = false;
    bool m_isFileMgrEncrypted = false;
    int m_osMajorVer = -1;
    int m_osMinorVer = -1;

#ifdef UI_TEST
    QTimer *m_timer = nullptr;
    int m_progress = 0;
#endif
};