//
// Created by uos on 2022/3/17.
//

#ifndef UOS_RECOVERY_PROGRESSWIDGET_H
#define UOS_RECOVERY_PROGRESSWIDGET_H

#include <DWidget>
#include <DWaterProgress>
#include <DLabel>
#include <DProgressBar>
#include <QVBoxLayout>
#include <DTipLabel>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class ProgressWidget : public DWidget
{
    Q_OBJECT
public:
    explicit ProgressWidget(const QString &mainTitle, const QString &subTitle,
                            const QString &warning, DWidget *parent = nullptr);
    void start();
    void stop(bool success);
    void setValue(int value);
    void setMainTitle(const QString &mainTitle);
    void setSubTitle(const QString &subTitle);
    void setWarning(const QString &warning);
    void setRemainTime(int remainTime);
private:
    DWaterProgress *m_waterProgress = nullptr;
    DLabel *m_mainTitle = nullptr;
    DLabel *m_subTitle = nullptr;
    DLabel *m_warning = nullptr;
    DLabel *m_remainTime = nullptr;
};

class ProgressWidgetV2 : public DWidget
{
Q_OBJECT
public:
    explicit ProgressWidgetV2(const QString &mainTitle, const QString &subTitle,
                            const QString &warning, DWidget *parent = nullptr);
    void setValue(int value);
    void setMainTitle(const QString &mainTitle);
    void setSubTitle(const QString &subTitle);
    void setWarning(const QString &warning);
    void setRemainTime(int remainTime);
    void setIconPixmap(const QPixmap &iconPix);
    void initLayout();
private:
    DLabel *m_icon = nullptr;
    DProgressBar *m_progressBar = nullptr;
    DLabel *m_mainTitle = nullptr;
    DLabel *m_progress = nullptr;
    DTipLabel *m_subTitle = nullptr;
    DLabel *m_warning = nullptr;
    DTipLabel *m_remainTime = nullptr;
    QVBoxLayout *m_mainVLayout = nullptr;
};

#endif //UOS_RECOVERY_PROGRESSWIDGET_H
