//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2025/4/25.
//
#include "ImmuBackupFrame.h"
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <DFontSizeManager>
#include <QDebug>
#include <QBitmap>
#include "utils/Utils.h"

ImmuBackupLeftFrame::ImmuBackupLeftFrame(const QString &title, const QString &description, const QString &icon, QWidget *parent) :
        ItemFrame(title, description, icon, parent)
{
}

// void ImmuBackupLeftFrame::paintEvent(QPaintEvent *event)
// {
//     QBitmap mask(this->size());
//     mask.fill(Qt::color0);
//     QPainter painter(&mask);
//     painter.setBrush(Qt::color1);
//     painter.setRenderHint(QPainter::Antialiasing);
//     painter.drawRoundedRect(rect(), 16, 16);
//     this->setMask(mask);

//     DFrame::paintEvent(event);
// }

bool ImmuBackupLeftFrame::event(QEvent *e)
{
    if (e->type() == QEvent::HoverEnter) {
        setSelectedBackground("hover");

        QString m_desText = m_description->text();
        QFontMetrics fontWidth(m_description->font());
        QString elideNote = fontWidth.elidedText(m_desText, Qt::ElideRight, m_description->width(),
                                                 Qt::AlignLeft | Qt::AlignBottom | Qt::TextSingleLine);
        if (elideNote.indexOf("…") != -1) {
            m_description->setToolTip(m_desText);
        } else {
            m_description->setToolTip("");
        }
    } else if (e->type() == QEvent::HoverLeave) {
        if (this->isSelected()) {
            setSelectedBackground("selected");
        } else {
            setSelectedBackground("unselected");
        }
    } else if (e->type() == QEvent::MouseButtonRelease) {
        if (this->isEnabled()) {
            if (!m_bChecked) {
                m_checkIcon->setVisible(true);
                m_checkIcon->setPixmap(m_radioPixmap);
                m_bChecked = true;
            }
            Q_EMIT clicked(m_bChecked);
        }
    }
    return QFrame::event(e);
}

void ImmuBackupLeftFrame::setSelectedPixmap(const QString &iconRes, const QSize &iconSize)
{
    m_selectedPixmap = Utils::loadSvgImage(iconRes, iconSize.width(), iconSize.height());
}

void ImmuBackupLeftFrame::setSelectedHoverPixmap(const QString &iconRes, const QSize &iconSize)
{
    m_selectedHoverPixmap = Utils::loadSvgImage(iconRes, iconSize.width(), iconSize.height());
}

void ImmuBackupLeftFrame::setSelectedDarkPixmap(const QString &iconRes, const QSize &iconSize)
{
    m_selectedDarkPixmap = Utils::loadSvgImage(iconRes, iconSize.width(), iconSize.height());
}

void ImmuBackupLeftFrame::setSelectedDarkHoverPixmap(const QString &iconRes, const QSize &iconSize)
{
    m_selectedDarkHoverPixmap = Utils::loadSvgImage(iconRes, iconSize.width(), iconSize.height());
}

void ImmuBackupLeftFrame::setSelectedBackground(const QString &selectStat)
{
    if (nullptr != m_backgroundWidget) {
        if (DGuiApplicationHelper::instance()->themeType() == DGuiApplicationHelper::LightType) {
            if (selectStat == "selected") {
                m_backgroundWidget->setBackgroundPixmap(&m_selectedPixmap);
            } else if (selectStat == "hover") {
                m_backgroundWidget->setBackgroundPixmap(&m_selectedHoverPixmap);
            } else {
                m_backgroundWidget->setBackgroundPixmap(nullptr);
            }
        } else {
            if (selectStat == "selected") {
                m_backgroundWidget->setBackgroundPixmap(&m_selectedDarkPixmap);
            } else if (selectStat == "hover") {
                m_backgroundWidget->setBackgroundPixmap(&m_selectedDarkHoverPixmap);
            } else {
                m_backgroundWidget->setBackgroundPixmap(nullptr);
            }
        }
    }
}

void ImmuBackupLeftFrame::initHorizontalLayout()
{
    m_backgroundWidget = new BackgroundWidget;
    QVBoxLayout *backgroundLayout = new QVBoxLayout(this);
    backgroundLayout->setContentsMargins(0, 0, 0, 0);
    backgroundLayout->setSpacing(0);
    backgroundLayout->addWidget(m_backgroundWidget);

    QVBoxLayout *centralLayout = new QVBoxLayout(m_backgroundWidget);
    auto hBoxLayout = new QHBoxLayout;
    hBoxLayout->addStretch();
    hBoxLayout->setContentsMargins(0,0,0,0);
    hBoxLayout->addWidget(m_checkIcon);

    centralLayout->addLayout(hBoxLayout);
    centralLayout->addSpacing(-25);
    centralLayout->addWidget(m_icon, 0, Qt::AlignHCenter);

    QVBoxLayout *vLayout = new QVBoxLayout();
    m_title->setAlignment(Qt::AlignTop | Qt::AlignHCenter);
    m_title->setWordWrap(true);

    QFont font = m_title->font();
    font.setWeight(QFont::DemiBold);
    font.setPixelSize(18);
    m_title->setFont(font);
    DFontSizeManager::instance()->bind(m_title, DFontSizeManager::T5);

    vLayout->addWidget(m_title);
    vLayout->addSpacing(-32);

    centralLayout->addLayout(vLayout);
    centralLayout->setSpacing(0);
}

ImmuBackupFrame::ImmuBackupFrame(const QString &title, const QString &description, const QString &icon, QWidget *parent) :
        ItemFrame(title, description, icon, parent)
{
    m_description->setToolTip(description);
}

// void ImmuBackupFrame::paintEvent(QPaintEvent *event)
// {
//     QBitmap mask(this->size());
//     mask.fill(Qt::color0);
//     QPainter painter(&mask);
//     painter.setBrush(Qt::color1);
//     painter.setRenderHint(QPainter::Antialiasing);
//     painter.drawRoundedRect(rect(), 16, 16);
//     this->setMask(mask);

//     DFrame::paintEvent(event);
// }

bool ImmuBackupFrame::event(QEvent *e)
{
    if (e->type() == QEvent::HoverEnter) {
        setBackgroundRole(DPalette::ItemBackground);
        setLineWidth(1);

        QString m_desText = m_description->text();
        QFontMetrics fontWidth(m_description->font());
        QString elideNote = fontWidth.elidedText(m_desText, Qt::ElideRight, m_description->width(),
                                                 Qt::AlignLeft | Qt::AlignBottom | Qt::TextSingleLine);
        if (elideNote.indexOf("…") != -1) {
            m_description->setToolTip(m_desText);
        } else {
            m_description->setToolTip("");
        }
    } else if (e->type() == QEvent::HoverLeave) {
        if (m_bChecked) {
            setBackgroundRole(DPalette::ObviousBackground);
            setLineWidth(1);
        } else {
            setBackgroundRole(DPalette::NoType);
            setLineWidth(0);
        }
    } else if (e->type() == QEvent::MouseButtonRelease) {
        if (this->isEnabled()) {
            if (!m_bChecked) {
                m_checkIcon->setVisible(true);
                m_checkIcon->setPixmap(m_radioPixmap);
                m_bChecked = true;
                setBackgroundRole(DPalette::ObviousBackground);
                setLineWidth(1);
            }
            Q_EMIT clicked(m_bChecked);
        }
    }
    return QFrame::event(e);
}

void ImmuBackupFrame::initHorizontalLayout()
{
    QVBoxLayout *centralLayout = new QVBoxLayout(this);
    auto hBoxLayout = new QHBoxLayout;

    hBoxLayout->addStretch();
    hBoxLayout->setContentsMargins(0,0,0,0);
    hBoxLayout->addWidget(m_checkIcon);

    centralLayout->addLayout(hBoxLayout);
    centralLayout->addSpacing(-10);
    centralLayout->addWidget(m_icon, 0, Qt::AlignHCenter);

    QVBoxLayout *vLayout = new QVBoxLayout();
    vLayout->setContentsMargins(0,0,0,0);
    m_title->setAlignment(Qt::AlignTop | Qt::AlignHCenter);
    m_title->setWordWrap(true);

    QFont font = m_title->font();
    font.setWeight(QFont::DemiBold);
    font.setPixelSize(18);
    m_title->setFont(font);
    DFontSizeManager::instance()->bind(m_title, DFontSizeManager::T5);

    vLayout->addWidget(m_title);
    if (!m_showDescription) {
        m_description->hide();
    }
    m_description->setAlignment(Qt::AlignHCenter);
    m_description->setWordWrap(true);
    //m_description->setElideMode(Qt::TextElideMode::ElideRight);
    QFont descriptionFont = m_description->font();
    descriptionFont.setWeight(QFont::Normal);
    descriptionFont.setPixelSize(12);
    m_description->setFont(descriptionFont);
    m_description->setFixedSize(200, 60);
    DFontSizeManager::instance()->bind(m_description, DFontSizeManager::T6);
    vLayout->addSpacing(3);
    vLayout->addWidget(m_description, 0, Qt::AlignmentFlag::AlignTop);
    centralLayout->addLayout(vLayout);
    centralLayout->setSpacing(0);
}
